/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.epsg31287;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.UploadAction;
import org.openstreetmap.josm.actions.upload.UploadHook;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.projection.Mercator;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.preferences.ProjectionPreference;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.epsg31287.EPSG31287UploadHook;
import org.openstreetmap.josm.plugins.epsg31287.ProjectionEPSG31287;
import org.openstreetmap.josm.tools.I18n;

public class Epsg31287
extends Plugin {
    private JMenu mMenu;
    private Projection oldProj;
    private final String projCode = ProjectionEPSG31287.getProjCode();

    public Epsg31287(PluginInformation info) {
        super(info);
        this.refreshMenu();
    }

    public void toggleProjection() {
        Bounds b = Main.map != null && Main.map.mapView != null ? Main.map.mapView.getRealBounds() : null;
        try {
            if (Main.proj.toCode().equals(this.projCode)) {
                ProjectionPreference.setProjection((String)this.oldProj.getClass().getName(), null);
            } else {
                this.oldProj = Main.proj;
                Main.proj = new ProjectionEPSG31287();
                UploadAction.registerUploadHook((UploadHook)new EPSG31287UploadHook(this));
            }
            this.refreshMenu();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Current projection is set to {0}", (Object[])new Object[]{Main.proj.toString()}) + (Main.proj.toCode().equals(this.projCode) ? I18n.tr((String)"\nPlease adjust WMS layer manually by using known exact objects/traces/... before starting to map") : ""), I18n.tr((String)"Info"), 1);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"The projection {0} could not be activated. Using Mercator", (Object[])new Object[]{this.projCode}), I18n.tr((String)"Error"), 0);
            Main.proj = new Mercator();
        }
        if (!(b == null || this.oldProj == null || Main.proj.getClass().getName().equals(this.oldProj.getClass().getName()) && Main.proj.hashCode() == this.oldProj.hashCode())) {
            Main.map.mapView.zoomTo(b);
        }
    }

    public void refreshMenu() {
        MainMenu menu = Main.main.menu;
        if (this.mMenu == null) {
            String string = I18n.marktr((String)"EPSG31287");
            menu.getClass();
            this.mMenu = menu.addMenu(string, 83, 5, null);
        } else {
            this.mMenu.removeAll();
        }
        if (Main.proj.toCode().equals(this.projCode)) {
            this.mMenu.add(new JMenuItem((Action)new JosmAction(I18n.tr((String)"set {0}", (Object[])new Object[]{this.oldProj.toString()}), "wmsmenu.png", I18n.tr((String)"set projection from {0} to {1}", (Object[])new Object[]{this.projCode, this.oldProj.toString()}), null, false){
                private static final long serialVersionUID = 7610502878925107647L;

                public void actionPerformed(ActionEvent ev) {
                    Epsg31287.this.toggleProjection();
                }
            }));
        } else {
            this.mMenu.add(new JMenuItem((Action)new JosmAction(I18n.tr((String)"set {0}", (Object[])new Object[]{this.projCode}), "wmsmenu_off.png", I18n.tr((String)"set projection from {0} to {1}", (Object[])new Object[]{Main.proj.toString(), this.projCode}), null, false){
                private static final long serialVersionUID = 7610502878925107646L;

                public void actionPerformed(ActionEvent ev) {
                    Epsg31287.this.toggleProjection();
                }
            }));
        }
    }
}

