/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation.gui;

import java.awt.Graphics2D;
import javax.swing.Action;
import javax.swing.Icon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.elevation.ElevationWayPointKind;
import org.openstreetmap.josm.plugins.elevation.IElevationProfile;
import org.openstreetmap.josm.plugins.elevation.WayPointHelper;
import org.openstreetmap.josm.plugins.elevation.gui.DefaultElevationProfileRenderer;
import org.openstreetmap.josm.plugins.elevation.gui.IElevationProfileRenderer;
import org.openstreetmap.josm.plugins.elevation.gui.IElevationProfileSelectionListener;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ElevationProfileLayer
extends Layer
implements IElevationProfileSelectionListener {
    private IElevationProfile profile;
    private IElevationProfileRenderer renderer = new DefaultElevationProfileRenderer();
    private WayPoint selWayPoint = null;

    public ElevationProfileLayer(String name) {
        super(name);
    }

    public IElevationProfile getProfile() {
        return this.profile;
    }

    public void setProfile(IElevationProfile profile) {
        this.profile = profile;
        Main.map.repaint();
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"layer", (String)"elevation_small");
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Action[] getMenuEntries() {
        return new Action[]{new LayerListPopup.InfoAction((Layer)this)};
    }

    public String getToolTipText() {
        if (this.profile != null) {
            return I18n.tr((String)("Elevation profile for track '" + this.profile.getName() + "'."));
        }
        return I18n.tr((String)"Elevation profile");
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    public void paint(Graphics2D g, MapView mv, Bounds box) {
        WayPoint lastWpt = null;
        int lastEle = 0;
        int index = 0;
        this.renderer.beginRendering();
        if (this.profile != null) {
            for (WayPoint wpt : this.profile.getWayPoints()) {
                int ele = (int)WayPointHelper.getElevation(wpt);
                if (wpt == null) {
                    throw new RuntimeException("WPT must not be null, profile " + this.profile);
                }
                if (lastWpt != null) {
                    int ele1 = (int)((double)ele / 100.0);
                    int ele2 = (int)((double)lastEle / 100.0);
                    if (ele1 != ele2 && Math.abs(ele1 - ele2) == 1) {
                        if (ele1 > ele2) {
                            this.renderer.renderWayPoint(g, this.profile, mv, wpt, ElevationWayPointKind.ElevationLevelGain);
                        } else {
                            this.renderer.renderWayPoint(g, this.profile, mv, wpt, ElevationWayPointKind.ElevationLevelLoss);
                        }
                    } else if (ele > lastEle) {
                        this.renderer.renderWayPoint(g, this.profile, mv, wpt, ElevationWayPointKind.ElevationGain);
                    } else {
                        this.renderer.renderWayPoint(g, this.profile, mv, wpt, ElevationWayPointKind.ElevationLoss);
                    }
                }
                lastEle = (int)WayPointHelper.getElevation(wpt);
                lastWpt = wpt;
                ++index;
            }
            if (this.selWayPoint != null) {
                this.renderer.renderWayPoint(g, this.profile, mv, this.selWayPoint, ElevationWayPointKind.Highlighted);
            }
            this.renderer.renderWayPoint(g, this.profile, mv, this.profile.getStartWayPoint(), ElevationWayPointKind.StartPoint);
            this.renderer.renderWayPoint(g, this.profile, mv, this.profile.getEndWayPoint(), ElevationWayPointKind.EndPoint);
            this.renderer.renderWayPoint(g, this.profile, mv, this.profile.getMaxWayPoint(), ElevationWayPointKind.MaxElevation);
            this.renderer.renderWayPoint(g, this.profile, mv, this.profile.getMinWayPoint(), ElevationWayPointKind.MinElevation);
        }
        this.renderer.finishRendering();
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    @Override
    public void selectedWayPointChanged(WayPoint newWayPoint) {
        if (this.selWayPoint != newWayPoint) {
            this.selWayPoint = newWayPoint;
            Main.map.repaint();
        }
    }
}

