/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation;

import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.elevation.ElevationMapMode;
import org.openstreetmap.josm.plugins.elevation.gui.ElevationProfileDialog;
import org.openstreetmap.josm.plugins.elevation.gui.ElevationProfileLayer;

public class ElevationProfilePlugin
extends Plugin {
    protected static ElevationProfileDialog eleProfileDlg;
    private ElevationMapMode eleMode;
    private IconToggleButton eleModeButton;
    private static ElevationProfileLayer currentLayer;

    public ElevationProfilePlugin(PluginInformation info) {
        super(info);
        try {
            eleProfileDlg = new ElevationProfileDialog();
            this.eleMode = new ElevationMapMode("Elevation profile", Main.map);
            this.eleModeButton = new IconToggleButton((Action)((Object)this.eleMode));
            this.eleModeButton.setVisible(true);
        }
        catch (Exception e1) {
            System.err.println("Init of ElevationProfilePlugin failed: " + e1);
            e1.printStackTrace();
        }
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        super.mapFrameInitialized(oldFrame, newFrame);
        if (newFrame != null) {
            newFrame.addToggleDialog((ToggleDialog)eleProfileDlg);
            eleProfileDlg.addModelListener(this.eleMode);
        }
        if (Main.map != null) {
            Main.map.toolGroup.add((AbstractButton)this.eleModeButton);
            Main.map.mapView.addPropertyChangeListener((PropertyChangeListener)eleProfileDlg);
            MapView.addLayerChangeListener((MapView.LayerChangeListener)eleProfileDlg);
            eleProfileDlg.setProfileLayer(ElevationProfilePlugin.getCurrentLayer());
        }
    }

    public static ElevationProfileLayer getCurrentLayer() {
        if (currentLayer == null) {
            currentLayer = new ElevationProfileLayer("Elevation profile");
            Main.main.addLayer((Layer)currentLayer);
        }
        return currentLayer;
    }
}

