/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.plugins.elevation.ElevationWayPointKind;
import org.openstreetmap.josm.plugins.elevation.IElevationProfile;
import org.openstreetmap.josm.plugins.elevation.WayPointHelper;
import org.openstreetmap.josm.plugins.elevation.gui.DefaultElevationProfileRenderer;
import org.openstreetmap.josm.plugins.elevation.gui.ElevationColors;
import org.openstreetmap.josm.plugins.elevation.gui.IElevationProfileRenderer;
import org.openstreetmap.josm.plugins.elevation.gui.IElevationProfileSelectionListener;
import org.openstreetmap.josm.plugins.elevation.gui.TextAlignment;
import org.openstreetmap.josm.tools.I18n;

public class ElevationProfilePanel
extends JPanel
implements ComponentListener,
MouseMotionListener {
    private static final long serialVersionUID = -7343429725259575319L;
    private IElevationProfile profile;
    private Rectangle plotArea;
    private IElevationProfileRenderer renderer = new DefaultElevationProfileRenderer();
    private int selectedIndex = -1;
    private List<IElevationProfileSelectionListener> selectionChangedListeners = new ArrayList<IElevationProfileSelectionListener>();
    private boolean isPainting;

    public ElevationProfilePanel(IElevationProfile profile) {
        this.profile = profile;
        this.setDoubleBuffered(true);
        this.setBackground(Color.WHITE);
        this.createOrUpdatePlotArea();
        this.addComponentListener(this);
        this.addMouseMotionListener(this);
    }

    public IElevationProfile getProfile() {
        return this.profile;
    }

    public void setElevationModel(IElevationProfile profile) {
        if (this.profile != profile) {
            this.profile = profile;
            this.invalidate();
        }
    }

    public Rectangle getPlotArea() {
        return this.plotArea;
    }

    public void setPlotArea(Rectangle plotArea) {
        this.plotArea = plotArea;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int selectedIndex) {
        this.selectedIndex = selectedIndex;
    }

    public WayPoint getSelectedWayPoint() {
        if (this.selectedIndex != -1 && this.profile != null && this.profile.getWayPoints() != null && this.profile.getWayPoints().size() > this.selectedIndex) {
            return this.profile.getWayPoints().get(this.selectedIndex);
        }
        return null;
    }

    public void addSelectionListener(IElevationProfileSelectionListener listener) {
        if (listener == null) {
            return;
        }
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionListener(IElevationProfileSelectionListener listener) {
        if (listener == null) {
            return;
        }
        this.selectionChangedListeners.remove(listener);
    }

    public void removeAllSelectionListeners() {
        this.selectionChangedListeners.clear();
    }

    protected void fireSelectionChanged(WayPoint selWayPoint) {
        for (IElevationProfileSelectionListener listener : this.selectionChangedListeners) {
            listener.selectedWayPointChanged(selWayPoint);
        }
    }

    @Override
    public void paint(Graphics g) {
        this.isPainting = true;
        Font oldFont = this.getFont();
        Font lFont = this.getFont().deriveFont(9.0f);
        this.setFont(lFont);
        try {
            super.paint(g);
            int y1 = this.getPlotBottom();
            g.setColor(Color.DARK_GRAY);
            g.drawLine(this.plotArea.x, this.plotArea.y, this.plotArea.x, this.plotArea.y + this.plotArea.height);
            g.drawLine(this.plotArea.x, this.plotArea.y + this.plotArea.height, this.plotArea.x + this.plotArea.width, this.plotArea.y + this.plotArea.height);
            if (this.profile != null && this.profile.hasElevationData()) {
                this.drawAlignedString(this.formatDate(this.profile.getStart()), 5, y1 + 5, TextAlignment.Left, g);
                this.drawAlignedString(this.formatDate(this.profile.getEnd()), this.getPlotRight(), y1 + 5, TextAlignment.Right, g);
                this.drawProfile(g);
                this.drawElevationLines(g);
            } else {
                this.drawAlignedString(I18n.tr((String)"(No elevation data)"), this.getPlotHCenter(), this.getPlotVCenter(), TextAlignment.Centered, g);
            }
        }
        finally {
            this.setFont(oldFont);
            this.isPainting = false;
        }
    }

    private Rectangle drawAlignedString(String s, int x, int y, TextAlignment align, Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        int w = fm.stringWidth(s);
        int h = fm.getHeight();
        int xoff = w / 2;
        int yoff = h / 2;
        if (align == TextAlignment.Left) {
            xoff = 0;
        }
        if (align == TextAlignment.Right) {
            xoff = w;
        }
        g.drawString(s, x - xoff, y + yoff);
        return new Rectangle(x - xoff, y - yoff, w, h);
    }

    private String formatDate(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("d MMM yy, HH:mm");
        return formatter.format((Object)date);
    }

    private void drawElevationLines(Graphics g) {
        double diff = this.profile.getHeightDifference();
        if (diff == 0.0) {
            return;
        }
        double z10 = Math.floor(Math.log10(diff));
        double scaleUnit = Math.pow(10.0, z10);
        int upperLimit = (int)((double)Math.round(Math.ceil((double)this.profile.getMaxHeight() / scaleUnit)) * scaleUnit);
        int lowerLimit = (int)((double)Math.round(Math.floor((double)this.profile.getMinHeight() / scaleUnit)) * scaleUnit);
        int su = (int)scaleUnit;
        int i = lowerLimit;
        while (i <= upperLimit) {
            int yLine = this.getYForEelevation(i);
            if (yLine <= this.getPlotBottom() && yLine >= this.getPlotTop()) {
                String txt = WayPointHelper.getElevationText(i);
                Rectangle r = this.drawAlignedString(txt, this.getPlotHCenter(), yLine - 2, TextAlignment.Right, g);
                r.grow(2, 2);
                g.drawLine(this.getPlotLeftAxis(), yLine, r.x, yLine);
                g.drawLine(r.x + r.width, yLine, this.getPlotRight(), yLine);
                g.setColor(Color.WHITE);
                this.drawAlignedString(txt, this.getPlotHCenter() + 1, yLine - 1, TextAlignment.Right, g);
                g.setColor(Color.BLACK);
                this.drawAlignedString(txt, this.getPlotHCenter(), yLine - 2, TextAlignment.Right, g);
            }
            i += su;
        }
    }

    private int getPlotLeftAxis() {
        return this.plotArea.x - 3;
    }

    private int getPlotLeft() {
        return this.plotArea.x + 1;
    }

    private int getPlotHCenter() {
        return (this.getPlotLeft() + this.getPlotRight()) / 2;
    }

    private int getPlotVCenter() {
        return (this.getPlotTop() + this.getPlotBottom()) / 2;
    }

    private int getPlotRight() {
        return this.plotArea.x + this.plotArea.width - 1;
    }

    private int getPlotBottom() {
        return this.plotArea.y + this.plotArea.height - 1;
    }

    private int getPlotTop() {
        return this.plotArea.y + 1;
    }

    private int getYForEelevation(int elevation) {
        int y1 = this.getPlotBottom();
        if (!this.profile.hasElevationData()) {
            return y1;
        }
        double diff = this.profile.getHeightDifference();
        return y1 - (int)Math.round((double)(elevation - this.profile.getMinHeight()) / diff * (double)this.plotArea.height);
    }

    private void drawProfile(Graphics g) {
        int n = Math.min(this.plotArea.width, this.profile.getNumberOfWayPoints());
        int yBottom = this.getPlotBottom();
        Color oldC = g.getColor();
        int i = 0;
        while (i < n) {
            WayPoint wpt = this.profile.getWayPoints().get(i);
            int eleVal = (int)WayPointHelper.getElevation(wpt);
            Color c = this.renderer.getColorForWaypoint(this.profile, wpt, ElevationWayPointKind.Plain);
            if (i == this.selectedIndex) {
                g.setColor(Color.BLACK);
                this.drawAlignedString(WayPointHelper.getElevationText(eleVal), (this.getPlotRight() + this.getPlotLeft()) / 2, this.getPlotBottom() + 6, TextAlignment.Centered, g);
                c = this.renderer.getColorForWaypoint(this.profile, wpt, ElevationWayPointKind.Highlighted);
            }
            int yEle = this.getYForEelevation(eleVal);
            int x = this.getPlotLeft() + i;
            g.setColor(c);
            g.drawLine(x, yBottom, x, yEle);
            byte geoidVal = 0;
            switch (WayPointHelper.getGeoidKind()) {
                case Auto: {
                    geoidVal = WayPointHelper.getGeoidCorrection(wpt);
                }
            }
            g.setColor(ElevationColors.EPLightBlue);
            int yGeoid = this.getYForEelevation(eleVal - geoidVal);
            g.drawLine(x, Math.min(yGeoid, yBottom), x, yEle);
            ++i;
        }
        g.setColor(oldC);
    }

    @Override
    protected void paintBorder(Graphics g) {
        super.paintBorder(g);
        Border loweredbevel = BorderFactory.createLoweredBevelBorder();
        this.setBorder(loweredbevel);
    }

    private void createOrUpdatePlotArea() {
        Dimension caSize = this.getSize();
        if (this.plotArea == null) {
            this.plotArea = new Rectangle(0, 0, caSize.width, caSize.height);
        } else {
            this.plotArea.width = caSize.width;
            this.plotArea.height = caSize.height;
        }
        this.plotArea.setLocation(0, 0);
        this.plotArea.grow(-10, -15);
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
    }

    @Override
    public void componentResized(ComponentEvent arg0) {
        this.createOrUpdatePlotArea();
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
        int pl;
        int l;
        int x;
        int newIdx;
        if (this.isPainting || arg0.isControlDown() || arg0.isAltDown() || arg0.isShiftDown()) {
            arg0.consume();
        }
        if ((newIdx = (x = arg0.getX()) - (l = this.getX()) - (pl = this.getPlotLeft())) != this.selectedIndex && newIdx >= 0) {
            this.selectedIndex = newIdx;
            this.repaint();
            this.fireSelectionChanged(this.getSelectedWayPoint());
        }
    }

    @Override
    public String getToolTipText() {
        WayPoint wpt = this.getSelectedWayPoint();
        if (wpt != null) {
            return String.format("%s: %s", WayPointHelper.getTimeText(wpt), WayPointHelper.getElevationText(wpt));
        }
        return super.getToolTipText();
    }
}

