/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.fixAddresses.IAddressEditContainerListener;
import org.openstreetmap.josm.plugins.fixAddresses.ICommandListener;
import org.openstreetmap.josm.plugins.fixAddresses.INodeEntity;
import org.openstreetmap.josm.plugins.fixAddresses.StringUtils;
import org.openstreetmap.josm.plugins.fixAddresses.TagUtils;
import org.openstreetmap.josm.tools.I18n;

public class NodeEntityBase
implements INodeEntity,
Comparable<INodeEntity> {
    public static final String ANONYMOUS = I18n.tr((String)"No name");
    private static List<IAddressEditContainerListener> containerListeners = new ArrayList<IAddressEditContainerListener>();
    private List<ICommandListener> cmdListeners = new ArrayList<ICommandListener>();
    protected OsmPrimitive osmObject;

    public NodeEntityBase(OsmPrimitive osmObject) {
        this.osmObject = osmObject;
    }

    protected void setOsmObject(OsmPrimitive osmObject) {
        this.osmObject = osmObject;
    }

    public static void addChangedListener(IAddressEditContainerListener listener) {
        containerListeners.add(listener);
    }

    public static void removeChangedListener(IAddressEditContainerListener listener) {
        containerListeners.remove(listener);
    }

    protected static void fireEntityChanged(INodeEntity entity) {
        for (IAddressEditContainerListener listener : containerListeners) {
            listener.entityChanged(entity);
        }
    }

    @Override
    public void addCommandListener(ICommandListener listener) {
        this.cmdListeners.add(listener);
    }

    @Override
    public void removeCommandListener(ICommandListener listener) {
        this.cmdListeners.remove(listener);
    }

    protected void fireCommandIssued(Command cmd) {
        if (this.cmdListeners.size() == 0) {
            throw new RuntimeException("Object has no TX context: " + this);
        }
        for (ICommandListener l : this.cmdListeners) {
            l.commandIssued(this, cmd);
        }
    }

    @Override
    public OsmPrimitive getOsmObject() {
        return this.osmObject;
    }

    @Override
    public List<INodeEntity> getChildren() {
        return null;
    }

    @Override
    public String getName() {
        if (TagUtils.hasNameTag(this.osmObject)) {
            return TagUtils.getNameValue(this.osmObject);
        }
        return "";
    }

    @Override
    public boolean hasName() {
        return TagUtils.hasNameTag(this.osmObject);
    }

    protected void setOSMTag(String tag, String newValue) {
        if (StringUtils.isNullOrEmpty(tag)) {
            return;
        }
        if (this.osmObject != null && (this.osmObject.hasKey(tag) && newValue == null || newValue != null)) {
            this.fireCommandIssued((Command)new ChangePropertyCommand(this.osmObject, tag, newValue));
            NodeEntityBase.fireEntityChanged(this);
        }
    }

    protected void removeOSMTag(String tag) {
        this.setOSMTag(tag, null);
    }

    public String toString() {
        if (this.hasName()) {
            return String.valueOf(this.getClass().getName()) + ": " + this.getName();
        }
        return String.valueOf(this.getClass().getName()) + ": " + ANONYMOUS;
    }

    @Override
    public int compareTo(INodeEntity o) {
        if (o == null || !(o instanceof NodeEntityBase)) {
            return -1;
        }
        return this.getName().compareTo(o.getName());
    }

    @Override
    public LatLon getCoor() {
        OsmPrimitive osm = this.getOsmObject();
        if (osm == null) {
            return null;
        }
        if (osm instanceof Node) {
            return ((Node)osm).getCoor();
        }
        if (osm instanceof Way) {
            Way w = (Way)osm;
            BBox bb = w.getBBox();
            return bb.getBottomRight().getCenter(bb.getTopLeft());
        }
        return null;
    }
}

