/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses.gui;

import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.fixAddresses.AddressEditContainer;
import org.openstreetmap.josm.plugins.fixAddresses.AddressFinderThread;
import org.openstreetmap.josm.plugins.fixAddresses.AddressNode;
import org.openstreetmap.josm.plugins.fixAddresses.gui.AbstractAddressEditAction;
import org.openstreetmap.josm.plugins.fixAddresses.gui.AddressEditSelectionEvent;
import org.openstreetmap.josm.tools.I18n;

public class GuessAddressDataAction
extends AbstractAddressEditAction {
    public GuessAddressDataAction() {
        super(I18n.tr((String)"Guess address data"), "guessstreets_24", "Tries to guess the street name by picking the name of the closest way.");
    }

    @Override
    public void updateEnabledState(AddressEditSelectionEvent ev) {
        this.setEnabled(ev != null && ev.getUnresolvedAddressTable() != null);
    }

    @Override
    protected void updateEnabledState(AddressEditContainer container) {
        this.setEnabled(container != null && container.getNumberOfIncompleteAddresses() > 0);
    }

    @Override
    public void addressEditActionPerformed(AddressEditContainer container) {
        if (container == null) {
            return;
        }
        if (container.getUnresolvedAddresses() == null) {
            return;
        }
        this.internalGuessAddresses(container.getIncompleteAddresses());
    }

    @Override
    public void addressEditActionPerformed(AddressEditSelectionEvent ev) {
        if (ev == null || ev.getSelectedUnresolvedAddresses() == null) {
            return;
        }
        this.internalGuessAddresses(ev.getSelectedUnresolvedAddresses());
    }

    private void internalGuessAddresses(List<AddressNode> nodes) {
        Main.worker.submit((Runnable)((Object)new AddressFinderThread(this.container, I18n.tr((String)"Guess street names"))));
    }
}

