/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses;

import java.io.IOException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.fixAddresses.AddressEditContainer;
import org.openstreetmap.josm.plugins.fixAddresses.AddressNode;
import org.openstreetmap.josm.plugins.fixAddresses.TagUtils;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class AddressFinderThread
extends PleaseWaitRunnable
implements Visitor {
    private AddressEditContainer container;
    private double minDist;
    private AddressNode curAddressNode;
    private boolean isRunning = false;
    private String nearestName = null;
    private String currentName = null;
    private boolean cancelled;

    public AddressFinderThread(AddressEditContainer AddressEditContainer2, String title) {
        super(title != null ? title : I18n.tr((String)"Searching"));
        this.setAddressEditContainer(AddressEditContainer2);
    }

    public void setAddressEditContainer(AddressEditContainer AddressEditContainer2) {
        if (this.isRunning) {
            throw new ConcurrentModificationException();
        }
        this.container = AddressEditContainer2;
    }

    public AddressEditContainer getAddressEditContainer() {
        return this.container;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void visit(Node n) {
        if (n == null) {
            return;
        }
        if (this.curAddressNode == null) {
            return;
        }
        LatLon ll = this.curAddressNode.getCoor();
        if (ll == null) {
            return;
        }
        double dist = ll.greatCircleDistance(n.getCoor());
        if (dist < this.minDist) {
            this.minDist = dist;
            this.nearestName = this.currentName;
        }
    }

    public void visit(Way w) {
        if (!TagUtils.hasHighwayTag((OsmPrimitive)w)) {
            return;
        }
        if (!TagUtils.hasNameTag((OsmPrimitive)w)) {
            return;
        }
        this.currentName = TagUtils.getNameValue((OsmPrimitive)w);
        for (Node node : w.getNodes()) {
            this.visit(node);
        }
    }

    public void visit(Relation e) {
    }

    public void visit(Changeset cs) {
    }

    protected void cancel() {
        this.cancelled = true;
    }

    protected void finish() {
    }

    protected void realRun() throws SAXException, IOException, OsmTransferException {
        if (Main.main.getCurrentDataSet() == null || this.container == null) {
            return;
        }
        this.isRunning = true;
        this.cancelled = false;
        this.progressMonitor.subTask(String.valueOf(I18n.tr((String)"Searching")) + "...");
        try {
            this.progressMonitor.setTicksCount(this.container.getNumberOfUnresolvedAddresses());
            ArrayList<AddressNode> shadowCopy = new ArrayList<AddressNode>(this.container.getUnresolvedAddresses());
            for (AddressNode aNode : shadowCopy) {
                this.minDist = Double.MAX_VALUE;
                this.curAddressNode = aNode;
                if (this.cancelled) break;
                for (OsmPrimitive osmPrimitive : Main.main.getCurrentDataSet().getWays()) {
                    if (this.cancelled) break;
                    osmPrimitive.visit((Visitor)this);
                }
                if (this.nearestName != null) {
                    this.progressMonitor.subTask(String.format("%s: %s (%4.1f m)", I18n.tr((String)"Guess"), this.nearestName, this.minDist));
                    aNode.setGuessedStreetName(this.nearestName);
                    this.nearestName = null;
                } else {
                    System.out.println("Did not find a street for " + aNode);
                }
                this.progressMonitor.worked(1);
            }
            this.container.invalidate();
        }
        finally {
            this.isRunning = false;
        }
    }
}

