/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.plugins.fixAddresses.AddressNode;
import org.openstreetmap.josm.plugins.fixAddresses.IAddressEditContainerListener;
import org.openstreetmap.josm.plugins.fixAddresses.INodeEntity;
import org.openstreetmap.josm.plugins.fixAddresses.NodeEntityBase;
import org.openstreetmap.josm.plugins.fixAddresses.NodeFactory;
import org.openstreetmap.josm.plugins.fixAddresses.StreetNode;
import org.openstreetmap.josm.plugins.fixAddresses.StreetSegmentNode;
import org.openstreetmap.josm.plugins.fixAddresses.StringUtils;

public class AddressEditContainer
implements Visitor,
DataSetListener,
IAddressEditContainerListener {
    private HashMap<String, StreetNode> streetDict = new HashMap(100);
    private List<AddressNode> unresolvedAddresses = new ArrayList<AddressNode>(100);
    private List<AddressNode> incompleteAddresses = new ArrayList<AddressNode>(100);
    private HashMap<String, StreetNode> shadowStreetDict = new HashMap(100);
    private List<AddressNode> shadowUnresolvedAddresses = new ArrayList<AddressNode>(100);
    private List<AddressNode> shadowIncompleteAddresses = new ArrayList<AddressNode>(100);
    private HashSet<Node> visitedNodes = new HashSet();
    private HashSet<Way> visitedWays = new HashSet();
    private HashSet<String> tags = new HashSet();
    private List<IAddressEditContainerListener> listeners = new ArrayList<IAddressEditContainerListener>();

    public AddressEditContainer() {
        NodeEntityBase.addChangedListener(this);
    }

    public void addChangedListener(IAddressEditContainerListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangedListener(IAddressEditContainerListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireContainerChanged() {
        ArrayList<IAddressEditContainerListener> shadowListeners = new ArrayList<IAddressEditContainerListener>(this.listeners);
        for (IAddressEditContainerListener listener : shadowListeners) {
            listener.containerChanged(this);
        }
    }

    private void markNodeAsVisited(Node n) {
        this.visitedNodes.add(n);
    }

    private boolean hasBeenVisited(Node n) {
        return this.visitedNodes.contains(n);
    }

    private void markWayAsVisited(Way w) {
        this.visitedWays.add(w);
    }

    private boolean hasBeenVisited(Way w) {
        return this.visitedWays.contains(w);
    }

    public void visit(Node n) {
        if (this.hasBeenVisited(n)) {
            return;
        }
        AddressNode aNode = null;
        aNode = NodeFactory.createNode(n);
        if (aNode != null) {
            this.addAndClassifyAddress(aNode);
        }
        this.markNodeAsVisited(n);
    }

    public void visit(Way w) {
        if (this.hasBeenVisited(w)) {
            return;
        }
        this.createNodeFromWay(w);
        this.markWayAsVisited(w);
    }

    private void addAndClassifyAddress(AddressNode aNode) {
        if (!this.assignAddressToStreet(aNode)) {
            this.shadowUnresolvedAddresses.add(aNode);
        }
        if (!aNode.isComplete()) {
            this.shadowIncompleteAddresses.add(aNode);
        }
    }

    private void createNodeFromWay(Way w) {
        INodeEntity ne = NodeFactory.createNodeFromWay(w);
        if (!this.processNode(ne, w)) {
            for (Node n : w.getNodes()) {
                this.visit(n);
            }
            for (String key : w.keySet()) {
                if (this.tags.contains(key)) continue;
                this.tags.add(key);
            }
        }
    }

    private boolean processNode(INodeEntity ne, Way w) {
        if (ne != null) {
            StreetSegmentNode newSegment;
            if (ne instanceof StreetSegmentNode && (newSegment = (StreetSegmentNode)ne) != null) {
                String name = newSegment.getName();
                if (StringUtils.isNullOrEmpty(name)) {
                    return false;
                }
                StreetNode sNode = null;
                if (this.shadowStreetDict.containsKey(name)) {
                    sNode = this.shadowStreetDict.get(name);
                } else {
                    sNode = new StreetNode((OsmPrimitive)w);
                    this.shadowStreetDict.put(name, sNode);
                }
                if (sNode != null) {
                    sNode.addStreetSegment(newSegment);
                    return true;
                }
                throw new RuntimeException("Street node is null!");
            }
            if (ne instanceof AddressNode) {
                AddressNode aNode = (AddressNode)ne;
                this.addAndClassifyAddress(aNode);
                return true;
            }
        }
        return false;
    }

    public void visit(Relation e) {
    }

    public void visit(Changeset cs) {
    }

    public HashMap<String, StreetNode> getStreetDict() {
        return this.streetDict;
    }

    public List<AddressNode> getUnresolvedAddresses() {
        return this.unresolvedAddresses;
    }

    public List<AddressNode> getIncompleteAddresses() {
        return this.incompleteAddresses;
    }

    public List<StreetNode> getStreetList() {
        ArrayList<StreetNode> sortedList = new ArrayList<StreetNode>(this.streetDict.values());
        Collections.sort(sortedList);
        return sortedList;
    }

    public List<AddressNode> getUnresolvedItems() {
        return this.unresolvedAddresses;
    }

    public HashSet<String> getTags() {
        return this.tags;
    }

    public int getNumberOfStreets() {
        return this.streetDict != null ? this.streetDict.size() : 0;
    }

    public int getNumberOfIncompleteAddresses() {
        return this.incompleteAddresses != null ? this.incompleteAddresses.size() : 0;
    }

    public int getNumberOfUnresolvedAddresses() {
        return this.unresolvedAddresses != null ? this.unresolvedAddresses.size() : 0;
    }

    public int getNumberOfGuesses() {
        int sum = 0;
        for (AddressNode aNode : this.getAllAddressesToFix()) {
            if (!aNode.hasGuesses()) continue;
            ++sum;
        }
        return sum;
    }

    public List<AddressNode> getAllAddressesToFix() {
        ArrayList<AddressNode> all = new ArrayList<AddressNode>(this.incompleteAddresses);
        for (AddressNode aNode : this.unresolvedAddresses) {
            if (all.contains(aNode)) continue;
            all.add(aNode);
        }
        return all;
    }

    private boolean assignAddressToStreet(AddressNode aNode) {
        String streetName = aNode.getStreet();
        if (streetName != null && this.shadowStreetDict.containsKey(streetName)) {
            StreetNode sNode = this.shadowStreetDict.get(streetName);
            sNode.addAddress(aNode);
            return true;
        }
        return false;
    }

    public void resolveAddresses() {
        ArrayList<AddressNode> resolvedAddresses = new ArrayList<AddressNode>();
        for (AddressNode node : this.shadowUnresolvedAddresses) {
            if (!this.assignAddressToStreet(node)) continue;
            resolvedAddresses.add(node);
        }
        for (AddressNode resolved : resolvedAddresses) {
            this.shadowUnresolvedAddresses.remove(resolved);
        }
    }

    public void invalidate() {
        this.invalidate(Main.main.getCurrentDataSet().allPrimitives());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(Collection<? extends OsmPrimitive> osmData) {
        if (osmData == null || osmData.isEmpty()) {
            return;
        }
        AddressEditContainer addressEditContainer = this;
        synchronized (addressEditContainer) {
            this.clearData();
            for (OsmPrimitive osmPrimitive : osmData) {
                osmPrimitive.visit((Visitor)this);
            }
            this.resolveAddresses();
            Collections.sort(this.shadowIncompleteAddresses);
            Collections.sort(this.shadowUnresolvedAddresses);
            this.incompleteAddresses = new ArrayList<AddressNode>(this.shadowIncompleteAddresses);
            this.unresolvedAddresses = new ArrayList<AddressNode>(this.shadowUnresolvedAddresses);
            this.streetDict = new HashMap<String, StreetNode>(this.shadowStreetDict);
            this.shadowStreetDict.clear();
            this.shadowUnresolvedAddresses.clear();
            this.shadowIncompleteAddresses.clear();
            this.fireContainerChanged();
        }
    }

    public void clearData() {
        this.shadowStreetDict.clear();
        this.shadowUnresolvedAddresses.clear();
        this.shadowIncompleteAddresses.clear();
        this.visitedNodes.clear();
        this.visitedWays.clear();
    }

    public void attachToDataSet(Collection<? extends OsmPrimitive> dataToExamine) {
        Main.main.getCurrentDataSet().addDataSetListener((DataSetListener)this);
        if (dataToExamine != null && dataToExamine.size() > 0) {
            this.invalidate(dataToExamine);
        } else {
            this.invalidate();
        }
    }

    public void detachFromDataSet() {
        Main.main.getCurrentDataSet().removeDataSetListener((DataSetListener)this);
    }

    public void dataChanged(DataChangedEvent event) {
    }

    public void nodeMoved(NodeMovedEvent event) {
    }

    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }

    public void primtivesAdded(PrimitivesAddedEvent event) {
        this.invalidate();
    }

    public void primtivesRemoved(PrimitivesRemovedEvent event) {
        this.invalidate();
    }

    public void relationMembersChanged(RelationMembersChangedEvent event) {
    }

    public void tagsChanged(TagsChangedEvent event) {
        this.invalidate();
    }

    public void wayNodesChanged(WayNodesChangedEvent event) {
    }

    @Override
    public void containerChanged(AddressEditContainer container) {
    }

    @Override
    public void entityChanged(INodeEntity entity) {
        this.invalidate();
    }
}

