/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses.gui;

import java.awt.event.ActionEvent;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.plugins.fixAddresses.AddressEditContainer;
import org.openstreetmap.josm.plugins.fixAddresses.IAddressEditContainerListener;
import org.openstreetmap.josm.plugins.fixAddresses.INodeEntity;
import org.openstreetmap.josm.plugins.fixAddresses.gui.AddressEditSelectionEvent;

public abstract class AbstractAddressEditAction
extends JosmAction
implements IAddressEditContainerListener {
    private AddressEditSelectionEvent event;
    protected AddressEditContainer container;

    public AbstractAddressEditAction(String name, String iconName, String tooltip) {
        super(name, iconName, tooltip, null, true);
        this.setEnabled(false);
    }

    public AbstractAddressEditAction(String name) {
        this(name, null, "");
    }

    public AddressEditContainer getContainer() {
        return this.container;
    }

    public void setContainer(AddressEditContainer container) {
        if (container != null) {
            container.removeChangedListener(this);
        }
        this.container = container;
        this.updateEnabledState();
        if (container != null) {
            container.addChangedListener(this);
        }
    }

    protected AddressEditSelectionEvent getEvent() {
        return this.event;
    }

    protected void setEvent(AddressEditSelectionEvent event) {
        this.event = event;
        this.updateEnabledState();
    }

    public void actionPerformed(ActionEvent arg0) {
        if (this.event != null) {
            this.addressEditActionPerformed(this.event);
            this.event = null;
        } else if (this.container != null) {
            this.addressEditActionPerformed(this.container);
        } else {
            this.actionPerformed(arg0);
        }
    }

    protected void updateEnabledState() {
        if (this.event != null) {
            this.updateEnabledState(this.event);
        } else if (this.container != null) {
            this.updateEnabledState(this.container);
        } else {
            super.updateEnabledState();
        }
    }

    protected abstract void updateEnabledState(AddressEditContainer var1);

    protected abstract void updateEnabledState(AddressEditSelectionEvent var1);

    public abstract void addressEditActionPerformed(AddressEditSelectionEvent var1);

    public abstract void addressEditActionPerformed(AddressEditContainer var1);

    @Override
    public void containerChanged(AddressEditContainer container) {
        this.updateEnabledState();
    }

    @Override
    public void entityChanged(INodeEntity node) {
        this.updateEnabledState();
    }
}

