/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses;

import java.awt.event.ActionEvent;
import java.util.Collection;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.fixAddresses.AddressEditContainer;
import org.openstreetmap.josm.plugins.fixAddresses.gui.AddressEditDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class FixUnresolvedStreetsAction
extends JosmAction
implements SelectionChangedListener {
    private static final long serialVersionUID = 1L;
    private AddressEditContainer addressEditContainer;
    private Collection<? extends OsmPrimitive> newSelection;

    public FixUnresolvedStreetsAction() {
        super(I18n.tr((String)"Fix street addresses"), "fixstreets_24", I18n.tr((String)"Find and fix addresses without (valid) streets."), Shortcut.registerShortcut((String)"tools:AddressEdit", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Address Edit")}), (int)65, (int)2, (int)576), false);
        this.setEnabled(false);
        this.addressEditContainer = new AddressEditContainer();
        DataSet.addSelectionListener((SelectionChangedListener)this);
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
    }

    public void actionPerformed(ActionEvent arg0) {
        if (this.addressEditContainer != null) {
            this.addressEditContainer.attachToDataSet(this.newSelection);
            try {
                AddressEditDialog dlg = new AddressEditDialog(this.addressEditContainer);
                dlg.setVisible(true);
            }
            finally {
                this.addressEditContainer.detachFromDataSet();
            }
        }
    }

    protected void updateEnabledState() {
        this.setEnabled(this.getCurrentDataSet() != null);
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty() || this.getCurrentDataSet() != null);
    }

    private void generateTagCode(AddressEditContainer addrVisitor) {
        for (String tag : addrVisitor.getTags()) {
            String methodName = this.createMethodName(tag);
            System.out.println(String.format("/** Check if OSM primitive has a tag '%s'.\n * @param osmPrimitive The OSM entity to check.*/\npublic static boolean has%sTag(OsmPrimitive osmPrimitive) {\n return osmPrimitive != null ? osmPrimitive.hasKey(%s_TAG) : false;\n}\n", tag, methodName, tag.toUpperCase().replaceAll(":", "_")));
            System.out.println(String.format("/** Gets the value of tag '%s'.\n * @param osmPrimitive The OSM entity to check.*/\npublic static String get%sValue(OsmPrimitive osmPrimitive) {\n return osmPrimitive != null ? osmPrimitive.get(%s_TAG) : null;\n}\n", tag, methodName, tag.toUpperCase().replaceAll(":", "_")));
        }
        for (String tag : addrVisitor.getTags()) {
            System.out.println(String.format("public static final String %s_TAG = \"%s\";", tag.toUpperCase().replaceAll(":", "_"), tag));
        }
    }

    private String createMethodName(String osmName) {
        StringBuffer result = new StringBuffer(osmName.length());
        boolean nextUp = false;
        int i = 0;
        while (i < osmName.length()) {
            char c = osmName.charAt(i);
            if (i == 0) {
                result.append(Character.toUpperCase(c));
            } else if (c == '_' || c == ':') {
                nextUp = true;
            } else if (nextUp) {
                result.append(Character.toUpperCase(c));
                nextUp = false;
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }
}

