/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses.gui;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.fixAddresses.AddressEditContainer;
import org.openstreetmap.josm.plugins.fixAddresses.AddressNode;
import org.openstreetmap.josm.plugins.fixAddresses.gui.AbstractAddressEditAction;
import org.openstreetmap.josm.plugins.fixAddresses.gui.AddressEditSelectionEvent;
import org.openstreetmap.josm.tools.I18n;

public class SelectAddressesInMapAction
extends AbstractAddressEditAction {
    public SelectAddressesInMapAction() {
        super(I18n.tr((String)"Select in map"), "selectall", "Selects selected addresses in the map");
    }

    @Override
    public void addressEditActionPerformed(AddressEditSelectionEvent ev) {
        if (ev == null) {
            return;
        }
        this.internalSelectAddresses(ev.getSelectedUnresolvedAddresses());
    }

    @Override
    public void addressEditActionPerformed(AddressEditContainer container) {
        this.internalSelectAddresses(container.getUnresolvedAddresses());
    }

    @Override
    protected void updateEnabledState(AddressEditContainer container) {
        this.setEnabled(container != null && container.getNumberOfIncompleteAddresses() > 0);
    }

    @Override
    protected void updateEnabledState(AddressEditSelectionEvent event) {
        this.setEnabled(event != null && event.getSelectedUnresolvedAddresses() != null);
    }

    private void internalSelectAddresses(List<AddressNode> addrToSel) {
        if (addrToSel == null) {
            return;
        }
        ArrayList<OsmPrimitive> sel = new ArrayList<OsmPrimitive>();
        for (AddressNode aNode : addrToSel) {
            sel.add(aNode.getOsmObject());
        }
        this.getCurrentDataSet().setSelected(sel);
    }
}

