/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses.gui;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.plugins.fixAddresses.AddressEditContainer;
import org.openstreetmap.josm.plugins.fixAddresses.AddressNode;
import org.openstreetmap.josm.plugins.fixAddresses.gui.AbstractAddressEditAction;
import org.openstreetmap.josm.plugins.fixAddresses.gui.AddressEditSelectionEvent;
import org.openstreetmap.josm.tools.I18n;

public class ApplyAllGuessesAction
extends AbstractAddressEditAction {
    public ApplyAllGuessesAction() {
        super(I18n.tr((String)"Apply all guesses"), "applyguesses_24", "Turns all guesses into the corresponding tag values.");
    }

    @Override
    public void addressEditActionPerformed(AddressEditSelectionEvent ev) {
        if (ev == null || ev.getSelectedUnresolvedAddresses() == null) {
            return;
        }
        List<AddressNode> addrToFix = ev.getSelectedUnresolvedAddresses();
        this.applyGuesses(addrToFix);
    }

    @Override
    protected void updateEnabledState(AddressEditContainer container) {
        this.setEnabled(container != null && container.getNumberOfGuesses() > 0);
    }

    private void applyGuesses(List<AddressNode> addrToFix) {
        ArrayList<AddressNode> addrToFixShadow = new ArrayList<AddressNode>(addrToFix);
        for (AddressNode aNode : addrToFixShadow) {
            aNode.applyAllGuesses();
        }
    }

    @Override
    protected void updateEnabledState(AddressEditSelectionEvent event) {
    }

    @Override
    public void addressEditActionPerformed(AddressEditContainer container) {
        if (container == null || container.getUnresolvedAddresses() == null) {
            return;
        }
        List<AddressNode> addrToFix = container.getUnresolvedAddresses();
        this.applyGuesses(addrToFix);
    }
}

