/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses.gui;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import org.openstreetmap.josm.plugins.fixAddresses.AddressEditContainer;
import org.openstreetmap.josm.plugins.fixAddresses.AddressNode;
import org.openstreetmap.josm.plugins.fixAddresses.StreetNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressEditSelectionEvent
extends ActionEvent {
    private static final long serialVersionUID = -93034483427803409L;
    private JTable streetTable;
    private JTable unresolvedAddressTable;
    private AddressEditContainer addressContainer;

    public AddressEditSelectionEvent(Object source, JTable selStreet, JTable unresolvedAddr, AddressEditContainer container) {
        super(source, -1, "");
        this.streetTable = selStreet;
        this.unresolvedAddressTable = unresolvedAddr;
        this.addressContainer = container;
    }

    public JTable getStreetTable() {
        return this.streetTable;
    }

    public JTable getUnresolvedAddressTable() {
        return this.unresolvedAddressTable;
    }

    public AddressEditContainer getAddressContainer() {
        return this.addressContainer;
    }

    public StreetNode getSelectedStreet() {
        if (this.streetTable != null && this.addressContainer != null && this.addressContainer.getStreetList() != null) {
            int selRows = this.streetTable.getSelectedRow();
            if (selRows < 0 || selRows >= this.addressContainer.getNumberOfStreets()) {
                return null;
            }
            return this.addressContainer.getStreetList().get(selRows);
        }
        return null;
    }

    public List<AddressNode> getSelectedUnresolvedAddresses() {
        if (this.unresolvedAddressTable != null && this.addressContainer != null && this.addressContainer.getUnresolvedAddresses() != null) {
            int[] selRows = this.unresolvedAddressTable.getSelectedRows();
            ArrayList<AddressNode> nodes = new ArrayList<AddressNode>();
            for (int i = 0; i < selRows.length; ++i) {
                if (i < 0 || i >= this.addressContainer.getNumberOfUnresolvedAddresses()) continue;
                nodes.add(this.addressContainer.getUnresolvedAddresses().get(selRows[i]));
            }
            return nodes;
        }
        return null;
    }
}

