/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.addressEdit.gui;

import org.openstreetmap.josm.plugins.addressEdit.AddressEditContainer;
import org.openstreetmap.josm.plugins.addressEdit.AddressNode;
import org.openstreetmap.josm.plugins.addressEdit.INodeEntity;
import org.openstreetmap.josm.plugins.addressEdit.StringUtils;
import org.openstreetmap.josm.plugins.addressEdit.gui.AddressEditTableModel;
import org.openstreetmap.josm.tools.I18n;

public class IncompleteAddressesTableModel
extends AddressEditTableModel {
    private static final long serialVersionUID = -5951629033395186324L;
    private static final int NUMBER_OF_COLUMNS = 5;
    private static final String[] COLUMN_NAMES = new String[]{I18n.tr((String)"Country"), I18n.tr((String)"State"), I18n.tr((String)"City"), I18n.tr((String)"Post Code"), I18n.tr((String)"Street")};
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{String.class, String.class, String.class, String.class, String.class};

    public IncompleteAddressesTableModel(AddressEditContainer addressContainer) {
        super(addressContainer);
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public int getRowCount() {
        if (this.addressContainer == null || this.addressContainer.getIncompleteAddresses() == null) {
            return 0;
        }
        return this.addressContainer.getNumberOfIncompleteAddresses();
    }

    @Override
    public Object getValueAt(int row, int column) {
        AddressNode aNode = (AddressNode)this.getEntityOfRow(row);
        if (aNode == null) {
            return null;
        }
        switch (column) {
            case 0: {
                return aNode.getCountry();
            }
            case 1: {
                return aNode.getState();
            }
            case 2: {
                return aNode.getCity();
            }
            case 3: {
                return aNode.getPostCode();
            }
            case 4: {
                if (!StringUtils.isNullOrEmpty(aNode.getGuessedStreetName()) && "?".equals(aNode.getStreet())) {
                    return "(" + aNode.getGuessedStreetName() + ")";
                }
                return aNode.getStreet();
            }
        }
        throw new RuntimeException("Invalid column index: " + column);
    }

    @Override
    public Class<?> getColumnClass(int arg0) {
        return COLUMN_CLASSES[arg0];
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public INodeEntity getEntityOfRow(int row) {
        if (this.addressContainer == null || this.addressContainer.getIncompleteAddresses() == null) {
            return null;
        }
        if (row < 0 || row > this.addressContainer.getNumberOfIncompleteAddresses()) {
            return null;
        }
        return this.addressContainer.getIncompleteAddresses().get(row);
    }
}

