/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.addressEdit.gui;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.plugins.addressEdit.AddressEditContainer;
import org.openstreetmap.josm.plugins.addressEdit.AddressFinderThread;
import org.openstreetmap.josm.plugins.addressEdit.AddressNode;
import org.openstreetmap.josm.plugins.addressEdit.gui.AbstractAddressEditAction;
import org.openstreetmap.josm.plugins.addressEdit.gui.AddressEditSelectionEvent;
import org.openstreetmap.josm.tools.I18n;

public class GuessAddressDataAction
extends AbstractAddressEditAction {
    private static final int THREAD_COUNT = 5;
    private AddressFinderThread[] threads = new AddressFinderThread[5];

    public GuessAddressDataAction() {
        super(I18n.tr((String)"Guess address data"), "guessstreets_24", "Tries to guess the street name by picking the name of the closest way.");
    }

    @Override
    public void updateEnabledState(AddressEditSelectionEvent ev) {
        this.setEnabled(ev != null && ev.getUnresolvedAddressTable() != null);
    }

    @Override
    protected void updateEnabledState(AddressEditContainer container) {
        this.setEnabled(container != null && container.getNumberOfIncompleteAddresses() > 0);
    }

    @Override
    public void addressEditActionPerformed(AddressEditContainer container) {
        if (container == null) {
            return;
        }
        if (container.getUnresolvedAddresses() == null) {
            return;
        }
        this.internalGuessAddresses(container.getIncompleteAddresses());
    }

    @Override
    public void addressEditActionPerformed(AddressEditSelectionEvent ev) {
        if (ev == null || ev.getSelectedUnresolvedAddresses() == null) {
            return;
        }
        this.internalGuessAddresses(ev.getSelectedUnresolvedAddresses());
    }

    /*
     * Unable to fully structure code
     */
    private void internalGuessAddresses(List<AddressNode> nodes) {
        i = 0;
        while (i < this.threads.length) {
            this.threads[i] = new AddressFinderThread();
            ++i;
        }
        addrNodes = new ArrayList<AddressNode>(nodes);
        for (AddressNode aNode : addrNodes) {
            if (!aNode.hasStreetName()) ** GOTO lbl15
            continue;
lbl-1000:
            // 1 sources

            {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    return;
                }
lbl15:
                // 2 sources

                ** while (!this.scheduleNode((AddressNode)aNode))
            }
lbl16:
            // 1 sources

        }
        this.container.containerChanged(this.container);
    }

    private boolean scheduleNode(AddressNode aNode) {
        int i = 0;
        while (i < this.threads.length) {
            if (!this.threads[i].isRunning()) {
                this.threads[i].setAddressNode(aNode);
                this.threads[i].run();
                return true;
            }
            ++i;
        }
        return false;
    }
}

