/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.addressEdit;

import java.util.ConcurrentModificationException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.plugins.addressEdit.AddressNode;
import org.openstreetmap.josm.plugins.addressEdit.TagUtils;

public class AddressFinderThread
implements Runnable,
Visitor {
    private AddressNode addressNode;
    private double minDist;
    private Node nearestNode;
    private Node osmAddressNode;
    private boolean isRunning = false;
    private String nearestName = null;
    private String currentName = null;

    public AddressFinderThread(AddressNode addressNode) {
        this.setAddressNode(addressNode);
    }

    public AddressFinderThread() {
        this(null);
    }

    public void setAddressNode(AddressNode addressNode) {
        if (this.isRunning) {
            throw new ConcurrentModificationException();
        }
        this.addressNode = addressNode;
        if (addressNode != null && addressNode.getOsmObject() instanceof Node) {
            this.osmAddressNode = (Node)addressNode.getOsmObject();
        }
    }

    public AddressNode getAddressNode() {
        return this.addressNode;
    }

    public double getMinDist() {
        return this.minDist;
    }

    public Node getNearestNode() {
        return this.nearestNode;
    }

    public String getGuessedName() {
        return this.nearestName;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (Main.main.getCurrentDataSet() == null || this.osmAddressNode == null) {
            return;
        }
        this.isRunning = true;
        AddressFinderThread addressFinderThread = this;
        synchronized (addressFinderThread) {
            try {
                this.minDist = Double.MAX_VALUE;
                for (OsmPrimitive osmPrimitive : Main.main.getCurrentDataSet().getWays()) {
                    osmPrimitive.visit((Visitor)this);
                }
                if (this.nearestName != null) {
                    System.out.println("Picked " + this.nearestName + " with distance " + this.minDist + "m");
                    this.addressNode.setGuessedStreetName(this.nearestName);
                }
            }
            finally {
                this.isRunning = false;
            }
        }
    }

    public void visit(Node n) {
        double dist = this.osmAddressNode.getCoor().greatCircleDistance(n.getCoor());
        if (dist < this.minDist) {
            this.minDist = dist;
            this.nearestNode = n;
            this.nearestName = this.currentName;
        }
    }

    public void visit(Way w) {
        if (!TagUtils.hasHighwayTag((OsmPrimitive)w)) {
            return;
        }
        if (!TagUtils.hasNameTag((OsmPrimitive)w)) {
            return;
        }
        this.currentName = TagUtils.getNameValue((OsmPrimitive)w);
        for (Node node : w.getNodes()) {
            this.visit(node);
        }
    }

    public void visit(Relation e) {
    }

    public void visit(Changeset cs) {
    }
}

