/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.addressEdit.gui;

import org.openstreetmap.josm.plugins.addressEdit.AddressEditContainer;
import org.openstreetmap.josm.plugins.addressEdit.AddressNode;
import org.openstreetmap.josm.plugins.addressEdit.StreetNode;
import org.openstreetmap.josm.plugins.addressEdit.gui.AbstractAddressEditAction;
import org.openstreetmap.josm.plugins.addressEdit.gui.AddressEditSelectionEvent;
import org.openstreetmap.josm.tools.I18n;

public class AssignAddressToStreetAction
extends AbstractAddressEditAction {
    private static final long serialVersionUID = -6180491357232121384L;

    public AssignAddressToStreetAction() {
        super(I18n.tr((String)"Assign address to street"), "assignstreet_24", "Assign the selected address(es) to the selected street.");
    }

    @Override
    public void addressEditActionPerformed(AddressEditSelectionEvent ev) {
        StreetNode streetNode = ev.getSelectedStreet();
        if (streetNode != null && ev.getSelectedUnresolvedAddresses() != null) {
            for (AddressNode addrNode : ev.getSelectedUnresolvedAddresses()) {
                addrNode.assignStreet(streetNode);
                System.out.println("Assign " + addrNode + " to " + streetNode);
            }
        }
    }

    @Override
    public void updateEnabledState(AddressEditSelectionEvent ev) {
        this.setEnabled(ev.getSelectedStreet() != null && ev.getSelectedUnresolvedAddresses() != null);
    }

    @Override
    public void updateEnabledState(AddressEditContainer container) {
        this.setEnabled(false);
    }

    @Override
    public void addressEditActionPerformed(AddressEditContainer container) {
    }
}

