/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.addressEdit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.MapMarkerDot;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.properties.PresetListPanel;
import org.openstreetmap.josm.plugins.addressEdit.AddressEditContainer;
import org.openstreetmap.josm.plugins.addressEdit.AddressNode;
import org.openstreetmap.josm.plugins.addressEdit.IAddressEditContainerListener;
import org.openstreetmap.josm.plugins.addressEdit.INodeEntity;
import org.openstreetmap.josm.plugins.addressEdit.StreetNode;
import org.openstreetmap.josm.plugins.addressEdit.StringUtils;
import org.openstreetmap.josm.plugins.addressEdit.gui.AbstractAddressEditAction;
import org.openstreetmap.josm.plugins.addressEdit.gui.AddressEditSelectionEvent;
import org.openstreetmap.josm.plugins.addressEdit.gui.ApplyAllGuessesAction;
import org.openstreetmap.josm.plugins.addressEdit.gui.AssignAddressToStreetAction;
import org.openstreetmap.josm.plugins.addressEdit.gui.GuessAddressDataAction;
import org.openstreetmap.josm.plugins.addressEdit.gui.IncompleteAddressesMouseListener;
import org.openstreetmap.josm.plugins.addressEdit.gui.SelectAddressesInMapAction;
import org.openstreetmap.josm.plugins.addressEdit.gui.StreetTableModel;
import org.openstreetmap.josm.plugins.addressEdit.gui.UnresolvedAddressesTableModel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class AddressEditDialog
extends JDialog
implements ActionListener,
ListSelectionListener,
IAddressEditContainerListener {
    private static final String UNRESOLVED_HEADER_FMT = I18n.tr((String)"Unresolved Addresses (%d)");
    private static final String STREET_HEADER_FMT = I18n.tr((String)"Streets (%d)");
    private static final String OK_COMMAND = I18n.tr((String)"Close");
    private static final String SELECT_AND_CLOSE = I18n.tr((String)"Select and close");
    private AddressEditContainer editContainer;
    private JTable unresolvedTable;
    private JTable streetTable;
    private AssignAddressToStreetAction resolveAction = new AssignAddressToStreetAction();
    private ApplyAllGuessesAction applyAllGuessesAction = new ApplyAllGuessesAction();
    private GuessAddressDataAction guessAddressAction = new GuessAddressDataAction();
    private SelectAddressesInMapAction selectAddressesInMapAction = new SelectAddressesInMapAction();
    private AbstractAddressEditAction[] actions = new AbstractAddressEditAction[]{this.resolveAction, this.guessAddressAction, this.applyAllGuessesAction, this.selectAddressesInMapAction};
    private JLabel streetLabel;
    private JLabel unresolvedAddressesLabel;
    private JMapViewer mapViewer;

    public AddressEditDialog(AddressEditContainer addressEditContainer) throws HeadlessException {
        super(JOptionPane.getFrameForComponent(Main.parent), I18n.tr((String)"Fix unresolved addresses"), false);
        this.editContainer = addressEditContainer;
        this.editContainer.addChangedListener(this);
        this.setLayout(new BorderLayout());
        this.setSize(1024, 600);
        this.setLocationRelativeTo(null);
        if (addressEditContainer != null) {
            JPanel streetPanel = new JPanel(new BorderLayout());
            this.streetTable = new JTable(new StreetTableModel(this.editContainer));
            this.streetTable.getSelectionModel().setSelectionMode(0);
            this.streetTable.getSelectionModel().addListSelectionListener(this);
            JScrollPane scroll1 = new JScrollPane(this.streetTable);
            streetPanel.add((Component)scroll1, "Center");
            this.streetLabel = this.createHeaderLabel(STREET_HEADER_FMT, this.editContainer.getNumberOfStreets());
            streetPanel.add((Component)this.streetLabel, "North");
            streetPanel.setMinimumSize(new Dimension(350, 300));
            JPanel unresolvedPanel = new JPanel(new BorderLayout());
            this.unresolvedTable = new JTable(new UnresolvedAddressesTableModel(this.editContainer));
            this.unresolvedTable.getSelectionModel().setSelectionMode(2);
            this.unresolvedTable.getSelectionModel().addListSelectionListener(this);
            this.unresolvedTable.getSelectionModel().addListSelectionListener(new IncompleteAddressListener());
            this.unresolvedTable.addMouseListener(new IncompleteAddressesMouseListener());
            JScrollPane scroll2 = new JScrollPane(this.unresolvedTable);
            unresolvedPanel.add((Component)scroll2, "Center");
            this.unresolvedAddressesLabel = this.createHeaderLabel(UNRESOLVED_HEADER_FMT, this.editContainer.getNumberOfUnresolvedAddresses());
            unresolvedPanel.add((Component)this.unresolvedAddressesLabel, "North");
            unresolvedPanel.setMinimumSize(new Dimension(350, 200));
            try {
                JPanel unresolvedButtons = new JPanel(new FlowLayout());
                SideButton assign = new SideButton((Action)((Object)this.resolveAction));
                unresolvedButtons.add((Component)assign);
                SideButton guess = new SideButton((Action)((Object)this.guessAddressAction));
                unresolvedButtons.add((Component)guess);
                SideButton applyAllGuesses = new SideButton((Action)((Object)this.applyAllGuessesAction));
                unresolvedButtons.add((Component)applyAllGuesses);
                unresolvedButtons.add(new JSeparator());
                SideButton selectInMap = new SideButton((Action)((Object)this.selectAddressesInMapAction));
                unresolvedButtons.add((Component)selectInMap);
                unresolvedPanel.add((Component)unresolvedButtons, "South");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            JPanel mapPanel = new JPanel(new BorderLayout());
            this.mapViewer = new JMapViewer();
            mapPanel.add((Component)this.mapViewer, "Center");
            mapPanel.setMinimumSize(new Dimension(200, 200));
            this.mapViewer.setVisible(false);
            JSplitPane unresSplitPane = new JSplitPane(0, streetPanel, unresolvedPanel);
            JSplitPane pane = new JSplitPane(1, unresSplitPane, mapPanel);
            this.getContentPane().add((Component)pane, "Center");
        } else {
            this.getContentPane().add((Component)new JLabel(I18n.tr((String)"(No data)")), "Center");
        }
        int i = 0;
        while (i < this.actions.length) {
            this.actions[i].setContainer(addressEditContainer);
            ++i;
        }
        JPanel buttonPanel = new JPanel(new GridLayout(1, 10));
        JButton ok = new JButton(OK_COMMAND, ImageProvider.getIfAvailable(null, (String)"ok"));
        ok.addActionListener(this);
        JButton selectAndClose = new JButton(SELECT_AND_CLOSE);
        selectAndClose.addActionListener(this);
        int i2 = 0;
        while (i2 < 8) {
            buttonPanel.add(new JSeparator());
            ++i2;
        }
        buttonPanel.add(ok);
        this.getContentPane().add((Component)buttonPanel, "South");
    }

    private JLabel createHeaderLabel(String fmtString, int n) {
        JLabel label = new JLabel(String.format(fmtString, n));
        label.setFont(label.getFont().deriveFont(1));
        return label;
    }

    private void updateHeaders() {
        if (this.editContainer != null) {
            this.streetLabel.setText(String.format(STREET_HEADER_FMT, this.editContainer.getNumberOfStreets()));
            this.unresolvedAddressesLabel.setText(String.format(UNRESOLVED_HEADER_FMT, this.editContainer.getNumberOfUnresolvedAddresses()));
        } else {
            this.streetLabel.setText(String.format(STREET_HEADER_FMT, 0));
            this.unresolvedAddressesLabel.setText(String.format(UNRESOLVED_HEADER_FMT, 0));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (OK_COMMAND.equals(e.getActionCommand())) {
            this.setVisible(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        AddressEditSelectionEvent ev = new AddressEditSelectionEvent(e.getSource(), this.streetTable, this.unresolvedTable, this.editContainer);
        AbstractAddressEditAction[] abstractAddressEditActionArray = this.actions;
        int n = this.actions.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractAddressEditAction action = abstractAddressEditActionArray[n2];
            action.updateEnabledState(ev);
            ++n2;
        }
        this.clearMapViewer();
        StreetNode sNode = ev.getSelectedStreet();
        if (sNode != null) {
            for (INodeEntity seg : sNode.getChildren()) {
                Way way = (Way)seg.getOsmObject();
                for (Node node : way.getNodes()) {
                    this.mapViewer.addMapMarker((MapMarker)new MapMarkerDot(Color.GREEN, node.getCoor().lat(), node.getCoor().lon()));
                }
            }
            List<AddressNode> unrAddresses = ev.getSelectedUnresolvedAddresses();
            if (unrAddresses != null) {
                for (AddressNode aNode : unrAddresses) {
                    Node node;
                    node = (Node)aNode.getOsmObject();
                    this.mapViewer.addMapMarker((MapMarker)new MapMarkerDot(Color.ORANGE, node.getCoor().lat(), node.getCoor().lon()));
                }
            }
            this.mapViewer.setDisplayToFitMapMarkers();
            this.mapViewer.setVisible(true);
        }
    }

    private void clearMapViewer() {
        this.mapViewer.setVisible(false);
        this.mapViewer.getMapMarkerList().clear();
        this.mapViewer.getMapRectangleList().clear();
    }

    @Override
    public void containerChanged(AddressEditContainer container) {
        this.updateHeaders();
        int i = 0;
        while (i < this.actions.length) {
            this.actions[i].setContainer(container);
            ++i;
        }
    }

    @Override
    public void entityChanged(INodeEntity entity) {
        this.updateHeaders();
    }

    class IncompleteAddressListener
    implements ListSelectionListener {
        IncompleteAddressListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (AddressEditDialog.this.unresolvedTable.getSelectedRowCount() == 1) {
                String streetOfAddr = (String)AddressEditDialog.this.unresolvedTable.getModel().getValueAt(AddressEditDialog.this.unresolvedTable.getSelectedRow(), 0);
                int maxScore = 0;
                int score = 0;
                int row = -1;
                int i = 0;
                while (i < AddressEditDialog.this.streetTable.getRowCount()) {
                    String streetName = (String)AddressEditDialog.this.streetTable.getModel().getValueAt(i, 1);
                    score = StringUtils.lcsLength(streetOfAddr, streetName);
                    if (score > maxScore) {
                        maxScore = score;
                        row = i;
                    }
                    ++i;
                }
                if (row > 0) {
                    AddressEditDialog.this.streetTable.getSelectionModel().clearSelection();
                    AddressEditDialog.this.streetTable.getSelectionModel().addSelectionInterval(row, row);
                    AddressEditDialog.this.streetTable.scrollRectToVisible(AddressEditDialog.this.streetTable.getCellRect(row, 0, true));
                }
            }
        }
    }

    class IncompleteAddressPresetHandler
    implements PresetListPanel.PresetHandler {
        private List<OsmPrimitive> osmPrimitives;

        public IncompleteAddressPresetHandler(List<OsmPrimitive> osmPrimitives) {
            this.osmPrimitives = osmPrimitives;
        }

        public Collection<OsmPrimitive> getSelection() {
            return this.osmPrimitives;
        }

        public void updateTags(List<Tag> tags) {
        }
    }
}

