/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.addressEdit;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.addressEdit.IAddressEditContainerListener;
import org.openstreetmap.josm.plugins.addressEdit.INodeEntity;
import org.openstreetmap.josm.plugins.addressEdit.TagUtils;
import org.openstreetmap.josm.tools.I18n;

public class NodeEntityBase
implements INodeEntity,
Comparable<INodeEntity> {
    public static final String ANONYMOUS = I18n.tr((String)"No name");
    private static List<IAddressEditContainerListener> listeners = new ArrayList<IAddressEditContainerListener>();
    protected OsmPrimitive osmObject;

    public NodeEntityBase(OsmPrimitive osmObject) {
        this.osmObject = osmObject;
    }

    protected void setOsmObject(OsmPrimitive osmObject) {
        this.osmObject = osmObject;
    }

    public static void addChangedListener(IAddressEditContainerListener listener) {
        listeners.add(listener);
    }

    public static void removeChangedListener(IAddressEditContainerListener listener) {
        listeners.remove(listener);
    }

    protected static void fireEntityChanged(INodeEntity entity) {
        for (IAddressEditContainerListener listener : listeners) {
            listener.entityChanged(entity);
        }
    }

    @Override
    public OsmPrimitive getOsmObject() {
        return this.osmObject;
    }

    @Override
    public List<INodeEntity> getChildren() {
        return null;
    }

    @Override
    public String getName() {
        if (TagUtils.hasNameTag(this.osmObject)) {
            return TagUtils.getNameValue(this.osmObject);
        }
        return "";
    }

    @Override
    public boolean hasName() {
        return TagUtils.hasNameTag(this.osmObject);
    }

    protected void setOSMTag(String tag, String newValue) {
        Node oldNode = (Node)this.osmObject;
        Node newNode = new Node(oldNode);
        newNode.put(tag, newValue);
        Main.main.undoRedo.add((Command)new ChangeCommand((OsmPrimitive)oldNode, (OsmPrimitive)newNode));
        NodeEntityBase.fireEntityChanged(this);
    }

    public String toString() {
        if (this.hasName()) {
            return String.valueOf(this.getClass().getName()) + ": " + this.getName();
        }
        return String.valueOf(this.getClass().getName()) + ": " + ANONYMOUS;
    }

    @Override
    public int compareTo(INodeEntity o) {
        if (o == null || !(o instanceof NodeEntityBase)) {
            return -1;
        }
        return this.getName().compareTo(o.getName());
    }
}

