/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.QuadBuckets;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnconnectedWays
extends Test {
    protected static int UNCONNECTED_WAYS = 1301;
    protected static final String PREFIX = "validator." + UnconnectedWays.class.getSimpleName();
    Set<MyWaySegment> ways;
    Set<Node> endnodes;
    Set<Node> endnodes_highway;
    Set<Node> middlenodes;
    Set<Node> othernodes;
    QuadBuckets<Node> nodecache;
    Area ds_area;
    DataSet ds;
    double mindist;
    double minmiddledist;

    public UnconnectedWays() {
        super(I18n.tr((String)"Unconnected ways."), I18n.tr((String)"This test checks if a way has an endpoint very near to another way."));
    }

    @Override
    public void startTest(ProgressMonitor monitor) {
        super.startTest(monitor);
        this.ways = new HashSet<MyWaySegment>();
        this.endnodes = new HashSet<Node>();
        this.endnodes_highway = new HashSet<Node>();
        this.middlenodes = new HashSet<Node>();
        this.othernodes = new HashSet<Node>();
        this.mindist = Main.pref.getDouble(PREFIX + ".node_way_distance", 10.0) / 6378135.0;
        this.minmiddledist = Main.pref.getDouble(PREFIX + ".way_way_distance", 0.0) / 6378135.0;
        this.ds = Main.main.getCurrentDataSet();
        this.ds_area = this.ds.getDataSourceArea();
    }

    @Override
    public void endTest() {
        HashMap<Node, Way> map = new HashMap<Node, Way>();
        long last = -1L;
        for (int iter = 0; iter < 1; ++iter) {
            last = System.currentTimeMillis();
            long l = -1L;
            int nr = 0;
            Set<MyWaySegment> tmp_ways = this.ways;
            for (MyWaySegment s : tmp_ways) {
                ++nr;
                long now = System.currentTimeMillis();
                if (now - l > 200L) {
                    l = now;
                }
                for (Node en : s.nearbyNodes(this.mindist)) {
                    if (en == null || !s.highway || !this.endnodes_highway.contains(en) || "turning_circle".equals(en.get("highway")) || "bus_stop".equals(en.get("highway")) || OsmUtils.isTrue((String)en.get("noexit")) || en.hasKey("barrier")) continue;
                    map.put(en, s.w);
                }
            }
            last = System.currentTimeMillis();
        }
        for (Map.Entry entry : map.entrySet()) {
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Way end node near other highway"), UNCONNECTED_WAYS, Arrays.asList((OsmPrimitive)entry.getKey(), (OsmPrimitive)entry.getValue())));
        }
        map.clear();
        for (MyWaySegment myWaySegment : this.ways) {
            for (Node en : myWaySegment.nearbyNodes(this.mindist)) {
                if (this.endnodes_highway.contains(en) && !myWaySegment.highway && !myWaySegment.isArea()) {
                    map.put(en, myWaySegment.w);
                    continue;
                }
                if (!this.endnodes.contains(en) || myWaySegment.isArea()) continue;
                map.put(en, myWaySegment.w);
            }
        }
        last = System.currentTimeMillis();
        for (Map.Entry entry : map.entrySet()) {
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Way end node near other way"), UNCONNECTED_WAYS, Arrays.asList((OsmPrimitive)entry.getKey(), (OsmPrimitive)entry.getValue())));
        }
        if (this.minmiddledist > 0.0) {
            map.clear();
            for (MyWaySegment myWaySegment : this.ways) {
                for (Node en : myWaySegment.nearbyNodes(this.minmiddledist)) {
                    if (!this.middlenodes.contains(en)) continue;
                    map.put(en, myWaySegment.w);
                }
            }
            last = System.currentTimeMillis();
            for (Map.Entry entry : map.entrySet()) {
                this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr((String)"Way node near other way"), UNCONNECTED_WAYS, Arrays.asList((OsmPrimitive)entry.getKey(), (OsmPrimitive)entry.getValue())));
            }
            map.clear();
            for (MyWaySegment myWaySegment : this.ways) {
                for (Node en : myWaySegment.nearbyNodes(this.minmiddledist)) {
                    if (!this.othernodes.contains(en)) continue;
                    map.put(en, myWaySegment.w);
                }
            }
            last = System.currentTimeMillis();
            for (Map.Entry entry : map.entrySet()) {
                this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr((String)"Connected way end node near other way"), UNCONNECTED_WAYS, Arrays.asList((OsmPrimitive)entry.getKey(), (OsmPrimitive)entry.getValue())));
            }
        }
        this.ways = null;
        this.endnodes = null;
        super.endTest();
        last = System.currentTimeMillis();
    }

    List<MyWaySegment> getWaySegments(Way w) {
        ArrayList<MyWaySegment> ret = new ArrayList<MyWaySegment>();
        if (!w.isUsable() || w.hasKey("barrier") || "cliff".equals(w.get("natural"))) {
            return ret;
        }
        int size = w.getNodesCount();
        if (size < 2) {
            return ret;
        }
        for (int i = 1; i < size; ++i) {
            if (i < size - 1) {
                this.addNode(w.getNode(i), this.middlenodes);
            }
            MyWaySegment ws = new MyWaySegment(w, w.getNode(i - 1), w.getNode(i));
            if (ws.isBoundary || ws.isAbandoned) continue;
            ret.add(ws);
        }
        return ret;
    }

    @Override
    public void visit(Way w) {
        this.ways.addAll(this.getWaySegments(w));
        Set<Node> set = this.endnodes;
        if (w.hasKey("highway") || w.hasKey("railway")) {
            set = this.endnodes_highway;
        }
        this.addNode(w.firstNode(), set);
        this.addNode(w.lastNode(), set);
    }

    @Override
    public void visit(Node n) {
    }

    private void addNode(Node n, Set<Node> s) {
        boolean m = this.middlenodes.contains(n);
        boolean e = this.endnodes.contains(n);
        boolean eh = this.endnodes_highway.contains(n);
        boolean o = this.othernodes.contains(n);
        if (!(m || e || o || eh)) {
            s.add(n);
        } else if (!o) {
            this.othernodes.add(n);
            if (e) {
                this.endnodes.remove(n);
            } else if (eh) {
                this.endnodes_highway.remove(n);
            } else {
                this.middlenodes.remove(n);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyWaySegment {
        private final Line2D line;
        public final Way w;
        public final boolean isAbandoned;
        public final boolean isBoundary;
        public final boolean highway;
        private final double len;
        private Set<Node> nearbyNodeCache;
        double nearbyNodeCacheDist = -1.0;
        final Node n1;
        final Node n2;

        public MyWaySegment(Way w, Node n1, Node n2) {
            this.w = w;
            String railway = w.get("railway");
            String highway = w.get("highway");
            this.isAbandoned = "abandoned".equals(railway) || OsmUtils.isTrue((String)w.get("disused"));
            this.highway = (highway != null || railway != null) && !this.isAbandoned;
            this.isBoundary = !this.highway && "administrative".equals(w.get("boundary"));
            this.line = new Line2D.Double(n1.getEastNorth().east(), n1.getEastNorth().north(), n2.getEastNorth().east(), n2.getEastNorth().north());
            this.len = this.line.getP1().distance(this.line.getP2());
            this.n1 = n1;
            this.n2 = n2;
        }

        public boolean nearby(Node n, double dist) {
            if (this.w == null) {
                Main.debug((String)"way null");
                return false;
            }
            if (this.w.containsNode(n)) {
                return false;
            }
            EastNorth coord = n.getEastNorth();
            if (coord == null) {
                return false;
            }
            Point2D.Double p = new Point2D.Double(coord.east(), coord.north());
            if (this.line.getP1().distance(p) > this.len + dist) {
                return false;
            }
            if (this.line.getP2().distance(p) > this.len + dist) {
                return false;
            }
            return this.line.ptSegDist(p) < dist;
        }

        public List<LatLon> getBounds(double fudge) {
            double y2;
            double y1;
            double x2;
            double x1 = this.n1.getCoor().lon();
            if (x1 > (x2 = this.n2.getCoor().lon())) {
                double tmpx = x1;
                x1 = x2;
                x2 = tmpx;
            }
            if ((y1 = this.n1.getCoor().lat()) > (y2 = this.n2.getCoor().lat())) {
                double tmpy = y1;
                y1 = y2;
                y2 = tmpy;
            }
            LatLon topLeft = new LatLon(y2 + fudge, x1 - fudge);
            LatLon botRight = new LatLon(y1 - fudge, x2 + fudge);
            ArrayList<LatLon> ret = new ArrayList<LatLon>();
            ret.add(topLeft);
            ret.add(botRight);
            return ret;
        }

        public Collection<Node> nearbyNodes(double dist) {
            if (dist > this.nearbyNodeCacheDist) {
                this.nearbyNodeCache = null;
            }
            if (this.nearbyNodeCache != null) {
                if (this.nearbyNodeCacheDist > dist) {
                    HashSet<Node> trimmed = new HashSet<Node>(this.nearbyNodeCache);
                    for (Node n : new HashSet<Node>(this.nearbyNodeCache)) {
                        if (this.nearby(n, dist)) continue;
                        trimmed.remove(n);
                    }
                    return trimmed;
                }
                return this.nearbyNodeCache;
            }
            this.nearbyNodeCache = null;
            List<LatLon> bounds = this.getBounds(dist);
            List found_nodes = UnconnectedWays.this.ds.searchNodes(new BBox(bounds.get(0), bounds.get(1)));
            if (found_nodes == null) {
                return Collections.emptySet();
            }
            for (Node n : found_nodes) {
                if (!this.nearby(n, dist) || UnconnectedWays.this.ds_area != null && !UnconnectedWays.this.ds_area.contains((Point2D)n.getCoor())) continue;
                if (this.nearbyNodeCache == null) {
                    this.nearbyNodeCache = new HashSet<Node>();
                }
                this.nearbyNodeCache.add(n);
            }
            this.nearbyNodeCacheDist = dist;
            if (this.nearbyNodeCache == null) {
                this.nearbyNodeCache = Collections.emptySet();
            }
            return this.nearbyNodeCache;
        }

        public boolean isArea() {
            return this.w.hasKey("landuse") || this.w.hasKey("leisure") || this.w.hasKey("amenity") || this.w.hasKey("building");
        }
    }
}

