/*
 * Decompiled with CFR 0.152.
 */
package multipoly;

import java.util.HashSet;
import java.util.List;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeometryFunctions {
    public static EastNorth getLineLineIntersection(EastNorth p1, EastNorth p2, EastNorth p3, EastNorth p4) {
        double a1 = p2.getY() - p1.getY();
        double b1 = p1.getX() - p2.getX();
        double c1 = p2.getX() * p1.getY() - p1.getX() * p2.getY();
        double a2 = p4.getY() - p3.getY();
        double b2 = p3.getX() - p4.getX();
        double c2 = p4.getX() * p3.getY() - p3.getX() * p4.getY();
        double det = a1 * b2 - a2 * b1;
        if (det == 0.0) {
            return null;
        }
        return new EastNorth((b1 * c2 - b2 * c1) / det, (a2 * c1 - a1 * c2) / det);
    }

    public static boolean segmentsParralel(EastNorth p1, EastNorth p2, EastNorth p3, EastNorth p4) {
        double a1 = p2.getY() - p1.getY();
        double b1 = p1.getX() - p2.getX();
        double a2 = p4.getY() - p3.getY();
        double b2 = p3.getX() - p4.getX();
        double det = a1 * b2 - a2 * b1;
        return Math.abs(det) < 1.0E-13;
    }

    public static EastNorth closestPointToSegment(EastNorth segmentP1, EastNorth segmentP2, EastNorth point) {
        double pdy;
        double ldx = segmentP2.getX() - segmentP1.getX();
        double ldy = segmentP2.getY() - segmentP1.getY();
        if (ldx == 0.0 && ldy == 0.0) {
            return segmentP1;
        }
        double pdx = point.getX() - segmentP1.getX();
        double offset = (pdx * ldx + (pdy = point.getY() - segmentP1.getY()) * ldy) / (ldx * ldx + ldy * ldy);
        if (offset <= 0.0) {
            return segmentP1;
        }
        if (offset >= 1.0) {
            return segmentP2;
        }
        return new EastNorth(segmentP1.getX() + ldx * offset, segmentP1.getY() + ldy * offset);
    }

    public static boolean angleIsClockwise(EastNorth commonNode, EastNorth firstNode, EastNorth secondNode) {
        double dy1 = firstNode.getY() - commonNode.getY();
        double dy2 = secondNode.getY() - commonNode.getY();
        double dx1 = firstNode.getX() - commonNode.getX();
        double dx2 = secondNode.getX() - commonNode.getX();
        return dy1 * dx2 - dx1 * dy2 > 0.0;
    }

    public static PolygonIntersection polygonIntersection(List<Node> first, List<Node> second) {
        HashSet<Node> firstSet = new HashSet<Node>(first);
        HashSet<Node> secondSet = new HashSet<Node>(second);
        int nodesInsideSecond = 0;
        int nodesOutsideSecond = 0;
        int nodesInsideFirst = 0;
        int nodesOutsideFirst = 0;
        for (Node insideNode : first) {
            if (secondSet.contains(insideNode)) continue;
            if (GeometryFunctions.nodeInsidePolygon(insideNode, second)) {
                ++nodesInsideSecond;
                continue;
            }
            ++nodesOutsideSecond;
        }
        for (Node insideNode : second) {
            if (firstSet.contains(insideNode)) continue;
            if (GeometryFunctions.nodeInsidePolygon(insideNode, first)) {
                ++nodesInsideFirst;
                continue;
            }
            ++nodesOutsideFirst;
        }
        if (nodesInsideFirst == 0) {
            if (nodesInsideSecond == 0) {
                if (nodesOutsideFirst + nodesInsideSecond > 0) {
                    return PolygonIntersection.OUTSIDE;
                }
                return PolygonIntersection.CROSSING;
            }
            return PolygonIntersection.FIRST_INSIDE_SECOND;
        }
        if (nodesInsideSecond == 0) {
            return PolygonIntersection.SECOND_INSIDE_FIRST;
        }
        return PolygonIntersection.CROSSING;
    }

    public static boolean nodeInsidePolygon(Node point, List<Node> polygonNodes) {
        if (polygonNodes.size() < 2) {
            return false;
        }
        boolean inside = false;
        Node oldPoint = polygonNodes.get(polygonNodes.size() - 1);
        for (Node newPoint : polygonNodes) {
            Node p2;
            Node p1;
            if (newPoint.equals((Object)oldPoint)) continue;
            if (newPoint.getEastNorth().getY() > oldPoint.getEastNorth().getY()) {
                p1 = oldPoint;
                p2 = newPoint;
            } else {
                p1 = newPoint;
                p2 = oldPoint;
            }
            if (newPoint.getEastNorth().getY() < point.getEastNorth().getY() == point.getEastNorth().getY() <= oldPoint.getEastNorth().getY() && (point.getEastNorth().getX() - p1.getEastNorth().getX()) * (p2.getEastNorth().getY() - p1.getEastNorth().getY()) < (p2.getEastNorth().getX() - p1.getEastNorth().getX()) * (point.getEastNorth().getY() - p1.getEastNorth().getY())) {
                inside = !inside;
            }
            oldPoint = newPoint;
        }
        return inside;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PolygonIntersection {
        FIRST_INSIDE_SECOND,
        SECOND_INSIDE_FIRST,
        OUTSIDE,
        CROSSING;

    }
}

