/*
 * Decompiled with CFR 0.152.
 */
package pdfimport.pdfbox;

import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.List;
import org.apache.pdfbox.pdfviewer.PageDrawer;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.util.PDFStreamEngine;
import org.openstreetmap.josm.tools.I18n;
import pdfimport.PathOptimizer;
import pdfimport.pdfbox.GraphicsProcessor;

public class PdfBoxParser
extends PDFStreamEngine {
    private final PathOptimizer target;

    public PdfBoxParser(PathOptimizer target) {
        this.target = target;
    }

    public void parse(File file) throws Exception {
        PDDocument document = PDDocument.load(file);
        if (document.isEncrypted()) {
            throw new Exception(I18n.tr((String)"Encrypted documents not supported."));
        }
        List allPages = document.getDocumentCatalog().getAllPages();
        if (allPages.size() != 1) {
            throw new Exception(I18n.tr((String)"The PDF file must have exactly one page."));
        }
        PDPage page = (PDPage)allPages.get(0);
        PDRectangle pageSize = page.findMediaBox();
        Dimension pageDimension = pageSize.createDimension();
        Integer rotationVal = page.getRotation();
        int rotation = 0;
        if (rotationVal != null) {
            rotation = rotationVal;
        }
        GraphicsProcessor p = new GraphicsProcessor(this.target, rotation, pageDimension.getHeight());
        PageDrawer drawer = new PageDrawer();
        drawer.drawPage(p, page, pageDimension);
        this.target.bounds = new Rectangle2D.Double(pageSize.getLowerLeftX(), pageSize.getLowerLeftY(), pageSize.getWidth(), pageSize.getHeight());
    }
}

