/*
 * Decompiled with CFR 0.152.
 */
package pdfimport;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import pdfimport.LayerContents;
import pdfimport.LayerInfo;
import pdfimport.PdfMultiPath;
import pdfimport.PdfPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathOptimizer {
    public Map<Point2D, Point2D> uniquePointMap = new HashMap<Point2D, Point2D>();
    private final Map<LayerInfo, LayerContents> layerMap = new HashMap<LayerInfo, LayerContents>();
    private List<LayerContents> layers = new ArrayList<LayerContents>();
    public Rectangle2D bounds;

    public Point2D getUniquePoint(Point2D point) {
        if (this.uniquePointMap.containsKey(point)) {
            return this.uniquePointMap.get(point);
        }
        this.uniquePointMap.put(point, point);
        return point;
    }

    public void addPath(LayerInfo info, PdfPath path) {
        LayerContents layer = this.getLayer(info);
        layer.paths.add(path);
    }

    public void addMultiPath(LayerInfo info, List<PdfPath> paths) {
        LayerContents layer = this.getLayer(info);
        PdfMultiPath p = new PdfMultiPath(paths);
        layer.multiPaths.add(p);
    }

    private LayerContents getLayer(LayerInfo info) {
        LayerContents layer;
        if (this.layerMap.containsKey(info)) {
            layer = this.layerMap.get(info);
        } else {
            layer = new LayerContents();
            layer.info = info.copy();
            layer.info.nr = this.layers.size();
            this.layerMap.put(layer.info, layer);
            this.layers.add(layer);
        }
        return layer;
    }

    public void optimize() {
        for (LayerContents layer : this.layers) {
            this.concatenataPaths(layer);
        }
        ArrayList<LayerContents> newLayers = new ArrayList<LayerContents>();
        int nr = 0;
        for (LayerContents l : this.layers) {
            List<LayerContents> splitResult = this.splitBySegmentKind(l);
            for (LayerContents ll : splitResult) {
                ll.info.nr = nr++;
                newLayers.add(ll);
            }
        }
        this.layers = newLayers;
        for (LayerContents layer : this.layers) {
            this.finalizeLayer(layer);
        }
    }

    private void finalizeLayer(LayerContents layer) {
        HashSet<Point2D> points = new HashSet<Point2D>();
        layer.points = new ArrayList<Point2D>();
        for (PdfPath pp : layer.paths) {
            pp.layer = layer;
            for (Point2D point : pp.points) {
                if (points.contains(point)) continue;
                layer.points.add(point);
                points.add(point);
            }
        }
        for (PdfMultiPath multipath : layer.multiPaths) {
            multipath.layer = layer;
            for (PdfPath pp : multipath.paths) {
                pp.layer = layer;
                for (Point2D point : pp.points) {
                    if (points.contains(point)) continue;
                    layer.points.add(point);
                    points.add(point);
                }
            }
        }
    }

    private void concatenataPaths(LayerContents layer) {
        HashMap<Point2D, PdfPath> pathEndpoints = new HashMap<Point2D, PdfPath>();
        HashSet<PdfPath> mergedPaths = new HashSet<PdfPath>();
        Iterator<PdfPath> i$ = layer.paths.iterator();
        while (i$.hasNext()) {
            PdfPath pp;
            PdfPath path = pp = i$.next();
            boolean changed = true;
            while (changed && !path.isClosed()) {
                List<Point2D> newNodes;
                PdfPath p1;
                changed = false;
                if (pathEndpoints.containsKey(path.firstPoint())) {
                    p1 = (PdfPath)pathEndpoints.get(path.firstPoint());
                    pathEndpoints.remove(p1.firstPoint());
                    pathEndpoints.remove(p1.lastPoint());
                    newNodes = this.tryMergeNodeLists(path.points, p1.points);
                    if (newNodes == null) {
                        int a = 10;
                        ++a;
                    }
                    path.points = newNodes;
                    mergedPaths.add(p1);
                    changed = true;
                }
                if (!pathEndpoints.containsKey(path.lastPoint())) continue;
                p1 = (PdfPath)pathEndpoints.get(path.lastPoint());
                pathEndpoints.remove(p1.firstPoint());
                pathEndpoints.remove(p1.lastPoint());
                newNodes = this.tryMergeNodeLists(path.points, p1.points);
                path.points = newNodes;
                mergedPaths.add(p1);
                changed = true;
            }
            if (path.isClosed()) continue;
            pathEndpoints.put(path.firstPoint(), path);
            pathEndpoints.put(path.lastPoint(), path);
        }
        ArrayList<PdfPath> resultPaths = new ArrayList<PdfPath>();
        for (PdfPath path : layer.paths) {
            if (mergedPaths.contains(path)) continue;
            resultPaths.add(path);
        }
        layer.paths = resultPaths;
    }

    private List<LayerContents> splitBySegmentKind(LayerContents layer) {
        LayerContents l;
        ArrayList<PdfPath> singleSegmentPaths = new ArrayList<PdfPath>();
        ArrayList<PdfPath> multiSegmentPaths = new ArrayList<PdfPath>();
        ArrayList<PdfPath> closedPaths = new ArrayList<PdfPath>();
        for (PdfPath path : layer.paths) {
            if (path.points.size() <= 3) {
                singleSegmentPaths.add(path);
                continue;
            }
            if (path.isClosed()) {
                closedPaths.add(path);
                continue;
            }
            multiSegmentPaths.add(path);
        }
        ArrayList<LayerContents> layers = new ArrayList<LayerContents>();
        if (multiSegmentPaths.size() > 0) {
            l = new LayerContents();
            l.paths = multiSegmentPaths;
            l.info = layer.info.copy();
            layers.add(l);
        }
        if (singleSegmentPaths.size() > 0) {
            l = new LayerContents();
            l.paths = singleSegmentPaths;
            l.info = layer.info.copy();
            layers.add(l);
        }
        if (closedPaths.size() > 0 || layer.multiPaths.size() > 0) {
            l = new LayerContents();
            l.paths = closedPaths;
            l.info = layer.info.copy();
            l.multiPaths = layer.multiPaths;
            layers.add(l);
        }
        return layers;
    }

    private List<Point2D> tryMergeNodeLists(List<Point2D> nodes1, List<Point2D> nodes2) {
        boolean nodes2Closed;
        boolean nodes1Closed = nodes1.get(0) == nodes1.get(nodes1.size() - 1);
        boolean bl = nodes2Closed = nodes2.get(0) == nodes2.get(nodes2.size() - 1);
        if (nodes1Closed || nodes2Closed) {
            return null;
        }
        if (nodes1.get(nodes1.size() - 1) == nodes2.get(0)) {
            nodes1.remove(nodes1.size() - 1);
            nodes1.addAll(nodes2);
            return nodes1;
        }
        if (nodes1.get(nodes1.size() - 1) == nodes2.get(nodes2.size() - 1)) {
            nodes1.remove(nodes1.size() - 1);
            for (int pos = nodes2.size() - 1; pos >= 0; --pos) {
                nodes1.add(nodes2.get(pos));
            }
            return nodes1;
        }
        if (nodes1.get(0) == nodes2.get(nodes2.size() - 1)) {
            nodes1.remove(0);
            nodes1.addAll(0, nodes2);
            return nodes1;
        }
        if (nodes1.get(0) == nodes2.get(0)) {
            nodes1.remove(0);
            for (int pos = 0; pos < nodes2.size(); ++pos) {
                nodes1.add(0, nodes2.get(pos));
            }
            return nodes1;
        }
        return null;
    }

    public List<LayerContents> getLayers() {
        return this.layers;
    }
}

