/*
 * Decompiled with CFR 0.152.
 */
package pdfimport;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.OsmExporter;
import org.openstreetmap.josm.tools.I18n;
import pdfimport.OsmBuilder;
import pdfimport.PathOptimizer;
import pdfimport.pdfbox.PdfBoxParser;

public class LoadPdfDialog
extends JFrame {
    private String fileName;
    private PathOptimizer data;
    private final OsmBuilder builder = new OsmBuilder();
    private OsmDataLayer layer;
    private JComboBox projectionCombo;
    private JTextField minXField;
    private JTextField minYField;
    private JTextField minEastField;
    private JTextField minNorthField;
    private JButton getMinButton;
    private JButton okButton;
    private JButton cancelButton;
    private JButton getMaxButton;
    private JTextField maxNorthField;
    private JTextField maxEastField;
    private JTextField maxYField;
    private JTextField maxXField;
    private JButton loadFileButton;
    private JButton showButton;
    private JButton saveButton;

    public LoadPdfDialog() {
        this.buildGUI();
        this.addListeners();
        this.removeLayer();
    }

    private void addListeners() {
        this.loadFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoadPdfDialog.this.loadFilePressed();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoadPdfDialog.this.okPressed();
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoadPdfDialog.this.savePressed();
            }
        });
        this.showButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoadPdfDialog.this.showPressed();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoadPdfDialog.this.cancelPressed();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                LoadPdfDialog.this.cancelPressed();
            }
        });
        this.getMinButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoadPdfDialog.this.getMinPressed();
            }
        });
        this.getMaxButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoadPdfDialog.this.getMaxPressed();
            }
        });
    }

    private void buildGUI() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.projectionCombo = new JComboBox();
        this.projectionCombo.addItem("Select projection...");
        for (Projection p : Projection.allProjections) {
            this.projectionCombo.addItem(p);
        }
        this.loadFileButton = new JButton(I18n.tr((String)"Load file..."));
        this.okButton = new JButton(I18n.tr((String)"Place"));
        this.saveButton = new JButton(I18n.tr((String)"Save"));
        this.showButton = new JButton(I18n.tr((String)"Show target"));
        this.cancelButton = new JButton(I18n.tr((String)"Discard"));
        this.minXField = new JTextField("" + this.builder.minX);
        this.minYField = new JTextField("" + this.builder.minY);
        this.minEastField = new JTextField("" + this.builder.minEast);
        this.minNorthField = new JTextField("" + this.builder.minNorth);
        this.getMinButton = new JButton(I18n.tr((String)"Take X and Y from selected node"));
        this.maxXField = new JTextField("" + this.builder.maxX);
        this.maxYField = new JTextField("" + this.builder.maxY);
        this.maxEastField = new JTextField("" + this.builder.maxEast);
        this.maxNorthField = new JTextField("" + this.builder.maxNorth);
        this.getMaxButton = new JButton(I18n.tr((String)"Take X and Y from selected node"));
        JPanel selectFilePanel = new JPanel(new GridBagLayout());
        selectFilePanel.setBorder(BorderFactory.createTitledBorder(I18n.tr((String)"Load file")));
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        selectFilePanel.add((Component)this.loadFileButton, c);
        JPanel projectionPanel = new JPanel(new GridBagLayout());
        projectionPanel.setBorder(BorderFactory.createTitledBorder(I18n.tr((String)"Bind to coordinates")));
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        projectionPanel.add((Component)new JLabel(I18n.tr((String)"Projection:")), c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        projectionPanel.add(this.projectionCombo);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        projectionPanel.add((Component)new JLabel(I18n.tr((String)"Bottom left (min) corner:")), c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        projectionPanel.add((Component)new JLabel(I18n.tr((String)"PDF X and Y")), c);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        projectionPanel.add((Component)new JLabel(I18n.tr((String)"East and North")), c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        projectionPanel.add((Component)this.minXField, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        projectionPanel.add((Component)this.minYField, c);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        projectionPanel.add((Component)this.minEastField, c);
        c.gridx = 1;
        c.gridy = 4;
        c.gridwidth = 1;
        projectionPanel.add((Component)this.minNorthField, c);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 1;
        projectionPanel.add((Component)this.getMinButton, c);
        c.gridx = 0;
        c.gridy = 6;
        c.gridwidth = 2;
        projectionPanel.add((Component)new JLabel(I18n.tr((String)"Top right (max) corner:")), c);
        c.gridx = 0;
        c.gridy = 7;
        c.gridwidth = 1;
        projectionPanel.add((Component)new JLabel(I18n.tr((String)"PDF X and Y")), c);
        c.gridx = 1;
        c.gridy = 7;
        c.gridwidth = 1;
        projectionPanel.add((Component)new JLabel(I18n.tr((String)"East and North")), c);
        c.gridx = 0;
        c.gridy = 8;
        c.gridwidth = 1;
        projectionPanel.add((Component)this.maxXField, c);
        c.gridx = 0;
        c.gridy = 9;
        c.gridwidth = 1;
        projectionPanel.add((Component)this.maxYField, c);
        c.gridx = 1;
        c.gridy = 8;
        c.gridwidth = 1;
        projectionPanel.add((Component)this.maxEastField, c);
        c.gridx = 1;
        c.gridy = 9;
        c.gridwidth = 1;
        projectionPanel.add((Component)this.maxNorthField, c);
        c.gridx = 0;
        c.gridy = 10;
        c.gridwidth = 1;
        projectionPanel.add((Component)this.getMaxButton, c);
        JPanel okCancelPanel = new JPanel(new GridLayout(1, 3));
        okCancelPanel.add(this.cancelButton);
        okCancelPanel.add(this.showButton);
        okCancelPanel.add(this.okButton);
        okCancelPanel.add(this.saveButton);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)okCancelPanel, "South");
        panel.add((Component)projectionPanel, "Center");
        panel.add((Component)selectFilePanel, "North");
        this.setSize(400, 400);
        this.setContentPane(panel);
    }

    private void loadFilePressed() {
        final File fileName = this.chooseFile();
        if (fileName == null) {
            return;
        }
        this.loadFileButton.setEnabled(false);
        this.loadFileButton.setText(I18n.tr((String)"Loading..."));
        this.runAsBackgroundTask(new Runnable(){

            public void run() {
                LoadPdfDialog.this.data = LoadPdfDialog.this.loadPDF(fileName);
            }
        }, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (LoadPdfDialog.this.data != null) {
                    LoadPdfDialog.this.fileName = fileName.getAbsolutePath();
                    LoadPdfDialog.this.makeLayer(I18n.tr((String)"PDF file preview"), false);
                    LoadPdfDialog.this.loadFileButton.setText(I18n.tr((String)"Loaded"));
                    LoadPdfDialog.this.loadFileButton.setEnabled(true);
                }
            }
        });
    }

    private void okPressed() {
        boolean ok = this.loadTransformation();
        if (!ok) {
            return;
        }
        this.makeLayer(I18n.tr((String)"Imported PDF: ") + this.fileName, true);
        this.setVisible(false);
    }

    private void savePressed() {
        boolean ok = this.loadTransformation();
        if (!ok) {
            return;
        }
        File file = this.chooseSaveFile();
        if (file == null) {
            return;
        }
        this.removeLayer();
        this.saveLayer(file);
        this.setVisible(false);
    }

    private void showPressed() {
        boolean ok = this.loadTransformation();
        if (!ok) {
            return;
        }
        Main.map.mapView.zoomTo(this.builder.getWorldBounds(this.data));
        Main.map.repaint();
    }

    private void cancelPressed() {
        this.removeLayer();
        this.setVisible(false);
    }

    private void getMinPressed() {
        EastNorth en = this.getSelectedCoor();
        if (en != null) {
            this.minXField.setText(Double.toString(en.east()));
            this.minYField.setText(Double.toString(en.north()));
        }
    }

    private void getMaxPressed() {
        EastNorth en = this.getSelectedCoor();
        if (en != null) {
            this.maxXField.setText(Double.toString(en.east()));
            this.maxYField.setText(Double.toString(en.north()));
        }
    }

    private EastNorth getSelectedCoor() {
        Collection selected = Main.main.getCurrentDataSet().getSelected();
        if (selected.size() != 1 || !(selected.iterator().next() instanceof Node)) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select exactly one node."));
            return null;
        }
        LatLon ll = ((Node)selected.iterator().next()).getCoor();
        return this.builder.reverseTransform(ll);
    }

    private File chooseFile() {
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        fc.setMultiSelectionEnabled(false);
        fc.setFileFilter(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.getName().endsWith(".pdf");
            }

            public String getDescription() {
                return I18n.tr((String)"PDF files");
            }
        });
        int result = fc.showOpenDialog(Main.parent);
        if (result != 0) {
            return null;
        }
        return fc.getSelectedFile();
    }

    private File chooseSaveFile() {
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(true);
        fc.setMultiSelectionEnabled(false);
        fc.setFileFilter(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.getName().endsWith(".osm");
            }

            public String getDescription() {
                return I18n.tr((String)"OSM files");
            }
        });
        int result = fc.showOpenDialog(Main.parent);
        if (result != 0) {
            return null;
        }
        return fc.getSelectedFile();
    }

    private void runAsBackgroundTask(final Runnable task, final ActionListener after) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Thread t = new Thread(new Runnable(){

            public void run() {
                task.run();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        LoadPdfDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                        after.actionPerformed(null);
                    }
                });
            }
        });
        t.start();
    }

    private PathOptimizer loadPDF(File fileName) {
        PathOptimizer data = new PathOptimizer();
        try {
            PdfBoxParser parser = new PdfBoxParser(data);
            parser.parse(fileName);
        }
        catch (FileNotFoundException e1) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"File not found."));
            return null;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error while parsing: {0}", (Object[])new Object[]{e.getMessage()}));
            return null;
        }
        data.optimize();
        return data;
    }

    private boolean loadTransformation() {
        Object selectedProjection = this.projectionCombo.getSelectedItem();
        if (!(selectedProjection instanceof Projection)) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please set a projection."));
            return false;
        }
        this.builder.projection = (Projection)this.projectionCombo.getSelectedItem();
        try {
            this.builder.setPdfBounds(Double.parseDouble(this.minXField.getText()), Double.parseDouble(this.minYField.getText()), Double.parseDouble(this.maxXField.getText()), Double.parseDouble(this.maxYField.getText()));
            this.builder.setEastNorthBounds(Double.parseDouble(this.minEastField.getText()), Double.parseDouble(this.minNorthField.getText()), Double.parseDouble(this.maxEastField.getText()), Double.parseDouble(this.maxNorthField.getText()));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Could not parse numbers. Please check."));
            return false;
        }
        return true;
    }

    private void makeLayer(String name, boolean isFinal) {
        this.removeLayer();
        if (this.builder == null) {
            return;
        }
        DataSet data = this.builder.build(this.data.getLayers(), isFinal);
        this.layer = new OsmDataLayer(data, name, null);
        this.layer.onPostLoadFromFile();
        Main.main.addLayer((Layer)this.layer);
        Main.map.mapView.zoomTo(this.builder.getWorldBounds(this.data));
        this.okButton.setEnabled(true);
        this.showButton.setEnabled(true);
    }

    private void removeLayer() {
        if (this.layer != null) {
            Main.main.removeLayer((Layer)this.layer);
            this.layer = null;
        }
        this.okButton.setEnabled(false);
        this.showButton.setEnabled(false);
    }

    private void saveLayer(File file) {
        DataSet data = this.builder.build(this.data.getLayers(), true);
        OsmDataLayer layer = new OsmDataLayer(data, file.getName(), file);
        OsmExporter exporter = new OsmExporter();
        try {
            exporter.exportData(file, (Layer)layer);
        }
        catch (IOException e) {
            // empty catch block
        }
    }
}

