/*
 * Decompiled with CFR 0.152.
 */
package multipoly;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import multipoly.GeometryFunctions;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Multipolygon {
    public List<JoinedPolygon> outerWays;
    public List<JoinedPolygon> innerWays;

    public Multipolygon(List<JoinedPolygon> outerWays, List<JoinedPolygon> innerWays) {
        this.outerWays = outerWays;
        this.innerWays = innerWays;
    }

    public Multipolygon() {
        this.outerWays = new ArrayList<JoinedPolygon>(0);
        this.innerWays = new ArrayList<JoinedPolygon>(0);
    }

    public String makeFromWays(Collection<Way> ways) {
        ArrayList<JoinedPolygon> joinedWays = new ArrayList<JoinedPolygon>();
        MultiMap nodesWithConnectedWays = new MultiMap();
        HashSet<Way> usedWays = new HashSet<Way>();
        for (Way w : ways) {
            if (w.getNodesCount() < 2) {
                return I18n.tr((String)"Cannot add a way with only {0} nodes.", (Object[])new Object[]{w.getNodesCount()});
            }
            if (w.isClosed()) {
                JoinedPolygon jw = new JoinedPolygon(w);
                joinedWays.add(jw);
                usedWays.add(w);
                continue;
            }
            nodesWithConnectedWays.put((Object)w.lastNode(), (Object)w);
            nodesWithConnectedWays.put((Object)w.firstNode(), (Object)w);
        }
        for (Way startWay : ways) {
            if (usedWays.contains(startWay)) continue;
            Node startNode = startWay.firstNode();
            ArrayList<Way> collectedWays = new ArrayList<Way>();
            ArrayList<Boolean> collectedWaysReverse = new ArrayList<Boolean>();
            Way curWay = startWay;
            Node prevNode = startNode;
            while (true) {
                boolean curWayReverse = prevNode == curWay.lastNode();
                Node nextNode = curWayReverse ? curWay.firstNode() : curWay.lastNode();
                collectedWays.add(curWay);
                collectedWaysReverse.add(curWayReverse);
                if (nextNode == startNode) break;
                Collection adjacentWays = (Collection)nodesWithConnectedWays.get((Object)nextNode);
                if (adjacentWays.size() != 2) {
                    return I18n.tr((String)"Each node must connect exactly 2 ways");
                }
                Way nextWay = null;
                for (Way way : adjacentWays) {
                    if (way == curWay) continue;
                    nextWay = way;
                }
                curWay = nextWay;
                prevNode = nextNode;
            }
            usedWays.addAll(collectedWays);
            joinedWays.add(new JoinedPolygon(collectedWays, collectedWaysReverse));
        }
        return this.makeFromPolygons(joinedWays);
    }

    private String makeFromPolygons(List<JoinedPolygon> polygons) {
        List<PolygonLevel> list = this.findOuterWaysRecursive(0, polygons);
        if (list == null) {
            return I18n.tr((String)"There is an intersection between ways.");
        }
        this.outerWays = new ArrayList<JoinedPolygon>(0);
        this.innerWays = new ArrayList<JoinedPolygon>(0);
        for (PolygonLevel pol : list) {
            if (pol.level % 2 == 0) {
                this.outerWays.add(pol.outerWay);
                continue;
            }
            this.innerWays.add(pol.outerWay);
        }
        return null;
    }

    private List<PolygonLevel> findOuterWaysRecursive(int level, Collection<JoinedPolygon> boundaryWays) {
        ArrayList<PolygonLevel> result = new ArrayList<PolygonLevel>();
        for (JoinedPolygon outerWay : boundaryWays) {
            boolean outerGood = true;
            ArrayList<JoinedPolygon> innerCandidates = new ArrayList<JoinedPolygon>();
            for (JoinedPolygon innerWay : boundaryWays) {
                if (innerWay == outerWay) continue;
                GeometryFunctions.PolygonIntersection intersection = GeometryFunctions.polygonIntersection(outerWay.nodes, innerWay.nodes);
                if (intersection == GeometryFunctions.PolygonIntersection.FIRST_INSIDE_SECOND) {
                    outerGood = false;
                    break;
                }
                if (intersection == GeometryFunctions.PolygonIntersection.SECOND_INSIDE_FIRST) {
                    innerCandidates.add(innerWay);
                    continue;
                }
                if (intersection != GeometryFunctions.PolygonIntersection.CROSSING) continue;
                return null;
            }
            if (!outerGood) continue;
            PolygonLevel pol = new PolygonLevel(outerWay, level);
            if (innerCandidates.size() > 0) {
                List<PolygonLevel> innerList = this.findOuterWaysRecursive(level + 1, innerCandidates);
                if (innerList == null) {
                    return null;
                }
                result.addAll(innerList);
                for (PolygonLevel pl : innerList) {
                    if (pl.level != level + 1) continue;
                    pol.innerWays.add(pl.outerWay);
                }
            }
            result.add(pol);
        }
        return result;
    }

    static class PolygonLevel {
        public final int level;
        public final JoinedPolygon outerWay;
        public List<JoinedPolygon> innerWays;

        public PolygonLevel(JoinedPolygon _pol, int _level) {
            this.outerWay = _pol;
            this.level = _level;
            this.innerWays = new ArrayList<JoinedPolygon>();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JoinedPolygon {
        public final List<Way> ways;
        public final List<Boolean> reversed;
        public final List<Node> nodes;

        public JoinedPolygon(List<Way> ways, List<Boolean> reversed) {
            this.ways = ways;
            this.reversed = reversed;
            this.nodes = this.getNodes();
        }

        public JoinedPolygon(Way way) {
            this.ways = Collections.singletonList(way);
            this.reversed = Collections.singletonList(Boolean.FALSE);
            this.nodes = this.getNodes();
        }

        private List<Node> getNodes() {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (int waypos = 0; waypos < this.ways.size(); ++waypos) {
                int pos;
                Way way = this.ways.get(waypos);
                boolean reversed = this.reversed.get(waypos);
                if (!reversed) {
                    for (pos = 0; pos < way.getNodesCount() - 1; ++pos) {
                        nodes.add(way.getNode(pos));
                    }
                    continue;
                }
                for (pos = way.getNodesCount() - 1; pos > 0; --pos) {
                    nodes.add(way.getNode(pos));
                }
            }
            return nodes;
        }
    }
}

