/*
 * Decompiled with CFR 0.152.
 */
package multipoly;

import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.JOptionPane;
import multipoly.Multipolygon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipolyAction
extends JosmAction {
    public MultipolyAction() {
        super(I18n.tr((String)"Create multipolygon"), "multipoly_create", I18n.tr((String)"Create multipolygon."), Shortcut.registerShortcut((String)"tools:multipoly", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Create multipolygon")}), (int)77, (int)3, (int)1), true);
    }

    public void actionPerformed(ActionEvent e) {
        if (Main.main.getEditLayer() == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"No data loaded."));
            return;
        }
        Collection selectedWays = Main.main.getCurrentDataSet().getSelectedWays();
        if (selectedWays.size() < 2) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"You must select at least two ways."));
            return;
        }
        Multipolygon polygon = this.analyzeWays(selectedWays);
        if (polygon == null) {
            return;
        }
        Relation relation = this.createRelation(polygon);
        RelationEditor editor = RelationEditor.getEditor((OsmDataLayer)Main.main.getEditLayer(), (Relation)relation, null);
        editor.setVisible(true);
    }

    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }

    private Multipolygon analyzeWays(Collection<Way> selectedWays) {
        Multipolygon pol = new Multipolygon();
        String error = pol.makeFromWays(selectedWays);
        if (error != null) {
            JOptionPane.showMessageDialog(Main.parent, error);
            return null;
        }
        return pol;
    }

    private Relation createRelation(Multipolygon pol) {
        Relation rel = new Relation();
        rel.put("type", "multipolygon");
        for (Multipolygon.JoinedPolygon jway : pol.outerWays) {
            for (Way way : jway.ways) {
                rel.addMember(new RelationMember("outer", (OsmPrimitive)way));
            }
        }
        for (Multipolygon.JoinedPolygon jway : pol.innerWays) {
            for (Way way : jway.ways) {
                rel.addMember(new RelationMember("inner", (OsmPrimitive)way));
            }
        }
        return rel;
    }
}

