/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.plugins.elevation.IElevationProfile;
import org.openstreetmap.josm.plugins.elevation.IGpxWaypointVisitor;
import org.openstreetmap.josm.plugins.elevation.WayPointHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElevationProfileBase
implements IElevationProfile,
IGpxWaypointVisitor {
    public static final int WAYPOINT_START = 0;
    public static final int WAYPOINT_END = 1;
    public static final int WAYPOINT_MIN = 2;
    public static final int WAYPOINT_MAX = 3;
    private String name;
    private int minHeight;
    private int maxHeight;
    private int avrgHeight;
    private double dist;
    private Date start = new Date();
    private Date end = new Date();
    private WayPoint[] importantWayPoints = new WayPoint[4];
    private IElevationProfile parent;
    private int sumEle;
    private List<WayPoint> wayPoints;
    private int numWayPoints;
    private int sliceSize;
    private int gain;
    private int lastEle;
    private static boolean ignoreZeroHeight = true;

    public ElevationProfileBase(String name) {
        this(name, null, null, 0);
    }

    public ElevationProfileBase(String name, IElevationProfile parent, List<WayPoint> wayPoints, int sliceSize) {
        this.name = name;
        this.parent = parent;
        this.sliceSize = sliceSize;
        this.setWayPoints(wayPoints, true);
    }

    public static boolean isIgnoreZeroHeight() {
        return ignoreZeroHeight;
    }

    public static void setIgnoreZeroHeight(boolean ignoreZeroHeight) {
        ElevationProfileBase.ignoreZeroHeight = ignoreZeroHeight;
    }

    @Override
    public void updateElevationData() {
        this.updateValues();
    }

    protected void updateValues() {
        if (this.wayPoints == null) {
            return;
        }
        int n = this.wayPoints.size();
        if (n == 0) {
            return;
        }
        this.start = new Date();
        this.end = new Date(0L);
        this.minHeight = Integer.MAX_VALUE;
        this.maxHeight = Integer.MIN_VALUE;
        this.sumEle = 0;
        this.gain = 0;
        this.lastEle = 0;
        for (WayPoint wayPoint : this.wayPoints) {
            this.visit(wayPoint);
        }
        this.avrgHeight = this.sumEle / n;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected void setMinWayPoint(WayPoint wp) {
        this.importantWayPoints[2] = wp;
        this.minHeight = (int)WayPointHelper.getElevation(wp);
    }

    protected void setMaxWayPoint(WayPoint wp) {
        this.importantWayPoints[3] = wp;
        this.maxHeight = (int)WayPointHelper.getElevation(wp);
    }

    protected void setAvrgHeight(int avrgHeight) {
        this.avrgHeight = avrgHeight;
    }

    protected void setStart(WayPoint wp) {
        this.importantWayPoints[0] = wp;
        this.start = wp.getTime();
    }

    protected void setEnd(WayPoint wp) {
        this.importantWayPoints[1] = wp;
        this.end = wp.getTime();
    }

    public void setParent(IElevationProfile parent) {
        this.parent = parent;
    }

    public void setWayPoints(List<WayPoint> wayPoints, boolean revisit) {
        if (this.wayPoints != wayPoints) {
            this.wayPoints = new ArrayList<WayPoint>(wayPoints);
            int n = this.numWayPoints = wayPoints != null ? wayPoints.size() : 0;
            if (revisit) {
                this.updateValues();
            }
        }
    }

    protected boolean checkIndex(int index) {
        return index >= 0 && index < this.getNumberOfWayPoints();
    }

    @Override
    public int elevationValueAt(int i) {
        if (this.checkIndex(i)) {
            return (int)WayPointHelper.getElevation(this.wayPoints.get(i));
        }
        throw new IndexOutOfBoundsException(String.format("Invalid index: %d, expected 0..%d", i, this.getNumberOfWayPoints()));
    }

    @Override
    public int getSliceSize() {
        return this.sliceSize;
    }

    @Override
    public void setSliceSize(int sliceSize) {
        if (this.sliceSize != sliceSize) {
            this.sliceSize = sliceSize;
        }
    }

    @Override
    public int getAverageHeight() {
        return this.avrgHeight;
    }

    @Override
    public abstract List<IElevationProfile> getChildren();

    @Override
    public Date getEnd() {
        return this.end;
    }

    @Override
    public int getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    public int getMinHeight() {
        return this.minHeight;
    }

    @Override
    public int getHeightDifference() {
        return this.maxHeight - this.minHeight;
    }

    @Override
    public int getGain() {
        return this.gain;
    }

    @Override
    public double getDistance() {
        return this.dist;
    }

    protected void setDistance(double dist) {
        this.dist = dist;
    }

    @Override
    public long getTimeDifference() {
        WayPoint wp1 = this.getStartWayPoint();
        WayPoint wp2 = this.getEndWayPoint();
        if (wp1 != null && wp2 != null) {
            long diff = wp2.getTime().getTime() - wp1.getTime().getTime();
            return diff;
        }
        return 0L;
    }

    @Override
    public IElevationProfile getParent() {
        return this.parent;
    }

    @Override
    public Date getStart() {
        return this.start;
    }

    @Override
    public WayPoint getEndWayPoint() {
        return this.importantWayPoints[1];
    }

    @Override
    public WayPoint getMaxWayPoint() {
        return this.importantWayPoints[3];
    }

    @Override
    public WayPoint getMinWayPoint() {
        return this.importantWayPoints[2];
    }

    @Override
    public WayPoint getStartWayPoint() {
        return this.importantWayPoints[0];
    }

    @Override
    public List<WayPoint> getWayPoints() {
        return this.wayPoints;
    }

    @Override
    public int getNumberOfWayPoints() {
        return this.numWayPoints;
    }

    @Override
    public boolean hasElevationData() {
        return this.minHeight != this.maxHeight;
    }

    @Override
    public void visit(WayPoint wp) {
        if (wp.getTime().after(this.end)) {
            this.setEnd(wp);
        }
        if (wp.getTime().before(this.start)) {
            this.setStart(wp);
        }
        int ele = (int)WayPointHelper.getElevation(wp);
        if (!ElevationProfileBase.isIgnoreZeroHeight() || ele > 0) {
            if (ele > this.maxHeight) {
                this.setMaxWayPoint(wp);
            }
            if (ele < this.minHeight) {
                this.setMinWayPoint(wp);
            }
            if (ele > this.lastEle) {
                this.gain += ele - this.lastEle;
            }
            this.sumEle += ele;
            this.lastEle = ele;
        }
    }
}

