/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.importvec;

import com.kitfox.svg.RenderableElement;
import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGLoader;
import com.kitfox.svg.SVGRoot;
import com.kitfox.svg.ShapeElement;
import java.awt.event.ActionEvent;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.projection.Mercator;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.importvec.ImportDialog;
import org.openstreetmap.josm.plugins.importvec.Settings;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ImportVectorAction
extends JosmAction {
    public ImportVectorAction() {
        super(I18n.tr((String)"Import..."), "open", I18n.tr((String)"Import vector graphics."), Shortcut.registerShortcut((String)"system:import", (String)I18n.tr((String)"File: {0}", (Object[])new Object[]{I18n.tr((String)"Import...")}), (int)73, (int)2), true);
    }

    public static JFileChooser createAndOpenFileChooser(boolean open, boolean multiple, String title) {
        File file;
        int answer;
        String curDir = Main.pref.get("lastDirectory");
        if (curDir.equals("")) {
            curDir = ".";
        }
        JFileChooser fc = new JFileChooser(new File(curDir));
        if (title != null) {
            fc.setDialogTitle(title);
        }
        fc.setFileSelectionMode(2);
        fc.setMultiSelectionEnabled(multiple);
        fc.setAcceptAllFileFilterUsed(false);
        fc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String name = f.getName().toLowerCase();
                return name.endsWith(".svg");
            }

            public String getDescription() {
                return I18n.tr((String)"SVG Drawings (*.svg)");
            }
        });
        int n = answer = open ? fc.showOpenDialog(Main.parent) : fc.showSaveDialog(Main.parent);
        if (answer != 0) {
            return null;
        }
        if (!fc.getCurrentDirectory().getAbsolutePath().equals(curDir)) {
            Main.pref.put("lastDirectory", fc.getCurrentDirectory().getAbsolutePath());
        }
        if (!open && (file = fc.getSelectedFile()) != null && file.exists()) {
            ExtendedDialog dialog = new ExtendedDialog(Main.parent, I18n.tr((String)"Overwrite"), new String[]{I18n.tr((String)"Overwrite"), I18n.tr((String)"Cancel")});
            dialog.setContent(I18n.tr((String)"File exists. Overwrite?"));
            dialog.setButtonIcons(new String[]{"save_as.png", "cancel.png"});
            if (dialog.getValue() != 1) {
                return null;
            }
        }
        return fc;
    }

    public void actionPerformed(ActionEvent arg0) {
        JFileChooser fc = ImportVectorAction.createAndOpenFileChooser(true, true, "Import vector graphics");
        if (fc == null) {
            return;
        }
        ImportDialog dlg = new ImportDialog();
        if (dlg.getValue() != 1) {
            return;
        }
        dlg.saveSettings();
        File[] files = fc.getSelectedFiles();
        Main.worker.submit((Runnable)((Object)new ImportTask(Arrays.asList(files))));
    }

    protected void updateEnabledState() {
        this.setEnabled(this.getCurrentDataSet() != null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImportTask
    extends PleaseWaitRunnable {
        LinkedList<Node> nodes = new LinkedList();
        LinkedList<Way> ways = new LinkedList();
        private List<File> files;
        private boolean cancelled;
        private static final double eqlen = 4.0075004E7;
        Mercator projection = new Mercator();
        EastNorth center;
        double scale;
        Way currentway;
        double lastX;
        double lastY;

        public ImportTask(List<File> files) {
            super(I18n.tr((String)"Importing..."), false);
            this.files = new ArrayList<File>(files);
        }

        protected void cancel() {
            this.cancelled = true;
        }

        protected void finish() {
        }

        private void appendNode(double x, double y) throws IOException {
            if (this.currentway == null) {
                throw new IOException("Shape is started incorectly");
            }
            Node nd = new Node(this.projection.eastNorth2latlon(this.center.add(x * this.scale, -y * this.scale)));
            if (nd.getCoor().isOutSideWorld()) {
                throw new IOException("Shape goes outside the world");
            }
            this.currentway.addNode(nd);
            this.nodes.add(nd);
            this.lastX = x;
            this.lastY = y;
        }

        private void appendNode(Point2D point) throws IOException {
            this.appendNode(point.getX(), point.getY());
        }

        private static double sqr(double x) {
            return x * x;
        }

        private static double cube(double x) {
            return x * x * x;
        }

        private static Point2D interpolate_quad(double ax, double ay, double bx, double by, double cx, double cy, double t) {
            return new Point2D.Double(ImportTask.sqr(1.0 - t) * ax + 2.0 * (1.0 - t) * t * bx + t * t * cx, ImportTask.sqr(1.0 - t) * ay + 2.0 * (1.0 - t) * t * by + t * t * cy);
        }

        private static Point2D interpolate_cubic(double ax, double ay, double bx, double by, double cx, double cy, double dx, double dy, double t) {
            return new Point2D.Double(ImportTask.cube(1.0 - t) * ax + 3.0 * ImportTask.sqr(1.0 - t) * t * bx + 3.0 * (1.0 - t) * t * t * cx + t * t * t * dx, ImportTask.cube(1.0 - t) * ay + 3.0 * ImportTask.sqr(1.0 - t) * t * by + 3.0 * (1.0 - t) * t * t * cy + t * t * t * dy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            LatLon center = Main.proj.eastNorth2latlon(Main.map.mapView.getCenter());
            this.scale = Math.PI * 2 / (Math.cos(Math.toRadians(center.lat())) * 4.0075004E7) * Settings.getScaleNumerator() / Settings.getScaleDivisor();
            this.center = this.projection.latlon2eastNorth(center);
            try {
                for (File f : this.files) {
                    SVGLoader loader = new SVGLoader(new URI("about:blank"), true);
                    XMLReader rdr = XMLReaderFactory.createXMLReader();
                    rdr.setContentHandler(loader);
                    FileInputStream in = new FileInputStream(f);
                    try {
                        rdr.parse(new InputSource(in));
                    }
                    finally {
                        in.close();
                    }
                    SVGDiagram diagram = loader.getLoadedDiagram();
                    SVGRoot shape = diagram.getRoot();
                    Rectangle2D bbox = ((RenderableElement)shape).getBoundingBox();
                    this.center = this.center.add(-bbox.getCenterX() * this.scale, bbox.getCenterY() * this.scale);
                    PathIterator it = ((ShapeElement)shape).getShape().getPathIterator(null);
                    while (!it.isDone()) {
                        double[] coords = new double[6];
                        switch (it.currentSegment(coords)) {
                            case 0: {
                                this.currentway = new Way();
                                this.ways.add(this.currentway);
                                this.appendNode(coords[0], coords[1]);
                                break;
                            }
                            case 1: {
                                this.appendNode(coords[0], coords[1]);
                                break;
                            }
                            case 4: {
                                this.currentway.addNode(this.currentway.firstNode());
                                break;
                            }
                            case 2: {
                                double lastx = this.lastX;
                                double lasty = this.lastY;
                                int i = 1;
                                while ((double)i < Settings.getCurveSteps()) {
                                    this.appendNode(ImportTask.interpolate_quad(lastx, lasty, coords[0], coords[1], coords[2], coords[3], (double)i / Settings.getCurveSteps()));
                                    ++i;
                                }
                                this.appendNode(coords[2], coords[3]);
                                break;
                            }
                            case 3: {
                                double lastx = this.lastX;
                                double lasty = this.lastY;
                                int i = 1;
                                while ((double)i < Settings.getCurveSteps()) {
                                    this.appendNode(ImportTask.interpolate_cubic(lastx, lasty, coords[0], coords[1], coords[2], coords[3], coords[4], coords[5], (double)i / Settings.getCurveSteps()));
                                    ++i;
                                }
                                this.appendNode(coords[4], coords[5]);
                            }
                        }
                        it.next();
                    }
                    if (!this.cancelled) continue;
                    return;
                }
            }
            catch (SAXException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            LinkedList<AddCommand> cmds = new LinkedList<AddCommand>();
            for (Node n : this.nodes) {
                cmds.add(new AddCommand((OsmPrimitive)n));
            }
            for (Way w : this.ways) {
                cmds.add(new AddCommand((OsmPrimitive)w));
            }
            Main.main.undoRedo.add((Command)new SequenceCommand("Import primitives", cmds));
        }
    }
}

