/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.RenderableElement;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;

public abstract class ShapeElement
extends RenderableElement {
    protected float strokeWidthScalar = 1.0f;

    public abstract void render(Graphics2D var1) throws SVGException;

    void pick(Point2D point, boolean boundingBox, List retVec) throws SVGException {
        StyleAttribute styleAttrib = new StyleAttribute();
        if ((boundingBox ? this.getBoundingBox() : this.getShape()).contains(point)) {
            retVec.add(this.getPath(null));
        }
    }

    void pick(Rectangle2D pickArea, AffineTransform ltw, boolean boundingBox, List retVec) throws SVGException {
        StyleAttribute styleAttrib = new StyleAttribute();
        if (ltw.createTransformedShape(boundingBox ? this.getBoundingBox() : this.getShape()).intersects(pickArea)) {
            retVec.add(this.getPath(null));
        }
    }

    protected void renderShape(Graphics2D g, Shape shape) throws SVGException {
        StyleAttribute styleAttrib = new StyleAttribute();
        if (this.getStyle(styleAttrib.setName("visibility")) && !styleAttrib.getStringValue().equals("visible")) {
            return;
        }
        if (this.getStyle(styleAttrib.setName("display")) && styleAttrib.getStringValue().equals("none")) {
            return;
        }
        Color fillPaint = Color.black;
        if (this.getStyle(styleAttrib.setName("fill"))) {
            fillPaint = styleAttrib.getStringValue().equals("none") ? null : styleAttrib.getColorValue();
        }
        float opacity = 1.0f;
        if (this.getStyle(styleAttrib.setName("opacity"))) {
            opacity = styleAttrib.getRatioValue();
        }
        float fillOpacity = opacity;
        if (this.getStyle(styleAttrib.setName("fill-opacity"))) {
            fillOpacity *= styleAttrib.getRatioValue();
        }
        Color strokePaint = null;
        if (this.getStyle(styleAttrib.setName("stroke"))) {
            strokePaint = styleAttrib.getStringValue().equals("none") ? null : styleAttrib.getColorValue();
        }
        float[] strokeDashArray = null;
        if (this.getStyle(styleAttrib.setName("stroke-dasharray")) && (strokeDashArray = styleAttrib.getFloatList()).length == 0) {
            strokeDashArray = null;
        }
        float strokeDashOffset = 0.0f;
        if (this.getStyle(styleAttrib.setName("stroke-dashoffset"))) {
            strokeDashOffset = styleAttrib.getFloatValueWithUnits();
        }
        int strokeLinecap = 0;
        if (this.getStyle(styleAttrib.setName("stroke-linecap"))) {
            String val = styleAttrib.getStringValue();
            if (val.equals("round")) {
                strokeLinecap = 1;
            } else if (val.equals("square")) {
                strokeLinecap = 2;
            }
        }
        int strokeLinejoin = 0;
        if (this.getStyle(styleAttrib.setName("stroke-linejoin"))) {
            String val = styleAttrib.getStringValue();
            if (val.equals("round")) {
                strokeLinejoin = 1;
            } else if (val.equals("bevel")) {
                strokeLinejoin = 2;
            }
        }
        float strokeMiterLimit = 4.0f;
        if (this.getStyle(styleAttrib.setName("stroke-miterlimit"))) {
            strokeMiterLimit = Math.max(styleAttrib.getFloatValueWithUnits(), 1.0f);
        }
        float strokeOpacity = opacity;
        if (this.getStyle(styleAttrib.setName("stroke-opacity"))) {
            strokeOpacity *= styleAttrib.getRatioValue();
        }
        float strokeWidth = 1.0f;
        if (this.getStyle(styleAttrib.setName("stroke-width"))) {
            strokeWidth = styleAttrib.getFloatValueWithUnits();
        }
        strokeWidth *= this.strokeWidthScalar;
        if (fillPaint != null && fillOpacity != 0.0f && !(fillOpacity <= 0.0f)) {
            if (fillOpacity < 1.0f) {
                Composite cachedComposite = g.getComposite();
                g.setComposite(AlphaComposite.getInstance(3, fillOpacity));
                g.setPaint(fillPaint);
                g.fill(shape);
                g.setComposite(cachedComposite);
            } else {
                g.setPaint(fillPaint);
                g.fill(shape);
            }
        }
        if (strokePaint != null && strokeOpacity != 0.0f) {
            BasicStroke stroke = strokeDashArray == null ? new BasicStroke(strokeWidth, strokeLinecap, strokeLinejoin, strokeMiterLimit) : new BasicStroke(strokeWidth, strokeLinecap, strokeLinejoin, strokeMiterLimit, strokeDashArray, strokeDashOffset);
            Shape strokeShape = stroke.createStrokedShape(shape);
            if (!(strokeOpacity <= 0.0f)) {
                if (strokeOpacity < 1.0f) {
                    Composite cachedComposite = g.getComposite();
                    g.setComposite(AlphaComposite.getInstance(3, strokeOpacity));
                    g.setPaint(strokePaint);
                    g.fill(strokeShape);
                    g.setComposite(cachedComposite);
                } else {
                    g.setPaint(strokePaint);
                    g.fill(strokeShape);
                }
            }
        }
    }

    public abstract Shape getShape();

    protected Rectangle2D includeStrokeInBounds(Rectangle2D rect) throws SVGException {
        StyleAttribute styleAttrib = new StyleAttribute();
        if (!this.getStyle(styleAttrib.setName("stroke"))) {
            return rect;
        }
        double strokeWidth = 1.0;
        if (this.getStyle(styleAttrib.setName("stroke-width"))) {
            strokeWidth = styleAttrib.getDoubleValue();
        }
        rect.setRect(rect.getX() - strokeWidth / 2.0, rect.getY() - strokeWidth / 2.0, rect.getWidth() + strokeWidth, rect.getHeight() + strokeWidth);
        return rect;
    }
}

