/**
 * This program is free software: you can redistribute it and/or modify it under 
 * the terms of the GNU General Public License as published by the 
 * Free Software Foundation, either version 3 of the License, or 
 * (at your option) any later version. 
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 * See the GNU General Public License for more details. 
 * 
 * You should have received a copy of the GNU General Public License along with this program. 
 * If not, see <http://www.gnu.org/licenses/>.
 */

package org.openstreetmap.josm.plugins.elevation;

/**
 * Holds the geoid correction data. 
 * @author Oliver 
 */
public class GeoidData {
	public static final int LAT_GRID_SIZE = 180;
	public static final int LON_GRID_SIZE = 360;
	
	private static final int LAT_GRID_SIZE_2 = LAT_GRID_SIZE / 2;
	private static final int LON_GRID_SIZE_2 = LON_GRID_SIZE / 2;
	private static byte geoidSimple[][];
	
	static {
		init();
	}
	
	/**
	 * Gets the GEOID correction value. Uses the 'north-east positive' convention. The data were 
	 * obtained from EGM 2008 GIS data {@link http://earth-info.nga.mil/GandG/wgs84/gravitymod/egm2008/egm08_gis.html}
	 * and have been simplified to reduce the data amount. While the GIS data have a 720 x 1440 grid (0.25 degree squares)
	 * we use a smoothed LAT_GRID_SIZE x LON_GRID_SIZE grid with integral values.
	 * @param lat The latitude (-89..89). North is positive, south is negative.
	 * @param lon The latitude (-LAT_GRID_SIZE..179). West is negative, east is positive.
	 * @returns The geoid correction height in meters.
	 */
	public static byte getGeoid(int lat, int lon) {
		if (Math.abs(lat) >= LAT_GRID_SIZE_2) return (byte)0;
		if (Math.abs(lon) >= LON_GRID_SIZE_2) return (byte)0;
		
		if (lat < 0) {
			if (lon < 0) {
				return geoidSimple[LAT_GRID_SIZE+lat][LON_GRID_SIZE+lon];
			} else {
				return geoidSimple[LAT_GRID_SIZE+lat][lon];
			}
		} else {
			if (lon < 0) {
				return geoidSimple[lat][LON_GRID_SIZE+lon];
			} else {
				return geoidSimple[lat][lon];
			}
		}
	}
	
	/**
	 * We cannot do a static init since Java compiler would complain that the constant table size 
	 * of 64K would be exceeded.
	 */
	private static void init() {		
		geoidSimple = new byte[LAT_GRID_SIZE][LON_GRID_SIZE];
		
		for(int i = 0; i < LAT_GRID_SIZE; i++) {
			geoidSimple[i] = new byte[LON_GRID_SIZE];
		}
		
		init0();
		init1();
		init2();
		init3();
		init4();
		init5();
		init6();
		init7();
		init8();
		init9();
		init10();
		init11();
		init12();
		init13();
		init14();
		init15();
		init16();
		init17();
		init18();
		init19();
		init20();
		init21();
		init22();
		init23();
		init24();
		init25();
		init26();
		init27();
		init28();
		init29();
		init30();
		init31();
		init32();
		init33();
		init34();
		init35();
		init36();
		init37();
		init38();
		init39();
		init40();
		init41();
		init42();
		init43();
		init44();
		init45();
		init46();
		init47();
		init48();
		init49();
		init50();
		init51();
		init52();
		init53();
		init54();
		init55();
		init56();
		init57();
		init58();
		init59();
		init60();
		init61();
		init62();
		init63();
		init64();
		init65();
		init66();
		init67();
		init68();
		init69();
		init70();
		init71();
		init72();
		init73();
		init74();
		init75();
		init76();
		init77();
		init78();
		init79();
		init80();
		init81();
		init82();
		init83();
		init84();
		init85();
		init86();
		init87();
		init88();
		init89();
		init90();
		init91();
		init92();
		init93();
		init94();
		init95();
		init96();
		init97();
		init98();
		init99();
		init100();
		init101();
		init102();
		init103();
		init104();
		init105();
		init106();
		init107();
		init108();
		init109();
		init110();
		init111();
		init112();
		init113();
		init114();
		init115();
		init116();
		init117();
		init118();
		init119();
		init120();
		init121();
		init122();
		init123();
		init124();
		init125();
		init126();
		init127();
		init128();
		init129();
		init130();
		init131();
		init132();
		init133();
		init134();
		init135();
		init136();
		init137();
		init138();
		init139();
		init140();
		init141();
		init142();
		init143();
		init144();
		init145();
		init146();
		init147();
		init148();
		init149();
		init150();
		init151();
		init152();
		init153();
		init154();
		init155();
		init156();
		init157();
		init158();
		init159();
		init160();
		init161();
		init162();
		init163();
		init164();
		init165();
		init166();
		init167();
		init168();
		init169();
		init170();
		init171();
		init172();
		init173();
		init174();
		init175();
		init176();
		init177();
		init178();
		init179();
	}

	/** Row 0*/
	private static void init0() {
	geoidSimple[0][0] = (byte)14;
	geoidSimple[0][1] = (byte)14;
	geoidSimple[0][2] = (byte)14;
	geoidSimple[0][3] = (byte)14;
	geoidSimple[0][4] = (byte)14;
	geoidSimple[0][5] = (byte)14;
	geoidSimple[0][6] = (byte)14;
	geoidSimple[0][7] = (byte)14;
	geoidSimple[0][8] = (byte)14;
	geoidSimple[0][9] = (byte)14;
	geoidSimple[0][10] = (byte)14;
	geoidSimple[0][11] = (byte)14;
	geoidSimple[0][12] = (byte)14;
	geoidSimple[0][13] = (byte)14;
	geoidSimple[0][14] = (byte)14;
	geoidSimple[0][15] = (byte)14;
	geoidSimple[0][16] = (byte)14;
	geoidSimple[0][17] = (byte)14;
	geoidSimple[0][18] = (byte)14;
	geoidSimple[0][19] = (byte)14;
	geoidSimple[0][20] = (byte)14;
	geoidSimple[0][21] = (byte)14;
	geoidSimple[0][22] = (byte)14;
	geoidSimple[0][23] = (byte)14;
	geoidSimple[0][24] = (byte)14;
	geoidSimple[0][25] = (byte)14;
	geoidSimple[0][26] = (byte)14;
	geoidSimple[0][27] = (byte)14;
	geoidSimple[0][28] = (byte)14;
	geoidSimple[0][29] = (byte)13;
	geoidSimple[0][30] = (byte)13;
	geoidSimple[0][31] = (byte)13;
	geoidSimple[0][32] = (byte)13;
	geoidSimple[0][33] = (byte)13;
	geoidSimple[0][34] = (byte)13;
	geoidSimple[0][35] = (byte)13;
	geoidSimple[0][36] = (byte)13;
	geoidSimple[0][37] = (byte)13;
	geoidSimple[0][38] = (byte)13;
	geoidSimple[0][39] = (byte)13;
	geoidSimple[0][40] = (byte)13;
	geoidSimple[0][41] = (byte)13;
	geoidSimple[0][42] = (byte)13;
	geoidSimple[0][43] = (byte)13;
	geoidSimple[0][44] = (byte)13;
	geoidSimple[0][45] = (byte)13;
	geoidSimple[0][46] = (byte)13;
	geoidSimple[0][47] = (byte)13;
	geoidSimple[0][48] = (byte)13;
	geoidSimple[0][49] = (byte)13;
	geoidSimple[0][50] = (byte)13;
	geoidSimple[0][51] = (byte)13;
	geoidSimple[0][52] = (byte)13;
	geoidSimple[0][53] = (byte)13;
	geoidSimple[0][54] = (byte)13;
	geoidSimple[0][55] = (byte)13;
	geoidSimple[0][56] = (byte)13;
	geoidSimple[0][57] = (byte)13;
	geoidSimple[0][58] = (byte)13;
	geoidSimple[0][59] = (byte)13;
	geoidSimple[0][60] = (byte)13;
	geoidSimple[0][61] = (byte)13;
	geoidSimple[0][62] = (byte)13;
	geoidSimple[0][63] = (byte)13;
	geoidSimple[0][64] = (byte)13;
	geoidSimple[0][65] = (byte)13;
	geoidSimple[0][66] = (byte)13;
	geoidSimple[0][67] = (byte)13;
	geoidSimple[0][68] = (byte)13;
	geoidSimple[0][69] = (byte)13;
	geoidSimple[0][70] = (byte)13;
	geoidSimple[0][71] = (byte)13;
	geoidSimple[0][72] = (byte)13;
	geoidSimple[0][73] = (byte)13;
	geoidSimple[0][74] = (byte)13;
	geoidSimple[0][75] = (byte)13;
	geoidSimple[0][76] = (byte)13;
	geoidSimple[0][77] = (byte)13;
	geoidSimple[0][78] = (byte)13;
	geoidSimple[0][79] = (byte)13;
	geoidSimple[0][80] = (byte)13;
	geoidSimple[0][81] = (byte)13;
	geoidSimple[0][82] = (byte)13;
	geoidSimple[0][83] = (byte)13;
	geoidSimple[0][84] = (byte)13;
	geoidSimple[0][85] = (byte)13;
	geoidSimple[0][86] = (byte)13;
	geoidSimple[0][87] = (byte)13;
	geoidSimple[0][88] = (byte)13;
	geoidSimple[0][89] = (byte)13;
	geoidSimple[0][90] = (byte)13;
	geoidSimple[0][91] = (byte)13;
	geoidSimple[0][92] = (byte)13;
	geoidSimple[0][93] = (byte)13;
	geoidSimple[0][94] = (byte)13;
	geoidSimple[0][95] = (byte)13;
	geoidSimple[0][96] = (byte)13;
	geoidSimple[0][97] = (byte)13;
	geoidSimple[0][98] = (byte)13;
	geoidSimple[0][99] = (byte)13;
	geoidSimple[0][100] = (byte)13;
	geoidSimple[0][101] = (byte)13;
	geoidSimple[0][102] = (byte)13;
	geoidSimple[0][103] = (byte)13;
	geoidSimple[0][104] = (byte)13;
	geoidSimple[0][105] = (byte)13;
	geoidSimple[0][106] = (byte)13;
	geoidSimple[0][107] = (byte)13;
	geoidSimple[0][108] = (byte)13;
	geoidSimple[0][109] = (byte)13;
	geoidSimple[0][110] = (byte)13;
	geoidSimple[0][111] = (byte)13;
	geoidSimple[0][112] = (byte)13;
	geoidSimple[0][113] = (byte)13;
	geoidSimple[0][114] = (byte)13;
	geoidSimple[0][115] = (byte)13;
	geoidSimple[0][116] = (byte)13;
	geoidSimple[0][117] = (byte)13;
	geoidSimple[0][118] = (byte)13;
	geoidSimple[0][119] = (byte)13;
	geoidSimple[0][120] = (byte)13;
	geoidSimple[0][121] = (byte)13;
	geoidSimple[0][122] = (byte)13;
	geoidSimple[0][123] = (byte)13;
	geoidSimple[0][124] = (byte)13;
	geoidSimple[0][125] = (byte)13;
	geoidSimple[0][126] = (byte)13;
	geoidSimple[0][127] = (byte)13;
	geoidSimple[0][128] = (byte)13;
	geoidSimple[0][129] = (byte)13;
	geoidSimple[0][130] = (byte)13;
	geoidSimple[0][131] = (byte)13;
	geoidSimple[0][132] = (byte)13;
	geoidSimple[0][133] = (byte)13;
	geoidSimple[0][134] = (byte)13;
	geoidSimple[0][135] = (byte)13;
	geoidSimple[0][136] = (byte)13;
	geoidSimple[0][137] = (byte)13;
	geoidSimple[0][138] = (byte)13;
	geoidSimple[0][139] = (byte)13;
	geoidSimple[0][140] = (byte)13;
	geoidSimple[0][141] = (byte)13;
	geoidSimple[0][142] = (byte)13;
	geoidSimple[0][143] = (byte)13;
	geoidSimple[0][144] = (byte)13;
	geoidSimple[0][145] = (byte)13;
	geoidSimple[0][146] = (byte)13;
	geoidSimple[0][147] = (byte)13;
	geoidSimple[0][148] = (byte)13;
	geoidSimple[0][149] = (byte)13;
	geoidSimple[0][150] = (byte)13;
	geoidSimple[0][151] = (byte)13;
	geoidSimple[0][152] = (byte)13;
	geoidSimple[0][153] = (byte)13;
	geoidSimple[0][154] = (byte)13;
	geoidSimple[0][155] = (byte)13;
	geoidSimple[0][156] = (byte)13;
	geoidSimple[0][157] = (byte)13;
	geoidSimple[0][158] = (byte)13;
	geoidSimple[0][159] = (byte)13;
	geoidSimple[0][160] = (byte)13;
	geoidSimple[0][161] = (byte)13;
	geoidSimple[0][162] = (byte)13;
	geoidSimple[0][163] = (byte)13;
	geoidSimple[0][164] = (byte)13;
	geoidSimple[0][165] = (byte)13;
	geoidSimple[0][166] = (byte)13;
	geoidSimple[0][167] = (byte)13;
	geoidSimple[0][168] = (byte)13;
	geoidSimple[0][169] = (byte)13;
	geoidSimple[0][170] = (byte)13;
	geoidSimple[0][171] = (byte)13;
	geoidSimple[0][172] = (byte)13;
	geoidSimple[0][173] = (byte)13;
	geoidSimple[0][174] = (byte)13;
	geoidSimple[0][175] = (byte)13;
	geoidSimple[0][176] = (byte)13;
	geoidSimple[0][177] = (byte)13;
	geoidSimple[0][178] = (byte)13;
	geoidSimple[0][179] = (byte)13;
	geoidSimple[0][LAT_GRID_SIZE] = (byte)13;
	geoidSimple[0][181] = (byte)13;
	geoidSimple[0][182] = (byte)13;
	geoidSimple[0][183] = (byte)13;
	geoidSimple[0][184] = (byte)13;
	geoidSimple[0][185] = (byte)13;
	geoidSimple[0][186] = (byte)13;
	geoidSimple[0][187] = (byte)13;
	geoidSimple[0][188] = (byte)13;
	geoidSimple[0][189] = (byte)13;
	geoidSimple[0][190] = (byte)13;
	geoidSimple[0][191] = (byte)13;
	geoidSimple[0][192] = (byte)13;
	geoidSimple[0][193] = (byte)13;
	geoidSimple[0][194] = (byte)13;
	geoidSimple[0][195] = (byte)13;
	geoidSimple[0][196] = (byte)13;
	geoidSimple[0][197] = (byte)13;
	geoidSimple[0][198] = (byte)13;
	geoidSimple[0][199] = (byte)13;
	geoidSimple[0][200] = (byte)13;
	geoidSimple[0][201] = (byte)13;
	geoidSimple[0][202] = (byte)13;
	geoidSimple[0][203] = (byte)13;
	geoidSimple[0][204] = (byte)13;
	geoidSimple[0][205] = (byte)13;
	geoidSimple[0][206] = (byte)13;
	geoidSimple[0][207] = (byte)13;
	geoidSimple[0][208] = (byte)13;
	geoidSimple[0][209] = (byte)13;
	geoidSimple[0][210] = (byte)13;
	geoidSimple[0][211] = (byte)13;
	geoidSimple[0][212] = (byte)13;
	geoidSimple[0][213] = (byte)13;
	geoidSimple[0][214] = (byte)13;
	geoidSimple[0][215] = (byte)13;
	geoidSimple[0][216] = (byte)13;
	geoidSimple[0][217] = (byte)13;
	geoidSimple[0][218] = (byte)13;
	geoidSimple[0][219] = (byte)13;
	geoidSimple[0][220] = (byte)13;
	geoidSimple[0][221] = (byte)13;
	geoidSimple[0][222] = (byte)13;
	geoidSimple[0][223] = (byte)13;
	geoidSimple[0][224] = (byte)13;
	geoidSimple[0][225] = (byte)13;
	geoidSimple[0][226] = (byte)13;
	geoidSimple[0][227] = (byte)13;
	geoidSimple[0][228] = (byte)13;
	geoidSimple[0][229] = (byte)13;
	geoidSimple[0][230] = (byte)13;
	geoidSimple[0][231] = (byte)13;
	geoidSimple[0][232] = (byte)13;
	geoidSimple[0][233] = (byte)13;
	geoidSimple[0][234] = (byte)13;
	geoidSimple[0][235] = (byte)13;
	geoidSimple[0][236] = (byte)13;
	geoidSimple[0][237] = (byte)13;
	geoidSimple[0][238] = (byte)13;
	geoidSimple[0][239] = (byte)13;
	geoidSimple[0][240] = (byte)13;
	geoidSimple[0][241] = (byte)13;
	geoidSimple[0][242] = (byte)13;
	geoidSimple[0][243] = (byte)14;
	geoidSimple[0][244] = (byte)14;
	geoidSimple[0][245] = (byte)14;
	geoidSimple[0][246] = (byte)14;
	geoidSimple[0][247] = (byte)14;
	geoidSimple[0][248] = (byte)14;
	geoidSimple[0][249] = (byte)14;
	geoidSimple[0][250] = (byte)14;
	geoidSimple[0][251] = (byte)14;
	geoidSimple[0][252] = (byte)14;
	geoidSimple[0][253] = (byte)14;
	geoidSimple[0][254] = (byte)14;
	geoidSimple[0][255] = (byte)14;
	geoidSimple[0][256] = (byte)14;
	geoidSimple[0][257] = (byte)14;
	geoidSimple[0][258] = (byte)14;
	geoidSimple[0][259] = (byte)14;
	geoidSimple[0][260] = (byte)14;
	geoidSimple[0][261] = (byte)14;
	geoidSimple[0][262] = (byte)14;
	geoidSimple[0][263] = (byte)14;
	geoidSimple[0][264] = (byte)14;
	geoidSimple[0][265] = (byte)14;
	geoidSimple[0][266] = (byte)14;
	geoidSimple[0][267] = (byte)14;
	geoidSimple[0][268] = (byte)14;
	geoidSimple[0][269] = (byte)14;
	geoidSimple[0][270] = (byte)14;
	geoidSimple[0][271] = (byte)14;
	geoidSimple[0][272] = (byte)14;
	geoidSimple[0][273] = (byte)14;
	geoidSimple[0][274] = (byte)14;
	geoidSimple[0][275] = (byte)14;
	geoidSimple[0][276] = (byte)14;
	geoidSimple[0][277] = (byte)14;
	geoidSimple[0][278] = (byte)14;
	geoidSimple[0][279] = (byte)14;
	geoidSimple[0][280] = (byte)14;
	geoidSimple[0][281] = (byte)14;
	geoidSimple[0][282] = (byte)14;
	geoidSimple[0][283] = (byte)14;
	geoidSimple[0][284] = (byte)14;
	geoidSimple[0][285] = (byte)14;
	geoidSimple[0][286] = (byte)14;
	geoidSimple[0][287] = (byte)14;
	geoidSimple[0][288] = (byte)14;
	geoidSimple[0][289] = (byte)14;
	geoidSimple[0][290] = (byte)14;
	geoidSimple[0][291] = (byte)14;
	geoidSimple[0][292] = (byte)14;
	geoidSimple[0][293] = (byte)14;
	geoidSimple[0][294] = (byte)14;
	geoidSimple[0][295] = (byte)14;
	geoidSimple[0][296] = (byte)14;
	geoidSimple[0][297] = (byte)14;
	geoidSimple[0][298] = (byte)14;
	geoidSimple[0][299] = (byte)14;
	geoidSimple[0][300] = (byte)14;
	geoidSimple[0][301] = (byte)14;
	geoidSimple[0][302] = (byte)14;
	geoidSimple[0][303] = (byte)14;
	geoidSimple[0][304] = (byte)14;
	geoidSimple[0][305] = (byte)14;
	geoidSimple[0][306] = (byte)14;
	geoidSimple[0][307] = (byte)14;
	geoidSimple[0][308] = (byte)14;
	geoidSimple[0][309] = (byte)14;
	geoidSimple[0][310] = (byte)14;
	geoidSimple[0][311] = (byte)14;
	geoidSimple[0][312] = (byte)14;
	geoidSimple[0][313] = (byte)14;
	geoidSimple[0][314] = (byte)14;
	geoidSimple[0][315] = (byte)14;
	geoidSimple[0][316] = (byte)14;
	geoidSimple[0][317] = (byte)14;
	geoidSimple[0][318] = (byte)14;
	geoidSimple[0][319] = (byte)14;
	geoidSimple[0][320] = (byte)14;
	geoidSimple[0][321] = (byte)14;
	geoidSimple[0][322] = (byte)14;
	geoidSimple[0][323] = (byte)14;
	geoidSimple[0][324] = (byte)14;
	geoidSimple[0][325] = (byte)14;
	geoidSimple[0][326] = (byte)14;
	geoidSimple[0][327] = (byte)14;
	geoidSimple[0][328] = (byte)14;
	geoidSimple[0][329] = (byte)14;
	geoidSimple[0][330] = (byte)14;
	geoidSimple[0][331] = (byte)14;
	geoidSimple[0][332] = (byte)14;
	geoidSimple[0][333] = (byte)14;
	geoidSimple[0][334] = (byte)14;
	geoidSimple[0][335] = (byte)14;
	geoidSimple[0][336] = (byte)14;
	geoidSimple[0][337] = (byte)14;
	geoidSimple[0][338] = (byte)14;
	geoidSimple[0][339] = (byte)14;
	geoidSimple[0][340] = (byte)14;
	geoidSimple[0][341] = (byte)14;
	geoidSimple[0][342] = (byte)14;
	geoidSimple[0][343] = (byte)14;
	geoidSimple[0][344] = (byte)14;
	geoidSimple[0][345] = (byte)14;
	geoidSimple[0][346] = (byte)14;
	geoidSimple[0][347] = (byte)14;
	geoidSimple[0][348] = (byte)14;
	geoidSimple[0][349] = (byte)14;
	geoidSimple[0][350] = (byte)14;
	geoidSimple[0][351] = (byte)14;
	geoidSimple[0][352] = (byte)14;
	geoidSimple[0][353] = (byte)14;
	geoidSimple[0][354] = (byte)14;
	geoidSimple[0][355] = (byte)14;
	geoidSimple[0][356] = (byte)14;
	geoidSimple[0][357] = (byte)14;
	geoidSimple[0][358] = (byte)14;
	geoidSimple[0][359] = (byte)14;
	}
		/** Row 1*/
	private static void init1() {
	geoidSimple[1][0] = (byte)16;
	geoidSimple[1][1] = (byte)16;
	geoidSimple[1][2] = (byte)16;
	geoidSimple[1][3] = (byte)16;
	geoidSimple[1][4] = (byte)16;
	geoidSimple[1][5] = (byte)16;
	geoidSimple[1][6] = (byte)16;
	geoidSimple[1][7] = (byte)16;
	geoidSimple[1][8] = (byte)16;
	geoidSimple[1][9] = (byte)16;
	geoidSimple[1][10] = (byte)16;
	geoidSimple[1][11] = (byte)16;
	geoidSimple[1][12] = (byte)16;
	geoidSimple[1][13] = (byte)16;
	geoidSimple[1][14] = (byte)16;
	geoidSimple[1][15] = (byte)16;
	geoidSimple[1][16] = (byte)16;
	geoidSimple[1][17] = (byte)16;
	geoidSimple[1][18] = (byte)16;
	geoidSimple[1][19] = (byte)16;
	geoidSimple[1][20] = (byte)15;
	geoidSimple[1][21] = (byte)15;
	geoidSimple[1][22] = (byte)15;
	geoidSimple[1][23] = (byte)15;
	geoidSimple[1][24] = (byte)15;
	geoidSimple[1][25] = (byte)15;
	geoidSimple[1][26] = (byte)15;
	geoidSimple[1][27] = (byte)15;
	geoidSimple[1][28] = (byte)15;
	geoidSimple[1][29] = (byte)15;
	geoidSimple[1][30] = (byte)15;
	geoidSimple[1][31] = (byte)15;
	geoidSimple[1][32] = (byte)15;
	geoidSimple[1][33] = (byte)15;
	geoidSimple[1][34] = (byte)15;
	geoidSimple[1][35] = (byte)15;
	geoidSimple[1][36] = (byte)15;
	geoidSimple[1][37] = (byte)15;
	geoidSimple[1][38] = (byte)15;
	geoidSimple[1][39] = (byte)15;
	geoidSimple[1][40] = (byte)15;
	geoidSimple[1][41] = (byte)15;
	geoidSimple[1][42] = (byte)15;
	geoidSimple[1][43] = (byte)15;
	geoidSimple[1][44] = (byte)15;
	geoidSimple[1][45] = (byte)15;
	geoidSimple[1][46] = (byte)15;
	geoidSimple[1][47] = (byte)15;
	geoidSimple[1][48] = (byte)15;
	geoidSimple[1][49] = (byte)15;
	geoidSimple[1][50] = (byte)15;
	geoidSimple[1][51] = (byte)15;
	geoidSimple[1][52] = (byte)14;
	geoidSimple[1][53] = (byte)14;
	geoidSimple[1][54] = (byte)14;
	geoidSimple[1][55] = (byte)14;
	geoidSimple[1][56] = (byte)14;
	geoidSimple[1][57] = (byte)14;
	geoidSimple[1][58] = (byte)14;
	geoidSimple[1][59] = (byte)14;
	geoidSimple[1][60] = (byte)14;
	geoidSimple[1][61] = (byte)14;
	geoidSimple[1][62] = (byte)14;
	geoidSimple[1][63] = (byte)14;
	geoidSimple[1][64] = (byte)14;
	geoidSimple[1][65] = (byte)14;
	geoidSimple[1][66] = (byte)14;
	geoidSimple[1][67] = (byte)14;
	geoidSimple[1][68] = (byte)14;
	geoidSimple[1][69] = (byte)14;
	geoidSimple[1][70] = (byte)14;
	geoidSimple[1][71] = (byte)14;
	geoidSimple[1][72] = (byte)14;
	geoidSimple[1][73] = (byte)14;
	geoidSimple[1][74] = (byte)14;
	geoidSimple[1][75] = (byte)14;
	geoidSimple[1][76] = (byte)14;
	geoidSimple[1][77] = (byte)13;
	geoidSimple[1][78] = (byte)13;
	geoidSimple[1][79] = (byte)13;
	geoidSimple[1][80] = (byte)13;
	geoidSimple[1][81] = (byte)13;
	geoidSimple[1][82] = (byte)13;
	geoidSimple[1][83] = (byte)13;
	geoidSimple[1][84] = (byte)13;
	geoidSimple[1][85] = (byte)13;
	geoidSimple[1][86] = (byte)13;
	geoidSimple[1][87] = (byte)13;
	geoidSimple[1][88] = (byte)13;
	geoidSimple[1][89] = (byte)13;
	geoidSimple[1][90] = (byte)13;
	geoidSimple[1][91] = (byte)13;
	geoidSimple[1][92] = (byte)13;
	geoidSimple[1][93] = (byte)13;
	geoidSimple[1][94] = (byte)13;
	geoidSimple[1][95] = (byte)13;
	geoidSimple[1][96] = (byte)13;
	geoidSimple[1][97] = (byte)13;
	geoidSimple[1][98] = (byte)13;
	geoidSimple[1][99] = (byte)12;
	geoidSimple[1][100] = (byte)12;
	geoidSimple[1][101] = (byte)12;
	geoidSimple[1][102] = (byte)12;
	geoidSimple[1][103] = (byte)12;
	geoidSimple[1][104] = (byte)12;
	geoidSimple[1][105] = (byte)12;
	geoidSimple[1][106] = (byte)12;
	geoidSimple[1][107] = (byte)12;
	geoidSimple[1][108] = (byte)12;
	geoidSimple[1][109] = (byte)12;
	geoidSimple[1][110] = (byte)12;
	geoidSimple[1][111] = (byte)12;
	geoidSimple[1][112] = (byte)12;
	geoidSimple[1][113] = (byte)12;
	geoidSimple[1][114] = (byte)12;
	geoidSimple[1][115] = (byte)12;
	geoidSimple[1][116] = (byte)12;
	geoidSimple[1][117] = (byte)12;
	geoidSimple[1][118] = (byte)12;
	geoidSimple[1][119] = (byte)12;
	geoidSimple[1][120] = (byte)12;
	geoidSimple[1][121] = (byte)12;
	geoidSimple[1][122] = (byte)12;
	geoidSimple[1][123] = (byte)12;
	geoidSimple[1][124] = (byte)12;
	geoidSimple[1][125] = (byte)12;
	geoidSimple[1][126] = (byte)12;
	geoidSimple[1][127] = (byte)12;
	geoidSimple[1][128] = (byte)12;
	geoidSimple[1][129] = (byte)12;
	geoidSimple[1][130] = (byte)13;
	geoidSimple[1][131] = (byte)13;
	geoidSimple[1][132] = (byte)13;
	geoidSimple[1][133] = (byte)13;
	geoidSimple[1][134] = (byte)13;
	geoidSimple[1][135] = (byte)13;
	geoidSimple[1][136] = (byte)13;
	geoidSimple[1][137] = (byte)13;
	geoidSimple[1][138] = (byte)13;
	geoidSimple[1][139] = (byte)13;
	geoidSimple[1][140] = (byte)14;
	geoidSimple[1][141] = (byte)14;
	geoidSimple[1][142] = (byte)14;
	geoidSimple[1][143] = (byte)14;
	geoidSimple[1][144] = (byte)14;
	geoidSimple[1][145] = (byte)14;
	geoidSimple[1][146] = (byte)14;
	geoidSimple[1][147] = (byte)13;
	geoidSimple[1][148] = (byte)13;
	geoidSimple[1][149] = (byte)13;
	geoidSimple[1][150] = (byte)13;
	geoidSimple[1][151] = (byte)13;
	geoidSimple[1][152] = (byte)13;
	geoidSimple[1][153] = (byte)13;
	geoidSimple[1][154] = (byte)13;
	geoidSimple[1][155] = (byte)13;
	geoidSimple[1][156] = (byte)13;
	geoidSimple[1][157] = (byte)13;
	geoidSimple[1][158] = (byte)13;
	geoidSimple[1][159] = (byte)12;
	geoidSimple[1][160] = (byte)12;
	geoidSimple[1][161] = (byte)12;
	geoidSimple[1][162] = (byte)12;
	geoidSimple[1][163] = (byte)12;
	geoidSimple[1][164] = (byte)12;
	geoidSimple[1][165] = (byte)12;
	geoidSimple[1][166] = (byte)12;
	geoidSimple[1][167] = (byte)12;
	geoidSimple[1][168] = (byte)12;
	geoidSimple[1][169] = (byte)12;
	geoidSimple[1][170] = (byte)12;
	geoidSimple[1][171] = (byte)12;
	geoidSimple[1][172] = (byte)12;
	geoidSimple[1][173] = (byte)12;
	geoidSimple[1][174] = (byte)12;
	geoidSimple[1][175] = (byte)12;
	geoidSimple[1][176] = (byte)12;
	geoidSimple[1][177] = (byte)12;
	geoidSimple[1][178] = (byte)12;
	geoidSimple[1][179] = (byte)12;
	geoidSimple[1][LAT_GRID_SIZE] = (byte)12;
	geoidSimple[1][181] = (byte)12;
	geoidSimple[1][182] = (byte)12;
	geoidSimple[1][183] = (byte)12;
	geoidSimple[1][184] = (byte)12;
	geoidSimple[1][185] = (byte)12;
	geoidSimple[1][186] = (byte)12;
	geoidSimple[1][187] = (byte)12;
	geoidSimple[1][188] = (byte)12;
	geoidSimple[1][189] = (byte)12;
	geoidSimple[1][190] = (byte)12;
	geoidSimple[1][191] = (byte)12;
	geoidSimple[1][192] = (byte)12;
	geoidSimple[1][193] = (byte)12;
	geoidSimple[1][194] = (byte)12;
	geoidSimple[1][195] = (byte)12;
	geoidSimple[1][196] = (byte)12;
	geoidSimple[1][197] = (byte)12;
	geoidSimple[1][198] = (byte)12;
	geoidSimple[1][199] = (byte)12;
	geoidSimple[1][200] = (byte)12;
	geoidSimple[1][201] = (byte)12;
	geoidSimple[1][202] = (byte)12;
	geoidSimple[1][203] = (byte)12;
	geoidSimple[1][204] = (byte)12;
	geoidSimple[1][205] = (byte)12;
	geoidSimple[1][206] = (byte)12;
	geoidSimple[1][207] = (byte)12;
	geoidSimple[1][208] = (byte)12;
	geoidSimple[1][209] = (byte)12;
	geoidSimple[1][210] = (byte)12;
	geoidSimple[1][211] = (byte)12;
	geoidSimple[1][212] = (byte)12;
	geoidSimple[1][213] = (byte)12;
	geoidSimple[1][214] = (byte)12;
	geoidSimple[1][215] = (byte)12;
	geoidSimple[1][216] = (byte)12;
	geoidSimple[1][217] = (byte)12;
	geoidSimple[1][218] = (byte)12;
	geoidSimple[1][219] = (byte)12;
	geoidSimple[1][220] = (byte)12;
	geoidSimple[1][221] = (byte)12;
	geoidSimple[1][222] = (byte)12;
	geoidSimple[1][223] = (byte)12;
	geoidSimple[1][224] = (byte)12;
	geoidSimple[1][225] = (byte)12;
	geoidSimple[1][226] = (byte)12;
	geoidSimple[1][227] = (byte)12;
	geoidSimple[1][228] = (byte)12;
	geoidSimple[1][229] = (byte)12;
	geoidSimple[1][230] = (byte)12;
	geoidSimple[1][231] = (byte)12;
	geoidSimple[1][232] = (byte)12;
	geoidSimple[1][233] = (byte)12;
	geoidSimple[1][234] = (byte)12;
	geoidSimple[1][235] = (byte)12;
	geoidSimple[1][236] = (byte)13;
	geoidSimple[1][237] = (byte)13;
	geoidSimple[1][238] = (byte)13;
	geoidSimple[1][239] = (byte)13;
	geoidSimple[1][240] = (byte)13;
	geoidSimple[1][241] = (byte)13;
	geoidSimple[1][242] = (byte)13;
	geoidSimple[1][243] = (byte)13;
	geoidSimple[1][244] = (byte)13;
	geoidSimple[1][245] = (byte)13;
	geoidSimple[1][246] = (byte)13;
	geoidSimple[1][247] = (byte)13;
	geoidSimple[1][248] = (byte)13;
	geoidSimple[1][249] = (byte)13;
	geoidSimple[1][250] = (byte)13;
	geoidSimple[1][251] = (byte)13;
	geoidSimple[1][252] = (byte)13;
	geoidSimple[1][253] = (byte)13;
	geoidSimple[1][254] = (byte)13;
	geoidSimple[1][255] = (byte)14;
	geoidSimple[1][256] = (byte)14;
	geoidSimple[1][257] = (byte)14;
	geoidSimple[1][258] = (byte)14;
	geoidSimple[1][259] = (byte)14;
	geoidSimple[1][260] = (byte)14;
	geoidSimple[1][261] = (byte)14;
	geoidSimple[1][262] = (byte)14;
	geoidSimple[1][263] = (byte)14;
	geoidSimple[1][264] = (byte)14;
	geoidSimple[1][265] = (byte)15;
	geoidSimple[1][266] = (byte)15;
	geoidSimple[1][267] = (byte)15;
	geoidSimple[1][268] = (byte)15;
	geoidSimple[1][269] = (byte)15;
	geoidSimple[1][270] = (byte)15;
	geoidSimple[1][271] = (byte)15;
	geoidSimple[1][272] = (byte)15;
	geoidSimple[1][273] = (byte)15;
	geoidSimple[1][274] = (byte)15;
	geoidSimple[1][275] = (byte)16;
	geoidSimple[1][276] = (byte)16;
	geoidSimple[1][277] = (byte)16;
	geoidSimple[1][278] = (byte)16;
	geoidSimple[1][279] = (byte)16;
	geoidSimple[1][280] = (byte)16;
	geoidSimple[1][281] = (byte)16;
	geoidSimple[1][282] = (byte)16;
	geoidSimple[1][283] = (byte)16;
	geoidSimple[1][284] = (byte)16;
	geoidSimple[1][285] = (byte)16;
	geoidSimple[1][286] = (byte)16;
	geoidSimple[1][287] = (byte)16;
	geoidSimple[1][288] = (byte)16;
	geoidSimple[1][289] = (byte)16;
	geoidSimple[1][290] = (byte)17;
	geoidSimple[1][291] = (byte)17;
	geoidSimple[1][292] = (byte)17;
	geoidSimple[1][293] = (byte)17;
	geoidSimple[1][294] = (byte)17;
	geoidSimple[1][295] = (byte)17;
	geoidSimple[1][296] = (byte)17;
	geoidSimple[1][297] = (byte)17;
	geoidSimple[1][298] = (byte)17;
	geoidSimple[1][299] = (byte)17;
	geoidSimple[1][300] = (byte)17;
	geoidSimple[1][301] = (byte)17;
	geoidSimple[1][302] = (byte)17;
	geoidSimple[1][303] = (byte)17;
	geoidSimple[1][304] = (byte)17;
	geoidSimple[1][305] = (byte)17;
	geoidSimple[1][306] = (byte)16;
	geoidSimple[1][307] = (byte)16;
	geoidSimple[1][308] = (byte)16;
	geoidSimple[1][309] = (byte)16;
	geoidSimple[1][310] = (byte)16;
	geoidSimple[1][311] = (byte)16;
	geoidSimple[1][312] = (byte)16;
	geoidSimple[1][313] = (byte)16;
	geoidSimple[1][314] = (byte)16;
	geoidSimple[1][315] = (byte)16;
	geoidSimple[1][316] = (byte)16;
	geoidSimple[1][317] = (byte)16;
	geoidSimple[1][318] = (byte)16;
	geoidSimple[1][319] = (byte)16;
	geoidSimple[1][320] = (byte)16;
	geoidSimple[1][321] = (byte)16;
	geoidSimple[1][322] = (byte)16;
	geoidSimple[1][323] = (byte)16;
	geoidSimple[1][324] = (byte)16;
	geoidSimple[1][325] = (byte)16;
	geoidSimple[1][326] = (byte)16;
	geoidSimple[1][327] = (byte)16;
	geoidSimple[1][328] = (byte)16;
	geoidSimple[1][329] = (byte)16;
	geoidSimple[1][330] = (byte)16;
	geoidSimple[1][331] = (byte)16;
	geoidSimple[1][332] = (byte)16;
	geoidSimple[1][333] = (byte)16;
	geoidSimple[1][334] = (byte)16;
	geoidSimple[1][335] = (byte)16;
	geoidSimple[1][336] = (byte)16;
	geoidSimple[1][337] = (byte)16;
	geoidSimple[1][338] = (byte)16;
	geoidSimple[1][339] = (byte)16;
	geoidSimple[1][340] = (byte)16;
	geoidSimple[1][341] = (byte)16;
	geoidSimple[1][342] = (byte)16;
	geoidSimple[1][343] = (byte)16;
	geoidSimple[1][344] = (byte)16;
	geoidSimple[1][345] = (byte)16;
	geoidSimple[1][346] = (byte)16;
	geoidSimple[1][347] = (byte)16;
	geoidSimple[1][348] = (byte)16;
	geoidSimple[1][349] = (byte)16;
	geoidSimple[1][350] = (byte)16;
	geoidSimple[1][351] = (byte)16;
	geoidSimple[1][352] = (byte)16;
	geoidSimple[1][353] = (byte)16;
	geoidSimple[1][354] = (byte)16;
	geoidSimple[1][355] = (byte)16;
	geoidSimple[1][356] = (byte)16;
	geoidSimple[1][357] = (byte)16;
	geoidSimple[1][358] = (byte)16;
	geoidSimple[1][359] = (byte)16;
	}
		/** Row 2*/
	private static void init2() {
	geoidSimple[2][0] = (byte)18;
	geoidSimple[2][1] = (byte)18;
	geoidSimple[2][2] = (byte)18;
	geoidSimple[2][3] = (byte)18;
	geoidSimple[2][4] = (byte)18;
	geoidSimple[2][5] = (byte)18;
	geoidSimple[2][6] = (byte)18;
	geoidSimple[2][7] = (byte)18;
	geoidSimple[2][8] = (byte)18;
	geoidSimple[2][9] = (byte)18;
	geoidSimple[2][10] = (byte)18;
	geoidSimple[2][11] = (byte)18;
	geoidSimple[2][12] = (byte)18;
	geoidSimple[2][13] = (byte)18;
	geoidSimple[2][14] = (byte)18;
	geoidSimple[2][15] = (byte)18;
	geoidSimple[2][16] = (byte)18;
	geoidSimple[2][17] = (byte)18;
	geoidSimple[2][18] = (byte)18;
	geoidSimple[2][19] = (byte)18;
	geoidSimple[2][20] = (byte)18;
	geoidSimple[2][21] = (byte)18;
	geoidSimple[2][22] = (byte)18;
	geoidSimple[2][23] = (byte)18;
	geoidSimple[2][24] = (byte)18;
	geoidSimple[2][25] = (byte)17;
	geoidSimple[2][26] = (byte)17;
	geoidSimple[2][27] = (byte)17;
	geoidSimple[2][28] = (byte)17;
	geoidSimple[2][29] = (byte)17;
	geoidSimple[2][30] = (byte)17;
	geoidSimple[2][31] = (byte)17;
	geoidSimple[2][32] = (byte)17;
	geoidSimple[2][33] = (byte)17;
	geoidSimple[2][34] = (byte)17;
	geoidSimple[2][35] = (byte)17;
	geoidSimple[2][36] = (byte)17;
	geoidSimple[2][37] = (byte)17;
	geoidSimple[2][38] = (byte)17;
	geoidSimple[2][39] = (byte)17;
	geoidSimple[2][40] = (byte)17;
	geoidSimple[2][41] = (byte)17;
	geoidSimple[2][42] = (byte)17;
	geoidSimple[2][43] = (byte)17;
	geoidSimple[2][44] = (byte)17;
	geoidSimple[2][45] = (byte)17;
	geoidSimple[2][46] = (byte)17;
	geoidSimple[2][47] = (byte)16;
	geoidSimple[2][48] = (byte)16;
	geoidSimple[2][49] = (byte)16;
	geoidSimple[2][50] = (byte)16;
	geoidSimple[2][51] = (byte)16;
	geoidSimple[2][52] = (byte)16;
	geoidSimple[2][53] = (byte)16;
	geoidSimple[2][54] = (byte)16;
	geoidSimple[2][55] = (byte)16;
	geoidSimple[2][56] = (byte)16;
	geoidSimple[2][57] = (byte)16;
	geoidSimple[2][58] = (byte)16;
	geoidSimple[2][59] = (byte)16;
	geoidSimple[2][60] = (byte)15;
	geoidSimple[2][61] = (byte)15;
	geoidSimple[2][62] = (byte)15;
	geoidSimple[2][63] = (byte)15;
	geoidSimple[2][64] = (byte)15;
	geoidSimple[2][65] = (byte)15;
	geoidSimple[2][66] = (byte)15;
	geoidSimple[2][67] = (byte)15;
	geoidSimple[2][68] = (byte)15;
	geoidSimple[2][69] = (byte)15;
	geoidSimple[2][70] = (byte)15;
	geoidSimple[2][71] = (byte)15;
	geoidSimple[2][72] = (byte)14;
	geoidSimple[2][73] = (byte)14;
	geoidSimple[2][74] = (byte)14;
	geoidSimple[2][75] = (byte)14;
	geoidSimple[2][76] = (byte)14;
	geoidSimple[2][77] = (byte)14;
	geoidSimple[2][78] = (byte)14;
	geoidSimple[2][79] = (byte)14;
	geoidSimple[2][80] = (byte)14;
	geoidSimple[2][81] = (byte)14;
	geoidSimple[2][82] = (byte)14;
	geoidSimple[2][83] = (byte)13;
	geoidSimple[2][84] = (byte)13;
	geoidSimple[2][85] = (byte)13;
	geoidSimple[2][86] = (byte)13;
	geoidSimple[2][87] = (byte)13;
	geoidSimple[2][88] = (byte)13;
	geoidSimple[2][89] = (byte)13;
	geoidSimple[2][90] = (byte)13;
	geoidSimple[2][91] = (byte)13;
	geoidSimple[2][92] = (byte)13;
	geoidSimple[2][93] = (byte)13;
	geoidSimple[2][94] = (byte)13;
	geoidSimple[2][95] = (byte)12;
	geoidSimple[2][96] = (byte)12;
	geoidSimple[2][97] = (byte)12;
	geoidSimple[2][98] = (byte)12;
	geoidSimple[2][99] = (byte)12;
	geoidSimple[2][100] = (byte)12;
	geoidSimple[2][101] = (byte)12;
	geoidSimple[2][102] = (byte)12;
	geoidSimple[2][103] = (byte)12;
	geoidSimple[2][104] = (byte)12;
	geoidSimple[2][105] = (byte)12;
	geoidSimple[2][106] = (byte)12;
	geoidSimple[2][107] = (byte)12;
	geoidSimple[2][108] = (byte)12;
	geoidSimple[2][109] = (byte)12;
	geoidSimple[2][110] = (byte)12;
	geoidSimple[2][111] = (byte)12;
	geoidSimple[2][112] = (byte)11;
	geoidSimple[2][113] = (byte)11;
	geoidSimple[2][114] = (byte)11;
	geoidSimple[2][115] = (byte)11;
	geoidSimple[2][116] = (byte)11;
	geoidSimple[2][117] = (byte)11;
	geoidSimple[2][118] = (byte)11;
	geoidSimple[2][119] = (byte)10;
	geoidSimple[2][120] = (byte)10;
	geoidSimple[2][121] = (byte)10;
	geoidSimple[2][122] = (byte)10;
	geoidSimple[2][123] = (byte)10;
	geoidSimple[2][124] = (byte)10;
	geoidSimple[2][125] = (byte)10;
	geoidSimple[2][126] = (byte)10;
	geoidSimple[2][127] = (byte)11;
	geoidSimple[2][128] = (byte)11;
	geoidSimple[2][129] = (byte)11;
	geoidSimple[2][130] = (byte)11;
	geoidSimple[2][131] = (byte)12;
	geoidSimple[2][132] = (byte)12;
	geoidSimple[2][133] = (byte)12;
	geoidSimple[2][134] = (byte)13;
	geoidSimple[2][135] = (byte)13;
	geoidSimple[2][136] = (byte)13;
	geoidSimple[2][137] = (byte)14;
	geoidSimple[2][138] = (byte)14;
	geoidSimple[2][139] = (byte)14;
	geoidSimple[2][140] = (byte)14;
	geoidSimple[2][141] = (byte)14;
	geoidSimple[2][142] = (byte)14;
	geoidSimple[2][143] = (byte)14;
	geoidSimple[2][144] = (byte)13;
	geoidSimple[2][145] = (byte)13;
	geoidSimple[2][146] = (byte)13;
	geoidSimple[2][147] = (byte)12;
	geoidSimple[2][148] = (byte)12;
	geoidSimple[2][149] = (byte)11;
	geoidSimple[2][150] = (byte)11;
	geoidSimple[2][151] = (byte)11;
	geoidSimple[2][152] = (byte)10;
	geoidSimple[2][153] = (byte)10;
	geoidSimple[2][154] = (byte)10;
	geoidSimple[2][155] = (byte)10;
	geoidSimple[2][156] = (byte)9;
	geoidSimple[2][157] = (byte)9;
	geoidSimple[2][158] = (byte)9;
	geoidSimple[2][159] = (byte)9;
	geoidSimple[2][160] = (byte)9;
	geoidSimple[2][161] = (byte)9;
	geoidSimple[2][162] = (byte)9;
	geoidSimple[2][163] = (byte)9;
	geoidSimple[2][164] = (byte)9;
	geoidSimple[2][165] = (byte)10;
	geoidSimple[2][166] = (byte)10;
	geoidSimple[2][167] = (byte)10;
	geoidSimple[2][168] = (byte)10;
	geoidSimple[2][169] = (byte)10;
	geoidSimple[2][170] = (byte)10;
	geoidSimple[2][171] = (byte)10;
	geoidSimple[2][172] = (byte)10;
	geoidSimple[2][173] = (byte)10;
	geoidSimple[2][174] = (byte)10;
	geoidSimple[2][175] = (byte)10;
	geoidSimple[2][176] = (byte)10;
	geoidSimple[2][177] = (byte)11;
	geoidSimple[2][178] = (byte)11;
	geoidSimple[2][179] = (byte)11;
	geoidSimple[2][LAT_GRID_SIZE] = (byte)11;
	geoidSimple[2][181] = (byte)11;
	geoidSimple[2][182] = (byte)11;
	geoidSimple[2][183] = (byte)11;
	geoidSimple[2][184] = (byte)10;
	geoidSimple[2][185] = (byte)10;
	geoidSimple[2][186] = (byte)10;
	geoidSimple[2][187] = (byte)10;
	geoidSimple[2][188] = (byte)10;
	geoidSimple[2][189] = (byte)10;
	geoidSimple[2][190] = (byte)10;
	geoidSimple[2][191] = (byte)10;
	geoidSimple[2][192] = (byte)10;
	geoidSimple[2][193] = (byte)11;
	geoidSimple[2][194] = (byte)11;
	geoidSimple[2][195] = (byte)11;
	geoidSimple[2][196] = (byte)11;
	geoidSimple[2][197] = (byte)11;
	geoidSimple[2][198] = (byte)11;
	geoidSimple[2][199] = (byte)11;
	geoidSimple[2][200] = (byte)11;
	geoidSimple[2][201] = (byte)11;
	geoidSimple[2][202] = (byte)11;
	geoidSimple[2][203] = (byte)11;
	geoidSimple[2][204] = (byte)11;
	geoidSimple[2][205] = (byte)11;
	geoidSimple[2][206] = (byte)11;
	geoidSimple[2][207] = (byte)12;
	geoidSimple[2][208] = (byte)12;
	geoidSimple[2][209] = (byte)12;
	geoidSimple[2][210] = (byte)12;
	geoidSimple[2][211] = (byte)12;
	geoidSimple[2][212] = (byte)12;
	geoidSimple[2][213] = (byte)12;
	geoidSimple[2][214] = (byte)12;
	geoidSimple[2][215] = (byte)12;
	geoidSimple[2][216] = (byte)12;
	geoidSimple[2][217] = (byte)12;
	geoidSimple[2][218] = (byte)12;
	geoidSimple[2][219] = (byte)12;
	geoidSimple[2][220] = (byte)12;
	geoidSimple[2][221] = (byte)12;
	geoidSimple[2][222] = (byte)12;
	geoidSimple[2][223] = (byte)12;
	geoidSimple[2][224] = (byte)12;
	geoidSimple[2][225] = (byte)12;
	geoidSimple[2][226] = (byte)12;
	geoidSimple[2][227] = (byte)12;
	geoidSimple[2][228] = (byte)12;
	geoidSimple[2][229] = (byte)13;
	geoidSimple[2][230] = (byte)13;
	geoidSimple[2][231] = (byte)13;
	geoidSimple[2][232] = (byte)13;
	geoidSimple[2][233] = (byte)13;
	geoidSimple[2][234] = (byte)13;
	geoidSimple[2][235] = (byte)13;
	geoidSimple[2][236] = (byte)13;
	geoidSimple[2][237] = (byte)13;
	geoidSimple[2][238] = (byte)13;
	geoidSimple[2][239] = (byte)14;
	geoidSimple[2][240] = (byte)14;
	geoidSimple[2][241] = (byte)14;
	geoidSimple[2][242] = (byte)14;
	geoidSimple[2][243] = (byte)14;
	geoidSimple[2][244] = (byte)14;
	geoidSimple[2][245] = (byte)14;
	geoidSimple[2][246] = (byte)14;
	geoidSimple[2][247] = (byte)14;
	geoidSimple[2][248] = (byte)14;
	geoidSimple[2][249] = (byte)14;
	geoidSimple[2][250] = (byte)14;
	geoidSimple[2][251] = (byte)14;
	geoidSimple[2][252] = (byte)14;
	geoidSimple[2][253] = (byte)14;
	geoidSimple[2][254] = (byte)14;
	geoidSimple[2][255] = (byte)14;
	geoidSimple[2][256] = (byte)14;
	geoidSimple[2][257] = (byte)14;
	geoidSimple[2][258] = (byte)14;
	geoidSimple[2][259] = (byte)14;
	geoidSimple[2][260] = (byte)14;
	geoidSimple[2][261] = (byte)14;
	geoidSimple[2][262] = (byte)15;
	geoidSimple[2][263] = (byte)15;
	geoidSimple[2][264] = (byte)15;
	geoidSimple[2][265] = (byte)15;
	geoidSimple[2][266] = (byte)15;
	geoidSimple[2][267] = (byte)15;
	geoidSimple[2][268] = (byte)15;
	geoidSimple[2][269] = (byte)15;
	geoidSimple[2][270] = (byte)16;
	geoidSimple[2][271] = (byte)16;
	geoidSimple[2][272] = (byte)16;
	geoidSimple[2][273] = (byte)16;
	geoidSimple[2][274] = (byte)16;
	geoidSimple[2][275] = (byte)16;
	geoidSimple[2][276] = (byte)16;
	geoidSimple[2][277] = (byte)16;
	geoidSimple[2][278] = (byte)16;
	geoidSimple[2][279] = (byte)16;
	geoidSimple[2][280] = (byte)16;
	geoidSimple[2][281] = (byte)16;
	geoidSimple[2][282] = (byte)17;
	geoidSimple[2][283] = (byte)17;
	geoidSimple[2][284] = (byte)17;
	geoidSimple[2][285] = (byte)17;
	geoidSimple[2][286] = (byte)17;
	geoidSimple[2][287] = (byte)17;
	geoidSimple[2][288] = (byte)17;
	geoidSimple[2][289] = (byte)18;
	geoidSimple[2][290] = (byte)18;
	geoidSimple[2][291] = (byte)18;
	geoidSimple[2][292] = (byte)18;
	geoidSimple[2][293] = (byte)18;
	geoidSimple[2][294] = (byte)18;
	geoidSimple[2][295] = (byte)19;
	geoidSimple[2][296] = (byte)19;
	geoidSimple[2][297] = (byte)19;
	geoidSimple[2][298] = (byte)19;
	geoidSimple[2][299] = (byte)19;
	geoidSimple[2][300] = (byte)19;
	geoidSimple[2][301] = (byte)19;
	geoidSimple[2][302] = (byte)19;
	geoidSimple[2][303] = (byte)19;
	geoidSimple[2][304] = (byte)19;
	geoidSimple[2][305] = (byte)19;
	geoidSimple[2][306] = (byte)19;
	geoidSimple[2][307] = (byte)19;
	geoidSimple[2][308] = (byte)19;
	geoidSimple[2][309] = (byte)19;
	geoidSimple[2][310] = (byte)18;
	geoidSimple[2][311] = (byte)18;
	geoidSimple[2][312] = (byte)18;
	geoidSimple[2][313] = (byte)18;
	geoidSimple[2][314] = (byte)18;
	geoidSimple[2][315] = (byte)18;
	geoidSimple[2][316] = (byte)18;
	geoidSimple[2][317] = (byte)18;
	geoidSimple[2][318] = (byte)18;
	geoidSimple[2][319] = (byte)18;
	geoidSimple[2][320] = (byte)18;
	geoidSimple[2][321] = (byte)18;
	geoidSimple[2][322] = (byte)18;
	geoidSimple[2][323] = (byte)18;
	geoidSimple[2][324] = (byte)18;
	geoidSimple[2][325] = (byte)18;
	geoidSimple[2][326] = (byte)18;
	geoidSimple[2][327] = (byte)18;
	geoidSimple[2][328] = (byte)18;
	geoidSimple[2][329] = (byte)18;
	geoidSimple[2][330] = (byte)18;
	geoidSimple[2][331] = (byte)18;
	geoidSimple[2][332] = (byte)18;
	geoidSimple[2][333] = (byte)18;
	geoidSimple[2][334] = (byte)18;
	geoidSimple[2][335] = (byte)18;
	geoidSimple[2][336] = (byte)18;
	geoidSimple[2][337] = (byte)18;
	geoidSimple[2][338] = (byte)18;
	geoidSimple[2][339] = (byte)18;
	geoidSimple[2][340] = (byte)18;
	geoidSimple[2][341] = (byte)18;
	geoidSimple[2][342] = (byte)18;
	geoidSimple[2][343] = (byte)18;
	geoidSimple[2][344] = (byte)18;
	geoidSimple[2][345] = (byte)18;
	geoidSimple[2][346] = (byte)18;
	geoidSimple[2][347] = (byte)18;
	geoidSimple[2][348] = (byte)18;
	geoidSimple[2][349] = (byte)18;
	geoidSimple[2][350] = (byte)18;
	geoidSimple[2][351] = (byte)18;
	geoidSimple[2][352] = (byte)18;
	geoidSimple[2][353] = (byte)18;
	geoidSimple[2][354] = (byte)18;
	geoidSimple[2][355] = (byte)18;
	geoidSimple[2][356] = (byte)18;
	geoidSimple[2][357] = (byte)18;
	geoidSimple[2][358] = (byte)18;
	geoidSimple[2][359] = (byte)18;
	}
		/** Row 3*/
	private static void init3() {
	geoidSimple[3][0] = (byte)21;
	geoidSimple[3][1] = (byte)21;
	geoidSimple[3][2] = (byte)21;
	geoidSimple[3][3] = (byte)21;
	geoidSimple[3][4] = (byte)21;
	geoidSimple[3][5] = (byte)21;
	geoidSimple[3][6] = (byte)21;
	geoidSimple[3][7] = (byte)21;
	geoidSimple[3][8] = (byte)21;
	geoidSimple[3][9] = (byte)21;
	geoidSimple[3][10] = (byte)21;
	geoidSimple[3][11] = (byte)21;
	geoidSimple[3][12] = (byte)20;
	geoidSimple[3][13] = (byte)20;
	geoidSimple[3][14] = (byte)20;
	geoidSimple[3][15] = (byte)20;
	geoidSimple[3][16] = (byte)20;
	geoidSimple[3][17] = (byte)20;
	geoidSimple[3][18] = (byte)20;
	geoidSimple[3][19] = (byte)20;
	geoidSimple[3][20] = (byte)20;
	geoidSimple[3][21] = (byte)20;
	geoidSimple[3][22] = (byte)20;
	geoidSimple[3][23] = (byte)20;
	geoidSimple[3][24] = (byte)20;
	geoidSimple[3][25] = (byte)20;
	geoidSimple[3][26] = (byte)20;
	geoidSimple[3][27] = (byte)20;
	geoidSimple[3][28] = (byte)20;
	geoidSimple[3][29] = (byte)20;
	geoidSimple[3][30] = (byte)20;
	geoidSimple[3][31] = (byte)20;
	geoidSimple[3][32] = (byte)20;
	geoidSimple[3][33] = (byte)20;
	geoidSimple[3][34] = (byte)20;
	geoidSimple[3][35] = (byte)20;
	geoidSimple[3][36] = (byte)20;
	geoidSimple[3][37] = (byte)20;
	geoidSimple[3][38] = (byte)19;
	geoidSimple[3][39] = (byte)19;
	geoidSimple[3][40] = (byte)19;
	geoidSimple[3][41] = (byte)19;
	geoidSimple[3][42] = (byte)19;
	geoidSimple[3][43] = (byte)19;
	geoidSimple[3][44] = (byte)19;
	geoidSimple[3][45] = (byte)18;
	geoidSimple[3][46] = (byte)18;
	geoidSimple[3][47] = (byte)18;
	geoidSimple[3][48] = (byte)18;
	geoidSimple[3][49] = (byte)18;
	geoidSimple[3][50] = (byte)18;
	geoidSimple[3][51] = (byte)17;
	geoidSimple[3][52] = (byte)17;
	geoidSimple[3][53] = (byte)17;
	geoidSimple[3][54] = (byte)17;
	geoidSimple[3][55] = (byte)17;
	geoidSimple[3][56] = (byte)17;
	geoidSimple[3][57] = (byte)17;
	geoidSimple[3][58] = (byte)17;
	geoidSimple[3][59] = (byte)17;
	geoidSimple[3][60] = (byte)17;
	geoidSimple[3][61] = (byte)17;
	geoidSimple[3][62] = (byte)17;
	geoidSimple[3][63] = (byte)17;
	geoidSimple[3][64] = (byte)17;
	geoidSimple[3][65] = (byte)17;
	geoidSimple[3][66] = (byte)17;
	geoidSimple[3][67] = (byte)17;
	geoidSimple[3][68] = (byte)16;
	geoidSimple[3][69] = (byte)16;
	geoidSimple[3][70] = (byte)16;
	geoidSimple[3][71] = (byte)16;
	geoidSimple[3][72] = (byte)16;
	geoidSimple[3][73] = (byte)15;
	geoidSimple[3][74] = (byte)15;
	geoidSimple[3][75] = (byte)15;
	geoidSimple[3][76] = (byte)15;
	geoidSimple[3][77] = (byte)15;
	geoidSimple[3][78] = (byte)14;
	geoidSimple[3][79] = (byte)14;
	geoidSimple[3][80] = (byte)14;
	geoidSimple[3][81] = (byte)14;
	geoidSimple[3][82] = (byte)14;
	geoidSimple[3][83] = (byte)14;
	geoidSimple[3][84] = (byte)14;
	geoidSimple[3][85] = (byte)13;
	geoidSimple[3][86] = (byte)13;
	geoidSimple[3][87] = (byte)13;
	geoidSimple[3][88] = (byte)13;
	geoidSimple[3][89] = (byte)13;
	geoidSimple[3][90] = (byte)13;
	geoidSimple[3][91] = (byte)13;
	geoidSimple[3][92] = (byte)13;
	geoidSimple[3][93] = (byte)13;
	geoidSimple[3][94] = (byte)13;
	geoidSimple[3][95] = (byte)13;
	geoidSimple[3][96] = (byte)12;
	geoidSimple[3][97] = (byte)12;
	geoidSimple[3][98] = (byte)12;
	geoidSimple[3][99] = (byte)12;
	geoidSimple[3][100] = (byte)12;
	geoidSimple[3][101] = (byte)12;
	geoidSimple[3][102] = (byte)12;
	geoidSimple[3][103] = (byte)12;
	geoidSimple[3][104] = (byte)11;
	geoidSimple[3][105] = (byte)11;
	geoidSimple[3][106] = (byte)11;
	geoidSimple[3][107] = (byte)11;
	geoidSimple[3][108] = (byte)11;
	geoidSimple[3][109] = (byte)11;
	geoidSimple[3][110] = (byte)11;
	geoidSimple[3][111] = (byte)11;
	geoidSimple[3][112] = (byte)11;
	geoidSimple[3][113] = (byte)11;
	geoidSimple[3][114] = (byte)11;
	geoidSimple[3][115] = (byte)11;
	geoidSimple[3][116] = (byte)11;
	geoidSimple[3][117] = (byte)11;
	geoidSimple[3][118] = (byte)11;
	geoidSimple[3][119] = (byte)11;
	geoidSimple[3][120] = (byte)10;
	geoidSimple[3][121] = (byte)10;
	geoidSimple[3][122] = (byte)10;
	geoidSimple[3][123] = (byte)10;
	geoidSimple[3][124] = (byte)9;
	geoidSimple[3][125] = (byte)9;
	geoidSimple[3][126] = (byte)9;
	geoidSimple[3][127] = (byte)9;
	geoidSimple[3][128] = (byte)9;
	geoidSimple[3][129] = (byte)9;
	geoidSimple[3][130] = (byte)9;
	geoidSimple[3][131] = (byte)9;
	geoidSimple[3][132] = (byte)10;
	geoidSimple[3][133] = (byte)10;
	geoidSimple[3][134] = (byte)11;
	geoidSimple[3][135] = (byte)11;
	geoidSimple[3][136] = (byte)11;
	geoidSimple[3][137] = (byte)12;
	geoidSimple[3][138] = (byte)12;
	geoidSimple[3][139] = (byte)12;
	geoidSimple[3][140] = (byte)12;
	geoidSimple[3][141] = (byte)12;
	geoidSimple[3][142] = (byte)12;
	geoidSimple[3][143] = (byte)11;
	geoidSimple[3][144] = (byte)11;
	geoidSimple[3][145] = (byte)11;
	geoidSimple[3][146] = (byte)10;
	geoidSimple[3][147] = (byte)9;
	geoidSimple[3][148] = (byte)9;
	geoidSimple[3][149] = (byte)9;
	geoidSimple[3][150] = (byte)8;
	geoidSimple[3][151] = (byte)8;
	geoidSimple[3][152] = (byte)8;
	geoidSimple[3][153] = (byte)8;
	geoidSimple[3][154] = (byte)8;
	geoidSimple[3][155] = (byte)8;
	geoidSimple[3][156] = (byte)8;
	geoidSimple[3][157] = (byte)8;
	geoidSimple[3][158] = (byte)8;
	geoidSimple[3][159] = (byte)8;
	geoidSimple[3][160] = (byte)8;
	geoidSimple[3][161] = (byte)8;
	geoidSimple[3][162] = (byte)8;
	geoidSimple[3][163] = (byte)8;
	geoidSimple[3][164] = (byte)8;
	geoidSimple[3][165] = (byte)8;
	geoidSimple[3][166] = (byte)8;
	geoidSimple[3][167] = (byte)8;
	geoidSimple[3][168] = (byte)8;
	geoidSimple[3][169] = (byte)9;
	geoidSimple[3][170] = (byte)9;
	geoidSimple[3][171] = (byte)9;
	geoidSimple[3][172] = (byte)9;
	geoidSimple[3][173] = (byte)9;
	geoidSimple[3][174] = (byte)9;
	geoidSimple[3][175] = (byte)9;
	geoidSimple[3][176] = (byte)9;
	geoidSimple[3][177] = (byte)9;
	geoidSimple[3][178] = (byte)9;
	geoidSimple[3][179] = (byte)9;
	geoidSimple[3][LAT_GRID_SIZE] = (byte)9;
	geoidSimple[3][181] = (byte)10;
	geoidSimple[3][182] = (byte)10;
	geoidSimple[3][183] = (byte)10;
	geoidSimple[3][184] = (byte)10;
	geoidSimple[3][185] = (byte)10;
	geoidSimple[3][186] = (byte)10;
	geoidSimple[3][187] = (byte)10;
	geoidSimple[3][188] = (byte)10;
	geoidSimple[3][189] = (byte)10;
	geoidSimple[3][190] = (byte)10;
	geoidSimple[3][191] = (byte)10;
	geoidSimple[3][192] = (byte)10;
	geoidSimple[3][193] = (byte)10;
	geoidSimple[3][194] = (byte)10;
	geoidSimple[3][195] = (byte)10;
	geoidSimple[3][196] = (byte)10;
	geoidSimple[3][197] = (byte)10;
	geoidSimple[3][198] = (byte)10;
	geoidSimple[3][199] = (byte)10;
	geoidSimple[3][200] = (byte)10;
	geoidSimple[3][201] = (byte)10;
	geoidSimple[3][202] = (byte)10;
	geoidSimple[3][203] = (byte)10;
	geoidSimple[3][204] = (byte)10;
	geoidSimple[3][205] = (byte)10;
	geoidSimple[3][206] = (byte)10;
	geoidSimple[3][207] = (byte)10;
	geoidSimple[3][208] = (byte)10;
	geoidSimple[3][209] = (byte)10;
	geoidSimple[3][210] = (byte)10;
	geoidSimple[3][211] = (byte)11;
	geoidSimple[3][212] = (byte)11;
	geoidSimple[3][213] = (byte)11;
	geoidSimple[3][214] = (byte)11;
	geoidSimple[3][215] = (byte)11;
	geoidSimple[3][216] = (byte)11;
	geoidSimple[3][217] = (byte)11;
	geoidSimple[3][218] = (byte)12;
	geoidSimple[3][219] = (byte)12;
	geoidSimple[3][220] = (byte)12;
	geoidSimple[3][221] = (byte)12;
	geoidSimple[3][222] = (byte)12;
	geoidSimple[3][223] = (byte)12;
	geoidSimple[3][224] = (byte)12;
	geoidSimple[3][225] = (byte)12;
	geoidSimple[3][226] = (byte)12;
	geoidSimple[3][227] = (byte)13;
	geoidSimple[3][228] = (byte)13;
	geoidSimple[3][229] = (byte)13;
	geoidSimple[3][230] = (byte)13;
	geoidSimple[3][231] = (byte)13;
	geoidSimple[3][232] = (byte)13;
	geoidSimple[3][233] = (byte)13;
	geoidSimple[3][234] = (byte)13;
	geoidSimple[3][235] = (byte)14;
	geoidSimple[3][236] = (byte)14;
	geoidSimple[3][237] = (byte)14;
	geoidSimple[3][238] = (byte)14;
	geoidSimple[3][239] = (byte)14;
	geoidSimple[3][240] = (byte)14;
	geoidSimple[3][241] = (byte)14;
	geoidSimple[3][242] = (byte)15;
	geoidSimple[3][243] = (byte)15;
	geoidSimple[3][244] = (byte)15;
	geoidSimple[3][245] = (byte)15;
	geoidSimple[3][246] = (byte)15;
	geoidSimple[3][247] = (byte)15;
	geoidSimple[3][248] = (byte)15;
	geoidSimple[3][249] = (byte)15;
	geoidSimple[3][250] = (byte)15;
	geoidSimple[3][251] = (byte)15;
	geoidSimple[3][252] = (byte)15;
	geoidSimple[3][253] = (byte)15;
	geoidSimple[3][254] = (byte)15;
	geoidSimple[3][255] = (byte)15;
	geoidSimple[3][256] = (byte)15;
	geoidSimple[3][257] = (byte)15;
	geoidSimple[3][258] = (byte)15;
	geoidSimple[3][259] = (byte)15;
	geoidSimple[3][260] = (byte)15;
	geoidSimple[3][261] = (byte)15;
	geoidSimple[3][262] = (byte)15;
	geoidSimple[3][263] = (byte)15;
	geoidSimple[3][264] = (byte)15;
	geoidSimple[3][265] = (byte)15;
	geoidSimple[3][266] = (byte)15;
	geoidSimple[3][267] = (byte)15;
	geoidSimple[3][268] = (byte)15;
	geoidSimple[3][269] = (byte)15;
	geoidSimple[3][270] = (byte)15;
	geoidSimple[3][271] = (byte)15;
	geoidSimple[3][272] = (byte)15;
	geoidSimple[3][273] = (byte)15;
	geoidSimple[3][274] = (byte)16;
	geoidSimple[3][275] = (byte)16;
	geoidSimple[3][276] = (byte)16;
	geoidSimple[3][277] = (byte)16;
	geoidSimple[3][278] = (byte)16;
	geoidSimple[3][279] = (byte)16;
	geoidSimple[3][280] = (byte)16;
	geoidSimple[3][281] = (byte)16;
	geoidSimple[3][282] = (byte)17;
	geoidSimple[3][283] = (byte)17;
	geoidSimple[3][284] = (byte)17;
	geoidSimple[3][285] = (byte)17;
	geoidSimple[3][286] = (byte)17;
	geoidSimple[3][287] = (byte)17;
	geoidSimple[3][288] = (byte)17;
	geoidSimple[3][289] = (byte)17;
	geoidSimple[3][290] = (byte)17;
	geoidSimple[3][291] = (byte)18;
	geoidSimple[3][292] = (byte)18;
	geoidSimple[3][293] = (byte)18;
	geoidSimple[3][294] = (byte)19;
	geoidSimple[3][295] = (byte)19;
	geoidSimple[3][296] = (byte)19;
	geoidSimple[3][297] = (byte)20;
	geoidSimple[3][298] = (byte)20;
	geoidSimple[3][299] = (byte)20;
	geoidSimple[3][300] = (byte)20;
	geoidSimple[3][301] = (byte)20;
	geoidSimple[3][302] = (byte)21;
	geoidSimple[3][303] = (byte)21;
	geoidSimple[3][304] = (byte)21;
	geoidSimple[3][305] = (byte)21;
	geoidSimple[3][306] = (byte)20;
	geoidSimple[3][307] = (byte)20;
	geoidSimple[3][308] = (byte)20;
	geoidSimple[3][309] = (byte)20;
	geoidSimple[3][310] = (byte)20;
	geoidSimple[3][311] = (byte)20;
	geoidSimple[3][312] = (byte)20;
	geoidSimple[3][313] = (byte)20;
	geoidSimple[3][314] = (byte)20;
	geoidSimple[3][315] = (byte)20;
	geoidSimple[3][316] = (byte)20;
	geoidSimple[3][317] = (byte)20;
	geoidSimple[3][318] = (byte)20;
	geoidSimple[3][319] = (byte)20;
	geoidSimple[3][320] = (byte)20;
	geoidSimple[3][321] = (byte)20;
	geoidSimple[3][322] = (byte)20;
	geoidSimple[3][323] = (byte)20;
	geoidSimple[3][324] = (byte)20;
	geoidSimple[3][325] = (byte)20;
	geoidSimple[3][326] = (byte)20;
	geoidSimple[3][327] = (byte)20;
	geoidSimple[3][328] = (byte)20;
	geoidSimple[3][329] = (byte)20;
	geoidSimple[3][330] = (byte)20;
	geoidSimple[3][331] = (byte)20;
	geoidSimple[3][332] = (byte)20;
	geoidSimple[3][333] = (byte)20;
	geoidSimple[3][334] = (byte)20;
	geoidSimple[3][335] = (byte)20;
	geoidSimple[3][336] = (byte)20;
	geoidSimple[3][337] = (byte)20;
	geoidSimple[3][338] = (byte)20;
	geoidSimple[3][339] = (byte)20;
	geoidSimple[3][340] = (byte)20;
	geoidSimple[3][341] = (byte)20;
	geoidSimple[3][342] = (byte)20;
	geoidSimple[3][343] = (byte)20;
	geoidSimple[3][344] = (byte)20;
	geoidSimple[3][345] = (byte)20;
	geoidSimple[3][346] = (byte)20;
	geoidSimple[3][347] = (byte)20;
	geoidSimple[3][348] = (byte)20;
	geoidSimple[3][349] = (byte)20;
	geoidSimple[3][350] = (byte)20;
	geoidSimple[3][351] = (byte)20;
	geoidSimple[3][352] = (byte)20;
	geoidSimple[3][353] = (byte)20;
	geoidSimple[3][354] = (byte)20;
	geoidSimple[3][355] = (byte)20;
	geoidSimple[3][356] = (byte)20;
	geoidSimple[3][357] = (byte)21;
	geoidSimple[3][358] = (byte)21;
	geoidSimple[3][359] = (byte)21;
	}
		/** Row 4*/
	private static void init4() {
	geoidSimple[4][0] = (byte)23;
	geoidSimple[4][1] = (byte)23;
	geoidSimple[4][2] = (byte)23;
	geoidSimple[4][3] = (byte)23;
	geoidSimple[4][4] = (byte)23;
	geoidSimple[4][5] = (byte)23;
	geoidSimple[4][6] = (byte)23;
	geoidSimple[4][7] = (byte)23;
	geoidSimple[4][8] = (byte)23;
	geoidSimple[4][9] = (byte)23;
	geoidSimple[4][10] = (byte)23;
	geoidSimple[4][11] = (byte)23;
	geoidSimple[4][12] = (byte)23;
	geoidSimple[4][13] = (byte)23;
	geoidSimple[4][14] = (byte)23;
	geoidSimple[4][15] = (byte)23;
	geoidSimple[4][16] = (byte)23;
	geoidSimple[4][17] = (byte)23;
	geoidSimple[4][18] = (byte)23;
	geoidSimple[4][19] = (byte)23;
	geoidSimple[4][20] = (byte)23;
	geoidSimple[4][21] = (byte)23;
	geoidSimple[4][22] = (byte)23;
	geoidSimple[4][23] = (byte)23;
	geoidSimple[4][24] = (byte)23;
	geoidSimple[4][25] = (byte)23;
	geoidSimple[4][26] = (byte)22;
	geoidSimple[4][27] = (byte)22;
	geoidSimple[4][28] = (byte)22;
	geoidSimple[4][29] = (byte)22;
	geoidSimple[4][30] = (byte)22;
	geoidSimple[4][31] = (byte)22;
	geoidSimple[4][32] = (byte)21;
	geoidSimple[4][33] = (byte)21;
	geoidSimple[4][34] = (byte)21;
	geoidSimple[4][35] = (byte)21;
	geoidSimple[4][36] = (byte)21;
	geoidSimple[4][37] = (byte)20;
	geoidSimple[4][38] = (byte)20;
	geoidSimple[4][39] = (byte)20;
	geoidSimple[4][40] = (byte)20;
	geoidSimple[4][41] = (byte)20;
	geoidSimple[4][42] = (byte)20;
	geoidSimple[4][43] = (byte)19;
	geoidSimple[4][44] = (byte)19;
	geoidSimple[4][45] = (byte)19;
	geoidSimple[4][46] = (byte)19;
	geoidSimple[4][47] = (byte)19;
	geoidSimple[4][48] = (byte)18;
	geoidSimple[4][49] = (byte)18;
	geoidSimple[4][50] = (byte)18;
	geoidSimple[4][51] = (byte)18;
	geoidSimple[4][52] = (byte)18;
	geoidSimple[4][53] = (byte)17;
	geoidSimple[4][54] = (byte)17;
	geoidSimple[4][55] = (byte)17;
	geoidSimple[4][56] = (byte)17;
	geoidSimple[4][57] = (byte)17;
	geoidSimple[4][58] = (byte)17;
	geoidSimple[4][59] = (byte)16;
	geoidSimple[4][60] = (byte)16;
	geoidSimple[4][61] = (byte)16;
	geoidSimple[4][62] = (byte)16;
	geoidSimple[4][63] = (byte)16;
	geoidSimple[4][64] = (byte)16;
	geoidSimple[4][65] = (byte)16;
	geoidSimple[4][66] = (byte)16;
	geoidSimple[4][67] = (byte)15;
	geoidSimple[4][68] = (byte)15;
	geoidSimple[4][69] = (byte)15;
	geoidSimple[4][70] = (byte)15;
	geoidSimple[4][71] = (byte)15;
	geoidSimple[4][72] = (byte)15;
	geoidSimple[4][73] = (byte)15;
	geoidSimple[4][74] = (byte)15;
	geoidSimple[4][75] = (byte)14;
	geoidSimple[4][76] = (byte)14;
	geoidSimple[4][77] = (byte)14;
	geoidSimple[4][78] = (byte)14;
	geoidSimple[4][79] = (byte)14;
	geoidSimple[4][80] = (byte)14;
	geoidSimple[4][81] = (byte)14;
	geoidSimple[4][82] = (byte)14;
	geoidSimple[4][83] = (byte)14;
	geoidSimple[4][84] = (byte)13;
	geoidSimple[4][85] = (byte)13;
	geoidSimple[4][86] = (byte)13;
	geoidSimple[4][87] = (byte)13;
	geoidSimple[4][88] = (byte)13;
	geoidSimple[4][89] = (byte)13;
	geoidSimple[4][90] = (byte)13;
	geoidSimple[4][91] = (byte)13;
	geoidSimple[4][92] = (byte)13;
	geoidSimple[4][93] = (byte)13;
	geoidSimple[4][94] = (byte)12;
	geoidSimple[4][95] = (byte)12;
	geoidSimple[4][96] = (byte)12;
	geoidSimple[4][97] = (byte)12;
	geoidSimple[4][98] = (byte)12;
	geoidSimple[4][99] = (byte)12;
	geoidSimple[4][100] = (byte)12;
	geoidSimple[4][101] = (byte)12;
	geoidSimple[4][102] = (byte)12;
	geoidSimple[4][103] = (byte)11;
	geoidSimple[4][104] = (byte)11;
	geoidSimple[4][105] = (byte)11;
	geoidSimple[4][106] = (byte)11;
	geoidSimple[4][107] = (byte)11;
	geoidSimple[4][108] = (byte)10;
	geoidSimple[4][109] = (byte)10;
	geoidSimple[4][110] = (byte)10;
	geoidSimple[4][111] = (byte)10;
	geoidSimple[4][112] = (byte)10;
	geoidSimple[4][113] = (byte)10;
	geoidSimple[4][114] = (byte)10;
	geoidSimple[4][115] = (byte)10;
	geoidSimple[4][116] = (byte)10;
	geoidSimple[4][117] = (byte)9;
	geoidSimple[4][118] = (byte)9;
	geoidSimple[4][119] = (byte)9;
	geoidSimple[4][120] = (byte)9;
	geoidSimple[4][121] = (byte)9;
	geoidSimple[4][122] = (byte)9;
	geoidSimple[4][123] = (byte)9;
	geoidSimple[4][124] = (byte)9;
	geoidSimple[4][125] = (byte)9;
	geoidSimple[4][126] = (byte)9;
	geoidSimple[4][127] = (byte)8;
	geoidSimple[4][128] = (byte)8;
	geoidSimple[4][129] = (byte)8;
	geoidSimple[4][130] = (byte)8;
	geoidSimple[4][131] = (byte)8;
	geoidSimple[4][132] = (byte)8;
	geoidSimple[4][133] = (byte)8;
	geoidSimple[4][134] = (byte)8;
	geoidSimple[4][135] = (byte)8;
	geoidSimple[4][136] = (byte)9;
	geoidSimple[4][137] = (byte)9;
	geoidSimple[4][138] = (byte)10;
	geoidSimple[4][139] = (byte)10;
	geoidSimple[4][140] = (byte)10;
	geoidSimple[4][141] = (byte)10;
	geoidSimple[4][142] = (byte)10;
	geoidSimple[4][143] = (byte)10;
	geoidSimple[4][144] = (byte)9;
	geoidSimple[4][145] = (byte)9;
	geoidSimple[4][146] = (byte)8;
	geoidSimple[4][147] = (byte)8;
	geoidSimple[4][148] = (byte)7;
	geoidSimple[4][149] = (byte)7;
	geoidSimple[4][150] = (byte)7;
	geoidSimple[4][151] = (byte)7;
	geoidSimple[4][152] = (byte)6;
	geoidSimple[4][153] = (byte)6;
	geoidSimple[4][154] = (byte)6;
	geoidSimple[4][155] = (byte)7;
	geoidSimple[4][156] = (byte)6;
	geoidSimple[4][157] = (byte)6;
	geoidSimple[4][158] = (byte)6;
	geoidSimple[4][159] = (byte)6;
	geoidSimple[4][160] = (byte)6;
	geoidSimple[4][161] = (byte)6;
	geoidSimple[4][162] = (byte)6;
	geoidSimple[4][163] = (byte)6;
	geoidSimple[4][164] = (byte)6;
	geoidSimple[4][165] = (byte)6;
	geoidSimple[4][166] = (byte)6;
	geoidSimple[4][167] = (byte)7;
	geoidSimple[4][168] = (byte)7;
	geoidSimple[4][169] = (byte)7;
	geoidSimple[4][170] = (byte)7;
	geoidSimple[4][171] = (byte)8;
	geoidSimple[4][172] = (byte)8;
	geoidSimple[4][173] = (byte)8;
	geoidSimple[4][174] = (byte)8;
	geoidSimple[4][175] = (byte)8;
	geoidSimple[4][176] = (byte)8;
	geoidSimple[4][177] = (byte)8;
	geoidSimple[4][178] = (byte)8;
	geoidSimple[4][179] = (byte)8;
	geoidSimple[4][LAT_GRID_SIZE] = (byte)8;
	geoidSimple[4][181] = (byte)8;
	geoidSimple[4][182] = (byte)8;
	geoidSimple[4][183] = (byte)8;
	geoidSimple[4][184] = (byte)9;
	geoidSimple[4][185] = (byte)9;
	geoidSimple[4][186] = (byte)9;
	geoidSimple[4][187] = (byte)9;
	geoidSimple[4][188] = (byte)9;
	geoidSimple[4][189] = (byte)9;
	geoidSimple[4][190] = (byte)9;
	geoidSimple[4][191] = (byte)9;
	geoidSimple[4][192] = (byte)9;
	geoidSimple[4][193] = (byte)9;
	geoidSimple[4][194] = (byte)9;
	geoidSimple[4][195] = (byte)9;
	geoidSimple[4][196] = (byte)9;
	geoidSimple[4][197] = (byte)9;
	geoidSimple[4][198] = (byte)9;
	geoidSimple[4][199] = (byte)9;
	geoidSimple[4][200] = (byte)9;
	geoidSimple[4][201] = (byte)9;
	geoidSimple[4][202] = (byte)9;
	geoidSimple[4][203] = (byte)9;
	geoidSimple[4][204] = (byte)10;
	geoidSimple[4][205] = (byte)10;
	geoidSimple[4][206] = (byte)10;
	geoidSimple[4][207] = (byte)10;
	geoidSimple[4][208] = (byte)10;
	geoidSimple[4][209] = (byte)10;
	geoidSimple[4][210] = (byte)10;
	geoidSimple[4][211] = (byte)10;
	geoidSimple[4][212] = (byte)10;
	geoidSimple[4][213] = (byte)10;
	geoidSimple[4][214] = (byte)10;
	geoidSimple[4][215] = (byte)11;
	geoidSimple[4][216] = (byte)11;
	geoidSimple[4][217] = (byte)11;
	geoidSimple[4][218] = (byte)11;
	geoidSimple[4][219] = (byte)11;
	geoidSimple[4][220] = (byte)11;
	geoidSimple[4][221] = (byte)12;
	geoidSimple[4][222] = (byte)12;
	geoidSimple[4][223] = (byte)12;
	geoidSimple[4][224] = (byte)12;
	geoidSimple[4][225] = (byte)12;
	geoidSimple[4][226] = (byte)12;
	geoidSimple[4][227] = (byte)12;
	geoidSimple[4][228] = (byte)12;
	geoidSimple[4][229] = (byte)13;
	geoidSimple[4][230] = (byte)13;
	geoidSimple[4][231] = (byte)13;
	geoidSimple[4][232] = (byte)13;
	geoidSimple[4][233] = (byte)13;
	geoidSimple[4][234] = (byte)13;
	geoidSimple[4][235] = (byte)13;
	geoidSimple[4][236] = (byte)13;
	geoidSimple[4][237] = (byte)13;
	geoidSimple[4][238] = (byte)13;
	geoidSimple[4][239] = (byte)13;
	geoidSimple[4][240] = (byte)13;
	geoidSimple[4][241] = (byte)13;
	geoidSimple[4][242] = (byte)13;
	geoidSimple[4][243] = (byte)13;
	geoidSimple[4][244] = (byte)13;
	geoidSimple[4][245] = (byte)14;
	geoidSimple[4][246] = (byte)14;
	geoidSimple[4][247] = (byte)14;
	geoidSimple[4][248] = (byte)14;
	geoidSimple[4][249] = (byte)14;
	geoidSimple[4][250] = (byte)14;
	geoidSimple[4][251] = (byte)14;
	geoidSimple[4][252] = (byte)14;
	geoidSimple[4][253] = (byte)14;
	geoidSimple[4][254] = (byte)14;
	geoidSimple[4][255] = (byte)14;
	geoidSimple[4][256] = (byte)15;
	geoidSimple[4][257] = (byte)15;
	geoidSimple[4][258] = (byte)15;
	geoidSimple[4][259] = (byte)15;
	geoidSimple[4][260] = (byte)15;
	geoidSimple[4][261] = (byte)15;
	geoidSimple[4][262] = (byte)15;
	geoidSimple[4][263] = (byte)16;
	geoidSimple[4][264] = (byte)16;
	geoidSimple[4][265] = (byte)16;
	geoidSimple[4][266] = (byte)16;
	geoidSimple[4][267] = (byte)16;
	geoidSimple[4][268] = (byte)16;
	geoidSimple[4][269] = (byte)16;
	geoidSimple[4][270] = (byte)16;
	geoidSimple[4][271] = (byte)16;
	geoidSimple[4][272] = (byte)16;
	geoidSimple[4][273] = (byte)16;
	geoidSimple[4][274] = (byte)16;
	geoidSimple[4][275] = (byte)16;
	geoidSimple[4][276] = (byte)16;
	geoidSimple[4][277] = (byte)16;
	geoidSimple[4][278] = (byte)16;
	geoidSimple[4][279] = (byte)16;
	geoidSimple[4][280] = (byte)17;
	geoidSimple[4][281] = (byte)17;
	geoidSimple[4][282] = (byte)17;
	geoidSimple[4][283] = (byte)17;
	geoidSimple[4][284] = (byte)18;
	geoidSimple[4][285] = (byte)18;
	geoidSimple[4][286] = (byte)18;
	geoidSimple[4][287] = (byte)18;
	geoidSimple[4][288] = (byte)19;
	geoidSimple[4][289] = (byte)19;
	geoidSimple[4][290] = (byte)19;
	geoidSimple[4][291] = (byte)19;
	geoidSimple[4][292] = (byte)20;
	geoidSimple[4][293] = (byte)20;
	geoidSimple[4][294] = (byte)20;
	geoidSimple[4][295] = (byte)21;
	geoidSimple[4][296] = (byte)21;
	geoidSimple[4][297] = (byte)21;
	geoidSimple[4][298] = (byte)22;
	geoidSimple[4][299] = (byte)22;
	geoidSimple[4][300] = (byte)22;
	geoidSimple[4][301] = (byte)22;
	geoidSimple[4][302] = (byte)22;
	geoidSimple[4][303] = (byte)22;
	geoidSimple[4][304] = (byte)22;
	geoidSimple[4][305] = (byte)22;
	geoidSimple[4][306] = (byte)21;
	geoidSimple[4][307] = (byte)21;
	geoidSimple[4][308] = (byte)21;
	geoidSimple[4][309] = (byte)20;
	geoidSimple[4][310] = (byte)20;
	geoidSimple[4][311] = (byte)20;
	geoidSimple[4][312] = (byte)20;
	geoidSimple[4][313] = (byte)20;
	geoidSimple[4][314] = (byte)20;
	geoidSimple[4][315] = (byte)20;
	geoidSimple[4][316] = (byte)20;
	geoidSimple[4][317] = (byte)20;
	geoidSimple[4][318] = (byte)20;
	geoidSimple[4][319] = (byte)21;
	geoidSimple[4][320] = (byte)21;
	geoidSimple[4][321] = (byte)21;
	geoidSimple[4][322] = (byte)21;
	geoidSimple[4][323] = (byte)21;
	geoidSimple[4][324] = (byte)21;
	geoidSimple[4][325] = (byte)22;
	geoidSimple[4][326] = (byte)22;
	geoidSimple[4][327] = (byte)22;
	geoidSimple[4][328] = (byte)22;
	geoidSimple[4][329] = (byte)22;
	geoidSimple[4][330] = (byte)22;
	geoidSimple[4][331] = (byte)22;
	geoidSimple[4][332] = (byte)22;
	geoidSimple[4][333] = (byte)22;
	geoidSimple[4][334] = (byte)22;
	geoidSimple[4][335] = (byte)22;
	geoidSimple[4][336] = (byte)22;
	geoidSimple[4][337] = (byte)22;
	geoidSimple[4][338] = (byte)23;
	geoidSimple[4][339] = (byte)23;
	geoidSimple[4][340] = (byte)23;
	geoidSimple[4][341] = (byte)23;
	geoidSimple[4][342] = (byte)23;
	geoidSimple[4][343] = (byte)24;
	geoidSimple[4][344] = (byte)24;
	geoidSimple[4][345] = (byte)24;
	geoidSimple[4][346] = (byte)24;
	geoidSimple[4][347] = (byte)24;
	geoidSimple[4][348] = (byte)23;
	geoidSimple[4][349] = (byte)23;
	geoidSimple[4][350] = (byte)23;
	geoidSimple[4][351] = (byte)23;
	geoidSimple[4][352] = (byte)23;
	geoidSimple[4][353] = (byte)23;
	geoidSimple[4][354] = (byte)23;
	geoidSimple[4][355] = (byte)23;
	geoidSimple[4][356] = (byte)23;
	geoidSimple[4][357] = (byte)23;
	geoidSimple[4][358] = (byte)23;
	geoidSimple[4][359] = (byte)23;
	}
		/** Row 5*/
	private static void init5() {
	geoidSimple[5][0] = (byte)26;
	geoidSimple[5][1] = (byte)26;
	geoidSimple[5][2] = (byte)26;
	geoidSimple[5][3] = (byte)25;
	geoidSimple[5][4] = (byte)25;
	geoidSimple[5][5] = (byte)25;
	geoidSimple[5][6] = (byte)25;
	geoidSimple[5][7] = (byte)25;
	geoidSimple[5][8] = (byte)25;
	geoidSimple[5][9] = (byte)25;
	geoidSimple[5][10] = (byte)25;
	geoidSimple[5][11] = (byte)25;
	geoidSimple[5][12] = (byte)25;
	geoidSimple[5][13] = (byte)25;
	geoidSimple[5][14] = (byte)25;
	geoidSimple[5][15] = (byte)24;
	geoidSimple[5][16] = (byte)24;
	geoidSimple[5][17] = (byte)24;
	geoidSimple[5][18] = (byte)24;
	geoidSimple[5][19] = (byte)24;
	geoidSimple[5][20] = (byte)24;
	geoidSimple[5][21] = (byte)24;
	geoidSimple[5][22] = (byte)24;
	geoidSimple[5][23] = (byte)23;
	geoidSimple[5][24] = (byte)23;
	geoidSimple[5][25] = (byte)23;
	geoidSimple[5][26] = (byte)23;
	geoidSimple[5][27] = (byte)23;
	geoidSimple[5][28] = (byte)23;
	geoidSimple[5][29] = (byte)22;
	geoidSimple[5][30] = (byte)22;
	geoidSimple[5][31] = (byte)22;
	geoidSimple[5][32] = (byte)22;
	geoidSimple[5][33] = (byte)21;
	geoidSimple[5][34] = (byte)21;
	geoidSimple[5][35] = (byte)21;
	geoidSimple[5][36] = (byte)21;
	geoidSimple[5][37] = (byte)20;
	geoidSimple[5][38] = (byte)20;
	geoidSimple[5][39] = (byte)20;
	geoidSimple[5][40] = (byte)20;
	geoidSimple[5][41] = (byte)20;
	geoidSimple[5][42] = (byte)19;
	geoidSimple[5][43] = (byte)19;
	geoidSimple[5][44] = (byte)19;
	geoidSimple[5][45] = (byte)19;
	geoidSimple[5][46] = (byte)18;
	geoidSimple[5][47] = (byte)18;
	geoidSimple[5][48] = (byte)18;
	geoidSimple[5][49] = (byte)18;
	geoidSimple[5][50] = (byte)18;
	geoidSimple[5][51] = (byte)17;
	geoidSimple[5][52] = (byte)17;
	geoidSimple[5][53] = (byte)17;
	geoidSimple[5][54] = (byte)17;
	geoidSimple[5][55] = (byte)16;
	geoidSimple[5][56] = (byte)16;
	geoidSimple[5][57] = (byte)16;
	geoidSimple[5][58] = (byte)16;
	geoidSimple[5][59] = (byte)15;
	geoidSimple[5][60] = (byte)15;
	geoidSimple[5][61] = (byte)15;
	geoidSimple[5][62] = (byte)15;
	geoidSimple[5][63] = (byte)15;
	geoidSimple[5][64] = (byte)14;
	geoidSimple[5][65] = (byte)14;
	geoidSimple[5][66] = (byte)14;
	geoidSimple[5][67] = (byte)14;
	geoidSimple[5][68] = (byte)13;
	geoidSimple[5][69] = (byte)13;
	geoidSimple[5][70] = (byte)13;
	geoidSimple[5][71] = (byte)13;
	geoidSimple[5][72] = (byte)13;
	geoidSimple[5][73] = (byte)13;
	geoidSimple[5][74] = (byte)13;
	geoidSimple[5][75] = (byte)12;
	geoidSimple[5][76] = (byte)12;
	geoidSimple[5][77] = (byte)12;
	geoidSimple[5][78] = (byte)12;
	geoidSimple[5][79] = (byte)12;
	geoidSimple[5][80] = (byte)12;
	geoidSimple[5][81] = (byte)12;
	geoidSimple[5][82] = (byte)11;
	geoidSimple[5][83] = (byte)11;
	geoidSimple[5][84] = (byte)11;
	geoidSimple[5][85] = (byte)11;
	geoidSimple[5][86] = (byte)11;
	geoidSimple[5][87] = (byte)11;
	geoidSimple[5][88] = (byte)11;
	geoidSimple[5][89] = (byte)11;
	geoidSimple[5][90] = (byte)11;
	geoidSimple[5][91] = (byte)11;
	geoidSimple[5][92] = (byte)11;
	geoidSimple[5][93] = (byte)11;
	geoidSimple[5][94] = (byte)11;
	geoidSimple[5][95] = (byte)11;
	geoidSimple[5][96] = (byte)11;
	geoidSimple[5][97] = (byte)11;
	geoidSimple[5][98] = (byte)11;
	geoidSimple[5][99] = (byte)10;
	geoidSimple[5][100] = (byte)10;
	geoidSimple[5][101] = (byte)10;
	geoidSimple[5][102] = (byte)10;
	geoidSimple[5][103] = (byte)10;
	geoidSimple[5][104] = (byte)10;
	geoidSimple[5][105] = (byte)10;
	geoidSimple[5][106] = (byte)10;
	geoidSimple[5][107] = (byte)10;
	geoidSimple[5][108] = (byte)10;
	geoidSimple[5][109] = (byte)10;
	geoidSimple[5][110] = (byte)10;
	geoidSimple[5][111] = (byte)10;
	geoidSimple[5][112] = (byte)10;
	geoidSimple[5][113] = (byte)10;
	geoidSimple[5][114] = (byte)10;
	geoidSimple[5][115] = (byte)10;
	geoidSimple[5][116] = (byte)9;
	geoidSimple[5][117] = (byte)9;
	geoidSimple[5][118] = (byte)9;
	geoidSimple[5][119] = (byte)9;
	geoidSimple[5][120] = (byte)8;
	geoidSimple[5][121] = (byte)8;
	geoidSimple[5][122] = (byte)8;
	geoidSimple[5][123] = (byte)8;
	geoidSimple[5][124] = (byte)8;
	geoidSimple[5][125] = (byte)8;
	geoidSimple[5][126] = (byte)8;
	geoidSimple[5][127] = (byte)7;
	geoidSimple[5][128] = (byte)7;
	geoidSimple[5][129] = (byte)7;
	geoidSimple[5][130] = (byte)7;
	geoidSimple[5][131] = (byte)7;
	geoidSimple[5][132] = (byte)6;
	geoidSimple[5][133] = (byte)6;
	geoidSimple[5][134] = (byte)6;
	geoidSimple[5][135] = (byte)6;
	geoidSimple[5][136] = (byte)6;
	geoidSimple[5][137] = (byte)6;
	geoidSimple[5][138] = (byte)7;
	geoidSimple[5][139] = (byte)7;
	geoidSimple[5][140] = (byte)8;
	geoidSimple[5][141] = (byte)8;
	geoidSimple[5][142] = (byte)8;
	geoidSimple[5][143] = (byte)8;
	geoidSimple[5][144] = (byte)8;
	geoidSimple[5][145] = (byte)8;
	geoidSimple[5][146] = (byte)8;
	geoidSimple[5][147] = (byte)8;
	geoidSimple[5][148] = (byte)7;
	geoidSimple[5][149] = (byte)7;
	geoidSimple[5][150] = (byte)7;
	geoidSimple[5][151] = (byte)7;
	geoidSimple[5][152] = (byte)6;
	geoidSimple[5][153] = (byte)6;
	geoidSimple[5][154] = (byte)6;
	geoidSimple[5][155] = (byte)6;
	geoidSimple[5][156] = (byte)6;
	geoidSimple[5][157] = (byte)6;
	geoidSimple[5][158] = (byte)6;
	geoidSimple[5][159] = (byte)5;
	geoidSimple[5][160] = (byte)5;
	geoidSimple[5][161] = (byte)5;
	geoidSimple[5][162] = (byte)5;
	geoidSimple[5][163] = (byte)5;
	geoidSimple[5][164] = (byte)5;
	geoidSimple[5][165] = (byte)5;
	geoidSimple[5][166] = (byte)5;
	geoidSimple[5][167] = (byte)6;
	geoidSimple[5][168] = (byte)6;
	geoidSimple[5][169] = (byte)6;
	geoidSimple[5][170] = (byte)6;
	geoidSimple[5][171] = (byte)6;
	geoidSimple[5][172] = (byte)6;
	geoidSimple[5][173] = (byte)6;
	geoidSimple[5][174] = (byte)6;
	geoidSimple[5][175] = (byte)6;
	geoidSimple[5][176] = (byte)6;
	geoidSimple[5][177] = (byte)6;
	geoidSimple[5][178] = (byte)6;
	geoidSimple[5][179] = (byte)7;
	geoidSimple[5][LAT_GRID_SIZE] = (byte)7;
	geoidSimple[5][181] = (byte)7;
	geoidSimple[5][182] = (byte)7;
	geoidSimple[5][183] = (byte)7;
	geoidSimple[5][184] = (byte)7;
	geoidSimple[5][185] = (byte)7;
	geoidSimple[5][186] = (byte)8;
	geoidSimple[5][187] = (byte)8;
	geoidSimple[5][188] = (byte)8;
	geoidSimple[5][189] = (byte)8;
	geoidSimple[5][190] = (byte)8;
	geoidSimple[5][191] = (byte)8;
	geoidSimple[5][192] = (byte)8;
	geoidSimple[5][193] = (byte)8;
	geoidSimple[5][194] = (byte)8;
	geoidSimple[5][195] = (byte)9;
	geoidSimple[5][196] = (byte)9;
	geoidSimple[5][197] = (byte)9;
	geoidSimple[5][198] = (byte)9;
	geoidSimple[5][199] = (byte)9;
	geoidSimple[5][200] = (byte)9;
	geoidSimple[5][201] = (byte)9;
	geoidSimple[5][202] = (byte)9;
	geoidSimple[5][203] = (byte)9;
	geoidSimple[5][204] = (byte)9;
	geoidSimple[5][205] = (byte)9;
	geoidSimple[5][206] = (byte)9;
	geoidSimple[5][207] = (byte)9;
	geoidSimple[5][208] = (byte)9;
	geoidSimple[5][209] = (byte)9;
	geoidSimple[5][210] = (byte)9;
	geoidSimple[5][211] = (byte)9;
	geoidSimple[5][212] = (byte)9;
	geoidSimple[5][213] = (byte)9;
	geoidSimple[5][214] = (byte)9;
	geoidSimple[5][215] = (byte)9;
	geoidSimple[5][216] = (byte)9;
	geoidSimple[5][217] = (byte)9;
	geoidSimple[5][218] = (byte)9;
	geoidSimple[5][219] = (byte)9;
	geoidSimple[5][220] = (byte)9;
	geoidSimple[5][221] = (byte)9;
	geoidSimple[5][222] = (byte)10;
	geoidSimple[5][223] = (byte)10;
	geoidSimple[5][224] = (byte)10;
	geoidSimple[5][225] = (byte)10;
	geoidSimple[5][226] = (byte)10;
	geoidSimple[5][227] = (byte)10;
	geoidSimple[5][228] = (byte)10;
	geoidSimple[5][229] = (byte)10;
	geoidSimple[5][230] = (byte)10;
	geoidSimple[5][231] = (byte)10;
	geoidSimple[5][232] = (byte)10;
	geoidSimple[5][233] = (byte)10;
	geoidSimple[5][234] = (byte)10;
	geoidSimple[5][235] = (byte)10;
	geoidSimple[5][236] = (byte)10;
	geoidSimple[5][237] = (byte)11;
	geoidSimple[5][238] = (byte)11;
	geoidSimple[5][239] = (byte)11;
	geoidSimple[5][240] = (byte)11;
	geoidSimple[5][241] = (byte)11;
	geoidSimple[5][242] = (byte)11;
	geoidSimple[5][243] = (byte)11;
	geoidSimple[5][244] = (byte)12;
	geoidSimple[5][245] = (byte)12;
	geoidSimple[5][246] = (byte)12;
	geoidSimple[5][247] = (byte)12;
	geoidSimple[5][248] = (byte)12;
	geoidSimple[5][249] = (byte)13;
	geoidSimple[5][250] = (byte)13;
	geoidSimple[5][251] = (byte)13;
	geoidSimple[5][252] = (byte)13;
	geoidSimple[5][253] = (byte)13;
	geoidSimple[5][254] = (byte)14;
	geoidSimple[5][255] = (byte)14;
	geoidSimple[5][256] = (byte)14;
	geoidSimple[5][257] = (byte)14;
	geoidSimple[5][258] = (byte)14;
	geoidSimple[5][259] = (byte)14;
	geoidSimple[5][260] = (byte)14;
	geoidSimple[5][261] = (byte)14;
	geoidSimple[5][262] = (byte)14;
	geoidSimple[5][263] = (byte)14;
	geoidSimple[5][264] = (byte)14;
	geoidSimple[5][265] = (byte)15;
	geoidSimple[5][266] = (byte)15;
	geoidSimple[5][267] = (byte)15;
	geoidSimple[5][268] = (byte)15;
	geoidSimple[5][269] = (byte)15;
	geoidSimple[5][270] = (byte)15;
	geoidSimple[5][271] = (byte)15;
	geoidSimple[5][272] = (byte)15;
	geoidSimple[5][273] = (byte)15;
	geoidSimple[5][274] = (byte)16;
	geoidSimple[5][275] = (byte)16;
	geoidSimple[5][276] = (byte)16;
	geoidSimple[5][277] = (byte)16;
	geoidSimple[5][278] = (byte)16;
	geoidSimple[5][279] = (byte)17;
	geoidSimple[5][280] = (byte)17;
	geoidSimple[5][281] = (byte)17;
	geoidSimple[5][282] = (byte)17;
	geoidSimple[5][283] = (byte)18;
	geoidSimple[5][284] = (byte)18;
	geoidSimple[5][285] = (byte)18;
	geoidSimple[5][286] = (byte)18;
	geoidSimple[5][287] = (byte)18;
	geoidSimple[5][288] = (byte)19;
	geoidSimple[5][289] = (byte)19;
	geoidSimple[5][290] = (byte)19;
	geoidSimple[5][291] = (byte)19;
	geoidSimple[5][292] = (byte)19;
	geoidSimple[5][293] = (byte)20;
	geoidSimple[5][294] = (byte)20;
	geoidSimple[5][295] = (byte)20;
	geoidSimple[5][296] = (byte)20;
	geoidSimple[5][297] = (byte)20;
	geoidSimple[5][298] = (byte)21;
	geoidSimple[5][299] = (byte)21;
	geoidSimple[5][300] = (byte)21;
	geoidSimple[5][301] = (byte)21;
	geoidSimple[5][302] = (byte)21;
	geoidSimple[5][303] = (byte)22;
	geoidSimple[5][304] = (byte)22;
	geoidSimple[5][305] = (byte)22;
	geoidSimple[5][306] = (byte)22;
	geoidSimple[5][307] = (byte)22;
	geoidSimple[5][308] = (byte)22;
	geoidSimple[5][309] = (byte)22;
	geoidSimple[5][310] = (byte)22;
	geoidSimple[5][311] = (byte)22;
	geoidSimple[5][312] = (byte)22;
	geoidSimple[5][313] = (byte)22;
	geoidSimple[5][314] = (byte)22;
	geoidSimple[5][315] = (byte)22;
	geoidSimple[5][316] = (byte)22;
	geoidSimple[5][317] = (byte)22;
	geoidSimple[5][318] = (byte)23;
	geoidSimple[5][319] = (byte)23;
	geoidSimple[5][320] = (byte)23;
	geoidSimple[5][321] = (byte)23;
	geoidSimple[5][322] = (byte)23;
	geoidSimple[5][323] = (byte)24;
	geoidSimple[5][324] = (byte)24;
	geoidSimple[5][325] = (byte)24;
	geoidSimple[5][326] = (byte)25;
	geoidSimple[5][327] = (byte)25;
	geoidSimple[5][328] = (byte)25;
	geoidSimple[5][329] = (byte)25;
	geoidSimple[5][330] = (byte)25;
	geoidSimple[5][331] = (byte)25;
	geoidSimple[5][332] = (byte)26;
	geoidSimple[5][333] = (byte)26;
	geoidSimple[5][334] = (byte)26;
	geoidSimple[5][335] = (byte)26;
	geoidSimple[5][336] = (byte)26;
	geoidSimple[5][337] = (byte)27;
	geoidSimple[5][338] = (byte)27;
	geoidSimple[5][339] = (byte)27;
	geoidSimple[5][340] = (byte)27;
	geoidSimple[5][341] = (byte)27;
	geoidSimple[5][342] = (byte)26;
	geoidSimple[5][343] = (byte)26;
	geoidSimple[5][344] = (byte)26;
	geoidSimple[5][345] = (byte)26;
	geoidSimple[5][346] = (byte)25;
	geoidSimple[5][347] = (byte)25;
	geoidSimple[5][348] = (byte)25;
	geoidSimple[5][349] = (byte)25;
	geoidSimple[5][350] = (byte)25;
	geoidSimple[5][351] = (byte)25;
	geoidSimple[5][352] = (byte)25;
	geoidSimple[5][353] = (byte)25;
	geoidSimple[5][354] = (byte)25;
	geoidSimple[5][355] = (byte)25;
	geoidSimple[5][356] = (byte)25;
	geoidSimple[5][357] = (byte)25;
	geoidSimple[5][358] = (byte)25;
	geoidSimple[5][359] = (byte)26;
	}
		/** Row 6*/
	private static void init6() {
	geoidSimple[6][0] = (byte)27;
	geoidSimple[6][1] = (byte)27;
	geoidSimple[6][2] = (byte)27;
	geoidSimple[6][3] = (byte)27;
	geoidSimple[6][4] = (byte)27;
	geoidSimple[6][5] = (byte)26;
	geoidSimple[6][6] = (byte)26;
	geoidSimple[6][7] = (byte)26;
	geoidSimple[6][8] = (byte)26;
	geoidSimple[6][9] = (byte)26;
	geoidSimple[6][10] = (byte)26;
	geoidSimple[6][11] = (byte)26;
	geoidSimple[6][12] = (byte)26;
	geoidSimple[6][13] = (byte)25;
	geoidSimple[6][14] = (byte)25;
	geoidSimple[6][15] = (byte)25;
	geoidSimple[6][16] = (byte)25;
	geoidSimple[6][17] = (byte)25;
	geoidSimple[6][18] = (byte)25;
	geoidSimple[6][19] = (byte)24;
	geoidSimple[6][20] = (byte)24;
	geoidSimple[6][21] = (byte)24;
	geoidSimple[6][22] = (byte)24;
	geoidSimple[6][23] = (byte)24;
	geoidSimple[6][24] = (byte)24;
	geoidSimple[6][25] = (byte)24;
	geoidSimple[6][26] = (byte)23;
	geoidSimple[6][27] = (byte)23;
	geoidSimple[6][28] = (byte)23;
	geoidSimple[6][29] = (byte)23;
	geoidSimple[6][30] = (byte)22;
	geoidSimple[6][31] = (byte)22;
	geoidSimple[6][32] = (byte)22;
	geoidSimple[6][33] = (byte)21;
	geoidSimple[6][34] = (byte)21;
	geoidSimple[6][35] = (byte)21;
	geoidSimple[6][36] = (byte)21;
	geoidSimple[6][37] = (byte)20;
	geoidSimple[6][38] = (byte)20;
	geoidSimple[6][39] = (byte)20;
	geoidSimple[6][40] = (byte)19;
	geoidSimple[6][41] = (byte)19;
	geoidSimple[6][42] = (byte)19;
	geoidSimple[6][43] = (byte)19;
	geoidSimple[6][44] = (byte)18;
	geoidSimple[6][45] = (byte)18;
	geoidSimple[6][46] = (byte)18;
	geoidSimple[6][47] = (byte)17;
	geoidSimple[6][48] = (byte)17;
	geoidSimple[6][49] = (byte)17;
	geoidSimple[6][50] = (byte)16;
	geoidSimple[6][51] = (byte)16;
	geoidSimple[6][52] = (byte)16;
	geoidSimple[6][53] = (byte)16;
	geoidSimple[6][54] = (byte)15;
	geoidSimple[6][55] = (byte)15;
	geoidSimple[6][56] = (byte)15;
	geoidSimple[6][57] = (byte)15;
	geoidSimple[6][58] = (byte)14;
	geoidSimple[6][59] = (byte)14;
	geoidSimple[6][60] = (byte)14;
	geoidSimple[6][61] = (byte)14;
	geoidSimple[6][62] = (byte)13;
	geoidSimple[6][63] = (byte)13;
	geoidSimple[6][64] = (byte)13;
	geoidSimple[6][65] = (byte)13;
	geoidSimple[6][66] = (byte)13;
	geoidSimple[6][67] = (byte)12;
	geoidSimple[6][68] = (byte)12;
	geoidSimple[6][69] = (byte)12;
	geoidSimple[6][70] = (byte)12;
	geoidSimple[6][71] = (byte)11;
	geoidSimple[6][72] = (byte)11;
	geoidSimple[6][73] = (byte)11;
	geoidSimple[6][74] = (byte)11;
	geoidSimple[6][75] = (byte)10;
	geoidSimple[6][76] = (byte)10;
	geoidSimple[6][77] = (byte)10;
	geoidSimple[6][78] = (byte)10;
	geoidSimple[6][79] = (byte)10;
	geoidSimple[6][80] = (byte)9;
	geoidSimple[6][81] = (byte)9;
	geoidSimple[6][82] = (byte)9;
	geoidSimple[6][83] = (byte)9;
	geoidSimple[6][84] = (byte)8;
	geoidSimple[6][85] = (byte)8;
	geoidSimple[6][86] = (byte)8;
	geoidSimple[6][87] = (byte)8;
	geoidSimple[6][88] = (byte)8;
	geoidSimple[6][89] = (byte)8;
	geoidSimple[6][90] = (byte)8;
	geoidSimple[6][91] = (byte)8;
	geoidSimple[6][92] = (byte)8;
	geoidSimple[6][93] = (byte)8;
	geoidSimple[6][94] = (byte)8;
	geoidSimple[6][95] = (byte)8;
	geoidSimple[6][96] = (byte)8;
	geoidSimple[6][97] = (byte)8;
	geoidSimple[6][98] = (byte)8;
	geoidSimple[6][99] = (byte)8;
	geoidSimple[6][100] = (byte)8;
	geoidSimple[6][101] = (byte)8;
	geoidSimple[6][102] = (byte)8;
	geoidSimple[6][103] = (byte)8;
	geoidSimple[6][104] = (byte)8;
	geoidSimple[6][105] = (byte)8;
	geoidSimple[6][106] = (byte)8;
	geoidSimple[6][107] = (byte)8;
	geoidSimple[6][108] = (byte)8;
	geoidSimple[6][109] = (byte)8;
	geoidSimple[6][110] = (byte)8;
	geoidSimple[6][111] = (byte)8;
	geoidSimple[6][112] = (byte)8;
	geoidSimple[6][113] = (byte)8;
	geoidSimple[6][114] = (byte)8;
	geoidSimple[6][115] = (byte)9;
	geoidSimple[6][116] = (byte)9;
	geoidSimple[6][117] = (byte)9;
	geoidSimple[6][118] = (byte)8;
	geoidSimple[6][119] = (byte)8;
	geoidSimple[6][120] = (byte)8;
	geoidSimple[6][121] = (byte)7;
	geoidSimple[6][122] = (byte)7;
	geoidSimple[6][123] = (byte)6;
	geoidSimple[6][124] = (byte)6;
	geoidSimple[6][125] = (byte)6;
	geoidSimple[6][126] = (byte)6;
	geoidSimple[6][127] = (byte)6;
	geoidSimple[6][128] = (byte)6;
	geoidSimple[6][129] = (byte)6;
	geoidSimple[6][130] = (byte)6;
	geoidSimple[6][131] = (byte)5;
	geoidSimple[6][132] = (byte)5;
	geoidSimple[6][133] = (byte)5;
	geoidSimple[6][134] = (byte)5;
	geoidSimple[6][135] = (byte)5;
	geoidSimple[6][136] = (byte)5;
	geoidSimple[6][137] = (byte)5;
	geoidSimple[6][138] = (byte)5;
	geoidSimple[6][139] = (byte)6;
	geoidSimple[6][140] = (byte)7;
	geoidSimple[6][141] = (byte)7;
	geoidSimple[6][142] = (byte)8;
	geoidSimple[6][143] = (byte)8;
	geoidSimple[6][144] = (byte)8;
	geoidSimple[6][145] = (byte)7;
	geoidSimple[6][146] = (byte)7;
	geoidSimple[6][147] = (byte)6;
	geoidSimple[6][148] = (byte)6;
	geoidSimple[6][149] = (byte)6;
	geoidSimple[6][150] = (byte)6;
	geoidSimple[6][151] = (byte)5;
	geoidSimple[6][152] = (byte)5;
	geoidSimple[6][153] = (byte)5;
	geoidSimple[6][154] = (byte)5;
	geoidSimple[6][155] = (byte)5;
	geoidSimple[6][156] = (byte)5;
	geoidSimple[6][157] = (byte)5;
	geoidSimple[6][158] = (byte)4;
	geoidSimple[6][159] = (byte)4;
	geoidSimple[6][160] = (byte)4;
	geoidSimple[6][161] = (byte)4;
	geoidSimple[6][162] = (byte)4;
	geoidSimple[6][163] = (byte)4;
	geoidSimple[6][164] = (byte)4;
	geoidSimple[6][165] = (byte)4;
	geoidSimple[6][166] = (byte)4;
	geoidSimple[6][167] = (byte)4;
	geoidSimple[6][168] = (byte)4;
	geoidSimple[6][169] = (byte)4;
	geoidSimple[6][170] = (byte)4;
	geoidSimple[6][171] = (byte)4;
	geoidSimple[6][172] = (byte)4;
	geoidSimple[6][173] = (byte)4;
	geoidSimple[6][174] = (byte)4;
	geoidSimple[6][175] = (byte)4;
	geoidSimple[6][176] = (byte)5;
	geoidSimple[6][177] = (byte)5;
	geoidSimple[6][178] = (byte)5;
	geoidSimple[6][179] = (byte)5;
	geoidSimple[6][LAT_GRID_SIZE] = (byte)5;
	geoidSimple[6][181] = (byte)5;
	geoidSimple[6][182] = (byte)5;
	geoidSimple[6][183] = (byte)6;
	geoidSimple[6][184] = (byte)6;
	geoidSimple[6][185] = (byte)6;
	geoidSimple[6][186] = (byte)6;
	geoidSimple[6][187] = (byte)6;
	geoidSimple[6][188] = (byte)6;
	geoidSimple[6][189] = (byte)6;
	geoidSimple[6][190] = (byte)6;
	geoidSimple[6][191] = (byte)6;
	geoidSimple[6][192] = (byte)6;
	geoidSimple[6][193] = (byte)6;
	geoidSimple[6][194] = (byte)6;
	geoidSimple[6][195] = (byte)6;
	geoidSimple[6][196] = (byte)6;
	geoidSimple[6][197] = (byte)6;
	geoidSimple[6][198] = (byte)7;
	geoidSimple[6][199] = (byte)7;
	geoidSimple[6][200] = (byte)7;
	geoidSimple[6][201] = (byte)7;
	geoidSimple[6][202] = (byte)7;
	geoidSimple[6][203] = (byte)7;
	geoidSimple[6][204] = (byte)7;
	geoidSimple[6][205] = (byte)7;
	geoidSimple[6][206] = (byte)7;
	geoidSimple[6][207] = (byte)7;
	geoidSimple[6][208] = (byte)7;
	geoidSimple[6][209] = (byte)7;
	geoidSimple[6][210] = (byte)7;
	geoidSimple[6][211] = (byte)7;
	geoidSimple[6][212] = (byte)7;
	geoidSimple[6][213] = (byte)7;
	geoidSimple[6][214] = (byte)7;
	geoidSimple[6][215] = (byte)7;
	geoidSimple[6][216] = (byte)7;
	geoidSimple[6][217] = (byte)7;
	geoidSimple[6][218] = (byte)7;
	geoidSimple[6][219] = (byte)7;
	geoidSimple[6][220] = (byte)7;
	geoidSimple[6][221] = (byte)7;
	geoidSimple[6][222] = (byte)7;
	geoidSimple[6][223] = (byte)7;
	geoidSimple[6][224] = (byte)7;
	geoidSimple[6][225] = (byte)7;
	geoidSimple[6][226] = (byte)7;
	geoidSimple[6][227] = (byte)7;
	geoidSimple[6][228] = (byte)7;
	geoidSimple[6][229] = (byte)7;
	geoidSimple[6][230] = (byte)7;
	geoidSimple[6][231] = (byte)7;
	geoidSimple[6][232] = (byte)7;
	geoidSimple[6][233] = (byte)7;
	geoidSimple[6][234] = (byte)7;
	geoidSimple[6][235] = (byte)7;
	geoidSimple[6][236] = (byte)7;
	geoidSimple[6][237] = (byte)8;
	geoidSimple[6][238] = (byte)8;
	geoidSimple[6][239] = (byte)8;
	geoidSimple[6][240] = (byte)8;
	geoidSimple[6][241] = (byte)8;
	geoidSimple[6][242] = (byte)8;
	geoidSimple[6][243] = (byte)8;
	geoidSimple[6][244] = (byte)9;
	geoidSimple[6][245] = (byte)9;
	geoidSimple[6][246] = (byte)9;
	geoidSimple[6][247] = (byte)9;
	geoidSimple[6][248] = (byte)9;
	geoidSimple[6][249] = (byte)9;
	geoidSimple[6][250] = (byte)10;
	geoidSimple[6][251] = (byte)10;
	geoidSimple[6][252] = (byte)10;
	geoidSimple[6][253] = (byte)10;
	geoidSimple[6][254] = (byte)10;
	geoidSimple[6][255] = (byte)11;
	geoidSimple[6][256] = (byte)11;
	geoidSimple[6][257] = (byte)11;
	geoidSimple[6][258] = (byte)11;
	geoidSimple[6][259] = (byte)11;
	geoidSimple[6][260] = (byte)12;
	geoidSimple[6][261] = (byte)12;
	geoidSimple[6][262] = (byte)12;
	geoidSimple[6][263] = (byte)12;
	geoidSimple[6][264] = (byte)13;
	geoidSimple[6][265] = (byte)13;
	geoidSimple[6][266] = (byte)13;
	geoidSimple[6][267] = (byte)13;
	geoidSimple[6][268] = (byte)13;
	geoidSimple[6][269] = (byte)14;
	geoidSimple[6][270] = (byte)14;
	geoidSimple[6][271] = (byte)15;
	geoidSimple[6][272] = (byte)15;
	geoidSimple[6][273] = (byte)15;
	geoidSimple[6][274] = (byte)15;
	geoidSimple[6][275] = (byte)16;
	geoidSimple[6][276] = (byte)16;
	geoidSimple[6][277] = (byte)16;
	geoidSimple[6][278] = (byte)17;
	geoidSimple[6][279] = (byte)17;
	geoidSimple[6][280] = (byte)17;
	geoidSimple[6][281] = (byte)17;
	geoidSimple[6][282] = (byte)18;
	geoidSimple[6][283] = (byte)18;
	geoidSimple[6][284] = (byte)18;
	geoidSimple[6][285] = (byte)18;
	geoidSimple[6][286] = (byte)19;
	geoidSimple[6][287] = (byte)19;
	geoidSimple[6][288] = (byte)19;
	geoidSimple[6][289] = (byte)19;
	geoidSimple[6][290] = (byte)19;
	geoidSimple[6][291] = (byte)19;
	geoidSimple[6][292] = (byte)20;
	geoidSimple[6][293] = (byte)20;
	geoidSimple[6][294] = (byte)20;
	geoidSimple[6][295] = (byte)20;
	geoidSimple[6][296] = (byte)21;
	geoidSimple[6][297] = (byte)21;
	geoidSimple[6][298] = (byte)21;
	geoidSimple[6][299] = (byte)21;
	geoidSimple[6][300] = (byte)21;
	geoidSimple[6][301] = (byte)22;
	geoidSimple[6][302] = (byte)22;
	geoidSimple[6][303] = (byte)22;
	geoidSimple[6][304] = (byte)22;
	geoidSimple[6][305] = (byte)23;
	geoidSimple[6][306] = (byte)23;
	geoidSimple[6][307] = (byte)23;
	geoidSimple[6][308] = (byte)23;
	geoidSimple[6][309] = (byte)24;
	geoidSimple[6][310] = (byte)24;
	geoidSimple[6][311] = (byte)24;
	geoidSimple[6][312] = (byte)24;
	geoidSimple[6][313] = (byte)24;
	geoidSimple[6][314] = (byte)25;
	geoidSimple[6][315] = (byte)25;
	geoidSimple[6][316] = (byte)25;
	geoidSimple[6][317] = (byte)25;
	geoidSimple[6][318] = (byte)25;
	geoidSimple[6][319] = (byte)25;
	geoidSimple[6][320] = (byte)25;
	geoidSimple[6][321] = (byte)25;
	geoidSimple[6][322] = (byte)26;
	geoidSimple[6][323] = (byte)26;
	geoidSimple[6][324] = (byte)26;
	geoidSimple[6][325] = (byte)26;
	geoidSimple[6][326] = (byte)27;
	geoidSimple[6][327] = (byte)27;
	geoidSimple[6][328] = (byte)27;
	geoidSimple[6][329] = (byte)27;
	geoidSimple[6][330] = (byte)27;
	geoidSimple[6][331] = (byte)27;
	geoidSimple[6][332] = (byte)27;
	geoidSimple[6][333] = (byte)27;
	geoidSimple[6][334] = (byte)27;
	geoidSimple[6][335] = (byte)27;
	geoidSimple[6][336] = (byte)26;
	geoidSimple[6][337] = (byte)26;
	geoidSimple[6][338] = (byte)26;
	geoidSimple[6][339] = (byte)26;
	geoidSimple[6][340] = (byte)26;
	geoidSimple[6][341] = (byte)26;
	geoidSimple[6][342] = (byte)26;
	geoidSimple[6][343] = (byte)25;
	geoidSimple[6][344] = (byte)25;
	geoidSimple[6][345] = (byte)26;
	geoidSimple[6][346] = (byte)26;
	geoidSimple[6][347] = (byte)26;
	geoidSimple[6][348] = (byte)26;
	geoidSimple[6][349] = (byte)27;
	geoidSimple[6][350] = (byte)27;
	geoidSimple[6][351] = (byte)27;
	geoidSimple[6][352] = (byte)27;
	geoidSimple[6][353] = (byte)27;
	geoidSimple[6][354] = (byte)28;
	geoidSimple[6][355] = (byte)27;
	geoidSimple[6][356] = (byte)27;
	geoidSimple[6][357] = (byte)27;
	geoidSimple[6][358] = (byte)27;
	geoidSimple[6][359] = (byte)27;
	}
		/** Row 7*/
	private static void init7() {
	geoidSimple[7][0] = (byte)29;
	geoidSimple[7][1] = (byte)28;
	geoidSimple[7][2] = (byte)28;
	geoidSimple[7][3] = (byte)28;
	geoidSimple[7][4] = (byte)28;
	geoidSimple[7][5] = (byte)28;
	geoidSimple[7][6] = (byte)28;
	geoidSimple[7][7] = (byte)28;
	geoidSimple[7][8] = (byte)28;
	geoidSimple[7][9] = (byte)28;
	geoidSimple[7][10] = (byte)28;
	geoidSimple[7][11] = (byte)28;
	geoidSimple[7][12] = (byte)29;
	geoidSimple[7][13] = (byte)28;
	geoidSimple[7][14] = (byte)28;
	geoidSimple[7][15] = (byte)28;
	geoidSimple[7][16] = (byte)27;
	geoidSimple[7][17] = (byte)27;
	geoidSimple[7][18] = (byte)26;
	geoidSimple[7][19] = (byte)26;
	geoidSimple[7][20] = (byte)25;
	geoidSimple[7][21] = (byte)25;
	geoidSimple[7][22] = (byte)25;
	geoidSimple[7][23] = (byte)24;
	geoidSimple[7][24] = (byte)24;
	geoidSimple[7][25] = (byte)24;
	geoidSimple[7][26] = (byte)23;
	geoidSimple[7][27] = (byte)23;
	geoidSimple[7][28] = (byte)23;
	geoidSimple[7][29] = (byte)22;
	geoidSimple[7][30] = (byte)22;
	geoidSimple[7][31] = (byte)22;
	geoidSimple[7][32] = (byte)21;
	geoidSimple[7][33] = (byte)21;
	geoidSimple[7][34] = (byte)21;
	geoidSimple[7][35] = (byte)20;
	geoidSimple[7][36] = (byte)20;
	geoidSimple[7][37] = (byte)19;
	geoidSimple[7][38] = (byte)19;
	geoidSimple[7][39] = (byte)19;
	geoidSimple[7][40] = (byte)19;
	geoidSimple[7][41] = (byte)18;
	geoidSimple[7][42] = (byte)18;
	geoidSimple[7][43] = (byte)18;
	geoidSimple[7][44] = (byte)18;
	geoidSimple[7][45] = (byte)18;
	geoidSimple[7][46] = (byte)18;
	geoidSimple[7][47] = (byte)17;
	geoidSimple[7][48] = (byte)16;
	geoidSimple[7][49] = (byte)16;
	geoidSimple[7][50] = (byte)16;
	geoidSimple[7][51] = (byte)16;
	geoidSimple[7][52] = (byte)16;
	geoidSimple[7][53] = (byte)16;
	geoidSimple[7][54] = (byte)16;
	geoidSimple[7][55] = (byte)16;
	geoidSimple[7][56] = (byte)16;
	geoidSimple[7][57] = (byte)16;
	geoidSimple[7][58] = (byte)16;
	geoidSimple[7][59] = (byte)16;
	geoidSimple[7][60] = (byte)15;
	geoidSimple[7][61] = (byte)15;
	geoidSimple[7][62] = (byte)15;
	geoidSimple[7][63] = (byte)14;
	geoidSimple[7][64] = (byte)13;
	geoidSimple[7][65] = (byte)12;
	geoidSimple[7][66] = (byte)12;
	geoidSimple[7][67] = (byte)11;
	geoidSimple[7][68] = (byte)11;
	geoidSimple[7][69] = (byte)11;
	geoidSimple[7][70] = (byte)11;
	geoidSimple[7][71] = (byte)10;
	geoidSimple[7][72] = (byte)10;
	geoidSimple[7][73] = (byte)10;
	geoidSimple[7][74] = (byte)10;
	geoidSimple[7][75] = (byte)9;
	geoidSimple[7][76] = (byte)9;
	geoidSimple[7][77] = (byte)9;
	geoidSimple[7][78] = (byte)8;
	geoidSimple[7][79] = (byte)8;
	geoidSimple[7][80] = (byte)8;
	geoidSimple[7][81] = (byte)8;
	geoidSimple[7][82] = (byte)7;
	geoidSimple[7][83] = (byte)7;
	geoidSimple[7][84] = (byte)7;
	geoidSimple[7][85] = (byte)6;
	geoidSimple[7][86] = (byte)6;
	geoidSimple[7][87] = (byte)6;
	geoidSimple[7][88] = (byte)6;
	geoidSimple[7][89] = (byte)6;
	geoidSimple[7][90] = (byte)6;
	geoidSimple[7][91] = (byte)6;
	geoidSimple[7][92] = (byte)6;
	geoidSimple[7][93] = (byte)6;
	geoidSimple[7][94] = (byte)6;
	geoidSimple[7][95] = (byte)6;
	geoidSimple[7][96] = (byte)5;
	geoidSimple[7][97] = (byte)5;
	geoidSimple[7][98] = (byte)5;
	geoidSimple[7][99] = (byte)5;
	geoidSimple[7][100] = (byte)5;
	geoidSimple[7][101] = (byte)5;
	geoidSimple[7][102] = (byte)5;
	geoidSimple[7][103] = (byte)5;
	geoidSimple[7][104] = (byte)5;
	geoidSimple[7][105] = (byte)5;
	geoidSimple[7][106] = (byte)5;
	geoidSimple[7][107] = (byte)5;
	geoidSimple[7][108] = (byte)5;
	geoidSimple[7][109] = (byte)5;
	geoidSimple[7][110] = (byte)5;
	geoidSimple[7][111] = (byte)5;
	geoidSimple[7][112] = (byte)5;
	geoidSimple[7][113] = (byte)5;
	geoidSimple[7][114] = (byte)5;
	geoidSimple[7][115] = (byte)5;
	geoidSimple[7][116] = (byte)6;
	geoidSimple[7][117] = (byte)6;
	geoidSimple[7][118] = (byte)6;
	geoidSimple[7][119] = (byte)6;
	geoidSimple[7][120] = (byte)5;
	geoidSimple[7][121] = (byte)5;
	geoidSimple[7][122] = (byte)5;
	geoidSimple[7][123] = (byte)4;
	geoidSimple[7][124] = (byte)4;
	geoidSimple[7][125] = (byte)4;
	geoidSimple[7][126] = (byte)4;
	geoidSimple[7][127] = (byte)4;
	geoidSimple[7][128] = (byte)4;
	geoidSimple[7][129] = (byte)4;
	geoidSimple[7][130] = (byte)4;
	geoidSimple[7][131] = (byte)4;
	geoidSimple[7][132] = (byte)4;
	geoidSimple[7][133] = (byte)4;
	geoidSimple[7][134] = (byte)3;
	geoidSimple[7][135] = (byte)3;
	geoidSimple[7][136] = (byte)3;
	geoidSimple[7][137] = (byte)3;
	geoidSimple[7][138] = (byte)4;
	geoidSimple[7][139] = (byte)5;
	geoidSimple[7][140] = (byte)6;
	geoidSimple[7][141] = (byte)6;
	geoidSimple[7][142] = (byte)7;
	geoidSimple[7][143] = (byte)7;
	geoidSimple[7][144] = (byte)6;
	geoidSimple[7][145] = (byte)5;
	geoidSimple[7][146] = (byte)5;
	geoidSimple[7][147] = (byte)4;
	geoidSimple[7][148] = (byte)3;
	geoidSimple[7][149] = (byte)3;
	geoidSimple[7][150] = (byte)3;
	geoidSimple[7][151] = (byte)3;
	geoidSimple[7][152] = (byte)3;
	geoidSimple[7][153] = (byte)3;
	geoidSimple[7][154] = (byte)3;
	geoidSimple[7][155] = (byte)3;
	geoidSimple[7][156] = (byte)3;
	geoidSimple[7][157] = (byte)3;
	geoidSimple[7][158] = (byte)3;
	geoidSimple[7][159] = (byte)3;
	geoidSimple[7][160] = (byte)3;
	geoidSimple[7][161] = (byte)3;
	geoidSimple[7][162] = (byte)3;
	geoidSimple[7][163] = (byte)3;
	geoidSimple[7][164] = (byte)3;
	geoidSimple[7][165] = (byte)3;
	geoidSimple[7][166] = (byte)3;
	geoidSimple[7][167] = (byte)3;
	geoidSimple[7][168] = (byte)3;
	geoidSimple[7][169] = (byte)3;
	geoidSimple[7][170] = (byte)3;
	geoidSimple[7][171] = (byte)3;
	geoidSimple[7][172] = (byte)3;
	geoidSimple[7][173] = (byte)3;
	geoidSimple[7][174] = (byte)3;
	geoidSimple[7][175] = (byte)3;
	geoidSimple[7][176] = (byte)4;
	geoidSimple[7][177] = (byte)4;
	geoidSimple[7][178] = (byte)4;
	geoidSimple[7][179] = (byte)4;
	geoidSimple[7][LAT_GRID_SIZE] = (byte)4;
	geoidSimple[7][181] = (byte)4;
	geoidSimple[7][182] = (byte)4;
	geoidSimple[7][183] = (byte)4;
	geoidSimple[7][184] = (byte)4;
	geoidSimple[7][185] = (byte)4;
	geoidSimple[7][186] = (byte)4;
	geoidSimple[7][187] = (byte)4;
	geoidSimple[7][188] = (byte)4;
	geoidSimple[7][189] = (byte)4;
	geoidSimple[7][190] = (byte)4;
	geoidSimple[7][191] = (byte)4;
	geoidSimple[7][192] = (byte)4;
	geoidSimple[7][193] = (byte)4;
	geoidSimple[7][194] = (byte)4;
	geoidSimple[7][195] = (byte)4;
	geoidSimple[7][196] = (byte)4;
	geoidSimple[7][197] = (byte)4;
	geoidSimple[7][198] = (byte)4;
	geoidSimple[7][199] = (byte)4;
	geoidSimple[7][200] = (byte)4;
	geoidSimple[7][201] = (byte)4;
	geoidSimple[7][202] = (byte)4;
	geoidSimple[7][203] = (byte)4;
	geoidSimple[7][204] = (byte)4;
	geoidSimple[7][205] = (byte)4;
	geoidSimple[7][206] = (byte)4;
	geoidSimple[7][207] = (byte)4;
	geoidSimple[7][208] = (byte)4;
	geoidSimple[7][209] = (byte)4;
	geoidSimple[7][210] = (byte)4;
	geoidSimple[7][211] = (byte)4;
	geoidSimple[7][212] = (byte)4;
	geoidSimple[7][213] = (byte)4;
	geoidSimple[7][214] = (byte)4;
	geoidSimple[7][215] = (byte)4;
	geoidSimple[7][216] = (byte)4;
	geoidSimple[7][217] = (byte)4;
	geoidSimple[7][218] = (byte)4;
	geoidSimple[7][219] = (byte)4;
	geoidSimple[7][220] = (byte)3;
	geoidSimple[7][221] = (byte)3;
	geoidSimple[7][222] = (byte)3;
	geoidSimple[7][223] = (byte)3;
	geoidSimple[7][224] = (byte)3;
	geoidSimple[7][225] = (byte)4;
	geoidSimple[7][226] = (byte)4;
	geoidSimple[7][227] = (byte)4;
	geoidSimple[7][228] = (byte)4;
	geoidSimple[7][229] = (byte)4;
	geoidSimple[7][230] = (byte)4;
	geoidSimple[7][231] = (byte)4;
	geoidSimple[7][232] = (byte)4;
	geoidSimple[7][233] = (byte)5;
	geoidSimple[7][234] = (byte)5;
	geoidSimple[7][235] = (byte)5;
	geoidSimple[7][236] = (byte)5;
	geoidSimple[7][237] = (byte)5;
	geoidSimple[7][238] = (byte)5;
	geoidSimple[7][239] = (byte)5;
	geoidSimple[7][240] = (byte)5;
	geoidSimple[7][241] = (byte)5;
	geoidSimple[7][242] = (byte)5;
	geoidSimple[7][243] = (byte)5;
	geoidSimple[7][244] = (byte)5;
	geoidSimple[7][245] = (byte)5;
	geoidSimple[7][246] = (byte)6;
	geoidSimple[7][247] = (byte)6;
	geoidSimple[7][248] = (byte)6;
	geoidSimple[7][249] = (byte)6;
	geoidSimple[7][250] = (byte)6;
	geoidSimple[7][251] = (byte)6;
	geoidSimple[7][252] = (byte)7;
	geoidSimple[7][253] = (byte)7;
	geoidSimple[7][254] = (byte)7;
	geoidSimple[7][255] = (byte)7;
	geoidSimple[7][256] = (byte)8;
	geoidSimple[7][257] = (byte)8;
	geoidSimple[7][258] = (byte)9;
	geoidSimple[7][259] = (byte)10;
	geoidSimple[7][260] = (byte)10;
	geoidSimple[7][261] = (byte)11;
	geoidSimple[7][262] = (byte)11;
	geoidSimple[7][263] = (byte)11;
	geoidSimple[7][264] = (byte)12;
	geoidSimple[7][265] = (byte)12;
	geoidSimple[7][266] = (byte)12;
	geoidSimple[7][267] = (byte)13;
	geoidSimple[7][268] = (byte)13;
	geoidSimple[7][269] = (byte)13;
	geoidSimple[7][270] = (byte)14;
	geoidSimple[7][271] = (byte)14;
	geoidSimple[7][272] = (byte)14;
	geoidSimple[7][273] = (byte)14;
	geoidSimple[7][274] = (byte)15;
	geoidSimple[7][275] = (byte)15;
	geoidSimple[7][276] = (byte)15;
	geoidSimple[7][277] = (byte)16;
	geoidSimple[7][278] = (byte)16;
	geoidSimple[7][279] = (byte)17;
	geoidSimple[7][280] = (byte)17;
	geoidSimple[7][281] = (byte)17;
	geoidSimple[7][282] = (byte)18;
	geoidSimple[7][283] = (byte)18;
	geoidSimple[7][284] = (byte)19;
	geoidSimple[7][285] = (byte)19;
	geoidSimple[7][286] = (byte)20;
	geoidSimple[7][287] = (byte)20;
	geoidSimple[7][288] = (byte)20;
	geoidSimple[7][289] = (byte)21;
	geoidSimple[7][290] = (byte)21;
	geoidSimple[7][291] = (byte)20;
	geoidSimple[7][292] = (byte)20;
	geoidSimple[7][293] = (byte)20;
	geoidSimple[7][294] = (byte)20;
	geoidSimple[7][295] = (byte)20;
	geoidSimple[7][296] = (byte)20;
	geoidSimple[7][297] = (byte)19;
	geoidSimple[7][298] = (byte)19;
	geoidSimple[7][299] = (byte)18;
	geoidSimple[7][300] = (byte)18;
	geoidSimple[7][301] = (byte)18;
	geoidSimple[7][302] = (byte)18;
	geoidSimple[7][303] = (byte)18;
	geoidSimple[7][304] = (byte)19;
	geoidSimple[7][305] = (byte)19;
	geoidSimple[7][306] = (byte)19;
	geoidSimple[7][307] = (byte)19;
	geoidSimple[7][308] = (byte)19;
	geoidSimple[7][309] = (byte)19;
	geoidSimple[7][310] = (byte)20;
	geoidSimple[7][311] = (byte)20;
	geoidSimple[7][312] = (byte)21;
	geoidSimple[7][313] = (byte)22;
	geoidSimple[7][314] = (byte)22;
	geoidSimple[7][315] = (byte)23;
	geoidSimple[7][316] = (byte)24;
	geoidSimple[7][317] = (byte)25;
	geoidSimple[7][318] = (byte)25;
	geoidSimple[7][319] = (byte)26;
	geoidSimple[7][320] = (byte)27;
	geoidSimple[7][321] = (byte)27;
	geoidSimple[7][322] = (byte)28;
	geoidSimple[7][323] = (byte)28;
	geoidSimple[7][324] = (byte)29;
	geoidSimple[7][325] = (byte)29;
	geoidSimple[7][326] = (byte)29;
	geoidSimple[7][327] = (byte)30;
	geoidSimple[7][328] = (byte)30;
	geoidSimple[7][329] = (byte)30;
	geoidSimple[7][330] = (byte)30;
	geoidSimple[7][331] = (byte)30;
	geoidSimple[7][332] = (byte)29;
	geoidSimple[7][333] = (byte)29;
	geoidSimple[7][334] = (byte)29;
	geoidSimple[7][335] = (byte)28;
	geoidSimple[7][336] = (byte)28;
	geoidSimple[7][337] = (byte)27;
	geoidSimple[7][338] = (byte)27;
	geoidSimple[7][339] = (byte)27;
	geoidSimple[7][340] = (byte)27;
	geoidSimple[7][341] = (byte)28;
	geoidSimple[7][342] = (byte)28;
	geoidSimple[7][343] = (byte)29;
	geoidSimple[7][344] = (byte)29;
	geoidSimple[7][345] = (byte)29;
	geoidSimple[7][346] = (byte)29;
	geoidSimple[7][347] = (byte)29;
	geoidSimple[7][348] = (byte)29;
	geoidSimple[7][349] = (byte)29;
	geoidSimple[7][350] = (byte)29;
	geoidSimple[7][351] = (byte)28;
	geoidSimple[7][352] = (byte)28;
	geoidSimple[7][353] = (byte)28;
	geoidSimple[7][354] = (byte)29;
	geoidSimple[7][355] = (byte)29;
	geoidSimple[7][356] = (byte)29;
	geoidSimple[7][357] = (byte)29;
	geoidSimple[7][358] = (byte)29;
	geoidSimple[7][359] = (byte)29;
	}
		/** Row 8*/
	private static void init8() {
	geoidSimple[8][0] = (byte)31;
	geoidSimple[8][1] = (byte)31;
	geoidSimple[8][2] = (byte)31;
	geoidSimple[8][3] = (byte)31;
	geoidSimple[8][4] = (byte)31;
	geoidSimple[8][5] = (byte)31;
	geoidSimple[8][6] = (byte)31;
	geoidSimple[8][7] = (byte)31;
	geoidSimple[8][8] = (byte)31;
	geoidSimple[8][9] = (byte)31;
	geoidSimple[8][10] = (byte)31;
	geoidSimple[8][11] = (byte)30;
	geoidSimple[8][12] = (byte)30;
	geoidSimple[8][13] = (byte)29;
	geoidSimple[8][14] = (byte)29;
	geoidSimple[8][15] = (byte)29;
	geoidSimple[8][16] = (byte)29;
	geoidSimple[8][17] = (byte)28;
	geoidSimple[8][18] = (byte)28;
	geoidSimple[8][19] = (byte)28;
	geoidSimple[8][20] = (byte)28;
	geoidSimple[8][21] = (byte)27;
	geoidSimple[8][22] = (byte)27;
	geoidSimple[8][23] = (byte)27;
	geoidSimple[8][24] = (byte)26;
	geoidSimple[8][25] = (byte)26;
	geoidSimple[8][26] = (byte)25;
	geoidSimple[8][27] = (byte)25;
	geoidSimple[8][28] = (byte)24;
	geoidSimple[8][29] = (byte)24;
	geoidSimple[8][30] = (byte)23;
	geoidSimple[8][31] = (byte)23;
	geoidSimple[8][32] = (byte)23;
	geoidSimple[8][33] = (byte)22;
	geoidSimple[8][34] = (byte)22;
	geoidSimple[8][35] = (byte)21;
	geoidSimple[8][36] = (byte)21;
	geoidSimple[8][37] = (byte)21;
	geoidSimple[8][38] = (byte)20;
	geoidSimple[8][39] = (byte)20;
	geoidSimple[8][40] = (byte)20;
	geoidSimple[8][41] = (byte)20;
	geoidSimple[8][42] = (byte)20;
	geoidSimple[8][43] = (byte)20;
	geoidSimple[8][44] = (byte)19;
	geoidSimple[8][45] = (byte)19;
	geoidSimple[8][46] = (byte)19;
	geoidSimple[8][47] = (byte)18;
	geoidSimple[8][48] = (byte)18;
	geoidSimple[8][49] = (byte)17;
	geoidSimple[8][50] = (byte)17;
	geoidSimple[8][51] = (byte)17;
	geoidSimple[8][52] = (byte)16;
	geoidSimple[8][53] = (byte)16;
	geoidSimple[8][54] = (byte)16;
	geoidSimple[8][55] = (byte)16;
	geoidSimple[8][56] = (byte)15;
	geoidSimple[8][57] = (byte)15;
	geoidSimple[8][58] = (byte)15;
	geoidSimple[8][59] = (byte)15;
	geoidSimple[8][60] = (byte)15;
	geoidSimple[8][61] = (byte)14;
	geoidSimple[8][62] = (byte)13;
	geoidSimple[8][63] = (byte)13;
	geoidSimple[8][64] = (byte)12;
	geoidSimple[8][65] = (byte)11;
	geoidSimple[8][66] = (byte)10;
	geoidSimple[8][67] = (byte)10;
	geoidSimple[8][68] = (byte)10;
	geoidSimple[8][69] = (byte)9;
	geoidSimple[8][70] = (byte)9;
	geoidSimple[8][71] = (byte)9;
	geoidSimple[8][72] = (byte)9;
	geoidSimple[8][73] = (byte)9;
	geoidSimple[8][74] = (byte)9;
	geoidSimple[8][75] = (byte)9;
	geoidSimple[8][76] = (byte)9;
	geoidSimple[8][77] = (byte)8;
	geoidSimple[8][78] = (byte)8;
	geoidSimple[8][79] = (byte)8;
	geoidSimple[8][80] = (byte)8;
	geoidSimple[8][81] = (byte)7;
	geoidSimple[8][82] = (byte)7;
	geoidSimple[8][83] = (byte)7;
	geoidSimple[8][84] = (byte)7;
	geoidSimple[8][85] = (byte)7;
	geoidSimple[8][86] = (byte)6;
	geoidSimple[8][87] = (byte)6;
	geoidSimple[8][88] = (byte)6;
	geoidSimple[8][89] = (byte)6;
	geoidSimple[8][90] = (byte)6;
	geoidSimple[8][91] = (byte)7;
	geoidSimple[8][92] = (byte)7;
	geoidSimple[8][93] = (byte)6;
	geoidSimple[8][94] = (byte)6;
	geoidSimple[8][95] = (byte)6;
	geoidSimple[8][96] = (byte)5;
	geoidSimple[8][97] = (byte)5;
	geoidSimple[8][98] = (byte)4;
	geoidSimple[8][99] = (byte)4;
	geoidSimple[8][100] = (byte)4;
	geoidSimple[8][101] = (byte)4;
	geoidSimple[8][102] = (byte)4;
	geoidSimple[8][103] = (byte)4;
	geoidSimple[8][104] = (byte)3;
	geoidSimple[8][105] = (byte)2;
	geoidSimple[8][106] = (byte)2;
	geoidSimple[8][107] = (byte)2;
	geoidSimple[8][108] = (byte)2;
	geoidSimple[8][109] = (byte)2;
	geoidSimple[8][110] = (byte)2;
	geoidSimple[8][111] = (byte)2;
	geoidSimple[8][112] = (byte)2;
	geoidSimple[8][113] = (byte)2;
	geoidSimple[8][114] = (byte)2;
	geoidSimple[8][115] = (byte)2;
	geoidSimple[8][116] = (byte)3;
	geoidSimple[8][117] = (byte)3;
	geoidSimple[8][118] = (byte)3;
	geoidSimple[8][119] = (byte)2;
	geoidSimple[8][120] = (byte)2;
	geoidSimple[8][121] = (byte)2;
	geoidSimple[8][122] = (byte)2;
	geoidSimple[8][123] = (byte)2;
	geoidSimple[8][124] = (byte)2;
	geoidSimple[8][125] = (byte)2;
	geoidSimple[8][126] = (byte)2;
	geoidSimple[8][127] = (byte)2;
	geoidSimple[8][128] = (byte)2;
	geoidSimple[8][129] = (byte)2;
	geoidSimple[8][130] = (byte)2;
	geoidSimple[8][131] = (byte)2;
	geoidSimple[8][132] = (byte)2;
	geoidSimple[8][133] = (byte)2;
	geoidSimple[8][134] = (byte)2;
	geoidSimple[8][135] = (byte)2;
	geoidSimple[8][136] = (byte)2;
	geoidSimple[8][137] = (byte)2;
	geoidSimple[8][138] = (byte)3;
	geoidSimple[8][139] = (byte)3;
	geoidSimple[8][140] = (byte)4;
	geoidSimple[8][141] = (byte)4;
	geoidSimple[8][142] = (byte)4;
	geoidSimple[8][143] = (byte)3;
	geoidSimple[8][144] = (byte)3;
	geoidSimple[8][145] = (byte)2;
	geoidSimple[8][146] = (byte)2;
	geoidSimple[8][147] = (byte)2;
	geoidSimple[8][148] = (byte)2;
	geoidSimple[8][149] = (byte)2;
	geoidSimple[8][150] = (byte)2;
	geoidSimple[8][151] = (byte)2;
	geoidSimple[8][152] = (byte)2;
	geoidSimple[8][153] = (byte)2;
	geoidSimple[8][154] = (byte)1;
	geoidSimple[8][155] = (byte)1;
	geoidSimple[8][156] = (byte)1;
	geoidSimple[8][157] = (byte)1;
	geoidSimple[8][158] = (byte)1;
	geoidSimple[8][159] = (byte)2;
	geoidSimple[8][160] = (byte)2;
	geoidSimple[8][161] = (byte)2;
	geoidSimple[8][162] = (byte)2;
	geoidSimple[8][163] = (byte)2;
	geoidSimple[8][164] = (byte)2;
	geoidSimple[8][165] = (byte)2;
	geoidSimple[8][166] = (byte)2;
	geoidSimple[8][167] = (byte)3;
	geoidSimple[8][168] = (byte)3;
	geoidSimple[8][169] = (byte)3;
	geoidSimple[8][170] = (byte)3;
	geoidSimple[8][171] = (byte)3;
	geoidSimple[8][172] = (byte)3;
	geoidSimple[8][173] = (byte)3;
	geoidSimple[8][174] = (byte)3;
	geoidSimple[8][175] = (byte)3;
	geoidSimple[8][176] = (byte)3;
	geoidSimple[8][177] = (byte)3;
	geoidSimple[8][178] = (byte)3;
	geoidSimple[8][179] = (byte)4;
	geoidSimple[8][LAT_GRID_SIZE] = (byte)4;
	geoidSimple[8][181] = (byte)4;
	geoidSimple[8][182] = (byte)4;
	geoidSimple[8][183] = (byte)4;
	geoidSimple[8][184] = (byte)4;
	geoidSimple[8][185] = (byte)3;
	geoidSimple[8][186] = (byte)3;
	geoidSimple[8][187] = (byte)3;
	geoidSimple[8][188] = (byte)3;
	geoidSimple[8][189] = (byte)3;
	geoidSimple[8][190] = (byte)3;
	geoidSimple[8][191] = (byte)3;
	geoidSimple[8][192] = (byte)3;
	geoidSimple[8][193] = (byte)3;
	geoidSimple[8][194] = (byte)3;
	geoidSimple[8][195] = (byte)3;
	geoidSimple[8][196] = (byte)3;
	geoidSimple[8][197] = (byte)3;
	geoidSimple[8][198] = (byte)3;
	geoidSimple[8][199] = (byte)3;
	geoidSimple[8][200] = (byte)3;
	geoidSimple[8][201] = (byte)3;
	geoidSimple[8][202] = (byte)3;
	geoidSimple[8][203] = (byte)3;
	geoidSimple[8][204] = (byte)3;
	geoidSimple[8][205] = (byte)2;
	geoidSimple[8][206] = (byte)2;
	geoidSimple[8][207] = (byte)2;
	geoidSimple[8][208] = (byte)2;
	geoidSimple[8][209] = (byte)2;
	geoidSimple[8][210] = (byte)2;
	geoidSimple[8][211] = (byte)2;
	geoidSimple[8][212] = (byte)2;
	geoidSimple[8][213] = (byte)2;
	geoidSimple[8][214] = (byte)1;
	geoidSimple[8][215] = (byte)1;
	geoidSimple[8][216] = (byte)1;
	geoidSimple[8][217] = (byte)1;
	geoidSimple[8][218] = (byte)1;
	geoidSimple[8][219] = (byte)1;
	geoidSimple[8][220] = (byte)1;
	geoidSimple[8][221] = (byte)2;
	geoidSimple[8][222] = (byte)2;
	geoidSimple[8][223] = (byte)2;
	geoidSimple[8][224] = (byte)2;
	geoidSimple[8][225] = (byte)2;
	geoidSimple[8][226] = (byte)2;
	geoidSimple[8][227] = (byte)2;
	geoidSimple[8][228] = (byte)2;
	geoidSimple[8][229] = (byte)2;
	geoidSimple[8][230] = (byte)2;
	geoidSimple[8][231] = (byte)2;
	geoidSimple[8][232] = (byte)2;
	geoidSimple[8][233] = (byte)2;
	geoidSimple[8][234] = (byte)2;
	geoidSimple[8][235] = (byte)2;
	geoidSimple[8][236] = (byte)2;
	geoidSimple[8][237] = (byte)2;
	geoidSimple[8][238] = (byte)2;
	geoidSimple[8][239] = (byte)2;
	geoidSimple[8][240] = (byte)2;
	geoidSimple[8][241] = (byte)2;
	geoidSimple[8][242] = (byte)2;
	geoidSimple[8][243] = (byte)2;
	geoidSimple[8][244] = (byte)2;
	geoidSimple[8][245] = (byte)2;
	geoidSimple[8][246] = (byte)3;
	geoidSimple[8][247] = (byte)3;
	geoidSimple[8][248] = (byte)3;
	geoidSimple[8][249] = (byte)4;
	geoidSimple[8][250] = (byte)4;
	geoidSimple[8][251] = (byte)4;
	geoidSimple[8][252] = (byte)5;
	geoidSimple[8][253] = (byte)5;
	geoidSimple[8][254] = (byte)5;
	geoidSimple[8][255] = (byte)6;
	geoidSimple[8][256] = (byte)6;
	geoidSimple[8][257] = (byte)7;
	geoidSimple[8][258] = (byte)7;
	geoidSimple[8][259] = (byte)8;
	geoidSimple[8][260] = (byte)8;
	geoidSimple[8][261] = (byte)8;
	geoidSimple[8][262] = (byte)9;
	geoidSimple[8][263] = (byte)9;
	geoidSimple[8][264] = (byte)9;
	geoidSimple[8][265] = (byte)10;
	geoidSimple[8][266] = (byte)10;
	geoidSimple[8][267] = (byte)11;
	geoidSimple[8][268] = (byte)11;
	geoidSimple[8][269] = (byte)12;
	geoidSimple[8][270] = (byte)12;
	geoidSimple[8][271] = (byte)12;
	geoidSimple[8][272] = (byte)13;
	geoidSimple[8][273] = (byte)14;
	geoidSimple[8][274] = (byte)14;
	geoidSimple[8][275] = (byte)16;
	geoidSimple[8][276] = (byte)17;
	geoidSimple[8][277] = (byte)17;
	geoidSimple[8][278] = (byte)18;
	geoidSimple[8][279] = (byte)18;
	geoidSimple[8][280] = (byte)18;
	geoidSimple[8][281] = (byte)19;
	geoidSimple[8][282] = (byte)19;
	geoidSimple[8][283] = (byte)19;
	geoidSimple[8][284] = (byte)20;
	geoidSimple[8][285] = (byte)20;
	geoidSimple[8][286] = (byte)20;
	geoidSimple[8][287] = (byte)19;
	geoidSimple[8][288] = (byte)19;
	geoidSimple[8][289] = (byte)18;
	geoidSimple[8][290] = (byte)18;
	geoidSimple[8][291] = (byte)17;
	geoidSimple[8][292] = (byte)17;
	geoidSimple[8][293] = (byte)16;
	geoidSimple[8][294] = (byte)15;
	geoidSimple[8][295] = (byte)14;
	geoidSimple[8][296] = (byte)14;
	geoidSimple[8][297] = (byte)14;
	geoidSimple[8][298] = (byte)14;
	geoidSimple[8][299] = (byte)14;
	geoidSimple[8][300] = (byte)15;
	geoidSimple[8][301] = (byte)16;
	geoidSimple[8][302] = (byte)17;
	geoidSimple[8][303] = (byte)17;
	geoidSimple[8][304] = (byte)18;
	geoidSimple[8][305] = (byte)18;
	geoidSimple[8][306] = (byte)19;
	geoidSimple[8][307] = (byte)19;
	geoidSimple[8][308] = (byte)20;
	geoidSimple[8][309] = (byte)20;
	geoidSimple[8][310] = (byte)21;
	geoidSimple[8][311] = (byte)22;
	geoidSimple[8][312] = (byte)22;
	geoidSimple[8][313] = (byte)23;
	geoidSimple[8][314] = (byte)24;
	geoidSimple[8][315] = (byte)25;
	geoidSimple[8][316] = (byte)27;
	geoidSimple[8][317] = (byte)28;
	geoidSimple[8][318] = (byte)29;
	geoidSimple[8][319] = (byte)30;
	geoidSimple[8][320] = (byte)31;
	geoidSimple[8][321] = (byte)32;
	geoidSimple[8][322] = (byte)32;
	geoidSimple[8][323] = (byte)33;
	geoidSimple[8][324] = (byte)33;
	geoidSimple[8][325] = (byte)33;
	geoidSimple[8][326] = (byte)33;
	geoidSimple[8][327] = (byte)33;
	geoidSimple[8][328] = (byte)32;
	geoidSimple[8][329] = (byte)32;
	geoidSimple[8][330] = (byte)32;
	geoidSimple[8][331] = (byte)32;
	geoidSimple[8][332] = (byte)32;
	geoidSimple[8][333] = (byte)32;
	geoidSimple[8][334] = (byte)31;
	geoidSimple[8][335] = (byte)30;
	geoidSimple[8][336] = (byte)30;
	geoidSimple[8][337] = (byte)29;
	geoidSimple[8][338] = (byte)29;
	geoidSimple[8][339] = (byte)28;
	geoidSimple[8][340] = (byte)28;
	geoidSimple[8][341] = (byte)28;
	geoidSimple[8][342] = (byte)28;
	geoidSimple[8][343] = (byte)29;
	geoidSimple[8][344] = (byte)29;
	geoidSimple[8][345] = (byte)30;
	geoidSimple[8][346] = (byte)30;
	geoidSimple[8][347] = (byte)31;
	geoidSimple[8][348] = (byte)31;
	geoidSimple[8][349] = (byte)32;
	geoidSimple[8][350] = (byte)32;
	geoidSimple[8][351] = (byte)32;
	geoidSimple[8][352] = (byte)31;
	geoidSimple[8][353] = (byte)30;
	geoidSimple[8][354] = (byte)29;
	geoidSimple[8][355] = (byte)29;
	geoidSimple[8][356] = (byte)28;
	geoidSimple[8][357] = (byte)29;
	geoidSimple[8][358] = (byte)29;
	geoidSimple[8][359] = (byte)30;
	}
		/** Row 9*/
	private static void init9() {
	geoidSimple[9][0] = (byte)33;
	geoidSimple[9][1] = (byte)34;
	geoidSimple[9][2] = (byte)34;
	geoidSimple[9][3] = (byte)34;
	geoidSimple[9][4] = (byte)33;
	geoidSimple[9][5] = (byte)33;
	geoidSimple[9][6] = (byte)33;
	geoidSimple[9][7] = (byte)33;
	geoidSimple[9][8] = (byte)33;
	geoidSimple[9][9] = (byte)33;
	geoidSimple[9][10] = (byte)33;
	geoidSimple[9][11] = (byte)33;
	geoidSimple[9][12] = (byte)33;
	geoidSimple[9][13] = (byte)33;
	geoidSimple[9][14] = (byte)32;
	geoidSimple[9][15] = (byte)32;
	geoidSimple[9][16] = (byte)31;
	geoidSimple[9][17] = (byte)30;
	geoidSimple[9][18] = (byte)30;
	geoidSimple[9][19] = (byte)29;
	geoidSimple[9][20] = (byte)29;
	geoidSimple[9][21] = (byte)28;
	geoidSimple[9][22] = (byte)28;
	geoidSimple[9][23] = (byte)28;
	geoidSimple[9][24] = (byte)27;
	geoidSimple[9][25] = (byte)27;
	geoidSimple[9][26] = (byte)26;
	geoidSimple[9][27] = (byte)26;
	geoidSimple[9][28] = (byte)25;
	geoidSimple[9][29] = (byte)25;
	geoidSimple[9][30] = (byte)24;
	geoidSimple[9][31] = (byte)24;
	geoidSimple[9][32] = (byte)23;
	geoidSimple[9][33] = (byte)23;
	geoidSimple[9][34] = (byte)23;
	geoidSimple[9][35] = (byte)22;
	geoidSimple[9][36] = (byte)21;
	geoidSimple[9][37] = (byte)21;
	geoidSimple[9][38] = (byte)20;
	geoidSimple[9][39] = (byte)19;
	geoidSimple[9][40] = (byte)19;
	geoidSimple[9][41] = (byte)18;
	geoidSimple[9][42] = (byte)18;
	geoidSimple[9][43] = (byte)18;
	geoidSimple[9][44] = (byte)17;
	geoidSimple[9][45] = (byte)17;
	geoidSimple[9][46] = (byte)17;
	geoidSimple[9][47] = (byte)16;
	geoidSimple[9][48] = (byte)16;
	geoidSimple[9][49] = (byte)15;
	geoidSimple[9][50] = (byte)15;
	geoidSimple[9][51] = (byte)14;
	geoidSimple[9][52] = (byte)14;
	geoidSimple[9][53] = (byte)13;
	geoidSimple[9][54] = (byte)13;
	geoidSimple[9][55] = (byte)12;
	geoidSimple[9][56] = (byte)12;
	geoidSimple[9][57] = (byte)12;
	geoidSimple[9][58] = (byte)11;
	geoidSimple[9][59] = (byte)11;
	geoidSimple[9][60] = (byte)11;
	geoidSimple[9][61] = (byte)10;
	geoidSimple[9][62] = (byte)10;
	geoidSimple[9][63] = (byte)9;
	geoidSimple[9][64] = (byte)9;
	geoidSimple[9][65] = (byte)8;
	geoidSimple[9][66] = (byte)8;
	geoidSimple[9][67] = (byte)7;
	geoidSimple[9][68] = (byte)6;
	geoidSimple[9][69] = (byte)6;
	geoidSimple[9][70] = (byte)6;
	geoidSimple[9][71] = (byte)5;
	geoidSimple[9][72] = (byte)5;
	geoidSimple[9][73] = (byte)5;
	geoidSimple[9][74] = (byte)5;
	geoidSimple[9][75] = (byte)5;
	geoidSimple[9][76] = (byte)5;
	geoidSimple[9][77] = (byte)5;
	geoidSimple[9][78] = (byte)5;
	geoidSimple[9][79] = (byte)4;
	geoidSimple[9][80] = (byte)4;
	geoidSimple[9][81] = (byte)4;
	geoidSimple[9][82] = (byte)3;
	geoidSimple[9][83] = (byte)2;
	geoidSimple[9][84] = (byte)2;
	geoidSimple[9][85] = (byte)2;
	geoidSimple[9][86] = (byte)2;
	geoidSimple[9][87] = (byte)2;
	geoidSimple[9][88] = (byte)2;
	geoidSimple[9][89] = (byte)2;
	geoidSimple[9][90] = (byte)2;
	geoidSimple[9][91] = (byte)2;
	geoidSimple[9][92] = (byte)3;
	geoidSimple[9][93] = (byte)3;
	geoidSimple[9][94] = (byte)4;
	geoidSimple[9][95] = (byte)4;
	geoidSimple[9][96] = (byte)4;
	geoidSimple[9][97] = (byte)4;
	geoidSimple[9][98] = (byte)4;
	geoidSimple[9][99] = (byte)4;
	geoidSimple[9][100] = (byte)4;
	geoidSimple[9][101] = (byte)4;
	geoidSimple[9][102] = (byte)4;
	geoidSimple[9][103] = (byte)3;
	geoidSimple[9][104] = (byte)3;
	geoidSimple[9][105] = (byte)2;
	geoidSimple[9][106] = (byte)1;
	geoidSimple[9][107] = (byte)1;
	geoidSimple[9][108] = (byte)0;
	geoidSimple[9][109] = (byte)0;
	geoidSimple[9][110] = (byte)0;
	geoidSimple[9][111] = (byte)0;
	geoidSimple[9][112] = (byte)0;
	geoidSimple[9][113] = (byte)0;
	geoidSimple[9][114] = (byte)0;
	geoidSimple[9][115] = (byte)0;
	geoidSimple[9][116] = (byte)1;
	geoidSimple[9][117] = (byte)1;
	geoidSimple[9][118] = (byte)1;
	geoidSimple[9][119] = (byte)1;
	geoidSimple[9][120] = (byte)0;
	geoidSimple[9][121] = (byte)0;
	geoidSimple[9][122] = (byte)0;
	geoidSimple[9][123] = (byte)1;
	geoidSimple[9][124] = (byte)1;
	geoidSimple[9][125] = (byte)1;
	geoidSimple[9][126] = (byte)1;
	geoidSimple[9][127] = (byte)1;
	geoidSimple[9][128] = (byte)0;
	geoidSimple[9][129] = (byte)0;
	geoidSimple[9][130] = (byte)0;
	geoidSimple[9][131] = (byte)0;
	geoidSimple[9][132] = (byte)0;
	geoidSimple[9][133] = (byte)0;
	geoidSimple[9][134] = (byte)0;
	geoidSimple[9][135] = (byte)0;
	geoidSimple[9][136] = (byte)0;
	geoidSimple[9][137] = (byte)1;
	geoidSimple[9][138] = (byte)1;
	geoidSimple[9][139] = (byte)1;
	geoidSimple[9][140] = (byte)2;
	geoidSimple[9][141] = (byte)2;
	geoidSimple[9][142] = (byte)2;
	geoidSimple[9][143] = (byte)2;
	geoidSimple[9][144] = (byte)2;
	geoidSimple[9][145] = (byte)2;
	geoidSimple[9][146] = (byte)1;
	geoidSimple[9][147] = (byte)1;
	geoidSimple[9][148] = (byte)1;
	geoidSimple[9][149] = (byte)1;
	geoidSimple[9][150] = (byte)1;
	geoidSimple[9][151] = (byte)1;
	geoidSimple[9][152] = (byte)1;
	geoidSimple[9][153] = (byte)1;
	geoidSimple[9][154] = (byte)1;
	geoidSimple[9][155] = (byte)1;
	geoidSimple[9][156] = (byte)1;
	geoidSimple[9][157] = (byte)1;
	geoidSimple[9][158] = (byte)1;
	geoidSimple[9][159] = (byte)1;
	geoidSimple[9][160] = (byte)1;
	geoidSimple[9][161] = (byte)1;
	geoidSimple[9][162] = (byte)1;
	geoidSimple[9][163] = (byte)1;
	geoidSimple[9][164] = (byte)1;
	geoidSimple[9][165] = (byte)1;
	geoidSimple[9][166] = (byte)1;
	geoidSimple[9][167] = (byte)1;
	geoidSimple[9][168] = (byte)1;
	geoidSimple[9][169] = (byte)2;
	geoidSimple[9][170] = (byte)2;
	geoidSimple[9][171] = (byte)2;
	geoidSimple[9][172] = (byte)2;
	geoidSimple[9][173] = (byte)2;
	geoidSimple[9][174] = (byte)2;
	geoidSimple[9][175] = (byte)2;
	geoidSimple[9][176] = (byte)3;
	geoidSimple[9][177] = (byte)3;
	geoidSimple[9][178] = (byte)3;
	geoidSimple[9][179] = (byte)3;
	geoidSimple[9][LAT_GRID_SIZE] = (byte)3;
	geoidSimple[9][181] = (byte)4;
	geoidSimple[9][182] = (byte)3;
	geoidSimple[9][183] = (byte)3;
	geoidSimple[9][184] = (byte)3;
	geoidSimple[9][185] = (byte)3;
	geoidSimple[9][186] = (byte)3;
	geoidSimple[9][187] = (byte)3;
	geoidSimple[9][188] = (byte)2;
	geoidSimple[9][189] = (byte)2;
	geoidSimple[9][190] = (byte)3;
	geoidSimple[9][191] = (byte)3;
	geoidSimple[9][192] = (byte)3;
	geoidSimple[9][193] = (byte)2;
	geoidSimple[9][194] = (byte)2;
	geoidSimple[9][195] = (byte)2;
	geoidSimple[9][196] = (byte)2;
	geoidSimple[9][197] = (byte)1;
	geoidSimple[9][198] = (byte)1;
	geoidSimple[9][199] = (byte)1;
	geoidSimple[9][200] = (byte)1;
	geoidSimple[9][201] = (byte)1;
	geoidSimple[9][202] = (byte)1;
	geoidSimple[9][203] = (byte)1;
	geoidSimple[9][204] = (byte)1;
	geoidSimple[9][205] = (byte)0;
	geoidSimple[9][206] = (byte)0;
	geoidSimple[9][207] = (byte)0;
	geoidSimple[9][208] = (byte)0;
	geoidSimple[9][209] = (byte)0;
	geoidSimple[9][210] = (byte)0;
	geoidSimple[9][211] = (byte)0;
	geoidSimple[9][212] = (byte)0;
	geoidSimple[9][213] = (byte)0;
	geoidSimple[9][214] = (byte)0;
	geoidSimple[9][215] = (byte)0;
	geoidSimple[9][216] = (byte)0;
	geoidSimple[9][217] = (byte)0;
	geoidSimple[9][218] = (byte)0;
	geoidSimple[9][219] = (byte)0;
	geoidSimple[9][220] = (byte)0;
	geoidSimple[9][221] = (byte)0;
	geoidSimple[9][222] = (byte)0;
	geoidSimple[9][223] = (byte)0;
	geoidSimple[9][224] = (byte)0;
	geoidSimple[9][225] = (byte)0;
	geoidSimple[9][226] = (byte)0;
	geoidSimple[9][227] = (byte)0;
	geoidSimple[9][228] = (byte)0;
	geoidSimple[9][229] = (byte)0;
	geoidSimple[9][230] = (byte)0;
	geoidSimple[9][231] = (byte)0;
	geoidSimple[9][232] = (byte)0;
	geoidSimple[9][233] = (byte)-1;
	geoidSimple[9][234] = (byte)-1;
	geoidSimple[9][235] = (byte)-1;
	geoidSimple[9][236] = (byte)0;
	geoidSimple[9][237] = (byte)0;
	geoidSimple[9][238] = (byte)0;
	geoidSimple[9][239] = (byte)0;
	geoidSimple[9][240] = (byte)0;
	geoidSimple[9][241] = (byte)0;
	geoidSimple[9][242] = (byte)1;
	geoidSimple[9][243] = (byte)1;
	geoidSimple[9][244] = (byte)2;
	geoidSimple[9][245] = (byte)2;
	geoidSimple[9][246] = (byte)3;
	geoidSimple[9][247] = (byte)4;
	geoidSimple[9][248] = (byte)4;
	geoidSimple[9][249] = (byte)5;
	geoidSimple[9][250] = (byte)5;
	geoidSimple[9][251] = (byte)5;
	geoidSimple[9][252] = (byte)5;
	geoidSimple[9][253] = (byte)5;
	geoidSimple[9][254] = (byte)5;
	geoidSimple[9][255] = (byte)4;
	geoidSimple[9][256] = (byte)4;
	geoidSimple[9][257] = (byte)4;
	geoidSimple[9][258] = (byte)4;
	geoidSimple[9][259] = (byte)4;
	geoidSimple[9][260] = (byte)5;
	geoidSimple[9][261] = (byte)5;
	geoidSimple[9][262] = (byte)6;
	geoidSimple[9][263] = (byte)6;
	geoidSimple[9][264] = (byte)7;
	geoidSimple[9][265] = (byte)9;
	geoidSimple[9][266] = (byte)10;
	geoidSimple[9][267] = (byte)11;
	geoidSimple[9][268] = (byte)11;
	geoidSimple[9][269] = (byte)11;
	geoidSimple[9][270] = (byte)10;
	geoidSimple[9][271] = (byte)10;
	geoidSimple[9][272] = (byte)10;
	geoidSimple[9][273] = (byte)10;
	geoidSimple[9][274] = (byte)10;
	geoidSimple[9][275] = (byte)11;
	geoidSimple[9][276] = (byte)12;
	geoidSimple[9][277] = (byte)13;
	geoidSimple[9][278] = (byte)14;
	geoidSimple[9][279] = (byte)15;
	geoidSimple[9][280] = (byte)15;
	geoidSimple[9][281] = (byte)16;
	geoidSimple[9][282] = (byte)16;
	geoidSimple[9][283] = (byte)16;
	geoidSimple[9][284] = (byte)16;
	geoidSimple[9][285] = (byte)17;
	geoidSimple[9][286] = (byte)16;
	geoidSimple[9][287] = (byte)16;
	geoidSimple[9][288] = (byte)15;
	geoidSimple[9][289] = (byte)13;
	geoidSimple[9][290] = (byte)12;
	geoidSimple[9][291] = (byte)10;
	geoidSimple[9][292] = (byte)10;
	geoidSimple[9][293] = (byte)10;
	geoidSimple[9][294] = (byte)10;
	geoidSimple[9][295] = (byte)11;
	geoidSimple[9][296] = (byte)12;
	geoidSimple[9][297] = (byte)13;
	geoidSimple[9][298] = (byte)14;
	geoidSimple[9][299] = (byte)15;
	geoidSimple[9][300] = (byte)17;
	geoidSimple[9][301] = (byte)18;
	geoidSimple[9][302] = (byte)19;
	geoidSimple[9][303] = (byte)21;
	geoidSimple[9][304] = (byte)22;
	geoidSimple[9][305] = (byte)22;
	geoidSimple[9][306] = (byte)23;
	geoidSimple[9][307] = (byte)24;
	geoidSimple[9][308] = (byte)25;
	geoidSimple[9][309] = (byte)25;
	geoidSimple[9][310] = (byte)26;
	geoidSimple[9][311] = (byte)27;
	geoidSimple[9][312] = (byte)27;
	geoidSimple[9][313] = (byte)28;
	geoidSimple[9][314] = (byte)29;
	geoidSimple[9][315] = (byte)30;
	geoidSimple[9][316] = (byte)30;
	geoidSimple[9][317] = (byte)31;
	geoidSimple[9][318] = (byte)32;
	geoidSimple[9][319] = (byte)33;
	geoidSimple[9][320] = (byte)33;
	geoidSimple[9][321] = (byte)34;
	geoidSimple[9][322] = (byte)34;
	geoidSimple[9][323] = (byte)34;
	geoidSimple[9][324] = (byte)35;
	geoidSimple[9][325] = (byte)35;
	geoidSimple[9][326] = (byte)35;
	geoidSimple[9][327] = (byte)35;
	geoidSimple[9][328] = (byte)36;
	geoidSimple[9][329] = (byte)36;
	geoidSimple[9][330] = (byte)36;
	geoidSimple[9][331] = (byte)35;
	geoidSimple[9][332] = (byte)34;
	geoidSimple[9][333] = (byte)33;
	geoidSimple[9][334] = (byte)32;
	geoidSimple[9][335] = (byte)32;
	geoidSimple[9][336] = (byte)31;
	geoidSimple[9][337] = (byte)31;
	geoidSimple[9][338] = (byte)31;
	geoidSimple[9][339] = (byte)31;
	geoidSimple[9][340] = (byte)31;
	geoidSimple[9][341] = (byte)31;
	geoidSimple[9][342] = (byte)31;
	geoidSimple[9][343] = (byte)31;
	geoidSimple[9][344] = (byte)31;
	geoidSimple[9][345] = (byte)31;
	geoidSimple[9][346] = (byte)31;
	geoidSimple[9][347] = (byte)31;
	geoidSimple[9][348] = (byte)31;
	geoidSimple[9][349] = (byte)31;
	geoidSimple[9][350] = (byte)32;
	geoidSimple[9][351] = (byte)32;
	geoidSimple[9][352] = (byte)33;
	geoidSimple[9][353] = (byte)33;
	geoidSimple[9][354] = (byte)33;
	geoidSimple[9][355] = (byte)32;
	geoidSimple[9][356] = (byte)32;
	geoidSimple[9][357] = (byte)32;
	geoidSimple[9][358] = (byte)32;
	geoidSimple[9][359] = (byte)33;
	}
		/** Row 10*/
	private static void init10() {
	geoidSimple[10][0] = (byte)34;
	geoidSimple[10][1] = (byte)34;
	geoidSimple[10][2] = (byte)34;
	geoidSimple[10][3] = (byte)35;
	geoidSimple[10][4] = (byte)35;
	geoidSimple[10][5] = (byte)36;
	geoidSimple[10][6] = (byte)36;
	geoidSimple[10][7] = (byte)36;
	geoidSimple[10][8] = (byte)36;
	geoidSimple[10][9] = (byte)36;
	geoidSimple[10][10] = (byte)36;
	geoidSimple[10][11] = (byte)35;
	geoidSimple[10][12] = (byte)35;
	geoidSimple[10][13] = (byte)35;
	geoidSimple[10][14] = (byte)34;
	geoidSimple[10][15] = (byte)33;
	geoidSimple[10][16] = (byte)33;
	geoidSimple[10][17] = (byte)32;
	geoidSimple[10][18] = (byte)31;
	geoidSimple[10][19] = (byte)30;
	geoidSimple[10][20] = (byte)29;
	geoidSimple[10][21] = (byte)29;
	geoidSimple[10][22] = (byte)28;
	geoidSimple[10][23] = (byte)28;
	geoidSimple[10][24] = (byte)27;
	geoidSimple[10][25] = (byte)26;
	geoidSimple[10][26] = (byte)25;
	geoidSimple[10][27] = (byte)25;
	geoidSimple[10][28] = (byte)24;
	geoidSimple[10][29] = (byte)23;
	geoidSimple[10][30] = (byte)23;
	geoidSimple[10][31] = (byte)22;
	geoidSimple[10][32] = (byte)22;
	geoidSimple[10][33] = (byte)21;
	geoidSimple[10][34] = (byte)21;
	geoidSimple[10][35] = (byte)20;
	geoidSimple[10][36] = (byte)19;
	geoidSimple[10][37] = (byte)19;
	geoidSimple[10][38] = (byte)18;
	geoidSimple[10][39] = (byte)17;
	geoidSimple[10][40] = (byte)17;
	geoidSimple[10][41] = (byte)16;
	geoidSimple[10][42] = (byte)15;
	geoidSimple[10][43] = (byte)15;
	geoidSimple[10][44] = (byte)15;
	geoidSimple[10][45] = (byte)14;
	geoidSimple[10][46] = (byte)14;
	geoidSimple[10][47] = (byte)13;
	geoidSimple[10][48] = (byte)13;
	geoidSimple[10][49] = (byte)12;
	geoidSimple[10][50] = (byte)12;
	geoidSimple[10][51] = (byte)11;
	geoidSimple[10][52] = (byte)11;
	geoidSimple[10][53] = (byte)10;
	geoidSimple[10][54] = (byte)10;
	geoidSimple[10][55] = (byte)10;
	geoidSimple[10][56] = (byte)10;
	geoidSimple[10][57] = (byte)9;
	geoidSimple[10][58] = (byte)9;
	geoidSimple[10][59] = (byte)8;
	geoidSimple[10][60] = (byte)8;
	geoidSimple[10][61] = (byte)7;
	geoidSimple[10][62] = (byte)7;
	geoidSimple[10][63] = (byte)6;
	geoidSimple[10][64] = (byte)6;
	geoidSimple[10][65] = (byte)5;
	geoidSimple[10][66] = (byte)5;
	geoidSimple[10][67] = (byte)4;
	geoidSimple[10][68] = (byte)4;
	geoidSimple[10][69] = (byte)3;
	geoidSimple[10][70] = (byte)3;
	geoidSimple[10][71] = (byte)2;
	geoidSimple[10][72] = (byte)2;
	geoidSimple[10][73] = (byte)2;
	geoidSimple[10][74] = (byte)2;
	geoidSimple[10][75] = (byte)2;
	geoidSimple[10][76] = (byte)2;
	geoidSimple[10][77] = (byte)2;
	geoidSimple[10][78] = (byte)2;
	geoidSimple[10][79] = (byte)1;
	geoidSimple[10][80] = (byte)1;
	geoidSimple[10][81] = (byte)1;
	geoidSimple[10][82] = (byte)1;
	geoidSimple[10][83] = (byte)1;
	geoidSimple[10][84] = (byte)1;
	geoidSimple[10][85] = (byte)0;
	geoidSimple[10][86] = (byte)0;
	geoidSimple[10][87] = (byte)0;
	geoidSimple[10][88] = (byte)0;
	geoidSimple[10][89] = (byte)0;
	geoidSimple[10][90] = (byte)0;
	geoidSimple[10][91] = (byte)0;
	geoidSimple[10][92] = (byte)0;
	geoidSimple[10][93] = (byte)0;
	geoidSimple[10][94] = (byte)0;
	geoidSimple[10][95] = (byte)0;
	geoidSimple[10][96] = (byte)1;
	geoidSimple[10][97] = (byte)1;
	geoidSimple[10][98] = (byte)1;
	geoidSimple[10][99] = (byte)1;
	geoidSimple[10][100] = (byte)1;
	geoidSimple[10][101] = (byte)1;
	geoidSimple[10][102] = (byte)1;
	geoidSimple[10][103] = (byte)1;
	geoidSimple[10][104] = (byte)1;
	geoidSimple[10][105] = (byte)1;
	geoidSimple[10][106] = (byte)1;
	geoidSimple[10][107] = (byte)1;
	geoidSimple[10][108] = (byte)0;
	geoidSimple[10][109] = (byte)0;
	geoidSimple[10][110] = (byte)0;
	geoidSimple[10][111] = (byte)-1;
	geoidSimple[10][112] = (byte)-1;
	geoidSimple[10][113] = (byte)-1;
	geoidSimple[10][114] = (byte)-1;
	geoidSimple[10][115] = (byte)-1;
	geoidSimple[10][116] = (byte)-1;
	geoidSimple[10][117] = (byte)-1;
	geoidSimple[10][118] = (byte)-1;
	geoidSimple[10][119] = (byte)-1;
	geoidSimple[10][120] = (byte)-1;
	geoidSimple[10][121] = (byte)0;
	geoidSimple[10][122] = (byte)0;
	geoidSimple[10][123] = (byte)0;
	geoidSimple[10][124] = (byte)0;
	geoidSimple[10][125] = (byte)-1;
	geoidSimple[10][126] = (byte)-1;
	geoidSimple[10][127] = (byte)-1;
	geoidSimple[10][128] = (byte)-1;
	geoidSimple[10][129] = (byte)-1;
	geoidSimple[10][130] = (byte)-1;
	geoidSimple[10][131] = (byte)-1;
	geoidSimple[10][132] = (byte)-1;
	geoidSimple[10][133] = (byte)-1;
	geoidSimple[10][134] = (byte)-1;
	geoidSimple[10][135] = (byte)-1;
	geoidSimple[10][136] = (byte)-1;
	geoidSimple[10][137] = (byte)-1;
	geoidSimple[10][138] = (byte)-1;
	geoidSimple[10][139] = (byte)0;
	geoidSimple[10][140] = (byte)0;
	geoidSimple[10][141] = (byte)1;
	geoidSimple[10][142] = (byte)2;
	geoidSimple[10][143] = (byte)2;
	geoidSimple[10][144] = (byte)2;
	geoidSimple[10][145] = (byte)2;
	geoidSimple[10][146] = (byte)2;
	geoidSimple[10][147] = (byte)3;
	geoidSimple[10][148] = (byte)3;
	geoidSimple[10][149] = (byte)3;
	geoidSimple[10][150] = (byte)3;
	geoidSimple[10][151] = (byte)3;
	geoidSimple[10][152] = (byte)3;
	geoidSimple[10][153] = (byte)2;
	geoidSimple[10][154] = (byte)2;
	geoidSimple[10][155] = (byte)2;
	geoidSimple[10][156] = (byte)2;
	geoidSimple[10][157] = (byte)2;
	geoidSimple[10][158] = (byte)1;
	geoidSimple[10][159] = (byte)1;
	geoidSimple[10][160] = (byte)1;
	geoidSimple[10][161] = (byte)0;
	geoidSimple[10][162] = (byte)0;
	geoidSimple[10][163] = (byte)0;
	geoidSimple[10][164] = (byte)0;
	geoidSimple[10][165] = (byte)0;
	geoidSimple[10][166] = (byte)0;
	geoidSimple[10][167] = (byte)0;
	geoidSimple[10][168] = (byte)1;
	geoidSimple[10][169] = (byte)1;
	geoidSimple[10][170] = (byte)1;
	geoidSimple[10][171] = (byte)1;
	geoidSimple[10][172] = (byte)1;
	geoidSimple[10][173] = (byte)1;
	geoidSimple[10][174] = (byte)1;
	geoidSimple[10][175] = (byte)2;
	geoidSimple[10][176] = (byte)2;
	geoidSimple[10][177] = (byte)3;
	geoidSimple[10][178] = (byte)3;
	geoidSimple[10][179] = (byte)3;
	geoidSimple[10][LAT_GRID_SIZE] = (byte)4;
	geoidSimple[10][181] = (byte)4;
	geoidSimple[10][182] = (byte)4;
	geoidSimple[10][183] = (byte)3;
	geoidSimple[10][184] = (byte)3;
	geoidSimple[10][185] = (byte)3;
	geoidSimple[10][186] = (byte)3;
	geoidSimple[10][187] = (byte)2;
	geoidSimple[10][188] = (byte)2;
	geoidSimple[10][189] = (byte)2;
	geoidSimple[10][190] = (byte)2;
	geoidSimple[10][191] = (byte)2;
	geoidSimple[10][192] = (byte)2;
	geoidSimple[10][193] = (byte)2;
	geoidSimple[10][194] = (byte)2;
	geoidSimple[10][195] = (byte)1;
	geoidSimple[10][196] = (byte)1;
	geoidSimple[10][197] = (byte)1;
	geoidSimple[10][198] = (byte)0;
	geoidSimple[10][199] = (byte)0;
	geoidSimple[10][200] = (byte)0;
	geoidSimple[10][201] = (byte)0;
	geoidSimple[10][202] = (byte)0;
	geoidSimple[10][203] = (byte)0;
	geoidSimple[10][204] = (byte)0;
	geoidSimple[10][205] = (byte)0;
	geoidSimple[10][206] = (byte)0;
	geoidSimple[10][207] = (byte)0;
	geoidSimple[10][208] = (byte)0;
	geoidSimple[10][209] = (byte)0;
	geoidSimple[10][210] = (byte)0;
	geoidSimple[10][211] = (byte)0;
	geoidSimple[10][212] = (byte)0;
	geoidSimple[10][213] = (byte)0;
	geoidSimple[10][214] = (byte)-1;
	geoidSimple[10][215] = (byte)-1;
	geoidSimple[10][216] = (byte)-1;
	geoidSimple[10][217] = (byte)-1;
	geoidSimple[10][218] = (byte)-2;
	geoidSimple[10][219] = (byte)-2;
	geoidSimple[10][220] = (byte)-2;
	geoidSimple[10][221] = (byte)-2;
	geoidSimple[10][222] = (byte)-2;
	geoidSimple[10][223] = (byte)-2;
	geoidSimple[10][224] = (byte)-2;
	geoidSimple[10][225] = (byte)-2;
	geoidSimple[10][226] = (byte)-2;
	geoidSimple[10][227] = (byte)-3;
	geoidSimple[10][228] = (byte)-3;
	geoidSimple[10][229] = (byte)-3;
	geoidSimple[10][230] = (byte)-3;
	geoidSimple[10][231] = (byte)-3;
	geoidSimple[10][232] = (byte)-3;
	geoidSimple[10][233] = (byte)-3;
	geoidSimple[10][234] = (byte)-3;
	geoidSimple[10][235] = (byte)-3;
	geoidSimple[10][236] = (byte)-3;
	geoidSimple[10][237] = (byte)-2;
	geoidSimple[10][238] = (byte)-2;
	geoidSimple[10][239] = (byte)-1;
	geoidSimple[10][240] = (byte)0;
	geoidSimple[10][241] = (byte)0;
	geoidSimple[10][242] = (byte)0;
	geoidSimple[10][243] = (byte)1;
	geoidSimple[10][244] = (byte)2;
	geoidSimple[10][245] = (byte)2;
	geoidSimple[10][246] = (byte)3;
	geoidSimple[10][247] = (byte)2;
	geoidSimple[10][248] = (byte)2;
	geoidSimple[10][249] = (byte)1;
	geoidSimple[10][250] = (byte)1;
	geoidSimple[10][251] = (byte)1;
	geoidSimple[10][252] = (byte)0;
	geoidSimple[10][253] = (byte)0;
	geoidSimple[10][254] = (byte)0;
	geoidSimple[10][255] = (byte)0;
	geoidSimple[10][256] = (byte)0;
	geoidSimple[10][257] = (byte)1;
	geoidSimple[10][258] = (byte)1;
	geoidSimple[10][259] = (byte)2;
	geoidSimple[10][260] = (byte)2;
	geoidSimple[10][261] = (byte)3;
	geoidSimple[10][262] = (byte)3;
	geoidSimple[10][263] = (byte)4;
	geoidSimple[10][264] = (byte)5;
	geoidSimple[10][265] = (byte)6;
	geoidSimple[10][266] = (byte)7;
	geoidSimple[10][267] = (byte)8;
	geoidSimple[10][268] = (byte)8;
	geoidSimple[10][269] = (byte)9;
	geoidSimple[10][270] = (byte)8;
	geoidSimple[10][271] = (byte)8;
	geoidSimple[10][272] = (byte)7;
	geoidSimple[10][273] = (byte)6;
	geoidSimple[10][274] = (byte)6;
	geoidSimple[10][275] = (byte)7;
	geoidSimple[10][276] = (byte)8;
	geoidSimple[10][277] = (byte)9;
	geoidSimple[10][278] = (byte)10;
	geoidSimple[10][279] = (byte)11;
	geoidSimple[10][280] = (byte)12;
	geoidSimple[10][281] = (byte)12;
	geoidSimple[10][282] = (byte)11;
	geoidSimple[10][283] = (byte)11;
	geoidSimple[10][284] = (byte)10;
	geoidSimple[10][285] = (byte)9;
	geoidSimple[10][286] = (byte)8;
	geoidSimple[10][287] = (byte)7;
	geoidSimple[10][288] = (byte)7;
	geoidSimple[10][289] = (byte)7;
	geoidSimple[10][290] = (byte)7;
	geoidSimple[10][291] = (byte)8;
	geoidSimple[10][292] = (byte)9;
	geoidSimple[10][293] = (byte)10;
	geoidSimple[10][294] = (byte)11;
	geoidSimple[10][295] = (byte)12;
	geoidSimple[10][296] = (byte)14;
	geoidSimple[10][297] = (byte)16;
	geoidSimple[10][298] = (byte)17;
	geoidSimple[10][299] = (byte)19;
	geoidSimple[10][300] = (byte)20;
	geoidSimple[10][301] = (byte)21;
	geoidSimple[10][302] = (byte)22;
	geoidSimple[10][303] = (byte)23;
	geoidSimple[10][304] = (byte)24;
	geoidSimple[10][305] = (byte)25;
	geoidSimple[10][306] = (byte)26;
	geoidSimple[10][307] = (byte)27;
	geoidSimple[10][308] = (byte)27;
	geoidSimple[10][309] = (byte)28;
	geoidSimple[10][310] = (byte)28;
	geoidSimple[10][311] = (byte)29;
	geoidSimple[10][312] = (byte)29;
	geoidSimple[10][313] = (byte)30;
	geoidSimple[10][314] = (byte)31;
	geoidSimple[10][315] = (byte)31;
	geoidSimple[10][316] = (byte)32;
	geoidSimple[10][317] = (byte)32;
	geoidSimple[10][318] = (byte)33;
	geoidSimple[10][319] = (byte)33;
	geoidSimple[10][320] = (byte)34;
	geoidSimple[10][321] = (byte)34;
	geoidSimple[10][322] = (byte)35;
	geoidSimple[10][323] = (byte)35;
	geoidSimple[10][324] = (byte)36;
	geoidSimple[10][325] = (byte)36;
	geoidSimple[10][326] = (byte)36;
	geoidSimple[10][327] = (byte)36;
	geoidSimple[10][328] = (byte)36;
	geoidSimple[10][329] = (byte)36;
	geoidSimple[10][330] = (byte)35;
	geoidSimple[10][331] = (byte)34;
	geoidSimple[10][332] = (byte)34;
	geoidSimple[10][333] = (byte)33;
	geoidSimple[10][334] = (byte)32;
	geoidSimple[10][335] = (byte)31;
	geoidSimple[10][336] = (byte)31;
	geoidSimple[10][337] = (byte)30;
	geoidSimple[10][338] = (byte)30;
	geoidSimple[10][339] = (byte)30;
	geoidSimple[10][340] = (byte)30;
	geoidSimple[10][341] = (byte)30;
	geoidSimple[10][342] = (byte)30;
	geoidSimple[10][343] = (byte)30;
	geoidSimple[10][344] = (byte)31;
	geoidSimple[10][345] = (byte)31;
	geoidSimple[10][346] = (byte)31;
	geoidSimple[10][347] = (byte)31;
	geoidSimple[10][348] = (byte)31;
	geoidSimple[10][349] = (byte)32;
	geoidSimple[10][350] = (byte)33;
	geoidSimple[10][351] = (byte)34;
	geoidSimple[10][352] = (byte)35;
	geoidSimple[10][353] = (byte)35;
	geoidSimple[10][354] = (byte)35;
	geoidSimple[10][355] = (byte)35;
	geoidSimple[10][356] = (byte)34;
	geoidSimple[10][357] = (byte)34;
	geoidSimple[10][358] = (byte)34;
	geoidSimple[10][359] = (byte)34;
	}
		/** Row 11*/
	private static void init11() {
	geoidSimple[11][0] = (byte)37;
	geoidSimple[11][1] = (byte)37;
	geoidSimple[11][2] = (byte)38;
	geoidSimple[11][3] = (byte)38;
	geoidSimple[11][4] = (byte)38;
	geoidSimple[11][5] = (byte)38;
	geoidSimple[11][6] = (byte)38;
	geoidSimple[11][7] = (byte)38;
	geoidSimple[11][8] = (byte)38;
	geoidSimple[11][9] = (byte)38;
	geoidSimple[11][10] = (byte)38;
	geoidSimple[11][11] = (byte)37;
	geoidSimple[11][12] = (byte)35;
	geoidSimple[11][13] = (byte)34;
	geoidSimple[11][14] = (byte)33;
	geoidSimple[11][15] = (byte)33;
	geoidSimple[11][16] = (byte)33;
	geoidSimple[11][17] = (byte)33;
	geoidSimple[11][18] = (byte)32;
	geoidSimple[11][19] = (byte)30;
	geoidSimple[11][20] = (byte)29;
	geoidSimple[11][21] = (byte)29;
	geoidSimple[11][22] = (byte)28;
	geoidSimple[11][23] = (byte)27;
	geoidSimple[11][24] = (byte)26;
	geoidSimple[11][25] = (byte)25;
	geoidSimple[11][26] = (byte)24;
	geoidSimple[11][27] = (byte)23;
	geoidSimple[11][28] = (byte)22;
	geoidSimple[11][29] = (byte)22;
	geoidSimple[11][30] = (byte)21;
	geoidSimple[11][31] = (byte)20;
	geoidSimple[11][32] = (byte)19;
	geoidSimple[11][33] = (byte)19;
	geoidSimple[11][34] = (byte)18;
	geoidSimple[11][35] = (byte)18;
	geoidSimple[11][36] = (byte)17;
	geoidSimple[11][37] = (byte)17;
	geoidSimple[11][38] = (byte)16;
	geoidSimple[11][39] = (byte)15;
	geoidSimple[11][40] = (byte)15;
	geoidSimple[11][41] = (byte)14;
	geoidSimple[11][42] = (byte)13;
	geoidSimple[11][43] = (byte)13;
	geoidSimple[11][44] = (byte)13;
	geoidSimple[11][45] = (byte)12;
	geoidSimple[11][46] = (byte)12;
	geoidSimple[11][47] = (byte)11;
	geoidSimple[11][48] = (byte)10;
	geoidSimple[11][49] = (byte)10;
	geoidSimple[11][50] = (byte)9;
	geoidSimple[11][51] = (byte)8;
	geoidSimple[11][52] = (byte)8;
	geoidSimple[11][53] = (byte)7;
	geoidSimple[11][54] = (byte)7;
	geoidSimple[11][55] = (byte)7;
	geoidSimple[11][56] = (byte)6;
	geoidSimple[11][57] = (byte)6;
	geoidSimple[11][58] = (byte)6;
	geoidSimple[11][59] = (byte)5;
	geoidSimple[11][60] = (byte)5;
	geoidSimple[11][61] = (byte)5;
	geoidSimple[11][62] = (byte)4;
	geoidSimple[11][63] = (byte)4;
	geoidSimple[11][64] = (byte)3;
	geoidSimple[11][65] = (byte)2;
	geoidSimple[11][66] = (byte)2;
	geoidSimple[11][67] = (byte)2;
	geoidSimple[11][68] = (byte)1;
	geoidSimple[11][69] = (byte)1;
	geoidSimple[11][70] = (byte)0;
	geoidSimple[11][71] = (byte)0;
	geoidSimple[11][72] = (byte)0;
	geoidSimple[11][73] = (byte)0;
	geoidSimple[11][74] = (byte)0;
	geoidSimple[11][75] = (byte)0;
	geoidSimple[11][76] = (byte)0;
	geoidSimple[11][77] = (byte)0;
	geoidSimple[11][78] = (byte)0;
	geoidSimple[11][79] = (byte)0;
	geoidSimple[11][80] = (byte)0;
	geoidSimple[11][81] = (byte)-1;
	geoidSimple[11][82] = (byte)-1;
	geoidSimple[11][83] = (byte)-1;
	geoidSimple[11][84] = (byte)-1;
	geoidSimple[11][85] = (byte)-1;
	geoidSimple[11][86] = (byte)-1;
	geoidSimple[11][87] = (byte)-1;
	geoidSimple[11][88] = (byte)-2;
	geoidSimple[11][89] = (byte)-2;
	geoidSimple[11][90] = (byte)-2;
	geoidSimple[11][91] = (byte)-2;
	geoidSimple[11][92] = (byte)-2;
	geoidSimple[11][93] = (byte)-2;
	geoidSimple[11][94] = (byte)-2;
	geoidSimple[11][95] = (byte)-2;
	geoidSimple[11][96] = (byte)-3;
	geoidSimple[11][97] = (byte)-3;
	geoidSimple[11][98] = (byte)-3;
	geoidSimple[11][99] = (byte)-3;
	geoidSimple[11][100] = (byte)-2;
	geoidSimple[11][101] = (byte)-1;
	geoidSimple[11][102] = (byte)0;
	geoidSimple[11][103] = (byte)0;
	geoidSimple[11][104] = (byte)0;
	geoidSimple[11][105] = (byte)0;
	geoidSimple[11][106] = (byte)0;
	geoidSimple[11][107] = (byte)0;
	geoidSimple[11][108] = (byte)0;
	geoidSimple[11][109] = (byte)0;
	geoidSimple[11][110] = (byte)0;
	geoidSimple[11][111] = (byte)-1;
	geoidSimple[11][112] = (byte)-2;
	geoidSimple[11][113] = (byte)-2;
	geoidSimple[11][114] = (byte)-2;
	geoidSimple[11][115] = (byte)-2;
	geoidSimple[11][116] = (byte)-2;
	geoidSimple[11][117] = (byte)-2;
	geoidSimple[11][118] = (byte)-2;
	geoidSimple[11][119] = (byte)-2;
	geoidSimple[11][120] = (byte)-2;
	geoidSimple[11][121] = (byte)-2;
	geoidSimple[11][122] = (byte)-2;
	geoidSimple[11][123] = (byte)-2;
	geoidSimple[11][124] = (byte)-2;
	geoidSimple[11][125] = (byte)-2;
	geoidSimple[11][126] = (byte)-2;
	geoidSimple[11][127] = (byte)-2;
	geoidSimple[11][128] = (byte)-2;
	geoidSimple[11][129] = (byte)-1;
	geoidSimple[11][130] = (byte)-1;
	geoidSimple[11][131] = (byte)0;
	geoidSimple[11][132] = (byte)0;
	geoidSimple[11][133] = (byte)0;
	geoidSimple[11][134] = (byte)0;
	geoidSimple[11][135] = (byte)0;
	geoidSimple[11][136] = (byte)0;
	geoidSimple[11][137] = (byte)1;
	geoidSimple[11][138] = (byte)1;
	geoidSimple[11][139] = (byte)2;
	geoidSimple[11][140] = (byte)2;
	geoidSimple[11][141] = (byte)2;
	geoidSimple[11][142] = (byte)2;
	geoidSimple[11][143] = (byte)2;
	geoidSimple[11][144] = (byte)2;
	geoidSimple[11][145] = (byte)2;
	geoidSimple[11][146] = (byte)2;
	geoidSimple[11][147] = (byte)2;
	geoidSimple[11][148] = (byte)2;
	geoidSimple[11][149] = (byte)2;
	geoidSimple[11][150] = (byte)2;
	geoidSimple[11][151] = (byte)2;
	geoidSimple[11][152] = (byte)2;
	geoidSimple[11][153] = (byte)2;
	geoidSimple[11][154] = (byte)2;
	geoidSimple[11][155] = (byte)2;
	geoidSimple[11][156] = (byte)3;
	geoidSimple[11][157] = (byte)3;
	geoidSimple[11][158] = (byte)3;
	geoidSimple[11][159] = (byte)3;
	geoidSimple[11][160] = (byte)2;
	geoidSimple[11][161] = (byte)2;
	geoidSimple[11][162] = (byte)2;
	geoidSimple[11][163] = (byte)2;
	geoidSimple[11][164] = (byte)2;
	geoidSimple[11][165] = (byte)2;
	geoidSimple[11][166] = (byte)2;
	geoidSimple[11][167] = (byte)1;
	geoidSimple[11][168] = (byte)1;
	geoidSimple[11][169] = (byte)1;
	geoidSimple[11][170] = (byte)1;
	geoidSimple[11][171] = (byte)1;
	geoidSimple[11][172] = (byte)1;
	geoidSimple[11][173] = (byte)1;
	geoidSimple[11][174] = (byte)1;
	geoidSimple[11][175] = (byte)1;
	geoidSimple[11][176] = (byte)2;
	geoidSimple[11][177] = (byte)2;
	geoidSimple[11][178] = (byte)2;
	geoidSimple[11][179] = (byte)3;
	geoidSimple[11][LAT_GRID_SIZE] = (byte)3;
	geoidSimple[11][181] = (byte)3;
	geoidSimple[11][182] = (byte)3;
	geoidSimple[11][183] = (byte)3;
	geoidSimple[11][184] = (byte)2;
	geoidSimple[11][185] = (byte)2;
	geoidSimple[11][186] = (byte)2;
	geoidSimple[11][187] = (byte)2;
	geoidSimple[11][188] = (byte)2;
	geoidSimple[11][189] = (byte)2;
	geoidSimple[11][190] = (byte)2;
	geoidSimple[11][191] = (byte)2;
	geoidSimple[11][192] = (byte)3;
	geoidSimple[11][193] = (byte)3;
	geoidSimple[11][194] = (byte)3;
	geoidSimple[11][195] = (byte)3;
	geoidSimple[11][196] = (byte)3;
	geoidSimple[11][197] = (byte)2;
	geoidSimple[11][198] = (byte)2;
	geoidSimple[11][199] = (byte)1;
	geoidSimple[11][200] = (byte)0;
	geoidSimple[11][201] = (byte)0;
	geoidSimple[11][202] = (byte)0;
	geoidSimple[11][203] = (byte)-1;
	geoidSimple[11][204] = (byte)-1;
	geoidSimple[11][205] = (byte)-1;
	geoidSimple[11][206] = (byte)-1;
	geoidSimple[11][207] = (byte)-2;
	geoidSimple[11][208] = (byte)-2;
	geoidSimple[11][209] = (byte)-2;
	geoidSimple[11][210] = (byte)-2;
	geoidSimple[11][211] = (byte)-2;
	geoidSimple[11][212] = (byte)-2;
	geoidSimple[11][213] = (byte)-2;
	geoidSimple[11][214] = (byte)-3;
	geoidSimple[11][215] = (byte)-3;
	geoidSimple[11][216] = (byte)-3;
	geoidSimple[11][217] = (byte)-3;
	geoidSimple[11][218] = (byte)-4;
	geoidSimple[11][219] = (byte)-4;
	geoidSimple[11][220] = (byte)-4;
	geoidSimple[11][221] = (byte)-4;
	geoidSimple[11][222] = (byte)-4;
	geoidSimple[11][223] = (byte)-4;
	geoidSimple[11][224] = (byte)-4;
	geoidSimple[11][225] = (byte)-4;
	geoidSimple[11][226] = (byte)-4;
	geoidSimple[11][227] = (byte)-4;
	geoidSimple[11][228] = (byte)-4;
	geoidSimple[11][229] = (byte)-4;
	geoidSimple[11][230] = (byte)-4;
	geoidSimple[11][231] = (byte)-4;
	geoidSimple[11][232] = (byte)-3;
	geoidSimple[11][233] = (byte)-3;
	geoidSimple[11][234] = (byte)-3;
	geoidSimple[11][235] = (byte)-3;
	geoidSimple[11][236] = (byte)-3;
	geoidSimple[11][237] = (byte)-3;
	geoidSimple[11][238] = (byte)-2;
	geoidSimple[11][239] = (byte)-2;
	geoidSimple[11][240] = (byte)-1;
	geoidSimple[11][241] = (byte)-1;
	geoidSimple[11][242] = (byte)-1;
	geoidSimple[11][243] = (byte)0;
	geoidSimple[11][244] = (byte)0;
	geoidSimple[11][245] = (byte)0;
	geoidSimple[11][246] = (byte)-1;
	geoidSimple[11][247] = (byte)-1;
	geoidSimple[11][248] = (byte)-1;
	geoidSimple[11][249] = (byte)-2;
	geoidSimple[11][250] = (byte)-2;
	geoidSimple[11][251] = (byte)-2;
	geoidSimple[11][252] = (byte)-2;
	geoidSimple[11][253] = (byte)-2;
	geoidSimple[11][254] = (byte)-1;
	geoidSimple[11][255] = (byte)-1;
	geoidSimple[11][256] = (byte)0;
	geoidSimple[11][257] = (byte)0;
	geoidSimple[11][258] = (byte)0;
	geoidSimple[11][259] = (byte)-1;
	geoidSimple[11][260] = (byte)-1;
	geoidSimple[11][261] = (byte)0;
	geoidSimple[11][262] = (byte)0;
	geoidSimple[11][263] = (byte)0;
	geoidSimple[11][264] = (byte)0;
	geoidSimple[11][265] = (byte)0;
	geoidSimple[11][266] = (byte)1;
	geoidSimple[11][267] = (byte)2;
	geoidSimple[11][268] = (byte)3;
	geoidSimple[11][269] = (byte)3;
	geoidSimple[11][270] = (byte)3;
	geoidSimple[11][271] = (byte)3;
	geoidSimple[11][272] = (byte)3;
	geoidSimple[11][273] = (byte)3;
	geoidSimple[11][274] = (byte)4;
	geoidSimple[11][275] = (byte)5;
	geoidSimple[11][276] = (byte)6;
	geoidSimple[11][277] = (byte)8;
	geoidSimple[11][278] = (byte)9;
	geoidSimple[11][279] = (byte)10;
	geoidSimple[11][280] = (byte)11;
	geoidSimple[11][281] = (byte)11;
	geoidSimple[11][282] = (byte)10;
	geoidSimple[11][283] = (byte)9;
	geoidSimple[11][284] = (byte)8;
	geoidSimple[11][285] = (byte)8;
	geoidSimple[11][286] = (byte)8;
	geoidSimple[11][287] = (byte)8;
	geoidSimple[11][288] = (byte)10;
	geoidSimple[11][289] = (byte)11;
	geoidSimple[11][290] = (byte)13;
	geoidSimple[11][291] = (byte)14;
	geoidSimple[11][292] = (byte)16;
	geoidSimple[11][293] = (byte)17;
	geoidSimple[11][294] = (byte)18;
	geoidSimple[11][295] = (byte)19;
	geoidSimple[11][296] = (byte)21;
	geoidSimple[11][297] = (byte)22;
	geoidSimple[11][298] = (byte)23;
	geoidSimple[11][299] = (byte)24;
	geoidSimple[11][300] = (byte)24;
	geoidSimple[11][301] = (byte)25;
	geoidSimple[11][302] = (byte)26;
	geoidSimple[11][303] = (byte)27;
	geoidSimple[11][304] = (byte)27;
	geoidSimple[11][305] = (byte)27;
	geoidSimple[11][306] = (byte)28;
	geoidSimple[11][307] = (byte)28;
	geoidSimple[11][308] = (byte)29;
	geoidSimple[11][309] = (byte)29;
	geoidSimple[11][310] = (byte)29;
	geoidSimple[11][311] = (byte)30;
	geoidSimple[11][312] = (byte)30;
	geoidSimple[11][313] = (byte)31;
	geoidSimple[11][314] = (byte)31;
	geoidSimple[11][315] = (byte)32;
	geoidSimple[11][316] = (byte)32;
	geoidSimple[11][317] = (byte)33;
	geoidSimple[11][318] = (byte)33;
	geoidSimple[11][319] = (byte)34;
	geoidSimple[11][320] = (byte)34;
	geoidSimple[11][321] = (byte)34;
	geoidSimple[11][322] = (byte)35;
	geoidSimple[11][323] = (byte)35;
	geoidSimple[11][324] = (byte)36;
	geoidSimple[11][325] = (byte)36;
	geoidSimple[11][326] = (byte)37;
	geoidSimple[11][327] = (byte)37;
	geoidSimple[11][328] = (byte)37;
	geoidSimple[11][329] = (byte)37;
	geoidSimple[11][330] = (byte)36;
	geoidSimple[11][331] = (byte)35;
	geoidSimple[11][332] = (byte)34;
	geoidSimple[11][333] = (byte)33;
	geoidSimple[11][334] = (byte)32;
	geoidSimple[11][335] = (byte)31;
	geoidSimple[11][336] = (byte)30;
	geoidSimple[11][337] = (byte)29;
	geoidSimple[11][338] = (byte)28;
	geoidSimple[11][339] = (byte)28;
	geoidSimple[11][340] = (byte)28;
	geoidSimple[11][341] = (byte)29;
	geoidSimple[11][342] = (byte)29;
	geoidSimple[11][343] = (byte)30;
	geoidSimple[11][344] = (byte)30;
	geoidSimple[11][345] = (byte)30;
	geoidSimple[11][346] = (byte)30;
	geoidSimple[11][347] = (byte)31;
	geoidSimple[11][348] = (byte)32;
	geoidSimple[11][349] = (byte)33;
	geoidSimple[11][350] = (byte)33;
	geoidSimple[11][351] = (byte)34;
	geoidSimple[11][352] = (byte)35;
	geoidSimple[11][353] = (byte)37;
	geoidSimple[11][354] = (byte)38;
	geoidSimple[11][355] = (byte)38;
	geoidSimple[11][356] = (byte)37;
	geoidSimple[11][357] = (byte)36;
	geoidSimple[11][358] = (byte)36;
	geoidSimple[11][359] = (byte)36;
	}
		/** Row 12*/
	private static void init12() {
	geoidSimple[12][0] = (byte)39;
	geoidSimple[12][1] = (byte)39;
	geoidSimple[12][2] = (byte)39;
	geoidSimple[12][3] = (byte)40;
	geoidSimple[12][4] = (byte)40;
	geoidSimple[12][5] = (byte)40;
	geoidSimple[12][6] = (byte)40;
	geoidSimple[12][7] = (byte)39;
	geoidSimple[12][8] = (byte)39;
	geoidSimple[12][9] = (byte)39;
	geoidSimple[12][10] = (byte)39;
	geoidSimple[12][11] = (byte)38;
	geoidSimple[12][12] = (byte)37;
	geoidSimple[12][13] = (byte)35;
	geoidSimple[12][14] = (byte)34;
	geoidSimple[12][15] = (byte)32;
	geoidSimple[12][16] = (byte)31;
	geoidSimple[12][17] = (byte)31;
	geoidSimple[12][18] = (byte)30;
	geoidSimple[12][19] = (byte)29;
	geoidSimple[12][20] = (byte)29;
	geoidSimple[12][21] = (byte)28;
	geoidSimple[12][22] = (byte)28;
	geoidSimple[12][23] = (byte)27;
	geoidSimple[12][24] = (byte)26;
	geoidSimple[12][25] = (byte)25;
	geoidSimple[12][26] = (byte)24;
	geoidSimple[12][27] = (byte)23;
	geoidSimple[12][28] = (byte)22;
	geoidSimple[12][29] = (byte)21;
	geoidSimple[12][30] = (byte)20;
	geoidSimple[12][31] = (byte)19;
	geoidSimple[12][32] = (byte)18;
	geoidSimple[12][33] = (byte)18;
	geoidSimple[12][34] = (byte)17;
	geoidSimple[12][35] = (byte)16;
	geoidSimple[12][36] = (byte)16;
	geoidSimple[12][37] = (byte)15;
	geoidSimple[12][38] = (byte)14;
	geoidSimple[12][39] = (byte)14;
	geoidSimple[12][40] = (byte)13;
	geoidSimple[12][41] = (byte)12;
	geoidSimple[12][42] = (byte)12;
	geoidSimple[12][43] = (byte)11;
	geoidSimple[12][44] = (byte)11;
	geoidSimple[12][45] = (byte)10;
	geoidSimple[12][46] = (byte)10;
	geoidSimple[12][47] = (byte)9;
	geoidSimple[12][48] = (byte)8;
	geoidSimple[12][49] = (byte)8;
	geoidSimple[12][50] = (byte)7;
	geoidSimple[12][51] = (byte)7;
	geoidSimple[12][52] = (byte)6;
	geoidSimple[12][53] = (byte)6;
	geoidSimple[12][54] = (byte)5;
	geoidSimple[12][55] = (byte)5;
	geoidSimple[12][56] = (byte)5;
	geoidSimple[12][57] = (byte)4;
	geoidSimple[12][58] = (byte)3;
	geoidSimple[12][59] = (byte)3;
	geoidSimple[12][60] = (byte)2;
	geoidSimple[12][61] = (byte)2;
	geoidSimple[12][62] = (byte)2;
	geoidSimple[12][63] = (byte)2;
	geoidSimple[12][64] = (byte)1;
	geoidSimple[12][65] = (byte)1;
	geoidSimple[12][66] = (byte)1;
	geoidSimple[12][67] = (byte)0;
	geoidSimple[12][68] = (byte)0;
	geoidSimple[12][69] = (byte)0;
	geoidSimple[12][70] = (byte)-1;
	geoidSimple[12][71] = (byte)-1;
	geoidSimple[12][72] = (byte)-1;
	geoidSimple[12][73] = (byte)-1;
	geoidSimple[12][74] = (byte)-1;
	geoidSimple[12][75] = (byte)-2;
	geoidSimple[12][76] = (byte)-2;
	geoidSimple[12][77] = (byte)-2;
	geoidSimple[12][78] = (byte)-2;
	geoidSimple[12][79] = (byte)-3;
	geoidSimple[12][80] = (byte)-3;
	geoidSimple[12][81] = (byte)-3;
	geoidSimple[12][82] = (byte)-4;
	geoidSimple[12][83] = (byte)-4;
	geoidSimple[12][84] = (byte)-4;
	geoidSimple[12][85] = (byte)-4;
	geoidSimple[12][86] = (byte)-4;
	geoidSimple[12][87] = (byte)-4;
	geoidSimple[12][88] = (byte)-4;
	geoidSimple[12][89] = (byte)-4;
	geoidSimple[12][90] = (byte)-4;
	geoidSimple[12][91] = (byte)-4;
	geoidSimple[12][92] = (byte)-4;
	geoidSimple[12][93] = (byte)-4;
	geoidSimple[12][94] = (byte)-5;
	geoidSimple[12][95] = (byte)-5;
	geoidSimple[12][96] = (byte)-5;
	geoidSimple[12][97] = (byte)-5;
	geoidSimple[12][98] = (byte)-5;
	geoidSimple[12][99] = (byte)-5;
	geoidSimple[12][100] = (byte)-5;
	geoidSimple[12][101] = (byte)-4;
	geoidSimple[12][102] = (byte)-4;
	geoidSimple[12][103] = (byte)-3;
	geoidSimple[12][104] = (byte)-3;
	geoidSimple[12][105] = (byte)-2;
	geoidSimple[12][106] = (byte)-2;
	geoidSimple[12][107] = (byte)-2;
	geoidSimple[12][108] = (byte)-2;
	geoidSimple[12][109] = (byte)-2;
	geoidSimple[12][110] = (byte)-2;
	geoidSimple[12][111] = (byte)-1;
	geoidSimple[12][112] = (byte)-1;
	geoidSimple[12][113] = (byte)-1;
	geoidSimple[12][114] = (byte)-1;
	geoidSimple[12][115] = (byte)-1;
	geoidSimple[12][116] = (byte)-1;
	geoidSimple[12][117] = (byte)-1;
	geoidSimple[12][118] = (byte)-1;
	geoidSimple[12][119] = (byte)-1;
	geoidSimple[12][120] = (byte)-1;
	geoidSimple[12][121] = (byte)-1;
	geoidSimple[12][122] = (byte)-1;
	geoidSimple[12][123] = (byte)-1;
	geoidSimple[12][124] = (byte)-1;
	geoidSimple[12][125] = (byte)-1;
	geoidSimple[12][126] = (byte)-1;
	geoidSimple[12][127] = (byte)-1;
	geoidSimple[12][128] = (byte)0;
	geoidSimple[12][129] = (byte)0;
	geoidSimple[12][130] = (byte)1;
	geoidSimple[12][131] = (byte)1;
	geoidSimple[12][132] = (byte)2;
	geoidSimple[12][133] = (byte)2;
	geoidSimple[12][134] = (byte)1;
	geoidSimple[12][135] = (byte)1;
	geoidSimple[12][136] = (byte)1;
	geoidSimple[12][137] = (byte)1;
	geoidSimple[12][138] = (byte)1;
	geoidSimple[12][139] = (byte)1;
	geoidSimple[12][140] = (byte)1;
	geoidSimple[12][141] = (byte)1;
	geoidSimple[12][142] = (byte)1;
	geoidSimple[12][143] = (byte)1;
	geoidSimple[12][144] = (byte)1;
	geoidSimple[12][145] = (byte)1;
	geoidSimple[12][146] = (byte)1;
	geoidSimple[12][147] = (byte)1;
	geoidSimple[12][148] = (byte)1;
	geoidSimple[12][149] = (byte)1;
	geoidSimple[12][150] = (byte)2;
	geoidSimple[12][151] = (byte)2;
	geoidSimple[12][152] = (byte)2;
	geoidSimple[12][153] = (byte)2;
	geoidSimple[12][154] = (byte)2;
	geoidSimple[12][155] = (byte)2;
	geoidSimple[12][156] = (byte)2;
	geoidSimple[12][157] = (byte)3;
	geoidSimple[12][158] = (byte)3;
	geoidSimple[12][159] = (byte)3;
	geoidSimple[12][160] = (byte)3;
	geoidSimple[12][161] = (byte)3;
	geoidSimple[12][162] = (byte)3;
	geoidSimple[12][163] = (byte)3;
	geoidSimple[12][164] = (byte)3;
	geoidSimple[12][165] = (byte)3;
	geoidSimple[12][166] = (byte)3;
	geoidSimple[12][167] = (byte)3;
	geoidSimple[12][168] = (byte)3;
	geoidSimple[12][169] = (byte)3;
	geoidSimple[12][170] = (byte)3;
	geoidSimple[12][171] = (byte)3;
	geoidSimple[12][172] = (byte)2;
	geoidSimple[12][173] = (byte)2;
	geoidSimple[12][174] = (byte)2;
	geoidSimple[12][175] = (byte)2;
	geoidSimple[12][176] = (byte)2;
	geoidSimple[12][177] = (byte)2;
	geoidSimple[12][178] = (byte)2;
	geoidSimple[12][179] = (byte)3;
	geoidSimple[12][LAT_GRID_SIZE] = (byte)2;
	geoidSimple[12][181] = (byte)2;
	geoidSimple[12][182] = (byte)2;
	geoidSimple[12][183] = (byte)2;
	geoidSimple[12][184] = (byte)2;
	geoidSimple[12][185] = (byte)1;
	geoidSimple[12][186] = (byte)1;
	geoidSimple[12][187] = (byte)1;
	geoidSimple[12][188] = (byte)1;
	geoidSimple[12][189] = (byte)2;
	geoidSimple[12][190] = (byte)2;
	geoidSimple[12][191] = (byte)3;
	geoidSimple[12][192] = (byte)3;
	geoidSimple[12][193] = (byte)3;
	geoidSimple[12][194] = (byte)3;
	geoidSimple[12][195] = (byte)3;
	geoidSimple[12][196] = (byte)3;
	geoidSimple[12][197] = (byte)2;
	geoidSimple[12][198] = (byte)2;
	geoidSimple[12][199] = (byte)1;
	geoidSimple[12][200] = (byte)1;
	geoidSimple[12][201] = (byte)0;
	geoidSimple[12][202] = (byte)0;
	geoidSimple[12][203] = (byte)0;
	geoidSimple[12][204] = (byte)0;
	geoidSimple[12][205] = (byte)-1;
	geoidSimple[12][206] = (byte)-1;
	geoidSimple[12][207] = (byte)-2;
	geoidSimple[12][208] = (byte)-2;
	geoidSimple[12][209] = (byte)-2;
	geoidSimple[12][210] = (byte)-2;
	geoidSimple[12][211] = (byte)-2;
	geoidSimple[12][212] = (byte)-3;
	geoidSimple[12][213] = (byte)-3;
	geoidSimple[12][214] = (byte)-3;
	geoidSimple[12][215] = (byte)-4;
	geoidSimple[12][216] = (byte)-4;
	geoidSimple[12][217] = (byte)-5;
	geoidSimple[12][218] = (byte)-5;
	geoidSimple[12][219] = (byte)-5;
	geoidSimple[12][220] = (byte)-5;
	geoidSimple[12][221] = (byte)-5;
	geoidSimple[12][222] = (byte)-6;
	geoidSimple[12][223] = (byte)-6;
	geoidSimple[12][224] = (byte)-6;
	geoidSimple[12][225] = (byte)-6;
	geoidSimple[12][226] = (byte)-6;
	geoidSimple[12][227] = (byte)-6;
	geoidSimple[12][228] = (byte)-5;
	geoidSimple[12][229] = (byte)-5;
	geoidSimple[12][230] = (byte)-5;
	geoidSimple[12][231] = (byte)-4;
	geoidSimple[12][232] = (byte)-3;
	geoidSimple[12][233] = (byte)-2;
	geoidSimple[12][234] = (byte)-2;
	geoidSimple[12][235] = (byte)-2;
	geoidSimple[12][236] = (byte)-2;
	geoidSimple[12][237] = (byte)-3;
	geoidSimple[12][238] = (byte)-3;
	geoidSimple[12][239] = (byte)-4;
	geoidSimple[12][240] = (byte)-4;
	geoidSimple[12][241] = (byte)-4;
	geoidSimple[12][242] = (byte)-3;
	geoidSimple[12][243] = (byte)-3;
	geoidSimple[12][244] = (byte)-4;
	geoidSimple[12][245] = (byte)-4;
	geoidSimple[12][246] = (byte)-4;
	geoidSimple[12][247] = (byte)-4;
	geoidSimple[12][248] = (byte)-4;
	geoidSimple[12][249] = (byte)-5;
	geoidSimple[12][250] = (byte)-5;
	geoidSimple[12][251] = (byte)-5;
	geoidSimple[12][252] = (byte)-5;
	geoidSimple[12][253] = (byte)-5;
	geoidSimple[12][254] = (byte)-5;
	geoidSimple[12][255] = (byte)-4;
	geoidSimple[12][256] = (byte)-5;
	geoidSimple[12][257] = (byte)-5;
	geoidSimple[12][258] = (byte)-4;
	geoidSimple[12][259] = (byte)-4;
	geoidSimple[12][260] = (byte)-4;
	geoidSimple[12][261] = (byte)-4;
	geoidSimple[12][262] = (byte)-3;
	geoidSimple[12][263] = (byte)-2;
	geoidSimple[12][264] = (byte)-1;
	geoidSimple[12][265] = (byte)-1;
	geoidSimple[12][266] = (byte)-1;
	geoidSimple[12][267] = (byte)-2;
	geoidSimple[12][268] = (byte)-2;
	geoidSimple[12][269] = (byte)-1;
	geoidSimple[12][270] = (byte)-1;
	geoidSimple[12][271] = (byte)0;
	geoidSimple[12][272] = (byte)1;
	geoidSimple[12][273] = (byte)2;
	geoidSimple[12][274] = (byte)4;
	geoidSimple[12][275] = (byte)5;
	geoidSimple[12][276] = (byte)6;
	geoidSimple[12][277] = (byte)7;
	geoidSimple[12][278] = (byte)8;
	geoidSimple[12][279] = (byte)9;
	geoidSimple[12][280] = (byte)9;
	geoidSimple[12][281] = (byte)9;
	geoidSimple[12][282] = (byte)8;
	geoidSimple[12][283] = (byte)8;
	geoidSimple[12][284] = (byte)8;
	geoidSimple[12][285] = (byte)8;
	geoidSimple[12][286] = (byte)9;
	geoidSimple[12][287] = (byte)10;
	geoidSimple[12][288] = (byte)11;
	geoidSimple[12][289] = (byte)13;
	geoidSimple[12][290] = (byte)15;
	geoidSimple[12][291] = (byte)16;
	geoidSimple[12][292] = (byte)17;
	geoidSimple[12][293] = (byte)19;
	geoidSimple[12][294] = (byte)20;
	geoidSimple[12][295] = (byte)21;
	geoidSimple[12][296] = (byte)22;
	geoidSimple[12][297] = (byte)23;
	geoidSimple[12][298] = (byte)24;
	geoidSimple[12][299] = (byte)25;
	geoidSimple[12][300] = (byte)25;
	geoidSimple[12][301] = (byte)26;
	geoidSimple[12][302] = (byte)27;
	geoidSimple[12][303] = (byte)27;
	geoidSimple[12][304] = (byte)28;
	geoidSimple[12][305] = (byte)29;
	geoidSimple[12][306] = (byte)29;
	geoidSimple[12][307] = (byte)30;
	geoidSimple[12][308] = (byte)30;
	geoidSimple[12][309] = (byte)30;
	geoidSimple[12][310] = (byte)30;
	geoidSimple[12][311] = (byte)30;
	geoidSimple[12][312] = (byte)31;
	geoidSimple[12][313] = (byte)31;
	geoidSimple[12][314] = (byte)32;
	geoidSimple[12][315] = (byte)32;
	geoidSimple[12][316] = (byte)33;
	geoidSimple[12][317] = (byte)33;
	geoidSimple[12][318] = (byte)34;
	geoidSimple[12][319] = (byte)34;
	geoidSimple[12][320] = (byte)35;
	geoidSimple[12][321] = (byte)35;
	geoidSimple[12][322] = (byte)36;
	geoidSimple[12][323] = (byte)37;
	geoidSimple[12][324] = (byte)37;
	geoidSimple[12][325] = (byte)38;
	geoidSimple[12][326] = (byte)39;
	geoidSimple[12][327] = (byte)40;
	geoidSimple[12][328] = (byte)40;
	geoidSimple[12][329] = (byte)40;
	geoidSimple[12][330] = (byte)40;
	geoidSimple[12][331] = (byte)39;
	geoidSimple[12][332] = (byte)38;
	geoidSimple[12][333] = (byte)37;
	geoidSimple[12][334] = (byte)36;
	geoidSimple[12][335] = (byte)34;
	geoidSimple[12][336] = (byte)32;
	geoidSimple[12][337] = (byte)30;
	geoidSimple[12][338] = (byte)30;
	geoidSimple[12][339] = (byte)30;
	geoidSimple[12][340] = (byte)31;
	geoidSimple[12][341] = (byte)31;
	geoidSimple[12][342] = (byte)31;
	geoidSimple[12][343] = (byte)31;
	geoidSimple[12][344] = (byte)31;
	geoidSimple[12][345] = (byte)31;
	geoidSimple[12][346] = (byte)33;
	geoidSimple[12][347] = (byte)35;
	geoidSimple[12][348] = (byte)36;
	geoidSimple[12][349] = (byte)37;
	geoidSimple[12][350] = (byte)37;
	geoidSimple[12][351] = (byte)38;
	geoidSimple[12][352] = (byte)39;
	geoidSimple[12][353] = (byte)40;
	geoidSimple[12][354] = (byte)40;
	geoidSimple[12][355] = (byte)40;
	geoidSimple[12][356] = (byte)39;
	geoidSimple[12][357] = (byte)39;
	geoidSimple[12][358] = (byte)39;
	geoidSimple[12][359] = (byte)40;
	}
		/** Row 13*/
	private static void init13() {
	geoidSimple[13][0] = (byte)42;
	geoidSimple[13][1] = (byte)42;
	geoidSimple[13][2] = (byte)41;
	geoidSimple[13][3] = (byte)41;
	geoidSimple[13][4] = (byte)41;
	geoidSimple[13][5] = (byte)41;
	geoidSimple[13][6] = (byte)41;
	geoidSimple[13][7] = (byte)41;
	geoidSimple[13][8] = (byte)40;
	geoidSimple[13][9] = (byte)40;
	geoidSimple[13][10] = (byte)39;
	geoidSimple[13][11] = (byte)38;
	geoidSimple[13][12] = (byte)38;
	geoidSimple[13][13] = (byte)38;
	geoidSimple[13][14] = (byte)37;
	geoidSimple[13][15] = (byte)35;
	geoidSimple[13][16] = (byte)33;
	geoidSimple[13][17] = (byte)31;
	geoidSimple[13][18] = (byte)30;
	geoidSimple[13][19] = (byte)29;
	geoidSimple[13][20] = (byte)29;
	geoidSimple[13][21] = (byte)28;
	geoidSimple[13][22] = (byte)28;
	geoidSimple[13][23] = (byte)27;
	geoidSimple[13][24] = (byte)26;
	geoidSimple[13][25] = (byte)25;
	geoidSimple[13][26] = (byte)24;
	geoidSimple[13][27] = (byte)23;
	geoidSimple[13][28] = (byte)22;
	geoidSimple[13][29] = (byte)21;
	geoidSimple[13][30] = (byte)20;
	geoidSimple[13][31] = (byte)19;
	geoidSimple[13][32] = (byte)18;
	geoidSimple[13][33] = (byte)18;
	geoidSimple[13][34] = (byte)17;
	geoidSimple[13][35] = (byte)16;
	geoidSimple[13][36] = (byte)15;
	geoidSimple[13][37] = (byte)14;
	geoidSimple[13][38] = (byte)14;
	geoidSimple[13][39] = (byte)13;
	geoidSimple[13][40] = (byte)12;
	geoidSimple[13][41] = (byte)11;
	geoidSimple[13][42] = (byte)11;
	geoidSimple[13][43] = (byte)10;
	geoidSimple[13][44] = (byte)9;
	geoidSimple[13][45] = (byte)9;
	geoidSimple[13][46] = (byte)8;
	geoidSimple[13][47] = (byte)8;
	geoidSimple[13][48] = (byte)7;
	geoidSimple[13][49] = (byte)6;
	geoidSimple[13][50] = (byte)6;
	geoidSimple[13][51] = (byte)5;
	geoidSimple[13][52] = (byte)5;
	geoidSimple[13][53] = (byte)4;
	geoidSimple[13][54] = (byte)4;
	geoidSimple[13][55] = (byte)4;
	geoidSimple[13][56] = (byte)3;
	geoidSimple[13][57] = (byte)3;
	geoidSimple[13][58] = (byte)2;
	geoidSimple[13][59] = (byte)2;
	geoidSimple[13][60] = (byte)1;
	geoidSimple[13][61] = (byte)1;
	geoidSimple[13][62] = (byte)1;
	geoidSimple[13][63] = (byte)1;
	geoidSimple[13][64] = (byte)1;
	geoidSimple[13][65] = (byte)1;
	geoidSimple[13][66] = (byte)0;
	geoidSimple[13][67] = (byte)0;
	geoidSimple[13][68] = (byte)0;
	geoidSimple[13][69] = (byte)-1;
	geoidSimple[13][70] = (byte)-2;
	geoidSimple[13][71] = (byte)-3;
	geoidSimple[13][72] = (byte)-3;
	geoidSimple[13][73] = (byte)-4;
	geoidSimple[13][74] = (byte)-4;
	geoidSimple[13][75] = (byte)-4;
	geoidSimple[13][76] = (byte)-5;
	geoidSimple[13][77] = (byte)-5;
	geoidSimple[13][78] = (byte)-5;
	geoidSimple[13][79] = (byte)-4;
	geoidSimple[13][80] = (byte)-4;
	geoidSimple[13][81] = (byte)-4;
	geoidSimple[13][82] = (byte)-4;
	geoidSimple[13][83] = (byte)-5;
	geoidSimple[13][84] = (byte)-5;
	geoidSimple[13][85] = (byte)-5;
	geoidSimple[13][86] = (byte)-6;
	geoidSimple[13][87] = (byte)-6;
	geoidSimple[13][88] = (byte)-6;
	geoidSimple[13][89] = (byte)-6;
	geoidSimple[13][90] = (byte)-6;
	geoidSimple[13][91] = (byte)-6;
	geoidSimple[13][92] = (byte)-6;
	geoidSimple[13][93] = (byte)-6;
	geoidSimple[13][94] = (byte)-6;
	geoidSimple[13][95] = (byte)-7;
	geoidSimple[13][96] = (byte)-7;
	geoidSimple[13][97] = (byte)-7;
	geoidSimple[13][98] = (byte)-7;
	geoidSimple[13][99] = (byte)-7;
	geoidSimple[13][100] = (byte)-7;
	geoidSimple[13][101] = (byte)-6;
	geoidSimple[13][102] = (byte)-6;
	geoidSimple[13][103] = (byte)-5;
	geoidSimple[13][104] = (byte)-5;
	geoidSimple[13][105] = (byte)-5;
	geoidSimple[13][106] = (byte)-4;
	geoidSimple[13][107] = (byte)-4;
	geoidSimple[13][108] = (byte)-4;
	geoidSimple[13][109] = (byte)-4;
	geoidSimple[13][110] = (byte)-3;
	geoidSimple[13][111] = (byte)-3;
	geoidSimple[13][112] = (byte)-2;
	geoidSimple[13][113] = (byte)-2;
	geoidSimple[13][114] = (byte)-2;
	geoidSimple[13][115] = (byte)-2;
	geoidSimple[13][116] = (byte)-2;
	geoidSimple[13][117] = (byte)-2;
	geoidSimple[13][118] = (byte)-1;
	geoidSimple[13][119] = (byte)-1;
	geoidSimple[13][120] = (byte)0;
	geoidSimple[13][121] = (byte)0;
	geoidSimple[13][122] = (byte)0;
	geoidSimple[13][123] = (byte)0;
	geoidSimple[13][124] = (byte)0;
	geoidSimple[13][125] = (byte)0;
	geoidSimple[13][126] = (byte)0;
	geoidSimple[13][127] = (byte)0;
	geoidSimple[13][128] = (byte)0;
	geoidSimple[13][129] = (byte)0;
	geoidSimple[13][130] = (byte)0;
	geoidSimple[13][131] = (byte)0;
	geoidSimple[13][132] = (byte)0;
	geoidSimple[13][133] = (byte)0;
	geoidSimple[13][134] = (byte)0;
	geoidSimple[13][135] = (byte)0;
	geoidSimple[13][136] = (byte)0;
	geoidSimple[13][137] = (byte)0;
	geoidSimple[13][138] = (byte)0;
	geoidSimple[13][139] = (byte)1;
	geoidSimple[13][140] = (byte)1;
	geoidSimple[13][141] = (byte)0;
	geoidSimple[13][142] = (byte)0;
	geoidSimple[13][143] = (byte)0;
	geoidSimple[13][144] = (byte)1;
	geoidSimple[13][145] = (byte)1;
	geoidSimple[13][146] = (byte)1;
	geoidSimple[13][147] = (byte)1;
	geoidSimple[13][148] = (byte)1;
	geoidSimple[13][149] = (byte)1;
	geoidSimple[13][150] = (byte)1;
	geoidSimple[13][151] = (byte)1;
	geoidSimple[13][152] = (byte)2;
	geoidSimple[13][153] = (byte)2;
	geoidSimple[13][154] = (byte)2;
	geoidSimple[13][155] = (byte)2;
	geoidSimple[13][156] = (byte)2;
	geoidSimple[13][157] = (byte)2;
	geoidSimple[13][158] = (byte)2;
	geoidSimple[13][159] = (byte)3;
	geoidSimple[13][160] = (byte)3;
	geoidSimple[13][161] = (byte)3;
	geoidSimple[13][162] = (byte)3;
	geoidSimple[13][163] = (byte)3;
	geoidSimple[13][164] = (byte)3;
	geoidSimple[13][165] = (byte)3;
	geoidSimple[13][166] = (byte)2;
	geoidSimple[13][167] = (byte)3;
	geoidSimple[13][168] = (byte)3;
	geoidSimple[13][169] = (byte)3;
	geoidSimple[13][170] = (byte)3;
	geoidSimple[13][171] = (byte)3;
	geoidSimple[13][172] = (byte)3;
	geoidSimple[13][173] = (byte)3;
	geoidSimple[13][174] = (byte)2;
	geoidSimple[13][175] = (byte)2;
	geoidSimple[13][176] = (byte)1;
	geoidSimple[13][177] = (byte)1;
	geoidSimple[13][178] = (byte)1;
	geoidSimple[13][179] = (byte)1;
	geoidSimple[13][LAT_GRID_SIZE] = (byte)1;
	geoidSimple[13][181] = (byte)2;
	geoidSimple[13][182] = (byte)1;
	geoidSimple[13][183] = (byte)1;
	geoidSimple[13][184] = (byte)0;
	geoidSimple[13][185] = (byte)0;
	geoidSimple[13][186] = (byte)0;
	geoidSimple[13][187] = (byte)0;
	geoidSimple[13][188] = (byte)0;
	geoidSimple[13][189] = (byte)0;
	geoidSimple[13][190] = (byte)1;
	geoidSimple[13][191] = (byte)1;
	geoidSimple[13][192] = (byte)1;
	geoidSimple[13][193] = (byte)2;
	geoidSimple[13][194] = (byte)2;
	geoidSimple[13][195] = (byte)1;
	geoidSimple[13][196] = (byte)1;
	geoidSimple[13][197] = (byte)0;
	geoidSimple[13][198] = (byte)0;
	geoidSimple[13][199] = (byte)0;
	geoidSimple[13][200] = (byte)0;
	geoidSimple[13][201] = (byte)0;
	geoidSimple[13][202] = (byte)0;
	geoidSimple[13][203] = (byte)0;
	geoidSimple[13][204] = (byte)-1;
	geoidSimple[13][205] = (byte)-1;
	geoidSimple[13][206] = (byte)-2;
	geoidSimple[13][207] = (byte)-2;
	geoidSimple[13][208] = (byte)-2;
	geoidSimple[13][209] = (byte)-2;
	geoidSimple[13][210] = (byte)-2;
	geoidSimple[13][211] = (byte)-3;
	geoidSimple[13][212] = (byte)-3;
	geoidSimple[13][213] = (byte)-3;
	geoidSimple[13][214] = (byte)-4;
	geoidSimple[13][215] = (byte)-4;
	geoidSimple[13][216] = (byte)-5;
	geoidSimple[13][217] = (byte)-5;
	geoidSimple[13][218] = (byte)-5;
	geoidSimple[13][219] = (byte)-6;
	geoidSimple[13][220] = (byte)-6;
	geoidSimple[13][221] = (byte)-6;
	geoidSimple[13][222] = (byte)-7;
	geoidSimple[13][223] = (byte)-7;
	geoidSimple[13][224] = (byte)-7;
	geoidSimple[13][225] = (byte)-7;
	geoidSimple[13][226] = (byte)-6;
	geoidSimple[13][227] = (byte)-6;
	geoidSimple[13][228] = (byte)-5;
	geoidSimple[13][229] = (byte)-5;
	geoidSimple[13][230] = (byte)-4;
	geoidSimple[13][231] = (byte)-4;
	geoidSimple[13][232] = (byte)-3;
	geoidSimple[13][233] = (byte)-3;
	geoidSimple[13][234] = (byte)-4;
	geoidSimple[13][235] = (byte)-5;
	geoidSimple[13][236] = (byte)-5;
	geoidSimple[13][237] = (byte)-5;
	geoidSimple[13][238] = (byte)-5;
	geoidSimple[13][239] = (byte)-6;
	geoidSimple[13][240] = (byte)-6;
	geoidSimple[13][241] = (byte)-6;
	geoidSimple[13][242] = (byte)-6;
	geoidSimple[13][243] = (byte)-6;
	geoidSimple[13][244] = (byte)-7;
	geoidSimple[13][245] = (byte)-7;
	geoidSimple[13][246] = (byte)-8;
	geoidSimple[13][247] = (byte)-8;
	geoidSimple[13][248] = (byte)-8;
	geoidSimple[13][249] = (byte)-8;
	geoidSimple[13][250] = (byte)-8;
	geoidSimple[13][251] = (byte)-8;
	geoidSimple[13][252] = (byte)-8;
	geoidSimple[13][253] = (byte)-8;
	geoidSimple[13][254] = (byte)-7;
	geoidSimple[13][255] = (byte)-7;
	geoidSimple[13][256] = (byte)-7;
	geoidSimple[13][257] = (byte)-7;
	geoidSimple[13][258] = (byte)-7;
	geoidSimple[13][259] = (byte)-6;
	geoidSimple[13][260] = (byte)-6;
	geoidSimple[13][261] = (byte)-5;
	geoidSimple[13][262] = (byte)-5;
	geoidSimple[13][263] = (byte)-4;
	geoidSimple[13][264] = (byte)-3;
	geoidSimple[13][265] = (byte)-2;
	geoidSimple[13][266] = (byte)-2;
	geoidSimple[13][267] = (byte)-2;
	geoidSimple[13][268] = (byte)-2;
	geoidSimple[13][269] = (byte)-1;
	geoidSimple[13][270] = (byte)0;
	geoidSimple[13][271] = (byte)0;
	geoidSimple[13][272] = (byte)1;
	geoidSimple[13][273] = (byte)2;
	geoidSimple[13][274] = (byte)3;
	geoidSimple[13][275] = (byte)3;
	geoidSimple[13][276] = (byte)4;
	geoidSimple[13][277] = (byte)4;
	geoidSimple[13][278] = (byte)5;
	geoidSimple[13][279] = (byte)7;
	geoidSimple[13][280] = (byte)8;
	geoidSimple[13][281] = (byte)9;
	geoidSimple[13][282] = (byte)9;
	geoidSimple[13][283] = (byte)10;
	geoidSimple[13][284] = (byte)10;
	geoidSimple[13][285] = (byte)11;
	geoidSimple[13][286] = (byte)11;
	geoidSimple[13][287] = (byte)11;
	geoidSimple[13][288] = (byte)12;
	geoidSimple[13][289] = (byte)13;
	geoidSimple[13][290] = (byte)15;
	geoidSimple[13][291] = (byte)16;
	geoidSimple[13][292] = (byte)18;
	geoidSimple[13][293] = (byte)19;
	geoidSimple[13][294] = (byte)20;
	geoidSimple[13][295] = (byte)20;
	geoidSimple[13][296] = (byte)21;
	geoidSimple[13][297] = (byte)21;
	geoidSimple[13][298] = (byte)22;
	geoidSimple[13][299] = (byte)22;
	geoidSimple[13][300] = (byte)22;
	geoidSimple[13][301] = (byte)23;
	geoidSimple[13][302] = (byte)24;
	geoidSimple[13][303] = (byte)25;
	geoidSimple[13][304] = (byte)26;
	geoidSimple[13][305] = (byte)27;
	geoidSimple[13][306] = (byte)28;
	geoidSimple[13][307] = (byte)29;
	geoidSimple[13][308] = (byte)29;
	geoidSimple[13][309] = (byte)30;
	geoidSimple[13][310] = (byte)30;
	geoidSimple[13][311] = (byte)31;
	geoidSimple[13][312] = (byte)31;
	geoidSimple[13][313] = (byte)31;
	geoidSimple[13][314] = (byte)32;
	geoidSimple[13][315] = (byte)32;
	geoidSimple[13][316] = (byte)33;
	geoidSimple[13][317] = (byte)34;
	geoidSimple[13][318] = (byte)35;
	geoidSimple[13][319] = (byte)36;
	geoidSimple[13][320] = (byte)36;
	geoidSimple[13][321] = (byte)37;
	geoidSimple[13][322] = (byte)38;
	geoidSimple[13][323] = (byte)39;
	geoidSimple[13][324] = (byte)40;
	geoidSimple[13][325] = (byte)40;
	geoidSimple[13][326] = (byte)41;
	geoidSimple[13][327] = (byte)42;
	geoidSimple[13][328] = (byte)43;
	geoidSimple[13][329] = (byte)43;
	geoidSimple[13][330] = (byte)44;
	geoidSimple[13][331] = (byte)44;
	geoidSimple[13][332] = (byte)44;
	geoidSimple[13][333] = (byte)43;
	geoidSimple[13][334] = (byte)42;
	geoidSimple[13][335] = (byte)39;
	geoidSimple[13][336] = (byte)36;
	geoidSimple[13][337] = (byte)33;
	geoidSimple[13][338] = (byte)33;
	geoidSimple[13][339] = (byte)33;
	geoidSimple[13][340] = (byte)34;
	geoidSimple[13][341] = (byte)34;
	geoidSimple[13][342] = (byte)34;
	geoidSimple[13][343] = (byte)34;
	geoidSimple[13][344] = (byte)35;
	geoidSimple[13][345] = (byte)36;
	geoidSimple[13][346] = (byte)38;
	geoidSimple[13][347] = (byte)39;
	geoidSimple[13][348] = (byte)41;
	geoidSimple[13][349] = (byte)41;
	geoidSimple[13][350] = (byte)42;
	geoidSimple[13][351] = (byte)42;
	geoidSimple[13][352] = (byte)43;
	geoidSimple[13][353] = (byte)42;
	geoidSimple[13][354] = (byte)42;
	geoidSimple[13][355] = (byte)41;
	geoidSimple[13][356] = (byte)41;
	geoidSimple[13][357] = (byte)41;
	geoidSimple[13][358] = (byte)41;
	geoidSimple[13][359] = (byte)42;
	}
		/** Row 14*/
	private static void init14() {
	geoidSimple[14][0] = (byte)43;
	geoidSimple[14][1] = (byte)43;
	geoidSimple[14][2] = (byte)43;
	geoidSimple[14][3] = (byte)43;
	geoidSimple[14][4] = (byte)43;
	geoidSimple[14][5] = (byte)43;
	geoidSimple[14][6] = (byte)42;
	geoidSimple[14][7] = (byte)42;
	geoidSimple[14][8] = (byte)41;
	geoidSimple[14][9] = (byte)41;
	geoidSimple[14][10] = (byte)40;
	geoidSimple[14][11] = (byte)39;
	geoidSimple[14][12] = (byte)39;
	geoidSimple[14][13] = (byte)40;
	geoidSimple[14][14] = (byte)40;
	geoidSimple[14][15] = (byte)40;
	geoidSimple[14][16] = (byte)37;
	geoidSimple[14][17] = (byte)34;
	geoidSimple[14][18] = (byte)32;
	geoidSimple[14][19] = (byte)31;
	geoidSimple[14][20] = (byte)30;
	geoidSimple[14][21] = (byte)29;
	geoidSimple[14][22] = (byte)28;
	geoidSimple[14][23] = (byte)27;
	geoidSimple[14][24] = (byte)26;
	geoidSimple[14][25] = (byte)25;
	geoidSimple[14][26] = (byte)24;
	geoidSimple[14][27] = (byte)23;
	geoidSimple[14][28] = (byte)22;
	geoidSimple[14][29] = (byte)21;
	geoidSimple[14][30] = (byte)20;
	geoidSimple[14][31] = (byte)19;
	geoidSimple[14][32] = (byte)18;
	geoidSimple[14][33] = (byte)18;
	geoidSimple[14][34] = (byte)17;
	geoidSimple[14][35] = (byte)16;
	geoidSimple[14][36] = (byte)15;
	geoidSimple[14][37] = (byte)14;
	geoidSimple[14][38] = (byte)13;
	geoidSimple[14][39] = (byte)12;
	geoidSimple[14][40] = (byte)11;
	geoidSimple[14][41] = (byte)10;
	geoidSimple[14][42] = (byte)9;
	geoidSimple[14][43] = (byte)9;
	geoidSimple[14][44] = (byte)8;
	geoidSimple[14][45] = (byte)8;
	geoidSimple[14][46] = (byte)7;
	geoidSimple[14][47] = (byte)6;
	geoidSimple[14][48] = (byte)6;
	geoidSimple[14][49] = (byte)5;
	geoidSimple[14][50] = (byte)5;
	geoidSimple[14][51] = (byte)4;
	geoidSimple[14][52] = (byte)4;
	geoidSimple[14][53] = (byte)3;
	geoidSimple[14][54] = (byte)3;
	geoidSimple[14][55] = (byte)2;
	geoidSimple[14][56] = (byte)2;
	geoidSimple[14][57] = (byte)2;
	geoidSimple[14][58] = (byte)2;
	geoidSimple[14][59] = (byte)1;
	geoidSimple[14][60] = (byte)1;
	geoidSimple[14][61] = (byte)1;
	geoidSimple[14][62] = (byte)0;
	geoidSimple[14][63] = (byte)0;
	geoidSimple[14][64] = (byte)-1;
	geoidSimple[14][65] = (byte)-1;
	geoidSimple[14][66] = (byte)-2;
	geoidSimple[14][67] = (byte)-3;
	geoidSimple[14][68] = (byte)-3;
	geoidSimple[14][69] = (byte)-4;
	geoidSimple[14][70] = (byte)-4;
	geoidSimple[14][71] = (byte)-4;
	geoidSimple[14][72] = (byte)-4;
	geoidSimple[14][73] = (byte)-4;
	geoidSimple[14][74] = (byte)-5;
	geoidSimple[14][75] = (byte)-5;
	geoidSimple[14][76] = (byte)-5;
	geoidSimple[14][77] = (byte)-6;
	geoidSimple[14][78] = (byte)-6;
	geoidSimple[14][79] = (byte)-6;
	geoidSimple[14][80] = (byte)-6;
	geoidSimple[14][81] = (byte)-6;
	geoidSimple[14][82] = (byte)-6;
	geoidSimple[14][83] = (byte)-7;
	geoidSimple[14][84] = (byte)-7;
	geoidSimple[14][85] = (byte)-7;
	geoidSimple[14][86] = (byte)-7;
	geoidSimple[14][87] = (byte)-7;
	geoidSimple[14][88] = (byte)-7;
	geoidSimple[14][89] = (byte)-7;
	geoidSimple[14][90] = (byte)-7;
	geoidSimple[14][91] = (byte)-7;
	geoidSimple[14][92] = (byte)-7;
	geoidSimple[14][93] = (byte)-7;
	geoidSimple[14][94] = (byte)-7;
	geoidSimple[14][95] = (byte)-7;
	geoidSimple[14][96] = (byte)-7;
	geoidSimple[14][97] = (byte)-8;
	geoidSimple[14][98] = (byte)-8;
	geoidSimple[14][99] = (byte)-8;
	geoidSimple[14][100] = (byte)-8;
	geoidSimple[14][101] = (byte)-8;
	geoidSimple[14][102] = (byte)-7;
	geoidSimple[14][103] = (byte)-7;
	geoidSimple[14][104] = (byte)-7;
	geoidSimple[14][105] = (byte)-7;
	geoidSimple[14][106] = (byte)-6;
	geoidSimple[14][107] = (byte)-5;
	geoidSimple[14][108] = (byte)-5;
	geoidSimple[14][109] = (byte)-4;
	geoidSimple[14][110] = (byte)-3;
	geoidSimple[14][111] = (byte)-3;
	geoidSimple[14][112] = (byte)-3;
	geoidSimple[14][113] = (byte)-3;
	geoidSimple[14][114] = (byte)-3;
	geoidSimple[14][115] = (byte)-3;
	geoidSimple[14][116] = (byte)-3;
	geoidSimple[14][117] = (byte)-3;
	geoidSimple[14][118] = (byte)-3;
	geoidSimple[14][119] = (byte)-2;
	geoidSimple[14][120] = (byte)-2;
	geoidSimple[14][121] = (byte)-2;
	geoidSimple[14][122] = (byte)-2;
	geoidSimple[14][123] = (byte)-1;
	geoidSimple[14][124] = (byte)-1;
	geoidSimple[14][125] = (byte)-1;
	geoidSimple[14][126] = (byte)-1;
	geoidSimple[14][127] = (byte)-1;
	geoidSimple[14][128] = (byte)-1;
	geoidSimple[14][129] = (byte)0;
	geoidSimple[14][130] = (byte)0;
	geoidSimple[14][131] = (byte)0;
	geoidSimple[14][132] = (byte)0;
	geoidSimple[14][133] = (byte)0;
	geoidSimple[14][134] = (byte)0;
	geoidSimple[14][135] = (byte)0;
	geoidSimple[14][136] = (byte)0;
	geoidSimple[14][137] = (byte)0;
	geoidSimple[14][138] = (byte)0;
	geoidSimple[14][139] = (byte)0;
	geoidSimple[14][140] = (byte)0;
	geoidSimple[14][141] = (byte)0;
	geoidSimple[14][142] = (byte)0;
	geoidSimple[14][143] = (byte)0;
	geoidSimple[14][144] = (byte)0;
	geoidSimple[14][145] = (byte)1;
	geoidSimple[14][146] = (byte)1;
	geoidSimple[14][147] = (byte)1;
	geoidSimple[14][148] = (byte)1;
	geoidSimple[14][149] = (byte)1;
	geoidSimple[14][150] = (byte)1;
	geoidSimple[14][151] = (byte)2;
	geoidSimple[14][152] = (byte)2;
	geoidSimple[14][153] = (byte)2;
	geoidSimple[14][154] = (byte)1;
	geoidSimple[14][155] = (byte)1;
	geoidSimple[14][156] = (byte)1;
	geoidSimple[14][157] = (byte)1;
	geoidSimple[14][158] = (byte)1;
	geoidSimple[14][159] = (byte)2;
	geoidSimple[14][160] = (byte)2;
	geoidSimple[14][161] = (byte)2;
	geoidSimple[14][162] = (byte)2;
	geoidSimple[14][163] = (byte)2;
	geoidSimple[14][164] = (byte)2;
	geoidSimple[14][165] = (byte)2;
	geoidSimple[14][166] = (byte)2;
	geoidSimple[14][167] = (byte)2;
	geoidSimple[14][168] = (byte)2;
	geoidSimple[14][169] = (byte)2;
	geoidSimple[14][170] = (byte)2;
	geoidSimple[14][171] = (byte)2;
	geoidSimple[14][172] = (byte)2;
	geoidSimple[14][173] = (byte)2;
	geoidSimple[14][174] = (byte)2;
	geoidSimple[14][175] = (byte)2;
	geoidSimple[14][176] = (byte)2;
	geoidSimple[14][177] = (byte)1;
	geoidSimple[14][178] = (byte)1;
	geoidSimple[14][179] = (byte)1;
	geoidSimple[14][LAT_GRID_SIZE] = (byte)1;
	geoidSimple[14][181] = (byte)1;
	geoidSimple[14][182] = (byte)1;
	geoidSimple[14][183] = (byte)0;
	geoidSimple[14][184] = (byte)0;
	geoidSimple[14][185] = (byte)0;
	geoidSimple[14][186] = (byte)0;
	geoidSimple[14][187] = (byte)1;
	geoidSimple[14][188] = (byte)1;
	geoidSimple[14][189] = (byte)1;
	geoidSimple[14][190] = (byte)1;
	geoidSimple[14][191] = (byte)1;
	geoidSimple[14][192] = (byte)1;
	geoidSimple[14][193] = (byte)1;
	geoidSimple[14][194] = (byte)0;
	geoidSimple[14][195] = (byte)0;
	geoidSimple[14][196] = (byte)0;
	geoidSimple[14][197] = (byte)-1;
	geoidSimple[14][198] = (byte)-1;
	geoidSimple[14][199] = (byte)-1;
	geoidSimple[14][200] = (byte)0;
	geoidSimple[14][201] = (byte)-1;
	geoidSimple[14][202] = (byte)-1;
	geoidSimple[14][203] = (byte)-2;
	geoidSimple[14][204] = (byte)-3;
	geoidSimple[14][205] = (byte)-3;
	geoidSimple[14][206] = (byte)-3;
	geoidSimple[14][207] = (byte)-3;
	geoidSimple[14][208] = (byte)-3;
	geoidSimple[14][209] = (byte)-3;
	geoidSimple[14][210] = (byte)-3;
	geoidSimple[14][211] = (byte)-3;
	geoidSimple[14][212] = (byte)-3;
	geoidSimple[14][213] = (byte)-3;
	geoidSimple[14][214] = (byte)-4;
	geoidSimple[14][215] = (byte)-4;
	geoidSimple[14][216] = (byte)-5;
	geoidSimple[14][217] = (byte)-5;
	geoidSimple[14][218] = (byte)-6;
	geoidSimple[14][219] = (byte)-6;
	geoidSimple[14][220] = (byte)-7;
	geoidSimple[14][221] = (byte)-7;
	geoidSimple[14][222] = (byte)-8;
	geoidSimple[14][223] = (byte)-8;
	geoidSimple[14][224] = (byte)-8;
	geoidSimple[14][225] = (byte)-8;
	geoidSimple[14][226] = (byte)-7;
	geoidSimple[14][227] = (byte)-6;
	geoidSimple[14][228] = (byte)-6;
	geoidSimple[14][229] = (byte)-5;
	geoidSimple[14][230] = (byte)-4;
	geoidSimple[14][231] = (byte)-4;
	geoidSimple[14][232] = (byte)-4;
	geoidSimple[14][233] = (byte)-6;
	geoidSimple[14][234] = (byte)-7;
	geoidSimple[14][235] = (byte)-8;
	geoidSimple[14][236] = (byte)-9;
	geoidSimple[14][237] = (byte)-9;
	geoidSimple[14][238] = (byte)-9;
	geoidSimple[14][239] = (byte)-9;
	geoidSimple[14][240] = (byte)-9;
	geoidSimple[14][241] = (byte)-9;
	geoidSimple[14][242] = (byte)-9;
	geoidSimple[14][243] = (byte)-9;
	geoidSimple[14][244] = (byte)-8;
	geoidSimple[14][245] = (byte)-8;
	geoidSimple[14][246] = (byte)-8;
	geoidSimple[14][247] = (byte)-9;
	geoidSimple[14][248] = (byte)-10;
	geoidSimple[14][249] = (byte)-10;
	geoidSimple[14][250] = (byte)-11;
	geoidSimple[14][251] = (byte)-11;
	geoidSimple[14][252] = (byte)-11;
	geoidSimple[14][253] = (byte)-11;
	geoidSimple[14][254] = (byte)-11;
	geoidSimple[14][255] = (byte)-11;
	geoidSimple[14][256] = (byte)-10;
	geoidSimple[14][257] = (byte)-10;
	geoidSimple[14][258] = (byte)-9;
	geoidSimple[14][259] = (byte)-9;
	geoidSimple[14][260] = (byte)-8;
	geoidSimple[14][261] = (byte)-7;
	geoidSimple[14][262] = (byte)-6;
	geoidSimple[14][263] = (byte)-6;
	geoidSimple[14][264] = (byte)-6;
	geoidSimple[14][265] = (byte)-5;
	geoidSimple[14][266] = (byte)-5;
	geoidSimple[14][267] = (byte)-4;
	geoidSimple[14][268] = (byte)-3;
	geoidSimple[14][269] = (byte)-2;
	geoidSimple[14][270] = (byte)-2;
	geoidSimple[14][271] = (byte)-1;
	geoidSimple[14][272] = (byte)-1;
	geoidSimple[14][273] = (byte)0;
	geoidSimple[14][274] = (byte)0;
	geoidSimple[14][275] = (byte)1;
	geoidSimple[14][276] = (byte)3;
	geoidSimple[14][277] = (byte)4;
	geoidSimple[14][278] = (byte)4;
	geoidSimple[14][279] = (byte)4;
	geoidSimple[14][280] = (byte)5;
	geoidSimple[14][281] = (byte)6;
	geoidSimple[14][282] = (byte)8;
	geoidSimple[14][283] = (byte)10;
	geoidSimple[14][284] = (byte)12;
	geoidSimple[14][285] = (byte)13;
	geoidSimple[14][286] = (byte)14;
	geoidSimple[14][287] = (byte)15;
	geoidSimple[14][288] = (byte)16;
	geoidSimple[14][289] = (byte)16;
	geoidSimple[14][290] = (byte)16;
	geoidSimple[14][291] = (byte)17;
	geoidSimple[14][292] = (byte)17;
	geoidSimple[14][293] = (byte)17;
	geoidSimple[14][294] = (byte)17;
	geoidSimple[14][295] = (byte)16;
	geoidSimple[14][296] = (byte)17;
	geoidSimple[14][297] = (byte)17;
	geoidSimple[14][298] = (byte)18;
	geoidSimple[14][299] = (byte)19;
	geoidSimple[14][300] = (byte)20;
	geoidSimple[14][301] = (byte)21;
	geoidSimple[14][302] = (byte)22;
	geoidSimple[14][303] = (byte)23;
	geoidSimple[14][304] = (byte)25;
	geoidSimple[14][305] = (byte)26;
	geoidSimple[14][306] = (byte)28;
	geoidSimple[14][307] = (byte)29;
	geoidSimple[14][308] = (byte)30;
	geoidSimple[14][309] = (byte)30;
	geoidSimple[14][310] = (byte)31;
	geoidSimple[14][311] = (byte)31;
	geoidSimple[14][312] = (byte)32;
	geoidSimple[14][313] = (byte)32;
	geoidSimple[14][314] = (byte)33;
	geoidSimple[14][315] = (byte)34;
	geoidSimple[14][316] = (byte)34;
	geoidSimple[14][317] = (byte)35;
	geoidSimple[14][318] = (byte)36;
	geoidSimple[14][319] = (byte)37;
	geoidSimple[14][320] = (byte)37;
	geoidSimple[14][321] = (byte)38;
	geoidSimple[14][322] = (byte)39;
	geoidSimple[14][323] = (byte)39;
	geoidSimple[14][324] = (byte)40;
	geoidSimple[14][325] = (byte)41;
	geoidSimple[14][326] = (byte)42;
	geoidSimple[14][327] = (byte)43;
	geoidSimple[14][328] = (byte)43;
	geoidSimple[14][329] = (byte)44;
	geoidSimple[14][330] = (byte)45;
	geoidSimple[14][331] = (byte)46;
	geoidSimple[14][332] = (byte)46;
	geoidSimple[14][333] = (byte)45;
	geoidSimple[14][334] = (byte)43;
	geoidSimple[14][335] = (byte)42;
	geoidSimple[14][336] = (byte)42;
	geoidSimple[14][337] = (byte)42;
	geoidSimple[14][338] = (byte)41;
	geoidSimple[14][339] = (byte)40;
	geoidSimple[14][340] = (byte)40;
	geoidSimple[14][341] = (byte)40;
	geoidSimple[14][342] = (byte)40;
	geoidSimple[14][343] = (byte)40;
	geoidSimple[14][344] = (byte)41;
	geoidSimple[14][345] = (byte)42;
	geoidSimple[14][346] = (byte)43;
	geoidSimple[14][347] = (byte)44;
	geoidSimple[14][348] = (byte)44;
	geoidSimple[14][349] = (byte)44;
	geoidSimple[14][350] = (byte)44;
	geoidSimple[14][351] = (byte)44;
	geoidSimple[14][352] = (byte)44;
	geoidSimple[14][353] = (byte)44;
	geoidSimple[14][354] = (byte)44;
	geoidSimple[14][355] = (byte)44;
	geoidSimple[14][356] = (byte)43;
	geoidSimple[14][357] = (byte)43;
	geoidSimple[14][358] = (byte)42;
	geoidSimple[14][359] = (byte)43;
	}
		/** Row 15*/
	private static void init15() {
	geoidSimple[15][0] = (byte)44;
	geoidSimple[15][1] = (byte)44;
	geoidSimple[15][2] = (byte)44;
	geoidSimple[15][3] = (byte)43;
	geoidSimple[15][4] = (byte)43;
	geoidSimple[15][5] = (byte)44;
	geoidSimple[15][6] = (byte)44;
	geoidSimple[15][7] = (byte)43;
	geoidSimple[15][8] = (byte)42;
	geoidSimple[15][9] = (byte)42;
	geoidSimple[15][10] = (byte)41;
	geoidSimple[15][11] = (byte)40;
	geoidSimple[15][12] = (byte)40;
	geoidSimple[15][13] = (byte)39;
	geoidSimple[15][14] = (byte)39;
	geoidSimple[15][15] = (byte)39;
	geoidSimple[15][16] = (byte)38;
	geoidSimple[15][17] = (byte)36;
	geoidSimple[15][18] = (byte)34;
	geoidSimple[15][19] = (byte)32;
	geoidSimple[15][20] = (byte)30;
	geoidSimple[15][21] = (byte)29;
	geoidSimple[15][22] = (byte)28;
	geoidSimple[15][23] = (byte)27;
	geoidSimple[15][24] = (byte)25;
	geoidSimple[15][25] = (byte)24;
	geoidSimple[15][26] = (byte)23;
	geoidSimple[15][27] = (byte)22;
	geoidSimple[15][28] = (byte)21;
	geoidSimple[15][29] = (byte)20;
	geoidSimple[15][30] = (byte)19;
	geoidSimple[15][31] = (byte)19;
	geoidSimple[15][32] = (byte)18;
	geoidSimple[15][33] = (byte)17;
	geoidSimple[15][34] = (byte)16;
	geoidSimple[15][35] = (byte)15;
	geoidSimple[15][36] = (byte)14;
	geoidSimple[15][37] = (byte)14;
	geoidSimple[15][38] = (byte)13;
	geoidSimple[15][39] = (byte)12;
	geoidSimple[15][40] = (byte)11;
	geoidSimple[15][41] = (byte)10;
	geoidSimple[15][42] = (byte)9;
	geoidSimple[15][43] = (byte)8;
	geoidSimple[15][44] = (byte)8;
	geoidSimple[15][45] = (byte)7;
	geoidSimple[15][46] = (byte)6;
	geoidSimple[15][47] = (byte)6;
	geoidSimple[15][48] = (byte)5;
	geoidSimple[15][49] = (byte)4;
	geoidSimple[15][50] = (byte)3;
	geoidSimple[15][51] = (byte)3;
	geoidSimple[15][52] = (byte)2;
	geoidSimple[15][53] = (byte)2;
	geoidSimple[15][54] = (byte)1;
	geoidSimple[15][55] = (byte)1;
	geoidSimple[15][56] = (byte)1;
	geoidSimple[15][57] = (byte)2;
	geoidSimple[15][58] = (byte)1;
	geoidSimple[15][59] = (byte)0;
	geoidSimple[15][60] = (byte)0;
	geoidSimple[15][61] = (byte)-2;
	geoidSimple[15][62] = (byte)-2;
	geoidSimple[15][63] = (byte)-3;
	geoidSimple[15][64] = (byte)-3;
	geoidSimple[15][65] = (byte)-3;
	geoidSimple[15][66] = (byte)-4;
	geoidSimple[15][67] = (byte)-4;
	geoidSimple[15][68] = (byte)-4;
	geoidSimple[15][69] = (byte)-4;
	geoidSimple[15][70] = (byte)-4;
	geoidSimple[15][71] = (byte)-5;
	geoidSimple[15][72] = (byte)-5;
	geoidSimple[15][73] = (byte)-5;
	geoidSimple[15][74] = (byte)-6;
	geoidSimple[15][75] = (byte)-6;
	geoidSimple[15][76] = (byte)-6;
	geoidSimple[15][77] = (byte)-6;
	geoidSimple[15][78] = (byte)-7;
	geoidSimple[15][79] = (byte)-7;
	geoidSimple[15][80] = (byte)-7;
	geoidSimple[15][81] = (byte)-7;
	geoidSimple[15][82] = (byte)-7;
	geoidSimple[15][83] = (byte)-7;
	geoidSimple[15][84] = (byte)-7;
	geoidSimple[15][85] = (byte)-7;
	geoidSimple[15][86] = (byte)-8;
	geoidSimple[15][87] = (byte)-8;
	geoidSimple[15][88] = (byte)-8;
	geoidSimple[15][89] = (byte)-8;
	geoidSimple[15][90] = (byte)-8;
	geoidSimple[15][91] = (byte)-8;
	geoidSimple[15][92] = (byte)-8;
	geoidSimple[15][93] = (byte)-8;
	geoidSimple[15][94] = (byte)-9;
	geoidSimple[15][95] = (byte)-9;
	geoidSimple[15][96] = (byte)-9;
	geoidSimple[15][97] = (byte)-9;
	geoidSimple[15][98] = (byte)-9;
	geoidSimple[15][99] = (byte)-9;
	geoidSimple[15][100] = (byte)-10;
	geoidSimple[15][101] = (byte)-10;
	geoidSimple[15][102] = (byte)-9;
	geoidSimple[15][103] = (byte)-9;
	geoidSimple[15][104] = (byte)-9;
	geoidSimple[15][105] = (byte)-9;
	geoidSimple[15][106] = (byte)-9;
	geoidSimple[15][107] = (byte)-8;
	geoidSimple[15][108] = (byte)-8;
	geoidSimple[15][109] = (byte)-8;
	geoidSimple[15][110] = (byte)-7;
	geoidSimple[15][111] = (byte)-7;
	geoidSimple[15][112] = (byte)-7;
	geoidSimple[15][113] = (byte)-6;
	geoidSimple[15][114] = (byte)-6;
	geoidSimple[15][115] = (byte)-5;
	geoidSimple[15][116] = (byte)-5;
	geoidSimple[15][117] = (byte)-5;
	geoidSimple[15][118] = (byte)-5;
	geoidSimple[15][119] = (byte)-4;
	geoidSimple[15][120] = (byte)-4;
	geoidSimple[15][121] = (byte)-4;
	geoidSimple[15][122] = (byte)-3;
	geoidSimple[15][123] = (byte)-3;
	geoidSimple[15][124] = (byte)-3;
	geoidSimple[15][125] = (byte)-3;
	geoidSimple[15][126] = (byte)-2;
	geoidSimple[15][127] = (byte)-2;
	geoidSimple[15][128] = (byte)-2;
	geoidSimple[15][129] = (byte)-2;
	geoidSimple[15][130] = (byte)-2;
	geoidSimple[15][131] = (byte)-2;
	geoidSimple[15][132] = (byte)-1;
	geoidSimple[15][133] = (byte)-1;
	geoidSimple[15][134] = (byte)-1;
	geoidSimple[15][135] = (byte)-1;
	geoidSimple[15][136] = (byte)-1;
	geoidSimple[15][137] = (byte)0;
	geoidSimple[15][138] = (byte)0;
	geoidSimple[15][139] = (byte)0;
	geoidSimple[15][140] = (byte)0;
	geoidSimple[15][141] = (byte)0;
	geoidSimple[15][142] = (byte)0;
	geoidSimple[15][143] = (byte)0;
	geoidSimple[15][144] = (byte)0;
	geoidSimple[15][145] = (byte)0;
	geoidSimple[15][146] = (byte)0;
	geoidSimple[15][147] = (byte)0;
	geoidSimple[15][148] = (byte)0;
	geoidSimple[15][149] = (byte)0;
	geoidSimple[15][150] = (byte)0;
	geoidSimple[15][151] = (byte)0;
	geoidSimple[15][152] = (byte)1;
	geoidSimple[15][153] = (byte)1;
	geoidSimple[15][154] = (byte)1;
	geoidSimple[15][155] = (byte)1;
	geoidSimple[15][156] = (byte)0;
	geoidSimple[15][157] = (byte)0;
	geoidSimple[15][158] = (byte)1;
	geoidSimple[15][159] = (byte)1;
	geoidSimple[15][160] = (byte)1;
	geoidSimple[15][161] = (byte)1;
	geoidSimple[15][162] = (byte)0;
	geoidSimple[15][163] = (byte)1;
	geoidSimple[15][164] = (byte)1;
	geoidSimple[15][165] = (byte)1;
	geoidSimple[15][166] = (byte)1;
	geoidSimple[15][167] = (byte)1;
	geoidSimple[15][168] = (byte)1;
	geoidSimple[15][169] = (byte)2;
	geoidSimple[15][170] = (byte)1;
	geoidSimple[15][171] = (byte)1;
	geoidSimple[15][172] = (byte)1;
	geoidSimple[15][173] = (byte)1;
	geoidSimple[15][174] = (byte)1;
	geoidSimple[15][175] = (byte)1;
	geoidSimple[15][176] = (byte)1;
	geoidSimple[15][177] = (byte)1;
	geoidSimple[15][178] = (byte)1;
	geoidSimple[15][179] = (byte)1;
	geoidSimple[15][LAT_GRID_SIZE] = (byte)1;
	geoidSimple[15][181] = (byte)1;
	geoidSimple[15][182] = (byte)1;
	geoidSimple[15][183] = (byte)1;
	geoidSimple[15][184] = (byte)2;
	geoidSimple[15][185] = (byte)2;
	geoidSimple[15][186] = (byte)2;
	geoidSimple[15][187] = (byte)2;
	geoidSimple[15][188] = (byte)2;
	geoidSimple[15][189] = (byte)2;
	geoidSimple[15][190] = (byte)3;
	geoidSimple[15][191] = (byte)2;
	geoidSimple[15][192] = (byte)2;
	geoidSimple[15][193] = (byte)1;
	geoidSimple[15][194] = (byte)0;
	geoidSimple[15][195] = (byte)0;
	geoidSimple[15][196] = (byte)0;
	geoidSimple[15][197] = (byte)0;
	geoidSimple[15][198] = (byte)-1;
	geoidSimple[15][199] = (byte)-1;
	geoidSimple[15][200] = (byte)-2;
	geoidSimple[15][201] = (byte)-3;
	geoidSimple[15][202] = (byte)-4;
	geoidSimple[15][203] = (byte)-5;
	geoidSimple[15][204] = (byte)-5;
	geoidSimple[15][205] = (byte)-5;
	geoidSimple[15][206] = (byte)-4;
	geoidSimple[15][207] = (byte)-4;
	geoidSimple[15][208] = (byte)-4;
	geoidSimple[15][209] = (byte)-4;
	geoidSimple[15][210] = (byte)-4;
	geoidSimple[15][211] = (byte)-4;
	geoidSimple[15][212] = (byte)-4;
	geoidSimple[15][213] = (byte)-3;
	geoidSimple[15][214] = (byte)-3;
	geoidSimple[15][215] = (byte)-4;
	geoidSimple[15][216] = (byte)-5;
	geoidSimple[15][217] = (byte)-6;
	geoidSimple[15][218] = (byte)-6;
	geoidSimple[15][219] = (byte)-7;
	geoidSimple[15][220] = (byte)-7;
	geoidSimple[15][221] = (byte)-8;
	geoidSimple[15][222] = (byte)-8;
	geoidSimple[15][223] = (byte)-9;
	geoidSimple[15][224] = (byte)-9;
	geoidSimple[15][225] = (byte)-9;
	geoidSimple[15][226] = (byte)-9;
	geoidSimple[15][227] = (byte)-8;
	geoidSimple[15][228] = (byte)-7;
	geoidSimple[15][229] = (byte)-5;
	geoidSimple[15][230] = (byte)-4;
	geoidSimple[15][231] = (byte)-3;
	geoidSimple[15][232] = (byte)-5;
	geoidSimple[15][233] = (byte)-7;
	geoidSimple[15][234] = (byte)-8;
	geoidSimple[15][235] = (byte)-9;
	geoidSimple[15][236] = (byte)-10;
	geoidSimple[15][237] = (byte)-10;
	geoidSimple[15][238] = (byte)-10;
	geoidSimple[15][239] = (byte)-11;
	geoidSimple[15][240] = (byte)-12;
	geoidSimple[15][241] = (byte)-12;
	geoidSimple[15][242] = (byte)-12;
	geoidSimple[15][243] = (byte)-12;
	geoidSimple[15][244] = (byte)-13;
	geoidSimple[15][245] = (byte)-13;
	geoidSimple[15][246] = (byte)-13;
	geoidSimple[15][247] = (byte)-13;
	geoidSimple[15][248] = (byte)-13;
	geoidSimple[15][249] = (byte)-14;
	geoidSimple[15][250] = (byte)-14;
	geoidSimple[15][251] = (byte)-15;
	geoidSimple[15][252] = (byte)-15;
	geoidSimple[15][253] = (byte)-15;
	geoidSimple[15][254] = (byte)-15;
	geoidSimple[15][255] = (byte)-15;
	geoidSimple[15][256] = (byte)-14;
	geoidSimple[15][257] = (byte)-14;
	geoidSimple[15][258] = (byte)-13;
	geoidSimple[15][259] = (byte)-12;
	geoidSimple[15][260] = (byte)-11;
	geoidSimple[15][261] = (byte)-10;
	geoidSimple[15][262] = (byte)-10;
	geoidSimple[15][263] = (byte)-9;
	geoidSimple[15][264] = (byte)-9;
	geoidSimple[15][265] = (byte)-8;
	geoidSimple[15][266] = (byte)-8;
	geoidSimple[15][267] = (byte)-8;
	geoidSimple[15][268] = (byte)-7;
	geoidSimple[15][269] = (byte)-6;
	geoidSimple[15][270] = (byte)-6;
	geoidSimple[15][271] = (byte)-5;
	geoidSimple[15][272] = (byte)-4;
	geoidSimple[15][273] = (byte)-3;
	geoidSimple[15][274] = (byte)-1;
	geoidSimple[15][275] = (byte)0;
	geoidSimple[15][276] = (byte)0;
	geoidSimple[15][277] = (byte)1;
	geoidSimple[15][278] = (byte)3;
	geoidSimple[15][279] = (byte)3;
	geoidSimple[15][280] = (byte)4;
	geoidSimple[15][281] = (byte)4;
	geoidSimple[15][282] = (byte)6;
	geoidSimple[15][283] = (byte)9;
	geoidSimple[15][284] = (byte)11;
	geoidSimple[15][285] = (byte)13;
	geoidSimple[15][286] = (byte)14;
	geoidSimple[15][287] = (byte)15;
	geoidSimple[15][288] = (byte)16;
	geoidSimple[15][289] = (byte)17;
	geoidSimple[15][290] = (byte)17;
	geoidSimple[15][291] = (byte)17;
	geoidSimple[15][292] = (byte)17;
	geoidSimple[15][293] = (byte)18;
	geoidSimple[15][294] = (byte)18;
	geoidSimple[15][295] = (byte)18;
	geoidSimple[15][296] = (byte)18;
	geoidSimple[15][297] = (byte)17;
	geoidSimple[15][298] = (byte)17;
	geoidSimple[15][299] = (byte)17;
	geoidSimple[15][300] = (byte)19;
	geoidSimple[15][301] = (byte)20;
	geoidSimple[15][302] = (byte)21;
	geoidSimple[15][303] = (byte)22;
	geoidSimple[15][304] = (byte)24;
	geoidSimple[15][305] = (byte)25;
	geoidSimple[15][306] = (byte)27;
	geoidSimple[15][307] = (byte)29;
	geoidSimple[15][308] = (byte)30;
	geoidSimple[15][309] = (byte)31;
	geoidSimple[15][310] = (byte)32;
	geoidSimple[15][311] = (byte)33;
	geoidSimple[15][312] = (byte)33;
	geoidSimple[15][313] = (byte)34;
	geoidSimple[15][314] = (byte)34;
	geoidSimple[15][315] = (byte)35;
	geoidSimple[15][316] = (byte)36;
	geoidSimple[15][317] = (byte)36;
	geoidSimple[15][318] = (byte)36;
	geoidSimple[15][319] = (byte)37;
	geoidSimple[15][320] = (byte)37;
	geoidSimple[15][321] = (byte)38;
	geoidSimple[15][322] = (byte)38;
	geoidSimple[15][323] = (byte)39;
	geoidSimple[15][324] = (byte)40;
	geoidSimple[15][325] = (byte)41;
	geoidSimple[15][326] = (byte)42;
	geoidSimple[15][327] = (byte)43;
	geoidSimple[15][328] = (byte)44;
	geoidSimple[15][329] = (byte)45;
	geoidSimple[15][330] = (byte)45;
	geoidSimple[15][331] = (byte)46;
	geoidSimple[15][332] = (byte)46;
	geoidSimple[15][333] = (byte)45;
	geoidSimple[15][334] = (byte)45;
	geoidSimple[15][335] = (byte)46;
	geoidSimple[15][336] = (byte)47;
	geoidSimple[15][337] = (byte)47;
	geoidSimple[15][338] = (byte)46;
	geoidSimple[15][339] = (byte)46;
	geoidSimple[15][340] = (byte)45;
	geoidSimple[15][341] = (byte)46;
	geoidSimple[15][342] = (byte)46;
	geoidSimple[15][343] = (byte)47;
	geoidSimple[15][344] = (byte)47;
	geoidSimple[15][345] = (byte)48;
	geoidSimple[15][346] = (byte)48;
	geoidSimple[15][347] = (byte)47;
	geoidSimple[15][348] = (byte)47;
	geoidSimple[15][349] = (byte)46;
	geoidSimple[15][350] = (byte)46;
	geoidSimple[15][351] = (byte)46;
	geoidSimple[15][352] = (byte)46;
	geoidSimple[15][353] = (byte)46;
	geoidSimple[15][354] = (byte)46;
	geoidSimple[15][355] = (byte)46;
	geoidSimple[15][356] = (byte)46;
	geoidSimple[15][357] = (byte)45;
	geoidSimple[15][358] = (byte)45;
	geoidSimple[15][359] = (byte)45;
	}
		/** Row 16*/
	private static void init16() {
	geoidSimple[16][0] = (byte)47;
	geoidSimple[16][1] = (byte)46;
	geoidSimple[16][2] = (byte)46;
	geoidSimple[16][3] = (byte)46;
	geoidSimple[16][4] = (byte)45;
	geoidSimple[16][5] = (byte)45;
	geoidSimple[16][6] = (byte)45;
	geoidSimple[16][7] = (byte)45;
	geoidSimple[16][8] = (byte)44;
	geoidSimple[16][9] = (byte)43;
	geoidSimple[16][10] = (byte)42;
	geoidSimple[16][11] = (byte)42;
	geoidSimple[16][12] = (byte)41;
	geoidSimple[16][13] = (byte)40;
	geoidSimple[16][14] = (byte)39;
	geoidSimple[16][15] = (byte)38;
	geoidSimple[16][16] = (byte)37;
	geoidSimple[16][17] = (byte)35;
	geoidSimple[16][18] = (byte)33;
	geoidSimple[16][19] = (byte)31;
	geoidSimple[16][20] = (byte)29;
	geoidSimple[16][21] = (byte)28;
	geoidSimple[16][22] = (byte)26;
	geoidSimple[16][23] = (byte)25;
	geoidSimple[16][24] = (byte)24;
	geoidSimple[16][25] = (byte)23;
	geoidSimple[16][26] = (byte)22;
	geoidSimple[16][27] = (byte)21;
	geoidSimple[16][28] = (byte)20;
	geoidSimple[16][29] = (byte)19;
	geoidSimple[16][30] = (byte)18;
	geoidSimple[16][31] = (byte)18;
	geoidSimple[16][32] = (byte)17;
	geoidSimple[16][33] = (byte)16;
	geoidSimple[16][34] = (byte)15;
	geoidSimple[16][35] = (byte)15;
	geoidSimple[16][36] = (byte)14;
	geoidSimple[16][37] = (byte)13;
	geoidSimple[16][38] = (byte)12;
	geoidSimple[16][39] = (byte)11;
	geoidSimple[16][40] = (byte)10;
	geoidSimple[16][41] = (byte)9;
	geoidSimple[16][42] = (byte)8;
	geoidSimple[16][43] = (byte)8;
	geoidSimple[16][44] = (byte)7;
	geoidSimple[16][45] = (byte)6;
	geoidSimple[16][46] = (byte)6;
	geoidSimple[16][47] = (byte)5;
	geoidSimple[16][48] = (byte)4;
	geoidSimple[16][49] = (byte)3;
	geoidSimple[16][50] = (byte)3;
	geoidSimple[16][51] = (byte)2;
	geoidSimple[16][52] = (byte)1;
	geoidSimple[16][53] = (byte)1;
	geoidSimple[16][54] = (byte)1;
	geoidSimple[16][55] = (byte)1;
	geoidSimple[16][56] = (byte)1;
	geoidSimple[16][57] = (byte)0;
	geoidSimple[16][58] = (byte)0;
	geoidSimple[16][59] = (byte)-1;
	geoidSimple[16][60] = (byte)-2;
	geoidSimple[16][61] = (byte)-2;
	geoidSimple[16][62] = (byte)-3;
	geoidSimple[16][63] = (byte)-3;
	geoidSimple[16][64] = (byte)-3;
	geoidSimple[16][65] = (byte)-4;
	geoidSimple[16][66] = (byte)-4;
	geoidSimple[16][67] = (byte)-4;
	geoidSimple[16][68] = (byte)-4;
	geoidSimple[16][69] = (byte)-5;
	geoidSimple[16][70] = (byte)-5;
	geoidSimple[16][71] = (byte)-5;
	geoidSimple[16][72] = (byte)-6;
	geoidSimple[16][73] = (byte)-6;
	geoidSimple[16][74] = (byte)-6;
	geoidSimple[16][75] = (byte)-7;
	geoidSimple[16][76] = (byte)-7;
	geoidSimple[16][77] = (byte)-8;
	geoidSimple[16][78] = (byte)-8;
	geoidSimple[16][79] = (byte)-8;
	geoidSimple[16][80] = (byte)-8;
	geoidSimple[16][81] = (byte)-8;
	geoidSimple[16][82] = (byte)-8;
	geoidSimple[16][83] = (byte)-9;
	geoidSimple[16][84] = (byte)-9;
	geoidSimple[16][85] = (byte)-10;
	geoidSimple[16][86] = (byte)-10;
	geoidSimple[16][87] = (byte)-10;
	geoidSimple[16][88] = (byte)-10;
	geoidSimple[16][89] = (byte)-10;
	geoidSimple[16][90] = (byte)-10;
	geoidSimple[16][91] = (byte)-10;
	geoidSimple[16][92] = (byte)-10;
	geoidSimple[16][93] = (byte)-9;
	geoidSimple[16][94] = (byte)-9;
	geoidSimple[16][95] = (byte)-10;
	geoidSimple[16][96] = (byte)-10;
	geoidSimple[16][97] = (byte)-11;
	geoidSimple[16][98] = (byte)-11;
	geoidSimple[16][99] = (byte)-11;
	geoidSimple[16][100] = (byte)-11;
	geoidSimple[16][101] = (byte)-11;
	geoidSimple[16][102] = (byte)-11;
	geoidSimple[16][103] = (byte)-11;
	geoidSimple[16][104] = (byte)-11;
	geoidSimple[16][105] = (byte)-11;
	geoidSimple[16][106] = (byte)-11;
	geoidSimple[16][107] = (byte)-10;
	geoidSimple[16][108] = (byte)-10;
	geoidSimple[16][109] = (byte)-9;
	geoidSimple[16][110] = (byte)-9;
	geoidSimple[16][111] = (byte)-9;
	geoidSimple[16][112] = (byte)-9;
	geoidSimple[16][113] = (byte)-8;
	geoidSimple[16][114] = (byte)-8;
	geoidSimple[16][115] = (byte)-7;
	geoidSimple[16][116] = (byte)-7;
	geoidSimple[16][117] = (byte)-7;
	geoidSimple[16][118] = (byte)-7;
	geoidSimple[16][119] = (byte)-6;
	geoidSimple[16][120] = (byte)-6;
	geoidSimple[16][121] = (byte)-5;
	geoidSimple[16][122] = (byte)-5;
	geoidSimple[16][123] = (byte)-5;
	geoidSimple[16][124] = (byte)-5;
	geoidSimple[16][125] = (byte)-5;
	geoidSimple[16][126] = (byte)-5;
	geoidSimple[16][127] = (byte)-4;
	geoidSimple[16][128] = (byte)-4;
	geoidSimple[16][129] = (byte)-4;
	geoidSimple[16][130] = (byte)-3;
	geoidSimple[16][131] = (byte)-3;
	geoidSimple[16][132] = (byte)-3;
	geoidSimple[16][133] = (byte)-2;
	geoidSimple[16][134] = (byte)-2;
	geoidSimple[16][135] = (byte)-2;
	geoidSimple[16][136] = (byte)-2;
	geoidSimple[16][137] = (byte)-1;
	geoidSimple[16][138] = (byte)-1;
	geoidSimple[16][139] = (byte)-1;
	geoidSimple[16][140] = (byte)-1;
	geoidSimple[16][141] = (byte)0;
	geoidSimple[16][142] = (byte)0;
	geoidSimple[16][143] = (byte)0;
	geoidSimple[16][144] = (byte)0;
	geoidSimple[16][145] = (byte)0;
	geoidSimple[16][146] = (byte)0;
	geoidSimple[16][147] = (byte)0;
	geoidSimple[16][148] = (byte)0;
	geoidSimple[16][149] = (byte)0;
	geoidSimple[16][150] = (byte)0;
	geoidSimple[16][151] = (byte)1;
	geoidSimple[16][152] = (byte)1;
	geoidSimple[16][153] = (byte)2;
	geoidSimple[16][154] = (byte)2;
	geoidSimple[16][155] = (byte)3;
	geoidSimple[16][156] = (byte)3;
	geoidSimple[16][157] = (byte)2;
	geoidSimple[16][158] = (byte)1;
	geoidSimple[16][159] = (byte)0;
	geoidSimple[16][160] = (byte)0;
	geoidSimple[16][161] = (byte)1;
	geoidSimple[16][162] = (byte)0;
	geoidSimple[16][163] = (byte)0;
	geoidSimple[16][164] = (byte)0;
	geoidSimple[16][165] = (byte)1;
	geoidSimple[16][166] = (byte)1;
	geoidSimple[16][167] = (byte)1;
	geoidSimple[16][168] = (byte)1;
	geoidSimple[16][169] = (byte)1;
	geoidSimple[16][170] = (byte)1;
	geoidSimple[16][171] = (byte)1;
	geoidSimple[16][172] = (byte)1;
	geoidSimple[16][173] = (byte)1;
	geoidSimple[16][174] = (byte)1;
	geoidSimple[16][175] = (byte)1;
	geoidSimple[16][176] = (byte)1;
	geoidSimple[16][177] = (byte)1;
	geoidSimple[16][178] = (byte)1;
	geoidSimple[16][179] = (byte)1;
	geoidSimple[16][LAT_GRID_SIZE] = (byte)1;
	geoidSimple[16][181] = (byte)1;
	geoidSimple[16][182] = (byte)1;
	geoidSimple[16][183] = (byte)1;
	geoidSimple[16][184] = (byte)0;
	geoidSimple[16][185] = (byte)0;
	geoidSimple[16][186] = (byte)0;
	geoidSimple[16][187] = (byte)0;
	geoidSimple[16][188] = (byte)0;
	geoidSimple[16][189] = (byte)0;
	geoidSimple[16][190] = (byte)1;
	geoidSimple[16][191] = (byte)1;
	geoidSimple[16][192] = (byte)1;
	geoidSimple[16][193] = (byte)0;
	geoidSimple[16][194] = (byte)0;
	geoidSimple[16][195] = (byte)0;
	geoidSimple[16][196] = (byte)0;
	geoidSimple[16][197] = (byte)0;
	geoidSimple[16][198] = (byte)0;
	geoidSimple[16][199] = (byte)-1;
	geoidSimple[16][200] = (byte)-2;
	geoidSimple[16][201] = (byte)-3;
	geoidSimple[16][202] = (byte)-4;
	geoidSimple[16][203] = (byte)-5;
	geoidSimple[16][204] = (byte)-5;
	geoidSimple[16][205] = (byte)-5;
	geoidSimple[16][206] = (byte)-6;
	geoidSimple[16][207] = (byte)-6;
	geoidSimple[16][208] = (byte)-6;
	geoidSimple[16][209] = (byte)-7;
	geoidSimple[16][210] = (byte)-7;
	geoidSimple[16][211] = (byte)-7;
	geoidSimple[16][212] = (byte)-6;
	geoidSimple[16][213] = (byte)-5;
	geoidSimple[16][214] = (byte)-5;
	geoidSimple[16][215] = (byte)-5;
	geoidSimple[16][216] = (byte)-6;
	geoidSimple[16][217] = (byte)-6;
	geoidSimple[16][218] = (byte)-7;
	geoidSimple[16][219] = (byte)-7;
	geoidSimple[16][220] = (byte)-8;
	geoidSimple[16][221] = (byte)-8;
	geoidSimple[16][222] = (byte)-8;
	geoidSimple[16][223] = (byte)-9;
	geoidSimple[16][224] = (byte)-9;
	geoidSimple[16][225] = (byte)-9;
	geoidSimple[16][226] = (byte)-9;
	geoidSimple[16][227] = (byte)-9;
	geoidSimple[16][228] = (byte)-8;
	geoidSimple[16][229] = (byte)-7;
	geoidSimple[16][230] = (byte)-6;
	geoidSimple[16][231] = (byte)-6;
	geoidSimple[16][232] = (byte)-7;
	geoidSimple[16][233] = (byte)-8;
	geoidSimple[16][234] = (byte)-9;
	geoidSimple[16][235] = (byte)-9;
	geoidSimple[16][236] = (byte)-9;
	geoidSimple[16][237] = (byte)-9;
	geoidSimple[16][238] = (byte)-9;
	geoidSimple[16][239] = (byte)-9;
	geoidSimple[16][240] = (byte)-10;
	geoidSimple[16][241] = (byte)-11;
	geoidSimple[16][242] = (byte)-12;
	geoidSimple[16][243] = (byte)-13;
	geoidSimple[16][244] = (byte)-14;
	geoidSimple[16][245] = (byte)-15;
	geoidSimple[16][246] = (byte)-15;
	geoidSimple[16][247] = (byte)-16;
	geoidSimple[16][248] = (byte)-17;
	geoidSimple[16][249] = (byte)-17;
	geoidSimple[16][250] = (byte)-17;
	geoidSimple[16][251] = (byte)-18;
	geoidSimple[16][252] = (byte)-18;
	geoidSimple[16][253] = (byte)-18;
	geoidSimple[16][254] = (byte)-18;
	geoidSimple[16][255] = (byte)-18;
	geoidSimple[16][256] = (byte)-18;
	geoidSimple[16][257] = (byte)-17;
	geoidSimple[16][258] = (byte)-16;
	geoidSimple[16][259] = (byte)-15;
	geoidSimple[16][260] = (byte)-14;
	geoidSimple[16][261] = (byte)-13;
	geoidSimple[16][262] = (byte)-13;
	geoidSimple[16][263] = (byte)-13;
	geoidSimple[16][264] = (byte)-12;
	geoidSimple[16][265] = (byte)-11;
	geoidSimple[16][266] = (byte)-10;
	geoidSimple[16][267] = (byte)-10;
	geoidSimple[16][268] = (byte)-10;
	geoidSimple[16][269] = (byte)-10;
	geoidSimple[16][270] = (byte)-10;
	geoidSimple[16][271] = (byte)-9;
	geoidSimple[16][272] = (byte)-8;
	geoidSimple[16][273] = (byte)-8;
	geoidSimple[16][274] = (byte)-8;
	geoidSimple[16][275] = (byte)-7;
	geoidSimple[16][276] = (byte)-6;
	geoidSimple[16][277] = (byte)-5;
	geoidSimple[16][278] = (byte)-4;
	geoidSimple[16][279] = (byte)-2;
	geoidSimple[16][280] = (byte)0;
	geoidSimple[16][281] = (byte)1;
	geoidSimple[16][282] = (byte)3;
	geoidSimple[16][283] = (byte)5;
	geoidSimple[16][284] = (byte)7;
	geoidSimple[16][285] = (byte)10;
	geoidSimple[16][286] = (byte)12;
	geoidSimple[16][287] = (byte)13;
	geoidSimple[16][288] = (byte)13;
	geoidSimple[16][289] = (byte)14;
	geoidSimple[16][290] = (byte)15;
	geoidSimple[16][291] = (byte)15;
	geoidSimple[16][292] = (byte)15;
	geoidSimple[16][293] = (byte)16;
	geoidSimple[16][294] = (byte)18;
	geoidSimple[16][295] = (byte)20;
	geoidSimple[16][296] = (byte)21;
	geoidSimple[16][297] = (byte)21;
	geoidSimple[16][298] = (byte)20;
	geoidSimple[16][299] = (byte)18;
	geoidSimple[16][300] = (byte)18;
	geoidSimple[16][301] = (byte)19;
	geoidSimple[16][302] = (byte)21;
	geoidSimple[16][303] = (byte)22;
	geoidSimple[16][304] = (byte)23;
	geoidSimple[16][305] = (byte)25;
	geoidSimple[16][306] = (byte)27;
	geoidSimple[16][307] = (byte)29;
	geoidSimple[16][308] = (byte)30;
	geoidSimple[16][309] = (byte)32;
	geoidSimple[16][310] = (byte)33;
	geoidSimple[16][311] = (byte)34;
	geoidSimple[16][312] = (byte)35;
	geoidSimple[16][313] = (byte)35;
	geoidSimple[16][314] = (byte)36;
	geoidSimple[16][315] = (byte)36;
	geoidSimple[16][316] = (byte)37;
	geoidSimple[16][317] = (byte)37;
	geoidSimple[16][318] = (byte)38;
	geoidSimple[16][319] = (byte)39;
	geoidSimple[16][320] = (byte)39;
	geoidSimple[16][321] = (byte)40;
	geoidSimple[16][322] = (byte)41;
	geoidSimple[16][323] = (byte)43;
	geoidSimple[16][324] = (byte)44;
	geoidSimple[16][325] = (byte)45;
	geoidSimple[16][326] = (byte)45;
	geoidSimple[16][327] = (byte)46;
	geoidSimple[16][328] = (byte)47;
	geoidSimple[16][329] = (byte)47;
	geoidSimple[16][330] = (byte)47;
	geoidSimple[16][331] = (byte)47;
	geoidSimple[16][332] = (byte)47;
	geoidSimple[16][333] = (byte)47;
	geoidSimple[16][334] = (byte)48;
	geoidSimple[16][335] = (byte)48;
	geoidSimple[16][336] = (byte)48;
	geoidSimple[16][337] = (byte)49;
	geoidSimple[16][338] = (byte)49;
	geoidSimple[16][339] = (byte)49;
	geoidSimple[16][340] = (byte)49;
	geoidSimple[16][341] = (byte)50;
	geoidSimple[16][342] = (byte)51;
	geoidSimple[16][343] = (byte)51;
	geoidSimple[16][344] = (byte)51;
	geoidSimple[16][345] = (byte)50;
	geoidSimple[16][346] = (byte)49;
	geoidSimple[16][347] = (byte)49;
	geoidSimple[16][348] = (byte)49;
	geoidSimple[16][349] = (byte)48;
	geoidSimple[16][350] = (byte)48;
	geoidSimple[16][351] = (byte)48;
	geoidSimple[16][352] = (byte)48;
	geoidSimple[16][353] = (byte)48;
	geoidSimple[16][354] = (byte)48;
	geoidSimple[16][355] = (byte)48;
	geoidSimple[16][356] = (byte)48;
	geoidSimple[16][357] = (byte)48;
	geoidSimple[16][358] = (byte)47;
	geoidSimple[16][359] = (byte)47;
	}
		/** Row 17*/
	private static void init17() {
	geoidSimple[17][0] = (byte)49;
	geoidSimple[17][1] = (byte)49;
	geoidSimple[17][2] = (byte)48;
	geoidSimple[17][3] = (byte)48;
	geoidSimple[17][4] = (byte)47;
	geoidSimple[17][5] = (byte)46;
	geoidSimple[17][6] = (byte)45;
	geoidSimple[17][7] = (byte)45;
	geoidSimple[17][8] = (byte)44;
	geoidSimple[17][9] = (byte)43;
	geoidSimple[17][10] = (byte)42;
	geoidSimple[17][11] = (byte)42;
	geoidSimple[17][12] = (byte)41;
	geoidSimple[17][13] = (byte)41;
	geoidSimple[17][14] = (byte)40;
	geoidSimple[17][15] = (byte)38;
	geoidSimple[17][16] = (byte)36;
	geoidSimple[17][17] = (byte)34;
	geoidSimple[17][18] = (byte)33;
	geoidSimple[17][19] = (byte)31;
	geoidSimple[17][20] = (byte)30;
	geoidSimple[17][21] = (byte)29;
	geoidSimple[17][22] = (byte)27;
	geoidSimple[17][23] = (byte)25;
	geoidSimple[17][24] = (byte)23;
	geoidSimple[17][25] = (byte)22;
	geoidSimple[17][26] = (byte)21;
	geoidSimple[17][27] = (byte)20;
	geoidSimple[17][28] = (byte)19;
	geoidSimple[17][29] = (byte)18;
	geoidSimple[17][30] = (byte)17;
	geoidSimple[17][31] = (byte)17;
	geoidSimple[17][32] = (byte)16;
	geoidSimple[17][33] = (byte)16;
	geoidSimple[17][34] = (byte)15;
	geoidSimple[17][35] = (byte)14;
	geoidSimple[17][36] = (byte)13;
	geoidSimple[17][37] = (byte)12;
	geoidSimple[17][38] = (byte)11;
	geoidSimple[17][39] = (byte)10;
	geoidSimple[17][40] = (byte)9;
	geoidSimple[17][41] = (byte)9;
	geoidSimple[17][42] = (byte)8;
	geoidSimple[17][43] = (byte)7;
	geoidSimple[17][44] = (byte)6;
	geoidSimple[17][45] = (byte)6;
	geoidSimple[17][46] = (byte)5;
	geoidSimple[17][47] = (byte)5;
	geoidSimple[17][48] = (byte)4;
	geoidSimple[17][49] = (byte)3;
	geoidSimple[17][50] = (byte)2;
	geoidSimple[17][51] = (byte)2;
	geoidSimple[17][52] = (byte)2;
	geoidSimple[17][53] = (byte)2;
	geoidSimple[17][54] = (byte)1;
	geoidSimple[17][55] = (byte)0;
	geoidSimple[17][56] = (byte)0;
	geoidSimple[17][57] = (byte)-1;
	geoidSimple[17][58] = (byte)-2;
	geoidSimple[17][59] = (byte)-2;
	geoidSimple[17][60] = (byte)-3;
	geoidSimple[17][61] = (byte)-3;
	geoidSimple[17][62] = (byte)-4;
	geoidSimple[17][63] = (byte)-4;
	geoidSimple[17][64] = (byte)-4;
	geoidSimple[17][65] = (byte)-5;
	geoidSimple[17][66] = (byte)-5;
	geoidSimple[17][67] = (byte)-5;
	geoidSimple[17][68] = (byte)-6;
	geoidSimple[17][69] = (byte)-6;
	geoidSimple[17][70] = (byte)-6;
	geoidSimple[17][71] = (byte)-7;
	geoidSimple[17][72] = (byte)-7;
	geoidSimple[17][73] = (byte)-7;
	geoidSimple[17][74] = (byte)-7;
	geoidSimple[17][75] = (byte)-7;
	geoidSimple[17][76] = (byte)-7;
	geoidSimple[17][77] = (byte)-8;
	geoidSimple[17][78] = (byte)-8;
	geoidSimple[17][79] = (byte)-9;
	geoidSimple[17][80] = (byte)-9;
	geoidSimple[17][81] = (byte)-9;
	geoidSimple[17][82] = (byte)-9;
	geoidSimple[17][83] = (byte)-10;
	geoidSimple[17][84] = (byte)-10;
	geoidSimple[17][85] = (byte)-11;
	geoidSimple[17][86] = (byte)-11;
	geoidSimple[17][87] = (byte)-11;
	geoidSimple[17][88] = (byte)-11;
	geoidSimple[17][89] = (byte)-11;
	geoidSimple[17][90] = (byte)-11;
	geoidSimple[17][91] = (byte)-11;
	geoidSimple[17][92] = (byte)-12;
	geoidSimple[17][93] = (byte)-12;
	geoidSimple[17][94] = (byte)-12;
	geoidSimple[17][95] = (byte)-13;
	geoidSimple[17][96] = (byte)-12;
	geoidSimple[17][97] = (byte)-12;
	geoidSimple[17][98] = (byte)-12;
	geoidSimple[17][99] = (byte)-12;
	geoidSimple[17][100] = (byte)-12;
	geoidSimple[17][101] = (byte)-12;
	geoidSimple[17][102] = (byte)-13;
	geoidSimple[17][103] = (byte)-13;
	geoidSimple[17][104] = (byte)-13;
	geoidSimple[17][105] = (byte)-12;
	geoidSimple[17][106] = (byte)-11;
	geoidSimple[17][107] = (byte)-10;
	geoidSimple[17][108] = (byte)-10;
	geoidSimple[17][109] = (byte)-10;
	geoidSimple[17][110] = (byte)-10;
	geoidSimple[17][111] = (byte)-10;
	geoidSimple[17][112] = (byte)-9;
	geoidSimple[17][113] = (byte)-9;
	geoidSimple[17][114] = (byte)-9;
	geoidSimple[17][115] = (byte)-9;
	geoidSimple[17][116] = (byte)-9;
	geoidSimple[17][117] = (byte)-8;
	geoidSimple[17][118] = (byte)-8;
	geoidSimple[17][119] = (byte)-8;
	geoidSimple[17][120] = (byte)-8;
	geoidSimple[17][121] = (byte)-7;
	geoidSimple[17][122] = (byte)-7;
	geoidSimple[17][123] = (byte)-6;
	geoidSimple[17][124] = (byte)-6;
	geoidSimple[17][125] = (byte)-6;
	geoidSimple[17][126] = (byte)-6;
	geoidSimple[17][127] = (byte)-6;
	geoidSimple[17][128] = (byte)-6;
	geoidSimple[17][129] = (byte)-5;
	geoidSimple[17][130] = (byte)-5;
	geoidSimple[17][131] = (byte)-4;
	geoidSimple[17][132] = (byte)-4;
	geoidSimple[17][133] = (byte)-3;
	geoidSimple[17][134] = (byte)-3;
	geoidSimple[17][135] = (byte)-3;
	geoidSimple[17][136] = (byte)-2;
	geoidSimple[17][137] = (byte)-2;
	geoidSimple[17][138] = (byte)-2;
	geoidSimple[17][139] = (byte)-1;
	geoidSimple[17][140] = (byte)-1;
	geoidSimple[17][141] = (byte)-1;
	geoidSimple[17][142] = (byte)0;
	geoidSimple[17][143] = (byte)0;
	geoidSimple[17][144] = (byte)0;
	geoidSimple[17][145] = (byte)0;
	geoidSimple[17][146] = (byte)0;
	geoidSimple[17][147] = (byte)0;
	geoidSimple[17][148] = (byte)0;
	geoidSimple[17][149] = (byte)0;
	geoidSimple[17][150] = (byte)0;
	geoidSimple[17][151] = (byte)0;
	geoidSimple[17][152] = (byte)1;
	geoidSimple[17][153] = (byte)1;
	geoidSimple[17][154] = (byte)1;
	geoidSimple[17][155] = (byte)1;
	geoidSimple[17][156] = (byte)1;
	geoidSimple[17][157] = (byte)1;
	geoidSimple[17][158] = (byte)1;
	geoidSimple[17][159] = (byte)1;
	geoidSimple[17][160] = (byte)1;
	geoidSimple[17][161] = (byte)1;
	geoidSimple[17][162] = (byte)1;
	geoidSimple[17][163] = (byte)1;
	geoidSimple[17][164] = (byte)1;
	geoidSimple[17][165] = (byte)1;
	geoidSimple[17][166] = (byte)1;
	geoidSimple[17][167] = (byte)1;
	geoidSimple[17][168] = (byte)1;
	geoidSimple[17][169] = (byte)1;
	geoidSimple[17][170] = (byte)1;
	geoidSimple[17][171] = (byte)1;
	geoidSimple[17][172] = (byte)1;
	geoidSimple[17][173] = (byte)1;
	geoidSimple[17][174] = (byte)1;
	geoidSimple[17][175] = (byte)1;
	geoidSimple[17][176] = (byte)1;
	geoidSimple[17][177] = (byte)1;
	geoidSimple[17][178] = (byte)1;
	geoidSimple[17][179] = (byte)1;
	geoidSimple[17][LAT_GRID_SIZE] = (byte)1;
	geoidSimple[17][181] = (byte)1;
	geoidSimple[17][182] = (byte)1;
	geoidSimple[17][183] = (byte)0;
	geoidSimple[17][184] = (byte)0;
	geoidSimple[17][185] = (byte)0;
	geoidSimple[17][186] = (byte)0;
	geoidSimple[17][187] = (byte)0;
	geoidSimple[17][188] = (byte)0;
	geoidSimple[17][189] = (byte)0;
	geoidSimple[17][190] = (byte)0;
	geoidSimple[17][191] = (byte)0;
	geoidSimple[17][192] = (byte)0;
	geoidSimple[17][193] = (byte)0;
	geoidSimple[17][194] = (byte)0;
	geoidSimple[17][195] = (byte)0;
	geoidSimple[17][196] = (byte)0;
	geoidSimple[17][197] = (byte)0;
	geoidSimple[17][198] = (byte)0;
	geoidSimple[17][199] = (byte)0;
	geoidSimple[17][200] = (byte)0;
	geoidSimple[17][201] = (byte)0;
	geoidSimple[17][202] = (byte)-1;
	geoidSimple[17][203] = (byte)-2;
	geoidSimple[17][204] = (byte)-3;
	geoidSimple[17][205] = (byte)-4;
	geoidSimple[17][206] = (byte)-5;
	geoidSimple[17][207] = (byte)-6;
	geoidSimple[17][208] = (byte)-7;
	geoidSimple[17][209] = (byte)-7;
	geoidSimple[17][210] = (byte)-8;
	geoidSimple[17][211] = (byte)-8;
	geoidSimple[17][212] = (byte)-8;
	geoidSimple[17][213] = (byte)-8;
	geoidSimple[17][214] = (byte)-8;
	geoidSimple[17][215] = (byte)-7;
	geoidSimple[17][216] = (byte)-7;
	geoidSimple[17][217] = (byte)-7;
	geoidSimple[17][218] = (byte)-8;
	geoidSimple[17][219] = (byte)-8;
	geoidSimple[17][220] = (byte)-8;
	geoidSimple[17][221] = (byte)-7;
	geoidSimple[17][222] = (byte)-7;
	geoidSimple[17][223] = (byte)-8;
	geoidSimple[17][224] = (byte)-8;
	geoidSimple[17][225] = (byte)-8;
	geoidSimple[17][226] = (byte)-8;
	geoidSimple[17][227] = (byte)-7;
	geoidSimple[17][228] = (byte)-6;
	geoidSimple[17][229] = (byte)-6;
	geoidSimple[17][230] = (byte)-6;
	geoidSimple[17][231] = (byte)-7;
	geoidSimple[17][232] = (byte)-9;
	geoidSimple[17][233] = (byte)-10;
	geoidSimple[17][234] = (byte)-10;
	geoidSimple[17][235] = (byte)-10;
	geoidSimple[17][236] = (byte)-9;
	geoidSimple[17][237] = (byte)-8;
	geoidSimple[17][238] = (byte)-8;
	geoidSimple[17][239] = (byte)-9;
	geoidSimple[17][240] = (byte)-10;
	geoidSimple[17][241] = (byte)-11;
	geoidSimple[17][242] = (byte)-12;
	geoidSimple[17][243] = (byte)-13;
	geoidSimple[17][244] = (byte)-14;
	geoidSimple[17][245] = (byte)-15;
	geoidSimple[17][246] = (byte)-17;
	geoidSimple[17][247] = (byte)-18;
	geoidSimple[17][248] = (byte)-19;
	geoidSimple[17][249] = (byte)-20;
	geoidSimple[17][250] = (byte)-20;
	geoidSimple[17][251] = (byte)-20;
	geoidSimple[17][252] = (byte)-20;
	geoidSimple[17][253] = (byte)-20;
	geoidSimple[17][254] = (byte)-20;
	geoidSimple[17][255] = (byte)-21;
	geoidSimple[17][256] = (byte)-21;
	geoidSimple[17][257] = (byte)-20;
	geoidSimple[17][258] = (byte)-19;
	geoidSimple[17][259] = (byte)-18;
	geoidSimple[17][260] = (byte)-17;
	geoidSimple[17][261] = (byte)-16;
	geoidSimple[17][262] = (byte)-16;
	geoidSimple[17][263] = (byte)-15;
	geoidSimple[17][264] = (byte)-14;
	geoidSimple[17][265] = (byte)-13;
	geoidSimple[17][266] = (byte)-13;
	geoidSimple[17][267] = (byte)-13;
	geoidSimple[17][268] = (byte)-14;
	geoidSimple[17][269] = (byte)-14;
	geoidSimple[17][270] = (byte)-13;
	geoidSimple[17][271] = (byte)-12;
	geoidSimple[17][272] = (byte)-12;
	geoidSimple[17][273] = (byte)-12;
	geoidSimple[17][274] = (byte)-11;
	geoidSimple[17][275] = (byte)-10;
	geoidSimple[17][276] = (byte)-8;
	geoidSimple[17][277] = (byte)-7;
	geoidSimple[17][278] = (byte)-6;
	geoidSimple[17][279] = (byte)-6;
	geoidSimple[17][280] = (byte)-5;
	geoidSimple[17][281] = (byte)-2;
	geoidSimple[17][282] = (byte)0;
	geoidSimple[17][283] = (byte)1;
	geoidSimple[17][284] = (byte)3;
	geoidSimple[17][285] = (byte)5;
	geoidSimple[17][286] = (byte)7;
	geoidSimple[17][287] = (byte)10;
	geoidSimple[17][288] = (byte)11;
	geoidSimple[17][289] = (byte)12;
	geoidSimple[17][290] = (byte)12;
	geoidSimple[17][291] = (byte)12;
	geoidSimple[17][292] = (byte)13;
	geoidSimple[17][293] = (byte)14;
	geoidSimple[17][294] = (byte)15;
	geoidSimple[17][295] = (byte)16;
	geoidSimple[17][296] = (byte)18;
	geoidSimple[17][297] = (byte)21;
	geoidSimple[17][298] = (byte)22;
	geoidSimple[17][299] = (byte)22;
	geoidSimple[17][300] = (byte)22;
	geoidSimple[17][301] = (byte)23;
	geoidSimple[17][302] = (byte)23;
	geoidSimple[17][303] = (byte)23;
	geoidSimple[17][304] = (byte)24;
	geoidSimple[17][305] = (byte)25;
	geoidSimple[17][306] = (byte)28;
	geoidSimple[17][307] = (byte)30;
	geoidSimple[17][308] = (byte)32;
	geoidSimple[17][309] = (byte)33;
	geoidSimple[17][310] = (byte)35;
	geoidSimple[17][311] = (byte)36;
	geoidSimple[17][312] = (byte)37;
	geoidSimple[17][313] = (byte)37;
	geoidSimple[17][314] = (byte)37;
	geoidSimple[17][315] = (byte)38;
	geoidSimple[17][316] = (byte)39;
	geoidSimple[17][317] = (byte)39;
	geoidSimple[17][318] = (byte)40;
	geoidSimple[17][319] = (byte)41;
	geoidSimple[17][320] = (byte)42;
	geoidSimple[17][321] = (byte)43;
	geoidSimple[17][322] = (byte)44;
	geoidSimple[17][323] = (byte)46;
	geoidSimple[17][324] = (byte)47;
	geoidSimple[17][325] = (byte)48;
	geoidSimple[17][326] = (byte)48;
	geoidSimple[17][327] = (byte)48;
	geoidSimple[17][328] = (byte)49;
	geoidSimple[17][329] = (byte)49;
	geoidSimple[17][330] = (byte)49;
	geoidSimple[17][331] = (byte)49;
	geoidSimple[17][332] = (byte)50;
	geoidSimple[17][333] = (byte)51;
	geoidSimple[17][334] = (byte)51;
	geoidSimple[17][335] = (byte)50;
	geoidSimple[17][336] = (byte)50;
	geoidSimple[17][337] = (byte)51;
	geoidSimple[17][338] = (byte)52;
	geoidSimple[17][339] = (byte)52;
	geoidSimple[17][340] = (byte)52;
	geoidSimple[17][341] = (byte)53;
	geoidSimple[17][342] = (byte)53;
	geoidSimple[17][343] = (byte)52;
	geoidSimple[17][344] = (byte)52;
	geoidSimple[17][345] = (byte)51;
	geoidSimple[17][346] = (byte)51;
	geoidSimple[17][347] = (byte)51;
	geoidSimple[17][348] = (byte)51;
	geoidSimple[17][349] = (byte)51;
	geoidSimple[17][350] = (byte)51;
	geoidSimple[17][351] = (byte)51;
	geoidSimple[17][352] = (byte)51;
	geoidSimple[17][353] = (byte)51;
	geoidSimple[17][354] = (byte)51;
	geoidSimple[17][355] = (byte)50;
	geoidSimple[17][356] = (byte)50;
	geoidSimple[17][357] = (byte)50;
	geoidSimple[17][358] = (byte)50;
	geoidSimple[17][359] = (byte)49;
	}
		/** Row 18*/
	private static void init18() {
	geoidSimple[18][0] = (byte)50;
	geoidSimple[18][1] = (byte)49;
	geoidSimple[18][2] = (byte)48;
	geoidSimple[18][3] = (byte)47;
	geoidSimple[18][4] = (byte)46;
	geoidSimple[18][5] = (byte)45;
	geoidSimple[18][6] = (byte)44;
	geoidSimple[18][7] = (byte)44;
	geoidSimple[18][8] = (byte)43;
	geoidSimple[18][9] = (byte)42;
	geoidSimple[18][10] = (byte)42;
	geoidSimple[18][11] = (byte)41;
	geoidSimple[18][12] = (byte)40;
	geoidSimple[18][13] = (byte)40;
	geoidSimple[18][14] = (byte)40;
	geoidSimple[18][15] = (byte)38;
	geoidSimple[18][16] = (byte)36;
	geoidSimple[18][17] = (byte)34;
	geoidSimple[18][18] = (byte)32;
	geoidSimple[18][19] = (byte)30;
	geoidSimple[18][20] = (byte)29;
	geoidSimple[18][21] = (byte)27;
	geoidSimple[18][22] = (byte)26;
	geoidSimple[18][23] = (byte)25;
	geoidSimple[18][24] = (byte)24;
	geoidSimple[18][25] = (byte)23;
	geoidSimple[18][26] = (byte)22;
	geoidSimple[18][27] = (byte)21;
	geoidSimple[18][28] = (byte)20;
	geoidSimple[18][29] = (byte)18;
	geoidSimple[18][30] = (byte)17;
	geoidSimple[18][31] = (byte)17;
	geoidSimple[18][32] = (byte)16;
	geoidSimple[18][33] = (byte)15;
	geoidSimple[18][34] = (byte)15;
	geoidSimple[18][35] = (byte)14;
	geoidSimple[18][36] = (byte)14;
	geoidSimple[18][37] = (byte)12;
	geoidSimple[18][38] = (byte)11;
	geoidSimple[18][39] = (byte)10;
	geoidSimple[18][40] = (byte)9;
	geoidSimple[18][41] = (byte)8;
	geoidSimple[18][42] = (byte)8;
	geoidSimple[18][43] = (byte)7;
	geoidSimple[18][44] = (byte)7;
	geoidSimple[18][45] = (byte)6;
	geoidSimple[18][46] = (byte)6;
	geoidSimple[18][47] = (byte)5;
	geoidSimple[18][48] = (byte)4;
	geoidSimple[18][49] = (byte)3;
	geoidSimple[18][50] = (byte)2;
	geoidSimple[18][51] = (byte)2;
	geoidSimple[18][52] = (byte)1;
	geoidSimple[18][53] = (byte)1;
	geoidSimple[18][54] = (byte)1;
	geoidSimple[18][55] = (byte)0;
	geoidSimple[18][56] = (byte)-1;
	geoidSimple[18][57] = (byte)-2;
	geoidSimple[18][58] = (byte)-2;
	geoidSimple[18][59] = (byte)-3;
	geoidSimple[18][60] = (byte)-4;
	geoidSimple[18][61] = (byte)-4;
	geoidSimple[18][62] = (byte)-5;
	geoidSimple[18][63] = (byte)-5;
	geoidSimple[18][64] = (byte)-6;
	geoidSimple[18][65] = (byte)-6;
	geoidSimple[18][66] = (byte)-6;
	geoidSimple[18][67] = (byte)-7;
	geoidSimple[18][68] = (byte)-7;
	geoidSimple[18][69] = (byte)-7;
	geoidSimple[18][70] = (byte)-8;
	geoidSimple[18][71] = (byte)-8;
	geoidSimple[18][72] = (byte)-8;
	geoidSimple[18][73] = (byte)-8;
	geoidSimple[18][74] = (byte)-8;
	geoidSimple[18][75] = (byte)-8;
	geoidSimple[18][76] = (byte)-8;
	geoidSimple[18][77] = (byte)-9;
	geoidSimple[18][78] = (byte)-9;
	geoidSimple[18][79] = (byte)-10;
	geoidSimple[18][80] = (byte)-10;
	geoidSimple[18][81] = (byte)-11;
	geoidSimple[18][82] = (byte)-11;
	geoidSimple[18][83] = (byte)-11;
	geoidSimple[18][84] = (byte)-12;
	geoidSimple[18][85] = (byte)-12;
	geoidSimple[18][86] = (byte)-13;
	geoidSimple[18][87] = (byte)-13;
	geoidSimple[18][88] = (byte)-13;
	geoidSimple[18][89] = (byte)-13;
	geoidSimple[18][90] = (byte)-13;
	geoidSimple[18][91] = (byte)-13;
	geoidSimple[18][92] = (byte)-13;
	geoidSimple[18][93] = (byte)-13;
	geoidSimple[18][94] = (byte)-13;
	geoidSimple[18][95] = (byte)-13;
	geoidSimple[18][96] = (byte)-13;
	geoidSimple[18][97] = (byte)-12;
	geoidSimple[18][98] = (byte)-12;
	geoidSimple[18][99] = (byte)-12;
	geoidSimple[18][100] = (byte)-12;
	geoidSimple[18][101] = (byte)-13;
	geoidSimple[18][102] = (byte)-13;
	geoidSimple[18][103] = (byte)-13;
	geoidSimple[18][104] = (byte)-12;
	geoidSimple[18][105] = (byte)-11;
	geoidSimple[18][106] = (byte)-11;
	geoidSimple[18][107] = (byte)-10;
	geoidSimple[18][108] = (byte)-9;
	geoidSimple[18][109] = (byte)-9;
	geoidSimple[18][110] = (byte)-10;
	geoidSimple[18][111] = (byte)-10;
	geoidSimple[18][112] = (byte)-10;
	geoidSimple[18][113] = (byte)-9;
	geoidSimple[18][114] = (byte)-9;
	geoidSimple[18][115] = (byte)-9;
	geoidSimple[18][116] = (byte)-9;
	geoidSimple[18][117] = (byte)-9;
	geoidSimple[18][118] = (byte)-9;
	geoidSimple[18][119] = (byte)-8;
	geoidSimple[18][120] = (byte)-8;
	geoidSimple[18][121] = (byte)-7;
	geoidSimple[18][122] = (byte)-7;
	geoidSimple[18][123] = (byte)-6;
	geoidSimple[18][124] = (byte)-6;
	geoidSimple[18][125] = (byte)-6;
	geoidSimple[18][126] = (byte)-6;
	geoidSimple[18][127] = (byte)-7;
	geoidSimple[18][128] = (byte)-6;
	geoidSimple[18][129] = (byte)-6;
	geoidSimple[18][130] = (byte)-6;
	geoidSimple[18][131] = (byte)-5;
	geoidSimple[18][132] = (byte)-5;
	geoidSimple[18][133] = (byte)-4;
	geoidSimple[18][134] = (byte)-4;
	geoidSimple[18][135] = (byte)-3;
	geoidSimple[18][136] = (byte)-3;
	geoidSimple[18][137] = (byte)-3;
	geoidSimple[18][138] = (byte)-2;
	geoidSimple[18][139] = (byte)-2;
	geoidSimple[18][140] = (byte)-2;
	geoidSimple[18][141] = (byte)-1;
	geoidSimple[18][142] = (byte)-1;
	geoidSimple[18][143] = (byte)-1;
	geoidSimple[18][144] = (byte)0;
	geoidSimple[18][145] = (byte)0;
	geoidSimple[18][146] = (byte)0;
	geoidSimple[18][147] = (byte)0;
	geoidSimple[18][148] = (byte)0;
	geoidSimple[18][149] = (byte)0;
	geoidSimple[18][150] = (byte)0;
	geoidSimple[18][151] = (byte)0;
	geoidSimple[18][152] = (byte)0;
	geoidSimple[18][153] = (byte)1;
	geoidSimple[18][154] = (byte)1;
	geoidSimple[18][155] = (byte)1;
	geoidSimple[18][156] = (byte)1;
	geoidSimple[18][157] = (byte)1;
	geoidSimple[18][158] = (byte)1;
	geoidSimple[18][159] = (byte)2;
	geoidSimple[18][160] = (byte)2;
	geoidSimple[18][161] = (byte)2;
	geoidSimple[18][162] = (byte)2;
	geoidSimple[18][163] = (byte)3;
	geoidSimple[18][164] = (byte)3;
	geoidSimple[18][165] = (byte)2;
	geoidSimple[18][166] = (byte)2;
	geoidSimple[18][167] = (byte)2;
	geoidSimple[18][168] = (byte)2;
	geoidSimple[18][169] = (byte)2;
	geoidSimple[18][170] = (byte)2;
	geoidSimple[18][171] = (byte)2;
	geoidSimple[18][172] = (byte)2;
	geoidSimple[18][173] = (byte)2;
	geoidSimple[18][174] = (byte)2;
	geoidSimple[18][175] = (byte)2;
	geoidSimple[18][176] = (byte)2;
	geoidSimple[18][177] = (byte)2;
	geoidSimple[18][178] = (byte)2;
	geoidSimple[18][179] = (byte)2;
	geoidSimple[18][LAT_GRID_SIZE] = (byte)2;
	geoidSimple[18][181] = (byte)2;
	geoidSimple[18][182] = (byte)1;
	geoidSimple[18][183] = (byte)0;
	geoidSimple[18][184] = (byte)0;
	geoidSimple[18][185] = (byte)0;
	geoidSimple[18][186] = (byte)0;
	geoidSimple[18][187] = (byte)0;
	geoidSimple[18][188] = (byte)0;
	geoidSimple[18][189] = (byte)0;
	geoidSimple[18][190] = (byte)0;
	geoidSimple[18][191] = (byte)0;
	geoidSimple[18][192] = (byte)0;
	geoidSimple[18][193] = (byte)0;
	geoidSimple[18][194] = (byte)0;
	geoidSimple[18][195] = (byte)0;
	geoidSimple[18][196] = (byte)0;
	geoidSimple[18][197] = (byte)0;
	geoidSimple[18][198] = (byte)0;
	geoidSimple[18][199] = (byte)0;
	geoidSimple[18][200] = (byte)0;
	geoidSimple[18][201] = (byte)0;
	geoidSimple[18][202] = (byte)0;
	geoidSimple[18][203] = (byte)-1;
	geoidSimple[18][204] = (byte)-2;
	geoidSimple[18][205] = (byte)-2;
	geoidSimple[18][206] = (byte)-2;
	geoidSimple[18][207] = (byte)-2;
	geoidSimple[18][208] = (byte)-4;
	geoidSimple[18][209] = (byte)-5;
	geoidSimple[18][210] = (byte)-6;
	geoidSimple[18][211] = (byte)-6;
	geoidSimple[18][212] = (byte)-6;
	geoidSimple[18][213] = (byte)-6;
	geoidSimple[18][214] = (byte)-6;
	geoidSimple[18][215] = (byte)-6;
	geoidSimple[18][216] = (byte)-7;
	geoidSimple[18][217] = (byte)-7;
	geoidSimple[18][218] = (byte)-7;
	geoidSimple[18][219] = (byte)-7;
	geoidSimple[18][220] = (byte)-7;
	geoidSimple[18][221] = (byte)-7;
	geoidSimple[18][222] = (byte)-6;
	geoidSimple[18][223] = (byte)-6;
	geoidSimple[18][224] = (byte)-6;
	geoidSimple[18][225] = (byte)-6;
	geoidSimple[18][226] = (byte)-5;
	geoidSimple[18][227] = (byte)-4;
	geoidSimple[18][228] = (byte)-4;
	geoidSimple[18][229] = (byte)-4;
	geoidSimple[18][230] = (byte)-6;
	geoidSimple[18][231] = (byte)-9;
	geoidSimple[18][232] = (byte)-10;
	geoidSimple[18][233] = (byte)-11;
	geoidSimple[18][234] = (byte)-10;
	geoidSimple[18][235] = (byte)-10;
	geoidSimple[18][236] = (byte)-10;
	geoidSimple[18][237] = (byte)-10;
	geoidSimple[18][238] = (byte)-11;
	geoidSimple[18][239] = (byte)-12;
	geoidSimple[18][240] = (byte)-13;
	geoidSimple[18][241] = (byte)-13;
	geoidSimple[18][242] = (byte)-14;
	geoidSimple[18][243] = (byte)-15;
	geoidSimple[18][244] = (byte)-16;
	geoidSimple[18][245] = (byte)-16;
	geoidSimple[18][246] = (byte)-17;
	geoidSimple[18][247] = (byte)-18;
	geoidSimple[18][248] = (byte)-19;
	geoidSimple[18][249] = (byte)-20;
	geoidSimple[18][250] = (byte)-21;
	geoidSimple[18][251] = (byte)-22;
	geoidSimple[18][252] = (byte)-22;
	geoidSimple[18][253] = (byte)-22;
	geoidSimple[18][254] = (byte)-22;
	geoidSimple[18][255] = (byte)-23;
	geoidSimple[18][256] = (byte)-24;
	geoidSimple[18][257] = (byte)-24;
	geoidSimple[18][258] = (byte)-23;
	geoidSimple[18][259] = (byte)-22;
	geoidSimple[18][260] = (byte)-21;
	geoidSimple[18][261] = (byte)-20;
	geoidSimple[18][262] = (byte)-19;
	geoidSimple[18][263] = (byte)-19;
	geoidSimple[18][264] = (byte)-18;
	geoidSimple[18][265] = (byte)-17;
	geoidSimple[18][266] = (byte)-17;
	geoidSimple[18][267] = (byte)-18;
	geoidSimple[18][268] = (byte)-18;
	geoidSimple[18][269] = (byte)-18;
	geoidSimple[18][270] = (byte)-17;
	geoidSimple[18][271] = (byte)-16;
	geoidSimple[18][272] = (byte)-15;
	geoidSimple[18][273] = (byte)-14;
	geoidSimple[18][274] = (byte)-14;
	geoidSimple[18][275] = (byte)-13;
	geoidSimple[18][276] = (byte)-12;
	geoidSimple[18][277] = (byte)-11;
	geoidSimple[18][278] = (byte)-10;
	geoidSimple[18][279] = (byte)-9;
	geoidSimple[18][280] = (byte)-8;
	geoidSimple[18][281] = (byte)-6;
	geoidSimple[18][282] = (byte)-4;
	geoidSimple[18][283] = (byte)-2;
	geoidSimple[18][284] = (byte)0;
	geoidSimple[18][285] = (byte)0;
	geoidSimple[18][286] = (byte)1;
	geoidSimple[18][287] = (byte)2;
	geoidSimple[18][288] = (byte)4;
	geoidSimple[18][289] = (byte)6;
	geoidSimple[18][290] = (byte)7;
	geoidSimple[18][291] = (byte)9;
	geoidSimple[18][292] = (byte)11;
	geoidSimple[18][293] = (byte)12;
	geoidSimple[18][294] = (byte)13;
	geoidSimple[18][295] = (byte)15;
	geoidSimple[18][296] = (byte)17;
	geoidSimple[18][297] = (byte)18;
	geoidSimple[18][298] = (byte)21;
	geoidSimple[18][299] = (byte)23;
	geoidSimple[18][300] = (byte)24;
	geoidSimple[18][301] = (byte)25;
	geoidSimple[18][302] = (byte)26;
	geoidSimple[18][303] = (byte)26;
	geoidSimple[18][304] = (byte)27;
	geoidSimple[18][305] = (byte)27;
	geoidSimple[18][306] = (byte)28;
	geoidSimple[18][307] = (byte)29;
	geoidSimple[18][308] = (byte)31;
	geoidSimple[18][309] = (byte)33;
	geoidSimple[18][310] = (byte)34;
	geoidSimple[18][311] = (byte)35;
	geoidSimple[18][312] = (byte)36;
	geoidSimple[18][313] = (byte)37;
	geoidSimple[18][314] = (byte)38;
	geoidSimple[18][315] = (byte)39;
	geoidSimple[18][316] = (byte)39;
	geoidSimple[18][317] = (byte)40;
	geoidSimple[18][318] = (byte)41;
	geoidSimple[18][319] = (byte)42;
	geoidSimple[18][320] = (byte)44;
	geoidSimple[18][321] = (byte)45;
	geoidSimple[18][322] = (byte)46;
	geoidSimple[18][323] = (byte)47;
	geoidSimple[18][324] = (byte)48;
	geoidSimple[18][325] = (byte)49;
	geoidSimple[18][326] = (byte)50;
	geoidSimple[18][327] = (byte)51;
	geoidSimple[18][328] = (byte)51;
	geoidSimple[18][329] = (byte)52;
	geoidSimple[18][330] = (byte)52;
	geoidSimple[18][331] = (byte)51;
	geoidSimple[18][332] = (byte)52;
	geoidSimple[18][333] = (byte)54;
	geoidSimple[18][334] = (byte)54;
	geoidSimple[18][335] = (byte)53;
	geoidSimple[18][336] = (byte)53;
	geoidSimple[18][337] = (byte)54;
	geoidSimple[18][338] = (byte)54;
	geoidSimple[18][339] = (byte)55;
	geoidSimple[18][340] = (byte)56;
	geoidSimple[18][341] = (byte)55;
	geoidSimple[18][342] = (byte)54;
	geoidSimple[18][343] = (byte)54;
	geoidSimple[18][344] = (byte)55;
	geoidSimple[18][345] = (byte)55;
	geoidSimple[18][346] = (byte)55;
	geoidSimple[18][347] = (byte)55;
	geoidSimple[18][348] = (byte)54;
	geoidSimple[18][349] = (byte)54;
	geoidSimple[18][350] = (byte)54;
	geoidSimple[18][351] = (byte)54;
	geoidSimple[18][352] = (byte)53;
	geoidSimple[18][353] = (byte)53;
	geoidSimple[18][354] = (byte)53;
	geoidSimple[18][355] = (byte)53;
	geoidSimple[18][356] = (byte)52;
	geoidSimple[18][357] = (byte)52;
	geoidSimple[18][358] = (byte)51;
	geoidSimple[18][359] = (byte)50;
	}
		/** Row 19*/
	private static void init19() {
	geoidSimple[19][0] = (byte)49;
	geoidSimple[19][1] = (byte)48;
	geoidSimple[19][2] = (byte)47;
	geoidSimple[19][3] = (byte)46;
	geoidSimple[19][4] = (byte)45;
	geoidSimple[19][5] = (byte)45;
	geoidSimple[19][6] = (byte)44;
	geoidSimple[19][7] = (byte)44;
	geoidSimple[19][8] = (byte)43;
	geoidSimple[19][9] = (byte)42;
	geoidSimple[19][10] = (byte)41;
	geoidSimple[19][11] = (byte)41;
	geoidSimple[19][12] = (byte)40;
	geoidSimple[19][13] = (byte)39;
	geoidSimple[19][14] = (byte)39;
	geoidSimple[19][15] = (byte)38;
	geoidSimple[19][16] = (byte)36;
	geoidSimple[19][17] = (byte)34;
	geoidSimple[19][18] = (byte)32;
	geoidSimple[19][19] = (byte)30;
	geoidSimple[19][20] = (byte)29;
	geoidSimple[19][21] = (byte)28;
	geoidSimple[19][22] = (byte)27;
	geoidSimple[19][23] = (byte)26;
	geoidSimple[19][24] = (byte)24;
	geoidSimple[19][25] = (byte)23;
	geoidSimple[19][26] = (byte)23;
	geoidSimple[19][27] = (byte)22;
	geoidSimple[19][28] = (byte)21;
	geoidSimple[19][29] = (byte)20;
	geoidSimple[19][30] = (byte)18;
	geoidSimple[19][31] = (byte)17;
	geoidSimple[19][32] = (byte)16;
	geoidSimple[19][33] = (byte)15;
	geoidSimple[19][34] = (byte)15;
	geoidSimple[19][35] = (byte)14;
	geoidSimple[19][36] = (byte)13;
	geoidSimple[19][37] = (byte)12;
	geoidSimple[19][38] = (byte)11;
	geoidSimple[19][39] = (byte)10;
	geoidSimple[19][40] = (byte)9;
	geoidSimple[19][41] = (byte)9;
	geoidSimple[19][42] = (byte)8;
	geoidSimple[19][43] = (byte)8;
	geoidSimple[19][44] = (byte)7;
	geoidSimple[19][45] = (byte)7;
	geoidSimple[19][46] = (byte)6;
	geoidSimple[19][47] = (byte)5;
	geoidSimple[19][48] = (byte)4;
	geoidSimple[19][49] = (byte)3;
	geoidSimple[19][50] = (byte)2;
	geoidSimple[19][51] = (byte)2;
	geoidSimple[19][52] = (byte)1;
	geoidSimple[19][53] = (byte)0;
	geoidSimple[19][54] = (byte)0;
	geoidSimple[19][55] = (byte)0;
	geoidSimple[19][56] = (byte)-1;
	geoidSimple[19][57] = (byte)-1;
	geoidSimple[19][58] = (byte)-1;
	geoidSimple[19][59] = (byte)-2;
	geoidSimple[19][60] = (byte)-3;
	geoidSimple[19][61] = (byte)-4;
	geoidSimple[19][62] = (byte)-6;
	geoidSimple[19][63] = (byte)-7;
	geoidSimple[19][64] = (byte)-7;
	geoidSimple[19][65] = (byte)-7;
	geoidSimple[19][66] = (byte)-7;
	geoidSimple[19][67] = (byte)-8;
	geoidSimple[19][68] = (byte)-8;
	geoidSimple[19][69] = (byte)-8;
	geoidSimple[19][70] = (byte)-9;
	geoidSimple[19][71] = (byte)-9;
	geoidSimple[19][72] = (byte)-9;
	geoidSimple[19][73] = (byte)-9;
	geoidSimple[19][74] = (byte)-9;
	geoidSimple[19][75] = (byte)-9;
	geoidSimple[19][76] = (byte)-9;
	geoidSimple[19][77] = (byte)-10;
	geoidSimple[19][78] = (byte)-10;
	geoidSimple[19][79] = (byte)-11;
	geoidSimple[19][80] = (byte)-12;
	geoidSimple[19][81] = (byte)-12;
	geoidSimple[19][82] = (byte)-13;
	geoidSimple[19][83] = (byte)-13;
	geoidSimple[19][84] = (byte)-13;
	geoidSimple[19][85] = (byte)-14;
	geoidSimple[19][86] = (byte)-14;
	geoidSimple[19][87] = (byte)-14;
	geoidSimple[19][88] = (byte)-14;
	geoidSimple[19][89] = (byte)-13;
	geoidSimple[19][90] = (byte)-13;
	geoidSimple[19][91] = (byte)-13;
	geoidSimple[19][92] = (byte)-14;
	geoidSimple[19][93] = (byte)-14;
	geoidSimple[19][94] = (byte)-14;
	geoidSimple[19][95] = (byte)-14;
	geoidSimple[19][96] = (byte)-14;
	geoidSimple[19][97] = (byte)-13;
	geoidSimple[19][98] = (byte)-13;
	geoidSimple[19][99] = (byte)-13;
	geoidSimple[19][100] = (byte)-13;
	geoidSimple[19][101] = (byte)-12;
	geoidSimple[19][102] = (byte)-13;
	geoidSimple[19][103] = (byte)-13;
	geoidSimple[19][104] = (byte)-12;
	geoidSimple[19][105] = (byte)-11;
	geoidSimple[19][106] = (byte)-10;
	geoidSimple[19][107] = (byte)-9;
	geoidSimple[19][108] = (byte)-8;
	geoidSimple[19][109] = (byte)-8;
	geoidSimple[19][110] = (byte)-9;
	geoidSimple[19][111] = (byte)-9;
	geoidSimple[19][112] = (byte)-10;
	geoidSimple[19][113] = (byte)-10;
	geoidSimple[19][114] = (byte)-10;
	geoidSimple[19][115] = (byte)-10;
	geoidSimple[19][116] = (byte)-10;
	geoidSimple[19][117] = (byte)-9;
	geoidSimple[19][118] = (byte)-9;
	geoidSimple[19][119] = (byte)-8;
	geoidSimple[19][120] = (byte)-7;
	geoidSimple[19][121] = (byte)-7;
	geoidSimple[19][122] = (byte)-7;
	geoidSimple[19][123] = (byte)-7;
	geoidSimple[19][124] = (byte)-7;
	geoidSimple[19][125] = (byte)-8;
	geoidSimple[19][126] = (byte)-8;
	geoidSimple[19][127] = (byte)-8;
	geoidSimple[19][128] = (byte)-8;
	geoidSimple[19][129] = (byte)-7;
	geoidSimple[19][130] = (byte)-6;
	geoidSimple[19][131] = (byte)-6;
	geoidSimple[19][132] = (byte)-5;
	geoidSimple[19][133] = (byte)-4;
	geoidSimple[19][134] = (byte)-4;
	geoidSimple[19][135] = (byte)-3;
	geoidSimple[19][136] = (byte)-3;
	geoidSimple[19][137] = (byte)-2;
	geoidSimple[19][138] = (byte)-2;
	geoidSimple[19][139] = (byte)-1;
	geoidSimple[19][140] = (byte)-1;
	geoidSimple[19][141] = (byte)-1;
	geoidSimple[19][142] = (byte)-1;
	geoidSimple[19][143] = (byte)-1;
	geoidSimple[19][144] = (byte)0;
	geoidSimple[19][145] = (byte)0;
	geoidSimple[19][146] = (byte)0;
	geoidSimple[19][147] = (byte)1;
	geoidSimple[19][148] = (byte)1;
	geoidSimple[19][149] = (byte)1;
	geoidSimple[19][150] = (byte)1;
	geoidSimple[19][151] = (byte)1;
	geoidSimple[19][152] = (byte)1;
	geoidSimple[19][153] = (byte)1;
	geoidSimple[19][154] = (byte)1;
	geoidSimple[19][155] = (byte)1;
	geoidSimple[19][156] = (byte)1;
	geoidSimple[19][157] = (byte)2;
	geoidSimple[19][158] = (byte)2;
	geoidSimple[19][159] = (byte)2;
	geoidSimple[19][160] = (byte)2;
	geoidSimple[19][161] = (byte)2;
	geoidSimple[19][162] = (byte)3;
	geoidSimple[19][163] = (byte)3;
	geoidSimple[19][164] = (byte)3;
	geoidSimple[19][165] = (byte)3;
	geoidSimple[19][166] = (byte)3;
	geoidSimple[19][167] = (byte)3;
	geoidSimple[19][168] = (byte)3;
	geoidSimple[19][169] = (byte)3;
	geoidSimple[19][170] = (byte)3;
	geoidSimple[19][171] = (byte)3;
	geoidSimple[19][172] = (byte)3;
	geoidSimple[19][173] = (byte)2;
	geoidSimple[19][174] = (byte)2;
	geoidSimple[19][175] = (byte)2;
	geoidSimple[19][176] = (byte)2;
	geoidSimple[19][177] = (byte)2;
	geoidSimple[19][178] = (byte)2;
	geoidSimple[19][179] = (byte)2;
	geoidSimple[19][LAT_GRID_SIZE] = (byte)2;
	geoidSimple[19][181] = (byte)2;
	geoidSimple[19][182] = (byte)1;
	geoidSimple[19][183] = (byte)1;
	geoidSimple[19][184] = (byte)0;
	geoidSimple[19][185] = (byte)0;
	geoidSimple[19][186] = (byte)0;
	geoidSimple[19][187] = (byte)1;
	geoidSimple[19][188] = (byte)1;
	geoidSimple[19][189] = (byte)1;
	geoidSimple[19][190] = (byte)1;
	geoidSimple[19][191] = (byte)1;
	geoidSimple[19][192] = (byte)0;
	geoidSimple[19][193] = (byte)0;
	geoidSimple[19][194] = (byte)0;
	geoidSimple[19][195] = (byte)0;
	geoidSimple[19][196] = (byte)0;
	geoidSimple[19][197] = (byte)0;
	geoidSimple[19][198] = (byte)0;
	geoidSimple[19][199] = (byte)0;
	geoidSimple[19][200] = (byte)-1;
	geoidSimple[19][201] = (byte)-1;
	geoidSimple[19][202] = (byte)-1;
	geoidSimple[19][203] = (byte)-1;
	geoidSimple[19][204] = (byte)-1;
	geoidSimple[19][205] = (byte)-1;
	geoidSimple[19][206] = (byte)-1;
	geoidSimple[19][207] = (byte)-1;
	geoidSimple[19][208] = (byte)-2;
	geoidSimple[19][209] = (byte)-2;
	geoidSimple[19][210] = (byte)-2;
	geoidSimple[19][211] = (byte)-3;
	geoidSimple[19][212] = (byte)-3;
	geoidSimple[19][213] = (byte)-2;
	geoidSimple[19][214] = (byte)-2;
	geoidSimple[19][215] = (byte)-1;
	geoidSimple[19][216] = (byte)-2;
	geoidSimple[19][217] = (byte)-2;
	geoidSimple[19][218] = (byte)-3;
	geoidSimple[19][219] = (byte)-4;
	geoidSimple[19][220] = (byte)-4;
	geoidSimple[19][221] = (byte)-5;
	geoidSimple[19][222] = (byte)-4;
	geoidSimple[19][223] = (byte)-4;
	geoidSimple[19][224] = (byte)-3;
	geoidSimple[19][225] = (byte)-3;
	geoidSimple[19][226] = (byte)-3;
	geoidSimple[19][227] = (byte)-4;
	geoidSimple[19][228] = (byte)-5;
	geoidSimple[19][229] = (byte)-6;
	geoidSimple[19][230] = (byte)-8;
	geoidSimple[19][231] = (byte)-9;
	geoidSimple[19][232] = (byte)-10;
	geoidSimple[19][233] = (byte)-11;
	geoidSimple[19][234] = (byte)-11;
	geoidSimple[19][235] = (byte)-12;
	geoidSimple[19][236] = (byte)-13;
	geoidSimple[19][237] = (byte)-14;
	geoidSimple[19][238] = (byte)-14;
	geoidSimple[19][239] = (byte)-14;
	geoidSimple[19][240] = (byte)-15;
	geoidSimple[19][241] = (byte)-16;
	geoidSimple[19][242] = (byte)-16;
	geoidSimple[19][243] = (byte)-17;
	geoidSimple[19][244] = (byte)-17;
	geoidSimple[19][245] = (byte)-17;
	geoidSimple[19][246] = (byte)-17;
	geoidSimple[19][247] = (byte)-18;
	geoidSimple[19][248] = (byte)-20;
	geoidSimple[19][249] = (byte)-22;
	geoidSimple[19][250] = (byte)-24;
	geoidSimple[19][251] = (byte)-25;
	geoidSimple[19][252] = (byte)-25;
	geoidSimple[19][253] = (byte)-25;
	geoidSimple[19][254] = (byte)-25;
	geoidSimple[19][255] = (byte)-26;
	geoidSimple[19][256] = (byte)-26;
	geoidSimple[19][257] = (byte)-26;
	geoidSimple[19][258] = (byte)-26;
	geoidSimple[19][259] = (byte)-25;
	geoidSimple[19][260] = (byte)-25;
	geoidSimple[19][261] = (byte)-24;
	geoidSimple[19][262] = (byte)-24;
	geoidSimple[19][263] = (byte)-23;
	geoidSimple[19][264] = (byte)-22;
	geoidSimple[19][265] = (byte)-21;
	geoidSimple[19][266] = (byte)-21;
	geoidSimple[19][267] = (byte)-22;
	geoidSimple[19][268] = (byte)-22;
	geoidSimple[19][269] = (byte)-23;
	geoidSimple[19][270] = (byte)-22;
	geoidSimple[19][271] = (byte)-22;
	geoidSimple[19][272] = (byte)-21;
	geoidSimple[19][273] = (byte)-21;
	geoidSimple[19][274] = (byte)-20;
	geoidSimple[19][275] = (byte)-19;
	geoidSimple[19][276] = (byte)-18;
	geoidSimple[19][277] = (byte)-17;
	geoidSimple[19][278] = (byte)-16;
	geoidSimple[19][279] = (byte)-15;
	geoidSimple[19][280] = (byte)-14;
	geoidSimple[19][281] = (byte)-12;
	geoidSimple[19][282] = (byte)-10;
	geoidSimple[19][283] = (byte)-7;
	geoidSimple[19][284] = (byte)-5;
	geoidSimple[19][285] = (byte)-2;
	geoidSimple[19][286] = (byte)0;
	geoidSimple[19][287] = (byte)0;
	geoidSimple[19][288] = (byte)1;
	geoidSimple[19][289] = (byte)2;
	geoidSimple[19][290] = (byte)3;
	geoidSimple[19][291] = (byte)5;
	geoidSimple[19][292] = (byte)6;
	geoidSimple[19][293] = (byte)8;
	geoidSimple[19][294] = (byte)10;
	geoidSimple[19][295] = (byte)13;
	geoidSimple[19][296] = (byte)15;
	geoidSimple[19][297] = (byte)18;
	geoidSimple[19][298] = (byte)20;
	geoidSimple[19][299] = (byte)22;
	geoidSimple[19][300] = (byte)24;
	geoidSimple[19][301] = (byte)25;
	geoidSimple[19][302] = (byte)26;
	geoidSimple[19][303] = (byte)27;
	geoidSimple[19][304] = (byte)28;
	geoidSimple[19][305] = (byte)28;
	geoidSimple[19][306] = (byte)27;
	geoidSimple[19][307] = (byte)27;
	geoidSimple[19][308] = (byte)27;
	geoidSimple[19][309] = (byte)29;
	geoidSimple[19][310] = (byte)32;
	geoidSimple[19][311] = (byte)34;
	geoidSimple[19][312] = (byte)35;
	geoidSimple[19][313] = (byte)37;
	geoidSimple[19][314] = (byte)38;
	geoidSimple[19][315] = (byte)39;
	geoidSimple[19][316] = (byte)40;
	geoidSimple[19][317] = (byte)41;
	geoidSimple[19][318] = (byte)42;
	geoidSimple[19][319] = (byte)44;
	geoidSimple[19][320] = (byte)45;
	geoidSimple[19][321] = (byte)46;
	geoidSimple[19][322] = (byte)48;
	geoidSimple[19][323] = (byte)49;
	geoidSimple[19][324] = (byte)50;
	geoidSimple[19][325] = (byte)52;
	geoidSimple[19][326] = (byte)53;
	geoidSimple[19][327] = (byte)54;
	geoidSimple[19][328] = (byte)54;
	geoidSimple[19][329] = (byte)55;
	geoidSimple[19][330] = (byte)54;
	geoidSimple[19][331] = (byte)53;
	geoidSimple[19][332] = (byte)53;
	geoidSimple[19][333] = (byte)54;
	geoidSimple[19][334] = (byte)54;
	geoidSimple[19][335] = (byte)53;
	geoidSimple[19][336] = (byte)54;
	geoidSimple[19][337] = (byte)55;
	geoidSimple[19][338] = (byte)56;
	geoidSimple[19][339] = (byte)57;
	geoidSimple[19][340] = (byte)57;
	geoidSimple[19][341] = (byte)57;
	geoidSimple[19][342] = (byte)57;
	geoidSimple[19][343] = (byte)57;
	geoidSimple[19][344] = (byte)58;
	geoidSimple[19][345] = (byte)57;
	geoidSimple[19][346] = (byte)57;
	geoidSimple[19][347] = (byte)57;
	geoidSimple[19][348] = (byte)57;
	geoidSimple[19][349] = (byte)56;
	geoidSimple[19][350] = (byte)55;
	geoidSimple[19][351] = (byte)55;
	geoidSimple[19][352] = (byte)54;
	geoidSimple[19][353] = (byte)53;
	geoidSimple[19][354] = (byte)52;
	geoidSimple[19][355] = (byte)52;
	geoidSimple[19][356] = (byte)52;
	geoidSimple[19][357] = (byte)51;
	geoidSimple[19][358] = (byte)50;
	geoidSimple[19][359] = (byte)49;
	}
		/** Row 20*/
	private static void init20() {
	geoidSimple[20][0] = (byte)48;
	geoidSimple[20][1] = (byte)47;
	geoidSimple[20][2] = (byte)47;
	geoidSimple[20][3] = (byte)46;
	geoidSimple[20][4] = (byte)45;
	geoidSimple[20][5] = (byte)45;
	geoidSimple[20][6] = (byte)44;
	geoidSimple[20][7] = (byte)43;
	geoidSimple[20][8] = (byte)42;
	geoidSimple[20][9] = (byte)42;
	geoidSimple[20][10] = (byte)41;
	geoidSimple[20][11] = (byte)40;
	geoidSimple[20][12] = (byte)39;
	geoidSimple[20][13] = (byte)38;
	geoidSimple[20][14] = (byte)38;
	geoidSimple[20][15] = (byte)37;
	geoidSimple[20][16] = (byte)35;
	geoidSimple[20][17] = (byte)33;
	geoidSimple[20][18] = (byte)32;
	geoidSimple[20][19] = (byte)30;
	geoidSimple[20][20] = (byte)29;
	geoidSimple[20][21] = (byte)28;
	geoidSimple[20][22] = (byte)27;
	geoidSimple[20][23] = (byte)26;
	geoidSimple[20][24] = (byte)25;
	geoidSimple[20][25] = (byte)25;
	geoidSimple[20][26] = (byte)24;
	geoidSimple[20][27] = (byte)23;
	geoidSimple[20][28] = (byte)21;
	geoidSimple[20][29] = (byte)20;
	geoidSimple[20][30] = (byte)19;
	geoidSimple[20][31] = (byte)18;
	geoidSimple[20][32] = (byte)17;
	geoidSimple[20][33] = (byte)16;
	geoidSimple[20][34] = (byte)15;
	geoidSimple[20][35] = (byte)14;
	geoidSimple[20][36] = (byte)13;
	geoidSimple[20][37] = (byte)13;
	geoidSimple[20][38] = (byte)12;
	geoidSimple[20][39] = (byte)11;
	geoidSimple[20][40] = (byte)10;
	geoidSimple[20][41] = (byte)10;
	geoidSimple[20][42] = (byte)9;
	geoidSimple[20][43] = (byte)8;
	geoidSimple[20][44] = (byte)7;
	geoidSimple[20][45] = (byte)7;
	geoidSimple[20][46] = (byte)6;
	geoidSimple[20][47] = (byte)5;
	geoidSimple[20][48] = (byte)4;
	geoidSimple[20][49] = (byte)3;
	geoidSimple[20][50] = (byte)2;
	geoidSimple[20][51] = (byte)2;
	geoidSimple[20][52] = (byte)1;
	geoidSimple[20][53] = (byte)0;
	geoidSimple[20][54] = (byte)0;
	geoidSimple[20][55] = (byte)0;
	geoidSimple[20][56] = (byte)-1;
	geoidSimple[20][57] = (byte)-2;
	geoidSimple[20][58] = (byte)-2;
	geoidSimple[20][59] = (byte)-2;
	geoidSimple[20][60] = (byte)-3;
	geoidSimple[20][61] = (byte)-4;
	geoidSimple[20][62] = (byte)-5;
	geoidSimple[20][63] = (byte)-5;
	geoidSimple[20][64] = (byte)-6;
	geoidSimple[20][65] = (byte)-7;
	geoidSimple[20][66] = (byte)-7;
	geoidSimple[20][67] = (byte)-8;
	geoidSimple[20][68] = (byte)-8;
	geoidSimple[20][69] = (byte)-9;
	geoidSimple[20][70] = (byte)-9;
	geoidSimple[20][71] = (byte)-9;
	geoidSimple[20][72] = (byte)-10;
	geoidSimple[20][73] = (byte)-10;
	geoidSimple[20][74] = (byte)-10;
	geoidSimple[20][75] = (byte)-11;
	geoidSimple[20][76] = (byte)-11;
	geoidSimple[20][77] = (byte)-11;
	geoidSimple[20][78] = (byte)-12;
	geoidSimple[20][79] = (byte)-12;
	geoidSimple[20][80] = (byte)-13;
	geoidSimple[20][81] = (byte)-13;
	geoidSimple[20][82] = (byte)-13;
	geoidSimple[20][83] = (byte)-14;
	geoidSimple[20][84] = (byte)-14;
	geoidSimple[20][85] = (byte)-14;
	geoidSimple[20][86] = (byte)-14;
	geoidSimple[20][87] = (byte)-14;
	geoidSimple[20][88] = (byte)-14;
	geoidSimple[20][89] = (byte)-14;
	geoidSimple[20][90] = (byte)-14;
	geoidSimple[20][91] = (byte)-13;
	geoidSimple[20][92] = (byte)-12;
	geoidSimple[20][93] = (byte)-13;
	geoidSimple[20][94] = (byte)-13;
	geoidSimple[20][95] = (byte)-14;
	geoidSimple[20][96] = (byte)-14;
	geoidSimple[20][97] = (byte)-14;
	geoidSimple[20][98] = (byte)-15;
	geoidSimple[20][99] = (byte)-15;
	geoidSimple[20][100] = (byte)-16;
	geoidSimple[20][101] = (byte)-16;
	geoidSimple[20][102] = (byte)-15;
	geoidSimple[20][103] = (byte)-15;
	geoidSimple[20][104] = (byte)-14;
	geoidSimple[20][105] = (byte)-13;
	geoidSimple[20][106] = (byte)-12;
	geoidSimple[20][107] = (byte)-11;
	geoidSimple[20][108] = (byte)-11;
	geoidSimple[20][109] = (byte)-10;
	geoidSimple[20][110] = (byte)-10;
	geoidSimple[20][111] = (byte)-10;
	geoidSimple[20][112] = (byte)-11;
	geoidSimple[20][113] = (byte)-11;
	geoidSimple[20][114] = (byte)-11;
	geoidSimple[20][115] = (byte)-11;
	geoidSimple[20][116] = (byte)-11;
	geoidSimple[20][117] = (byte)-11;
	geoidSimple[20][118] = (byte)-10;
	geoidSimple[20][119] = (byte)-9;
	geoidSimple[20][120] = (byte)-9;
	geoidSimple[20][121] = (byte)-9;
	geoidSimple[20][122] = (byte)-9;
	geoidSimple[20][123] = (byte)-10;
	geoidSimple[20][124] = (byte)-11;
	geoidSimple[20][125] = (byte)-11;
	geoidSimple[20][126] = (byte)-10;
	geoidSimple[20][127] = (byte)-9;
	geoidSimple[20][128] = (byte)-7;
	geoidSimple[20][129] = (byte)-6;
	geoidSimple[20][130] = (byte)-5;
	geoidSimple[20][131] = (byte)-5;
	geoidSimple[20][132] = (byte)-5;
	geoidSimple[20][133] = (byte)-4;
	geoidSimple[20][134] = (byte)-3;
	geoidSimple[20][135] = (byte)-2;
	geoidSimple[20][136] = (byte)-2;
	geoidSimple[20][137] = (byte)-1;
	geoidSimple[20][138] = (byte)0;
	geoidSimple[20][139] = (byte)0;
	geoidSimple[20][140] = (byte)0;
	geoidSimple[20][141] = (byte)0;
	geoidSimple[20][142] = (byte)0;
	geoidSimple[20][143] = (byte)0;
	geoidSimple[20][144] = (byte)0;
	geoidSimple[20][145] = (byte)0;
	geoidSimple[20][146] = (byte)1;
	geoidSimple[20][147] = (byte)1;
	geoidSimple[20][148] = (byte)2;
	geoidSimple[20][149] = (byte)2;
	geoidSimple[20][150] = (byte)2;
	geoidSimple[20][151] = (byte)2;
	geoidSimple[20][152] = (byte)2;
	geoidSimple[20][153] = (byte)2;
	geoidSimple[20][154] = (byte)2;
	geoidSimple[20][155] = (byte)2;
	geoidSimple[20][156] = (byte)2;
	geoidSimple[20][157] = (byte)3;
	geoidSimple[20][158] = (byte)3;
	geoidSimple[20][159] = (byte)3;
	geoidSimple[20][160] = (byte)3;
	geoidSimple[20][161] = (byte)4;
	geoidSimple[20][162] = (byte)4;
	geoidSimple[20][163] = (byte)4;
	geoidSimple[20][164] = (byte)5;
	geoidSimple[20][165] = (byte)4;
	geoidSimple[20][166] = (byte)4;
	geoidSimple[20][167] = (byte)4;
	geoidSimple[20][168] = (byte)4;
	geoidSimple[20][169] = (byte)4;
	geoidSimple[20][170] = (byte)4;
	geoidSimple[20][171] = (byte)4;
	geoidSimple[20][172] = (byte)4;
	geoidSimple[20][173] = (byte)4;
	geoidSimple[20][174] = (byte)4;
	geoidSimple[20][175] = (byte)4;
	geoidSimple[20][176] = (byte)4;
	geoidSimple[20][177] = (byte)3;
	geoidSimple[20][178] = (byte)3;
	geoidSimple[20][179] = (byte)3;
	geoidSimple[20][LAT_GRID_SIZE] = (byte)2;
	geoidSimple[20][181] = (byte)2;
	geoidSimple[20][182] = (byte)2;
	geoidSimple[20][183] = (byte)1;
	geoidSimple[20][184] = (byte)0;
	geoidSimple[20][185] = (byte)0;
	geoidSimple[20][186] = (byte)0;
	geoidSimple[20][187] = (byte)0;
	geoidSimple[20][188] = (byte)1;
	geoidSimple[20][189] = (byte)0;
	geoidSimple[20][190] = (byte)0;
	geoidSimple[20][191] = (byte)0;
	geoidSimple[20][192] = (byte)0;
	geoidSimple[20][193] = (byte)0;
	geoidSimple[20][194] = (byte)0;
	geoidSimple[20][195] = (byte)0;
	geoidSimple[20][196] = (byte)0;
	geoidSimple[20][197] = (byte)0;
	geoidSimple[20][198] = (byte)0;
	geoidSimple[20][199] = (byte)0;
	geoidSimple[20][200] = (byte)0;
	geoidSimple[20][201] = (byte)0;
	geoidSimple[20][202] = (byte)0;
	geoidSimple[20][203] = (byte)0;
	geoidSimple[20][204] = (byte)0;
	geoidSimple[20][205] = (byte)0;
	geoidSimple[20][206] = (byte)0;
	geoidSimple[20][207] = (byte)0;
	geoidSimple[20][208] = (byte)0;
	geoidSimple[20][209] = (byte)0;
	geoidSimple[20][210] = (byte)0;
	geoidSimple[20][211] = (byte)0;
	geoidSimple[20][212] = (byte)0;
	geoidSimple[20][213] = (byte)1;
	geoidSimple[20][214] = (byte)1;
	geoidSimple[20][215] = (byte)1;
	geoidSimple[20][216] = (byte)1;
	geoidSimple[20][217] = (byte)0;
	geoidSimple[20][218] = (byte)0;
	geoidSimple[20][219] = (byte)0;
	geoidSimple[20][220] = (byte)-1;
	geoidSimple[20][221] = (byte)-2;
	geoidSimple[20][222] = (byte)-4;
	geoidSimple[20][223] = (byte)-4;
	geoidSimple[20][224] = (byte)-4;
	geoidSimple[20][225] = (byte)-5;
	geoidSimple[20][226] = (byte)-6;
	geoidSimple[20][227] = (byte)-6;
	geoidSimple[20][228] = (byte)-6;
	geoidSimple[20][229] = (byte)-7;
	geoidSimple[20][230] = (byte)-7;
	geoidSimple[20][231] = (byte)-8;
	geoidSimple[20][232] = (byte)-9;
	geoidSimple[20][233] = (byte)-9;
	geoidSimple[20][234] = (byte)-10;
	geoidSimple[20][235] = (byte)-10;
	geoidSimple[20][236] = (byte)-10;
	geoidSimple[20][237] = (byte)-11;
	geoidSimple[20][238] = (byte)-12;
	geoidSimple[20][239] = (byte)-13;
	geoidSimple[20][240] = (byte)-15;
	geoidSimple[20][241] = (byte)-16;
	geoidSimple[20][242] = (byte)-17;
	geoidSimple[20][243] = (byte)-17;
	geoidSimple[20][244] = (byte)-18;
	geoidSimple[20][245] = (byte)-18;
	geoidSimple[20][246] = (byte)-19;
	geoidSimple[20][247] = (byte)-20;
	geoidSimple[20][248] = (byte)-21;
	geoidSimple[20][249] = (byte)-23;
	geoidSimple[20][250] = (byte)-26;
	geoidSimple[20][251] = (byte)-27;
	geoidSimple[20][252] = (byte)-28;
	geoidSimple[20][253] = (byte)-28;
	geoidSimple[20][254] = (byte)-29;
	geoidSimple[20][255] = (byte)-29;
	geoidSimple[20][256] = (byte)-29;
	geoidSimple[20][257] = (byte)-29;
	geoidSimple[20][258] = (byte)-29;
	geoidSimple[20][259] = (byte)-28;
	geoidSimple[20][260] = (byte)-29;
	geoidSimple[20][261] = (byte)-29;
	geoidSimple[20][262] = (byte)-29;
	geoidSimple[20][263] = (byte)-28;
	geoidSimple[20][264] = (byte)-28;
	geoidSimple[20][265] = (byte)-27;
	geoidSimple[20][266] = (byte)-27;
	geoidSimple[20][267] = (byte)-26;
	geoidSimple[20][268] = (byte)-26;
	geoidSimple[20][269] = (byte)-26;
	geoidSimple[20][270] = (byte)-26;
	geoidSimple[20][271] = (byte)-26;
	geoidSimple[20][272] = (byte)-26;
	geoidSimple[20][273] = (byte)-25;
	geoidSimple[20][274] = (byte)-24;
	geoidSimple[20][275] = (byte)-22;
	geoidSimple[20][276] = (byte)-21;
	geoidSimple[20][277] = (byte)-21;
	geoidSimple[20][278] = (byte)-21;
	geoidSimple[20][279] = (byte)-20;
	geoidSimple[20][280] = (byte)-19;
	geoidSimple[20][281] = (byte)-18;
	geoidSimple[20][282] = (byte)-16;
	geoidSimple[20][283] = (byte)-14;
	geoidSimple[20][284] = (byte)-12;
	geoidSimple[20][285] = (byte)-9;
	geoidSimple[20][286] = (byte)-6;
	geoidSimple[20][287] = (byte)-3;
	geoidSimple[20][288] = (byte)-1;
	geoidSimple[20][289] = (byte)0;
	geoidSimple[20][290] = (byte)1;
	geoidSimple[20][291] = (byte)2;
	geoidSimple[20][292] = (byte)2;
	geoidSimple[20][293] = (byte)3;
	geoidSimple[20][294] = (byte)7;
	geoidSimple[20][295] = (byte)11;
	geoidSimple[20][296] = (byte)14;
	geoidSimple[20][297] = (byte)16;
	geoidSimple[20][298] = (byte)18;
	geoidSimple[20][299] = (byte)20;
	geoidSimple[20][300] = (byte)22;
	geoidSimple[20][301] = (byte)24;
	geoidSimple[20][302] = (byte)26;
	geoidSimple[20][303] = (byte)27;
	geoidSimple[20][304] = (byte)27;
	geoidSimple[20][305] = (byte)27;
	geoidSimple[20][306] = (byte)25;
	geoidSimple[20][307] = (byte)24;
	geoidSimple[20][308] = (byte)24;
	geoidSimple[20][309] = (byte)27;
	geoidSimple[20][310] = (byte)30;
	geoidSimple[20][311] = (byte)32;
	geoidSimple[20][312] = (byte)34;
	geoidSimple[20][313] = (byte)36;
	geoidSimple[20][314] = (byte)38;
	geoidSimple[20][315] = (byte)39;
	geoidSimple[20][316] = (byte)40;
	geoidSimple[20][317] = (byte)42;
	geoidSimple[20][318] = (byte)43;
	geoidSimple[20][319] = (byte)45;
	geoidSimple[20][320] = (byte)46;
	geoidSimple[20][321] = (byte)48;
	geoidSimple[20][322] = (byte)49;
	geoidSimple[20][323] = (byte)51;
	geoidSimple[20][324] = (byte)53;
	geoidSimple[20][325] = (byte)54;
	geoidSimple[20][326] = (byte)54;
	geoidSimple[20][327] = (byte)56;
	geoidSimple[20][328] = (byte)57;
	geoidSimple[20][329] = (byte)57;
	geoidSimple[20][330] = (byte)58;
	geoidSimple[20][331] = (byte)59;
	geoidSimple[20][332] = (byte)59;
	geoidSimple[20][333] = (byte)59;
	geoidSimple[20][334] = (byte)59;
	geoidSimple[20][335] = (byte)58;
	geoidSimple[20][336] = (byte)57;
	geoidSimple[20][337] = (byte)58;
	geoidSimple[20][338] = (byte)58;
	geoidSimple[20][339] = (byte)59;
	geoidSimple[20][340] = (byte)59;
	geoidSimple[20][341] = (byte)59;
	geoidSimple[20][342] = (byte)59;
	geoidSimple[20][343] = (byte)59;
	geoidSimple[20][344] = (byte)59;
	geoidSimple[20][345] = (byte)59;
	geoidSimple[20][346] = (byte)58;
	geoidSimple[20][347] = (byte)58;
	geoidSimple[20][348] = (byte)57;
	geoidSimple[20][349] = (byte)56;
	geoidSimple[20][350] = (byte)55;
	geoidSimple[20][351] = (byte)55;
	geoidSimple[20][352] = (byte)53;
	geoidSimple[20][353] = (byte)51;
	geoidSimple[20][354] = (byte)51;
	geoidSimple[20][355] = (byte)51;
	geoidSimple[20][356] = (byte)50;
	geoidSimple[20][357] = (byte)50;
	geoidSimple[20][358] = (byte)49;
	geoidSimple[20][359] = (byte)48;
	}
		/** Row 21*/
	private static void init21() {
	geoidSimple[21][0] = (byte)48;
	geoidSimple[21][1] = (byte)47;
	geoidSimple[21][2] = (byte)47;
	geoidSimple[21][3] = (byte)46;
	geoidSimple[21][4] = (byte)45;
	geoidSimple[21][5] = (byte)44;
	geoidSimple[21][6] = (byte)43;
	geoidSimple[21][7] = (byte)42;
	geoidSimple[21][8] = (byte)41;
	geoidSimple[21][9] = (byte)40;
	geoidSimple[21][10] = (byte)39;
	geoidSimple[21][11] = (byte)39;
	geoidSimple[21][12] = (byte)39;
	geoidSimple[21][13] = (byte)38;
	geoidSimple[21][14] = (byte)37;
	geoidSimple[21][15] = (byte)34;
	geoidSimple[21][16] = (byte)32;
	geoidSimple[21][17] = (byte)31;
	geoidSimple[21][18] = (byte)31;
	geoidSimple[21][19] = (byte)31;
	geoidSimple[21][20] = (byte)30;
	geoidSimple[21][21] = (byte)29;
	geoidSimple[21][22] = (byte)28;
	geoidSimple[21][23] = (byte)27;
	geoidSimple[21][24] = (byte)25;
	geoidSimple[21][25] = (byte)24;
	geoidSimple[21][26] = (byte)23;
	geoidSimple[21][27] = (byte)22;
	geoidSimple[21][28] = (byte)21;
	geoidSimple[21][29] = (byte)20;
	geoidSimple[21][30] = (byte)19;
	geoidSimple[21][31] = (byte)18;
	geoidSimple[21][32] = (byte)18;
	geoidSimple[21][33] = (byte)17;
	geoidSimple[21][34] = (byte)17;
	geoidSimple[21][35] = (byte)16;
	geoidSimple[21][36] = (byte)15;
	geoidSimple[21][37] = (byte)14;
	geoidSimple[21][38] = (byte)13;
	geoidSimple[21][39] = (byte)12;
	geoidSimple[21][40] = (byte)11;
	geoidSimple[21][41] = (byte)10;
	geoidSimple[21][42] = (byte)10;
	geoidSimple[21][43] = (byte)10;
	geoidSimple[21][44] = (byte)9;
	geoidSimple[21][45] = (byte)8;
	geoidSimple[21][46] = (byte)8;
	geoidSimple[21][47] = (byte)7;
	geoidSimple[21][48] = (byte)5;
	geoidSimple[21][49] = (byte)4;
	geoidSimple[21][50] = (byte)3;
	geoidSimple[21][51] = (byte)3;
	geoidSimple[21][52] = (byte)2;
	geoidSimple[21][53] = (byte)0;
	geoidSimple[21][54] = (byte)0;
	geoidSimple[21][55] = (byte)0;
	geoidSimple[21][56] = (byte)-1;
	geoidSimple[21][57] = (byte)-1;
	geoidSimple[21][58] = (byte)-2;
	geoidSimple[21][59] = (byte)-3;
	geoidSimple[21][60] = (byte)-3;
	geoidSimple[21][61] = (byte)-4;
	geoidSimple[21][62] = (byte)-5;
	geoidSimple[21][63] = (byte)-6;
	geoidSimple[21][64] = (byte)-6;
	geoidSimple[21][65] = (byte)-6;
	geoidSimple[21][66] = (byte)-6;
	geoidSimple[21][67] = (byte)-7;
	geoidSimple[21][68] = (byte)-8;
	geoidSimple[21][69] = (byte)-9;
	geoidSimple[21][70] = (byte)-10;
	geoidSimple[21][71] = (byte)-11;
	geoidSimple[21][72] = (byte)-12;
	geoidSimple[21][73] = (byte)-12;
	geoidSimple[21][74] = (byte)-12;
	geoidSimple[21][75] = (byte)-12;
	geoidSimple[21][76] = (byte)-12;
	geoidSimple[21][77] = (byte)-13;
	geoidSimple[21][78] = (byte)-13;
	geoidSimple[21][79] = (byte)-13;
	geoidSimple[21][80] = (byte)-14;
	geoidSimple[21][81] = (byte)-14;
	geoidSimple[21][82] = (byte)-14;
	geoidSimple[21][83] = (byte)-14;
	geoidSimple[21][84] = (byte)-15;
	geoidSimple[21][85] = (byte)-15;
	geoidSimple[21][86] = (byte)-14;
	geoidSimple[21][87] = (byte)-14;
	geoidSimple[21][88] = (byte)-15;
	geoidSimple[21][89] = (byte)-16;
	geoidSimple[21][90] = (byte)-17;
	geoidSimple[21][91] = (byte)-16;
	geoidSimple[21][92] = (byte)-15;
	geoidSimple[21][93] = (byte)-15;
	geoidSimple[21][94] = (byte)-15;
	geoidSimple[21][95] = (byte)-15;
	geoidSimple[21][96] = (byte)-15;
	geoidSimple[21][97] = (byte)-15;
	geoidSimple[21][98] = (byte)-15;
	geoidSimple[21][99] = (byte)-15;
	geoidSimple[21][100] = (byte)-16;
	geoidSimple[21][101] = (byte)-16;
	geoidSimple[21][102] = (byte)-15;
	geoidSimple[21][103] = (byte)-15;
	geoidSimple[21][104] = (byte)-15;
	geoidSimple[21][105] = (byte)-15;
	geoidSimple[21][106] = (byte)-15;
	geoidSimple[21][107] = (byte)-15;
	geoidSimple[21][108] = (byte)-15;
	geoidSimple[21][109] = (byte)-14;
	geoidSimple[21][110] = (byte)-14;
	geoidSimple[21][111] = (byte)-13;
	geoidSimple[21][112] = (byte)-13;
	geoidSimple[21][113] = (byte)-13;
	geoidSimple[21][114] = (byte)-13;
	geoidSimple[21][115] = (byte)-12;
	geoidSimple[21][116] = (byte)-11;
	geoidSimple[21][117] = (byte)-11;
	geoidSimple[21][118] = (byte)-10;
	geoidSimple[21][119] = (byte)-10;
	geoidSimple[21][120] = (byte)-10;
	geoidSimple[21][121] = (byte)-11;
	geoidSimple[21][122] = (byte)-12;
	geoidSimple[21][123] = (byte)-13;
	geoidSimple[21][124] = (byte)-15;
	geoidSimple[21][125] = (byte)-14;
	geoidSimple[21][126] = (byte)-12;
	geoidSimple[21][127] = (byte)-9;
	geoidSimple[21][128] = (byte)-6;
	geoidSimple[21][129] = (byte)-5;
	geoidSimple[21][130] = (byte)-5;
	geoidSimple[21][131] = (byte)-5;
	geoidSimple[21][132] = (byte)-4;
	geoidSimple[21][133] = (byte)-4;
	geoidSimple[21][134] = (byte)-3;
	geoidSimple[21][135] = (byte)-2;
	geoidSimple[21][136] = (byte)-1;
	geoidSimple[21][137] = (byte)0;
	geoidSimple[21][138] = (byte)0;
	geoidSimple[21][139] = (byte)0;
	geoidSimple[21][140] = (byte)1;
	geoidSimple[21][141] = (byte)1;
	geoidSimple[21][142] = (byte)0;
	geoidSimple[21][143] = (byte)0;
	geoidSimple[21][144] = (byte)1;
	geoidSimple[21][145] = (byte)1;
	geoidSimple[21][146] = (byte)2;
	geoidSimple[21][147] = (byte)2;
	geoidSimple[21][148] = (byte)3;
	geoidSimple[21][149] = (byte)3;
	geoidSimple[21][150] = (byte)3;
	geoidSimple[21][151] = (byte)3;
	geoidSimple[21][152] = (byte)3;
	geoidSimple[21][153] = (byte)3;
	geoidSimple[21][154] = (byte)4;
	geoidSimple[21][155] = (byte)4;
	geoidSimple[21][156] = (byte)4;
	geoidSimple[21][157] = (byte)4;
	geoidSimple[21][158] = (byte)4;
	geoidSimple[21][159] = (byte)4;
	geoidSimple[21][160] = (byte)5;
	geoidSimple[21][161] = (byte)5;
	geoidSimple[21][162] = (byte)5;
	geoidSimple[21][163] = (byte)6;
	geoidSimple[21][164] = (byte)6;
	geoidSimple[21][165] = (byte)7;
	geoidSimple[21][166] = (byte)7;
	geoidSimple[21][167] = (byte)7;
	geoidSimple[21][168] = (byte)6;
	geoidSimple[21][169] = (byte)6;
	geoidSimple[21][170] = (byte)5;
	geoidSimple[21][171] = (byte)5;
	geoidSimple[21][172] = (byte)5;
	geoidSimple[21][173] = (byte)5;
	geoidSimple[21][174] = (byte)5;
	geoidSimple[21][175] = (byte)5;
	geoidSimple[21][176] = (byte)5;
	geoidSimple[21][177] = (byte)5;
	geoidSimple[21][178] = (byte)5;
	geoidSimple[21][179] = (byte)4;
	geoidSimple[21][LAT_GRID_SIZE] = (byte)4;
	geoidSimple[21][181] = (byte)3;
	geoidSimple[21][182] = (byte)2;
	geoidSimple[21][183] = (byte)2;
	geoidSimple[21][184] = (byte)1;
	geoidSimple[21][185] = (byte)1;
	geoidSimple[21][186] = (byte)0;
	geoidSimple[21][187] = (byte)0;
	geoidSimple[21][188] = (byte)0;
	geoidSimple[21][189] = (byte)0;
	geoidSimple[21][190] = (byte)0;
	geoidSimple[21][191] = (byte)0;
	geoidSimple[21][192] = (byte)0;
	geoidSimple[21][193] = (byte)1;
	geoidSimple[21][194] = (byte)1;
	geoidSimple[21][195] = (byte)1;
	geoidSimple[21][196] = (byte)2;
	geoidSimple[21][197] = (byte)3;
	geoidSimple[21][198] = (byte)4;
	geoidSimple[21][199] = (byte)4;
	geoidSimple[21][200] = (byte)4;
	geoidSimple[21][201] = (byte)4;
	geoidSimple[21][202] = (byte)3;
	geoidSimple[21][203] = (byte)4;
	geoidSimple[21][204] = (byte)4;
	geoidSimple[21][205] = (byte)4;
	geoidSimple[21][206] = (byte)4;
	geoidSimple[21][207] = (byte)4;
	geoidSimple[21][208] = (byte)5;
	geoidSimple[21][209] = (byte)5;
	geoidSimple[21][210] = (byte)6;
	geoidSimple[21][211] = (byte)6;
	geoidSimple[21][212] = (byte)7;
	geoidSimple[21][213] = (byte)7;
	geoidSimple[21][214] = (byte)7;
	geoidSimple[21][215] = (byte)7;
	geoidSimple[21][216] = (byte)7;
	geoidSimple[21][217] = (byte)6;
	geoidSimple[21][218] = (byte)5;
	geoidSimple[21][219] = (byte)4;
	geoidSimple[21][220] = (byte)3;
	geoidSimple[21][221] = (byte)1;
	geoidSimple[21][222] = (byte)0;
	geoidSimple[21][223] = (byte)-2;
	geoidSimple[21][224] = (byte)-3;
	geoidSimple[21][225] = (byte)-4;
	geoidSimple[21][226] = (byte)-4;
	geoidSimple[21][227] = (byte)-4;
	geoidSimple[21][228] = (byte)-4;
	geoidSimple[21][229] = (byte)-5;
	geoidSimple[21][230] = (byte)-6;
	geoidSimple[21][231] = (byte)-7;
	geoidSimple[21][232] = (byte)-7;
	geoidSimple[21][233] = (byte)-8;
	geoidSimple[21][234] = (byte)-8;
	geoidSimple[21][235] = (byte)-8;
	geoidSimple[21][236] = (byte)-8;
	geoidSimple[21][237] = (byte)-9;
	geoidSimple[21][238] = (byte)-9;
	geoidSimple[21][239] = (byte)-10;
	geoidSimple[21][240] = (byte)-12;
	geoidSimple[21][241] = (byte)-13;
	geoidSimple[21][242] = (byte)-15;
	geoidSimple[21][243] = (byte)-17;
	geoidSimple[21][244] = (byte)-18;
	geoidSimple[21][245] = (byte)-20;
	geoidSimple[21][246] = (byte)-21;
	geoidSimple[21][247] = (byte)-22;
	geoidSimple[21][248] = (byte)-23;
	geoidSimple[21][249] = (byte)-25;
	geoidSimple[21][250] = (byte)-28;
	geoidSimple[21][251] = (byte)-29;
	geoidSimple[21][252] = (byte)-30;
	geoidSimple[21][253] = (byte)-31;
	geoidSimple[21][254] = (byte)-31;
	geoidSimple[21][255] = (byte)-32;
	geoidSimple[21][256] = (byte)-32;
	geoidSimple[21][257] = (byte)-32;
	geoidSimple[21][258] = (byte)-32;
	geoidSimple[21][259] = (byte)-32;
	geoidSimple[21][260] = (byte)-33;
	geoidSimple[21][261] = (byte)-33;
	geoidSimple[21][262] = (byte)-32;
	geoidSimple[21][263] = (byte)-32;
	geoidSimple[21][264] = (byte)-32;
	geoidSimple[21][265] = (byte)-32;
	geoidSimple[21][266] = (byte)-31;
	geoidSimple[21][267] = (byte)-29;
	geoidSimple[21][268] = (byte)-28;
	geoidSimple[21][269] = (byte)-28;
	geoidSimple[21][270] = (byte)-28;
	geoidSimple[21][271] = (byte)-28;
	geoidSimple[21][272] = (byte)-28;
	geoidSimple[21][273] = (byte)-28;
	geoidSimple[21][274] = (byte)-27;
	geoidSimple[21][275] = (byte)-25;
	geoidSimple[21][276] = (byte)-24;
	geoidSimple[21][277] = (byte)-24;
	geoidSimple[21][278] = (byte)-24;
	geoidSimple[21][279] = (byte)-24;
	geoidSimple[21][280] = (byte)-23;
	geoidSimple[21][281] = (byte)-22;
	geoidSimple[21][282] = (byte)-21;
	geoidSimple[21][283] = (byte)-19;
	geoidSimple[21][284] = (byte)-17;
	geoidSimple[21][285] = (byte)-15;
	geoidSimple[21][286] = (byte)-12;
	geoidSimple[21][287] = (byte)-10;
	geoidSimple[21][288] = (byte)-7;
	geoidSimple[21][289] = (byte)-4;
	geoidSimple[21][290] = (byte)-2;
	geoidSimple[21][291] = (byte)0;
	geoidSimple[21][292] = (byte)0;
	geoidSimple[21][293] = (byte)1;
	geoidSimple[21][294] = (byte)4;
	geoidSimple[21][295] = (byte)9;
	geoidSimple[21][296] = (byte)12;
	geoidSimple[21][297] = (byte)14;
	geoidSimple[21][298] = (byte)16;
	geoidSimple[21][299] = (byte)18;
	geoidSimple[21][300] = (byte)21;
	geoidSimple[21][301] = (byte)24;
	geoidSimple[21][302] = (byte)25;
	geoidSimple[21][303] = (byte)25;
	geoidSimple[21][304] = (byte)26;
	geoidSimple[21][305] = (byte)25;
	geoidSimple[21][306] = (byte)23;
	geoidSimple[21][307] = (byte)24;
	geoidSimple[21][308] = (byte)25;
	geoidSimple[21][309] = (byte)28;
	geoidSimple[21][310] = (byte)30;
	geoidSimple[21][311] = (byte)33;
	geoidSimple[21][312] = (byte)35;
	geoidSimple[21][313] = (byte)37;
	geoidSimple[21][314] = (byte)39;
	geoidSimple[21][315] = (byte)40;
	geoidSimple[21][316] = (byte)42;
	geoidSimple[21][317] = (byte)43;
	geoidSimple[21][318] = (byte)45;
	geoidSimple[21][319] = (byte)46;
	geoidSimple[21][320] = (byte)47;
	geoidSimple[21][321] = (byte)49;
	geoidSimple[21][322] = (byte)50;
	geoidSimple[21][323] = (byte)52;
	geoidSimple[21][324] = (byte)54;
	geoidSimple[21][325] = (byte)55;
	geoidSimple[21][326] = (byte)55;
	geoidSimple[21][327] = (byte)55;
	geoidSimple[21][328] = (byte)57;
	geoidSimple[21][329] = (byte)58;
	geoidSimple[21][330] = (byte)59;
	geoidSimple[21][331] = (byte)59;
	geoidSimple[21][332] = (byte)59;
	geoidSimple[21][333] = (byte)59;
	geoidSimple[21][334] = (byte)59;
	geoidSimple[21][335] = (byte)59;
	geoidSimple[21][336] = (byte)58;
	geoidSimple[21][337] = (byte)58;
	geoidSimple[21][338] = (byte)59;
	geoidSimple[21][339] = (byte)60;
	geoidSimple[21][340] = (byte)60;
	geoidSimple[21][341] = (byte)61;
	geoidSimple[21][342] = (byte)61;
	geoidSimple[21][343] = (byte)61;
	geoidSimple[21][344] = (byte)60;
	geoidSimple[21][345] = (byte)60;
	geoidSimple[21][346] = (byte)59;
	geoidSimple[21][347] = (byte)58;
	geoidSimple[21][348] = (byte)58;
	geoidSimple[21][349] = (byte)57;
	geoidSimple[21][350] = (byte)56;
	geoidSimple[21][351] = (byte)55;
	geoidSimple[21][352] = (byte)53;
	geoidSimple[21][353] = (byte)52;
	geoidSimple[21][354] = (byte)51;
	geoidSimple[21][355] = (byte)50;
	geoidSimple[21][356] = (byte)50;
	geoidSimple[21][357] = (byte)49;
	geoidSimple[21][358] = (byte)49;
	geoidSimple[21][359] = (byte)48;
	}
		/** Row 22*/
	private static void init22() {
	geoidSimple[22][0] = (byte)48;
	geoidSimple[22][1] = (byte)48;
	geoidSimple[22][2] = (byte)47;
	geoidSimple[22][3] = (byte)46;
	geoidSimple[22][4] = (byte)45;
	geoidSimple[22][5] = (byte)44;
	geoidSimple[22][6] = (byte)42;
	geoidSimple[22][7] = (byte)41;
	geoidSimple[22][8] = (byte)41;
	geoidSimple[22][9] = (byte)41;
	geoidSimple[22][10] = (byte)41;
	geoidSimple[22][11] = (byte)40;
	geoidSimple[22][12] = (byte)39;
	geoidSimple[22][13] = (byte)36;
	geoidSimple[22][14] = (byte)32;
	geoidSimple[22][15] = (byte)30;
	geoidSimple[22][16] = (byte)30;
	geoidSimple[22][17] = (byte)30;
	geoidSimple[22][18] = (byte)31;
	geoidSimple[22][19] = (byte)30;
	geoidSimple[22][20] = (byte)29;
	geoidSimple[22][21] = (byte)28;
	geoidSimple[22][22] = (byte)27;
	geoidSimple[22][23] = (byte)25;
	geoidSimple[22][24] = (byte)23;
	geoidSimple[22][25] = (byte)22;
	geoidSimple[22][26] = (byte)21;
	geoidSimple[22][27] = (byte)20;
	geoidSimple[22][28] = (byte)19;
	geoidSimple[22][29] = (byte)18;
	geoidSimple[22][30] = (byte)18;
	geoidSimple[22][31] = (byte)17;
	geoidSimple[22][32] = (byte)17;
	geoidSimple[22][33] = (byte)17;
	geoidSimple[22][34] = (byte)17;
	geoidSimple[22][35] = (byte)17;
	geoidSimple[22][36] = (byte)16;
	geoidSimple[22][37] = (byte)15;
	geoidSimple[22][38] = (byte)14;
	geoidSimple[22][39] = (byte)13;
	geoidSimple[22][40] = (byte)12;
	geoidSimple[22][41] = (byte)11;
	geoidSimple[22][42] = (byte)11;
	geoidSimple[22][43] = (byte)10;
	geoidSimple[22][44] = (byte)10;
	geoidSimple[22][45] = (byte)9;
	geoidSimple[22][46] = (byte)8;
	geoidSimple[22][47] = (byte)8;
	geoidSimple[22][48] = (byte)7;
	geoidSimple[22][49] = (byte)6;
	geoidSimple[22][50] = (byte)4;
	geoidSimple[22][51] = (byte)3;
	geoidSimple[22][52] = (byte)2;
	geoidSimple[22][53] = (byte)1;
	geoidSimple[22][54] = (byte)0;
	geoidSimple[22][55] = (byte)0;
	geoidSimple[22][56] = (byte)0;
	geoidSimple[22][57] = (byte)-1;
	geoidSimple[22][58] = (byte)-2;
	geoidSimple[22][59] = (byte)-2;
	geoidSimple[22][60] = (byte)-3;
	geoidSimple[22][61] = (byte)-4;
	geoidSimple[22][62] = (byte)-5;
	geoidSimple[22][63] = (byte)-6;
	geoidSimple[22][64] = (byte)-6;
	geoidSimple[22][65] = (byte)-5;
	geoidSimple[22][66] = (byte)-5;
	geoidSimple[22][67] = (byte)-6;
	geoidSimple[22][68] = (byte)-8;
	geoidSimple[22][69] = (byte)-9;
	geoidSimple[22][70] = (byte)-11;
	geoidSimple[22][71] = (byte)-12;
	geoidSimple[22][72] = (byte)-13;
	geoidSimple[22][73] = (byte)-14;
	geoidSimple[22][74] = (byte)-14;
	geoidSimple[22][75] = (byte)-14;
	geoidSimple[22][76] = (byte)-14;
	geoidSimple[22][77] = (byte)-14;
	geoidSimple[22][78] = (byte)-14;
	geoidSimple[22][79] = (byte)-15;
	geoidSimple[22][80] = (byte)-15;
	geoidSimple[22][81] = (byte)-15;
	geoidSimple[22][82] = (byte)-15;
	geoidSimple[22][83] = (byte)-15;
	geoidSimple[22][84] = (byte)-16;
	geoidSimple[22][85] = (byte)-16;
	geoidSimple[22][86] = (byte)-15;
	geoidSimple[22][87] = (byte)-16;
	geoidSimple[22][88] = (byte)-17;
	geoidSimple[22][89] = (byte)-17;
	geoidSimple[22][90] = (byte)-18;
	geoidSimple[22][91] = (byte)-18;
	geoidSimple[22][92] = (byte)-18;
	geoidSimple[22][93] = (byte)-17;
	geoidSimple[22][94] = (byte)-17;
	geoidSimple[22][95] = (byte)-17;
	geoidSimple[22][96] = (byte)-17;
	geoidSimple[22][97] = (byte)-17;
	geoidSimple[22][98] = (byte)-17;
	geoidSimple[22][99] = (byte)-17;
	geoidSimple[22][100] = (byte)-17;
	geoidSimple[22][101] = (byte)-17;
	geoidSimple[22][102] = (byte)-17;
	geoidSimple[22][103] = (byte)-16;
	geoidSimple[22][104] = (byte)-17;
	geoidSimple[22][105] = (byte)-17;
	geoidSimple[22][106] = (byte)-17;
	geoidSimple[22][107] = (byte)-17;
	geoidSimple[22][108] = (byte)-17;
	geoidSimple[22][109] = (byte)-16;
	geoidSimple[22][110] = (byte)-16;
	geoidSimple[22][111] = (byte)-15;
	geoidSimple[22][112] = (byte)-14;
	geoidSimple[22][113] = (byte)-14;
	geoidSimple[22][114] = (byte)-13;
	geoidSimple[22][115] = (byte)-13;
	geoidSimple[22][116] = (byte)-12;
	geoidSimple[22][117] = (byte)-11;
	geoidSimple[22][118] = (byte)-11;
	geoidSimple[22][119] = (byte)-11;
	geoidSimple[22][120] = (byte)-11;
	geoidSimple[22][121] = (byte)-11;
	geoidSimple[22][122] = (byte)-12;
	geoidSimple[22][123] = (byte)-13;
	geoidSimple[22][124] = (byte)-14;
	geoidSimple[22][125] = (byte)-14;
	geoidSimple[22][126] = (byte)-11;
	geoidSimple[22][127] = (byte)-8;
	geoidSimple[22][128] = (byte)-5;
	geoidSimple[22][129] = (byte)-5;
	geoidSimple[22][130] = (byte)-5;
	geoidSimple[22][131] = (byte)-4;
	geoidSimple[22][132] = (byte)-4;
	geoidSimple[22][133] = (byte)-4;
	geoidSimple[22][134] = (byte)-3;
	geoidSimple[22][135] = (byte)-2;
	geoidSimple[22][136] = (byte)-2;
	geoidSimple[22][137] = (byte)0;
	geoidSimple[22][138] = (byte)1;
	geoidSimple[22][139] = (byte)1;
	geoidSimple[22][140] = (byte)1;
	geoidSimple[22][141] = (byte)1;
	geoidSimple[22][142] = (byte)1;
	geoidSimple[22][143] = (byte)1;
	geoidSimple[22][144] = (byte)1;
	geoidSimple[22][145] = (byte)1;
	geoidSimple[22][146] = (byte)2;
	geoidSimple[22][147] = (byte)3;
	geoidSimple[22][148] = (byte)4;
	geoidSimple[22][149] = (byte)4;
	geoidSimple[22][150] = (byte)5;
	geoidSimple[22][151] = (byte)5;
	geoidSimple[22][152] = (byte)5;
	geoidSimple[22][153] = (byte)5;
	geoidSimple[22][154] = (byte)5;
	geoidSimple[22][155] = (byte)5;
	geoidSimple[22][156] = (byte)5;
	geoidSimple[22][157] = (byte)5;
	geoidSimple[22][158] = (byte)6;
	geoidSimple[22][159] = (byte)6;
	geoidSimple[22][160] = (byte)6;
	geoidSimple[22][161] = (byte)6;
	geoidSimple[22][162] = (byte)6;
	geoidSimple[22][163] = (byte)7;
	geoidSimple[22][164] = (byte)7;
	geoidSimple[22][165] = (byte)7;
	geoidSimple[22][166] = (byte)8;
	geoidSimple[22][167] = (byte)8;
	geoidSimple[22][168] = (byte)8;
	geoidSimple[22][169] = (byte)7;
	geoidSimple[22][170] = (byte)6;
	geoidSimple[22][171] = (byte)6;
	geoidSimple[22][172] = (byte)6;
	geoidSimple[22][173] = (byte)6;
	geoidSimple[22][174] = (byte)6;
	geoidSimple[22][175] = (byte)6;
	geoidSimple[22][176] = (byte)6;
	geoidSimple[22][177] = (byte)6;
	geoidSimple[22][178] = (byte)6;
	geoidSimple[22][179] = (byte)5;
	geoidSimple[22][LAT_GRID_SIZE] = (byte)4;
	geoidSimple[22][181] = (byte)4;
	geoidSimple[22][182] = (byte)3;
	geoidSimple[22][183] = (byte)2;
	geoidSimple[22][184] = (byte)2;
	geoidSimple[22][185] = (byte)1;
	geoidSimple[22][186] = (byte)1;
	geoidSimple[22][187] = (byte)1;
	geoidSimple[22][188] = (byte)1;
	geoidSimple[22][189] = (byte)1;
	geoidSimple[22][190] = (byte)0;
	geoidSimple[22][191] = (byte)0;
	geoidSimple[22][192] = (byte)0;
	geoidSimple[22][193] = (byte)1;
	geoidSimple[22][194] = (byte)1;
	geoidSimple[22][195] = (byte)1;
	geoidSimple[22][196] = (byte)2;
	geoidSimple[22][197] = (byte)3;
	geoidSimple[22][198] = (byte)4;
	geoidSimple[22][199] = (byte)4;
	geoidSimple[22][200] = (byte)4;
	geoidSimple[22][201] = (byte)4;
	geoidSimple[22][202] = (byte)4;
	geoidSimple[22][203] = (byte)5;
	geoidSimple[22][204] = (byte)7;
	geoidSimple[22][205] = (byte)7;
	geoidSimple[22][206] = (byte)7;
	geoidSimple[22][207] = (byte)7;
	geoidSimple[22][208] = (byte)8;
	geoidSimple[22][209] = (byte)8;
	geoidSimple[22][210] = (byte)9;
	geoidSimple[22][211] = (byte)9;
	geoidSimple[22][212] = (byte)8;
	geoidSimple[22][213] = (byte)8;
	geoidSimple[22][214] = (byte)7;
	geoidSimple[22][215] = (byte)7;
	geoidSimple[22][216] = (byte)7;
	geoidSimple[22][217] = (byte)6;
	geoidSimple[22][218] = (byte)6;
	geoidSimple[22][219] = (byte)5;
	geoidSimple[22][220] = (byte)5;
	geoidSimple[22][221] = (byte)4;
	geoidSimple[22][222] = (byte)3;
	geoidSimple[22][223] = (byte)2;
	geoidSimple[22][224] = (byte)0;
	geoidSimple[22][225] = (byte)0;
	geoidSimple[22][226] = (byte)-1;
	geoidSimple[22][227] = (byte)-1;
	geoidSimple[22][228] = (byte)-2;
	geoidSimple[22][229] = (byte)-3;
	geoidSimple[22][230] = (byte)-4;
	geoidSimple[22][231] = (byte)-5;
	geoidSimple[22][232] = (byte)-5;
	geoidSimple[22][233] = (byte)-6;
	geoidSimple[22][234] = (byte)-7;
	geoidSimple[22][235] = (byte)-8;
	geoidSimple[22][236] = (byte)-9;
	geoidSimple[22][237] = (byte)-10;
	geoidSimple[22][238] = (byte)-11;
	geoidSimple[22][239] = (byte)-13;
	geoidSimple[22][240] = (byte)-14;
	geoidSimple[22][241] = (byte)-16;
	geoidSimple[22][242] = (byte)-17;
	geoidSimple[22][243] = (byte)-18;
	geoidSimple[22][244] = (byte)-19;
	geoidSimple[22][245] = (byte)-21;
	geoidSimple[22][246] = (byte)-23;
	geoidSimple[22][247] = (byte)-25;
	geoidSimple[22][248] = (byte)-26;
	geoidSimple[22][249] = (byte)-27;
	geoidSimple[22][250] = (byte)-29;
	geoidSimple[22][251] = (byte)-30;
	geoidSimple[22][252] = (byte)-31;
	geoidSimple[22][253] = (byte)-32;
	geoidSimple[22][254] = (byte)-32;
	geoidSimple[22][255] = (byte)-33;
	geoidSimple[22][256] = (byte)-34;
	geoidSimple[22][257] = (byte)-35;
	geoidSimple[22][258] = (byte)-35;
	geoidSimple[22][259] = (byte)-35;
	geoidSimple[22][260] = (byte)-36;
	geoidSimple[22][261] = (byte)-35;
	geoidSimple[22][262] = (byte)-35;
	geoidSimple[22][263] = (byte)-35;
	geoidSimple[22][264] = (byte)-34;
	geoidSimple[22][265] = (byte)-34;
	geoidSimple[22][266] = (byte)-33;
	geoidSimple[22][267] = (byte)-31;
	geoidSimple[22][268] = (byte)-30;
	geoidSimple[22][269] = (byte)-30;
	geoidSimple[22][270] = (byte)-30;
	geoidSimple[22][271] = (byte)-30;
	geoidSimple[22][272] = (byte)-31;
	geoidSimple[22][273] = (byte)-30;
	geoidSimple[22][274] = (byte)-29;
	geoidSimple[22][275] = (byte)-28;
	geoidSimple[22][276] = (byte)-27;
	geoidSimple[22][277] = (byte)-26;
	geoidSimple[22][278] = (byte)-26;
	geoidSimple[22][279] = (byte)-26;
	geoidSimple[22][280] = (byte)-25;
	geoidSimple[22][281] = (byte)-24;
	geoidSimple[22][282] = (byte)-24;
	geoidSimple[22][283] = (byte)-22;
	geoidSimple[22][284] = (byte)-20;
	geoidSimple[22][285] = (byte)-19;
	geoidSimple[22][286] = (byte)-17;
	geoidSimple[22][287] = (byte)-15;
	geoidSimple[22][288] = (byte)-12;
	geoidSimple[22][289] = (byte)-9;
	geoidSimple[22][290] = (byte)-5;
	geoidSimple[22][291] = (byte)-2;
	geoidSimple[22][292] = (byte)0;
	geoidSimple[22][293] = (byte)3;
	geoidSimple[22][294] = (byte)5;
	geoidSimple[22][295] = (byte)6;
	geoidSimple[22][296] = (byte)8;
	geoidSimple[22][297] = (byte)11;
	geoidSimple[22][298] = (byte)14;
	geoidSimple[22][299] = (byte)16;
	geoidSimple[22][300] = (byte)19;
	geoidSimple[22][301] = (byte)21;
	geoidSimple[22][302] = (byte)23;
	geoidSimple[22][303] = (byte)24;
	geoidSimple[22][304] = (byte)25;
	geoidSimple[22][305] = (byte)25;
	geoidSimple[22][306] = (byte)26;
	geoidSimple[22][307] = (byte)28;
	geoidSimple[22][308] = (byte)29;
	geoidSimple[22][309] = (byte)31;
	geoidSimple[22][310] = (byte)33;
	geoidSimple[22][311] = (byte)36;
	geoidSimple[22][312] = (byte)38;
	geoidSimple[22][313] = (byte)40;
	geoidSimple[22][314] = (byte)41;
	geoidSimple[22][315] = (byte)43;
	geoidSimple[22][316] = (byte)45;
	geoidSimple[22][317] = (byte)46;
	geoidSimple[22][318] = (byte)47;
	geoidSimple[22][319] = (byte)47;
	geoidSimple[22][320] = (byte)48;
	geoidSimple[22][321] = (byte)50;
	geoidSimple[22][322] = (byte)53;
	geoidSimple[22][323] = (byte)55;
	geoidSimple[22][324] = (byte)56;
	geoidSimple[22][325] = (byte)56;
	geoidSimple[22][326] = (byte)56;
	geoidSimple[22][327] = (byte)56;
	geoidSimple[22][328] = (byte)57;
	geoidSimple[22][329] = (byte)58;
	geoidSimple[22][330] = (byte)58;
	geoidSimple[22][331] = (byte)59;
	geoidSimple[22][332] = (byte)59;
	geoidSimple[22][333] = (byte)59;
	geoidSimple[22][334] = (byte)59;
	geoidSimple[22][335] = (byte)59;
	geoidSimple[22][336] = (byte)60;
	geoidSimple[22][337] = (byte)61;
	geoidSimple[22][338] = (byte)61;
	geoidSimple[22][339] = (byte)62;
	geoidSimple[22][340] = (byte)62;
	geoidSimple[22][341] = (byte)63;
	geoidSimple[22][342] = (byte)62;
	geoidSimple[22][343] = (byte)62;
	geoidSimple[22][344] = (byte)61;
	geoidSimple[22][345] = (byte)61;
	geoidSimple[22][346] = (byte)59;
	geoidSimple[22][347] = (byte)59;
	geoidSimple[22][348] = (byte)58;
	geoidSimple[22][349] = (byte)57;
	geoidSimple[22][350] = (byte)56;
	geoidSimple[22][351] = (byte)55;
	geoidSimple[22][352] = (byte)54;
	geoidSimple[22][353] = (byte)53;
	geoidSimple[22][354] = (byte)51;
	geoidSimple[22][355] = (byte)51;
	geoidSimple[22][356] = (byte)50;
	geoidSimple[22][357] = (byte)50;
	geoidSimple[22][358] = (byte)50;
	geoidSimple[22][359] = (byte)49;
	}
		/** Row 23*/
	private static void init23() {
	geoidSimple[23][0] = (byte)49;
	geoidSimple[23][1] = (byte)48;
	geoidSimple[23][2] = (byte)47;
	geoidSimple[23][3] = (byte)45;
	geoidSimple[23][4] = (byte)44;
	geoidSimple[23][5] = (byte)43;
	geoidSimple[23][6] = (byte)42;
	geoidSimple[23][7] = (byte)42;
	geoidSimple[23][8] = (byte)42;
	geoidSimple[23][9] = (byte)41;
	geoidSimple[23][10] = (byte)40;
	geoidSimple[23][11] = (byte)38;
	geoidSimple[23][12] = (byte)36;
	geoidSimple[23][13] = (byte)34;
	geoidSimple[23][14] = (byte)32;
	geoidSimple[23][15] = (byte)31;
	geoidSimple[23][16] = (byte)31;
	geoidSimple[23][17] = (byte)31;
	geoidSimple[23][18] = (byte)30;
	geoidSimple[23][19] = (byte)29;
	geoidSimple[23][20] = (byte)28;
	geoidSimple[23][21] = (byte)26;
	geoidSimple[23][22] = (byte)24;
	geoidSimple[23][23] = (byte)22;
	geoidSimple[23][24] = (byte)21;
	geoidSimple[23][25] = (byte)20;
	geoidSimple[23][26] = (byte)19;
	geoidSimple[23][27] = (byte)18;
	geoidSimple[23][28] = (byte)17;
	geoidSimple[23][29] = (byte)17;
	geoidSimple[23][30] = (byte)17;
	geoidSimple[23][31] = (byte)17;
	geoidSimple[23][32] = (byte)16;
	geoidSimple[23][33] = (byte)17;
	geoidSimple[23][34] = (byte)17;
	geoidSimple[23][35] = (byte)17;
	geoidSimple[23][36] = (byte)16;
	geoidSimple[23][37] = (byte)16;
	geoidSimple[23][38] = (byte)15;
	geoidSimple[23][39] = (byte)15;
	geoidSimple[23][40] = (byte)13;
	geoidSimple[23][41] = (byte)12;
	geoidSimple[23][42] = (byte)11;
	geoidSimple[23][43] = (byte)11;
	geoidSimple[23][44] = (byte)10;
	geoidSimple[23][45] = (byte)8;
	geoidSimple[23][46] = (byte)7;
	geoidSimple[23][47] = (byte)6;
	geoidSimple[23][48] = (byte)7;
	geoidSimple[23][49] = (byte)6;
	geoidSimple[23][50] = (byte)5;
	geoidSimple[23][51] = (byte)3;
	geoidSimple[23][52] = (byte)2;
	geoidSimple[23][53] = (byte)1;
	geoidSimple[23][54] = (byte)0;
	geoidSimple[23][55] = (byte)0;
	geoidSimple[23][56] = (byte)0;
	geoidSimple[23][57] = (byte)-1;
	geoidSimple[23][58] = (byte)-2;
	geoidSimple[23][59] = (byte)-3;
	geoidSimple[23][60] = (byte)-4;
	geoidSimple[23][61] = (byte)-6;
	geoidSimple[23][62] = (byte)-7;
	geoidSimple[23][63] = (byte)-6;
	geoidSimple[23][64] = (byte)-4;
	geoidSimple[23][65] = (byte)-5;
	geoidSimple[23][66] = (byte)-6;
	geoidSimple[23][67] = (byte)-8;
	geoidSimple[23][68] = (byte)-10;
	geoidSimple[23][69] = (byte)-11;
	geoidSimple[23][70] = (byte)-12;
	geoidSimple[23][71] = (byte)-13;
	geoidSimple[23][72] = (byte)-15;
	geoidSimple[23][73] = (byte)-15;
	geoidSimple[23][74] = (byte)-15;
	geoidSimple[23][75] = (byte)-15;
	geoidSimple[23][76] = (byte)-16;
	geoidSimple[23][77] = (byte)-15;
	geoidSimple[23][78] = (byte)-15;
	geoidSimple[23][79] = (byte)-16;
	geoidSimple[23][80] = (byte)-17;
	geoidSimple[23][81] = (byte)-17;
	geoidSimple[23][82] = (byte)-17;
	geoidSimple[23][83] = (byte)-17;
	geoidSimple[23][84] = (byte)-17;
	geoidSimple[23][85] = (byte)-18;
	geoidSimple[23][86] = (byte)-18;
	geoidSimple[23][87] = (byte)-19;
	geoidSimple[23][88] = (byte)-19;
	geoidSimple[23][89] = (byte)-20;
	geoidSimple[23][90] = (byte)-20;
	geoidSimple[23][91] = (byte)-20;
	geoidSimple[23][92] = (byte)-20;
	geoidSimple[23][93] = (byte)-20;
	geoidSimple[23][94] = (byte)-20;
	geoidSimple[23][95] = (byte)-20;
	geoidSimple[23][96] = (byte)-20;
	geoidSimple[23][97] = (byte)-20;
	geoidSimple[23][98] = (byte)-20;
	geoidSimple[23][99] = (byte)-20;
	geoidSimple[23][100] = (byte)-20;
	geoidSimple[23][101] = (byte)-20;
	geoidSimple[23][102] = (byte)-19;
	geoidSimple[23][103] = (byte)-19;
	geoidSimple[23][104] = (byte)-19;
	geoidSimple[23][105] = (byte)-19;
	geoidSimple[23][106] = (byte)-18;
	geoidSimple[23][107] = (byte)-18;
	geoidSimple[23][108] = (byte)-17;
	geoidSimple[23][109] = (byte)-17;
	geoidSimple[23][110] = (byte)-16;
	geoidSimple[23][111] = (byte)-16;
	geoidSimple[23][112] = (byte)-15;
	geoidSimple[23][113] = (byte)-14;
	geoidSimple[23][114] = (byte)-14;
	geoidSimple[23][115] = (byte)-14;
	geoidSimple[23][116] = (byte)-13;
	geoidSimple[23][117] = (byte)-13;
	geoidSimple[23][118] = (byte)-12;
	geoidSimple[23][119] = (byte)-12;
	geoidSimple[23][120] = (byte)-12;
	geoidSimple[23][121] = (byte)-12;
	geoidSimple[23][122] = (byte)-13;
	geoidSimple[23][123] = (byte)-13;
	geoidSimple[23][124] = (byte)-13;
	geoidSimple[23][125] = (byte)-12;
	geoidSimple[23][126] = (byte)-9;
	geoidSimple[23][127] = (byte)-6;
	geoidSimple[23][128] = (byte)-5;
	geoidSimple[23][129] = (byte)-4;
	geoidSimple[23][130] = (byte)-4;
	geoidSimple[23][131] = (byte)-4;
	geoidSimple[23][132] = (byte)-4;
	geoidSimple[23][133] = (byte)-3;
	geoidSimple[23][134] = (byte)-2;
	geoidSimple[23][135] = (byte)-1;
	geoidSimple[23][136] = (byte)0;
	geoidSimple[23][137] = (byte)0;
	geoidSimple[23][138] = (byte)1;
	geoidSimple[23][139] = (byte)3;
	geoidSimple[23][140] = (byte)3;
	geoidSimple[23][141] = (byte)3;
	geoidSimple[23][142] = (byte)3;
	geoidSimple[23][143] = (byte)5;
	geoidSimple[23][144] = (byte)6;
	geoidSimple[23][145] = (byte)6;
	geoidSimple[23][146] = (byte)4;
	geoidSimple[23][147] = (byte)4;
	geoidSimple[23][148] = (byte)4;
	geoidSimple[23][149] = (byte)4;
	geoidSimple[23][150] = (byte)5;
	geoidSimple[23][151] = (byte)5;
	geoidSimple[23][152] = (byte)6;
	geoidSimple[23][153] = (byte)6;
	geoidSimple[23][154] = (byte)6;
	geoidSimple[23][155] = (byte)6;
	geoidSimple[23][156] = (byte)6;
	geoidSimple[23][157] = (byte)6;
	geoidSimple[23][158] = (byte)7;
	geoidSimple[23][159] = (byte)7;
	geoidSimple[23][160] = (byte)7;
	geoidSimple[23][161] = (byte)8;
	geoidSimple[23][162] = (byte)8;
	geoidSimple[23][163] = (byte)8;
	geoidSimple[23][164] = (byte)8;
	geoidSimple[23][165] = (byte)8;
	geoidSimple[23][166] = (byte)8;
	geoidSimple[23][167] = (byte)9;
	geoidSimple[23][168] = (byte)8;
	geoidSimple[23][169] = (byte)8;
	geoidSimple[23][170] = (byte)8;
	geoidSimple[23][171] = (byte)7;
	geoidSimple[23][172] = (byte)7;
	geoidSimple[23][173] = (byte)6;
	geoidSimple[23][174] = (byte)6;
	geoidSimple[23][175] = (byte)6;
	geoidSimple[23][176] = (byte)6;
	geoidSimple[23][177] = (byte)6;
	geoidSimple[23][178] = (byte)5;
	geoidSimple[23][179] = (byte)5;
	geoidSimple[23][LAT_GRID_SIZE] = (byte)4;
	geoidSimple[23][181] = (byte)4;
	geoidSimple[23][182] = (byte)4;
	geoidSimple[23][183] = (byte)3;
	geoidSimple[23][184] = (byte)2;
	geoidSimple[23][185] = (byte)2;
	geoidSimple[23][186] = (byte)2;
	geoidSimple[23][187] = (byte)2;
	geoidSimple[23][188] = (byte)2;
	geoidSimple[23][189] = (byte)2;
	geoidSimple[23][190] = (byte)2;
	geoidSimple[23][191] = (byte)2;
	geoidSimple[23][192] = (byte)2;
	geoidSimple[23][193] = (byte)3;
	geoidSimple[23][194] = (byte)3;
	geoidSimple[23][195] = (byte)3;
	geoidSimple[23][196] = (byte)3;
	geoidSimple[23][197] = (byte)4;
	geoidSimple[23][198] = (byte)4;
	geoidSimple[23][199] = (byte)5;
	geoidSimple[23][200] = (byte)5;
	geoidSimple[23][201] = (byte)6;
	geoidSimple[23][202] = (byte)6;
	geoidSimple[23][203] = (byte)7;
	geoidSimple[23][204] = (byte)7;
	geoidSimple[23][205] = (byte)8;
	geoidSimple[23][206] = (byte)8;
	geoidSimple[23][207] = (byte)8;
	geoidSimple[23][208] = (byte)8;
	geoidSimple[23][209] = (byte)8;
	geoidSimple[23][210] = (byte)8;
	geoidSimple[23][211] = (byte)8;
	geoidSimple[23][212] = (byte)8;
	geoidSimple[23][213] = (byte)7;
	geoidSimple[23][214] = (byte)7;
	geoidSimple[23][215] = (byte)7;
	geoidSimple[23][216] = (byte)7;
	geoidSimple[23][217] = (byte)7;
	geoidSimple[23][218] = (byte)7;
	geoidSimple[23][219] = (byte)7;
	geoidSimple[23][220] = (byte)7;
	geoidSimple[23][221] = (byte)6;
	geoidSimple[23][222] = (byte)5;
	geoidSimple[23][223] = (byte)5;
	geoidSimple[23][224] = (byte)4;
	geoidSimple[23][225] = (byte)2;
	geoidSimple[23][226] = (byte)0;
	geoidSimple[23][227] = (byte)-1;
	geoidSimple[23][228] = (byte)-2;
	geoidSimple[23][229] = (byte)-3;
	geoidSimple[23][230] = (byte)-4;
	geoidSimple[23][231] = (byte)-5;
	geoidSimple[23][232] = (byte)-6;
	geoidSimple[23][233] = (byte)-7;
	geoidSimple[23][234] = (byte)-8;
	geoidSimple[23][235] = (byte)-10;
	geoidSimple[23][236] = (byte)-11;
	geoidSimple[23][237] = (byte)-12;
	geoidSimple[23][238] = (byte)-14;
	geoidSimple[23][239] = (byte)-15;
	geoidSimple[23][240] = (byte)-16;
	geoidSimple[23][241] = (byte)-17;
	geoidSimple[23][242] = (byte)-17;
	geoidSimple[23][243] = (byte)-18;
	geoidSimple[23][244] = (byte)-18;
	geoidSimple[23][245] = (byte)-20;
	geoidSimple[23][246] = (byte)-22;
	geoidSimple[23][247] = (byte)-23;
	geoidSimple[23][248] = (byte)-24;
	geoidSimple[23][249] = (byte)-26;
	geoidSimple[23][250] = (byte)-27;
	geoidSimple[23][251] = (byte)-29;
	geoidSimple[23][252] = (byte)-31;
	geoidSimple[23][253] = (byte)-32;
	geoidSimple[23][254] = (byte)-33;
	geoidSimple[23][255] = (byte)-34;
	geoidSimple[23][256] = (byte)-35;
	geoidSimple[23][257] = (byte)-36;
	geoidSimple[23][258] = (byte)-36;
	geoidSimple[23][259] = (byte)-36;
	geoidSimple[23][260] = (byte)-37;
	geoidSimple[23][261] = (byte)-37;
	geoidSimple[23][262] = (byte)-37;
	geoidSimple[23][263] = (byte)-37;
	geoidSimple[23][264] = (byte)-36;
	geoidSimple[23][265] = (byte)-35;
	geoidSimple[23][266] = (byte)-34;
	geoidSimple[23][267] = (byte)-34;
	geoidSimple[23][268] = (byte)-33;
	geoidSimple[23][269] = (byte)-33;
	geoidSimple[23][270] = (byte)-32;
	geoidSimple[23][271] = (byte)-32;
	geoidSimple[23][272] = (byte)-32;
	geoidSimple[23][273] = (byte)-32;
	geoidSimple[23][274] = (byte)-32;
	geoidSimple[23][275] = (byte)-31;
	geoidSimple[23][276] = (byte)-30;
	geoidSimple[23][277] = (byte)-29;
	geoidSimple[23][278] = (byte)-29;
	geoidSimple[23][279] = (byte)-28;
	geoidSimple[23][280] = (byte)-27;
	geoidSimple[23][281] = (byte)-27;
	geoidSimple[23][282] = (byte)-27;
	geoidSimple[23][283] = (byte)-26;
	geoidSimple[23][284] = (byte)-24;
	geoidSimple[23][285] = (byte)-22;
	geoidSimple[23][286] = (byte)-21;
	geoidSimple[23][287] = (byte)-18;
	geoidSimple[23][288] = (byte)-16;
	geoidSimple[23][289] = (byte)-13;
	geoidSimple[23][290] = (byte)-10;
	geoidSimple[23][291] = (byte)-7;
	geoidSimple[23][292] = (byte)-4;
	geoidSimple[23][293] = (byte)0;
	geoidSimple[23][294] = (byte)4;
	geoidSimple[23][295] = (byte)6;
	geoidSimple[23][296] = (byte)8;
	geoidSimple[23][297] = (byte)9;
	geoidSimple[23][298] = (byte)11;
	geoidSimple[23][299] = (byte)15;
	geoidSimple[23][300] = (byte)18;
	geoidSimple[23][301] = (byte)20;
	geoidSimple[23][302] = (byte)21;
	geoidSimple[23][303] = (byte)23;
	geoidSimple[23][304] = (byte)25;
	geoidSimple[23][305] = (byte)26;
	geoidSimple[23][306] = (byte)27;
	geoidSimple[23][307] = (byte)29;
	geoidSimple[23][308] = (byte)31;
	geoidSimple[23][309] = (byte)32;
	geoidSimple[23][310] = (byte)34;
	geoidSimple[23][311] = (byte)36;
	geoidSimple[23][312] = (byte)39;
	geoidSimple[23][313] = (byte)42;
	geoidSimple[23][314] = (byte)43;
	geoidSimple[23][315] = (byte)45;
	geoidSimple[23][316] = (byte)47;
	geoidSimple[23][317] = (byte)47;
	geoidSimple[23][318] = (byte)47;
	geoidSimple[23][319] = (byte)48;
	geoidSimple[23][320] = (byte)49;
	geoidSimple[23][321] = (byte)50;
	geoidSimple[23][322] = (byte)52;
	geoidSimple[23][323] = (byte)54;
	geoidSimple[23][324] = (byte)55;
	geoidSimple[23][325] = (byte)55;
	geoidSimple[23][326] = (byte)56;
	geoidSimple[23][327] = (byte)57;
	geoidSimple[23][328] = (byte)57;
	geoidSimple[23][329] = (byte)58;
	geoidSimple[23][330] = (byte)59;
	geoidSimple[23][331] = (byte)59;
	geoidSimple[23][332] = (byte)60;
	geoidSimple[23][333] = (byte)60;
	geoidSimple[23][334] = (byte)61;
	geoidSimple[23][335] = (byte)62;
	geoidSimple[23][336] = (byte)63;
	geoidSimple[23][337] = (byte)63;
	geoidSimple[23][338] = (byte)63;
	geoidSimple[23][339] = (byte)64;
	geoidSimple[23][340] = (byte)64;
	geoidSimple[23][341] = (byte)64;
	geoidSimple[23][342] = (byte)64;
	geoidSimple[23][343] = (byte)63;
	geoidSimple[23][344] = (byte)63;
	geoidSimple[23][345] = (byte)63;
	geoidSimple[23][346] = (byte)62;
	geoidSimple[23][347] = (byte)60;
	geoidSimple[23][348] = (byte)59;
	geoidSimple[23][349] = (byte)58;
	geoidSimple[23][350] = (byte)57;
	geoidSimple[23][351] = (byte)56;
	geoidSimple[23][352] = (byte)55;
	geoidSimple[23][353] = (byte)53;
	geoidSimple[23][354] = (byte)52;
	geoidSimple[23][355] = (byte)52;
	geoidSimple[23][356] = (byte)51;
	geoidSimple[23][357] = (byte)51;
	geoidSimple[23][358] = (byte)50;
	geoidSimple[23][359] = (byte)50;
	}
		/** Row 24*/
	private static void init24() {
	geoidSimple[24][0] = (byte)50;
	geoidSimple[24][1] = (byte)49;
	geoidSimple[24][2] = (byte)47;
	geoidSimple[24][3] = (byte)45;
	geoidSimple[24][4] = (byte)44;
	geoidSimple[24][5] = (byte)43;
	geoidSimple[24][6] = (byte)42;
	geoidSimple[24][7] = (byte)41;
	geoidSimple[24][8] = (byte)40;
	geoidSimple[24][9] = (byte)40;
	geoidSimple[24][10] = (byte)39;
	geoidSimple[24][11] = (byte)38;
	geoidSimple[24][12] = (byte)36;
	geoidSimple[24][13] = (byte)34;
	geoidSimple[24][14] = (byte)33;
	geoidSimple[24][15] = (byte)32;
	geoidSimple[24][16] = (byte)31;
	geoidSimple[24][17] = (byte)30;
	geoidSimple[24][18] = (byte)29;
	geoidSimple[24][19] = (byte)27;
	geoidSimple[24][20] = (byte)25;
	geoidSimple[24][21] = (byte)23;
	geoidSimple[24][22] = (byte)21;
	geoidSimple[24][23] = (byte)19;
	geoidSimple[24][24] = (byte)19;
	geoidSimple[24][25] = (byte)18;
	geoidSimple[24][26] = (byte)18;
	geoidSimple[24][27] = (byte)17;
	geoidSimple[24][28] = (byte)17;
	geoidSimple[24][29] = (byte)18;
	geoidSimple[24][30] = (byte)17;
	geoidSimple[24][31] = (byte)17;
	geoidSimple[24][32] = (byte)17;
	geoidSimple[24][33] = (byte)17;
	geoidSimple[24][34] = (byte)17;
	geoidSimple[24][35] = (byte)17;
	geoidSimple[24][36] = (byte)16;
	geoidSimple[24][37] = (byte)15;
	geoidSimple[24][38] = (byte)14;
	geoidSimple[24][39] = (byte)13;
	geoidSimple[24][40] = (byte)13;
	geoidSimple[24][41] = (byte)12;
	geoidSimple[24][42] = (byte)11;
	geoidSimple[24][43] = (byte)11;
	geoidSimple[24][44] = (byte)10;
	geoidSimple[24][45] = (byte)9;
	geoidSimple[24][46] = (byte)7;
	geoidSimple[24][47] = (byte)6;
	geoidSimple[24][48] = (byte)6;
	geoidSimple[24][49] = (byte)6;
	geoidSimple[24][50] = (byte)5;
	geoidSimple[24][51] = (byte)3;
	geoidSimple[24][52] = (byte)2;
	geoidSimple[24][53] = (byte)1;
	geoidSimple[24][54] = (byte)0;
	geoidSimple[24][55] = (byte)0;
	geoidSimple[24][56] = (byte)0;
	geoidSimple[24][57] = (byte)-2;
	geoidSimple[24][58] = (byte)-3;
	geoidSimple[24][59] = (byte)-3;
	geoidSimple[24][60] = (byte)-3;
	geoidSimple[24][61] = (byte)-4;
	geoidSimple[24][62] = (byte)-4;
	geoidSimple[24][63] = (byte)-5;
	geoidSimple[24][64] = (byte)-6;
	geoidSimple[24][65] = (byte)-8;
	geoidSimple[24][66] = (byte)-9;
	geoidSimple[24][67] = (byte)-10;
	geoidSimple[24][68] = (byte)-12;
	geoidSimple[24][69] = (byte)-13;
	geoidSimple[24][70] = (byte)-14;
	geoidSimple[24][71] = (byte)-15;
	geoidSimple[24][72] = (byte)-16;
	geoidSimple[24][73] = (byte)-17;
	geoidSimple[24][74] = (byte)-17;
	geoidSimple[24][75] = (byte)-17;
	geoidSimple[24][76] = (byte)-17;
	geoidSimple[24][77] = (byte)-17;
	geoidSimple[24][78] = (byte)-17;
	geoidSimple[24][79] = (byte)-18;
	geoidSimple[24][80] = (byte)-19;
	geoidSimple[24][81] = (byte)-19;
	geoidSimple[24][82] = (byte)-19;
	geoidSimple[24][83] = (byte)-19;
	geoidSimple[24][84] = (byte)-19;
	geoidSimple[24][85] = (byte)-20;
	geoidSimple[24][86] = (byte)-21;
	geoidSimple[24][87] = (byte)-21;
	geoidSimple[24][88] = (byte)-22;
	geoidSimple[24][89] = (byte)-22;
	geoidSimple[24][90] = (byte)-22;
	geoidSimple[24][91] = (byte)-22;
	geoidSimple[24][92] = (byte)-23;
	geoidSimple[24][93] = (byte)-23;
	geoidSimple[24][94] = (byte)-23;
	geoidSimple[24][95] = (byte)-22;
	geoidSimple[24][96] = (byte)-23;
	geoidSimple[24][97] = (byte)-23;
	geoidSimple[24][98] = (byte)-23;
	geoidSimple[24][99] = (byte)-22;
	geoidSimple[24][100] = (byte)-22;
	geoidSimple[24][101] = (byte)-23;
	geoidSimple[24][102] = (byte)-22;
	geoidSimple[24][103] = (byte)-21;
	geoidSimple[24][104] = (byte)-21;
	geoidSimple[24][105] = (byte)-20;
	geoidSimple[24][106] = (byte)-20;
	geoidSimple[24][107] = (byte)-19;
	geoidSimple[24][108] = (byte)-18;
	geoidSimple[24][109] = (byte)-17;
	geoidSimple[24][110] = (byte)-17;
	geoidSimple[24][111] = (byte)-16;
	geoidSimple[24][112] = (byte)-15;
	geoidSimple[24][113] = (byte)-15;
	geoidSimple[24][114] = (byte)-16;
	geoidSimple[24][115] = (byte)-16;
	geoidSimple[24][116] = (byte)-16;
	geoidSimple[24][117] = (byte)-16;
	geoidSimple[24][118] = (byte)-15;
	geoidSimple[24][119] = (byte)-15;
	geoidSimple[24][120] = (byte)-15;
	geoidSimple[24][121] = (byte)-15;
	geoidSimple[24][122] = (byte)-15;
	geoidSimple[24][123] = (byte)-15;
	geoidSimple[24][124] = (byte)-15;
	geoidSimple[24][125] = (byte)-14;
	geoidSimple[24][126] = (byte)-11;
	geoidSimple[24][127] = (byte)-7;
	geoidSimple[24][128] = (byte)-5;
	geoidSimple[24][129] = (byte)-4;
	geoidSimple[24][130] = (byte)-4;
	geoidSimple[24][131] = (byte)-4;
	geoidSimple[24][132] = (byte)-3;
	geoidSimple[24][133] = (byte)-2;
	geoidSimple[24][134] = (byte)-1;
	geoidSimple[24][135] = (byte)0;
	geoidSimple[24][136] = (byte)0;
	geoidSimple[24][137] = (byte)1;
	geoidSimple[24][138] = (byte)2;
	geoidSimple[24][139] = (byte)3;
	geoidSimple[24][140] = (byte)4;
	geoidSimple[24][141] = (byte)5;
	geoidSimple[24][142] = (byte)5;
	geoidSimple[24][143] = (byte)5;
	geoidSimple[24][144] = (byte)6;
	geoidSimple[24][145] = (byte)7;
	geoidSimple[24][146] = (byte)8;
	geoidSimple[24][147] = (byte)8;
	geoidSimple[24][148] = (byte)8;
	geoidSimple[24][149] = (byte)6;
	geoidSimple[24][150] = (byte)5;
	geoidSimple[24][151] = (byte)6;
	geoidSimple[24][152] = (byte)7;
	geoidSimple[24][153] = (byte)7;
	geoidSimple[24][154] = (byte)7;
	geoidSimple[24][155] = (byte)7;
	geoidSimple[24][156] = (byte)7;
	geoidSimple[24][157] = (byte)8;
	geoidSimple[24][158] = (byte)8;
	geoidSimple[24][159] = (byte)8;
	geoidSimple[24][160] = (byte)9;
	geoidSimple[24][161] = (byte)9;
	geoidSimple[24][162] = (byte)10;
	geoidSimple[24][163] = (byte)10;
	geoidSimple[24][164] = (byte)10;
	geoidSimple[24][165] = (byte)10;
	geoidSimple[24][166] = (byte)9;
	geoidSimple[24][167] = (byte)9;
	geoidSimple[24][168] = (byte)9;
	geoidSimple[24][169] = (byte)8;
	geoidSimple[24][170] = (byte)8;
	geoidSimple[24][171] = (byte)7;
	geoidSimple[24][172] = (byte)6;
	geoidSimple[24][173] = (byte)6;
	geoidSimple[24][174] = (byte)6;
	geoidSimple[24][175] = (byte)5;
	geoidSimple[24][176] = (byte)5;
	geoidSimple[24][177] = (byte)5;
	geoidSimple[24][178] = (byte)5;
	geoidSimple[24][179] = (byte)4;
	geoidSimple[24][LAT_GRID_SIZE] = (byte)4;
	geoidSimple[24][181] = (byte)4;
	geoidSimple[24][182] = (byte)4;
	geoidSimple[24][183] = (byte)4;
	geoidSimple[24][184] = (byte)4;
	geoidSimple[24][185] = (byte)3;
	geoidSimple[24][186] = (byte)3;
	geoidSimple[24][187] = (byte)3;
	geoidSimple[24][188] = (byte)4;
	geoidSimple[24][189] = (byte)4;
	geoidSimple[24][190] = (byte)3;
	geoidSimple[24][191] = (byte)3;
	geoidSimple[24][192] = (byte)4;
	geoidSimple[24][193] = (byte)5;
	geoidSimple[24][194] = (byte)5;
	geoidSimple[24][195] = (byte)5;
	geoidSimple[24][196] = (byte)6;
	geoidSimple[24][197] = (byte)6;
	geoidSimple[24][198] = (byte)6;
	geoidSimple[24][199] = (byte)7;
	geoidSimple[24][200] = (byte)7;
	geoidSimple[24][201] = (byte)7;
	geoidSimple[24][202] = (byte)7;
	geoidSimple[24][203] = (byte)7;
	geoidSimple[24][204] = (byte)8;
	geoidSimple[24][205] = (byte)8;
	geoidSimple[24][206] = (byte)9;
	geoidSimple[24][207] = (byte)9;
	geoidSimple[24][208] = (byte)10;
	geoidSimple[24][209] = (byte)10;
	geoidSimple[24][210] = (byte)10;
	geoidSimple[24][211] = (byte)10;
	geoidSimple[24][212] = (byte)10;
	geoidSimple[24][213] = (byte)10;
	geoidSimple[24][214] = (byte)10;
	geoidSimple[24][215] = (byte)10;
	geoidSimple[24][216] = (byte)9;
	geoidSimple[24][217] = (byte)9;
	geoidSimple[24][218] = (byte)9;
	geoidSimple[24][219] = (byte)9;
	geoidSimple[24][220] = (byte)8;
	geoidSimple[24][221] = (byte)8;
	geoidSimple[24][222] = (byte)7;
	geoidSimple[24][223] = (byte)6;
	geoidSimple[24][224] = (byte)5;
	geoidSimple[24][225] = (byte)4;
	geoidSimple[24][226] = (byte)3;
	geoidSimple[24][227] = (byte)2;
	geoidSimple[24][228] = (byte)0;
	geoidSimple[24][229] = (byte)-1;
	geoidSimple[24][230] = (byte)-3;
	geoidSimple[24][231] = (byte)-5;
	geoidSimple[24][232] = (byte)-6;
	geoidSimple[24][233] = (byte)-8;
	geoidSimple[24][234] = (byte)-9;
	geoidSimple[24][235] = (byte)-10;
	geoidSimple[24][236] = (byte)-12;
	geoidSimple[24][237] = (byte)-13;
	geoidSimple[24][238] = (byte)-15;
	geoidSimple[24][239] = (byte)-16;
	geoidSimple[24][240] = (byte)-17;
	geoidSimple[24][241] = (byte)-18;
	geoidSimple[24][242] = (byte)-19;
	geoidSimple[24][243] = (byte)-19;
	geoidSimple[24][244] = (byte)-19;
	geoidSimple[24][245] = (byte)-20;
	geoidSimple[24][246] = (byte)-22;
	geoidSimple[24][247] = (byte)-23;
	geoidSimple[24][248] = (byte)-24;
	geoidSimple[24][249] = (byte)-26;
	geoidSimple[24][250] = (byte)-27;
	geoidSimple[24][251] = (byte)-29;
	geoidSimple[24][252] = (byte)-31;
	geoidSimple[24][253] = (byte)-32;
	geoidSimple[24][254] = (byte)-33;
	geoidSimple[24][255] = (byte)-34;
	geoidSimple[24][256] = (byte)-35;
	geoidSimple[24][257] = (byte)-36;
	geoidSimple[24][258] = (byte)-37;
	geoidSimple[24][259] = (byte)-38;
	geoidSimple[24][260] = (byte)-39;
	geoidSimple[24][261] = (byte)-39;
	geoidSimple[24][262] = (byte)-39;
	geoidSimple[24][263] = (byte)-39;
	geoidSimple[24][264] = (byte)-38;
	geoidSimple[24][265] = (byte)-38;
	geoidSimple[24][266] = (byte)-37;
	geoidSimple[24][267] = (byte)-37;
	geoidSimple[24][268] = (byte)-36;
	geoidSimple[24][269] = (byte)-36;
	geoidSimple[24][270] = (byte)-36;
	geoidSimple[24][271] = (byte)-35;
	geoidSimple[24][272] = (byte)-35;
	geoidSimple[24][273] = (byte)-34;
	geoidSimple[24][274] = (byte)-34;
	geoidSimple[24][275] = (byte)-33;
	geoidSimple[24][276] = (byte)-33;
	geoidSimple[24][277] = (byte)-32;
	geoidSimple[24][278] = (byte)-31;
	geoidSimple[24][279] = (byte)-30;
	geoidSimple[24][280] = (byte)-30;
	geoidSimple[24][281] = (byte)-29;
	geoidSimple[24][282] = (byte)-28;
	geoidSimple[24][283] = (byte)-26;
	geoidSimple[24][284] = (byte)-25;
	geoidSimple[24][285] = (byte)-23;
	geoidSimple[24][286] = (byte)-21;
	geoidSimple[24][287] = (byte)-19;
	geoidSimple[24][288] = (byte)-17;
	geoidSimple[24][289] = (byte)-15;
	geoidSimple[24][290] = (byte)-12;
	geoidSimple[24][291] = (byte)-9;
	geoidSimple[24][292] = (byte)-7;
	geoidSimple[24][293] = (byte)-5;
	geoidSimple[24][294] = (byte)-1;
	geoidSimple[24][295] = (byte)2;
	geoidSimple[24][296] = (byte)5;
	geoidSimple[24][297] = (byte)6;
	geoidSimple[24][298] = (byte)8;
	geoidSimple[24][299] = (byte)14;
	geoidSimple[24][300] = (byte)17;
	geoidSimple[24][301] = (byte)19;
	geoidSimple[24][302] = (byte)20;
	geoidSimple[24][303] = (byte)22;
	geoidSimple[24][304] = (byte)24;
	geoidSimple[24][305] = (byte)27;
	geoidSimple[24][306] = (byte)28;
	geoidSimple[24][307] = (byte)28;
	geoidSimple[24][308] = (byte)29;
	geoidSimple[24][309] = (byte)31;
	geoidSimple[24][310] = (byte)34;
	geoidSimple[24][311] = (byte)37;
	geoidSimple[24][312] = (byte)40;
	geoidSimple[24][313] = (byte)43;
	geoidSimple[24][314] = (byte)44;
	geoidSimple[24][315] = (byte)46;
	geoidSimple[24][316] = (byte)48;
	geoidSimple[24][317] = (byte)48;
	geoidSimple[24][318] = (byte)47;
	geoidSimple[24][319] = (byte)46;
	geoidSimple[24][320] = (byte)46;
	geoidSimple[24][321] = (byte)47;
	geoidSimple[24][322] = (byte)49;
	geoidSimple[24][323] = (byte)51;
	geoidSimple[24][324] = (byte)54;
	geoidSimple[24][325] = (byte)56;
	geoidSimple[24][326] = (byte)57;
	geoidSimple[24][327] = (byte)57;
	geoidSimple[24][328] = (byte)57;
	geoidSimple[24][329] = (byte)59;
	geoidSimple[24][330] = (byte)59;
	geoidSimple[24][331] = (byte)60;
	geoidSimple[24][332] = (byte)60;
	geoidSimple[24][333] = (byte)62;
	geoidSimple[24][334] = (byte)63;
	geoidSimple[24][335] = (byte)63;
	geoidSimple[24][336] = (byte)64;
	geoidSimple[24][337] = (byte)65;
	geoidSimple[24][338] = (byte)65;
	geoidSimple[24][339] = (byte)65;
	geoidSimple[24][340] = (byte)66;
	geoidSimple[24][341] = (byte)66;
	geoidSimple[24][342] = (byte)66;
	geoidSimple[24][343] = (byte)65;
	geoidSimple[24][344] = (byte)65;
	geoidSimple[24][345] = (byte)64;
	geoidSimple[24][346] = (byte)63;
	geoidSimple[24][347] = (byte)62;
	geoidSimple[24][348] = (byte)61;
	geoidSimple[24][349] = (byte)59;
	geoidSimple[24][350] = (byte)58;
	geoidSimple[24][351] = (byte)57;
	geoidSimple[24][352] = (byte)55;
	geoidSimple[24][353] = (byte)54;
	geoidSimple[24][354] = (byte)53;
	geoidSimple[24][355] = (byte)52;
	geoidSimple[24][356] = (byte)52;
	geoidSimple[24][357] = (byte)51;
	geoidSimple[24][358] = (byte)51;
	geoidSimple[24][359] = (byte)50;
	}
		/** Row 25*/
	private static void init25() {
	geoidSimple[25][0] = (byte)50;
	geoidSimple[25][1] = (byte)48;
	geoidSimple[25][2] = (byte)46;
	geoidSimple[25][3] = (byte)44;
	geoidSimple[25][4] = (byte)43;
	geoidSimple[25][5] = (byte)42;
	geoidSimple[25][6] = (byte)42;
	geoidSimple[25][7] = (byte)41;
	geoidSimple[25][8] = (byte)40;
	geoidSimple[25][9] = (byte)40;
	geoidSimple[25][10] = (byte)40;
	geoidSimple[25][11] = (byte)38;
	geoidSimple[25][12] = (byte)36;
	geoidSimple[25][13] = (byte)34;
	geoidSimple[25][14] = (byte)32;
	geoidSimple[25][15] = (byte)30;
	geoidSimple[25][16] = (byte)30;
	geoidSimple[25][17] = (byte)29;
	geoidSimple[25][18] = (byte)27;
	geoidSimple[25][19] = (byte)26;
	geoidSimple[25][20] = (byte)23;
	geoidSimple[25][21] = (byte)21;
	geoidSimple[25][22] = (byte)19;
	geoidSimple[25][23] = (byte)18;
	geoidSimple[25][24] = (byte)17;
	geoidSimple[25][25] = (byte)17;
	geoidSimple[25][26] = (byte)17;
	geoidSimple[25][27] = (byte)17;
	geoidSimple[25][28] = (byte)17;
	geoidSimple[25][29] = (byte)17;
	geoidSimple[25][30] = (byte)17;
	geoidSimple[25][31] = (byte)16;
	geoidSimple[25][32] = (byte)16;
	geoidSimple[25][33] = (byte)16;
	geoidSimple[25][34] = (byte)16;
	geoidSimple[25][35] = (byte)16;
	geoidSimple[25][36] = (byte)16;
	geoidSimple[25][37] = (byte)15;
	geoidSimple[25][38] = (byte)14;
	geoidSimple[25][39] = (byte)13;
	geoidSimple[25][40] = (byte)12;
	geoidSimple[25][41] = (byte)12;
	geoidSimple[25][42] = (byte)10;
	geoidSimple[25][43] = (byte)9;
	geoidSimple[25][44] = (byte)8;
	geoidSimple[25][45] = (byte)8;
	geoidSimple[25][46] = (byte)7;
	geoidSimple[25][47] = (byte)7;
	geoidSimple[25][48] = (byte)6;
	geoidSimple[25][49] = (byte)6;
	geoidSimple[25][50] = (byte)5;
	geoidSimple[25][51] = (byte)4;
	geoidSimple[25][52] = (byte)3;
	geoidSimple[25][53] = (byte)1;
	geoidSimple[25][54] = (byte)0;
	geoidSimple[25][55] = (byte)0;
	geoidSimple[25][56] = (byte)0;
	geoidSimple[25][57] = (byte)-2;
	geoidSimple[25][58] = (byte)-2;
	geoidSimple[25][59] = (byte)-1;
	geoidSimple[25][60] = (byte)-1;
	geoidSimple[25][61] = (byte)-3;
	geoidSimple[25][62] = (byte)-5;
	geoidSimple[25][63] = (byte)-7;
	geoidSimple[25][64] = (byte)-9;
	geoidSimple[25][65] = (byte)-10;
	geoidSimple[25][66] = (byte)-11;
	geoidSimple[25][67] = (byte)-12;
	geoidSimple[25][68] = (byte)-13;
	geoidSimple[25][69] = (byte)-13;
	geoidSimple[25][70] = (byte)-14;
	geoidSimple[25][71] = (byte)-15;
	geoidSimple[25][72] = (byte)-16;
	geoidSimple[25][73] = (byte)-17;
	geoidSimple[25][74] = (byte)-18;
	geoidSimple[25][75] = (byte)-19;
	geoidSimple[25][76] = (byte)-19;
	geoidSimple[25][77] = (byte)-19;
	geoidSimple[25][78] = (byte)-19;
	geoidSimple[25][79] = (byte)-19;
	geoidSimple[25][80] = (byte)-20;
	geoidSimple[25][81] = (byte)-20;
	geoidSimple[25][82] = (byte)-20;
	geoidSimple[25][83] = (byte)-20;
	geoidSimple[25][84] = (byte)-21;
	geoidSimple[25][85] = (byte)-22;
	geoidSimple[25][86] = (byte)-23;
	geoidSimple[25][87] = (byte)-23;
	geoidSimple[25][88] = (byte)-23;
	geoidSimple[25][89] = (byte)-23;
	geoidSimple[25][90] = (byte)-23;
	geoidSimple[25][91] = (byte)-23;
	geoidSimple[25][92] = (byte)-24;
	geoidSimple[25][93] = (byte)-25;
	geoidSimple[25][94] = (byte)-25;
	geoidSimple[25][95] = (byte)-25;
	geoidSimple[25][96] = (byte)-25;
	geoidSimple[25][97] = (byte)-25;
	geoidSimple[25][98] = (byte)-25;
	geoidSimple[25][99] = (byte)-25;
	geoidSimple[25][100] = (byte)-26;
	geoidSimple[25][101] = (byte)-26;
	geoidSimple[25][102] = (byte)-26;
	geoidSimple[25][103] = (byte)-25;
	geoidSimple[25][104] = (byte)-23;
	geoidSimple[25][105] = (byte)-23;
	geoidSimple[25][106] = (byte)-23;
	geoidSimple[25][107] = (byte)-23;
	geoidSimple[25][108] = (byte)-22;
	geoidSimple[25][109] = (byte)-20;
	geoidSimple[25][110] = (byte)-19;
	geoidSimple[25][111] = (byte)-19;
	geoidSimple[25][112] = (byte)-18;
	geoidSimple[25][113] = (byte)-18;
	geoidSimple[25][114] = (byte)-18;
	geoidSimple[25][115] = (byte)-18;
	geoidSimple[25][116] = (byte)-18;
	geoidSimple[25][117] = (byte)-18;
	geoidSimple[25][118] = (byte)-17;
	geoidSimple[25][119] = (byte)-17;
	geoidSimple[25][120] = (byte)-17;
	geoidSimple[25][121] = (byte)-17;
	geoidSimple[25][122] = (byte)-17;
	geoidSimple[25][123] = (byte)-16;
	geoidSimple[25][124] = (byte)-16;
	geoidSimple[25][125] = (byte)-15;
	geoidSimple[25][126] = (byte)-12;
	geoidSimple[25][127] = (byte)-9;
	geoidSimple[25][128] = (byte)-7;
	geoidSimple[25][129] = (byte)-5;
	geoidSimple[25][130] = (byte)-5;
	geoidSimple[25][131] = (byte)-3;
	geoidSimple[25][132] = (byte)-2;
	geoidSimple[25][133] = (byte)0;
	geoidSimple[25][134] = (byte)0;
	geoidSimple[25][135] = (byte)1;
	geoidSimple[25][136] = (byte)2;
	geoidSimple[25][137] = (byte)3;
	geoidSimple[25][138] = (byte)3;
	geoidSimple[25][139] = (byte)4;
	geoidSimple[25][140] = (byte)4;
	geoidSimple[25][141] = (byte)5;
	geoidSimple[25][142] = (byte)6;
	geoidSimple[25][143] = (byte)6;
	geoidSimple[25][144] = (byte)7;
	geoidSimple[25][145] = (byte)8;
	geoidSimple[25][146] = (byte)9;
	geoidSimple[25][147] = (byte)9;
	geoidSimple[25][148] = (byte)9;
	geoidSimple[25][149] = (byte)9;
	geoidSimple[25][150] = (byte)8;
	geoidSimple[25][151] = (byte)8;
	geoidSimple[25][152] = (byte)8;
	geoidSimple[25][153] = (byte)8;
	geoidSimple[25][154] = (byte)8;
	geoidSimple[25][155] = (byte)9;
	geoidSimple[25][156] = (byte)9;
	geoidSimple[25][157] = (byte)9;
	geoidSimple[25][158] = (byte)10;
	geoidSimple[25][159] = (byte)10;
	geoidSimple[25][160] = (byte)10;
	geoidSimple[25][161] = (byte)10;
	geoidSimple[25][162] = (byte)11;
	geoidSimple[25][163] = (byte)11;
	geoidSimple[25][164] = (byte)10;
	geoidSimple[25][165] = (byte)10;
	geoidSimple[25][166] = (byte)10;
	geoidSimple[25][167] = (byte)10;
	geoidSimple[25][168] = (byte)9;
	geoidSimple[25][169] = (byte)9;
	geoidSimple[25][170] = (byte)8;
	geoidSimple[25][171] = (byte)7;
	geoidSimple[25][172] = (byte)7;
	geoidSimple[25][173] = (byte)6;
	geoidSimple[25][174] = (byte)6;
	geoidSimple[25][175] = (byte)5;
	geoidSimple[25][176] = (byte)4;
	geoidSimple[25][177] = (byte)4;
	geoidSimple[25][178] = (byte)4;
	geoidSimple[25][179] = (byte)4;
	geoidSimple[25][LAT_GRID_SIZE] = (byte)4;
	geoidSimple[25][181] = (byte)4;
	geoidSimple[25][182] = (byte)4;
	geoidSimple[25][183] = (byte)4;
	geoidSimple[25][184] = (byte)4;
	geoidSimple[25][185] = (byte)4;
	geoidSimple[25][186] = (byte)4;
	geoidSimple[25][187] = (byte)4;
	geoidSimple[25][188] = (byte)4;
	geoidSimple[25][189] = (byte)4;
	geoidSimple[25][190] = (byte)4;
	geoidSimple[25][191] = (byte)4;
	geoidSimple[25][192] = (byte)5;
	geoidSimple[25][193] = (byte)5;
	geoidSimple[25][194] = (byte)6;
	geoidSimple[25][195] = (byte)6;
	geoidSimple[25][196] = (byte)7;
	geoidSimple[25][197] = (byte)7;
	geoidSimple[25][198] = (byte)8;
	geoidSimple[25][199] = (byte)8;
	geoidSimple[25][200] = (byte)9;
	geoidSimple[25][201] = (byte)9;
	geoidSimple[25][202] = (byte)9;
	geoidSimple[25][203] = (byte)9;
	geoidSimple[25][204] = (byte)9;
	geoidSimple[25][205] = (byte)9;
	geoidSimple[25][206] = (byte)10;
	geoidSimple[25][207] = (byte)10;
	geoidSimple[25][208] = (byte)11;
	geoidSimple[25][209] = (byte)11;
	geoidSimple[25][210] = (byte)11;
	geoidSimple[25][211] = (byte)11;
	geoidSimple[25][212] = (byte)12;
	geoidSimple[25][213] = (byte)12;
	geoidSimple[25][214] = (byte)12;
	geoidSimple[25][215] = (byte)12;
	geoidSimple[25][216] = (byte)12;
	geoidSimple[25][217] = (byte)12;
	geoidSimple[25][218] = (byte)11;
	geoidSimple[25][219] = (byte)11;
	geoidSimple[25][220] = (byte)11;
	geoidSimple[25][221] = (byte)10;
	geoidSimple[25][222] = (byte)10;
	geoidSimple[25][223] = (byte)9;
	geoidSimple[25][224] = (byte)8;
	geoidSimple[25][225] = (byte)7;
	geoidSimple[25][226] = (byte)6;
	geoidSimple[25][227] = (byte)6;
	geoidSimple[25][228] = (byte)5;
	geoidSimple[25][229] = (byte)3;
	geoidSimple[25][230] = (byte)2;
	geoidSimple[25][231] = (byte)0;
	geoidSimple[25][232] = (byte)-2;
	geoidSimple[25][233] = (byte)-6;
	geoidSimple[25][234] = (byte)-9;
	geoidSimple[25][235] = (byte)-10;
	geoidSimple[25][236] = (byte)-11;
	geoidSimple[25][237] = (byte)-12;
	geoidSimple[25][238] = (byte)-14;
	geoidSimple[25][239] = (byte)-15;
	geoidSimple[25][240] = (byte)-16;
	geoidSimple[25][241] = (byte)-18;
	geoidSimple[25][242] = (byte)-19;
	geoidSimple[25][243] = (byte)-20;
	geoidSimple[25][244] = (byte)-21;
	geoidSimple[25][245] = (byte)-22;
	geoidSimple[25][246] = (byte)-23;
	geoidSimple[25][247] = (byte)-24;
	geoidSimple[25][248] = (byte)-26;
	geoidSimple[25][249] = (byte)-27;
	geoidSimple[25][250] = (byte)-28;
	geoidSimple[25][251] = (byte)-30;
	geoidSimple[25][252] = (byte)-32;
	geoidSimple[25][253] = (byte)-33;
	geoidSimple[25][254] = (byte)-34;
	geoidSimple[25][255] = (byte)-35;
	geoidSimple[25][256] = (byte)-36;
	geoidSimple[25][257] = (byte)-38;
	geoidSimple[25][258] = (byte)-39;
	geoidSimple[25][259] = (byte)-40;
	geoidSimple[25][260] = (byte)-41;
	geoidSimple[25][261] = (byte)-42;
	geoidSimple[25][262] = (byte)-42;
	geoidSimple[25][263] = (byte)-41;
	geoidSimple[25][264] = (byte)-41;
	geoidSimple[25][265] = (byte)-40;
	geoidSimple[25][266] = (byte)-39;
	geoidSimple[25][267] = (byte)-38;
	geoidSimple[25][268] = (byte)-38;
	geoidSimple[25][269] = (byte)-38;
	geoidSimple[25][270] = (byte)-37;
	geoidSimple[25][271] = (byte)-37;
	geoidSimple[25][272] = (byte)-37;
	geoidSimple[25][273] = (byte)-37;
	geoidSimple[25][274] = (byte)-36;
	geoidSimple[25][275] = (byte)-35;
	geoidSimple[25][276] = (byte)-33;
	geoidSimple[25][277] = (byte)-33;
	geoidSimple[25][278] = (byte)-33;
	geoidSimple[25][279] = (byte)-32;
	geoidSimple[25][280] = (byte)-32;
	geoidSimple[25][281] = (byte)-31;
	geoidSimple[25][282] = (byte)-29;
	geoidSimple[25][283] = (byte)-28;
	geoidSimple[25][284] = (byte)-26;
	geoidSimple[25][285] = (byte)-25;
	geoidSimple[25][286] = (byte)-23;
	geoidSimple[25][287] = (byte)-20;
	geoidSimple[25][288] = (byte)-17;
	geoidSimple[25][289] = (byte)-15;
	geoidSimple[25][290] = (byte)-12;
	geoidSimple[25][291] = (byte)-9;
	geoidSimple[25][292] = (byte)-6;
	geoidSimple[25][293] = (byte)-4;
	geoidSimple[25][294] = (byte)-3;
	geoidSimple[25][295] = (byte)-1;
	geoidSimple[25][296] = (byte)0;
	geoidSimple[25][297] = (byte)3;
	geoidSimple[25][298] = (byte)8;
	geoidSimple[25][299] = (byte)13;
	geoidSimple[25][300] = (byte)16;
	geoidSimple[25][301] = (byte)17;
	geoidSimple[25][302] = (byte)18;
	geoidSimple[25][303] = (byte)20;
	geoidSimple[25][304] = (byte)22;
	geoidSimple[25][305] = (byte)25;
	geoidSimple[25][306] = (byte)27;
	geoidSimple[25][307] = (byte)27;
	geoidSimple[25][308] = (byte)27;
	geoidSimple[25][309] = (byte)29;
	geoidSimple[25][310] = (byte)33;
	geoidSimple[25][311] = (byte)37;
	geoidSimple[25][312] = (byte)41;
	geoidSimple[25][313] = (byte)44;
	geoidSimple[25][314] = (byte)47;
	geoidSimple[25][315] = (byte)49;
	geoidSimple[25][316] = (byte)49;
	geoidSimple[25][317] = (byte)49;
	geoidSimple[25][318] = (byte)46;
	geoidSimple[25][319] = (byte)44;
	geoidSimple[25][320] = (byte)45;
	geoidSimple[25][321] = (byte)47;
	geoidSimple[25][322] = (byte)50;
	geoidSimple[25][323] = (byte)52;
	geoidSimple[25][324] = (byte)54;
	geoidSimple[25][325] = (byte)55;
	geoidSimple[25][326] = (byte)55;
	geoidSimple[25][327] = (byte)55;
	geoidSimple[25][328] = (byte)56;
	geoidSimple[25][329] = (byte)57;
	geoidSimple[25][330] = (byte)59;
	geoidSimple[25][331] = (byte)60;
	geoidSimple[25][332] = (byte)62;
	geoidSimple[25][333] = (byte)63;
	geoidSimple[25][334] = (byte)64;
	geoidSimple[25][335] = (byte)64;
	geoidSimple[25][336] = (byte)65;
	geoidSimple[25][337] = (byte)66;
	geoidSimple[25][338] = (byte)66;
	geoidSimple[25][339] = (byte)66;
	geoidSimple[25][340] = (byte)67;
	geoidSimple[25][341] = (byte)67;
	geoidSimple[25][342] = (byte)66;
	geoidSimple[25][343] = (byte)66;
	geoidSimple[25][344] = (byte)65;
	geoidSimple[25][345] = (byte)64;
	geoidSimple[25][346] = (byte)63;
	geoidSimple[25][347] = (byte)62;
	geoidSimple[25][348] = (byte)62;
	geoidSimple[25][349] = (byte)60;
	geoidSimple[25][350] = (byte)58;
	geoidSimple[25][351] = (byte)57;
	geoidSimple[25][352] = (byte)56;
	geoidSimple[25][353] = (byte)55;
	geoidSimple[25][354] = (byte)53;
	geoidSimple[25][355] = (byte)52;
	geoidSimple[25][356] = (byte)52;
	geoidSimple[25][357] = (byte)51;
	geoidSimple[25][358] = (byte)51;
	geoidSimple[25][359] = (byte)51;
	}
		/** Row 26*/
	private static void init26() {
	geoidSimple[26][0] = (byte)48;
	geoidSimple[26][1] = (byte)47;
	geoidSimple[26][2] = (byte)46;
	geoidSimple[26][3] = (byte)44;
	geoidSimple[26][4] = (byte)43;
	geoidSimple[26][5] = (byte)43;
	geoidSimple[26][6] = (byte)44;
	geoidSimple[26][7] = (byte)43;
	geoidSimple[26][8] = (byte)42;
	geoidSimple[26][9] = (byte)41;
	geoidSimple[26][10] = (byte)40;
	geoidSimple[26][11] = (byte)37;
	geoidSimple[26][12] = (byte)35;
	geoidSimple[26][13] = (byte)33;
	geoidSimple[26][14] = (byte)31;
	geoidSimple[26][15] = (byte)31;
	geoidSimple[26][16] = (byte)30;
	geoidSimple[26][17] = (byte)28;
	geoidSimple[26][18] = (byte)26;
	geoidSimple[26][19] = (byte)23;
	geoidSimple[26][20] = (byte)21;
	geoidSimple[26][21] = (byte)19;
	geoidSimple[26][22] = (byte)18;
	geoidSimple[26][23] = (byte)17;
	geoidSimple[26][24] = (byte)17;
	geoidSimple[26][25] = (byte)17;
	geoidSimple[26][26] = (byte)17;
	geoidSimple[26][27] = (byte)17;
	geoidSimple[26][28] = (byte)17;
	geoidSimple[26][29] = (byte)17;
	geoidSimple[26][30] = (byte)17;
	geoidSimple[26][31] = (byte)16;
	geoidSimple[26][32] = (byte)15;
	geoidSimple[26][33] = (byte)15;
	geoidSimple[26][34] = (byte)14;
	geoidSimple[26][35] = (byte)14;
	geoidSimple[26][36] = (byte)14;
	geoidSimple[26][37] = (byte)14;
	geoidSimple[26][38] = (byte)13;
	geoidSimple[26][39] = (byte)13;
	geoidSimple[26][40] = (byte)12;
	geoidSimple[26][41] = (byte)12;
	geoidSimple[26][42] = (byte)11;
	geoidSimple[26][43] = (byte)10;
	geoidSimple[26][44] = (byte)9;
	geoidSimple[26][45] = (byte)9;
	geoidSimple[26][46] = (byte)9;
	geoidSimple[26][47] = (byte)9;
	geoidSimple[26][48] = (byte)7;
	geoidSimple[26][49] = (byte)6;
	geoidSimple[26][50] = (byte)5;
	geoidSimple[26][51] = (byte)3;
	geoidSimple[26][52] = (byte)2;
	geoidSimple[26][53] = (byte)1;
	geoidSimple[26][54] = (byte)0;
	geoidSimple[26][55] = (byte)0;
	geoidSimple[26][56] = (byte)0;
	geoidSimple[26][57] = (byte)-2;
	geoidSimple[26][58] = (byte)-2;
	geoidSimple[26][59] = (byte)-1;
	geoidSimple[26][60] = (byte)-3;
	geoidSimple[26][61] = (byte)-5;
	geoidSimple[26][62] = (byte)-7;
	geoidSimple[26][63] = (byte)-9;
	geoidSimple[26][64] = (byte)-10;
	geoidSimple[26][65] = (byte)-11;
	geoidSimple[26][66] = (byte)-12;
	geoidSimple[26][67] = (byte)-12;
	geoidSimple[26][68] = (byte)-13;
	geoidSimple[26][69] = (byte)-15;
	geoidSimple[26][70] = (byte)-16;
	geoidSimple[26][71] = (byte)-17;
	geoidSimple[26][72] = (byte)-18;
	geoidSimple[26][73] = (byte)-19;
	geoidSimple[26][74] = (byte)-20;
	geoidSimple[26][75] = (byte)-20;
	geoidSimple[26][76] = (byte)-21;
	geoidSimple[26][77] = (byte)-21;
	geoidSimple[26][78] = (byte)-21;
	geoidSimple[26][79] = (byte)-21;
	geoidSimple[26][80] = (byte)-21;
	geoidSimple[26][81] = (byte)-22;
	geoidSimple[26][82] = (byte)-23;
	geoidSimple[26][83] = (byte)-23;
	geoidSimple[26][84] = (byte)-23;
	geoidSimple[26][85] = (byte)-24;
	geoidSimple[26][86] = (byte)-24;
	geoidSimple[26][87] = (byte)-25;
	geoidSimple[26][88] = (byte)-25;
	geoidSimple[26][89] = (byte)-25;
	geoidSimple[26][90] = (byte)-25;
	geoidSimple[26][91] = (byte)-25;
	geoidSimple[26][92] = (byte)-25;
	geoidSimple[26][93] = (byte)-26;
	geoidSimple[26][94] = (byte)-27;
	geoidSimple[26][95] = (byte)-28;
	geoidSimple[26][96] = (byte)-28;
	geoidSimple[26][97] = (byte)-28;
	geoidSimple[26][98] = (byte)-28;
	geoidSimple[26][99] = (byte)-29;
	geoidSimple[26][100] = (byte)-29;
	geoidSimple[26][101] = (byte)-29;
	geoidSimple[26][102] = (byte)-29;
	geoidSimple[26][103] = (byte)-28;
	geoidSimple[26][104] = (byte)-28;
	geoidSimple[26][105] = (byte)-27;
	geoidSimple[26][106] = (byte)-27;
	geoidSimple[26][107] = (byte)-26;
	geoidSimple[26][108] = (byte)-25;
	geoidSimple[26][109] = (byte)-24;
	geoidSimple[26][110] = (byte)-23;
	geoidSimple[26][111] = (byte)-22;
	geoidSimple[26][112] = (byte)-21;
	geoidSimple[26][113] = (byte)-20;
	geoidSimple[26][114] = (byte)-20;
	geoidSimple[26][115] = (byte)-21;
	geoidSimple[26][116] = (byte)-21;
	geoidSimple[26][117] = (byte)-20;
	geoidSimple[26][118] = (byte)-19;
	geoidSimple[26][119] = (byte)-18;
	geoidSimple[26][120] = (byte)-17;
	geoidSimple[26][121] = (byte)-16;
	geoidSimple[26][122] = (byte)-16;
	geoidSimple[26][123] = (byte)-15;
	geoidSimple[26][124] = (byte)-14;
	geoidSimple[26][125] = (byte)-13;
	geoidSimple[26][126] = (byte)-13;
	geoidSimple[26][127] = (byte)-11;
	geoidSimple[26][128] = (byte)-11;
	geoidSimple[26][129] = (byte)-10;
	geoidSimple[26][130] = (byte)-10;
	geoidSimple[26][131] = (byte)-9;
	geoidSimple[26][132] = (byte)-6;
	geoidSimple[26][133] = (byte)-4;
	geoidSimple[26][134] = (byte)-2;
	geoidSimple[26][135] = (byte)0;
	geoidSimple[26][136] = (byte)1;
	geoidSimple[26][137] = (byte)3;
	geoidSimple[26][138] = (byte)5;
	geoidSimple[26][139] = (byte)6;
	geoidSimple[26][140] = (byte)7;
	geoidSimple[26][141] = (byte)7;
	geoidSimple[26][142] = (byte)7;
	geoidSimple[26][143] = (byte)8;
	geoidSimple[26][144] = (byte)9;
	geoidSimple[26][145] = (byte)9;
	geoidSimple[26][146] = (byte)10;
	geoidSimple[26][147] = (byte)10;
	geoidSimple[26][148] = (byte)11;
	geoidSimple[26][149] = (byte)11;
	geoidSimple[26][150] = (byte)11;
	geoidSimple[26][151] = (byte)10;
	geoidSimple[26][152] = (byte)10;
	geoidSimple[26][153] = (byte)10;
	geoidSimple[26][154] = (byte)11;
	geoidSimple[26][155] = (byte)11;
	geoidSimple[26][156] = (byte)11;
	geoidSimple[26][157] = (byte)12;
	geoidSimple[26][158] = (byte)12;
	geoidSimple[26][159] = (byte)12;
	geoidSimple[26][160] = (byte)12;
	geoidSimple[26][161] = (byte)12;
	geoidSimple[26][162] = (byte)11;
	geoidSimple[26][163] = (byte)11;
	geoidSimple[26][164] = (byte)11;
	geoidSimple[26][165] = (byte)11;
	geoidSimple[26][166] = (byte)11;
	geoidSimple[26][167] = (byte)10;
	geoidSimple[26][168] = (byte)9;
	geoidSimple[26][169] = (byte)9;
	geoidSimple[26][170] = (byte)8;
	geoidSimple[26][171] = (byte)8;
	geoidSimple[26][172] = (byte)8;
	geoidSimple[26][173] = (byte)7;
	geoidSimple[26][174] = (byte)6;
	geoidSimple[26][175] = (byte)6;
	geoidSimple[26][176] = (byte)5;
	geoidSimple[26][177] = (byte)4;
	geoidSimple[26][178] = (byte)4;
	geoidSimple[26][179] = (byte)3;
	geoidSimple[26][LAT_GRID_SIZE] = (byte)3;
	geoidSimple[26][181] = (byte)4;
	geoidSimple[26][182] = (byte)4;
	geoidSimple[26][183] = (byte)4;
	geoidSimple[26][184] = (byte)4;
	geoidSimple[26][185] = (byte)4;
	geoidSimple[26][186] = (byte)5;
	geoidSimple[26][187] = (byte)5;
	geoidSimple[26][188] = (byte)5;
	geoidSimple[26][189] = (byte)5;
	geoidSimple[26][190] = (byte)5;
	geoidSimple[26][191] = (byte)5;
	geoidSimple[26][192] = (byte)5;
	geoidSimple[26][193] = (byte)5;
	geoidSimple[26][194] = (byte)6;
	geoidSimple[26][195] = (byte)6;
	geoidSimple[26][196] = (byte)7;
	geoidSimple[26][197] = (byte)8;
	geoidSimple[26][198] = (byte)9;
	geoidSimple[26][199] = (byte)10;
	geoidSimple[26][200] = (byte)10;
	geoidSimple[26][201] = (byte)9;
	geoidSimple[26][202] = (byte)10;
	geoidSimple[26][203] = (byte)10;
	geoidSimple[26][204] = (byte)10;
	geoidSimple[26][205] = (byte)11;
	geoidSimple[26][206] = (byte)12;
	geoidSimple[26][207] = (byte)12;
	geoidSimple[26][208] = (byte)13;
	geoidSimple[26][209] = (byte)14;
	geoidSimple[26][210] = (byte)15;
	geoidSimple[26][211] = (byte)15;
	geoidSimple[26][212] = (byte)16;
	geoidSimple[26][213] = (byte)15;
	geoidSimple[26][214] = (byte)15;
	geoidSimple[26][215] = (byte)14;
	geoidSimple[26][216] = (byte)13;
	geoidSimple[26][217] = (byte)12;
	geoidSimple[26][218] = (byte)12;
	geoidSimple[26][219] = (byte)11;
	geoidSimple[26][220] = (byte)10;
	geoidSimple[26][221] = (byte)9;
	geoidSimple[26][222] = (byte)8;
	geoidSimple[26][223] = (byte)8;
	geoidSimple[26][224] = (byte)7;
	geoidSimple[26][225] = (byte)6;
	geoidSimple[26][226] = (byte)4;
	geoidSimple[26][227] = (byte)4;
	geoidSimple[26][228] = (byte)3;
	geoidSimple[26][229] = (byte)3;
	geoidSimple[26][230] = (byte)2;
	geoidSimple[26][231] = (byte)0;
	geoidSimple[26][232] = (byte)0;
	geoidSimple[26][233] = (byte)-3;
	geoidSimple[26][234] = (byte)-5;
	geoidSimple[26][235] = (byte)-7;
	geoidSimple[26][236] = (byte)-9;
	geoidSimple[26][237] = (byte)-11;
	geoidSimple[26][238] = (byte)-12;
	geoidSimple[26][239] = (byte)-14;
	geoidSimple[26][240] = (byte)-16;
	geoidSimple[26][241] = (byte)-18;
	geoidSimple[26][242] = (byte)-19;
	geoidSimple[26][243] = (byte)-21;
	geoidSimple[26][244] = (byte)-23;
	geoidSimple[26][245] = (byte)-24;
	geoidSimple[26][246] = (byte)-25;
	geoidSimple[26][247] = (byte)-26;
	geoidSimple[26][248] = (byte)-28;
	geoidSimple[26][249] = (byte)-28;
	geoidSimple[26][250] = (byte)-29;
	geoidSimple[26][251] = (byte)-31;
	geoidSimple[26][252] = (byte)-32;
	geoidSimple[26][253] = (byte)-33;
	geoidSimple[26][254] = (byte)-34;
	geoidSimple[26][255] = (byte)-36;
	geoidSimple[26][256] = (byte)-38;
	geoidSimple[26][257] = (byte)-39;
	geoidSimple[26][258] = (byte)-41;
	geoidSimple[26][259] = (byte)-42;
	geoidSimple[26][260] = (byte)-43;
	geoidSimple[26][261] = (byte)-44;
	geoidSimple[26][262] = (byte)-44;
	geoidSimple[26][263] = (byte)-44;
	geoidSimple[26][264] = (byte)-43;
	geoidSimple[26][265] = (byte)-43;
	geoidSimple[26][266] = (byte)-42;
	geoidSimple[26][267] = (byte)-42;
	geoidSimple[26][268] = (byte)-41;
	geoidSimple[26][269] = (byte)-41;
	geoidSimple[26][270] = (byte)-41;
	geoidSimple[26][271] = (byte)-41;
	geoidSimple[26][272] = (byte)-40;
	geoidSimple[26][273] = (byte)-39;
	geoidSimple[26][274] = (byte)-39;
	geoidSimple[26][275] = (byte)-38;
	geoidSimple[26][276] = (byte)-38;
	geoidSimple[26][277] = (byte)-37;
	geoidSimple[26][278] = (byte)-36;
	geoidSimple[26][279] = (byte)-35;
	geoidSimple[26][280] = (byte)-34;
	geoidSimple[26][281] = (byte)-32;
	geoidSimple[26][282] = (byte)-31;
	geoidSimple[26][283] = (byte)-30;
	geoidSimple[26][284] = (byte)-29;
	geoidSimple[26][285] = (byte)-28;
	geoidSimple[26][286] = (byte)-26;
	geoidSimple[26][287] = (byte)-23;
	geoidSimple[26][288] = (byte)-19;
	geoidSimple[26][289] = (byte)-15;
	geoidSimple[26][290] = (byte)-12;
	geoidSimple[26][291] = (byte)-11;
	geoidSimple[26][292] = (byte)-8;
	geoidSimple[26][293] = (byte)-4;
	geoidSimple[26][294] = (byte)-2;
	geoidSimple[26][295] = (byte)-1;
	geoidSimple[26][296] = (byte)0;
	geoidSimple[26][297] = (byte)2;
	geoidSimple[26][298] = (byte)8;
	geoidSimple[26][299] = (byte)11;
	geoidSimple[26][300] = (byte)13;
	geoidSimple[26][301] = (byte)14;
	geoidSimple[26][302] = (byte)16;
	geoidSimple[26][303] = (byte)18;
	geoidSimple[26][304] = (byte)20;
	geoidSimple[26][305] = (byte)22;
	geoidSimple[26][306] = (byte)25;
	geoidSimple[26][307] = (byte)27;
	geoidSimple[26][308] = (byte)28;
	geoidSimple[26][309] = (byte)30;
	geoidSimple[26][310] = (byte)34;
	geoidSimple[26][311] = (byte)37;
	geoidSimple[26][312] = (byte)41;
	geoidSimple[26][313] = (byte)44;
	geoidSimple[26][314] = (byte)47;
	geoidSimple[26][315] = (byte)49;
	geoidSimple[26][316] = (byte)50;
	geoidSimple[26][317] = (byte)49;
	geoidSimple[26][318] = (byte)46;
	geoidSimple[26][319] = (byte)46;
	geoidSimple[26][320] = (byte)49;
	geoidSimple[26][321] = (byte)51;
	geoidSimple[26][322] = (byte)52;
	geoidSimple[26][323] = (byte)52;
	geoidSimple[26][324] = (byte)52;
	geoidSimple[26][325] = (byte)53;
	geoidSimple[26][326] = (byte)54;
	geoidSimple[26][327] = (byte)55;
	geoidSimple[26][328] = (byte)57;
	geoidSimple[26][329] = (byte)58;
	geoidSimple[26][330] = (byte)60;
	geoidSimple[26][331] = (byte)61;
	geoidSimple[26][332] = (byte)62;
	geoidSimple[26][333] = (byte)63;
	geoidSimple[26][334] = (byte)64;
	geoidSimple[26][335] = (byte)65;
	geoidSimple[26][336] = (byte)65;
	geoidSimple[26][337] = (byte)65;
	geoidSimple[26][338] = (byte)65;
	geoidSimple[26][339] = (byte)65;
	geoidSimple[26][340] = (byte)65;
	geoidSimple[26][341] = (byte)65;
	geoidSimple[26][342] = (byte)64;
	geoidSimple[26][343] = (byte)63;
	geoidSimple[26][344] = (byte)63;
	geoidSimple[26][345] = (byte)62;
	geoidSimple[26][346] = (byte)62;
	geoidSimple[26][347] = (byte)62;
	geoidSimple[26][348] = (byte)61;
	geoidSimple[26][349] = (byte)60;
	geoidSimple[26][350] = (byte)59;
	geoidSimple[26][351] = (byte)58;
	geoidSimple[26][352] = (byte)57;
	geoidSimple[26][353] = (byte)54;
	geoidSimple[26][354] = (byte)53;
	geoidSimple[26][355] = (byte)52;
	geoidSimple[26][356] = (byte)51;
	geoidSimple[26][357] = (byte)51;
	geoidSimple[26][358] = (byte)50;
	geoidSimple[26][359] = (byte)49;
	}
		/** Row 27*/
	private static void init27() {
	geoidSimple[27][0] = (byte)49;
	geoidSimple[27][1] = (byte)48;
	geoidSimple[27][2] = (byte)47;
	geoidSimple[27][3] = (byte)46;
	geoidSimple[27][4] = (byte)45;
	geoidSimple[27][5] = (byte)45;
	geoidSimple[27][6] = (byte)44;
	geoidSimple[27][7] = (byte)44;
	geoidSimple[27][8] = (byte)44;
	geoidSimple[27][9] = (byte)43;
	geoidSimple[27][10] = (byte)41;
	geoidSimple[27][11] = (byte)38;
	geoidSimple[27][12] = (byte)36;
	geoidSimple[27][13] = (byte)34;
	geoidSimple[27][14] = (byte)33;
	geoidSimple[27][15] = (byte)31;
	geoidSimple[27][16] = (byte)29;
	geoidSimple[27][17] = (byte)26;
	geoidSimple[27][18] = (byte)23;
	geoidSimple[27][19] = (byte)21;
	geoidSimple[27][20] = (byte)19;
	geoidSimple[27][21] = (byte)18;
	geoidSimple[27][22] = (byte)18;
	geoidSimple[27][23] = (byte)18;
	geoidSimple[27][24] = (byte)18;
	geoidSimple[27][25] = (byte)18;
	geoidSimple[27][26] = (byte)18;
	geoidSimple[27][27] = (byte)18;
	geoidSimple[27][28] = (byte)18;
	geoidSimple[27][29] = (byte)17;
	geoidSimple[27][30] = (byte)17;
	geoidSimple[27][31] = (byte)16;
	geoidSimple[27][32] = (byte)15;
	geoidSimple[27][33] = (byte)14;
	geoidSimple[27][34] = (byte)14;
	geoidSimple[27][35] = (byte)13;
	geoidSimple[27][36] = (byte)14;
	geoidSimple[27][37] = (byte)13;
	geoidSimple[27][38] = (byte)12;
	geoidSimple[27][39] = (byte)11;
	geoidSimple[27][40] = (byte)11;
	geoidSimple[27][41] = (byte)11;
	geoidSimple[27][42] = (byte)11;
	geoidSimple[27][43] = (byte)10;
	geoidSimple[27][44] = (byte)9;
	geoidSimple[27][45] = (byte)8;
	geoidSimple[27][46] = (byte)8;
	geoidSimple[27][47] = (byte)8;
	geoidSimple[27][48] = (byte)8;
	geoidSimple[27][49] = (byte)7;
	geoidSimple[27][50] = (byte)5;
	geoidSimple[27][51] = (byte)3;
	geoidSimple[27][52] = (byte)1;
	geoidSimple[27][53] = (byte)0;
	geoidSimple[27][54] = (byte)0;
	geoidSimple[27][55] = (byte)0;
	geoidSimple[27][56] = (byte)0;
	geoidSimple[27][57] = (byte)-2;
	geoidSimple[27][58] = (byte)-2;
	geoidSimple[27][59] = (byte)-2;
	geoidSimple[27][60] = (byte)-4;
	geoidSimple[27][61] = (byte)-6;
	geoidSimple[27][62] = (byte)-9;
	geoidSimple[27][63] = (byte)-10;
	geoidSimple[27][64] = (byte)-10;
	geoidSimple[27][65] = (byte)-11;
	geoidSimple[27][66] = (byte)-12;
	geoidSimple[27][67] = (byte)-14;
	geoidSimple[27][68] = (byte)-15;
	geoidSimple[27][69] = (byte)-17;
	geoidSimple[27][70] = (byte)-18;
	geoidSimple[27][71] = (byte)-19;
	geoidSimple[27][72] = (byte)-20;
	geoidSimple[27][73] = (byte)-21;
	geoidSimple[27][74] = (byte)-21;
	geoidSimple[27][75] = (byte)-22;
	geoidSimple[27][76] = (byte)-22;
	geoidSimple[27][77] = (byte)-23;
	geoidSimple[27][78] = (byte)-23;
	geoidSimple[27][79] = (byte)-24;
	geoidSimple[27][80] = (byte)-24;
	geoidSimple[27][81] = (byte)-25;
	geoidSimple[27][82] = (byte)-25;
	geoidSimple[27][83] = (byte)-25;
	geoidSimple[27][84] = (byte)-25;
	geoidSimple[27][85] = (byte)-25;
	geoidSimple[27][86] = (byte)-26;
	geoidSimple[27][87] = (byte)-25;
	geoidSimple[27][88] = (byte)-26;
	geoidSimple[27][89] = (byte)-26;
	geoidSimple[27][90] = (byte)-26;
	geoidSimple[27][91] = (byte)-27;
	geoidSimple[27][92] = (byte)-27;
	geoidSimple[27][93] = (byte)-28;
	geoidSimple[27][94] = (byte)-28;
	geoidSimple[27][95] = (byte)-29;
	geoidSimple[27][96] = (byte)-29;
	geoidSimple[27][97] = (byte)-29;
	geoidSimple[27][98] = (byte)-30;
	geoidSimple[27][99] = (byte)-30;
	geoidSimple[27][100] = (byte)-30;
	geoidSimple[27][101] = (byte)-30;
	geoidSimple[27][102] = (byte)-29;
	geoidSimple[27][103] = (byte)-29;
	geoidSimple[27][104] = (byte)-29;
	geoidSimple[27][105] = (byte)-29;
	geoidSimple[27][106] = (byte)-29;
	geoidSimple[27][107] = (byte)-28;
	geoidSimple[27][108] = (byte)-27;
	geoidSimple[27][109] = (byte)-26;
	geoidSimple[27][110] = (byte)-25;
	geoidSimple[27][111] = (byte)-24;
	geoidSimple[27][112] = (byte)-23;
	geoidSimple[27][113] = (byte)-23;
	geoidSimple[27][114] = (byte)-22;
	geoidSimple[27][115] = (byte)-22;
	geoidSimple[27][116] = (byte)-22;
	geoidSimple[27][117] = (byte)-20;
	geoidSimple[27][118] = (byte)-18;
	geoidSimple[27][119] = (byte)-19;
	geoidSimple[27][120] = (byte)-19;
	geoidSimple[27][121] = (byte)-16;
	geoidSimple[27][122] = (byte)-14;
	geoidSimple[27][123] = (byte)-13;
	geoidSimple[27][124] = (byte)-12;
	geoidSimple[27][125] = (byte)-12;
	geoidSimple[27][126] = (byte)-11;
	geoidSimple[27][127] = (byte)-10;
	geoidSimple[27][128] = (byte)-9;
	geoidSimple[27][129] = (byte)-8;
	geoidSimple[27][130] = (byte)-6;
	geoidSimple[27][131] = (byte)-5;
	geoidSimple[27][132] = (byte)-4;
	geoidSimple[27][133] = (byte)-3;
	geoidSimple[27][134] = (byte)-2;
	geoidSimple[27][135] = (byte)-1;
	geoidSimple[27][136] = (byte)0;
	geoidSimple[27][137] = (byte)3;
	geoidSimple[27][138] = (byte)5;
	geoidSimple[27][139] = (byte)7;
	geoidSimple[27][140] = (byte)9;
	geoidSimple[27][141] = (byte)9;
	geoidSimple[27][142] = (byte)10;
	geoidSimple[27][143] = (byte)10;
	geoidSimple[27][144] = (byte)10;
	geoidSimple[27][145] = (byte)11;
	geoidSimple[27][146] = (byte)11;
	geoidSimple[27][147] = (byte)11;
	geoidSimple[27][148] = (byte)12;
	geoidSimple[27][149] = (byte)12;
	geoidSimple[27][150] = (byte)12;
	geoidSimple[27][151] = (byte)12;
	geoidSimple[27][152] = (byte)12;
	geoidSimple[27][153] = (byte)12;
	geoidSimple[27][154] = (byte)13;
	geoidSimple[27][155] = (byte)13;
	geoidSimple[27][156] = (byte)13;
	geoidSimple[27][157] = (byte)13;
	geoidSimple[27][158] = (byte)13;
	geoidSimple[27][159] = (byte)12;
	geoidSimple[27][160] = (byte)12;
	geoidSimple[27][161] = (byte)12;
	geoidSimple[27][162] = (byte)11;
	geoidSimple[27][163] = (byte)11;
	geoidSimple[27][164] = (byte)11;
	geoidSimple[27][165] = (byte)11;
	geoidSimple[27][166] = (byte)10;
	geoidSimple[27][167] = (byte)10;
	geoidSimple[27][168] = (byte)10;
	geoidSimple[27][169] = (byte)10;
	geoidSimple[27][170] = (byte)10;
	geoidSimple[27][171] = (byte)9;
	geoidSimple[27][172] = (byte)8;
	geoidSimple[27][173] = (byte)7;
	geoidSimple[27][174] = (byte)6;
	geoidSimple[27][175] = (byte)5;
	geoidSimple[27][176] = (byte)4;
	geoidSimple[27][177] = (byte)4;
	geoidSimple[27][178] = (byte)5;
	geoidSimple[27][179] = (byte)4;
	geoidSimple[27][LAT_GRID_SIZE] = (byte)4;
	geoidSimple[27][181] = (byte)4;
	geoidSimple[27][182] = (byte)4;
	geoidSimple[27][183] = (byte)4;
	geoidSimple[27][184] = (byte)5;
	geoidSimple[27][185] = (byte)5;
	geoidSimple[27][186] = (byte)5;
	geoidSimple[27][187] = (byte)5;
	geoidSimple[27][188] = (byte)6;
	geoidSimple[27][189] = (byte)6;
	geoidSimple[27][190] = (byte)6;
	geoidSimple[27][191] = (byte)6;
	geoidSimple[27][192] = (byte)7;
	geoidSimple[27][193] = (byte)7;
	geoidSimple[27][194] = (byte)8;
	geoidSimple[27][195] = (byte)8;
	geoidSimple[27][196] = (byte)9;
	geoidSimple[27][197] = (byte)10;
	geoidSimple[27][198] = (byte)11;
	geoidSimple[27][199] = (byte)11;
	geoidSimple[27][200] = (byte)11;
	geoidSimple[27][201] = (byte)11;
	geoidSimple[27][202] = (byte)11;
	geoidSimple[27][203] = (byte)11;
	geoidSimple[27][204] = (byte)11;
	geoidSimple[27][205] = (byte)12;
	geoidSimple[27][206] = (byte)14;
	geoidSimple[27][207] = (byte)14;
	geoidSimple[27][208] = (byte)14;
	geoidSimple[27][209] = (byte)13;
	geoidSimple[27][210] = (byte)14;
	geoidSimple[27][211] = (byte)16;
	geoidSimple[27][212] = (byte)17;
	geoidSimple[27][213] = (byte)16;
	geoidSimple[27][214] = (byte)16;
	geoidSimple[27][215] = (byte)16;
	geoidSimple[27][216] = (byte)16;
	geoidSimple[27][217] = (byte)15;
	geoidSimple[27][218] = (byte)13;
	geoidSimple[27][219] = (byte)12;
	geoidSimple[27][220] = (byte)11;
	geoidSimple[27][221] = (byte)10;
	geoidSimple[27][222] = (byte)9;
	geoidSimple[27][223] = (byte)8;
	geoidSimple[27][224] = (byte)7;
	geoidSimple[27][225] = (byte)6;
	geoidSimple[27][226] = (byte)5;
	geoidSimple[27][227] = (byte)4;
	geoidSimple[27][228] = (byte)2;
	geoidSimple[27][229] = (byte)1;
	geoidSimple[27][230] = (byte)1;
	geoidSimple[27][231] = (byte)0;
	geoidSimple[27][232] = (byte)0;
	geoidSimple[27][233] = (byte)0;
	geoidSimple[27][234] = (byte)-3;
	geoidSimple[27][235] = (byte)-5;
	geoidSimple[27][236] = (byte)-8;
	geoidSimple[27][237] = (byte)-11;
	geoidSimple[27][238] = (byte)-13;
	geoidSimple[27][239] = (byte)-14;
	geoidSimple[27][240] = (byte)-16;
	geoidSimple[27][241] = (byte)-18;
	geoidSimple[27][242] = (byte)-20;
	geoidSimple[27][243] = (byte)-22;
	geoidSimple[27][244] = (byte)-24;
	geoidSimple[27][245] = (byte)-26;
	geoidSimple[27][246] = (byte)-27;
	geoidSimple[27][247] = (byte)-28;
	geoidSimple[27][248] = (byte)-29;
	geoidSimple[27][249] = (byte)-29;
	geoidSimple[27][250] = (byte)-30;
	geoidSimple[27][251] = (byte)-31;
	geoidSimple[27][252] = (byte)-33;
	geoidSimple[27][253] = (byte)-34;
	geoidSimple[27][254] = (byte)-35;
	geoidSimple[27][255] = (byte)-37;
	geoidSimple[27][256] = (byte)-38;
	geoidSimple[27][257] = (byte)-40;
	geoidSimple[27][258] = (byte)-41;
	geoidSimple[27][259] = (byte)-42;
	geoidSimple[27][260] = (byte)-43;
	geoidSimple[27][261] = (byte)-44;
	geoidSimple[27][262] = (byte)-45;
	geoidSimple[27][263] = (byte)-45;
	geoidSimple[27][264] = (byte)-46;
	geoidSimple[27][265] = (byte)-46;
	geoidSimple[27][266] = (byte)-46;
	geoidSimple[27][267] = (byte)-46;
	geoidSimple[27][268] = (byte)-46;
	geoidSimple[27][269] = (byte)-45;
	geoidSimple[27][270] = (byte)-45;
	geoidSimple[27][271] = (byte)-44;
	geoidSimple[27][272] = (byte)-43;
	geoidSimple[27][273] = (byte)-42;
	geoidSimple[27][274] = (byte)-42;
	geoidSimple[27][275] = (byte)-41;
	geoidSimple[27][276] = (byte)-40;
	geoidSimple[27][277] = (byte)-38;
	geoidSimple[27][278] = (byte)-37;
	geoidSimple[27][279] = (byte)-36;
	geoidSimple[27][280] = (byte)-35;
	geoidSimple[27][281] = (byte)-34;
	geoidSimple[27][282] = (byte)-32;
	geoidSimple[27][283] = (byte)-31;
	geoidSimple[27][284] = (byte)-29;
	geoidSimple[27][285] = (byte)-28;
	geoidSimple[27][286] = (byte)-26;
	geoidSimple[27][287] = (byte)-25;
	geoidSimple[27][288] = (byte)-23;
	geoidSimple[27][289] = (byte)-20;
	geoidSimple[27][290] = (byte)-17;
	geoidSimple[27][291] = (byte)-14;
	geoidSimple[27][292] = (byte)-11;
	geoidSimple[27][293] = (byte)-9;
	geoidSimple[27][294] = (byte)-6;
	geoidSimple[27][295] = (byte)-3;
	geoidSimple[27][296] = (byte)0;
	geoidSimple[27][297] = (byte)4;
	geoidSimple[27][298] = (byte)8;
	geoidSimple[27][299] = (byte)9;
	geoidSimple[27][300] = (byte)10;
	geoidSimple[27][301] = (byte)12;
	geoidSimple[27][302] = (byte)14;
	geoidSimple[27][303] = (byte)16;
	geoidSimple[27][304] = (byte)18;
	geoidSimple[27][305] = (byte)20;
	geoidSimple[27][306] = (byte)22;
	geoidSimple[27][307] = (byte)24;
	geoidSimple[27][308] = (byte)28;
	geoidSimple[27][309] = (byte)30;
	geoidSimple[27][310] = (byte)33;
	geoidSimple[27][311] = (byte)37;
	geoidSimple[27][312] = (byte)41;
	geoidSimple[27][313] = (byte)44;
	geoidSimple[27][314] = (byte)47;
	geoidSimple[27][315] = (byte)49;
	geoidSimple[27][316] = (byte)48;
	geoidSimple[27][317] = (byte)46;
	geoidSimple[27][318] = (byte)46;
	geoidSimple[27][319] = (byte)49;
	geoidSimple[27][320] = (byte)49;
	geoidSimple[27][321] = (byte)50;
	geoidSimple[27][322] = (byte)51;
	geoidSimple[27][323] = (byte)51;
	geoidSimple[27][324] = (byte)52;
	geoidSimple[27][325] = (byte)54;
	geoidSimple[27][326] = (byte)55;
	geoidSimple[27][327] = (byte)56;
	geoidSimple[27][328] = (byte)58;
	geoidSimple[27][329] = (byte)60;
	geoidSimple[27][330] = (byte)61;
	geoidSimple[27][331] = (byte)62;
	geoidSimple[27][332] = (byte)63;
	geoidSimple[27][333] = (byte)64;
	geoidSimple[27][334] = (byte)65;
	geoidSimple[27][335] = (byte)65;
	geoidSimple[27][336] = (byte)65;
	geoidSimple[27][337] = (byte)64;
	geoidSimple[27][338] = (byte)64;
	geoidSimple[27][339] = (byte)63;
	geoidSimple[27][340] = (byte)62;
	geoidSimple[27][341] = (byte)62;
	geoidSimple[27][342] = (byte)62;
	geoidSimple[27][343] = (byte)61;
	geoidSimple[27][344] = (byte)60;
	geoidSimple[27][345] = (byte)60;
	geoidSimple[27][346] = (byte)60;
	geoidSimple[27][347] = (byte)61;
	geoidSimple[27][348] = (byte)60;
	geoidSimple[27][349] = (byte)60;
	geoidSimple[27][350] = (byte)59;
	geoidSimple[27][351] = (byte)59;
	geoidSimple[27][352] = (byte)58;
	geoidSimple[27][353] = (byte)57;
	geoidSimple[27][354] = (byte)55;
	geoidSimple[27][355] = (byte)53;
	geoidSimple[27][356] = (byte)52;
	geoidSimple[27][357] = (byte)50;
	geoidSimple[27][358] = (byte)49;
	geoidSimple[27][359] = (byte)49;
	}
		/** Row 28*/
	private static void init28() {
	geoidSimple[28][0] = (byte)49;
	geoidSimple[28][1] = (byte)47;
	geoidSimple[28][2] = (byte)47;
	geoidSimple[28][3] = (byte)46;
	geoidSimple[28][4] = (byte)45;
	geoidSimple[28][5] = (byte)45;
	geoidSimple[28][6] = (byte)45;
	geoidSimple[28][7] = (byte)45;
	geoidSimple[28][8] = (byte)45;
	geoidSimple[28][9] = (byte)43;
	geoidSimple[28][10] = (byte)40;
	geoidSimple[28][11] = (byte)37;
	geoidSimple[28][12] = (byte)35;
	geoidSimple[28][13] = (byte)34;
	geoidSimple[28][14] = (byte)32;
	geoidSimple[28][15] = (byte)31;
	geoidSimple[28][16] = (byte)28;
	geoidSimple[28][17] = (byte)25;
	geoidSimple[28][18] = (byte)22;
	geoidSimple[28][19] = (byte)21;
	geoidSimple[28][20] = (byte)20;
	geoidSimple[28][21] = (byte)18;
	geoidSimple[28][22] = (byte)18;
	geoidSimple[28][23] = (byte)18;
	geoidSimple[28][24] = (byte)18;
	geoidSimple[28][25] = (byte)18;
	geoidSimple[28][26] = (byte)17;
	geoidSimple[28][27] = (byte)17;
	geoidSimple[28][28] = (byte)17;
	geoidSimple[28][29] = (byte)17;
	geoidSimple[28][30] = (byte)17;
	geoidSimple[28][31] = (byte)16;
	geoidSimple[28][32] = (byte)16;
	geoidSimple[28][33] = (byte)15;
	geoidSimple[28][34] = (byte)14;
	geoidSimple[28][35] = (byte)13;
	geoidSimple[28][36] = (byte)13;
	geoidSimple[28][37] = (byte)12;
	geoidSimple[28][38] = (byte)12;
	geoidSimple[28][39] = (byte)12;
	geoidSimple[28][40] = (byte)11;
	geoidSimple[28][41] = (byte)11;
	geoidSimple[28][42] = (byte)11;
	geoidSimple[28][43] = (byte)10;
	geoidSimple[28][44] = (byte)9;
	geoidSimple[28][45] = (byte)9;
	geoidSimple[28][46] = (byte)8;
	geoidSimple[28][47] = (byte)8;
	geoidSimple[28][48] = (byte)7;
	geoidSimple[28][49] = (byte)6;
	geoidSimple[28][50] = (byte)5;
	geoidSimple[28][51] = (byte)3;
	geoidSimple[28][52] = (byte)2;
	geoidSimple[28][53] = (byte)0;
	geoidSimple[28][54] = (byte)0;
	geoidSimple[28][55] = (byte)-1;
	geoidSimple[28][56] = (byte)-2;
	geoidSimple[28][57] = (byte)-3;
	geoidSimple[28][58] = (byte)-3;
	geoidSimple[28][59] = (byte)-2;
	geoidSimple[28][60] = (byte)-4;
	geoidSimple[28][61] = (byte)-6;
	geoidSimple[28][62] = (byte)-9;
	geoidSimple[28][63] = (byte)-10;
	geoidSimple[28][64] = (byte)-11;
	geoidSimple[28][65] = (byte)-12;
	geoidSimple[28][66] = (byte)-14;
	geoidSimple[28][67] = (byte)-16;
	geoidSimple[28][68] = (byte)-17;
	geoidSimple[28][69] = (byte)-18;
	geoidSimple[28][70] = (byte)-19;
	geoidSimple[28][71] = (byte)-20;
	geoidSimple[28][72] = (byte)-22;
	geoidSimple[28][73] = (byte)-23;
	geoidSimple[28][74] = (byte)-23;
	geoidSimple[28][75] = (byte)-24;
	geoidSimple[28][76] = (byte)-25;
	geoidSimple[28][77] = (byte)-25;
	geoidSimple[28][78] = (byte)-25;
	geoidSimple[28][79] = (byte)-26;
	geoidSimple[28][80] = (byte)-27;
	geoidSimple[28][81] = (byte)-27;
	geoidSimple[28][82] = (byte)-28;
	geoidSimple[28][83] = (byte)-28;
	geoidSimple[28][84] = (byte)-28;
	geoidSimple[28][85] = (byte)-27;
	geoidSimple[28][86] = (byte)-27;
	geoidSimple[28][87] = (byte)-28;
	geoidSimple[28][88] = (byte)-28;
	geoidSimple[28][89] = (byte)-28;
	geoidSimple[28][90] = (byte)-28;
	geoidSimple[28][91] = (byte)-29;
	geoidSimple[28][92] = (byte)-29;
	geoidSimple[28][93] = (byte)-29;
	geoidSimple[28][94] = (byte)-29;
	geoidSimple[28][95] = (byte)-30;
	geoidSimple[28][96] = (byte)-31;
	geoidSimple[28][97] = (byte)-32;
	geoidSimple[28][98] = (byte)-32;
	geoidSimple[28][99] = (byte)-32;
	geoidSimple[28][100] = (byte)-31;
	geoidSimple[28][101] = (byte)-31;
	geoidSimple[28][102] = (byte)-31;
	geoidSimple[28][103] = (byte)-30;
	geoidSimple[28][104] = (byte)-29;
	geoidSimple[28][105] = (byte)-29;
	geoidSimple[28][106] = (byte)-29;
	geoidSimple[28][107] = (byte)-29;
	geoidSimple[28][108] = (byte)-28;
	geoidSimple[28][109] = (byte)-27;
	geoidSimple[28][110] = (byte)-26;
	geoidSimple[28][111] = (byte)-25;
	geoidSimple[28][112] = (byte)-25;
	geoidSimple[28][113] = (byte)-24;
	geoidSimple[28][114] = (byte)-24;
	geoidSimple[28][115] = (byte)-23;
	geoidSimple[28][116] = (byte)-21;
	geoidSimple[28][117] = (byte)-20;
	geoidSimple[28][118] = (byte)-20;
	geoidSimple[28][119] = (byte)-20;
	geoidSimple[28][120] = (byte)-18;
	geoidSimple[28][121] = (byte)-15;
	geoidSimple[28][122] = (byte)-12;
	geoidSimple[28][123] = (byte)-11;
	geoidSimple[28][124] = (byte)-10;
	geoidSimple[28][125] = (byte)-9;
	geoidSimple[28][126] = (byte)-8;
	geoidSimple[28][127] = (byte)-7;
	geoidSimple[28][128] = (byte)-6;
	geoidSimple[28][129] = (byte)-4;
	geoidSimple[28][130] = (byte)-2;
	geoidSimple[28][131] = (byte)0;
	geoidSimple[28][132] = (byte)0;
	geoidSimple[28][133] = (byte)1;
	geoidSimple[28][134] = (byte)2;
	geoidSimple[28][135] = (byte)2;
	geoidSimple[28][136] = (byte)4;
	geoidSimple[28][137] = (byte)7;
	geoidSimple[28][138] = (byte)8;
	geoidSimple[28][139] = (byte)9;
	geoidSimple[28][140] = (byte)10;
	geoidSimple[28][141] = (byte)11;
	geoidSimple[28][142] = (byte)12;
	geoidSimple[28][143] = (byte)12;
	geoidSimple[28][144] = (byte)12;
	geoidSimple[28][145] = (byte)12;
	geoidSimple[28][146] = (byte)13;
	geoidSimple[28][147] = (byte)13;
	geoidSimple[28][148] = (byte)13;
	geoidSimple[28][149] = (byte)14;
	geoidSimple[28][150] = (byte)14;
	geoidSimple[28][151] = (byte)14;
	geoidSimple[28][152] = (byte)14;
	geoidSimple[28][153] = (byte)14;
	geoidSimple[28][154] = (byte)15;
	geoidSimple[28][155] = (byte)15;
	geoidSimple[28][156] = (byte)14;
	geoidSimple[28][157] = (byte)13;
	geoidSimple[28][158] = (byte)12;
	geoidSimple[28][159] = (byte)12;
	geoidSimple[28][160] = (byte)13;
	geoidSimple[28][161] = (byte)13;
	geoidSimple[28][162] = (byte)12;
	geoidSimple[28][163] = (byte)11;
	geoidSimple[28][164] = (byte)11;
	geoidSimple[28][165] = (byte)11;
	geoidSimple[28][166] = (byte)10;
	geoidSimple[28][167] = (byte)10;
	geoidSimple[28][168] = (byte)10;
	geoidSimple[28][169] = (byte)10;
	geoidSimple[28][170] = (byte)10;
	geoidSimple[28][171] = (byte)10;
	geoidSimple[28][172] = (byte)8;
	geoidSimple[28][173] = (byte)6;
	geoidSimple[28][174] = (byte)4;
	geoidSimple[28][175] = (byte)2;
	geoidSimple[28][176] = (byte)1;
	geoidSimple[28][177] = (byte)2;
	geoidSimple[28][178] = (byte)4;
	geoidSimple[28][179] = (byte)5;
	geoidSimple[28][LAT_GRID_SIZE] = (byte)4;
	geoidSimple[28][181] = (byte)4;
	geoidSimple[28][182] = (byte)3;
	geoidSimple[28][183] = (byte)4;
	geoidSimple[28][184] = (byte)5;
	geoidSimple[28][185] = (byte)5;
	geoidSimple[28][186] = (byte)6;
	geoidSimple[28][187] = (byte)6;
	geoidSimple[28][188] = (byte)6;
	geoidSimple[28][189] = (byte)6;
	geoidSimple[28][190] = (byte)7;
	geoidSimple[28][191] = (byte)7;
	geoidSimple[28][192] = (byte)8;
	geoidSimple[28][193] = (byte)9;
	geoidSimple[28][194] = (byte)9;
	geoidSimple[28][195] = (byte)10;
	geoidSimple[28][196] = (byte)10;
	geoidSimple[28][197] = (byte)11;
	geoidSimple[28][198] = (byte)11;
	geoidSimple[28][199] = (byte)12;
	geoidSimple[28][200] = (byte)12;
	geoidSimple[28][201] = (byte)12;
	geoidSimple[28][202] = (byte)12;
	geoidSimple[28][203] = (byte)12;
	geoidSimple[28][204] = (byte)13;
	geoidSimple[28][205] = (byte)14;
	geoidSimple[28][206] = (byte)15;
	geoidSimple[28][207] = (byte)13;
	geoidSimple[28][208] = (byte)10;
	geoidSimple[28][209] = (byte)8;
	geoidSimple[28][210] = (byte)11;
	geoidSimple[28][211] = (byte)15;
	geoidSimple[28][212] = (byte)17;
	geoidSimple[28][213] = (byte)18;
	geoidSimple[28][214] = (byte)17;
	geoidSimple[28][215] = (byte)17;
	geoidSimple[28][216] = (byte)18;
	geoidSimple[28][217] = (byte)17;
	geoidSimple[28][218] = (byte)17;
	geoidSimple[28][219] = (byte)15;
	geoidSimple[28][220] = (byte)13;
	geoidSimple[28][221] = (byte)11;
	geoidSimple[28][222] = (byte)10;
	geoidSimple[28][223] = (byte)9;
	geoidSimple[28][224] = (byte)7;
	geoidSimple[28][225] = (byte)6;
	geoidSimple[28][226] = (byte)5;
	geoidSimple[28][227] = (byte)4;
	geoidSimple[28][228] = (byte)3;
	geoidSimple[28][229] = (byte)2;
	geoidSimple[28][230] = (byte)1;
	geoidSimple[28][231] = (byte)0;
	geoidSimple[28][232] = (byte)0;
	geoidSimple[28][233] = (byte)-2;
	geoidSimple[28][234] = (byte)-3;
	geoidSimple[28][235] = (byte)-5;
	geoidSimple[28][236] = (byte)-8;
	geoidSimple[28][237] = (byte)-11;
	geoidSimple[28][238] = (byte)-13;
	geoidSimple[28][239] = (byte)-14;
	geoidSimple[28][240] = (byte)-16;
	geoidSimple[28][241] = (byte)-19;
	geoidSimple[28][242] = (byte)-21;
	geoidSimple[28][243] = (byte)-22;
	geoidSimple[28][244] = (byte)-25;
	geoidSimple[28][245] = (byte)-26;
	geoidSimple[28][246] = (byte)-28;
	geoidSimple[28][247] = (byte)-29;
	geoidSimple[28][248] = (byte)-30;
	geoidSimple[28][249] = (byte)-31;
	geoidSimple[28][250] = (byte)-31;
	geoidSimple[28][251] = (byte)-32;
	geoidSimple[28][252] = (byte)-33;
	geoidSimple[28][253] = (byte)-34;
	geoidSimple[28][254] = (byte)-35;
	geoidSimple[28][255] = (byte)-37;
	geoidSimple[28][256] = (byte)-39;
	geoidSimple[28][257] = (byte)-40;
	geoidSimple[28][258] = (byte)-41;
	geoidSimple[28][259] = (byte)-42;
	geoidSimple[28][260] = (byte)-43;
	geoidSimple[28][261] = (byte)-44;
	geoidSimple[28][262] = (byte)-45;
	geoidSimple[28][263] = (byte)-46;
	geoidSimple[28][264] = (byte)-47;
	geoidSimple[28][265] = (byte)-48;
	geoidSimple[28][266] = (byte)-48;
	geoidSimple[28][267] = (byte)-48;
	geoidSimple[28][268] = (byte)-48;
	geoidSimple[28][269] = (byte)-47;
	geoidSimple[28][270] = (byte)-46;
	geoidSimple[28][271] = (byte)-45;
	geoidSimple[28][272] = (byte)-45;
	geoidSimple[28][273] = (byte)-44;
	geoidSimple[28][274] = (byte)-43;
	geoidSimple[28][275] = (byte)-43;
	geoidSimple[28][276] = (byte)-41;
	geoidSimple[28][277] = (byte)-40;
	geoidSimple[28][278] = (byte)-38;
	geoidSimple[28][279] = (byte)-37;
	geoidSimple[28][280] = (byte)-35;
	geoidSimple[28][281] = (byte)-34;
	geoidSimple[28][282] = (byte)-32;
	geoidSimple[28][283] = (byte)-30;
	geoidSimple[28][284] = (byte)-28;
	geoidSimple[28][285] = (byte)-26;
	geoidSimple[28][286] = (byte)-24;
	geoidSimple[28][287] = (byte)-24;
	geoidSimple[28][288] = (byte)-24;
	geoidSimple[28][289] = (byte)-22;
	geoidSimple[28][290] = (byte)-21;
	geoidSimple[28][291] = (byte)-19;
	geoidSimple[28][292] = (byte)-17;
	geoidSimple[28][293] = (byte)-13;
	geoidSimple[28][294] = (byte)-8;
	geoidSimple[28][295] = (byte)-4;
	geoidSimple[28][296] = (byte)0;
	geoidSimple[28][297] = (byte)2;
	geoidSimple[28][298] = (byte)6;
	geoidSimple[28][299] = (byte)8;
	geoidSimple[28][300] = (byte)8;
	geoidSimple[28][301] = (byte)10;
	geoidSimple[28][302] = (byte)12;
	geoidSimple[28][303] = (byte)15;
	geoidSimple[28][304] = (byte)17;
	geoidSimple[28][305] = (byte)20;
	geoidSimple[28][306] = (byte)22;
	geoidSimple[28][307] = (byte)24;
	geoidSimple[28][308] = (byte)26;
	geoidSimple[28][309] = (byte)29;
	geoidSimple[28][310] = (byte)31;
	geoidSimple[28][311] = (byte)33;
	geoidSimple[28][312] = (byte)37;
	geoidSimple[28][313] = (byte)40;
	geoidSimple[28][314] = (byte)43;
	geoidSimple[28][315] = (byte)46;
	geoidSimple[28][316] = (byte)47;
	geoidSimple[28][317] = (byte)46;
	geoidSimple[28][318] = (byte)48;
	geoidSimple[28][319] = (byte)49;
	geoidSimple[28][320] = (byte)49;
	geoidSimple[28][321] = (byte)50;
	geoidSimple[28][322] = (byte)51;
	geoidSimple[28][323] = (byte)52;
	geoidSimple[28][324] = (byte)53;
	geoidSimple[28][325] = (byte)54;
	geoidSimple[28][326] = (byte)56;
	geoidSimple[28][327] = (byte)58;
	geoidSimple[28][328] = (byte)59;
	geoidSimple[28][329] = (byte)61;
	geoidSimple[28][330] = (byte)62;
	geoidSimple[28][331] = (byte)63;
	geoidSimple[28][332] = (byte)64;
	geoidSimple[28][333] = (byte)65;
	geoidSimple[28][334] = (byte)64;
	geoidSimple[28][335] = (byte)64;
	geoidSimple[28][336] = (byte)64;
	geoidSimple[28][337] = (byte)63;
	geoidSimple[28][338] = (byte)63;
	geoidSimple[28][339] = (byte)62;
	geoidSimple[28][340] = (byte)62;
	geoidSimple[28][341] = (byte)61;
	geoidSimple[28][342] = (byte)61;
	geoidSimple[28][343] = (byte)60;
	geoidSimple[28][344] = (byte)60;
	geoidSimple[28][345] = (byte)59;
	geoidSimple[28][346] = (byte)60;
	geoidSimple[28][347] = (byte)59;
	geoidSimple[28][348] = (byte)59;
	geoidSimple[28][349] = (byte)59;
	geoidSimple[28][350] = (byte)58;
	geoidSimple[28][351] = (byte)58;
	geoidSimple[28][352] = (byte)57;
	geoidSimple[28][353] = (byte)56;
	geoidSimple[28][354] = (byte)54;
	geoidSimple[28][355] = (byte)53;
	geoidSimple[28][356] = (byte)51;
	geoidSimple[28][357] = (byte)49;
	geoidSimple[28][358] = (byte)50;
	geoidSimple[28][359] = (byte)50;
	}
		/** Row 29*/
	private static void init29() {
	geoidSimple[29][0] = (byte)48;
	geoidSimple[29][1] = (byte)47;
	geoidSimple[29][2] = (byte)46;
	geoidSimple[29][3] = (byte)45;
	geoidSimple[29][4] = (byte)45;
	geoidSimple[29][5] = (byte)45;
	geoidSimple[29][6] = (byte)45;
	geoidSimple[29][7] = (byte)45;
	geoidSimple[29][8] = (byte)44;
	geoidSimple[29][9] = (byte)41;
	geoidSimple[29][10] = (byte)39;
	geoidSimple[29][11] = (byte)37;
	geoidSimple[29][12] = (byte)34;
	geoidSimple[29][13] = (byte)32;
	geoidSimple[29][14] = (byte)30;
	geoidSimple[29][15] = (byte)29;
	geoidSimple[29][16] = (byte)27;
	geoidSimple[29][17] = (byte)24;
	geoidSimple[29][18] = (byte)22;
	geoidSimple[29][19] = (byte)20;
	geoidSimple[29][20] = (byte)19;
	geoidSimple[29][21] = (byte)19;
	geoidSimple[29][22] = (byte)19;
	geoidSimple[29][23] = (byte)19;
	geoidSimple[29][24] = (byte)18;
	geoidSimple[29][25] = (byte)17;
	geoidSimple[29][26] = (byte)15;
	geoidSimple[29][27] = (byte)15;
	geoidSimple[29][28] = (byte)15;
	geoidSimple[29][29] = (byte)15;
	geoidSimple[29][30] = (byte)16;
	geoidSimple[29][31] = (byte)16;
	geoidSimple[29][32] = (byte)15;
	geoidSimple[29][33] = (byte)15;
	geoidSimple[29][34] = (byte)15;
	geoidSimple[29][35] = (byte)14;
	geoidSimple[29][36] = (byte)12;
	geoidSimple[29][37] = (byte)11;
	geoidSimple[29][38] = (byte)11;
	geoidSimple[29][39] = (byte)11;
	geoidSimple[29][40] = (byte)11;
	geoidSimple[29][41] = (byte)11;
	geoidSimple[29][42] = (byte)10;
	geoidSimple[29][43] = (byte)10;
	geoidSimple[29][44] = (byte)9;
	geoidSimple[29][45] = (byte)9;
	geoidSimple[29][46] = (byte)8;
	geoidSimple[29][47] = (byte)7;
	geoidSimple[29][48] = (byte)7;
	geoidSimple[29][49] = (byte)6;
	geoidSimple[29][50] = (byte)5;
	geoidSimple[29][51] = (byte)4;
	geoidSimple[29][52] = (byte)3;
	geoidSimple[29][53] = (byte)2;
	geoidSimple[29][54] = (byte)0;
	geoidSimple[29][55] = (byte)0;
	geoidSimple[29][56] = (byte)-2;
	geoidSimple[29][57] = (byte)-3;
	geoidSimple[29][58] = (byte)-3;
	geoidSimple[29][59] = (byte)-2;
	geoidSimple[29][60] = (byte)-4;
	geoidSimple[29][61] = (byte)-8;
	geoidSimple[29][62] = (byte)-9;
	geoidSimple[29][63] = (byte)-10;
	geoidSimple[29][64] = (byte)-12;
	geoidSimple[29][65] = (byte)-14;
	geoidSimple[29][66] = (byte)-16;
	geoidSimple[29][67] = (byte)-17;
	geoidSimple[29][68] = (byte)-18;
	geoidSimple[29][69] = (byte)-19;
	geoidSimple[29][70] = (byte)-21;
	geoidSimple[29][71] = (byte)-22;
	geoidSimple[29][72] = (byte)-23;
	geoidSimple[29][73] = (byte)-24;
	geoidSimple[29][74] = (byte)-24;
	geoidSimple[29][75] = (byte)-25;
	geoidSimple[29][76] = (byte)-27;
	geoidSimple[29][77] = (byte)-27;
	geoidSimple[29][78] = (byte)-27;
	geoidSimple[29][79] = (byte)-29;
	geoidSimple[29][80] = (byte)-29;
	geoidSimple[29][81] = (byte)-30;
	geoidSimple[29][82] = (byte)-30;
	geoidSimple[29][83] = (byte)-30;
	geoidSimple[29][84] = (byte)-30;
	geoidSimple[29][85] = (byte)-30;
	geoidSimple[29][86] = (byte)-30;
	geoidSimple[29][87] = (byte)-30;
	geoidSimple[29][88] = (byte)-31;
	geoidSimple[29][89] = (byte)-31;
	geoidSimple[29][90] = (byte)-31;
	geoidSimple[29][91] = (byte)-30;
	geoidSimple[29][92] = (byte)-30;
	geoidSimple[29][93] = (byte)-30;
	geoidSimple[29][94] = (byte)-32;
	geoidSimple[29][95] = (byte)-33;
	geoidSimple[29][96] = (byte)-34;
	geoidSimple[29][97] = (byte)-34;
	geoidSimple[29][98] = (byte)-34;
	geoidSimple[29][99] = (byte)-33;
	geoidSimple[29][100] = (byte)-33;
	geoidSimple[29][101] = (byte)-33;
	geoidSimple[29][102] = (byte)-32;
	geoidSimple[29][103] = (byte)-31;
	geoidSimple[29][104] = (byte)-30;
	geoidSimple[29][105] = (byte)-30;
	geoidSimple[29][106] = (byte)-30;
	geoidSimple[29][107] = (byte)-29;
	geoidSimple[29][108] = (byte)-28;
	geoidSimple[29][109] = (byte)-27;
	geoidSimple[29][110] = (byte)-27;
	geoidSimple[29][111] = (byte)-26;
	geoidSimple[29][112] = (byte)-26;
	geoidSimple[29][113] = (byte)-26;
	geoidSimple[29][114] = (byte)-26;
	geoidSimple[29][115] = (byte)-25;
	geoidSimple[29][116] = (byte)-23;
	geoidSimple[29][117] = (byte)-20;
	geoidSimple[29][118] = (byte)-18;
	geoidSimple[29][119] = (byte)-17;
	geoidSimple[29][120] = (byte)-16;
	geoidSimple[29][121] = (byte)-13;
	geoidSimple[29][122] = (byte)-11;
	geoidSimple[29][123] = (byte)-10;
	geoidSimple[29][124] = (byte)-8;
	geoidSimple[29][125] = (byte)-6;
	geoidSimple[29][126] = (byte)-5;
	geoidSimple[29][127] = (byte)-4;
	geoidSimple[29][128] = (byte)-3;
	geoidSimple[29][129] = (byte)-1;
	geoidSimple[29][130] = (byte)0;
	geoidSimple[29][131] = (byte)1;
	geoidSimple[29][132] = (byte)2;
	geoidSimple[29][133] = (byte)3;
	geoidSimple[29][134] = (byte)4;
	geoidSimple[29][135] = (byte)4;
	geoidSimple[29][136] = (byte)6;
	geoidSimple[29][137] = (byte)8;
	geoidSimple[29][138] = (byte)10;
	geoidSimple[29][139] = (byte)11;
	geoidSimple[29][140] = (byte)11;
	geoidSimple[29][141] = (byte)12;
	geoidSimple[29][142] = (byte)12;
	geoidSimple[29][143] = (byte)13;
	geoidSimple[29][144] = (byte)13;
	geoidSimple[29][145] = (byte)13;
	geoidSimple[29][146] = (byte)13;
	geoidSimple[29][147] = (byte)14;
	geoidSimple[29][148] = (byte)14;
	geoidSimple[29][149] = (byte)15;
	geoidSimple[29][150] = (byte)15;
	geoidSimple[29][151] = (byte)16;
	geoidSimple[29][152] = (byte)16;
	geoidSimple[29][153] = (byte)16;
	geoidSimple[29][154] = (byte)16;
	geoidSimple[29][155] = (byte)15;
	geoidSimple[29][156] = (byte)14;
	geoidSimple[29][157] = (byte)13;
	geoidSimple[29][158] = (byte)13;
	geoidSimple[29][159] = (byte)13;
	geoidSimple[29][160] = (byte)13;
	geoidSimple[29][161] = (byte)14;
	geoidSimple[29][162] = (byte)13;
	geoidSimple[29][163] = (byte)12;
	geoidSimple[29][164] = (byte)12;
	geoidSimple[29][165] = (byte)12;
	geoidSimple[29][166] = (byte)11;
	geoidSimple[29][167] = (byte)11;
	geoidSimple[29][168] = (byte)10;
	geoidSimple[29][169] = (byte)10;
	geoidSimple[29][170] = (byte)9;
	geoidSimple[29][171] = (byte)6;
	geoidSimple[29][172] = (byte)3;
	geoidSimple[29][173] = (byte)2;
	geoidSimple[29][174] = (byte)0;
	geoidSimple[29][175] = (byte)-1;
	geoidSimple[29][176] = (byte)-1;
	geoidSimple[29][177] = (byte)-1;
	geoidSimple[29][178] = (byte)0;
	geoidSimple[29][179] = (byte)2;
	geoidSimple[29][LAT_GRID_SIZE] = (byte)3;
	geoidSimple[29][181] = (byte)3;
	geoidSimple[29][182] = (byte)3;
	geoidSimple[29][183] = (byte)4;
	geoidSimple[29][184] = (byte)5;
	geoidSimple[29][185] = (byte)6;
	geoidSimple[29][186] = (byte)6;
	geoidSimple[29][187] = (byte)7;
	geoidSimple[29][188] = (byte)7;
	geoidSimple[29][189] = (byte)7;
	geoidSimple[29][190] = (byte)8;
	geoidSimple[29][191] = (byte)9;
	geoidSimple[29][192] = (byte)10;
	geoidSimple[29][193] = (byte)10;
	geoidSimple[29][194] = (byte)11;
	geoidSimple[29][195] = (byte)11;
	geoidSimple[29][196] = (byte)11;
	geoidSimple[29][197] = (byte)12;
	geoidSimple[29][198] = (byte)12;
	geoidSimple[29][199] = (byte)13;
	geoidSimple[29][200] = (byte)14;
	geoidSimple[29][201] = (byte)14;
	geoidSimple[29][202] = (byte)14;
	geoidSimple[29][203] = (byte)14;
	geoidSimple[29][204] = (byte)14;
	geoidSimple[29][205] = (byte)14;
	geoidSimple[29][206] = (byte)14;
	geoidSimple[29][207] = (byte)12;
	geoidSimple[29][208] = (byte)8;
	geoidSimple[29][209] = (byte)8;
	geoidSimple[29][210] = (byte)11;
	geoidSimple[29][211] = (byte)12;
	geoidSimple[29][212] = (byte)13;
	geoidSimple[29][213] = (byte)13;
	geoidSimple[29][214] = (byte)14;
	geoidSimple[29][215] = (byte)15;
	geoidSimple[29][216] = (byte)14;
	geoidSimple[29][217] = (byte)13;
	geoidSimple[29][218] = (byte)13;
	geoidSimple[29][219] = (byte)15;
	geoidSimple[29][220] = (byte)15;
	geoidSimple[29][221] = (byte)12;
	geoidSimple[29][222] = (byte)10;
	geoidSimple[29][223] = (byte)9;
	geoidSimple[29][224] = (byte)7;
	geoidSimple[29][225] = (byte)6;
	geoidSimple[29][226] = (byte)5;
	geoidSimple[29][227] = (byte)4;
	geoidSimple[29][228] = (byte)3;
	geoidSimple[29][229] = (byte)1;
	geoidSimple[29][230] = (byte)0;
	geoidSimple[29][231] = (byte)-1;
	geoidSimple[29][232] = (byte)-1;
	geoidSimple[29][233] = (byte)-3;
	geoidSimple[29][234] = (byte)-4;
	geoidSimple[29][235] = (byte)-6;
	geoidSimple[29][236] = (byte)-10;
	geoidSimple[29][237] = (byte)-11;
	geoidSimple[29][238] = (byte)-12;
	geoidSimple[29][239] = (byte)-14;
	geoidSimple[29][240] = (byte)-16;
	geoidSimple[29][241] = (byte)-18;
	geoidSimple[29][242] = (byte)-20;
	geoidSimple[29][243] = (byte)-22;
	geoidSimple[29][244] = (byte)-24;
	geoidSimple[29][245] = (byte)-26;
	geoidSimple[29][246] = (byte)-28;
	geoidSimple[29][247] = (byte)-29;
	geoidSimple[29][248] = (byte)-30;
	geoidSimple[29][249] = (byte)-31;
	geoidSimple[29][250] = (byte)-31;
	geoidSimple[29][251] = (byte)-32;
	geoidSimple[29][252] = (byte)-33;
	geoidSimple[29][253] = (byte)-34;
	geoidSimple[29][254] = (byte)-35;
	geoidSimple[29][255] = (byte)-37;
	geoidSimple[29][256] = (byte)-38;
	geoidSimple[29][257] = (byte)-39;
	geoidSimple[29][258] = (byte)-40;
	geoidSimple[29][259] = (byte)-41;
	geoidSimple[29][260] = (byte)-43;
	geoidSimple[29][261] = (byte)-44;
	geoidSimple[29][262] = (byte)-45;
	geoidSimple[29][263] = (byte)-46;
	geoidSimple[29][264] = (byte)-47;
	geoidSimple[29][265] = (byte)-48;
	geoidSimple[29][266] = (byte)-49;
	geoidSimple[29][267] = (byte)-49;
	geoidSimple[29][268] = (byte)-48;
	geoidSimple[29][269] = (byte)-47;
	geoidSimple[29][270] = (byte)-46;
	geoidSimple[29][271] = (byte)-46;
	geoidSimple[29][272] = (byte)-46;
	geoidSimple[29][273] = (byte)-46;
	geoidSimple[29][274] = (byte)-45;
	geoidSimple[29][275] = (byte)-44;
	geoidSimple[29][276] = (byte)-42;
	geoidSimple[29][277] = (byte)-41;
	geoidSimple[29][278] = (byte)-40;
	geoidSimple[29][279] = (byte)-39;
	geoidSimple[29][280] = (byte)-39;
	geoidSimple[29][281] = (byte)-38;
	geoidSimple[29][282] = (byte)-35;
	geoidSimple[29][283] = (byte)-32;
	geoidSimple[29][284] = (byte)-30;
	geoidSimple[29][285] = (byte)-28;
	geoidSimple[29][286] = (byte)-26;
	geoidSimple[29][287] = (byte)-24;
	geoidSimple[29][288] = (byte)-23;
	geoidSimple[29][289] = (byte)-22;
	geoidSimple[29][290] = (byte)-21;
	geoidSimple[29][291] = (byte)-20;
	geoidSimple[29][292] = (byte)-19;
	geoidSimple[29][293] = (byte)-16;
	geoidSimple[29][294] = (byte)-11;
	geoidSimple[29][295] = (byte)-6;
	geoidSimple[29][296] = (byte)-2;
	geoidSimple[29][297] = (byte)0;
	geoidSimple[29][298] = (byte)3;
	geoidSimple[29][299] = (byte)5;
	geoidSimple[29][300] = (byte)7;
	geoidSimple[29][301] = (byte)9;
	geoidSimple[29][302] = (byte)11;
	geoidSimple[29][303] = (byte)13;
	geoidSimple[29][304] = (byte)16;
	geoidSimple[29][305] = (byte)18;
	geoidSimple[29][306] = (byte)20;
	geoidSimple[29][307] = (byte)23;
	geoidSimple[29][308] = (byte)25;
	geoidSimple[29][309] = (byte)27;
	geoidSimple[29][310] = (byte)29;
	geoidSimple[29][311] = (byte)31;
	geoidSimple[29][312] = (byte)34;
	geoidSimple[29][313] = (byte)36;
	geoidSimple[29][314] = (byte)38;
	geoidSimple[29][315] = (byte)43;
	geoidSimple[29][316] = (byte)45;
	geoidSimple[29][317] = (byte)46;
	geoidSimple[29][318] = (byte)48;
	geoidSimple[29][319] = (byte)48;
	geoidSimple[29][320] = (byte)49;
	geoidSimple[29][321] = (byte)50;
	geoidSimple[29][322] = (byte)51;
	geoidSimple[29][323] = (byte)52;
	geoidSimple[29][324] = (byte)54;
	geoidSimple[29][325] = (byte)55;
	geoidSimple[29][326] = (byte)57;
	geoidSimple[29][327] = (byte)59;
	geoidSimple[29][328] = (byte)60;
	geoidSimple[29][329] = (byte)62;
	geoidSimple[29][330] = (byte)63;
	geoidSimple[29][331] = (byte)64;
	geoidSimple[29][332] = (byte)64;
	geoidSimple[29][333] = (byte)64;
	geoidSimple[29][334] = (byte)64;
	geoidSimple[29][335] = (byte)63;
	geoidSimple[29][336] = (byte)63;
	geoidSimple[29][337] = (byte)62;
	geoidSimple[29][338] = (byte)61;
	geoidSimple[29][339] = (byte)61;
	geoidSimple[29][340] = (byte)60;
	geoidSimple[29][341] = (byte)60;
	geoidSimple[29][342] = (byte)60;
	geoidSimple[29][343] = (byte)59;
	geoidSimple[29][344] = (byte)59;
	geoidSimple[29][345] = (byte)59;
	geoidSimple[29][346] = (byte)59;
	geoidSimple[29][347] = (byte)59;
	geoidSimple[29][348] = (byte)58;
	geoidSimple[29][349] = (byte)57;
	geoidSimple[29][350] = (byte)57;
	geoidSimple[29][351] = (byte)57;
	geoidSimple[29][352] = (byte)56;
	geoidSimple[29][353] = (byte)55;
	geoidSimple[29][354] = (byte)54;
	geoidSimple[29][355] = (byte)52;
	geoidSimple[29][356] = (byte)52;
	geoidSimple[29][357] = (byte)51;
	geoidSimple[29][358] = (byte)50;
	geoidSimple[29][359] = (byte)49;
	}
		/** Row 30*/
	private static void init30() {
	geoidSimple[30][0] = (byte)47;
	geoidSimple[30][1] = (byte)46;
	geoidSimple[30][2] = (byte)46;
	geoidSimple[30][3] = (byte)44;
	geoidSimple[30][4] = (byte)44;
	geoidSimple[30][5] = (byte)44;
	geoidSimple[30][6] = (byte)44;
	geoidSimple[30][7] = (byte)45;
	geoidSimple[30][8] = (byte)43;
	geoidSimple[30][9] = (byte)41;
	geoidSimple[30][10] = (byte)39;
	geoidSimple[30][11] = (byte)37;
	geoidSimple[30][12] = (byte)34;
	geoidSimple[30][13] = (byte)31;
	geoidSimple[30][14] = (byte)29;
	geoidSimple[30][15] = (byte)28;
	geoidSimple[30][16] = (byte)26;
	geoidSimple[30][17] = (byte)24;
	geoidSimple[30][18] = (byte)22;
	geoidSimple[30][19] = (byte)20;
	geoidSimple[30][20] = (byte)18;
	geoidSimple[30][21] = (byte)18;
	geoidSimple[30][22] = (byte)19;
	geoidSimple[30][23] = (byte)19;
	geoidSimple[30][24] = (byte)18;
	geoidSimple[30][25] = (byte)17;
	geoidSimple[30][26] = (byte)16;
	geoidSimple[30][27] = (byte)16;
	geoidSimple[30][28] = (byte)15;
	geoidSimple[30][29] = (byte)15;
	geoidSimple[30][30] = (byte)15;
	geoidSimple[30][31] = (byte)15;
	geoidSimple[30][32] = (byte)15;
	geoidSimple[30][33] = (byte)16;
	geoidSimple[30][34] = (byte)16;
	geoidSimple[30][35] = (byte)15;
	geoidSimple[30][36] = (byte)13;
	geoidSimple[30][37] = (byte)12;
	geoidSimple[30][38] = (byte)12;
	geoidSimple[30][39] = (byte)12;
	geoidSimple[30][40] = (byte)11;
	geoidSimple[30][41] = (byte)11;
	geoidSimple[30][42] = (byte)11;
	geoidSimple[30][43] = (byte)11;
	geoidSimple[30][44] = (byte)10;
	geoidSimple[30][45] = (byte)8;
	geoidSimple[30][46] = (byte)7;
	geoidSimple[30][47] = (byte)7;
	geoidSimple[30][48] = (byte)7;
	geoidSimple[30][49] = (byte)6;
	geoidSimple[30][50] = (byte)5;
	geoidSimple[30][51] = (byte)4;
	geoidSimple[30][52] = (byte)3;
	geoidSimple[30][53] = (byte)2;
	geoidSimple[30][54] = (byte)1;
	geoidSimple[30][55] = (byte)0;
	geoidSimple[30][56] = (byte)-1;
	geoidSimple[30][57] = (byte)-2;
	geoidSimple[30][58] = (byte)-2;
	geoidSimple[30][59] = (byte)-2;
	geoidSimple[30][60] = (byte)-5;
	geoidSimple[30][61] = (byte)-9;
	geoidSimple[30][62] = (byte)-10;
	geoidSimple[30][63] = (byte)-12;
	geoidSimple[30][64] = (byte)-14;
	geoidSimple[30][65] = (byte)-15;
	geoidSimple[30][66] = (byte)-16;
	geoidSimple[30][67] = (byte)-17;
	geoidSimple[30][68] = (byte)-19;
	geoidSimple[30][69] = (byte)-20;
	geoidSimple[30][70] = (byte)-22;
	geoidSimple[30][71] = (byte)-23;
	geoidSimple[30][72] = (byte)-24;
	geoidSimple[30][73] = (byte)-25;
	geoidSimple[30][74] = (byte)-26;
	geoidSimple[30][75] = (byte)-27;
	geoidSimple[30][76] = (byte)-28;
	geoidSimple[30][77] = (byte)-29;
	geoidSimple[30][78] = (byte)-29;
	geoidSimple[30][79] = (byte)-30;
	geoidSimple[30][80] = (byte)-31;
	geoidSimple[30][81] = (byte)-31;
	geoidSimple[30][82] = (byte)-32;
	geoidSimple[30][83] = (byte)-32;
	geoidSimple[30][84] = (byte)-32;
	geoidSimple[30][85] = (byte)-32;
	geoidSimple[30][86] = (byte)-33;
	geoidSimple[30][87] = (byte)-33;
	geoidSimple[30][88] = (byte)-34;
	geoidSimple[30][89] = (byte)-35;
	geoidSimple[30][90] = (byte)-35;
	geoidSimple[30][91] = (byte)-33;
	geoidSimple[30][92] = (byte)-32;
	geoidSimple[30][93] = (byte)-32;
	geoidSimple[30][94] = (byte)-32;
	geoidSimple[30][95] = (byte)-33;
	geoidSimple[30][96] = (byte)-34;
	geoidSimple[30][97] = (byte)-34;
	geoidSimple[30][98] = (byte)-34;
	geoidSimple[30][99] = (byte)-34;
	geoidSimple[30][100] = (byte)-34;
	geoidSimple[30][101] = (byte)-34;
	geoidSimple[30][102] = (byte)-33;
	geoidSimple[30][103] = (byte)-32;
	geoidSimple[30][104] = (byte)-31;
	geoidSimple[30][105] = (byte)-31;
	geoidSimple[30][106] = (byte)-31;
	geoidSimple[30][107] = (byte)-30;
	geoidSimple[30][108] = (byte)-29;
	geoidSimple[30][109] = (byte)-28;
	geoidSimple[30][110] = (byte)-27;
	geoidSimple[30][111] = (byte)-27;
	geoidSimple[30][112] = (byte)-27;
	geoidSimple[30][113] = (byte)-26;
	geoidSimple[30][114] = (byte)-25;
	geoidSimple[30][115] = (byte)-22;
	geoidSimple[30][116] = (byte)-20;
	geoidSimple[30][117] = (byte)-19;
	geoidSimple[30][118] = (byte)-18;
	geoidSimple[30][119] = (byte)-17;
	geoidSimple[30][120] = (byte)-15;
	geoidSimple[30][121] = (byte)-13;
	geoidSimple[30][122] = (byte)-10;
	geoidSimple[30][123] = (byte)-8;
	geoidSimple[30][124] = (byte)-6;
	geoidSimple[30][125] = (byte)-4;
	geoidSimple[30][126] = (byte)-3;
	geoidSimple[30][127] = (byte)-2;
	geoidSimple[30][128] = (byte)0;
	geoidSimple[30][129] = (byte)0;
	geoidSimple[30][130] = (byte)1;
	geoidSimple[30][131] = (byte)3;
	geoidSimple[30][132] = (byte)4;
	geoidSimple[30][133] = (byte)5;
	geoidSimple[30][134] = (byte)6;
	geoidSimple[30][135] = (byte)6;
	geoidSimple[30][136] = (byte)8;
	geoidSimple[30][137] = (byte)10;
	geoidSimple[30][138] = (byte)11;
	geoidSimple[30][139] = (byte)12;
	geoidSimple[30][140] = (byte)12;
	geoidSimple[30][141] = (byte)12;
	geoidSimple[30][142] = (byte)12;
	geoidSimple[30][143] = (byte)12;
	geoidSimple[30][144] = (byte)13;
	geoidSimple[30][145] = (byte)13;
	geoidSimple[30][146] = (byte)14;
	geoidSimple[30][147] = (byte)14;
	geoidSimple[30][148] = (byte)15;
	geoidSimple[30][149] = (byte)16;
	geoidSimple[30][150] = (byte)16;
	geoidSimple[30][151] = (byte)17;
	geoidSimple[30][152] = (byte)17;
	geoidSimple[30][153] = (byte)16;
	geoidSimple[30][154] = (byte)16;
	geoidSimple[30][155] = (byte)15;
	geoidSimple[30][156] = (byte)15;
	geoidSimple[30][157] = (byte)14;
	geoidSimple[30][158] = (byte)14;
	geoidSimple[30][159] = (byte)14;
	geoidSimple[30][160] = (byte)15;
	geoidSimple[30][161] = (byte)15;
	geoidSimple[30][162] = (byte)14;
	geoidSimple[30][163] = (byte)13;
	geoidSimple[30][164] = (byte)13;
	geoidSimple[30][165] = (byte)12;
	geoidSimple[30][166] = (byte)11;
	geoidSimple[30][167] = (byte)8;
	geoidSimple[30][168] = (byte)6;
	geoidSimple[30][169] = (byte)6;
	geoidSimple[30][170] = (byte)6;
	geoidSimple[30][171] = (byte)2;
	geoidSimple[30][172] = (byte)0;
	geoidSimple[30][173] = (byte)0;
	geoidSimple[30][174] = (byte)0;
	geoidSimple[30][175] = (byte)-1;
	geoidSimple[30][176] = (byte)0;
	geoidSimple[30][177] = (byte)0;
	geoidSimple[30][178] = (byte)0;
	geoidSimple[30][179] = (byte)0;
	geoidSimple[30][LAT_GRID_SIZE] = (byte)0;
	geoidSimple[30][181] = (byte)3;
	geoidSimple[30][182] = (byte)4;
	geoidSimple[30][183] = (byte)5;
	geoidSimple[30][184] = (byte)5;
	geoidSimple[30][185] = (byte)6;
	geoidSimple[30][186] = (byte)7;
	geoidSimple[30][187] = (byte)8;
	geoidSimple[30][188] = (byte)8;
	geoidSimple[30][189] = (byte)9;
	geoidSimple[30][190] = (byte)9;
	geoidSimple[30][191] = (byte)10;
	geoidSimple[30][192] = (byte)11;
	geoidSimple[30][193] = (byte)11;
	geoidSimple[30][194] = (byte)12;
	geoidSimple[30][195] = (byte)12;
	geoidSimple[30][196] = (byte)12;
	geoidSimple[30][197] = (byte)13;
	geoidSimple[30][198] = (byte)14;
	geoidSimple[30][199] = (byte)15;
	geoidSimple[30][200] = (byte)15;
	geoidSimple[30][201] = (byte)14;
	geoidSimple[30][202] = (byte)14;
	geoidSimple[30][203] = (byte)15;
	geoidSimple[30][204] = (byte)15;
	geoidSimple[30][205] = (byte)14;
	geoidSimple[30][206] = (byte)13;
	geoidSimple[30][207] = (byte)11;
	geoidSimple[30][208] = (byte)10;
	geoidSimple[30][209] = (byte)12;
	geoidSimple[30][210] = (byte)12;
	geoidSimple[30][211] = (byte)12;
	geoidSimple[30][212] = (byte)12;
	geoidSimple[30][213] = (byte)12;
	geoidSimple[30][214] = (byte)10;
	geoidSimple[30][215] = (byte)9;
	geoidSimple[30][216] = (byte)8;
	geoidSimple[30][217] = (byte)8;
	geoidSimple[30][218] = (byte)9;
	geoidSimple[30][219] = (byte)8;
	geoidSimple[30][220] = (byte)7;
	geoidSimple[30][221] = (byte)9;
	geoidSimple[30][222] = (byte)9;
	geoidSimple[30][223] = (byte)8;
	geoidSimple[30][224] = (byte)7;
	geoidSimple[30][225] = (byte)6;
	geoidSimple[30][226] = (byte)4;
	geoidSimple[30][227] = (byte)3;
	geoidSimple[30][228] = (byte)2;
	geoidSimple[30][229] = (byte)1;
	geoidSimple[30][230] = (byte)0;
	geoidSimple[30][231] = (byte)-1;
	geoidSimple[30][232] = (byte)-3;
	geoidSimple[30][233] = (byte)-4;
	geoidSimple[30][234] = (byte)-6;
	geoidSimple[30][235] = (byte)-8;
	geoidSimple[30][236] = (byte)-11;
	geoidSimple[30][237] = (byte)-12;
	geoidSimple[30][238] = (byte)-13;
	geoidSimple[30][239] = (byte)-14;
	geoidSimple[30][240] = (byte)-16;
	geoidSimple[30][241] = (byte)-17;
	geoidSimple[30][242] = (byte)-19;
	geoidSimple[30][243] = (byte)-20;
	geoidSimple[30][244] = (byte)-21;
	geoidSimple[30][245] = (byte)-23;
	geoidSimple[30][246] = (byte)-26;
	geoidSimple[30][247] = (byte)-28;
	geoidSimple[30][248] = (byte)-29;
	geoidSimple[30][249] = (byte)-30;
	geoidSimple[30][250] = (byte)-31;
	geoidSimple[30][251] = (byte)-32;
	geoidSimple[30][252] = (byte)-33;
	geoidSimple[30][253] = (byte)-34;
	geoidSimple[30][254] = (byte)-34;
	geoidSimple[30][255] = (byte)-35;
	geoidSimple[30][256] = (byte)-37;
	geoidSimple[30][257] = (byte)-38;
	geoidSimple[30][258] = (byte)-39;
	geoidSimple[30][259] = (byte)-41;
	geoidSimple[30][260] = (byte)-42;
	geoidSimple[30][261] = (byte)-43;
	geoidSimple[30][262] = (byte)-44;
	geoidSimple[30][263] = (byte)-45;
	geoidSimple[30][264] = (byte)-47;
	geoidSimple[30][265] = (byte)-48;
	geoidSimple[30][266] = (byte)-49;
	geoidSimple[30][267] = (byte)-49;
	geoidSimple[30][268] = (byte)-48;
	geoidSimple[30][269] = (byte)-48;
	geoidSimple[30][270] = (byte)-47;
	geoidSimple[30][271] = (byte)-46;
	geoidSimple[30][272] = (byte)-47;
	geoidSimple[30][273] = (byte)-47;
	geoidSimple[30][274] = (byte)-46;
	geoidSimple[30][275] = (byte)-45;
	geoidSimple[30][276] = (byte)-44;
	geoidSimple[30][277] = (byte)-44;
	geoidSimple[30][278] = (byte)-43;
	geoidSimple[30][279] = (byte)-43;
	geoidSimple[30][280] = (byte)-42;
	geoidSimple[30][281] = (byte)-39;
	geoidSimple[30][282] = (byte)-36;
	geoidSimple[30][283] = (byte)-34;
	geoidSimple[30][284] = (byte)-32;
	geoidSimple[30][285] = (byte)-30;
	geoidSimple[30][286] = (byte)-28;
	geoidSimple[30][287] = (byte)-27;
	geoidSimple[30][288] = (byte)-25;
	geoidSimple[30][289] = (byte)-24;
	geoidSimple[30][290] = (byte)-23;
	geoidSimple[30][291] = (byte)-21;
	geoidSimple[30][292] = (byte)-18;
	geoidSimple[30][293] = (byte)-15;
	geoidSimple[30][294] = (byte)-12;
	geoidSimple[30][295] = (byte)-8;
	geoidSimple[30][296] = (byte)-4;
	geoidSimple[30][297] = (byte)-1;
	geoidSimple[30][298] = (byte)1;
	geoidSimple[30][299] = (byte)4;
	geoidSimple[30][300] = (byte)5;
	geoidSimple[30][301] = (byte)6;
	geoidSimple[30][302] = (byte)9;
	geoidSimple[30][303] = (byte)11;
	geoidSimple[30][304] = (byte)14;
	geoidSimple[30][305] = (byte)16;
	geoidSimple[30][306] = (byte)19;
	geoidSimple[30][307] = (byte)22;
	geoidSimple[30][308] = (byte)24;
	geoidSimple[30][309] = (byte)26;
	geoidSimple[30][310] = (byte)28;
	geoidSimple[30][311] = (byte)31;
	geoidSimple[30][312] = (byte)33;
	geoidSimple[30][313] = (byte)37;
	geoidSimple[30][314] = (byte)39;
	geoidSimple[30][315] = (byte)41;
	geoidSimple[30][316] = (byte)44;
	geoidSimple[30][317] = (byte)46;
	geoidSimple[30][318] = (byte)47;
	geoidSimple[30][319] = (byte)48;
	geoidSimple[30][320] = (byte)49;
	geoidSimple[30][321] = (byte)50;
	geoidSimple[30][322] = (byte)51;
	geoidSimple[30][323] = (byte)53;
	geoidSimple[30][324] = (byte)55;
	geoidSimple[30][325] = (byte)57;
	geoidSimple[30][326] = (byte)58;
	geoidSimple[30][327] = (byte)60;
	geoidSimple[30][328] = (byte)62;
	geoidSimple[30][329] = (byte)63;
	geoidSimple[30][330] = (byte)64;
	geoidSimple[30][331] = (byte)64;
	geoidSimple[30][332] = (byte)63;
	geoidSimple[30][333] = (byte)63;
	geoidSimple[30][334] = (byte)63;
	geoidSimple[30][335] = (byte)62;
	geoidSimple[30][336] = (byte)62;
	geoidSimple[30][337] = (byte)61;
	geoidSimple[30][338] = (byte)60;
	geoidSimple[30][339] = (byte)60;
	geoidSimple[30][340] = (byte)60;
	geoidSimple[30][341] = (byte)60;
	geoidSimple[30][342] = (byte)60;
	geoidSimple[30][343] = (byte)60;
	geoidSimple[30][344] = (byte)59;
	geoidSimple[30][345] = (byte)59;
	geoidSimple[30][346] = (byte)58;
	geoidSimple[30][347] = (byte)57;
	geoidSimple[30][348] = (byte)56;
	geoidSimple[30][349] = (byte)56;
	geoidSimple[30][350] = (byte)55;
	geoidSimple[30][351] = (byte)55;
	geoidSimple[30][352] = (byte)55;
	geoidSimple[30][353] = (byte)55;
	geoidSimple[30][354] = (byte)55;
	geoidSimple[30][355] = (byte)54;
	geoidSimple[30][356] = (byte)53;
	geoidSimple[30][357] = (byte)51;
	geoidSimple[30][358] = (byte)49;
	geoidSimple[30][359] = (byte)48;
	}
		/** Row 31*/
	private static void init31() {
	geoidSimple[31][0] = (byte)47;
	geoidSimple[31][1] = (byte)46;
	geoidSimple[31][2] = (byte)45;
	geoidSimple[31][3] = (byte)44;
	geoidSimple[31][4] = (byte)44;
	geoidSimple[31][5] = (byte)43;
	geoidSimple[31][6] = (byte)43;
	geoidSimple[31][7] = (byte)43;
	geoidSimple[31][8] = (byte)41;
	geoidSimple[31][9] = (byte)40;
	geoidSimple[31][10] = (byte)38;
	geoidSimple[31][11] = (byte)36;
	geoidSimple[31][12] = (byte)34;
	geoidSimple[31][13] = (byte)32;
	geoidSimple[31][14] = (byte)30;
	geoidSimple[31][15] = (byte)29;
	geoidSimple[31][16] = (byte)27;
	geoidSimple[31][17] = (byte)25;
	geoidSimple[31][18] = (byte)23;
	geoidSimple[31][19] = (byte)20;
	geoidSimple[31][20] = (byte)19;
	geoidSimple[31][21] = (byte)18;
	geoidSimple[31][22] = (byte)19;
	geoidSimple[31][23] = (byte)19;
	geoidSimple[31][24] = (byte)19;
	geoidSimple[31][25] = (byte)19;
	geoidSimple[31][26] = (byte)18;
	geoidSimple[31][27] = (byte)17;
	geoidSimple[31][28] = (byte)16;
	geoidSimple[31][29] = (byte)15;
	geoidSimple[31][30] = (byte)14;
	geoidSimple[31][31] = (byte)14;
	geoidSimple[31][32] = (byte)15;
	geoidSimple[31][33] = (byte)16;
	geoidSimple[31][34] = (byte)16;
	geoidSimple[31][35] = (byte)15;
	geoidSimple[31][36] = (byte)14;
	geoidSimple[31][37] = (byte)14;
	geoidSimple[31][38] = (byte)13;
	geoidSimple[31][39] = (byte)13;
	geoidSimple[31][40] = (byte)12;
	geoidSimple[31][41] = (byte)12;
	geoidSimple[31][42] = (byte)11;
	geoidSimple[31][43] = (byte)10;
	geoidSimple[31][44] = (byte)9;
	geoidSimple[31][45] = (byte)8;
	geoidSimple[31][46] = (byte)8;
	geoidSimple[31][47] = (byte)7;
	geoidSimple[31][48] = (byte)6;
	geoidSimple[31][49] = (byte)6;
	geoidSimple[31][50] = (byte)5;
	geoidSimple[31][51] = (byte)3;
	geoidSimple[31][52] = (byte)2;
	geoidSimple[31][53] = (byte)1;
	geoidSimple[31][54] = (byte)0;
	geoidSimple[31][55] = (byte)0;
	geoidSimple[31][56] = (byte)-1;
	geoidSimple[31][57] = (byte)-2;
	geoidSimple[31][58] = (byte)-3;
	geoidSimple[31][59] = (byte)-3;
	geoidSimple[31][60] = (byte)-6;
	geoidSimple[31][61] = (byte)-9;
	geoidSimple[31][62] = (byte)-11;
	geoidSimple[31][63] = (byte)-13;
	geoidSimple[31][64] = (byte)-14;
	geoidSimple[31][65] = (byte)-16;
	geoidSimple[31][66] = (byte)-17;
	geoidSimple[31][67] = (byte)-19;
	geoidSimple[31][68] = (byte)-20;
	geoidSimple[31][69] = (byte)-21;
	geoidSimple[31][70] = (byte)-23;
	geoidSimple[31][71] = (byte)-24;
	geoidSimple[31][72] = (byte)-25;
	geoidSimple[31][73] = (byte)-27;
	geoidSimple[31][74] = (byte)-28;
	geoidSimple[31][75] = (byte)-28;
	geoidSimple[31][76] = (byte)-29;
	geoidSimple[31][77] = (byte)-30;
	geoidSimple[31][78] = (byte)-31;
	geoidSimple[31][79] = (byte)-32;
	geoidSimple[31][80] = (byte)-32;
	geoidSimple[31][81] = (byte)-33;
	geoidSimple[31][82] = (byte)-33;
	geoidSimple[31][83] = (byte)-34;
	geoidSimple[31][84] = (byte)-34;
	geoidSimple[31][85] = (byte)-34;
	geoidSimple[31][86] = (byte)-34;
	geoidSimple[31][87] = (byte)-35;
	geoidSimple[31][88] = (byte)-35;
	geoidSimple[31][89] = (byte)-36;
	geoidSimple[31][90] = (byte)-37;
	geoidSimple[31][91] = (byte)-37;
	geoidSimple[31][92] = (byte)-36;
	geoidSimple[31][93] = (byte)-34;
	geoidSimple[31][94] = (byte)-34;
	geoidSimple[31][95] = (byte)-35;
	geoidSimple[31][96] = (byte)-36;
	geoidSimple[31][97] = (byte)-36;
	geoidSimple[31][98] = (byte)-36;
	geoidSimple[31][99] = (byte)-37;
	geoidSimple[31][100] = (byte)-36;
	geoidSimple[31][101] = (byte)-36;
	geoidSimple[31][102] = (byte)-35;
	geoidSimple[31][103] = (byte)-33;
	geoidSimple[31][104] = (byte)-32;
	geoidSimple[31][105] = (byte)-32;
	geoidSimple[31][106] = (byte)-32;
	geoidSimple[31][107] = (byte)-31;
	geoidSimple[31][108] = (byte)-30;
	geoidSimple[31][109] = (byte)-29;
	geoidSimple[31][110] = (byte)-28;
	geoidSimple[31][111] = (byte)-27;
	geoidSimple[31][112] = (byte)-25;
	geoidSimple[31][113] = (byte)-22;
	geoidSimple[31][114] = (byte)-20;
	geoidSimple[31][115] = (byte)-18;
	geoidSimple[31][116] = (byte)-17;
	geoidSimple[31][117] = (byte)-17;
	geoidSimple[31][118] = (byte)-17;
	geoidSimple[31][119] = (byte)-15;
	geoidSimple[31][120] = (byte)-14;
	geoidSimple[31][121] = (byte)-12;
	geoidSimple[31][122] = (byte)-9;
	geoidSimple[31][123] = (byte)-6;
	geoidSimple[31][124] = (byte)-5;
	geoidSimple[31][125] = (byte)-3;
	geoidSimple[31][126] = (byte)-1;
	geoidSimple[31][127] = (byte)0;
	geoidSimple[31][128] = (byte)1;
	geoidSimple[31][129] = (byte)3;
	geoidSimple[31][130] = (byte)4;
	geoidSimple[31][131] = (byte)6;
	geoidSimple[31][132] = (byte)7;
	geoidSimple[31][133] = (byte)8;
	geoidSimple[31][134] = (byte)9;
	geoidSimple[31][135] = (byte)9;
	geoidSimple[31][136] = (byte)10;
	geoidSimple[31][137] = (byte)11;
	geoidSimple[31][138] = (byte)12;
	geoidSimple[31][139] = (byte)13;
	geoidSimple[31][140] = (byte)13;
	geoidSimple[31][141] = (byte)13;
	geoidSimple[31][142] = (byte)12;
	geoidSimple[31][143] = (byte)12;
	geoidSimple[31][144] = (byte)12;
	geoidSimple[31][145] = (byte)13;
	geoidSimple[31][146] = (byte)14;
	geoidSimple[31][147] = (byte)14;
	geoidSimple[31][148] = (byte)15;
	geoidSimple[31][149] = (byte)16;
	geoidSimple[31][150] = (byte)17;
	geoidSimple[31][151] = (byte)17;
	geoidSimple[31][152] = (byte)16;
	geoidSimple[31][153] = (byte)16;
	geoidSimple[31][154] = (byte)16;
	geoidSimple[31][155] = (byte)16;
	geoidSimple[31][156] = (byte)16;
	geoidSimple[31][157] = (byte)17;
	geoidSimple[31][158] = (byte)17;
	geoidSimple[31][159] = (byte)17;
	geoidSimple[31][160] = (byte)17;
	geoidSimple[31][161] = (byte)17;
	geoidSimple[31][162] = (byte)15;
	geoidSimple[31][163] = (byte)14;
	geoidSimple[31][164] = (byte)12;
	geoidSimple[31][165] = (byte)9;
	geoidSimple[31][166] = (byte)8;
	geoidSimple[31][167] = (byte)7;
	geoidSimple[31][168] = (byte)6;
	geoidSimple[31][169] = (byte)6;
	geoidSimple[31][170] = (byte)6;
	geoidSimple[31][171] = (byte)4;
	geoidSimple[31][172] = (byte)1;
	geoidSimple[31][173] = (byte)0;
	geoidSimple[31][174] = (byte)0;
	geoidSimple[31][175] = (byte)0;
	geoidSimple[31][176] = (byte)0;
	geoidSimple[31][177] = (byte)0;
	geoidSimple[31][178] = (byte)0;
	geoidSimple[31][179] = (byte)0;
	geoidSimple[31][LAT_GRID_SIZE] = (byte)0;
	geoidSimple[31][181] = (byte)1;
	geoidSimple[31][182] = (byte)3;
	geoidSimple[31][183] = (byte)4;
	geoidSimple[31][184] = (byte)6;
	geoidSimple[31][185] = (byte)6;
	geoidSimple[31][186] = (byte)7;
	geoidSimple[31][187] = (byte)8;
	geoidSimple[31][188] = (byte)9;
	geoidSimple[31][189] = (byte)9;
	geoidSimple[31][190] = (byte)10;
	geoidSimple[31][191] = (byte)10;
	geoidSimple[31][192] = (byte)11;
	geoidSimple[31][193] = (byte)12;
	geoidSimple[31][194] = (byte)12;
	geoidSimple[31][195] = (byte)13;
	geoidSimple[31][196] = (byte)13;
	geoidSimple[31][197] = (byte)14;
	geoidSimple[31][198] = (byte)15;
	geoidSimple[31][199] = (byte)15;
	geoidSimple[31][200] = (byte)15;
	geoidSimple[31][201] = (byte)15;
	geoidSimple[31][202] = (byte)15;
	geoidSimple[31][203] = (byte)15;
	geoidSimple[31][204] = (byte)15;
	geoidSimple[31][205] = (byte)14;
	geoidSimple[31][206] = (byte)12;
	geoidSimple[31][207] = (byte)11;
	geoidSimple[31][208] = (byte)10;
	geoidSimple[31][209] = (byte)11;
	geoidSimple[31][210] = (byte)12;
	geoidSimple[31][211] = (byte)12;
	geoidSimple[31][212] = (byte)10;
	geoidSimple[31][213] = (byte)7;
	geoidSimple[31][214] = (byte)6;
	geoidSimple[31][215] = (byte)6;
	geoidSimple[31][216] = (byte)6;
	geoidSimple[31][217] = (byte)6;
	geoidSimple[31][218] = (byte)5;
	geoidSimple[31][219] = (byte)6;
	geoidSimple[31][220] = (byte)5;
	geoidSimple[31][221] = (byte)5;
	geoidSimple[31][222] = (byte)6;
	geoidSimple[31][223] = (byte)6;
	geoidSimple[31][224] = (byte)4;
	geoidSimple[31][225] = (byte)4;
	geoidSimple[31][226] = (byte)3;
	geoidSimple[31][227] = (byte)2;
	geoidSimple[31][228] = (byte)1;
	geoidSimple[31][229] = (byte)0;
	geoidSimple[31][230] = (byte)0;
	geoidSimple[31][231] = (byte)-1;
	geoidSimple[31][232] = (byte)-3;
	geoidSimple[31][233] = (byte)-4;
	geoidSimple[31][234] = (byte)-5;
	geoidSimple[31][235] = (byte)-8;
	geoidSimple[31][236] = (byte)-10;
	geoidSimple[31][237] = (byte)-12;
	geoidSimple[31][238] = (byte)-14;
	geoidSimple[31][239] = (byte)-15;
	geoidSimple[31][240] = (byte)-16;
	geoidSimple[31][241] = (byte)-18;
	geoidSimple[31][242] = (byte)-19;
	geoidSimple[31][243] = (byte)-20;
	geoidSimple[31][244] = (byte)-21;
	geoidSimple[31][245] = (byte)-22;
	geoidSimple[31][246] = (byte)-25;
	geoidSimple[31][247] = (byte)-26;
	geoidSimple[31][248] = (byte)-28;
	geoidSimple[31][249] = (byte)-29;
	geoidSimple[31][250] = (byte)-30;
	geoidSimple[31][251] = (byte)-31;
	geoidSimple[31][252] = (byte)-32;
	geoidSimple[31][253] = (byte)-33;
	geoidSimple[31][254] = (byte)-33;
	geoidSimple[31][255] = (byte)-34;
	geoidSimple[31][256] = (byte)-34;
	geoidSimple[31][257] = (byte)-36;
	geoidSimple[31][258] = (byte)-37;
	geoidSimple[31][259] = (byte)-38;
	geoidSimple[31][260] = (byte)-40;
	geoidSimple[31][261] = (byte)-41;
	geoidSimple[31][262] = (byte)-43;
	geoidSimple[31][263] = (byte)-44;
	geoidSimple[31][264] = (byte)-46;
	geoidSimple[31][265] = (byte)-47;
	geoidSimple[31][266] = (byte)-48;
	geoidSimple[31][267] = (byte)-48;
	geoidSimple[31][268] = (byte)-48;
	geoidSimple[31][269] = (byte)-48;
	geoidSimple[31][270] = (byte)-48;
	geoidSimple[31][271] = (byte)-48;
	geoidSimple[31][272] = (byte)-48;
	geoidSimple[31][273] = (byte)-48;
	geoidSimple[31][274] = (byte)-47;
	geoidSimple[31][275] = (byte)-46;
	geoidSimple[31][276] = (byte)-46;
	geoidSimple[31][277] = (byte)-46;
	geoidSimple[31][278] = (byte)-44;
	geoidSimple[31][279] = (byte)-44;
	geoidSimple[31][280] = (byte)-43;
	geoidSimple[31][281] = (byte)-41;
	geoidSimple[31][282] = (byte)-38;
	geoidSimple[31][283] = (byte)-36;
	geoidSimple[31][284] = (byte)-34;
	geoidSimple[31][285] = (byte)-32;
	geoidSimple[31][286] = (byte)-31;
	geoidSimple[31][287] = (byte)-29;
	geoidSimple[31][288] = (byte)-28;
	geoidSimple[31][289] = (byte)-27;
	geoidSimple[31][290] = (byte)-26;
	geoidSimple[31][291] = (byte)-23;
	geoidSimple[31][292] = (byte)-20;
	geoidSimple[31][293] = (byte)-17;
	geoidSimple[31][294] = (byte)-13;
	geoidSimple[31][295] = (byte)-10;
	geoidSimple[31][296] = (byte)-7;
	geoidSimple[31][297] = (byte)-5;
	geoidSimple[31][298] = (byte)-1;
	geoidSimple[31][299] = (byte)2;
	geoidSimple[31][300] = (byte)4;
	geoidSimple[31][301] = (byte)5;
	geoidSimple[31][302] = (byte)7;
	geoidSimple[31][303] = (byte)10;
	geoidSimple[31][304] = (byte)13;
	geoidSimple[31][305] = (byte)15;
	geoidSimple[31][306] = (byte)18;
	geoidSimple[31][307] = (byte)21;
	geoidSimple[31][308] = (byte)23;
	geoidSimple[31][309] = (byte)26;
	geoidSimple[31][310] = (byte)28;
	geoidSimple[31][311] = (byte)31;
	geoidSimple[31][312] = (byte)34;
	geoidSimple[31][313] = (byte)36;
	geoidSimple[31][314] = (byte)38;
	geoidSimple[31][315] = (byte)41;
	geoidSimple[31][316] = (byte)43;
	geoidSimple[31][317] = (byte)45;
	geoidSimple[31][318] = (byte)46;
	geoidSimple[31][319] = (byte)47;
	geoidSimple[31][320] = (byte)49;
	geoidSimple[31][321] = (byte)50;
	geoidSimple[31][322] = (byte)52;
	geoidSimple[31][323] = (byte)54;
	geoidSimple[31][324] = (byte)56;
	geoidSimple[31][325] = (byte)58;
	geoidSimple[31][326] = (byte)60;
	geoidSimple[31][327] = (byte)61;
	geoidSimple[31][328] = (byte)62;
	geoidSimple[31][329] = (byte)63;
	geoidSimple[31][330] = (byte)63;
	geoidSimple[31][331] = (byte)63;
	geoidSimple[31][332] = (byte)63;
	geoidSimple[31][333] = (byte)62;
	geoidSimple[31][334] = (byte)62;
	geoidSimple[31][335] = (byte)61;
	geoidSimple[31][336] = (byte)61;
	geoidSimple[31][337] = (byte)60;
	geoidSimple[31][338] = (byte)60;
	geoidSimple[31][339] = (byte)60;
	geoidSimple[31][340] = (byte)60;
	geoidSimple[31][341] = (byte)60;
	geoidSimple[31][342] = (byte)60;
	geoidSimple[31][343] = (byte)59;
	geoidSimple[31][344] = (byte)58;
	geoidSimple[31][345] = (byte)58;
	geoidSimple[31][346] = (byte)57;
	geoidSimple[31][347] = (byte)56;
	geoidSimple[31][348] = (byte)55;
	geoidSimple[31][349] = (byte)55;
	geoidSimple[31][350] = (byte)55;
	geoidSimple[31][351] = (byte)56;
	geoidSimple[31][352] = (byte)56;
	geoidSimple[31][353] = (byte)56;
	geoidSimple[31][354] = (byte)55;
	geoidSimple[31][355] = (byte)54;
	geoidSimple[31][356] = (byte)52;
	geoidSimple[31][357] = (byte)50;
	geoidSimple[31][358] = (byte)49;
	geoidSimple[31][359] = (byte)48;
	}
		/** Row 32*/
	private static void init32() {
	geoidSimple[32][0] = (byte)47;
	geoidSimple[32][1] = (byte)46;
	geoidSimple[32][2] = (byte)45;
	geoidSimple[32][3] = (byte)43;
	geoidSimple[32][4] = (byte)43;
	geoidSimple[32][5] = (byte)42;
	geoidSimple[32][6] = (byte)41;
	geoidSimple[32][7] = (byte)41;
	geoidSimple[32][8] = (byte)39;
	geoidSimple[32][9] = (byte)38;
	geoidSimple[32][10] = (byte)38;
	geoidSimple[32][11] = (byte)36;
	geoidSimple[32][12] = (byte)35;
	geoidSimple[32][13] = (byte)34;
	geoidSimple[32][14] = (byte)32;
	geoidSimple[32][15] = (byte)31;
	geoidSimple[32][16] = (byte)28;
	geoidSimple[32][17] = (byte)26;
	geoidSimple[32][18] = (byte)24;
	geoidSimple[32][19] = (byte)22;
	geoidSimple[32][20] = (byte)21;
	geoidSimple[32][21] = (byte)20;
	geoidSimple[32][22] = (byte)20;
	geoidSimple[32][23] = (byte)19;
	geoidSimple[32][24] = (byte)19;
	geoidSimple[32][25] = (byte)19;
	geoidSimple[32][26] = (byte)20;
	geoidSimple[32][27] = (byte)19;
	geoidSimple[32][28] = (byte)18;
	geoidSimple[32][29] = (byte)17;
	geoidSimple[32][30] = (byte)16;
	geoidSimple[32][31] = (byte)15;
	geoidSimple[32][32] = (byte)15;
	geoidSimple[32][33] = (byte)15;
	geoidSimple[32][34] = (byte)15;
	geoidSimple[32][35] = (byte)14;
	geoidSimple[32][36] = (byte)13;
	geoidSimple[32][37] = (byte)13;
	geoidSimple[32][38] = (byte)13;
	geoidSimple[32][39] = (byte)12;
	geoidSimple[32][40] = (byte)11;
	geoidSimple[32][41] = (byte)10;
	geoidSimple[32][42] = (byte)9;
	geoidSimple[32][43] = (byte)9;
	geoidSimple[32][44] = (byte)8;
	geoidSimple[32][45] = (byte)9;
	geoidSimple[32][46] = (byte)8;
	geoidSimple[32][47] = (byte)7;
	geoidSimple[32][48] = (byte)6;
	geoidSimple[32][49] = (byte)5;
	geoidSimple[32][50] = (byte)3;
	geoidSimple[32][51] = (byte)2;
	geoidSimple[32][52] = (byte)1;
	geoidSimple[32][53] = (byte)0;
	geoidSimple[32][54] = (byte)-2;
	geoidSimple[32][55] = (byte)-3;
	geoidSimple[32][56] = (byte)-3;
	geoidSimple[32][57] = (byte)-4;
	geoidSimple[32][58] = (byte)-5;
	geoidSimple[32][59] = (byte)-5;
	geoidSimple[32][60] = (byte)-6;
	geoidSimple[32][61] = (byte)-10;
	geoidSimple[32][62] = (byte)-12;
	geoidSimple[32][63] = (byte)-14;
	geoidSimple[32][64] = (byte)-16;
	geoidSimple[32][65] = (byte)-17;
	geoidSimple[32][66] = (byte)-19;
	geoidSimple[32][67] = (byte)-20;
	geoidSimple[32][68] = (byte)-22;
	geoidSimple[32][69] = (byte)-23;
	geoidSimple[32][70] = (byte)-24;
	geoidSimple[32][71] = (byte)-25;
	geoidSimple[32][72] = (byte)-26;
	geoidSimple[32][73] = (byte)-28;
	geoidSimple[32][74] = (byte)-29;
	geoidSimple[32][75] = (byte)-29;
	geoidSimple[32][76] = (byte)-30;
	geoidSimple[32][77] = (byte)-31;
	geoidSimple[32][78] = (byte)-32;
	geoidSimple[32][79] = (byte)-33;
	geoidSimple[32][80] = (byte)-33;
	geoidSimple[32][81] = (byte)-34;
	geoidSimple[32][82] = (byte)-34;
	geoidSimple[32][83] = (byte)-35;
	geoidSimple[32][84] = (byte)-36;
	geoidSimple[32][85] = (byte)-36;
	geoidSimple[32][86] = (byte)-35;
	geoidSimple[32][87] = (byte)-36;
	geoidSimple[32][88] = (byte)-36;
	geoidSimple[32][89] = (byte)-37;
	geoidSimple[32][90] = (byte)-37;
	geoidSimple[32][91] = (byte)-38;
	geoidSimple[32][92] = (byte)-37;
	geoidSimple[32][93] = (byte)-37;
	geoidSimple[32][94] = (byte)-38;
	geoidSimple[32][95] = (byte)-39;
	geoidSimple[32][96] = (byte)-39;
	geoidSimple[32][97] = (byte)-40;
	geoidSimple[32][98] = (byte)-40;
	geoidSimple[32][99] = (byte)-39;
	geoidSimple[32][100] = (byte)-38;
	geoidSimple[32][101] = (byte)-37;
	geoidSimple[32][102] = (byte)-35;
	geoidSimple[32][103] = (byte)-34;
	geoidSimple[32][104] = (byte)-34;
	geoidSimple[32][105] = (byte)-34;
	geoidSimple[32][106] = (byte)-33;
	geoidSimple[32][107] = (byte)-33;
	geoidSimple[32][108] = (byte)-32;
	geoidSimple[32][109] = (byte)-30;
	geoidSimple[32][110] = (byte)-27;
	geoidSimple[32][111] = (byte)-24;
	geoidSimple[32][112] = (byte)-22;
	geoidSimple[32][113] = (byte)-21;
	geoidSimple[32][114] = (byte)-20;
	geoidSimple[32][115] = (byte)-18;
	geoidSimple[32][116] = (byte)-16;
	geoidSimple[32][117] = (byte)-14;
	geoidSimple[32][118] = (byte)-14;
	geoidSimple[32][119] = (byte)-12;
	geoidSimple[32][120] = (byte)-11;
	geoidSimple[32][121] = (byte)-9;
	geoidSimple[32][122] = (byte)-7;
	geoidSimple[32][123] = (byte)-5;
	geoidSimple[32][124] = (byte)-3;
	geoidSimple[32][125] = (byte)0;
	geoidSimple[32][126] = (byte)1;
	geoidSimple[32][127] = (byte)3;
	geoidSimple[32][128] = (byte)5;
	geoidSimple[32][129] = (byte)6;
	geoidSimple[32][130] = (byte)7;
	geoidSimple[32][131] = (byte)9;
	geoidSimple[32][132] = (byte)10;
	geoidSimple[32][133] = (byte)10;
	geoidSimple[32][134] = (byte)11;
	geoidSimple[32][135] = (byte)11;
	geoidSimple[32][136] = (byte)12;
	geoidSimple[32][137] = (byte)13;
	geoidSimple[32][138] = (byte)14;
	geoidSimple[32][139] = (byte)14;
	geoidSimple[32][140] = (byte)14;
	geoidSimple[32][141] = (byte)13;
	geoidSimple[32][142] = (byte)13;
	geoidSimple[32][143] = (byte)14;
	geoidSimple[32][144] = (byte)14;
	geoidSimple[32][145] = (byte)15;
	geoidSimple[32][146] = (byte)15;
	geoidSimple[32][147] = (byte)16;
	geoidSimple[32][148] = (byte)16;
	geoidSimple[32][149] = (byte)16;
	geoidSimple[32][150] = (byte)16;
	geoidSimple[32][151] = (byte)16;
	geoidSimple[32][152] = (byte)16;
	geoidSimple[32][153] = (byte)16;
	geoidSimple[32][154] = (byte)16;
	geoidSimple[32][155] = (byte)17;
	geoidSimple[32][156] = (byte)18;
	geoidSimple[32][157] = (byte)19;
	geoidSimple[32][158] = (byte)19;
	geoidSimple[32][159] = (byte)18;
	geoidSimple[32][160] = (byte)19;
	geoidSimple[32][161] = (byte)18;
	geoidSimple[32][162] = (byte)16;
	geoidSimple[32][163] = (byte)13;
	geoidSimple[32][164] = (byte)11;
	geoidSimple[32][165] = (byte)10;
	geoidSimple[32][166] = (byte)9;
	geoidSimple[32][167] = (byte)8;
	geoidSimple[32][168] = (byte)6;
	geoidSimple[32][169] = (byte)6;
	geoidSimple[32][170] = (byte)6;
	geoidSimple[32][171] = (byte)4;
	geoidSimple[32][172] = (byte)2;
	geoidSimple[32][173] = (byte)1;
	geoidSimple[32][174] = (byte)1;
	geoidSimple[32][175] = (byte)1;
	geoidSimple[32][176] = (byte)1;
	geoidSimple[32][177] = (byte)0;
	geoidSimple[32][178] = (byte)1;
	geoidSimple[32][179] = (byte)1;
	geoidSimple[32][LAT_GRID_SIZE] = (byte)1;
	geoidSimple[32][181] = (byte)1;
	geoidSimple[32][182] = (byte)1;
	geoidSimple[32][183] = (byte)2;
	geoidSimple[32][184] = (byte)3;
	geoidSimple[32][185] = (byte)4;
	geoidSimple[32][186] = (byte)8;
	geoidSimple[32][187] = (byte)9;
	geoidSimple[32][188] = (byte)10;
	geoidSimple[32][189] = (byte)10;
	geoidSimple[32][190] = (byte)11;
	geoidSimple[32][191] = (byte)11;
	geoidSimple[32][192] = (byte)12;
	geoidSimple[32][193] = (byte)12;
	geoidSimple[32][194] = (byte)13;
	geoidSimple[32][195] = (byte)14;
	geoidSimple[32][196] = (byte)14;
	geoidSimple[32][197] = (byte)14;
	geoidSimple[32][198] = (byte)15;
	geoidSimple[32][199] = (byte)15;
	geoidSimple[32][200] = (byte)14;
	geoidSimple[32][201] = (byte)14;
	geoidSimple[32][202] = (byte)15;
	geoidSimple[32][203] = (byte)15;
	geoidSimple[32][204] = (byte)13;
	geoidSimple[32][205] = (byte)13;
	geoidSimple[32][206] = (byte)13;
	geoidSimple[32][207] = (byte)13;
	geoidSimple[32][208] = (byte)13;
	geoidSimple[32][209] = (byte)14;
	geoidSimple[32][210] = (byte)12;
	geoidSimple[32][211] = (byte)10;
	geoidSimple[32][212] = (byte)7;
	geoidSimple[32][213] = (byte)6;
	geoidSimple[32][214] = (byte)7;
	geoidSimple[32][215] = (byte)7;
	geoidSimple[32][216] = (byte)7;
	geoidSimple[32][217] = (byte)6;
	geoidSimple[32][218] = (byte)4;
	geoidSimple[32][219] = (byte)3;
	geoidSimple[32][220] = (byte)2;
	geoidSimple[32][221] = (byte)1;
	geoidSimple[32][222] = (byte)0;
	geoidSimple[32][223] = (byte)2;
	geoidSimple[32][224] = (byte)3;
	geoidSimple[32][225] = (byte)1;
	geoidSimple[32][226] = (byte)1;
	geoidSimple[32][227] = (byte)1;
	geoidSimple[32][228] = (byte)1;
	geoidSimple[32][229] = (byte)0;
	geoidSimple[32][230] = (byte)0;
	geoidSimple[32][231] = (byte)-1;
	geoidSimple[32][232] = (byte)-3;
	geoidSimple[32][233] = (byte)-4;
	geoidSimple[32][234] = (byte)-6;
	geoidSimple[32][235] = (byte)-7;
	geoidSimple[32][236] = (byte)-9;
	geoidSimple[32][237] = (byte)-11;
	geoidSimple[32][238] = (byte)-13;
	geoidSimple[32][239] = (byte)-14;
	geoidSimple[32][240] = (byte)-15;
	geoidSimple[32][241] = (byte)-16;
	geoidSimple[32][242] = (byte)-18;
	geoidSimple[32][243] = (byte)-20;
	geoidSimple[32][244] = (byte)-21;
	geoidSimple[32][245] = (byte)-22;
	geoidSimple[32][246] = (byte)-23;
	geoidSimple[32][247] = (byte)-24;
	geoidSimple[32][248] = (byte)-26;
	geoidSimple[32][249] = (byte)-27;
	geoidSimple[32][250] = (byte)-28;
	geoidSimple[32][251] = (byte)-29;
	geoidSimple[32][252] = (byte)-30;
	geoidSimple[32][253] = (byte)-31;
	geoidSimple[32][254] = (byte)-31;
	geoidSimple[32][255] = (byte)-32;
	geoidSimple[32][256] = (byte)-33;
	geoidSimple[32][257] = (byte)-34;
	geoidSimple[32][258] = (byte)-35;
	geoidSimple[32][259] = (byte)-36;
	geoidSimple[32][260] = (byte)-37;
	geoidSimple[32][261] = (byte)-39;
	geoidSimple[32][262] = (byte)-41;
	geoidSimple[32][263] = (byte)-42;
	geoidSimple[32][264] = (byte)-43;
	geoidSimple[32][265] = (byte)-44;
	geoidSimple[32][266] = (byte)-46;
	geoidSimple[32][267] = (byte)-47;
	geoidSimple[32][268] = (byte)-47;
	geoidSimple[32][269] = (byte)-47;
	geoidSimple[32][270] = (byte)-48;
	geoidSimple[32][271] = (byte)-48;
	geoidSimple[32][272] = (byte)-48;
	geoidSimple[32][273] = (byte)-48;
	geoidSimple[32][274] = (byte)-48;
	geoidSimple[32][275] = (byte)-47;
	geoidSimple[32][276] = (byte)-47;
	geoidSimple[32][277] = (byte)-46;
	geoidSimple[32][278] = (byte)-45;
	geoidSimple[32][279] = (byte)-44;
	geoidSimple[32][280] = (byte)-43;
	geoidSimple[32][281] = (byte)-42;
	geoidSimple[32][282] = (byte)-40;
	geoidSimple[32][283] = (byte)-38;
	geoidSimple[32][284] = (byte)-36;
	geoidSimple[32][285] = (byte)-35;
	geoidSimple[32][286] = (byte)-33;
	geoidSimple[32][287] = (byte)-31;
	geoidSimple[32][288] = (byte)-29;
	geoidSimple[32][289] = (byte)-28;
	geoidSimple[32][290] = (byte)-27;
	geoidSimple[32][291] = (byte)-24;
	geoidSimple[32][292] = (byte)-21;
	geoidSimple[32][293] = (byte)-18;
	geoidSimple[32][294] = (byte)-14;
	geoidSimple[32][295] = (byte)-11;
	geoidSimple[32][296] = (byte)-9;
	geoidSimple[32][297] = (byte)-8;
	geoidSimple[32][298] = (byte)-6;
	geoidSimple[32][299] = (byte)-2;
	geoidSimple[32][300] = (byte)3;
	geoidSimple[32][301] = (byte)4;
	geoidSimple[32][302] = (byte)6;
	geoidSimple[32][303] = (byte)9;
	geoidSimple[32][304] = (byte)12;
	geoidSimple[32][305] = (byte)14;
	geoidSimple[32][306] = (byte)17;
	geoidSimple[32][307] = (byte)19;
	geoidSimple[32][308] = (byte)22;
	geoidSimple[32][309] = (byte)25;
	geoidSimple[32][310] = (byte)27;
	geoidSimple[32][311] = (byte)30;
	geoidSimple[32][312] = (byte)33;
	geoidSimple[32][313] = (byte)35;
	geoidSimple[32][314] = (byte)38;
	geoidSimple[32][315] = (byte)40;
	geoidSimple[32][316] = (byte)42;
	geoidSimple[32][317] = (byte)44;
	geoidSimple[32][318] = (byte)46;
	geoidSimple[32][319] = (byte)47;
	geoidSimple[32][320] = (byte)49;
	geoidSimple[32][321] = (byte)51;
	geoidSimple[32][322] = (byte)53;
	geoidSimple[32][323] = (byte)55;
	geoidSimple[32][324] = (byte)57;
	geoidSimple[32][325] = (byte)59;
	geoidSimple[32][326] = (byte)61;
	geoidSimple[32][327] = (byte)62;
	geoidSimple[32][328] = (byte)62;
	geoidSimple[32][329] = (byte)62;
	geoidSimple[32][330] = (byte)62;
	geoidSimple[32][331] = (byte)62;
	geoidSimple[32][332] = (byte)61;
	geoidSimple[32][333] = (byte)61;
	geoidSimple[32][334] = (byte)61;
	geoidSimple[32][335] = (byte)61;
	geoidSimple[32][336] = (byte)60;
	geoidSimple[32][337] = (byte)60;
	geoidSimple[32][338] = (byte)61;
	geoidSimple[32][339] = (byte)61;
	geoidSimple[32][340] = (byte)61;
	geoidSimple[32][341] = (byte)60;
	geoidSimple[32][342] = (byte)59;
	geoidSimple[32][343] = (byte)59;
	geoidSimple[32][344] = (byte)59;
	geoidSimple[32][345] = (byte)60;
	geoidSimple[32][346] = (byte)59;
	geoidSimple[32][347] = (byte)56;
	geoidSimple[32][348] = (byte)56;
	geoidSimple[32][349] = (byte)55;
	geoidSimple[32][350] = (byte)56;
	geoidSimple[32][351] = (byte)58;
	geoidSimple[32][352] = (byte)57;
	geoidSimple[32][353] = (byte)56;
	geoidSimple[32][354] = (byte)55;
	geoidSimple[32][355] = (byte)54;
	geoidSimple[32][356] = (byte)52;
	geoidSimple[32][357] = (byte)50;
	geoidSimple[32][358] = (byte)49;
	geoidSimple[32][359] = (byte)48;
	}
		/** Row 33*/
	private static void init33() {
	geoidSimple[33][0] = (byte)46;
	geoidSimple[33][1] = (byte)45;
	geoidSimple[33][2] = (byte)45;
	geoidSimple[33][3] = (byte)43;
	geoidSimple[33][4] = (byte)42;
	geoidSimple[33][5] = (byte)42;
	geoidSimple[33][6] = (byte)41;
	geoidSimple[33][7] = (byte)40;
	geoidSimple[33][8] = (byte)40;
	geoidSimple[33][9] = (byte)39;
	geoidSimple[33][10] = (byte)38;
	geoidSimple[33][11] = (byte)37;
	geoidSimple[33][12] = (byte)37;
	geoidSimple[33][13] = (byte)35;
	geoidSimple[33][14] = (byte)33;
	geoidSimple[33][15] = (byte)32;
	geoidSimple[33][16] = (byte)30;
	geoidSimple[33][17] = (byte)28;
	geoidSimple[33][18] = (byte)26;
	geoidSimple[33][19] = (byte)24;
	geoidSimple[33][20] = (byte)23;
	geoidSimple[33][21] = (byte)23;
	geoidSimple[33][22] = (byte)22;
	geoidSimple[33][23] = (byte)22;
	geoidSimple[33][24] = (byte)21;
	geoidSimple[33][25] = (byte)21;
	geoidSimple[33][26] = (byte)20;
	geoidSimple[33][27] = (byte)19;
	geoidSimple[33][28] = (byte)19;
	geoidSimple[33][29] = (byte)18;
	geoidSimple[33][30] = (byte)17;
	geoidSimple[33][31] = (byte)16;
	geoidSimple[33][32] = (byte)16;
	geoidSimple[33][33] = (byte)16;
	geoidSimple[33][34] = (byte)15;
	geoidSimple[33][35] = (byte)14;
	geoidSimple[33][36] = (byte)13;
	geoidSimple[33][37] = (byte)14;
	geoidSimple[33][38] = (byte)13;
	geoidSimple[33][39] = (byte)12;
	geoidSimple[33][40] = (byte)11;
	geoidSimple[33][41] = (byte)9;
	geoidSimple[33][42] = (byte)8;
	geoidSimple[33][43] = (byte)8;
	geoidSimple[33][44] = (byte)8;
	geoidSimple[33][45] = (byte)7;
	geoidSimple[33][46] = (byte)6;
	geoidSimple[33][47] = (byte)6;
	geoidSimple[33][48] = (byte)5;
	geoidSimple[33][49] = (byte)4;
	geoidSimple[33][50] = (byte)2;
	geoidSimple[33][51] = (byte)1;
	geoidSimple[33][52] = (byte)0;
	geoidSimple[33][53] = (byte)-2;
	geoidSimple[33][54] = (byte)-4;
	geoidSimple[33][55] = (byte)-5;
	geoidSimple[33][56] = (byte)-5;
	geoidSimple[33][57] = (byte)-5;
	geoidSimple[33][58] = (byte)-6;
	geoidSimple[33][59] = (byte)-6;
	geoidSimple[33][60] = (byte)-8;
	geoidSimple[33][61] = (byte)-11;
	geoidSimple[33][62] = (byte)-13;
	geoidSimple[33][63] = (byte)-15;
	geoidSimple[33][64] = (byte)-17;
	geoidSimple[33][65] = (byte)-18;
	geoidSimple[33][66] = (byte)-20;
	geoidSimple[33][67] = (byte)-21;
	geoidSimple[33][68] = (byte)-22;
	geoidSimple[33][69] = (byte)-24;
	geoidSimple[33][70] = (byte)-25;
	geoidSimple[33][71] = (byte)-27;
	geoidSimple[33][72] = (byte)-28;
	geoidSimple[33][73] = (byte)-29;
	geoidSimple[33][74] = (byte)-30;
	geoidSimple[33][75] = (byte)-30;
	geoidSimple[33][76] = (byte)-31;
	geoidSimple[33][77] = (byte)-33;
	geoidSimple[33][78] = (byte)-33;
	geoidSimple[33][79] = (byte)-34;
	geoidSimple[33][80] = (byte)-34;
	geoidSimple[33][81] = (byte)-34;
	geoidSimple[33][82] = (byte)-35;
	geoidSimple[33][83] = (byte)-35;
	geoidSimple[33][84] = (byte)-36;
	geoidSimple[33][85] = (byte)-36;
	geoidSimple[33][86] = (byte)-36;
	geoidSimple[33][87] = (byte)-37;
	geoidSimple[33][88] = (byte)-38;
	geoidSimple[33][89] = (byte)-38;
	geoidSimple[33][90] = (byte)-38;
	geoidSimple[33][91] = (byte)-38;
	geoidSimple[33][92] = (byte)-39;
	geoidSimple[33][93] = (byte)-39;
	geoidSimple[33][94] = (byte)-38;
	geoidSimple[33][95] = (byte)-40;
	geoidSimple[33][96] = (byte)-40;
	geoidSimple[33][97] = (byte)-40;
	geoidSimple[33][98] = (byte)-40;
	geoidSimple[33][99] = (byte)-40;
	geoidSimple[33][100] = (byte)-38;
	geoidSimple[33][101] = (byte)-37;
	geoidSimple[33][102] = (byte)-36;
	geoidSimple[33][103] = (byte)-35;
	geoidSimple[33][104] = (byte)-35;
	geoidSimple[33][105] = (byte)-34;
	geoidSimple[33][106] = (byte)-33;
	geoidSimple[33][107] = (byte)-33;
	geoidSimple[33][108] = (byte)-31;
	geoidSimple[33][109] = (byte)-27;
	geoidSimple[33][110] = (byte)-25;
	geoidSimple[33][111] = (byte)-25;
	geoidSimple[33][112] = (byte)-24;
	geoidSimple[33][113] = (byte)-22;
	geoidSimple[33][114] = (byte)-21;
	geoidSimple[33][115] = (byte)-18;
	geoidSimple[33][116] = (byte)-16;
	geoidSimple[33][117] = (byte)-13;
	geoidSimple[33][118] = (byte)-12;
	geoidSimple[33][119] = (byte)-10;
	geoidSimple[33][120] = (byte)-8;
	geoidSimple[33][121] = (byte)-8;
	geoidSimple[33][122] = (byte)-6;
	geoidSimple[33][123] = (byte)-3;
	geoidSimple[33][124] = (byte)-2;
	geoidSimple[33][125] = (byte)0;
	geoidSimple[33][126] = (byte)2;
	geoidSimple[33][127] = (byte)4;
	geoidSimple[33][128] = (byte)6;
	geoidSimple[33][129] = (byte)8;
	geoidSimple[33][130] = (byte)9;
	geoidSimple[33][131] = (byte)10;
	geoidSimple[33][132] = (byte)11;
	geoidSimple[33][133] = (byte)12;
	geoidSimple[33][134] = (byte)12;
	geoidSimple[33][135] = (byte)13;
	geoidSimple[33][136] = (byte)14;
	geoidSimple[33][137] = (byte)15;
	geoidSimple[33][138] = (byte)14;
	geoidSimple[33][139] = (byte)14;
	geoidSimple[33][140] = (byte)14;
	geoidSimple[33][141] = (byte)14;
	geoidSimple[33][142] = (byte)14;
	geoidSimple[33][143] = (byte)15;
	geoidSimple[33][144] = (byte)15;
	geoidSimple[33][145] = (byte)16;
	geoidSimple[33][146] = (byte)17;
	geoidSimple[33][147] = (byte)17;
	geoidSimple[33][148] = (byte)17;
	geoidSimple[33][149] = (byte)18;
	geoidSimple[33][150] = (byte)18;
	geoidSimple[33][151] = (byte)17;
	geoidSimple[33][152] = (byte)17;
	geoidSimple[33][153] = (byte)16;
	geoidSimple[33][154] = (byte)17;
	geoidSimple[33][155] = (byte)19;
	geoidSimple[33][156] = (byte)20;
	geoidSimple[33][157] = (byte)21;
	geoidSimple[33][158] = (byte)21;
	geoidSimple[33][159] = (byte)21;
	geoidSimple[33][160] = (byte)20;
	geoidSimple[33][161] = (byte)18;
	geoidSimple[33][162] = (byte)15;
	geoidSimple[33][163] = (byte)12;
	geoidSimple[33][164] = (byte)9;
	geoidSimple[33][165] = (byte)9;
	geoidSimple[33][166] = (byte)9;
	geoidSimple[33][167] = (byte)8;
	geoidSimple[33][168] = (byte)7;
	geoidSimple[33][169] = (byte)6;
	geoidSimple[33][170] = (byte)5;
	geoidSimple[33][171] = (byte)4;
	geoidSimple[33][172] = (byte)2;
	geoidSimple[33][173] = (byte)2;
	geoidSimple[33][174] = (byte)1;
	geoidSimple[33][175] = (byte)0;
	geoidSimple[33][176] = (byte)0;
	geoidSimple[33][177] = (byte)0;
	geoidSimple[33][178] = (byte)1;
	geoidSimple[33][179] = (byte)1;
	geoidSimple[33][LAT_GRID_SIZE] = (byte)1;
	geoidSimple[33][181] = (byte)2;
	geoidSimple[33][182] = (byte)2;
	geoidSimple[33][183] = (byte)2;
	geoidSimple[33][184] = (byte)2;
	geoidSimple[33][185] = (byte)2;
	geoidSimple[33][186] = (byte)5;
	geoidSimple[33][187] = (byte)8;
	geoidSimple[33][188] = (byte)9;
	geoidSimple[33][189] = (byte)11;
	geoidSimple[33][190] = (byte)12;
	geoidSimple[33][191] = (byte)12;
	geoidSimple[33][192] = (byte)12;
	geoidSimple[33][193] = (byte)13;
	geoidSimple[33][194] = (byte)13;
	geoidSimple[33][195] = (byte)14;
	geoidSimple[33][196] = (byte)14;
	geoidSimple[33][197] = (byte)14;
	geoidSimple[33][198] = (byte)14;
	geoidSimple[33][199] = (byte)14;
	geoidSimple[33][200] = (byte)15;
	geoidSimple[33][201] = (byte)15;
	geoidSimple[33][202] = (byte)15;
	geoidSimple[33][203] = (byte)12;
	geoidSimple[33][204] = (byte)11;
	geoidSimple[33][205] = (byte)12;
	geoidSimple[33][206] = (byte)13;
	geoidSimple[33][207] = (byte)13;
	geoidSimple[33][208] = (byte)11;
	geoidSimple[33][209] = (byte)9;
	geoidSimple[33][210] = (byte)8;
	geoidSimple[33][211] = (byte)8;
	geoidSimple[33][212] = (byte)8;
	geoidSimple[33][213] = (byte)8;
	geoidSimple[33][214] = (byte)8;
	geoidSimple[33][215] = (byte)7;
	geoidSimple[33][216] = (byte)6;
	geoidSimple[33][217] = (byte)5;
	geoidSimple[33][218] = (byte)4;
	geoidSimple[33][219] = (byte)3;
	geoidSimple[33][220] = (byte)1;
	geoidSimple[33][221] = (byte)0;
	geoidSimple[33][222] = (byte)0;
	geoidSimple[33][223] = (byte)-1;
	geoidSimple[33][224] = (byte)0;
	geoidSimple[33][225] = (byte)1;
	geoidSimple[33][226] = (byte)0;
	geoidSimple[33][227] = (byte)0;
	geoidSimple[33][228] = (byte)0;
	geoidSimple[33][229] = (byte)0;
	geoidSimple[33][230] = (byte)-2;
	geoidSimple[33][231] = (byte)-4;
	geoidSimple[33][232] = (byte)-5;
	geoidSimple[33][233] = (byte)-5;
	geoidSimple[33][234] = (byte)-7;
	geoidSimple[33][235] = (byte)-8;
	geoidSimple[33][236] = (byte)-9;
	geoidSimple[33][237] = (byte)-11;
	geoidSimple[33][238] = (byte)-12;
	geoidSimple[33][239] = (byte)-14;
	geoidSimple[33][240] = (byte)-14;
	geoidSimple[33][241] = (byte)-16;
	geoidSimple[33][242] = (byte)-18;
	geoidSimple[33][243] = (byte)-19;
	geoidSimple[33][244] = (byte)-20;
	geoidSimple[33][245] = (byte)-21;
	geoidSimple[33][246] = (byte)-22;
	geoidSimple[33][247] = (byte)-23;
	geoidSimple[33][248] = (byte)-25;
	geoidSimple[33][249] = (byte)-26;
	geoidSimple[33][250] = (byte)-28;
	geoidSimple[33][251] = (byte)-29;
	geoidSimple[33][252] = (byte)-29;
	geoidSimple[33][253] = (byte)-29;
	geoidSimple[33][254] = (byte)-29;
	geoidSimple[33][255] = (byte)-30;
	geoidSimple[33][256] = (byte)-31;
	geoidSimple[33][257] = (byte)-32;
	geoidSimple[33][258] = (byte)-33;
	geoidSimple[33][259] = (byte)-34;
	geoidSimple[33][260] = (byte)-36;
	geoidSimple[33][261] = (byte)-37;
	geoidSimple[33][262] = (byte)-38;
	geoidSimple[33][263] = (byte)-40;
	geoidSimple[33][264] = (byte)-41;
	geoidSimple[33][265] = (byte)-42;
	geoidSimple[33][266] = (byte)-44;
	geoidSimple[33][267] = (byte)-45;
	geoidSimple[33][268] = (byte)-45;
	geoidSimple[33][269] = (byte)-46;
	geoidSimple[33][270] = (byte)-47;
	geoidSimple[33][271] = (byte)-48;
	geoidSimple[33][272] = (byte)-48;
	geoidSimple[33][273] = (byte)-48;
	geoidSimple[33][274] = (byte)-48;
	geoidSimple[33][275] = (byte)-48;
	geoidSimple[33][276] = (byte)-47;
	geoidSimple[33][277] = (byte)-47;
	geoidSimple[33][278] = (byte)-46;
	geoidSimple[33][279] = (byte)-44;
	geoidSimple[33][280] = (byte)-43;
	geoidSimple[33][281] = (byte)-43;
	geoidSimple[33][282] = (byte)-41;
	geoidSimple[33][283] = (byte)-40;
	geoidSimple[33][284] = (byte)-37;
	geoidSimple[33][285] = (byte)-36;
	geoidSimple[33][286] = (byte)-34;
	geoidSimple[33][287] = (byte)-32;
	geoidSimple[33][288] = (byte)-30;
	geoidSimple[33][289] = (byte)-28;
	geoidSimple[33][290] = (byte)-27;
	geoidSimple[33][291] = (byte)-25;
	geoidSimple[33][292] = (byte)-22;
	geoidSimple[33][293] = (byte)-18;
	geoidSimple[33][294] = (byte)-15;
	geoidSimple[33][295] = (byte)-12;
	geoidSimple[33][296] = (byte)-10;
	geoidSimple[33][297] = (byte)-10;
	geoidSimple[33][298] = (byte)-9;
	geoidSimple[33][299] = (byte)-6;
	geoidSimple[33][300] = (byte)-1;
	geoidSimple[33][301] = (byte)4;
	geoidSimple[33][302] = (byte)6;
	geoidSimple[33][303] = (byte)8;
	geoidSimple[33][304] = (byte)10;
	geoidSimple[33][305] = (byte)13;
	geoidSimple[33][306] = (byte)16;
	geoidSimple[33][307] = (byte)18;
	geoidSimple[33][308] = (byte)21;
	geoidSimple[33][309] = (byte)24;
	geoidSimple[33][310] = (byte)27;
	geoidSimple[33][311] = (byte)30;
	geoidSimple[33][312] = (byte)32;
	geoidSimple[33][313] = (byte)34;
	geoidSimple[33][314] = (byte)37;
	geoidSimple[33][315] = (byte)40;
	geoidSimple[33][316] = (byte)42;
	geoidSimple[33][317] = (byte)44;
	geoidSimple[33][318] = (byte)46;
	geoidSimple[33][319] = (byte)48;
	geoidSimple[33][320] = (byte)49;
	geoidSimple[33][321] = (byte)51;
	geoidSimple[33][322] = (byte)54;
	geoidSimple[33][323] = (byte)56;
	geoidSimple[33][324] = (byte)58;
	geoidSimple[33][325] = (byte)60;
	geoidSimple[33][326] = (byte)61;
	geoidSimple[33][327] = (byte)61;
	geoidSimple[33][328] = (byte)61;
	geoidSimple[33][329] = (byte)61;
	geoidSimple[33][330] = (byte)61;
	geoidSimple[33][331] = (byte)61;
	geoidSimple[33][332] = (byte)61;
	geoidSimple[33][333] = (byte)61;
	geoidSimple[33][334] = (byte)61;
	geoidSimple[33][335] = (byte)61;
	geoidSimple[33][336] = (byte)61;
	geoidSimple[33][337] = (byte)61;
	geoidSimple[33][338] = (byte)62;
	geoidSimple[33][339] = (byte)61;
	geoidSimple[33][340] = (byte)61;
	geoidSimple[33][341] = (byte)60;
	geoidSimple[33][342] = (byte)61;
	geoidSimple[33][343] = (byte)60;
	geoidSimple[33][344] = (byte)60;
	geoidSimple[33][345] = (byte)59;
	geoidSimple[33][346] = (byte)57;
	geoidSimple[33][347] = (byte)55;
	geoidSimple[33][348] = (byte)55;
	geoidSimple[33][349] = (byte)55;
	geoidSimple[33][350] = (byte)56;
	geoidSimple[33][351] = (byte)57;
	geoidSimple[33][352] = (byte)57;
	geoidSimple[33][353] = (byte)56;
	geoidSimple[33][354] = (byte)55;
	geoidSimple[33][355] = (byte)54;
	geoidSimple[33][356] = (byte)53;
	geoidSimple[33][357] = (byte)51;
	geoidSimple[33][358] = (byte)49;
	geoidSimple[33][359] = (byte)47;
	}
		/** Row 34*/
	private static void init34() {
	geoidSimple[34][0] = (byte)45;
	geoidSimple[34][1] = (byte)44;
	geoidSimple[34][2] = (byte)43;
	geoidSimple[34][3] = (byte)42;
	geoidSimple[34][4] = (byte)42;
	geoidSimple[34][5] = (byte)41;
	geoidSimple[34][6] = (byte)41;
	geoidSimple[34][7] = (byte)41;
	geoidSimple[34][8] = (byte)40;
	geoidSimple[34][9] = (byte)40;
	geoidSimple[34][10] = (byte)39;
	geoidSimple[34][11] = (byte)37;
	geoidSimple[34][12] = (byte)36;
	geoidSimple[34][13] = (byte)35;
	geoidSimple[34][14] = (byte)34;
	geoidSimple[34][15] = (byte)32;
	geoidSimple[34][16] = (byte)31;
	geoidSimple[34][17] = (byte)29;
	geoidSimple[34][18] = (byte)27;
	geoidSimple[34][19] = (byte)26;
	geoidSimple[34][20] = (byte)25;
	geoidSimple[34][21] = (byte)24;
	geoidSimple[34][22] = (byte)24;
	geoidSimple[34][23] = (byte)23;
	geoidSimple[34][24] = (byte)22;
	geoidSimple[34][25] = (byte)22;
	geoidSimple[34][26] = (byte)21;
	geoidSimple[34][27] = (byte)21;
	geoidSimple[34][28] = (byte)20;
	geoidSimple[34][29] = (byte)19;
	geoidSimple[34][30] = (byte)18;
	geoidSimple[34][31] = (byte)17;
	geoidSimple[34][32] = (byte)17;
	geoidSimple[34][33] = (byte)17;
	geoidSimple[34][34] = (byte)16;
	geoidSimple[34][35] = (byte)15;
	geoidSimple[34][36] = (byte)15;
	geoidSimple[34][37] = (byte)14;
	geoidSimple[34][38] = (byte)13;
	geoidSimple[34][39] = (byte)12;
	geoidSimple[34][40] = (byte)10;
	geoidSimple[34][41] = (byte)9;
	geoidSimple[34][42] = (byte)8;
	geoidSimple[34][43] = (byte)7;
	geoidSimple[34][44] = (byte)7;
	geoidSimple[34][45] = (byte)6;
	geoidSimple[34][46] = (byte)6;
	geoidSimple[34][47] = (byte)5;
	geoidSimple[34][48] = (byte)4;
	geoidSimple[34][49] = (byte)2;
	geoidSimple[34][50] = (byte)1;
	geoidSimple[34][51] = (byte)0;
	geoidSimple[34][52] = (byte)-1;
	geoidSimple[34][53] = (byte)-3;
	geoidSimple[34][54] = (byte)-5;
	geoidSimple[34][55] = (byte)-6;
	geoidSimple[34][56] = (byte)-7;
	geoidSimple[34][57] = (byte)-7;
	geoidSimple[34][58] = (byte)-8;
	geoidSimple[34][59] = (byte)-8;
	geoidSimple[34][60] = (byte)-9;
	geoidSimple[34][61] = (byte)-12;
	geoidSimple[34][62] = (byte)-14;
	geoidSimple[34][63] = (byte)-16;
	geoidSimple[34][64] = (byte)-18;
	geoidSimple[34][65] = (byte)-19;
	geoidSimple[34][66] = (byte)-21;
	geoidSimple[34][67] = (byte)-22;
	geoidSimple[34][68] = (byte)-23;
	geoidSimple[34][69] = (byte)-24;
	geoidSimple[34][70] = (byte)-26;
	geoidSimple[34][71] = (byte)-27;
	geoidSimple[34][72] = (byte)-28;
	geoidSimple[34][73] = (byte)-30;
	geoidSimple[34][74] = (byte)-31;
	geoidSimple[34][75] = (byte)-32;
	geoidSimple[34][76] = (byte)-33;
	geoidSimple[34][77] = (byte)-34;
	geoidSimple[34][78] = (byte)-34;
	geoidSimple[34][79] = (byte)-35;
	geoidSimple[34][80] = (byte)-35;
	geoidSimple[34][81] = (byte)-35;
	geoidSimple[34][82] = (byte)-35;
	geoidSimple[34][83] = (byte)-36;
	geoidSimple[34][84] = (byte)-36;
	geoidSimple[34][85] = (byte)-36;
	geoidSimple[34][86] = (byte)-36;
	geoidSimple[34][87] = (byte)-35;
	geoidSimple[34][88] = (byte)-36;
	geoidSimple[34][89] = (byte)-37;
	geoidSimple[34][90] = (byte)-37;
	geoidSimple[34][91] = (byte)-38;
	geoidSimple[34][92] = (byte)-38;
	geoidSimple[34][93] = (byte)-38;
	geoidSimple[34][94] = (byte)-39;
	geoidSimple[34][95] = (byte)-39;
	geoidSimple[34][96] = (byte)-39;
	geoidSimple[34][97] = (byte)-39;
	geoidSimple[34][98] = (byte)-40;
	geoidSimple[34][99] = (byte)-40;
	geoidSimple[34][100] = (byte)-39;
	geoidSimple[34][101] = (byte)-39;
	geoidSimple[34][102] = (byte)-37;
	geoidSimple[34][103] = (byte)-36;
	geoidSimple[34][104] = (byte)-34;
	geoidSimple[34][105] = (byte)-33;
	geoidSimple[34][106] = (byte)-32;
	geoidSimple[34][107] = (byte)-32;
	geoidSimple[34][108] = (byte)-30;
	geoidSimple[34][109] = (byte)-30;
	geoidSimple[34][110] = (byte)-28;
	geoidSimple[34][111] = (byte)-25;
	geoidSimple[34][112] = (byte)-24;
	geoidSimple[34][113] = (byte)-22;
	geoidSimple[34][114] = (byte)-20;
	geoidSimple[34][115] = (byte)-18;
	geoidSimple[34][116] = (byte)-16;
	geoidSimple[34][117] = (byte)-13;
	geoidSimple[34][118] = (byte)-11;
	geoidSimple[34][119] = (byte)-10;
	geoidSimple[34][120] = (byte)-8;
	geoidSimple[34][121] = (byte)-7;
	geoidSimple[34][122] = (byte)-5;
	geoidSimple[34][123] = (byte)-3;
	geoidSimple[34][124] = (byte)-1;
	geoidSimple[34][125] = (byte)0;
	geoidSimple[34][126] = (byte)2;
	geoidSimple[34][127] = (byte)4;
	geoidSimple[34][128] = (byte)6;
	geoidSimple[34][129] = (byte)8;
	geoidSimple[34][130] = (byte)10;
	geoidSimple[34][131] = (byte)12;
	geoidSimple[34][132] = (byte)13;
	geoidSimple[34][133] = (byte)13;
	geoidSimple[34][134] = (byte)14;
	geoidSimple[34][135] = (byte)14;
	geoidSimple[34][136] = (byte)14;
	geoidSimple[34][137] = (byte)15;
	geoidSimple[34][138] = (byte)15;
	geoidSimple[34][139] = (byte)14;
	geoidSimple[34][140] = (byte)14;
	geoidSimple[34][141] = (byte)14;
	geoidSimple[34][142] = (byte)15;
	geoidSimple[34][143] = (byte)15;
	geoidSimple[34][144] = (byte)16;
	geoidSimple[34][145] = (byte)17;
	geoidSimple[34][146] = (byte)17;
	geoidSimple[34][147] = (byte)18;
	geoidSimple[34][148] = (byte)18;
	geoidSimple[34][149] = (byte)18;
	geoidSimple[34][150] = (byte)19;
	geoidSimple[34][151] = (byte)19;
	geoidSimple[34][152] = (byte)18;
	geoidSimple[34][153] = (byte)18;
	geoidSimple[34][154] = (byte)19;
	geoidSimple[34][155] = (byte)20;
	geoidSimple[34][156] = (byte)21;
	geoidSimple[34][157] = (byte)23;
	geoidSimple[34][158] = (byte)23;
	geoidSimple[34][159] = (byte)21;
	geoidSimple[34][160] = (byte)20;
	geoidSimple[34][161] = (byte)17;
	geoidSimple[34][162] = (byte)10;
	geoidSimple[34][163] = (byte)3;
	geoidSimple[34][164] = (byte)3;
	geoidSimple[34][165] = (byte)8;
	geoidSimple[34][166] = (byte)10;
	geoidSimple[34][167] = (byte)8;
	geoidSimple[34][168] = (byte)7;
	geoidSimple[34][169] = (byte)6;
	geoidSimple[34][170] = (byte)4;
	geoidSimple[34][171] = (byte)2;
	geoidSimple[34][172] = (byte)2;
	geoidSimple[34][173] = (byte)1;
	geoidSimple[34][174] = (byte)0;
	geoidSimple[34][175] = (byte)0;
	geoidSimple[34][176] = (byte)0;
	geoidSimple[34][177] = (byte)0;
	geoidSimple[34][178] = (byte)0;
	geoidSimple[34][179] = (byte)0;
	geoidSimple[34][LAT_GRID_SIZE] = (byte)1;
	geoidSimple[34][181] = (byte)2;
	geoidSimple[34][182] = (byte)2;
	geoidSimple[34][183] = (byte)3;
	geoidSimple[34][184] = (byte)3;
	geoidSimple[34][185] = (byte)4;
	geoidSimple[34][186] = (byte)4;
	geoidSimple[34][187] = (byte)5;
	geoidSimple[34][188] = (byte)5;
	geoidSimple[34][189] = (byte)7;
	geoidSimple[34][190] = (byte)9;
	geoidSimple[34][191] = (byte)11;
	geoidSimple[34][192] = (byte)13;
	geoidSimple[34][193] = (byte)13;
	geoidSimple[34][194] = (byte)14;
	geoidSimple[34][195] = (byte)14;
	geoidSimple[34][196] = (byte)15;
	geoidSimple[34][197] = (byte)15;
	geoidSimple[34][198] = (byte)16;
	geoidSimple[34][199] = (byte)17;
	geoidSimple[34][200] = (byte)16;
	geoidSimple[34][201] = (byte)15;
	geoidSimple[34][202] = (byte)13;
	geoidSimple[34][203] = (byte)13;
	geoidSimple[34][204] = (byte)13;
	geoidSimple[34][205] = (byte)12;
	geoidSimple[34][206] = (byte)10;
	geoidSimple[34][207] = (byte)8;
	geoidSimple[34][208] = (byte)8;
	geoidSimple[34][209] = (byte)8;
	geoidSimple[34][210] = (byte)8;
	geoidSimple[34][211] = (byte)8;
	geoidSimple[34][212] = (byte)8;
	geoidSimple[34][213] = (byte)7;
	geoidSimple[34][214] = (byte)7;
	geoidSimple[34][215] = (byte)6;
	geoidSimple[34][216] = (byte)5;
	geoidSimple[34][217] = (byte)4;
	geoidSimple[34][218] = (byte)3;
	geoidSimple[34][219] = (byte)1;
	geoidSimple[34][220] = (byte)0;
	geoidSimple[34][221] = (byte)0;
	geoidSimple[34][222] = (byte)-1;
	geoidSimple[34][223] = (byte)-3;
	geoidSimple[34][224] = (byte)-4;
	geoidSimple[34][225] = (byte)-1;
	geoidSimple[34][226] = (byte)-1;
	geoidSimple[34][227] = (byte)-2;
	geoidSimple[34][228] = (byte)-3;
	geoidSimple[34][229] = (byte)-4;
	geoidSimple[34][230] = (byte)-5;
	geoidSimple[34][231] = (byte)-6;
	geoidSimple[34][232] = (byte)-7;
	geoidSimple[34][233] = (byte)-8;
	geoidSimple[34][234] = (byte)-8;
	geoidSimple[34][235] = (byte)-9;
	geoidSimple[34][236] = (byte)-10;
	geoidSimple[34][237] = (byte)-11;
	geoidSimple[34][238] = (byte)-13;
	geoidSimple[34][239] = (byte)-14;
	geoidSimple[34][240] = (byte)-15;
	geoidSimple[34][241] = (byte)-16;
	geoidSimple[34][242] = (byte)-17;
	geoidSimple[34][243] = (byte)-18;
	geoidSimple[34][244] = (byte)-19;
	geoidSimple[34][245] = (byte)-19;
	geoidSimple[34][246] = (byte)-21;
	geoidSimple[34][247] = (byte)-22;
	geoidSimple[34][248] = (byte)-24;
	geoidSimple[34][249] = (byte)-25;
	geoidSimple[34][250] = (byte)-26;
	geoidSimple[34][251] = (byte)-27;
	geoidSimple[34][252] = (byte)-28;
	geoidSimple[34][253] = (byte)-28;
	geoidSimple[34][254] = (byte)-29;
	geoidSimple[34][255] = (byte)-29;
	geoidSimple[34][256] = (byte)-30;
	geoidSimple[34][257] = (byte)-31;
	geoidSimple[34][258] = (byte)-32;
	geoidSimple[34][259] = (byte)-33;
	geoidSimple[34][260] = (byte)-33;
	geoidSimple[34][261] = (byte)-35;
	geoidSimple[34][262] = (byte)-36;
	geoidSimple[34][263] = (byte)-38;
	geoidSimple[34][264] = (byte)-39;
	geoidSimple[34][265] = (byte)-41;
	geoidSimple[34][266] = (byte)-41;
	geoidSimple[34][267] = (byte)-43;
	geoidSimple[34][268] = (byte)-44;
	geoidSimple[34][269] = (byte)-44;
	geoidSimple[34][270] = (byte)-46;
	geoidSimple[34][271] = (byte)-46;
	geoidSimple[34][272] = (byte)-46;
	geoidSimple[34][273] = (byte)-47;
	geoidSimple[34][274] = (byte)-47;
	geoidSimple[34][275] = (byte)-46;
	geoidSimple[34][276] = (byte)-46;
	geoidSimple[34][277] = (byte)-45;
	geoidSimple[34][278] = (byte)-45;
	geoidSimple[34][279] = (byte)-44;
	geoidSimple[34][280] = (byte)-44;
	geoidSimple[34][281] = (byte)-43;
	geoidSimple[34][282] = (byte)-42;
	geoidSimple[34][283] = (byte)-40;
	geoidSimple[34][284] = (byte)-38;
	geoidSimple[34][285] = (byte)-36;
	geoidSimple[34][286] = (byte)-34;
	geoidSimple[34][287] = (byte)-32;
	geoidSimple[34][288] = (byte)-30;
	geoidSimple[34][289] = (byte)-28;
	geoidSimple[34][290] = (byte)-26;
	geoidSimple[34][291] = (byte)-25;
	geoidSimple[34][292] = (byte)-22;
	geoidSimple[34][293] = (byte)-19;
	geoidSimple[34][294] = (byte)-16;
	geoidSimple[34][295] = (byte)-14;
	geoidSimple[34][296] = (byte)-12;
	geoidSimple[34][297] = (byte)-11;
	geoidSimple[34][298] = (byte)-9;
	geoidSimple[34][299] = (byte)-8;
	geoidSimple[34][300] = (byte)-5;
	geoidSimple[34][301] = (byte)0;
	geoidSimple[34][302] = (byte)3;
	geoidSimple[34][303] = (byte)6;
	geoidSimple[34][304] = (byte)9;
	geoidSimple[34][305] = (byte)12;
	geoidSimple[34][306] = (byte)14;
	geoidSimple[34][307] = (byte)17;
	geoidSimple[34][308] = (byte)20;
	geoidSimple[34][309] = (byte)23;
	geoidSimple[34][310] = (byte)26;
	geoidSimple[34][311] = (byte)29;
	geoidSimple[34][312] = (byte)32;
	geoidSimple[34][313] = (byte)35;
	geoidSimple[34][314] = (byte)37;
	geoidSimple[34][315] = (byte)39;
	geoidSimple[34][316] = (byte)41;
	geoidSimple[34][317] = (byte)44;
	geoidSimple[34][318] = (byte)46;
	geoidSimple[34][319] = (byte)48;
	geoidSimple[34][320] = (byte)50;
	geoidSimple[34][321] = (byte)52;
	geoidSimple[34][322] = (byte)54;
	geoidSimple[34][323] = (byte)56;
	geoidSimple[34][324] = (byte)58;
	geoidSimple[34][325] = (byte)60;
	geoidSimple[34][326] = (byte)60;
	geoidSimple[34][327] = (byte)60;
	geoidSimple[34][328] = (byte)60;
	geoidSimple[34][329] = (byte)60;
	geoidSimple[34][330] = (byte)60;
	geoidSimple[34][331] = (byte)60;
	geoidSimple[34][332] = (byte)60;
	geoidSimple[34][333] = (byte)60;
	geoidSimple[34][334] = (byte)61;
	geoidSimple[34][335] = (byte)61;
	geoidSimple[34][336] = (byte)61;
	geoidSimple[34][337] = (byte)61;
	geoidSimple[34][338] = (byte)60;
	geoidSimple[34][339] = (byte)60;
	geoidSimple[34][340] = (byte)61;
	geoidSimple[34][341] = (byte)61;
	geoidSimple[34][342] = (byte)61;
	geoidSimple[34][343] = (byte)61;
	geoidSimple[34][344] = (byte)59;
	geoidSimple[34][345] = (byte)58;
	geoidSimple[34][346] = (byte)57;
	geoidSimple[34][347] = (byte)56;
	geoidSimple[34][348] = (byte)55;
	geoidSimple[34][349] = (byte)56;
	geoidSimple[34][350] = (byte)57;
	geoidSimple[34][351] = (byte)58;
	geoidSimple[34][352] = (byte)57;
	geoidSimple[34][353] = (byte)56;
	geoidSimple[34][354] = (byte)55;
	geoidSimple[34][355] = (byte)54;
	geoidSimple[34][356] = (byte)53;
	geoidSimple[34][357] = (byte)51;
	geoidSimple[34][358] = (byte)49;
	geoidSimple[34][359] = (byte)47;
	}
		/** Row 35*/
	private static void init35() {
	geoidSimple[35][0] = (byte)45;
	geoidSimple[35][1] = (byte)43;
	geoidSimple[35][2] = (byte)42;
	geoidSimple[35][3] = (byte)41;
	geoidSimple[35][4] = (byte)41;
	geoidSimple[35][5] = (byte)40;
	geoidSimple[35][6] = (byte)39;
	geoidSimple[35][7] = (byte)39;
	geoidSimple[35][8] = (byte)39;
	geoidSimple[35][9] = (byte)39;
	geoidSimple[35][10] = (byte)39;
	geoidSimple[35][11] = (byte)38;
	geoidSimple[35][12] = (byte)37;
	geoidSimple[35][13] = (byte)35;
	geoidSimple[35][14] = (byte)34;
	geoidSimple[35][15] = (byte)33;
	geoidSimple[35][16] = (byte)32;
	geoidSimple[35][17] = (byte)30;
	geoidSimple[35][18] = (byte)29;
	geoidSimple[35][19] = (byte)27;
	geoidSimple[35][20] = (byte)27;
	geoidSimple[35][21] = (byte)26;
	geoidSimple[35][22] = (byte)26;
	geoidSimple[35][23] = (byte)25;
	geoidSimple[35][24] = (byte)25;
	geoidSimple[35][25] = (byte)24;
	geoidSimple[35][26] = (byte)23;
	geoidSimple[35][27] = (byte)22;
	geoidSimple[35][28] = (byte)21;
	geoidSimple[35][29] = (byte)20;
	geoidSimple[35][30] = (byte)19;
	geoidSimple[35][31] = (byte)18;
	geoidSimple[35][32] = (byte)17;
	geoidSimple[35][33] = (byte)16;
	geoidSimple[35][34] = (byte)15;
	geoidSimple[35][35] = (byte)15;
	geoidSimple[35][36] = (byte)14;
	geoidSimple[35][37] = (byte)14;
	geoidSimple[35][38] = (byte)12;
	geoidSimple[35][39] = (byte)11;
	geoidSimple[35][40] = (byte)10;
	geoidSimple[35][41] = (byte)9;
	geoidSimple[35][42] = (byte)7;
	geoidSimple[35][43] = (byte)6;
	geoidSimple[35][44] = (byte)6;
	geoidSimple[35][45] = (byte)5;
	geoidSimple[35][46] = (byte)5;
	geoidSimple[35][47] = (byte)4;
	geoidSimple[35][48] = (byte)3;
	geoidSimple[35][49] = (byte)1;
	geoidSimple[35][50] = (byte)0;
	geoidSimple[35][51] = (byte)0;
	geoidSimple[35][52] = (byte)0;
	geoidSimple[35][53] = (byte)-2;
	geoidSimple[35][54] = (byte)-4;
	geoidSimple[35][55] = (byte)-7;
	geoidSimple[35][56] = (byte)-9;
	geoidSimple[35][57] = (byte)-10;
	geoidSimple[35][58] = (byte)-9;
	geoidSimple[35][59] = (byte)-9;
	geoidSimple[35][60] = (byte)-11;
	geoidSimple[35][61] = (byte)-13;
	geoidSimple[35][62] = (byte)-15;
	geoidSimple[35][63] = (byte)-17;
	geoidSimple[35][64] = (byte)-19;
	geoidSimple[35][65] = (byte)-21;
	geoidSimple[35][66] = (byte)-22;
	geoidSimple[35][67] = (byte)-23;
	geoidSimple[35][68] = (byte)-25;
	geoidSimple[35][69] = (byte)-25;
	geoidSimple[35][70] = (byte)-26;
	geoidSimple[35][71] = (byte)-28;
	geoidSimple[35][72] = (byte)-29;
	geoidSimple[35][73] = (byte)-31;
	geoidSimple[35][74] = (byte)-32;
	geoidSimple[35][75] = (byte)-34;
	geoidSimple[35][76] = (byte)-34;
	geoidSimple[35][77] = (byte)-35;
	geoidSimple[35][78] = (byte)-36;
	geoidSimple[35][79] = (byte)-36;
	geoidSimple[35][80] = (byte)-36;
	geoidSimple[35][81] = (byte)-36;
	geoidSimple[35][82] = (byte)-37;
	geoidSimple[35][83] = (byte)-37;
	geoidSimple[35][84] = (byte)-37;
	geoidSimple[35][85] = (byte)-37;
	geoidSimple[35][86] = (byte)-38;
	geoidSimple[35][87] = (byte)-37;
	geoidSimple[35][88] = (byte)-35;
	geoidSimple[35][89] = (byte)-36;
	geoidSimple[35][90] = (byte)-37;
	geoidSimple[35][91] = (byte)-38;
	geoidSimple[35][92] = (byte)-38;
	geoidSimple[35][93] = (byte)-37;
	geoidSimple[35][94] = (byte)-37;
	geoidSimple[35][95] = (byte)-37;
	geoidSimple[35][96] = (byte)-37;
	geoidSimple[35][97] = (byte)-36;
	geoidSimple[35][98] = (byte)-37;
	geoidSimple[35][99] = (byte)-39;
	geoidSimple[35][100] = (byte)-40;
	geoidSimple[35][101] = (byte)-39;
	geoidSimple[35][102] = (byte)-38;
	geoidSimple[35][103] = (byte)-36;
	geoidSimple[35][104] = (byte)-34;
	geoidSimple[35][105] = (byte)-34;
	geoidSimple[35][106] = (byte)-32;
	geoidSimple[35][107] = (byte)-32;
	geoidSimple[35][108] = (byte)-31;
	geoidSimple[35][109] = (byte)-32;
	geoidSimple[35][110] = (byte)-29;
	geoidSimple[35][111] = (byte)-26;
	geoidSimple[35][112] = (byte)-23;
	geoidSimple[35][113] = (byte)-21;
	geoidSimple[35][114] = (byte)-19;
	geoidSimple[35][115] = (byte)-17;
	geoidSimple[35][116] = (byte)-16;
	geoidSimple[35][117] = (byte)-14;
	geoidSimple[35][118] = (byte)-12;
	geoidSimple[35][119] = (byte)-10;
	geoidSimple[35][120] = (byte)-8;
	geoidSimple[35][121] = (byte)-7;
	geoidSimple[35][122] = (byte)-5;
	geoidSimple[35][123] = (byte)-3;
	geoidSimple[35][124] = (byte)0;
	geoidSimple[35][125] = (byte)1;
	geoidSimple[35][126] = (byte)3;
	geoidSimple[35][127] = (byte)5;
	geoidSimple[35][128] = (byte)6;
	geoidSimple[35][129] = (byte)7;
	geoidSimple[35][130] = (byte)9;
	geoidSimple[35][131] = (byte)12;
	geoidSimple[35][132] = (byte)13;
	geoidSimple[35][133] = (byte)14;
	geoidSimple[35][134] = (byte)14;
	geoidSimple[35][135] = (byte)15;
	geoidSimple[35][136] = (byte)15;
	geoidSimple[35][137] = (byte)15;
	geoidSimple[35][138] = (byte)16;
	geoidSimple[35][139] = (byte)16;
	geoidSimple[35][140] = (byte)16;
	geoidSimple[35][141] = (byte)15;
	geoidSimple[35][142] = (byte)16;
	geoidSimple[35][143] = (byte)16;
	geoidSimple[35][144] = (byte)15;
	geoidSimple[35][145] = (byte)15;
	geoidSimple[35][146] = (byte)16;
	geoidSimple[35][147] = (byte)17;
	geoidSimple[35][148] = (byte)18;
	geoidSimple[35][149] = (byte)18;
	geoidSimple[35][150] = (byte)19;
	geoidSimple[35][151] = (byte)19;
	geoidSimple[35][152] = (byte)19;
	geoidSimple[35][153] = (byte)19;
	geoidSimple[35][154] = (byte)20;
	geoidSimple[35][155] = (byte)21;
	geoidSimple[35][156] = (byte)22;
	geoidSimple[35][157] = (byte)24;
	geoidSimple[35][158] = (byte)24;
	geoidSimple[35][159] = (byte)23;
	geoidSimple[35][160] = (byte)21;
	geoidSimple[35][161] = (byte)17;
	geoidSimple[35][162] = (byte)7;
	geoidSimple[35][163] = (byte)0;
	geoidSimple[35][164] = (byte)1;
	geoidSimple[35][165] = (byte)1;
	geoidSimple[35][166] = (byte)6;
	geoidSimple[35][167] = (byte)9;
	geoidSimple[35][168] = (byte)7;
	geoidSimple[35][169] = (byte)5;
	geoidSimple[35][170] = (byte)4;
	geoidSimple[35][171] = (byte)2;
	geoidSimple[35][172] = (byte)1;
	geoidSimple[35][173] = (byte)0;
	geoidSimple[35][174] = (byte)0;
	geoidSimple[35][175] = (byte)0;
	geoidSimple[35][176] = (byte)3;
	geoidSimple[35][177] = (byte)3;
	geoidSimple[35][178] = (byte)4;
	geoidSimple[35][179] = (byte)3;
	geoidSimple[35][LAT_GRID_SIZE] = (byte)0;
	geoidSimple[35][181] = (byte)1;
	geoidSimple[35][182] = (byte)2;
	geoidSimple[35][183] = (byte)3;
	geoidSimple[35][184] = (byte)4;
	geoidSimple[35][185] = (byte)4;
	geoidSimple[35][186] = (byte)5;
	geoidSimple[35][187] = (byte)6;
	geoidSimple[35][188] = (byte)7;
	geoidSimple[35][189] = (byte)8;
	geoidSimple[35][190] = (byte)10;
	geoidSimple[35][191] = (byte)11;
	geoidSimple[35][192] = (byte)12;
	geoidSimple[35][193] = (byte)14;
	geoidSimple[35][194] = (byte)15;
	geoidSimple[35][195] = (byte)17;
	geoidSimple[35][196] = (byte)17;
	geoidSimple[35][197] = (byte)16;
	geoidSimple[35][198] = (byte)14;
	geoidSimple[35][199] = (byte)14;
	geoidSimple[35][200] = (byte)14;
	geoidSimple[35][201] = (byte)12;
	geoidSimple[35][202] = (byte)11;
	geoidSimple[35][203] = (byte)10;
	geoidSimple[35][204] = (byte)9;
	geoidSimple[35][205] = (byte)9;
	geoidSimple[35][206] = (byte)10;
	geoidSimple[35][207] = (byte)11;
	geoidSimple[35][208] = (byte)11;
	geoidSimple[35][209] = (byte)11;
	geoidSimple[35][210] = (byte)11;
	geoidSimple[35][211] = (byte)9;
	geoidSimple[35][212] = (byte)7;
	geoidSimple[35][213] = (byte)6;
	geoidSimple[35][214] = (byte)5;
	geoidSimple[35][215] = (byte)4;
	geoidSimple[35][216] = (byte)3;
	geoidSimple[35][217] = (byte)2;
	geoidSimple[35][218] = (byte)1;
	geoidSimple[35][219] = (byte)0;
	geoidSimple[35][220] = (byte)0;
	geoidSimple[35][221] = (byte)-1;
	geoidSimple[35][222] = (byte)-3;
	geoidSimple[35][223] = (byte)-4;
	geoidSimple[35][224] = (byte)-6;
	geoidSimple[35][225] = (byte)-7;
	geoidSimple[35][226] = (byte)-5;
	geoidSimple[35][227] = (byte)-5;
	geoidSimple[35][228] = (byte)-6;
	geoidSimple[35][229] = (byte)-7;
	geoidSimple[35][230] = (byte)-8;
	geoidSimple[35][231] = (byte)-8;
	geoidSimple[35][232] = (byte)-8;
	geoidSimple[35][233] = (byte)-9;
	geoidSimple[35][234] = (byte)-10;
	geoidSimple[35][235] = (byte)-11;
	geoidSimple[35][236] = (byte)-11;
	geoidSimple[35][237] = (byte)-12;
	geoidSimple[35][238] = (byte)-13;
	geoidSimple[35][239] = (byte)-13;
	geoidSimple[35][240] = (byte)-15;
	geoidSimple[35][241] = (byte)-16;
	geoidSimple[35][242] = (byte)-16;
	geoidSimple[35][243] = (byte)-17;
	geoidSimple[35][244] = (byte)-17;
	geoidSimple[35][245] = (byte)-19;
	geoidSimple[35][246] = (byte)-20;
	geoidSimple[35][247] = (byte)-22;
	geoidSimple[35][248] = (byte)-23;
	geoidSimple[35][249] = (byte)-24;
	geoidSimple[35][250] = (byte)-25;
	geoidSimple[35][251] = (byte)-25;
	geoidSimple[35][252] = (byte)-26;
	geoidSimple[35][253] = (byte)-27;
	geoidSimple[35][254] = (byte)-27;
	geoidSimple[35][255] = (byte)-28;
	geoidSimple[35][256] = (byte)-29;
	geoidSimple[35][257] = (byte)-30;
	geoidSimple[35][258] = (byte)-31;
	geoidSimple[35][259] = (byte)-31;
	geoidSimple[35][260] = (byte)-32;
	geoidSimple[35][261] = (byte)-33;
	geoidSimple[35][262] = (byte)-35;
	geoidSimple[35][263] = (byte)-37;
	geoidSimple[35][264] = (byte)-38;
	geoidSimple[35][265] = (byte)-39;
	geoidSimple[35][266] = (byte)-40;
	geoidSimple[35][267] = (byte)-41;
	geoidSimple[35][268] = (byte)-41;
	geoidSimple[35][269] = (byte)-43;
	geoidSimple[35][270] = (byte)-44;
	geoidSimple[35][271] = (byte)-45;
	geoidSimple[35][272] = (byte)-45;
	geoidSimple[35][273] = (byte)-46;
	geoidSimple[35][274] = (byte)-46;
	geoidSimple[35][275] = (byte)-45;
	geoidSimple[35][276] = (byte)-44;
	geoidSimple[35][277] = (byte)-44;
	geoidSimple[35][278] = (byte)-44;
	geoidSimple[35][279] = (byte)-44;
	geoidSimple[35][280] = (byte)-44;
	geoidSimple[35][281] = (byte)-43;
	geoidSimple[35][282] = (byte)-41;
	geoidSimple[35][283] = (byte)-39;
	geoidSimple[35][284] = (byte)-37;
	geoidSimple[35][285] = (byte)-35;
	geoidSimple[35][286] = (byte)-33;
	geoidSimple[35][287] = (byte)-31;
	geoidSimple[35][288] = (byte)-29;
	geoidSimple[35][289] = (byte)-27;
	geoidSimple[35][290] = (byte)-25;
	geoidSimple[35][291] = (byte)-23;
	geoidSimple[35][292] = (byte)-21;
	geoidSimple[35][293] = (byte)-19;
	geoidSimple[35][294] = (byte)-17;
	geoidSimple[35][295] = (byte)-16;
	geoidSimple[35][296] = (byte)-15;
	geoidSimple[35][297] = (byte)-14;
	geoidSimple[35][298] = (byte)-12;
	geoidSimple[35][299] = (byte)-10;
	geoidSimple[35][300] = (byte)-7;
	geoidSimple[35][301] = (byte)-3;
	geoidSimple[35][302] = (byte)0;
	geoidSimple[35][303] = (byte)3;
	geoidSimple[35][304] = (byte)8;
	geoidSimple[35][305] = (byte)13;
	geoidSimple[35][306] = (byte)15;
	geoidSimple[35][307] = (byte)16;
	geoidSimple[35][308] = (byte)19;
	geoidSimple[35][309] = (byte)22;
	geoidSimple[35][310] = (byte)25;
	geoidSimple[35][311] = (byte)28;
	geoidSimple[35][312] = (byte)31;
	geoidSimple[35][313] = (byte)34;
	geoidSimple[35][314] = (byte)37;
	geoidSimple[35][315] = (byte)39;
	geoidSimple[35][316] = (byte)41;
	geoidSimple[35][317] = (byte)43;
	geoidSimple[35][318] = (byte)45;
	geoidSimple[35][319] = (byte)47;
	geoidSimple[35][320] = (byte)50;
	geoidSimple[35][321] = (byte)52;
	geoidSimple[35][322] = (byte)54;
	geoidSimple[35][323] = (byte)56;
	geoidSimple[35][324] = (byte)58;
	geoidSimple[35][325] = (byte)59;
	geoidSimple[35][326] = (byte)59;
	geoidSimple[35][327] = (byte)60;
	geoidSimple[35][328] = (byte)60;
	geoidSimple[35][329] = (byte)60;
	geoidSimple[35][330] = (byte)60;
	geoidSimple[35][331] = (byte)60;
	geoidSimple[35][332] = (byte)60;
	geoidSimple[35][333] = (byte)60;
	geoidSimple[35][334] = (byte)61;
	geoidSimple[35][335] = (byte)61;
	geoidSimple[35][336] = (byte)60;
	geoidSimple[35][337] = (byte)60;
	geoidSimple[35][338] = (byte)60;
	geoidSimple[35][339] = (byte)60;
	geoidSimple[35][340] = (byte)61;
	geoidSimple[35][341] = (byte)61;
	geoidSimple[35][342] = (byte)60;
	geoidSimple[35][343] = (byte)59;
	geoidSimple[35][344] = (byte)58;
	geoidSimple[35][345] = (byte)57;
	geoidSimple[35][346] = (byte)56;
	geoidSimple[35][347] = (byte)56;
	geoidSimple[35][348] = (byte)56;
	geoidSimple[35][349] = (byte)57;
	geoidSimple[35][350] = (byte)58;
	geoidSimple[35][351] = (byte)57;
	geoidSimple[35][352] = (byte)57;
	geoidSimple[35][353] = (byte)56;
	geoidSimple[35][354] = (byte)55;
	geoidSimple[35][355] = (byte)54;
	geoidSimple[35][356] = (byte)53;
	geoidSimple[35][357] = (byte)52;
	geoidSimple[35][358] = (byte)50;
	geoidSimple[35][359] = (byte)47;
	}
		/** Row 36*/
	private static void init36() {
	geoidSimple[36][0] = (byte)45;
	geoidSimple[36][1] = (byte)43;
	geoidSimple[36][2] = (byte)42;
	geoidSimple[36][3] = (byte)41;
	geoidSimple[36][4] = (byte)41;
	geoidSimple[36][5] = (byte)40;
	geoidSimple[36][6] = (byte)40;
	geoidSimple[36][7] = (byte)40;
	geoidSimple[36][8] = (byte)39;
	geoidSimple[36][9] = (byte)39;
	geoidSimple[36][10] = (byte)39;
	geoidSimple[36][11] = (byte)39;
	geoidSimple[36][12] = (byte)39;
	geoidSimple[36][13] = (byte)37;
	geoidSimple[36][14] = (byte)35;
	geoidSimple[36][15] = (byte)34;
	geoidSimple[36][16] = (byte)33;
	geoidSimple[36][17] = (byte)31;
	geoidSimple[36][18] = (byte)29;
	geoidSimple[36][19] = (byte)29;
	geoidSimple[36][20] = (byte)29;
	geoidSimple[36][21] = (byte)29;
	geoidSimple[36][22] = (byte)28;
	geoidSimple[36][23] = (byte)27;
	geoidSimple[36][24] = (byte)26;
	geoidSimple[36][25] = (byte)26;
	geoidSimple[36][26] = (byte)24;
	geoidSimple[36][27] = (byte)23;
	geoidSimple[36][28] = (byte)21;
	geoidSimple[36][29] = (byte)20;
	geoidSimple[36][30] = (byte)19;
	geoidSimple[36][31] = (byte)17;
	geoidSimple[36][32] = (byte)16;
	geoidSimple[36][33] = (byte)16;
	geoidSimple[36][34] = (byte)16;
	geoidSimple[36][35] = (byte)15;
	geoidSimple[36][36] = (byte)13;
	geoidSimple[36][37] = (byte)11;
	geoidSimple[36][38] = (byte)10;
	geoidSimple[36][39] = (byte)9;
	geoidSimple[36][40] = (byte)8;
	geoidSimple[36][41] = (byte)8;
	geoidSimple[36][42] = (byte)7;
	geoidSimple[36][43] = (byte)6;
	geoidSimple[36][44] = (byte)6;
	geoidSimple[36][45] = (byte)5;
	geoidSimple[36][46] = (byte)4;
	geoidSimple[36][47] = (byte)3;
	geoidSimple[36][48] = (byte)1;
	geoidSimple[36][49] = (byte)0;
	geoidSimple[36][50] = (byte)0;
	geoidSimple[36][51] = (byte)0;
	geoidSimple[36][52] = (byte)-2;
	geoidSimple[36][53] = (byte)-4;
	geoidSimple[36][54] = (byte)-6;
	geoidSimple[36][55] = (byte)-9;
	geoidSimple[36][56] = (byte)-10;
	geoidSimple[36][57] = (byte)-10;
	geoidSimple[36][58] = (byte)-10;
	geoidSimple[36][59] = (byte)-11;
	geoidSimple[36][60] = (byte)-13;
	geoidSimple[36][61] = (byte)-16;
	geoidSimple[36][62] = (byte)-18;
	geoidSimple[36][63] = (byte)-19;
	geoidSimple[36][64] = (byte)-21;
	geoidSimple[36][65] = (byte)-23;
	geoidSimple[36][66] = (byte)-24;
	geoidSimple[36][67] = (byte)-25;
	geoidSimple[36][68] = (byte)-26;
	geoidSimple[36][69] = (byte)-27;
	geoidSimple[36][70] = (byte)-28;
	geoidSimple[36][71] = (byte)-29;
	geoidSimple[36][72] = (byte)-30;
	geoidSimple[36][73] = (byte)-32;
	geoidSimple[36][74] = (byte)-33;
	geoidSimple[36][75] = (byte)-35;
	geoidSimple[36][76] = (byte)-36;
	geoidSimple[36][77] = (byte)-37;
	geoidSimple[36][78] = (byte)-38;
	geoidSimple[36][79] = (byte)-38;
	geoidSimple[36][80] = (byte)-39;
	geoidSimple[36][81] = (byte)-39;
	geoidSimple[36][82] = (byte)-39;
	geoidSimple[36][83] = (byte)-39;
	geoidSimple[36][84] = (byte)-40;
	geoidSimple[36][85] = (byte)-40;
	geoidSimple[36][86] = (byte)-40;
	geoidSimple[36][87] = (byte)-39;
	geoidSimple[36][88] = (byte)-38;
	geoidSimple[36][89] = (byte)-37;
	geoidSimple[36][90] = (byte)-38;
	geoidSimple[36][91] = (byte)-40;
	geoidSimple[36][92] = (byte)-40;
	geoidSimple[36][93] = (byte)-39;
	geoidSimple[36][94] = (byte)-38;
	geoidSimple[36][95] = (byte)-38;
	geoidSimple[36][96] = (byte)-36;
	geoidSimple[36][97] = (byte)-35;
	geoidSimple[36][98] = (byte)-36;
	geoidSimple[36][99] = (byte)-37;
	geoidSimple[36][100] = (byte)-38;
	geoidSimple[36][101] = (byte)-38;
	geoidSimple[36][102] = (byte)-38;
	geoidSimple[36][103] = (byte)-37;
	geoidSimple[36][104] = (byte)-35;
	geoidSimple[36][105] = (byte)-34;
	geoidSimple[36][106] = (byte)-33;
	geoidSimple[36][107] = (byte)-32;
	geoidSimple[36][108] = (byte)-33;
	geoidSimple[36][109] = (byte)-31;
	geoidSimple[36][110] = (byte)-28;
	geoidSimple[36][111] = (byte)-25;
	geoidSimple[36][112] = (byte)-23;
	geoidSimple[36][113] = (byte)-21;
	geoidSimple[36][114] = (byte)-19;
	geoidSimple[36][115] = (byte)-18;
	geoidSimple[36][116] = (byte)-16;
	geoidSimple[36][117] = (byte)-13;
	geoidSimple[36][118] = (byte)-12;
	geoidSimple[36][119] = (byte)-9;
	geoidSimple[36][120] = (byte)-8;
	geoidSimple[36][121] = (byte)-7;
	geoidSimple[36][122] = (byte)-5;
	geoidSimple[36][123] = (byte)-3;
	geoidSimple[36][124] = (byte)0;
	geoidSimple[36][125] = (byte)2;
	geoidSimple[36][126] = (byte)4;
	geoidSimple[36][127] = (byte)5;
	geoidSimple[36][128] = (byte)7;
	geoidSimple[36][129] = (byte)9;
	geoidSimple[36][130] = (byte)11;
	geoidSimple[36][131] = (byte)12;
	geoidSimple[36][132] = (byte)14;
	geoidSimple[36][133] = (byte)15;
	geoidSimple[36][134] = (byte)17;
	geoidSimple[36][135] = (byte)16;
	geoidSimple[36][136] = (byte)16;
	geoidSimple[36][137] = (byte)17;
	geoidSimple[36][138] = (byte)17;
	geoidSimple[36][139] = (byte)18;
	geoidSimple[36][140] = (byte)18;
	geoidSimple[36][141] = (byte)17;
	geoidSimple[36][142] = (byte)16;
	geoidSimple[36][143] = (byte)17;
	geoidSimple[36][144] = (byte)16;
	geoidSimple[36][145] = (byte)15;
	geoidSimple[36][146] = (byte)16;
	geoidSimple[36][147] = (byte)17;
	geoidSimple[36][148] = (byte)17;
	geoidSimple[36][149] = (byte)18;
	geoidSimple[36][150] = (byte)18;
	geoidSimple[36][151] = (byte)19;
	geoidSimple[36][152] = (byte)19;
	geoidSimple[36][153] = (byte)20;
	geoidSimple[36][154] = (byte)21;
	geoidSimple[36][155] = (byte)22;
	geoidSimple[36][156] = (byte)23;
	geoidSimple[36][157] = (byte)24;
	geoidSimple[36][158] = (byte)24;
	geoidSimple[36][159] = (byte)22;
	geoidSimple[36][160] = (byte)16;
	geoidSimple[36][161] = (byte)5;
	geoidSimple[36][162] = (byte)0;
	geoidSimple[36][163] = (byte)2;
	geoidSimple[36][164] = (byte)6;
	geoidSimple[36][165] = (byte)6;
	geoidSimple[36][166] = (byte)3;
	geoidSimple[36][167] = (byte)0;
	geoidSimple[36][168] = (byte)0;
	geoidSimple[36][169] = (byte)2;
	geoidSimple[36][170] = (byte)4;
	geoidSimple[36][171] = (byte)4;
	geoidSimple[36][172] = (byte)3;
	geoidSimple[36][173] = (byte)2;
	geoidSimple[36][174] = (byte)2;
	geoidSimple[36][175] = (byte)2;
	geoidSimple[36][176] = (byte)2;
	geoidSimple[36][177] = (byte)1;
	geoidSimple[36][178] = (byte)1;
	geoidSimple[36][179] = (byte)4;
	geoidSimple[36][LAT_GRID_SIZE] = (byte)3;
	geoidSimple[36][181] = (byte)0;
	geoidSimple[36][182] = (byte)2;
	geoidSimple[36][183] = (byte)2;
	geoidSimple[36][184] = (byte)3;
	geoidSimple[36][185] = (byte)4;
	geoidSimple[36][186] = (byte)4;
	geoidSimple[36][187] = (byte)6;
	geoidSimple[36][188] = (byte)7;
	geoidSimple[36][189] = (byte)9;
	geoidSimple[36][190] = (byte)11;
	geoidSimple[36][191] = (byte)13;
	geoidSimple[36][192] = (byte)15;
	geoidSimple[36][193] = (byte)15;
	geoidSimple[36][194] = (byte)13;
	geoidSimple[36][195] = (byte)10;
	geoidSimple[36][196] = (byte)8;
	geoidSimple[36][197] = (byte)5;
	geoidSimple[36][198] = (byte)4;
	geoidSimple[36][199] = (byte)5;
	geoidSimple[36][200] = (byte)7;
	geoidSimple[36][201] = (byte)8;
	geoidSimple[36][202] = (byte)9;
	geoidSimple[36][203] = (byte)10;
	geoidSimple[36][204] = (byte)10;
	geoidSimple[36][205] = (byte)11;
	geoidSimple[36][206] = (byte)10;
	geoidSimple[36][207] = (byte)10;
	geoidSimple[36][208] = (byte)9;
	geoidSimple[36][209] = (byte)9;
	geoidSimple[36][210] = (byte)8;
	geoidSimple[36][211] = (byte)8;
	geoidSimple[36][212] = (byte)6;
	geoidSimple[36][213] = (byte)5;
	geoidSimple[36][214] = (byte)4;
	geoidSimple[36][215] = (byte)3;
	geoidSimple[36][216] = (byte)1;
	geoidSimple[36][217] = (byte)0;
	geoidSimple[36][218] = (byte)-1;
	geoidSimple[36][219] = (byte)-2;
	geoidSimple[36][220] = (byte)-3;
	geoidSimple[36][221] = (byte)-4;
	geoidSimple[36][222] = (byte)-5;
	geoidSimple[36][223] = (byte)-6;
	geoidSimple[36][224] = (byte)-7;
	geoidSimple[36][225] = (byte)-9;
	geoidSimple[36][226] = (byte)-9;
	geoidSimple[36][227] = (byte)-7;
	geoidSimple[36][228] = (byte)-8;
	geoidSimple[36][229] = (byte)-9;
	geoidSimple[36][230] = (byte)-10;
	geoidSimple[36][231] = (byte)-11;
	geoidSimple[36][232] = (byte)-10;
	geoidSimple[36][233] = (byte)-10;
	geoidSimple[36][234] = (byte)-11;
	geoidSimple[36][235] = (byte)-12;
	geoidSimple[36][236] = (byte)-12;
	geoidSimple[36][237] = (byte)-13;
	geoidSimple[36][238] = (byte)-13;
	geoidSimple[36][239] = (byte)-13;
	geoidSimple[36][240] = (byte)-14;
	geoidSimple[36][241] = (byte)-14;
	geoidSimple[36][242] = (byte)-15;
	geoidSimple[36][243] = (byte)-16;
	geoidSimple[36][244] = (byte)-17;
	geoidSimple[36][245] = (byte)-18;
	geoidSimple[36][246] = (byte)-20;
	geoidSimple[36][247] = (byte)-21;
	geoidSimple[36][248] = (byte)-22;
	geoidSimple[36][249] = (byte)-23;
	geoidSimple[36][250] = (byte)-23;
	geoidSimple[36][251] = (byte)-23;
	geoidSimple[36][252] = (byte)-24;
	geoidSimple[36][253] = (byte)-24;
	geoidSimple[36][254] = (byte)-25;
	geoidSimple[36][255] = (byte)-25;
	geoidSimple[36][256] = (byte)-27;
	geoidSimple[36][257] = (byte)-28;
	geoidSimple[36][258] = (byte)-29;
	geoidSimple[36][259] = (byte)-29;
	geoidSimple[36][260] = (byte)-30;
	geoidSimple[36][261] = (byte)-32;
	geoidSimple[36][262] = (byte)-34;
	geoidSimple[36][263] = (byte)-35;
	geoidSimple[36][264] = (byte)-36;
	geoidSimple[36][265] = (byte)-37;
	geoidSimple[36][266] = (byte)-38;
	geoidSimple[36][267] = (byte)-39;
	geoidSimple[36][268] = (byte)-40;
	geoidSimple[36][269] = (byte)-41;
	geoidSimple[36][270] = (byte)-42;
	geoidSimple[36][271] = (byte)-43;
	geoidSimple[36][272] = (byte)-44;
	geoidSimple[36][273] = (byte)-45;
	geoidSimple[36][274] = (byte)-45;
	geoidSimple[36][275] = (byte)-45;
	geoidSimple[36][276] = (byte)-44;
	geoidSimple[36][277] = (byte)-44;
	geoidSimple[36][278] = (byte)-44;
	geoidSimple[36][279] = (byte)-44;
	geoidSimple[36][280] = (byte)-43;
	geoidSimple[36][281] = (byte)-43;
	geoidSimple[36][282] = (byte)-41;
	geoidSimple[36][283] = (byte)-40;
	geoidSimple[36][284] = (byte)-38;
	geoidSimple[36][285] = (byte)-36;
	geoidSimple[36][286] = (byte)-33;
	geoidSimple[36][287] = (byte)-31;
	geoidSimple[36][288] = (byte)-29;
	geoidSimple[36][289] = (byte)-27;
	geoidSimple[36][290] = (byte)-25;
	geoidSimple[36][291] = (byte)-23;
	geoidSimple[36][292] = (byte)-22;
	geoidSimple[36][293] = (byte)-21;
	geoidSimple[36][294] = (byte)-19;
	geoidSimple[36][295] = (byte)-18;
	geoidSimple[36][296] = (byte)-17;
	geoidSimple[36][297] = (byte)-15;
	geoidSimple[36][298] = (byte)-13;
	geoidSimple[36][299] = (byte)-11;
	geoidSimple[36][300] = (byte)-6;
	geoidSimple[36][301] = (byte)-2;
	geoidSimple[36][302] = (byte)0;
	geoidSimple[36][303] = (byte)4;
	geoidSimple[36][304] = (byte)7;
	geoidSimple[36][305] = (byte)11;
	geoidSimple[36][306] = (byte)14;
	geoidSimple[36][307] = (byte)16;
	geoidSimple[36][308] = (byte)19;
	geoidSimple[36][309] = (byte)21;
	geoidSimple[36][310] = (byte)24;
	geoidSimple[36][311] = (byte)27;
	geoidSimple[36][312] = (byte)30;
	geoidSimple[36][313] = (byte)32;
	geoidSimple[36][314] = (byte)35;
	geoidSimple[36][315] = (byte)38;
	geoidSimple[36][316] = (byte)40;
	geoidSimple[36][317] = (byte)42;
	geoidSimple[36][318] = (byte)45;
	geoidSimple[36][319] = (byte)47;
	geoidSimple[36][320] = (byte)49;
	geoidSimple[36][321] = (byte)51;
	geoidSimple[36][322] = (byte)53;
	geoidSimple[36][323] = (byte)56;
	geoidSimple[36][324] = (byte)58;
	geoidSimple[36][325] = (byte)59;
	geoidSimple[36][326] = (byte)59;
	geoidSimple[36][327] = (byte)59;
	geoidSimple[36][328] = (byte)60;
	geoidSimple[36][329] = (byte)60;
	geoidSimple[36][330] = (byte)60;
	geoidSimple[36][331] = (byte)60;
	geoidSimple[36][332] = (byte)60;
	geoidSimple[36][333] = (byte)61;
	geoidSimple[36][334] = (byte)61;
	geoidSimple[36][335] = (byte)61;
	geoidSimple[36][336] = (byte)60;
	geoidSimple[36][337] = (byte)60;
	geoidSimple[36][338] = (byte)60;
	geoidSimple[36][339] = (byte)60;
	geoidSimple[36][340] = (byte)60;
	geoidSimple[36][341] = (byte)60;
	geoidSimple[36][342] = (byte)60;
	geoidSimple[36][343] = (byte)59;
	geoidSimple[36][344] = (byte)58;
	geoidSimple[36][345] = (byte)59;
	geoidSimple[36][346] = (byte)60;
	geoidSimple[36][347] = (byte)60;
	geoidSimple[36][348] = (byte)60;
	geoidSimple[36][349] = (byte)59;
	geoidSimple[36][350] = (byte)58;
	geoidSimple[36][351] = (byte)57;
	geoidSimple[36][352] = (byte)56;
	geoidSimple[36][353] = (byte)56;
	geoidSimple[36][354] = (byte)55;
	geoidSimple[36][355] = (byte)54;
	geoidSimple[36][356] = (byte)53;
	geoidSimple[36][357] = (byte)52;
	geoidSimple[36][358] = (byte)50;
	geoidSimple[36][359] = (byte)47;
	}
		/** Row 37*/
	private static void init37() {
	geoidSimple[37][0] = (byte)45;
	geoidSimple[37][1] = (byte)44;
	geoidSimple[37][2] = (byte)43;
	geoidSimple[37][3] = (byte)43;
	geoidSimple[37][4] = (byte)42;
	geoidSimple[37][5] = (byte)42;
	geoidSimple[37][6] = (byte)42;
	geoidSimple[37][7] = (byte)42;
	geoidSimple[37][8] = (byte)42;
	geoidSimple[37][9] = (byte)42;
	geoidSimple[37][10] = (byte)42;
	geoidSimple[37][11] = (byte)41;
	geoidSimple[37][12] = (byte)40;
	geoidSimple[37][13] = (byte)39;
	geoidSimple[37][14] = (byte)37;
	geoidSimple[37][15] = (byte)36;
	geoidSimple[37][16] = (byte)35;
	geoidSimple[37][17] = (byte)33;
	geoidSimple[37][18] = (byte)31;
	geoidSimple[37][19] = (byte)31;
	geoidSimple[37][20] = (byte)31;
	geoidSimple[37][21] = (byte)30;
	geoidSimple[37][22] = (byte)28;
	geoidSimple[37][23] = (byte)28;
	geoidSimple[37][24] = (byte)27;
	geoidSimple[37][25] = (byte)26;
	geoidSimple[37][26] = (byte)25;
	geoidSimple[37][27] = (byte)23;
	geoidSimple[37][28] = (byte)21;
	geoidSimple[37][29] = (byte)19;
	geoidSimple[37][30] = (byte)20;
	geoidSimple[37][31] = (byte)19;
	geoidSimple[37][32] = (byte)18;
	geoidSimple[37][33] = (byte)17;
	geoidSimple[37][34] = (byte)16;
	geoidSimple[37][35] = (byte)15;
	geoidSimple[37][36] = (byte)13;
	geoidSimple[37][37] = (byte)12;
	geoidSimple[37][38] = (byte)11;
	geoidSimple[37][39] = (byte)9;
	geoidSimple[37][40] = (byte)8;
	geoidSimple[37][41] = (byte)7;
	geoidSimple[37][42] = (byte)7;
	geoidSimple[37][43] = (byte)6;
	geoidSimple[37][44] = (byte)4;
	geoidSimple[37][45] = (byte)3;
	geoidSimple[37][46] = (byte)2;
	geoidSimple[37][47] = (byte)1;
	geoidSimple[37][48] = (byte)0;
	geoidSimple[37][49] = (byte)-1;
	geoidSimple[37][50] = (byte)-2;
	geoidSimple[37][51] = (byte)-3;
	geoidSimple[37][52] = (byte)-4;
	geoidSimple[37][53] = (byte)-5;
	geoidSimple[37][54] = (byte)-7;
	geoidSimple[37][55] = (byte)-10;
	geoidSimple[37][56] = (byte)-12;
	geoidSimple[37][57] = (byte)-12;
	geoidSimple[37][58] = (byte)-11;
	geoidSimple[37][59] = (byte)-13;
	geoidSimple[37][60] = (byte)-15;
	geoidSimple[37][61] = (byte)-18;
	geoidSimple[37][62] = (byte)-20;
	geoidSimple[37][63] = (byte)-22;
	geoidSimple[37][64] = (byte)-23;
	geoidSimple[37][65] = (byte)-24;
	geoidSimple[37][66] = (byte)-24;
	geoidSimple[37][67] = (byte)-25;
	geoidSimple[37][68] = (byte)-26;
	geoidSimple[37][69] = (byte)-27;
	geoidSimple[37][70] = (byte)-28;
	geoidSimple[37][71] = (byte)-29;
	geoidSimple[37][72] = (byte)-31;
	geoidSimple[37][73] = (byte)-32;
	geoidSimple[37][74] = (byte)-34;
	geoidSimple[37][75] = (byte)-35;
	geoidSimple[37][76] = (byte)-37;
	geoidSimple[37][77] = (byte)-38;
	geoidSimple[37][78] = (byte)-39;
	geoidSimple[37][79] = (byte)-39;
	geoidSimple[37][80] = (byte)-40;
	geoidSimple[37][81] = (byte)-40;
	geoidSimple[37][82] = (byte)-41;
	geoidSimple[37][83] = (byte)-41;
	geoidSimple[37][84] = (byte)-42;
	geoidSimple[37][85] = (byte)-42;
	geoidSimple[37][86] = (byte)-41;
	geoidSimple[37][87] = (byte)-40;
	geoidSimple[37][88] = (byte)-39;
	geoidSimple[37][89] = (byte)-39;
	geoidSimple[37][90] = (byte)-39;
	geoidSimple[37][91] = (byte)-40;
	geoidSimple[37][92] = (byte)-40;
	geoidSimple[37][93] = (byte)-40;
	geoidSimple[37][94] = (byte)-40;
	geoidSimple[37][95] = (byte)-39;
	geoidSimple[37][96] = (byte)-39;
	geoidSimple[37][97] = (byte)-38;
	geoidSimple[37][98] = (byte)-37;
	geoidSimple[37][99] = (byte)-36;
	geoidSimple[37][100] = (byte)-36;
	geoidSimple[37][101] = (byte)-36;
	geoidSimple[37][102] = (byte)-37;
	geoidSimple[37][103] = (byte)-37;
	geoidSimple[37][104] = (byte)-37;
	geoidSimple[37][105] = (byte)-36;
	geoidSimple[37][106] = (byte)-37;
	geoidSimple[37][107] = (byte)-36;
	geoidSimple[37][108] = (byte)-32;
	geoidSimple[37][109] = (byte)-30;
	geoidSimple[37][110] = (byte)-28;
	geoidSimple[37][111] = (byte)-26;
	geoidSimple[37][112] = (byte)-23;
	geoidSimple[37][113] = (byte)-22;
	geoidSimple[37][114] = (byte)-19;
	geoidSimple[37][115] = (byte)-18;
	geoidSimple[37][116] = (byte)-15;
	geoidSimple[37][117] = (byte)-13;
	geoidSimple[37][118] = (byte)-11;
	geoidSimple[37][119] = (byte)-8;
	geoidSimple[37][120] = (byte)-7;
	geoidSimple[37][121] = (byte)-4;
	geoidSimple[37][122] = (byte)-1;
	geoidSimple[37][123] = (byte)0;
	geoidSimple[37][124] = (byte)2;
	geoidSimple[37][125] = (byte)4;
	geoidSimple[37][126] = (byte)5;
	geoidSimple[37][127] = (byte)7;
	geoidSimple[37][128] = (byte)8;
	geoidSimple[37][129] = (byte)10;
	geoidSimple[37][130] = (byte)12;
	geoidSimple[37][131] = (byte)13;
	geoidSimple[37][132] = (byte)15;
	geoidSimple[37][133] = (byte)17;
	geoidSimple[37][134] = (byte)18;
	geoidSimple[37][135] = (byte)18;
	geoidSimple[37][136] = (byte)17;
	geoidSimple[37][137] = (byte)18;
	geoidSimple[37][138] = (byte)18;
	geoidSimple[37][139] = (byte)19;
	geoidSimple[37][140] = (byte)19;
	geoidSimple[37][141] = (byte)18;
	geoidSimple[37][142] = (byte)18;
	geoidSimple[37][143] = (byte)17;
	geoidSimple[37][144] = (byte)16;
	geoidSimple[37][145] = (byte)15;
	geoidSimple[37][146] = (byte)16;
	geoidSimple[37][147] = (byte)17;
	geoidSimple[37][148] = (byte)18;
	geoidSimple[37][149] = (byte)18;
	geoidSimple[37][150] = (byte)18;
	geoidSimple[37][151] = (byte)19;
	geoidSimple[37][152] = (byte)20;
	geoidSimple[37][153] = (byte)21;
	geoidSimple[37][154] = (byte)22;
	geoidSimple[37][155] = (byte)23;
	geoidSimple[37][156] = (byte)23;
	geoidSimple[37][157] = (byte)24;
	geoidSimple[37][158] = (byte)21;
	geoidSimple[37][159] = (byte)14;
	geoidSimple[37][160] = (byte)8;
	geoidSimple[37][161] = (byte)0;
	geoidSimple[37][162] = (byte)0;
	geoidSimple[37][163] = (byte)5;
	geoidSimple[37][164] = (byte)9;
	geoidSimple[37][165] = (byte)9;
	geoidSimple[37][166] = (byte)8;
	geoidSimple[37][167] = (byte)5;
	geoidSimple[37][168] = (byte)1;
	geoidSimple[37][169] = (byte)-1;
	geoidSimple[37][170] = (byte)-1;
	geoidSimple[37][171] = (byte)-1;
	geoidSimple[37][172] = (byte)2;
	geoidSimple[37][173] = (byte)7;
	geoidSimple[37][174] = (byte)5;
	geoidSimple[37][175] = (byte)3;
	geoidSimple[37][176] = (byte)3;
	geoidSimple[37][177] = (byte)2;
	geoidSimple[37][178] = (byte)3;
	geoidSimple[37][179] = (byte)4;
	geoidSimple[37][LAT_GRID_SIZE] = (byte)3;
	geoidSimple[37][181] = (byte)1;
	geoidSimple[37][182] = (byte)2;
	geoidSimple[37][183] = (byte)2;
	geoidSimple[37][184] = (byte)4;
	geoidSimple[37][185] = (byte)5;
	geoidSimple[37][186] = (byte)7;
	geoidSimple[37][187] = (byte)8;
	geoidSimple[37][188] = (byte)9;
	geoidSimple[37][189] = (byte)10;
	geoidSimple[37][190] = (byte)10;
	geoidSimple[37][191] = (byte)8;
	geoidSimple[37][192] = (byte)5;
	geoidSimple[37][193] = (byte)1;
	geoidSimple[37][194] = (byte)0;
	geoidSimple[37][195] = (byte)1;
	geoidSimple[37][196] = (byte)3;
	geoidSimple[37][197] = (byte)6;
	geoidSimple[37][198] = (byte)8;
	geoidSimple[37][199] = (byte)9;
	geoidSimple[37][200] = (byte)10;
	geoidSimple[37][201] = (byte)10;
	geoidSimple[37][202] = (byte)10;
	geoidSimple[37][203] = (byte)11;
	geoidSimple[37][204] = (byte)11;
	geoidSimple[37][205] = (byte)10;
	geoidSimple[37][206] = (byte)9;
	geoidSimple[37][207] = (byte)9;
	geoidSimple[37][208] = (byte)8;
	geoidSimple[37][209] = (byte)7;
	geoidSimple[37][210] = (byte)6;
	geoidSimple[37][211] = (byte)5;
	geoidSimple[37][212] = (byte)4;
	geoidSimple[37][213] = (byte)3;
	geoidSimple[37][214] = (byte)2;
	geoidSimple[37][215] = (byte)1;
	geoidSimple[37][216] = (byte)0;
	geoidSimple[37][217] = (byte)-1;
	geoidSimple[37][218] = (byte)-3;
	geoidSimple[37][219] = (byte)-4;
	geoidSimple[37][220] = (byte)-5;
	geoidSimple[37][221] = (byte)-7;
	geoidSimple[37][222] = (byte)-8;
	geoidSimple[37][223] = (byte)-9;
	geoidSimple[37][224] = (byte)-9;
	geoidSimple[37][225] = (byte)-10;
	geoidSimple[37][226] = (byte)-12;
	geoidSimple[37][227] = (byte)-12;
	geoidSimple[37][228] = (byte)-11;
	geoidSimple[37][229] = (byte)-11;
	geoidSimple[37][230] = (byte)-12;
	geoidSimple[37][231] = (byte)-13;
	geoidSimple[37][232] = (byte)-13;
	geoidSimple[37][233] = (byte)-12;
	geoidSimple[37][234] = (byte)-11;
	geoidSimple[37][235] = (byte)-11;
	geoidSimple[37][236] = (byte)-12;
	geoidSimple[37][237] = (byte)-13;
	geoidSimple[37][238] = (byte)-13;
	geoidSimple[37][239] = (byte)-14;
	geoidSimple[37][240] = (byte)-14;
	geoidSimple[37][241] = (byte)-14;
	geoidSimple[37][242] = (byte)-13;
	geoidSimple[37][243] = (byte)-13;
	geoidSimple[37][244] = (byte)-16;
	geoidSimple[37][245] = (byte)-17;
	geoidSimple[37][246] = (byte)-19;
	geoidSimple[37][247] = (byte)-20;
	geoidSimple[37][248] = (byte)-21;
	geoidSimple[37][249] = (byte)-21;
	geoidSimple[37][250] = (byte)-20;
	geoidSimple[37][251] = (byte)-21;
	geoidSimple[37][252] = (byte)-21;
	geoidSimple[37][253] = (byte)-22;
	geoidSimple[37][254] = (byte)-23;
	geoidSimple[37][255] = (byte)-23;
	geoidSimple[37][256] = (byte)-24;
	geoidSimple[37][257] = (byte)-25;
	geoidSimple[37][258] = (byte)-26;
	geoidSimple[37][259] = (byte)-28;
	geoidSimple[37][260] = (byte)-30;
	geoidSimple[37][261] = (byte)-31;
	geoidSimple[37][262] = (byte)-33;
	geoidSimple[37][263] = (byte)-33;
	geoidSimple[37][264] = (byte)-33;
	geoidSimple[37][265] = (byte)-34;
	geoidSimple[37][266] = (byte)-35;
	geoidSimple[37][267] = (byte)-37;
	geoidSimple[37][268] = (byte)-38;
	geoidSimple[37][269] = (byte)-39;
	geoidSimple[37][270] = (byte)-40;
	geoidSimple[37][271] = (byte)-42;
	geoidSimple[37][272] = (byte)-43;
	geoidSimple[37][273] = (byte)-43;
	geoidSimple[37][274] = (byte)-44;
	geoidSimple[37][275] = (byte)-44;
	geoidSimple[37][276] = (byte)-44;
	geoidSimple[37][277] = (byte)-44;
	geoidSimple[37][278] = (byte)-44;
	geoidSimple[37][279] = (byte)-44;
	geoidSimple[37][280] = (byte)-44;
	geoidSimple[37][281] = (byte)-43;
	geoidSimple[37][282] = (byte)-41;
	geoidSimple[37][283] = (byte)-40;
	geoidSimple[37][284] = (byte)-38;
	geoidSimple[37][285] = (byte)-35;
	geoidSimple[37][286] = (byte)-33;
	geoidSimple[37][287] = (byte)-31;
	geoidSimple[37][288] = (byte)-29;
	geoidSimple[37][289] = (byte)-28;
	geoidSimple[37][290] = (byte)-26;
	geoidSimple[37][291] = (byte)-24;
	geoidSimple[37][292] = (byte)-23;
	geoidSimple[37][293] = (byte)-20;
	geoidSimple[37][294] = (byte)-18;
	geoidSimple[37][295] = (byte)-16;
	geoidSimple[37][296] = (byte)-15;
	geoidSimple[37][297] = (byte)-14;
	geoidSimple[37][298] = (byte)-11;
	geoidSimple[37][299] = (byte)-8;
	geoidSimple[37][300] = (byte)-5;
	geoidSimple[37][301] = (byte)-2;
	geoidSimple[37][302] = (byte)0;
	geoidSimple[37][303] = (byte)3;
	geoidSimple[37][304] = (byte)7;
	geoidSimple[37][305] = (byte)10;
	geoidSimple[37][306] = (byte)13;
	geoidSimple[37][307] = (byte)16;
	geoidSimple[37][308] = (byte)19;
	geoidSimple[37][309] = (byte)21;
	geoidSimple[37][310] = (byte)23;
	geoidSimple[37][311] = (byte)25;
	geoidSimple[37][312] = (byte)28;
	geoidSimple[37][313] = (byte)31;
	geoidSimple[37][314] = (byte)34;
	geoidSimple[37][315] = (byte)36;
	geoidSimple[37][316] = (byte)38;
	geoidSimple[37][317] = (byte)41;
	geoidSimple[37][318] = (byte)43;
	geoidSimple[37][319] = (byte)45;
	geoidSimple[37][320] = (byte)47;
	geoidSimple[37][321] = (byte)49;
	geoidSimple[37][322] = (byte)51;
	geoidSimple[37][323] = (byte)53;
	geoidSimple[37][324] = (byte)55;
	geoidSimple[37][325] = (byte)57;
	geoidSimple[37][326] = (byte)58;
	geoidSimple[37][327] = (byte)59;
	geoidSimple[37][328] = (byte)59;
	geoidSimple[37][329] = (byte)60;
	geoidSimple[37][330] = (byte)60;
	geoidSimple[37][331] = (byte)60;
	geoidSimple[37][332] = (byte)61;
	geoidSimple[37][333] = (byte)61;
	geoidSimple[37][334] = (byte)61;
	geoidSimple[37][335] = (byte)61;
	geoidSimple[37][336] = (byte)60;
	geoidSimple[37][337] = (byte)60;
	geoidSimple[37][338] = (byte)60;
	geoidSimple[37][339] = (byte)60;
	geoidSimple[37][340] = (byte)60;
	geoidSimple[37][341] = (byte)59;
	geoidSimple[37][342] = (byte)58;
	geoidSimple[37][343] = (byte)58;
	geoidSimple[37][344] = (byte)59;
	geoidSimple[37][345] = (byte)61;
	geoidSimple[37][346] = (byte)60;
	geoidSimple[37][347] = (byte)60;
	geoidSimple[37][348] = (byte)60;
	geoidSimple[37][349] = (byte)59;
	geoidSimple[37][350] = (byte)58;
	geoidSimple[37][351] = (byte)57;
	geoidSimple[37][352] = (byte)56;
	geoidSimple[37][353] = (byte)55;
	geoidSimple[37][354] = (byte)54;
	geoidSimple[37][355] = (byte)54;
	geoidSimple[37][356] = (byte)53;
	geoidSimple[37][357] = (byte)51;
	geoidSimple[37][358] = (byte)49;
	geoidSimple[37][359] = (byte)47;
	}
		/** Row 38*/
	private static void init38() {
	geoidSimple[38][0] = (byte)45;
	geoidSimple[38][1] = (byte)44;
	geoidSimple[38][2] = (byte)44;
	geoidSimple[38][3] = (byte)44;
	geoidSimple[38][4] = (byte)44;
	geoidSimple[38][5] = (byte)44;
	geoidSimple[38][6] = (byte)44;
	geoidSimple[38][7] = (byte)45;
	geoidSimple[38][8] = (byte)46;
	geoidSimple[38][9] = (byte)45;
	geoidSimple[38][10] = (byte)45;
	geoidSimple[38][11] = (byte)44;
	geoidSimple[38][12] = (byte)43;
	geoidSimple[38][13] = (byte)42;
	geoidSimple[38][14] = (byte)41;
	geoidSimple[38][15] = (byte)40;
	geoidSimple[38][16] = (byte)39;
	geoidSimple[38][17] = (byte)37;
	geoidSimple[38][18] = (byte)36;
	geoidSimple[38][19] = (byte)34;
	geoidSimple[38][20] = (byte)33;
	geoidSimple[38][21] = (byte)33;
	geoidSimple[38][22] = (byte)31;
	geoidSimple[38][23] = (byte)29;
	geoidSimple[38][24] = (byte)28;
	geoidSimple[38][25] = (byte)28;
	geoidSimple[38][26] = (byte)28;
	geoidSimple[38][27] = (byte)26;
	geoidSimple[38][28] = (byte)24;
	geoidSimple[38][29] = (byte)22;
	geoidSimple[38][30] = (byte)23;
	geoidSimple[38][31] = (byte)23;
	geoidSimple[38][32] = (byte)21;
	geoidSimple[38][33] = (byte)19;
	geoidSimple[38][34] = (byte)17;
	geoidSimple[38][35] = (byte)15;
	geoidSimple[38][36] = (byte)13;
	geoidSimple[38][37] = (byte)12;
	geoidSimple[38][38] = (byte)11;
	geoidSimple[38][39] = (byte)10;
	geoidSimple[38][40] = (byte)9;
	geoidSimple[38][41] = (byte)7;
	geoidSimple[38][42] = (byte)6;
	geoidSimple[38][43] = (byte)5;
	geoidSimple[38][44] = (byte)4;
	geoidSimple[38][45] = (byte)2;
	geoidSimple[38][46] = (byte)0;
	geoidSimple[38][47] = (byte)-2;
	geoidSimple[38][48] = (byte)-3;
	geoidSimple[38][49] = (byte)-5;
	geoidSimple[38][50] = (byte)-6;
	geoidSimple[38][51] = (byte)-8;
	geoidSimple[38][52] = (byte)-9;
	geoidSimple[38][53] = (byte)-10;
	geoidSimple[38][54] = (byte)-12;
	geoidSimple[38][55] = (byte)-14;
	geoidSimple[38][56] = (byte)-15;
	geoidSimple[38][57] = (byte)-15;
	geoidSimple[38][58] = (byte)-13;
	geoidSimple[38][59] = (byte)-15;
	geoidSimple[38][60] = (byte)-17;
	geoidSimple[38][61] = (byte)-19;
	geoidSimple[38][62] = (byte)-22;
	geoidSimple[38][63] = (byte)-24;
	geoidSimple[38][64] = (byte)-25;
	geoidSimple[38][65] = (byte)-25;
	geoidSimple[38][66] = (byte)-26;
	geoidSimple[38][67] = (byte)-27;
	geoidSimple[38][68] = (byte)-28;
	geoidSimple[38][69] = (byte)-29;
	geoidSimple[38][70] = (byte)-30;
	geoidSimple[38][71] = (byte)-31;
	geoidSimple[38][72] = (byte)-32;
	geoidSimple[38][73] = (byte)-34;
	geoidSimple[38][74] = (byte)-35;
	geoidSimple[38][75] = (byte)-37;
	geoidSimple[38][76] = (byte)-38;
	geoidSimple[38][77] = (byte)-39;
	geoidSimple[38][78] = (byte)-40;
	geoidSimple[38][79] = (byte)-41;
	geoidSimple[38][80] = (byte)-41;
	geoidSimple[38][81] = (byte)-41;
	geoidSimple[38][82] = (byte)-42;
	geoidSimple[38][83] = (byte)-42;
	geoidSimple[38][84] = (byte)-42;
	geoidSimple[38][85] = (byte)-42;
	geoidSimple[38][86] = (byte)-41;
	geoidSimple[38][87] = (byte)-40;
	geoidSimple[38][88] = (byte)-39;
	geoidSimple[38][89] = (byte)-38;
	geoidSimple[38][90] = (byte)-40;
	geoidSimple[38][91] = (byte)-41;
	geoidSimple[38][92] = (byte)-42;
	geoidSimple[38][93] = (byte)-42;
	geoidSimple[38][94] = (byte)-43;
	geoidSimple[38][95] = (byte)-42;
	geoidSimple[38][96] = (byte)-41;
	geoidSimple[38][97] = (byte)-40;
	geoidSimple[38][98] = (byte)-39;
	geoidSimple[38][99] = (byte)-38;
	geoidSimple[38][100] = (byte)-37;
	geoidSimple[38][101] = (byte)-37;
	geoidSimple[38][102] = (byte)-38;
	geoidSimple[38][103] = (byte)-38;
	geoidSimple[38][104] = (byte)-39;
	geoidSimple[38][105] = (byte)-40;
	geoidSimple[38][106] = (byte)-37;
	geoidSimple[38][107] = (byte)-35;
	geoidSimple[38][108] = (byte)-33;
	geoidSimple[38][109] = (byte)-31;
	geoidSimple[38][110] = (byte)-28;
	geoidSimple[38][111] = (byte)-26;
	geoidSimple[38][112] = (byte)-24;
	geoidSimple[38][113] = (byte)-22;
	geoidSimple[38][114] = (byte)-20;
	geoidSimple[38][115] = (byte)-17;
	geoidSimple[38][116] = (byte)-15;
	geoidSimple[38][117] = (byte)-12;
	geoidSimple[38][118] = (byte)-10;
	geoidSimple[38][119] = (byte)-7;
	geoidSimple[38][120] = (byte)-4;
	geoidSimple[38][121] = (byte)-1;
	geoidSimple[38][122] = (byte)1;
	geoidSimple[38][123] = (byte)4;
	geoidSimple[38][124] = (byte)6;
	geoidSimple[38][125] = (byte)7;
	geoidSimple[38][126] = (byte)7;
	geoidSimple[38][127] = (byte)9;
	geoidSimple[38][128] = (byte)10;
	geoidSimple[38][129] = (byte)11;
	geoidSimple[38][130] = (byte)13;
	geoidSimple[38][131] = (byte)15;
	geoidSimple[38][132] = (byte)16;
	geoidSimple[38][133] = (byte)18;
	geoidSimple[38][134] = (byte)19;
	geoidSimple[38][135] = (byte)19;
	geoidSimple[38][136] = (byte)18;
	geoidSimple[38][137] = (byte)19;
	geoidSimple[38][138] = (byte)20;
	geoidSimple[38][139] = (byte)20;
	geoidSimple[38][140] = (byte)20;
	geoidSimple[38][141] = (byte)19;
	geoidSimple[38][142] = (byte)18;
	geoidSimple[38][143] = (byte)18;
	geoidSimple[38][144] = (byte)17;
	geoidSimple[38][145] = (byte)16;
	geoidSimple[38][146] = (byte)16;
	geoidSimple[38][147] = (byte)17;
	geoidSimple[38][148] = (byte)18;
	geoidSimple[38][149] = (byte)18;
	geoidSimple[38][150] = (byte)19;
	geoidSimple[38][151] = (byte)19;
	geoidSimple[38][152] = (byte)20;
	geoidSimple[38][153] = (byte)21;
	geoidSimple[38][154] = (byte)22;
	geoidSimple[38][155] = (byte)23;
	geoidSimple[38][156] = (byte)24;
	geoidSimple[38][157] = (byte)24;
	geoidSimple[38][158] = (byte)19;
	geoidSimple[38][159] = (byte)6;
	geoidSimple[38][160] = (byte)0;
	geoidSimple[38][161] = (byte)2;
	geoidSimple[38][162] = (byte)6;
	geoidSimple[38][163] = (byte)7;
	geoidSimple[38][164] = (byte)8;
	geoidSimple[38][165] = (byte)8;
	geoidSimple[38][166] = (byte)7;
	geoidSimple[38][167] = (byte)7;
	geoidSimple[38][168] = (byte)5;
	geoidSimple[38][169] = (byte)3;
	geoidSimple[38][170] = (byte)1;
	geoidSimple[38][171] = (byte)0;
	geoidSimple[38][172] = (byte)-3;
	geoidSimple[38][173] = (byte)-4;
	geoidSimple[38][174] = (byte)-3;
	geoidSimple[38][175] = (byte)0;
	geoidSimple[38][176] = (byte)-1;
	geoidSimple[38][177] = (byte)0;
	geoidSimple[38][178] = (byte)2;
	geoidSimple[38][179] = (byte)2;
	geoidSimple[38][LAT_GRID_SIZE] = (byte)1;
	geoidSimple[38][181] = (byte)2;
	geoidSimple[38][182] = (byte)2;
	geoidSimple[38][183] = (byte)2;
	geoidSimple[38][184] = (byte)1;
	geoidSimple[38][185] = (byte)0;
	geoidSimple[38][186] = (byte)-1;
	geoidSimple[38][187] = (byte)-1;
	geoidSimple[38][188] = (byte)-1;
	geoidSimple[38][189] = (byte)-3;
	geoidSimple[38][190] = (byte)-2;
	geoidSimple[38][191] = (byte)-1;
	geoidSimple[38][192] = (byte)0;
	geoidSimple[38][193] = (byte)4;
	geoidSimple[38][194] = (byte)6;
	geoidSimple[38][195] = (byte)8;
	geoidSimple[38][196] = (byte)9;
	geoidSimple[38][197] = (byte)10;
	geoidSimple[38][198] = (byte)11;
	geoidSimple[38][199] = (byte)11;
	geoidSimple[38][200] = (byte)10;
	geoidSimple[38][201] = (byte)10;
	geoidSimple[38][202] = (byte)9;
	geoidSimple[38][203] = (byte)8;
	geoidSimple[38][204] = (byte)8;
	geoidSimple[38][205] = (byte)8;
	geoidSimple[38][206] = (byte)7;
	geoidSimple[38][207] = (byte)6;
	geoidSimple[38][208] = (byte)5;
	geoidSimple[38][209] = (byte)4;
	geoidSimple[38][210] = (byte)4;
	geoidSimple[38][211] = (byte)3;
	geoidSimple[38][212] = (byte)2;
	geoidSimple[38][213] = (byte)1;
	geoidSimple[38][214] = (byte)0;
	geoidSimple[38][215] = (byte)-1;
	geoidSimple[38][216] = (byte)-2;
	geoidSimple[38][217] = (byte)-3;
	geoidSimple[38][218] = (byte)-5;
	geoidSimple[38][219] = (byte)-6;
	geoidSimple[38][220] = (byte)-7;
	geoidSimple[38][221] = (byte)-9;
	geoidSimple[38][222] = (byte)-10;
	geoidSimple[38][223] = (byte)-11;
	geoidSimple[38][224] = (byte)-12;
	geoidSimple[38][225] = (byte)-12;
	geoidSimple[38][226] = (byte)-13;
	geoidSimple[38][227] = (byte)-14;
	geoidSimple[38][228] = (byte)-14;
	geoidSimple[38][229] = (byte)-15;
	geoidSimple[38][230] = (byte)-15;
	geoidSimple[38][231] = (byte)-15;
	geoidSimple[38][232] = (byte)-14;
	geoidSimple[38][233] = (byte)-13;
	geoidSimple[38][234] = (byte)-12;
	geoidSimple[38][235] = (byte)-12;
	geoidSimple[38][236] = (byte)-12;
	geoidSimple[38][237] = (byte)-13;
	geoidSimple[38][238] = (byte)-14;
	geoidSimple[38][239] = (byte)-14;
	geoidSimple[38][240] = (byte)-15;
	geoidSimple[38][241] = (byte)-15;
	geoidSimple[38][242] = (byte)-15;
	geoidSimple[38][243] = (byte)-13;
	geoidSimple[38][244] = (byte)-12;
	geoidSimple[38][245] = (byte)-16;
	geoidSimple[38][246] = (byte)-18;
	geoidSimple[38][247] = (byte)-18;
	geoidSimple[38][248] = (byte)-19;
	geoidSimple[38][249] = (byte)-19;
	geoidSimple[38][250] = (byte)-19;
	geoidSimple[38][251] = (byte)-20;
	geoidSimple[38][252] = (byte)-20;
	geoidSimple[38][253] = (byte)-21;
	geoidSimple[38][254] = (byte)-21;
	geoidSimple[38][255] = (byte)-21;
	geoidSimple[38][256] = (byte)-22;
	geoidSimple[38][257] = (byte)-23;
	geoidSimple[38][258] = (byte)-24;
	geoidSimple[38][259] = (byte)-27;
	geoidSimple[38][260] = (byte)-29;
	geoidSimple[38][261] = (byte)-30;
	geoidSimple[38][262] = (byte)-31;
	geoidSimple[38][263] = (byte)-32;
	geoidSimple[38][264] = (byte)-32;
	geoidSimple[38][265] = (byte)-32;
	geoidSimple[38][266] = (byte)-34;
	geoidSimple[38][267] = (byte)-35;
	geoidSimple[38][268] = (byte)-36;
	geoidSimple[38][269] = (byte)-37;
	geoidSimple[38][270] = (byte)-38;
	geoidSimple[38][271] = (byte)-40;
	geoidSimple[38][272] = (byte)-41;
	geoidSimple[38][273] = (byte)-41;
	geoidSimple[38][274] = (byte)-41;
	geoidSimple[38][275] = (byte)-41;
	geoidSimple[38][276] = (byte)-42;
	geoidSimple[38][277] = (byte)-42;
	geoidSimple[38][278] = (byte)-42;
	geoidSimple[38][279] = (byte)-42;
	geoidSimple[38][280] = (byte)-42;
	geoidSimple[38][281] = (byte)-42;
	geoidSimple[38][282] = (byte)-40;
	geoidSimple[38][283] = (byte)-39;
	geoidSimple[38][284] = (byte)-37;
	geoidSimple[38][285] = (byte)-35;
	geoidSimple[38][286] = (byte)-33;
	geoidSimple[38][287] = (byte)-32;
	geoidSimple[38][288] = (byte)-31;
	geoidSimple[38][289] = (byte)-28;
	geoidSimple[38][290] = (byte)-26;
	geoidSimple[38][291] = (byte)-24;
	geoidSimple[38][292] = (byte)-21;
	geoidSimple[38][293] = (byte)-19;
	geoidSimple[38][294] = (byte)-18;
	geoidSimple[38][295] = (byte)-17;
	geoidSimple[38][296] = (byte)-16;
	geoidSimple[38][297] = (byte)-14;
	geoidSimple[38][298] = (byte)-12;
	geoidSimple[38][299] = (byte)-10;
	geoidSimple[38][300] = (byte)-7;
	geoidSimple[38][301] = (byte)-4;
	geoidSimple[38][302] = (byte)-1;
	geoidSimple[38][303] = (byte)1;
	geoidSimple[38][304] = (byte)5;
	geoidSimple[38][305] = (byte)10;
	geoidSimple[38][306] = (byte)12;
	geoidSimple[38][307] = (byte)15;
	geoidSimple[38][308] = (byte)18;
	geoidSimple[38][309] = (byte)21;
	geoidSimple[38][310] = (byte)23;
	geoidSimple[38][311] = (byte)24;
	geoidSimple[38][312] = (byte)26;
	geoidSimple[38][313] = (byte)29;
	geoidSimple[38][314] = (byte)32;
	geoidSimple[38][315] = (byte)34;
	geoidSimple[38][316] = (byte)37;
	geoidSimple[38][317] = (byte)39;
	geoidSimple[38][318] = (byte)42;
	geoidSimple[38][319] = (byte)44;
	geoidSimple[38][320] = (byte)47;
	geoidSimple[38][321] = (byte)49;
	geoidSimple[38][322] = (byte)51;
	geoidSimple[38][323] = (byte)52;
	geoidSimple[38][324] = (byte)54;
	geoidSimple[38][325] = (byte)56;
	geoidSimple[38][326] = (byte)57;
	geoidSimple[38][327] = (byte)58;
	geoidSimple[38][328] = (byte)60;
	geoidSimple[38][329] = (byte)61;
	geoidSimple[38][330] = (byte)62;
	geoidSimple[38][331] = (byte)62;
	geoidSimple[38][332] = (byte)62;
	geoidSimple[38][333] = (byte)62;
	geoidSimple[38][334] = (byte)62;
	geoidSimple[38][335] = (byte)62;
	geoidSimple[38][336] = (byte)62;
	geoidSimple[38][337] = (byte)62;
	geoidSimple[38][338] = (byte)62;
	geoidSimple[38][339] = (byte)61;
	geoidSimple[38][340] = (byte)60;
	geoidSimple[38][341] = (byte)58;
	geoidSimple[38][342] = (byte)57;
	geoidSimple[38][343] = (byte)57;
	geoidSimple[38][344] = (byte)58;
	geoidSimple[38][345] = (byte)60;
	geoidSimple[38][346] = (byte)60;
	geoidSimple[38][347] = (byte)59;
	geoidSimple[38][348] = (byte)59;
	geoidSimple[38][349] = (byte)59;
	geoidSimple[38][350] = (byte)58;
	geoidSimple[38][351] = (byte)57;
	geoidSimple[38][352] = (byte)55;
	geoidSimple[38][353] = (byte)54;
	geoidSimple[38][354] = (byte)54;
	geoidSimple[38][355] = (byte)53;
	geoidSimple[38][356] = (byte)52;
	geoidSimple[38][357] = (byte)50;
	geoidSimple[38][358] = (byte)48;
	geoidSimple[38][359] = (byte)46;
	}
		/** Row 39*/
	private static void init39() {
	geoidSimple[39][0] = (byte)44;
	geoidSimple[39][1] = (byte)44;
	geoidSimple[39][2] = (byte)44;
	geoidSimple[39][3] = (byte)44;
	geoidSimple[39][4] = (byte)45;
	geoidSimple[39][5] = (byte)46;
	geoidSimple[39][6] = (byte)47;
	geoidSimple[39][7] = (byte)47;
	geoidSimple[39][8] = (byte)48;
	geoidSimple[39][9] = (byte)47;
	geoidSimple[39][10] = (byte)47;
	geoidSimple[39][11] = (byte)46;
	geoidSimple[39][12] = (byte)46;
	geoidSimple[39][13] = (byte)45;
	geoidSimple[39][14] = (byte)43;
	geoidSimple[39][15] = (byte)43;
	geoidSimple[39][16] = (byte)42;
	geoidSimple[39][17] = (byte)41;
	geoidSimple[39][18] = (byte)40;
	geoidSimple[39][19] = (byte)39;
	geoidSimple[39][20] = (byte)37;
	geoidSimple[39][21] = (byte)35;
	geoidSimple[39][22] = (byte)34;
	geoidSimple[39][23] = (byte)31;
	geoidSimple[39][24] = (byte)30;
	geoidSimple[39][25] = (byte)30;
	geoidSimple[39][26] = (byte)30;
	geoidSimple[39][27] = (byte)29;
	geoidSimple[39][28] = (byte)28;
	geoidSimple[39][29] = (byte)26;
	geoidSimple[39][30] = (byte)25;
	geoidSimple[39][31] = (byte)24;
	geoidSimple[39][32] = (byte)22;
	geoidSimple[39][33] = (byte)20;
	geoidSimple[39][34] = (byte)17;
	geoidSimple[39][35] = (byte)15;
	geoidSimple[39][36] = (byte)13;
	geoidSimple[39][37] = (byte)12;
	geoidSimple[39][38] = (byte)11;
	geoidSimple[39][39] = (byte)10;
	geoidSimple[39][40] = (byte)9;
	geoidSimple[39][41] = (byte)8;
	geoidSimple[39][42] = (byte)6;
	geoidSimple[39][43] = (byte)5;
	geoidSimple[39][44] = (byte)3;
	geoidSimple[39][45] = (byte)0;
	geoidSimple[39][46] = (byte)-3;
	geoidSimple[39][47] = (byte)-6;
	geoidSimple[39][48] = (byte)-8;
	geoidSimple[39][49] = (byte)-10;
	geoidSimple[39][50] = (byte)-11;
	geoidSimple[39][51] = (byte)-13;
	geoidSimple[39][52] = (byte)-14;
	geoidSimple[39][53] = (byte)-15;
	geoidSimple[39][54] = (byte)-16;
	geoidSimple[39][55] = (byte)-17;
	geoidSimple[39][56] = (byte)-19;
	geoidSimple[39][57] = (byte)-18;
	geoidSimple[39][58] = (byte)-16;
	geoidSimple[39][59] = (byte)-17;
	geoidSimple[39][60] = (byte)-19;
	geoidSimple[39][61] = (byte)-21;
	geoidSimple[39][62] = (byte)-23;
	geoidSimple[39][63] = (byte)-25;
	geoidSimple[39][64] = (byte)-27;
	geoidSimple[39][65] = (byte)-27;
	geoidSimple[39][66] = (byte)-28;
	geoidSimple[39][67] = (byte)-29;
	geoidSimple[39][68] = (byte)-29;
	geoidSimple[39][69] = (byte)-31;
	geoidSimple[39][70] = (byte)-32;
	geoidSimple[39][71] = (byte)-33;
	geoidSimple[39][72] = (byte)-33;
	geoidSimple[39][73] = (byte)-35;
	geoidSimple[39][74] = (byte)-36;
	geoidSimple[39][75] = (byte)-38;
	geoidSimple[39][76] = (byte)-39;
	geoidSimple[39][77] = (byte)-40;
	geoidSimple[39][78] = (byte)-41;
	geoidSimple[39][79] = (byte)-42;
	geoidSimple[39][80] = (byte)-43;
	geoidSimple[39][81] = (byte)-43;
	geoidSimple[39][82] = (byte)-43;
	geoidSimple[39][83] = (byte)-41;
	geoidSimple[39][84] = (byte)-40;
	geoidSimple[39][85] = (byte)-41;
	geoidSimple[39][86] = (byte)-41;
	geoidSimple[39][87] = (byte)-40;
	geoidSimple[39][88] = (byte)-40;
	geoidSimple[39][89] = (byte)-40;
	geoidSimple[39][90] = (byte)-41;
	geoidSimple[39][91] = (byte)-42;
	geoidSimple[39][92] = (byte)-44;
	geoidSimple[39][93] = (byte)-44;
	geoidSimple[39][94] = (byte)-44;
	geoidSimple[39][95] = (byte)-43;
	geoidSimple[39][96] = (byte)-42;
	geoidSimple[39][97] = (byte)-42;
	geoidSimple[39][98] = (byte)-41;
	geoidSimple[39][99] = (byte)-40;
	geoidSimple[39][100] = (byte)-40;
	geoidSimple[39][101] = (byte)-40;
	geoidSimple[39][102] = (byte)-39;
	geoidSimple[39][103] = (byte)-39;
	geoidSimple[39][104] = (byte)-38;
	geoidSimple[39][105] = (byte)-38;
	geoidSimple[39][106] = (byte)-38;
	geoidSimple[39][107] = (byte)-36;
	geoidSimple[39][108] = (byte)-33;
	geoidSimple[39][109] = (byte)-31;
	geoidSimple[39][110] = (byte)-28;
	geoidSimple[39][111] = (byte)-26;
	geoidSimple[39][112] = (byte)-24;
	geoidSimple[39][113] = (byte)-22;
	geoidSimple[39][114] = (byte)-20;
	geoidSimple[39][115] = (byte)-17;
	geoidSimple[39][116] = (byte)-15;
	geoidSimple[39][117] = (byte)-12;
	geoidSimple[39][118] = (byte)-9;
	geoidSimple[39][119] = (byte)-7;
	geoidSimple[39][120] = (byte)-3;
	geoidSimple[39][121] = (byte)0;
	geoidSimple[39][122] = (byte)3;
	geoidSimple[39][123] = (byte)4;
	geoidSimple[39][124] = (byte)6;
	geoidSimple[39][125] = (byte)8;
	geoidSimple[39][126] = (byte)10;
	geoidSimple[39][127] = (byte)10;
	geoidSimple[39][128] = (byte)11;
	geoidSimple[39][129] = (byte)13;
	geoidSimple[39][130] = (byte)14;
	geoidSimple[39][131] = (byte)16;
	geoidSimple[39][132] = (byte)18;
	geoidSimple[39][133] = (byte)19;
	geoidSimple[39][134] = (byte)20;
	geoidSimple[39][135] = (byte)20;
	geoidSimple[39][136] = (byte)20;
	geoidSimple[39][137] = (byte)20;
	geoidSimple[39][138] = (byte)21;
	geoidSimple[39][139] = (byte)22;
	geoidSimple[39][140] = (byte)21;
	geoidSimple[39][141] = (byte)19;
	geoidSimple[39][142] = (byte)20;
	geoidSimple[39][143] = (byte)20;
	geoidSimple[39][144] = (byte)18;
	geoidSimple[39][145] = (byte)17;
	geoidSimple[39][146] = (byte)17;
	geoidSimple[39][147] = (byte)18;
	geoidSimple[39][148] = (byte)18;
	geoidSimple[39][149] = (byte)19;
	geoidSimple[39][150] = (byte)19;
	geoidSimple[39][151] = (byte)20;
	geoidSimple[39][152] = (byte)21;
	geoidSimple[39][153] = (byte)22;
	geoidSimple[39][154] = (byte)22;
	geoidSimple[39][155] = (byte)23;
	geoidSimple[39][156] = (byte)24;
	geoidSimple[39][157] = (byte)20;
	geoidSimple[39][158] = (byte)10;
	geoidSimple[39][159] = (byte)2;
	geoidSimple[39][160] = (byte)4;
	geoidSimple[39][161] = (byte)7;
	geoidSimple[39][162] = (byte)8;
	geoidSimple[39][163] = (byte)8;
	geoidSimple[39][164] = (byte)7;
	geoidSimple[39][165] = (byte)6;
	geoidSimple[39][166] = (byte)4;
	geoidSimple[39][167] = (byte)5;
	geoidSimple[39][168] = (byte)4;
	geoidSimple[39][169] = (byte)4;
	geoidSimple[39][170] = (byte)3;
	geoidSimple[39][171] = (byte)2;
	geoidSimple[39][172] = (byte)0;
	geoidSimple[39][173] = (byte)0;
	geoidSimple[39][174] = (byte)-1;
	geoidSimple[39][175] = (byte)-3;
	geoidSimple[39][176] = (byte)-6;
	geoidSimple[39][177] = (byte)-8;
	geoidSimple[39][178] = (byte)-8;
	geoidSimple[39][179] = (byte)-9;
	geoidSimple[39][LAT_GRID_SIZE] = (byte)-10;
	geoidSimple[39][181] = (byte)-9;
	geoidSimple[39][182] = (byte)-9;
	geoidSimple[39][183] = (byte)-8;
	geoidSimple[39][184] = (byte)-8;
	geoidSimple[39][185] = (byte)-7;
	geoidSimple[39][186] = (byte)-5;
	geoidSimple[39][187] = (byte)-4;
	geoidSimple[39][188] = (byte)-1;
	geoidSimple[39][189] = (byte)0;
	geoidSimple[39][190] = (byte)3;
	geoidSimple[39][191] = (byte)5;
	geoidSimple[39][192] = (byte)7;
	geoidSimple[39][193] = (byte)8;
	geoidSimple[39][194] = (byte)9;
	geoidSimple[39][195] = (byte)9;
	geoidSimple[39][196] = (byte)9;
	geoidSimple[39][197] = (byte)9;
	geoidSimple[39][198] = (byte)9;
	geoidSimple[39][199] = (byte)9;
	geoidSimple[39][200] = (byte)8;
	geoidSimple[39][201] = (byte)8;
	geoidSimple[39][202] = (byte)7;
	geoidSimple[39][203] = (byte)6;
	geoidSimple[39][204] = (byte)6;
	geoidSimple[39][205] = (byte)5;
	geoidSimple[39][206] = (byte)4;
	geoidSimple[39][207] = (byte)3;
	geoidSimple[39][208] = (byte)2;
	geoidSimple[39][209] = (byte)1;
	geoidSimple[39][210] = (byte)1;
	geoidSimple[39][211] = (byte)0;
	geoidSimple[39][212] = (byte)0;
	geoidSimple[39][213] = (byte)-1;
	geoidSimple[39][214] = (byte)-2;
	geoidSimple[39][215] = (byte)-3;
	geoidSimple[39][216] = (byte)-4;
	geoidSimple[39][217] = (byte)-6;
	geoidSimple[39][218] = (byte)-7;
	geoidSimple[39][219] = (byte)-9;
	geoidSimple[39][220] = (byte)-10;
	geoidSimple[39][221] = (byte)-11;
	geoidSimple[39][222] = (byte)-12;
	geoidSimple[39][223] = (byte)-13;
	geoidSimple[39][224] = (byte)-14;
	geoidSimple[39][225] = (byte)-15;
	geoidSimple[39][226] = (byte)-15;
	geoidSimple[39][227] = (byte)-16;
	geoidSimple[39][228] = (byte)-16;
	geoidSimple[39][229] = (byte)-17;
	geoidSimple[39][230] = (byte)-18;
	geoidSimple[39][231] = (byte)-17;
	geoidSimple[39][232] = (byte)-15;
	geoidSimple[39][233] = (byte)-15;
	geoidSimple[39][234] = (byte)-15;
	geoidSimple[39][235] = (byte)-16;
	geoidSimple[39][236] = (byte)-15;
	geoidSimple[39][237] = (byte)-15;
	geoidSimple[39][238] = (byte)-15;
	geoidSimple[39][239] = (byte)-15;
	geoidSimple[39][240] = (byte)-16;
	geoidSimple[39][241] = (byte)-16;
	geoidSimple[39][242] = (byte)-16;
	geoidSimple[39][243] = (byte)-15;
	geoidSimple[39][244] = (byte)-14;
	geoidSimple[39][245] = (byte)-14;
	geoidSimple[39][246] = (byte)-16;
	geoidSimple[39][247] = (byte)-17;
	geoidSimple[39][248] = (byte)-18;
	geoidSimple[39][249] = (byte)-18;
	geoidSimple[39][250] = (byte)-18;
	geoidSimple[39][251] = (byte)-18;
	geoidSimple[39][252] = (byte)-19;
	geoidSimple[39][253] = (byte)-20;
	geoidSimple[39][254] = (byte)-20;
	geoidSimple[39][255] = (byte)-20;
	geoidSimple[39][256] = (byte)-20;
	geoidSimple[39][257] = (byte)-21;
	geoidSimple[39][258] = (byte)-23;
	geoidSimple[39][259] = (byte)-24;
	geoidSimple[39][260] = (byte)-25;
	geoidSimple[39][261] = (byte)-27;
	geoidSimple[39][262] = (byte)-28;
	geoidSimple[39][263] = (byte)-29;
	geoidSimple[39][264] = (byte)-30;
	geoidSimple[39][265] = (byte)-31;
	geoidSimple[39][266] = (byte)-32;
	geoidSimple[39][267] = (byte)-33;
	geoidSimple[39][268] = (byte)-34;
	geoidSimple[39][269] = (byte)-35;
	geoidSimple[39][270] = (byte)-36;
	geoidSimple[39][271] = (byte)-37;
	geoidSimple[39][272] = (byte)-39;
	geoidSimple[39][273] = (byte)-39;
	geoidSimple[39][274] = (byte)-39;
	geoidSimple[39][275] = (byte)-40;
	geoidSimple[39][276] = (byte)-40;
	geoidSimple[39][277] = (byte)-40;
	geoidSimple[39][278] = (byte)-40;
	geoidSimple[39][279] = (byte)-40;
	geoidSimple[39][280] = (byte)-41;
	geoidSimple[39][281] = (byte)-41;
	geoidSimple[39][282] = (byte)-40;
	geoidSimple[39][283] = (byte)-38;
	geoidSimple[39][284] = (byte)-36;
	geoidSimple[39][285] = (byte)-35;
	geoidSimple[39][286] = (byte)-33;
	geoidSimple[39][287] = (byte)-32;
	geoidSimple[39][288] = (byte)-30;
	geoidSimple[39][289] = (byte)-27;
	geoidSimple[39][290] = (byte)-25;
	geoidSimple[39][291] = (byte)-23;
	geoidSimple[39][292] = (byte)-22;
	geoidSimple[39][293] = (byte)-21;
	geoidSimple[39][294] = (byte)-20;
	geoidSimple[39][295] = (byte)-19;
	geoidSimple[39][296] = (byte)-18;
	geoidSimple[39][297] = (byte)-17;
	geoidSimple[39][298] = (byte)-15;
	geoidSimple[39][299] = (byte)-13;
	geoidSimple[39][300] = (byte)-10;
	geoidSimple[39][301] = (byte)-7;
	geoidSimple[39][302] = (byte)-3;
	geoidSimple[39][303] = (byte)0;
	geoidSimple[39][304] = (byte)5;
	geoidSimple[39][305] = (byte)9;
	geoidSimple[39][306] = (byte)12;
	geoidSimple[39][307] = (byte)14;
	geoidSimple[39][308] = (byte)17;
	geoidSimple[39][309] = (byte)21;
	geoidSimple[39][310] = (byte)23;
	geoidSimple[39][311] = (byte)23;
	geoidSimple[39][312] = (byte)25;
	geoidSimple[39][313] = (byte)28;
	geoidSimple[39][314] = (byte)31;
	geoidSimple[39][315] = (byte)34;
	geoidSimple[39][316] = (byte)36;
	geoidSimple[39][317] = (byte)39;
	geoidSimple[39][318] = (byte)41;
	geoidSimple[39][319] = (byte)43;
	geoidSimple[39][320] = (byte)45;
	geoidSimple[39][321] = (byte)48;
	geoidSimple[39][322] = (byte)50;
	geoidSimple[39][323] = (byte)52;
	geoidSimple[39][324] = (byte)53;
	geoidSimple[39][325] = (byte)55;
	geoidSimple[39][326] = (byte)56;
	geoidSimple[39][327] = (byte)58;
	geoidSimple[39][328] = (byte)59;
	geoidSimple[39][329] = (byte)61;
	geoidSimple[39][330] = (byte)62;
	geoidSimple[39][331] = (byte)63;
	geoidSimple[39][332] = (byte)63;
	geoidSimple[39][333] = (byte)63;
	geoidSimple[39][334] = (byte)63;
	geoidSimple[39][335] = (byte)62;
	geoidSimple[39][336] = (byte)62;
	geoidSimple[39][337] = (byte)62;
	geoidSimple[39][338] = (byte)62;
	geoidSimple[39][339] = (byte)62;
	geoidSimple[39][340] = (byte)61;
	geoidSimple[39][341] = (byte)59;
	geoidSimple[39][342] = (byte)58;
	geoidSimple[39][343] = (byte)57;
	geoidSimple[39][344] = (byte)57;
	geoidSimple[39][345] = (byte)58;
	geoidSimple[39][346] = (byte)58;
	geoidSimple[39][347] = (byte)57;
	geoidSimple[39][348] = (byte)58;
	geoidSimple[39][349] = (byte)59;
	geoidSimple[39][350] = (byte)58;
	geoidSimple[39][351] = (byte)57;
	geoidSimple[39][352] = (byte)55;
	geoidSimple[39][353] = (byte)54;
	geoidSimple[39][354] = (byte)54;
	geoidSimple[39][355] = (byte)53;
	geoidSimple[39][356] = (byte)51;
	geoidSimple[39][357] = (byte)49;
	geoidSimple[39][358] = (byte)47;
	geoidSimple[39][359] = (byte)45;
	}
		/** Row 40*/
	private static void init40() {
	geoidSimple[40][0] = (byte)45;
	geoidSimple[40][1] = (byte)45;
	geoidSimple[40][2] = (byte)44;
	geoidSimple[40][3] = (byte)45;
	geoidSimple[40][4] = (byte)45;
	geoidSimple[40][5] = (byte)47;
	geoidSimple[40][6] = (byte)48;
	geoidSimple[40][7] = (byte)48;
	geoidSimple[40][8] = (byte)48;
	geoidSimple[40][9] = (byte)48;
	geoidSimple[40][10] = (byte)47;
	geoidSimple[40][11] = (byte)46;
	geoidSimple[40][12] = (byte)46;
	geoidSimple[40][13] = (byte)46;
	geoidSimple[40][14] = (byte)45;
	geoidSimple[40][15] = (byte)45;
	geoidSimple[40][16] = (byte)44;
	geoidSimple[40][17] = (byte)43;
	geoidSimple[40][18] = (byte)42;
	geoidSimple[40][19] = (byte)41;
	geoidSimple[40][20] = (byte)40;
	geoidSimple[40][21] = (byte)37;
	geoidSimple[40][22] = (byte)35;
	geoidSimple[40][23] = (byte)32;
	geoidSimple[40][24] = (byte)31;
	geoidSimple[40][25] = (byte)32;
	geoidSimple[40][26] = (byte)33;
	geoidSimple[40][27] = (byte)32;
	geoidSimple[40][28] = (byte)31;
	geoidSimple[40][29] = (byte)29;
	geoidSimple[40][30] = (byte)26;
	geoidSimple[40][31] = (byte)24;
	geoidSimple[40][32] = (byte)22;
	geoidSimple[40][33] = (byte)21;
	geoidSimple[40][34] = (byte)18;
	geoidSimple[40][35] = (byte)15;
	geoidSimple[40][36] = (byte)14;
	geoidSimple[40][37] = (byte)12;
	geoidSimple[40][38] = (byte)10;
	geoidSimple[40][39] = (byte)10;
	geoidSimple[40][40] = (byte)10;
	geoidSimple[40][41] = (byte)8;
	geoidSimple[40][42] = (byte)6;
	geoidSimple[40][43] = (byte)4;
	geoidSimple[40][44] = (byte)1;
	geoidSimple[40][45] = (byte)-2;
	geoidSimple[40][46] = (byte)-6;
	geoidSimple[40][47] = (byte)-7;
	geoidSimple[40][48] = (byte)-9;
	geoidSimple[40][49] = (byte)-11;
	geoidSimple[40][50] = (byte)-13;
	geoidSimple[40][51] = (byte)-14;
	geoidSimple[40][52] = (byte)-15;
	geoidSimple[40][53] = (byte)-15;
	geoidSimple[40][54] = (byte)-15;
	geoidSimple[40][55] = (byte)-18;
	geoidSimple[40][56] = (byte)-20;
	geoidSimple[40][57] = (byte)-20;
	geoidSimple[40][58] = (byte)-17;
	geoidSimple[40][59] = (byte)-18;
	geoidSimple[40][60] = (byte)-21;
	geoidSimple[40][61] = (byte)-23;
	geoidSimple[40][62] = (byte)-25;
	geoidSimple[40][63] = (byte)-28;
	geoidSimple[40][64] = (byte)-29;
	geoidSimple[40][65] = (byte)-29;
	geoidSimple[40][66] = (byte)-30;
	geoidSimple[40][67] = (byte)-31;
	geoidSimple[40][68] = (byte)-32;
	geoidSimple[40][69] = (byte)-33;
	geoidSimple[40][70] = (byte)-34;
	geoidSimple[40][71] = (byte)-34;
	geoidSimple[40][72] = (byte)-35;
	geoidSimple[40][73] = (byte)-36;
	geoidSimple[40][74] = (byte)-37;
	geoidSimple[40][75] = (byte)-38;
	geoidSimple[40][76] = (byte)-39;
	geoidSimple[40][77] = (byte)-40;
	geoidSimple[40][78] = (byte)-42;
	geoidSimple[40][79] = (byte)-43;
	geoidSimple[40][80] = (byte)-44;
	geoidSimple[40][81] = (byte)-45;
	geoidSimple[40][82] = (byte)-44;
	geoidSimple[40][83] = (byte)-44;
	geoidSimple[40][84] = (byte)-44;
	geoidSimple[40][85] = (byte)-42;
	geoidSimple[40][86] = (byte)-41;
	geoidSimple[40][87] = (byte)-40;
	geoidSimple[40][88] = (byte)-40;
	geoidSimple[40][89] = (byte)-41;
	geoidSimple[40][90] = (byte)-43;
	geoidSimple[40][91] = (byte)-43;
	geoidSimple[40][92] = (byte)-45;
	geoidSimple[40][93] = (byte)-45;
	geoidSimple[40][94] = (byte)-45;
	geoidSimple[40][95] = (byte)-45;
	geoidSimple[40][96] = (byte)-45;
	geoidSimple[40][97] = (byte)-43;
	geoidSimple[40][98] = (byte)-43;
	geoidSimple[40][99] = (byte)-42;
	geoidSimple[40][100] = (byte)-42;
	geoidSimple[40][101] = (byte)-41;
	geoidSimple[40][102] = (byte)-41;
	geoidSimple[40][103] = (byte)-40;
	geoidSimple[40][104] = (byte)-40;
	geoidSimple[40][105] = (byte)-39;
	geoidSimple[40][106] = (byte)-38;
	geoidSimple[40][107] = (byte)-36;
	geoidSimple[40][108] = (byte)-33;
	geoidSimple[40][109] = (byte)-31;
	geoidSimple[40][110] = (byte)-28;
	geoidSimple[40][111] = (byte)-26;
	geoidSimple[40][112] = (byte)-24;
	geoidSimple[40][113] = (byte)-22;
	geoidSimple[40][114] = (byte)-20;
	geoidSimple[40][115] = (byte)-17;
	geoidSimple[40][116] = (byte)-15;
	geoidSimple[40][117] = (byte)-12;
	geoidSimple[40][118] = (byte)-9;
	geoidSimple[40][119] = (byte)-6;
	geoidSimple[40][120] = (byte)-2;
	geoidSimple[40][121] = (byte)0;
	geoidSimple[40][122] = (byte)3;
	geoidSimple[40][123] = (byte)5;
	geoidSimple[40][124] = (byte)7;
	geoidSimple[40][125] = (byte)9;
	geoidSimple[40][126] = (byte)11;
	geoidSimple[40][127] = (byte)12;
	geoidSimple[40][128] = (byte)13;
	geoidSimple[40][129] = (byte)14;
	geoidSimple[40][130] = (byte)15;
	geoidSimple[40][131] = (byte)17;
	geoidSimple[40][132] = (byte)19;
	geoidSimple[40][133] = (byte)20;
	geoidSimple[40][134] = (byte)20;
	geoidSimple[40][135] = (byte)20;
	geoidSimple[40][136] = (byte)20;
	geoidSimple[40][137] = (byte)21;
	geoidSimple[40][138] = (byte)22;
	geoidSimple[40][139] = (byte)23;
	geoidSimple[40][140] = (byte)22;
	geoidSimple[40][141] = (byte)20;
	geoidSimple[40][142] = (byte)21;
	geoidSimple[40][143] = (byte)21;
	geoidSimple[40][144] = (byte)20;
	geoidSimple[40][145] = (byte)19;
	geoidSimple[40][146] = (byte)19;
	geoidSimple[40][147] = (byte)19;
	geoidSimple[40][148] = (byte)19;
	geoidSimple[40][149] = (byte)20;
	geoidSimple[40][150] = (byte)20;
	geoidSimple[40][151] = (byte)21;
	geoidSimple[40][152] = (byte)21;
	geoidSimple[40][153] = (byte)21;
	geoidSimple[40][154] = (byte)24;
	geoidSimple[40][155] = (byte)23;
	geoidSimple[40][156] = (byte)16;
	geoidSimple[40][157] = (byte)6;
	geoidSimple[40][158] = (byte)3;
	geoidSimple[40][159] = (byte)5;
	geoidSimple[40][160] = (byte)8;
	geoidSimple[40][161] = (byte)8;
	geoidSimple[40][162] = (byte)8;
	geoidSimple[40][163] = (byte)7;
	geoidSimple[40][164] = (byte)6;
	geoidSimple[40][165] = (byte)4;
	geoidSimple[40][166] = (byte)2;
	geoidSimple[40][167] = (byte)1;
	geoidSimple[40][168] = (byte)1;
	geoidSimple[40][169] = (byte)0;
	geoidSimple[40][170] = (byte)1;
	geoidSimple[40][171] = (byte)1;
	geoidSimple[40][172] = (byte)0;
	geoidSimple[40][173] = (byte)0;
	geoidSimple[40][174] = (byte)0;
	geoidSimple[40][175] = (byte)0;
	geoidSimple[40][176] = (byte)0;
	geoidSimple[40][177] = (byte)0;
	geoidSimple[40][178] = (byte)0;
	geoidSimple[40][179] = (byte)-1;
	geoidSimple[40][LAT_GRID_SIZE] = (byte)-2;
	geoidSimple[40][181] = (byte)-1;
	geoidSimple[40][182] = (byte)0;
	geoidSimple[40][183] = (byte)0;
	geoidSimple[40][184] = (byte)0;
	geoidSimple[40][185] = (byte)2;
	geoidSimple[40][186] = (byte)2;
	geoidSimple[40][187] = (byte)3;
	geoidSimple[40][188] = (byte)4;
	geoidSimple[40][189] = (byte)5;
	geoidSimple[40][190] = (byte)6;
	geoidSimple[40][191] = (byte)6;
	geoidSimple[40][192] = (byte)7;
	geoidSimple[40][193] = (byte)7;
	geoidSimple[40][194] = (byte)7;
	geoidSimple[40][195] = (byte)7;
	geoidSimple[40][196] = (byte)7;
	geoidSimple[40][197] = (byte)7;
	geoidSimple[40][198] = (byte)7;
	geoidSimple[40][199] = (byte)6;
	geoidSimple[40][200] = (byte)6;
	geoidSimple[40][201] = (byte)6;
	geoidSimple[40][202] = (byte)5;
	geoidSimple[40][203] = (byte)4;
	geoidSimple[40][204] = (byte)4;
	geoidSimple[40][205] = (byte)3;
	geoidSimple[40][206] = (byte)2;
	geoidSimple[40][207] = (byte)1;
	geoidSimple[40][208] = (byte)0;
	geoidSimple[40][209] = (byte)0;
	geoidSimple[40][210] = (byte)-1;
	geoidSimple[40][211] = (byte)-2;
	geoidSimple[40][212] = (byte)-3;
	geoidSimple[40][213] = (byte)-4;
	geoidSimple[40][214] = (byte)-5;
	geoidSimple[40][215] = (byte)-6;
	geoidSimple[40][216] = (byte)-8;
	geoidSimple[40][217] = (byte)-9;
	geoidSimple[40][218] = (byte)-10;
	geoidSimple[40][219] = (byte)-11;
	geoidSimple[40][220] = (byte)-12;
	geoidSimple[40][221] = (byte)-14;
	geoidSimple[40][222] = (byte)-15;
	geoidSimple[40][223] = (byte)-16;
	geoidSimple[40][224] = (byte)-17;
	geoidSimple[40][225] = (byte)-17;
	geoidSimple[40][226] = (byte)-18;
	geoidSimple[40][227] = (byte)-18;
	geoidSimple[40][228] = (byte)-18;
	geoidSimple[40][229] = (byte)-18;
	geoidSimple[40][230] = (byte)-19;
	geoidSimple[40][231] = (byte)-20;
	geoidSimple[40][232] = (byte)-20;
	geoidSimple[40][233] = (byte)-17;
	geoidSimple[40][234] = (byte)-15;
	geoidSimple[40][235] = (byte)-17;
	geoidSimple[40][236] = (byte)-18;
	geoidSimple[40][237] = (byte)-17;
	geoidSimple[40][238] = (byte)-17;
	geoidSimple[40][239] = (byte)-15;
	geoidSimple[40][240] = (byte)-16;
	geoidSimple[40][241] = (byte)-15;
	geoidSimple[40][242] = (byte)-16;
	geoidSimple[40][243] = (byte)-15;
	geoidSimple[40][244] = (byte)-15;
	geoidSimple[40][245] = (byte)-14;
	geoidSimple[40][246] = (byte)-15;
	geoidSimple[40][247] = (byte)-16;
	geoidSimple[40][248] = (byte)-16;
	geoidSimple[40][249] = (byte)-16;
	geoidSimple[40][250] = (byte)-16;
	geoidSimple[40][251] = (byte)-16;
	geoidSimple[40][252] = (byte)-17;
	geoidSimple[40][253] = (byte)-18;
	geoidSimple[40][254] = (byte)-18;
	geoidSimple[40][255] = (byte)-18;
	geoidSimple[40][256] = (byte)-19;
	geoidSimple[40][257] = (byte)-20;
	geoidSimple[40][258] = (byte)-21;
	geoidSimple[40][259] = (byte)-22;
	geoidSimple[40][260] = (byte)-23;
	geoidSimple[40][261] = (byte)-24;
	geoidSimple[40][262] = (byte)-26;
	geoidSimple[40][263] = (byte)-28;
	geoidSimple[40][264] = (byte)-29;
	geoidSimple[40][265] = (byte)-30;
	geoidSimple[40][266] = (byte)-31;
	geoidSimple[40][267] = (byte)-32;
	geoidSimple[40][268] = (byte)-34;
	geoidSimple[40][269] = (byte)-34;
	geoidSimple[40][270] = (byte)-35;
	geoidSimple[40][271] = (byte)-36;
	geoidSimple[40][272] = (byte)-37;
	geoidSimple[40][273] = (byte)-38;
	geoidSimple[40][274] = (byte)-38;
	geoidSimple[40][275] = (byte)-39;
	geoidSimple[40][276] = (byte)-39;
	geoidSimple[40][277] = (byte)-38;
	geoidSimple[40][278] = (byte)-38;
	geoidSimple[40][279] = (byte)-38;
	geoidSimple[40][280] = (byte)-39;
	geoidSimple[40][281] = (byte)-39;
	geoidSimple[40][282] = (byte)-39;
	geoidSimple[40][283] = (byte)-38;
	geoidSimple[40][284] = (byte)-36;
	geoidSimple[40][285] = (byte)-35;
	geoidSimple[40][286] = (byte)-34;
	geoidSimple[40][287] = (byte)-33;
	geoidSimple[40][288] = (byte)-31;
	geoidSimple[40][289] = (byte)-28;
	geoidSimple[40][290] = (byte)-26;
	geoidSimple[40][291] = (byte)-24;
	geoidSimple[40][292] = (byte)-24;
	geoidSimple[40][293] = (byte)-23;
	geoidSimple[40][294] = (byte)-21;
	geoidSimple[40][295] = (byte)-21;
	geoidSimple[40][296] = (byte)-20;
	geoidSimple[40][297] = (byte)-18;
	geoidSimple[40][298] = (byte)-17;
	geoidSimple[40][299] = (byte)-15;
	geoidSimple[40][300] = (byte)-11;
	geoidSimple[40][301] = (byte)-8;
	geoidSimple[40][302] = (byte)-2;
	geoidSimple[40][303] = (byte)2;
	geoidSimple[40][304] = (byte)5;
	geoidSimple[40][305] = (byte)8;
	geoidSimple[40][306] = (byte)11;
	geoidSimple[40][307] = (byte)13;
	geoidSimple[40][308] = (byte)18;
	geoidSimple[40][309] = (byte)23;
	geoidSimple[40][310] = (byte)23;
	geoidSimple[40][311] = (byte)22;
	geoidSimple[40][312] = (byte)24;
	geoidSimple[40][313] = (byte)27;
	geoidSimple[40][314] = (byte)30;
	geoidSimple[40][315] = (byte)33;
	geoidSimple[40][316] = (byte)35;
	geoidSimple[40][317] = (byte)38;
	geoidSimple[40][318] = (byte)40;
	geoidSimple[40][319] = (byte)42;
	geoidSimple[40][320] = (byte)44;
	geoidSimple[40][321] = (byte)47;
	geoidSimple[40][322] = (byte)49;
	geoidSimple[40][323] = (byte)51;
	geoidSimple[40][324] = (byte)52;
	geoidSimple[40][325] = (byte)54;
	geoidSimple[40][326] = (byte)55;
	geoidSimple[40][327] = (byte)57;
	geoidSimple[40][328] = (byte)59;
	geoidSimple[40][329] = (byte)61;
	geoidSimple[40][330] = (byte)62;
	geoidSimple[40][331] = (byte)63;
	geoidSimple[40][332] = (byte)64;
	geoidSimple[40][333] = (byte)64;
	geoidSimple[40][334] = (byte)63;
	geoidSimple[40][335] = (byte)63;
	geoidSimple[40][336] = (byte)63;
	geoidSimple[40][337] = (byte)63;
	geoidSimple[40][338] = (byte)62;
	geoidSimple[40][339] = (byte)62;
	geoidSimple[40][340] = (byte)61;
	geoidSimple[40][341] = (byte)60;
	geoidSimple[40][342] = (byte)59;
	geoidSimple[40][343] = (byte)58;
	geoidSimple[40][344] = (byte)57;
	geoidSimple[40][345] = (byte)56;
	geoidSimple[40][346] = (byte)56;
	geoidSimple[40][347] = (byte)57;
	geoidSimple[40][348] = (byte)58;
	geoidSimple[40][349] = (byte)58;
	geoidSimple[40][350] = (byte)57;
	geoidSimple[40][351] = (byte)56;
	geoidSimple[40][352] = (byte)55;
	geoidSimple[40][353] = (byte)54;
	geoidSimple[40][354] = (byte)53;
	geoidSimple[40][355] = (byte)52;
	geoidSimple[40][356] = (byte)51;
	geoidSimple[40][357] = (byte)49;
	geoidSimple[40][358] = (byte)47;
	geoidSimple[40][359] = (byte)46;
	}
		/** Row 41*/
	private static void init41() {
	geoidSimple[41][0] = (byte)46;
	geoidSimple[41][1] = (byte)45;
	geoidSimple[41][2] = (byte)44;
	geoidSimple[41][3] = (byte)45;
	geoidSimple[41][4] = (byte)46;
	geoidSimple[41][5] = (byte)47;
	geoidSimple[41][6] = (byte)47;
	geoidSimple[41][7] = (byte)48;
	geoidSimple[41][8] = (byte)48;
	geoidSimple[41][9] = (byte)48;
	geoidSimple[41][10] = (byte)47;
	geoidSimple[41][11] = (byte)46;
	geoidSimple[41][12] = (byte)45;
	geoidSimple[41][13] = (byte)45;
	geoidSimple[41][14] = (byte)46;
	geoidSimple[41][15] = (byte)46;
	geoidSimple[41][16] = (byte)44;
	geoidSimple[41][17] = (byte)43;
	geoidSimple[41][18] = (byte)43;
	geoidSimple[41][19] = (byte)43;
	geoidSimple[41][20] = (byte)42;
	geoidSimple[41][21] = (byte)40;
	geoidSimple[41][22] = (byte)38;
	geoidSimple[41][23] = (byte)37;
	geoidSimple[41][24] = (byte)34;
	geoidSimple[41][25] = (byte)33;
	geoidSimple[41][26] = (byte)33;
	geoidSimple[41][27] = (byte)33;
	geoidSimple[41][28] = (byte)32;
	geoidSimple[41][29] = (byte)30;
	geoidSimple[41][30] = (byte)28;
	geoidSimple[41][31] = (byte)25;
	geoidSimple[41][32] = (byte)23;
	geoidSimple[41][33] = (byte)22;
	geoidSimple[41][34] = (byte)20;
	geoidSimple[41][35] = (byte)19;
	geoidSimple[41][36] = (byte)17;
	geoidSimple[41][37] = (byte)15;
	geoidSimple[41][38] = (byte)13;
	geoidSimple[41][39] = (byte)11;
	geoidSimple[41][40] = (byte)9;
	geoidSimple[41][41] = (byte)7;
	geoidSimple[41][42] = (byte)6;
	geoidSimple[41][43] = (byte)3;
	geoidSimple[41][44] = (byte)0;
	geoidSimple[41][45] = (byte)-4;
	geoidSimple[41][46] = (byte)-5;
	geoidSimple[41][47] = (byte)-8;
	geoidSimple[41][48] = (byte)-11;
	geoidSimple[41][49] = (byte)-13;
	geoidSimple[41][50] = (byte)-14;
	geoidSimple[41][51] = (byte)-15;
	geoidSimple[41][52] = (byte)-16;
	geoidSimple[41][53] = (byte)-17;
	geoidSimple[41][54] = (byte)-18;
	geoidSimple[41][55] = (byte)-20;
	geoidSimple[41][56] = (byte)-21;
	geoidSimple[41][57] = (byte)-21;
	geoidSimple[41][58] = (byte)-19;
	geoidSimple[41][59] = (byte)-20;
	geoidSimple[41][60] = (byte)-23;
	geoidSimple[41][61] = (byte)-26;
	geoidSimple[41][62] = (byte)-28;
	geoidSimple[41][63] = (byte)-30;
	geoidSimple[41][64] = (byte)-31;
	geoidSimple[41][65] = (byte)-31;
	geoidSimple[41][66] = (byte)-31;
	geoidSimple[41][67] = (byte)-32;
	geoidSimple[41][68] = (byte)-33;
	geoidSimple[41][69] = (byte)-35;
	geoidSimple[41][70] = (byte)-37;
	geoidSimple[41][71] = (byte)-38;
	geoidSimple[41][72] = (byte)-39;
	geoidSimple[41][73] = (byte)-40;
	geoidSimple[41][74] = (byte)-40;
	geoidSimple[41][75] = (byte)-41;
	geoidSimple[41][76] = (byte)-41;
	geoidSimple[41][77] = (byte)-40;
	geoidSimple[41][78] = (byte)-41;
	geoidSimple[41][79] = (byte)-42;
	geoidSimple[41][80] = (byte)-44;
	geoidSimple[41][81] = (byte)-45;
	geoidSimple[41][82] = (byte)-46;
	geoidSimple[41][83] = (byte)-48;
	geoidSimple[41][84] = (byte)-47;
	geoidSimple[41][85] = (byte)-46;
	geoidSimple[41][86] = (byte)-45;
	geoidSimple[41][87] = (byte)-43;
	geoidSimple[41][88] = (byte)-42;
	geoidSimple[41][89] = (byte)-42;
	geoidSimple[41][90] = (byte)-42;
	geoidSimple[41][91] = (byte)-45;
	geoidSimple[41][92] = (byte)-46;
	geoidSimple[41][93] = (byte)-47;
	geoidSimple[41][94] = (byte)-46;
	geoidSimple[41][95] = (byte)-46;
	geoidSimple[41][96] = (byte)-45;
	geoidSimple[41][97] = (byte)-45;
	geoidSimple[41][98] = (byte)-44;
	geoidSimple[41][99] = (byte)-43;
	geoidSimple[41][100] = (byte)-43;
	geoidSimple[41][101] = (byte)-43;
	geoidSimple[41][102] = (byte)-42;
	geoidSimple[41][103] = (byte)-41;
	geoidSimple[41][104] = (byte)-41;
	geoidSimple[41][105] = (byte)-40;
	geoidSimple[41][106] = (byte)-38;
	geoidSimple[41][107] = (byte)-35;
	geoidSimple[41][108] = (byte)-32;
	geoidSimple[41][109] = (byte)-31;
	geoidSimple[41][110] = (byte)-29;
	geoidSimple[41][111] = (byte)-26;
	geoidSimple[41][112] = (byte)-24;
	geoidSimple[41][113] = (byte)-22;
	geoidSimple[41][114] = (byte)-20;
	geoidSimple[41][115] = (byte)-17;
	geoidSimple[41][116] = (byte)-14;
	geoidSimple[41][117] = (byte)-12;
	geoidSimple[41][118] = (byte)-8;
	geoidSimple[41][119] = (byte)-5;
	geoidSimple[41][120] = (byte)-1;
	geoidSimple[41][121] = (byte)1;
	geoidSimple[41][122] = (byte)3;
	geoidSimple[41][123] = (byte)5;
	geoidSimple[41][124] = (byte)7;
	geoidSimple[41][125] = (byte)9;
	geoidSimple[41][126] = (byte)11;
	geoidSimple[41][127] = (byte)13;
	geoidSimple[41][128] = (byte)15;
	geoidSimple[41][129] = (byte)16;
	geoidSimple[41][130] = (byte)17;
	geoidSimple[41][131] = (byte)18;
	geoidSimple[41][132] = (byte)19;
	geoidSimple[41][133] = (byte)19;
	geoidSimple[41][134] = (byte)20;
	geoidSimple[41][135] = (byte)21;
	geoidSimple[41][136] = (byte)22;
	geoidSimple[41][137] = (byte)24;
	geoidSimple[41][138] = (byte)24;
	geoidSimple[41][139] = (byte)24;
	geoidSimple[41][140] = (byte)22;
	geoidSimple[41][141] = (byte)21;
	geoidSimple[41][142] = (byte)23;
	geoidSimple[41][143] = (byte)21;
	geoidSimple[41][144] = (byte)21;
	geoidSimple[41][145] = (byte)20;
	geoidSimple[41][146] = (byte)20;
	geoidSimple[41][147] = (byte)20;
	geoidSimple[41][148] = (byte)20;
	geoidSimple[41][149] = (byte)20;
	geoidSimple[41][150] = (byte)20;
	geoidSimple[41][151] = (byte)20;
	geoidSimple[41][152] = (byte)21;
	geoidSimple[41][153] = (byte)23;
	geoidSimple[41][154] = (byte)25;
	geoidSimple[41][155] = (byte)16;
	geoidSimple[41][156] = (byte)4;
	geoidSimple[41][157] = (byte)3;
	geoidSimple[41][158] = (byte)7;
	geoidSimple[41][159] = (byte)9;
	geoidSimple[41][160] = (byte)9;
	geoidSimple[41][161] = (byte)8;
	geoidSimple[41][162] = (byte)6;
	geoidSimple[41][163] = (byte)5;
	geoidSimple[41][164] = (byte)4;
	geoidSimple[41][165] = (byte)2;
	geoidSimple[41][166] = (byte)0;
	geoidSimple[41][167] = (byte)-1;
	geoidSimple[41][168] = (byte)0;
	geoidSimple[41][169] = (byte)-1;
	geoidSimple[41][170] = (byte)-2;
	geoidSimple[41][171] = (byte)0;
	geoidSimple[41][172] = (byte)0;
	geoidSimple[41][173] = (byte)-1;
	geoidSimple[41][174] = (byte)0;
	geoidSimple[41][175] = (byte)0;
	geoidSimple[41][176] = (byte)0;
	geoidSimple[41][177] = (byte)0;
	geoidSimple[41][178] = (byte)0;
	geoidSimple[41][179] = (byte)0;
	geoidSimple[41][LAT_GRID_SIZE] = (byte)0;
	geoidSimple[41][181] = (byte)0;
	geoidSimple[41][182] = (byte)1;
	geoidSimple[41][183] = (byte)1;
	geoidSimple[41][184] = (byte)1;
	geoidSimple[41][185] = (byte)2;
	geoidSimple[41][186] = (byte)3;
	geoidSimple[41][187] = (byte)3;
	geoidSimple[41][188] = (byte)4;
	geoidSimple[41][189] = (byte)4;
	geoidSimple[41][190] = (byte)5;
	geoidSimple[41][191] = (byte)5;
	geoidSimple[41][192] = (byte)5;
	geoidSimple[41][193] = (byte)5;
	geoidSimple[41][194] = (byte)5;
	geoidSimple[41][195] = (byte)5;
	geoidSimple[41][196] = (byte)5;
	geoidSimple[41][197] = (byte)5;
	geoidSimple[41][198] = (byte)4;
	geoidSimple[41][199] = (byte)4;
	geoidSimple[41][200] = (byte)4;
	geoidSimple[41][201] = (byte)3;
	geoidSimple[41][202] = (byte)2;
	geoidSimple[41][203] = (byte)1;
	geoidSimple[41][204] = (byte)1;
	geoidSimple[41][205] = (byte)0;
	geoidSimple[41][206] = (byte)0;
	geoidSimple[41][207] = (byte)-1;
	geoidSimple[41][208] = (byte)-1;
	geoidSimple[41][209] = (byte)-2;
	geoidSimple[41][210] = (byte)-4;
	geoidSimple[41][211] = (byte)-5;
	geoidSimple[41][212] = (byte)-6;
	geoidSimple[41][213] = (byte)-7;
	geoidSimple[41][214] = (byte)-8;
	geoidSimple[41][215] = (byte)-9;
	geoidSimple[41][216] = (byte)-11;
	geoidSimple[41][217] = (byte)-12;
	geoidSimple[41][218] = (byte)-13;
	geoidSimple[41][219] = (byte)-14;
	geoidSimple[41][220] = (byte)-15;
	geoidSimple[41][221] = (byte)-17;
	geoidSimple[41][222] = (byte)-18;
	geoidSimple[41][223] = (byte)-18;
	geoidSimple[41][224] = (byte)-19;
	geoidSimple[41][225] = (byte)-20;
	geoidSimple[41][226] = (byte)-20;
	geoidSimple[41][227] = (byte)-20;
	geoidSimple[41][228] = (byte)-20;
	geoidSimple[41][229] = (byte)-20;
	geoidSimple[41][230] = (byte)-21;
	geoidSimple[41][231] = (byte)-21;
	geoidSimple[41][232] = (byte)-21;
	geoidSimple[41][233] = (byte)-21;
	geoidSimple[41][234] = (byte)-20;
	geoidSimple[41][235] = (byte)-18;
	geoidSimple[41][236] = (byte)-18;
	geoidSimple[41][237] = (byte)-20;
	geoidSimple[41][238] = (byte)-18;
	geoidSimple[41][239] = (byte)-16;
	geoidSimple[41][240] = (byte)-16;
	geoidSimple[41][241] = (byte)-16;
	geoidSimple[41][242] = (byte)-16;
	geoidSimple[41][243] = (byte)-15;
	geoidSimple[41][244] = (byte)-15;
	geoidSimple[41][245] = (byte)-15;
	geoidSimple[41][246] = (byte)-14;
	geoidSimple[41][247] = (byte)-13;
	geoidSimple[41][248] = (byte)-14;
	geoidSimple[41][249] = (byte)-15;
	geoidSimple[41][250] = (byte)-15;
	geoidSimple[41][251] = (byte)-16;
	geoidSimple[41][252] = (byte)-16;
	geoidSimple[41][253] = (byte)-16;
	geoidSimple[41][254] = (byte)-17;
	geoidSimple[41][255] = (byte)-17;
	geoidSimple[41][256] = (byte)-18;
	geoidSimple[41][257] = (byte)-18;
	geoidSimple[41][258] = (byte)-20;
	geoidSimple[41][259] = (byte)-21;
	geoidSimple[41][260] = (byte)-22;
	geoidSimple[41][261] = (byte)-24;
	geoidSimple[41][262] = (byte)-26;
	geoidSimple[41][263] = (byte)-27;
	geoidSimple[41][264] = (byte)-28;
	geoidSimple[41][265] = (byte)-29;
	geoidSimple[41][266] = (byte)-30;
	geoidSimple[41][267] = (byte)-32;
	geoidSimple[41][268] = (byte)-33;
	geoidSimple[41][269] = (byte)-33;
	geoidSimple[41][270] = (byte)-35;
	geoidSimple[41][271] = (byte)-36;
	geoidSimple[41][272] = (byte)-36;
	geoidSimple[41][273] = (byte)-37;
	geoidSimple[41][274] = (byte)-38;
	geoidSimple[41][275] = (byte)-38;
	geoidSimple[41][276] = (byte)-37;
	geoidSimple[41][277] = (byte)-37;
	geoidSimple[41][278] = (byte)-38;
	geoidSimple[41][279] = (byte)-38;
	geoidSimple[41][280] = (byte)-38;
	geoidSimple[41][281] = (byte)-38;
	geoidSimple[41][282] = (byte)-38;
	geoidSimple[41][283] = (byte)-36;
	geoidSimple[41][284] = (byte)-35;
	geoidSimple[41][285] = (byte)-34;
	geoidSimple[41][286] = (byte)-33;
	geoidSimple[41][287] = (byte)-33;
	geoidSimple[41][288] = (byte)-31;
	geoidSimple[41][289] = (byte)-28;
	geoidSimple[41][290] = (byte)-27;
	geoidSimple[41][291] = (byte)-26;
	geoidSimple[41][292] = (byte)-24;
	geoidSimple[41][293] = (byte)-21;
	geoidSimple[41][294] = (byte)-19;
	geoidSimple[41][295] = (byte)-18;
	geoidSimple[41][296] = (byte)-19;
	geoidSimple[41][297] = (byte)-18;
	geoidSimple[41][298] = (byte)-16;
	geoidSimple[41][299] = (byte)-15;
	geoidSimple[41][300] = (byte)-12;
	geoidSimple[41][301] = (byte)-6;
	geoidSimple[41][302] = (byte)-1;
	geoidSimple[41][303] = (byte)1;
	geoidSimple[41][304] = (byte)4;
	geoidSimple[41][305] = (byte)7;
	geoidSimple[41][306] = (byte)9;
	geoidSimple[41][307] = (byte)12;
	geoidSimple[41][308] = (byte)16;
	geoidSimple[41][309] = (byte)21;
	geoidSimple[41][310] = (byte)23;
	geoidSimple[41][311] = (byte)23;
	geoidSimple[41][312] = (byte)25;
	geoidSimple[41][313] = (byte)28;
	geoidSimple[41][314] = (byte)31;
	geoidSimple[41][315] = (byte)34;
	geoidSimple[41][316] = (byte)35;
	geoidSimple[41][317] = (byte)37;
	geoidSimple[41][318] = (byte)39;
	geoidSimple[41][319] = (byte)41;
	geoidSimple[41][320] = (byte)43;
	geoidSimple[41][321] = (byte)45;
	geoidSimple[41][322] = (byte)47;
	geoidSimple[41][323] = (byte)50;
	geoidSimple[41][324] = (byte)51;
	geoidSimple[41][325] = (byte)53;
	geoidSimple[41][326] = (byte)55;
	geoidSimple[41][327] = (byte)56;
	geoidSimple[41][328] = (byte)58;
	geoidSimple[41][329] = (byte)60;
	geoidSimple[41][330] = (byte)62;
	geoidSimple[41][331] = (byte)64;
	geoidSimple[41][332] = (byte)65;
	geoidSimple[41][333] = (byte)65;
	geoidSimple[41][334] = (byte)64;
	geoidSimple[41][335] = (byte)64;
	geoidSimple[41][336] = (byte)63;
	geoidSimple[41][337] = (byte)63;
	geoidSimple[41][338] = (byte)62;
	geoidSimple[41][339] = (byte)62;
	geoidSimple[41][340] = (byte)62;
	geoidSimple[41][341] = (byte)61;
	geoidSimple[41][342] = (byte)60;
	geoidSimple[41][343] = (byte)58;
	geoidSimple[41][344] = (byte)57;
	geoidSimple[41][345] = (byte)56;
	geoidSimple[41][346] = (byte)55;
	geoidSimple[41][347] = (byte)56;
	geoidSimple[41][348] = (byte)56;
	geoidSimple[41][349] = (byte)56;
	geoidSimple[41][350] = (byte)55;
	geoidSimple[41][351] = (byte)54;
	geoidSimple[41][352] = (byte)54;
	geoidSimple[41][353] = (byte)53;
	geoidSimple[41][354] = (byte)52;
	geoidSimple[41][355] = (byte)51;
	geoidSimple[41][356] = (byte)50;
	geoidSimple[41][357] = (byte)49;
	geoidSimple[41][358] = (byte)48;
	geoidSimple[41][359] = (byte)47;
	}
		/** Row 42*/
	private static void init42() {
	geoidSimple[42][0] = (byte)47;
	geoidSimple[42][1] = (byte)46;
	geoidSimple[42][2] = (byte)46;
	geoidSimple[42][3] = (byte)46;
	geoidSimple[42][4] = (byte)47;
	geoidSimple[42][5] = (byte)47;
	geoidSimple[42][6] = (byte)48;
	geoidSimple[42][7] = (byte)49;
	geoidSimple[42][8] = (byte)48;
	geoidSimple[42][9] = (byte)46;
	geoidSimple[42][10] = (byte)47;
	geoidSimple[42][11] = (byte)46;
	geoidSimple[42][12] = (byte)46;
	geoidSimple[42][13] = (byte)46;
	geoidSimple[42][14] = (byte)46;
	geoidSimple[42][15] = (byte)47;
	geoidSimple[42][16] = (byte)45;
	geoidSimple[42][17] = (byte)44;
	geoidSimple[42][18] = (byte)44;
	geoidSimple[42][19] = (byte)43;
	geoidSimple[42][20] = (byte)42;
	geoidSimple[42][21] = (byte)41;
	geoidSimple[42][22] = (byte)39;
	geoidSimple[42][23] = (byte)39;
	geoidSimple[42][24] = (byte)38;
	geoidSimple[42][25] = (byte)36;
	geoidSimple[42][26] = (byte)34;
	geoidSimple[42][27] = (byte)33;
	geoidSimple[42][28] = (byte)31;
	geoidSimple[42][29] = (byte)30;
	geoidSimple[42][30] = (byte)28;
	geoidSimple[42][31] = (byte)26;
	geoidSimple[42][32] = (byte)24;
	geoidSimple[42][33] = (byte)23;
	geoidSimple[42][34] = (byte)22;
	geoidSimple[42][35] = (byte)20;
	geoidSimple[42][36] = (byte)19;
	geoidSimple[42][37] = (byte)17;
	geoidSimple[42][38] = (byte)15;
	geoidSimple[42][39] = (byte)13;
	geoidSimple[42][40] = (byte)10;
	geoidSimple[42][41] = (byte)8;
	geoidSimple[42][42] = (byte)6;
	geoidSimple[42][43] = (byte)3;
	geoidSimple[42][44] = (byte)0;
	geoidSimple[42][45] = (byte)-3;
	geoidSimple[42][46] = (byte)-5;
	geoidSimple[42][47] = (byte)-8;
	geoidSimple[42][48] = (byte)-11;
	geoidSimple[42][49] = (byte)-13;
	geoidSimple[42][50] = (byte)-14;
	geoidSimple[42][51] = (byte)-16;
	geoidSimple[42][52] = (byte)-17;
	geoidSimple[42][53] = (byte)-18;
	geoidSimple[42][54] = (byte)-19;
	geoidSimple[42][55] = (byte)-20;
	geoidSimple[42][56] = (byte)-21;
	geoidSimple[42][57] = (byte)-21;
	geoidSimple[42][58] = (byte)-21;
	geoidSimple[42][59] = (byte)-24;
	geoidSimple[42][60] = (byte)-25;
	geoidSimple[42][61] = (byte)-28;
	geoidSimple[42][62] = (byte)-30;
	geoidSimple[42][63] = (byte)-32;
	geoidSimple[42][64] = (byte)-33;
	geoidSimple[42][65] = (byte)-33;
	geoidSimple[42][66] = (byte)-34;
	geoidSimple[42][67] = (byte)-35;
	geoidSimple[42][68] = (byte)-36;
	geoidSimple[42][69] = (byte)-37;
	geoidSimple[42][70] = (byte)-39;
	geoidSimple[42][71] = (byte)-41;
	geoidSimple[42][72] = (byte)-41;
	geoidSimple[42][73] = (byte)-42;
	geoidSimple[42][74] = (byte)-43;
	geoidSimple[42][75] = (byte)-44;
	geoidSimple[42][76] = (byte)-44;
	geoidSimple[42][77] = (byte)-44;
	geoidSimple[42][78] = (byte)-44;
	geoidSimple[42][79] = (byte)-45;
	geoidSimple[42][80] = (byte)-46;
	geoidSimple[42][81] = (byte)-46;
	geoidSimple[42][82] = (byte)-47;
	geoidSimple[42][83] = (byte)-48;
	geoidSimple[42][84] = (byte)-49;
	geoidSimple[42][85] = (byte)-49;
	geoidSimple[42][86] = (byte)-50;
	geoidSimple[42][87] = (byte)-50;
	geoidSimple[42][88] = (byte)-48;
	geoidSimple[42][89] = (byte)-44;
	geoidSimple[42][90] = (byte)-42;
	geoidSimple[42][91] = (byte)-44;
	geoidSimple[42][92] = (byte)-48;
	geoidSimple[42][93] = (byte)-49;
	geoidSimple[42][94] = (byte)-48;
	geoidSimple[42][95] = (byte)-48;
	geoidSimple[42][96] = (byte)-47;
	geoidSimple[42][97] = (byte)-45;
	geoidSimple[42][98] = (byte)-44;
	geoidSimple[42][99] = (byte)-43;
	geoidSimple[42][100] = (byte)-43;
	geoidSimple[42][101] = (byte)-44;
	geoidSimple[42][102] = (byte)-44;
	geoidSimple[42][103] = (byte)-43;
	geoidSimple[42][104] = (byte)-42;
	geoidSimple[42][105] = (byte)-41;
	geoidSimple[42][106] = (byte)-38;
	geoidSimple[42][107] = (byte)-36;
	geoidSimple[42][108] = (byte)-34;
	geoidSimple[42][109] = (byte)-31;
	geoidSimple[42][110] = (byte)-29;
	geoidSimple[42][111] = (byte)-27;
	geoidSimple[42][112] = (byte)-24;
	geoidSimple[42][113] = (byte)-22;
	geoidSimple[42][114] = (byte)-19;
	geoidSimple[42][115] = (byte)-16;
	geoidSimple[42][116] = (byte)-14;
	geoidSimple[42][117] = (byte)-11;
	geoidSimple[42][118] = (byte)-7;
	geoidSimple[42][119] = (byte)-4;
	geoidSimple[42][120] = (byte)0;
	geoidSimple[42][121] = (byte)2;
	geoidSimple[42][122] = (byte)3;
	geoidSimple[42][123] = (byte)5;
	geoidSimple[42][124] = (byte)7;
	geoidSimple[42][125] = (byte)10;
	geoidSimple[42][126] = (byte)12;
	geoidSimple[42][127] = (byte)14;
	geoidSimple[42][128] = (byte)16;
	geoidSimple[42][129] = (byte)18;
	geoidSimple[42][130] = (byte)18;
	geoidSimple[42][131] = (byte)19;
	geoidSimple[42][132] = (byte)19;
	geoidSimple[42][133] = (byte)20;
	geoidSimple[42][134] = (byte)21;
	geoidSimple[42][135] = (byte)23;
	geoidSimple[42][136] = (byte)25;
	geoidSimple[42][137] = (byte)26;
	geoidSimple[42][138] = (byte)26;
	geoidSimple[42][139] = (byte)24;
	geoidSimple[42][140] = (byte)22;
	geoidSimple[42][141] = (byte)22;
	geoidSimple[42][142] = (byte)24;
	geoidSimple[42][143] = (byte)22;
	geoidSimple[42][144] = (byte)21;
	geoidSimple[42][145] = (byte)20;
	geoidSimple[42][146] = (byte)19;
	geoidSimple[42][147] = (byte)20;
	geoidSimple[42][148] = (byte)20;
	geoidSimple[42][149] = (byte)20;
	geoidSimple[42][150] = (byte)21;
	geoidSimple[42][151] = (byte)21;
	geoidSimple[42][152] = (byte)23;
	geoidSimple[42][153] = (byte)24;
	geoidSimple[42][154] = (byte)18;
	geoidSimple[42][155] = (byte)6;
	geoidSimple[42][156] = (byte)6;
	geoidSimple[42][157] = (byte)10;
	geoidSimple[42][158] = (byte)11;
	geoidSimple[42][159] = (byte)10;
	geoidSimple[42][160] = (byte)8;
	geoidSimple[42][161] = (byte)7;
	geoidSimple[42][162] = (byte)5;
	geoidSimple[42][163] = (byte)3;
	geoidSimple[42][164] = (byte)1;
	geoidSimple[42][165] = (byte)0;
	geoidSimple[42][166] = (byte)0;
	geoidSimple[42][167] = (byte)-3;
	geoidSimple[42][168] = (byte)-3;
	geoidSimple[42][169] = (byte)-1;
	geoidSimple[42][170] = (byte)-5;
	geoidSimple[42][171] = (byte)-3;
	geoidSimple[42][172] = (byte)-2;
	geoidSimple[42][173] = (byte)-3;
	geoidSimple[42][174] = (byte)-3;
	geoidSimple[42][175] = (byte)-2;
	geoidSimple[42][176] = (byte)-2;
	geoidSimple[42][177] = (byte)-2;
	geoidSimple[42][178] = (byte)-2;
	geoidSimple[42][179] = (byte)-2;
	geoidSimple[42][LAT_GRID_SIZE] = (byte)-1;
	geoidSimple[42][181] = (byte)-1;
	geoidSimple[42][182] = (byte)0;
	geoidSimple[42][183] = (byte)0;
	geoidSimple[42][184] = (byte)0;
	geoidSimple[42][185] = (byte)0;
	geoidSimple[42][186] = (byte)1;
	geoidSimple[42][187] = (byte)2;
	geoidSimple[42][188] = (byte)2;
	geoidSimple[42][189] = (byte)2;
	geoidSimple[42][190] = (byte)2;
	geoidSimple[42][191] = (byte)3;
	geoidSimple[42][192] = (byte)3;
	geoidSimple[42][193] = (byte)3;
	geoidSimple[42][194] = (byte)3;
	geoidSimple[42][195] = (byte)3;
	geoidSimple[42][196] = (byte)3;
	geoidSimple[42][197] = (byte)3;
	geoidSimple[42][198] = (byte)2;
	geoidSimple[42][199] = (byte)2;
	geoidSimple[42][200] = (byte)1;
	geoidSimple[42][201] = (byte)0;
	geoidSimple[42][202] = (byte)0;
	geoidSimple[42][203] = (byte)0;
	geoidSimple[42][204] = (byte)-1;
	geoidSimple[42][205] = (byte)-2;
	geoidSimple[42][206] = (byte)-3;
	geoidSimple[42][207] = (byte)-4;
	geoidSimple[42][208] = (byte)-4;
	geoidSimple[42][209] = (byte)-5;
	geoidSimple[42][210] = (byte)-6;
	geoidSimple[42][211] = (byte)-8;
	geoidSimple[42][212] = (byte)-9;
	geoidSimple[42][213] = (byte)-10;
	geoidSimple[42][214] = (byte)-11;
	geoidSimple[42][215] = (byte)-12;
	geoidSimple[42][216] = (byte)-13;
	geoidSimple[42][217] = (byte)-15;
	geoidSimple[42][218] = (byte)-16;
	geoidSimple[42][219] = (byte)-17;
	geoidSimple[42][220] = (byte)-18;
	geoidSimple[42][221] = (byte)-19;
	geoidSimple[42][222] = (byte)-20;
	geoidSimple[42][223] = (byte)-21;
	geoidSimple[42][224] = (byte)-21;
	geoidSimple[42][225] = (byte)-22;
	geoidSimple[42][226] = (byte)-22;
	geoidSimple[42][227] = (byte)-22;
	geoidSimple[42][228] = (byte)-22;
	geoidSimple[42][229] = (byte)-22;
	geoidSimple[42][230] = (byte)-22;
	geoidSimple[42][231] = (byte)-22;
	geoidSimple[42][232] = (byte)-22;
	geoidSimple[42][233] = (byte)-23;
	geoidSimple[42][234] = (byte)-23;
	geoidSimple[42][235] = (byte)-23;
	geoidSimple[42][236] = (byte)-20;
	geoidSimple[42][237] = (byte)-21;
	geoidSimple[42][238] = (byte)-20;
	geoidSimple[42][239] = (byte)-17;
	geoidSimple[42][240] = (byte)-18;
	geoidSimple[42][241] = (byte)-18;
	geoidSimple[42][242] = (byte)-17;
	geoidSimple[42][243] = (byte)-16;
	geoidSimple[42][244] = (byte)-15;
	geoidSimple[42][245] = (byte)-15;
	geoidSimple[42][246] = (byte)-13;
	geoidSimple[42][247] = (byte)-12;
	geoidSimple[42][248] = (byte)-13;
	geoidSimple[42][249] = (byte)-13;
	geoidSimple[42][250] = (byte)-13;
	geoidSimple[42][251] = (byte)-14;
	geoidSimple[42][252] = (byte)-15;
	geoidSimple[42][253] = (byte)-15;
	geoidSimple[42][254] = (byte)-16;
	geoidSimple[42][255] = (byte)-16;
	geoidSimple[42][256] = (byte)-17;
	geoidSimple[42][257] = (byte)-17;
	geoidSimple[42][258] = (byte)-19;
	geoidSimple[42][259] = (byte)-21;
	geoidSimple[42][260] = (byte)-22;
	geoidSimple[42][261] = (byte)-24;
	geoidSimple[42][262] = (byte)-25;
	geoidSimple[42][263] = (byte)-26;
	geoidSimple[42][264] = (byte)-27;
	geoidSimple[42][265] = (byte)-28;
	geoidSimple[42][266] = (byte)-29;
	geoidSimple[42][267] = (byte)-30;
	geoidSimple[42][268] = (byte)-29;
	geoidSimple[42][269] = (byte)-30;
	geoidSimple[42][270] = (byte)-32;
	geoidSimple[42][271] = (byte)-33;
	geoidSimple[42][272] = (byte)-35;
	geoidSimple[42][273] = (byte)-36;
	geoidSimple[42][274] = (byte)-37;
	geoidSimple[42][275] = (byte)-37;
	geoidSimple[42][276] = (byte)-37;
	geoidSimple[42][277] = (byte)-37;
	geoidSimple[42][278] = (byte)-37;
	geoidSimple[42][279] = (byte)-37;
	geoidSimple[42][280] = (byte)-37;
	geoidSimple[42][281] = (byte)-37;
	geoidSimple[42][282] = (byte)-36;
	geoidSimple[42][283] = (byte)-35;
	geoidSimple[42][284] = (byte)-34;
	geoidSimple[42][285] = (byte)-33;
	geoidSimple[42][286] = (byte)-32;
	geoidSimple[42][287] = (byte)-30;
	geoidSimple[42][288] = (byte)-27;
	geoidSimple[42][289] = (byte)-26;
	geoidSimple[42][290] = (byte)-27;
	geoidSimple[42][291] = (byte)-25;
	geoidSimple[42][292] = (byte)-23;
	geoidSimple[42][293] = (byte)-21;
	geoidSimple[42][294] = (byte)-20;
	geoidSimple[42][295] = (byte)-20;
	geoidSimple[42][296] = (byte)-18;
	geoidSimple[42][297] = (byte)-17;
	geoidSimple[42][298] = (byte)-16;
	geoidSimple[42][299] = (byte)-15;
	geoidSimple[42][300] = (byte)-12;
	geoidSimple[42][301] = (byte)-7;
	geoidSimple[42][302] = (byte)-4;
	geoidSimple[42][303] = (byte)-1;
	geoidSimple[42][304] = (byte)2;
	geoidSimple[42][305] = (byte)5;
	geoidSimple[42][306] = (byte)8;
	geoidSimple[42][307] = (byte)10;
	geoidSimple[42][308] = (byte)13;
	geoidSimple[42][309] = (byte)16;
	geoidSimple[42][310] = (byte)20;
	geoidSimple[42][311] = (byte)25;
	geoidSimple[42][312] = (byte)27;
	geoidSimple[42][313] = (byte)29;
	geoidSimple[42][314] = (byte)33;
	geoidSimple[42][315] = (byte)35;
	geoidSimple[42][316] = (byte)36;
	geoidSimple[42][317] = (byte)36;
	geoidSimple[42][318] = (byte)37;
	geoidSimple[42][319] = (byte)40;
	geoidSimple[42][320] = (byte)42;
	geoidSimple[42][321] = (byte)44;
	geoidSimple[42][322] = (byte)46;
	geoidSimple[42][323] = (byte)49;
	geoidSimple[42][324] = (byte)51;
	geoidSimple[42][325] = (byte)52;
	geoidSimple[42][326] = (byte)54;
	geoidSimple[42][327] = (byte)56;
	geoidSimple[42][328] = (byte)58;
	geoidSimple[42][329] = (byte)60;
	geoidSimple[42][330] = (byte)62;
	geoidSimple[42][331] = (byte)63;
	geoidSimple[42][332] = (byte)65;
	geoidSimple[42][333] = (byte)65;
	geoidSimple[42][334] = (byte)65;
	geoidSimple[42][335] = (byte)64;
	geoidSimple[42][336] = (byte)63;
	geoidSimple[42][337] = (byte)62;
	geoidSimple[42][338] = (byte)62;
	geoidSimple[42][339] = (byte)62;
	geoidSimple[42][340] = (byte)61;
	geoidSimple[42][341] = (byte)61;
	geoidSimple[42][342] = (byte)60;
	geoidSimple[42][343] = (byte)59;
	geoidSimple[42][344] = (byte)57;
	geoidSimple[42][345] = (byte)56;
	geoidSimple[42][346] = (byte)55;
	geoidSimple[42][347] = (byte)54;
	geoidSimple[42][348] = (byte)52;
	geoidSimple[42][349] = (byte)51;
	geoidSimple[42][350] = (byte)50;
	geoidSimple[42][351] = (byte)50;
	geoidSimple[42][352] = (byte)51;
	geoidSimple[42][353] = (byte)51;
	geoidSimple[42][354] = (byte)51;
	geoidSimple[42][355] = (byte)50;
	geoidSimple[42][356] = (byte)49;
	geoidSimple[42][357] = (byte)49;
	geoidSimple[42][358] = (byte)48;
	geoidSimple[42][359] = (byte)47;
	}
		/** Row 43*/
	private static void init43() {
	geoidSimple[43][0] = (byte)47;
	geoidSimple[43][1] = (byte)48;
	geoidSimple[43][2] = (byte)48;
	geoidSimple[43][3] = (byte)48;
	geoidSimple[43][4] = (byte)48;
	geoidSimple[43][5] = (byte)49;
	geoidSimple[43][6] = (byte)49;
	geoidSimple[43][7] = (byte)49;
	geoidSimple[43][8] = (byte)49;
	geoidSimple[43][9] = (byte)48;
	geoidSimple[43][10] = (byte)49;
	geoidSimple[43][11] = (byte)49;
	geoidSimple[43][12] = (byte)49;
	geoidSimple[43][13] = (byte)47;
	geoidSimple[43][14] = (byte)47;
	geoidSimple[43][15] = (byte)47;
	geoidSimple[43][16] = (byte)45;
	geoidSimple[43][17] = (byte)45;
	geoidSimple[43][18] = (byte)44;
	geoidSimple[43][19] = (byte)43;
	geoidSimple[43][20] = (byte)42;
	geoidSimple[43][21] = (byte)42;
	geoidSimple[43][22] = (byte)42;
	geoidSimple[43][23] = (byte)41;
	geoidSimple[43][24] = (byte)39;
	geoidSimple[43][25] = (byte)38;
	geoidSimple[43][26] = (byte)35;
	geoidSimple[43][27] = (byte)32;
	geoidSimple[43][28] = (byte)31;
	geoidSimple[43][29] = (byte)30;
	geoidSimple[43][30] = (byte)28;
	geoidSimple[43][31] = (byte)26;
	geoidSimple[43][32] = (byte)24;
	geoidSimple[43][33] = (byte)22;
	geoidSimple[43][34] = (byte)21;
	geoidSimple[43][35] = (byte)19;
	geoidSimple[43][36] = (byte)17;
	geoidSimple[43][37] = (byte)15;
	geoidSimple[43][38] = (byte)13;
	geoidSimple[43][39] = (byte)12;
	geoidSimple[43][40] = (byte)10;
	geoidSimple[43][41] = (byte)8;
	geoidSimple[43][42] = (byte)6;
	geoidSimple[43][43] = (byte)4;
	geoidSimple[43][44] = (byte)1;
	geoidSimple[43][45] = (byte)-1;
	geoidSimple[43][46] = (byte)-3;
	geoidSimple[43][47] = (byte)-5;
	geoidSimple[43][48] = (byte)-8;
	geoidSimple[43][49] = (byte)-10;
	geoidSimple[43][50] = (byte)-13;
	geoidSimple[43][51] = (byte)-14;
	geoidSimple[43][52] = (byte)-16;
	geoidSimple[43][53] = (byte)-17;
	geoidSimple[43][54] = (byte)-19;
	geoidSimple[43][55] = (byte)-20;
	geoidSimple[43][56] = (byte)-22;
	geoidSimple[43][57] = (byte)-23;
	geoidSimple[43][58] = (byte)-24;
	geoidSimple[43][59] = (byte)-26;
	geoidSimple[43][60] = (byte)-28;
	geoidSimple[43][61] = (byte)-29;
	geoidSimple[43][62] = (byte)-31;
	geoidSimple[43][63] = (byte)-33;
	geoidSimple[43][64] = (byte)-34;
	geoidSimple[43][65] = (byte)-35;
	geoidSimple[43][66] = (byte)-36;
	geoidSimple[43][67] = (byte)-37;
	geoidSimple[43][68] = (byte)-38;
	geoidSimple[43][69] = (byte)-39;
	geoidSimple[43][70] = (byte)-40;
	geoidSimple[43][71] = (byte)-41;
	geoidSimple[43][72] = (byte)-42;
	geoidSimple[43][73] = (byte)-43;
	geoidSimple[43][74] = (byte)-44;
	geoidSimple[43][75] = (byte)-45;
	geoidSimple[43][76] = (byte)-47;
	geoidSimple[43][77] = (byte)-48;
	geoidSimple[43][78] = (byte)-49;
	geoidSimple[43][79] = (byte)-50;
	geoidSimple[43][80] = (byte)-50;
	geoidSimple[43][81] = (byte)-50;
	geoidSimple[43][82] = (byte)-51;
	geoidSimple[43][83] = (byte)-50;
	geoidSimple[43][84] = (byte)-50;
	geoidSimple[43][85] = (byte)-50;
	geoidSimple[43][86] = (byte)-53;
	geoidSimple[43][87] = (byte)-56;
	geoidSimple[43][88] = (byte)-55;
	geoidSimple[43][89] = (byte)-52;
	geoidSimple[43][90] = (byte)-48;
	geoidSimple[43][91] = (byte)-46;
	geoidSimple[43][92] = (byte)-46;
	geoidSimple[43][93] = (byte)-47;
	geoidSimple[43][94] = (byte)-50;
	geoidSimple[43][95] = (byte)-50;
	geoidSimple[43][96] = (byte)-48;
	geoidSimple[43][97] = (byte)-47;
	geoidSimple[43][98] = (byte)-46;
	geoidSimple[43][99] = (byte)-46;
	geoidSimple[43][100] = (byte)-44;
	geoidSimple[43][101] = (byte)-43;
	geoidSimple[43][102] = (byte)-43;
	geoidSimple[43][103] = (byte)-43;
	geoidSimple[43][104] = (byte)-42;
	geoidSimple[43][105] = (byte)-41;
	geoidSimple[43][106] = (byte)-39;
	geoidSimple[43][107] = (byte)-37;
	geoidSimple[43][108] = (byte)-34;
	geoidSimple[43][109] = (byte)-32;
	geoidSimple[43][110] = (byte)-30;
	geoidSimple[43][111] = (byte)-27;
	geoidSimple[43][112] = (byte)-24;
	geoidSimple[43][113] = (byte)-21;
	geoidSimple[43][114] = (byte)-18;
	geoidSimple[43][115] = (byte)-15;
	geoidSimple[43][116] = (byte)-13;
	geoidSimple[43][117] = (byte)-10;
	geoidSimple[43][118] = (byte)-6;
	geoidSimple[43][119] = (byte)-2;
	geoidSimple[43][120] = (byte)0;
	geoidSimple[43][121] = (byte)2;
	geoidSimple[43][122] = (byte)4;
	geoidSimple[43][123] = (byte)5;
	geoidSimple[43][124] = (byte)7;
	geoidSimple[43][125] = (byte)10;
	geoidSimple[43][126] = (byte)12;
	geoidSimple[43][127] = (byte)14;
	geoidSimple[43][128] = (byte)17;
	geoidSimple[43][129] = (byte)18;
	geoidSimple[43][130] = (byte)19;
	geoidSimple[43][131] = (byte)20;
	geoidSimple[43][132] = (byte)20;
	geoidSimple[43][133] = (byte)21;
	geoidSimple[43][134] = (byte)23;
	geoidSimple[43][135] = (byte)25;
	geoidSimple[43][136] = (byte)27;
	geoidSimple[43][137] = (byte)28;
	geoidSimple[43][138] = (byte)26;
	geoidSimple[43][139] = (byte)24;
	geoidSimple[43][140] = (byte)24;
	geoidSimple[43][141] = (byte)25;
	geoidSimple[43][142] = (byte)25;
	geoidSimple[43][143] = (byte)23;
	geoidSimple[43][144] = (byte)21;
	geoidSimple[43][145] = (byte)21;
	geoidSimple[43][146] = (byte)21;
	geoidSimple[43][147] = (byte)21;
	geoidSimple[43][148] = (byte)21;
	geoidSimple[43][149] = (byte)21;
	geoidSimple[43][150] = (byte)23;
	geoidSimple[43][151] = (byte)23;
	geoidSimple[43][152] = (byte)22;
	geoidSimple[43][153] = (byte)16;
	geoidSimple[43][154] = (byte)7;
	geoidSimple[43][155] = (byte)8;
	geoidSimple[43][156] = (byte)11;
	geoidSimple[43][157] = (byte)12;
	geoidSimple[43][158] = (byte)10;
	geoidSimple[43][159] = (byte)9;
	geoidSimple[43][160] = (byte)7;
	geoidSimple[43][161] = (byte)5;
	geoidSimple[43][162] = (byte)3;
	geoidSimple[43][163] = (byte)1;
	geoidSimple[43][164] = (byte)0;
	geoidSimple[43][165] = (byte)0;
	geoidSimple[43][166] = (byte)-2;
	geoidSimple[43][167] = (byte)-4;
	geoidSimple[43][168] = (byte)-7;
	geoidSimple[43][169] = (byte)-2;
	geoidSimple[43][170] = (byte)-7;
	geoidSimple[43][171] = (byte)-6;
	geoidSimple[43][172] = (byte)-5;
	geoidSimple[43][173] = (byte)-5;
	geoidSimple[43][174] = (byte)-5;
	geoidSimple[43][175] = (byte)-5;
	geoidSimple[43][176] = (byte)-4;
	geoidSimple[43][177] = (byte)-4;
	geoidSimple[43][178] = (byte)-4;
	geoidSimple[43][179] = (byte)-3;
	geoidSimple[43][LAT_GRID_SIZE] = (byte)-3;
	geoidSimple[43][181] = (byte)-3;
	geoidSimple[43][182] = (byte)-2;
	geoidSimple[43][183] = (byte)-1;
	geoidSimple[43][184] = (byte)-1;
	geoidSimple[43][185] = (byte)-1;
	geoidSimple[43][186] = (byte)0;
	geoidSimple[43][187] = (byte)0;
	geoidSimple[43][188] = (byte)0;
	geoidSimple[43][189] = (byte)0;
	geoidSimple[43][190] = (byte)0;
	geoidSimple[43][191] = (byte)0;
	geoidSimple[43][192] = (byte)1;
	geoidSimple[43][193] = (byte)0;
	geoidSimple[43][194] = (byte)0;
	geoidSimple[43][195] = (byte)0;
	geoidSimple[43][196] = (byte)1;
	geoidSimple[43][197] = (byte)1;
	geoidSimple[43][198] = (byte)0;
	geoidSimple[43][199] = (byte)0;
	geoidSimple[43][200] = (byte)0;
	geoidSimple[43][201] = (byte)-1;
	geoidSimple[43][202] = (byte)-2;
	geoidSimple[43][203] = (byte)-2;
	geoidSimple[43][204] = (byte)-3;
	geoidSimple[43][205] = (byte)-4;
	geoidSimple[43][206] = (byte)-5;
	geoidSimple[43][207] = (byte)-6;
	geoidSimple[43][208] = (byte)-7;
	geoidSimple[43][209] = (byte)-8;
	geoidSimple[43][210] = (byte)-9;
	geoidSimple[43][211] = (byte)-10;
	geoidSimple[43][212] = (byte)-11;
	geoidSimple[43][213] = (byte)-12;
	geoidSimple[43][214] = (byte)-13;
	geoidSimple[43][215] = (byte)-15;
	geoidSimple[43][216] = (byte)-16;
	geoidSimple[43][217] = (byte)-17;
	geoidSimple[43][218] = (byte)-18;
	geoidSimple[43][219] = (byte)-19;
	geoidSimple[43][220] = (byte)-20;
	geoidSimple[43][221] = (byte)-21;
	geoidSimple[43][222] = (byte)-22;
	geoidSimple[43][223] = (byte)-23;
	geoidSimple[43][224] = (byte)-24;
	geoidSimple[43][225] = (byte)-24;
	geoidSimple[43][226] = (byte)-24;
	geoidSimple[43][227] = (byte)-24;
	geoidSimple[43][228] = (byte)-24;
	geoidSimple[43][229] = (byte)-23;
	geoidSimple[43][230] = (byte)-23;
	geoidSimple[43][231] = (byte)-24;
	geoidSimple[43][232] = (byte)-24;
	geoidSimple[43][233] = (byte)-24;
	geoidSimple[43][234] = (byte)-25;
	geoidSimple[43][235] = (byte)-24;
	geoidSimple[43][236] = (byte)-21;
	geoidSimple[43][237] = (byte)-20;
	geoidSimple[43][238] = (byte)-18;
	geoidSimple[43][239] = (byte)-19;
	geoidSimple[43][240] = (byte)-20;
	geoidSimple[43][241] = (byte)-19;
	geoidSimple[43][242] = (byte)-18;
	geoidSimple[43][243] = (byte)-16;
	geoidSimple[43][244] = (byte)-15;
	geoidSimple[43][245] = (byte)-14;
	geoidSimple[43][246] = (byte)-13;
	geoidSimple[43][247] = (byte)-12;
	geoidSimple[43][248] = (byte)-11;
	geoidSimple[43][249] = (byte)-10;
	geoidSimple[43][250] = (byte)-11;
	geoidSimple[43][251] = (byte)-12;
	geoidSimple[43][252] = (byte)-14;
	geoidSimple[43][253] = (byte)-15;
	geoidSimple[43][254] = (byte)-15;
	geoidSimple[43][255] = (byte)-15;
	geoidSimple[43][256] = (byte)-15;
	geoidSimple[43][257] = (byte)-17;
	geoidSimple[43][258] = (byte)-19;
	geoidSimple[43][259] = (byte)-21;
	geoidSimple[43][260] = (byte)-22;
	geoidSimple[43][261] = (byte)-24;
	geoidSimple[43][262] = (byte)-25;
	geoidSimple[43][263] = (byte)-26;
	geoidSimple[43][264] = (byte)-27;
	geoidSimple[43][265] = (byte)-27;
	geoidSimple[43][266] = (byte)-28;
	geoidSimple[43][267] = (byte)-28;
	geoidSimple[43][268] = (byte)-29;
	geoidSimple[43][269] = (byte)-31;
	geoidSimple[43][270] = (byte)-31;
	geoidSimple[43][271] = (byte)-33;
	geoidSimple[43][272] = (byte)-34;
	geoidSimple[43][273] = (byte)-35;
	geoidSimple[43][274] = (byte)-36;
	geoidSimple[43][275] = (byte)-37;
	geoidSimple[43][276] = (byte)-37;
	geoidSimple[43][277] = (byte)-37;
	geoidSimple[43][278] = (byte)-37;
	geoidSimple[43][279] = (byte)-36;
	geoidSimple[43][280] = (byte)-37;
	geoidSimple[43][281] = (byte)-37;
	geoidSimple[43][282] = (byte)-36;
	geoidSimple[43][283] = (byte)-35;
	geoidSimple[43][284] = (byte)-34;
	geoidSimple[43][285] = (byte)-33;
	geoidSimple[43][286] = (byte)-32;
	geoidSimple[43][287] = (byte)-30;
	geoidSimple[43][288] = (byte)-29;
	geoidSimple[43][289] = (byte)-27;
	geoidSimple[43][290] = (byte)-26;
	geoidSimple[43][291] = (byte)-24;
	geoidSimple[43][292] = (byte)-23;
	geoidSimple[43][293] = (byte)-22;
	geoidSimple[43][294] = (byte)-21;
	geoidSimple[43][295] = (byte)-20;
	geoidSimple[43][296] = (byte)-18;
	geoidSimple[43][297] = (byte)-17;
	geoidSimple[43][298] = (byte)-16;
	geoidSimple[43][299] = (byte)-13;
	geoidSimple[43][300] = (byte)-12;
	geoidSimple[43][301] = (byte)-10;
	geoidSimple[43][302] = (byte)-7;
	geoidSimple[43][303] = (byte)-3;
	geoidSimple[43][304] = (byte)0;
	geoidSimple[43][305] = (byte)3;
	geoidSimple[43][306] = (byte)6;
	geoidSimple[43][307] = (byte)8;
	geoidSimple[43][308] = (byte)12;
	geoidSimple[43][309] = (byte)15;
	geoidSimple[43][310] = (byte)18;
	geoidSimple[43][311] = (byte)21;
	geoidSimple[43][312] = (byte)25;
	geoidSimple[43][313] = (byte)28;
	geoidSimple[43][314] = (byte)32;
	geoidSimple[43][315] = (byte)33;
	geoidSimple[43][316] = (byte)33;
	geoidSimple[43][317] = (byte)35;
	geoidSimple[43][318] = (byte)36;
	geoidSimple[43][319] = (byte)39;
	geoidSimple[43][320] = (byte)41;
	geoidSimple[43][321] = (byte)44;
	geoidSimple[43][322] = (byte)45;
	geoidSimple[43][323] = (byte)48;
	geoidSimple[43][324] = (byte)50;
	geoidSimple[43][325] = (byte)52;
	geoidSimple[43][326] = (byte)54;
	geoidSimple[43][327] = (byte)56;
	geoidSimple[43][328] = (byte)58;
	geoidSimple[43][329] = (byte)60;
	geoidSimple[43][330] = (byte)62;
	geoidSimple[43][331] = (byte)63;
	geoidSimple[43][332] = (byte)65;
	geoidSimple[43][333] = (byte)66;
	geoidSimple[43][334] = (byte)65;
	geoidSimple[43][335] = (byte)65;
	geoidSimple[43][336] = (byte)64;
	geoidSimple[43][337] = (byte)63;
	geoidSimple[43][338] = (byte)62;
	geoidSimple[43][339] = (byte)61;
	geoidSimple[43][340] = (byte)61;
	geoidSimple[43][341] = (byte)61;
	geoidSimple[43][342] = (byte)59;
	geoidSimple[43][343] = (byte)58;
	geoidSimple[43][344] = (byte)57;
	geoidSimple[43][345] = (byte)56;
	geoidSimple[43][346] = (byte)55;
	geoidSimple[43][347] = (byte)54;
	geoidSimple[43][348] = (byte)51;
	geoidSimple[43][349] = (byte)49;
	geoidSimple[43][350] = (byte)49;
	geoidSimple[43][351] = (byte)49;
	geoidSimple[43][352] = (byte)48;
	geoidSimple[43][353] = (byte)47;
	geoidSimple[43][354] = (byte)47;
	geoidSimple[43][355] = (byte)48;
	geoidSimple[43][356] = (byte)49;
	geoidSimple[43][357] = (byte)48;
	geoidSimple[43][358] = (byte)48;
	geoidSimple[43][359] = (byte)48;
	}
		/** Row 44*/
	private static void init44() {
	geoidSimple[44][0] = (byte)48;
	geoidSimple[44][1] = (byte)49;
	geoidSimple[44][2] = (byte)51;
	geoidSimple[44][3] = (byte)51;
	geoidSimple[44][4] = (byte)50;
	geoidSimple[44][5] = (byte)49;
	geoidSimple[44][6] = (byte)50;
	geoidSimple[44][7] = (byte)52;
	geoidSimple[44][8] = (byte)47;
	geoidSimple[44][9] = (byte)44;
	geoidSimple[44][10] = (byte)45;
	geoidSimple[44][11] = (byte)46;
	geoidSimple[44][12] = (byte)44;
	geoidSimple[44][13] = (byte)44;
	geoidSimple[44][14] = (byte)46;
	geoidSimple[44][15] = (byte)46;
	geoidSimple[44][16] = (byte)45;
	geoidSimple[44][17] = (byte)45;
	geoidSimple[44][18] = (byte)45;
	geoidSimple[44][19] = (byte)44;
	geoidSimple[44][20] = (byte)43;
	geoidSimple[44][21] = (byte)42;
	geoidSimple[44][22] = (byte)42;
	geoidSimple[44][23] = (byte)42;
	geoidSimple[44][24] = (byte)40;
	geoidSimple[44][25] = (byte)38;
	geoidSimple[44][26] = (byte)34;
	geoidSimple[44][27] = (byte)31;
	geoidSimple[44][28] = (byte)31;
	geoidSimple[44][29] = (byte)30;
	geoidSimple[44][30] = (byte)28;
	geoidSimple[44][31] = (byte)26;
	geoidSimple[44][32] = (byte)24;
	geoidSimple[44][33] = (byte)23;
	geoidSimple[44][34] = (byte)21;
	geoidSimple[44][35] = (byte)18;
	geoidSimple[44][36] = (byte)15;
	geoidSimple[44][37] = (byte)13;
	geoidSimple[44][38] = (byte)12;
	geoidSimple[44][39] = (byte)11;
	geoidSimple[44][40] = (byte)10;
	geoidSimple[44][41] = (byte)9;
	geoidSimple[44][42] = (byte)7;
	geoidSimple[44][43] = (byte)5;
	geoidSimple[44][44] = (byte)2;
	geoidSimple[44][45] = (byte)0;
	geoidSimple[44][46] = (byte)-2;
	geoidSimple[44][47] = (byte)-4;
	geoidSimple[44][48] = (byte)-6;
	geoidSimple[44][49] = (byte)-8;
	geoidSimple[44][50] = (byte)-10;
	geoidSimple[44][51] = (byte)-12;
	geoidSimple[44][52] = (byte)-15;
	geoidSimple[44][53] = (byte)-16;
	geoidSimple[44][54] = (byte)-19;
	geoidSimple[44][55] = (byte)-21;
	geoidSimple[44][56] = (byte)-23;
	geoidSimple[44][57] = (byte)-25;
	geoidSimple[44][58] = (byte)-26;
	geoidSimple[44][59] = (byte)-28;
	geoidSimple[44][60] = (byte)-29;
	geoidSimple[44][61] = (byte)-30;
	geoidSimple[44][62] = (byte)-31;
	geoidSimple[44][63] = (byte)-33;
	geoidSimple[44][64] = (byte)-35;
	geoidSimple[44][65] = (byte)-36;
	geoidSimple[44][66] = (byte)-37;
	geoidSimple[44][67] = (byte)-38;
	geoidSimple[44][68] = (byte)-39;
	geoidSimple[44][69] = (byte)-41;
	geoidSimple[44][70] = (byte)-42;
	geoidSimple[44][71] = (byte)-42;
	geoidSimple[44][72] = (byte)-43;
	geoidSimple[44][73] = (byte)-43;
	geoidSimple[44][74] = (byte)-45;
	geoidSimple[44][75] = (byte)-47;
	geoidSimple[44][76] = (byte)-48;
	geoidSimple[44][77] = (byte)-50;
	geoidSimple[44][78] = (byte)-50;
	geoidSimple[44][79] = (byte)-49;
	geoidSimple[44][80] = (byte)-47;
	geoidSimple[44][81] = (byte)-48;
	geoidSimple[44][82] = (byte)-51;
	geoidSimple[44][83] = (byte)-50;
	geoidSimple[44][84] = (byte)-54;
	geoidSimple[44][85] = (byte)-60;
	geoidSimple[44][86] = (byte)-62;
	geoidSimple[44][87] = (byte)-62;
	geoidSimple[44][88] = (byte)-61;
	geoidSimple[44][89] = (byte)-57;
	geoidSimple[44][90] = (byte)-54;
	geoidSimple[44][91] = (byte)-53;
	geoidSimple[44][92] = (byte)-52;
	geoidSimple[44][93] = (byte)-51;
	geoidSimple[44][94] = (byte)-51;
	geoidSimple[44][95] = (byte)-51;
	geoidSimple[44][96] = (byte)-50;
	geoidSimple[44][97] = (byte)-49;
	geoidSimple[44][98] = (byte)-49;
	geoidSimple[44][99] = (byte)-49;
	geoidSimple[44][100] = (byte)-48;
	geoidSimple[44][101] = (byte)-46;
	geoidSimple[44][102] = (byte)-46;
	geoidSimple[44][103] = (byte)-45;
	geoidSimple[44][104] = (byte)-44;
	geoidSimple[44][105] = (byte)-42;
	geoidSimple[44][106] = (byte)-40;
	geoidSimple[44][107] = (byte)-38;
	geoidSimple[44][108] = (byte)-35;
	geoidSimple[44][109] = (byte)-33;
	geoidSimple[44][110] = (byte)-30;
	geoidSimple[44][111] = (byte)-27;
	geoidSimple[44][112] = (byte)-24;
	geoidSimple[44][113] = (byte)-20;
	geoidSimple[44][114] = (byte)-17;
	geoidSimple[44][115] = (byte)-15;
	geoidSimple[44][116] = (byte)-11;
	geoidSimple[44][117] = (byte)-8;
	geoidSimple[44][118] = (byte)-5;
	geoidSimple[44][119] = (byte)-1;
	geoidSimple[44][120] = (byte)1;
	geoidSimple[44][121] = (byte)2;
	geoidSimple[44][122] = (byte)4;
	geoidSimple[44][123] = (byte)6;
	geoidSimple[44][124] = (byte)8;
	geoidSimple[44][125] = (byte)11;
	geoidSimple[44][126] = (byte)13;
	geoidSimple[44][127] = (byte)15;
	geoidSimple[44][128] = (byte)18;
	geoidSimple[44][129] = (byte)20;
	geoidSimple[44][130] = (byte)21;
	geoidSimple[44][131] = (byte)22;
	geoidSimple[44][132] = (byte)22;
	geoidSimple[44][133] = (byte)23;
	geoidSimple[44][134] = (byte)25;
	geoidSimple[44][135] = (byte)28;
	geoidSimple[44][136] = (byte)29;
	geoidSimple[44][137] = (byte)26;
	geoidSimple[44][138] = (byte)25;
	geoidSimple[44][139] = (byte)25;
	geoidSimple[44][140] = (byte)26;
	geoidSimple[44][141] = (byte)27;
	geoidSimple[44][142] = (byte)26;
	geoidSimple[44][143] = (byte)26;
	geoidSimple[44][144] = (byte)24;
	geoidSimple[44][145] = (byte)23;
	geoidSimple[44][146] = (byte)23;
	geoidSimple[44][147] = (byte)24;
	geoidSimple[44][148] = (byte)25;
	geoidSimple[44][149] = (byte)24;
	geoidSimple[44][150] = (byte)21;
	geoidSimple[44][151] = (byte)13;
	geoidSimple[44][152] = (byte)5;
	geoidSimple[44][153] = (byte)2;
	geoidSimple[44][154] = (byte)8;
	geoidSimple[44][155] = (byte)11;
	geoidSimple[44][156] = (byte)11;
	geoidSimple[44][157] = (byte)10;
	geoidSimple[44][158] = (byte)9;
	geoidSimple[44][159] = (byte)7;
	geoidSimple[44][160] = (byte)5;
	geoidSimple[44][161] = (byte)3;
	geoidSimple[44][162] = (byte)1;
	geoidSimple[44][163] = (byte)0;
	geoidSimple[44][164] = (byte)-1;
	geoidSimple[44][165] = (byte)-2;
	geoidSimple[44][166] = (byte)-3;
	geoidSimple[44][167] = (byte)-5;
	geoidSimple[44][168] = (byte)-7;
	geoidSimple[44][169] = (byte)-5;
	geoidSimple[44][170] = (byte)-6;
	geoidSimple[44][171] = (byte)-8;
	geoidSimple[44][172] = (byte)-6;
	geoidSimple[44][173] = (byte)-6;
	geoidSimple[44][174] = (byte)-7;
	geoidSimple[44][175] = (byte)-6;
	geoidSimple[44][176] = (byte)-6;
	geoidSimple[44][177] = (byte)-6;
	geoidSimple[44][178] = (byte)-5;
	geoidSimple[44][179] = (byte)-5;
	geoidSimple[44][LAT_GRID_SIZE] = (byte)-5;
	geoidSimple[44][181] = (byte)-4;
	geoidSimple[44][182] = (byte)-4;
	geoidSimple[44][183] = (byte)-3;
	geoidSimple[44][184] = (byte)-3;
	geoidSimple[44][185] = (byte)-3;
	geoidSimple[44][186] = (byte)-2;
	geoidSimple[44][187] = (byte)-2;
	geoidSimple[44][188] = (byte)-2;
	geoidSimple[44][189] = (byte)-1;
	geoidSimple[44][190] = (byte)-1;
	geoidSimple[44][191] = (byte)-1;
	geoidSimple[44][192] = (byte)-1;
	geoidSimple[44][193] = (byte)-1;
	geoidSimple[44][194] = (byte)-1;
	geoidSimple[44][195] = (byte)-1;
	geoidSimple[44][196] = (byte)-1;
	geoidSimple[44][197] = (byte)-1;
	geoidSimple[44][198] = (byte)-1;
	geoidSimple[44][199] = (byte)-2;
	geoidSimple[44][200] = (byte)-3;
	geoidSimple[44][201] = (byte)-3;
	geoidSimple[44][202] = (byte)-4;
	geoidSimple[44][203] = (byte)-5;
	geoidSimple[44][204] = (byte)-6;
	geoidSimple[44][205] = (byte)-7;
	geoidSimple[44][206] = (byte)-7;
	geoidSimple[44][207] = (byte)-8;
	geoidSimple[44][208] = (byte)-10;
	geoidSimple[44][209] = (byte)-11;
	geoidSimple[44][210] = (byte)-12;
	geoidSimple[44][211] = (byte)-13;
	geoidSimple[44][212] = (byte)-14;
	geoidSimple[44][213] = (byte)-14;
	geoidSimple[44][214] = (byte)-15;
	geoidSimple[44][215] = (byte)-17;
	geoidSimple[44][216] = (byte)-18;
	geoidSimple[44][217] = (byte)-19;
	geoidSimple[44][218] = (byte)-20;
	geoidSimple[44][219] = (byte)-21;
	geoidSimple[44][220] = (byte)-22;
	geoidSimple[44][221] = (byte)-24;
	geoidSimple[44][222] = (byte)-24;
	geoidSimple[44][223] = (byte)-25;
	geoidSimple[44][224] = (byte)-26;
	geoidSimple[44][225] = (byte)-26;
	geoidSimple[44][226] = (byte)-26;
	geoidSimple[44][227] = (byte)-26;
	geoidSimple[44][228] = (byte)-26;
	geoidSimple[44][229] = (byte)-25;
	geoidSimple[44][230] = (byte)-25;
	geoidSimple[44][231] = (byte)-25;
	geoidSimple[44][232] = (byte)-25;
	geoidSimple[44][233] = (byte)-25;
	geoidSimple[44][234] = (byte)-26;
	geoidSimple[44][235] = (byte)-25;
	geoidSimple[44][236] = (byte)-21;
	geoidSimple[44][237] = (byte)-21;
	geoidSimple[44][238] = (byte)-20;
	geoidSimple[44][239] = (byte)-19;
	geoidSimple[44][240] = (byte)-20;
	geoidSimple[44][241] = (byte)-18;
	geoidSimple[44][242] = (byte)-16;
	geoidSimple[44][243] = (byte)-15;
	geoidSimple[44][244] = (byte)-15;
	geoidSimple[44][245] = (byte)-14;
	geoidSimple[44][246] = (byte)-12;
	geoidSimple[44][247] = (byte)-11;
	geoidSimple[44][248] = (byte)-10;
	geoidSimple[44][249] = (byte)-9;
	geoidSimple[44][250] = (byte)-10;
	geoidSimple[44][251] = (byte)-12;
	geoidSimple[44][252] = (byte)-13;
	geoidSimple[44][253] = (byte)-14;
	geoidSimple[44][254] = (byte)-15;
	geoidSimple[44][255] = (byte)-15;
	geoidSimple[44][256] = (byte)-15;
	geoidSimple[44][257] = (byte)-17;
	geoidSimple[44][258] = (byte)-19;
	geoidSimple[44][259] = (byte)-21;
	geoidSimple[44][260] = (byte)-22;
	geoidSimple[44][261] = (byte)-24;
	geoidSimple[44][262] = (byte)-25;
	geoidSimple[44][263] = (byte)-26;
	geoidSimple[44][264] = (byte)-26;
	geoidSimple[44][265] = (byte)-27;
	geoidSimple[44][266] = (byte)-27;
	geoidSimple[44][267] = (byte)-28;
	geoidSimple[44][268] = (byte)-29;
	geoidSimple[44][269] = (byte)-30;
	geoidSimple[44][270] = (byte)-32;
	geoidSimple[44][271] = (byte)-34;
	geoidSimple[44][272] = (byte)-35;
	geoidSimple[44][273] = (byte)-36;
	geoidSimple[44][274] = (byte)-35;
	geoidSimple[44][275] = (byte)-36;
	geoidSimple[44][276] = (byte)-37;
	geoidSimple[44][277] = (byte)-37;
	geoidSimple[44][278] = (byte)-37;
	geoidSimple[44][279] = (byte)-37;
	geoidSimple[44][280] = (byte)-36;
	geoidSimple[44][281] = (byte)-35;
	geoidSimple[44][282] = (byte)-35;
	geoidSimple[44][283] = (byte)-34;
	geoidSimple[44][284] = (byte)-33;
	geoidSimple[44][285] = (byte)-32;
	geoidSimple[44][286] = (byte)-31;
	geoidSimple[44][287] = (byte)-29;
	geoidSimple[44][288] = (byte)-27;
	geoidSimple[44][289] = (byte)-26;
	geoidSimple[44][290] = (byte)-25;
	geoidSimple[44][291] = (byte)-24;
	geoidSimple[44][292] = (byte)-24;
	geoidSimple[44][293] = (byte)-23;
	geoidSimple[44][294] = (byte)-21;
	geoidSimple[44][295] = (byte)-20;
	geoidSimple[44][296] = (byte)-19;
	geoidSimple[44][297] = (byte)-17;
	geoidSimple[44][298] = (byte)-16;
	geoidSimple[44][299] = (byte)-14;
	geoidSimple[44][300] = (byte)-13;
	geoidSimple[44][301] = (byte)-10;
	geoidSimple[44][302] = (byte)-8;
	geoidSimple[44][303] = (byte)-4;
	geoidSimple[44][304] = (byte)-1;
	geoidSimple[44][305] = (byte)2;
	geoidSimple[44][306] = (byte)5;
	geoidSimple[44][307] = (byte)8;
	geoidSimple[44][308] = (byte)11;
	geoidSimple[44][309] = (byte)15;
	geoidSimple[44][310] = (byte)18;
	geoidSimple[44][311] = (byte)21;
	geoidSimple[44][312] = (byte)23;
	geoidSimple[44][313] = (byte)26;
	geoidSimple[44][314] = (byte)27;
	geoidSimple[44][315] = (byte)29;
	geoidSimple[44][316] = (byte)31;
	geoidSimple[44][317] = (byte)33;
	geoidSimple[44][318] = (byte)35;
	geoidSimple[44][319] = (byte)38;
	geoidSimple[44][320] = (byte)40;
	geoidSimple[44][321] = (byte)42;
	geoidSimple[44][322] = (byte)45;
	geoidSimple[44][323] = (byte)47;
	geoidSimple[44][324] = (byte)49;
	geoidSimple[44][325] = (byte)52;
	geoidSimple[44][326] = (byte)54;
	geoidSimple[44][327] = (byte)56;
	geoidSimple[44][328] = (byte)58;
	geoidSimple[44][329] = (byte)60;
	geoidSimple[44][330] = (byte)61;
	geoidSimple[44][331] = (byte)63;
	geoidSimple[44][332] = (byte)65;
	geoidSimple[44][333] = (byte)65;
	geoidSimple[44][334] = (byte)65;
	geoidSimple[44][335] = (byte)65;
	geoidSimple[44][336] = (byte)64;
	geoidSimple[44][337] = (byte)63;
	geoidSimple[44][338] = (byte)62;
	geoidSimple[44][339] = (byte)61;
	geoidSimple[44][340] = (byte)60;
	geoidSimple[44][341] = (byte)60;
	geoidSimple[44][342] = (byte)59;
	geoidSimple[44][343] = (byte)58;
	geoidSimple[44][344] = (byte)57;
	geoidSimple[44][345] = (byte)56;
	geoidSimple[44][346] = (byte)54;
	geoidSimple[44][347] = (byte)53;
	geoidSimple[44][348] = (byte)51;
	geoidSimple[44][349] = (byte)51;
	geoidSimple[44][350] = (byte)49;
	geoidSimple[44][351] = (byte)48;
	geoidSimple[44][352] = (byte)47;
	geoidSimple[44][353] = (byte)46;
	geoidSimple[44][354] = (byte)46;
	geoidSimple[44][355] = (byte)46;
	geoidSimple[44][356] = (byte)47;
	geoidSimple[44][357] = (byte)48;
	geoidSimple[44][358] = (byte)47;
	geoidSimple[44][359] = (byte)47;
	}
		/** Row 45*/
	private static void init45() {
	geoidSimple[45][0] = (byte)48;
	geoidSimple[45][1] = (byte)49;
	geoidSimple[45][2] = (byte)51;
	geoidSimple[45][3] = (byte)52;
	geoidSimple[45][4] = (byte)51;
	geoidSimple[45][5] = (byte)51;
	geoidSimple[45][6] = (byte)52;
	geoidSimple[45][7] = (byte)50;
	geoidSimple[45][8] = (byte)44;
	geoidSimple[45][9] = (byte)42;
	geoidSimple[45][10] = (byte)40;
	geoidSimple[45][11] = (byte)41;
	geoidSimple[45][12] = (byte)41;
	geoidSimple[45][13] = (byte)42;
	geoidSimple[45][14] = (byte)43;
	geoidSimple[45][15] = (byte)45;
	geoidSimple[45][16] = (byte)46;
	geoidSimple[45][17] = (byte)46;
	geoidSimple[45][18] = (byte)46;
	geoidSimple[45][19] = (byte)44;
	geoidSimple[45][20] = (byte)43;
	geoidSimple[45][21] = (byte)43;
	geoidSimple[45][22] = (byte)42;
	geoidSimple[45][23] = (byte)39;
	geoidSimple[45][24] = (byte)37;
	geoidSimple[45][25] = (byte)36;
	geoidSimple[45][26] = (byte)34;
	geoidSimple[45][27] = (byte)33;
	geoidSimple[45][28] = (byte)33;
	geoidSimple[45][29] = (byte)32;
	geoidSimple[45][30] = (byte)31;
	geoidSimple[45][31] = (byte)28;
	geoidSimple[45][32] = (byte)25;
	geoidSimple[45][33] = (byte)25;
	geoidSimple[45][34] = (byte)22;
	geoidSimple[45][35] = (byte)18;
	geoidSimple[45][36] = (byte)17;
	geoidSimple[45][37] = (byte)15;
	geoidSimple[45][38] = (byte)14;
	geoidSimple[45][39] = (byte)14;
	geoidSimple[45][40] = (byte)15;
	geoidSimple[45][41] = (byte)14;
	geoidSimple[45][42] = (byte)12;
	geoidSimple[45][43] = (byte)7;
	geoidSimple[45][44] = (byte)3;
	geoidSimple[45][45] = (byte)0;
	geoidSimple[45][46] = (byte)-3;
	geoidSimple[45][47] = (byte)-5;
	geoidSimple[45][48] = (byte)-7;
	geoidSimple[45][49] = (byte)-9;
	geoidSimple[45][50] = (byte)-11;
	geoidSimple[45][51] = (byte)-12;
	geoidSimple[45][52] = (byte)-14;
	geoidSimple[45][53] = (byte)-16;
	geoidSimple[45][54] = (byte)-18;
	geoidSimple[45][55] = (byte)-20;
	geoidSimple[45][56] = (byte)-22;
	geoidSimple[45][57] = (byte)-24;
	geoidSimple[45][58] = (byte)-26;
	geoidSimple[45][59] = (byte)-28;
	geoidSimple[45][60] = (byte)-29;
	geoidSimple[45][61] = (byte)-30;
	geoidSimple[45][62] = (byte)-32;
	geoidSimple[45][63] = (byte)-34;
	geoidSimple[45][64] = (byte)-35;
	geoidSimple[45][65] = (byte)-37;
	geoidSimple[45][66] = (byte)-38;
	geoidSimple[45][67] = (byte)-38;
	geoidSimple[45][68] = (byte)-39;
	geoidSimple[45][69] = (byte)-40;
	geoidSimple[45][70] = (byte)-42;
	geoidSimple[45][71] = (byte)-43;
	geoidSimple[45][72] = (byte)-43;
	geoidSimple[45][73] = (byte)-44;
	geoidSimple[45][74] = (byte)-46;
	geoidSimple[45][75] = (byte)-47;
	geoidSimple[45][76] = (byte)-48;
	geoidSimple[45][77] = (byte)-48;
	geoidSimple[45][78] = (byte)-46;
	geoidSimple[45][79] = (byte)-44;
	geoidSimple[45][80] = (byte)-43;
	geoidSimple[45][81] = (byte)-48;
	geoidSimple[45][82] = (byte)-53;
	geoidSimple[45][83] = (byte)-56;
	geoidSimple[45][84] = (byte)-60;
	geoidSimple[45][85] = (byte)-64;
	geoidSimple[45][86] = (byte)-66;
	geoidSimple[45][87] = (byte)-67;
	geoidSimple[45][88] = (byte)-64;
	geoidSimple[45][89] = (byte)-61;
	geoidSimple[45][90] = (byte)-59;
	geoidSimple[45][91] = (byte)-58;
	geoidSimple[45][92] = (byte)-58;
	geoidSimple[45][93] = (byte)-59;
	geoidSimple[45][94] = (byte)-58;
	geoidSimple[45][95] = (byte)-54;
	geoidSimple[45][96] = (byte)-54;
	geoidSimple[45][97] = (byte)-52;
	geoidSimple[45][98] = (byte)-51;
	geoidSimple[45][99] = (byte)-50;
	geoidSimple[45][100] = (byte)-49;
	geoidSimple[45][101] = (byte)-48;
	geoidSimple[45][102] = (byte)-47;
	geoidSimple[45][103] = (byte)-47;
	geoidSimple[45][104] = (byte)-45;
	geoidSimple[45][105] = (byte)-43;
	geoidSimple[45][106] = (byte)-41;
	geoidSimple[45][107] = (byte)-38;
	geoidSimple[45][108] = (byte)-35;
	geoidSimple[45][109] = (byte)-33;
	geoidSimple[45][110] = (byte)-30;
	geoidSimple[45][111] = (byte)-27;
	geoidSimple[45][112] = (byte)-24;
	geoidSimple[45][113] = (byte)-20;
	geoidSimple[45][114] = (byte)-16;
	geoidSimple[45][115] = (byte)-13;
	geoidSimple[45][116] = (byte)-9;
	geoidSimple[45][117] = (byte)-6;
	geoidSimple[45][118] = (byte)-3;
	geoidSimple[45][119] = (byte)0;
	geoidSimple[45][120] = (byte)1;
	geoidSimple[45][121] = (byte)2;
	geoidSimple[45][122] = (byte)4;
	geoidSimple[45][123] = (byte)6;
	geoidSimple[45][124] = (byte)9;
	geoidSimple[45][125] = (byte)12;
	geoidSimple[45][126] = (byte)15;
	geoidSimple[45][127] = (byte)18;
	geoidSimple[45][128] = (byte)18;
	geoidSimple[45][129] = (byte)22;
	geoidSimple[45][130] = (byte)24;
	geoidSimple[45][131] = (byte)24;
	geoidSimple[45][132] = (byte)23;
	geoidSimple[45][133] = (byte)24;
	geoidSimple[45][134] = (byte)26;
	geoidSimple[45][135] = (byte)28;
	geoidSimple[45][136] = (byte)27;
	geoidSimple[45][137] = (byte)25;
	geoidSimple[45][138] = (byte)26;
	geoidSimple[45][139] = (byte)27;
	geoidSimple[45][140] = (byte)29;
	geoidSimple[45][141] = (byte)29;
	geoidSimple[45][142] = (byte)29;
	geoidSimple[45][143] = (byte)28;
	geoidSimple[45][144] = (byte)28;
	geoidSimple[45][145] = (byte)27;
	geoidSimple[45][146] = (byte)28;
	geoidSimple[45][147] = (byte)28;
	geoidSimple[45][148] = (byte)23;
	geoidSimple[45][149] = (byte)11;
	geoidSimple[45][150] = (byte)1;
	geoidSimple[45][151] = (byte)-1;
	geoidSimple[45][152] = (byte)2;
	geoidSimple[45][153] = (byte)8;
	geoidSimple[45][154] = (byte)11;
	geoidSimple[45][155] = (byte)11;
	geoidSimple[45][156] = (byte)10;
	geoidSimple[45][157] = (byte)8;
	geoidSimple[45][158] = (byte)6;
	geoidSimple[45][159] = (byte)5;
	geoidSimple[45][160] = (byte)3;
	geoidSimple[45][161] = (byte)1;
	geoidSimple[45][162] = (byte)0;
	geoidSimple[45][163] = (byte)-1;
	geoidSimple[45][164] = (byte)-2;
	geoidSimple[45][165] = (byte)-3;
	geoidSimple[45][166] = (byte)-4;
	geoidSimple[45][167] = (byte)-5;
	geoidSimple[45][168] = (byte)-8;
	geoidSimple[45][169] = (byte)-8;
	geoidSimple[45][170] = (byte)-5;
	geoidSimple[45][171] = (byte)-10;
	geoidSimple[45][172] = (byte)-8;
	geoidSimple[45][173] = (byte)-8;
	geoidSimple[45][174] = (byte)-8;
	geoidSimple[45][175] = (byte)-8;
	geoidSimple[45][176] = (byte)-7;
	geoidSimple[45][177] = (byte)-7;
	geoidSimple[45][178] = (byte)-7;
	geoidSimple[45][179] = (byte)-7;
	geoidSimple[45][LAT_GRID_SIZE] = (byte)-6;
	geoidSimple[45][181] = (byte)-6;
	geoidSimple[45][182] = (byte)-6;
	geoidSimple[45][183] = (byte)-6;
	geoidSimple[45][184] = (byte)-5;
	geoidSimple[45][185] = (byte)-5;
	geoidSimple[45][186] = (byte)-4;
	geoidSimple[45][187] = (byte)-4;
	geoidSimple[45][188] = (byte)-4;
	geoidSimple[45][189] = (byte)-4;
	geoidSimple[45][190] = (byte)-3;
	geoidSimple[45][191] = (byte)-3;
	geoidSimple[45][192] = (byte)-3;
	geoidSimple[45][193] = (byte)-3;
	geoidSimple[45][194] = (byte)-3;
	geoidSimple[45][195] = (byte)-3;
	geoidSimple[45][196] = (byte)-4;
	geoidSimple[45][197] = (byte)-4;
	geoidSimple[45][198] = (byte)-4;
	geoidSimple[45][199] = (byte)-4;
	geoidSimple[45][200] = (byte)-5;
	geoidSimple[45][201] = (byte)-6;
	geoidSimple[45][202] = (byte)-6;
	geoidSimple[45][203] = (byte)-7;
	geoidSimple[45][204] = (byte)-8;
	geoidSimple[45][205] = (byte)-9;
	geoidSimple[45][206] = (byte)-10;
	geoidSimple[45][207] = (byte)-11;
	geoidSimple[45][208] = (byte)-12;
	geoidSimple[45][209] = (byte)-13;
	geoidSimple[45][210] = (byte)-14;
	geoidSimple[45][211] = (byte)-15;
	geoidSimple[45][212] = (byte)-16;
	geoidSimple[45][213] = (byte)-17;
	geoidSimple[45][214] = (byte)-18;
	geoidSimple[45][215] = (byte)-18;
	geoidSimple[45][216] = (byte)-20;
	geoidSimple[45][217] = (byte)-21;
	geoidSimple[45][218] = (byte)-22;
	geoidSimple[45][219] = (byte)-23;
	geoidSimple[45][220] = (byte)-24;
	geoidSimple[45][221] = (byte)-25;
	geoidSimple[45][222] = (byte)-26;
	geoidSimple[45][223] = (byte)-26;
	geoidSimple[45][224] = (byte)-27;
	geoidSimple[45][225] = (byte)-28;
	geoidSimple[45][226] = (byte)-28;
	geoidSimple[45][227] = (byte)-28;
	geoidSimple[45][228] = (byte)-28;
	geoidSimple[45][229] = (byte)-27;
	geoidSimple[45][230] = (byte)-27;
	geoidSimple[45][231] = (byte)-26;
	geoidSimple[45][232] = (byte)-26;
	geoidSimple[45][233] = (byte)-27;
	geoidSimple[45][234] = (byte)-28;
	geoidSimple[45][235] = (byte)-25;
	geoidSimple[45][236] = (byte)-21;
	geoidSimple[45][237] = (byte)-21;
	geoidSimple[45][238] = (byte)-20;
	geoidSimple[45][239] = (byte)-19;
	geoidSimple[45][240] = (byte)-18;
	geoidSimple[45][241] = (byte)-16;
	geoidSimple[45][242] = (byte)-16;
	geoidSimple[45][243] = (byte)-15;
	geoidSimple[45][244] = (byte)-14;
	geoidSimple[45][245] = (byte)-13;
	geoidSimple[45][246] = (byte)-11;
	geoidSimple[45][247] = (byte)-10;
	geoidSimple[45][248] = (byte)-9;
	geoidSimple[45][249] = (byte)-8;
	geoidSimple[45][250] = (byte)-8;
	geoidSimple[45][251] = (byte)-12;
	geoidSimple[45][252] = (byte)-10;
	geoidSimple[45][253] = (byte)-13;
	geoidSimple[45][254] = (byte)-14;
	geoidSimple[45][255] = (byte)-14;
	geoidSimple[45][256] = (byte)-15;
	geoidSimple[45][257] = (byte)-18;
	geoidSimple[45][258] = (byte)-20;
	geoidSimple[45][259] = (byte)-22;
	geoidSimple[45][260] = (byte)-23;
	geoidSimple[45][261] = (byte)-24;
	geoidSimple[45][262] = (byte)-25;
	geoidSimple[45][263] = (byte)-25;
	geoidSimple[45][264] = (byte)-27;
	geoidSimple[45][265] = (byte)-27;
	geoidSimple[45][266] = (byte)-27;
	geoidSimple[45][267] = (byte)-29;
	geoidSimple[45][268] = (byte)-31;
	geoidSimple[45][269] = (byte)-33;
	geoidSimple[45][270] = (byte)-35;
	geoidSimple[45][271] = (byte)-36;
	geoidSimple[45][272] = (byte)-36;
	geoidSimple[45][273] = (byte)-36;
	geoidSimple[45][274] = (byte)-34;
	geoidSimple[45][275] = (byte)-34;
	geoidSimple[45][276] = (byte)-36;
	geoidSimple[45][277] = (byte)-36;
	geoidSimple[45][278] = (byte)-37;
	geoidSimple[45][279] = (byte)-36;
	geoidSimple[45][280] = (byte)-36;
	geoidSimple[45][281] = (byte)-36;
	geoidSimple[45][282] = (byte)-35;
	geoidSimple[45][283] = (byte)-34;
	geoidSimple[45][284] = (byte)-33;
	geoidSimple[45][285] = (byte)-30;
	geoidSimple[45][286] = (byte)-29;
	geoidSimple[45][287] = (byte)-28;
	geoidSimple[45][288] = (byte)-27;
	geoidSimple[45][289] = (byte)-26;
	geoidSimple[45][290] = (byte)-26;
	geoidSimple[45][291] = (byte)-25;
	geoidSimple[45][292] = (byte)-24;
	geoidSimple[45][293] = (byte)-23;
	geoidSimple[45][294] = (byte)-22;
	geoidSimple[45][295] = (byte)-22;
	geoidSimple[45][296] = (byte)-21;
	geoidSimple[45][297] = (byte)-19;
	geoidSimple[45][298] = (byte)-18;
	geoidSimple[45][299] = (byte)-17;
	geoidSimple[45][300] = (byte)-14;
	geoidSimple[45][301] = (byte)-12;
	geoidSimple[45][302] = (byte)-9;
	geoidSimple[45][303] = (byte)-6;
	geoidSimple[45][304] = (byte)-5;
	geoidSimple[45][305] = (byte)-2;
	geoidSimple[45][306] = (byte)2;
	geoidSimple[45][307] = (byte)6;
	geoidSimple[45][308] = (byte)10;
	geoidSimple[45][309] = (byte)14;
	geoidSimple[45][310] = (byte)17;
	geoidSimple[45][311] = (byte)18;
	geoidSimple[45][312] = (byte)20;
	geoidSimple[45][313] = (byte)23;
	geoidSimple[45][314] = (byte)25;
	geoidSimple[45][315] = (byte)27;
	geoidSimple[45][316] = (byte)29;
	geoidSimple[45][317] = (byte)32;
	geoidSimple[45][318] = (byte)34;
	geoidSimple[45][319] = (byte)37;
	geoidSimple[45][320] = (byte)39;
	geoidSimple[45][321] = (byte)42;
	geoidSimple[45][322] = (byte)44;
	geoidSimple[45][323] = (byte)47;
	geoidSimple[45][324] = (byte)49;
	geoidSimple[45][325] = (byte)51;
	geoidSimple[45][326] = (byte)53;
	geoidSimple[45][327] = (byte)55;
	geoidSimple[45][328] = (byte)58;
	geoidSimple[45][329] = (byte)60;
	geoidSimple[45][330] = (byte)61;
	geoidSimple[45][331] = (byte)63;
	geoidSimple[45][332] = (byte)64;
	geoidSimple[45][333] = (byte)64;
	geoidSimple[45][334] = (byte)64;
	geoidSimple[45][335] = (byte)64;
	geoidSimple[45][336] = (byte)63;
	geoidSimple[45][337] = (byte)63;
	geoidSimple[45][338] = (byte)62;
	geoidSimple[45][339] = (byte)61;
	geoidSimple[45][340] = (byte)59;
	geoidSimple[45][341] = (byte)58;
	geoidSimple[45][342] = (byte)58;
	geoidSimple[45][343] = (byte)58;
	geoidSimple[45][344] = (byte)56;
	geoidSimple[45][345] = (byte)55;
	geoidSimple[45][346] = (byte)55;
	geoidSimple[45][347] = (byte)54;
	geoidSimple[45][348] = (byte)51;
	geoidSimple[45][349] = (byte)49;
	geoidSimple[45][350] = (byte)48;
	geoidSimple[45][351] = (byte)47;
	geoidSimple[45][352] = (byte)45;
	geoidSimple[45][353] = (byte)44;
	geoidSimple[45][354] = (byte)44;
	geoidSimple[45][355] = (byte)45;
	geoidSimple[45][356] = (byte)44;
	geoidSimple[45][357] = (byte)47;
	geoidSimple[45][358] = (byte)48;
	geoidSimple[45][359] = (byte)47;
	}
		/** Row 46*/
	private static void init46() {
	geoidSimple[46][0] = (byte)49;
	geoidSimple[46][1] = (byte)49;
	geoidSimple[46][2] = (byte)50;
	geoidSimple[46][3] = (byte)50;
	geoidSimple[46][4] = (byte)50;
	geoidSimple[46][5] = (byte)50;
	geoidSimple[46][6] = (byte)50;
	geoidSimple[46][7] = (byte)48;
	geoidSimple[46][8] = (byte)46;
	geoidSimple[46][9] = (byte)46;
	geoidSimple[46][10] = (byte)47;
	geoidSimple[46][11] = (byte)46;
	geoidSimple[46][12] = (byte)44;
	geoidSimple[46][13] = (byte)42;
	geoidSimple[46][14] = (byte)42;
	geoidSimple[46][15] = (byte)43;
	geoidSimple[46][16] = (byte)44;
	geoidSimple[46][17] = (byte)44;
	geoidSimple[46][18] = (byte)45;
	geoidSimple[46][19] = (byte)46;
	geoidSimple[46][20] = (byte)45;
	geoidSimple[46][21] = (byte)44;
	geoidSimple[46][22] = (byte)42;
	geoidSimple[46][23] = (byte)41;
	geoidSimple[46][24] = (byte)39;
	geoidSimple[46][25] = (byte)38;
	geoidSimple[46][26] = (byte)37;
	geoidSimple[46][27] = (byte)36;
	geoidSimple[46][28] = (byte)34;
	geoidSimple[46][29] = (byte)31;
	geoidSimple[46][30] = (byte)30;
	geoidSimple[46][31] = (byte)27;
	geoidSimple[46][32] = (byte)23;
	geoidSimple[46][33] = (byte)20;
	geoidSimple[46][34] = (byte)18;
	geoidSimple[46][35] = (byte)17;
	geoidSimple[46][36] = (byte)18;
	geoidSimple[46][37] = (byte)16;
	geoidSimple[46][38] = (byte)13;
	geoidSimple[46][39] = (byte)16;
	geoidSimple[46][40] = (byte)21;
	geoidSimple[46][41] = (byte)22;
	geoidSimple[46][42] = (byte)20;
	geoidSimple[46][43] = (byte)14;
	geoidSimple[46][44] = (byte)7;
	geoidSimple[46][45] = (byte)2;
	geoidSimple[46][46] = (byte)-2;
	geoidSimple[46][47] = (byte)-6;
	geoidSimple[46][48] = (byte)-7;
	geoidSimple[46][49] = (byte)-8;
	geoidSimple[46][50] = (byte)-10;
	geoidSimple[46][51] = (byte)-11;
	geoidSimple[46][52] = (byte)-12;
	geoidSimple[46][53] = (byte)-15;
	geoidSimple[46][54] = (byte)-17;
	geoidSimple[46][55] = (byte)-18;
	geoidSimple[46][56] = (byte)-20;
	geoidSimple[46][57] = (byte)-23;
	geoidSimple[46][58] = (byte)-26;
	geoidSimple[46][59] = (byte)-27;
	geoidSimple[46][60] = (byte)-28;
	geoidSimple[46][61] = (byte)-30;
	geoidSimple[46][62] = (byte)-32;
	geoidSimple[46][63] = (byte)-34;
	geoidSimple[46][64] = (byte)-36;
	geoidSimple[46][65] = (byte)-37;
	geoidSimple[46][66] = (byte)-39;
	geoidSimple[46][67] = (byte)-39;
	geoidSimple[46][68] = (byte)-38;
	geoidSimple[46][69] = (byte)-39;
	geoidSimple[46][70] = (byte)-41;
	geoidSimple[46][71] = (byte)-42;
	geoidSimple[46][72] = (byte)-43;
	geoidSimple[46][73] = (byte)-44;
	geoidSimple[46][74] = (byte)-43;
	geoidSimple[46][75] = (byte)-43;
	geoidSimple[46][76] = (byte)-45;
	geoidSimple[46][77] = (byte)-45;
	geoidSimple[46][78] = (byte)-46;
	geoidSimple[46][79] = (byte)-48;
	geoidSimple[46][80] = (byte)-49;
	geoidSimple[46][81] = (byte)-50;
	geoidSimple[46][82] = (byte)-52;
	geoidSimple[46][83] = (byte)-50;
	geoidSimple[46][84] = (byte)-50;
	geoidSimple[46][85] = (byte)-51;
	geoidSimple[46][86] = (byte)-56;
	geoidSimple[46][87] = (byte)-61;
	geoidSimple[46][88] = (byte)-59;
	geoidSimple[46][89] = (byte)-59;
	geoidSimple[46][90] = (byte)-59;
	geoidSimple[46][91] = (byte)-60;
	geoidSimple[46][92] = (byte)-59;
	geoidSimple[46][93] = (byte)-57;
	geoidSimple[46][94] = (byte)-58;
	geoidSimple[46][95] = (byte)-60;
	geoidSimple[46][96] = (byte)-57;
	geoidSimple[46][97] = (byte)-55;
	geoidSimple[46][98] = (byte)-54;
	geoidSimple[46][99] = (byte)-53;
	geoidSimple[46][100] = (byte)-51;
	geoidSimple[46][101] = (byte)-50;
	geoidSimple[46][102] = (byte)-48;
	geoidSimple[46][103] = (byte)-46;
	geoidSimple[46][104] = (byte)-44;
	geoidSimple[46][105] = (byte)-43;
	geoidSimple[46][106] = (byte)-41;
	geoidSimple[46][107] = (byte)-39;
	geoidSimple[46][108] = (byte)-36;
	geoidSimple[46][109] = (byte)-33;
	geoidSimple[46][110] = (byte)-30;
	geoidSimple[46][111] = (byte)-27;
	geoidSimple[46][112] = (byte)-24;
	geoidSimple[46][113] = (byte)-20;
	geoidSimple[46][114] = (byte)-16;
	geoidSimple[46][115] = (byte)-12;
	geoidSimple[46][116] = (byte)-8;
	geoidSimple[46][117] = (byte)-4;
	geoidSimple[46][118] = (byte)-2;
	geoidSimple[46][119] = (byte)0;
	geoidSimple[46][120] = (byte)1;
	geoidSimple[46][121] = (byte)3;
	geoidSimple[46][122] = (byte)5;
	geoidSimple[46][123] = (byte)7;
	geoidSimple[46][124] = (byte)11;
	geoidSimple[46][125] = (byte)14;
	geoidSimple[46][126] = (byte)18;
	geoidSimple[46][127] = (byte)21;
	geoidSimple[46][128] = (byte)21;
	geoidSimple[46][129] = (byte)24;
	geoidSimple[46][130] = (byte)26;
	geoidSimple[46][131] = (byte)25;
	geoidSimple[46][132] = (byte)25;
	geoidSimple[46][133] = (byte)24;
	geoidSimple[46][134] = (byte)26;
	geoidSimple[46][135] = (byte)26;
	geoidSimple[46][136] = (byte)26;
	geoidSimple[46][137] = (byte)26;
	geoidSimple[46][138] = (byte)27;
	geoidSimple[46][139] = (byte)28;
	geoidSimple[46][140] = (byte)30;
	geoidSimple[46][141] = (byte)31;
	geoidSimple[46][142] = (byte)31;
	geoidSimple[46][143] = (byte)31;
	geoidSimple[46][144] = (byte)31;
	geoidSimple[46][145] = (byte)31;
	geoidSimple[46][146] = (byte)27;
	geoidSimple[46][147] = (byte)18;
	geoidSimple[46][148] = (byte)6;
	geoidSimple[46][149] = (byte)0;
	geoidSimple[46][150] = (byte)4;
	geoidSimple[46][151] = (byte)9;
	geoidSimple[46][152] = (byte)12;
	geoidSimple[46][153] = (byte)12;
	geoidSimple[46][154] = (byte)11;
	geoidSimple[46][155] = (byte)10;
	geoidSimple[46][156] = (byte)8;
	geoidSimple[46][157] = (byte)6;
	geoidSimple[46][158] = (byte)5;
	geoidSimple[46][159] = (byte)3;
	geoidSimple[46][160] = (byte)1;
	geoidSimple[46][161] = (byte)0;
	geoidSimple[46][162] = (byte)-1;
	geoidSimple[46][163] = (byte)-2;
	geoidSimple[46][164] = (byte)-3;
	geoidSimple[46][165] = (byte)-4;
	geoidSimple[46][166] = (byte)-5;
	geoidSimple[46][167] = (byte)-6;
	geoidSimple[46][168] = (byte)-8;
	geoidSimple[46][169] = (byte)-10;
	geoidSimple[46][170] = (byte)-8;
	geoidSimple[46][171] = (byte)-11;
	geoidSimple[46][172] = (byte)-9;
	geoidSimple[46][173] = (byte)-8;
	geoidSimple[46][174] = (byte)-10;
	geoidSimple[46][175] = (byte)-10;
	geoidSimple[46][176] = (byte)-9;
	geoidSimple[46][177] = (byte)-9;
	geoidSimple[46][178] = (byte)-9;
	geoidSimple[46][179] = (byte)-8;
	geoidSimple[46][LAT_GRID_SIZE] = (byte)-8;
	geoidSimple[46][181] = (byte)-8;
	geoidSimple[46][182] = (byte)-8;
	geoidSimple[46][183] = (byte)-7;
	geoidSimple[46][184] = (byte)-7;
	geoidSimple[46][185] = (byte)-7;
	geoidSimple[46][186] = (byte)-6;
	geoidSimple[46][187] = (byte)-6;
	geoidSimple[46][188] = (byte)-6;
	geoidSimple[46][189] = (byte)-6;
	geoidSimple[46][190] = (byte)-5;
	geoidSimple[46][191] = (byte)-5;
	geoidSimple[46][192] = (byte)-5;
	geoidSimple[46][193] = (byte)-5;
	geoidSimple[46][194] = (byte)-5;
	geoidSimple[46][195] = (byte)-5;
	geoidSimple[46][196] = (byte)-6;
	geoidSimple[46][197] = (byte)-6;
	geoidSimple[46][198] = (byte)-6;
	geoidSimple[46][199] = (byte)-7;
	geoidSimple[46][200] = (byte)-7;
	geoidSimple[46][201] = (byte)-8;
	geoidSimple[46][202] = (byte)-8;
	geoidSimple[46][203] = (byte)-9;
	geoidSimple[46][204] = (byte)-10;
	geoidSimple[46][205] = (byte)-11;
	geoidSimple[46][206] = (byte)-12;
	geoidSimple[46][207] = (byte)-12;
	geoidSimple[46][208] = (byte)-13;
	geoidSimple[46][209] = (byte)-14;
	geoidSimple[46][210] = (byte)-16;
	geoidSimple[46][211] = (byte)-17;
	geoidSimple[46][212] = (byte)-18;
	geoidSimple[46][213] = (byte)-19;
	geoidSimple[46][214] = (byte)-19;
	geoidSimple[46][215] = (byte)-20;
	geoidSimple[46][216] = (byte)-21;
	geoidSimple[46][217] = (byte)-22;
	geoidSimple[46][218] = (byte)-23;
	geoidSimple[46][219] = (byte)-24;
	geoidSimple[46][220] = (byte)-25;
	geoidSimple[46][221] = (byte)-26;
	geoidSimple[46][222] = (byte)-27;
	geoidSimple[46][223] = (byte)-28;
	geoidSimple[46][224] = (byte)-29;
	geoidSimple[46][225] = (byte)-29;
	geoidSimple[46][226] = (byte)-29;
	geoidSimple[46][227] = (byte)-29;
	geoidSimple[46][228] = (byte)-29;
	geoidSimple[46][229] = (byte)-29;
	geoidSimple[46][230] = (byte)-29;
	geoidSimple[46][231] = (byte)-28;
	geoidSimple[46][232] = (byte)-28;
	geoidSimple[46][233] = (byte)-28;
	geoidSimple[46][234] = (byte)-29;
	geoidSimple[46][235] = (byte)-26;
	geoidSimple[46][236] = (byte)-23;
	geoidSimple[46][237] = (byte)-22;
	geoidSimple[46][238] = (byte)-20;
	geoidSimple[46][239] = (byte)-19;
	geoidSimple[46][240] = (byte)-18;
	geoidSimple[46][241] = (byte)-17;
	geoidSimple[46][242] = (byte)-17;
	geoidSimple[46][243] = (byte)-16;
	geoidSimple[46][244] = (byte)-14;
	geoidSimple[46][245] = (byte)-12;
	geoidSimple[46][246] = (byte)-12;
	geoidSimple[46][247] = (byte)-11;
	geoidSimple[46][248] = (byte)-10;
	geoidSimple[46][249] = (byte)-9;
	geoidSimple[46][250] = (byte)-8;
	geoidSimple[46][251] = (byte)-12;
	geoidSimple[46][252] = (byte)-12;
	geoidSimple[46][253] = (byte)-12;
	geoidSimple[46][254] = (byte)-14;
	geoidSimple[46][255] = (byte)-14;
	geoidSimple[46][256] = (byte)-14;
	geoidSimple[46][257] = (byte)-17;
	geoidSimple[46][258] = (byte)-20;
	geoidSimple[46][259] = (byte)-23;
	geoidSimple[46][260] = (byte)-25;
	geoidSimple[46][261] = (byte)-26;
	geoidSimple[46][262] = (byte)-26;
	geoidSimple[46][263] = (byte)-26;
	geoidSimple[46][264] = (byte)-27;
	geoidSimple[46][265] = (byte)-28;
	geoidSimple[46][266] = (byte)-29;
	geoidSimple[46][267] = (byte)-30;
	geoidSimple[46][268] = (byte)-31;
	geoidSimple[46][269] = (byte)-33;
	geoidSimple[46][270] = (byte)-35;
	geoidSimple[46][271] = (byte)-35;
	geoidSimple[46][272] = (byte)-35;
	geoidSimple[46][273] = (byte)-35;
	geoidSimple[46][274] = (byte)-33;
	geoidSimple[46][275] = (byte)-34;
	geoidSimple[46][276] = (byte)-35;
	geoidSimple[46][277] = (byte)-35;
	geoidSimple[46][278] = (byte)-36;
	geoidSimple[46][279] = (byte)-36;
	geoidSimple[46][280] = (byte)-37;
	geoidSimple[46][281] = (byte)-36;
	geoidSimple[46][282] = (byte)-36;
	geoidSimple[46][283] = (byte)-35;
	geoidSimple[46][284] = (byte)-33;
	geoidSimple[46][285] = (byte)-30;
	geoidSimple[46][286] = (byte)-29;
	geoidSimple[46][287] = (byte)-28;
	geoidSimple[46][288] = (byte)-27;
	geoidSimple[46][289] = (byte)-27;
	geoidSimple[46][290] = (byte)-26;
	geoidSimple[46][291] = (byte)-25;
	geoidSimple[46][292] = (byte)-24;
	geoidSimple[46][293] = (byte)-23;
	geoidSimple[46][294] = (byte)-23;
	geoidSimple[46][295] = (byte)-23;
	geoidSimple[46][296] = (byte)-22;
	geoidSimple[46][297] = (byte)-20;
	geoidSimple[46][298] = (byte)-19;
	geoidSimple[46][299] = (byte)-17;
	geoidSimple[46][300] = (byte)-15;
	geoidSimple[46][301] = (byte)-15;
	geoidSimple[46][302] = (byte)-14;
	geoidSimple[46][303] = (byte)-10;
	geoidSimple[46][304] = (byte)-8;
	geoidSimple[46][305] = (byte)-6;
	geoidSimple[46][306] = (byte)-2;
	geoidSimple[46][307] = (byte)2;
	geoidSimple[46][308] = (byte)8;
	geoidSimple[46][309] = (byte)12;
	geoidSimple[46][310] = (byte)15;
	geoidSimple[46][311] = (byte)16;
	geoidSimple[46][312] = (byte)18;
	geoidSimple[46][313] = (byte)20;
	geoidSimple[46][314] = (byte)23;
	geoidSimple[46][315] = (byte)25;
	geoidSimple[46][316] = (byte)27;
	geoidSimple[46][317] = (byte)30;
	geoidSimple[46][318] = (byte)33;
	geoidSimple[46][319] = (byte)35;
	geoidSimple[46][320] = (byte)38;
	geoidSimple[46][321] = (byte)41;
	geoidSimple[46][322] = (byte)44;
	geoidSimple[46][323] = (byte)46;
	geoidSimple[46][324] = (byte)48;
	geoidSimple[46][325] = (byte)51;
	geoidSimple[46][326] = (byte)53;
	geoidSimple[46][327] = (byte)55;
	geoidSimple[46][328] = (byte)57;
	geoidSimple[46][329] = (byte)59;
	geoidSimple[46][330] = (byte)61;
	geoidSimple[46][331] = (byte)63;
	geoidSimple[46][332] = (byte)63;
	geoidSimple[46][333] = (byte)63;
	geoidSimple[46][334] = (byte)63;
	geoidSimple[46][335] = (byte)62;
	geoidSimple[46][336] = (byte)62;
	geoidSimple[46][337] = (byte)62;
	geoidSimple[46][338] = (byte)61;
	geoidSimple[46][339] = (byte)60;
	geoidSimple[46][340] = (byte)58;
	geoidSimple[46][341] = (byte)58;
	geoidSimple[46][342] = (byte)58;
	geoidSimple[46][343] = (byte)57;
	geoidSimple[46][344] = (byte)54;
	geoidSimple[46][345] = (byte)54;
	geoidSimple[46][346] = (byte)53;
	geoidSimple[46][347] = (byte)52;
	geoidSimple[46][348] = (byte)50;
	geoidSimple[46][349] = (byte)49;
	geoidSimple[46][350] = (byte)51;
	geoidSimple[46][351] = (byte)53;
	geoidSimple[46][352] = (byte)53;
	geoidSimple[46][353] = (byte)52;
	geoidSimple[46][354] = (byte)52;
	geoidSimple[46][355] = (byte)51;
	geoidSimple[46][356] = (byte)48;
	geoidSimple[46][357] = (byte)48;
	geoidSimple[46][358] = (byte)49;
	geoidSimple[46][359] = (byte)49;
	}
		/** Row 47*/
	private static void init47() {
	geoidSimple[47][0] = (byte)52;
	geoidSimple[47][1] = (byte)52;
	geoidSimple[47][2] = (byte)51;
	geoidSimple[47][3] = (byte)49;
	geoidSimple[47][4] = (byte)48;
	geoidSimple[47][5] = (byte)47;
	geoidSimple[47][6] = (byte)46;
	geoidSimple[47][7] = (byte)45;
	geoidSimple[47][8] = (byte)46;
	geoidSimple[47][9] = (byte)49;
	geoidSimple[47][10] = (byte)48;
	geoidSimple[47][11] = (byte)48;
	geoidSimple[47][12] = (byte)48;
	geoidSimple[47][13] = (byte)47;
	geoidSimple[47][14] = (byte)44;
	geoidSimple[47][15] = (byte)43;
	geoidSimple[47][16] = (byte)44;
	geoidSimple[47][17] = (byte)42;
	geoidSimple[47][18] = (byte)40;
	geoidSimple[47][19] = (byte)42;
	geoidSimple[47][20] = (byte)44;
	geoidSimple[47][21] = (byte)43;
	geoidSimple[47][22] = (byte)44;
	geoidSimple[47][23] = (byte)43;
	geoidSimple[47][24] = (byte)42;
	geoidSimple[47][25] = (byte)40;
	geoidSimple[47][26] = (byte)39;
	geoidSimple[47][27] = (byte)37;
	geoidSimple[47][28] = (byte)34;
	geoidSimple[47][29] = (byte)30;
	geoidSimple[47][30] = (byte)29;
	geoidSimple[47][31] = (byte)27;
	geoidSimple[47][32] = (byte)24;
	geoidSimple[47][33] = (byte)23;
	geoidSimple[47][34] = (byte)23;
	geoidSimple[47][35] = (byte)21;
	geoidSimple[47][36] = (byte)20;
	geoidSimple[47][37] = (byte)20;
	geoidSimple[47][38] = (byte)18;
	geoidSimple[47][39] = (byte)16;
	geoidSimple[47][40] = (byte)17;
	geoidSimple[47][41] = (byte)19;
	geoidSimple[47][42] = (byte)20;
	geoidSimple[47][43] = (byte)19;
	geoidSimple[47][44] = (byte)17;
	geoidSimple[47][45] = (byte)13;
	geoidSimple[47][46] = (byte)7;
	geoidSimple[47][47] = (byte)0;
	geoidSimple[47][48] = (byte)-5;
	geoidSimple[47][49] = (byte)-8;
	geoidSimple[47][50] = (byte)-9;
	geoidSimple[47][51] = (byte)-10;
	geoidSimple[47][52] = (byte)-12;
	geoidSimple[47][53] = (byte)-14;
	geoidSimple[47][54] = (byte)-16;
	geoidSimple[47][55] = (byte)-19;
	geoidSimple[47][56] = (byte)-21;
	geoidSimple[47][57] = (byte)-23;
	geoidSimple[47][58] = (byte)-25;
	geoidSimple[47][59] = (byte)-26;
	geoidSimple[47][60] = (byte)-27;
	geoidSimple[47][61] = (byte)-30;
	geoidSimple[47][62] = (byte)-31;
	geoidSimple[47][63] = (byte)-32;
	geoidSimple[47][64] = (byte)-34;
	geoidSimple[47][65] = (byte)-37;
	geoidSimple[47][66] = (byte)-39;
	geoidSimple[47][67] = (byte)-41;
	geoidSimple[47][68] = (byte)-43;
	geoidSimple[47][69] = (byte)-42;
	geoidSimple[47][70] = (byte)-38;
	geoidSimple[47][71] = (byte)-38;
	geoidSimple[47][72] = (byte)-38;
	geoidSimple[47][73] = (byte)-39;
	geoidSimple[47][74] = (byte)-39;
	geoidSimple[47][75] = (byte)-39;
	geoidSimple[47][76] = (byte)-39;
	geoidSimple[47][77] = (byte)-40;
	geoidSimple[47][78] = (byte)-41;
	geoidSimple[47][79] = (byte)-42;
	geoidSimple[47][80] = (byte)-42;
	geoidSimple[47][81] = (byte)-45;
	geoidSimple[47][82] = (byte)-48;
	geoidSimple[47][83] = (byte)-49;
	geoidSimple[47][84] = (byte)-50;
	geoidSimple[47][85] = (byte)-50;
	geoidSimple[47][86] = (byte)-54;
	geoidSimple[47][87] = (byte)-57;
	geoidSimple[47][88] = (byte)-64;
	geoidSimple[47][89] = (byte)-65;
	geoidSimple[47][90] = (byte)-64;
	geoidSimple[47][91] = (byte)-64;
	geoidSimple[47][92] = (byte)-64;
	geoidSimple[47][93] = (byte)-62;
	geoidSimple[47][94] = (byte)-59;
	geoidSimple[47][95] = (byte)-58;
	geoidSimple[47][96] = (byte)-58;
	geoidSimple[47][97] = (byte)-56;
	geoidSimple[47][98] = (byte)-56;
	geoidSimple[47][99] = (byte)-55;
	geoidSimple[47][100] = (byte)-53;
	geoidSimple[47][101] = (byte)-52;
	geoidSimple[47][102] = (byte)-50;
	geoidSimple[47][103] = (byte)-48;
	geoidSimple[47][104] = (byte)-45;
	geoidSimple[47][105] = (byte)-43;
	geoidSimple[47][106] = (byte)-42;
	geoidSimple[47][107] = (byte)-39;
	geoidSimple[47][108] = (byte)-36;
	geoidSimple[47][109] = (byte)-32;
	geoidSimple[47][110] = (byte)-29;
	geoidSimple[47][111] = (byte)-26;
	geoidSimple[47][112] = (byte)-23;
	geoidSimple[47][113] = (byte)-19;
	geoidSimple[47][114] = (byte)-15;
	geoidSimple[47][115] = (byte)-10;
	geoidSimple[47][116] = (byte)-6;
	geoidSimple[47][117] = (byte)-3;
	geoidSimple[47][118] = (byte)-1;
	geoidSimple[47][119] = (byte)0;
	geoidSimple[47][120] = (byte)2;
	geoidSimple[47][121] = (byte)4;
	geoidSimple[47][122] = (byte)6;
	geoidSimple[47][123] = (byte)9;
	geoidSimple[47][124] = (byte)13;
	geoidSimple[47][125] = (byte)17;
	geoidSimple[47][126] = (byte)21;
	geoidSimple[47][127] = (byte)21;
	geoidSimple[47][128] = (byte)23;
	geoidSimple[47][129] = (byte)25;
	geoidSimple[47][130] = (byte)24;
	geoidSimple[47][131] = (byte)24;
	geoidSimple[47][132] = (byte)25;
	geoidSimple[47][133] = (byte)25;
	geoidSimple[47][134] = (byte)25;
	geoidSimple[47][135] = (byte)25;
	geoidSimple[47][136] = (byte)26;
	geoidSimple[47][137] = (byte)27;
	geoidSimple[47][138] = (byte)28;
	geoidSimple[47][139] = (byte)30;
	geoidSimple[47][140] = (byte)33;
	geoidSimple[47][141] = (byte)30;
	geoidSimple[47][142] = (byte)27;
	geoidSimple[47][143] = (byte)25;
	geoidSimple[47][144] = (byte)22;
	geoidSimple[47][145] = (byte)18;
	geoidSimple[47][146] = (byte)12;
	geoidSimple[47][147] = (byte)6;
	geoidSimple[47][148] = (byte)7;
	geoidSimple[47][149] = (byte)12;
	geoidSimple[47][150] = (byte)15;
	geoidSimple[47][151] = (byte)15;
	geoidSimple[47][152] = (byte)14;
	geoidSimple[47][153] = (byte)12;
	geoidSimple[47][154] = (byte)11;
	geoidSimple[47][155] = (byte)9;
	geoidSimple[47][156] = (byte)7;
	geoidSimple[47][157] = (byte)5;
	geoidSimple[47][158] = (byte)3;
	geoidSimple[47][159] = (byte)1;
	geoidSimple[47][160] = (byte)0;
	geoidSimple[47][161] = (byte)-1;
	geoidSimple[47][162] = (byte)-2;
	geoidSimple[47][163] = (byte)-4;
	geoidSimple[47][164] = (byte)-5;
	geoidSimple[47][165] = (byte)-5;
	geoidSimple[47][166] = (byte)-6;
	geoidSimple[47][167] = (byte)-7;
	geoidSimple[47][168] = (byte)-9;
	geoidSimple[47][169] = (byte)-11;
	geoidSimple[47][170] = (byte)-7;
	geoidSimple[47][171] = (byte)-11;
	geoidSimple[47][172] = (byte)-10;
	geoidSimple[47][173] = (byte)-9;
	geoidSimple[47][174] = (byte)-10;
	geoidSimple[47][175] = (byte)-11;
	geoidSimple[47][176] = (byte)-10;
	geoidSimple[47][177] = (byte)-10;
	geoidSimple[47][178] = (byte)-10;
	geoidSimple[47][179] = (byte)-10;
	geoidSimple[47][LAT_GRID_SIZE] = (byte)-10;
	geoidSimple[47][181] = (byte)-10;
	geoidSimple[47][182] = (byte)-10;
	geoidSimple[47][183] = (byte)-9;
	geoidSimple[47][184] = (byte)-9;
	geoidSimple[47][185] = (byte)-9;
	geoidSimple[47][186] = (byte)-8;
	geoidSimple[47][187] = (byte)-8;
	geoidSimple[47][188] = (byte)-7;
	geoidSimple[47][189] = (byte)-7;
	geoidSimple[47][190] = (byte)-7;
	geoidSimple[47][191] = (byte)-7;
	geoidSimple[47][192] = (byte)-7;
	geoidSimple[47][193] = (byte)-7;
	geoidSimple[47][194] = (byte)-7;
	geoidSimple[47][195] = (byte)-7;
	geoidSimple[47][196] = (byte)-8;
	geoidSimple[47][197] = (byte)-8;
	geoidSimple[47][198] = (byte)-8;
	geoidSimple[47][199] = (byte)-9;
	geoidSimple[47][200] = (byte)-9;
	geoidSimple[47][201] = (byte)-10;
	geoidSimple[47][202] = (byte)-10;
	geoidSimple[47][203] = (byte)-11;
	geoidSimple[47][204] = (byte)-11;
	geoidSimple[47][205] = (byte)-12;
	geoidSimple[47][206] = (byte)-13;
	geoidSimple[47][207] = (byte)-14;
	geoidSimple[47][208] = (byte)-15;
	geoidSimple[47][209] = (byte)-16;
	geoidSimple[47][210] = (byte)-17;
	geoidSimple[47][211] = (byte)-18;
	geoidSimple[47][212] = (byte)-19;
	geoidSimple[47][213] = (byte)-20;
	geoidSimple[47][214] = (byte)-21;
	geoidSimple[47][215] = (byte)-22;
	geoidSimple[47][216] = (byte)-23;
	geoidSimple[47][217] = (byte)-24;
	geoidSimple[47][218] = (byte)-25;
	geoidSimple[47][219] = (byte)-26;
	geoidSimple[47][220] = (byte)-27;
	geoidSimple[47][221] = (byte)-28;
	geoidSimple[47][222] = (byte)-28;
	geoidSimple[47][223] = (byte)-29;
	geoidSimple[47][224] = (byte)-30;
	geoidSimple[47][225] = (byte)-30;
	geoidSimple[47][226] = (byte)-30;
	geoidSimple[47][227] = (byte)-30;
	geoidSimple[47][228] = (byte)-30;
	geoidSimple[47][229] = (byte)-30;
	geoidSimple[47][230] = (byte)-30;
	geoidSimple[47][231] = (byte)-29;
	geoidSimple[47][232] = (byte)-29;
	geoidSimple[47][233] = (byte)-29;
	geoidSimple[47][234] = (byte)-29;
	geoidSimple[47][235] = (byte)-27;
	geoidSimple[47][236] = (byte)-24;
	geoidSimple[47][237] = (byte)-22;
	geoidSimple[47][238] = (byte)-21;
	geoidSimple[47][239] = (byte)-19;
	geoidSimple[47][240] = (byte)-19;
	geoidSimple[47][241] = (byte)-18;
	geoidSimple[47][242] = (byte)-17;
	geoidSimple[47][243] = (byte)-16;
	geoidSimple[47][244] = (byte)-15;
	geoidSimple[47][245] = (byte)-14;
	geoidSimple[47][246] = (byte)-13;
	geoidSimple[47][247] = (byte)-13;
	geoidSimple[47][248] = (byte)-12;
	geoidSimple[47][249] = (byte)-11;
	geoidSimple[47][250] = (byte)-11;
	geoidSimple[47][251] = (byte)-12;
	geoidSimple[47][252] = (byte)-12;
	geoidSimple[47][253] = (byte)-12;
	geoidSimple[47][254] = (byte)-13;
	geoidSimple[47][255] = (byte)-14;
	geoidSimple[47][256] = (byte)-16;
	geoidSimple[47][257] = (byte)-18;
	geoidSimple[47][258] = (byte)-19;
	geoidSimple[47][259] = (byte)-21;
	geoidSimple[47][260] = (byte)-23;
	geoidSimple[47][261] = (byte)-25;
	geoidSimple[47][262] = (byte)-25;
	geoidSimple[47][263] = (byte)-26;
	geoidSimple[47][264] = (byte)-28;
	geoidSimple[47][265] = (byte)-29;
	geoidSimple[47][266] = (byte)-28;
	geoidSimple[47][267] = (byte)-31;
	geoidSimple[47][268] = (byte)-31;
	geoidSimple[47][269] = (byte)-33;
	geoidSimple[47][270] = (byte)-34;
	geoidSimple[47][271] = (byte)-34;
	geoidSimple[47][272] = (byte)-34;
	geoidSimple[47][273] = (byte)-34;
	geoidSimple[47][274] = (byte)-33;
	geoidSimple[47][275] = (byte)-34;
	geoidSimple[47][276] = (byte)-34;
	geoidSimple[47][277] = (byte)-35;
	geoidSimple[47][278] = (byte)-35;
	geoidSimple[47][279] = (byte)-36;
	geoidSimple[47][280] = (byte)-35;
	geoidSimple[47][281] = (byte)-34;
	geoidSimple[47][282] = (byte)-34;
	geoidSimple[47][283] = (byte)-34;
	geoidSimple[47][284] = (byte)-32;
	geoidSimple[47][285] = (byte)-31;
	geoidSimple[47][286] = (byte)-31;
	geoidSimple[47][287] = (byte)-28;
	geoidSimple[47][288] = (byte)-28;
	geoidSimple[47][289] = (byte)-27;
	geoidSimple[47][290] = (byte)-27;
	geoidSimple[47][291] = (byte)-26;
	geoidSimple[47][292] = (byte)-25;
	geoidSimple[47][293] = (byte)-25;
	geoidSimple[47][294] = (byte)-24;
	geoidSimple[47][295] = (byte)-23;
	geoidSimple[47][296] = (byte)-23;
	geoidSimple[47][297] = (byte)-23;
	geoidSimple[47][298] = (byte)-23;
	geoidSimple[47][299] = (byte)-23;
	geoidSimple[47][300] = (byte)-21;
	geoidSimple[47][301] = (byte)-20;
	geoidSimple[47][302] = (byte)-17;
	geoidSimple[47][303] = (byte)-13;
	geoidSimple[47][304] = (byte)-10;
	geoidSimple[47][305] = (byte)-8;
	geoidSimple[47][306] = (byte)-6;
	geoidSimple[47][307] = (byte)-1;
	geoidSimple[47][308] = (byte)4;
	geoidSimple[47][309] = (byte)8;
	geoidSimple[47][310] = (byte)11;
	geoidSimple[47][311] = (byte)14;
	geoidSimple[47][312] = (byte)16;
	geoidSimple[47][313] = (byte)18;
	geoidSimple[47][314] = (byte)20;
	geoidSimple[47][315] = (byte)23;
	geoidSimple[47][316] = (byte)26;
	geoidSimple[47][317] = (byte)28;
	geoidSimple[47][318] = (byte)31;
	geoidSimple[47][319] = (byte)34;
	geoidSimple[47][320] = (byte)37;
	geoidSimple[47][321] = (byte)40;
	geoidSimple[47][322] = (byte)43;
	geoidSimple[47][323] = (byte)45;
	geoidSimple[47][324] = (byte)47;
	geoidSimple[47][325] = (byte)49;
	geoidSimple[47][326] = (byte)52;
	geoidSimple[47][327] = (byte)54;
	geoidSimple[47][328] = (byte)57;
	geoidSimple[47][329] = (byte)59;
	geoidSimple[47][330] = (byte)61;
	geoidSimple[47][331] = (byte)62;
	geoidSimple[47][332] = (byte)61;
	geoidSimple[47][333] = (byte)61;
	geoidSimple[47][334] = (byte)61;
	geoidSimple[47][335] = (byte)61;
	geoidSimple[47][336] = (byte)60;
	geoidSimple[47][337] = (byte)60;
	geoidSimple[47][338] = (byte)59;
	geoidSimple[47][339] = (byte)58;
	geoidSimple[47][340] = (byte)57;
	geoidSimple[47][341] = (byte)56;
	geoidSimple[47][342] = (byte)55;
	geoidSimple[47][343] = (byte)55;
	geoidSimple[47][344] = (byte)54;
	geoidSimple[47][345] = (byte)51;
	geoidSimple[47][346] = (byte)50;
	geoidSimple[47][347] = (byte)52;
	geoidSimple[47][348] = (byte)53;
	geoidSimple[47][349] = (byte)52;
	geoidSimple[47][350] = (byte)54;
	geoidSimple[47][351] = (byte)55;
	geoidSimple[47][352] = (byte)56;
	geoidSimple[47][353] = (byte)57;
	geoidSimple[47][354] = (byte)55;
	geoidSimple[47][355] = (byte)54;
	geoidSimple[47][356] = (byte)53;
	geoidSimple[47][357] = (byte)51;
	geoidSimple[47][358] = (byte)50;
	geoidSimple[47][359] = (byte)51;
	}
		/** Row 48*/
	private static void init48() {
	geoidSimple[48][0] = (byte)49;
	geoidSimple[48][1] = (byte)49;
	geoidSimple[48][2] = (byte)49;
	geoidSimple[48][3] = (byte)48;
	geoidSimple[48][4] = (byte)46;
	geoidSimple[48][5] = (byte)45;
	geoidSimple[48][6] = (byte)45;
	geoidSimple[48][7] = (byte)45;
	geoidSimple[48][8] = (byte)47;
	geoidSimple[48][9] = (byte)48;
	geoidSimple[48][10] = (byte)46;
	geoidSimple[48][11] = (byte)47;
	geoidSimple[48][12] = (byte)48;
	geoidSimple[48][13] = (byte)48;
	geoidSimple[48][14] = (byte)48;
	geoidSimple[48][15] = (byte)47;
	geoidSimple[48][16] = (byte)47;
	geoidSimple[48][17] = (byte)42;
	geoidSimple[48][18] = (byte)37;
	geoidSimple[48][19] = (byte)36;
	geoidSimple[48][20] = (byte)41;
	geoidSimple[48][21] = (byte)44;
	geoidSimple[48][22] = (byte)44;
	geoidSimple[48][23] = (byte)43;
	geoidSimple[48][24] = (byte)42;
	geoidSimple[48][25] = (byte)41;
	geoidSimple[48][26] = (byte)40;
	geoidSimple[48][27] = (byte)39;
	geoidSimple[48][28] = (byte)37;
	geoidSimple[48][29] = (byte)34;
	geoidSimple[48][30] = (byte)31;
	geoidSimple[48][31] = (byte)30;
	geoidSimple[48][32] = (byte)30;
	geoidSimple[48][33] = (byte)31;
	geoidSimple[48][34] = (byte)30;
	geoidSimple[48][35] = (byte)27;
	geoidSimple[48][36] = (byte)25;
	geoidSimple[48][37] = (byte)22;
	geoidSimple[48][38] = (byte)20;
	geoidSimple[48][39] = (byte)20;
	geoidSimple[48][40] = (byte)19;
	geoidSimple[48][41] = (byte)20;
	geoidSimple[48][42] = (byte)23;
	geoidSimple[48][43] = (byte)22;
	geoidSimple[48][44] = (byte)18;
	geoidSimple[48][45] = (byte)12;
	geoidSimple[48][46] = (byte)9;
	geoidSimple[48][47] = (byte)7;
	geoidSimple[48][48] = (byte)-2;
	geoidSimple[48][49] = (byte)-9;
	geoidSimple[48][50] = (byte)-13;
	geoidSimple[48][51] = (byte)-12;
	geoidSimple[48][52] = (byte)-10;
	geoidSimple[48][53] = (byte)-12;
	geoidSimple[48][54] = (byte)-13;
	geoidSimple[48][55] = (byte)-16;
	geoidSimple[48][56] = (byte)-20;
	geoidSimple[48][57] = (byte)-23;
	geoidSimple[48][58] = (byte)-25;
	geoidSimple[48][59] = (byte)-27;
	geoidSimple[48][60] = (byte)-28;
	geoidSimple[48][61] = (byte)-30;
	geoidSimple[48][62] = (byte)-32;
	geoidSimple[48][63] = (byte)-33;
	geoidSimple[48][64] = (byte)-34;
	geoidSimple[48][65] = (byte)-36;
	geoidSimple[48][66] = (byte)-39;
	geoidSimple[48][67] = (byte)-41;
	geoidSimple[48][68] = (byte)-42;
	geoidSimple[48][69] = (byte)-42;
	geoidSimple[48][70] = (byte)-38;
	geoidSimple[48][71] = (byte)-39;
	geoidSimple[48][72] = (byte)-41;
	geoidSimple[48][73] = (byte)-38;
	geoidSimple[48][74] = (byte)-36;
	geoidSimple[48][75] = (byte)-35;
	geoidSimple[48][76] = (byte)-35;
	geoidSimple[48][77] = (byte)-34;
	geoidSimple[48][78] = (byte)-36;
	geoidSimple[48][79] = (byte)-42;
	geoidSimple[48][80] = (byte)-46;
	geoidSimple[48][81] = (byte)-53;
	geoidSimple[48][82] = (byte)-58;
	geoidSimple[48][83] = (byte)-59;
	geoidSimple[48][84] = (byte)-61;
	geoidSimple[48][85] = (byte)-61;
	geoidSimple[48][86] = (byte)-62;
	geoidSimple[48][87] = (byte)-61;
	geoidSimple[48][88] = (byte)-61;
	geoidSimple[48][89] = (byte)-62;
	geoidSimple[48][90] = (byte)-61;
	geoidSimple[48][91] = (byte)-62;
	geoidSimple[48][92] = (byte)-62;
	geoidSimple[48][93] = (byte)-62;
	geoidSimple[48][94] = (byte)-61;
	geoidSimple[48][95] = (byte)-58;
	geoidSimple[48][96] = (byte)-56;
	geoidSimple[48][97] = (byte)-55;
	geoidSimple[48][98] = (byte)-56;
	geoidSimple[48][99] = (byte)-55;
	geoidSimple[48][100] = (byte)-55;
	geoidSimple[48][101] = (byte)-53;
	geoidSimple[48][102] = (byte)-52;
	geoidSimple[48][103] = (byte)-49;
	geoidSimple[48][104] = (byte)-47;
	geoidSimple[48][105] = (byte)-45;
	geoidSimple[48][106] = (byte)-41;
	geoidSimple[48][107] = (byte)-38;
	geoidSimple[48][108] = (byte)-35;
	geoidSimple[48][109] = (byte)-30;
	geoidSimple[48][110] = (byte)-26;
	geoidSimple[48][111] = (byte)-23;
	geoidSimple[48][112] = (byte)-19;
	geoidSimple[48][113] = (byte)-16;
	geoidSimple[48][114] = (byte)-13;
	geoidSimple[48][115] = (byte)-9;
	geoidSimple[48][116] = (byte)-6;
	geoidSimple[48][117] = (byte)-4;
	geoidSimple[48][118] = (byte)-1;
	geoidSimple[48][119] = (byte)1;
	geoidSimple[48][120] = (byte)3;
	geoidSimple[48][121] = (byte)5;
	geoidSimple[48][122] = (byte)6;
	geoidSimple[48][123] = (byte)10;
	geoidSimple[48][124] = (byte)15;
	geoidSimple[48][125] = (byte)19;
	geoidSimple[48][126] = (byte)21;
	geoidSimple[48][127] = (byte)23;
	geoidSimple[48][128] = (byte)26;
	geoidSimple[48][129] = (byte)26;
	geoidSimple[48][130] = (byte)23;
	geoidSimple[48][131] = (byte)22;
	geoidSimple[48][132] = (byte)23;
	geoidSimple[48][133] = (byte)24;
	geoidSimple[48][134] = (byte)25;
	geoidSimple[48][135] = (byte)26;
	geoidSimple[48][136] = (byte)28;
	geoidSimple[48][137] = (byte)28;
	geoidSimple[48][138] = (byte)30;
	geoidSimple[48][139] = (byte)32;
	geoidSimple[48][140] = (byte)34;
	geoidSimple[48][141] = (byte)31;
	geoidSimple[48][142] = (byte)20;
	geoidSimple[48][143] = (byte)16;
	geoidSimple[48][144] = (byte)11;
	geoidSimple[48][145] = (byte)9;
	geoidSimple[48][146] = (byte)12;
	geoidSimple[48][147] = (byte)14;
	geoidSimple[48][148] = (byte)16;
	geoidSimple[48][149] = (byte)17;
	geoidSimple[48][150] = (byte)16;
	geoidSimple[48][151] = (byte)15;
	geoidSimple[48][152] = (byte)13;
	geoidSimple[48][153] = (byte)11;
	geoidSimple[48][154] = (byte)9;
	geoidSimple[48][155] = (byte)7;
	geoidSimple[48][156] = (byte)5;
	geoidSimple[48][157] = (byte)3;
	geoidSimple[48][158] = (byte)2;
	geoidSimple[48][159] = (byte)0;
	geoidSimple[48][160] = (byte)-1;
	geoidSimple[48][161] = (byte)-2;
	geoidSimple[48][162] = (byte)-3;
	geoidSimple[48][163] = (byte)-4;
	geoidSimple[48][164] = (byte)-5;
	geoidSimple[48][165] = (byte)-6;
	geoidSimple[48][166] = (byte)-7;
	geoidSimple[48][167] = (byte)-8;
	geoidSimple[48][168] = (byte)-10;
	geoidSimple[48][169] = (byte)-11;
	geoidSimple[48][170] = (byte)-7;
	geoidSimple[48][171] = (byte)-12;
	geoidSimple[48][172] = (byte)-12;
	geoidSimple[48][173] = (byte)-10;
	geoidSimple[48][174] = (byte)-11;
	geoidSimple[48][175] = (byte)-11;
	geoidSimple[48][176] = (byte)-12;
	geoidSimple[48][177] = (byte)-11;
	geoidSimple[48][178] = (byte)-11;
	geoidSimple[48][179] = (byte)-11;
	geoidSimple[48][LAT_GRID_SIZE] = (byte)-11;
	geoidSimple[48][181] = (byte)-11;
	geoidSimple[48][182] = (byte)-11;
	geoidSimple[48][183] = (byte)-11;
	geoidSimple[48][184] = (byte)-10;
	geoidSimple[48][185] = (byte)-10;
	geoidSimple[48][186] = (byte)-10;
	geoidSimple[48][187] = (byte)-9;
	geoidSimple[48][188] = (byte)-9;
	geoidSimple[48][189] = (byte)-9;
	geoidSimple[48][190] = (byte)-9;
	geoidSimple[48][191] = (byte)-9;
	geoidSimple[48][192] = (byte)-9;
	geoidSimple[48][193] = (byte)-8;
	geoidSimple[48][194] = (byte)-8;
	geoidSimple[48][195] = (byte)-9;
	geoidSimple[48][196] = (byte)-9;
	geoidSimple[48][197] = (byte)-10;
	geoidSimple[48][198] = (byte)-10;
	geoidSimple[48][199] = (byte)-10;
	geoidSimple[48][200] = (byte)-10;
	geoidSimple[48][201] = (byte)-11;
	geoidSimple[48][202] = (byte)-11;
	geoidSimple[48][203] = (byte)-12;
	geoidSimple[48][204] = (byte)-13;
	geoidSimple[48][205] = (byte)-13;
	geoidSimple[48][206] = (byte)-14;
	geoidSimple[48][207] = (byte)-15;
	geoidSimple[48][208] = (byte)-16;
	geoidSimple[48][209] = (byte)-17;
	geoidSimple[48][210] = (byte)-18;
	geoidSimple[48][211] = (byte)-19;
	geoidSimple[48][212] = (byte)-21;
	geoidSimple[48][213] = (byte)-22;
	geoidSimple[48][214] = (byte)-22;
	geoidSimple[48][215] = (byte)-24;
	geoidSimple[48][216] = (byte)-25;
	geoidSimple[48][217] = (byte)-25;
	geoidSimple[48][218] = (byte)-26;
	geoidSimple[48][219] = (byte)-27;
	geoidSimple[48][220] = (byte)-28;
	geoidSimple[48][221] = (byte)-29;
	geoidSimple[48][222] = (byte)-30;
	geoidSimple[48][223] = (byte)-30;
	geoidSimple[48][224] = (byte)-31;
	geoidSimple[48][225] = (byte)-31;
	geoidSimple[48][226] = (byte)-32;
	geoidSimple[48][227] = (byte)-32;
	geoidSimple[48][228] = (byte)-31;
	geoidSimple[48][229] = (byte)-31;
	geoidSimple[48][230] = (byte)-31;
	geoidSimple[48][231] = (byte)-31;
	geoidSimple[48][232] = (byte)-30;
	geoidSimple[48][233] = (byte)-30;
	geoidSimple[48][234] = (byte)-30;
	geoidSimple[48][235] = (byte)-30;
	geoidSimple[48][236] = (byte)-26;
	geoidSimple[48][237] = (byte)-23;
	geoidSimple[48][238] = (byte)-22;
	geoidSimple[48][239] = (byte)-21;
	geoidSimple[48][240] = (byte)-20;
	geoidSimple[48][241] = (byte)-19;
	geoidSimple[48][242] = (byte)-18;
	geoidSimple[48][243] = (byte)-17;
	geoidSimple[48][244] = (byte)-16;
	geoidSimple[48][245] = (byte)-15;
	geoidSimple[48][246] = (byte)-15;
	geoidSimple[48][247] = (byte)-15;
	geoidSimple[48][248] = (byte)-15;
	geoidSimple[48][249] = (byte)-14;
	geoidSimple[48][250] = (byte)-14;
	geoidSimple[48][251] = (byte)-14;
	geoidSimple[48][252] = (byte)-13;
	geoidSimple[48][253] = (byte)-12;
	geoidSimple[48][254] = (byte)-11;
	geoidSimple[48][255] = (byte)-15;
	geoidSimple[48][256] = (byte)-18;
	geoidSimple[48][257] = (byte)-19;
	geoidSimple[48][258] = (byte)-20;
	geoidSimple[48][259] = (byte)-21;
	geoidSimple[48][260] = (byte)-23;
	geoidSimple[48][261] = (byte)-24;
	geoidSimple[48][262] = (byte)-25;
	geoidSimple[48][263] = (byte)-26;
	geoidSimple[48][264] = (byte)-28;
	geoidSimple[48][265] = (byte)-28;
	geoidSimple[48][266] = (byte)-31;
	geoidSimple[48][267] = (byte)-32;
	geoidSimple[48][268] = (byte)-32;
	geoidSimple[48][269] = (byte)-33;
	geoidSimple[48][270] = (byte)-33;
	geoidSimple[48][271] = (byte)-33;
	geoidSimple[48][272] = (byte)-33;
	geoidSimple[48][273] = (byte)-34;
	geoidSimple[48][274] = (byte)-33;
	geoidSimple[48][275] = (byte)-34;
	geoidSimple[48][276] = (byte)-35;
	geoidSimple[48][277] = (byte)-35;
	geoidSimple[48][278] = (byte)-35;
	geoidSimple[48][279] = (byte)-34;
	geoidSimple[48][280] = (byte)-34;
	geoidSimple[48][281] = (byte)-32;
	geoidSimple[48][282] = (byte)-32;
	geoidSimple[48][283] = (byte)-33;
	geoidSimple[48][284] = (byte)-32;
	geoidSimple[48][285] = (byte)-31;
	geoidSimple[48][286] = (byte)-31;
	geoidSimple[48][287] = (byte)-30;
	geoidSimple[48][288] = (byte)-30;
	geoidSimple[48][289] = (byte)-29;
	geoidSimple[48][290] = (byte)-29;
	geoidSimple[48][291] = (byte)-28;
	geoidSimple[48][292] = (byte)-27;
	geoidSimple[48][293] = (byte)-26;
	geoidSimple[48][294] = (byte)-27;
	geoidSimple[48][295] = (byte)-28;
	geoidSimple[48][296] = (byte)-27;
	geoidSimple[48][297] = (byte)-27;
	geoidSimple[48][298] = (byte)-26;
	geoidSimple[48][299] = (byte)-25;
	geoidSimple[48][300] = (byte)-24;
	geoidSimple[48][301] = (byte)-22;
	geoidSimple[48][302] = (byte)-19;
	geoidSimple[48][303] = (byte)-16;
	geoidSimple[48][304] = (byte)-13;
	geoidSimple[48][305] = (byte)-10;
	geoidSimple[48][306] = (byte)-7;
	geoidSimple[48][307] = (byte)-5;
	geoidSimple[48][308] = (byte)0;
	geoidSimple[48][309] = (byte)2;
	geoidSimple[48][310] = (byte)5;
	geoidSimple[48][311] = (byte)9;
	geoidSimple[48][312] = (byte)11;
	geoidSimple[48][313] = (byte)15;
	geoidSimple[48][314] = (byte)18;
	geoidSimple[48][315] = (byte)20;
	geoidSimple[48][316] = (byte)23;
	geoidSimple[48][317] = (byte)26;
	geoidSimple[48][318] = (byte)29;
	geoidSimple[48][319] = (byte)32;
	geoidSimple[48][320] = (byte)35;
	geoidSimple[48][321] = (byte)39;
	geoidSimple[48][322] = (byte)41;
	geoidSimple[48][323] = (byte)44;
	geoidSimple[48][324] = (byte)46;
	geoidSimple[48][325] = (byte)48;
	geoidSimple[48][326] = (byte)51;
	geoidSimple[48][327] = (byte)54;
	geoidSimple[48][328] = (byte)56;
	geoidSimple[48][329] = (byte)58;
	geoidSimple[48][330] = (byte)60;
	geoidSimple[48][331] = (byte)61;
	geoidSimple[48][332] = (byte)61;
	geoidSimple[48][333] = (byte)60;
	geoidSimple[48][334] = (byte)60;
	geoidSimple[48][335] = (byte)59;
	geoidSimple[48][336] = (byte)59;
	geoidSimple[48][337] = (byte)58;
	geoidSimple[48][338] = (byte)57;
	geoidSimple[48][339] = (byte)56;
	geoidSimple[48][340] = (byte)55;
	geoidSimple[48][341] = (byte)53;
	geoidSimple[48][342] = (byte)52;
	geoidSimple[48][343] = (byte)52;
	geoidSimple[48][344] = (byte)51;
	geoidSimple[48][345] = (byte)50;
	geoidSimple[48][346] = (byte)49;
	geoidSimple[48][347] = (byte)49;
	geoidSimple[48][348] = (byte)50;
	geoidSimple[48][349] = (byte)50;
	geoidSimple[48][350] = (byte)52;
	geoidSimple[48][351] = (byte)55;
	geoidSimple[48][352] = (byte)56;
	geoidSimple[48][353] = (byte)56;
	geoidSimple[48][354] = (byte)55;
	geoidSimple[48][355] = (byte)53;
	geoidSimple[48][356] = (byte)53;
	geoidSimple[48][357] = (byte)53;
	geoidSimple[48][358] = (byte)51;
	geoidSimple[48][359] = (byte)50;
	}
		/** Row 49*/
	private static void init49() {
	geoidSimple[49][0] = (byte)50;
	geoidSimple[49][1] = (byte)49;
	geoidSimple[49][2] = (byte)47;
	geoidSimple[49][3] = (byte)47;
	geoidSimple[49][4] = (byte)46;
	geoidSimple[49][5] = (byte)45;
	geoidSimple[49][6] = (byte)44;
	geoidSimple[49][7] = (byte)44;
	geoidSimple[49][8] = (byte)47;
	geoidSimple[49][9] = (byte)48;
	geoidSimple[49][10] = (byte)45;
	geoidSimple[49][11] = (byte)45;
	geoidSimple[49][12] = (byte)45;
	geoidSimple[49][13] = (byte)46;
	geoidSimple[49][14] = (byte)47;
	geoidSimple[49][15] = (byte)47;
	geoidSimple[49][16] = (byte)45;
	geoidSimple[49][17] = (byte)42;
	geoidSimple[49][18] = (byte)38;
	geoidSimple[49][19] = (byte)34;
	geoidSimple[49][20] = (byte)37;
	geoidSimple[49][21] = (byte)41;
	geoidSimple[49][22] = (byte)42;
	geoidSimple[49][23] = (byte)42;
	geoidSimple[49][24] = (byte)41;
	geoidSimple[49][25] = (byte)40;
	geoidSimple[49][26] = (byte)39;
	geoidSimple[49][27] = (byte)39;
	geoidSimple[49][28] = (byte)37;
	geoidSimple[49][29] = (byte)37;
	geoidSimple[49][30] = (byte)36;
	geoidSimple[49][31] = (byte)37;
	geoidSimple[49][32] = (byte)37;
	geoidSimple[49][33] = (byte)35;
	geoidSimple[49][34] = (byte)33;
	geoidSimple[49][35] = (byte)31;
	geoidSimple[49][36] = (byte)28;
	geoidSimple[49][37] = (byte)27;
	geoidSimple[49][38] = (byte)26;
	geoidSimple[49][39] = (byte)27;
	geoidSimple[49][40] = (byte)26;
	geoidSimple[49][41] = (byte)26;
	geoidSimple[49][42] = (byte)26;
	geoidSimple[49][43] = (byte)25;
	geoidSimple[49][44] = (byte)22;
	geoidSimple[49][45] = (byte)18;
	geoidSimple[49][46] = (byte)11;
	geoidSimple[49][47] = (byte)4;
	geoidSimple[49][48] = (byte)0;
	geoidSimple[49][49] = (byte)-11;
	geoidSimple[49][50] = (byte)-17;
	geoidSimple[49][51] = (byte)-16;
	geoidSimple[49][52] = (byte)-12;
	geoidSimple[49][53] = (byte)-13;
	geoidSimple[49][54] = (byte)-13;
	geoidSimple[49][55] = (byte)-14;
	geoidSimple[49][56] = (byte)-18;
	geoidSimple[49][57] = (byte)-22;
	geoidSimple[49][58] = (byte)-25;
	geoidSimple[49][59] = (byte)-27;
	geoidSimple[49][60] = (byte)-29;
	geoidSimple[49][61] = (byte)-31;
	geoidSimple[49][62] = (byte)-32;
	geoidSimple[49][63] = (byte)-33;
	geoidSimple[49][64] = (byte)-35;
	geoidSimple[49][65] = (byte)-36;
	geoidSimple[49][66] = (byte)-37;
	geoidSimple[49][67] = (byte)-39;
	geoidSimple[49][68] = (byte)-42;
	geoidSimple[49][69] = (byte)-43;
	geoidSimple[49][70] = (byte)-44;
	geoidSimple[49][71] = (byte)-48;
	geoidSimple[49][72] = (byte)-46;
	geoidSimple[49][73] = (byte)-40;
	geoidSimple[49][74] = (byte)-34;
	geoidSimple[49][75] = (byte)-33;
	geoidSimple[49][76] = (byte)-35;
	geoidSimple[49][77] = (byte)-37;
	geoidSimple[49][78] = (byte)-41;
	geoidSimple[49][79] = (byte)-50;
	geoidSimple[49][80] = (byte)-57;
	geoidSimple[49][81] = (byte)-60;
	geoidSimple[49][82] = (byte)-62;
	geoidSimple[49][83] = (byte)-63;
	geoidSimple[49][84] = (byte)-65;
	geoidSimple[49][85] = (byte)-66;
	geoidSimple[49][86] = (byte)-65;
	geoidSimple[49][87] = (byte)-64;
	geoidSimple[49][88] = (byte)-64;
	geoidSimple[49][89] = (byte)-64;
	geoidSimple[49][90] = (byte)-64;
	geoidSimple[49][91] = (byte)-64;
	geoidSimple[49][92] = (byte)-63;
	geoidSimple[49][93] = (byte)-62;
	geoidSimple[49][94] = (byte)-61;
	geoidSimple[49][95] = (byte)-59;
	geoidSimple[49][96] = (byte)-57;
	geoidSimple[49][97] = (byte)-56;
	geoidSimple[49][98] = (byte)-57;
	geoidSimple[49][99] = (byte)-55;
	geoidSimple[49][100] = (byte)-55;
	geoidSimple[49][101] = (byte)-54;
	geoidSimple[49][102] = (byte)-51;
	geoidSimple[49][103] = (byte)-48;
	geoidSimple[49][104] = (byte)-46;
	geoidSimple[49][105] = (byte)-43;
	geoidSimple[49][106] = (byte)-41;
	geoidSimple[49][107] = (byte)-39;
	geoidSimple[49][108] = (byte)-35;
	geoidSimple[49][109] = (byte)-31;
	geoidSimple[49][110] = (byte)-27;
	geoidSimple[49][111] = (byte)-23;
	geoidSimple[49][112] = (byte)-18;
	geoidSimple[49][113] = (byte)-15;
	geoidSimple[49][114] = (byte)-12;
	geoidSimple[49][115] = (byte)-9;
	geoidSimple[49][116] = (byte)-8;
	geoidSimple[49][117] = (byte)-5;
	geoidSimple[49][118] = (byte)-2;
	geoidSimple[49][119] = (byte)1;
	geoidSimple[49][120] = (byte)3;
	geoidSimple[49][121] = (byte)5;
	geoidSimple[49][122] = (byte)8;
	geoidSimple[49][123] = (byte)12;
	geoidSimple[49][124] = (byte)15;
	geoidSimple[49][125] = (byte)18;
	geoidSimple[49][126] = (byte)22;
	geoidSimple[49][127] = (byte)25;
	geoidSimple[49][128] = (byte)25;
	geoidSimple[49][129] = (byte)24;
	geoidSimple[49][130] = (byte)23;
	geoidSimple[49][131] = (byte)23;
	geoidSimple[49][132] = (byte)24;
	geoidSimple[49][133] = (byte)25;
	geoidSimple[49][134] = (byte)27;
	geoidSimple[49][135] = (byte)28;
	geoidSimple[49][136] = (byte)29;
	geoidSimple[49][137] = (byte)30;
	geoidSimple[49][138] = (byte)31;
	geoidSimple[49][139] = (byte)33;
	geoidSimple[49][140] = (byte)37;
	geoidSimple[49][141] = (byte)36;
	geoidSimple[49][142] = (byte)27;
	geoidSimple[49][143] = (byte)17;
	geoidSimple[49][144] = (byte)11;
	geoidSimple[49][145] = (byte)15;
	geoidSimple[49][146] = (byte)18;
	geoidSimple[49][147] = (byte)19;
	geoidSimple[49][148] = (byte)18;
	geoidSimple[49][149] = (byte)17;
	geoidSimple[49][150] = (byte)16;
	geoidSimple[49][151] = (byte)14;
	geoidSimple[49][152] = (byte)12;
	geoidSimple[49][153] = (byte)10;
	geoidSimple[49][154] = (byte)8;
	geoidSimple[49][155] = (byte)6;
	geoidSimple[49][156] = (byte)4;
	geoidSimple[49][157] = (byte)2;
	geoidSimple[49][158] = (byte)1;
	geoidSimple[49][159] = (byte)0;
	geoidSimple[49][160] = (byte)-1;
	geoidSimple[49][161] = (byte)-3;
	geoidSimple[49][162] = (byte)-4;
	geoidSimple[49][163] = (byte)-5;
	geoidSimple[49][164] = (byte)-6;
	geoidSimple[49][165] = (byte)-7;
	geoidSimple[49][166] = (byte)-8;
	geoidSimple[49][167] = (byte)-9;
	geoidSimple[49][168] = (byte)-11;
	geoidSimple[49][169] = (byte)-11;
	geoidSimple[49][170] = (byte)-7;
	geoidSimple[49][171] = (byte)-13;
	geoidSimple[49][172] = (byte)-12;
	geoidSimple[49][173] = (byte)-11;
	geoidSimple[49][174] = (byte)-11;
	geoidSimple[49][175] = (byte)-12;
	geoidSimple[49][176] = (byte)-12;
	geoidSimple[49][177] = (byte)-12;
	geoidSimple[49][178] = (byte)-12;
	geoidSimple[49][179] = (byte)-11;
	geoidSimple[49][LAT_GRID_SIZE] = (byte)-12;
	geoidSimple[49][181] = (byte)-12;
	geoidSimple[49][182] = (byte)-12;
	geoidSimple[49][183] = (byte)-12;
	geoidSimple[49][184] = (byte)-11;
	geoidSimple[49][185] = (byte)-11;
	geoidSimple[49][186] = (byte)-11;
	geoidSimple[49][187] = (byte)-11;
	geoidSimple[49][188] = (byte)-10;
	geoidSimple[49][189] = (byte)-10;
	geoidSimple[49][190] = (byte)-10;
	geoidSimple[49][191] = (byte)-10;
	geoidSimple[49][192] = (byte)-10;
	geoidSimple[49][193] = (byte)-10;
	geoidSimple[49][194] = (byte)-10;
	geoidSimple[49][195] = (byte)-10;
	geoidSimple[49][196] = (byte)-11;
	geoidSimple[49][197] = (byte)-11;
	geoidSimple[49][198] = (byte)-11;
	geoidSimple[49][199] = (byte)-11;
	geoidSimple[49][200] = (byte)-12;
	geoidSimple[49][201] = (byte)-12;
	geoidSimple[49][202] = (byte)-13;
	geoidSimple[49][203] = (byte)-13;
	geoidSimple[49][204] = (byte)-14;
	geoidSimple[49][205] = (byte)-15;
	geoidSimple[49][206] = (byte)-16;
	geoidSimple[49][207] = (byte)-16;
	geoidSimple[49][208] = (byte)-17;
	geoidSimple[49][209] = (byte)-18;
	geoidSimple[49][210] = (byte)-19;
	geoidSimple[49][211] = (byte)-20;
	geoidSimple[49][212] = (byte)-21;
	geoidSimple[49][213] = (byte)-22;
	geoidSimple[49][214] = (byte)-24;
	geoidSimple[49][215] = (byte)-25;
	geoidSimple[49][216] = (byte)-26;
	geoidSimple[49][217] = (byte)-27;
	geoidSimple[49][218] = (byte)-28;
	geoidSimple[49][219] = (byte)-29;
	geoidSimple[49][220] = (byte)-30;
	geoidSimple[49][221] = (byte)-30;
	geoidSimple[49][222] = (byte)-31;
	geoidSimple[49][223] = (byte)-32;
	geoidSimple[49][224] = (byte)-32;
	geoidSimple[49][225] = (byte)-33;
	geoidSimple[49][226] = (byte)-33;
	geoidSimple[49][227] = (byte)-33;
	geoidSimple[49][228] = (byte)-34;
	geoidSimple[49][229] = (byte)-33;
	geoidSimple[49][230] = (byte)-33;
	geoidSimple[49][231] = (byte)-33;
	geoidSimple[49][232] = (byte)-33;
	geoidSimple[49][233] = (byte)-33;
	geoidSimple[49][234] = (byte)-33;
	geoidSimple[49][235] = (byte)-31;
	geoidSimple[49][236] = (byte)-28;
	geoidSimple[49][237] = (byte)-26;
	geoidSimple[49][238] = (byte)-24;
	geoidSimple[49][239] = (byte)-22;
	geoidSimple[49][240] = (byte)-22;
	geoidSimple[49][241] = (byte)-21;
	geoidSimple[49][242] = (byte)-20;
	geoidSimple[49][243] = (byte)-19;
	geoidSimple[49][244] = (byte)-18;
	geoidSimple[49][245] = (byte)-17;
	geoidSimple[49][246] = (byte)-18;
	geoidSimple[49][247] = (byte)-17;
	geoidSimple[49][248] = (byte)-16;
	geoidSimple[49][249] = (byte)-14;
	geoidSimple[49][250] = (byte)-15;
	geoidSimple[49][251] = (byte)-15;
	geoidSimple[49][252] = (byte)-14;
	geoidSimple[49][253] = (byte)-11;
	geoidSimple[49][254] = (byte)-12;
	geoidSimple[49][255] = (byte)-17;
	geoidSimple[49][256] = (byte)-19;
	geoidSimple[49][257] = (byte)-20;
	geoidSimple[49][258] = (byte)-22;
	geoidSimple[49][259] = (byte)-23;
	geoidSimple[49][260] = (byte)-24;
	geoidSimple[49][261] = (byte)-25;
	geoidSimple[49][262] = (byte)-27;
	geoidSimple[49][263] = (byte)-27;
	geoidSimple[49][264] = (byte)-30;
	geoidSimple[49][265] = (byte)-31;
	geoidSimple[49][266] = (byte)-32;
	geoidSimple[49][267] = (byte)-32;
	geoidSimple[49][268] = (byte)-33;
	geoidSimple[49][269] = (byte)-33;
	geoidSimple[49][270] = (byte)-33;
	geoidSimple[49][271] = (byte)-32;
	geoidSimple[49][272] = (byte)-33;
	geoidSimple[49][273] = (byte)-34;
	geoidSimple[49][274] = (byte)-34;
	geoidSimple[49][275] = (byte)-34;
	geoidSimple[49][276] = (byte)-35;
	geoidSimple[49][277] = (byte)-34;
	geoidSimple[49][278] = (byte)-34;
	geoidSimple[49][279] = (byte)-34;
	geoidSimple[49][280] = (byte)-34;
	geoidSimple[49][281] = (byte)-33;
	geoidSimple[49][282] = (byte)-34;
	geoidSimple[49][283] = (byte)-34;
	geoidSimple[49][284] = (byte)-34;
	geoidSimple[49][285] = (byte)-33;
	geoidSimple[49][286] = (byte)-32;
	geoidSimple[49][287] = (byte)-33;
	geoidSimple[49][288] = (byte)-33;
	geoidSimple[49][289] = (byte)-32;
	geoidSimple[49][290] = (byte)-32;
	geoidSimple[49][291] = (byte)-31;
	geoidSimple[49][292] = (byte)-30;
	geoidSimple[49][293] = (byte)-30;
	geoidSimple[49][294] = (byte)-31;
	geoidSimple[49][295] = (byte)-31;
	geoidSimple[49][296] = (byte)-30;
	geoidSimple[49][297] = (byte)-29;
	geoidSimple[49][298] = (byte)-28;
	geoidSimple[49][299] = (byte)-27;
	geoidSimple[49][300] = (byte)-25;
	geoidSimple[49][301] = (byte)-23;
	geoidSimple[49][302] = (byte)-21;
	geoidSimple[49][303] = (byte)-18;
	geoidSimple[49][304] = (byte)-15;
	geoidSimple[49][305] = (byte)-12;
	geoidSimple[49][306] = (byte)-9;
	geoidSimple[49][307] = (byte)-6;
	geoidSimple[49][308] = (byte)-3;
	geoidSimple[49][309] = (byte)0;
	geoidSimple[49][310] = (byte)3;
	geoidSimple[49][311] = (byte)7;
	geoidSimple[49][312] = (byte)9;
	geoidSimple[49][313] = (byte)12;
	geoidSimple[49][314] = (byte)15;
	geoidSimple[49][315] = (byte)18;
	geoidSimple[49][316] = (byte)21;
	geoidSimple[49][317] = (byte)24;
	geoidSimple[49][318] = (byte)27;
	geoidSimple[49][319] = (byte)31;
	geoidSimple[49][320] = (byte)34;
	geoidSimple[49][321] = (byte)37;
	geoidSimple[49][322] = (byte)40;
	geoidSimple[49][323] = (byte)42;
	geoidSimple[49][324] = (byte)45;
	geoidSimple[49][325] = (byte)47;
	geoidSimple[49][326] = (byte)50;
	geoidSimple[49][327] = (byte)53;
	geoidSimple[49][328] = (byte)56;
	geoidSimple[49][329] = (byte)58;
	geoidSimple[49][330] = (byte)59;
	geoidSimple[49][331] = (byte)60;
	geoidSimple[49][332] = (byte)60;
	geoidSimple[49][333] = (byte)59;
	geoidSimple[49][334] = (byte)59;
	geoidSimple[49][335] = (byte)58;
	geoidSimple[49][336] = (byte)57;
	geoidSimple[49][337] = (byte)56;
	geoidSimple[49][338] = (byte)55;
	geoidSimple[49][339] = (byte)54;
	geoidSimple[49][340] = (byte)52;
	geoidSimple[49][341] = (byte)51;
	geoidSimple[49][342] = (byte)51;
	geoidSimple[49][343] = (byte)50;
	geoidSimple[49][344] = (byte)50;
	geoidSimple[49][345] = (byte)48;
	geoidSimple[49][346] = (byte)47;
	geoidSimple[49][347] = (byte)46;
	geoidSimple[49][348] = (byte)46;
	geoidSimple[49][349] = (byte)47;
	geoidSimple[49][350] = (byte)51;
	geoidSimple[49][351] = (byte)55;
	geoidSimple[49][352] = (byte)56;
	geoidSimple[49][353] = (byte)55;
	geoidSimple[49][354] = (byte)55;
	geoidSimple[49][355] = (byte)54;
	geoidSimple[49][356] = (byte)52;
	geoidSimple[49][357] = (byte)52;
	geoidSimple[49][358] = (byte)52;
	geoidSimple[49][359] = (byte)51;
	}
		/** Row 50*/
	private static void init50() {
	geoidSimple[50][0] = (byte)49;
	geoidSimple[50][1] = (byte)48;
	geoidSimple[50][2] = (byte)48;
	geoidSimple[50][3] = (byte)48;
	geoidSimple[50][4] = (byte)46;
	geoidSimple[50][5] = (byte)45;
	geoidSimple[50][6] = (byte)44;
	geoidSimple[50][7] = (byte)44;
	geoidSimple[50][8] = (byte)46;
	geoidSimple[50][9] = (byte)47;
	geoidSimple[50][10] = (byte)44;
	geoidSimple[50][11] = (byte)43;
	geoidSimple[50][12] = (byte)43;
	geoidSimple[50][13] = (byte)43;
	geoidSimple[50][14] = (byte)44;
	geoidSimple[50][15] = (byte)45;
	geoidSimple[50][16] = (byte)42;
	geoidSimple[50][17] = (byte)35;
	geoidSimple[50][18] = (byte)34;
	geoidSimple[50][19] = (byte)31;
	geoidSimple[50][20] = (byte)31;
	geoidSimple[50][21] = (byte)34;
	geoidSimple[50][22] = (byte)38;
	geoidSimple[50][23] = (byte)39;
	geoidSimple[50][24] = (byte)40;
	geoidSimple[50][25] = (byte)40;
	geoidSimple[50][26] = (byte)40;
	geoidSimple[50][27] = (byte)40;
	geoidSimple[50][28] = (byte)38;
	geoidSimple[50][29] = (byte)39;
	geoidSimple[50][30] = (byte)38;
	geoidSimple[50][31] = (byte)37;
	geoidSimple[50][32] = (byte)36;
	geoidSimple[50][33] = (byte)36;
	geoidSimple[50][34] = (byte)35;
	geoidSimple[50][35] = (byte)34;
	geoidSimple[50][36] = (byte)33;
	geoidSimple[50][37] = (byte)30;
	geoidSimple[50][38] = (byte)29;
	geoidSimple[50][39] = (byte)30;
	geoidSimple[50][40] = (byte)29;
	geoidSimple[50][41] = (byte)28;
	geoidSimple[50][42] = (byte)27;
	geoidSimple[50][43] = (byte)24;
	geoidSimple[50][44] = (byte)21;
	geoidSimple[50][45] = (byte)20;
	geoidSimple[50][46] = (byte)16;
	geoidSimple[50][47] = (byte)9;
	geoidSimple[50][48] = (byte)2;
	geoidSimple[50][49] = (byte)-8;
	geoidSimple[50][50] = (byte)-17;
	geoidSimple[50][51] = (byte)-19;
	geoidSimple[50][52] = (byte)-17;
	geoidSimple[50][53] = (byte)-18;
	geoidSimple[50][54] = (byte)-17;
	geoidSimple[50][55] = (byte)-17;
	geoidSimple[50][56] = (byte)-19;
	geoidSimple[50][57] = (byte)-22;
	geoidSimple[50][58] = (byte)-24;
	geoidSimple[50][59] = (byte)-27;
	geoidSimple[50][60] = (byte)-29;
	geoidSimple[50][61] = (byte)-31;
	geoidSimple[50][62] = (byte)-33;
	geoidSimple[50][63] = (byte)-34;
	geoidSimple[50][64] = (byte)-35;
	geoidSimple[50][65] = (byte)-36;
	geoidSimple[50][66] = (byte)-37;
	geoidSimple[50][67] = (byte)-37;
	geoidSimple[50][68] = (byte)-37;
	geoidSimple[50][69] = (byte)-37;
	geoidSimple[50][70] = (byte)-37;
	geoidSimple[50][71] = (byte)-37;
	geoidSimple[50][72] = (byte)-35;
	geoidSimple[50][73] = (byte)-34;
	geoidSimple[50][74] = (byte)-34;
	geoidSimple[50][75] = (byte)-40;
	geoidSimple[50][76] = (byte)-46;
	geoidSimple[50][77] = (byte)-48;
	geoidSimple[50][78] = (byte)-48;
	geoidSimple[50][79] = (byte)-50;
	geoidSimple[50][80] = (byte)-55;
	geoidSimple[50][81] = (byte)-58;
	geoidSimple[50][82] = (byte)-60;
	geoidSimple[50][83] = (byte)-61;
	geoidSimple[50][84] = (byte)-63;
	geoidSimple[50][85] = (byte)-64;
	geoidSimple[50][86] = (byte)-65;
	geoidSimple[50][87] = (byte)-65;
	geoidSimple[50][88] = (byte)-65;
	geoidSimple[50][89] = (byte)-65;
	geoidSimple[50][90] = (byte)-63;
	geoidSimple[50][91] = (byte)-62;
	geoidSimple[50][92] = (byte)-60;
	geoidSimple[50][93] = (byte)-58;
	geoidSimple[50][94] = (byte)-56;
	geoidSimple[50][95] = (byte)-53;
	geoidSimple[50][96] = (byte)-51;
	geoidSimple[50][97] = (byte)-51;
	geoidSimple[50][98] = (byte)-53;
	geoidSimple[50][99] = (byte)-54;
	geoidSimple[50][100] = (byte)-54;
	geoidSimple[50][101] = (byte)-53;
	geoidSimple[50][102] = (byte)-51;
	geoidSimple[50][103] = (byte)-49;
	geoidSimple[50][104] = (byte)-46;
	geoidSimple[50][105] = (byte)-44;
	geoidSimple[50][106] = (byte)-41;
	geoidSimple[50][107] = (byte)-37;
	geoidSimple[50][108] = (byte)-34;
	geoidSimple[50][109] = (byte)-30;
	geoidSimple[50][110] = (byte)-27;
	geoidSimple[50][111] = (byte)-23;
	geoidSimple[50][112] = (byte)-18;
	geoidSimple[50][113] = (byte)-14;
	geoidSimple[50][114] = (byte)-12;
	geoidSimple[50][115] = (byte)-11;
	geoidSimple[50][116] = (byte)-10;
	geoidSimple[50][117] = (byte)-7;
	geoidSimple[50][118] = (byte)-3;
	geoidSimple[50][119] = (byte)0;
	geoidSimple[50][120] = (byte)3;
	geoidSimple[50][121] = (byte)6;
	geoidSimple[50][122] = (byte)10;
	geoidSimple[50][123] = (byte)12;
	geoidSimple[50][124] = (byte)15;
	geoidSimple[50][125] = (byte)18;
	geoidSimple[50][126] = (byte)21;
	geoidSimple[50][127] = (byte)23;
	geoidSimple[50][128] = (byte)23;
	geoidSimple[50][129] = (byte)23;
	geoidSimple[50][130] = (byte)23;
	geoidSimple[50][131] = (byte)24;
	geoidSimple[50][132] = (byte)25;
	geoidSimple[50][133] = (byte)28;
	geoidSimple[50][134] = (byte)29;
	geoidSimple[50][135] = (byte)31;
	geoidSimple[50][136] = (byte)31;
	geoidSimple[50][137] = (byte)32;
	geoidSimple[50][138] = (byte)34;
	geoidSimple[50][139] = (byte)36;
	geoidSimple[50][140] = (byte)39;
	geoidSimple[50][141] = (byte)40;
	geoidSimple[50][142] = (byte)32;
	geoidSimple[50][143] = (byte)20;
	geoidSimple[50][144] = (byte)15;
	geoidSimple[50][145] = (byte)19;
	geoidSimple[50][146] = (byte)21;
	geoidSimple[50][147] = (byte)20;
	geoidSimple[50][148] = (byte)19;
	geoidSimple[50][149] = (byte)17;
	geoidSimple[50][150] = (byte)15;
	geoidSimple[50][151] = (byte)13;
	geoidSimple[50][152] = (byte)11;
	geoidSimple[50][153] = (byte)8;
	geoidSimple[50][154] = (byte)7;
	geoidSimple[50][155] = (byte)5;
	geoidSimple[50][156] = (byte)3;
	geoidSimple[50][157] = (byte)1;
	geoidSimple[50][158] = (byte)0;
	geoidSimple[50][159] = (byte)-1;
	geoidSimple[50][160] = (byte)-2;
	geoidSimple[50][161] = (byte)-3;
	geoidSimple[50][162] = (byte)-4;
	geoidSimple[50][163] = (byte)-6;
	geoidSimple[50][164] = (byte)-7;
	geoidSimple[50][165] = (byte)-8;
	geoidSimple[50][166] = (byte)-9;
	geoidSimple[50][167] = (byte)-10;
	geoidSimple[50][168] = (byte)-11;
	geoidSimple[50][169] = (byte)-13;
	geoidSimple[50][170] = (byte)-13;
	geoidSimple[50][171] = (byte)-14;
	geoidSimple[50][172] = (byte)-13;
	geoidSimple[50][173] = (byte)-11;
	geoidSimple[50][174] = (byte)-11;
	geoidSimple[50][175] = (byte)-12;
	geoidSimple[50][176] = (byte)-12;
	geoidSimple[50][177] = (byte)-12;
	geoidSimple[50][178] = (byte)-12;
	geoidSimple[50][179] = (byte)-12;
	geoidSimple[50][LAT_GRID_SIZE] = (byte)-12;
	geoidSimple[50][181] = (byte)-12;
	geoidSimple[50][182] = (byte)-12;
	geoidSimple[50][183] = (byte)-12;
	geoidSimple[50][184] = (byte)-12;
	geoidSimple[50][185] = (byte)-12;
	geoidSimple[50][186] = (byte)-12;
	geoidSimple[50][187] = (byte)-11;
	geoidSimple[50][188] = (byte)-11;
	geoidSimple[50][189] = (byte)-11;
	geoidSimple[50][190] = (byte)-11;
	geoidSimple[50][191] = (byte)-10;
	geoidSimple[50][192] = (byte)-11;
	geoidSimple[50][193] = (byte)-11;
	geoidSimple[50][194] = (byte)-11;
	geoidSimple[50][195] = (byte)-11;
	geoidSimple[50][196] = (byte)-11;
	geoidSimple[50][197] = (byte)-12;
	geoidSimple[50][198] = (byte)-12;
	geoidSimple[50][199] = (byte)-13;
	geoidSimple[50][200] = (byte)-13;
	geoidSimple[50][201] = (byte)-13;
	geoidSimple[50][202] = (byte)-14;
	geoidSimple[50][203] = (byte)-14;
	geoidSimple[50][204] = (byte)-15;
	geoidSimple[50][205] = (byte)-16;
	geoidSimple[50][206] = (byte)-17;
	geoidSimple[50][207] = (byte)-18;
	geoidSimple[50][208] = (byte)-19;
	geoidSimple[50][209] = (byte)-20;
	geoidSimple[50][210] = (byte)-21;
	geoidSimple[50][211] = (byte)-22;
	geoidSimple[50][212] = (byte)-23;
	geoidSimple[50][213] = (byte)-24;
	geoidSimple[50][214] = (byte)-25;
	geoidSimple[50][215] = (byte)-27;
	geoidSimple[50][216] = (byte)-28;
	geoidSimple[50][217] = (byte)-29;
	geoidSimple[50][218] = (byte)-31;
	geoidSimple[50][219] = (byte)-31;
	geoidSimple[50][220] = (byte)-32;
	geoidSimple[50][221] = (byte)-33;
	geoidSimple[50][222] = (byte)-34;
	geoidSimple[50][223] = (byte)-34;
	geoidSimple[50][224] = (byte)-35;
	geoidSimple[50][225] = (byte)-35;
	geoidSimple[50][226] = (byte)-36;
	geoidSimple[50][227] = (byte)-36;
	geoidSimple[50][228] = (byte)-36;
	geoidSimple[50][229] = (byte)-36;
	geoidSimple[50][230] = (byte)-36;
	geoidSimple[50][231] = (byte)-36;
	geoidSimple[50][232] = (byte)-36;
	geoidSimple[50][233] = (byte)-35;
	geoidSimple[50][234] = (byte)-34;
	geoidSimple[50][235] = (byte)-33;
	geoidSimple[50][236] = (byte)-30;
	geoidSimple[50][237] = (byte)-28;
	geoidSimple[50][238] = (byte)-27;
	geoidSimple[50][239] = (byte)-23;
	geoidSimple[50][240] = (byte)-23;
	geoidSimple[50][241] = (byte)-23;
	geoidSimple[50][242] = (byte)-22;
	geoidSimple[50][243] = (byte)-21;
	geoidSimple[50][244] = (byte)-20;
	geoidSimple[50][245] = (byte)-19;
	geoidSimple[50][246] = (byte)-19;
	geoidSimple[50][247] = (byte)-18;
	geoidSimple[50][248] = (byte)-17;
	geoidSimple[50][249] = (byte)-17;
	geoidSimple[50][250] = (byte)-17;
	geoidSimple[50][251] = (byte)-16;
	geoidSimple[50][252] = (byte)-14;
	geoidSimple[50][253] = (byte)-13;
	geoidSimple[50][254] = (byte)-13;
	geoidSimple[50][255] = (byte)-17;
	geoidSimple[50][256] = (byte)-20;
	geoidSimple[50][257] = (byte)-22;
	geoidSimple[50][258] = (byte)-23;
	geoidSimple[50][259] = (byte)-25;
	geoidSimple[50][260] = (byte)-25;
	geoidSimple[50][261] = (byte)-26;
	geoidSimple[50][262] = (byte)-27;
	geoidSimple[50][263] = (byte)-29;
	geoidSimple[50][264] = (byte)-31;
	geoidSimple[50][265] = (byte)-32;
	geoidSimple[50][266] = (byte)-33;
	geoidSimple[50][267] = (byte)-32;
	geoidSimple[50][268] = (byte)-33;
	geoidSimple[50][269] = (byte)-32;
	geoidSimple[50][270] = (byte)-32;
	geoidSimple[50][271] = (byte)-32;
	geoidSimple[50][272] = (byte)-33;
	geoidSimple[50][273] = (byte)-33;
	geoidSimple[50][274] = (byte)-34;
	geoidSimple[50][275] = (byte)-34;
	geoidSimple[50][276] = (byte)-33;
	geoidSimple[50][277] = (byte)-34;
	geoidSimple[50][278] = (byte)-34;
	geoidSimple[50][279] = (byte)-34;
	geoidSimple[50][280] = (byte)-32;
	geoidSimple[50][281] = (byte)-33;
	geoidSimple[50][282] = (byte)-34;
	geoidSimple[50][283] = (byte)-33;
	geoidSimple[50][284] = (byte)-34;
	geoidSimple[50][285] = (byte)-34;
	geoidSimple[50][286] = (byte)-35;
	geoidSimple[50][287] = (byte)-35;
	geoidSimple[50][288] = (byte)-36;
	geoidSimple[50][289] = (byte)-36;
	geoidSimple[50][290] = (byte)-36;
	geoidSimple[50][291] = (byte)-36;
	geoidSimple[50][292] = (byte)-36;
	geoidSimple[50][293] = (byte)-35;
	geoidSimple[50][294] = (byte)-34;
	geoidSimple[50][295] = (byte)-34;
	geoidSimple[50][296] = (byte)-32;
	geoidSimple[50][297] = (byte)-31;
	geoidSimple[50][298] = (byte)-29;
	geoidSimple[50][299] = (byte)-27;
	geoidSimple[50][300] = (byte)-26;
	geoidSimple[50][301] = (byte)-24;
	geoidSimple[50][302] = (byte)-22;
	geoidSimple[50][303] = (byte)-20;
	geoidSimple[50][304] = (byte)-17;
	geoidSimple[50][305] = (byte)-14;
	geoidSimple[50][306] = (byte)-11;
	geoidSimple[50][307] = (byte)-8;
	geoidSimple[50][308] = (byte)-4;
	geoidSimple[50][309] = (byte)-1;
	geoidSimple[50][310] = (byte)1;
	geoidSimple[50][311] = (byte)4;
	geoidSimple[50][312] = (byte)7;
	geoidSimple[50][313] = (byte)10;
	geoidSimple[50][314] = (byte)13;
	geoidSimple[50][315] = (byte)16;
	geoidSimple[50][316] = (byte)19;
	geoidSimple[50][317] = (byte)22;
	geoidSimple[50][318] = (byte)26;
	geoidSimple[50][319] = (byte)29;
	geoidSimple[50][320] = (byte)32;
	geoidSimple[50][321] = (byte)35;
	geoidSimple[50][322] = (byte)38;
	geoidSimple[50][323] = (byte)41;
	geoidSimple[50][324] = (byte)44;
	geoidSimple[50][325] = (byte)46;
	geoidSimple[50][326] = (byte)50;
	geoidSimple[50][327] = (byte)53;
	geoidSimple[50][328] = (byte)55;
	geoidSimple[50][329] = (byte)57;
	geoidSimple[50][330] = (byte)58;
	geoidSimple[50][331] = (byte)58;
	geoidSimple[50][332] = (byte)59;
	geoidSimple[50][333] = (byte)58;
	geoidSimple[50][334] = (byte)57;
	geoidSimple[50][335] = (byte)56;
	geoidSimple[50][336] = (byte)55;
	geoidSimple[50][337] = (byte)54;
	geoidSimple[50][338] = (byte)53;
	geoidSimple[50][339] = (byte)51;
	geoidSimple[50][340] = (byte)51;
	geoidSimple[50][341] = (byte)50;
	geoidSimple[50][342] = (byte)50;
	geoidSimple[50][343] = (byte)49;
	geoidSimple[50][344] = (byte)48;
	geoidSimple[50][345] = (byte)48;
	geoidSimple[50][346] = (byte)48;
	geoidSimple[50][347] = (byte)47;
	geoidSimple[50][348] = (byte)46;
	geoidSimple[50][349] = (byte)48;
	geoidSimple[50][350] = (byte)52;
	geoidSimple[50][351] = (byte)54;
	geoidSimple[50][352] = (byte)55;
	geoidSimple[50][353] = (byte)54;
	geoidSimple[50][354] = (byte)54;
	geoidSimple[50][355] = (byte)54;
	geoidSimple[50][356] = (byte)53;
	geoidSimple[50][357] = (byte)52;
	geoidSimple[50][358] = (byte)52;
	geoidSimple[50][359] = (byte)51;
	}
		/** Row 51*/
	private static void init51() {
	geoidSimple[51][0] = (byte)49;
	geoidSimple[51][1] = (byte)48;
	geoidSimple[51][2] = (byte)47;
	geoidSimple[51][3] = (byte)45;
	geoidSimple[51][4] = (byte)44;
	geoidSimple[51][5] = (byte)44;
	geoidSimple[51][6] = (byte)43;
	geoidSimple[51][7] = (byte)43;
	geoidSimple[51][8] = (byte)44;
	geoidSimple[51][9] = (byte)44;
	geoidSimple[51][10] = (byte)43;
	geoidSimple[51][11] = (byte)43;
	geoidSimple[51][12] = (byte)43;
	geoidSimple[51][13] = (byte)42;
	geoidSimple[51][14] = (byte)42;
	geoidSimple[51][15] = (byte)43;
	geoidSimple[51][16] = (byte)40;
	geoidSimple[51][17] = (byte)32;
	geoidSimple[51][18] = (byte)28;
	geoidSimple[51][19] = (byte)25;
	geoidSimple[51][20] = (byte)25;
	geoidSimple[51][21] = (byte)27;
	geoidSimple[51][22] = (byte)33;
	geoidSimple[51][23] = (byte)38;
	geoidSimple[51][24] = (byte)39;
	geoidSimple[51][25] = (byte)39;
	geoidSimple[51][26] = (byte)39;
	geoidSimple[51][27] = (byte)38;
	geoidSimple[51][28] = (byte)39;
	geoidSimple[51][29] = (byte)39;
	geoidSimple[51][30] = (byte)39;
	geoidSimple[51][31] = (byte)38;
	geoidSimple[51][32] = (byte)37;
	geoidSimple[51][33] = (byte)36;
	geoidSimple[51][34] = (byte)36;
	geoidSimple[51][35] = (byte)36;
	geoidSimple[51][36] = (byte)36;
	geoidSimple[51][37] = (byte)33;
	geoidSimple[51][38] = (byte)30;
	geoidSimple[51][39] = (byte)29;
	geoidSimple[51][40] = (byte)27;
	geoidSimple[51][41] = (byte)25;
	geoidSimple[51][42] = (byte)26;
	geoidSimple[51][43] = (byte)25;
	geoidSimple[51][44] = (byte)23;
	geoidSimple[51][45] = (byte)19;
	geoidSimple[51][46] = (byte)17;
	geoidSimple[51][47] = (byte)14;
	geoidSimple[51][48] = (byte)9;
	geoidSimple[51][49] = (byte)-3;
	geoidSimple[51][50] = (byte)-12;
	geoidSimple[51][51] = (byte)-15;
	geoidSimple[51][52] = (byte)-15;
	geoidSimple[51][53] = (byte)-17;
	geoidSimple[51][54] = (byte)-19;
	geoidSimple[51][55] = (byte)-18;
	geoidSimple[51][56] = (byte)-18;
	geoidSimple[51][57] = (byte)-20;
	geoidSimple[51][58] = (byte)-24;
	geoidSimple[51][59] = (byte)-27;
	geoidSimple[51][60] = (byte)-30;
	geoidSimple[51][61] = (byte)-32;
	geoidSimple[51][62] = (byte)-33;
	geoidSimple[51][63] = (byte)-34;
	geoidSimple[51][64] = (byte)-36;
	geoidSimple[51][65] = (byte)-37;
	geoidSimple[51][66] = (byte)-37;
	geoidSimple[51][67] = (byte)-36;
	geoidSimple[51][68] = (byte)-38;
	geoidSimple[51][69] = (byte)-39;
	geoidSimple[51][70] = (byte)-36;
	geoidSimple[51][71] = (byte)-33;
	geoidSimple[51][72] = (byte)-31;
	geoidSimple[51][73] = (byte)-28;
	geoidSimple[51][74] = (byte)-30;
	geoidSimple[51][75] = (byte)-35;
	geoidSimple[51][76] = (byte)-44;
	geoidSimple[51][77] = (byte)-50;
	geoidSimple[51][78] = (byte)-52;
	geoidSimple[51][79] = (byte)-51;
	geoidSimple[51][80] = (byte)-52;
	geoidSimple[51][81] = (byte)-54;
	geoidSimple[51][82] = (byte)-57;
	geoidSimple[51][83] = (byte)-58;
	geoidSimple[51][84] = (byte)-59;
	geoidSimple[51][85] = (byte)-59;
	geoidSimple[51][86] = (byte)-60;
	geoidSimple[51][87] = (byte)-58;
	geoidSimple[51][88] = (byte)-53;
	geoidSimple[51][89] = (byte)-50;
	geoidSimple[51][90] = (byte)-52;
	geoidSimple[51][91] = (byte)-55;
	geoidSimple[51][92] = (byte)-57;
	geoidSimple[51][93] = (byte)-56;
	geoidSimple[51][94] = (byte)-53;
	geoidSimple[51][95] = (byte)-50;
	geoidSimple[51][96] = (byte)-48;
	geoidSimple[51][97] = (byte)-47;
	geoidSimple[51][98] = (byte)-46;
	geoidSimple[51][99] = (byte)-46;
	geoidSimple[51][100] = (byte)-49;
	geoidSimple[51][101] = (byte)-49;
	geoidSimple[51][102] = (byte)-50;
	geoidSimple[51][103] = (byte)-49;
	geoidSimple[51][104] = (byte)-46;
	geoidSimple[51][105] = (byte)-43;
	geoidSimple[51][106] = (byte)-41;
	geoidSimple[51][107] = (byte)-38;
	geoidSimple[51][108] = (byte)-34;
	geoidSimple[51][109] = (byte)-31;
	geoidSimple[51][110] = (byte)-27;
	geoidSimple[51][111] = (byte)-22;
	geoidSimple[51][112] = (byte)-18;
	geoidSimple[51][113] = (byte)-15;
	geoidSimple[51][114] = (byte)-15;
	geoidSimple[51][115] = (byte)-13;
	geoidSimple[51][116] = (byte)-11;
	geoidSimple[51][117] = (byte)-7;
	geoidSimple[51][118] = (byte)-3;
	geoidSimple[51][119] = (byte)0;
	geoidSimple[51][120] = (byte)3;
	geoidSimple[51][121] = (byte)8;
	geoidSimple[51][122] = (byte)11;
	geoidSimple[51][123] = (byte)13;
	geoidSimple[51][124] = (byte)16;
	geoidSimple[51][125] = (byte)18;
	geoidSimple[51][126] = (byte)21;
	geoidSimple[51][127] = (byte)23;
	geoidSimple[51][128] = (byte)24;
	geoidSimple[51][129] = (byte)24;
	geoidSimple[51][130] = (byte)25;
	geoidSimple[51][131] = (byte)26;
	geoidSimple[51][132] = (byte)26;
	geoidSimple[51][133] = (byte)29;
	geoidSimple[51][134] = (byte)30;
	geoidSimple[51][135] = (byte)30;
	geoidSimple[51][136] = (byte)32;
	geoidSimple[51][137] = (byte)34;
	geoidSimple[51][138] = (byte)36;
	geoidSimple[51][139] = (byte)38;
	geoidSimple[51][140] = (byte)40;
	geoidSimple[51][141] = (byte)40;
	geoidSimple[51][142] = (byte)32;
	geoidSimple[51][143] = (byte)21;
	geoidSimple[51][144] = (byte)17;
	geoidSimple[51][145] = (byte)21;
	geoidSimple[51][146] = (byte)22;
	geoidSimple[51][147] = (byte)20;
	geoidSimple[51][148] = (byte)18;
	geoidSimple[51][149] = (byte)16;
	geoidSimple[51][150] = (byte)13;
	geoidSimple[51][151] = (byte)12;
	geoidSimple[51][152] = (byte)10;
	geoidSimple[51][153] = (byte)8;
	geoidSimple[51][154] = (byte)6;
	geoidSimple[51][155] = (byte)4;
	geoidSimple[51][156] = (byte)2;
	geoidSimple[51][157] = (byte)0;
	geoidSimple[51][158] = (byte)0;
	geoidSimple[51][159] = (byte)-2;
	geoidSimple[51][160] = (byte)-3;
	geoidSimple[51][161] = (byte)-3;
	geoidSimple[51][162] = (byte)-4;
	geoidSimple[51][163] = (byte)-6;
	geoidSimple[51][164] = (byte)-7;
	geoidSimple[51][165] = (byte)-8;
	geoidSimple[51][166] = (byte)-9;
	geoidSimple[51][167] = (byte)-10;
	geoidSimple[51][168] = (byte)-11;
	geoidSimple[51][169] = (byte)-13;
	geoidSimple[51][170] = (byte)-11;
	geoidSimple[51][171] = (byte)-11;
	geoidSimple[51][172] = (byte)-13;
	geoidSimple[51][173] = (byte)-12;
	geoidSimple[51][174] = (byte)-11;
	geoidSimple[51][175] = (byte)-11;
	geoidSimple[51][176] = (byte)-11;
	geoidSimple[51][177] = (byte)-12;
	geoidSimple[51][178] = (byte)-12;
	geoidSimple[51][179] = (byte)-12;
	geoidSimple[51][LAT_GRID_SIZE] = (byte)-12;
	geoidSimple[51][181] = (byte)-12;
	geoidSimple[51][182] = (byte)-12;
	geoidSimple[51][183] = (byte)-12;
	geoidSimple[51][184] = (byte)-12;
	geoidSimple[51][185] = (byte)-12;
	geoidSimple[51][186] = (byte)-12;
	geoidSimple[51][187] = (byte)-12;
	geoidSimple[51][188] = (byte)-12;
	geoidSimple[51][189] = (byte)-11;
	geoidSimple[51][190] = (byte)-11;
	geoidSimple[51][191] = (byte)-11;
	geoidSimple[51][192] = (byte)-11;
	geoidSimple[51][193] = (byte)-11;
	geoidSimple[51][194] = (byte)-11;
	geoidSimple[51][195] = (byte)-11;
	geoidSimple[51][196] = (byte)-12;
	geoidSimple[51][197] = (byte)-12;
	geoidSimple[51][198] = (byte)-13;
	geoidSimple[51][199] = (byte)-13;
	geoidSimple[51][200] = (byte)-14;
	geoidSimple[51][201] = (byte)-14;
	geoidSimple[51][202] = (byte)-15;
	geoidSimple[51][203] = (byte)-15;
	geoidSimple[51][204] = (byte)-16;
	geoidSimple[51][205] = (byte)-17;
	geoidSimple[51][206] = (byte)-18;
	geoidSimple[51][207] = (byte)-18;
	geoidSimple[51][208] = (byte)-19;
	geoidSimple[51][209] = (byte)-21;
	geoidSimple[51][210] = (byte)-21;
	geoidSimple[51][211] = (byte)-22;
	geoidSimple[51][212] = (byte)-23;
	geoidSimple[51][213] = (byte)-24;
	geoidSimple[51][214] = (byte)-26;
	geoidSimple[51][215] = (byte)-27;
	geoidSimple[51][216] = (byte)-29;
	geoidSimple[51][217] = (byte)-30;
	geoidSimple[51][218] = (byte)-31;
	geoidSimple[51][219] = (byte)-32;
	geoidSimple[51][220] = (byte)-33;
	geoidSimple[51][221] = (byte)-34;
	geoidSimple[51][222] = (byte)-34;
	geoidSimple[51][223] = (byte)-35;
	geoidSimple[51][224] = (byte)-35;
	geoidSimple[51][225] = (byte)-36;
	geoidSimple[51][226] = (byte)-36;
	geoidSimple[51][227] = (byte)-37;
	geoidSimple[51][228] = (byte)-37;
	geoidSimple[51][229] = (byte)-37;
	geoidSimple[51][230] = (byte)-37;
	geoidSimple[51][231] = (byte)-37;
	geoidSimple[51][232] = (byte)-37;
	geoidSimple[51][233] = (byte)-37;
	geoidSimple[51][234] = (byte)-36;
	geoidSimple[51][235] = (byte)-36;
	geoidSimple[51][236] = (byte)-33;
	geoidSimple[51][237] = (byte)-30;
	geoidSimple[51][238] = (byte)-30;
	geoidSimple[51][239] = (byte)-26;
	geoidSimple[51][240] = (byte)-24;
	geoidSimple[51][241] = (byte)-24;
	geoidSimple[51][242] = (byte)-23;
	geoidSimple[51][243] = (byte)-23;
	geoidSimple[51][244] = (byte)-22;
	geoidSimple[51][245] = (byte)-21;
	geoidSimple[51][246] = (byte)-21;
	geoidSimple[51][247] = (byte)-19;
	geoidSimple[51][248] = (byte)-18;
	geoidSimple[51][249] = (byte)-19;
	geoidSimple[51][250] = (byte)-19;
	geoidSimple[51][251] = (byte)-17;
	geoidSimple[51][252] = (byte)-16;
	geoidSimple[51][253] = (byte)-14;
	geoidSimple[51][254] = (byte)-14;
	geoidSimple[51][255] = (byte)-18;
	geoidSimple[51][256] = (byte)-21;
	geoidSimple[51][257] = (byte)-23;
	geoidSimple[51][258] = (byte)-24;
	geoidSimple[51][259] = (byte)-25;
	geoidSimple[51][260] = (byte)-26;
	geoidSimple[51][261] = (byte)-27;
	geoidSimple[51][262] = (byte)-28;
	geoidSimple[51][263] = (byte)-30;
	geoidSimple[51][264] = (byte)-32;
	geoidSimple[51][265] = (byte)-32;
	geoidSimple[51][266] = (byte)-33;
	geoidSimple[51][267] = (byte)-33;
	geoidSimple[51][268] = (byte)-32;
	geoidSimple[51][269] = (byte)-31;
	geoidSimple[51][270] = (byte)-31;
	geoidSimple[51][271] = (byte)-31;
	geoidSimple[51][272] = (byte)-32;
	geoidSimple[51][273] = (byte)-33;
	geoidSimple[51][274] = (byte)-34;
	geoidSimple[51][275] = (byte)-34;
	geoidSimple[51][276] = (byte)-34;
	geoidSimple[51][277] = (byte)-34;
	geoidSimple[51][278] = (byte)-34;
	geoidSimple[51][279] = (byte)-32;
	geoidSimple[51][280] = (byte)-32;
	geoidSimple[51][281] = (byte)-33;
	geoidSimple[51][282] = (byte)-33;
	geoidSimple[51][283] = (byte)-34;
	geoidSimple[51][284] = (byte)-36;
	geoidSimple[51][285] = (byte)-37;
	geoidSimple[51][286] = (byte)-38;
	geoidSimple[51][287] = (byte)-40;
	geoidSimple[51][288] = (byte)-40;
	geoidSimple[51][289] = (byte)-39;
	geoidSimple[51][290] = (byte)-39;
	geoidSimple[51][291] = (byte)-39;
	geoidSimple[51][292] = (byte)-38;
	geoidSimple[51][293] = (byte)-38;
	geoidSimple[51][294] = (byte)-36;
	geoidSimple[51][295] = (byte)-35;
	geoidSimple[51][296] = (byte)-32;
	geoidSimple[51][297] = (byte)-31;
	geoidSimple[51][298] = (byte)-29;
	geoidSimple[51][299] = (byte)-26;
	geoidSimple[51][300] = (byte)-26;
	geoidSimple[51][301] = (byte)-25;
	geoidSimple[51][302] = (byte)-23;
	geoidSimple[51][303] = (byte)-21;
	geoidSimple[51][304] = (byte)-18;
	geoidSimple[51][305] = (byte)-15;
	geoidSimple[51][306] = (byte)-12;
	geoidSimple[51][307] = (byte)-9;
	geoidSimple[51][308] = (byte)-5;
	geoidSimple[51][309] = (byte)-2;
	geoidSimple[51][310] = (byte)0;
	geoidSimple[51][311] = (byte)2;
	geoidSimple[51][312] = (byte)5;
	geoidSimple[51][313] = (byte)8;
	geoidSimple[51][314] = (byte)11;
	geoidSimple[51][315] = (byte)14;
	geoidSimple[51][316] = (byte)17;
	geoidSimple[51][317] = (byte)21;
	geoidSimple[51][318] = (byte)24;
	geoidSimple[51][319] = (byte)28;
	geoidSimple[51][320] = (byte)31;
	geoidSimple[51][321] = (byte)34;
	geoidSimple[51][322] = (byte)37;
	geoidSimple[51][323] = (byte)40;
	geoidSimple[51][324] = (byte)43;
	geoidSimple[51][325] = (byte)46;
	geoidSimple[51][326] = (byte)49;
	geoidSimple[51][327] = (byte)52;
	geoidSimple[51][328] = (byte)54;
	geoidSimple[51][329] = (byte)55;
	geoidSimple[51][330] = (byte)56;
	geoidSimple[51][331] = (byte)57;
	geoidSimple[51][332] = (byte)57;
	geoidSimple[51][333] = (byte)56;
	geoidSimple[51][334] = (byte)55;
	geoidSimple[51][335] = (byte)54;
	geoidSimple[51][336] = (byte)53;
	geoidSimple[51][337] = (byte)52;
	geoidSimple[51][338] = (byte)51;
	geoidSimple[51][339] = (byte)50;
	geoidSimple[51][340] = (byte)49;
	geoidSimple[51][341] = (byte)48;
	geoidSimple[51][342] = (byte)48;
	geoidSimple[51][343] = (byte)48;
	geoidSimple[51][344] = (byte)48;
	geoidSimple[51][345] = (byte)48;
	geoidSimple[51][346] = (byte)50;
	geoidSimple[51][347] = (byte)48;
	geoidSimple[51][348] = (byte)46;
	geoidSimple[51][349] = (byte)48;
	geoidSimple[51][350] = (byte)52;
	geoidSimple[51][351] = (byte)54;
	geoidSimple[51][352] = (byte)55;
	geoidSimple[51][353] = (byte)55;
	geoidSimple[51][354] = (byte)54;
	geoidSimple[51][355] = (byte)53;
	geoidSimple[51][356] = (byte)53;
	geoidSimple[51][357] = (byte)53;
	geoidSimple[51][358] = (byte)51;
	geoidSimple[51][359] = (byte)50;
	}
		/** Row 52*/
	private static void init52() {
	geoidSimple[52][0] = (byte)47;
	geoidSimple[52][1] = (byte)45;
	geoidSimple[52][2] = (byte)44;
	geoidSimple[52][3] = (byte)44;
	geoidSimple[52][4] = (byte)43;
	geoidSimple[52][5] = (byte)42;
	geoidSimple[52][6] = (byte)41;
	geoidSimple[52][7] = (byte)41;
	geoidSimple[52][8] = (byte)42;
	geoidSimple[52][9] = (byte)43;
	geoidSimple[52][10] = (byte)42;
	geoidSimple[52][11] = (byte)42;
	geoidSimple[52][12] = (byte)42;
	geoidSimple[52][13] = (byte)41;
	geoidSimple[52][14] = (byte)41;
	geoidSimple[52][15] = (byte)38;
	geoidSimple[52][16] = (byte)32;
	geoidSimple[52][17] = (byte)29;
	geoidSimple[52][18] = (byte)28;
	geoidSimple[52][19] = (byte)24;
	geoidSimple[52][20] = (byte)24;
	geoidSimple[52][21] = (byte)25;
	geoidSimple[52][22] = (byte)31;
	geoidSimple[52][23] = (byte)36;
	geoidSimple[52][24] = (byte)38;
	geoidSimple[52][25] = (byte)38;
	geoidSimple[52][26] = (byte)37;
	geoidSimple[52][27] = (byte)36;
	geoidSimple[52][28] = (byte)34;
	geoidSimple[52][29] = (byte)32;
	geoidSimple[52][30] = (byte)34;
	geoidSimple[52][31] = (byte)35;
	geoidSimple[52][32] = (byte)35;
	geoidSimple[52][33] = (byte)34;
	geoidSimple[52][34] = (byte)35;
	geoidSimple[52][35] = (byte)33;
	geoidSimple[52][36] = (byte)33;
	geoidSimple[52][37] = (byte)31;
	geoidSimple[52][38] = (byte)27;
	geoidSimple[52][39] = (byte)26;
	geoidSimple[52][40] = (byte)24;
	geoidSimple[52][41] = (byte)22;
	geoidSimple[52][42] = (byte)21;
	geoidSimple[52][43] = (byte)22;
	geoidSimple[52][44] = (byte)21;
	geoidSimple[52][45] = (byte)19;
	geoidSimple[52][46] = (byte)17;
	geoidSimple[52][47] = (byte)14;
	geoidSimple[52][48] = (byte)11;
	geoidSimple[52][49] = (byte)1;
	geoidSimple[52][50] = (byte)-5;
	geoidSimple[52][51] = (byte)-10;
	geoidSimple[52][52] = (byte)-11;
	geoidSimple[52][53] = (byte)-12;
	geoidSimple[52][54] = (byte)-15;
	geoidSimple[52][55] = (byte)-14;
	geoidSimple[52][56] = (byte)-12;
	geoidSimple[52][57] = (byte)-13;
	geoidSimple[52][58] = (byte)-17;
	geoidSimple[52][59] = (byte)-24;
	geoidSimple[52][60] = (byte)-28;
	geoidSimple[52][61] = (byte)-30;
	geoidSimple[52][62] = (byte)-32;
	geoidSimple[52][63] = (byte)-35;
	geoidSimple[52][64] = (byte)-36;
	geoidSimple[52][65] = (byte)-37;
	geoidSimple[52][66] = (byte)-38;
	geoidSimple[52][67] = (byte)-42;
	geoidSimple[52][68] = (byte)-44;
	geoidSimple[52][69] = (byte)-44;
	geoidSimple[52][70] = (byte)-37;
	geoidSimple[52][71] = (byte)-31;
	geoidSimple[52][72] = (byte)-29;
	geoidSimple[52][73] = (byte)-26;
	geoidSimple[52][74] = (byte)-28;
	geoidSimple[52][75] = (byte)-30;
	geoidSimple[52][76] = (byte)-34;
	geoidSimple[52][77] = (byte)-43;
	geoidSimple[52][78] = (byte)-48;
	geoidSimple[52][79] = (byte)-52;
	geoidSimple[52][80] = (byte)-53;
	geoidSimple[52][81] = (byte)-53;
	geoidSimple[52][82] = (byte)-53;
	geoidSimple[52][83] = (byte)-54;
	geoidSimple[52][84] = (byte)-52;
	geoidSimple[52][85] = (byte)-50;
	geoidSimple[52][86] = (byte)-46;
	geoidSimple[52][87] = (byte)-43;
	geoidSimple[52][88] = (byte)-43;
	geoidSimple[52][89] = (byte)-45;
	geoidSimple[52][90] = (byte)-48;
	geoidSimple[52][91] = (byte)-52;
	geoidSimple[52][92] = (byte)-57;
	geoidSimple[52][93] = (byte)-59;
	geoidSimple[52][94] = (byte)-57;
	geoidSimple[52][95] = (byte)-52;
	geoidSimple[52][96] = (byte)-50;
	geoidSimple[52][97] = (byte)-48;
	geoidSimple[52][98] = (byte)-46;
	geoidSimple[52][99] = (byte)-45;
	geoidSimple[52][100] = (byte)-44;
	geoidSimple[52][101] = (byte)-43;
	geoidSimple[52][102] = (byte)-44;
	geoidSimple[52][103] = (byte)-46;
	geoidSimple[52][104] = (byte)-45;
	geoidSimple[52][105] = (byte)-43;
	geoidSimple[52][106] = (byte)-40;
	geoidSimple[52][107] = (byte)-37;
	geoidSimple[52][108] = (byte)-33;
	geoidSimple[52][109] = (byte)-31;
	geoidSimple[52][110] = (byte)-28;
	geoidSimple[52][111] = (byte)-22;
	geoidSimple[52][112] = (byte)-19;
	geoidSimple[52][113] = (byte)-15;
	geoidSimple[52][114] = (byte)-15;
	geoidSimple[52][115] = (byte)-14;
	geoidSimple[52][116] = (byte)-10;
	geoidSimple[52][117] = (byte)-6;
	geoidSimple[52][118] = (byte)-2;
	geoidSimple[52][119] = (byte)1;
	geoidSimple[52][120] = (byte)4;
	geoidSimple[52][121] = (byte)8;
	geoidSimple[52][122] = (byte)10;
	geoidSimple[52][123] = (byte)13;
	geoidSimple[52][124] = (byte)16;
	geoidSimple[52][125] = (byte)18;
	geoidSimple[52][126] = (byte)21;
	geoidSimple[52][127] = (byte)23;
	geoidSimple[52][128] = (byte)26;
	geoidSimple[52][129] = (byte)26;
	geoidSimple[52][130] = (byte)26;
	geoidSimple[52][131] = (byte)27;
	geoidSimple[52][132] = (byte)28;
	geoidSimple[52][133] = (byte)30;
	geoidSimple[52][134] = (byte)30;
	geoidSimple[52][135] = (byte)31;
	geoidSimple[52][136] = (byte)35;
	geoidSimple[52][137] = (byte)36;
	geoidSimple[52][138] = (byte)37;
	geoidSimple[52][139] = (byte)40;
	geoidSimple[52][140] = (byte)42;
	geoidSimple[52][141] = (byte)38;
	geoidSimple[52][142] = (byte)29;
	geoidSimple[52][143] = (byte)18;
	geoidSimple[52][144] = (byte)18;
	geoidSimple[52][145] = (byte)21;
	geoidSimple[52][146] = (byte)21;
	geoidSimple[52][147] = (byte)19;
	geoidSimple[52][148] = (byte)17;
	geoidSimple[52][149] = (byte)14;
	geoidSimple[52][150] = (byte)12;
	geoidSimple[52][151] = (byte)10;
	geoidSimple[52][152] = (byte)9;
	geoidSimple[52][153] = (byte)7;
	geoidSimple[52][154] = (byte)5;
	geoidSimple[52][155] = (byte)3;
	geoidSimple[52][156] = (byte)1;
	geoidSimple[52][157] = (byte)0;
	geoidSimple[52][158] = (byte)0;
	geoidSimple[52][159] = (byte)-1;
	geoidSimple[52][160] = (byte)-3;
	geoidSimple[52][161] = (byte)-3;
	geoidSimple[52][162] = (byte)-4;
	geoidSimple[52][163] = (byte)-5;
	geoidSimple[52][164] = (byte)-7;
	geoidSimple[52][165] = (byte)-8;
	geoidSimple[52][166] = (byte)-9;
	geoidSimple[52][167] = (byte)-9;
	geoidSimple[52][168] = (byte)-10;
	geoidSimple[52][169] = (byte)-12;
	geoidSimple[52][170] = (byte)-9;
	geoidSimple[52][171] = (byte)-11;
	geoidSimple[52][172] = (byte)-13;
	geoidSimple[52][173] = (byte)-12;
	geoidSimple[52][174] = (byte)-11;
	geoidSimple[52][175] = (byte)-11;
	geoidSimple[52][176] = (byte)-10;
	geoidSimple[52][177] = (byte)-11;
	geoidSimple[52][178] = (byte)-12;
	geoidSimple[52][179] = (byte)-12;
	geoidSimple[52][LAT_GRID_SIZE] = (byte)-12;
	geoidSimple[52][181] = (byte)-12;
	geoidSimple[52][182] = (byte)-12;
	geoidSimple[52][183] = (byte)-12;
	geoidSimple[52][184] = (byte)-12;
	geoidSimple[52][185] = (byte)-12;
	geoidSimple[52][186] = (byte)-12;
	geoidSimple[52][187] = (byte)-12;
	geoidSimple[52][188] = (byte)-12;
	geoidSimple[52][189] = (byte)-12;
	geoidSimple[52][190] = (byte)-12;
	geoidSimple[52][191] = (byte)-12;
	geoidSimple[52][192] = (byte)-12;
	geoidSimple[52][193] = (byte)-12;
	geoidSimple[52][194] = (byte)-12;
	geoidSimple[52][195] = (byte)-12;
	geoidSimple[52][196] = (byte)-12;
	geoidSimple[52][197] = (byte)-13;
	geoidSimple[52][198] = (byte)-13;
	geoidSimple[52][199] = (byte)-14;
	geoidSimple[52][200] = (byte)-14;
	geoidSimple[52][201] = (byte)-15;
	geoidSimple[52][202] = (byte)-15;
	geoidSimple[52][203] = (byte)-16;
	geoidSimple[52][204] = (byte)-17;
	geoidSimple[52][205] = (byte)-17;
	geoidSimple[52][206] = (byte)-18;
	geoidSimple[52][207] = (byte)-19;
	geoidSimple[52][208] = (byte)-20;
	geoidSimple[52][209] = (byte)-21;
	geoidSimple[52][210] = (byte)-22;
	geoidSimple[52][211] = (byte)-22;
	geoidSimple[52][212] = (byte)-24;
	geoidSimple[52][213] = (byte)-25;
	geoidSimple[52][214] = (byte)-26;
	geoidSimple[52][215] = (byte)-27;
	geoidSimple[52][216] = (byte)-29;
	geoidSimple[52][217] = (byte)-30;
	geoidSimple[52][218] = (byte)-31;
	geoidSimple[52][219] = (byte)-33;
	geoidSimple[52][220] = (byte)-34;
	geoidSimple[52][221] = (byte)-34;
	geoidSimple[52][222] = (byte)-35;
	geoidSimple[52][223] = (byte)-36;
	geoidSimple[52][224] = (byte)-36;
	geoidSimple[52][225] = (byte)-37;
	geoidSimple[52][226] = (byte)-37;
	geoidSimple[52][227] = (byte)-38;
	geoidSimple[52][228] = (byte)-38;
	geoidSimple[52][229] = (byte)-38;
	geoidSimple[52][230] = (byte)-39;
	geoidSimple[52][231] = (byte)-39;
	geoidSimple[52][232] = (byte)-39;
	geoidSimple[52][233] = (byte)-38;
	geoidSimple[52][234] = (byte)-38;
	geoidSimple[52][235] = (byte)-37;
	geoidSimple[52][236] = (byte)-36;
	geoidSimple[52][237] = (byte)-33;
	geoidSimple[52][238] = (byte)-31;
	geoidSimple[52][239] = (byte)-30;
	geoidSimple[52][240] = (byte)-26;
	geoidSimple[52][241] = (byte)-25;
	geoidSimple[52][242] = (byte)-26;
	geoidSimple[52][243] = (byte)-26;
	geoidSimple[52][244] = (byte)-25;
	geoidSimple[52][245] = (byte)-24;
	geoidSimple[52][246] = (byte)-23;
	geoidSimple[52][247] = (byte)-21;
	geoidSimple[52][248] = (byte)-21;
	geoidSimple[52][249] = (byte)-21;
	geoidSimple[52][250] = (byte)-20;
	geoidSimple[52][251] = (byte)-19;
	geoidSimple[52][252] = (byte)-17;
	geoidSimple[52][253] = (byte)-16;
	geoidSimple[52][254] = (byte)-16;
	geoidSimple[52][255] = (byte)-18;
	geoidSimple[52][256] = (byte)-21;
	geoidSimple[52][257] = (byte)-23;
	geoidSimple[52][258] = (byte)-25;
	geoidSimple[52][259] = (byte)-26;
	geoidSimple[52][260] = (byte)-27;
	geoidSimple[52][261] = (byte)-28;
	geoidSimple[52][262] = (byte)-29;
	geoidSimple[52][263] = (byte)-30;
	geoidSimple[52][264] = (byte)-31;
	geoidSimple[52][265] = (byte)-31;
	geoidSimple[52][266] = (byte)-31;
	geoidSimple[52][267] = (byte)-31;
	geoidSimple[52][268] = (byte)-31;
	geoidSimple[52][269] = (byte)-30;
	geoidSimple[52][270] = (byte)-29;
	geoidSimple[52][271] = (byte)-29;
	geoidSimple[52][272] = (byte)-31;
	geoidSimple[52][273] = (byte)-32;
	geoidSimple[52][274] = (byte)-33;
	geoidSimple[52][275] = (byte)-33;
	geoidSimple[52][276] = (byte)-33;
	geoidSimple[52][277] = (byte)-33;
	geoidSimple[52][278] = (byte)-32;
	geoidSimple[52][279] = (byte)-32;
	geoidSimple[52][280] = (byte)-33;
	geoidSimple[52][281] = (byte)-33;
	geoidSimple[52][282] = (byte)-33;
	geoidSimple[52][283] = (byte)-36;
	geoidSimple[52][284] = (byte)-38;
	geoidSimple[52][285] = (byte)-38;
	geoidSimple[52][286] = (byte)-41;
	geoidSimple[52][287] = (byte)-42;
	geoidSimple[52][288] = (byte)-41;
	geoidSimple[52][289] = (byte)-41;
	geoidSimple[52][290] = (byte)-41;
	geoidSimple[52][291] = (byte)-41;
	geoidSimple[52][292] = (byte)-40;
	geoidSimple[52][293] = (byte)-39;
	geoidSimple[52][294] = (byte)-37;
	geoidSimple[52][295] = (byte)-35;
	geoidSimple[52][296] = (byte)-33;
	geoidSimple[52][297] = (byte)-32;
	geoidSimple[52][298] = (byte)-30;
	geoidSimple[52][299] = (byte)-28;
	geoidSimple[52][300] = (byte)-27;
	geoidSimple[52][301] = (byte)-26;
	geoidSimple[52][302] = (byte)-23;
	geoidSimple[52][303] = (byte)-22;
	geoidSimple[52][304] = (byte)-19;
	geoidSimple[52][305] = (byte)-17;
	geoidSimple[52][306] = (byte)-14;
	geoidSimple[52][307] = (byte)-10;
	geoidSimple[52][308] = (byte)-7;
	geoidSimple[52][309] = (byte)-4;
	geoidSimple[52][310] = (byte)-1;
	geoidSimple[52][311] = (byte)1;
	geoidSimple[52][312] = (byte)4;
	geoidSimple[52][313] = (byte)7;
	geoidSimple[52][314] = (byte)10;
	geoidSimple[52][315] = (byte)13;
	geoidSimple[52][316] = (byte)17;
	geoidSimple[52][317] = (byte)21;
	geoidSimple[52][318] = (byte)24;
	geoidSimple[52][319] = (byte)28;
	geoidSimple[52][320] = (byte)31;
	geoidSimple[52][321] = (byte)34;
	geoidSimple[52][322] = (byte)37;
	geoidSimple[52][323] = (byte)39;
	geoidSimple[52][324] = (byte)42;
	geoidSimple[52][325] = (byte)45;
	geoidSimple[52][326] = (byte)48;
	geoidSimple[52][327] = (byte)50;
	geoidSimple[52][328] = (byte)52;
	geoidSimple[52][329] = (byte)53;
	geoidSimple[52][330] = (byte)54;
	geoidSimple[52][331] = (byte)54;
	geoidSimple[52][332] = (byte)54;
	geoidSimple[52][333] = (byte)54;
	geoidSimple[52][334] = (byte)55;
	geoidSimple[52][335] = (byte)53;
	geoidSimple[52][336] = (byte)51;
	geoidSimple[52][337] = (byte)50;
	geoidSimple[52][338] = (byte)50;
	geoidSimple[52][339] = (byte)49;
	geoidSimple[52][340] = (byte)47;
	geoidSimple[52][341] = (byte)48;
	geoidSimple[52][342] = (byte)47;
	geoidSimple[52][343] = (byte)47;
	geoidSimple[52][344] = (byte)48;
	geoidSimple[52][345] = (byte)50;
	geoidSimple[52][346] = (byte)49;
	geoidSimple[52][347] = (byte)46;
	geoidSimple[52][348] = (byte)44;
	geoidSimple[52][349] = (byte)47;
	geoidSimple[52][350] = (byte)50;
	geoidSimple[52][351] = (byte)53;
	geoidSimple[52][352] = (byte)54;
	geoidSimple[52][353] = (byte)53;
	geoidSimple[52][354] = (byte)50;
	geoidSimple[52][355] = (byte)48;
	geoidSimple[52][356] = (byte)49;
	geoidSimple[52][357] = (byte)51;
	geoidSimple[52][358] = (byte)50;
	geoidSimple[52][359] = (byte)48;
	}
		/** Row 53*/
	private static void init53() {
	geoidSimple[53][0] = (byte)46;
	geoidSimple[53][1] = (byte)46;
	geoidSimple[53][2] = (byte)46;
	geoidSimple[53][3] = (byte)46;
	geoidSimple[53][4] = (byte)45;
	geoidSimple[53][5] = (byte)44;
	geoidSimple[53][6] = (byte)44;
	geoidSimple[53][7] = (byte)43;
	geoidSimple[53][8] = (byte)43;
	geoidSimple[53][9] = (byte)42;
	geoidSimple[53][10] = (byte)41;
	geoidSimple[53][11] = (byte)41;
	geoidSimple[53][12] = (byte)40;
	geoidSimple[53][13] = (byte)38;
	geoidSimple[53][14] = (byte)39;
	geoidSimple[53][15] = (byte)36;
	geoidSimple[53][16] = (byte)29;
	geoidSimple[53][17] = (byte)28;
	geoidSimple[53][18] = (byte)28;
	geoidSimple[53][19] = (byte)25;
	geoidSimple[53][20] = (byte)20;
	geoidSimple[53][21] = (byte)17;
	geoidSimple[53][22] = (byte)22;
	geoidSimple[53][23] = (byte)29;
	geoidSimple[53][24] = (byte)34;
	geoidSimple[53][25] = (byte)35;
	geoidSimple[53][26] = (byte)33;
	geoidSimple[53][27] = (byte)29;
	geoidSimple[53][28] = (byte)22;
	geoidSimple[53][29] = (byte)24;
	geoidSimple[53][30] = (byte)24;
	geoidSimple[53][31] = (byte)24;
	geoidSimple[53][32] = (byte)30;
	geoidSimple[53][33] = (byte)30;
	geoidSimple[53][34] = (byte)27;
	geoidSimple[53][35] = (byte)26;
	geoidSimple[53][36] = (byte)28;
	geoidSimple[53][37] = (byte)27;
	geoidSimple[53][38] = (byte)25;
	geoidSimple[53][39] = (byte)23;
	geoidSimple[53][40] = (byte)21;
	geoidSimple[53][41] = (byte)19;
	geoidSimple[53][42] = (byte)16;
	geoidSimple[53][43] = (byte)16;
	geoidSimple[53][44] = (byte)17;
	geoidSimple[53][45] = (byte)17;
	geoidSimple[53][46] = (byte)16;
	geoidSimple[53][47] = (byte)14;
	geoidSimple[53][48] = (byte)11;
	geoidSimple[53][49] = (byte)7;
	geoidSimple[53][50] = (byte)5;
	geoidSimple[53][51] = (byte)0;
	geoidSimple[53][52] = (byte)-5;
	geoidSimple[53][53] = (byte)-7;
	geoidSimple[53][54] = (byte)-7;
	geoidSimple[53][55] = (byte)-8;
	geoidSimple[53][56] = (byte)-11;
	geoidSimple[53][57] = (byte)-12;
	geoidSimple[53][58] = (byte)-14;
	geoidSimple[53][59] = (byte)-17;
	geoidSimple[53][60] = (byte)-23;
	geoidSimple[53][61] = (byte)-27;
	geoidSimple[53][62] = (byte)-29;
	geoidSimple[53][63] = (byte)-31;
	geoidSimple[53][64] = (byte)-33;
	geoidSimple[53][65] = (byte)-35;
	geoidSimple[53][66] = (byte)-37;
	geoidSimple[53][67] = (byte)-38;
	geoidSimple[53][68] = (byte)-41;
	geoidSimple[53][69] = (byte)-39;
	geoidSimple[53][70] = (byte)-32;
	geoidSimple[53][71] = (byte)-31;
	geoidSimple[53][72] = (byte)-30;
	geoidSimple[53][73] = (byte)-30;
	geoidSimple[53][74] = (byte)-31;
	geoidSimple[53][75] = (byte)-29;
	geoidSimple[53][76] = (byte)-24;
	geoidSimple[53][77] = (byte)-25;
	geoidSimple[53][78] = (byte)-29;
	geoidSimple[53][79] = (byte)-36;
	geoidSimple[53][80] = (byte)-42;
	geoidSimple[53][81] = (byte)-45;
	geoidSimple[53][82] = (byte)-43;
	geoidSimple[53][83] = (byte)-41;
	geoidSimple[53][84] = (byte)-39;
	geoidSimple[53][85] = (byte)-38;
	geoidSimple[53][86] = (byte)-38;
	geoidSimple[53][87] = (byte)-39;
	geoidSimple[53][88] = (byte)-41;
	geoidSimple[53][89] = (byte)-43;
	geoidSimple[53][90] = (byte)-44;
	geoidSimple[53][91] = (byte)-45;
	geoidSimple[53][92] = (byte)-48;
	geoidSimple[53][93] = (byte)-52;
	geoidSimple[53][94] = (byte)-54;
	geoidSimple[53][95] = (byte)-54;
	geoidSimple[53][96] = (byte)-53;
	geoidSimple[53][97] = (byte)-52;
	geoidSimple[53][98] = (byte)-48;
	geoidSimple[53][99] = (byte)-46;
	geoidSimple[53][100] = (byte)-45;
	geoidSimple[53][101] = (byte)-43;
	geoidSimple[53][102] = (byte)-43;
	geoidSimple[53][103] = (byte)-43;
	geoidSimple[53][104] = (byte)-42;
	geoidSimple[53][105] = (byte)-39;
	geoidSimple[53][106] = (byte)-37;
	geoidSimple[53][107] = (byte)-35;
	geoidSimple[53][108] = (byte)-32;
	geoidSimple[53][109] = (byte)-30;
	geoidSimple[53][110] = (byte)-28;
	geoidSimple[53][111] = (byte)-23;
	geoidSimple[53][112] = (byte)-19;
	geoidSimple[53][113] = (byte)-15;
	geoidSimple[53][114] = (byte)-16;
	geoidSimple[53][115] = (byte)-14;
	geoidSimple[53][116] = (byte)-10;
	geoidSimple[53][117] = (byte)-5;
	geoidSimple[53][118] = (byte)-1;
	geoidSimple[53][119] = (byte)2;
	geoidSimple[53][120] = (byte)5;
	geoidSimple[53][121] = (byte)8;
	geoidSimple[53][122] = (byte)11;
	geoidSimple[53][123] = (byte)14;
	geoidSimple[53][124] = (byte)16;
	geoidSimple[53][125] = (byte)19;
	geoidSimple[53][126] = (byte)22;
	geoidSimple[53][127] = (byte)24;
	geoidSimple[53][128] = (byte)27;
	geoidSimple[53][129] = (byte)28;
	geoidSimple[53][130] = (byte)27;
	geoidSimple[53][131] = (byte)28;
	geoidSimple[53][132] = (byte)30;
	geoidSimple[53][133] = (byte)32;
	geoidSimple[53][134] = (byte)32;
	geoidSimple[53][135] = (byte)33;
	geoidSimple[53][136] = (byte)36;
	geoidSimple[53][137] = (byte)39;
	geoidSimple[53][138] = (byte)41;
	geoidSimple[53][139] = (byte)42;
	geoidSimple[53][140] = (byte)40;
	geoidSimple[53][141] = (byte)31;
	geoidSimple[53][142] = (byte)19;
	geoidSimple[53][143] = (byte)16;
	geoidSimple[53][144] = (byte)21;
	geoidSimple[53][145] = (byte)22;
	geoidSimple[53][146] = (byte)21;
	geoidSimple[53][147] = (byte)19;
	geoidSimple[53][148] = (byte)17;
	geoidSimple[53][149] = (byte)15;
	geoidSimple[53][150] = (byte)13;
	geoidSimple[53][151] = (byte)10;
	geoidSimple[53][152] = (byte)9;
	geoidSimple[53][153] = (byte)7;
	geoidSimple[53][154] = (byte)5;
	geoidSimple[53][155] = (byte)3;
	geoidSimple[53][156] = (byte)2;
	geoidSimple[53][157] = (byte)1;
	geoidSimple[53][158] = (byte)1;
	geoidSimple[53][159] = (byte)0;
	geoidSimple[53][160] = (byte)-2;
	geoidSimple[53][161] = (byte)-4;
	geoidSimple[53][162] = (byte)-5;
	geoidSimple[53][163] = (byte)-6;
	geoidSimple[53][164] = (byte)-7;
	geoidSimple[53][165] = (byte)-8;
	geoidSimple[53][166] = (byte)-9;
	geoidSimple[53][167] = (byte)-9;
	geoidSimple[53][168] = (byte)-9;
	geoidSimple[53][169] = (byte)-11;
	geoidSimple[53][170] = (byte)-13;
	geoidSimple[53][171] = (byte)-11;
	geoidSimple[53][172] = (byte)-12;
	geoidSimple[53][173] = (byte)-12;
	geoidSimple[53][174] = (byte)-11;
	geoidSimple[53][175] = (byte)-10;
	geoidSimple[53][176] = (byte)-10;
	geoidSimple[53][177] = (byte)-10;
	geoidSimple[53][178] = (byte)-10;
	geoidSimple[53][179] = (byte)-11;
	geoidSimple[53][LAT_GRID_SIZE] = (byte)-11;
	geoidSimple[53][181] = (byte)-11;
	geoidSimple[53][182] = (byte)-12;
	geoidSimple[53][183] = (byte)-12;
	geoidSimple[53][184] = (byte)-12;
	geoidSimple[53][185] = (byte)-12;
	geoidSimple[53][186] = (byte)-13;
	geoidSimple[53][187] = (byte)-13;
	geoidSimple[53][188] = (byte)-13;
	geoidSimple[53][189] = (byte)-13;
	geoidSimple[53][190] = (byte)-13;
	geoidSimple[53][191] = (byte)-13;
	geoidSimple[53][192] = (byte)-13;
	geoidSimple[53][193] = (byte)-13;
	geoidSimple[53][194] = (byte)-13;
	geoidSimple[53][195] = (byte)-13;
	geoidSimple[53][196] = (byte)-13;
	geoidSimple[53][197] = (byte)-13;
	geoidSimple[53][198] = (byte)-14;
	geoidSimple[53][199] = (byte)-14;
	geoidSimple[53][200] = (byte)-15;
	geoidSimple[53][201] = (byte)-15;
	geoidSimple[53][202] = (byte)-15;
	geoidSimple[53][203] = (byte)-16;
	geoidSimple[53][204] = (byte)-17;
	geoidSimple[53][205] = (byte)-17;
	geoidSimple[53][206] = (byte)-18;
	geoidSimple[53][207] = (byte)-19;
	geoidSimple[53][208] = (byte)-20;
	geoidSimple[53][209] = (byte)-21;
	geoidSimple[53][210] = (byte)-22;
	geoidSimple[53][211] = (byte)-23;
	geoidSimple[53][212] = (byte)-24;
	geoidSimple[53][213] = (byte)-25;
	geoidSimple[53][214] = (byte)-26;
	geoidSimple[53][215] = (byte)-27;
	geoidSimple[53][216] = (byte)-29;
	geoidSimple[53][217] = (byte)-30;
	geoidSimple[53][218] = (byte)-31;
	geoidSimple[53][219] = (byte)-33;
	geoidSimple[53][220] = (byte)-34;
	geoidSimple[53][221] = (byte)-34;
	geoidSimple[53][222] = (byte)-36;
	geoidSimple[53][223] = (byte)-36;
	geoidSimple[53][224] = (byte)-37;
	geoidSimple[53][225] = (byte)-37;
	geoidSimple[53][226] = (byte)-38;
	geoidSimple[53][227] = (byte)-38;
	geoidSimple[53][228] = (byte)-39;
	geoidSimple[53][229] = (byte)-39;
	geoidSimple[53][230] = (byte)-39;
	geoidSimple[53][231] = (byte)-39;
	geoidSimple[53][232] = (byte)-39;
	geoidSimple[53][233] = (byte)-39;
	geoidSimple[53][234] = (byte)-39;
	geoidSimple[53][235] = (byte)-38;
	geoidSimple[53][236] = (byte)-37;
	geoidSimple[53][237] = (byte)-36;
	geoidSimple[53][238] = (byte)-33;
	geoidSimple[53][239] = (byte)-33;
	geoidSimple[53][240] = (byte)-32;
	geoidSimple[53][241] = (byte)-27;
	geoidSimple[53][242] = (byte)-28;
	geoidSimple[53][243] = (byte)-28;
	geoidSimple[53][244] = (byte)-27;
	geoidSimple[53][245] = (byte)-27;
	geoidSimple[53][246] = (byte)-25;
	geoidSimple[53][247] = (byte)-23;
	geoidSimple[53][248] = (byte)-23;
	geoidSimple[53][249] = (byte)-21;
	geoidSimple[53][250] = (byte)-20;
	geoidSimple[53][251] = (byte)-21;
	geoidSimple[53][252] = (byte)-20;
	geoidSimple[53][253] = (byte)-18;
	geoidSimple[53][254] = (byte)-17;
	geoidSimple[53][255] = (byte)-18;
	geoidSimple[53][256] = (byte)-20;
	geoidSimple[53][257] = (byte)-24;
	geoidSimple[53][258] = (byte)-26;
	geoidSimple[53][259] = (byte)-28;
	geoidSimple[53][260] = (byte)-28;
	geoidSimple[53][261] = (byte)-28;
	geoidSimple[53][262] = (byte)-28;
	geoidSimple[53][263] = (byte)-29;
	geoidSimple[53][264] = (byte)-30;
	geoidSimple[53][265] = (byte)-29;
	geoidSimple[53][266] = (byte)-29;
	geoidSimple[53][267] = (byte)-29;
	geoidSimple[53][268] = (byte)-30;
	geoidSimple[53][269] = (byte)-30;
	geoidSimple[53][270] = (byte)-29;
	geoidSimple[53][271] = (byte)-29;
	geoidSimple[53][272] = (byte)-30;
	geoidSimple[53][273] = (byte)-30;
	geoidSimple[53][274] = (byte)-31;
	geoidSimple[53][275] = (byte)-30;
	geoidSimple[53][276] = (byte)-31;
	geoidSimple[53][277] = (byte)-32;
	geoidSimple[53][278] = (byte)-32;
	geoidSimple[53][279] = (byte)-33;
	geoidSimple[53][280] = (byte)-33;
	geoidSimple[53][281] = (byte)-33;
	geoidSimple[53][282] = (byte)-35;
	geoidSimple[53][283] = (byte)-37;
	geoidSimple[53][284] = (byte)-39;
	geoidSimple[53][285] = (byte)-39;
	geoidSimple[53][286] = (byte)-42;
	geoidSimple[53][287] = (byte)-43;
	geoidSimple[53][288] = (byte)-43;
	geoidSimple[53][289] = (byte)-42;
	geoidSimple[53][290] = (byte)-42;
	geoidSimple[53][291] = (byte)-42;
	geoidSimple[53][292] = (byte)-41;
	geoidSimple[53][293] = (byte)-39;
	geoidSimple[53][294] = (byte)-38;
	geoidSimple[53][295] = (byte)-36;
	geoidSimple[53][296] = (byte)-35;
	geoidSimple[53][297] = (byte)-33;
	geoidSimple[53][298] = (byte)-31;
	geoidSimple[53][299] = (byte)-30;
	geoidSimple[53][300] = (byte)-28;
	geoidSimple[53][301] = (byte)-26;
	geoidSimple[53][302] = (byte)-25;
	geoidSimple[53][303] = (byte)-23;
	geoidSimple[53][304] = (byte)-21;
	geoidSimple[53][305] = (byte)-18;
	geoidSimple[53][306] = (byte)-15;
	geoidSimple[53][307] = (byte)-12;
	geoidSimple[53][308] = (byte)-9;
	geoidSimple[53][309] = (byte)-6;
	geoidSimple[53][310] = (byte)-3;
	geoidSimple[53][311] = (byte)0;
	geoidSimple[53][312] = (byte)2;
	geoidSimple[53][313] = (byte)6;
	geoidSimple[53][314] = (byte)9;
	geoidSimple[53][315] = (byte)12;
	geoidSimple[53][316] = (byte)16;
	geoidSimple[53][317] = (byte)19;
	geoidSimple[53][318] = (byte)23;
	geoidSimple[53][319] = (byte)26;
	geoidSimple[53][320] = (byte)29;
	geoidSimple[53][321] = (byte)33;
	geoidSimple[53][322] = (byte)36;
	geoidSimple[53][323] = (byte)39;
	geoidSimple[53][324] = (byte)42;
	geoidSimple[53][325] = (byte)45;
	geoidSimple[53][326] = (byte)47;
	geoidSimple[53][327] = (byte)48;
	geoidSimple[53][328] = (byte)49;
	geoidSimple[53][329] = (byte)49;
	geoidSimple[53][330] = (byte)49;
	geoidSimple[53][331] = (byte)50;
	geoidSimple[53][332] = (byte)50;
	geoidSimple[53][333] = (byte)50;
	geoidSimple[53][334] = (byte)50;
	geoidSimple[53][335] = (byte)49;
	geoidSimple[53][336] = (byte)47;
	geoidSimple[53][337] = (byte)46;
	geoidSimple[53][338] = (byte)46;
	geoidSimple[53][339] = (byte)45;
	geoidSimple[53][340] = (byte)43;
	geoidSimple[53][341] = (byte)43;
	geoidSimple[53][342] = (byte)44;
	geoidSimple[53][343] = (byte)46;
	geoidSimple[53][344] = (byte)48;
	geoidSimple[53][345] = (byte)51;
	geoidSimple[53][346] = (byte)49;
	geoidSimple[53][347] = (byte)48;
	geoidSimple[53][348] = (byte)49;
	geoidSimple[53][349] = (byte)48;
	geoidSimple[53][350] = (byte)47;
	geoidSimple[53][351] = (byte)49;
	geoidSimple[53][352] = (byte)48;
	geoidSimple[53][353] = (byte)46;
	geoidSimple[53][354] = (byte)45;
	geoidSimple[53][355] = (byte)46;
	geoidSimple[53][356] = (byte)48;
	geoidSimple[53][357] = (byte)49;
	geoidSimple[53][358] = (byte)47;
	geoidSimple[53][359] = (byte)46;
	}
		/** Row 54*/
	private static void init54() {
	geoidSimple[54][0] = (byte)48;
	geoidSimple[54][1] = (byte)47;
	geoidSimple[54][2] = (byte)46;
	geoidSimple[54][3] = (byte)44;
	geoidSimple[54][4] = (byte)41;
	geoidSimple[54][5] = (byte)40;
	geoidSimple[54][6] = (byte)41;
	geoidSimple[54][7] = (byte)41;
	geoidSimple[54][8] = (byte)41;
	geoidSimple[54][9] = (byte)39;
	geoidSimple[54][10] = (byte)38;
	geoidSimple[54][11] = (byte)38;
	geoidSimple[54][12] = (byte)38;
	geoidSimple[54][13] = (byte)36;
	geoidSimple[54][14] = (byte)35;
	geoidSimple[54][15] = (byte)35;
	geoidSimple[54][16] = (byte)30;
	geoidSimple[54][17] = (byte)28;
	geoidSimple[54][18] = (byte)28;
	geoidSimple[54][19] = (byte)24;
	geoidSimple[54][20] = (byte)18;
	geoidSimple[54][21] = (byte)13;
	geoidSimple[54][22] = (byte)10;
	geoidSimple[54][23] = (byte)18;
	geoidSimple[54][24] = (byte)25;
	geoidSimple[54][25] = (byte)27;
	geoidSimple[54][26] = (byte)22;
	geoidSimple[54][27] = (byte)16;
	geoidSimple[54][28] = (byte)9;
	geoidSimple[54][29] = (byte)10;
	geoidSimple[54][30] = (byte)10;
	geoidSimple[54][31] = (byte)13;
	geoidSimple[54][32] = (byte)23;
	geoidSimple[54][33] = (byte)26;
	geoidSimple[54][34] = (byte)24;
	geoidSimple[54][35] = (byte)22;
	geoidSimple[54][36] = (byte)26;
	geoidSimple[54][37] = (byte)26;
	geoidSimple[54][38] = (byte)24;
	geoidSimple[54][39] = (byte)22;
	geoidSimple[54][40] = (byte)20;
	geoidSimple[54][41] = (byte)17;
	geoidSimple[54][42] = (byte)14;
	geoidSimple[54][43] = (byte)11;
	geoidSimple[54][44] = (byte)10;
	geoidSimple[54][45] = (byte)11;
	geoidSimple[54][46] = (byte)13;
	geoidSimple[54][47] = (byte)13;
	geoidSimple[54][48] = (byte)11;
	geoidSimple[54][49] = (byte)8;
	geoidSimple[54][50] = (byte)4;
	geoidSimple[54][51] = (byte)2;
	geoidSimple[54][52] = (byte)0;
	geoidSimple[54][53] = (byte)-3;
	geoidSimple[54][54] = (byte)-6;
	geoidSimple[54][55] = (byte)-8;
	geoidSimple[54][56] = (byte)-11;
	geoidSimple[54][57] = (byte)-12;
	geoidSimple[54][58] = (byte)-14;
	geoidSimple[54][59] = (byte)-15;
	geoidSimple[54][60] = (byte)-18;
	geoidSimple[54][61] = (byte)-23;
	geoidSimple[54][62] = (byte)-25;
	geoidSimple[54][63] = (byte)-26;
	geoidSimple[54][64] = (byte)-25;
	geoidSimple[54][65] = (byte)-25;
	geoidSimple[54][66] = (byte)-26;
	geoidSimple[54][67] = (byte)-26;
	geoidSimple[54][68] = (byte)-30;
	geoidSimple[54][69] = (byte)-30;
	geoidSimple[54][70] = (byte)-28;
	geoidSimple[54][71] = (byte)-30;
	geoidSimple[54][72] = (byte)-30;
	geoidSimple[54][73] = (byte)-29;
	geoidSimple[54][74] = (byte)-30;
	geoidSimple[54][75] = (byte)-27;
	geoidSimple[54][76] = (byte)-24;
	geoidSimple[54][77] = (byte)-21;
	geoidSimple[54][78] = (byte)-22;
	geoidSimple[54][79] = (byte)-24;
	geoidSimple[54][80] = (byte)-27;
	geoidSimple[54][81] = (byte)-29;
	geoidSimple[54][82] = (byte)-31;
	geoidSimple[54][83] = (byte)-33;
	geoidSimple[54][84] = (byte)-34;
	geoidSimple[54][85] = (byte)-36;
	geoidSimple[54][86] = (byte)-37;
	geoidSimple[54][87] = (byte)-38;
	geoidSimple[54][88] = (byte)-39;
	geoidSimple[54][89] = (byte)-40;
	geoidSimple[54][90] = (byte)-41;
	geoidSimple[54][91] = (byte)-42;
	geoidSimple[54][92] = (byte)-43;
	geoidSimple[54][93] = (byte)-43;
	geoidSimple[54][94] = (byte)-44;
	geoidSimple[54][95] = (byte)-44;
	geoidSimple[54][96] = (byte)-44;
	geoidSimple[54][97] = (byte)-44;
	geoidSimple[54][98] = (byte)-43;
	geoidSimple[54][99] = (byte)-42;
	geoidSimple[54][100] = (byte)-43;
	geoidSimple[54][101] = (byte)-41;
	geoidSimple[54][102] = (byte)-40;
	geoidSimple[54][103] = (byte)-41;
	geoidSimple[54][104] = (byte)-40;
	geoidSimple[54][105] = (byte)-38;
	geoidSimple[54][106] = (byte)-36;
	geoidSimple[54][107] = (byte)-35;
	geoidSimple[54][108] = (byte)-33;
	geoidSimple[54][109] = (byte)-31;
	geoidSimple[54][110] = (byte)-28;
	geoidSimple[54][111] = (byte)-25;
	geoidSimple[54][112] = (byte)-20;
	geoidSimple[54][113] = (byte)-17;
	geoidSimple[54][114] = (byte)-17;
	geoidSimple[54][115] = (byte)-14;
	geoidSimple[54][116] = (byte)-9;
	geoidSimple[54][117] = (byte)-4;
	geoidSimple[54][118] = (byte)0;
	geoidSimple[54][119] = (byte)2;
	geoidSimple[54][120] = (byte)4;
	geoidSimple[54][121] = (byte)8;
	geoidSimple[54][122] = (byte)11;
	geoidSimple[54][123] = (byte)14;
	geoidSimple[54][124] = (byte)17;
	geoidSimple[54][125] = (byte)20;
	geoidSimple[54][126] = (byte)22;
	geoidSimple[54][127] = (byte)25;
	geoidSimple[54][128] = (byte)28;
	geoidSimple[54][129] = (byte)29;
	geoidSimple[54][130] = (byte)28;
	geoidSimple[54][131] = (byte)30;
	geoidSimple[54][132] = (byte)32;
	geoidSimple[54][133] = (byte)34;
	geoidSimple[54][134] = (byte)34;
	geoidSimple[54][135] = (byte)35;
	geoidSimple[54][136] = (byte)36;
	geoidSimple[54][137] = (byte)40;
	geoidSimple[54][138] = (byte)42;
	geoidSimple[54][139] = (byte)38;
	geoidSimple[54][140] = (byte)33;
	geoidSimple[54][141] = (byte)23;
	geoidSimple[54][142] = (byte)15;
	geoidSimple[54][143] = (byte)20;
	geoidSimple[54][144] = (byte)23;
	geoidSimple[54][145] = (byte)22;
	geoidSimple[54][146] = (byte)21;
	geoidSimple[54][147] = (byte)20;
	geoidSimple[54][148] = (byte)18;
	geoidSimple[54][149] = (byte)15;
	geoidSimple[54][150] = (byte)13;
	geoidSimple[54][151] = (byte)11;
	geoidSimple[54][152] = (byte)9;
	geoidSimple[54][153] = (byte)7;
	geoidSimple[54][154] = (byte)5;
	geoidSimple[54][155] = (byte)4;
	geoidSimple[54][156] = (byte)3;
	geoidSimple[54][157] = (byte)1;
	geoidSimple[54][158] = (byte)0;
	geoidSimple[54][159] = (byte)0;
	geoidSimple[54][160] = (byte)-2;
	geoidSimple[54][161] = (byte)-3;
	geoidSimple[54][162] = (byte)-5;
	geoidSimple[54][163] = (byte)-6;
	geoidSimple[54][164] = (byte)-8;
	geoidSimple[54][165] = (byte)-9;
	geoidSimple[54][166] = (byte)-9;
	geoidSimple[54][167] = (byte)-9;
	geoidSimple[54][168] = (byte)-9;
	geoidSimple[54][169] = (byte)-10;
	geoidSimple[54][170] = (byte)-11;
	geoidSimple[54][171] = (byte)-6;
	geoidSimple[54][172] = (byte)-10;
	geoidSimple[54][173] = (byte)-11;
	geoidSimple[54][174] = (byte)-10;
	geoidSimple[54][175] = (byte)-10;
	geoidSimple[54][176] = (byte)-10;
	geoidSimple[54][177] = (byte)-10;
	geoidSimple[54][178] = (byte)-10;
	geoidSimple[54][179] = (byte)-10;
	geoidSimple[54][LAT_GRID_SIZE] = (byte)-10;
	geoidSimple[54][181] = (byte)-10;
	geoidSimple[54][182] = (byte)-10;
	geoidSimple[54][183] = (byte)-11;
	geoidSimple[54][184] = (byte)-11;
	geoidSimple[54][185] = (byte)-12;
	geoidSimple[54][186] = (byte)-12;
	geoidSimple[54][187] = (byte)-13;
	geoidSimple[54][188] = (byte)-13;
	geoidSimple[54][189] = (byte)-13;
	geoidSimple[54][190] = (byte)-13;
	geoidSimple[54][191] = (byte)-13;
	geoidSimple[54][192] = (byte)-13;
	geoidSimple[54][193] = (byte)-13;
	geoidSimple[54][194] = (byte)-13;
	geoidSimple[54][195] = (byte)-13;
	geoidSimple[54][196] = (byte)-13;
	geoidSimple[54][197] = (byte)-13;
	geoidSimple[54][198] = (byte)-14;
	geoidSimple[54][199] = (byte)-14;
	geoidSimple[54][200] = (byte)-15;
	geoidSimple[54][201] = (byte)-15;
	geoidSimple[54][202] = (byte)-15;
	geoidSimple[54][203] = (byte)-16;
	geoidSimple[54][204] = (byte)-16;
	geoidSimple[54][205] = (byte)-17;
	geoidSimple[54][206] = (byte)-18;
	geoidSimple[54][207] = (byte)-19;
	geoidSimple[54][208] = (byte)-20;
	geoidSimple[54][209] = (byte)-21;
	geoidSimple[54][210] = (byte)-22;
	geoidSimple[54][211] = (byte)-22;
	geoidSimple[54][212] = (byte)-23;
	geoidSimple[54][213] = (byte)-25;
	geoidSimple[54][214] = (byte)-26;
	geoidSimple[54][215] = (byte)-27;
	geoidSimple[54][216] = (byte)-28;
	geoidSimple[54][217] = (byte)-30;
	geoidSimple[54][218] = (byte)-31;
	geoidSimple[54][219] = (byte)-32;
	geoidSimple[54][220] = (byte)-33;
	geoidSimple[54][221] = (byte)-34;
	geoidSimple[54][222] = (byte)-35;
	geoidSimple[54][223] = (byte)-36;
	geoidSimple[54][224] = (byte)-37;
	geoidSimple[54][225] = (byte)-37;
	geoidSimple[54][226] = (byte)-38;
	geoidSimple[54][227] = (byte)-39;
	geoidSimple[54][228] = (byte)-39;
	geoidSimple[54][229] = (byte)-40;
	geoidSimple[54][230] = (byte)-40;
	geoidSimple[54][231] = (byte)-40;
	geoidSimple[54][232] = (byte)-40;
	geoidSimple[54][233] = (byte)-40;
	geoidSimple[54][234] = (byte)-40;
	geoidSimple[54][235] = (byte)-39;
	geoidSimple[54][236] = (byte)-38;
	geoidSimple[54][237] = (byte)-38;
	geoidSimple[54][238] = (byte)-36;
	geoidSimple[54][239] = (byte)-34;
	geoidSimple[54][240] = (byte)-34;
	geoidSimple[54][241] = (byte)-31;
	geoidSimple[54][242] = (byte)-30;
	geoidSimple[54][243] = (byte)-30;
	geoidSimple[54][244] = (byte)-29;
	geoidSimple[54][245] = (byte)-29;
	geoidSimple[54][246] = (byte)-26;
	geoidSimple[54][247] = (byte)-24;
	geoidSimple[54][248] = (byte)-23;
	geoidSimple[54][249] = (byte)-23;
	geoidSimple[54][250] = (byte)-21;
	geoidSimple[54][251] = (byte)-21;
	geoidSimple[54][252] = (byte)-20;
	geoidSimple[54][253] = (byte)-20;
	geoidSimple[54][254] = (byte)-18;
	geoidSimple[54][255] = (byte)-20;
	geoidSimple[54][256] = (byte)-22;
	geoidSimple[54][257] = (byte)-25;
	geoidSimple[54][258] = (byte)-27;
	geoidSimple[54][259] = (byte)-28;
	geoidSimple[54][260] = (byte)-28;
	geoidSimple[54][261] = (byte)-28;
	geoidSimple[54][262] = (byte)-27;
	geoidSimple[54][263] = (byte)-28;
	geoidSimple[54][264] = (byte)-30;
	geoidSimple[54][265] = (byte)-30;
	geoidSimple[54][266] = (byte)-29;
	geoidSimple[54][267] = (byte)-29;
	geoidSimple[54][268] = (byte)-28;
	geoidSimple[54][269] = (byte)-28;
	geoidSimple[54][270] = (byte)-28;
	geoidSimple[54][271] = (byte)-29;
	geoidSimple[54][272] = (byte)-29;
	geoidSimple[54][273] = (byte)-29;
	geoidSimple[54][274] = (byte)-30;
	geoidSimple[54][275] = (byte)-31;
	geoidSimple[54][276] = (byte)-30;
	geoidSimple[54][277] = (byte)-31;
	geoidSimple[54][278] = (byte)-33;
	geoidSimple[54][279] = (byte)-32;
	geoidSimple[54][280] = (byte)-32;
	geoidSimple[54][281] = (byte)-34;
	geoidSimple[54][282] = (byte)-37;
	geoidSimple[54][283] = (byte)-38;
	geoidSimple[54][284] = (byte)-40;
	geoidSimple[54][285] = (byte)-41;
	geoidSimple[54][286] = (byte)-44;
	geoidSimple[54][287] = (byte)-45;
	geoidSimple[54][288] = (byte)-45;
	geoidSimple[54][289] = (byte)-44;
	geoidSimple[54][290] = (byte)-43;
	geoidSimple[54][291] = (byte)-43;
	geoidSimple[54][292] = (byte)-42;
	geoidSimple[54][293] = (byte)-40;
	geoidSimple[54][294] = (byte)-38;
	geoidSimple[54][295] = (byte)-37;
	geoidSimple[54][296] = (byte)-36;
	geoidSimple[54][297] = (byte)-35;
	geoidSimple[54][298] = (byte)-33;
	geoidSimple[54][299] = (byte)-31;
	geoidSimple[54][300] = (byte)-30;
	geoidSimple[54][301] = (byte)-29;
	geoidSimple[54][302] = (byte)-27;
	geoidSimple[54][303] = (byte)-25;
	geoidSimple[54][304] = (byte)-23;
	geoidSimple[54][305] = (byte)-20;
	geoidSimple[54][306] = (byte)-17;
	geoidSimple[54][307] = (byte)-15;
	geoidSimple[54][308] = (byte)-11;
	geoidSimple[54][309] = (byte)-8;
	geoidSimple[54][310] = (byte)-5;
	geoidSimple[54][311] = (byte)-2;
	geoidSimple[54][312] = (byte)1;
	geoidSimple[54][313] = (byte)4;
	geoidSimple[54][314] = (byte)8;
	geoidSimple[54][315] = (byte)11;
	geoidSimple[54][316] = (byte)14;
	geoidSimple[54][317] = (byte)18;
	geoidSimple[54][318] = (byte)22;
	geoidSimple[54][319] = (byte)25;
	geoidSimple[54][320] = (byte)28;
	geoidSimple[54][321] = (byte)32;
	geoidSimple[54][322] = (byte)35;
	geoidSimple[54][323] = (byte)38;
	geoidSimple[54][324] = (byte)41;
	geoidSimple[54][325] = (byte)43;
	geoidSimple[54][326] = (byte)44;
	geoidSimple[54][327] = (byte)45;
	geoidSimple[54][328] = (byte)46;
	geoidSimple[54][329] = (byte)46;
	geoidSimple[54][330] = (byte)47;
	geoidSimple[54][331] = (byte)47;
	geoidSimple[54][332] = (byte)47;
	geoidSimple[54][333] = (byte)46;
	geoidSimple[54][334] = (byte)46;
	geoidSimple[54][335] = (byte)45;
	geoidSimple[54][336] = (byte)44;
	geoidSimple[54][337] = (byte)43;
	geoidSimple[54][338] = (byte)42;
	geoidSimple[54][339] = (byte)41;
	geoidSimple[54][340] = (byte)41;
	geoidSimple[54][341] = (byte)42;
	geoidSimple[54][342] = (byte)44;
	geoidSimple[54][343] = (byte)46;
	geoidSimple[54][344] = (byte)48;
	geoidSimple[54][345] = (byte)46;
	geoidSimple[54][346] = (byte)45;
	geoidSimple[54][347] = (byte)46;
	geoidSimple[54][348] = (byte)45;
	geoidSimple[54][349] = (byte)43;
	geoidSimple[54][350] = (byte)43;
	geoidSimple[54][351] = (byte)43;
	geoidSimple[54][352] = (byte)41;
	geoidSimple[54][353] = (byte)40;
	geoidSimple[54][354] = (byte)41;
	geoidSimple[54][355] = (byte)43;
	geoidSimple[54][356] = (byte)47;
	geoidSimple[54][357] = (byte)48;
	geoidSimple[54][358] = (byte)48;
	geoidSimple[54][359] = (byte)48;
	}
		/** Row 55*/
	private static void init55() {
	geoidSimple[55][0] = (byte)48;
	geoidSimple[55][1] = (byte)47;
	geoidSimple[55][2] = (byte)45;
	geoidSimple[55][3] = (byte)42;
	geoidSimple[55][4] = (byte)39;
	geoidSimple[55][5] = (byte)34;
	geoidSimple[55][6] = (byte)32;
	geoidSimple[55][7] = (byte)33;
	geoidSimple[55][8] = (byte)34;
	geoidSimple[55][9] = (byte)35;
	geoidSimple[55][10] = (byte)35;
	geoidSimple[55][11] = (byte)35;
	geoidSimple[55][12] = (byte)35;
	geoidSimple[55][13] = (byte)34;
	geoidSimple[55][14] = (byte)33;
	geoidSimple[55][15] = (byte)33;
	geoidSimple[55][16] = (byte)31;
	geoidSimple[55][17] = (byte)28;
	geoidSimple[55][18] = (byte)27;
	geoidSimple[55][19] = (byte)25;
	geoidSimple[55][20] = (byte)22;
	geoidSimple[55][21] = (byte)17;
	geoidSimple[55][22] = (byte)12;
	geoidSimple[55][23] = (byte)10;
	geoidSimple[55][24] = (byte)13;
	geoidSimple[55][25] = (byte)14;
	geoidSimple[55][26] = (byte)8;
	geoidSimple[55][27] = (byte)4;
	geoidSimple[55][28] = (byte)3;
	geoidSimple[55][29] = (byte)5;
	geoidSimple[55][30] = (byte)6;
	geoidSimple[55][31] = (byte)9;
	geoidSimple[55][32] = (byte)17;
	geoidSimple[55][33] = (byte)21;
	geoidSimple[55][34] = (byte)19;
	geoidSimple[55][35] = (byte)20;
	geoidSimple[55][36] = (byte)26;
	geoidSimple[55][37] = (byte)25;
	geoidSimple[55][38] = (byte)22;
	geoidSimple[55][39] = (byte)19;
	geoidSimple[55][40] = (byte)17;
	geoidSimple[55][41] = (byte)14;
	geoidSimple[55][42] = (byte)10;
	geoidSimple[55][43] = (byte)6;
	geoidSimple[55][44] = (byte)3;
	geoidSimple[55][45] = (byte)4;
	geoidSimple[55][46] = (byte)8;
	geoidSimple[55][47] = (byte)8;
	geoidSimple[55][48] = (byte)8;
	geoidSimple[55][49] = (byte)7;
	geoidSimple[55][50] = (byte)4;
	geoidSimple[55][51] = (byte)0;
	geoidSimple[55][52] = (byte)-2;
	geoidSimple[55][53] = (byte)-5;
	geoidSimple[55][54] = (byte)-7;
	geoidSimple[55][55] = (byte)-9;
	geoidSimple[55][56] = (byte)-11;
	geoidSimple[55][57] = (byte)-12;
	geoidSimple[55][58] = (byte)-14;
	geoidSimple[55][59] = (byte)-16;
	geoidSimple[55][60] = (byte)-18;
	geoidSimple[55][61] = (byte)-21;
	geoidSimple[55][62] = (byte)-21;
	geoidSimple[55][63] = (byte)-21;
	geoidSimple[55][64] = (byte)-21;
	geoidSimple[55][65] = (byte)-21;
	geoidSimple[55][66] = (byte)-22;
	geoidSimple[55][67] = (byte)-22;
	geoidSimple[55][68] = (byte)-25;
	geoidSimple[55][69] = (byte)-31;
	geoidSimple[55][70] = (byte)-36;
	geoidSimple[55][71] = (byte)-41;
	geoidSimple[55][72] = (byte)-41;
	geoidSimple[55][73] = (byte)-36;
	geoidSimple[55][74] = (byte)-33;
	geoidSimple[55][75] = (byte)-27;
	geoidSimple[55][76] = (byte)-25;
	geoidSimple[55][77] = (byte)-23;
	geoidSimple[55][78] = (byte)-21;
	geoidSimple[55][79] = (byte)-23;
	geoidSimple[55][80] = (byte)-25;
	geoidSimple[55][81] = (byte)-27;
	geoidSimple[55][82] = (byte)-29;
	geoidSimple[55][83] = (byte)-31;
	geoidSimple[55][84] = (byte)-33;
	geoidSimple[55][85] = (byte)-34;
	geoidSimple[55][86] = (byte)-35;
	geoidSimple[55][87] = (byte)-37;
	geoidSimple[55][88] = (byte)-38;
	geoidSimple[55][89] = (byte)-39;
	geoidSimple[55][90] = (byte)-39;
	geoidSimple[55][91] = (byte)-40;
	geoidSimple[55][92] = (byte)-41;
	geoidSimple[55][93] = (byte)-41;
	geoidSimple[55][94] = (byte)-41;
	geoidSimple[55][95] = (byte)-41;
	geoidSimple[55][96] = (byte)-41;
	geoidSimple[55][97] = (byte)-40;
	geoidSimple[55][98] = (byte)-39;
	geoidSimple[55][99] = (byte)-38;
	geoidSimple[55][100] = (byte)-37;
	geoidSimple[55][101] = (byte)-37;
	geoidSimple[55][102] = (byte)-37;
	geoidSimple[55][103] = (byte)-37;
	geoidSimple[55][104] = (byte)-38;
	geoidSimple[55][105] = (byte)-39;
	geoidSimple[55][106] = (byte)-37;
	geoidSimple[55][107] = (byte)-36;
	geoidSimple[55][108] = (byte)-35;
	geoidSimple[55][109] = (byte)-33;
	geoidSimple[55][110] = (byte)-28;
	geoidSimple[55][111] = (byte)-24;
	geoidSimple[55][112] = (byte)-22;
	geoidSimple[55][113] = (byte)-20;
	geoidSimple[55][114] = (byte)-17;
	geoidSimple[55][115] = (byte)-13;
	geoidSimple[55][116] = (byte)-9;
	geoidSimple[55][117] = (byte)-5;
	geoidSimple[55][118] = (byte)-1;
	geoidSimple[55][119] = (byte)2;
	geoidSimple[55][120] = (byte)5;
	geoidSimple[55][121] = (byte)9;
	geoidSimple[55][122] = (byte)12;
	geoidSimple[55][123] = (byte)15;
	geoidSimple[55][124] = (byte)18;
	geoidSimple[55][125] = (byte)21;
	geoidSimple[55][126] = (byte)23;
	geoidSimple[55][127] = (byte)26;
	geoidSimple[55][128] = (byte)28;
	geoidSimple[55][129] = (byte)29;
	geoidSimple[55][130] = (byte)30;
	geoidSimple[55][131] = (byte)31;
	geoidSimple[55][132] = (byte)33;
	geoidSimple[55][133] = (byte)34;
	geoidSimple[55][134] = (byte)35;
	geoidSimple[55][135] = (byte)37;
	geoidSimple[55][136] = (byte)37;
	geoidSimple[55][137] = (byte)38;
	geoidSimple[55][138] = (byte)39;
	geoidSimple[55][139] = (byte)38;
	geoidSimple[55][140] = (byte)30;
	geoidSimple[55][141] = (byte)15;
	geoidSimple[55][142] = (byte)15;
	geoidSimple[55][143] = (byte)23;
	geoidSimple[55][144] = (byte)25;
	geoidSimple[55][145] = (byte)23;
	geoidSimple[55][146] = (byte)22;
	geoidSimple[55][147] = (byte)20;
	geoidSimple[55][148] = (byte)18;
	geoidSimple[55][149] = (byte)16;
	geoidSimple[55][150] = (byte)14;
	geoidSimple[55][151] = (byte)11;
	geoidSimple[55][152] = (byte)9;
	geoidSimple[55][153] = (byte)7;
	geoidSimple[55][154] = (byte)6;
	geoidSimple[55][155] = (byte)4;
	geoidSimple[55][156] = (byte)3;
	geoidSimple[55][157] = (byte)2;
	geoidSimple[55][158] = (byte)1;
	geoidSimple[55][159] = (byte)0;
	geoidSimple[55][160] = (byte)-1;
	geoidSimple[55][161] = (byte)-3;
	geoidSimple[55][162] = (byte)-5;
	geoidSimple[55][163] = (byte)-7;
	geoidSimple[55][164] = (byte)-8;
	geoidSimple[55][165] = (byte)-8;
	geoidSimple[55][166] = (byte)-9;
	geoidSimple[55][167] = (byte)-9;
	geoidSimple[55][168] = (byte)-9;
	geoidSimple[55][169] = (byte)-10;
	geoidSimple[55][170] = (byte)-12;
	geoidSimple[55][171] = (byte)-7;
	geoidSimple[55][172] = (byte)-9;
	geoidSimple[55][173] = (byte)-10;
	geoidSimple[55][174] = (byte)-9;
	geoidSimple[55][175] = (byte)-9;
	geoidSimple[55][176] = (byte)-9;
	geoidSimple[55][177] = (byte)-9;
	geoidSimple[55][178] = (byte)-9;
	geoidSimple[55][179] = (byte)-9;
	geoidSimple[55][LAT_GRID_SIZE] = (byte)-9;
	geoidSimple[55][181] = (byte)-9;
	geoidSimple[55][182] = (byte)-9;
	geoidSimple[55][183] = (byte)-9;
	geoidSimple[55][184] = (byte)-11;
	geoidSimple[55][185] = (byte)-11;
	geoidSimple[55][186] = (byte)-12;
	geoidSimple[55][187] = (byte)-12;
	geoidSimple[55][188] = (byte)-12;
	geoidSimple[55][189] = (byte)-13;
	geoidSimple[55][190] = (byte)-13;
	geoidSimple[55][191] = (byte)-12;
	geoidSimple[55][192] = (byte)-12;
	geoidSimple[55][193] = (byte)-12;
	geoidSimple[55][194] = (byte)-12;
	geoidSimple[55][195] = (byte)-12;
	geoidSimple[55][196] = (byte)-13;
	geoidSimple[55][197] = (byte)-13;
	geoidSimple[55][198] = (byte)-13;
	geoidSimple[55][199] = (byte)-14;
	geoidSimple[55][200] = (byte)-14;
	geoidSimple[55][201] = (byte)-15;
	geoidSimple[55][202] = (byte)-15;
	geoidSimple[55][203] = (byte)-16;
	geoidSimple[55][204] = (byte)-16;
	geoidSimple[55][205] = (byte)-16;
	geoidSimple[55][206] = (byte)-17;
	geoidSimple[55][207] = (byte)-18;
	geoidSimple[55][208] = (byte)-19;
	geoidSimple[55][209] = (byte)-20;
	geoidSimple[55][210] = (byte)-21;
	geoidSimple[55][211] = (byte)-22;
	geoidSimple[55][212] = (byte)-23;
	geoidSimple[55][213] = (byte)-24;
	geoidSimple[55][214] = (byte)-25;
	geoidSimple[55][215] = (byte)-27;
	geoidSimple[55][216] = (byte)-28;
	geoidSimple[55][217] = (byte)-29;
	geoidSimple[55][218] = (byte)-30;
	geoidSimple[55][219] = (byte)-31;
	geoidSimple[55][220] = (byte)-32;
	geoidSimple[55][221] = (byte)-33;
	geoidSimple[55][222] = (byte)-34;
	geoidSimple[55][223] = (byte)-35;
	geoidSimple[55][224] = (byte)-36;
	geoidSimple[55][225] = (byte)-37;
	geoidSimple[55][226] = (byte)-38;
	geoidSimple[55][227] = (byte)-39;
	geoidSimple[55][228] = (byte)-40;
	geoidSimple[55][229] = (byte)-40;
	geoidSimple[55][230] = (byte)-40;
	geoidSimple[55][231] = (byte)-40;
	geoidSimple[55][232] = (byte)-41;
	geoidSimple[55][233] = (byte)-41;
	geoidSimple[55][234] = (byte)-41;
	geoidSimple[55][235] = (byte)-40;
	geoidSimple[55][236] = (byte)-40;
	geoidSimple[55][237] = (byte)-39;
	geoidSimple[55][238] = (byte)-38;
	geoidSimple[55][239] = (byte)-36;
	geoidSimple[55][240] = (byte)-34;
	geoidSimple[55][241] = (byte)-33;
	geoidSimple[55][242] = (byte)-32;
	geoidSimple[55][243] = (byte)-31;
	geoidSimple[55][244] = (byte)-31;
	geoidSimple[55][245] = (byte)-31;
	geoidSimple[55][246] = (byte)-29;
	geoidSimple[55][247] = (byte)-27;
	geoidSimple[55][248] = (byte)-25;
	geoidSimple[55][249] = (byte)-24;
	geoidSimple[55][250] = (byte)-24;
	geoidSimple[55][251] = (byte)-22;
	geoidSimple[55][252] = (byte)-21;
	geoidSimple[55][253] = (byte)-21;
	geoidSimple[55][254] = (byte)-20;
	geoidSimple[55][255] = (byte)-23;
	geoidSimple[55][256] = (byte)-24;
	geoidSimple[55][257] = (byte)-25;
	geoidSimple[55][258] = (byte)-27;
	geoidSimple[55][259] = (byte)-28;
	geoidSimple[55][260] = (byte)-28;
	geoidSimple[55][261] = (byte)-27;
	geoidSimple[55][262] = (byte)-26;
	geoidSimple[55][263] = (byte)-27;
	geoidSimple[55][264] = (byte)-31;
	geoidSimple[55][265] = (byte)-31;
	geoidSimple[55][266] = (byte)-29;
	geoidSimple[55][267] = (byte)-28;
	geoidSimple[55][268] = (byte)-27;
	geoidSimple[55][269] = (byte)-27;
	geoidSimple[55][270] = (byte)-28;
	geoidSimple[55][271] = (byte)-28;
	geoidSimple[55][272] = (byte)-27;
	geoidSimple[55][273] = (byte)-29;
	geoidSimple[55][274] = (byte)-30;
	geoidSimple[55][275] = (byte)-30;
	geoidSimple[55][276] = (byte)-30;
	geoidSimple[55][277] = (byte)-31;
	geoidSimple[55][278] = (byte)-32;
	geoidSimple[55][279] = (byte)-32;
	geoidSimple[55][280] = (byte)-33;
	geoidSimple[55][281] = (byte)-36;
	geoidSimple[55][282] = (byte)-38;
	geoidSimple[55][283] = (byte)-39;
	geoidSimple[55][284] = (byte)-41;
	geoidSimple[55][285] = (byte)-45;
	geoidSimple[55][286] = (byte)-46;
	geoidSimple[55][287] = (byte)-47;
	geoidSimple[55][288] = (byte)-46;
	geoidSimple[55][289] = (byte)-46;
	geoidSimple[55][290] = (byte)-45;
	geoidSimple[55][291] = (byte)-44;
	geoidSimple[55][292] = (byte)-43;
	geoidSimple[55][293] = (byte)-42;
	geoidSimple[55][294] = (byte)-40;
	geoidSimple[55][295] = (byte)-38;
	geoidSimple[55][296] = (byte)-37;
	geoidSimple[55][297] = (byte)-35;
	geoidSimple[55][298] = (byte)-34;
	geoidSimple[55][299] = (byte)-32;
	geoidSimple[55][300] = (byte)-31;
	geoidSimple[55][301] = (byte)-30;
	geoidSimple[55][302] = (byte)-29;
	geoidSimple[55][303] = (byte)-27;
	geoidSimple[55][304] = (byte)-25;
	geoidSimple[55][305] = (byte)-22;
	geoidSimple[55][306] = (byte)-19;
	geoidSimple[55][307] = (byte)-17;
	geoidSimple[55][308] = (byte)-14;
	geoidSimple[55][309] = (byte)-10;
	geoidSimple[55][310] = (byte)-6;
	geoidSimple[55][311] = (byte)-3;
	geoidSimple[55][312] = (byte)0;
	geoidSimple[55][313] = (byte)3;
	geoidSimple[55][314] = (byte)6;
	geoidSimple[55][315] = (byte)10;
	geoidSimple[55][316] = (byte)13;
	geoidSimple[55][317] = (byte)17;
	geoidSimple[55][318] = (byte)20;
	geoidSimple[55][319] = (byte)24;
	geoidSimple[55][320] = (byte)27;
	geoidSimple[55][321] = (byte)31;
	geoidSimple[55][322] = (byte)34;
	geoidSimple[55][323] = (byte)37;
	geoidSimple[55][324] = (byte)38;
	geoidSimple[55][325] = (byte)40;
	geoidSimple[55][326] = (byte)41;
	geoidSimple[55][327] = (byte)42;
	geoidSimple[55][328] = (byte)42;
	geoidSimple[55][329] = (byte)43;
	geoidSimple[55][330] = (byte)43;
	geoidSimple[55][331] = (byte)44;
	geoidSimple[55][332] = (byte)44;
	geoidSimple[55][333] = (byte)42;
	geoidSimple[55][334] = (byte)41;
	geoidSimple[55][335] = (byte)40;
	geoidSimple[55][336] = (byte)40;
	geoidSimple[55][337] = (byte)39;
	geoidSimple[55][338] = (byte)39;
	geoidSimple[55][339] = (byte)40;
	geoidSimple[55][340] = (byte)41;
	geoidSimple[55][341] = (byte)42;
	geoidSimple[55][342] = (byte)44;
	geoidSimple[55][343] = (byte)46;
	geoidSimple[55][344] = (byte)46;
	geoidSimple[55][345] = (byte)45;
	geoidSimple[55][346] = (byte)45;
	geoidSimple[55][347] = (byte)45;
	geoidSimple[55][348] = (byte)43;
	geoidSimple[55][349] = (byte)41;
	geoidSimple[55][350] = (byte)40;
	geoidSimple[55][351] = (byte)39;
	geoidSimple[55][352] = (byte)40;
	geoidSimple[55][353] = (byte)41;
	geoidSimple[55][354] = (byte)41;
	geoidSimple[55][355] = (byte)45;
	geoidSimple[55][356] = (byte)49;
	geoidSimple[55][357] = (byte)50;
	geoidSimple[55][358] = (byte)50;
	geoidSimple[55][359] = (byte)50;
	}
		/** Row 56*/
	private static void init56() {
	geoidSimple[56][0] = (byte)46;
	geoidSimple[56][1] = (byte)44;
	geoidSimple[56][2] = (byte)42;
	geoidSimple[56][3] = (byte)39;
	geoidSimple[56][4] = (byte)36;
	geoidSimple[56][5] = (byte)32;
	geoidSimple[56][6] = (byte)29;
	geoidSimple[56][7] = (byte)29;
	geoidSimple[56][8] = (byte)29;
	geoidSimple[56][9] = (byte)31;
	geoidSimple[56][10] = (byte)33;
	geoidSimple[56][11] = (byte)33;
	geoidSimple[56][12] = (byte)32;
	geoidSimple[56][13] = (byte)32;
	geoidSimple[56][14] = (byte)31;
	geoidSimple[56][15] = (byte)30;
	geoidSimple[56][16] = (byte)29;
	geoidSimple[56][17] = (byte)27;
	geoidSimple[56][18] = (byte)27;
	geoidSimple[56][19] = (byte)26;
	geoidSimple[56][20] = (byte)25;
	geoidSimple[56][21] = (byte)23;
	geoidSimple[56][22] = (byte)20;
	geoidSimple[56][23] = (byte)14;
	geoidSimple[56][24] = (byte)9;
	geoidSimple[56][25] = (byte)7;
	geoidSimple[56][26] = (byte)4;
	geoidSimple[56][27] = (byte)2;
	geoidSimple[56][28] = (byte)4;
	geoidSimple[56][29] = (byte)7;
	geoidSimple[56][30] = (byte)9;
	geoidSimple[56][31] = (byte)12;
	geoidSimple[56][32] = (byte)14;
	geoidSimple[56][33] = (byte)14;
	geoidSimple[56][34] = (byte)16;
	geoidSimple[56][35] = (byte)22;
	geoidSimple[56][36] = (byte)26;
	geoidSimple[56][37] = (byte)23;
	geoidSimple[56][38] = (byte)20;
	geoidSimple[56][39] = (byte)18;
	geoidSimple[56][40] = (byte)16;
	geoidSimple[56][41] = (byte)12;
	geoidSimple[56][42] = (byte)7;
	geoidSimple[56][43] = (byte)2;
	geoidSimple[56][44] = (byte)0;
	geoidSimple[56][45] = (byte)0;
	geoidSimple[56][46] = (byte)2;
	geoidSimple[56][47] = (byte)2;
	geoidSimple[56][48] = (byte)3;
	geoidSimple[56][49] = (byte)5;
	geoidSimple[56][50] = (byte)5;
	geoidSimple[56][51] = (byte)3;
	geoidSimple[56][52] = (byte)0;
	geoidSimple[56][53] = (byte)-2;
	geoidSimple[56][54] = (byte)-4;
	geoidSimple[56][55] = (byte)-7;
	geoidSimple[56][56] = (byte)-9;
	geoidSimple[56][57] = (byte)-11;
	geoidSimple[56][58] = (byte)-12;
	geoidSimple[56][59] = (byte)-13;
	geoidSimple[56][60] = (byte)-17;
	geoidSimple[56][61] = (byte)-20;
	geoidSimple[56][62] = (byte)-20;
	geoidSimple[56][63] = (byte)-19;
	geoidSimple[56][64] = (byte)-20;
	geoidSimple[56][65] = (byte)-21;
	geoidSimple[56][66] = (byte)-22;
	geoidSimple[56][67] = (byte)-22;
	geoidSimple[56][68] = (byte)-25;
	geoidSimple[56][69] = (byte)-30;
	geoidSimple[56][70] = (byte)-38;
	geoidSimple[56][71] = (byte)-45;
	geoidSimple[56][72] = (byte)-47;
	geoidSimple[56][73] = (byte)-44;
	geoidSimple[56][74] = (byte)-37;
	geoidSimple[56][75] = (byte)-31;
	geoidSimple[56][76] = (byte)-25;
	geoidSimple[56][77] = (byte)-23;
	geoidSimple[56][78] = (byte)-22;
	geoidSimple[56][79] = (byte)-24;
	geoidSimple[56][80] = (byte)-26;
	geoidSimple[56][81] = (byte)-27;
	geoidSimple[56][82] = (byte)-29;
	geoidSimple[56][83] = (byte)-30;
	geoidSimple[56][84] = (byte)-32;
	geoidSimple[56][85] = (byte)-33;
	geoidSimple[56][86] = (byte)-34;
	geoidSimple[56][87] = (byte)-35;
	geoidSimple[56][88] = (byte)-36;
	geoidSimple[56][89] = (byte)-37;
	geoidSimple[56][90] = (byte)-38;
	geoidSimple[56][91] = (byte)-38;
	geoidSimple[56][92] = (byte)-39;
	geoidSimple[56][93] = (byte)-40;
	geoidSimple[56][94] = (byte)-40;
	geoidSimple[56][95] = (byte)-40;
	geoidSimple[56][96] = (byte)-40;
	geoidSimple[56][97] = (byte)-39;
	geoidSimple[56][98] = (byte)-37;
	geoidSimple[56][99] = (byte)-36;
	geoidSimple[56][100] = (byte)-35;
	geoidSimple[56][101] = (byte)-34;
	geoidSimple[56][102] = (byte)-35;
	geoidSimple[56][103] = (byte)-34;
	geoidSimple[56][104] = (byte)-36;
	geoidSimple[56][105] = (byte)-38;
	geoidSimple[56][106] = (byte)-37;
	geoidSimple[56][107] = (byte)-35;
	geoidSimple[56][108] = (byte)-32;
	geoidSimple[56][109] = (byte)-30;
	geoidSimple[56][110] = (byte)-27;
	geoidSimple[56][111] = (byte)-24;
	geoidSimple[56][112] = (byte)-21;
	geoidSimple[56][113] = (byte)-20;
	geoidSimple[56][114] = (byte)-17;
	geoidSimple[56][115] = (byte)-13;
	geoidSimple[56][116] = (byte)-9;
	geoidSimple[56][117] = (byte)-5;
	geoidSimple[56][118] = (byte)-1;
	geoidSimple[56][119] = (byte)2;
	geoidSimple[56][120] = (byte)5;
	geoidSimple[56][121] = (byte)8;
	geoidSimple[56][122] = (byte)12;
	geoidSimple[56][123] = (byte)15;
	geoidSimple[56][124] = (byte)18;
	geoidSimple[56][125] = (byte)22;
	geoidSimple[56][126] = (byte)24;
	geoidSimple[56][127] = (byte)26;
	geoidSimple[56][128] = (byte)28;
	geoidSimple[56][129] = (byte)30;
	geoidSimple[56][130] = (byte)32;
	geoidSimple[56][131] = (byte)32;
	geoidSimple[56][132] = (byte)32;
	geoidSimple[56][133] = (byte)35;
	geoidSimple[56][134] = (byte)36;
	geoidSimple[56][135] = (byte)36;
	geoidSimple[56][136] = (byte)36;
	geoidSimple[56][137] = (byte)35;
	geoidSimple[56][138] = (byte)38;
	geoidSimple[56][139] = (byte)40;
	geoidSimple[56][140] = (byte)38;
	geoidSimple[56][141] = (byte)20;
	geoidSimple[56][142] = (byte)15;
	geoidSimple[56][143] = (byte)25;
	geoidSimple[56][144] = (byte)26;
	geoidSimple[56][145] = (byte)25;
	geoidSimple[56][146] = (byte)23;
	geoidSimple[56][147] = (byte)21;
	geoidSimple[56][148] = (byte)18;
	geoidSimple[56][149] = (byte)16;
	geoidSimple[56][150] = (byte)15;
	geoidSimple[56][151] = (byte)13;
	geoidSimple[56][152] = (byte)10;
	geoidSimple[56][153] = (byte)8;
	geoidSimple[56][154] = (byte)7;
	geoidSimple[56][155] = (byte)5;
	geoidSimple[56][156] = (byte)4;
	geoidSimple[56][157] = (byte)4;
	geoidSimple[56][158] = (byte)3;
	geoidSimple[56][159] = (byte)1;
	geoidSimple[56][160] = (byte)0;
	geoidSimple[56][161] = (byte)-2;
	geoidSimple[56][162] = (byte)-5;
	geoidSimple[56][163] = (byte)-6;
	geoidSimple[56][164] = (byte)-7;
	geoidSimple[56][165] = (byte)-8;
	geoidSimple[56][166] = (byte)-9;
	geoidSimple[56][167] = (byte)-9;
	geoidSimple[56][168] = (byte)-9;
	geoidSimple[56][169] = (byte)-10;
	geoidSimple[56][170] = (byte)-11;
	geoidSimple[56][171] = (byte)-8;
	geoidSimple[56][172] = (byte)-9;
	geoidSimple[56][173] = (byte)-10;
	geoidSimple[56][174] = (byte)-8;
	geoidSimple[56][175] = (byte)-8;
	geoidSimple[56][176] = (byte)-8;
	geoidSimple[56][177] = (byte)-8;
	geoidSimple[56][178] = (byte)-8;
	geoidSimple[56][179] = (byte)-8;
	geoidSimple[56][LAT_GRID_SIZE] = (byte)-9;
	geoidSimple[56][181] = (byte)-10;
	geoidSimple[56][182] = (byte)-10;
	geoidSimple[56][183] = (byte)-10;
	geoidSimple[56][184] = (byte)-10;
	geoidSimple[56][185] = (byte)-11;
	geoidSimple[56][186] = (byte)-11;
	geoidSimple[56][187] = (byte)-11;
	geoidSimple[56][188] = (byte)-11;
	geoidSimple[56][189] = (byte)-12;
	geoidSimple[56][190] = (byte)-12;
	geoidSimple[56][191] = (byte)-11;
	geoidSimple[56][192] = (byte)-11;
	geoidSimple[56][193] = (byte)-11;
	geoidSimple[56][194] = (byte)-11;
	geoidSimple[56][195] = (byte)-11;
	geoidSimple[56][196] = (byte)-12;
	geoidSimple[56][197] = (byte)-12;
	geoidSimple[56][198] = (byte)-12;
	geoidSimple[56][199] = (byte)-13;
	geoidSimple[56][200] = (byte)-14;
	geoidSimple[56][201] = (byte)-14;
	geoidSimple[56][202] = (byte)-14;
	geoidSimple[56][203] = (byte)-15;
	geoidSimple[56][204] = (byte)-15;
	geoidSimple[56][205] = (byte)-15;
	geoidSimple[56][206] = (byte)-16;
	geoidSimple[56][207] = (byte)-17;
	geoidSimple[56][208] = (byte)-18;
	geoidSimple[56][209] = (byte)-19;
	geoidSimple[56][210] = (byte)-21;
	geoidSimple[56][211] = (byte)-22;
	geoidSimple[56][212] = (byte)-23;
	geoidSimple[56][213] = (byte)-24;
	geoidSimple[56][214] = (byte)-25;
	geoidSimple[56][215] = (byte)-26;
	geoidSimple[56][216] = (byte)-27;
	geoidSimple[56][217] = (byte)-28;
	geoidSimple[56][218] = (byte)-29;
	geoidSimple[56][219] = (byte)-30;
	geoidSimple[56][220] = (byte)-31;
	geoidSimple[56][221] = (byte)-32;
	geoidSimple[56][222] = (byte)-33;
	geoidSimple[56][223] = (byte)-34;
	geoidSimple[56][224] = (byte)-35;
	geoidSimple[56][225] = (byte)-36;
	geoidSimple[56][226] = (byte)-38;
	geoidSimple[56][227] = (byte)-39;
	geoidSimple[56][228] = (byte)-39;
	geoidSimple[56][229] = (byte)-40;
	geoidSimple[56][230] = (byte)-40;
	geoidSimple[56][231] = (byte)-40;
	geoidSimple[56][232] = (byte)-41;
	geoidSimple[56][233] = (byte)-41;
	geoidSimple[56][234] = (byte)-41;
	geoidSimple[56][235] = (byte)-41;
	geoidSimple[56][236] = (byte)-41;
	geoidSimple[56][237] = (byte)-40;
	geoidSimple[56][238] = (byte)-39;
	geoidSimple[56][239] = (byte)-38;
	geoidSimple[56][240] = (byte)-37;
	geoidSimple[56][241] = (byte)-37;
	geoidSimple[56][242] = (byte)-34;
	geoidSimple[56][243] = (byte)-32;
	geoidSimple[56][244] = (byte)-33;
	geoidSimple[56][245] = (byte)-32;
	geoidSimple[56][246] = (byte)-31;
	geoidSimple[56][247] = (byte)-30;
	geoidSimple[56][248] = (byte)-29;
	geoidSimple[56][249] = (byte)-27;
	geoidSimple[56][250] = (byte)-24;
	geoidSimple[56][251] = (byte)-23;
	geoidSimple[56][252] = (byte)-23;
	geoidSimple[56][253] = (byte)-23;
	geoidSimple[56][254] = (byte)-21;
	geoidSimple[56][255] = (byte)-23;
	geoidSimple[56][256] = (byte)-23;
	geoidSimple[56][257] = (byte)-24;
	geoidSimple[56][258] = (byte)-26;
	geoidSimple[56][259] = (byte)-28;
	geoidSimple[56][260] = (byte)-29;
	geoidSimple[56][261] = (byte)-29;
	geoidSimple[56][262] = (byte)-27;
	geoidSimple[56][263] = (byte)-27;
	geoidSimple[56][264] = (byte)-28;
	geoidSimple[56][265] = (byte)-28;
	geoidSimple[56][266] = (byte)-28;
	geoidSimple[56][267] = (byte)-27;
	geoidSimple[56][268] = (byte)-27;
	geoidSimple[56][269] = (byte)-27;
	geoidSimple[56][270] = (byte)-27;
	geoidSimple[56][271] = (byte)-28;
	geoidSimple[56][272] = (byte)-29;
	geoidSimple[56][273] = (byte)-29;
	geoidSimple[56][274] = (byte)-30;
	geoidSimple[56][275] = (byte)-30;
	geoidSimple[56][276] = (byte)-29;
	geoidSimple[56][277] = (byte)-30;
	geoidSimple[56][278] = (byte)-31;
	geoidSimple[56][279] = (byte)-33;
	geoidSimple[56][280] = (byte)-34;
	geoidSimple[56][281] = (byte)-37;
	geoidSimple[56][282] = (byte)-39;
	geoidSimple[56][283] = (byte)-40;
	geoidSimple[56][284] = (byte)-44;
	geoidSimple[56][285] = (byte)-47;
	geoidSimple[56][286] = (byte)-48;
	geoidSimple[56][287] = (byte)-49;
	geoidSimple[56][288] = (byte)-49;
	geoidSimple[56][289] = (byte)-48;
	geoidSimple[56][290] = (byte)-47;
	geoidSimple[56][291] = (byte)-46;
	geoidSimple[56][292] = (byte)-44;
	geoidSimple[56][293] = (byte)-43;
	geoidSimple[56][294] = (byte)-41;
	geoidSimple[56][295] = (byte)-39;
	geoidSimple[56][296] = (byte)-37;
	geoidSimple[56][297] = (byte)-36;
	geoidSimple[56][298] = (byte)-35;
	geoidSimple[56][299] = (byte)-34;
	geoidSimple[56][300] = (byte)-33;
	geoidSimple[56][301] = (byte)-31;
	geoidSimple[56][302] = (byte)-30;
	geoidSimple[56][303] = (byte)-29;
	geoidSimple[56][304] = (byte)-27;
	geoidSimple[56][305] = (byte)-25;
	geoidSimple[56][306] = (byte)-22;
	geoidSimple[56][307] = (byte)-19;
	geoidSimple[56][308] = (byte)-15;
	geoidSimple[56][309] = (byte)-12;
	geoidSimple[56][310] = (byte)-9;
	geoidSimple[56][311] = (byte)-5;
	geoidSimple[56][312] = (byte)-2;
	geoidSimple[56][313] = (byte)1;
	geoidSimple[56][314] = (byte)5;
	geoidSimple[56][315] = (byte)8;
	geoidSimple[56][316] = (byte)12;
	geoidSimple[56][317] = (byte)15;
	geoidSimple[56][318] = (byte)19;
	geoidSimple[56][319] = (byte)23;
	geoidSimple[56][320] = (byte)26;
	geoidSimple[56][321] = (byte)30;
	geoidSimple[56][322] = (byte)32;
	geoidSimple[56][323] = (byte)34;
	geoidSimple[56][324] = (byte)35;
	geoidSimple[56][325] = (byte)37;
	geoidSimple[56][326] = (byte)38;
	geoidSimple[56][327] = (byte)39;
	geoidSimple[56][328] = (byte)39;
	geoidSimple[56][329] = (byte)40;
	geoidSimple[56][330] = (byte)41;
	geoidSimple[56][331] = (byte)41;
	geoidSimple[56][332] = (byte)40;
	geoidSimple[56][333] = (byte)40;
	geoidSimple[56][334] = (byte)38;
	geoidSimple[56][335] = (byte)37;
	geoidSimple[56][336] = (byte)36;
	geoidSimple[56][337] = (byte)36;
	geoidSimple[56][338] = (byte)36;
	geoidSimple[56][339] = (byte)38;
	geoidSimple[56][340] = (byte)40;
	geoidSimple[56][341] = (byte)43;
	geoidSimple[56][342] = (byte)44;
	geoidSimple[56][343] = (byte)45;
	geoidSimple[56][344] = (byte)45;
	geoidSimple[56][345] = (byte)44;
	geoidSimple[56][346] = (byte)41;
	geoidSimple[56][347] = (byte)41;
	geoidSimple[56][348] = (byte)40;
	geoidSimple[56][349] = (byte)39;
	geoidSimple[56][350] = (byte)38;
	geoidSimple[56][351] = (byte)42;
	geoidSimple[56][352] = (byte)46;
	geoidSimple[56][353] = (byte)48;
	geoidSimple[56][354] = (byte)50;
	geoidSimple[56][355] = (byte)52;
	geoidSimple[56][356] = (byte)52;
	geoidSimple[56][357] = (byte)51;
	geoidSimple[56][358] = (byte)50;
	geoidSimple[56][359] = (byte)48;
	}
		/** Row 57*/
	private static void init57() {
	geoidSimple[57][0] = (byte)41;
	geoidSimple[57][1] = (byte)39;
	geoidSimple[57][2] = (byte)38;
	geoidSimple[57][3] = (byte)36;
	geoidSimple[57][4] = (byte)33;
	geoidSimple[57][5] = (byte)30;
	geoidSimple[57][6] = (byte)29;
	geoidSimple[57][7] = (byte)28;
	geoidSimple[57][8] = (byte)29;
	geoidSimple[57][9] = (byte)31;
	geoidSimple[57][10] = (byte)32;
	geoidSimple[57][11] = (byte)32;
	geoidSimple[57][12] = (byte)32;
	geoidSimple[57][13] = (byte)32;
	geoidSimple[57][14] = (byte)31;
	geoidSimple[57][15] = (byte)29;
	geoidSimple[57][16] = (byte)28;
	geoidSimple[57][17] = (byte)27;
	geoidSimple[57][18] = (byte)26;
	geoidSimple[57][19] = (byte)27;
	geoidSimple[57][20] = (byte)29;
	geoidSimple[57][21] = (byte)30;
	geoidSimple[57][22] = (byte)27;
	geoidSimple[57][23] = (byte)21;
	geoidSimple[57][24] = (byte)15;
	geoidSimple[57][25] = (byte)10;
	geoidSimple[57][26] = (byte)8;
	geoidSimple[57][27] = (byte)8;
	geoidSimple[57][28] = (byte)9;
	geoidSimple[57][29] = (byte)11;
	geoidSimple[57][30] = (byte)14;
	geoidSimple[57][31] = (byte)16;
	geoidSimple[57][32] = (byte)16;
	geoidSimple[57][33] = (byte)16;
	geoidSimple[57][34] = (byte)16;
	geoidSimple[57][35] = (byte)21;
	geoidSimple[57][36] = (byte)22;
	geoidSimple[57][37] = (byte)21;
	geoidSimple[57][38] = (byte)19;
	geoidSimple[57][39] = (byte)17;
	geoidSimple[57][40] = (byte)14;
	geoidSimple[57][41] = (byte)10;
	geoidSimple[57][42] = (byte)5;
	geoidSimple[57][43] = (byte)1;
	geoidSimple[57][44] = (byte)-3;
	geoidSimple[57][45] = (byte)-6;
	geoidSimple[57][46] = (byte)-7;
	geoidSimple[57][47] = (byte)-7;
	geoidSimple[57][48] = (byte)-7;
	geoidSimple[57][49] = (byte)-2;
	geoidSimple[57][50] = (byte)2;
	geoidSimple[57][51] = (byte)0;
	geoidSimple[57][52] = (byte)0;
	geoidSimple[57][53] = (byte)-1;
	geoidSimple[57][54] = (byte)-4;
	geoidSimple[57][55] = (byte)-5;
	geoidSimple[57][56] = (byte)-8;
	geoidSimple[57][57] = (byte)-10;
	geoidSimple[57][58] = (byte)-12;
	geoidSimple[57][59] = (byte)-12;
	geoidSimple[57][60] = (byte)-15;
	geoidSimple[57][61] = (byte)-19;
	geoidSimple[57][62] = (byte)-20;
	geoidSimple[57][63] = (byte)-21;
	geoidSimple[57][64] = (byte)-22;
	geoidSimple[57][65] = (byte)-23;
	geoidSimple[57][66] = (byte)-23;
	geoidSimple[57][67] = (byte)-24;
	geoidSimple[57][68] = (byte)-27;
	geoidSimple[57][69] = (byte)-32;
	geoidSimple[57][70] = (byte)-41;
	geoidSimple[57][71] = (byte)-45;
	geoidSimple[57][72] = (byte)-45;
	geoidSimple[57][73] = (byte)-45;
	geoidSimple[57][74] = (byte)-45;
	geoidSimple[57][75] = (byte)-42;
	geoidSimple[57][76] = (byte)-35;
	geoidSimple[57][77] = (byte)-26;
	geoidSimple[57][78] = (byte)-23;
	geoidSimple[57][79] = (byte)-24;
	geoidSimple[57][80] = (byte)-25;
	geoidSimple[57][81] = (byte)-27;
	geoidSimple[57][82] = (byte)-29;
	geoidSimple[57][83] = (byte)-30;
	geoidSimple[57][84] = (byte)-31;
	geoidSimple[57][85] = (byte)-32;
	geoidSimple[57][86] = (byte)-33;
	geoidSimple[57][87] = (byte)-34;
	geoidSimple[57][88] = (byte)-35;
	geoidSimple[57][89] = (byte)-37;
	geoidSimple[57][90] = (byte)-37;
	geoidSimple[57][91] = (byte)-37;
	geoidSimple[57][92] = (byte)-37;
	geoidSimple[57][93] = (byte)-38;
	geoidSimple[57][94] = (byte)-39;
	geoidSimple[57][95] = (byte)-39;
	geoidSimple[57][96] = (byte)-40;
	geoidSimple[57][97] = (byte)-38;
	geoidSimple[57][98] = (byte)-36;
	geoidSimple[57][99] = (byte)-34;
	geoidSimple[57][100] = (byte)-33;
	geoidSimple[57][101] = (byte)-33;
	geoidSimple[57][102] = (byte)-33;
	geoidSimple[57][103] = (byte)-32;
	geoidSimple[57][104] = (byte)-36;
	geoidSimple[57][105] = (byte)-39;
	geoidSimple[57][106] = (byte)-37;
	geoidSimple[57][107] = (byte)-35;
	geoidSimple[57][108] = (byte)-32;
	geoidSimple[57][109] = (byte)-29;
	geoidSimple[57][110] = (byte)-27;
	geoidSimple[57][111] = (byte)-25;
	geoidSimple[57][112] = (byte)-22;
	geoidSimple[57][113] = (byte)-19;
	geoidSimple[57][114] = (byte)-16;
	geoidSimple[57][115] = (byte)-13;
	geoidSimple[57][116] = (byte)-8;
	geoidSimple[57][117] = (byte)-4;
	geoidSimple[57][118] = (byte)0;
	geoidSimple[57][119] = (byte)2;
	geoidSimple[57][120] = (byte)6;
	geoidSimple[57][121] = (byte)9;
	geoidSimple[57][122] = (byte)12;
	geoidSimple[57][123] = (byte)16;
	geoidSimple[57][124] = (byte)18;
	geoidSimple[57][125] = (byte)21;
	geoidSimple[57][126] = (byte)24;
	geoidSimple[57][127] = (byte)26;
	geoidSimple[57][128] = (byte)29;
	geoidSimple[57][129] = (byte)31;
	geoidSimple[57][130] = (byte)32;
	geoidSimple[57][131] = (byte)31;
	geoidSimple[57][132] = (byte)30;
	geoidSimple[57][133] = (byte)33;
	geoidSimple[57][134] = (byte)33;
	geoidSimple[57][135] = (byte)33;
	geoidSimple[57][136] = (byte)34;
	geoidSimple[57][137] = (byte)36;
	geoidSimple[57][138] = (byte)39;
	geoidSimple[57][139] = (byte)42;
	geoidSimple[57][140] = (byte)39;
	geoidSimple[57][141] = (byte)26;
	geoidSimple[57][142] = (byte)17;
	geoidSimple[57][143] = (byte)26;
	geoidSimple[57][144] = (byte)28;
	geoidSimple[57][145] = (byte)27;
	geoidSimple[57][146] = (byte)25;
	geoidSimple[57][147] = (byte)22;
	geoidSimple[57][148] = (byte)20;
	geoidSimple[57][149] = (byte)17;
	geoidSimple[57][150] = (byte)15;
	geoidSimple[57][151] = (byte)14;
	geoidSimple[57][152] = (byte)12;
	geoidSimple[57][153] = (byte)10;
	geoidSimple[57][154] = (byte)9;
	geoidSimple[57][155] = (byte)7;
	geoidSimple[57][156] = (byte)6;
	geoidSimple[57][157] = (byte)5;
	geoidSimple[57][158] = (byte)4;
	geoidSimple[57][159] = (byte)2;
	geoidSimple[57][160] = (byte)0;
	geoidSimple[57][161] = (byte)-2;
	geoidSimple[57][162] = (byte)-4;
	geoidSimple[57][163] = (byte)-5;
	geoidSimple[57][164] = (byte)-7;
	geoidSimple[57][165] = (byte)-7;
	geoidSimple[57][166] = (byte)-8;
	geoidSimple[57][167] = (byte)-8;
	geoidSimple[57][168] = (byte)-8;
	geoidSimple[57][169] = (byte)-9;
	geoidSimple[57][170] = (byte)-9;
	geoidSimple[57][171] = (byte)-9;
	geoidSimple[57][172] = (byte)-6;
	geoidSimple[57][173] = (byte)-8;
	geoidSimple[57][174] = (byte)-9;
	geoidSimple[57][175] = (byte)-9;
	geoidSimple[57][176] = (byte)-9;
	geoidSimple[57][177] = (byte)-9;
	geoidSimple[57][178] = (byte)-9;
	geoidSimple[57][179] = (byte)-9;
	geoidSimple[57][LAT_GRID_SIZE] = (byte)-9;
	geoidSimple[57][181] = (byte)-9;
	geoidSimple[57][182] = (byte)-9;
	geoidSimple[57][183] = (byte)-10;
	geoidSimple[57][184] = (byte)-9;
	geoidSimple[57][185] = (byte)-10;
	geoidSimple[57][186] = (byte)-10;
	geoidSimple[57][187] = (byte)-10;
	geoidSimple[57][188] = (byte)-10;
	geoidSimple[57][189] = (byte)-10;
	geoidSimple[57][190] = (byte)-10;
	geoidSimple[57][191] = (byte)-10;
	geoidSimple[57][192] = (byte)-10;
	geoidSimple[57][193] = (byte)-10;
	geoidSimple[57][194] = (byte)-10;
	geoidSimple[57][195] = (byte)-10;
	geoidSimple[57][196] = (byte)-10;
	geoidSimple[57][197] = (byte)-10;
	geoidSimple[57][198] = (byte)-11;
	geoidSimple[57][199] = (byte)-12;
	geoidSimple[57][200] = (byte)-12;
	geoidSimple[57][201] = (byte)-13;
	geoidSimple[57][202] = (byte)-14;
	geoidSimple[57][203] = (byte)-14;
	geoidSimple[57][204] = (byte)-14;
	geoidSimple[57][205] = (byte)-14;
	geoidSimple[57][206] = (byte)-15;
	geoidSimple[57][207] = (byte)-15;
	geoidSimple[57][208] = (byte)-16;
	geoidSimple[57][209] = (byte)-18;
	geoidSimple[57][210] = (byte)-19;
	geoidSimple[57][211] = (byte)-21;
	geoidSimple[57][212] = (byte)-22;
	geoidSimple[57][213] = (byte)-23;
	geoidSimple[57][214] = (byte)-24;
	geoidSimple[57][215] = (byte)-26;
	geoidSimple[57][216] = (byte)-26;
	geoidSimple[57][217] = (byte)-27;
	geoidSimple[57][218] = (byte)-28;
	geoidSimple[57][219] = (byte)-29;
	geoidSimple[57][220] = (byte)-30;
	geoidSimple[57][221] = (byte)-31;
	geoidSimple[57][222] = (byte)-32;
	geoidSimple[57][223] = (byte)-33;
	geoidSimple[57][224] = (byte)-35;
	geoidSimple[57][225] = (byte)-36;
	geoidSimple[57][226] = (byte)-37;
	geoidSimple[57][227] = (byte)-38;
	geoidSimple[57][228] = (byte)-39;
	geoidSimple[57][229] = (byte)-39;
	geoidSimple[57][230] = (byte)-40;
	geoidSimple[57][231] = (byte)-40;
	geoidSimple[57][232] = (byte)-40;
	geoidSimple[57][233] = (byte)-41;
	geoidSimple[57][234] = (byte)-41;
	geoidSimple[57][235] = (byte)-41;
	geoidSimple[57][236] = (byte)-41;
	geoidSimple[57][237] = (byte)-41;
	geoidSimple[57][238] = (byte)-40;
	geoidSimple[57][239] = (byte)-40;
	geoidSimple[57][240] = (byte)-38;
	geoidSimple[57][241] = (byte)-38;
	geoidSimple[57][242] = (byte)-36;
	geoidSimple[57][243] = (byte)-33;
	geoidSimple[57][244] = (byte)-34;
	geoidSimple[57][245] = (byte)-34;
	geoidSimple[57][246] = (byte)-32;
	geoidSimple[57][247] = (byte)-31;
	geoidSimple[57][248] = (byte)-30;
	geoidSimple[57][249] = (byte)-28;
	geoidSimple[57][250] = (byte)-27;
	geoidSimple[57][251] = (byte)-25;
	geoidSimple[57][252] = (byte)-24;
	geoidSimple[57][253] = (byte)-24;
	geoidSimple[57][254] = (byte)-22;
	geoidSimple[57][255] = (byte)-23;
	geoidSimple[57][256] = (byte)-23;
	geoidSimple[57][257] = (byte)-23;
	geoidSimple[57][258] = (byte)-26;
	geoidSimple[57][259] = (byte)-28;
	geoidSimple[57][260] = (byte)-29;
	geoidSimple[57][261] = (byte)-29;
	geoidSimple[57][262] = (byte)-29;
	geoidSimple[57][263] = (byte)-27;
	geoidSimple[57][264] = (byte)-27;
	geoidSimple[57][265] = (byte)-27;
	geoidSimple[57][266] = (byte)-27;
	geoidSimple[57][267] = (byte)-26;
	geoidSimple[57][268] = (byte)-27;
	geoidSimple[57][269] = (byte)-27;
	geoidSimple[57][270] = (byte)-28;
	geoidSimple[57][271] = (byte)-29;
	geoidSimple[57][272] = (byte)-29;
	geoidSimple[57][273] = (byte)-29;
	geoidSimple[57][274] = (byte)-29;
	geoidSimple[57][275] = (byte)-28;
	geoidSimple[57][276] = (byte)-28;
	geoidSimple[57][277] = (byte)-29;
	geoidSimple[57][278] = (byte)-31;
	geoidSimple[57][279] = (byte)-33;
	geoidSimple[57][280] = (byte)-35;
	geoidSimple[57][281] = (byte)-37;
	geoidSimple[57][282] = (byte)-39;
	geoidSimple[57][283] = (byte)-41;
	geoidSimple[57][284] = (byte)-45;
	geoidSimple[57][285] = (byte)-48;
	geoidSimple[57][286] = (byte)-50;
	geoidSimple[57][287] = (byte)-51;
	geoidSimple[57][288] = (byte)-50;
	geoidSimple[57][289] = (byte)-49;
	geoidSimple[57][290] = (byte)-48;
	geoidSimple[57][291] = (byte)-47;
	geoidSimple[57][292] = (byte)-45;
	geoidSimple[57][293] = (byte)-43;
	geoidSimple[57][294] = (byte)-41;
	geoidSimple[57][295] = (byte)-36;
	geoidSimple[57][296] = (byte)-38;
	geoidSimple[57][297] = (byte)-37;
	geoidSimple[57][298] = (byte)-36;
	geoidSimple[57][299] = (byte)-35;
	geoidSimple[57][300] = (byte)-35;
	geoidSimple[57][301] = (byte)-34;
	geoidSimple[57][302] = (byte)-32;
	geoidSimple[57][303] = (byte)-31;
	geoidSimple[57][304] = (byte)-29;
	geoidSimple[57][305] = (byte)-26;
	geoidSimple[57][306] = (byte)-24;
	geoidSimple[57][307] = (byte)-21;
	geoidSimple[57][308] = (byte)-18;
	geoidSimple[57][309] = (byte)-15;
	geoidSimple[57][310] = (byte)-11;
	geoidSimple[57][311] = (byte)-7;
	geoidSimple[57][312] = (byte)-4;
	geoidSimple[57][313] = (byte)0;
	geoidSimple[57][314] = (byte)3;
	geoidSimple[57][315] = (byte)7;
	geoidSimple[57][316] = (byte)10;
	geoidSimple[57][317] = (byte)14;
	geoidSimple[57][318] = (byte)18;
	geoidSimple[57][319] = (byte)22;
	geoidSimple[57][320] = (byte)25;
	geoidSimple[57][321] = (byte)27;
	geoidSimple[57][322] = (byte)29;
	geoidSimple[57][323] = (byte)31;
	geoidSimple[57][324] = (byte)32;
	geoidSimple[57][325] = (byte)33;
	geoidSimple[57][326] = (byte)35;
	geoidSimple[57][327] = (byte)36;
	geoidSimple[57][328] = (byte)37;
	geoidSimple[57][329] = (byte)37;
	geoidSimple[57][330] = (byte)37;
	geoidSimple[57][331] = (byte)37;
	geoidSimple[57][332] = (byte)37;
	geoidSimple[57][333] = (byte)36;
	geoidSimple[57][334] = (byte)36;
	geoidSimple[57][335] = (byte)35;
	geoidSimple[57][336] = (byte)34;
	geoidSimple[57][337] = (byte)34;
	geoidSimple[57][338] = (byte)35;
	geoidSimple[57][339] = (byte)37;
	geoidSimple[57][340] = (byte)40;
	geoidSimple[57][341] = (byte)42;
	geoidSimple[57][342] = (byte)44;
	geoidSimple[57][343] = (byte)45;
	geoidSimple[57][344] = (byte)42;
	geoidSimple[57][345] = (byte)41;
	geoidSimple[57][346] = (byte)41;
	geoidSimple[57][347] = (byte)42;
	geoidSimple[57][348] = (byte)42;
	geoidSimple[57][349] = (byte)41;
	geoidSimple[57][350] = (byte)44;
	geoidSimple[57][351] = (byte)47;
	geoidSimple[57][352] = (byte)49;
	geoidSimple[57][353] = (byte)50;
	geoidSimple[57][354] = (byte)54;
	geoidSimple[57][355] = (byte)54;
	geoidSimple[57][356] = (byte)51;
	geoidSimple[57][357] = (byte)49;
	geoidSimple[57][358] = (byte)48;
	geoidSimple[57][359] = (byte)45;
	}
		/** Row 58*/
	private static void init58() {
	geoidSimple[58][0] = (byte)39;
	geoidSimple[58][1] = (byte)37;
	geoidSimple[58][2] = (byte)36;
	geoidSimple[58][3] = (byte)33;
	geoidSimple[58][4] = (byte)30;
	geoidSimple[58][5] = (byte)28;
	geoidSimple[58][6] = (byte)27;
	geoidSimple[58][7] = (byte)27;
	geoidSimple[58][8] = (byte)28;
	geoidSimple[58][9] = (byte)29;
	geoidSimple[58][10] = (byte)31;
	geoidSimple[58][11] = (byte)32;
	geoidSimple[58][12] = (byte)32;
	geoidSimple[58][13] = (byte)31;
	geoidSimple[58][14] = (byte)30;
	geoidSimple[58][15] = (byte)29;
	geoidSimple[58][16] = (byte)27;
	geoidSimple[58][17] = (byte)27;
	geoidSimple[58][18] = (byte)26;
	geoidSimple[58][19] = (byte)27;
	geoidSimple[58][20] = (byte)28;
	geoidSimple[58][21] = (byte)27;
	geoidSimple[58][22] = (byte)25;
	geoidSimple[58][23] = (byte)23;
	geoidSimple[58][24] = (byte)21;
	geoidSimple[58][25] = (byte)19;
	geoidSimple[58][26] = (byte)16;
	geoidSimple[58][27] = (byte)14;
	geoidSimple[58][28] = (byte)12;
	geoidSimple[58][29] = (byte)14;
	geoidSimple[58][30] = (byte)17;
	geoidSimple[58][31] = (byte)18;
	geoidSimple[58][32] = (byte)17;
	geoidSimple[58][33] = (byte)17;
	geoidSimple[58][34] = (byte)17;
	geoidSimple[58][35] = (byte)19;
	geoidSimple[58][36] = (byte)19;
	geoidSimple[58][37] = (byte)18;
	geoidSimple[58][38] = (byte)17;
	geoidSimple[58][39] = (byte)15;
	geoidSimple[58][40] = (byte)13;
	geoidSimple[58][41] = (byte)8;
	geoidSimple[58][42] = (byte)4;
	geoidSimple[58][43] = (byte)0;
	geoidSimple[58][44] = (byte)-3;
	geoidSimple[58][45] = (byte)-8;
	geoidSimple[58][46] = (byte)-11;
	geoidSimple[58][47] = (byte)-14;
	geoidSimple[58][48] = (byte)-14;
	geoidSimple[58][49] = (byte)-11;
	geoidSimple[58][50] = (byte)-4;
	geoidSimple[58][51] = (byte)-2;
	geoidSimple[58][52] = (byte)-2;
	geoidSimple[58][53] = (byte)-2;
	geoidSimple[58][54] = (byte)-3;
	geoidSimple[58][55] = (byte)-5;
	geoidSimple[58][56] = (byte)-7;
	geoidSimple[58][57] = (byte)-11;
	geoidSimple[58][58] = (byte)-12;
	geoidSimple[58][59] = (byte)-12;
	geoidSimple[58][60] = (byte)-15;
	geoidSimple[58][61] = (byte)-19;
	geoidSimple[58][62] = (byte)-21;
	geoidSimple[58][63] = (byte)-22;
	geoidSimple[58][64] = (byte)-24;
	geoidSimple[58][65] = (byte)-24;
	geoidSimple[58][66] = (byte)-25;
	geoidSimple[58][67] = (byte)-25;
	geoidSimple[58][68] = (byte)-28;
	geoidSimple[58][69] = (byte)-33;
	geoidSimple[58][70] = (byte)-42;
	geoidSimple[58][71] = (byte)-45;
	geoidSimple[58][72] = (byte)-43;
	geoidSimple[58][73] = (byte)-43;
	geoidSimple[58][74] = (byte)-44;
	geoidSimple[58][75] = (byte)-47;
	geoidSimple[58][76] = (byte)-45;
	geoidSimple[58][77] = (byte)-35;
	geoidSimple[58][78] = (byte)-28;
	geoidSimple[58][79] = (byte)-24;
	geoidSimple[58][80] = (byte)-24;
	geoidSimple[58][81] = (byte)-26;
	geoidSimple[58][82] = (byte)-28;
	geoidSimple[58][83] = (byte)-29;
	geoidSimple[58][84] = (byte)-30;
	geoidSimple[58][85] = (byte)-30;
	geoidSimple[58][86] = (byte)-31;
	geoidSimple[58][87] = (byte)-33;
	geoidSimple[58][88] = (byte)-35;
	geoidSimple[58][89] = (byte)-36;
	geoidSimple[58][90] = (byte)-36;
	geoidSimple[58][91] = (byte)-36;
	geoidSimple[58][92] = (byte)-37;
	geoidSimple[58][93] = (byte)-37;
	geoidSimple[58][94] = (byte)-37;
	geoidSimple[58][95] = (byte)-38;
	geoidSimple[58][96] = (byte)-38;
	geoidSimple[58][97] = (byte)-37;
	geoidSimple[58][98] = (byte)-35;
	geoidSimple[58][99] = (byte)-33;
	geoidSimple[58][100] = (byte)-32;
	geoidSimple[58][101] = (byte)-31;
	geoidSimple[58][102] = (byte)-31;
	geoidSimple[58][103] = (byte)-32;
	geoidSimple[58][104] = (byte)-39;
	geoidSimple[58][105] = (byte)-41;
	geoidSimple[58][106] = (byte)-40;
	geoidSimple[58][107] = (byte)-37;
	geoidSimple[58][108] = (byte)-32;
	geoidSimple[58][109] = (byte)-27;
	geoidSimple[58][110] = (byte)-23;
	geoidSimple[58][111] = (byte)-22;
	geoidSimple[58][112] = (byte)-22;
	geoidSimple[58][113] = (byte)-18;
	geoidSimple[58][114] = (byte)-15;
	geoidSimple[58][115] = (byte)-10;
	geoidSimple[58][116] = (byte)-7;
	geoidSimple[58][117] = (byte)-3;
	geoidSimple[58][118] = (byte)0;
	geoidSimple[58][119] = (byte)3;
	geoidSimple[58][120] = (byte)6;
	geoidSimple[58][121] = (byte)10;
	geoidSimple[58][122] = (byte)13;
	geoidSimple[58][123] = (byte)16;
	geoidSimple[58][124] = (byte)19;
	geoidSimple[58][125] = (byte)22;
	geoidSimple[58][126] = (byte)24;
	geoidSimple[58][127] = (byte)27;
	geoidSimple[58][128] = (byte)29;
	geoidSimple[58][129] = (byte)30;
	geoidSimple[58][130] = (byte)31;
	geoidSimple[58][131] = (byte)28;
	geoidSimple[58][132] = (byte)27;
	geoidSimple[58][133] = (byte)31;
	geoidSimple[58][134] = (byte)32;
	geoidSimple[58][135] = (byte)35;
	geoidSimple[58][136] = (byte)36;
	geoidSimple[58][137] = (byte)38;
	geoidSimple[58][138] = (byte)39;
	geoidSimple[58][139] = (byte)42;
	geoidSimple[58][140] = (byte)39;
	geoidSimple[58][141] = (byte)28;
	geoidSimple[58][142] = (byte)18;
	geoidSimple[58][143] = (byte)26;
	geoidSimple[58][144] = (byte)28;
	geoidSimple[58][145] = (byte)27;
	geoidSimple[58][146] = (byte)25;
	geoidSimple[58][147] = (byte)23;
	geoidSimple[58][148] = (byte)21;
	geoidSimple[58][149] = (byte)18;
	geoidSimple[58][150] = (byte)16;
	geoidSimple[58][151] = (byte)15;
	geoidSimple[58][152] = (byte)13;
	geoidSimple[58][153] = (byte)11;
	geoidSimple[58][154] = (byte)10;
	geoidSimple[58][155] = (byte)8;
	geoidSimple[58][156] = (byte)7;
	geoidSimple[58][157] = (byte)6;
	geoidSimple[58][158] = (byte)5;
	geoidSimple[58][159] = (byte)3;
	geoidSimple[58][160] = (byte)1;
	geoidSimple[58][161] = (byte)0;
	geoidSimple[58][162] = (byte)-2;
	geoidSimple[58][163] = (byte)-4;
	geoidSimple[58][164] = (byte)-5;
	geoidSimple[58][165] = (byte)-6;
	geoidSimple[58][166] = (byte)-7;
	geoidSimple[58][167] = (byte)-8;
	geoidSimple[58][168] = (byte)-8;
	geoidSimple[58][169] = (byte)-8;
	geoidSimple[58][170] = (byte)-8;
	geoidSimple[58][171] = (byte)-9;
	geoidSimple[58][172] = (byte)-8;
	geoidSimple[58][173] = (byte)-7;
	geoidSimple[58][174] = (byte)-8;
	geoidSimple[58][175] = (byte)-8;
	geoidSimple[58][176] = (byte)-8;
	geoidSimple[58][177] = (byte)-8;
	geoidSimple[58][178] = (byte)-8;
	geoidSimple[58][179] = (byte)-8;
	geoidSimple[58][LAT_GRID_SIZE] = (byte)-8;
	geoidSimple[58][181] = (byte)-9;
	geoidSimple[58][182] = (byte)-8;
	geoidSimple[58][183] = (byte)-8;
	geoidSimple[58][184] = (byte)-9;
	geoidSimple[58][185] = (byte)-8;
	geoidSimple[58][186] = (byte)-9;
	geoidSimple[58][187] = (byte)-9;
	geoidSimple[58][188] = (byte)-8;
	geoidSimple[58][189] = (byte)-9;
	geoidSimple[58][190] = (byte)-9;
	geoidSimple[58][191] = (byte)-9;
	geoidSimple[58][192] = (byte)-9;
	geoidSimple[58][193] = (byte)-9;
	geoidSimple[58][194] = (byte)-9;
	geoidSimple[58][195] = (byte)-9;
	geoidSimple[58][196] = (byte)-8;
	geoidSimple[58][197] = (byte)-8;
	geoidSimple[58][198] = (byte)-9;
	geoidSimple[58][199] = (byte)-10;
	geoidSimple[58][200] = (byte)-11;
	geoidSimple[58][201] = (byte)-12;
	geoidSimple[58][202] = (byte)-13;
	geoidSimple[58][203] = (byte)-13;
	geoidSimple[58][204] = (byte)-13;
	geoidSimple[58][205] = (byte)-13;
	geoidSimple[58][206] = (byte)-13;
	geoidSimple[58][207] = (byte)-14;
	geoidSimple[58][208] = (byte)-15;
	geoidSimple[58][209] = (byte)-16;
	geoidSimple[58][210] = (byte)-18;
	geoidSimple[58][211] = (byte)-19;
	geoidSimple[58][212] = (byte)-20;
	geoidSimple[58][213] = (byte)-22;
	geoidSimple[58][214] = (byte)-23;
	geoidSimple[58][215] = (byte)-25;
	geoidSimple[58][216] = (byte)-26;
	geoidSimple[58][217] = (byte)-27;
	geoidSimple[58][218] = (byte)-27;
	geoidSimple[58][219] = (byte)-28;
	geoidSimple[58][220] = (byte)-29;
	geoidSimple[58][221] = (byte)-30;
	geoidSimple[58][222] = (byte)-31;
	geoidSimple[58][223] = (byte)-33;
	geoidSimple[58][224] = (byte)-34;
	geoidSimple[58][225] = (byte)-35;
	geoidSimple[58][226] = (byte)-36;
	geoidSimple[58][227] = (byte)-37;
	geoidSimple[58][228] = (byte)-38;
	geoidSimple[58][229] = (byte)-39;
	geoidSimple[58][230] = (byte)-40;
	geoidSimple[58][231] = (byte)-40;
	geoidSimple[58][232] = (byte)-41;
	geoidSimple[58][233] = (byte)-41;
	geoidSimple[58][234] = (byte)-41;
	geoidSimple[58][235] = (byte)-41;
	geoidSimple[58][236] = (byte)-41;
	geoidSimple[58][237] = (byte)-41;
	geoidSimple[58][238] = (byte)-41;
	geoidSimple[58][239] = (byte)-41;
	geoidSimple[58][240] = (byte)-40;
	geoidSimple[58][241] = (byte)-39;
	geoidSimple[58][242] = (byte)-38;
	geoidSimple[58][243] = (byte)-35;
	geoidSimple[58][244] = (byte)-33;
	geoidSimple[58][245] = (byte)-35;
	geoidSimple[58][246] = (byte)-34;
	geoidSimple[58][247] = (byte)-32;
	geoidSimple[58][248] = (byte)-30;
	geoidSimple[58][249] = (byte)-29;
	geoidSimple[58][250] = (byte)-27;
	geoidSimple[58][251] = (byte)-26;
	geoidSimple[58][252] = (byte)-25;
	geoidSimple[58][253] = (byte)-24;
	geoidSimple[58][254] = (byte)-23;
	geoidSimple[58][255] = (byte)-24;
	geoidSimple[58][256] = (byte)-25;
	geoidSimple[58][257] = (byte)-24;
	geoidSimple[58][258] = (byte)-25;
	geoidSimple[58][259] = (byte)-25;
	geoidSimple[58][260] = (byte)-26;
	geoidSimple[58][261] = (byte)-27;
	geoidSimple[58][262] = (byte)-28;
	geoidSimple[58][263] = (byte)-26;
	geoidSimple[58][264] = (byte)-27;
	geoidSimple[58][265] = (byte)-27;
	geoidSimple[58][266] = (byte)-27;
	geoidSimple[58][267] = (byte)-27;
	geoidSimple[58][268] = (byte)-27;
	geoidSimple[58][269] = (byte)-27;
	geoidSimple[58][270] = (byte)-27;
	geoidSimple[58][271] = (byte)-28;
	geoidSimple[58][272] = (byte)-28;
	geoidSimple[58][273] = (byte)-28;
	geoidSimple[58][274] = (byte)-27;
	geoidSimple[58][275] = (byte)-27;
	geoidSimple[58][276] = (byte)-28;
	geoidSimple[58][277] = (byte)-29;
	geoidSimple[58][278] = (byte)-31;
	geoidSimple[58][279] = (byte)-32;
	geoidSimple[58][280] = (byte)-35;
	geoidSimple[58][281] = (byte)-37;
	geoidSimple[58][282] = (byte)-39;
	geoidSimple[58][283] = (byte)-42;
	geoidSimple[58][284] = (byte)-43;
	geoidSimple[58][285] = (byte)-46;
	geoidSimple[58][286] = (byte)-50;
	geoidSimple[58][287] = (byte)-51;
	geoidSimple[58][288] = (byte)-51;
	geoidSimple[58][289] = (byte)-50;
	geoidSimple[58][290] = (byte)-49;
	geoidSimple[58][291] = (byte)-48;
	geoidSimple[58][292] = (byte)-46;
	geoidSimple[58][293] = (byte)-44;
	geoidSimple[58][294] = (byte)-42;
	geoidSimple[58][295] = (byte)-40;
	geoidSimple[58][296] = (byte)-40;
	geoidSimple[58][297] = (byte)-38;
	geoidSimple[58][298] = (byte)-37;
	geoidSimple[58][299] = (byte)-37;
	geoidSimple[58][300] = (byte)-37;
	geoidSimple[58][301] = (byte)-36;
	geoidSimple[58][302] = (byte)-34;
	geoidSimple[58][303] = (byte)-33;
	geoidSimple[58][304] = (byte)-31;
	geoidSimple[58][305] = (byte)-28;
	geoidSimple[58][306] = (byte)-26;
	geoidSimple[58][307] = (byte)-23;
	geoidSimple[58][308] = (byte)-20;
	geoidSimple[58][309] = (byte)-16;
	geoidSimple[58][310] = (byte)-13;
	geoidSimple[58][311] = (byte)-9;
	geoidSimple[58][312] = (byte)-6;
	geoidSimple[58][313] = (byte)-2;
	geoidSimple[58][314] = (byte)1;
	geoidSimple[58][315] = (byte)5;
	geoidSimple[58][316] = (byte)9;
	geoidSimple[58][317] = (byte)12;
	geoidSimple[58][318] = (byte)16;
	geoidSimple[58][319] = (byte)20;
	geoidSimple[58][320] = (byte)22;
	geoidSimple[58][321] = (byte)24;
	geoidSimple[58][322] = (byte)26;
	geoidSimple[58][323] = (byte)27;
	geoidSimple[58][324] = (byte)29;
	geoidSimple[58][325] = (byte)30;
	geoidSimple[58][326] = (byte)31;
	geoidSimple[58][327] = (byte)32;
	geoidSimple[58][328] = (byte)33;
	geoidSimple[58][329] = (byte)34;
	geoidSimple[58][330] = (byte)34;
	geoidSimple[58][331] = (byte)36;
	geoidSimple[58][332] = (byte)34;
	geoidSimple[58][333] = (byte)32;
	geoidSimple[58][334] = (byte)32;
	geoidSimple[58][335] = (byte)31;
	geoidSimple[58][336] = (byte)31;
	geoidSimple[58][337] = (byte)33;
	geoidSimple[58][338] = (byte)34;
	geoidSimple[58][339] = (byte)35;
	geoidSimple[58][340] = (byte)37;
	geoidSimple[58][341] = (byte)38;
	geoidSimple[58][342] = (byte)39;
	geoidSimple[58][343] = (byte)39;
	geoidSimple[58][344] = (byte)39;
	geoidSimple[58][345] = (byte)41;
	geoidSimple[58][346] = (byte)43;
	geoidSimple[58][347] = (byte)43;
	geoidSimple[58][348] = (byte)43;
	geoidSimple[58][349] = (byte)44;
	geoidSimple[58][350] = (byte)47;
	geoidSimple[58][351] = (byte)49;
	geoidSimple[58][352] = (byte)51;
	geoidSimple[58][353] = (byte)53;
	geoidSimple[58][354] = (byte)54;
	geoidSimple[58][355] = (byte)50;
	geoidSimple[58][356] = (byte)48;
	geoidSimple[58][357] = (byte)46;
	geoidSimple[58][358] = (byte)44;
	geoidSimple[58][359] = (byte)42;
	}
		/** Row 59*/
	private static void init59() {
	geoidSimple[59][0] = (byte)37;
	geoidSimple[59][1] = (byte)34;
	geoidSimple[59][2] = (byte)31;
	geoidSimple[59][3] = (byte)29;
	geoidSimple[59][4] = (byte)27;
	geoidSimple[59][5] = (byte)26;
	geoidSimple[59][6] = (byte)26;
	geoidSimple[59][7] = (byte)26;
	geoidSimple[59][8] = (byte)27;
	geoidSimple[59][9] = (byte)27;
	geoidSimple[59][10] = (byte)29;
	geoidSimple[59][11] = (byte)30;
	geoidSimple[59][12] = (byte)31;
	geoidSimple[59][13] = (byte)31;
	geoidSimple[59][14] = (byte)30;
	geoidSimple[59][15] = (byte)29;
	geoidSimple[59][16] = (byte)28;
	geoidSimple[59][17] = (byte)28;
	geoidSimple[59][18] = (byte)27;
	geoidSimple[59][19] = (byte)26;
	geoidSimple[59][20] = (byte)26;
	geoidSimple[59][21] = (byte)24;
	geoidSimple[59][22] = (byte)23;
	geoidSimple[59][23] = (byte)22;
	geoidSimple[59][24] = (byte)21;
	geoidSimple[59][25] = (byte)21;
	geoidSimple[59][26] = (byte)20;
	geoidSimple[59][27] = (byte)18;
	geoidSimple[59][28] = (byte)16;
	geoidSimple[59][29] = (byte)15;
	geoidSimple[59][30] = (byte)15;
	geoidSimple[59][31] = (byte)15;
	geoidSimple[59][32] = (byte)16;
	geoidSimple[59][33] = (byte)17;
	geoidSimple[59][34] = (byte)17;
	geoidSimple[59][35] = (byte)18;
	geoidSimple[59][36] = (byte)19;
	geoidSimple[59][37] = (byte)16;
	geoidSimple[59][38] = (byte)14;
	geoidSimple[59][39] = (byte)12;
	geoidSimple[59][40] = (byte)9;
	geoidSimple[59][41] = (byte)6;
	geoidSimple[59][42] = (byte)3;
	geoidSimple[59][43] = (byte)1;
	geoidSimple[59][44] = (byte)-2;
	geoidSimple[59][45] = (byte)-6;
	geoidSimple[59][46] = (byte)-11;
	geoidSimple[59][47] = (byte)-14;
	geoidSimple[59][48] = (byte)-15;
	geoidSimple[59][49] = (byte)-16;
	geoidSimple[59][50] = (byte)-12;
	geoidSimple[59][51] = (byte)-5;
	geoidSimple[59][52] = (byte)-4;
	geoidSimple[59][53] = (byte)-5;
	geoidSimple[59][54] = (byte)-5;
	geoidSimple[59][55] = (byte)-5;
	geoidSimple[59][56] = (byte)-6;
	geoidSimple[59][57] = (byte)-10;
	geoidSimple[59][58] = (byte)-15;
	geoidSimple[59][59] = (byte)-14;
	geoidSimple[59][60] = (byte)-16;
	geoidSimple[59][61] = (byte)-20;
	geoidSimple[59][62] = (byte)-22;
	geoidSimple[59][63] = (byte)-22;
	geoidSimple[59][64] = (byte)-23;
	geoidSimple[59][65] = (byte)-25;
	geoidSimple[59][66] = (byte)-25;
	geoidSimple[59][67] = (byte)-25;
	geoidSimple[59][68] = (byte)-29;
	geoidSimple[59][69] = (byte)-32;
	geoidSimple[59][70] = (byte)-42;
	geoidSimple[59][71] = (byte)-48;
	geoidSimple[59][72] = (byte)-46;
	geoidSimple[59][73] = (byte)-45;
	geoidSimple[59][74] = (byte)-45;
	geoidSimple[59][75] = (byte)-47;
	geoidSimple[59][76] = (byte)-48;
	geoidSimple[59][77] = (byte)-44;
	geoidSimple[59][78] = (byte)-36;
	geoidSimple[59][79] = (byte)-23;
	geoidSimple[59][80] = (byte)-23;
	geoidSimple[59][81] = (byte)-24;
	geoidSimple[59][82] = (byte)-25;
	geoidSimple[59][83] = (byte)-27;
	geoidSimple[59][84] = (byte)-28;
	geoidSimple[59][85] = (byte)-29;
	geoidSimple[59][86] = (byte)-30;
	geoidSimple[59][87] = (byte)-31;
	geoidSimple[59][88] = (byte)-32;
	geoidSimple[59][89] = (byte)-34;
	geoidSimple[59][90] = (byte)-34;
	geoidSimple[59][91] = (byte)-35;
	geoidSimple[59][92] = (byte)-35;
	geoidSimple[59][93] = (byte)-35;
	geoidSimple[59][94] = (byte)-36;
	geoidSimple[59][95] = (byte)-37;
	geoidSimple[59][96] = (byte)-37;
	geoidSimple[59][97] = (byte)-36;
	geoidSimple[59][98] = (byte)-34;
	geoidSimple[59][99] = (byte)-32;
	geoidSimple[59][100] = (byte)-31;
	geoidSimple[59][101] = (byte)-31;
	geoidSimple[59][102] = (byte)-32;
	geoidSimple[59][103] = (byte)-39;
	geoidSimple[59][104] = (byte)-42;
	geoidSimple[59][105] = (byte)-42;
	geoidSimple[59][106] = (byte)-40;
	geoidSimple[59][107] = (byte)-37;
	geoidSimple[59][108] = (byte)-32;
	geoidSimple[59][109] = (byte)-26;
	geoidSimple[59][110] = (byte)-22;
	geoidSimple[59][111] = (byte)-22;
	geoidSimple[59][112] = (byte)-21;
	geoidSimple[59][113] = (byte)-17;
	geoidSimple[59][114] = (byte)-14;
	geoidSimple[59][115] = (byte)-10;
	geoidSimple[59][116] = (byte)-6;
	geoidSimple[59][117] = (byte)-2;
	geoidSimple[59][118] = (byte)1;
	geoidSimple[59][119] = (byte)4;
	geoidSimple[59][120] = (byte)7;
	geoidSimple[59][121] = (byte)11;
	geoidSimple[59][122] = (byte)14;
	geoidSimple[59][123] = (byte)17;
	geoidSimple[59][124] = (byte)20;
	geoidSimple[59][125] = (byte)23;
	geoidSimple[59][126] = (byte)25;
	geoidSimple[59][127] = (byte)28;
	geoidSimple[59][128] = (byte)29;
	geoidSimple[59][129] = (byte)30;
	geoidSimple[59][130] = (byte)30;
	geoidSimple[59][131] = (byte)26;
	geoidSimple[59][132] = (byte)28;
	geoidSimple[59][133] = (byte)31;
	geoidSimple[59][134] = (byte)34;
	geoidSimple[59][135] = (byte)36;
	geoidSimple[59][136] = (byte)37;
	geoidSimple[59][137] = (byte)38;
	geoidSimple[59][138] = (byte)40;
	geoidSimple[59][139] = (byte)42;
	geoidSimple[59][140] = (byte)40;
	geoidSimple[59][141] = (byte)31;
	geoidSimple[59][142] = (byte)20;
	geoidSimple[59][143] = (byte)26;
	geoidSimple[59][144] = (byte)29;
	geoidSimple[59][145] = (byte)28;
	geoidSimple[59][146] = (byte)26;
	geoidSimple[59][147] = (byte)23;
	geoidSimple[59][148] = (byte)21;
	geoidSimple[59][149] = (byte)19;
	geoidSimple[59][150] = (byte)17;
	geoidSimple[59][151] = (byte)15;
	geoidSimple[59][152] = (byte)14;
	geoidSimple[59][153] = (byte)12;
	geoidSimple[59][154] = (byte)10;
	geoidSimple[59][155] = (byte)9;
	geoidSimple[59][156] = (byte)8;
	geoidSimple[59][157] = (byte)6;
	geoidSimple[59][158] = (byte)5;
	geoidSimple[59][159] = (byte)3;
	geoidSimple[59][160] = (byte)2;
	geoidSimple[59][161] = (byte)0;
	geoidSimple[59][162] = (byte)-1;
	geoidSimple[59][163] = (byte)-2;
	geoidSimple[59][164] = (byte)-3;
	geoidSimple[59][165] = (byte)-5;
	geoidSimple[59][166] = (byte)-6;
	geoidSimple[59][167] = (byte)-7;
	geoidSimple[59][168] = (byte)-7;
	geoidSimple[59][169] = (byte)-7;
	geoidSimple[59][170] = (byte)-7;
	geoidSimple[59][171] = (byte)-7;
	geoidSimple[59][172] = (byte)-7;
	geoidSimple[59][173] = (byte)-7;
	geoidSimple[59][174] = (byte)-7;
	geoidSimple[59][175] = (byte)-7;
	geoidSimple[59][176] = (byte)-7;
	geoidSimple[59][177] = (byte)-7;
	geoidSimple[59][178] = (byte)-7;
	geoidSimple[59][179] = (byte)-7;
	geoidSimple[59][LAT_GRID_SIZE] = (byte)-8;
	geoidSimple[59][181] = (byte)-8;
	geoidSimple[59][182] = (byte)-8;
	geoidSimple[59][183] = (byte)-8;
	geoidSimple[59][184] = (byte)-7;
	geoidSimple[59][185] = (byte)-7;
	geoidSimple[59][186] = (byte)-7;
	geoidSimple[59][187] = (byte)-7;
	geoidSimple[59][188] = (byte)-7;
	geoidSimple[59][189] = (byte)-7;
	geoidSimple[59][190] = (byte)-7;
	geoidSimple[59][191] = (byte)-7;
	geoidSimple[59][192] = (byte)-7;
	geoidSimple[59][193] = (byte)-7;
	geoidSimple[59][194] = (byte)-7;
	geoidSimple[59][195] = (byte)-7;
	geoidSimple[59][196] = (byte)-7;
	geoidSimple[59][197] = (byte)-7;
	geoidSimple[59][198] = (byte)-8;
	geoidSimple[59][199] = (byte)-9;
	geoidSimple[59][200] = (byte)-10;
	geoidSimple[59][201] = (byte)-10;
	geoidSimple[59][202] = (byte)-11;
	geoidSimple[59][203] = (byte)-12;
	geoidSimple[59][204] = (byte)-12;
	geoidSimple[59][205] = (byte)-13;
	geoidSimple[59][206] = (byte)-13;
	geoidSimple[59][207] = (byte)-13;
	geoidSimple[59][208] = (byte)-14;
	geoidSimple[59][209] = (byte)-15;
	geoidSimple[59][210] = (byte)-16;
	geoidSimple[59][211] = (byte)-18;
	geoidSimple[59][212] = (byte)-19;
	geoidSimple[59][213] = (byte)-20;
	geoidSimple[59][214] = (byte)-22;
	geoidSimple[59][215] = (byte)-23;
	geoidSimple[59][216] = (byte)-24;
	geoidSimple[59][217] = (byte)-25;
	geoidSimple[59][218] = (byte)-26;
	geoidSimple[59][219] = (byte)-27;
	geoidSimple[59][220] = (byte)-28;
	geoidSimple[59][221] = (byte)-30;
	geoidSimple[59][222] = (byte)-31;
	geoidSimple[59][223] = (byte)-32;
	geoidSimple[59][224] = (byte)-33;
	geoidSimple[59][225] = (byte)-34;
	geoidSimple[59][226] = (byte)-36;
	geoidSimple[59][227] = (byte)-37;
	geoidSimple[59][228] = (byte)-38;
	geoidSimple[59][229] = (byte)-39;
	geoidSimple[59][230] = (byte)-40;
	geoidSimple[59][231] = (byte)-41;
	geoidSimple[59][232] = (byte)-41;
	geoidSimple[59][233] = (byte)-42;
	geoidSimple[59][234] = (byte)-42;
	geoidSimple[59][235] = (byte)-42;
	geoidSimple[59][236] = (byte)-42;
	geoidSimple[59][237] = (byte)-42;
	geoidSimple[59][238] = (byte)-42;
	geoidSimple[59][239] = (byte)-42;
	geoidSimple[59][240] = (byte)-41;
	geoidSimple[59][241] = (byte)-40;
	geoidSimple[59][242] = (byte)-39;
	geoidSimple[59][243] = (byte)-38;
	geoidSimple[59][244] = (byte)-34;
	geoidSimple[59][245] = (byte)-35;
	geoidSimple[59][246] = (byte)-35;
	geoidSimple[59][247] = (byte)-33;
	geoidSimple[59][248] = (byte)-31;
	geoidSimple[59][249] = (byte)-30;
	geoidSimple[59][250] = (byte)-28;
	geoidSimple[59][251] = (byte)-26;
	geoidSimple[59][252] = (byte)-25;
	geoidSimple[59][253] = (byte)-25;
	geoidSimple[59][254] = (byte)-24;
	geoidSimple[59][255] = (byte)-23;
	geoidSimple[59][256] = (byte)-22;
	geoidSimple[59][257] = (byte)-23;
	geoidSimple[59][258] = (byte)-24;
	geoidSimple[59][259] = (byte)-23;
	geoidSimple[59][260] = (byte)-23;
	geoidSimple[59][261] = (byte)-24;
	geoidSimple[59][262] = (byte)-27;
	geoidSimple[59][263] = (byte)-27;
	geoidSimple[59][264] = (byte)-28;
	geoidSimple[59][265] = (byte)-28;
	geoidSimple[59][266] = (byte)-28;
	geoidSimple[59][267] = (byte)-28;
	geoidSimple[59][268] = (byte)-28;
	geoidSimple[59][269] = (byte)-28;
	geoidSimple[59][270] = (byte)-28;
	geoidSimple[59][271] = (byte)-29;
	geoidSimple[59][272] = (byte)-29;
	geoidSimple[59][273] = (byte)-28;
	geoidSimple[59][274] = (byte)-28;
	geoidSimple[59][275] = (byte)-28;
	geoidSimple[59][276] = (byte)-28;
	geoidSimple[59][277] = (byte)-29;
	geoidSimple[59][278] = (byte)-29;
	geoidSimple[59][279] = (byte)-31;
	geoidSimple[59][280] = (byte)-34;
	geoidSimple[59][281] = (byte)-37;
	geoidSimple[59][282] = (byte)-40;
	geoidSimple[59][283] = (byte)-43;
	geoidSimple[59][284] = (byte)-44;
	geoidSimple[59][285] = (byte)-45;
	geoidSimple[59][286] = (byte)-48;
	geoidSimple[59][287] = (byte)-51;
	geoidSimple[59][288] = (byte)-51;
	geoidSimple[59][289] = (byte)-51;
	geoidSimple[59][290] = (byte)-50;
	geoidSimple[59][291] = (byte)-49;
	geoidSimple[59][292] = (byte)-47;
	geoidSimple[59][293] = (byte)-45;
	geoidSimple[59][294] = (byte)-44;
	geoidSimple[59][295] = (byte)-43;
	geoidSimple[59][296] = (byte)-41;
	geoidSimple[59][297] = (byte)-40;
	geoidSimple[59][298] = (byte)-40;
	geoidSimple[59][299] = (byte)-39;
	geoidSimple[59][300] = (byte)-39;
	geoidSimple[59][301] = (byte)-37;
	geoidSimple[59][302] = (byte)-36;
	geoidSimple[59][303] = (byte)-34;
	geoidSimple[59][304] = (byte)-32;
	geoidSimple[59][305] = (byte)-30;
	geoidSimple[59][306] = (byte)-28;
	geoidSimple[59][307] = (byte)-25;
	geoidSimple[59][308] = (byte)-22;
	geoidSimple[59][309] = (byte)-18;
	geoidSimple[59][310] = (byte)-15;
	geoidSimple[59][311] = (byte)-11;
	geoidSimple[59][312] = (byte)-7;
	geoidSimple[59][313] = (byte)-3;
	geoidSimple[59][314] = (byte)0;
	geoidSimple[59][315] = (byte)3;
	geoidSimple[59][316] = (byte)7;
	geoidSimple[59][317] = (byte)11;
	geoidSimple[59][318] = (byte)14;
	geoidSimple[59][319] = (byte)17;
	geoidSimple[59][320] = (byte)19;
	geoidSimple[59][321] = (byte)21;
	geoidSimple[59][322] = (byte)22;
	geoidSimple[59][323] = (byte)24;
	geoidSimple[59][324] = (byte)26;
	geoidSimple[59][325] = (byte)27;
	geoidSimple[59][326] = (byte)28;
	geoidSimple[59][327] = (byte)29;
	geoidSimple[59][328] = (byte)30;
	geoidSimple[59][329] = (byte)31;
	geoidSimple[59][330] = (byte)31;
	geoidSimple[59][331] = (byte)33;
	geoidSimple[59][332] = (byte)31;
	geoidSimple[59][333] = (byte)31;
	geoidSimple[59][334] = (byte)31;
	geoidSimple[59][335] = (byte)30;
	geoidSimple[59][336] = (byte)30;
	geoidSimple[59][337] = (byte)31;
	geoidSimple[59][338] = (byte)33;
	geoidSimple[59][339] = (byte)34;
	geoidSimple[59][340] = (byte)35;
	geoidSimple[59][341] = (byte)36;
	geoidSimple[59][342] = (byte)36;
	geoidSimple[59][343] = (byte)38;
	geoidSimple[59][344] = (byte)39;
	geoidSimple[59][345] = (byte)41;
	geoidSimple[59][346] = (byte)43;
	geoidSimple[59][347] = (byte)44;
	geoidSimple[59][348] = (byte)42;
	geoidSimple[59][349] = (byte)41;
	geoidSimple[59][350] = (byte)46;
	geoidSimple[59][351] = (byte)50;
	geoidSimple[59][352] = (byte)52;
	geoidSimple[59][353] = (byte)51;
	geoidSimple[59][354] = (byte)49;
	geoidSimple[59][355] = (byte)47;
	geoidSimple[59][356] = (byte)45;
	geoidSimple[59][357] = (byte)43;
	geoidSimple[59][358] = (byte)41;
	geoidSimple[59][359] = (byte)39;
	}
		/** Row 60*/
	private static void init60() {
	geoidSimple[60][0] = (byte)32;
	geoidSimple[60][1] = (byte)29;
	geoidSimple[60][2] = (byte)28;
	geoidSimple[60][3] = (byte)28;
	geoidSimple[60][4] = (byte)27;
	geoidSimple[60][5] = (byte)26;
	geoidSimple[60][6] = (byte)26;
	geoidSimple[60][7] = (byte)26;
	geoidSimple[60][8] = (byte)26;
	geoidSimple[60][9] = (byte)27;
	geoidSimple[60][10] = (byte)28;
	geoidSimple[60][11] = (byte)29;
	geoidSimple[60][12] = (byte)30;
	geoidSimple[60][13] = (byte)31;
	geoidSimple[60][14] = (byte)30;
	geoidSimple[60][15] = (byte)30;
	geoidSimple[60][16] = (byte)29;
	geoidSimple[60][17] = (byte)28;
	geoidSimple[60][18] = (byte)27;
	geoidSimple[60][19] = (byte)26;
	geoidSimple[60][20] = (byte)24;
	geoidSimple[60][21] = (byte)23;
	geoidSimple[60][22] = (byte)22;
	geoidSimple[60][23] = (byte)22;
	geoidSimple[60][24] = (byte)21;
	geoidSimple[60][25] = (byte)20;
	geoidSimple[60][26] = (byte)18;
	geoidSimple[60][27] = (byte)16;
	geoidSimple[60][28] = (byte)16;
	geoidSimple[60][29] = (byte)16;
	geoidSimple[60][30] = (byte)15;
	geoidSimple[60][31] = (byte)15;
	geoidSimple[60][32] = (byte)15;
	geoidSimple[60][33] = (byte)16;
	geoidSimple[60][34] = (byte)14;
	geoidSimple[60][35] = (byte)18;
	geoidSimple[60][36] = (byte)18;
	geoidSimple[60][37] = (byte)15;
	geoidSimple[60][38] = (byte)13;
	geoidSimple[60][39] = (byte)10;
	geoidSimple[60][40] = (byte)8;
	geoidSimple[60][41] = (byte)6;
	geoidSimple[60][42] = (byte)4;
	geoidSimple[60][43] = (byte)1;
	geoidSimple[60][44] = (byte)-1;
	geoidSimple[60][45] = (byte)-5;
	geoidSimple[60][46] = (byte)-9;
	geoidSimple[60][47] = (byte)-12;
	geoidSimple[60][48] = (byte)-15;
	geoidSimple[60][49] = (byte)-18;
	geoidSimple[60][50] = (byte)-18;
	geoidSimple[60][51] = (byte)-13;
	geoidSimple[60][52] = (byte)-9;
	geoidSimple[60][53] = (byte)-9;
	geoidSimple[60][54] = (byte)-9;
	geoidSimple[60][55] = (byte)-7;
	geoidSimple[60][56] = (byte)-5;
	geoidSimple[60][57] = (byte)-7;
	geoidSimple[60][58] = (byte)-14;
	geoidSimple[60][59] = (byte)-16;
	geoidSimple[60][60] = (byte)-15;
	geoidSimple[60][61] = (byte)-19;
	geoidSimple[60][62] = (byte)-21;
	geoidSimple[60][63] = (byte)-22;
	geoidSimple[60][64] = (byte)-26;
	geoidSimple[60][65] = (byte)-29;
	geoidSimple[60][66] = (byte)-28;
	geoidSimple[60][67] = (byte)-34;
	geoidSimple[60][68] = (byte)-37;
	geoidSimple[60][69] = (byte)-35;
	geoidSimple[60][70] = (byte)-45;
	geoidSimple[60][71] = (byte)-49;
	geoidSimple[60][72] = (byte)-48;
	geoidSimple[60][73] = (byte)-47;
	geoidSimple[60][74] = (byte)-46;
	geoidSimple[60][75] = (byte)-47;
	geoidSimple[60][76] = (byte)-49;
	geoidSimple[60][77] = (byte)-51;
	geoidSimple[60][78] = (byte)-50;
	geoidSimple[60][79] = (byte)-46;
	geoidSimple[60][80] = (byte)-42;
	geoidSimple[60][81] = (byte)-32;
	geoidSimple[60][82] = (byte)-26;
	geoidSimple[60][83] = (byte)-26;
	geoidSimple[60][84] = (byte)-27;
	geoidSimple[60][85] = (byte)-28;
	geoidSimple[60][86] = (byte)-30;
	geoidSimple[60][87] = (byte)-30;
	geoidSimple[60][88] = (byte)-32;
	geoidSimple[60][89] = (byte)-33;
	geoidSimple[60][90] = (byte)-34;
	geoidSimple[60][91] = (byte)-34;
	geoidSimple[60][92] = (byte)-33;
	geoidSimple[60][93] = (byte)-33;
	geoidSimple[60][94] = (byte)-34;
	geoidSimple[60][95] = (byte)-41;
	geoidSimple[60][96] = (byte)-39;
	geoidSimple[60][97] = (byte)-36;
	geoidSimple[60][98] = (byte)-34;
	geoidSimple[60][99] = (byte)-33;
	geoidSimple[60][100] = (byte)-31;
	geoidSimple[60][101] = (byte)-30;
	geoidSimple[60][102] = (byte)-36;
	geoidSimple[60][103] = (byte)-42;
	geoidSimple[60][104] = (byte)-42;
	geoidSimple[60][105] = (byte)-41;
	geoidSimple[60][106] = (byte)-39;
	geoidSimple[60][107] = (byte)-34;
	geoidSimple[60][108] = (byte)-29;
	geoidSimple[60][109] = (byte)-26;
	geoidSimple[60][110] = (byte)-22;
	geoidSimple[60][111] = (byte)-22;
	geoidSimple[60][112] = (byte)-20;
	geoidSimple[60][113] = (byte)-16;
	geoidSimple[60][114] = (byte)-12;
	geoidSimple[60][115] = (byte)-8;
	geoidSimple[60][116] = (byte)-5;
	geoidSimple[60][117] = (byte)-1;
	geoidSimple[60][118] = (byte)2;
	geoidSimple[60][119] = (byte)5;
	geoidSimple[60][120] = (byte)8;
	geoidSimple[60][121] = (byte)12;
	geoidSimple[60][122] = (byte)15;
	geoidSimple[60][123] = (byte)19;
	geoidSimple[60][124] = (byte)21;
	geoidSimple[60][125] = (byte)24;
	geoidSimple[60][126] = (byte)27;
	geoidSimple[60][127] = (byte)29;
	geoidSimple[60][128] = (byte)30;
	geoidSimple[60][129] = (byte)30;
	geoidSimple[60][130] = (byte)26;
	geoidSimple[60][131] = (byte)24;
	geoidSimple[60][132] = (byte)29;
	geoidSimple[60][133] = (byte)33;
	geoidSimple[60][134] = (byte)35;
	geoidSimple[60][135] = (byte)36;
	geoidSimple[60][136] = (byte)37;
	geoidSimple[60][137] = (byte)39;
	geoidSimple[60][138] = (byte)40;
	geoidSimple[60][139] = (byte)42;
	geoidSimple[60][140] = (byte)40;
	geoidSimple[60][141] = (byte)32;
	geoidSimple[60][142] = (byte)23;
	geoidSimple[60][143] = (byte)26;
	geoidSimple[60][144] = (byte)30;
	geoidSimple[60][145] = (byte)30;
	geoidSimple[60][146] = (byte)28;
	geoidSimple[60][147] = (byte)25;
	geoidSimple[60][148] = (byte)23;
	geoidSimple[60][149] = (byte)21;
	geoidSimple[60][150] = (byte)19;
	geoidSimple[60][151] = (byte)17;
	geoidSimple[60][152] = (byte)15;
	geoidSimple[60][153] = (byte)14;
	geoidSimple[60][154] = (byte)11;
	geoidSimple[60][155] = (byte)10;
	geoidSimple[60][156] = (byte)8;
	geoidSimple[60][157] = (byte)7;
	geoidSimple[60][158] = (byte)5;
	geoidSimple[60][159] = (byte)4;
	geoidSimple[60][160] = (byte)3;
	geoidSimple[60][161] = (byte)1;
	geoidSimple[60][162] = (byte)0;
	geoidSimple[60][163] = (byte)-1;
	geoidSimple[60][164] = (byte)-2;
	geoidSimple[60][165] = (byte)-3;
	geoidSimple[60][166] = (byte)-4;
	geoidSimple[60][167] = (byte)-5;
	geoidSimple[60][168] = (byte)-6;
	geoidSimple[60][169] = (byte)-6;
	geoidSimple[60][170] = (byte)-6;
	geoidSimple[60][171] = (byte)-6;
	geoidSimple[60][172] = (byte)-7;
	geoidSimple[60][173] = (byte)-6;
	geoidSimple[60][174] = (byte)-6;
	geoidSimple[60][175] = (byte)-6;
	geoidSimple[60][176] = (byte)-6;
	geoidSimple[60][177] = (byte)-6;
	geoidSimple[60][178] = (byte)-6;
	geoidSimple[60][179] = (byte)-5;
	geoidSimple[60][LAT_GRID_SIZE] = (byte)-6;
	geoidSimple[60][181] = (byte)-7;
	geoidSimple[60][182] = (byte)-7;
	geoidSimple[60][183] = (byte)-7;
	geoidSimple[60][184] = (byte)-6;
	geoidSimple[60][185] = (byte)-6;
	geoidSimple[60][186] = (byte)-5;
	geoidSimple[60][187] = (byte)-5;
	geoidSimple[60][188] = (byte)-4;
	geoidSimple[60][189] = (byte)-4;
	geoidSimple[60][190] = (byte)-4;
	geoidSimple[60][191] = (byte)-4;
	geoidSimple[60][192] = (byte)-4;
	geoidSimple[60][193] = (byte)-4;
	geoidSimple[60][194] = (byte)-4;
	geoidSimple[60][195] = (byte)-5;
	geoidSimple[60][196] = (byte)-5;
	geoidSimple[60][197] = (byte)-6;
	geoidSimple[60][198] = (byte)-6;
	geoidSimple[60][199] = (byte)-7;
	geoidSimple[60][200] = (byte)-8;
	geoidSimple[60][201] = (byte)-9;
	geoidSimple[60][202] = (byte)-10;
	geoidSimple[60][203] = (byte)-11;
	geoidSimple[60][204] = (byte)-11;
	geoidSimple[60][205] = (byte)-12;
	geoidSimple[60][206] = (byte)-12;
	geoidSimple[60][207] = (byte)-13;
	geoidSimple[60][208] = (byte)-13;
	geoidSimple[60][209] = (byte)-14;
	geoidSimple[60][210] = (byte)-15;
	geoidSimple[60][211] = (byte)-16;
	geoidSimple[60][212] = (byte)-17;
	geoidSimple[60][213] = (byte)-18;
	geoidSimple[60][214] = (byte)-19;
	geoidSimple[60][215] = (byte)-21;
	geoidSimple[60][216] = (byte)-22;
	geoidSimple[60][217] = (byte)-24;
	geoidSimple[60][218] = (byte)-25;
	geoidSimple[60][219] = (byte)-27;
	geoidSimple[60][220] = (byte)-28;
	geoidSimple[60][221] = (byte)-29;
	geoidSimple[60][222] = (byte)-30;
	geoidSimple[60][223] = (byte)-32;
	geoidSimple[60][224] = (byte)-33;
	geoidSimple[60][225] = (byte)-34;
	geoidSimple[60][226] = (byte)-35;
	geoidSimple[60][227] = (byte)-36;
	geoidSimple[60][228] = (byte)-38;
	geoidSimple[60][229] = (byte)-39;
	geoidSimple[60][230] = (byte)-40;
	geoidSimple[60][231] = (byte)-41;
	geoidSimple[60][232] = (byte)-42;
	geoidSimple[60][233] = (byte)-42;
	geoidSimple[60][234] = (byte)-43;
	geoidSimple[60][235] = (byte)-43;
	geoidSimple[60][236] = (byte)-43;
	geoidSimple[60][237] = (byte)-43;
	geoidSimple[60][238] = (byte)-43;
	geoidSimple[60][239] = (byte)-43;
	geoidSimple[60][240] = (byte)-42;
	geoidSimple[60][241] = (byte)-41;
	geoidSimple[60][242] = (byte)-41;
	geoidSimple[60][243] = (byte)-40;
	geoidSimple[60][244] = (byte)-37;
	geoidSimple[60][245] = (byte)-35;
	geoidSimple[60][246] = (byte)-36;
	geoidSimple[60][247] = (byte)-35;
	geoidSimple[60][248] = (byte)-32;
	geoidSimple[60][249] = (byte)-31;
	geoidSimple[60][250] = (byte)-29;
	geoidSimple[60][251] = (byte)-26;
	geoidSimple[60][252] = (byte)-24;
	geoidSimple[60][253] = (byte)-24;
	geoidSimple[60][254] = (byte)-24;
	geoidSimple[60][255] = (byte)-23;
	geoidSimple[60][256] = (byte)-22;
	geoidSimple[60][257] = (byte)-22;
	geoidSimple[60][258] = (byte)-23;
	geoidSimple[60][259] = (byte)-23;
	geoidSimple[60][260] = (byte)-23;
	geoidSimple[60][261] = (byte)-25;
	geoidSimple[60][262] = (byte)-27;
	geoidSimple[60][263] = (byte)-28;
	geoidSimple[60][264] = (byte)-28;
	geoidSimple[60][265] = (byte)-28;
	geoidSimple[60][266] = (byte)-27;
	geoidSimple[60][267] = (byte)-26;
	geoidSimple[60][268] = (byte)-26;
	geoidSimple[60][269] = (byte)-26;
	geoidSimple[60][270] = (byte)-26;
	geoidSimple[60][271] = (byte)-26;
	geoidSimple[60][272] = (byte)-27;
	geoidSimple[60][273] = (byte)-27;
	geoidSimple[60][274] = (byte)-27;
	geoidSimple[60][275] = (byte)-28;
	geoidSimple[60][276] = (byte)-28;
	geoidSimple[60][277] = (byte)-29;
	geoidSimple[60][278] = (byte)-29;
	geoidSimple[60][279] = (byte)-30;
	geoidSimple[60][280] = (byte)-33;
	geoidSimple[60][281] = (byte)-36;
	geoidSimple[60][282] = (byte)-38;
	geoidSimple[60][283] = (byte)-43;
	geoidSimple[60][284] = (byte)-46;
	geoidSimple[60][285] = (byte)-46;
	geoidSimple[60][286] = (byte)-47;
	geoidSimple[60][287] = (byte)-49;
	geoidSimple[60][288] = (byte)-51;
	geoidSimple[60][289] = (byte)-52;
	geoidSimple[60][290] = (byte)-51;
	geoidSimple[60][291] = (byte)-50;
	geoidSimple[60][292] = (byte)-48;
	geoidSimple[60][293] = (byte)-46;
	geoidSimple[60][294] = (byte)-45;
	geoidSimple[60][295] = (byte)-44;
	geoidSimple[60][296] = (byte)-43;
	geoidSimple[60][297] = (byte)-42;
	geoidSimple[60][298] = (byte)-42;
	geoidSimple[60][299] = (byte)-41;
	geoidSimple[60][300] = (byte)-41;
	geoidSimple[60][301] = (byte)-39;
	geoidSimple[60][302] = (byte)-38;
	geoidSimple[60][303] = (byte)-36;
	geoidSimple[60][304] = (byte)-34;
	geoidSimple[60][305] = (byte)-32;
	geoidSimple[60][306] = (byte)-29;
	geoidSimple[60][307] = (byte)-27;
	geoidSimple[60][308] = (byte)-23;
	geoidSimple[60][309] = (byte)-20;
	geoidSimple[60][310] = (byte)-16;
	geoidSimple[60][311] = (byte)-13;
	geoidSimple[60][312] = (byte)-9;
	geoidSimple[60][313] = (byte)-5;
	geoidSimple[60][314] = (byte)-1;
	geoidSimple[60][315] = (byte)2;
	geoidSimple[60][316] = (byte)6;
	geoidSimple[60][317] = (byte)9;
	geoidSimple[60][318] = (byte)11;
	geoidSimple[60][319] = (byte)13;
	geoidSimple[60][320] = (byte)15;
	geoidSimple[60][321] = (byte)17;
	geoidSimple[60][322] = (byte)19;
	geoidSimple[60][323] = (byte)21;
	geoidSimple[60][324] = (byte)22;
	geoidSimple[60][325] = (byte)24;
	geoidSimple[60][326] = (byte)25;
	geoidSimple[60][327] = (byte)27;
	geoidSimple[60][328] = (byte)28;
	geoidSimple[60][329] = (byte)29;
	geoidSimple[60][330] = (byte)29;
	geoidSimple[60][331] = (byte)32;
	geoidSimple[60][332] = (byte)29;
	geoidSimple[60][333] = (byte)29;
	geoidSimple[60][334] = (byte)29;
	geoidSimple[60][335] = (byte)29;
	geoidSimple[60][336] = (byte)29;
	geoidSimple[60][337] = (byte)30;
	geoidSimple[60][338] = (byte)32;
	geoidSimple[60][339] = (byte)33;
	geoidSimple[60][340] = (byte)33;
	geoidSimple[60][341] = (byte)34;
	geoidSimple[60][342] = (byte)36;
	geoidSimple[60][343] = (byte)37;
	geoidSimple[60][344] = (byte)37;
	geoidSimple[60][345] = (byte)38;
	geoidSimple[60][346] = (byte)42;
	geoidSimple[60][347] = (byte)43;
	geoidSimple[60][348] = (byte)40;
	geoidSimple[60][349] = (byte)41;
	geoidSimple[60][350] = (byte)44;
	geoidSimple[60][351] = (byte)46;
	geoidSimple[60][352] = (byte)44;
	geoidSimple[60][353] = (byte)44;
	geoidSimple[60][354] = (byte)44;
	geoidSimple[60][355] = (byte)43;
	geoidSimple[60][356] = (byte)41;
	geoidSimple[60][357] = (byte)39;
	geoidSimple[60][358] = (byte)37;
	geoidSimple[60][359] = (byte)35;
	}
		/** Row 61*/
	private static void init61() {
	geoidSimple[61][0] = (byte)29;
	geoidSimple[61][1] = (byte)27;
	geoidSimple[61][2] = (byte)27;
	geoidSimple[61][3] = (byte)28;
	geoidSimple[61][4] = (byte)27;
	geoidSimple[61][5] = (byte)27;
	geoidSimple[61][6] = (byte)27;
	geoidSimple[61][7] = (byte)27;
	geoidSimple[61][8] = (byte)27;
	geoidSimple[61][9] = (byte)28;
	geoidSimple[61][10] = (byte)28;
	geoidSimple[61][11] = (byte)28;
	geoidSimple[61][12] = (byte)29;
	geoidSimple[61][13] = (byte)30;
	geoidSimple[61][14] = (byte)30;
	geoidSimple[61][15] = (byte)30;
	geoidSimple[61][16] = (byte)29;
	geoidSimple[61][17] = (byte)29;
	geoidSimple[61][18] = (byte)27;
	geoidSimple[61][19] = (byte)25;
	geoidSimple[61][20] = (byte)24;
	geoidSimple[61][21] = (byte)22;
	geoidSimple[61][22] = (byte)22;
	geoidSimple[61][23] = (byte)21;
	geoidSimple[61][24] = (byte)20;
	geoidSimple[61][25] = (byte)17;
	geoidSimple[61][26] = (byte)16;
	geoidSimple[61][27] = (byte)15;
	geoidSimple[61][28] = (byte)15;
	geoidSimple[61][29] = (byte)15;
	geoidSimple[61][30] = (byte)14;
	geoidSimple[61][31] = (byte)14;
	geoidSimple[61][32] = (byte)14;
	geoidSimple[61][33] = (byte)12;
	geoidSimple[61][34] = (byte)10;
	geoidSimple[61][35] = (byte)18;
	geoidSimple[61][36] = (byte)18;
	geoidSimple[61][37] = (byte)15;
	geoidSimple[61][38] = (byte)13;
	geoidSimple[61][39] = (byte)10;
	geoidSimple[61][40] = (byte)9;
	geoidSimple[61][41] = (byte)6;
	geoidSimple[61][42] = (byte)4;
	geoidSimple[61][43] = (byte)1;
	geoidSimple[61][44] = (byte)-1;
	geoidSimple[61][45] = (byte)-4;
	geoidSimple[61][46] = (byte)-8;
	geoidSimple[61][47] = (byte)-12;
	geoidSimple[61][48] = (byte)-16;
	geoidSimple[61][49] = (byte)-19;
	geoidSimple[61][50] = (byte)-22;
	geoidSimple[61][51] = (byte)-21;
	geoidSimple[61][52] = (byte)-16;
	geoidSimple[61][53] = (byte)-15;
	geoidSimple[61][54] = (byte)-15;
	geoidSimple[61][55] = (byte)-13;
	geoidSimple[61][56] = (byte)-11;
	geoidSimple[61][57] = (byte)-12;
	geoidSimple[61][58] = (byte)-15;
	geoidSimple[61][59] = (byte)-18;
	geoidSimple[61][60] = (byte)-17;
	geoidSimple[61][61] = (byte)-19;
	geoidSimple[61][62] = (byte)-25;
	geoidSimple[61][63] = (byte)-28;
	geoidSimple[61][64] = (byte)-29;
	geoidSimple[61][65] = (byte)-30;
	geoidSimple[61][66] = (byte)-30;
	geoidSimple[61][67] = (byte)-39;
	geoidSimple[61][68] = (byte)-41;
	geoidSimple[61][69] = (byte)-42;
	geoidSimple[61][70] = (byte)-47;
	geoidSimple[61][71] = (byte)-49;
	geoidSimple[61][72] = (byte)-48;
	geoidSimple[61][73] = (byte)-47;
	geoidSimple[61][74] = (byte)-46;
	geoidSimple[61][75] = (byte)-47;
	geoidSimple[61][76] = (byte)-49;
	geoidSimple[61][77] = (byte)-53;
	geoidSimple[61][78] = (byte)-56;
	geoidSimple[61][79] = (byte)-59;
	geoidSimple[61][80] = (byte)-58;
	geoidSimple[61][81] = (byte)-53;
	geoidSimple[61][82] = (byte)-44;
	geoidSimple[61][83] = (byte)-40;
	geoidSimple[61][84] = (byte)-35;
	geoidSimple[61][85] = (byte)-30;
	geoidSimple[61][86] = (byte)-28;
	geoidSimple[61][87] = (byte)-29;
	geoidSimple[61][88] = (byte)-30;
	geoidSimple[61][89] = (byte)-31;
	geoidSimple[61][90] = (byte)-31;
	geoidSimple[61][91] = (byte)-31;
	geoidSimple[61][92] = (byte)-30;
	geoidSimple[61][93] = (byte)-31;
	geoidSimple[61][94] = (byte)-32;
	geoidSimple[61][95] = (byte)-45;
	geoidSimple[61][96] = (byte)-43;
	geoidSimple[61][97] = (byte)-39;
	geoidSimple[61][98] = (byte)-36;
	geoidSimple[61][99] = (byte)-33;
	geoidSimple[61][100] = (byte)-31;
	geoidSimple[61][101] = (byte)-30;
	geoidSimple[61][102] = (byte)-34;
	geoidSimple[61][103] = (byte)-37;
	geoidSimple[61][104] = (byte)-41;
	geoidSimple[61][105] = (byte)-39;
	geoidSimple[61][106] = (byte)-35;
	geoidSimple[61][107] = (byte)-31;
	geoidSimple[61][108] = (byte)-28;
	geoidSimple[61][109] = (byte)-25;
	geoidSimple[61][110] = (byte)-22;
	geoidSimple[61][111] = (byte)-20;
	geoidSimple[61][112] = (byte)-19;
	geoidSimple[61][113] = (byte)-15;
	geoidSimple[61][114] = (byte)-10;
	geoidSimple[61][115] = (byte)-7;
	geoidSimple[61][116] = (byte)-4;
	geoidSimple[61][117] = (byte)0;
	geoidSimple[61][118] = (byte)3;
	geoidSimple[61][119] = (byte)7;
	geoidSimple[61][120] = (byte)10;
	geoidSimple[61][121] = (byte)13;
	geoidSimple[61][122] = (byte)16;
	geoidSimple[61][123] = (byte)20;
	geoidSimple[61][124] = (byte)23;
	geoidSimple[61][125] = (byte)25;
	geoidSimple[61][126] = (byte)28;
	geoidSimple[61][127] = (byte)30;
	geoidSimple[61][128] = (byte)30;
	geoidSimple[61][129] = (byte)28;
	geoidSimple[61][130] = (byte)24;
	geoidSimple[61][131] = (byte)27;
	geoidSimple[61][132] = (byte)32;
	geoidSimple[61][133] = (byte)34;
	geoidSimple[61][134] = (byte)35;
	geoidSimple[61][135] = (byte)36;
	geoidSimple[61][136] = (byte)38;
	geoidSimple[61][137] = (byte)39;
	geoidSimple[61][138] = (byte)40;
	geoidSimple[61][139] = (byte)42;
	geoidSimple[61][140] = (byte)41;
	geoidSimple[61][141] = (byte)38;
	geoidSimple[61][142] = (byte)37;
	geoidSimple[61][143] = (byte)27;
	geoidSimple[61][144] = (byte)31;
	geoidSimple[61][145] = (byte)31;
	geoidSimple[61][146] = (byte)29;
	geoidSimple[61][147] = (byte)27;
	geoidSimple[61][148] = (byte)24;
	geoidSimple[61][149] = (byte)22;
	geoidSimple[61][150] = (byte)21;
	geoidSimple[61][151] = (byte)19;
	geoidSimple[61][152] = (byte)17;
	geoidSimple[61][153] = (byte)15;
	geoidSimple[61][154] = (byte)12;
	geoidSimple[61][155] = (byte)11;
	geoidSimple[61][156] = (byte)9;
	geoidSimple[61][157] = (byte)8;
	geoidSimple[61][158] = (byte)6;
	geoidSimple[61][159] = (byte)4;
	geoidSimple[61][160] = (byte)4;
	geoidSimple[61][161] = (byte)3;
	geoidSimple[61][162] = (byte)2;
	geoidSimple[61][163] = (byte)0;
	geoidSimple[61][164] = (byte)-1;
	geoidSimple[61][165] = (byte)-2;
	geoidSimple[61][166] = (byte)-3;
	geoidSimple[61][167] = (byte)-4;
	geoidSimple[61][168] = (byte)-5;
	geoidSimple[61][169] = (byte)-5;
	geoidSimple[61][170] = (byte)-6;
	geoidSimple[61][171] = (byte)-6;
	geoidSimple[61][172] = (byte)-6;
	geoidSimple[61][173] = (byte)-6;
	geoidSimple[61][174] = (byte)-6;
	geoidSimple[61][175] = (byte)-6;
	geoidSimple[61][176] = (byte)-5;
	geoidSimple[61][177] = (byte)-5;
	geoidSimple[61][178] = (byte)-5;
	geoidSimple[61][179] = (byte)-5;
	geoidSimple[61][LAT_GRID_SIZE] = (byte)-4;
	geoidSimple[61][181] = (byte)-1;
	geoidSimple[61][182] = (byte)-3;
	geoidSimple[61][183] = (byte)-3;
	geoidSimple[61][184] = (byte)-3;
	geoidSimple[61][185] = (byte)-5;
	geoidSimple[61][186] = (byte)-4;
	geoidSimple[61][187] = (byte)-3;
	geoidSimple[61][188] = (byte)-2;
	geoidSimple[61][189] = (byte)-1;
	geoidSimple[61][190] = (byte)-1;
	geoidSimple[61][191] = (byte)-1;
	geoidSimple[61][192] = (byte)-1;
	geoidSimple[61][193] = (byte)-1;
	geoidSimple[61][194] = (byte)-1;
	geoidSimple[61][195] = (byte)-2;
	geoidSimple[61][196] = (byte)-2;
	geoidSimple[61][197] = (byte)-3;
	geoidSimple[61][198] = (byte)-3;
	geoidSimple[61][199] = (byte)-4;
	geoidSimple[61][200] = (byte)-5;
	geoidSimple[61][201] = (byte)-6;
	geoidSimple[61][202] = (byte)-8;
	geoidSimple[61][203] = (byte)-9;
	geoidSimple[61][204] = (byte)-9;
	geoidSimple[61][205] = (byte)-10;
	geoidSimple[61][206] = (byte)-11;
	geoidSimple[61][207] = (byte)-11;
	geoidSimple[61][208] = (byte)-12;
	geoidSimple[61][209] = (byte)-13;
	geoidSimple[61][210] = (byte)-14;
	geoidSimple[61][211] = (byte)-15;
	geoidSimple[61][212] = (byte)-16;
	geoidSimple[61][213] = (byte)-17;
	geoidSimple[61][214] = (byte)-18;
	geoidSimple[61][215] = (byte)-20;
	geoidSimple[61][216] = (byte)-21;
	geoidSimple[61][217] = (byte)-23;
	geoidSimple[61][218] = (byte)-24;
	geoidSimple[61][219] = (byte)-26;
	geoidSimple[61][220] = (byte)-27;
	geoidSimple[61][221] = (byte)-29;
	geoidSimple[61][222] = (byte)-30;
	geoidSimple[61][223] = (byte)-31;
	geoidSimple[61][224] = (byte)-32;
	geoidSimple[61][225] = (byte)-34;
	geoidSimple[61][226] = (byte)-35;
	geoidSimple[61][227] = (byte)-36;
	geoidSimple[61][228] = (byte)-38;
	geoidSimple[61][229] = (byte)-39;
	geoidSimple[61][230] = (byte)-41;
	geoidSimple[61][231] = (byte)-42;
	geoidSimple[61][232] = (byte)-42;
	geoidSimple[61][233] = (byte)-43;
	geoidSimple[61][234] = (byte)-43;
	geoidSimple[61][235] = (byte)-44;
	geoidSimple[61][236] = (byte)-44;
	geoidSimple[61][237] = (byte)-44;
	geoidSimple[61][238] = (byte)-44;
	geoidSimple[61][239] = (byte)-44;
	geoidSimple[61][240] = (byte)-43;
	geoidSimple[61][241] = (byte)-42;
	geoidSimple[61][242] = (byte)-42;
	geoidSimple[61][243] = (byte)-42;
	geoidSimple[61][244] = (byte)-40;
	geoidSimple[61][245] = (byte)-37;
	geoidSimple[61][246] = (byte)-35;
	geoidSimple[61][247] = (byte)-35;
	geoidSimple[61][248] = (byte)-34;
	geoidSimple[61][249] = (byte)-32;
	geoidSimple[61][250] = (byte)-30;
	geoidSimple[61][251] = (byte)-26;
	geoidSimple[61][252] = (byte)-24;
	geoidSimple[61][253] = (byte)-23;
	geoidSimple[61][254] = (byte)-24;
	geoidSimple[61][255] = (byte)-23;
	geoidSimple[61][256] = (byte)-22;
	geoidSimple[61][257] = (byte)-21;
	geoidSimple[61][258] = (byte)-22;
	geoidSimple[61][259] = (byte)-23;
	geoidSimple[61][260] = (byte)-24;
	geoidSimple[61][261] = (byte)-26;
	geoidSimple[61][262] = (byte)-28;
	geoidSimple[61][263] = (byte)-28;
	geoidSimple[61][264] = (byte)-27;
	geoidSimple[61][265] = (byte)-27;
	geoidSimple[61][266] = (byte)-26;
	geoidSimple[61][267] = (byte)-25;
	geoidSimple[61][268] = (byte)-24;
	geoidSimple[61][269] = (byte)-24;
	geoidSimple[61][270] = (byte)-25;
	geoidSimple[61][271] = (byte)-27;
	geoidSimple[61][272] = (byte)-30;
	geoidSimple[61][273] = (byte)-29;
	geoidSimple[61][274] = (byte)-27;
	geoidSimple[61][275] = (byte)-26;
	geoidSimple[61][276] = (byte)-27;
	geoidSimple[61][277] = (byte)-28;
	geoidSimple[61][278] = (byte)-29;
	geoidSimple[61][279] = (byte)-30;
	geoidSimple[61][280] = (byte)-33;
	geoidSimple[61][281] = (byte)-35;
	geoidSimple[61][282] = (byte)-37;
	geoidSimple[61][283] = (byte)-43;
	geoidSimple[61][284] = (byte)-45;
	geoidSimple[61][285] = (byte)-45;
	geoidSimple[61][286] = (byte)-47;
	geoidSimple[61][287] = (byte)-49;
	geoidSimple[61][288] = (byte)-51;
	geoidSimple[61][289] = (byte)-52;
	geoidSimple[61][290] = (byte)-51;
	geoidSimple[61][291] = (byte)-50;
	geoidSimple[61][292] = (byte)-49;
	geoidSimple[61][293] = (byte)-47;
	geoidSimple[61][294] = (byte)-46;
	geoidSimple[61][295] = (byte)-46;
	geoidSimple[61][296] = (byte)-45;
	geoidSimple[61][297] = (byte)-45;
	geoidSimple[61][298] = (byte)-45;
	geoidSimple[61][299] = (byte)-44;
	geoidSimple[61][300] = (byte)-43;
	geoidSimple[61][301] = (byte)-42;
	geoidSimple[61][302] = (byte)-40;
	geoidSimple[61][303] = (byte)-38;
	geoidSimple[61][304] = (byte)-36;
	geoidSimple[61][305] = (byte)-34;
	geoidSimple[61][306] = (byte)-31;
	geoidSimple[61][307] = (byte)-28;
	geoidSimple[61][308] = (byte)-25;
	geoidSimple[61][309] = (byte)-22;
	geoidSimple[61][310] = (byte)-18;
	geoidSimple[61][311] = (byte)-15;
	geoidSimple[61][312] = (byte)-11;
	geoidSimple[61][313] = (byte)-7;
	geoidSimple[61][314] = (byte)-3;
	geoidSimple[61][315] = (byte)0;
	geoidSimple[61][316] = (byte)4;
	geoidSimple[61][317] = (byte)6;
	geoidSimple[61][318] = (byte)8;
	geoidSimple[61][319] = (byte)10;
	geoidSimple[61][320] = (byte)12;
	geoidSimple[61][321] = (byte)14;
	geoidSimple[61][322] = (byte)15;
	geoidSimple[61][323] = (byte)17;
	geoidSimple[61][324] = (byte)19;
	geoidSimple[61][325] = (byte)21;
	geoidSimple[61][326] = (byte)22;
	geoidSimple[61][327] = (byte)24;
	geoidSimple[61][328] = (byte)25;
	geoidSimple[61][329] = (byte)26;
	geoidSimple[61][330] = (byte)27;
	geoidSimple[61][331] = (byte)26;
	geoidSimple[61][332] = (byte)27;
	geoidSimple[61][333] = (byte)27;
	geoidSimple[61][334] = (byte)27;
	geoidSimple[61][335] = (byte)27;
	geoidSimple[61][336] = (byte)28;
	geoidSimple[61][337] = (byte)28;
	geoidSimple[61][338] = (byte)30;
	geoidSimple[61][339] = (byte)31;
	geoidSimple[61][340] = (byte)32;
	geoidSimple[61][341] = (byte)35;
	geoidSimple[61][342] = (byte)40;
	geoidSimple[61][343] = (byte)43;
	geoidSimple[61][344] = (byte)38;
	geoidSimple[61][345] = (byte)39;
	geoidSimple[61][346] = (byte)42;
	geoidSimple[61][347] = (byte)40;
	geoidSimple[61][348] = (byte)40;
	geoidSimple[61][349] = (byte)40;
	geoidSimple[61][350] = (byte)40;
	geoidSimple[61][351] = (byte)39;
	geoidSimple[61][352] = (byte)38;
	geoidSimple[61][353] = (byte)38;
	geoidSimple[61][354] = (byte)38;
	geoidSimple[61][355] = (byte)38;
	geoidSimple[61][356] = (byte)37;
	geoidSimple[61][357] = (byte)35;
	geoidSimple[61][358] = (byte)33;
	geoidSimple[61][359] = (byte)31;
	}
		/** Row 62*/
	private static void init62() {
	geoidSimple[62][0] = (byte)27;
	geoidSimple[62][1] = (byte)26;
	geoidSimple[62][2] = (byte)25;
	geoidSimple[62][3] = (byte)27;
	geoidSimple[62][4] = (byte)28;
	geoidSimple[62][5] = (byte)28;
	geoidSimple[62][6] = (byte)28;
	geoidSimple[62][7] = (byte)28;
	geoidSimple[62][8] = (byte)29;
	geoidSimple[62][9] = (byte)28;
	geoidSimple[62][10] = (byte)28;
	geoidSimple[62][11] = (byte)28;
	geoidSimple[62][12] = (byte)28;
	geoidSimple[62][13] = (byte)28;
	geoidSimple[62][14] = (byte)28;
	geoidSimple[62][15] = (byte)29;
	geoidSimple[62][16] = (byte)30;
	geoidSimple[62][17] = (byte)30;
	geoidSimple[62][18] = (byte)28;
	geoidSimple[62][19] = (byte)25;
	geoidSimple[62][20] = (byte)23;
	geoidSimple[62][21] = (byte)22;
	geoidSimple[62][22] = (byte)21;
	geoidSimple[62][23] = (byte)20;
	geoidSimple[62][24] = (byte)18;
	geoidSimple[62][25] = (byte)15;
	geoidSimple[62][26] = (byte)14;
	geoidSimple[62][27] = (byte)14;
	geoidSimple[62][28] = (byte)14;
	geoidSimple[62][29] = (byte)14;
	geoidSimple[62][30] = (byte)13;
	geoidSimple[62][31] = (byte)13;
	geoidSimple[62][32] = (byte)13;
	geoidSimple[62][33] = (byte)13;
	geoidSimple[62][34] = (byte)11;
	geoidSimple[62][35] = (byte)14;
	geoidSimple[62][36] = (byte)17;
	geoidSimple[62][37] = (byte)15;
	geoidSimple[62][38] = (byte)12;
	geoidSimple[62][39] = (byte)11;
	geoidSimple[62][40] = (byte)10;
	geoidSimple[62][41] = (byte)7;
	geoidSimple[62][42] = (byte)5;
	geoidSimple[62][43] = (byte)2;
	geoidSimple[62][44] = (byte)-1;
	geoidSimple[62][45] = (byte)-4;
	geoidSimple[62][46] = (byte)-7;
	geoidSimple[62][47] = (byte)-12;
	geoidSimple[62][48] = (byte)-16;
	geoidSimple[62][49] = (byte)-20;
	geoidSimple[62][50] = (byte)-25;
	geoidSimple[62][51] = (byte)-26;
	geoidSimple[62][52] = (byte)-25;
	geoidSimple[62][53] = (byte)-22;
	geoidSimple[62][54] = (byte)-20;
	geoidSimple[62][55] = (byte)-22;
	geoidSimple[62][56] = (byte)-24;
	geoidSimple[62][57] = (byte)-21;
	geoidSimple[62][58] = (byte)-19;
	geoidSimple[62][59] = (byte)-21;
	geoidSimple[62][60] = (byte)-22;
	geoidSimple[62][61] = (byte)-23;
	geoidSimple[62][62] = (byte)-27;
	geoidSimple[62][63] = (byte)-30;
	geoidSimple[62][64] = (byte)-31;
	geoidSimple[62][65] = (byte)-31;
	geoidSimple[62][66] = (byte)-34;
	geoidSimple[62][67] = (byte)-41;
	geoidSimple[62][68] = (byte)-43;
	geoidSimple[62][69] = (byte)-43;
	geoidSimple[62][70] = (byte)-45;
	geoidSimple[62][71] = (byte)-46;
	geoidSimple[62][72] = (byte)-45;
	geoidSimple[62][73] = (byte)-46;
	geoidSimple[62][74] = (byte)-46;
	geoidSimple[62][75] = (byte)-47;
	geoidSimple[62][76] = (byte)-50;
	geoidSimple[62][77] = (byte)-54;
	geoidSimple[62][78] = (byte)-57;
	geoidSimple[62][79] = (byte)-61;
	geoidSimple[62][80] = (byte)-64;
	geoidSimple[62][81] = (byte)-64;
	geoidSimple[62][82] = (byte)-62;
	geoidSimple[62][83] = (byte)-60;
	geoidSimple[62][84] = (byte)-58;
	geoidSimple[62][85] = (byte)-50;
	geoidSimple[62][86] = (byte)-38;
	geoidSimple[62][87] = (byte)-35;
	geoidSimple[62][88] = (byte)-32;
	geoidSimple[62][89] = (byte)-30;
	geoidSimple[62][90] = (byte)-34;
	geoidSimple[62][91] = (byte)-33;
	geoidSimple[62][92] = (byte)-31;
	geoidSimple[62][93] = (byte)-43;
	geoidSimple[62][94] = (byte)-51;
	geoidSimple[62][95] = (byte)-54;
	geoidSimple[62][96] = (byte)-47;
	geoidSimple[62][97] = (byte)-43;
	geoidSimple[62][98] = (byte)-40;
	geoidSimple[62][99] = (byte)-36;
	geoidSimple[62][100] = (byte)-34;
	geoidSimple[62][101] = (byte)-32;
	geoidSimple[62][102] = (byte)-34;
	geoidSimple[62][103] = (byte)-34;
	geoidSimple[62][104] = (byte)-34;
	geoidSimple[62][105] = (byte)-33;
	geoidSimple[62][106] = (byte)-32;
	geoidSimple[62][107] = (byte)-29;
	geoidSimple[62][108] = (byte)-26;
	geoidSimple[62][109] = (byte)-23;
	geoidSimple[62][110] = (byte)-21;
	geoidSimple[62][111] = (byte)-19;
	geoidSimple[62][112] = (byte)-17;
	geoidSimple[62][113] = (byte)-14;
	geoidSimple[62][114] = (byte)-10;
	geoidSimple[62][115] = (byte)-7;
	geoidSimple[62][116] = (byte)-3;
	geoidSimple[62][117] = (byte)1;
	geoidSimple[62][118] = (byte)5;
	geoidSimple[62][119] = (byte)9;
	geoidSimple[62][120] = (byte)11;
	geoidSimple[62][121] = (byte)15;
	geoidSimple[62][122] = (byte)17;
	geoidSimple[62][123] = (byte)21;
	geoidSimple[62][124] = (byte)24;
	geoidSimple[62][125] = (byte)27;
	geoidSimple[62][126] = (byte)30;
	geoidSimple[62][127] = (byte)31;
	geoidSimple[62][128] = (byte)30;
	geoidSimple[62][129] = (byte)26;
	geoidSimple[62][130] = (byte)24;
	geoidSimple[62][131] = (byte)29;
	geoidSimple[62][132] = (byte)33;
	geoidSimple[62][133] = (byte)34;
	geoidSimple[62][134] = (byte)35;
	geoidSimple[62][135] = (byte)37;
	geoidSimple[62][136] = (byte)38;
	geoidSimple[62][137] = (byte)40;
	geoidSimple[62][138] = (byte)41;
	geoidSimple[62][139] = (byte)43;
	geoidSimple[62][140] = (byte)43;
	geoidSimple[62][141] = (byte)41;
	geoidSimple[62][142] = (byte)46;
	geoidSimple[62][143] = (byte)29;
	geoidSimple[62][144] = (byte)32;
	geoidSimple[62][145] = (byte)34;
	geoidSimple[62][146] = (byte)32;
	geoidSimple[62][147] = (byte)30;
	geoidSimple[62][148] = (byte)27;
	geoidSimple[62][149] = (byte)24;
	geoidSimple[62][150] = (byte)22;
	geoidSimple[62][151] = (byte)21;
	geoidSimple[62][152] = (byte)19;
	geoidSimple[62][153] = (byte)17;
	geoidSimple[62][154] = (byte)14;
	geoidSimple[62][155] = (byte)13;
	geoidSimple[62][156] = (byte)11;
	geoidSimple[62][157] = (byte)9;
	geoidSimple[62][158] = (byte)7;
	geoidSimple[62][159] = (byte)6;
	geoidSimple[62][160] = (byte)4;
	geoidSimple[62][161] = (byte)3;
	geoidSimple[62][162] = (byte)2;
	geoidSimple[62][163] = (byte)1;
	geoidSimple[62][164] = (byte)0;
	geoidSimple[62][165] = (byte)0;
	geoidSimple[62][166] = (byte)-1;
	geoidSimple[62][167] = (byte)-2;
	geoidSimple[62][168] = (byte)-3;
	geoidSimple[62][169] = (byte)-4;
	geoidSimple[62][170] = (byte)-5;
	geoidSimple[62][171] = (byte)-6;
	geoidSimple[62][172] = (byte)-6;
	geoidSimple[62][173] = (byte)-6;
	geoidSimple[62][174] = (byte)-6;
	geoidSimple[62][175] = (byte)-5;
	geoidSimple[62][176] = (byte)-5;
	geoidSimple[62][177] = (byte)-4;
	geoidSimple[62][178] = (byte)-4;
	geoidSimple[62][179] = (byte)-4;
	geoidSimple[62][LAT_GRID_SIZE] = (byte)-4;
	geoidSimple[62][181] = (byte)-3;
	geoidSimple[62][182] = (byte)-2;
	geoidSimple[62][183] = (byte)-1;
	geoidSimple[62][184] = (byte)0;
	geoidSimple[62][185] = (byte)-3;
	geoidSimple[62][186] = (byte)-3;
	geoidSimple[62][187] = (byte)-2;
	geoidSimple[62][188] = (byte)-1;
	geoidSimple[62][189] = (byte)0;
	geoidSimple[62][190] = (byte)0;
	geoidSimple[62][191] = (byte)1;
	geoidSimple[62][192] = (byte)1;
	geoidSimple[62][193] = (byte)1;
	geoidSimple[62][194] = (byte)1;
	geoidSimple[62][195] = (byte)0;
	geoidSimple[62][196] = (byte)0;
	geoidSimple[62][197] = (byte)0;
	geoidSimple[62][198] = (byte)0;
	geoidSimple[62][199] = (byte)-1;
	geoidSimple[62][200] = (byte)-2;
	geoidSimple[62][201] = (byte)-4;
	geoidSimple[62][202] = (byte)-5;
	geoidSimple[62][203] = (byte)-6;
	geoidSimple[62][204] = (byte)-7;
	geoidSimple[62][205] = (byte)-8;
	geoidSimple[62][206] = (byte)-9;
	geoidSimple[62][207] = (byte)-10;
	geoidSimple[62][208] = (byte)-11;
	geoidSimple[62][209] = (byte)-12;
	geoidSimple[62][210] = (byte)-13;
	geoidSimple[62][211] = (byte)-14;
	geoidSimple[62][212] = (byte)-15;
	geoidSimple[62][213] = (byte)-16;
	geoidSimple[62][214] = (byte)-17;
	geoidSimple[62][215] = (byte)-19;
	geoidSimple[62][216] = (byte)-20;
	geoidSimple[62][217] = (byte)-22;
	geoidSimple[62][218] = (byte)-23;
	geoidSimple[62][219] = (byte)-25;
	geoidSimple[62][220] = (byte)-27;
	geoidSimple[62][221] = (byte)-28;
	geoidSimple[62][222] = (byte)-29;
	geoidSimple[62][223] = (byte)-31;
	geoidSimple[62][224] = (byte)-32;
	geoidSimple[62][225] = (byte)-33;
	geoidSimple[62][226] = (byte)-35;
	geoidSimple[62][227] = (byte)-36;
	geoidSimple[62][228] = (byte)-38;
	geoidSimple[62][229] = (byte)-39;
	geoidSimple[62][230] = (byte)-41;
	geoidSimple[62][231] = (byte)-42;
	geoidSimple[62][232] = (byte)-43;
	geoidSimple[62][233] = (byte)-43;
	geoidSimple[62][234] = (byte)-44;
	geoidSimple[62][235] = (byte)-44;
	geoidSimple[62][236] = (byte)-45;
	geoidSimple[62][237] = (byte)-45;
	geoidSimple[62][238] = (byte)-45;
	geoidSimple[62][239] = (byte)-44;
	geoidSimple[62][240] = (byte)-44;
	geoidSimple[62][241] = (byte)-44;
	geoidSimple[62][242] = (byte)-43;
	geoidSimple[62][243] = (byte)-42;
	geoidSimple[62][244] = (byte)-42;
	geoidSimple[62][245] = (byte)-38;
	geoidSimple[62][246] = (byte)-36;
	geoidSimple[62][247] = (byte)-35;
	geoidSimple[62][248] = (byte)-35;
	geoidSimple[62][249] = (byte)-33;
	geoidSimple[62][250] = (byte)-31;
	geoidSimple[62][251] = (byte)-28;
	geoidSimple[62][252] = (byte)-24;
	geoidSimple[62][253] = (byte)-23;
	geoidSimple[62][254] = (byte)-23;
	geoidSimple[62][255] = (byte)-22;
	geoidSimple[62][256] = (byte)-21;
	geoidSimple[62][257] = (byte)-20;
	geoidSimple[62][258] = (byte)-21;
	geoidSimple[62][259] = (byte)-22;
	geoidSimple[62][260] = (byte)-24;
	geoidSimple[62][261] = (byte)-26;
	geoidSimple[62][262] = (byte)-27;
	geoidSimple[62][263] = (byte)-27;
	geoidSimple[62][264] = (byte)-28;
	geoidSimple[62][265] = (byte)-29;
	geoidSimple[62][266] = (byte)-27;
	geoidSimple[62][267] = (byte)-26;
	geoidSimple[62][268] = (byte)-26;
	geoidSimple[62][269] = (byte)-26;
	geoidSimple[62][270] = (byte)-26;
	geoidSimple[62][271] = (byte)-27;
	geoidSimple[62][272] = (byte)-29;
	geoidSimple[62][273] = (byte)-30;
	geoidSimple[62][274] = (byte)-28;
	geoidSimple[62][275] = (byte)-25;
	geoidSimple[62][276] = (byte)-24;
	geoidSimple[62][277] = (byte)-26;
	geoidSimple[62][278] = (byte)-27;
	geoidSimple[62][279] = (byte)-29;
	geoidSimple[62][280] = (byte)-31;
	geoidSimple[62][281] = (byte)-33;
	geoidSimple[62][282] = (byte)-37;
	geoidSimple[62][283] = (byte)-41;
	geoidSimple[62][284] = (byte)-44;
	geoidSimple[62][285] = (byte)-44;
	geoidSimple[62][286] = (byte)-46;
	geoidSimple[62][287] = (byte)-48;
	geoidSimple[62][288] = (byte)-50;
	geoidSimple[62][289] = (byte)-51;
	geoidSimple[62][290] = (byte)-51;
	geoidSimple[62][291] = (byte)-50;
	geoidSimple[62][292] = (byte)-49;
	geoidSimple[62][293] = (byte)-48;
	geoidSimple[62][294] = (byte)-48;
	geoidSimple[62][295] = (byte)-47;
	geoidSimple[62][296] = (byte)-47;
	geoidSimple[62][297] = (byte)-47;
	geoidSimple[62][298] = (byte)-47;
	geoidSimple[62][299] = (byte)-46;
	geoidSimple[62][300] = (byte)-45;
	geoidSimple[62][301] = (byte)-44;
	geoidSimple[62][302] = (byte)-42;
	geoidSimple[62][303] = (byte)-40;
	geoidSimple[62][304] = (byte)-38;
	geoidSimple[62][305] = (byte)-36;
	geoidSimple[62][306] = (byte)-33;
	geoidSimple[62][307] = (byte)-30;
	geoidSimple[62][308] = (byte)-27;
	geoidSimple[62][309] = (byte)-23;
	geoidSimple[62][310] = (byte)-20;
	geoidSimple[62][311] = (byte)-16;
	geoidSimple[62][312] = (byte)-13;
	geoidSimple[62][313] = (byte)-9;
	geoidSimple[62][314] = (byte)-5;
	geoidSimple[62][315] = (byte)-1;
	geoidSimple[62][316] = (byte)1;
	geoidSimple[62][317] = (byte)3;
	geoidSimple[62][318] = (byte)5;
	geoidSimple[62][319] = (byte)7;
	geoidSimple[62][320] = (byte)9;
	geoidSimple[62][321] = (byte)10;
	geoidSimple[62][322] = (byte)12;
	geoidSimple[62][323] = (byte)14;
	geoidSimple[62][324] = (byte)16;
	geoidSimple[62][325] = (byte)17;
	geoidSimple[62][326] = (byte)19;
	geoidSimple[62][327] = (byte)20;
	geoidSimple[62][328] = (byte)22;
	geoidSimple[62][329] = (byte)23;
	geoidSimple[62][330] = (byte)24;
	geoidSimple[62][331] = (byte)24;
	geoidSimple[62][332] = (byte)25;
	geoidSimple[62][333] = (byte)26;
	geoidSimple[62][334] = (byte)26;
	geoidSimple[62][335] = (byte)26;
	geoidSimple[62][336] = (byte)26;
	geoidSimple[62][337] = (byte)26;
	geoidSimple[62][338] = (byte)28;
	geoidSimple[62][339] = (byte)30;
	geoidSimple[62][340] = (byte)32;
	geoidSimple[62][341] = (byte)34;
	geoidSimple[62][342] = (byte)37;
	geoidSimple[62][343] = (byte)38;
	geoidSimple[62][344] = (byte)38;
	geoidSimple[62][345] = (byte)37;
	geoidSimple[62][346] = (byte)38;
	geoidSimple[62][347] = (byte)39;
	geoidSimple[62][348] = (byte)39;
	geoidSimple[62][349] = (byte)39;
	geoidSimple[62][350] = (byte)39;
	geoidSimple[62][351] = (byte)38;
	geoidSimple[62][352] = (byte)37;
	geoidSimple[62][353] = (byte)35;
	geoidSimple[62][354] = (byte)34;
	geoidSimple[62][355] = (byte)34;
	geoidSimple[62][356] = (byte)34;
	geoidSimple[62][357] = (byte)32;
	geoidSimple[62][358] = (byte)29;
	geoidSimple[62][359] = (byte)27;
	}
		/** Row 63*/
	private static void init63() {
	geoidSimple[63][0] = (byte)25;
	geoidSimple[63][1] = (byte)25;
	geoidSimple[63][2] = (byte)25;
	geoidSimple[63][3] = (byte)26;
	geoidSimple[63][4] = (byte)28;
	geoidSimple[63][5] = (byte)30;
	geoidSimple[63][6] = (byte)31;
	geoidSimple[63][7] = (byte)30;
	geoidSimple[63][8] = (byte)30;
	geoidSimple[63][9] = (byte)30;
	geoidSimple[63][10] = (byte)29;
	geoidSimple[63][11] = (byte)28;
	geoidSimple[63][12] = (byte)27;
	geoidSimple[63][13] = (byte)26;
	geoidSimple[63][14] = (byte)26;
	geoidSimple[63][15] = (byte)27;
	geoidSimple[63][16] = (byte)29;
	geoidSimple[63][17] = (byte)30;
	geoidSimple[63][18] = (byte)28;
	geoidSimple[63][19] = (byte)26;
	geoidSimple[63][20] = (byte)24;
	geoidSimple[63][21] = (byte)22;
	geoidSimple[63][22] = (byte)21;
	geoidSimple[63][23] = (byte)18;
	geoidSimple[63][24] = (byte)16;
	geoidSimple[63][25] = (byte)14;
	geoidSimple[63][26] = (byte)14;
	geoidSimple[63][27] = (byte)13;
	geoidSimple[63][28] = (byte)13;
	geoidSimple[63][29] = (byte)12;
	geoidSimple[63][30] = (byte)13;
	geoidSimple[63][31] = (byte)12;
	geoidSimple[63][32] = (byte)13;
	geoidSimple[63][33] = (byte)14;
	geoidSimple[63][34] = (byte)12;
	geoidSimple[63][35] = (byte)12;
	geoidSimple[63][36] = (byte)13;
	geoidSimple[63][37] = (byte)14;
	geoidSimple[63][38] = (byte)12;
	geoidSimple[63][39] = (byte)12;
	geoidSimple[63][40] = (byte)11;
	geoidSimple[63][41] = (byte)9;
	geoidSimple[63][42] = (byte)6;
	geoidSimple[63][43] = (byte)3;
	geoidSimple[63][44] = (byte)0;
	geoidSimple[63][45] = (byte)-2;
	geoidSimple[63][46] = (byte)-7;
	geoidSimple[63][47] = (byte)-12;
	geoidSimple[63][48] = (byte)-17;
	geoidSimple[63][49] = (byte)-22;
	geoidSimple[63][50] = (byte)-26;
	geoidSimple[63][51] = (byte)-28;
	geoidSimple[63][52] = (byte)-29;
	geoidSimple[63][53] = (byte)-29;
	geoidSimple[63][54] = (byte)-28;
	geoidSimple[63][55] = (byte)-30;
	geoidSimple[63][56] = (byte)-29;
	geoidSimple[63][57] = (byte)-23;
	geoidSimple[63][58] = (byte)-20;
	geoidSimple[63][59] = (byte)-23;
	geoidSimple[63][60] = (byte)-24;
	geoidSimple[63][61] = (byte)-26;
	geoidSimple[63][62] = (byte)-28;
	geoidSimple[63][63] = (byte)-30;
	geoidSimple[63][64] = (byte)-31;
	geoidSimple[63][65] = (byte)-34;
	geoidSimple[63][66] = (byte)-38;
	geoidSimple[63][67] = (byte)-42;
	geoidSimple[63][68] = (byte)-44;
	geoidSimple[63][69] = (byte)-44;
	geoidSimple[63][70] = (byte)-45;
	geoidSimple[63][71] = (byte)-44;
	geoidSimple[63][72] = (byte)-44;
	geoidSimple[63][73] = (byte)-47;
	geoidSimple[63][74] = (byte)-47;
	geoidSimple[63][75] = (byte)-48;
	geoidSimple[63][76] = (byte)-52;
	geoidSimple[63][77] = (byte)-55;
	geoidSimple[63][78] = (byte)-58;
	geoidSimple[63][79] = (byte)-61;
	geoidSimple[63][80] = (byte)-63;
	geoidSimple[63][81] = (byte)-65;
	geoidSimple[63][82] = (byte)-66;
	geoidSimple[63][83] = (byte)-67;
	geoidSimple[63][84] = (byte)-66;
	geoidSimple[63][85] = (byte)-65;
	geoidSimple[63][86] = (byte)-60;
	geoidSimple[63][87] = (byte)-55;
	geoidSimple[63][88] = (byte)-51;
	geoidSimple[63][89] = (byte)-47;
	geoidSimple[63][90] = (byte)-46;
	geoidSimple[63][91] = (byte)-46;
	geoidSimple[63][92] = (byte)-48;
	geoidSimple[63][93] = (byte)-54;
	geoidSimple[63][94] = (byte)-57;
	geoidSimple[63][95] = (byte)-51;
	geoidSimple[63][96] = (byte)-48;
	geoidSimple[63][97] = (byte)-45;
	geoidSimple[63][98] = (byte)-41;
	geoidSimple[63][99] = (byte)-38;
	geoidSimple[63][100] = (byte)-36;
	geoidSimple[63][101] = (byte)-35;
	geoidSimple[63][102] = (byte)-34;
	geoidSimple[63][103] = (byte)-32;
	geoidSimple[63][104] = (byte)-30;
	geoidSimple[63][105] = (byte)-30;
	geoidSimple[63][106] = (byte)-29;
	geoidSimple[63][107] = (byte)-27;
	geoidSimple[63][108] = (byte)-25;
	geoidSimple[63][109] = (byte)-23;
	geoidSimple[63][110] = (byte)-19;
	geoidSimple[63][111] = (byte)-18;
	geoidSimple[63][112] = (byte)-16;
	geoidSimple[63][113] = (byte)-12;
	geoidSimple[63][114] = (byte)-8;
	geoidSimple[63][115] = (byte)-5;
	geoidSimple[63][116] = (byte)-1;
	geoidSimple[63][117] = (byte)3;
	geoidSimple[63][118] = (byte)7;
	geoidSimple[63][119] = (byte)10;
	geoidSimple[63][120] = (byte)13;
	geoidSimple[63][121] = (byte)16;
	geoidSimple[63][122] = (byte)19;
	geoidSimple[63][123] = (byte)22;
	geoidSimple[63][124] = (byte)25;
	geoidSimple[63][125] = (byte)28;
	geoidSimple[63][126] = (byte)30;
	geoidSimple[63][127] = (byte)31;
	geoidSimple[63][128] = (byte)29;
	geoidSimple[63][129] = (byte)24;
	geoidSimple[63][130] = (byte)27;
	geoidSimple[63][131] = (byte)32;
	geoidSimple[63][132] = (byte)34;
	geoidSimple[63][133] = (byte)35;
	geoidSimple[63][134] = (byte)35;
	geoidSimple[63][135] = (byte)37;
	geoidSimple[63][136] = (byte)39;
	geoidSimple[63][137] = (byte)40;
	geoidSimple[63][138] = (byte)42;
	geoidSimple[63][139] = (byte)43;
	geoidSimple[63][140] = (byte)43;
	geoidSimple[63][141] = (byte)39;
	geoidSimple[63][142] = (byte)42;
	geoidSimple[63][143] = (byte)33;
	geoidSimple[63][144] = (byte)36;
	geoidSimple[63][145] = (byte)36;
	geoidSimple[63][146] = (byte)33;
	geoidSimple[63][147] = (byte)31;
	geoidSimple[63][148] = (byte)28;
	geoidSimple[63][149] = (byte)26;
	geoidSimple[63][150] = (byte)25;
	geoidSimple[63][151] = (byte)23;
	geoidSimple[63][152] = (byte)21;
	geoidSimple[63][153] = (byte)18;
	geoidSimple[63][154] = (byte)16;
	geoidSimple[63][155] = (byte)15;
	geoidSimple[63][156] = (byte)12;
	geoidSimple[63][157] = (byte)11;
	geoidSimple[63][158] = (byte)9;
	geoidSimple[63][159] = (byte)8;
	geoidSimple[63][160] = (byte)6;
	geoidSimple[63][161] = (byte)5;
	geoidSimple[63][162] = (byte)4;
	geoidSimple[63][163] = (byte)2;
	geoidSimple[63][164] = (byte)1;
	geoidSimple[63][165] = (byte)0;
	geoidSimple[63][166] = (byte)0;
	geoidSimple[63][167] = (byte)-1;
	geoidSimple[63][168] = (byte)-2;
	geoidSimple[63][169] = (byte)-3;
	geoidSimple[63][170] = (byte)-4;
	geoidSimple[63][171] = (byte)-5;
	geoidSimple[63][172] = (byte)-5;
	geoidSimple[63][173] = (byte)-5;
	geoidSimple[63][174] = (byte)-5;
	geoidSimple[63][175] = (byte)-5;
	geoidSimple[63][176] = (byte)-5;
	geoidSimple[63][177] = (byte)-4;
	geoidSimple[63][178] = (byte)-3;
	geoidSimple[63][179] = (byte)-3;
	geoidSimple[63][LAT_GRID_SIZE] = (byte)-4;
	geoidSimple[63][181] = (byte)-3;
	geoidSimple[63][182] = (byte)-2;
	geoidSimple[63][183] = (byte)0;
	geoidSimple[63][184] = (byte)-2;
	geoidSimple[63][185] = (byte)-1;
	geoidSimple[63][186] = (byte)0;
	geoidSimple[63][187] = (byte)-1;
	geoidSimple[63][188] = (byte)0;
	geoidSimple[63][189] = (byte)0;
	geoidSimple[63][190] = (byte)1;
	geoidSimple[63][191] = (byte)2;
	geoidSimple[63][192] = (byte)2;
	geoidSimple[63][193] = (byte)3;
	geoidSimple[63][194] = (byte)3;
	geoidSimple[63][195] = (byte)3;
	geoidSimple[63][196] = (byte)2;
	geoidSimple[63][197] = (byte)1;
	geoidSimple[63][198] = (byte)1;
	geoidSimple[63][199] = (byte)0;
	geoidSimple[63][200] = (byte)0;
	geoidSimple[63][201] = (byte)-1;
	geoidSimple[63][202] = (byte)-2;
	geoidSimple[63][203] = (byte)-4;
	geoidSimple[63][204] = (byte)-5;
	geoidSimple[63][205] = (byte)-7;
	geoidSimple[63][206] = (byte)-8;
	geoidSimple[63][207] = (byte)-9;
	geoidSimple[63][208] = (byte)-10;
	geoidSimple[63][209] = (byte)-11;
	geoidSimple[63][210] = (byte)-12;
	geoidSimple[63][211] = (byte)-14;
	geoidSimple[63][212] = (byte)-15;
	geoidSimple[63][213] = (byte)-16;
	geoidSimple[63][214] = (byte)-17;
	geoidSimple[63][215] = (byte)-18;
	geoidSimple[63][216] = (byte)-19;
	geoidSimple[63][217] = (byte)-21;
	geoidSimple[63][218] = (byte)-22;
	geoidSimple[63][219] = (byte)-24;
	geoidSimple[63][220] = (byte)-26;
	geoidSimple[63][221] = (byte)-27;
	geoidSimple[63][222] = (byte)-29;
	geoidSimple[63][223] = (byte)-30;
	geoidSimple[63][224] = (byte)-32;
	geoidSimple[63][225] = (byte)-33;
	geoidSimple[63][226] = (byte)-35;
	geoidSimple[63][227] = (byte)-36;
	geoidSimple[63][228] = (byte)-38;
	geoidSimple[63][229] = (byte)-39;
	geoidSimple[63][230] = (byte)-41;
	geoidSimple[63][231] = (byte)-42;
	geoidSimple[63][232] = (byte)-43;
	geoidSimple[63][233] = (byte)-44;
	geoidSimple[63][234] = (byte)-45;
	geoidSimple[63][235] = (byte)-45;
	geoidSimple[63][236] = (byte)-45;
	geoidSimple[63][237] = (byte)-46;
	geoidSimple[63][238] = (byte)-45;
	geoidSimple[63][239] = (byte)-45;
	geoidSimple[63][240] = (byte)-45;
	geoidSimple[63][241] = (byte)-44;
	geoidSimple[63][242] = (byte)-44;
	geoidSimple[63][243] = (byte)-43;
	geoidSimple[63][244] = (byte)-42;
	geoidSimple[63][245] = (byte)-41;
	geoidSimple[63][246] = (byte)-38;
	geoidSimple[63][247] = (byte)-36;
	geoidSimple[63][248] = (byte)-35;
	geoidSimple[63][249] = (byte)-35;
	geoidSimple[63][250] = (byte)-32;
	geoidSimple[63][251] = (byte)-29;
	geoidSimple[63][252] = (byte)-26;
	geoidSimple[63][253] = (byte)-22;
	geoidSimple[63][254] = (byte)-22;
	geoidSimple[63][255] = (byte)-21;
	geoidSimple[63][256] = (byte)-21;
	geoidSimple[63][257] = (byte)-19;
	geoidSimple[63][258] = (byte)-19;
	geoidSimple[63][259] = (byte)-20;
	geoidSimple[63][260] = (byte)-22;
	geoidSimple[63][261] = (byte)-25;
	geoidSimple[63][262] = (byte)-25;
	geoidSimple[63][263] = (byte)-24;
	geoidSimple[63][264] = (byte)-29;
	geoidSimple[63][265] = (byte)-31;
	geoidSimple[63][266] = (byte)-29;
	geoidSimple[63][267] = (byte)-29;
	geoidSimple[63][268] = (byte)-29;
	geoidSimple[63][269] = (byte)-28;
	geoidSimple[63][270] = (byte)-27;
	geoidSimple[63][271] = (byte)-25;
	geoidSimple[63][272] = (byte)-25;
	geoidSimple[63][273] = (byte)-26;
	geoidSimple[63][274] = (byte)-28;
	geoidSimple[63][275] = (byte)-26;
	geoidSimple[63][276] = (byte)-25;
	geoidSimple[63][277] = (byte)-25;
	geoidSimple[63][278] = (byte)-26;
	geoidSimple[63][279] = (byte)-27;
	geoidSimple[63][280] = (byte)-30;
	geoidSimple[63][281] = (byte)-30;
	geoidSimple[63][282] = (byte)-33;
	geoidSimple[63][283] = (byte)-40;
	geoidSimple[63][284] = (byte)-43;
	geoidSimple[63][285] = (byte)-43;
	geoidSimple[63][286] = (byte)-46;
	geoidSimple[63][287] = (byte)-48;
	geoidSimple[63][288] = (byte)-50;
	geoidSimple[63][289] = (byte)-51;
	geoidSimple[63][290] = (byte)-52;
	geoidSimple[63][291] = (byte)-51;
	geoidSimple[63][292] = (byte)-50;
	geoidSimple[63][293] = (byte)-49;
	geoidSimple[63][294] = (byte)-49;
	geoidSimple[63][295] = (byte)-49;
	geoidSimple[63][296] = (byte)-49;
	geoidSimple[63][297] = (byte)-50;
	geoidSimple[63][298] = (byte)-49;
	geoidSimple[63][299] = (byte)-48;
	geoidSimple[63][300] = (byte)-47;
	geoidSimple[63][301] = (byte)-46;
	geoidSimple[63][302] = (byte)-44;
	geoidSimple[63][303] = (byte)-42;
	geoidSimple[63][304] = (byte)-40;
	geoidSimple[63][305] = (byte)-37;
	geoidSimple[63][306] = (byte)-34;
	geoidSimple[63][307] = (byte)-31;
	geoidSimple[63][308] = (byte)-28;
	geoidSimple[63][309] = (byte)-25;
	geoidSimple[63][310] = (byte)-22;
	geoidSimple[63][311] = (byte)-18;
	geoidSimple[63][312] = (byte)-14;
	geoidSimple[63][313] = (byte)-11;
	geoidSimple[63][314] = (byte)-7;
	geoidSimple[63][315] = (byte)-3;
	geoidSimple[63][316] = (byte)-1;
	geoidSimple[63][317] = (byte)0;
	geoidSimple[63][318] = (byte)3;
	geoidSimple[63][319] = (byte)4;
	geoidSimple[63][320] = (byte)6;
	geoidSimple[63][321] = (byte)8;
	geoidSimple[63][322] = (byte)9;
	geoidSimple[63][323] = (byte)11;
	geoidSimple[63][324] = (byte)13;
	geoidSimple[63][325] = (byte)14;
	geoidSimple[63][326] = (byte)16;
	geoidSimple[63][327] = (byte)17;
	geoidSimple[63][328] = (byte)19;
	geoidSimple[63][329] = (byte)20;
	geoidSimple[63][330] = (byte)22;
	geoidSimple[63][331] = (byte)23;
	geoidSimple[63][332] = (byte)24;
	geoidSimple[63][333] = (byte)25;
	geoidSimple[63][334] = (byte)25;
	geoidSimple[63][335] = (byte)25;
	geoidSimple[63][336] = (byte)25;
	geoidSimple[63][337] = (byte)26;
	geoidSimple[63][338] = (byte)28;
	geoidSimple[63][339] = (byte)30;
	geoidSimple[63][340] = (byte)32;
	geoidSimple[63][341] = (byte)34;
	geoidSimple[63][342] = (byte)33;
	geoidSimple[63][343] = (byte)31;
	geoidSimple[63][344] = (byte)31;
	geoidSimple[63][345] = (byte)33;
	geoidSimple[63][346] = (byte)36;
	geoidSimple[63][347] = (byte)38;
	geoidSimple[63][348] = (byte)39;
	geoidSimple[63][349] = (byte)40;
	geoidSimple[63][350] = (byte)39;
	geoidSimple[63][351] = (byte)37;
	geoidSimple[63][352] = (byte)36;
	geoidSimple[63][353] = (byte)33;
	geoidSimple[63][354] = (byte)32;
	geoidSimple[63][355] = (byte)32;
	geoidSimple[63][356] = (byte)32;
	geoidSimple[63][357] = (byte)30;
	geoidSimple[63][358] = (byte)28;
	geoidSimple[63][359] = (byte)26;
	}
		/** Row 64*/
	private static void init64() {
	geoidSimple[64][0] = (byte)26;
	geoidSimple[64][1] = (byte)26;
	geoidSimple[64][2] = (byte)27;
	geoidSimple[64][3] = (byte)30;
	geoidSimple[64][4] = (byte)32;
	geoidSimple[64][5] = (byte)34;
	geoidSimple[64][6] = (byte)34;
	geoidSimple[64][7] = (byte)34;
	geoidSimple[64][8] = (byte)34;
	geoidSimple[64][9] = (byte)32;
	geoidSimple[64][10] = (byte)30;
	geoidSimple[64][11] = (byte)29;
	geoidSimple[64][12] = (byte)27;
	geoidSimple[64][13] = (byte)26;
	geoidSimple[64][14] = (byte)25;
	geoidSimple[64][15] = (byte)26;
	geoidSimple[64][16] = (byte)28;
	geoidSimple[64][17] = (byte)28;
	geoidSimple[64][18] = (byte)26;
	geoidSimple[64][19] = (byte)24;
	geoidSimple[64][20] = (byte)22;
	geoidSimple[64][21] = (byte)20;
	geoidSimple[64][22] = (byte)20;
	geoidSimple[64][23] = (byte)17;
	geoidSimple[64][24] = (byte)16;
	geoidSimple[64][25] = (byte)14;
	geoidSimple[64][26] = (byte)13;
	geoidSimple[64][27] = (byte)12;
	geoidSimple[64][28] = (byte)12;
	geoidSimple[64][29] = (byte)12;
	geoidSimple[64][30] = (byte)12;
	geoidSimple[64][31] = (byte)12;
	geoidSimple[64][32] = (byte)12;
	geoidSimple[64][33] = (byte)13;
	geoidSimple[64][34] = (byte)12;
	geoidSimple[64][35] = (byte)11;
	geoidSimple[64][36] = (byte)10;
	geoidSimple[64][37] = (byte)11;
	geoidSimple[64][38] = (byte)10;
	geoidSimple[64][39] = (byte)10;
	geoidSimple[64][40] = (byte)10;
	geoidSimple[64][41] = (byte)9;
	geoidSimple[64][42] = (byte)6;
	geoidSimple[64][43] = (byte)3;
	geoidSimple[64][44] = (byte)0;
	geoidSimple[64][45] = (byte)-2;
	geoidSimple[64][46] = (byte)-6;
	geoidSimple[64][47] = (byte)-11;
	geoidSimple[64][48] = (byte)-17;
	geoidSimple[64][49] = (byte)-23;
	geoidSimple[64][50] = (byte)-27;
	geoidSimple[64][51] = (byte)-29;
	geoidSimple[64][52] = (byte)-30;
	geoidSimple[64][53] = (byte)-31;
	geoidSimple[64][54] = (byte)-32;
	geoidSimple[64][55] = (byte)-33;
	geoidSimple[64][56] = (byte)-27;
	geoidSimple[64][57] = (byte)-25;
	geoidSimple[64][58] = (byte)-24;
	geoidSimple[64][59] = (byte)-26;
	geoidSimple[64][60] = (byte)-27;
	geoidSimple[64][61] = (byte)-30;
	geoidSimple[64][62] = (byte)-31;
	geoidSimple[64][63] = (byte)-32;
	geoidSimple[64][64] = (byte)-34;
	geoidSimple[64][65] = (byte)-38;
	geoidSimple[64][66] = (byte)-42;
	geoidSimple[64][67] = (byte)-42;
	geoidSimple[64][68] = (byte)-44;
	geoidSimple[64][69] = (byte)-45;
	geoidSimple[64][70] = (byte)-45;
	geoidSimple[64][71] = (byte)-45;
	geoidSimple[64][72] = (byte)-47;
	geoidSimple[64][73] = (byte)-48;
	geoidSimple[64][74] = (byte)-48;
	geoidSimple[64][75] = (byte)-51;
	geoidSimple[64][76] = (byte)-54;
	geoidSimple[64][77] = (byte)-55;
	geoidSimple[64][78] = (byte)-57;
	geoidSimple[64][79] = (byte)-59;
	geoidSimple[64][80] = (byte)-61;
	geoidSimple[64][81] = (byte)-61;
	geoidSimple[64][82] = (byte)-63;
	geoidSimple[64][83] = (byte)-64;
	geoidSimple[64][84] = (byte)-64;
	geoidSimple[64][85] = (byte)-63;
	geoidSimple[64][86] = (byte)-62;
	geoidSimple[64][87] = (byte)-59;
	geoidSimple[64][88] = (byte)-55;
	geoidSimple[64][89] = (byte)-53;
	geoidSimple[64][90] = (byte)-50;
	geoidSimple[64][91] = (byte)-49;
	geoidSimple[64][92] = (byte)-48;
	geoidSimple[64][93] = (byte)-51;
	geoidSimple[64][94] = (byte)-51;
	geoidSimple[64][95] = (byte)-49;
	geoidSimple[64][96] = (byte)-47;
	geoidSimple[64][97] = (byte)-43;
	geoidSimple[64][98] = (byte)-40;
	geoidSimple[64][99] = (byte)-38;
	geoidSimple[64][100] = (byte)-37;
	geoidSimple[64][101] = (byte)-36;
	geoidSimple[64][102] = (byte)-34;
	geoidSimple[64][103] = (byte)-31;
	geoidSimple[64][104] = (byte)-30;
	geoidSimple[64][105] = (byte)-31;
	geoidSimple[64][106] = (byte)-30;
	geoidSimple[64][107] = (byte)-28;
	geoidSimple[64][108] = (byte)-25;
	geoidSimple[64][109] = (byte)-23;
	geoidSimple[64][110] = (byte)-19;
	geoidSimple[64][111] = (byte)-17;
	geoidSimple[64][112] = (byte)-14;
	geoidSimple[64][113] = (byte)-10;
	geoidSimple[64][114] = (byte)-7;
	geoidSimple[64][115] = (byte)-3;
	geoidSimple[64][116] = (byte)1;
	geoidSimple[64][117] = (byte)5;
	geoidSimple[64][118] = (byte)9;
	geoidSimple[64][119] = (byte)11;
	geoidSimple[64][120] = (byte)14;
	geoidSimple[64][121] = (byte)17;
	geoidSimple[64][122] = (byte)20;
	geoidSimple[64][123] = (byte)23;
	geoidSimple[64][124] = (byte)26;
	geoidSimple[64][125] = (byte)28;
	geoidSimple[64][126] = (byte)27;
	geoidSimple[64][127] = (byte)26;
	geoidSimple[64][128] = (byte)25;
	geoidSimple[64][129] = (byte)27;
	geoidSimple[64][130] = (byte)31;
	geoidSimple[64][131] = (byte)34;
	geoidSimple[64][132] = (byte)36;
	geoidSimple[64][133] = (byte)36;
	geoidSimple[64][134] = (byte)36;
	geoidSimple[64][135] = (byte)38;
	geoidSimple[64][136] = (byte)39;
	geoidSimple[64][137] = (byte)41;
	geoidSimple[64][138] = (byte)43;
	geoidSimple[64][139] = (byte)44;
	geoidSimple[64][140] = (byte)45;
	geoidSimple[64][141] = (byte)41;
	geoidSimple[64][142] = (byte)38;
	geoidSimple[64][143] = (byte)35;
	geoidSimple[64][144] = (byte)38;
	geoidSimple[64][145] = (byte)37;
	geoidSimple[64][146] = (byte)34;
	geoidSimple[64][147] = (byte)34;
	geoidSimple[64][148] = (byte)32;
	geoidSimple[64][149] = (byte)28;
	geoidSimple[64][150] = (byte)27;
	geoidSimple[64][151] = (byte)25;
	geoidSimple[64][152] = (byte)24;
	geoidSimple[64][153] = (byte)21;
	geoidSimple[64][154] = (byte)19;
	geoidSimple[64][155] = (byte)16;
	geoidSimple[64][156] = (byte)14;
	geoidSimple[64][157] = (byte)13;
	geoidSimple[64][158] = (byte)11;
	geoidSimple[64][159] = (byte)10;
	geoidSimple[64][160] = (byte)8;
	geoidSimple[64][161] = (byte)7;
	geoidSimple[64][162] = (byte)6;
	geoidSimple[64][163] = (byte)4;
	geoidSimple[64][164] = (byte)2;
	geoidSimple[64][165] = (byte)1;
	geoidSimple[64][166] = (byte)0;
	geoidSimple[64][167] = (byte)0;
	geoidSimple[64][168] = (byte)-1;
	geoidSimple[64][169] = (byte)-2;
	geoidSimple[64][170] = (byte)-2;
	geoidSimple[64][171] = (byte)-3;
	geoidSimple[64][172] = (byte)-4;
	geoidSimple[64][173] = (byte)-4;
	geoidSimple[64][174] = (byte)-4;
	geoidSimple[64][175] = (byte)-4;
	geoidSimple[64][176] = (byte)-4;
	geoidSimple[64][177] = (byte)-4;
	geoidSimple[64][178] = (byte)-4;
	geoidSimple[64][179] = (byte)-3;
	geoidSimple[64][LAT_GRID_SIZE] = (byte)-3;
	geoidSimple[64][181] = (byte)-2;
	geoidSimple[64][182] = (byte)-2;
	geoidSimple[64][183] = (byte)-1;
	geoidSimple[64][184] = (byte)-1;
	geoidSimple[64][185] = (byte)1;
	geoidSimple[64][186] = (byte)3;
	geoidSimple[64][187] = (byte)3;
	geoidSimple[64][188] = (byte)6;
	geoidSimple[64][189] = (byte)8;
	geoidSimple[64][190] = (byte)6;
	geoidSimple[64][191] = (byte)7;
	geoidSimple[64][192] = (byte)7;
	geoidSimple[64][193] = (byte)3;
	geoidSimple[64][194] = (byte)3;
	geoidSimple[64][195] = (byte)3;
	geoidSimple[64][196] = (byte)3;
	geoidSimple[64][197] = (byte)3;
	geoidSimple[64][198] = (byte)3;
	geoidSimple[64][199] = (byte)2;
	geoidSimple[64][200] = (byte)2;
	geoidSimple[64][201] = (byte)1;
	geoidSimple[64][202] = (byte)0;
	geoidSimple[64][203] = (byte)-1;
	geoidSimple[64][204] = (byte)-2;
	geoidSimple[64][205] = (byte)-4;
	geoidSimple[64][206] = (byte)-6;
	geoidSimple[64][207] = (byte)-8;
	geoidSimple[64][208] = (byte)-9;
	geoidSimple[64][209] = (byte)-10;
	geoidSimple[64][210] = (byte)-12;
	geoidSimple[64][211] = (byte)-13;
	geoidSimple[64][212] = (byte)-14;
	geoidSimple[64][213] = (byte)-15;
	geoidSimple[64][214] = (byte)-16;
	geoidSimple[64][215] = (byte)-18;
	geoidSimple[64][216] = (byte)-19;
	geoidSimple[64][217] = (byte)-20;
	geoidSimple[64][218] = (byte)-22;
	geoidSimple[64][219] = (byte)-23;
	geoidSimple[64][220] = (byte)-25;
	geoidSimple[64][221] = (byte)-27;
	geoidSimple[64][222] = (byte)-28;
	geoidSimple[64][223] = (byte)-30;
	geoidSimple[64][224] = (byte)-32;
	geoidSimple[64][225] = (byte)-33;
	geoidSimple[64][226] = (byte)-35;
	geoidSimple[64][227] = (byte)-36;
	geoidSimple[64][228] = (byte)-38;
	geoidSimple[64][229] = (byte)-39;
	geoidSimple[64][230] = (byte)-41;
	geoidSimple[64][231] = (byte)-42;
	geoidSimple[64][232] = (byte)-43;
	geoidSimple[64][233] = (byte)-44;
	geoidSimple[64][234] = (byte)-45;
	geoidSimple[64][235] = (byte)-45;
	geoidSimple[64][236] = (byte)-46;
	geoidSimple[64][237] = (byte)-46;
	geoidSimple[64][238] = (byte)-46;
	geoidSimple[64][239] = (byte)-46;
	geoidSimple[64][240] = (byte)-46;
	geoidSimple[64][241] = (byte)-45;
	geoidSimple[64][242] = (byte)-44;
	geoidSimple[64][243] = (byte)-44;
	geoidSimple[64][244] = (byte)-42;
	geoidSimple[64][245] = (byte)-41;
	geoidSimple[64][246] = (byte)-40;
	geoidSimple[64][247] = (byte)-37;
	geoidSimple[64][248] = (byte)-35;
	geoidSimple[64][249] = (byte)-35;
	geoidSimple[64][250] = (byte)-33;
	geoidSimple[64][251] = (byte)-30;
	geoidSimple[64][252] = (byte)-27;
	geoidSimple[64][253] = (byte)-23;
	geoidSimple[64][254] = (byte)-21;
	geoidSimple[64][255] = (byte)-20;
	geoidSimple[64][256] = (byte)-20;
	geoidSimple[64][257] = (byte)-18;
	geoidSimple[64][258] = (byte)-17;
	geoidSimple[64][259] = (byte)-17;
	geoidSimple[64][260] = (byte)-20;
	geoidSimple[64][261] = (byte)-23;
	geoidSimple[64][262] = (byte)-23;
	geoidSimple[64][263] = (byte)-23;
	geoidSimple[64][264] = (byte)-29;
	geoidSimple[64][265] = (byte)-32;
	geoidSimple[64][266] = (byte)-31;
	geoidSimple[64][267] = (byte)-29;
	geoidSimple[64][268] = (byte)-28;
	geoidSimple[64][269] = (byte)-27;
	geoidSimple[64][270] = (byte)-26;
	geoidSimple[64][271] = (byte)-26;
	geoidSimple[64][272] = (byte)-26;
	geoidSimple[64][273] = (byte)-25;
	geoidSimple[64][274] = (byte)-26;
	geoidSimple[64][275] = (byte)-26;
	geoidSimple[64][276] = (byte)-24;
	geoidSimple[64][277] = (byte)-24;
	geoidSimple[64][278] = (byte)-24;
	geoidSimple[64][279] = (byte)-26;
	geoidSimple[64][280] = (byte)-29;
	geoidSimple[64][281] = (byte)-29;
	geoidSimple[64][282] = (byte)-34;
	geoidSimple[64][283] = (byte)-39;
	geoidSimple[64][284] = (byte)-42;
	geoidSimple[64][285] = (byte)-43;
	geoidSimple[64][286] = (byte)-45;
	geoidSimple[64][287] = (byte)-48;
	geoidSimple[64][288] = (byte)-50;
	geoidSimple[64][289] = (byte)-51;
	geoidSimple[64][290] = (byte)-52;
	geoidSimple[64][291] = (byte)-52;
	geoidSimple[64][292] = (byte)-51;
	geoidSimple[64][293] = (byte)-50;
	geoidSimple[64][294] = (byte)-50;
	geoidSimple[64][295] = (byte)-50;
	geoidSimple[64][296] = (byte)-50;
	geoidSimple[64][297] = (byte)-51;
	geoidSimple[64][298] = (byte)-50;
	geoidSimple[64][299] = (byte)-49;
	geoidSimple[64][300] = (byte)-48;
	geoidSimple[64][301] = (byte)-47;
	geoidSimple[64][302] = (byte)-45;
	geoidSimple[64][303] = (byte)-43;
	geoidSimple[64][304] = (byte)-41;
	geoidSimple[64][305] = (byte)-38;
	geoidSimple[64][306] = (byte)-35;
	geoidSimple[64][307] = (byte)-33;
	geoidSimple[64][308] = (byte)-30;
	geoidSimple[64][309] = (byte)-26;
	geoidSimple[64][310] = (byte)-23;
	geoidSimple[64][311] = (byte)-20;
	geoidSimple[64][312] = (byte)-16;
	geoidSimple[64][313] = (byte)-12;
	geoidSimple[64][314] = (byte)-8;
	geoidSimple[64][315] = (byte)-6;
	geoidSimple[64][316] = (byte)-4;
	geoidSimple[64][317] = (byte)-1;
	geoidSimple[64][318] = (byte)0;
	geoidSimple[64][319] = (byte)1;
	geoidSimple[64][320] = (byte)3;
	geoidSimple[64][321] = (byte)5;
	geoidSimple[64][322] = (byte)7;
	geoidSimple[64][323] = (byte)8;
	geoidSimple[64][324] = (byte)10;
	geoidSimple[64][325] = (byte)11;
	geoidSimple[64][326] = (byte)13;
	geoidSimple[64][327] = (byte)14;
	geoidSimple[64][328] = (byte)16;
	geoidSimple[64][329] = (byte)18;
	geoidSimple[64][330] = (byte)20;
	geoidSimple[64][331] = (byte)21;
	geoidSimple[64][332] = (byte)22;
	geoidSimple[64][333] = (byte)22;
	geoidSimple[64][334] = (byte)23;
	geoidSimple[64][335] = (byte)23;
	geoidSimple[64][336] = (byte)24;
	geoidSimple[64][337] = (byte)25;
	geoidSimple[64][338] = (byte)27;
	geoidSimple[64][339] = (byte)29;
	geoidSimple[64][340] = (byte)32;
	geoidSimple[64][341] = (byte)34;
	geoidSimple[64][342] = (byte)32;
	geoidSimple[64][343] = (byte)31;
	geoidSimple[64][344] = (byte)32;
	geoidSimple[64][345] = (byte)34;
	geoidSimple[64][346] = (byte)37;
	geoidSimple[64][347] = (byte)39;
	geoidSimple[64][348] = (byte)39;
	geoidSimple[64][349] = (byte)39;
	geoidSimple[64][350] = (byte)38;
	geoidSimple[64][351] = (byte)35;
	geoidSimple[64][352] = (byte)33;
	geoidSimple[64][353] = (byte)31;
	geoidSimple[64][354] = (byte)31;
	geoidSimple[64][355] = (byte)31;
	geoidSimple[64][356] = (byte)30;
	geoidSimple[64][357] = (byte)29;
	geoidSimple[64][358] = (byte)27;
	geoidSimple[64][359] = (byte)26;
	}
		/** Row 65*/
	private static void init65() {
	geoidSimple[65][0] = (byte)28;
	geoidSimple[65][1] = (byte)29;
	geoidSimple[65][2] = (byte)29;
	geoidSimple[65][3] = (byte)32;
	geoidSimple[65][4] = (byte)34;
	geoidSimple[65][5] = (byte)36;
	geoidSimple[65][6] = (byte)36;
	geoidSimple[65][7] = (byte)36;
	geoidSimple[65][8] = (byte)35;
	geoidSimple[65][9] = (byte)34;
	geoidSimple[65][10] = (byte)32;
	geoidSimple[65][11] = (byte)29;
	geoidSimple[65][12] = (byte)27;
	geoidSimple[65][13] = (byte)26;
	geoidSimple[65][14] = (byte)25;
	geoidSimple[65][15] = (byte)25;
	geoidSimple[65][16] = (byte)27;
	geoidSimple[65][17] = (byte)27;
	geoidSimple[65][18] = (byte)25;
	geoidSimple[65][19] = (byte)23;
	geoidSimple[65][20] = (byte)21;
	geoidSimple[65][21] = (byte)19;
	geoidSimple[65][22] = (byte)17;
	geoidSimple[65][23] = (byte)15;
	geoidSimple[65][24] = (byte)14;
	geoidSimple[65][25] = (byte)14;
	geoidSimple[65][26] = (byte)13;
	geoidSimple[65][27] = (byte)13;
	geoidSimple[65][28] = (byte)13;
	geoidSimple[65][29] = (byte)12;
	geoidSimple[65][30] = (byte)12;
	geoidSimple[65][31] = (byte)12;
	geoidSimple[65][32] = (byte)11;
	geoidSimple[65][33] = (byte)11;
	geoidSimple[65][34] = (byte)12;
	geoidSimple[65][35] = (byte)10;
	geoidSimple[65][36] = (byte)8;
	geoidSimple[65][37] = (byte)8;
	geoidSimple[65][38] = (byte)10;
	geoidSimple[65][39] = (byte)8;
	geoidSimple[65][40] = (byte)8;
	geoidSimple[65][41] = (byte)8;
	geoidSimple[65][42] = (byte)6;
	geoidSimple[65][43] = (byte)3;
	geoidSimple[65][44] = (byte)0;
	geoidSimple[65][45] = (byte)-3;
	geoidSimple[65][46] = (byte)-6;
	geoidSimple[65][47] = (byte)-12;
	geoidSimple[65][48] = (byte)-18;
	geoidSimple[65][49] = (byte)-24;
	geoidSimple[65][50] = (byte)-28;
	geoidSimple[65][51] = (byte)-30;
	geoidSimple[65][52] = (byte)-32;
	geoidSimple[65][53] = (byte)-32;
	geoidSimple[65][54] = (byte)-33;
	geoidSimple[65][55] = (byte)-32;
	geoidSimple[65][56] = (byte)-25;
	geoidSimple[65][57] = (byte)-28;
	geoidSimple[65][58] = (byte)-31;
	geoidSimple[65][59] = (byte)-33;
	geoidSimple[65][60] = (byte)-34;
	geoidSimple[65][61] = (byte)-35;
	geoidSimple[65][62] = (byte)-38;
	geoidSimple[65][63] = (byte)-40;
	geoidSimple[65][64] = (byte)-43;
	geoidSimple[65][65] = (byte)-44;
	geoidSimple[65][66] = (byte)-43;
	geoidSimple[65][67] = (byte)-44;
	geoidSimple[65][68] = (byte)-45;
	geoidSimple[65][69] = (byte)-46;
	geoidSimple[65][70] = (byte)-46;
	geoidSimple[65][71] = (byte)-48;
	geoidSimple[65][72] = (byte)-48;
	geoidSimple[65][73] = (byte)-49;
	geoidSimple[65][74] = (byte)-51;
	geoidSimple[65][75] = (byte)-52;
	geoidSimple[65][76] = (byte)-54;
	geoidSimple[65][77] = (byte)-55;
	geoidSimple[65][78] = (byte)-56;
	geoidSimple[65][79] = (byte)-58;
	geoidSimple[65][80] = (byte)-59;
	geoidSimple[65][81] = (byte)-59;
	geoidSimple[65][82] = (byte)-60;
	geoidSimple[65][83] = (byte)-60;
	geoidSimple[65][84] = (byte)-60;
	geoidSimple[65][85] = (byte)-59;
	geoidSimple[65][86] = (byte)-58;
	geoidSimple[65][87] = (byte)-56;
	geoidSimple[65][88] = (byte)-55;
	geoidSimple[65][89] = (byte)-55;
	geoidSimple[65][90] = (byte)-54;
	geoidSimple[65][91] = (byte)-54;
	geoidSimple[65][92] = (byte)-54;
	geoidSimple[65][93] = (byte)-51;
	geoidSimple[65][94] = (byte)-50;
	geoidSimple[65][95] = (byte)-50;
	geoidSimple[65][96] = (byte)-47;
	geoidSimple[65][97] = (byte)-43;
	geoidSimple[65][98] = (byte)-41;
	geoidSimple[65][99] = (byte)-39;
	geoidSimple[65][100] = (byte)-38;
	geoidSimple[65][101] = (byte)-36;
	geoidSimple[65][102] = (byte)-34;
	geoidSimple[65][103] = (byte)-32;
	geoidSimple[65][104] = (byte)-31;
	geoidSimple[65][105] = (byte)-32;
	geoidSimple[65][106] = (byte)-30;
	geoidSimple[65][107] = (byte)-28;
	geoidSimple[65][108] = (byte)-26;
	geoidSimple[65][109] = (byte)-23;
	geoidSimple[65][110] = (byte)-19;
	geoidSimple[65][111] = (byte)-15;
	geoidSimple[65][112] = (byte)-12;
	geoidSimple[65][113] = (byte)-9;
	geoidSimple[65][114] = (byte)-5;
	geoidSimple[65][115] = (byte)-1;
	geoidSimple[65][116] = (byte)2;
	geoidSimple[65][117] = (byte)7;
	geoidSimple[65][118] = (byte)11;
	geoidSimple[65][119] = (byte)13;
	geoidSimple[65][120] = (byte)16;
	geoidSimple[65][121] = (byte)20;
	geoidSimple[65][122] = (byte)18;
	geoidSimple[65][123] = (byte)23;
	geoidSimple[65][124] = (byte)26;
	geoidSimple[65][125] = (byte)26;
	geoidSimple[65][126] = (byte)26;
	geoidSimple[65][127] = (byte)24;
	geoidSimple[65][128] = (byte)27;
	geoidSimple[65][129] = (byte)32;
	geoidSimple[65][130] = (byte)34;
	geoidSimple[65][131] = (byte)36;
	geoidSimple[65][132] = (byte)35;
	geoidSimple[65][133] = (byte)36;
	geoidSimple[65][134] = (byte)37;
	geoidSimple[65][135] = (byte)37;
	geoidSimple[65][136] = (byte)39;
	geoidSimple[65][137] = (byte)41;
	geoidSimple[65][138] = (byte)43;
	geoidSimple[65][139] = (byte)45;
	geoidSimple[65][140] = (byte)46;
	geoidSimple[65][141] = (byte)45;
	geoidSimple[65][142] = (byte)40;
	geoidSimple[65][143] = (byte)31;
	geoidSimple[65][144] = (byte)36;
	geoidSimple[65][145] = (byte)37;
	geoidSimple[65][146] = (byte)35;
	geoidSimple[65][147] = (byte)34;
	geoidSimple[65][148] = (byte)32;
	geoidSimple[65][149] = (byte)30;
	geoidSimple[65][150] = (byte)29;
	geoidSimple[65][151] = (byte)27;
	geoidSimple[65][152] = (byte)26;
	geoidSimple[65][153] = (byte)23;
	geoidSimple[65][154] = (byte)22;
	geoidSimple[65][155] = (byte)19;
	geoidSimple[65][156] = (byte)17;
	geoidSimple[65][157] = (byte)15;
	geoidSimple[65][158] = (byte)13;
	geoidSimple[65][159] = (byte)12;
	geoidSimple[65][160] = (byte)10;
	geoidSimple[65][161] = (byte)9;
	geoidSimple[65][162] = (byte)8;
	geoidSimple[65][163] = (byte)7;
	geoidSimple[65][164] = (byte)4;
	geoidSimple[65][165] = (byte)3;
	geoidSimple[65][166] = (byte)2;
	geoidSimple[65][167] = (byte)1;
	geoidSimple[65][168] = (byte)0;
	geoidSimple[65][169] = (byte)0;
	geoidSimple[65][170] = (byte)0;
	geoidSimple[65][171] = (byte)-1;
	geoidSimple[65][172] = (byte)-2;
	geoidSimple[65][173] = (byte)-2;
	geoidSimple[65][174] = (byte)-2;
	geoidSimple[65][175] = (byte)-3;
	geoidSimple[65][176] = (byte)-3;
	geoidSimple[65][177] = (byte)-3;
	geoidSimple[65][178] = (byte)-3;
	geoidSimple[65][179] = (byte)-2;
	geoidSimple[65][LAT_GRID_SIZE] = (byte)-2;
	geoidSimple[65][181] = (byte)-1;
	geoidSimple[65][182] = (byte)0;
	geoidSimple[65][183] = (byte)0;
	geoidSimple[65][184] = (byte)0;
	geoidSimple[65][185] = (byte)0;
	geoidSimple[65][186] = (byte)1;
	geoidSimple[65][187] = (byte)2;
	geoidSimple[65][188] = (byte)3;
	geoidSimple[65][189] = (byte)4;
	geoidSimple[65][190] = (byte)4;
	geoidSimple[65][191] = (byte)8;
	geoidSimple[65][192] = (byte)12;
	geoidSimple[65][193] = (byte)8;
	geoidSimple[65][194] = (byte)5;
	geoidSimple[65][195] = (byte)4;
	geoidSimple[65][196] = (byte)4;
	geoidSimple[65][197] = (byte)4;
	geoidSimple[65][198] = (byte)3;
	geoidSimple[65][199] = (byte)3;
	geoidSimple[65][200] = (byte)3;
	geoidSimple[65][201] = (byte)3;
	geoidSimple[65][202] = (byte)2;
	geoidSimple[65][203] = (byte)1;
	geoidSimple[65][204] = (byte)0;
	geoidSimple[65][205] = (byte)-1;
	geoidSimple[65][206] = (byte)-4;
	geoidSimple[65][207] = (byte)-6;
	geoidSimple[65][208] = (byte)-8;
	geoidSimple[65][209] = (byte)-9;
	geoidSimple[65][210] = (byte)-11;
	geoidSimple[65][211] = (byte)-12;
	geoidSimple[65][212] = (byte)-13;
	geoidSimple[65][213] = (byte)-15;
	geoidSimple[65][214] = (byte)-16;
	geoidSimple[65][215] = (byte)-17;
	geoidSimple[65][216] = (byte)-18;
	geoidSimple[65][217] = (byte)-20;
	geoidSimple[65][218] = (byte)-21;
	geoidSimple[65][219] = (byte)-23;
	geoidSimple[65][220] = (byte)-25;
	geoidSimple[65][221] = (byte)-26;
	geoidSimple[65][222] = (byte)-28;
	geoidSimple[65][223] = (byte)-30;
	geoidSimple[65][224] = (byte)-31;
	geoidSimple[65][225] = (byte)-33;
	geoidSimple[65][226] = (byte)-34;
	geoidSimple[65][227] = (byte)-36;
	geoidSimple[65][228] = (byte)-37;
	geoidSimple[65][229] = (byte)-39;
	geoidSimple[65][230] = (byte)-40;
	geoidSimple[65][231] = (byte)-41;
	geoidSimple[65][232] = (byte)-43;
	geoidSimple[65][233] = (byte)-44;
	geoidSimple[65][234] = (byte)-44;
	geoidSimple[65][235] = (byte)-45;
	geoidSimple[65][236] = (byte)-46;
	geoidSimple[65][237] = (byte)-46;
	geoidSimple[65][238] = (byte)-47;
	geoidSimple[65][239] = (byte)-46;
	geoidSimple[65][240] = (byte)-46;
	geoidSimple[65][241] = (byte)-46;
	geoidSimple[65][242] = (byte)-45;
	geoidSimple[65][243] = (byte)-44;
	geoidSimple[65][244] = (byte)-43;
	geoidSimple[65][245] = (byte)-42;
	geoidSimple[65][246] = (byte)-41;
	geoidSimple[65][247] = (byte)-38;
	geoidSimple[65][248] = (byte)-35;
	geoidSimple[65][249] = (byte)-34;
	geoidSimple[65][250] = (byte)-33;
	geoidSimple[65][251] = (byte)-31;
	geoidSimple[65][252] = (byte)-28;
	geoidSimple[65][253] = (byte)-24;
	geoidSimple[65][254] = (byte)-20;
	geoidSimple[65][255] = (byte)-19;
	geoidSimple[65][256] = (byte)-18;
	geoidSimple[65][257] = (byte)-17;
	geoidSimple[65][258] = (byte)-15;
	geoidSimple[65][259] = (byte)-14;
	geoidSimple[65][260] = (byte)-16;
	geoidSimple[65][261] = (byte)-19;
	geoidSimple[65][262] = (byte)-22;
	geoidSimple[65][263] = (byte)-24;
	geoidSimple[65][264] = (byte)-29;
	geoidSimple[65][265] = (byte)-32;
	geoidSimple[65][266] = (byte)-30;
	geoidSimple[65][267] = (byte)-28;
	geoidSimple[65][268] = (byte)-28;
	geoidSimple[65][269] = (byte)-27;
	geoidSimple[65][270] = (byte)-27;
	geoidSimple[65][271] = (byte)-27;
	geoidSimple[65][272] = (byte)-25;
	geoidSimple[65][273] = (byte)-24;
	geoidSimple[65][274] = (byte)-24;
	geoidSimple[65][275] = (byte)-26;
	geoidSimple[65][276] = (byte)-23;
	geoidSimple[65][277] = (byte)-23;
	geoidSimple[65][278] = (byte)-23;
	geoidSimple[65][279] = (byte)-25;
	geoidSimple[65][280] = (byte)-28;
	geoidSimple[65][281] = (byte)-27;
	geoidSimple[65][282] = (byte)-31;
	geoidSimple[65][283] = (byte)-33;
	geoidSimple[65][284] = (byte)-39;
	geoidSimple[65][285] = (byte)-42;
	geoidSimple[65][286] = (byte)-44;
	geoidSimple[65][287] = (byte)-47;
	geoidSimple[65][288] = (byte)-49;
	geoidSimple[65][289] = (byte)-51;
	geoidSimple[65][290] = (byte)-52;
	geoidSimple[65][291] = (byte)-52;
	geoidSimple[65][292] = (byte)-51;
	geoidSimple[65][293] = (byte)-51;
	geoidSimple[65][294] = (byte)-51;
	geoidSimple[65][295] = (byte)-51;
	geoidSimple[65][296] = (byte)-51;
	geoidSimple[65][297] = (byte)-52;
	geoidSimple[65][298] = (byte)-51;
	geoidSimple[65][299] = (byte)-50;
	geoidSimple[65][300] = (byte)-49;
	geoidSimple[65][301] = (byte)-48;
	geoidSimple[65][302] = (byte)-46;
	geoidSimple[65][303] = (byte)-44;
	geoidSimple[65][304] = (byte)-42;
	geoidSimple[65][305] = (byte)-40;
	geoidSimple[65][306] = (byte)-37;
	geoidSimple[65][307] = (byte)-34;
	geoidSimple[65][308] = (byte)-31;
	geoidSimple[65][309] = (byte)-28;
	geoidSimple[65][310] = (byte)-25;
	geoidSimple[65][311] = (byte)-21;
	geoidSimple[65][312] = (byte)-18;
	geoidSimple[65][313] = (byte)-14;
	geoidSimple[65][314] = (byte)-10;
	geoidSimple[65][315] = (byte)-8;
	geoidSimple[65][316] = (byte)-6;
	geoidSimple[65][317] = (byte)-4;
	geoidSimple[65][318] = (byte)-2;
	geoidSimple[65][319] = (byte)0;
	geoidSimple[65][320] = (byte)0;
	geoidSimple[65][321] = (byte)2;
	geoidSimple[65][322] = (byte)4;
	geoidSimple[65][323] = (byte)5;
	geoidSimple[65][324] = (byte)7;
	geoidSimple[65][325] = (byte)9;
	geoidSimple[65][326] = (byte)11;
	geoidSimple[65][327] = (byte)12;
	geoidSimple[65][328] = (byte)14;
	geoidSimple[65][329] = (byte)16;
	geoidSimple[65][330] = (byte)18;
	geoidSimple[65][331] = (byte)19;
	geoidSimple[65][332] = (byte)20;
	geoidSimple[65][333] = (byte)20;
	geoidSimple[65][334] = (byte)21;
	geoidSimple[65][335] = (byte)22;
	geoidSimple[65][336] = (byte)23;
	geoidSimple[65][337] = (byte)24;
	geoidSimple[65][338] = (byte)26;
	geoidSimple[65][339] = (byte)28;
	geoidSimple[65][340] = (byte)30;
	geoidSimple[65][341] = (byte)32;
	geoidSimple[65][342] = (byte)31;
	geoidSimple[65][343] = (byte)32;
	geoidSimple[65][344] = (byte)33;
	geoidSimple[65][345] = (byte)36;
	geoidSimple[65][346] = (byte)39;
	geoidSimple[65][347] = (byte)39;
	geoidSimple[65][348] = (byte)38;
	geoidSimple[65][349] = (byte)38;
	geoidSimple[65][350] = (byte)36;
	geoidSimple[65][351] = (byte)34;
	geoidSimple[65][352] = (byte)32;
	geoidSimple[65][353] = (byte)30;
	geoidSimple[65][354] = (byte)30;
	geoidSimple[65][355] = (byte)29;
	geoidSimple[65][356] = (byte)28;
	geoidSimple[65][357] = (byte)27;
	geoidSimple[65][358] = (byte)27;
	geoidSimple[65][359] = (byte)27;
	}
		/** Row 66*/
	private static void init66() {
	geoidSimple[66][0] = (byte)30;
	geoidSimple[66][1] = (byte)31;
	geoidSimple[66][2] = (byte)32;
	geoidSimple[66][3] = (byte)33;
	geoidSimple[66][4] = (byte)34;
	geoidSimple[66][5] = (byte)36;
	geoidSimple[66][6] = (byte)37;
	geoidSimple[66][7] = (byte)35;
	geoidSimple[66][8] = (byte)34;
	geoidSimple[66][9] = (byte)32;
	geoidSimple[66][10] = (byte)30;
	geoidSimple[66][11] = (byte)29;
	geoidSimple[66][12] = (byte)26;
	geoidSimple[66][13] = (byte)25;
	geoidSimple[66][14] = (byte)25;
	geoidSimple[66][15] = (byte)26;
	geoidSimple[66][16] = (byte)27;
	geoidSimple[66][17] = (byte)27;
	geoidSimple[66][18] = (byte)25;
	geoidSimple[66][19] = (byte)24;
	geoidSimple[66][20] = (byte)21;
	geoidSimple[66][21] = (byte)18;
	geoidSimple[66][22] = (byte)15;
	geoidSimple[66][23] = (byte)14;
	geoidSimple[66][24] = (byte)14;
	geoidSimple[66][25] = (byte)14;
	geoidSimple[66][26] = (byte)14;
	geoidSimple[66][27] = (byte)13;
	geoidSimple[66][28] = (byte)13;
	geoidSimple[66][29] = (byte)12;
	geoidSimple[66][30] = (byte)11;
	geoidSimple[66][31] = (byte)10;
	geoidSimple[66][32] = (byte)10;
	geoidSimple[66][33] = (byte)10;
	geoidSimple[66][34] = (byte)11;
	geoidSimple[66][35] = (byte)10;
	geoidSimple[66][36] = (byte)7;
	geoidSimple[66][37] = (byte)6;
	geoidSimple[66][38] = (byte)6;
	geoidSimple[66][39] = (byte)7;
	geoidSimple[66][40] = (byte)7;
	geoidSimple[66][41] = (byte)6;
	geoidSimple[66][42] = (byte)4;
	geoidSimple[66][43] = (byte)2;
	geoidSimple[66][44] = (byte)0;
	geoidSimple[66][45] = (byte)-3;
	geoidSimple[66][46] = (byte)-7;
	geoidSimple[66][47] = (byte)-13;
	geoidSimple[66][48] = (byte)-21;
	geoidSimple[66][49] = (byte)-26;
	geoidSimple[66][50] = (byte)-29;
	geoidSimple[66][51] = (byte)-31;
	geoidSimple[66][52] = (byte)-32;
	geoidSimple[66][53] = (byte)-33;
	geoidSimple[66][54] = (byte)-32;
	geoidSimple[66][55] = (byte)-32;
	geoidSimple[66][56] = (byte)-29;
	geoidSimple[66][57] = (byte)-27;
	geoidSimple[66][58] = (byte)-29;
	geoidSimple[66][59] = (byte)-35;
	geoidSimple[66][60] = (byte)-38;
	geoidSimple[66][61] = (byte)-40;
	geoidSimple[66][62] = (byte)-44;
	geoidSimple[66][63] = (byte)-45;
	geoidSimple[66][64] = (byte)-47;
	geoidSimple[66][65] = (byte)-47;
	geoidSimple[66][66] = (byte)-45;
	geoidSimple[66][67] = (byte)-46;
	geoidSimple[66][68] = (byte)-48;
	geoidSimple[66][69] = (byte)-49;
	geoidSimple[66][70] = (byte)-49;
	geoidSimple[66][71] = (byte)-51;
	geoidSimple[66][72] = (byte)-52;
	geoidSimple[66][73] = (byte)-53;
	geoidSimple[66][74] = (byte)-54;
	geoidSimple[66][75] = (byte)-55;
	geoidSimple[66][76] = (byte)-55;
	geoidSimple[66][77] = (byte)-56;
	geoidSimple[66][78] = (byte)-57;
	geoidSimple[66][79] = (byte)-58;
	geoidSimple[66][80] = (byte)-58;
	geoidSimple[66][81] = (byte)-59;
	geoidSimple[66][82] = (byte)-59;
	geoidSimple[66][83] = (byte)-58;
	geoidSimple[66][84] = (byte)-56;
	geoidSimple[66][85] = (byte)-56;
	geoidSimple[66][86] = (byte)-56;
	geoidSimple[66][87] = (byte)-55;
	geoidSimple[66][88] = (byte)-56;
	geoidSimple[66][89] = (byte)-55;
	geoidSimple[66][90] = (byte)-55;
	geoidSimple[66][91] = (byte)-54;
	geoidSimple[66][92] = (byte)-53;
	geoidSimple[66][93] = (byte)-50;
	geoidSimple[66][94] = (byte)-51;
	geoidSimple[66][95] = (byte)-49;
	geoidSimple[66][96] = (byte)-47;
	geoidSimple[66][97] = (byte)-43;
	geoidSimple[66][98] = (byte)-41;
	geoidSimple[66][99] = (byte)-39;
	geoidSimple[66][100] = (byte)-38;
	geoidSimple[66][101] = (byte)-36;
	geoidSimple[66][102] = (byte)-34;
	geoidSimple[66][103] = (byte)-32;
	geoidSimple[66][104] = (byte)-31;
	geoidSimple[66][105] = (byte)-30;
	geoidSimple[66][106] = (byte)-29;
	geoidSimple[66][107] = (byte)-27;
	geoidSimple[66][108] = (byte)-25;
	geoidSimple[66][109] = (byte)-22;
	geoidSimple[66][110] = (byte)-18;
	geoidSimple[66][111] = (byte)-14;
	geoidSimple[66][112] = (byte)-11;
	geoidSimple[66][113] = (byte)-7;
	geoidSimple[66][114] = (byte)-3;
	geoidSimple[66][115] = (byte)0;
	geoidSimple[66][116] = (byte)4;
	geoidSimple[66][117] = (byte)7;
	geoidSimple[66][118] = (byte)13;
	geoidSimple[66][119] = (byte)16;
	geoidSimple[66][120] = (byte)20;
	geoidSimple[66][121] = (byte)23;
	geoidSimple[66][122] = (byte)15;
	geoidSimple[66][123] = (byte)16;
	geoidSimple[66][124] = (byte)19;
	geoidSimple[66][125] = (byte)23;
	geoidSimple[66][126] = (byte)25;
	geoidSimple[66][127] = (byte)27;
	geoidSimple[66][128] = (byte)31;
	geoidSimple[66][129] = (byte)34;
	geoidSimple[66][130] = (byte)35;
	geoidSimple[66][131] = (byte)36;
	geoidSimple[66][132] = (byte)37;
	geoidSimple[66][133] = (byte)37;
	geoidSimple[66][134] = (byte)37;
	geoidSimple[66][135] = (byte)38;
	geoidSimple[66][136] = (byte)40;
	geoidSimple[66][137] = (byte)42;
	geoidSimple[66][138] = (byte)44;
	geoidSimple[66][139] = (byte)46;
	geoidSimple[66][140] = (byte)46;
	geoidSimple[66][141] = (byte)47;
	geoidSimple[66][142] = (byte)42;
	geoidSimple[66][143] = (byte)32;
	geoidSimple[66][144] = (byte)29;
	geoidSimple[66][145] = (byte)33;
	geoidSimple[66][146] = (byte)35;
	geoidSimple[66][147] = (byte)35;
	geoidSimple[66][148] = (byte)34;
	geoidSimple[66][149] = (byte)32;
	geoidSimple[66][150] = (byte)32;
	geoidSimple[66][151] = (byte)29;
	geoidSimple[66][152] = (byte)27;
	geoidSimple[66][153] = (byte)26;
	geoidSimple[66][154] = (byte)23;
	geoidSimple[66][155] = (byte)21;
	geoidSimple[66][156] = (byte)20;
	geoidSimple[66][157] = (byte)19;
	geoidSimple[66][158] = (byte)16;
	geoidSimple[66][159] = (byte)15;
	geoidSimple[66][160] = (byte)13;
	geoidSimple[66][161] = (byte)11;
	geoidSimple[66][162] = (byte)11;
	geoidSimple[66][163] = (byte)8;
	geoidSimple[66][164] = (byte)7;
	geoidSimple[66][165] = (byte)5;
	geoidSimple[66][166] = (byte)4;
	geoidSimple[66][167] = (byte)3;
	geoidSimple[66][168] = (byte)2;
	geoidSimple[66][169] = (byte)1;
	geoidSimple[66][170] = (byte)0;
	geoidSimple[66][171] = (byte)0;
	geoidSimple[66][172] = (byte)0;
	geoidSimple[66][173] = (byte)0;
	geoidSimple[66][174] = (byte)0;
	geoidSimple[66][175] = (byte)-1;
	geoidSimple[66][176] = (byte)-1;
	geoidSimple[66][177] = (byte)-1;
	geoidSimple[66][178] = (byte)-1;
	geoidSimple[66][179] = (byte)-1;
	geoidSimple[66][LAT_GRID_SIZE] = (byte)-1;
	geoidSimple[66][181] = (byte)-1;
	geoidSimple[66][182] = (byte)0;
	geoidSimple[66][183] = (byte)0;
	geoidSimple[66][184] = (byte)1;
	geoidSimple[66][185] = (byte)2;
	geoidSimple[66][186] = (byte)2;
	geoidSimple[66][187] = (byte)3;
	geoidSimple[66][188] = (byte)4;
	geoidSimple[66][189] = (byte)5;
	geoidSimple[66][190] = (byte)5;
	geoidSimple[66][191] = (byte)5;
	geoidSimple[66][192] = (byte)6;
	geoidSimple[66][193] = (byte)10;
	geoidSimple[66][194] = (byte)11;
	geoidSimple[66][195] = (byte)11;
	geoidSimple[66][196] = (byte)8;
	geoidSimple[66][197] = (byte)7;
	geoidSimple[66][198] = (byte)7;
	geoidSimple[66][199] = (byte)4;
	geoidSimple[66][200] = (byte)3;
	geoidSimple[66][201] = (byte)3;
	geoidSimple[66][202] = (byte)3;
	geoidSimple[66][203] = (byte)3;
	geoidSimple[66][204] = (byte)2;
	geoidSimple[66][205] = (byte)0;
	geoidSimple[66][206] = (byte)-2;
	geoidSimple[66][207] = (byte)-5;
	geoidSimple[66][208] = (byte)-7;
	geoidSimple[66][209] = (byte)-8;
	geoidSimple[66][210] = (byte)-10;
	geoidSimple[66][211] = (byte)-11;
	geoidSimple[66][212] = (byte)-13;
	geoidSimple[66][213] = (byte)-14;
	geoidSimple[66][214] = (byte)-16;
	geoidSimple[66][215] = (byte)-17;
	geoidSimple[66][216] = (byte)-19;
	geoidSimple[66][217] = (byte)-20;
	geoidSimple[66][218] = (byte)-21;
	geoidSimple[66][219] = (byte)-22;
	geoidSimple[66][220] = (byte)-24;
	geoidSimple[66][221] = (byte)-26;
	geoidSimple[66][222] = (byte)-28;
	geoidSimple[66][223] = (byte)-29;
	geoidSimple[66][224] = (byte)-31;
	geoidSimple[66][225] = (byte)-33;
	geoidSimple[66][226] = (byte)-34;
	geoidSimple[66][227] = (byte)-35;
	geoidSimple[66][228] = (byte)-37;
	geoidSimple[66][229] = (byte)-39;
	geoidSimple[66][230] = (byte)-40;
	geoidSimple[66][231] = (byte)-41;
	geoidSimple[66][232] = (byte)-42;
	geoidSimple[66][233] = (byte)-43;
	geoidSimple[66][234] = (byte)-44;
	geoidSimple[66][235] = (byte)-45;
	geoidSimple[66][236] = (byte)-46;
	geoidSimple[66][237] = (byte)-47;
	geoidSimple[66][238] = (byte)-47;
	geoidSimple[66][239] = (byte)-47;
	geoidSimple[66][240] = (byte)-47;
	geoidSimple[66][241] = (byte)-46;
	geoidSimple[66][242] = (byte)-45;
	geoidSimple[66][243] = (byte)-45;
	geoidSimple[66][244] = (byte)-43;
	geoidSimple[66][245] = (byte)-42;
	geoidSimple[66][246] = (byte)-41;
	geoidSimple[66][247] = (byte)-39;
	geoidSimple[66][248] = (byte)-36;
	geoidSimple[66][249] = (byte)-34;
	geoidSimple[66][250] = (byte)-32;
	geoidSimple[66][251] = (byte)-32;
	geoidSimple[66][252] = (byte)-29;
	geoidSimple[66][253] = (byte)-26;
	geoidSimple[66][254] = (byte)-22;
	geoidSimple[66][255] = (byte)-19;
	geoidSimple[66][256] = (byte)-17;
	geoidSimple[66][257] = (byte)-15;
	geoidSimple[66][258] = (byte)-14;
	geoidSimple[66][259] = (byte)-13;
	geoidSimple[66][260] = (byte)-13;
	geoidSimple[66][261] = (byte)-17;
	geoidSimple[66][262] = (byte)-20;
	geoidSimple[66][263] = (byte)-24;
	geoidSimple[66][264] = (byte)-28;
	geoidSimple[66][265] = (byte)-30;
	geoidSimple[66][266] = (byte)-28;
	geoidSimple[66][267] = (byte)-27;
	geoidSimple[66][268] = (byte)-28;
	geoidSimple[66][269] = (byte)-27;
	geoidSimple[66][270] = (byte)-23;
	geoidSimple[66][271] = (byte)-19;
	geoidSimple[66][272] = (byte)-19;
	geoidSimple[66][273] = (byte)-21;
	geoidSimple[66][274] = (byte)-23;
	geoidSimple[66][275] = (byte)-25;
	geoidSimple[66][276] = (byte)-24;
	geoidSimple[66][277] = (byte)-25;
	geoidSimple[66][278] = (byte)-25;
	geoidSimple[66][279] = (byte)-25;
	geoidSimple[66][280] = (byte)-25;
	geoidSimple[66][281] = (byte)-25;
	geoidSimple[66][282] = (byte)-27;
	geoidSimple[66][283] = (byte)-30;
	geoidSimple[66][284] = (byte)-33;
	geoidSimple[66][285] = (byte)-39;
	geoidSimple[66][286] = (byte)-43;
	geoidSimple[66][287] = (byte)-45;
	geoidSimple[66][288] = (byte)-48;
	geoidSimple[66][289] = (byte)-50;
	geoidSimple[66][290] = (byte)-51;
	geoidSimple[66][291] = (byte)-51;
	geoidSimple[66][292] = (byte)-52;
	geoidSimple[66][293] = (byte)-51;
	geoidSimple[66][294] = (byte)-51;
	geoidSimple[66][295] = (byte)-52;
	geoidSimple[66][296] = (byte)-52;
	geoidSimple[66][297] = (byte)-52;
	geoidSimple[66][298] = (byte)-52;
	geoidSimple[66][299] = (byte)-51;
	geoidSimple[66][300] = (byte)-49;
	geoidSimple[66][301] = (byte)-48;
	geoidSimple[66][302] = (byte)-46;
	geoidSimple[66][303] = (byte)-45;
	geoidSimple[66][304] = (byte)-43;
	geoidSimple[66][305] = (byte)-40;
	geoidSimple[66][306] = (byte)-37;
	geoidSimple[66][307] = (byte)-35;
	geoidSimple[66][308] = (byte)-32;
	geoidSimple[66][309] = (byte)-29;
	geoidSimple[66][310] = (byte)-26;
	geoidSimple[66][311] = (byte)-23;
	geoidSimple[66][312] = (byte)-20;
	geoidSimple[66][313] = (byte)-16;
	geoidSimple[66][314] = (byte)-13;
	geoidSimple[66][315] = (byte)-11;
	geoidSimple[66][316] = (byte)-8;
	geoidSimple[66][317] = (byte)-7;
	geoidSimple[66][318] = (byte)-5;
	geoidSimple[66][319] = (byte)-3;
	geoidSimple[66][320] = (byte)-1;
	geoidSimple[66][321] = (byte)0;
	geoidSimple[66][322] = (byte)1;
	geoidSimple[66][323] = (byte)3;
	geoidSimple[66][324] = (byte)5;
	geoidSimple[66][325] = (byte)7;
	geoidSimple[66][326] = (byte)9;
	geoidSimple[66][327] = (byte)12;
	geoidSimple[66][328] = (byte)14;
	geoidSimple[66][329] = (byte)16;
	geoidSimple[66][330] = (byte)17;
	geoidSimple[66][331] = (byte)17;
	geoidSimple[66][332] = (byte)18;
	geoidSimple[66][333] = (byte)19;
	geoidSimple[66][334] = (byte)20;
	geoidSimple[66][335] = (byte)22;
	geoidSimple[66][336] = (byte)23;
	geoidSimple[66][337] = (byte)24;
	geoidSimple[66][338] = (byte)25;
	geoidSimple[66][339] = (byte)26;
	geoidSimple[66][340] = (byte)27;
	geoidSimple[66][341] = (byte)29;
	geoidSimple[66][342] = (byte)31;
	geoidSimple[66][343] = (byte)34;
	geoidSimple[66][344] = (byte)35;
	geoidSimple[66][345] = (byte)38;
	geoidSimple[66][346] = (byte)39;
	geoidSimple[66][347] = (byte)38;
	geoidSimple[66][348] = (byte)37;
	geoidSimple[66][349] = (byte)36;
	geoidSimple[66][350] = (byte)34;
	geoidSimple[66][351] = (byte)32;
	geoidSimple[66][352] = (byte)31;
	geoidSimple[66][353] = (byte)30;
	geoidSimple[66][354] = (byte)28;
	geoidSimple[66][355] = (byte)26;
	geoidSimple[66][356] = (byte)26;
	geoidSimple[66][357] = (byte)25;
	geoidSimple[66][358] = (byte)26;
	geoidSimple[66][359] = (byte)28;
	}
		/** Row 67*/
	private static void init67() {
	geoidSimple[67][0] = (byte)30;
	geoidSimple[67][1] = (byte)31;
	geoidSimple[67][2] = (byte)32;
	geoidSimple[67][3] = (byte)32;
	geoidSimple[67][4] = (byte)32;
	geoidSimple[67][5] = (byte)34;
	geoidSimple[67][6] = (byte)32;
	geoidSimple[67][7] = (byte)31;
	geoidSimple[67][8] = (byte)31;
	geoidSimple[67][9] = (byte)29;
	geoidSimple[67][10] = (byte)28;
	geoidSimple[67][11] = (byte)27;
	geoidSimple[67][12] = (byte)25;
	geoidSimple[67][13] = (byte)24;
	geoidSimple[67][14] = (byte)24;
	geoidSimple[67][15] = (byte)26;
	geoidSimple[67][16] = (byte)26;
	geoidSimple[67][17] = (byte)27;
	geoidSimple[67][18] = (byte)26;
	geoidSimple[67][19] = (byte)23;
	geoidSimple[67][20] = (byte)19;
	geoidSimple[67][21] = (byte)16;
	geoidSimple[67][22] = (byte)14;
	geoidSimple[67][23] = (byte)13;
	geoidSimple[67][24] = (byte)13;
	geoidSimple[67][25] = (byte)14;
	geoidSimple[67][26] = (byte)14;
	geoidSimple[67][27] = (byte)13;
	geoidSimple[67][28] = (byte)13;
	geoidSimple[67][29] = (byte)12;
	geoidSimple[67][30] = (byte)10;
	geoidSimple[67][31] = (byte)9;
	geoidSimple[67][32] = (byte)9;
	geoidSimple[67][33] = (byte)9;
	geoidSimple[67][34] = (byte)11;
	geoidSimple[67][35] = (byte)9;
	geoidSimple[67][36] = (byte)7;
	geoidSimple[67][37] = (byte)5;
	geoidSimple[67][38] = (byte)5;
	geoidSimple[67][39] = (byte)5;
	geoidSimple[67][40] = (byte)6;
	geoidSimple[67][41] = (byte)5;
	geoidSimple[67][42] = (byte)3;
	geoidSimple[67][43] = (byte)1;
	geoidSimple[67][44] = (byte)-1;
	geoidSimple[67][45] = (byte)-5;
	geoidSimple[67][46] = (byte)-9;
	geoidSimple[67][47] = (byte)-16;
	geoidSimple[67][48] = (byte)-22;
	geoidSimple[67][49] = (byte)-27;
	geoidSimple[67][50] = (byte)-31;
	geoidSimple[67][51] = (byte)-32;
	geoidSimple[67][52] = (byte)-33;
	geoidSimple[67][53] = (byte)-33;
	geoidSimple[67][54] = (byte)-33;
	geoidSimple[67][55] = (byte)-33;
	geoidSimple[67][56] = (byte)-33;
	geoidSimple[67][57] = (byte)-30;
	geoidSimple[67][58] = (byte)-28;
	geoidSimple[67][59] = (byte)-31;
	geoidSimple[67][60] = (byte)-38;
	geoidSimple[67][61] = (byte)-40;
	geoidSimple[67][62] = (byte)-44;
	geoidSimple[67][63] = (byte)-44;
	geoidSimple[67][64] = (byte)-45;
	geoidSimple[67][65] = (byte)-47;
	geoidSimple[67][66] = (byte)-49;
	geoidSimple[67][67] = (byte)-50;
	geoidSimple[67][68] = (byte)-51;
	geoidSimple[67][69] = (byte)-52;
	geoidSimple[67][70] = (byte)-53;
	geoidSimple[67][71] = (byte)-55;
	geoidSimple[67][72] = (byte)-56;
	geoidSimple[67][73] = (byte)-57;
	geoidSimple[67][74] = (byte)-57;
	geoidSimple[67][75] = (byte)-58;
	geoidSimple[67][76] = (byte)-58;
	geoidSimple[67][77] = (byte)-59;
	geoidSimple[67][78] = (byte)-59;
	geoidSimple[67][79] = (byte)-58;
	geoidSimple[67][80] = (byte)-58;
	geoidSimple[67][81] = (byte)-59;
	geoidSimple[67][82] = (byte)-60;
	geoidSimple[67][83] = (byte)-59;
	geoidSimple[67][84] = (byte)-57;
	geoidSimple[67][85] = (byte)-56;
	geoidSimple[67][86] = (byte)-57;
	geoidSimple[67][87] = (byte)-57;
	geoidSimple[67][88] = (byte)-56;
	geoidSimple[67][89] = (byte)-56;
	geoidSimple[67][90] = (byte)-55;
	geoidSimple[67][91] = (byte)-54;
	geoidSimple[67][92] = (byte)-52;
	geoidSimple[67][93] = (byte)-50;
	geoidSimple[67][94] = (byte)-51;
	geoidSimple[67][95] = (byte)-50;
	geoidSimple[67][96] = (byte)-46;
	geoidSimple[67][97] = (byte)-43;
	geoidSimple[67][98] = (byte)-41;
	geoidSimple[67][99] = (byte)-39;
	geoidSimple[67][100] = (byte)-37;
	geoidSimple[67][101] = (byte)-36;
	geoidSimple[67][102] = (byte)-33;
	geoidSimple[67][103] = (byte)-31;
	geoidSimple[67][104] = (byte)-30;
	geoidSimple[67][105] = (byte)-29;
	geoidSimple[67][106] = (byte)-28;
	geoidSimple[67][107] = (byte)-26;
	geoidSimple[67][108] = (byte)-23;
	geoidSimple[67][109] = (byte)-20;
	geoidSimple[67][110] = (byte)-16;
	geoidSimple[67][111] = (byte)-12;
	geoidSimple[67][112] = (byte)-9;
	geoidSimple[67][113] = (byte)-5;
	geoidSimple[67][114] = (byte)-1;
	geoidSimple[67][115] = (byte)1;
	geoidSimple[67][116] = (byte)5;
	geoidSimple[67][117] = (byte)10;
	geoidSimple[67][118] = (byte)14;
	geoidSimple[67][119] = (byte)17;
	geoidSimple[67][120] = (byte)21;
	geoidSimple[67][121] = (byte)23;
	geoidSimple[67][122] = (byte)20;
	geoidSimple[67][123] = (byte)20;
	geoidSimple[67][124] = (byte)22;
	geoidSimple[67][125] = (byte)26;
	geoidSimple[67][126] = (byte)29;
	geoidSimple[67][127] = (byte)31;
	geoidSimple[67][128] = (byte)33;
	geoidSimple[67][129] = (byte)34;
	geoidSimple[67][130] = (byte)35;
	geoidSimple[67][131] = (byte)36;
	geoidSimple[67][132] = (byte)37;
	geoidSimple[67][133] = (byte)38;
	geoidSimple[67][134] = (byte)39;
	geoidSimple[67][135] = (byte)39;
	geoidSimple[67][136] = (byte)40;
	geoidSimple[67][137] = (byte)43;
	geoidSimple[67][138] = (byte)45;
	geoidSimple[67][139] = (byte)46;
	geoidSimple[67][140] = (byte)47;
	geoidSimple[67][141] = (byte)47;
	geoidSimple[67][142] = (byte)46;
	geoidSimple[67][143] = (byte)40;
	geoidSimple[67][144] = (byte)33;
	geoidSimple[67][145] = (byte)26;
	geoidSimple[67][146] = (byte)30;
	geoidSimple[67][147] = (byte)35;
	geoidSimple[67][148] = (byte)36;
	geoidSimple[67][149] = (byte)35;
	geoidSimple[67][150] = (byte)33;
	geoidSimple[67][151] = (byte)31;
	geoidSimple[67][152] = (byte)29;
	geoidSimple[67][153] = (byte)28;
	geoidSimple[67][154] = (byte)25;
	geoidSimple[67][155] = (byte)24;
	geoidSimple[67][156] = (byte)21;
	geoidSimple[67][157] = (byte)20;
	geoidSimple[67][158] = (byte)18;
	geoidSimple[67][159] = (byte)16;
	geoidSimple[67][160] = (byte)14;
	geoidSimple[67][161] = (byte)13;
	geoidSimple[67][162] = (byte)12;
	geoidSimple[67][163] = (byte)10;
	geoidSimple[67][164] = (byte)9;
	geoidSimple[67][165] = (byte)8;
	geoidSimple[67][166] = (byte)6;
	geoidSimple[67][167] = (byte)5;
	geoidSimple[67][168] = (byte)4;
	geoidSimple[67][169] = (byte)3;
	geoidSimple[67][170] = (byte)2;
	geoidSimple[67][171] = (byte)2;
	geoidSimple[67][172] = (byte)1;
	geoidSimple[67][173] = (byte)1;
	geoidSimple[67][174] = (byte)1;
	geoidSimple[67][175] = (byte)1;
	geoidSimple[67][176] = (byte)0;
	geoidSimple[67][177] = (byte)0;
	geoidSimple[67][178] = (byte)0;
	geoidSimple[67][179] = (byte)0;
	geoidSimple[67][LAT_GRID_SIZE] = (byte)0;
	geoidSimple[67][181] = (byte)0;
	geoidSimple[67][182] = (byte)0;
	geoidSimple[67][183] = (byte)1;
	geoidSimple[67][184] = (byte)1;
	geoidSimple[67][185] = (byte)2;
	geoidSimple[67][186] = (byte)4;
	geoidSimple[67][187] = (byte)5;
	geoidSimple[67][188] = (byte)6;
	geoidSimple[67][189] = (byte)7;
	geoidSimple[67][190] = (byte)7;
	geoidSimple[67][191] = (byte)7;
	geoidSimple[67][192] = (byte)7;
	geoidSimple[67][193] = (byte)7;
	geoidSimple[67][194] = (byte)7;
	geoidSimple[67][195] = (byte)8;
	geoidSimple[67][196] = (byte)8;
	geoidSimple[67][197] = (byte)9;
	geoidSimple[67][198] = (byte)9;
	geoidSimple[67][199] = (byte)7;
	geoidSimple[67][200] = (byte)8;
	geoidSimple[67][201] = (byte)4;
	geoidSimple[67][202] = (byte)2;
	geoidSimple[67][203] = (byte)1;
	geoidSimple[67][204] = (byte)1;
	geoidSimple[67][205] = (byte)0;
	geoidSimple[67][206] = (byte)-1;
	geoidSimple[67][207] = (byte)-3;
	geoidSimple[67][208] = (byte)-6;
	geoidSimple[67][209] = (byte)-8;
	geoidSimple[67][210] = (byte)-9;
	geoidSimple[67][211] = (byte)-11;
	geoidSimple[67][212] = (byte)-12;
	geoidSimple[67][213] = (byte)-14;
	geoidSimple[67][214] = (byte)-15;
	geoidSimple[67][215] = (byte)-17;
	geoidSimple[67][216] = (byte)-18;
	geoidSimple[67][217] = (byte)-20;
	geoidSimple[67][218] = (byte)-21;
	geoidSimple[67][219] = (byte)-23;
	geoidSimple[67][220] = (byte)-24;
	geoidSimple[67][221] = (byte)-26;
	geoidSimple[67][222] = (byte)-27;
	geoidSimple[67][223] = (byte)-29;
	geoidSimple[67][224] = (byte)-31;
	geoidSimple[67][225] = (byte)-32;
	geoidSimple[67][226] = (byte)-34;
	geoidSimple[67][227] = (byte)-35;
	geoidSimple[67][228] = (byte)-37;
	geoidSimple[67][229] = (byte)-38;
	geoidSimple[67][230] = (byte)-40;
	geoidSimple[67][231] = (byte)-41;
	geoidSimple[67][232] = (byte)-42;
	geoidSimple[67][233] = (byte)-43;
	geoidSimple[67][234] = (byte)-44;
	geoidSimple[67][235] = (byte)-45;
	geoidSimple[67][236] = (byte)-46;
	geoidSimple[67][237] = (byte)-47;
	geoidSimple[67][238] = (byte)-47;
	geoidSimple[67][239] = (byte)-47;
	geoidSimple[67][240] = (byte)-47;
	geoidSimple[67][241] = (byte)-46;
	geoidSimple[67][242] = (byte)-46;
	geoidSimple[67][243] = (byte)-45;
	geoidSimple[67][244] = (byte)-44;
	geoidSimple[67][245] = (byte)-42;
	geoidSimple[67][246] = (byte)-41;
	geoidSimple[67][247] = (byte)-39;
	geoidSimple[67][248] = (byte)-37;
	geoidSimple[67][249] = (byte)-35;
	geoidSimple[67][250] = (byte)-33;
	geoidSimple[67][251] = (byte)-32;
	geoidSimple[67][252] = (byte)-30;
	geoidSimple[67][253] = (byte)-27;
	geoidSimple[67][254] = (byte)-24;
	geoidSimple[67][255] = (byte)-20;
	geoidSimple[67][256] = (byte)-16;
	geoidSimple[67][257] = (byte)-14;
	geoidSimple[67][258] = (byte)-13;
	geoidSimple[67][259] = (byte)-13;
	geoidSimple[67][260] = (byte)-13;
	geoidSimple[67][261] = (byte)-15;
	geoidSimple[67][262] = (byte)-18;
	geoidSimple[67][263] = (byte)-22;
	geoidSimple[67][264] = (byte)-26;
	geoidSimple[67][265] = (byte)-27;
	geoidSimple[67][266] = (byte)-25;
	geoidSimple[67][267] = (byte)-25;
	geoidSimple[67][268] = (byte)-23;
	geoidSimple[67][269] = (byte)-19;
	geoidSimple[67][270] = (byte)-16;
	geoidSimple[67][271] = (byte)-15;
	geoidSimple[67][272] = (byte)-15;
	geoidSimple[67][273] = (byte)-16;
	geoidSimple[67][274] = (byte)-19;
	geoidSimple[67][275] = (byte)-21;
	geoidSimple[67][276] = (byte)-19;
	geoidSimple[67][277] = (byte)-18;
	geoidSimple[67][278] = (byte)-19;
	geoidSimple[67][279] = (byte)-21;
	geoidSimple[67][280] = (byte)-23;
	geoidSimple[67][281] = (byte)-24;
	geoidSimple[67][282] = (byte)-24;
	geoidSimple[67][283] = (byte)-27;
	geoidSimple[67][284] = (byte)-33;
	geoidSimple[67][285] = (byte)-36;
	geoidSimple[67][286] = (byte)-39;
	geoidSimple[67][287] = (byte)-44;
	geoidSimple[67][288] = (byte)-47;
	geoidSimple[67][289] = (byte)-49;
	geoidSimple[67][290] = (byte)-50;
	geoidSimple[67][291] = (byte)-50;
	geoidSimple[67][292] = (byte)-51;
	geoidSimple[67][293] = (byte)-51;
	geoidSimple[67][294] = (byte)-51;
	geoidSimple[67][295] = (byte)-52;
	geoidSimple[67][296] = (byte)-52;
	geoidSimple[67][297] = (byte)-52;
	geoidSimple[67][298] = (byte)-51;
	geoidSimple[67][299] = (byte)-50;
	geoidSimple[67][300] = (byte)-49;
	geoidSimple[67][301] = (byte)-48;
	geoidSimple[67][302] = (byte)-46;
	geoidSimple[67][303] = (byte)-45;
	geoidSimple[67][304] = (byte)-43;
	geoidSimple[67][305] = (byte)-40;
	geoidSimple[67][306] = (byte)-38;
	geoidSimple[67][307] = (byte)-36;
	geoidSimple[67][308] = (byte)-33;
	geoidSimple[67][309] = (byte)-31;
	geoidSimple[67][310] = (byte)-28;
	geoidSimple[67][311] = (byte)-24;
	geoidSimple[67][312] = (byte)-21;
	geoidSimple[67][313] = (byte)-18;
	geoidSimple[67][314] = (byte)-14;
	geoidSimple[67][315] = (byte)-12;
	geoidSimple[67][316] = (byte)-11;
	geoidSimple[67][317] = (byte)-9;
	geoidSimple[67][318] = (byte)-7;
	geoidSimple[67][319] = (byte)-6;
	geoidSimple[67][320] = (byte)-4;
	geoidSimple[67][321] = (byte)-2;
	geoidSimple[67][322] = (byte)0;
	geoidSimple[67][323] = (byte)2;
	geoidSimple[67][324] = (byte)4;
	geoidSimple[67][325] = (byte)7;
	geoidSimple[67][326] = (byte)9;
	geoidSimple[67][327] = (byte)12;
	geoidSimple[67][328] = (byte)14;
	geoidSimple[67][329] = (byte)15;
	geoidSimple[67][330] = (byte)16;
	geoidSimple[67][331] = (byte)16;
	geoidSimple[67][332] = (byte)17;
	geoidSimple[67][333] = (byte)18;
	geoidSimple[67][334] = (byte)19;
	geoidSimple[67][335] = (byte)21;
	geoidSimple[67][336] = (byte)22;
	geoidSimple[67][337] = (byte)23;
	geoidSimple[67][338] = (byte)24;
	geoidSimple[67][339] = (byte)24;
	geoidSimple[67][340] = (byte)25;
	geoidSimple[67][341] = (byte)26;
	geoidSimple[67][342] = (byte)29;
	geoidSimple[67][343] = (byte)34;
	geoidSimple[67][344] = (byte)36;
	geoidSimple[67][345] = (byte)36;
	geoidSimple[67][346] = (byte)37;
	geoidSimple[67][347] = (byte)38;
	geoidSimple[67][348] = (byte)37;
	geoidSimple[67][349] = (byte)35;
	geoidSimple[67][350] = (byte)33;
	geoidSimple[67][351] = (byte)31;
	geoidSimple[67][352] = (byte)30;
	geoidSimple[67][353] = (byte)28;
	geoidSimple[67][354] = (byte)26;
	geoidSimple[67][355] = (byte)25;
	geoidSimple[67][356] = (byte)24;
	geoidSimple[67][357] = (byte)25;
	geoidSimple[67][358] = (byte)27;
	geoidSimple[67][359] = (byte)28;
	}
		/** Row 68*/
	private static void init68() {
	geoidSimple[68][0] = (byte)30;
	geoidSimple[68][1] = (byte)31;
	geoidSimple[68][2] = (byte)31;
	geoidSimple[68][3] = (byte)31;
	geoidSimple[68][4] = (byte)30;
	geoidSimple[68][5] = (byte)30;
	geoidSimple[68][6] = (byte)29;
	geoidSimple[68][7] = (byte)28;
	geoidSimple[68][8] = (byte)28;
	geoidSimple[68][9] = (byte)28;
	geoidSimple[68][10] = (byte)26;
	geoidSimple[68][11] = (byte)25;
	geoidSimple[68][12] = (byte)23;
	geoidSimple[68][13] = (byte)22;
	geoidSimple[68][14] = (byte)22;
	geoidSimple[68][15] = (byte)24;
	geoidSimple[68][16] = (byte)27;
	geoidSimple[68][17] = (byte)28;
	geoidSimple[68][18] = (byte)29;
	geoidSimple[68][19] = (byte)22;
	geoidSimple[68][20] = (byte)17;
	geoidSimple[68][21] = (byte)15;
	geoidSimple[68][22] = (byte)13;
	geoidSimple[68][23] = (byte)12;
	geoidSimple[68][24] = (byte)13;
	geoidSimple[68][25] = (byte)15;
	geoidSimple[68][26] = (byte)15;
	geoidSimple[68][27] = (byte)13;
	geoidSimple[68][28] = (byte)12;
	geoidSimple[68][29] = (byte)11;
	geoidSimple[68][30] = (byte)10;
	geoidSimple[68][31] = (byte)9;
	geoidSimple[68][32] = (byte)9;
	geoidSimple[68][33] = (byte)9;
	geoidSimple[68][34] = (byte)9;
	geoidSimple[68][35] = (byte)9;
	geoidSimple[68][36] = (byte)7;
	geoidSimple[68][37] = (byte)5;
	geoidSimple[68][38] = (byte)4;
	geoidSimple[68][39] = (byte)4;
	geoidSimple[68][40] = (byte)6;
	geoidSimple[68][41] = (byte)5;
	geoidSimple[68][42] = (byte)2;
	geoidSimple[68][43] = (byte)0;
	geoidSimple[68][44] = (byte)-4;
	geoidSimple[68][45] = (byte)-8;
	geoidSimple[68][46] = (byte)-13;
	geoidSimple[68][47] = (byte)-19;
	geoidSimple[68][48] = (byte)-25;
	geoidSimple[68][49] = (byte)-29;
	geoidSimple[68][50] = (byte)-31;
	geoidSimple[68][51] = (byte)-33;
	geoidSimple[68][52] = (byte)-34;
	geoidSimple[68][53] = (byte)-34;
	geoidSimple[68][54] = (byte)-35;
	geoidSimple[68][55] = (byte)-35;
	geoidSimple[68][56] = (byte)-34;
	geoidSimple[68][57] = (byte)-32;
	geoidSimple[68][58] = (byte)-32;
	geoidSimple[68][59] = (byte)-34;
	geoidSimple[68][60] = (byte)-39;
	geoidSimple[68][61] = (byte)-41;
	geoidSimple[68][62] = (byte)-45;
	geoidSimple[68][63] = (byte)-45;
	geoidSimple[68][64] = (byte)-48;
	geoidSimple[68][65] = (byte)-52;
	geoidSimple[68][66] = (byte)-53;
	geoidSimple[68][67] = (byte)-55;
	geoidSimple[68][68] = (byte)-55;
	geoidSimple[68][69] = (byte)-54;
	geoidSimple[68][70] = (byte)-55;
	geoidSimple[68][71] = (byte)-57;
	geoidSimple[68][72] = (byte)-59;
	geoidSimple[68][73] = (byte)-60;
	geoidSimple[68][74] = (byte)-60;
	geoidSimple[68][75] = (byte)-61;
	geoidSimple[68][76] = (byte)-61;
	geoidSimple[68][77] = (byte)-60;
	geoidSimple[68][78] = (byte)-60;
	geoidSimple[68][79] = (byte)-61;
	geoidSimple[68][80] = (byte)-62;
	geoidSimple[68][81] = (byte)-63;
	geoidSimple[68][82] = (byte)-62;
	geoidSimple[68][83] = (byte)-61;
	geoidSimple[68][84] = (byte)-59;
	geoidSimple[68][85] = (byte)-58;
	geoidSimple[68][86] = (byte)-59;
	geoidSimple[68][87] = (byte)-59;
	geoidSimple[68][88] = (byte)-58;
	geoidSimple[68][89] = (byte)-57;
	geoidSimple[68][90] = (byte)-56;
	geoidSimple[68][91] = (byte)-55;
	geoidSimple[68][92] = (byte)-53;
	geoidSimple[68][93] = (byte)-50;
	geoidSimple[68][94] = (byte)-52;
	geoidSimple[68][95] = (byte)-50;
	geoidSimple[68][96] = (byte)-45;
	geoidSimple[68][97] = (byte)-42;
	geoidSimple[68][98] = (byte)-41;
	geoidSimple[68][99] = (byte)-38;
	geoidSimple[68][100] = (byte)-37;
	geoidSimple[68][101] = (byte)-35;
	geoidSimple[68][102] = (byte)-33;
	geoidSimple[68][103] = (byte)-32;
	geoidSimple[68][104] = (byte)-30;
	geoidSimple[68][105] = (byte)-29;
	geoidSimple[68][106] = (byte)-27;
	geoidSimple[68][107] = (byte)-23;
	geoidSimple[68][108] = (byte)-21;
	geoidSimple[68][109] = (byte)-18;
	geoidSimple[68][110] = (byte)-15;
	geoidSimple[68][111] = (byte)-11;
	geoidSimple[68][112] = (byte)-7;
	geoidSimple[68][113] = (byte)-3;
	geoidSimple[68][114] = (byte)0;
	geoidSimple[68][115] = (byte)3;
	geoidSimple[68][116] = (byte)8;
	geoidSimple[68][117] = (byte)12;
	geoidSimple[68][118] = (byte)15;
	geoidSimple[68][119] = (byte)17;
	geoidSimple[68][120] = (byte)19;
	geoidSimple[68][121] = (byte)23;
	geoidSimple[68][122] = (byte)24;
	geoidSimple[68][123] = (byte)25;
	geoidSimple[68][124] = (byte)28;
	geoidSimple[68][125] = (byte)30;
	geoidSimple[68][126] = (byte)32;
	geoidSimple[68][127] = (byte)33;
	geoidSimple[68][128] = (byte)35;
	geoidSimple[68][129] = (byte)35;
	geoidSimple[68][130] = (byte)35;
	geoidSimple[68][131] = (byte)36;
	geoidSimple[68][132] = (byte)37;
	geoidSimple[68][133] = (byte)38;
	geoidSimple[68][134] = (byte)39;
	geoidSimple[68][135] = (byte)40;
	geoidSimple[68][136] = (byte)42;
	geoidSimple[68][137] = (byte)44;
	geoidSimple[68][138] = (byte)46;
	geoidSimple[68][139] = (byte)47;
	geoidSimple[68][140] = (byte)47;
	geoidSimple[68][141] = (byte)48;
	geoidSimple[68][142] = (byte)48;
	geoidSimple[68][143] = (byte)47;
	geoidSimple[68][144] = (byte)42;
	geoidSimple[68][145] = (byte)33;
	geoidSimple[68][146] = (byte)28;
	geoidSimple[68][147] = (byte)33;
	geoidSimple[68][148] = (byte)37;
	geoidSimple[68][149] = (byte)36;
	geoidSimple[68][150] = (byte)35;
	geoidSimple[68][151] = (byte)33;
	geoidSimple[68][152] = (byte)31;
	geoidSimple[68][153] = (byte)30;
	geoidSimple[68][154] = (byte)28;
	geoidSimple[68][155] = (byte)25;
	geoidSimple[68][156] = (byte)23;
	geoidSimple[68][157] = (byte)21;
	geoidSimple[68][158] = (byte)20;
	geoidSimple[68][159] = (byte)19;
	geoidSimple[68][160] = (byte)17;
	geoidSimple[68][161] = (byte)16;
	geoidSimple[68][162] = (byte)14;
	geoidSimple[68][163] = (byte)13;
	geoidSimple[68][164] = (byte)11;
	geoidSimple[68][165] = (byte)10;
	geoidSimple[68][166] = (byte)9;
	geoidSimple[68][167] = (byte)8;
	geoidSimple[68][168] = (byte)7;
	geoidSimple[68][169] = (byte)6;
	geoidSimple[68][170] = (byte)5;
	geoidSimple[68][171] = (byte)4;
	geoidSimple[68][172] = (byte)3;
	geoidSimple[68][173] = (byte)3;
	geoidSimple[68][174] = (byte)3;
	geoidSimple[68][175] = (byte)3;
	geoidSimple[68][176] = (byte)3;
	geoidSimple[68][177] = (byte)3;
	geoidSimple[68][178] = (byte)3;
	geoidSimple[68][179] = (byte)2;
	geoidSimple[68][LAT_GRID_SIZE] = (byte)1;
	geoidSimple[68][181] = (byte)1;
	geoidSimple[68][182] = (byte)1;
	geoidSimple[68][183] = (byte)1;
	geoidSimple[68][184] = (byte)2;
	geoidSimple[68][185] = (byte)3;
	geoidSimple[68][186] = (byte)4;
	geoidSimple[68][187] = (byte)5;
	geoidSimple[68][188] = (byte)6;
	geoidSimple[68][189] = (byte)7;
	geoidSimple[68][190] = (byte)8;
	geoidSimple[68][191] = (byte)8;
	geoidSimple[68][192] = (byte)9;
	geoidSimple[68][193] = (byte)9;
	geoidSimple[68][194] = (byte)9;
	geoidSimple[68][195] = (byte)8;
	geoidSimple[68][196] = (byte)8;
	geoidSimple[68][197] = (byte)7;
	geoidSimple[68][198] = (byte)7;
	geoidSimple[68][199] = (byte)9;
	geoidSimple[68][200] = (byte)11;
	geoidSimple[68][201] = (byte)10;
	geoidSimple[68][202] = (byte)10;
	geoidSimple[68][203] = (byte)4;
	geoidSimple[68][204] = (byte)0;
	geoidSimple[68][205] = (byte)0;
	geoidSimple[68][206] = (byte)-1;
	geoidSimple[68][207] = (byte)-3;
	geoidSimple[68][208] = (byte)-5;
	geoidSimple[68][209] = (byte)-7;
	geoidSimple[68][210] = (byte)-8;
	geoidSimple[68][211] = (byte)-10;
	geoidSimple[68][212] = (byte)-11;
	geoidSimple[68][213] = (byte)-13;
	geoidSimple[68][214] = (byte)-15;
	geoidSimple[68][215] = (byte)-16;
	geoidSimple[68][216] = (byte)-18;
	geoidSimple[68][217] = (byte)-19;
	geoidSimple[68][218] = (byte)-21;
	geoidSimple[68][219] = (byte)-22;
	geoidSimple[68][220] = (byte)-24;
	geoidSimple[68][221] = (byte)-25;
	geoidSimple[68][222] = (byte)-27;
	geoidSimple[68][223] = (byte)-29;
	geoidSimple[68][224] = (byte)-31;
	geoidSimple[68][225] = (byte)-32;
	geoidSimple[68][226] = (byte)-34;
	geoidSimple[68][227] = (byte)-35;
	geoidSimple[68][228] = (byte)-36;
	geoidSimple[68][229] = (byte)-38;
	geoidSimple[68][230] = (byte)-40;
	geoidSimple[68][231] = (byte)-41;
	geoidSimple[68][232] = (byte)-42;
	geoidSimple[68][233] = (byte)-43;
	geoidSimple[68][234] = (byte)-44;
	geoidSimple[68][235] = (byte)-45;
	geoidSimple[68][236] = (byte)-46;
	geoidSimple[68][237] = (byte)-47;
	geoidSimple[68][238] = (byte)-47;
	geoidSimple[68][239] = (byte)-47;
	geoidSimple[68][240] = (byte)-47;
	geoidSimple[68][241] = (byte)-46;
	geoidSimple[68][242] = (byte)-46;
	geoidSimple[68][243] = (byte)-45;
	geoidSimple[68][244] = (byte)-44;
	geoidSimple[68][245] = (byte)-42;
	geoidSimple[68][246] = (byte)-41;
	geoidSimple[68][247] = (byte)-39;
	geoidSimple[68][248] = (byte)-37;
	geoidSimple[68][249] = (byte)-35;
	geoidSimple[68][250] = (byte)-33;
	geoidSimple[68][251] = (byte)-31;
	geoidSimple[68][252] = (byte)-30;
	geoidSimple[68][253] = (byte)-28;
	geoidSimple[68][254] = (byte)-24;
	geoidSimple[68][255] = (byte)-20;
	geoidSimple[68][256] = (byte)-17;
	geoidSimple[68][257] = (byte)-14;
	geoidSimple[68][258] = (byte)-12;
	geoidSimple[68][259] = (byte)-11;
	geoidSimple[68][260] = (byte)-12;
	geoidSimple[68][261] = (byte)-13;
	geoidSimple[68][262] = (byte)-16;
	geoidSimple[68][263] = (byte)-19;
	geoidSimple[68][264] = (byte)-23;
	geoidSimple[68][265] = (byte)-23;
	geoidSimple[68][266] = (byte)-23;
	geoidSimple[68][267] = (byte)-20;
	geoidSimple[68][268] = (byte)-15;
	geoidSimple[68][269] = (byte)-14;
	geoidSimple[68][270] = (byte)-14;
	geoidSimple[68][271] = (byte)-13;
	geoidSimple[68][272] = (byte)-13;
	geoidSimple[68][273] = (byte)-13;
	geoidSimple[68][274] = (byte)-19;
	geoidSimple[68][275] = (byte)-20;
	geoidSimple[68][276] = (byte)-19;
	geoidSimple[68][277] = (byte)-18;
	geoidSimple[68][278] = (byte)-20;
	geoidSimple[68][279] = (byte)-22;
	geoidSimple[68][280] = (byte)-21;
	geoidSimple[68][281] = (byte)-22;
	geoidSimple[68][282] = (byte)-25;
	geoidSimple[68][283] = (byte)-30;
	geoidSimple[68][284] = (byte)-34;
	geoidSimple[68][285] = (byte)-38;
	geoidSimple[68][286] = (byte)-40;
	geoidSimple[68][287] = (byte)-43;
	geoidSimple[68][288] = (byte)-43;
	geoidSimple[68][289] = (byte)-48;
	geoidSimple[68][290] = (byte)-50;
	geoidSimple[68][291] = (byte)-50;
	geoidSimple[68][292] = (byte)-50;
	geoidSimple[68][293] = (byte)-51;
	geoidSimple[68][294] = (byte)-51;
	geoidSimple[68][295] = (byte)-51;
	geoidSimple[68][296] = (byte)-51;
	geoidSimple[68][297] = (byte)-51;
	geoidSimple[68][298] = (byte)-50;
	geoidSimple[68][299] = (byte)-49;
	geoidSimple[68][300] = (byte)-49;
	geoidSimple[68][301] = (byte)-47;
	geoidSimple[68][302] = (byte)-45;
	geoidSimple[68][303] = (byte)-44;
	geoidSimple[68][304] = (byte)-43;
	geoidSimple[68][305] = (byte)-41;
	geoidSimple[68][306] = (byte)-39;
	geoidSimple[68][307] = (byte)-37;
	geoidSimple[68][308] = (byte)-34;
	geoidSimple[68][309] = (byte)-32;
	geoidSimple[68][310] = (byte)-29;
	geoidSimple[68][311] = (byte)-26;
	geoidSimple[68][312] = (byte)-23;
	geoidSimple[68][313] = (byte)-20;
	geoidSimple[68][314] = (byte)-16;
	geoidSimple[68][315] = (byte)-14;
	geoidSimple[68][316] = (byte)-13;
	geoidSimple[68][317] = (byte)-11;
	geoidSimple[68][318] = (byte)-9;
	geoidSimple[68][319] = (byte)-8;
	geoidSimple[68][320] = (byte)-6;
	geoidSimple[68][321] = (byte)-4;
	geoidSimple[68][322] = (byte)-2;
	geoidSimple[68][323] = (byte)0;
	geoidSimple[68][324] = (byte)3;
	geoidSimple[68][325] = (byte)6;
	geoidSimple[68][326] = (byte)9;
	geoidSimple[68][327] = (byte)12;
	geoidSimple[68][328] = (byte)14;
	geoidSimple[68][329] = (byte)16;
	geoidSimple[68][330] = (byte)17;
	geoidSimple[68][331] = (byte)17;
	geoidSimple[68][332] = (byte)17;
	geoidSimple[68][333] = (byte)18;
	geoidSimple[68][334] = (byte)19;
	geoidSimple[68][335] = (byte)21;
	geoidSimple[68][336] = (byte)22;
	geoidSimple[68][337] = (byte)23;
	geoidSimple[68][338] = (byte)23;
	geoidSimple[68][339] = (byte)23;
	geoidSimple[68][340] = (byte)24;
	geoidSimple[68][341] = (byte)25;
	geoidSimple[68][342] = (byte)29;
	geoidSimple[68][343] = (byte)33;
	geoidSimple[68][344] = (byte)35;
	geoidSimple[68][345] = (byte)35;
	geoidSimple[68][346] = (byte)35;
	geoidSimple[68][347] = (byte)36;
	geoidSimple[68][348] = (byte)36;
	geoidSimple[68][349] = (byte)33;
	geoidSimple[68][350] = (byte)32;
	geoidSimple[68][351] = (byte)30;
	geoidSimple[68][352] = (byte)29;
	geoidSimple[68][353] = (byte)28;
	geoidSimple[68][354] = (byte)27;
	geoidSimple[68][355] = (byte)26;
	geoidSimple[68][356] = (byte)26;
	geoidSimple[68][357] = (byte)26;
	geoidSimple[68][358] = (byte)28;
	geoidSimple[68][359] = (byte)29;
	}
		/** Row 69*/
	private static void init69() {
	geoidSimple[69][0] = (byte)31;
	geoidSimple[69][1] = (byte)31;
	geoidSimple[69][2] = (byte)31;
	geoidSimple[69][3] = (byte)30;
	geoidSimple[69][4] = (byte)28;
	geoidSimple[69][5] = (byte)27;
	geoidSimple[69][6] = (byte)26;
	geoidSimple[69][7] = (byte)24;
	geoidSimple[69][8] = (byte)26;
	geoidSimple[69][9] = (byte)27;
	geoidSimple[69][10] = (byte)26;
	geoidSimple[69][11] = (byte)24;
	geoidSimple[69][12] = (byte)22;
	geoidSimple[69][13] = (byte)21;
	geoidSimple[69][14] = (byte)20;
	geoidSimple[69][15] = (byte)21;
	geoidSimple[69][16] = (byte)24;
	geoidSimple[69][17] = (byte)27;
	geoidSimple[69][18] = (byte)27;
	geoidSimple[69][19] = (byte)19;
	geoidSimple[69][20] = (byte)14;
	geoidSimple[69][21] = (byte)13;
	geoidSimple[69][22] = (byte)12;
	geoidSimple[69][23] = (byte)12;
	geoidSimple[69][24] = (byte)13;
	geoidSimple[69][25] = (byte)14;
	geoidSimple[69][26] = (byte)14;
	geoidSimple[69][27] = (byte)13;
	geoidSimple[69][28] = (byte)11;
	geoidSimple[69][29] = (byte)10;
	geoidSimple[69][30] = (byte)9;
	geoidSimple[69][31] = (byte)9;
	geoidSimple[69][32] = (byte)9;
	geoidSimple[69][33] = (byte)8;
	geoidSimple[69][34] = (byte)7;
	geoidSimple[69][35] = (byte)7;
	geoidSimple[69][36] = (byte)7;
	geoidSimple[69][37] = (byte)4;
	geoidSimple[69][38] = (byte)3;
	geoidSimple[69][39] = (byte)3;
	geoidSimple[69][40] = (byte)3;
	geoidSimple[69][41] = (byte)5;
	geoidSimple[69][42] = (byte)2;
	geoidSimple[69][43] = (byte)-2;
	geoidSimple[69][44] = (byte)-5;
	geoidSimple[69][45] = (byte)-10;
	geoidSimple[69][46] = (byte)-16;
	geoidSimple[69][47] = (byte)-21;
	geoidSimple[69][48] = (byte)-25;
	geoidSimple[69][49] = (byte)-29;
	geoidSimple[69][50] = (byte)-31;
	geoidSimple[69][51] = (byte)-33;
	geoidSimple[69][52] = (byte)-34;
	geoidSimple[69][53] = (byte)-35;
	geoidSimple[69][54] = (byte)-36;
	geoidSimple[69][55] = (byte)-35;
	geoidSimple[69][56] = (byte)-34;
	geoidSimple[69][57] = (byte)-33;
	geoidSimple[69][58] = (byte)-34;
	geoidSimple[69][59] = (byte)-37;
	geoidSimple[69][60] = (byte)-42;
	geoidSimple[69][61] = (byte)-46;
	geoidSimple[69][62] = (byte)-48;
	geoidSimple[69][63] = (byte)-49;
	geoidSimple[69][64] = (byte)-52;
	geoidSimple[69][65] = (byte)-55;
	geoidSimple[69][66] = (byte)-55;
	geoidSimple[69][67] = (byte)-58;
	geoidSimple[69][68] = (byte)-60;
	geoidSimple[69][69] = (byte)-58;
	geoidSimple[69][70] = (byte)-59;
	geoidSimple[69][71] = (byte)-61;
	geoidSimple[69][72] = (byte)-62;
	geoidSimple[69][73] = (byte)-63;
	geoidSimple[69][74] = (byte)-64;
	geoidSimple[69][75] = (byte)-64;
	geoidSimple[69][76] = (byte)-64;
	geoidSimple[69][77] = (byte)-64;
	geoidSimple[69][78] = (byte)-65;
	geoidSimple[69][79] = (byte)-65;
	geoidSimple[69][80] = (byte)-65;
	geoidSimple[69][81] = (byte)-65;
	geoidSimple[69][82] = (byte)-64;
	geoidSimple[69][83] = (byte)-63;
	geoidSimple[69][84] = (byte)-61;
	geoidSimple[69][85] = (byte)-60;
	geoidSimple[69][86] = (byte)-62;
	geoidSimple[69][87] = (byte)-61;
	geoidSimple[69][88] = (byte)-58;
	geoidSimple[69][89] = (byte)-58;
	geoidSimple[69][90] = (byte)-56;
	geoidSimple[69][91] = (byte)-55;
	geoidSimple[69][92] = (byte)-53;
	geoidSimple[69][93] = (byte)-51;
	geoidSimple[69][94] = (byte)-52;
	geoidSimple[69][95] = (byte)-50;
	geoidSimple[69][96] = (byte)-46;
	geoidSimple[69][97] = (byte)-42;
	geoidSimple[69][98] = (byte)-41;
	geoidSimple[69][99] = (byte)-38;
	geoidSimple[69][100] = (byte)-36;
	geoidSimple[69][101] = (byte)-34;
	geoidSimple[69][102] = (byte)-33;
	geoidSimple[69][103] = (byte)-31;
	geoidSimple[69][104] = (byte)-30;
	geoidSimple[69][105] = (byte)-28;
	geoidSimple[69][106] = (byte)-25;
	geoidSimple[69][107] = (byte)-22;
	geoidSimple[69][108] = (byte)-20;
	geoidSimple[69][109] = (byte)-16;
	geoidSimple[69][110] = (byte)-12;
	geoidSimple[69][111] = (byte)-9;
	geoidSimple[69][112] = (byte)-5;
	geoidSimple[69][113] = (byte)-2;
	geoidSimple[69][114] = (byte)1;
	geoidSimple[69][115] = (byte)6;
	geoidSimple[69][116] = (byte)10;
	geoidSimple[69][117] = (byte)14;
	geoidSimple[69][118] = (byte)17;
	geoidSimple[69][119] = (byte)19;
	geoidSimple[69][120] = (byte)19;
	geoidSimple[69][121] = (byte)24;
	geoidSimple[69][122] = (byte)27;
	geoidSimple[69][123] = (byte)27;
	geoidSimple[69][124] = (byte)30;
	geoidSimple[69][125] = (byte)32;
	geoidSimple[69][126] = (byte)33;
	geoidSimple[69][127] = (byte)35;
	geoidSimple[69][128] = (byte)35;
	geoidSimple[69][129] = (byte)36;
	geoidSimple[69][130] = (byte)37;
	geoidSimple[69][131] = (byte)37;
	geoidSimple[69][132] = (byte)38;
	geoidSimple[69][133] = (byte)39;
	geoidSimple[69][134] = (byte)40;
	geoidSimple[69][135] = (byte)41;
	geoidSimple[69][136] = (byte)43;
	geoidSimple[69][137] = (byte)45;
	geoidSimple[69][138] = (byte)46;
	geoidSimple[69][139] = (byte)48;
	geoidSimple[69][140] = (byte)48;
	geoidSimple[69][141] = (byte)48;
	geoidSimple[69][142] = (byte)49;
	geoidSimple[69][143] = (byte)49;
	geoidSimple[69][144] = (byte)47;
	geoidSimple[69][145] = (byte)42;
	geoidSimple[69][146] = (byte)34;
	geoidSimple[69][147] = (byte)32;
	geoidSimple[69][148] = (byte)37;
	geoidSimple[69][149] = (byte)38;
	geoidSimple[69][150] = (byte)37;
	geoidSimple[69][151] = (byte)34;
	geoidSimple[69][152] = (byte)32;
	geoidSimple[69][153] = (byte)31;
	geoidSimple[69][154] = (byte)29;
	geoidSimple[69][155] = (byte)27;
	geoidSimple[69][156] = (byte)27;
	geoidSimple[69][157] = (byte)24;
	geoidSimple[69][158] = (byte)21;
	geoidSimple[69][159] = (byte)19;
	geoidSimple[69][160] = (byte)19;
	geoidSimple[69][161] = (byte)18;
	geoidSimple[69][162] = (byte)16;
	geoidSimple[69][163] = (byte)16;
	geoidSimple[69][164] = (byte)13;
	geoidSimple[69][165] = (byte)12;
	geoidSimple[69][166] = (byte)12;
	geoidSimple[69][167] = (byte)10;
	geoidSimple[69][168] = (byte)9;
	geoidSimple[69][169] = (byte)8;
	geoidSimple[69][170] = (byte)7;
	geoidSimple[69][171] = (byte)6;
	geoidSimple[69][172] = (byte)5;
	geoidSimple[69][173] = (byte)5;
	geoidSimple[69][174] = (byte)4;
	geoidSimple[69][175] = (byte)4;
	geoidSimple[69][176] = (byte)5;
	geoidSimple[69][177] = (byte)5;
	geoidSimple[69][178] = (byte)3;
	geoidSimple[69][179] = (byte)3;
	geoidSimple[69][LAT_GRID_SIZE] = (byte)3;
	geoidSimple[69][181] = (byte)3;
	geoidSimple[69][182] = (byte)2;
	geoidSimple[69][183] = (byte)3;
	geoidSimple[69][184] = (byte)3;
	geoidSimple[69][185] = (byte)4;
	geoidSimple[69][186] = (byte)5;
	geoidSimple[69][187] = (byte)6;
	geoidSimple[69][188] = (byte)7;
	geoidSimple[69][189] = (byte)8;
	geoidSimple[69][190] = (byte)9;
	geoidSimple[69][191] = (byte)9;
	geoidSimple[69][192] = (byte)9;
	geoidSimple[69][193] = (byte)9;
	geoidSimple[69][194] = (byte)9;
	geoidSimple[69][195] = (byte)9;
	geoidSimple[69][196] = (byte)8;
	geoidSimple[69][197] = (byte)8;
	geoidSimple[69][198] = (byte)7;
	geoidSimple[69][199] = (byte)7;
	geoidSimple[69][200] = (byte)6;
	geoidSimple[69][201] = (byte)6;
	geoidSimple[69][202] = (byte)9;
	geoidSimple[69][203] = (byte)14;
	geoidSimple[69][204] = (byte)10;
	geoidSimple[69][205] = (byte)0;
	geoidSimple[69][206] = (byte)-2;
	geoidSimple[69][207] = (byte)-3;
	geoidSimple[69][208] = (byte)-4;
	geoidSimple[69][209] = (byte)-6;
	geoidSimple[69][210] = (byte)-8;
	geoidSimple[69][211] = (byte)-9;
	geoidSimple[69][212] = (byte)-11;
	geoidSimple[69][213] = (byte)-12;
	geoidSimple[69][214] = (byte)-14;
	geoidSimple[69][215] = (byte)-16;
	geoidSimple[69][216] = (byte)-17;
	geoidSimple[69][217] = (byte)-19;
	geoidSimple[69][218] = (byte)-20;
	geoidSimple[69][219] = (byte)-22;
	geoidSimple[69][220] = (byte)-23;
	geoidSimple[69][221] = (byte)-25;
	geoidSimple[69][222] = (byte)-27;
	geoidSimple[69][223] = (byte)-28;
	geoidSimple[69][224] = (byte)-30;
	geoidSimple[69][225] = (byte)-32;
	geoidSimple[69][226] = (byte)-34;
	geoidSimple[69][227] = (byte)-35;
	geoidSimple[69][228] = (byte)-36;
	geoidSimple[69][229] = (byte)-38;
	geoidSimple[69][230] = (byte)-40;
	geoidSimple[69][231] = (byte)-41;
	geoidSimple[69][232] = (byte)-42;
	geoidSimple[69][233] = (byte)-43;
	geoidSimple[69][234] = (byte)-44;
	geoidSimple[69][235] = (byte)-45;
	geoidSimple[69][236] = (byte)-46;
	geoidSimple[69][237] = (byte)-47;
	geoidSimple[69][238] = (byte)-47;
	geoidSimple[69][239] = (byte)-47;
	geoidSimple[69][240] = (byte)-47;
	geoidSimple[69][241] = (byte)-47;
	geoidSimple[69][242] = (byte)-46;
	geoidSimple[69][243] = (byte)-45;
	geoidSimple[69][244] = (byte)-44;
	geoidSimple[69][245] = (byte)-42;
	geoidSimple[69][246] = (byte)-41;
	geoidSimple[69][247] = (byte)-39;
	geoidSimple[69][248] = (byte)-37;
	geoidSimple[69][249] = (byte)-35;
	geoidSimple[69][250] = (byte)-33;
	geoidSimple[69][251] = (byte)-31;
	geoidSimple[69][252] = (byte)-29;
	geoidSimple[69][253] = (byte)-30;
	geoidSimple[69][254] = (byte)-25;
	geoidSimple[69][255] = (byte)-19;
	geoidSimple[69][256] = (byte)-16;
	geoidSimple[69][257] = (byte)-13;
	geoidSimple[69][258] = (byte)-11;
	geoidSimple[69][259] = (byte)-10;
	geoidSimple[69][260] = (byte)-8;
	geoidSimple[69][261] = (byte)-8;
	geoidSimple[69][262] = (byte)-11;
	geoidSimple[69][263] = (byte)-14;
	geoidSimple[69][264] = (byte)-19;
	geoidSimple[69][265] = (byte)-20;
	geoidSimple[69][266] = (byte)-19;
	geoidSimple[69][267] = (byte)-17;
	geoidSimple[69][268] = (byte)-13;
	geoidSimple[69][269] = (byte)-12;
	geoidSimple[69][270] = (byte)-12;
	geoidSimple[69][271] = (byte)-11;
	geoidSimple[69][272] = (byte)-10;
	geoidSimple[69][273] = (byte)-13;
	geoidSimple[69][274] = (byte)-17;
	geoidSimple[69][275] = (byte)-17;
	geoidSimple[69][276] = (byte)-19;
	geoidSimple[69][277] = (byte)-19;
	geoidSimple[69][278] = (byte)-20;
	geoidSimple[69][279] = (byte)-21;
	geoidSimple[69][280] = (byte)-22;
	geoidSimple[69][281] = (byte)-22;
	geoidSimple[69][282] = (byte)-23;
	geoidSimple[69][283] = (byte)-23;
	geoidSimple[69][284] = (byte)-25;
	geoidSimple[69][285] = (byte)-33;
	geoidSimple[69][286] = (byte)-41;
	geoidSimple[69][287] = (byte)-45;
	geoidSimple[69][288] = (byte)-46;
	geoidSimple[69][289] = (byte)-47;
	geoidSimple[69][290] = (byte)-47;
	geoidSimple[69][291] = (byte)-51;
	geoidSimple[69][292] = (byte)-52;
	geoidSimple[69][293] = (byte)-54;
	geoidSimple[69][294] = (byte)-55;
	geoidSimple[69][295] = (byte)-53;
	geoidSimple[69][296] = (byte)-52;
	geoidSimple[69][297] = (byte)-51;
	geoidSimple[69][298] = (byte)-50;
	geoidSimple[69][299] = (byte)-49;
	geoidSimple[69][300] = (byte)-47;
	geoidSimple[69][301] = (byte)-46;
	geoidSimple[69][302] = (byte)-44;
	geoidSimple[69][303] = (byte)-44;
	geoidSimple[69][304] = (byte)-43;
	geoidSimple[69][305] = (byte)-41;
	geoidSimple[69][306] = (byte)-40;
	geoidSimple[69][307] = (byte)-38;
	geoidSimple[69][308] = (byte)-35;
	geoidSimple[69][309] = (byte)-33;
	geoidSimple[69][310] = (byte)-30;
	geoidSimple[69][311] = (byte)-27;
	geoidSimple[69][312] = (byte)-24;
	geoidSimple[69][313] = (byte)-21;
	geoidSimple[69][314] = (byte)-18;
	geoidSimple[69][315] = (byte)-16;
	geoidSimple[69][316] = (byte)-15;
	geoidSimple[69][317] = (byte)-13;
	geoidSimple[69][318] = (byte)-12;
	geoidSimple[69][319] = (byte)-10;
	geoidSimple[69][320] = (byte)-8;
	geoidSimple[69][321] = (byte)-6;
	geoidSimple[69][322] = (byte)-4;
	geoidSimple[69][323] = (byte)-1;
	geoidSimple[69][324] = (byte)1;
	geoidSimple[69][325] = (byte)4;
	geoidSimple[69][326] = (byte)8;
	geoidSimple[69][327] = (byte)11;
	geoidSimple[69][328] = (byte)14;
	geoidSimple[69][329] = (byte)16;
	geoidSimple[69][330] = (byte)17;
	geoidSimple[69][331] = (byte)17;
	geoidSimple[69][332] = (byte)18;
	geoidSimple[69][333] = (byte)19;
	geoidSimple[69][334] = (byte)20;
	geoidSimple[69][335] = (byte)22;
	geoidSimple[69][336] = (byte)23;
	geoidSimple[69][337] = (byte)24;
	geoidSimple[69][338] = (byte)24;
	geoidSimple[69][339] = (byte)24;
	geoidSimple[69][340] = (byte)24;
	geoidSimple[69][341] = (byte)26;
	geoidSimple[69][342] = (byte)30;
	geoidSimple[69][343] = (byte)32;
	geoidSimple[69][344] = (byte)34;
	geoidSimple[69][345] = (byte)34;
	geoidSimple[69][346] = (byte)34;
	geoidSimple[69][347] = (byte)34;
	geoidSimple[69][348] = (byte)33;
	geoidSimple[69][349] = (byte)31;
	geoidSimple[69][350] = (byte)30;
	geoidSimple[69][351] = (byte)28;
	geoidSimple[69][352] = (byte)27;
	geoidSimple[69][353] = (byte)27;
	geoidSimple[69][354] = (byte)27;
	geoidSimple[69][355] = (byte)27;
	geoidSimple[69][356] = (byte)27;
	geoidSimple[69][357] = (byte)27;
	geoidSimple[69][358] = (byte)29;
	geoidSimple[69][359] = (byte)29;
	}
		/** Row 70*/
	private static void init70() {
	geoidSimple[70][0] = (byte)31;
	geoidSimple[70][1] = (byte)31;
	geoidSimple[70][2] = (byte)30;
	geoidSimple[70][3] = (byte)28;
	geoidSimple[70][4] = (byte)26;
	geoidSimple[70][5] = (byte)25;
	geoidSimple[70][6] = (byte)24;
	geoidSimple[70][7] = (byte)23;
	geoidSimple[70][8] = (byte)25;
	geoidSimple[70][9] = (byte)27;
	geoidSimple[70][10] = (byte)25;
	geoidSimple[70][11] = (byte)24;
	geoidSimple[70][12] = (byte)22;
	geoidSimple[70][13] = (byte)20;
	geoidSimple[70][14] = (byte)19;
	geoidSimple[70][15] = (byte)19;
	geoidSimple[70][16] = (byte)20;
	geoidSimple[70][17] = (byte)20;
	geoidSimple[70][18] = (byte)20;
	geoidSimple[70][19] = (byte)16;
	geoidSimple[70][20] = (byte)12;
	geoidSimple[70][21] = (byte)11;
	geoidSimple[70][22] = (byte)11;
	geoidSimple[70][23] = (byte)12;
	geoidSimple[70][24] = (byte)13;
	geoidSimple[70][25] = (byte)13;
	geoidSimple[70][26] = (byte)13;
	geoidSimple[70][27] = (byte)12;
	geoidSimple[70][28] = (byte)11;
	geoidSimple[70][29] = (byte)9;
	geoidSimple[70][30] = (byte)8;
	geoidSimple[70][31] = (byte)8;
	geoidSimple[70][32] = (byte)7;
	geoidSimple[70][33] = (byte)7;
	geoidSimple[70][34] = (byte)5;
	geoidSimple[70][35] = (byte)5;
	geoidSimple[70][36] = (byte)6;
	geoidSimple[70][37] = (byte)3;
	geoidSimple[70][38] = (byte)2;
	geoidSimple[70][39] = (byte)1;
	geoidSimple[70][40] = (byte)0;
	geoidSimple[70][41] = (byte)0;
	geoidSimple[70][42] = (byte)2;
	geoidSimple[70][43] = (byte)-2;
	geoidSimple[70][44] = (byte)-7;
	geoidSimple[70][45] = (byte)-12;
	geoidSimple[70][46] = (byte)-16;
	geoidSimple[70][47] = (byte)-21;
	geoidSimple[70][48] = (byte)-25;
	geoidSimple[70][49] = (byte)-28;
	geoidSimple[70][50] = (byte)-31;
	geoidSimple[70][51] = (byte)-32;
	geoidSimple[70][52] = (byte)-34;
	geoidSimple[70][53] = (byte)-35;
	geoidSimple[70][54] = (byte)-36;
	geoidSimple[70][55] = (byte)-36;
	geoidSimple[70][56] = (byte)-35;
	geoidSimple[70][57] = (byte)-33;
	geoidSimple[70][58] = (byte)-37;
	geoidSimple[70][59] = (byte)-40;
	geoidSimple[70][60] = (byte)-44;
	geoidSimple[70][61] = (byte)-49;
	geoidSimple[70][62] = (byte)-49;
	geoidSimple[70][63] = (byte)-51;
	geoidSimple[70][64] = (byte)-53;
	geoidSimple[70][65] = (byte)-55;
	geoidSimple[70][66] = (byte)-56;
	geoidSimple[70][67] = (byte)-59;
	geoidSimple[70][68] = (byte)-63;
	geoidSimple[70][69] = (byte)-63;
	geoidSimple[70][70] = (byte)-63;
	geoidSimple[70][71] = (byte)-66;
	geoidSimple[70][72] = (byte)-66;
	geoidSimple[70][73] = (byte)-68;
	geoidSimple[70][74] = (byte)-67;
	geoidSimple[70][75] = (byte)-68;
	geoidSimple[70][76] = (byte)-69;
	geoidSimple[70][77] = (byte)-69;
	geoidSimple[70][78] = (byte)-69;
	geoidSimple[70][79] = (byte)-69;
	geoidSimple[70][80] = (byte)-68;
	geoidSimple[70][81] = (byte)-67;
	geoidSimple[70][82] = (byte)-65;
	geoidSimple[70][83] = (byte)-64;
	geoidSimple[70][84] = (byte)-64;
	geoidSimple[70][85] = (byte)-64;
	geoidSimple[70][86] = (byte)-66;
	geoidSimple[70][87] = (byte)-65;
	geoidSimple[70][88] = (byte)-63;
	geoidSimple[70][89] = (byte)-62;
	geoidSimple[70][90] = (byte)-60;
	geoidSimple[70][91] = (byte)-58;
	geoidSimple[70][92] = (byte)-55;
	geoidSimple[70][93] = (byte)-52;
	geoidSimple[70][94] = (byte)-49;
	geoidSimple[70][95] = (byte)-50;
	geoidSimple[70][96] = (byte)-46;
	geoidSimple[70][97] = (byte)-43;
	geoidSimple[70][98] = (byte)-40;
	geoidSimple[70][99] = (byte)-38;
	geoidSimple[70][100] = (byte)-36;
	geoidSimple[70][101] = (byte)-34;
	geoidSimple[70][102] = (byte)-32;
	geoidSimple[70][103] = (byte)-30;
	geoidSimple[70][104] = (byte)-28;
	geoidSimple[70][105] = (byte)-26;
	geoidSimple[70][106] = (byte)-23;
	geoidSimple[70][107] = (byte)-21;
	geoidSimple[70][108] = (byte)-17;
	geoidSimple[70][109] = (byte)-14;
	geoidSimple[70][110] = (byte)-10;
	geoidSimple[70][111] = (byte)-7;
	geoidSimple[70][112] = (byte)-3;
	geoidSimple[70][113] = (byte)0;
	geoidSimple[70][114] = (byte)3;
	geoidSimple[70][115] = (byte)7;
	geoidSimple[70][116] = (byte)11;
	geoidSimple[70][117] = (byte)14;
	geoidSimple[70][118] = (byte)18;
	geoidSimple[70][119] = (byte)21;
	geoidSimple[70][120] = (byte)22;
	geoidSimple[70][121] = (byte)28;
	geoidSimple[70][122] = (byte)30;
	geoidSimple[70][123] = (byte)30;
	geoidSimple[70][124] = (byte)32;
	geoidSimple[70][125] = (byte)34;
	geoidSimple[70][126] = (byte)35;
	geoidSimple[70][127] = (byte)36;
	geoidSimple[70][128] = (byte)37;
	geoidSimple[70][129] = (byte)38;
	geoidSimple[70][130] = (byte)38;
	geoidSimple[70][131] = (byte)39;
	geoidSimple[70][132] = (byte)39;
	geoidSimple[70][133] = (byte)40;
	geoidSimple[70][134] = (byte)41;
	geoidSimple[70][135] = (byte)42;
	geoidSimple[70][136] = (byte)44;
	geoidSimple[70][137] = (byte)46;
	geoidSimple[70][138] = (byte)47;
	geoidSimple[70][139] = (byte)48;
	geoidSimple[70][140] = (byte)49;
	geoidSimple[70][141] = (byte)48;
	geoidSimple[70][142] = (byte)49;
	geoidSimple[70][143] = (byte)49;
	geoidSimple[70][144] = (byte)48;
	geoidSimple[70][145] = (byte)45;
	geoidSimple[70][146] = (byte)37;
	geoidSimple[70][147] = (byte)31;
	geoidSimple[70][148] = (byte)37;
	geoidSimple[70][149] = (byte)39;
	geoidSimple[70][150] = (byte)39;
	geoidSimple[70][151] = (byte)37;
	geoidSimple[70][152] = (byte)35;
	geoidSimple[70][153] = (byte)34;
	geoidSimple[70][154] = (byte)30;
	geoidSimple[70][155] = (byte)28;
	geoidSimple[70][156] = (byte)27;
	geoidSimple[70][157] = (byte)26;
	geoidSimple[70][158] = (byte)23;
	geoidSimple[70][159] = (byte)21;
	geoidSimple[70][160] = (byte)22;
	geoidSimple[70][161] = (byte)19;
	geoidSimple[70][162] = (byte)20;
	geoidSimple[70][163] = (byte)17;
	geoidSimple[70][164] = (byte)16;
	geoidSimple[70][165] = (byte)15;
	geoidSimple[70][166] = (byte)14;
	geoidSimple[70][167] = (byte)14;
	geoidSimple[70][168] = (byte)11;
	geoidSimple[70][169] = (byte)10;
	geoidSimple[70][170] = (byte)9;
	geoidSimple[70][171] = (byte)8;
	geoidSimple[70][172] = (byte)7;
	geoidSimple[70][173] = (byte)7;
	geoidSimple[70][174] = (byte)6;
	geoidSimple[70][175] = (byte)6;
	geoidSimple[70][176] = (byte)6;
	geoidSimple[70][177] = (byte)5;
	geoidSimple[70][178] = (byte)5;
	geoidSimple[70][179] = (byte)4;
	geoidSimple[70][LAT_GRID_SIZE] = (byte)4;
	geoidSimple[70][181] = (byte)4;
	geoidSimple[70][182] = (byte)4;
	geoidSimple[70][183] = (byte)4;
	geoidSimple[70][184] = (byte)5;
	geoidSimple[70][185] = (byte)5;
	geoidSimple[70][186] = (byte)7;
	geoidSimple[70][187] = (byte)8;
	geoidSimple[70][188] = (byte)8;
	geoidSimple[70][189] = (byte)9;
	geoidSimple[70][190] = (byte)9;
	geoidSimple[70][191] = (byte)9;
	geoidSimple[70][192] = (byte)9;
	geoidSimple[70][193] = (byte)8;
	geoidSimple[70][194] = (byte)8;
	geoidSimple[70][195] = (byte)8;
	geoidSimple[70][196] = (byte)8;
	geoidSimple[70][197] = (byte)8;
	geoidSimple[70][198] = (byte)7;
	geoidSimple[70][199] = (byte)7;
	geoidSimple[70][200] = (byte)7;
	geoidSimple[70][201] = (byte)6;
	geoidSimple[70][202] = (byte)5;
	geoidSimple[70][203] = (byte)7;
	geoidSimple[70][204] = (byte)21;
	geoidSimple[70][205] = (byte)6;
	geoidSimple[70][206] = (byte)-2;
	geoidSimple[70][207] = (byte)-2;
	geoidSimple[70][208] = (byte)-4;
	geoidSimple[70][209] = (byte)-5;
	geoidSimple[70][210] = (byte)-7;
	geoidSimple[70][211] = (byte)-8;
	geoidSimple[70][212] = (byte)-10;
	geoidSimple[70][213] = (byte)-11;
	geoidSimple[70][214] = (byte)-13;
	geoidSimple[70][215] = (byte)-15;
	geoidSimple[70][216] = (byte)-16;
	geoidSimple[70][217] = (byte)-18;
	geoidSimple[70][218] = (byte)-20;
	geoidSimple[70][219] = (byte)-21;
	geoidSimple[70][220] = (byte)-23;
	geoidSimple[70][221] = (byte)-24;
	geoidSimple[70][222] = (byte)-26;
	geoidSimple[70][223] = (byte)-28;
	geoidSimple[70][224] = (byte)-29;
	geoidSimple[70][225] = (byte)-31;
	geoidSimple[70][226] = (byte)-33;
	geoidSimple[70][227] = (byte)-35;
	geoidSimple[70][228] = (byte)-36;
	geoidSimple[70][229] = (byte)-38;
	geoidSimple[70][230] = (byte)-39;
	geoidSimple[70][231] = (byte)-41;
	geoidSimple[70][232] = (byte)-42;
	geoidSimple[70][233] = (byte)-43;
	geoidSimple[70][234] = (byte)-44;
	geoidSimple[70][235] = (byte)-45;
	geoidSimple[70][236] = (byte)-46;
	geoidSimple[70][237] = (byte)-46;
	geoidSimple[70][238] = (byte)-47;
	geoidSimple[70][239] = (byte)-47;
	geoidSimple[70][240] = (byte)-47;
	geoidSimple[70][241] = (byte)-46;
	geoidSimple[70][242] = (byte)-45;
	geoidSimple[70][243] = (byte)-45;
	geoidSimple[70][244] = (byte)-43;
	geoidSimple[70][245] = (byte)-42;
	geoidSimple[70][246] = (byte)-40;
	geoidSimple[70][247] = (byte)-38;
	geoidSimple[70][248] = (byte)-36;
	geoidSimple[70][249] = (byte)-34;
	geoidSimple[70][250] = (byte)-33;
	geoidSimple[70][251] = (byte)-31;
	geoidSimple[70][252] = (byte)-29;
	geoidSimple[70][253] = (byte)-29;
	geoidSimple[70][254] = (byte)-26;
	geoidSimple[70][255] = (byte)-19;
	geoidSimple[70][256] = (byte)-15;
	geoidSimple[70][257] = (byte)-14;
	geoidSimple[70][258] = (byte)-11;
	geoidSimple[70][259] = (byte)-8;
	geoidSimple[70][260] = (byte)-5;
	geoidSimple[70][261] = (byte)-4;
	geoidSimple[70][262] = (byte)-4;
	geoidSimple[70][263] = (byte)-10;
	geoidSimple[70][264] = (byte)-15;
	geoidSimple[70][265] = (byte)-17;
	geoidSimple[70][266] = (byte)-15;
	geoidSimple[70][267] = (byte)-13;
	geoidSimple[70][268] = (byte)-11;
	geoidSimple[70][269] = (byte)-10;
	geoidSimple[70][270] = (byte)-9;
	geoidSimple[70][271] = (byte)-8;
	geoidSimple[70][272] = (byte)-9;
	geoidSimple[70][273] = (byte)-13;
	geoidSimple[70][274] = (byte)-14;
	geoidSimple[70][275] = (byte)-14;
	geoidSimple[70][276] = (byte)-16;
	geoidSimple[70][277] = (byte)-16;
	geoidSimple[70][278] = (byte)-17;
	geoidSimple[70][279] = (byte)-18;
	geoidSimple[70][280] = (byte)-20;
	geoidSimple[70][281] = (byte)-22;
	geoidSimple[70][282] = (byte)-24;
	geoidSimple[70][283] = (byte)-28;
	geoidSimple[70][284] = (byte)-29;
	geoidSimple[70][285] = (byte)-30;
	geoidSimple[70][286] = (byte)-31;
	geoidSimple[70][287] = (byte)-31;
	geoidSimple[70][288] = (byte)-34;
	geoidSimple[70][289] = (byte)-39;
	geoidSimple[70][290] = (byte)-46;
	geoidSimple[70][291] = (byte)-55;
	geoidSimple[70][292] = (byte)-63;
	geoidSimple[70][293] = (byte)-67;
	geoidSimple[70][294] = (byte)-66;
	geoidSimple[70][295] = (byte)-62;
	geoidSimple[70][296] = (byte)-60;
	geoidSimple[70][297] = (byte)-59;
	geoidSimple[70][298] = (byte)-54;
	geoidSimple[70][299] = (byte)-50;
	geoidSimple[70][300] = (byte)-47;
	geoidSimple[70][301] = (byte)-46;
	geoidSimple[70][302] = (byte)-46;
	geoidSimple[70][303] = (byte)-46;
	geoidSimple[70][304] = (byte)-44;
	geoidSimple[70][305] = (byte)-42;
	geoidSimple[70][306] = (byte)-40;
	geoidSimple[70][307] = (byte)-39;
	geoidSimple[70][308] = (byte)-37;
	geoidSimple[70][309] = (byte)-35;
	geoidSimple[70][310] = (byte)-32;
	geoidSimple[70][311] = (byte)-29;
	geoidSimple[70][312] = (byte)-26;
	geoidSimple[70][313] = (byte)-23;
	geoidSimple[70][314] = (byte)-20;
	geoidSimple[70][315] = (byte)-18;
	geoidSimple[70][316] = (byte)-17;
	geoidSimple[70][317] = (byte)-15;
	geoidSimple[70][318] = (byte)-13;
	geoidSimple[70][319] = (byte)-11;
	geoidSimple[70][320] = (byte)-10;
	geoidSimple[70][321] = (byte)-8;
	geoidSimple[70][322] = (byte)-5;
	geoidSimple[70][323] = (byte)-3;
	geoidSimple[70][324] = (byte)0;
	geoidSimple[70][325] = (byte)3;
	geoidSimple[70][326] = (byte)6;
	geoidSimple[70][327] = (byte)10;
	geoidSimple[70][328] = (byte)13;
	geoidSimple[70][329] = (byte)15;
	geoidSimple[70][330] = (byte)16;
	geoidSimple[70][331] = (byte)17;
	geoidSimple[70][332] = (byte)19;
	geoidSimple[70][333] = (byte)20;
	geoidSimple[70][334] = (byte)22;
	geoidSimple[70][335] = (byte)23;
	geoidSimple[70][336] = (byte)24;
	geoidSimple[70][337] = (byte)25;
	geoidSimple[70][338] = (byte)26;
	geoidSimple[70][339] = (byte)25;
	geoidSimple[70][340] = (byte)25;
	geoidSimple[70][341] = (byte)26;
	geoidSimple[70][342] = (byte)27;
	geoidSimple[70][343] = (byte)31;
	geoidSimple[70][344] = (byte)33;
	geoidSimple[70][345] = (byte)34;
	geoidSimple[70][346] = (byte)33;
	geoidSimple[70][347] = (byte)32;
	geoidSimple[70][348] = (byte)31;
	geoidSimple[70][349] = (byte)30;
	geoidSimple[70][350] = (byte)29;
	geoidSimple[70][351] = (byte)28;
	geoidSimple[70][352] = (byte)27;
	geoidSimple[70][353] = (byte)26;
	geoidSimple[70][354] = (byte)26;
	geoidSimple[70][355] = (byte)26;
	geoidSimple[70][356] = (byte)26;
	geoidSimple[70][357] = (byte)27;
	geoidSimple[70][358] = (byte)28;
	geoidSimple[70][359] = (byte)30;
	}
		/** Row 71*/
	private static void init71() {
	geoidSimple[71][0] = (byte)29;
	geoidSimple[71][1] = (byte)29;
	geoidSimple[71][2] = (byte)28;
	geoidSimple[71][3] = (byte)25;
	geoidSimple[71][4] = (byte)24;
	geoidSimple[71][5] = (byte)24;
	geoidSimple[71][6] = (byte)23;
	geoidSimple[71][7] = (byte)23;
	geoidSimple[71][8] = (byte)26;
	geoidSimple[71][9] = (byte)27;
	geoidSimple[71][10] = (byte)25;
	geoidSimple[71][11] = (byte)23;
	geoidSimple[71][12] = (byte)21;
	geoidSimple[71][13] = (byte)19;
	geoidSimple[71][14] = (byte)17;
	geoidSimple[71][15] = (byte)17;
	geoidSimple[71][16] = (byte)16;
	geoidSimple[71][17] = (byte)16;
	geoidSimple[71][18] = (byte)14;
	geoidSimple[71][19] = (byte)13;
	geoidSimple[71][20] = (byte)12;
	geoidSimple[71][21] = (byte)11;
	geoidSimple[71][22] = (byte)11;
	geoidSimple[71][23] = (byte)11;
	geoidSimple[71][24] = (byte)12;
	geoidSimple[71][25] = (byte)12;
	geoidSimple[71][26] = (byte)12;
	geoidSimple[71][27] = (byte)10;
	geoidSimple[71][28] = (byte)9;
	geoidSimple[71][29] = (byte)8;
	geoidSimple[71][30] = (byte)7;
	geoidSimple[71][31] = (byte)7;
	geoidSimple[71][32] = (byte)6;
	geoidSimple[71][33] = (byte)5;
	geoidSimple[71][34] = (byte)4;
	geoidSimple[71][35] = (byte)4;
	geoidSimple[71][36] = (byte)5;
	geoidSimple[71][37] = (byte)3;
	geoidSimple[71][38] = (byte)0;
	geoidSimple[71][39] = (byte)0;
	geoidSimple[71][40] = (byte)0;
	geoidSimple[71][41] = (byte)-1;
	geoidSimple[71][42] = (byte)1;
	geoidSimple[71][43] = (byte)-1;
	geoidSimple[71][44] = (byte)-6;
	geoidSimple[71][45] = (byte)-11;
	geoidSimple[71][46] = (byte)-16;
	geoidSimple[71][47] = (byte)-19;
	geoidSimple[71][48] = (byte)-24;
	geoidSimple[71][49] = (byte)-27;
	geoidSimple[71][50] = (byte)-29;
	geoidSimple[71][51] = (byte)-30;
	geoidSimple[71][52] = (byte)-31;
	geoidSimple[71][53] = (byte)-34;
	geoidSimple[71][54] = (byte)-35;
	geoidSimple[71][55] = (byte)-36;
	geoidSimple[71][56] = (byte)-35;
	geoidSimple[71][57] = (byte)-35;
	geoidSimple[71][58] = (byte)-40;
	geoidSimple[71][59] = (byte)-43;
	geoidSimple[71][60] = (byte)-47;
	geoidSimple[71][61] = (byte)-51;
	geoidSimple[71][62] = (byte)-51;
	geoidSimple[71][63] = (byte)-53;
	geoidSimple[71][64] = (byte)-55;
	geoidSimple[71][65] = (byte)-58;
	geoidSimple[71][66] = (byte)-61;
	geoidSimple[71][67] = (byte)-62;
	geoidSimple[71][68] = (byte)-65;
	geoidSimple[71][69] = (byte)-68;
	geoidSimple[71][70] = (byte)-67;
	geoidSimple[71][71] = (byte)-68;
	geoidSimple[71][72] = (byte)-70;
	geoidSimple[71][73] = (byte)-72;
	geoidSimple[71][74] = (byte)-71;
	geoidSimple[71][75] = (byte)-72;
	geoidSimple[71][76] = (byte)-72;
	geoidSimple[71][77] = (byte)-72;
	geoidSimple[71][78] = (byte)-72;
	geoidSimple[71][79] = (byte)-73;
	geoidSimple[71][80] = (byte)-73;
	geoidSimple[71][81] = (byte)-71;
	geoidSimple[71][82] = (byte)-68;
	geoidSimple[71][83] = (byte)-67;
	geoidSimple[71][84] = (byte)-69;
	geoidSimple[71][85] = (byte)-71;
	geoidSimple[71][86] = (byte)-70;
	geoidSimple[71][87] = (byte)-68;
	geoidSimple[71][88] = (byte)-66;
	geoidSimple[71][89] = (byte)-65;
	geoidSimple[71][90] = (byte)-61;
	geoidSimple[71][91] = (byte)-59;
	geoidSimple[71][92] = (byte)-59;
	geoidSimple[71][93] = (byte)-55;
	geoidSimple[71][94] = (byte)-49;
	geoidSimple[71][95] = (byte)-49;
	geoidSimple[71][96] = (byte)-46;
	geoidSimple[71][97] = (byte)-43;
	geoidSimple[71][98] = (byte)-40;
	geoidSimple[71][99] = (byte)-38;
	geoidSimple[71][100] = (byte)-36;
	geoidSimple[71][101] = (byte)-33;
	geoidSimple[71][102] = (byte)-32;
	geoidSimple[71][103] = (byte)-30;
	geoidSimple[71][104] = (byte)-28;
	geoidSimple[71][105] = (byte)-24;
	geoidSimple[71][106] = (byte)-21;
	geoidSimple[71][107] = (byte)-19;
	geoidSimple[71][108] = (byte)-15;
	geoidSimple[71][109] = (byte)-12;
	geoidSimple[71][110] = (byte)-8;
	geoidSimple[71][111] = (byte)-5;
	geoidSimple[71][112] = (byte)-2;
	geoidSimple[71][113] = (byte)1;
	geoidSimple[71][114] = (byte)5;
	geoidSimple[71][115] = (byte)9;
	geoidSimple[71][116] = (byte)13;
	geoidSimple[71][117] = (byte)17;
	geoidSimple[71][118] = (byte)21;
	geoidSimple[71][119] = (byte)23;
	geoidSimple[71][120] = (byte)29;
	geoidSimple[71][121] = (byte)34;
	geoidSimple[71][122] = (byte)33;
	geoidSimple[71][123] = (byte)32;
	geoidSimple[71][124] = (byte)35;
	geoidSimple[71][125] = (byte)36;
	geoidSimple[71][126] = (byte)38;
	geoidSimple[71][127] = (byte)39;
	geoidSimple[71][128] = (byte)39;
	geoidSimple[71][129] = (byte)40;
	geoidSimple[71][130] = (byte)40;
	geoidSimple[71][131] = (byte)40;
	geoidSimple[71][132] = (byte)41;
	geoidSimple[71][133] = (byte)41;
	geoidSimple[71][134] = (byte)42;
	geoidSimple[71][135] = (byte)44;
	geoidSimple[71][136] = (byte)45;
	geoidSimple[71][137] = (byte)47;
	geoidSimple[71][138] = (byte)48;
	geoidSimple[71][139] = (byte)49;
	geoidSimple[71][140] = (byte)49;
	geoidSimple[71][141] = (byte)49;
	geoidSimple[71][142] = (byte)49;
	geoidSimple[71][143] = (byte)50;
	geoidSimple[71][144] = (byte)50;
	geoidSimple[71][145] = (byte)47;
	geoidSimple[71][146] = (byte)39;
	geoidSimple[71][147] = (byte)33;
	geoidSimple[71][148] = (byte)35;
	geoidSimple[71][149] = (byte)38;
	geoidSimple[71][150] = (byte)39;
	geoidSimple[71][151] = (byte)37;
	geoidSimple[71][152] = (byte)36;
	geoidSimple[71][153] = (byte)34;
	geoidSimple[71][154] = (byte)32;
	geoidSimple[71][155] = (byte)30;
	geoidSimple[71][156] = (byte)28;
	geoidSimple[71][157] = (byte)26;
	geoidSimple[71][158] = (byte)24;
	geoidSimple[71][159] = (byte)22;
	geoidSimple[71][160] = (byte)21;
	geoidSimple[71][161] = (byte)21;
	geoidSimple[71][162] = (byte)20;
	geoidSimple[71][163] = (byte)19;
	geoidSimple[71][164] = (byte)18;
	geoidSimple[71][165] = (byte)17;
	geoidSimple[71][166] = (byte)16;
	geoidSimple[71][167] = (byte)15;
	geoidSimple[71][168] = (byte)13;
	geoidSimple[71][169] = (byte)12;
	geoidSimple[71][170] = (byte)11;
	geoidSimple[71][171] = (byte)12;
	geoidSimple[71][172] = (byte)9;
	geoidSimple[71][173] = (byte)8;
	geoidSimple[71][174] = (byte)8;
	geoidSimple[71][175] = (byte)7;
	geoidSimple[71][176] = (byte)7;
	geoidSimple[71][177] = (byte)6;
	geoidSimple[71][178] = (byte)6;
	geoidSimple[71][179] = (byte)5;
	geoidSimple[71][LAT_GRID_SIZE] = (byte)5;
	geoidSimple[71][181] = (byte)5;
	geoidSimple[71][182] = (byte)5;
	geoidSimple[71][183] = (byte)6;
	geoidSimple[71][184] = (byte)7;
	geoidSimple[71][185] = (byte)8;
	geoidSimple[71][186] = (byte)8;
	geoidSimple[71][187] = (byte)8;
	geoidSimple[71][188] = (byte)8;
	geoidSimple[71][189] = (byte)9;
	geoidSimple[71][190] = (byte)9;
	geoidSimple[71][191] = (byte)9;
	geoidSimple[71][192] = (byte)9;
	geoidSimple[71][193] = (byte)8;
	geoidSimple[71][194] = (byte)8;
	geoidSimple[71][195] = (byte)7;
	geoidSimple[71][196] = (byte)7;
	geoidSimple[71][197] = (byte)7;
	geoidSimple[71][198] = (byte)7;
	geoidSimple[71][199] = (byte)7;
	geoidSimple[71][200] = (byte)7;
	geoidSimple[71][201] = (byte)7;
	geoidSimple[71][202] = (byte)6;
	geoidSimple[71][203] = (byte)5;
	geoidSimple[71][204] = (byte)7;
	geoidSimple[71][205] = (byte)1;
	geoidSimple[71][206] = (byte)-1;
	geoidSimple[71][207] = (byte)-2;
	geoidSimple[71][208] = (byte)-3;
	geoidSimple[71][209] = (byte)-5;
	geoidSimple[71][210] = (byte)-6;
	geoidSimple[71][211] = (byte)-8;
	geoidSimple[71][212] = (byte)-9;
	geoidSimple[71][213] = (byte)-10;
	geoidSimple[71][214] = (byte)-12;
	geoidSimple[71][215] = (byte)-14;
	geoidSimple[71][216] = (byte)-15;
	geoidSimple[71][217] = (byte)-17;
	geoidSimple[71][218] = (byte)-19;
	geoidSimple[71][219] = (byte)-21;
	geoidSimple[71][220] = (byte)-22;
	geoidSimple[71][221] = (byte)-24;
	geoidSimple[71][222] = (byte)-25;
	geoidSimple[71][223] = (byte)-27;
	geoidSimple[71][224] = (byte)-29;
	geoidSimple[71][225] = (byte)-31;
	geoidSimple[71][226] = (byte)-33;
	geoidSimple[71][227] = (byte)-34;
	geoidSimple[71][228] = (byte)-36;
	geoidSimple[71][229] = (byte)-38;
	geoidSimple[71][230] = (byte)-39;
	geoidSimple[71][231] = (byte)-40;
	geoidSimple[71][232] = (byte)-41;
	geoidSimple[71][233] = (byte)-42;
	geoidSimple[71][234] = (byte)-43;
	geoidSimple[71][235] = (byte)-44;
	geoidSimple[71][236] = (byte)-45;
	geoidSimple[71][237] = (byte)-46;
	geoidSimple[71][238] = (byte)-46;
	geoidSimple[71][239] = (byte)-47;
	geoidSimple[71][240] = (byte)-46;
	geoidSimple[71][241] = (byte)-46;
	geoidSimple[71][242] = (byte)-45;
	geoidSimple[71][243] = (byte)-44;
	geoidSimple[71][244] = (byte)-43;
	geoidSimple[71][245] = (byte)-42;
	geoidSimple[71][246] = (byte)-40;
	geoidSimple[71][247] = (byte)-38;
	geoidSimple[71][248] = (byte)-36;
	geoidSimple[71][249] = (byte)-34;
	geoidSimple[71][250] = (byte)-32;
	geoidSimple[71][251] = (byte)-31;
	geoidSimple[71][252] = (byte)-29;
	geoidSimple[71][253] = (byte)-27;
	geoidSimple[71][254] = (byte)-25;
	geoidSimple[71][255] = (byte)-23;
	geoidSimple[71][256] = (byte)-18;
	geoidSimple[71][257] = (byte)-14;
	geoidSimple[71][258] = (byte)-11;
	geoidSimple[71][259] = (byte)-9;
	geoidSimple[71][260] = (byte)-7;
	geoidSimple[71][261] = (byte)-5;
	geoidSimple[71][262] = (byte)-4;
	geoidSimple[71][263] = (byte)-10;
	geoidSimple[71][264] = (byte)-12;
	geoidSimple[71][265] = (byte)-12;
	geoidSimple[71][266] = (byte)-12;
	geoidSimple[71][267] = (byte)-11;
	geoidSimple[71][268] = (byte)-10;
	geoidSimple[71][269] = (byte)-8;
	geoidSimple[71][270] = (byte)-7;
	geoidSimple[71][271] = (byte)-6;
	geoidSimple[71][272] = (byte)-8;
	geoidSimple[71][273] = (byte)-12;
	geoidSimple[71][274] = (byte)-12;
	geoidSimple[71][275] = (byte)-13;
	geoidSimple[71][276] = (byte)-12;
	geoidSimple[71][277] = (byte)-13;
	geoidSimple[71][278] = (byte)-14;
	geoidSimple[71][279] = (byte)-15;
	geoidSimple[71][280] = (byte)-18;
	geoidSimple[71][281] = (byte)-20;
	geoidSimple[71][282] = (byte)-20;
	geoidSimple[71][283] = (byte)-22;
	geoidSimple[71][284] = (byte)-24;
	geoidSimple[71][285] = (byte)-25;
	geoidSimple[71][286] = (byte)-25;
	geoidSimple[71][287] = (byte)-26;
	geoidSimple[71][288] = (byte)-27;
	geoidSimple[71][289] = (byte)-32;
	geoidSimple[71][290] = (byte)-37;
	geoidSimple[71][291] = (byte)-44;
	geoidSimple[71][292] = (byte)-50;
	geoidSimple[71][293] = (byte)-50;
	geoidSimple[71][294] = (byte)-49;
	geoidSimple[71][295] = (byte)-49;
	geoidSimple[71][296] = (byte)-52;
	geoidSimple[71][297] = (byte)-55;
	geoidSimple[71][298] = (byte)-60;
	geoidSimple[71][299] = (byte)-58;
	geoidSimple[71][300] = (byte)-52;
	geoidSimple[71][301] = (byte)-48;
	geoidSimple[71][302] = (byte)-47;
	geoidSimple[71][303] = (byte)-46;
	geoidSimple[71][304] = (byte)-44;
	geoidSimple[71][305] = (byte)-42;
	geoidSimple[71][306] = (byte)-40;
	geoidSimple[71][307] = (byte)-39;
	geoidSimple[71][308] = (byte)-38;
	geoidSimple[71][309] = (byte)-36;
	geoidSimple[71][310] = (byte)-33;
	geoidSimple[71][311] = (byte)-31;
	geoidSimple[71][312] = (byte)-27;
	geoidSimple[71][313] = (byte)-24;
	geoidSimple[71][314] = (byte)-22;
	geoidSimple[71][315] = (byte)-20;
	geoidSimple[71][316] = (byte)-19;
	geoidSimple[71][317] = (byte)-17;
	geoidSimple[71][318] = (byte)-15;
	geoidSimple[71][319] = (byte)-13;
	geoidSimple[71][320] = (byte)-11;
	geoidSimple[71][321] = (byte)-9;
	geoidSimple[71][322] = (byte)-7;
	geoidSimple[71][323] = (byte)-4;
	geoidSimple[71][324] = (byte)-1;
	geoidSimple[71][325] = (byte)1;
	geoidSimple[71][326] = (byte)5;
	geoidSimple[71][327] = (byte)8;
	geoidSimple[71][328] = (byte)11;
	geoidSimple[71][329] = (byte)13;
	geoidSimple[71][330] = (byte)15;
	geoidSimple[71][331] = (byte)17;
	geoidSimple[71][332] = (byte)18;
	geoidSimple[71][333] = (byte)20;
	geoidSimple[71][334] = (byte)22;
	geoidSimple[71][335] = (byte)23;
	geoidSimple[71][336] = (byte)24;
	geoidSimple[71][337] = (byte)26;
	geoidSimple[71][338] = (byte)26;
	geoidSimple[71][339] = (byte)26;
	geoidSimple[71][340] = (byte)26;
	geoidSimple[71][341] = (byte)26;
	geoidSimple[71][342] = (byte)26;
	geoidSimple[71][343] = (byte)30;
	geoidSimple[71][344] = (byte)33;
	geoidSimple[71][345] = (byte)34;
	geoidSimple[71][346] = (byte)34;
	geoidSimple[71][347] = (byte)31;
	geoidSimple[71][348] = (byte)30;
	geoidSimple[71][349] = (byte)29;
	geoidSimple[71][350] = (byte)28;
	geoidSimple[71][351] = (byte)28;
	geoidSimple[71][352] = (byte)27;
	geoidSimple[71][353] = (byte)26;
	geoidSimple[71][354] = (byte)26;
	geoidSimple[71][355] = (byte)26;
	geoidSimple[71][356] = (byte)26;
	geoidSimple[71][357] = (byte)27;
	geoidSimple[71][358] = (byte)29;
	geoidSimple[71][359] = (byte)30;
	}
		/** Row 72*/
	private static void init72() {
	geoidSimple[72][0] = (byte)28;
	geoidSimple[72][1] = (byte)26;
	geoidSimple[72][2] = (byte)25;
	geoidSimple[72][3] = (byte)23;
	geoidSimple[72][4] = (byte)23;
	geoidSimple[72][5] = (byte)22;
	geoidSimple[72][6] = (byte)22;
	geoidSimple[72][7] = (byte)22;
	geoidSimple[72][8] = (byte)24;
	geoidSimple[72][9] = (byte)25;
	geoidSimple[72][10] = (byte)23;
	geoidSimple[72][11] = (byte)21;
	geoidSimple[72][12] = (byte)20;
	geoidSimple[72][13] = (byte)19;
	geoidSimple[72][14] = (byte)16;
	geoidSimple[72][15] = (byte)15;
	geoidSimple[72][16] = (byte)14;
	geoidSimple[72][17] = (byte)13;
	geoidSimple[72][18] = (byte)11;
	geoidSimple[72][19] = (byte)11;
	geoidSimple[72][20] = (byte)11;
	geoidSimple[72][21] = (byte)10;
	geoidSimple[72][22] = (byte)11;
	geoidSimple[72][23] = (byte)12;
	geoidSimple[72][24] = (byte)12;
	geoidSimple[72][25] = (byte)11;
	geoidSimple[72][26] = (byte)10;
	geoidSimple[72][27] = (byte)9;
	geoidSimple[72][28] = (byte)8;
	geoidSimple[72][29] = (byte)7;
	geoidSimple[72][30] = (byte)6;
	geoidSimple[72][31] = (byte)5;
	geoidSimple[72][32] = (byte)5;
	geoidSimple[72][33] = (byte)4;
	geoidSimple[72][34] = (byte)3;
	geoidSimple[72][35] = (byte)3;
	geoidSimple[72][36] = (byte)2;
	geoidSimple[72][37] = (byte)0;
	geoidSimple[72][38] = (byte)0;
	geoidSimple[72][39] = (byte)-1;
	geoidSimple[72][40] = (byte)-1;
	geoidSimple[72][41] = (byte)-2;
	geoidSimple[72][42] = (byte)-2;
	geoidSimple[72][43] = (byte)-2;
	geoidSimple[72][44] = (byte)-5;
	geoidSimple[72][45] = (byte)-10;
	geoidSimple[72][46] = (byte)-14;
	geoidSimple[72][47] = (byte)-18;
	geoidSimple[72][48] = (byte)-22;
	geoidSimple[72][49] = (byte)-24;
	geoidSimple[72][50] = (byte)-25;
	geoidSimple[72][51] = (byte)-26;
	geoidSimple[72][52] = (byte)-28;
	geoidSimple[72][53] = (byte)-31;
	geoidSimple[72][54] = (byte)-32;
	geoidSimple[72][55] = (byte)-34;
	geoidSimple[72][56] = (byte)-35;
	geoidSimple[72][57] = (byte)-38;
	geoidSimple[72][58] = (byte)-42;
	geoidSimple[72][59] = (byte)-44;
	geoidSimple[72][60] = (byte)-52;
	geoidSimple[72][61] = (byte)-53;
	geoidSimple[72][62] = (byte)-53;
	geoidSimple[72][63] = (byte)-55;
	geoidSimple[72][64] = (byte)-58;
	geoidSimple[72][65] = (byte)-60;
	geoidSimple[72][66] = (byte)-64;
	geoidSimple[72][67] = (byte)-67;
	geoidSimple[72][68] = (byte)-68;
	geoidSimple[72][69] = (byte)-71;
	geoidSimple[72][70] = (byte)-73;
	geoidSimple[72][71] = (byte)-72;
	geoidSimple[72][72] = (byte)-73;
	geoidSimple[72][73] = (byte)-76;
	geoidSimple[72][74] = (byte)-75;
	geoidSimple[72][75] = (byte)-75;
	geoidSimple[72][76] = (byte)-76;
	geoidSimple[72][77] = (byte)-76;
	geoidSimple[72][78] = (byte)-76;
	geoidSimple[72][79] = (byte)-76;
	geoidSimple[72][80] = (byte)-76;
	geoidSimple[72][81] = (byte)-74;
	geoidSimple[72][82] = (byte)-72;
	geoidSimple[72][83] = (byte)-73;
	geoidSimple[72][84] = (byte)-76;
	geoidSimple[72][85] = (byte)-77;
	geoidSimple[72][86] = (byte)-73;
	geoidSimple[72][87] = (byte)-71;
	geoidSimple[72][88] = (byte)-68;
	geoidSimple[72][89] = (byte)-65;
	geoidSimple[72][90] = (byte)-61;
	geoidSimple[72][91] = (byte)-59;
	geoidSimple[72][92] = (byte)-59;
	geoidSimple[72][93] = (byte)-58;
	geoidSimple[72][94] = (byte)-53;
	geoidSimple[72][95] = (byte)-50;
	geoidSimple[72][96] = (byte)-46;
	geoidSimple[72][97] = (byte)-43;
	geoidSimple[72][98] = (byte)-40;
	geoidSimple[72][99] = (byte)-38;
	geoidSimple[72][100] = (byte)-35;
	geoidSimple[72][101] = (byte)-33;
	geoidSimple[72][102] = (byte)-31;
	geoidSimple[72][103] = (byte)-30;
	geoidSimple[72][104] = (byte)-27;
	geoidSimple[72][105] = (byte)-22;
	geoidSimple[72][106] = (byte)-19;
	geoidSimple[72][107] = (byte)-17;
	geoidSimple[72][108] = (byte)-14;
	geoidSimple[72][109] = (byte)-10;
	geoidSimple[72][110] = (byte)-7;
	geoidSimple[72][111] = (byte)-4;
	geoidSimple[72][112] = (byte)0;
	geoidSimple[72][113] = (byte)3;
	geoidSimple[72][114] = (byte)7;
	geoidSimple[72][115] = (byte)11;
	geoidSimple[72][116] = (byte)16;
	geoidSimple[72][117] = (byte)20;
	geoidSimple[72][118] = (byte)24;
	geoidSimple[72][119] = (byte)27;
	geoidSimple[72][120] = (byte)35;
	geoidSimple[72][121] = (byte)39;
	geoidSimple[72][122] = (byte)34;
	geoidSimple[72][123] = (byte)34;
	geoidSimple[72][124] = (byte)38;
	geoidSimple[72][125] = (byte)40;
	geoidSimple[72][126] = (byte)40;
	geoidSimple[72][127] = (byte)41;
	geoidSimple[72][128] = (byte)41;
	geoidSimple[72][129] = (byte)42;
	geoidSimple[72][130] = (byte)42;
	geoidSimple[72][131] = (byte)42;
	geoidSimple[72][132] = (byte)43;
	geoidSimple[72][133] = (byte)43;
	geoidSimple[72][134] = (byte)44;
	geoidSimple[72][135] = (byte)45;
	geoidSimple[72][136] = (byte)47;
	geoidSimple[72][137] = (byte)48;
	geoidSimple[72][138] = (byte)49;
	geoidSimple[72][139] = (byte)49;
	geoidSimple[72][140] = (byte)50;
	geoidSimple[72][141] = (byte)50;
	geoidSimple[72][142] = (byte)50;
	geoidSimple[72][143] = (byte)51;
	geoidSimple[72][144] = (byte)51;
	geoidSimple[72][145] = (byte)49;
	geoidSimple[72][146] = (byte)42;
	geoidSimple[72][147] = (byte)33;
	geoidSimple[72][148] = (byte)34;
	geoidSimple[72][149] = (byte)40;
	geoidSimple[72][150] = (byte)43;
	geoidSimple[72][151] = (byte)40;
	geoidSimple[72][152] = (byte)38;
	geoidSimple[72][153] = (byte)35;
	geoidSimple[72][154] = (byte)34;
	geoidSimple[72][155] = (byte)31;
	geoidSimple[72][156] = (byte)30;
	geoidSimple[72][157] = (byte)28;
	geoidSimple[72][158] = (byte)26;
	geoidSimple[72][159] = (byte)25;
	geoidSimple[72][160] = (byte)24;
	geoidSimple[72][161] = (byte)22;
	geoidSimple[72][162] = (byte)22;
	geoidSimple[72][163] = (byte)21;
	geoidSimple[72][164] = (byte)20;
	geoidSimple[72][165] = (byte)18;
	geoidSimple[72][166] = (byte)17;
	geoidSimple[72][167] = (byte)17;
	geoidSimple[72][168] = (byte)15;
	geoidSimple[72][169] = (byte)14;
	geoidSimple[72][170] = (byte)13;
	geoidSimple[72][171] = (byte)13;
	geoidSimple[72][172] = (byte)11;
	geoidSimple[72][173] = (byte)10;
	geoidSimple[72][174] = (byte)9;
	geoidSimple[72][175] = (byte)8;
	geoidSimple[72][176] = (byte)8;
	geoidSimple[72][177] = (byte)7;
	geoidSimple[72][178] = (byte)7;
	geoidSimple[72][179] = (byte)6;
	geoidSimple[72][LAT_GRID_SIZE] = (byte)6;
	geoidSimple[72][181] = (byte)5;
	geoidSimple[72][182] = (byte)6;
	geoidSimple[72][183] = (byte)7;
	geoidSimple[72][184] = (byte)8;
	geoidSimple[72][185] = (byte)8;
	geoidSimple[72][186] = (byte)8;
	geoidSimple[72][187] = (byte)8;
	geoidSimple[72][188] = (byte)9;
	geoidSimple[72][189] = (byte)8;
	geoidSimple[72][190] = (byte)8;
	geoidSimple[72][191] = (byte)9;
	geoidSimple[72][192] = (byte)9;
	geoidSimple[72][193] = (byte)8;
	geoidSimple[72][194] = (byte)8;
	geoidSimple[72][195] = (byte)7;
	geoidSimple[72][196] = (byte)7;
	geoidSimple[72][197] = (byte)6;
	geoidSimple[72][198] = (byte)6;
	geoidSimple[72][199] = (byte)6;
	geoidSimple[72][200] = (byte)6;
	geoidSimple[72][201] = (byte)6;
	geoidSimple[72][202] = (byte)6;
	geoidSimple[72][203] = (byte)4;
	geoidSimple[72][204] = (byte)2;
	geoidSimple[72][205] = (byte)0;
	geoidSimple[72][206] = (byte)0;
	geoidSimple[72][207] = (byte)-2;
	geoidSimple[72][208] = (byte)-3;
	geoidSimple[72][209] = (byte)-4;
	geoidSimple[72][210] = (byte)-6;
	geoidSimple[72][211] = (byte)-7;
	geoidSimple[72][212] = (byte)-8;
	geoidSimple[72][213] = (byte)-9;
	geoidSimple[72][214] = (byte)-11;
	geoidSimple[72][215] = (byte)-13;
	geoidSimple[72][216] = (byte)-14;
	geoidSimple[72][217] = (byte)-16;
	geoidSimple[72][218] = (byte)-18;
	geoidSimple[72][219] = (byte)-20;
	geoidSimple[72][220] = (byte)-22;
	geoidSimple[72][221] = (byte)-23;
	geoidSimple[72][222] = (byte)-24;
	geoidSimple[72][223] = (byte)-26;
	geoidSimple[72][224] = (byte)-28;
	geoidSimple[72][225] = (byte)-30;
	geoidSimple[72][226] = (byte)-32;
	geoidSimple[72][227] = (byte)-34;
	geoidSimple[72][228] = (byte)-36;
	geoidSimple[72][229] = (byte)-37;
	geoidSimple[72][230] = (byte)-38;
	geoidSimple[72][231] = (byte)-40;
	geoidSimple[72][232] = (byte)-41;
	geoidSimple[72][233] = (byte)-42;
	geoidSimple[72][234] = (byte)-43;
	geoidSimple[72][235] = (byte)-44;
	geoidSimple[72][236] = (byte)-45;
	geoidSimple[72][237] = (byte)-45;
	geoidSimple[72][238] = (byte)-46;
	geoidSimple[72][239] = (byte)-46;
	geoidSimple[72][240] = (byte)-46;
	geoidSimple[72][241] = (byte)-45;
	geoidSimple[72][242] = (byte)-45;
	geoidSimple[72][243] = (byte)-44;
	geoidSimple[72][244] = (byte)-43;
	geoidSimple[72][245] = (byte)-41;
	geoidSimple[72][246] = (byte)-40;
	geoidSimple[72][247] = (byte)-38;
	geoidSimple[72][248] = (byte)-36;
	geoidSimple[72][249] = (byte)-34;
	geoidSimple[72][250] = (byte)-32;
	geoidSimple[72][251] = (byte)-30;
	geoidSimple[72][252] = (byte)-29;
	geoidSimple[72][253] = (byte)-26;
	geoidSimple[72][254] = (byte)-23;
	geoidSimple[72][255] = (byte)-22;
	geoidSimple[72][256] = (byte)-21;
	geoidSimple[72][257] = (byte)-19;
	geoidSimple[72][258] = (byte)-13;
	geoidSimple[72][259] = (byte)-7;
	geoidSimple[72][260] = (byte)-5;
	geoidSimple[72][261] = (byte)-4;
	geoidSimple[72][262] = (byte)-2;
	geoidSimple[72][263] = (byte)-5;
	geoidSimple[72][264] = (byte)-11;
	geoidSimple[72][265] = (byte)-11;
	geoidSimple[72][266] = (byte)-10;
	geoidSimple[72][267] = (byte)-8;
	geoidSimple[72][268] = (byte)-8;
	geoidSimple[72][269] = (byte)-7;
	geoidSimple[72][270] = (byte)-5;
	geoidSimple[72][271] = (byte)-5;
	geoidSimple[72][272] = (byte)-8;
	geoidSimple[72][273] = (byte)-9;
	geoidSimple[72][274] = (byte)-10;
	geoidSimple[72][275] = (byte)-10;
	geoidSimple[72][276] = (byte)-10;
	geoidSimple[72][277] = (byte)-10;
	geoidSimple[72][278] = (byte)-10;
	geoidSimple[72][279] = (byte)-11;
	geoidSimple[72][280] = (byte)-13;
	geoidSimple[72][281] = (byte)-14;
	geoidSimple[72][282] = (byte)-15;
	geoidSimple[72][283] = (byte)-17;
	geoidSimple[72][284] = (byte)-20;
	geoidSimple[72][285] = (byte)-24;
	geoidSimple[72][286] = (byte)-28;
	geoidSimple[72][287] = (byte)-31;
	geoidSimple[72][288] = (byte)-30;
	geoidSimple[72][289] = (byte)-36;
	geoidSimple[72][290] = (byte)-40;
	geoidSimple[72][291] = (byte)-43;
	geoidSimple[72][292] = (byte)-44;
	geoidSimple[72][293] = (byte)-44;
	geoidSimple[72][294] = (byte)-45;
	geoidSimple[72][295] = (byte)-45;
	geoidSimple[72][296] = (byte)-43;
	geoidSimple[72][297] = (byte)-42;
	geoidSimple[72][298] = (byte)-48;
	geoidSimple[72][299] = (byte)-61;
	geoidSimple[72][300] = (byte)-56;
	geoidSimple[72][301] = (byte)-50;
	geoidSimple[72][302] = (byte)-48;
	geoidSimple[72][303] = (byte)-46;
	geoidSimple[72][304] = (byte)-45;
	geoidSimple[72][305] = (byte)-43;
	geoidSimple[72][306] = (byte)-41;
	geoidSimple[72][307] = (byte)-40;
	geoidSimple[72][308] = (byte)-39;
	geoidSimple[72][309] = (byte)-37;
	geoidSimple[72][310] = (byte)-34;
	geoidSimple[72][311] = (byte)-32;
	geoidSimple[72][312] = (byte)-29;
	geoidSimple[72][313] = (byte)-26;
	geoidSimple[72][314] = (byte)-24;
	geoidSimple[72][315] = (byte)-22;
	geoidSimple[72][316] = (byte)-20;
	geoidSimple[72][317] = (byte)-19;
	geoidSimple[72][318] = (byte)-17;
	geoidSimple[72][319] = (byte)-15;
	geoidSimple[72][320] = (byte)-13;
	geoidSimple[72][321] = (byte)-11;
	geoidSimple[72][322] = (byte)-8;
	geoidSimple[72][323] = (byte)-5;
	geoidSimple[72][324] = (byte)-2;
	geoidSimple[72][325] = (byte)0;
	geoidSimple[72][326] = (byte)3;
	geoidSimple[72][327] = (byte)6;
	geoidSimple[72][328] = (byte)9;
	geoidSimple[72][329] = (byte)12;
	geoidSimple[72][330] = (byte)14;
	geoidSimple[72][331] = (byte)16;
	geoidSimple[72][332] = (byte)18;
	geoidSimple[72][333] = (byte)20;
	geoidSimple[72][334] = (byte)23;
	geoidSimple[72][335] = (byte)24;
	geoidSimple[72][336] = (byte)24;
	geoidSimple[72][337] = (byte)25;
	geoidSimple[72][338] = (byte)25;
	geoidSimple[72][339] = (byte)26;
	geoidSimple[72][340] = (byte)26;
	geoidSimple[72][341] = (byte)26;
	geoidSimple[72][342] = (byte)27;
	geoidSimple[72][343] = (byte)30;
	geoidSimple[72][344] = (byte)31;
	geoidSimple[72][345] = (byte)32;
	geoidSimple[72][346] = (byte)33;
	geoidSimple[72][347] = (byte)29;
	geoidSimple[72][348] = (byte)28;
	geoidSimple[72][349] = (byte)27;
	geoidSimple[72][350] = (byte)28;
	geoidSimple[72][351] = (byte)27;
	geoidSimple[72][352] = (byte)27;
	geoidSimple[72][353] = (byte)27;
	geoidSimple[72][354] = (byte)27;
	geoidSimple[72][355] = (byte)27;
	geoidSimple[72][356] = (byte)27;
	geoidSimple[72][357] = (byte)28;
	geoidSimple[72][358] = (byte)28;
	geoidSimple[72][359] = (byte)28;
	}
		/** Row 73*/
	private static void init73() {
	geoidSimple[73][0] = (byte)25;
	geoidSimple[73][1] = (byte)25;
	geoidSimple[73][2] = (byte)24;
	geoidSimple[73][3] = (byte)22;
	geoidSimple[73][4] = (byte)22;
	geoidSimple[73][5] = (byte)21;
	geoidSimple[73][6] = (byte)21;
	geoidSimple[73][7] = (byte)21;
	geoidSimple[73][8] = (byte)22;
	geoidSimple[73][9] = (byte)22;
	geoidSimple[73][10] = (byte)21;
	geoidSimple[73][11] = (byte)19;
	geoidSimple[73][12] = (byte)18;
	geoidSimple[73][13] = (byte)17;
	geoidSimple[73][14] = (byte)15;
	geoidSimple[73][15] = (byte)14;
	geoidSimple[73][16] = (byte)13;
	geoidSimple[73][17] = (byte)11;
	geoidSimple[73][18] = (byte)10;
	geoidSimple[73][19] = (byte)10;
	geoidSimple[73][20] = (byte)11;
	geoidSimple[73][21] = (byte)11;
	geoidSimple[73][22] = (byte)12;
	geoidSimple[73][23] = (byte)12;
	geoidSimple[73][24] = (byte)11;
	geoidSimple[73][25] = (byte)10;
	geoidSimple[73][26] = (byte)9;
	geoidSimple[73][27] = (byte)8;
	geoidSimple[73][28] = (byte)8;
	geoidSimple[73][29] = (byte)6;
	geoidSimple[73][30] = (byte)5;
	geoidSimple[73][31] = (byte)4;
	geoidSimple[73][32] = (byte)3;
	geoidSimple[73][33] = (byte)2;
	geoidSimple[73][34] = (byte)2;
	geoidSimple[73][35] = (byte)1;
	geoidSimple[73][36] = (byte)1;
	geoidSimple[73][37] = (byte)0;
	geoidSimple[73][38] = (byte)0;
	geoidSimple[73][39] = (byte)-1;
	geoidSimple[73][40] = (byte)-2;
	geoidSimple[73][41] = (byte)-3;
	geoidSimple[73][42] = (byte)-4;
	geoidSimple[73][43] = (byte)-4;
	geoidSimple[73][44] = (byte)-5;
	geoidSimple[73][45] = (byte)-9;
	geoidSimple[73][46] = (byte)-13;
	geoidSimple[73][47] = (byte)-16;
	geoidSimple[73][48] = (byte)-19;
	geoidSimple[73][49] = (byte)-21;
	geoidSimple[73][50] = (byte)-22;
	geoidSimple[73][51] = (byte)-24;
	geoidSimple[73][52] = (byte)-26;
	geoidSimple[73][53] = (byte)-30;
	geoidSimple[73][54] = (byte)-32;
	geoidSimple[73][55] = (byte)-34;
	geoidSimple[73][56] = (byte)-36;
	geoidSimple[73][57] = (byte)-40;
	geoidSimple[73][58] = (byte)-44;
	geoidSimple[73][59] = (byte)-45;
	geoidSimple[73][60] = (byte)-54;
	geoidSimple[73][61] = (byte)-55;
	geoidSimple[73][62] = (byte)-55;
	geoidSimple[73][63] = (byte)-58;
	geoidSimple[73][64] = (byte)-61;
	geoidSimple[73][65] = (byte)-63;
	geoidSimple[73][66] = (byte)-66;
	geoidSimple[73][67] = (byte)-70;
	geoidSimple[73][68] = (byte)-72;
	geoidSimple[73][69] = (byte)-74;
	geoidSimple[73][70] = (byte)-77;
	geoidSimple[73][71] = (byte)-78;
	geoidSimple[73][72] = (byte)-77;
	geoidSimple[73][73] = (byte)-78;
	geoidSimple[73][74] = (byte)-78;
	geoidSimple[73][75] = (byte)-78;
	geoidSimple[73][76] = (byte)-79;
	geoidSimple[73][77] = (byte)-80;
	geoidSimple[73][78] = (byte)-80;
	geoidSimple[73][79] = (byte)-81;
	geoidSimple[73][80] = (byte)-80;
	geoidSimple[73][81] = (byte)-78;
	geoidSimple[73][82] = (byte)-78;
	geoidSimple[73][83] = (byte)-81;
	geoidSimple[73][84] = (byte)-81;
	geoidSimple[73][85] = (byte)-79;
	geoidSimple[73][86] = (byte)-75;
	geoidSimple[73][87] = (byte)-72;
	geoidSimple[73][88] = (byte)-69;
	geoidSimple[73][89] = (byte)-65;
	geoidSimple[73][90] = (byte)-62;
	geoidSimple[73][91] = (byte)-60;
	geoidSimple[73][92] = (byte)-59;
	geoidSimple[73][93] = (byte)-60;
	geoidSimple[73][94] = (byte)-54;
	geoidSimple[73][95] = (byte)-49;
	geoidSimple[73][96] = (byte)-46;
	geoidSimple[73][97] = (byte)-42;
	geoidSimple[73][98] = (byte)-39;
	geoidSimple[73][99] = (byte)-37;
	geoidSimple[73][100] = (byte)-34;
	geoidSimple[73][101] = (byte)-31;
	geoidSimple[73][102] = (byte)-30;
	geoidSimple[73][103] = (byte)-28;
	geoidSimple[73][104] = (byte)-25;
	geoidSimple[73][105] = (byte)-22;
	geoidSimple[73][106] = (byte)-18;
	geoidSimple[73][107] = (byte)-15;
	geoidSimple[73][108] = (byte)-12;
	geoidSimple[73][109] = (byte)-8;
	geoidSimple[73][110] = (byte)-6;
	geoidSimple[73][111] = (byte)-1;
	geoidSimple[73][112] = (byte)3;
	geoidSimple[73][113] = (byte)6;
	geoidSimple[73][114] = (byte)11;
	geoidSimple[73][115] = (byte)15;
	geoidSimple[73][116] = (byte)19;
	geoidSimple[73][117] = (byte)24;
	geoidSimple[73][118] = (byte)27;
	geoidSimple[73][119] = (byte)31;
	geoidSimple[73][120] = (byte)39;
	geoidSimple[73][121] = (byte)41;
	geoidSimple[73][122] = (byte)37;
	geoidSimple[73][123] = (byte)36;
	geoidSimple[73][124] = (byte)42;
	geoidSimple[73][125] = (byte)43;
	geoidSimple[73][126] = (byte)43;
	geoidSimple[73][127] = (byte)43;
	geoidSimple[73][128] = (byte)43;
	geoidSimple[73][129] = (byte)44;
	geoidSimple[73][130] = (byte)44;
	geoidSimple[73][131] = (byte)44;
	geoidSimple[73][132] = (byte)44;
	geoidSimple[73][133] = (byte)45;
	geoidSimple[73][134] = (byte)46;
	geoidSimple[73][135] = (byte)47;
	geoidSimple[73][136] = (byte)48;
	geoidSimple[73][137] = (byte)49;
	geoidSimple[73][138] = (byte)50;
	geoidSimple[73][139] = (byte)50;
	geoidSimple[73][140] = (byte)51;
	geoidSimple[73][141] = (byte)51;
	geoidSimple[73][142] = (byte)51;
	geoidSimple[73][143] = (byte)52;
	geoidSimple[73][144] = (byte)53;
	geoidSimple[73][145] = (byte)52;
	geoidSimple[73][146] = (byte)46;
	geoidSimple[73][147] = (byte)35;
	geoidSimple[73][148] = (byte)36;
	geoidSimple[73][149] = (byte)42;
	geoidSimple[73][150] = (byte)42;
	geoidSimple[73][151] = (byte)39;
	geoidSimple[73][152] = (byte)38;
	geoidSimple[73][153] = (byte)35;
	geoidSimple[73][154] = (byte)35;
	geoidSimple[73][155] = (byte)31;
	geoidSimple[73][156] = (byte)30;
	geoidSimple[73][157] = (byte)29;
	geoidSimple[73][158] = (byte)28;
	geoidSimple[73][159] = (byte)26;
	geoidSimple[73][160] = (byte)25;
	geoidSimple[73][161] = (byte)23;
	geoidSimple[73][162] = (byte)23;
	geoidSimple[73][163] = (byte)23;
	geoidSimple[73][164] = (byte)21;
	geoidSimple[73][165] = (byte)20;
	geoidSimple[73][166] = (byte)18;
	geoidSimple[73][167] = (byte)18;
	geoidSimple[73][168] = (byte)16;
	geoidSimple[73][169] = (byte)15;
	geoidSimple[73][170] = (byte)14;
	geoidSimple[73][171] = (byte)13;
	geoidSimple[73][172] = (byte)12;
	geoidSimple[73][173] = (byte)11;
	geoidSimple[73][174] = (byte)10;
	geoidSimple[73][175] = (byte)10;
	geoidSimple[73][176] = (byte)9;
	geoidSimple[73][177] = (byte)9;
	geoidSimple[73][178] = (byte)8;
	geoidSimple[73][179] = (byte)7;
	geoidSimple[73][LAT_GRID_SIZE] = (byte)7;
	geoidSimple[73][181] = (byte)7;
	geoidSimple[73][182] = (byte)6;
	geoidSimple[73][183] = (byte)7;
	geoidSimple[73][184] = (byte)7;
	geoidSimple[73][185] = (byte)7;
	geoidSimple[73][186] = (byte)7;
	geoidSimple[73][187] = (byte)8;
	geoidSimple[73][188] = (byte)9;
	geoidSimple[73][189] = (byte)8;
	geoidSimple[73][190] = (byte)10;
	geoidSimple[73][191] = (byte)9;
	geoidSimple[73][192] = (byte)9;
	geoidSimple[73][193] = (byte)9;
	geoidSimple[73][194] = (byte)9;
	geoidSimple[73][195] = (byte)8;
	geoidSimple[73][196] = (byte)7;
	geoidSimple[73][197] = (byte)7;
	geoidSimple[73][198] = (byte)6;
	geoidSimple[73][199] = (byte)5;
	geoidSimple[73][200] = (byte)5;
	geoidSimple[73][201] = (byte)4;
	geoidSimple[73][202] = (byte)4;
	geoidSimple[73][203] = (byte)4;
	geoidSimple[73][204] = (byte)2;
	geoidSimple[73][205] = (byte)1;
	geoidSimple[73][206] = (byte)0;
	geoidSimple[73][207] = (byte)-2;
	geoidSimple[73][208] = (byte)-3;
	geoidSimple[73][209] = (byte)-4;
	geoidSimple[73][210] = (byte)-5;
	geoidSimple[73][211] = (byte)-6;
	geoidSimple[73][212] = (byte)-8;
	geoidSimple[73][213] = (byte)-9;
	geoidSimple[73][214] = (byte)-10;
	geoidSimple[73][215] = (byte)-12;
	geoidSimple[73][216] = (byte)-13;
	geoidSimple[73][217] = (byte)-15;
	geoidSimple[73][218] = (byte)-17;
	geoidSimple[73][219] = (byte)-18;
	geoidSimple[73][220] = (byte)-20;
	geoidSimple[73][221] = (byte)-22;
	geoidSimple[73][222] = (byte)-23;
	geoidSimple[73][223] = (byte)-25;
	geoidSimple[73][224] = (byte)-27;
	geoidSimple[73][225] = (byte)-29;
	geoidSimple[73][226] = (byte)-31;
	geoidSimple[73][227] = (byte)-33;
	geoidSimple[73][228] = (byte)-34;
	geoidSimple[73][229] = (byte)-36;
	geoidSimple[73][230] = (byte)-38;
	geoidSimple[73][231] = (byte)-39;
	geoidSimple[73][232] = (byte)-40;
	geoidSimple[73][233] = (byte)-41;
	geoidSimple[73][234] = (byte)-42;
	geoidSimple[73][235] = (byte)-43;
	geoidSimple[73][236] = (byte)-44;
	geoidSimple[73][237] = (byte)-45;
	geoidSimple[73][238] = (byte)-45;
	geoidSimple[73][239] = (byte)-45;
	geoidSimple[73][240] = (byte)-45;
	geoidSimple[73][241] = (byte)-45;
	geoidSimple[73][242] = (byte)-44;
	geoidSimple[73][243] = (byte)-43;
	geoidSimple[73][244] = (byte)-43;
	geoidSimple[73][245] = (byte)-41;
	geoidSimple[73][246] = (byte)-39;
	geoidSimple[73][247] = (byte)-37;
	geoidSimple[73][248] = (byte)-35;
	geoidSimple[73][249] = (byte)-33;
	geoidSimple[73][250] = (byte)-32;
	geoidSimple[73][251] = (byte)-30;
	geoidSimple[73][252] = (byte)-28;
	geoidSimple[73][253] = (byte)-25;
	geoidSimple[73][254] = (byte)-23;
	geoidSimple[73][255] = (byte)-20;
	geoidSimple[73][256] = (byte)-19;
	geoidSimple[73][257] = (byte)-18;
	geoidSimple[73][258] = (byte)-16;
	geoidSimple[73][259] = (byte)-14;
	geoidSimple[73][260] = (byte)-10;
	geoidSimple[73][261] = (byte)-6;
	geoidSimple[73][262] = (byte)-3;
	geoidSimple[73][263] = (byte)-1;
	geoidSimple[73][264] = (byte)-6;
	geoidSimple[73][265] = (byte)-7;
	geoidSimple[73][266] = (byte)-5;
	geoidSimple[73][267] = (byte)-3;
	geoidSimple[73][268] = (byte)-4;
	geoidSimple[73][269] = (byte)-4;
	geoidSimple[73][270] = (byte)-2;
	geoidSimple[73][271] = (byte)-3;
	geoidSimple[73][272] = (byte)-5;
	geoidSimple[73][273] = (byte)-6;
	geoidSimple[73][274] = (byte)-5;
	geoidSimple[73][275] = (byte)-4;
	geoidSimple[73][276] = (byte)-4;
	geoidSimple[73][277] = (byte)-4;
	geoidSimple[73][278] = (byte)-6;
	geoidSimple[73][279] = (byte)-7;
	geoidSimple[73][280] = (byte)-10;
	geoidSimple[73][281] = (byte)-12;
	geoidSimple[73][282] = (byte)-14;
	geoidSimple[73][283] = (byte)-16;
	geoidSimple[73][284] = (byte)-18;
	geoidSimple[73][285] = (byte)-21;
	geoidSimple[73][286] = (byte)-25;
	geoidSimple[73][287] = (byte)-28;
	geoidSimple[73][288] = (byte)-29;
	geoidSimple[73][289] = (byte)-32;
	geoidSimple[73][290] = (byte)-36;
	geoidSimple[73][291] = (byte)-39;
	geoidSimple[73][292] = (byte)-41;
	geoidSimple[73][293] = (byte)-42;
	geoidSimple[73][294] = (byte)-43;
	geoidSimple[73][295] = (byte)-44;
	geoidSimple[73][296] = (byte)-42;
	geoidSimple[73][297] = (byte)-41;
	geoidSimple[73][298] = (byte)-42;
	geoidSimple[73][299] = (byte)-57;
	geoidSimple[73][300] = (byte)-59;
	geoidSimple[73][301] = (byte)-51;
	geoidSimple[73][302] = (byte)-48;
	geoidSimple[73][303] = (byte)-47;
	geoidSimple[73][304] = (byte)-47;
	geoidSimple[73][305] = (byte)-46;
	geoidSimple[73][306] = (byte)-44;
	geoidSimple[73][307] = (byte)-42;
	geoidSimple[73][308] = (byte)-40;
	geoidSimple[73][309] = (byte)-38;
	geoidSimple[73][310] = (byte)-35;
	geoidSimple[73][311] = (byte)-33;
	geoidSimple[73][312] = (byte)-30;
	geoidSimple[73][313] = (byte)-27;
	geoidSimple[73][314] = (byte)-25;
	geoidSimple[73][315] = (byte)-23;
	geoidSimple[73][316] = (byte)-22;
	geoidSimple[73][317] = (byte)-20;
	geoidSimple[73][318] = (byte)-18;
	geoidSimple[73][319] = (byte)-16;
	geoidSimple[73][320] = (byte)-14;
	geoidSimple[73][321] = (byte)-12;
	geoidSimple[73][322] = (byte)-9;
	geoidSimple[73][323] = (byte)-6;
	geoidSimple[73][324] = (byte)-3;
	geoidSimple[73][325] = (byte)0;
	geoidSimple[73][326] = (byte)1;
	geoidSimple[73][327] = (byte)4;
	geoidSimple[73][328] = (byte)7;
	geoidSimple[73][329] = (byte)10;
	geoidSimple[73][330] = (byte)12;
	geoidSimple[73][331] = (byte)14;
	geoidSimple[73][332] = (byte)16;
	geoidSimple[73][333] = (byte)18;
	geoidSimple[73][334] = (byte)22;
	geoidSimple[73][335] = (byte)26;
	geoidSimple[73][336] = (byte)25;
	geoidSimple[73][337] = (byte)28;
	geoidSimple[73][338] = (byte)24;
	geoidSimple[73][339] = (byte)25;
	geoidSimple[73][340] = (byte)26;
	geoidSimple[73][341] = (byte)26;
	geoidSimple[73][342] = (byte)27;
	geoidSimple[73][343] = (byte)30;
	geoidSimple[73][344] = (byte)30;
	geoidSimple[73][345] = (byte)32;
	geoidSimple[73][346] = (byte)33;
	geoidSimple[73][347] = (byte)29;
	geoidSimple[73][348] = (byte)27;
	geoidSimple[73][349] = (byte)27;
	geoidSimple[73][350] = (byte)27;
	geoidSimple[73][351] = (byte)27;
	geoidSimple[73][352] = (byte)27;
	geoidSimple[73][353] = (byte)27;
	geoidSimple[73][354] = (byte)28;
	geoidSimple[73][355] = (byte)28;
	geoidSimple[73][356] = (byte)28;
	geoidSimple[73][357] = (byte)28;
	geoidSimple[73][358] = (byte)27;
	geoidSimple[73][359] = (byte)26;
	}
		/** Row 74*/
	private static void init74() {
	geoidSimple[74][0] = (byte)22;
	geoidSimple[74][1] = (byte)22;
	geoidSimple[74][2] = (byte)23;
	geoidSimple[74][3] = (byte)21;
	geoidSimple[74][4] = (byte)21;
	geoidSimple[74][5] = (byte)21;
	geoidSimple[74][6] = (byte)20;
	geoidSimple[74][7] = (byte)20;
	geoidSimple[74][8] = (byte)20;
	geoidSimple[74][9] = (byte)20;
	geoidSimple[74][10] = (byte)19;
	geoidSimple[74][11] = (byte)17;
	geoidSimple[74][12] = (byte)16;
	geoidSimple[74][13] = (byte)15;
	geoidSimple[74][14] = (byte)14;
	geoidSimple[74][15] = (byte)13;
	geoidSimple[74][16] = (byte)12;
	geoidSimple[74][17] = (byte)11;
	geoidSimple[74][18] = (byte)10;
	geoidSimple[74][19] = (byte)10;
	geoidSimple[74][20] = (byte)10;
	geoidSimple[74][21] = (byte)10;
	geoidSimple[74][22] = (byte)11;
	geoidSimple[74][23] = (byte)11;
	geoidSimple[74][24] = (byte)9;
	geoidSimple[74][25] = (byte)9;
	geoidSimple[74][26] = (byte)8;
	geoidSimple[74][27] = (byte)7;
	geoidSimple[74][28] = (byte)6;
	geoidSimple[74][29] = (byte)5;
	geoidSimple[74][30] = (byte)4;
	geoidSimple[74][31] = (byte)3;
	geoidSimple[74][32] = (byte)2;
	geoidSimple[74][33] = (byte)1;
	geoidSimple[74][34] = (byte)0;
	geoidSimple[74][35] = (byte)0;
	geoidSimple[74][36] = (byte)0;
	geoidSimple[74][37] = (byte)0;
	geoidSimple[74][38] = (byte)1;
	geoidSimple[74][39] = (byte)-1;
	geoidSimple[74][40] = (byte)-4;
	geoidSimple[74][41] = (byte)-5;
	geoidSimple[74][42] = (byte)-6;
	geoidSimple[74][43] = (byte)-6;
	geoidSimple[74][44] = (byte)-5;
	geoidSimple[74][45] = (byte)-10;
	geoidSimple[74][46] = (byte)-13;
	geoidSimple[74][47] = (byte)-15;
	geoidSimple[74][48] = (byte)-17;
	geoidSimple[74][49] = (byte)-18;
	geoidSimple[74][50] = (byte)-21;
	geoidSimple[74][51] = (byte)-23;
	geoidSimple[74][52] = (byte)-27;
	geoidSimple[74][53] = (byte)-29;
	geoidSimple[74][54] = (byte)-32;
	geoidSimple[74][55] = (byte)-34;
	geoidSimple[74][56] = (byte)-37;
	geoidSimple[74][57] = (byte)-41;
	geoidSimple[74][58] = (byte)-45;
	geoidSimple[74][59] = (byte)-49;
	geoidSimple[74][60] = (byte)-55;
	geoidSimple[74][61] = (byte)-56;
	geoidSimple[74][62] = (byte)-57;
	geoidSimple[74][63] = (byte)-60;
	geoidSimple[74][64] = (byte)-63;
	geoidSimple[74][65] = (byte)-66;
	geoidSimple[74][66] = (byte)-69;
	geoidSimple[74][67] = (byte)-72;
	geoidSimple[74][68] = (byte)-75;
	geoidSimple[74][69] = (byte)-77;
	geoidSimple[74][70] = (byte)-79;
	geoidSimple[74][71] = (byte)-81;
	geoidSimple[74][72] = (byte)-81;
	geoidSimple[74][73] = (byte)-81;
	geoidSimple[74][74] = (byte)-81;
	geoidSimple[74][75] = (byte)-81;
	geoidSimple[74][76] = (byte)-82;
	geoidSimple[74][77] = (byte)-84;
	geoidSimple[74][78] = (byte)-86;
	geoidSimple[74][79] = (byte)-85;
	geoidSimple[74][80] = (byte)-83;
	geoidSimple[74][81] = (byte)-83;
	geoidSimple[74][82] = (byte)-84;
	geoidSimple[74][83] = (byte)-84;
	geoidSimple[74][84] = (byte)-83;
	geoidSimple[74][85] = (byte)-80;
	geoidSimple[74][86] = (byte)-77;
	geoidSimple[74][87] = (byte)-74;
	geoidSimple[74][88] = (byte)-70;
	geoidSimple[74][89] = (byte)-66;
	geoidSimple[74][90] = (byte)-62;
	geoidSimple[74][91] = (byte)-60;
	geoidSimple[74][92] = (byte)-60;
	geoidSimple[74][93] = (byte)-60;
	geoidSimple[74][94] = (byte)-53;
	geoidSimple[74][95] = (byte)-49;
	geoidSimple[74][96] = (byte)-45;
	geoidSimple[74][97] = (byte)-41;
	geoidSimple[74][98] = (byte)-38;
	geoidSimple[74][99] = (byte)-35;
	geoidSimple[74][100] = (byte)-33;
	geoidSimple[74][101] = (byte)-31;
	geoidSimple[74][102] = (byte)-29;
	geoidSimple[74][103] = (byte)-28;
	geoidSimple[74][104] = (byte)-25;
	geoidSimple[74][105] = (byte)-21;
	geoidSimple[74][106] = (byte)-16;
	geoidSimple[74][107] = (byte)-11;
	geoidSimple[74][108] = (byte)-9;
	geoidSimple[74][109] = (byte)-6;
	geoidSimple[74][110] = (byte)-3;
	geoidSimple[74][111] = (byte)1;
	geoidSimple[74][112] = (byte)5;
	geoidSimple[74][113] = (byte)9;
	geoidSimple[74][114] = (byte)15;
	geoidSimple[74][115] = (byte)18;
	geoidSimple[74][116] = (byte)22;
	geoidSimple[74][117] = (byte)27;
	geoidSimple[74][118] = (byte)30;
	geoidSimple[74][119] = (byte)33;
	geoidSimple[74][120] = (byte)42;
	geoidSimple[74][121] = (byte)41;
	geoidSimple[74][122] = (byte)34;
	geoidSimple[74][123] = (byte)37;
	geoidSimple[74][124] = (byte)42;
	geoidSimple[74][125] = (byte)44;
	geoidSimple[74][126] = (byte)45;
	geoidSimple[74][127] = (byte)45;
	geoidSimple[74][128] = (byte)46;
	geoidSimple[74][129] = (byte)46;
	geoidSimple[74][130] = (byte)46;
	geoidSimple[74][131] = (byte)46;
	geoidSimple[74][132] = (byte)47;
	geoidSimple[74][133] = (byte)47;
	geoidSimple[74][134] = (byte)48;
	geoidSimple[74][135] = (byte)49;
	geoidSimple[74][136] = (byte)49;
	geoidSimple[74][137] = (byte)50;
	geoidSimple[74][138] = (byte)51;
	geoidSimple[74][139] = (byte)51;
	geoidSimple[74][140] = (byte)51;
	geoidSimple[74][141] = (byte)51;
	geoidSimple[74][142] = (byte)51;
	geoidSimple[74][143] = (byte)53;
	geoidSimple[74][144] = (byte)54;
	geoidSimple[74][145] = (byte)53;
	geoidSimple[74][146] = (byte)46;
	geoidSimple[74][147] = (byte)36;
	geoidSimple[74][148] = (byte)40;
	geoidSimple[74][149] = (byte)43;
	geoidSimple[74][150] = (byte)42;
	geoidSimple[74][151] = (byte)41;
	geoidSimple[74][152] = (byte)40;
	geoidSimple[74][153] = (byte)36;
	geoidSimple[74][154] = (byte)35;
	geoidSimple[74][155] = (byte)35;
	geoidSimple[74][156] = (byte)30;
	geoidSimple[74][157] = (byte)29;
	geoidSimple[74][158] = (byte)29;
	geoidSimple[74][159] = (byte)28;
	geoidSimple[74][160] = (byte)28;
	geoidSimple[74][161] = (byte)25;
	geoidSimple[74][162] = (byte)24;
	geoidSimple[74][163] = (byte)24;
	geoidSimple[74][164] = (byte)22;
	geoidSimple[74][165] = (byte)21;
	geoidSimple[74][166] = (byte)20;
	geoidSimple[74][167] = (byte)18;
	geoidSimple[74][168] = (byte)17;
	geoidSimple[74][169] = (byte)16;
	geoidSimple[74][170] = (byte)15;
	geoidSimple[74][171] = (byte)14;
	geoidSimple[74][172] = (byte)13;
	geoidSimple[74][173] = (byte)12;
	geoidSimple[74][174] = (byte)11;
	geoidSimple[74][175] = (byte)11;
	geoidSimple[74][176] = (byte)11;
	geoidSimple[74][177] = (byte)10;
	geoidSimple[74][178] = (byte)9;
	geoidSimple[74][179] = (byte)8;
	geoidSimple[74][LAT_GRID_SIZE] = (byte)7;
	geoidSimple[74][181] = (byte)7;
	geoidSimple[74][182] = (byte)8;
	geoidSimple[74][183] = (byte)7;
	geoidSimple[74][184] = (byte)7;
	geoidSimple[74][185] = (byte)7;
	geoidSimple[74][186] = (byte)7;
	geoidSimple[74][187] = (byte)7;
	geoidSimple[74][188] = (byte)8;
	geoidSimple[74][189] = (byte)9;
	geoidSimple[74][190] = (byte)9;
	geoidSimple[74][191] = (byte)9;
	geoidSimple[74][192] = (byte)10;
	geoidSimple[74][193] = (byte)9;
	geoidSimple[74][194] = (byte)9;
	geoidSimple[74][195] = (byte)9;
	geoidSimple[74][196] = (byte)8;
	geoidSimple[74][197] = (byte)7;
	geoidSimple[74][198] = (byte)6;
	geoidSimple[74][199] = (byte)5;
	geoidSimple[74][200] = (byte)5;
	geoidSimple[74][201] = (byte)4;
	geoidSimple[74][202] = (byte)3;
	geoidSimple[74][203] = (byte)3;
	geoidSimple[74][204] = (byte)2;
	geoidSimple[74][205] = (byte)0;
	geoidSimple[74][206] = (byte)0;
	geoidSimple[74][207] = (byte)-2;
	geoidSimple[74][208] = (byte)-3;
	geoidSimple[74][209] = (byte)-4;
	geoidSimple[74][210] = (byte)-4;
	geoidSimple[74][211] = (byte)-6;
	geoidSimple[74][212] = (byte)-7;
	geoidSimple[74][213] = (byte)-8;
	geoidSimple[74][214] = (byte)-9;
	geoidSimple[74][215] = (byte)-11;
	geoidSimple[74][216] = (byte)-12;
	geoidSimple[74][217] = (byte)-14;
	geoidSimple[74][218] = (byte)-15;
	geoidSimple[74][219] = (byte)-17;
	geoidSimple[74][220] = (byte)-18;
	geoidSimple[74][221] = (byte)-20;
	geoidSimple[74][222] = (byte)-21;
	geoidSimple[74][223] = (byte)-23;
	geoidSimple[74][224] = (byte)-25;
	geoidSimple[74][225] = (byte)-27;
	geoidSimple[74][226] = (byte)-29;
	geoidSimple[74][227] = (byte)-31;
	geoidSimple[74][228] = (byte)-33;
	geoidSimple[74][229] = (byte)-35;
	geoidSimple[74][230] = (byte)-37;
	geoidSimple[74][231] = (byte)-38;
	geoidSimple[74][232] = (byte)-40;
	geoidSimple[74][233] = (byte)-41;
	geoidSimple[74][234] = (byte)-42;
	geoidSimple[74][235] = (byte)-43;
	geoidSimple[74][236] = (byte)-44;
	geoidSimple[74][237] = (byte)-44;
	geoidSimple[74][238] = (byte)-45;
	geoidSimple[74][239] = (byte)-45;
	geoidSimple[74][240] = (byte)-45;
	geoidSimple[74][241] = (byte)-44;
	geoidSimple[74][242] = (byte)-44;
	geoidSimple[74][243] = (byte)-43;
	geoidSimple[74][244] = (byte)-42;
	geoidSimple[74][245] = (byte)-40;
	geoidSimple[74][246] = (byte)-38;
	geoidSimple[74][247] = (byte)-37;
	geoidSimple[74][248] = (byte)-35;
	geoidSimple[74][249] = (byte)-33;
	geoidSimple[74][250] = (byte)-31;
	geoidSimple[74][251] = (byte)-30;
	geoidSimple[74][252] = (byte)-28;
	geoidSimple[74][253] = (byte)-25;
	geoidSimple[74][254] = (byte)-22;
	geoidSimple[74][255] = (byte)-20;
	geoidSimple[74][256] = (byte)-18;
	geoidSimple[74][257] = (byte)-16;
	geoidSimple[74][258] = (byte)-14;
	geoidSimple[74][259] = (byte)-13;
	geoidSimple[74][260] = (byte)-12;
	geoidSimple[74][261] = (byte)-11;
	geoidSimple[74][262] = (byte)-8;
	geoidSimple[74][263] = (byte)-5;
	geoidSimple[74][264] = (byte)-8;
	geoidSimple[74][265] = (byte)-5;
	geoidSimple[74][266] = (byte)-5;
	geoidSimple[74][267] = (byte)-2;
	geoidSimple[74][268] = (byte)1;
	geoidSimple[74][269] = (byte)0;
	geoidSimple[74][270] = (byte)0;
	geoidSimple[74][271] = (byte)0;
	geoidSimple[74][272] = (byte)0;
	geoidSimple[74][273] = (byte)1;
	geoidSimple[74][274] = (byte)1;
	geoidSimple[74][275] = (byte)0;
	geoidSimple[74][276] = (byte)-1;
	geoidSimple[74][277] = (byte)-2;
	geoidSimple[74][278] = (byte)-3;
	geoidSimple[74][279] = (byte)-5;
	geoidSimple[74][280] = (byte)-7;
	geoidSimple[74][281] = (byte)-10;
	geoidSimple[74][282] = (byte)-12;
	geoidSimple[74][283] = (byte)-15;
	geoidSimple[74][284] = (byte)-17;
	geoidSimple[74][285] = (byte)-20;
	geoidSimple[74][286] = (byte)-22;
	geoidSimple[74][287] = (byte)-24;
	geoidSimple[74][288] = (byte)-26;
	geoidSimple[74][289] = (byte)-29;
	geoidSimple[74][290] = (byte)-31;
	geoidSimple[74][291] = (byte)-33;
	geoidSimple[74][292] = (byte)-36;
	geoidSimple[74][293] = (byte)-38;
	geoidSimple[74][294] = (byte)-40;
	geoidSimple[74][295] = (byte)-41;
	geoidSimple[74][296] = (byte)-40;
	geoidSimple[74][297] = (byte)-41;
	geoidSimple[74][298] = (byte)-41;
	geoidSimple[74][299] = (byte)-49;
	geoidSimple[74][300] = (byte)-58;
	geoidSimple[74][301] = (byte)-51;
	geoidSimple[74][302] = (byte)-48;
	geoidSimple[74][303] = (byte)-47;
	geoidSimple[74][304] = (byte)-47;
	geoidSimple[74][305] = (byte)-47;
	geoidSimple[74][306] = (byte)-45;
	geoidSimple[74][307] = (byte)-43;
	geoidSimple[74][308] = (byte)-41;
	geoidSimple[74][309] = (byte)-39;
	geoidSimple[74][310] = (byte)-36;
	geoidSimple[74][311] = (byte)-33;
	geoidSimple[74][312] = (byte)-31;
	geoidSimple[74][313] = (byte)-28;
	geoidSimple[74][314] = (byte)-26;
	geoidSimple[74][315] = (byte)-25;
	geoidSimple[74][316] = (byte)-23;
	geoidSimple[74][317] = (byte)-21;
	geoidSimple[74][318] = (byte)-19;
	geoidSimple[74][319] = (byte)-17;
	geoidSimple[74][320] = (byte)-15;
	geoidSimple[74][321] = (byte)-13;
	geoidSimple[74][322] = (byte)-10;
	geoidSimple[74][323] = (byte)-7;
	geoidSimple[74][324] = (byte)-5;
	geoidSimple[74][325] = (byte)-3;
	geoidSimple[74][326] = (byte)0;
	geoidSimple[74][327] = (byte)2;
	geoidSimple[74][328] = (byte)5;
	geoidSimple[74][329] = (byte)7;
	geoidSimple[74][330] = (byte)10;
	geoidSimple[74][331] = (byte)12;
	geoidSimple[74][332] = (byte)15;
	geoidSimple[74][333] = (byte)17;
	geoidSimple[74][334] = (byte)19;
	geoidSimple[74][335] = (byte)21;
	geoidSimple[74][336] = (byte)26;
	geoidSimple[74][337] = (byte)27;
	geoidSimple[74][338] = (byte)22;
	geoidSimple[74][339] = (byte)23;
	geoidSimple[74][340] = (byte)24;
	geoidSimple[74][341] = (byte)25;
	geoidSimple[74][342] = (byte)28;
	geoidSimple[74][343] = (byte)30;
	geoidSimple[74][344] = (byte)30;
	geoidSimple[74][345] = (byte)31;
	geoidSimple[74][346] = (byte)33;
	geoidSimple[74][347] = (byte)30;
	geoidSimple[74][348] = (byte)28;
	geoidSimple[74][349] = (byte)28;
	geoidSimple[74][350] = (byte)29;
	geoidSimple[74][351] = (byte)28;
	geoidSimple[74][352] = (byte)28;
	geoidSimple[74][353] = (byte)27;
	geoidSimple[74][354] = (byte)27;
	geoidSimple[74][355] = (byte)28;
	geoidSimple[74][356] = (byte)28;
	geoidSimple[74][357] = (byte)28;
	geoidSimple[74][358] = (byte)26;
	geoidSimple[74][359] = (byte)24;
	}
		/** Row 75*/
	private static void init75() {
	geoidSimple[75][0] = (byte)22;
	geoidSimple[75][1] = (byte)22;
	geoidSimple[75][2] = (byte)22;
	geoidSimple[75][3] = (byte)21;
	geoidSimple[75][4] = (byte)20;
	geoidSimple[75][5] = (byte)20;
	geoidSimple[75][6] = (byte)19;
	geoidSimple[75][7] = (byte)19;
	geoidSimple[75][8] = (byte)19;
	geoidSimple[75][9] = (byte)20;
	geoidSimple[75][10] = (byte)19;
	geoidSimple[75][11] = (byte)18;
	geoidSimple[75][12] = (byte)16;
	geoidSimple[75][13] = (byte)14;
	geoidSimple[75][14] = (byte)13;
	geoidSimple[75][15] = (byte)13;
	geoidSimple[75][16] = (byte)12;
	geoidSimple[75][17] = (byte)11;
	geoidSimple[75][18] = (byte)10;
	geoidSimple[75][19] = (byte)9;
	geoidSimple[75][20] = (byte)9;
	geoidSimple[75][21] = (byte)9;
	geoidSimple[75][22] = (byte)10;
	geoidSimple[75][23] = (byte)9;
	geoidSimple[75][24] = (byte)8;
	geoidSimple[75][25] = (byte)7;
	geoidSimple[75][26] = (byte)6;
	geoidSimple[75][27] = (byte)5;
	geoidSimple[75][28] = (byte)4;
	geoidSimple[75][29] = (byte)3;
	geoidSimple[75][30] = (byte)2;
	geoidSimple[75][31] = (byte)1;
	geoidSimple[75][32] = (byte)0;
	geoidSimple[75][33] = (byte)0;
	geoidSimple[75][34] = (byte)0;
	geoidSimple[75][35] = (byte)0;
	geoidSimple[75][36] = (byte)-1;
	geoidSimple[75][37] = (byte)-6;
	geoidSimple[75][38] = (byte)-2;
	geoidSimple[75][39] = (byte)0;
	geoidSimple[75][40] = (byte)-4;
	geoidSimple[75][41] = (byte)-6;
	geoidSimple[75][42] = (byte)-8;
	geoidSimple[75][43] = (byte)-8;
	geoidSimple[75][44] = (byte)-6;
	geoidSimple[75][45] = (byte)-9;
	geoidSimple[75][46] = (byte)-13;
	geoidSimple[75][47] = (byte)-15;
	geoidSimple[75][48] = (byte)-17;
	geoidSimple[75][49] = (byte)-20;
	geoidSimple[75][50] = (byte)-23;
	geoidSimple[75][51] = (byte)-25;
	geoidSimple[75][52] = (byte)-28;
	geoidSimple[75][53] = (byte)-30;
	geoidSimple[75][54] = (byte)-33;
	geoidSimple[75][55] = (byte)-35;
	geoidSimple[75][56] = (byte)-38;
	geoidSimple[75][57] = (byte)-41;
	geoidSimple[75][58] = (byte)-46;
	geoidSimple[75][59] = (byte)-51;
	geoidSimple[75][60] = (byte)-55;
	geoidSimple[75][61] = (byte)-57;
	geoidSimple[75][62] = (byte)-59;
	geoidSimple[75][63] = (byte)-62;
	geoidSimple[75][64] = (byte)-66;
	geoidSimple[75][65] = (byte)-68;
	geoidSimple[75][66] = (byte)-71;
	geoidSimple[75][67] = (byte)-74;
	geoidSimple[75][68] = (byte)-77;
	geoidSimple[75][69] = (byte)-80;
	geoidSimple[75][70] = (byte)-82;
	geoidSimple[75][71] = (byte)-83;
	geoidSimple[75][72] = (byte)-84;
	geoidSimple[75][73] = (byte)-83;
	geoidSimple[75][74] = (byte)-85;
	geoidSimple[75][75] = (byte)-84;
	geoidSimple[75][76] = (byte)-84;
	geoidSimple[75][77] = (byte)-85;
	geoidSimple[75][78] = (byte)-88;
	geoidSimple[75][79] = (byte)-88;
	geoidSimple[75][80] = (byte)-88;
	geoidSimple[75][81] = (byte)-89;
	geoidSimple[75][82] = (byte)-89;
	geoidSimple[75][83] = (byte)-86;
	geoidSimple[75][84] = (byte)-85;
	geoidSimple[75][85] = (byte)-82;
	geoidSimple[75][86] = (byte)-78;
	geoidSimple[75][87] = (byte)-75;
	geoidSimple[75][88] = (byte)-71;
	geoidSimple[75][89] = (byte)-66;
	geoidSimple[75][90] = (byte)-63;
	geoidSimple[75][91] = (byte)-60;
	geoidSimple[75][92] = (byte)-61;
	geoidSimple[75][93] = (byte)-60;
	geoidSimple[75][94] = (byte)-53;
	geoidSimple[75][95] = (byte)-48;
	geoidSimple[75][96] = (byte)-45;
	geoidSimple[75][97] = (byte)-41;
	geoidSimple[75][98] = (byte)-37;
	geoidSimple[75][99] = (byte)-35;
	geoidSimple[75][100] = (byte)-32;
	geoidSimple[75][101] = (byte)-29;
	geoidSimple[75][102] = (byte)-27;
	geoidSimple[75][103] = (byte)-24;
	geoidSimple[75][104] = (byte)-22;
	geoidSimple[75][105] = (byte)-18;
	geoidSimple[75][106] = (byte)-13;
	geoidSimple[75][107] = (byte)-8;
	geoidSimple[75][108] = (byte)-5;
	geoidSimple[75][109] = (byte)-3;
	geoidSimple[75][110] = (byte)0;
	geoidSimple[75][111] = (byte)3;
	geoidSimple[75][112] = (byte)8;
	geoidSimple[75][113] = (byte)12;
	geoidSimple[75][114] = (byte)16;
	geoidSimple[75][115] = (byte)21;
	geoidSimple[75][116] = (byte)25;
	geoidSimple[75][117] = (byte)29;
	geoidSimple[75][118] = (byte)32;
	geoidSimple[75][119] = (byte)32;
	geoidSimple[75][120] = (byte)41;
	geoidSimple[75][121] = (byte)44;
	geoidSimple[75][122] = (byte)45;
	geoidSimple[75][123] = (byte)47;
	geoidSimple[75][124] = (byte)45;
	geoidSimple[75][125] = (byte)43;
	geoidSimple[75][126] = (byte)46;
	geoidSimple[75][127] = (byte)48;
	geoidSimple[75][128] = (byte)48;
	geoidSimple[75][129] = (byte)48;
	geoidSimple[75][130] = (byte)48;
	geoidSimple[75][131] = (byte)48;
	geoidSimple[75][132] = (byte)49;
	geoidSimple[75][133] = (byte)49;
	geoidSimple[75][134] = (byte)50;
	geoidSimple[75][135] = (byte)50;
	geoidSimple[75][136] = (byte)51;
	geoidSimple[75][137] = (byte)52;
	geoidSimple[75][138] = (byte)52;
	geoidSimple[75][139] = (byte)52;
	geoidSimple[75][140] = (byte)52;
	geoidSimple[75][141] = (byte)52;
	geoidSimple[75][142] = (byte)52;
	geoidSimple[75][143] = (byte)54;
	geoidSimple[75][144] = (byte)54;
	geoidSimple[75][145] = (byte)53;
	geoidSimple[75][146] = (byte)42;
	geoidSimple[75][147] = (byte)35;
	geoidSimple[75][148] = (byte)42;
	geoidSimple[75][149] = (byte)44;
	geoidSimple[75][150] = (byte)43;
	geoidSimple[75][151] = (byte)40;
	geoidSimple[75][152] = (byte)39;
	geoidSimple[75][153] = (byte)37;
	geoidSimple[75][154] = (byte)35;
	geoidSimple[75][155] = (byte)33;
	geoidSimple[75][156] = (byte)33;
	geoidSimple[75][157] = (byte)31;
	geoidSimple[75][158] = (byte)29;
	geoidSimple[75][159] = (byte)28;
	geoidSimple[75][160] = (byte)29;
	geoidSimple[75][161] = (byte)27;
	geoidSimple[75][162] = (byte)25;
	geoidSimple[75][163] = (byte)24;
	geoidSimple[75][164] = (byte)23;
	geoidSimple[75][165] = (byte)23;
	geoidSimple[75][166] = (byte)21;
	geoidSimple[75][167] = (byte)20;
	geoidSimple[75][168] = (byte)19;
	geoidSimple[75][169] = (byte)18;
	geoidSimple[75][170] = (byte)16;
	geoidSimple[75][171] = (byte)15;
	geoidSimple[75][172] = (byte)14;
	geoidSimple[75][173] = (byte)13;
	geoidSimple[75][174] = (byte)13;
	geoidSimple[75][175] = (byte)12;
	geoidSimple[75][176] = (byte)12;
	geoidSimple[75][177] = (byte)11;
	geoidSimple[75][178] = (byte)9;
	geoidSimple[75][179] = (byte)8;
	geoidSimple[75][LAT_GRID_SIZE] = (byte)9;
	geoidSimple[75][181] = (byte)9;
	geoidSimple[75][182] = (byte)9;
	geoidSimple[75][183] = (byte)8;
	geoidSimple[75][184] = (byte)8;
	geoidSimple[75][185] = (byte)8;
	geoidSimple[75][186] = (byte)8;
	geoidSimple[75][187] = (byte)8;
	geoidSimple[75][188] = (byte)8;
	geoidSimple[75][189] = (byte)9;
	geoidSimple[75][190] = (byte)9;
	geoidSimple[75][191] = (byte)10;
	geoidSimple[75][192] = (byte)10;
	geoidSimple[75][193] = (byte)10;
	geoidSimple[75][194] = (byte)10;
	geoidSimple[75][195] = (byte)9;
	geoidSimple[75][196] = (byte)8;
	geoidSimple[75][197] = (byte)7;
	geoidSimple[75][198] = (byte)6;
	geoidSimple[75][199] = (byte)5;
	geoidSimple[75][200] = (byte)5;
	geoidSimple[75][201] = (byte)4;
	geoidSimple[75][202] = (byte)3;
	geoidSimple[75][203] = (byte)2;
	geoidSimple[75][204] = (byte)1;
	geoidSimple[75][205] = (byte)0;
	geoidSimple[75][206] = (byte)-1;
	geoidSimple[75][207] = (byte)-2;
	geoidSimple[75][208] = (byte)-3;
	geoidSimple[75][209] = (byte)-3;
	geoidSimple[75][210] = (byte)-4;
	geoidSimple[75][211] = (byte)-5;
	geoidSimple[75][212] = (byte)-6;
	geoidSimple[75][213] = (byte)-7;
	geoidSimple[75][214] = (byte)-8;
	geoidSimple[75][215] = (byte)-10;
	geoidSimple[75][216] = (byte)-11;
	geoidSimple[75][217] = (byte)-12;
	geoidSimple[75][218] = (byte)-13;
	geoidSimple[75][219] = (byte)-15;
	geoidSimple[75][220] = (byte)-16;
	geoidSimple[75][221] = (byte)-18;
	geoidSimple[75][222] = (byte)-20;
	geoidSimple[75][223] = (byte)-22;
	geoidSimple[75][224] = (byte)-24;
	geoidSimple[75][225] = (byte)-26;
	geoidSimple[75][226] = (byte)-28;
	geoidSimple[75][227] = (byte)-30;
	geoidSimple[75][228] = (byte)-32;
	geoidSimple[75][229] = (byte)-34;
	geoidSimple[75][230] = (byte)-36;
	geoidSimple[75][231] = (byte)-37;
	geoidSimple[75][232] = (byte)-38;
	geoidSimple[75][233] = (byte)-40;
	geoidSimple[75][234] = (byte)-41;
	geoidSimple[75][235] = (byte)-42;
	geoidSimple[75][236] = (byte)-43;
	geoidSimple[75][237] = (byte)-44;
	geoidSimple[75][238] = (byte)-44;
	geoidSimple[75][239] = (byte)-44;
	geoidSimple[75][240] = (byte)-44;
	geoidSimple[75][241] = (byte)-44;
	geoidSimple[75][242] = (byte)-43;
	geoidSimple[75][243] = (byte)-43;
	geoidSimple[75][244] = (byte)-41;
	geoidSimple[75][245] = (byte)-40;
	geoidSimple[75][246] = (byte)-38;
	geoidSimple[75][247] = (byte)-37;
	geoidSimple[75][248] = (byte)-35;
	geoidSimple[75][249] = (byte)-33;
	geoidSimple[75][250] = (byte)-31;
	geoidSimple[75][251] = (byte)-29;
	geoidSimple[75][252] = (byte)-27;
	geoidSimple[75][253] = (byte)-24;
	geoidSimple[75][254] = (byte)-22;
	geoidSimple[75][255] = (byte)-20;
	geoidSimple[75][256] = (byte)-17;
	geoidSimple[75][257] = (byte)-15;
	geoidSimple[75][258] = (byte)-13;
	geoidSimple[75][259] = (byte)-12;
	geoidSimple[75][260] = (byte)-10;
	geoidSimple[75][261] = (byte)-8;
	geoidSimple[75][262] = (byte)-8;
	geoidSimple[75][263] = (byte)-7;
	geoidSimple[75][264] = (byte)-8;
	geoidSimple[75][265] = (byte)-9;
	geoidSimple[75][266] = (byte)-6;
	geoidSimple[75][267] = (byte)-4;
	geoidSimple[75][268] = (byte)0;
	geoidSimple[75][269] = (byte)1;
	geoidSimple[75][270] = (byte)1;
	geoidSimple[75][271] = (byte)2;
	geoidSimple[75][272] = (byte)3;
	geoidSimple[75][273] = (byte)4;
	geoidSimple[75][274] = (byte)4;
	geoidSimple[75][275] = (byte)3;
	geoidSimple[75][276] = (byte)1;
	geoidSimple[75][277] = (byte)0;
	geoidSimple[75][278] = (byte)0;
	geoidSimple[75][279] = (byte)-3;
	geoidSimple[75][280] = (byte)-5;
	geoidSimple[75][281] = (byte)-7;
	geoidSimple[75][282] = (byte)-10;
	geoidSimple[75][283] = (byte)-14;
	geoidSimple[75][284] = (byte)-16;
	geoidSimple[75][285] = (byte)-18;
	geoidSimple[75][286] = (byte)-20;
	geoidSimple[75][287] = (byte)-22;
	geoidSimple[75][288] = (byte)-25;
	geoidSimple[75][289] = (byte)-29;
	geoidSimple[75][290] = (byte)-31;
	geoidSimple[75][291] = (byte)-33;
	geoidSimple[75][292] = (byte)-35;
	geoidSimple[75][293] = (byte)-36;
	geoidSimple[75][294] = (byte)-38;
	geoidSimple[75][295] = (byte)-38;
	geoidSimple[75][296] = (byte)-38;
	geoidSimple[75][297] = (byte)-40;
	geoidSimple[75][298] = (byte)-41;
	geoidSimple[75][299] = (byte)-43;
	geoidSimple[75][300] = (byte)-55;
	geoidSimple[75][301] = (byte)-53;
	geoidSimple[75][302] = (byte)-50;
	geoidSimple[75][303] = (byte)-49;
	geoidSimple[75][304] = (byte)-48;
	geoidSimple[75][305] = (byte)-47;
	geoidSimple[75][306] = (byte)-45;
	geoidSimple[75][307] = (byte)-43;
	geoidSimple[75][308] = (byte)-42;
	geoidSimple[75][309] = (byte)-40;
	geoidSimple[75][310] = (byte)-38;
	geoidSimple[75][311] = (byte)-35;
	geoidSimple[75][312] = (byte)-32;
	geoidSimple[75][313] = (byte)-30;
	geoidSimple[75][314] = (byte)-27;
	geoidSimple[75][315] = (byte)-25;
	geoidSimple[75][316] = (byte)-23;
	geoidSimple[75][317] = (byte)-22;
	geoidSimple[75][318] = (byte)-20;
	geoidSimple[75][319] = (byte)-18;
	geoidSimple[75][320] = (byte)-16;
	geoidSimple[75][321] = (byte)-14;
	geoidSimple[75][322] = (byte)-12;
	geoidSimple[75][323] = (byte)-9;
	geoidSimple[75][324] = (byte)-7;
	geoidSimple[75][325] = (byte)-5;
	geoidSimple[75][326] = (byte)-2;
	geoidSimple[75][327] = (byte)0;
	geoidSimple[75][328] = (byte)2;
	geoidSimple[75][329] = (byte)5;
	geoidSimple[75][330] = (byte)7;
	geoidSimple[75][331] = (byte)10;
	geoidSimple[75][332] = (byte)12;
	geoidSimple[75][333] = (byte)15;
	geoidSimple[75][334] = (byte)17;
	geoidSimple[75][335] = (byte)20;
	geoidSimple[75][336] = (byte)22;
	geoidSimple[75][337] = (byte)20;
	geoidSimple[75][338] = (byte)20;
	geoidSimple[75][339] = (byte)21;
	geoidSimple[75][340] = (byte)23;
	geoidSimple[75][341] = (byte)25;
	geoidSimple[75][342] = (byte)29;
	geoidSimple[75][343] = (byte)29;
	geoidSimple[75][344] = (byte)29;
	geoidSimple[75][345] = (byte)30;
	geoidSimple[75][346] = (byte)32;
	geoidSimple[75][347] = (byte)32;
	geoidSimple[75][348] = (byte)29;
	geoidSimple[75][349] = (byte)30;
	geoidSimple[75][350] = (byte)30;
	geoidSimple[75][351] = (byte)29;
	geoidSimple[75][352] = (byte)29;
	geoidSimple[75][353] = (byte)28;
	geoidSimple[75][354] = (byte)28;
	geoidSimple[75][355] = (byte)28;
	geoidSimple[75][356] = (byte)29;
	geoidSimple[75][357] = (byte)26;
	geoidSimple[75][358] = (byte)24;
	geoidSimple[75][359] = (byte)23;
	}
		/** Row 76*/
	private static void init76() {
	geoidSimple[76][0] = (byte)23;
	geoidSimple[76][1] = (byte)23;
	geoidSimple[76][2] = (byte)22;
	geoidSimple[76][3] = (byte)21;
	geoidSimple[76][4] = (byte)20;
	geoidSimple[76][5] = (byte)19;
	geoidSimple[76][6] = (byte)18;
	geoidSimple[76][7] = (byte)19;
	geoidSimple[76][8] = (byte)20;
	geoidSimple[76][9] = (byte)20;
	geoidSimple[76][10] = (byte)19;
	geoidSimple[76][11] = (byte)18;
	geoidSimple[76][12] = (byte)16;
	geoidSimple[76][13] = (byte)14;
	geoidSimple[76][14] = (byte)13;
	geoidSimple[76][15] = (byte)13;
	geoidSimple[76][16] = (byte)11;
	geoidSimple[76][17] = (byte)10;
	geoidSimple[76][18] = (byte)9;
	geoidSimple[76][19] = (byte)8;
	geoidSimple[76][20] = (byte)7;
	geoidSimple[76][21] = (byte)7;
	geoidSimple[76][22] = (byte)8;
	geoidSimple[76][23] = (byte)8;
	geoidSimple[76][24] = (byte)7;
	geoidSimple[76][25] = (byte)5;
	geoidSimple[76][26] = (byte)4;
	geoidSimple[76][27] = (byte)3;
	geoidSimple[76][28] = (byte)3;
	geoidSimple[76][29] = (byte)2;
	geoidSimple[76][30] = (byte)1;
	geoidSimple[76][31] = (byte)0;
	geoidSimple[76][32] = (byte)-1;
	geoidSimple[76][33] = (byte)-1;
	geoidSimple[76][34] = (byte)-2;
	geoidSimple[76][35] = (byte)-2;
	geoidSimple[76][36] = (byte)-3;
	geoidSimple[76][37] = (byte)-4;
	geoidSimple[76][38] = (byte)-3;
	geoidSimple[76][39] = (byte)-1;
	geoidSimple[76][40] = (byte)-5;
	geoidSimple[76][41] = (byte)-7;
	geoidSimple[76][42] = (byte)-9;
	geoidSimple[76][43] = (byte)-9;
	geoidSimple[76][44] = (byte)-9;
	geoidSimple[76][45] = (byte)-13;
	geoidSimple[76][46] = (byte)-16;
	geoidSimple[76][47] = (byte)-18;
	geoidSimple[76][48] = (byte)-20;
	geoidSimple[76][49] = (byte)-23;
	geoidSimple[76][50] = (byte)-25;
	geoidSimple[76][51] = (byte)-28;
	geoidSimple[76][52] = (byte)-30;
	geoidSimple[76][53] = (byte)-33;
	geoidSimple[76][54] = (byte)-35;
	geoidSimple[76][55] = (byte)-38;
	geoidSimple[76][56] = (byte)-40;
	geoidSimple[76][57] = (byte)-43;
	geoidSimple[76][58] = (byte)-48;
	geoidSimple[76][59] = (byte)-52;
	geoidSimple[76][60] = (byte)-56;
	geoidSimple[76][61] = (byte)-58;
	geoidSimple[76][62] = (byte)-61;
	geoidSimple[76][63] = (byte)-65;
	geoidSimple[76][64] = (byte)-68;
	geoidSimple[76][65] = (byte)-71;
	geoidSimple[76][66] = (byte)-73;
	geoidSimple[76][67] = (byte)-76;
	geoidSimple[76][68] = (byte)-79;
	geoidSimple[76][69] = (byte)-82;
	geoidSimple[76][70] = (byte)-84;
	geoidSimple[76][71] = (byte)-85;
	geoidSimple[76][72] = (byte)-87;
	geoidSimple[76][73] = (byte)-87;
	geoidSimple[76][74] = (byte)-88;
	geoidSimple[76][75] = (byte)-88;
	geoidSimple[76][76] = (byte)-85;
	geoidSimple[76][77] = (byte)-85;
	geoidSimple[76][78] = (byte)-86;
	geoidSimple[76][79] = (byte)-89;
	geoidSimple[76][80] = (byte)-91;
	geoidSimple[76][81] = (byte)-91;
	geoidSimple[76][82] = (byte)-90;
	geoidSimple[76][83] = (byte)-87;
	geoidSimple[76][84] = (byte)-86;
	geoidSimple[76][85] = (byte)-84;
	geoidSimple[76][86] = (byte)-79;
	geoidSimple[76][87] = (byte)-75;
	geoidSimple[76][88] = (byte)-71;
	geoidSimple[76][89] = (byte)-67;
	geoidSimple[76][90] = (byte)-63;
	geoidSimple[76][91] = (byte)-61;
	geoidSimple[76][92] = (byte)-60;
	geoidSimple[76][93] = (byte)-61;
	geoidSimple[76][94] = (byte)-54;
	geoidSimple[76][95] = (byte)-49;
	geoidSimple[76][96] = (byte)-44;
	geoidSimple[76][97] = (byte)-40;
	geoidSimple[76][98] = (byte)-37;
	geoidSimple[76][99] = (byte)-33;
	geoidSimple[76][100] = (byte)-31;
	geoidSimple[76][101] = (byte)-28;
	geoidSimple[76][102] = (byte)-25;
	geoidSimple[76][103] = (byte)-22;
	geoidSimple[76][104] = (byte)-19;
	geoidSimple[76][105] = (byte)-15;
	geoidSimple[76][106] = (byte)-11;
	geoidSimple[76][107] = (byte)-6;
	geoidSimple[76][108] = (byte)-2;
	geoidSimple[76][109] = (byte)0;
	geoidSimple[76][110] = (byte)1;
	geoidSimple[76][111] = (byte)6;
	geoidSimple[76][112] = (byte)10;
	geoidSimple[76][113] = (byte)15;
	geoidSimple[76][114] = (byte)19;
	geoidSimple[76][115] = (byte)23;
	geoidSimple[76][116] = (byte)28;
	geoidSimple[76][117] = (byte)32;
	geoidSimple[76][118] = (byte)35;
	geoidSimple[76][119] = (byte)34;
	geoidSimple[76][120] = (byte)38;
	geoidSimple[76][121] = (byte)46;
	geoidSimple[76][122] = (byte)48;
	geoidSimple[76][123] = (byte)51;
	geoidSimple[76][124] = (byte)50;
	geoidSimple[76][125] = (byte)43;
	geoidSimple[76][126] = (byte)48;
	geoidSimple[76][127] = (byte)50;
	geoidSimple[76][128] = (byte)51;
	geoidSimple[76][129] = (byte)50;
	geoidSimple[76][130] = (byte)50;
	geoidSimple[76][131] = (byte)50;
	geoidSimple[76][132] = (byte)50;
	geoidSimple[76][133] = (byte)50;
	geoidSimple[76][134] = (byte)51;
	geoidSimple[76][135] = (byte)52;
	geoidSimple[76][136] = (byte)53;
	geoidSimple[76][137] = (byte)53;
	geoidSimple[76][138] = (byte)53;
	geoidSimple[76][139] = (byte)53;
	geoidSimple[76][140] = (byte)52;
	geoidSimple[76][141] = (byte)52;
	geoidSimple[76][142] = (byte)53;
	geoidSimple[76][143] = (byte)54;
	geoidSimple[76][144] = (byte)54;
	geoidSimple[76][145] = (byte)48;
	geoidSimple[76][146] = (byte)34;
	geoidSimple[76][147] = (byte)38;
	geoidSimple[76][148] = (byte)44;
	geoidSimple[76][149] = (byte)44;
	geoidSimple[76][150] = (byte)43;
	geoidSimple[76][151] = (byte)41;
	geoidSimple[76][152] = (byte)39;
	geoidSimple[76][153] = (byte)38;
	geoidSimple[76][154] = (byte)36;
	geoidSimple[76][155] = (byte)34;
	geoidSimple[76][156] = (byte)33;
	geoidSimple[76][157] = (byte)32;
	geoidSimple[76][158] = (byte)30;
	geoidSimple[76][159] = (byte)30;
	geoidSimple[76][160] = (byte)29;
	geoidSimple[76][161] = (byte)29;
	geoidSimple[76][162] = (byte)27;
	geoidSimple[76][163] = (byte)27;
	geoidSimple[76][164] = (byte)26;
	geoidSimple[76][165] = (byte)24;
	geoidSimple[76][166] = (byte)22;
	geoidSimple[76][167] = (byte)24;
	geoidSimple[76][168] = (byte)20;
	geoidSimple[76][169] = (byte)18;
	geoidSimple[76][170] = (byte)18;
	geoidSimple[76][171] = (byte)16;
	geoidSimple[76][172] = (byte)15;
	geoidSimple[76][173] = (byte)14;
	geoidSimple[76][174] = (byte)14;
	geoidSimple[76][175] = (byte)14;
	geoidSimple[76][176] = (byte)13;
	geoidSimple[76][177] = (byte)12;
	geoidSimple[76][178] = (byte)10;
	geoidSimple[76][179] = (byte)10;
	geoidSimple[76][LAT_GRID_SIZE] = (byte)9;
	geoidSimple[76][181] = (byte)10;
	geoidSimple[76][182] = (byte)10;
	geoidSimple[76][183] = (byte)9;
	geoidSimple[76][184] = (byte)9;
	geoidSimple[76][185] = (byte)9;
	geoidSimple[76][186] = (byte)9;
	geoidSimple[76][187] = (byte)9;
	geoidSimple[76][188] = (byte)9;
	geoidSimple[76][189] = (byte)9;
	geoidSimple[76][190] = (byte)9;
	geoidSimple[76][191] = (byte)10;
	geoidSimple[76][192] = (byte)11;
	geoidSimple[76][193] = (byte)11;
	geoidSimple[76][194] = (byte)11;
	geoidSimple[76][195] = (byte)10;
	geoidSimple[76][196] = (byte)9;
	geoidSimple[76][197] = (byte)8;
	geoidSimple[76][198] = (byte)7;
	geoidSimple[76][199] = (byte)6;
	geoidSimple[76][200] = (byte)6;
	geoidSimple[76][201] = (byte)4;
	geoidSimple[76][202] = (byte)3;
	geoidSimple[76][203] = (byte)2;
	geoidSimple[76][204] = (byte)1;
	geoidSimple[76][205] = (byte)0;
	geoidSimple[76][206] = (byte)0;
	geoidSimple[76][207] = (byte)-1;
	geoidSimple[76][208] = (byte)-2;
	geoidSimple[76][209] = (byte)-3;
	geoidSimple[76][210] = (byte)-3;
	geoidSimple[76][211] = (byte)-4;
	geoidSimple[76][212] = (byte)-5;
	geoidSimple[76][213] = (byte)-6;
	geoidSimple[76][214] = (byte)-7;
	geoidSimple[76][215] = (byte)-8;
	geoidSimple[76][216] = (byte)-9;
	geoidSimple[76][217] = (byte)-11;
	geoidSimple[76][218] = (byte)-12;
	geoidSimple[76][219] = (byte)-13;
	geoidSimple[76][220] = (byte)-15;
	geoidSimple[76][221] = (byte)-17;
	geoidSimple[76][222] = (byte)-19;
	geoidSimple[76][223] = (byte)-21;
	geoidSimple[76][224] = (byte)-23;
	geoidSimple[76][225] = (byte)-25;
	geoidSimple[76][226] = (byte)-27;
	geoidSimple[76][227] = (byte)-29;
	geoidSimple[76][228] = (byte)-31;
	geoidSimple[76][229] = (byte)-33;
	geoidSimple[76][230] = (byte)-35;
	geoidSimple[76][231] = (byte)-36;
	geoidSimple[76][232] = (byte)-37;
	geoidSimple[76][233] = (byte)-39;
	geoidSimple[76][234] = (byte)-40;
	geoidSimple[76][235] = (byte)-41;
	geoidSimple[76][236] = (byte)-42;
	geoidSimple[76][237] = (byte)-43;
	geoidSimple[76][238] = (byte)-43;
	geoidSimple[76][239] = (byte)-43;
	geoidSimple[76][240] = (byte)-43;
	geoidSimple[76][241] = (byte)-43;
	geoidSimple[76][242] = (byte)-43;
	geoidSimple[76][243] = (byte)-42;
	geoidSimple[76][244] = (byte)-41;
	geoidSimple[76][245] = (byte)-39;
	geoidSimple[76][246] = (byte)-38;
	geoidSimple[76][247] = (byte)-36;
	geoidSimple[76][248] = (byte)-34;
	geoidSimple[76][249] = (byte)-32;
	geoidSimple[76][250] = (byte)-31;
	geoidSimple[76][251] = (byte)-29;
	geoidSimple[76][252] = (byte)-26;
	geoidSimple[76][253] = (byte)-24;
	geoidSimple[76][254] = (byte)-22;
	geoidSimple[76][255] = (byte)-19;
	geoidSimple[76][256] = (byte)-17;
	geoidSimple[76][257] = (byte)-15;
	geoidSimple[76][258] = (byte)-13;
	geoidSimple[76][259] = (byte)-11;
	geoidSimple[76][260] = (byte)-9;
	geoidSimple[76][261] = (byte)-8;
	geoidSimple[76][262] = (byte)-7;
	geoidSimple[76][263] = (byte)-6;
	geoidSimple[76][264] = (byte)-5;
	geoidSimple[76][265] = (byte)-5;
	geoidSimple[76][266] = (byte)-7;
	geoidSimple[76][267] = (byte)-6;
	geoidSimple[76][268] = (byte)-4;
	geoidSimple[76][269] = (byte)-2;
	geoidSimple[76][270] = (byte)0;
	geoidSimple[76][271] = (byte)1;
	geoidSimple[76][272] = (byte)3;
	geoidSimple[76][273] = (byte)5;
	geoidSimple[76][274] = (byte)6;
	geoidSimple[76][275] = (byte)5;
	geoidSimple[76][276] = (byte)3;
	geoidSimple[76][277] = (byte)2;
	geoidSimple[76][278] = (byte)0;
	geoidSimple[76][279] = (byte)0;
	geoidSimple[76][280] = (byte)-3;
	geoidSimple[76][281] = (byte)-5;
	geoidSimple[76][282] = (byte)-8;
	geoidSimple[76][283] = (byte)-11;
	geoidSimple[76][284] = (byte)-14;
	geoidSimple[76][285] = (byte)-19;
	geoidSimple[76][286] = (byte)-22;
	geoidSimple[76][287] = (byte)-24;
	geoidSimple[76][288] = (byte)-27;
	geoidSimple[76][289] = (byte)-30;
	geoidSimple[76][290] = (byte)-34;
	geoidSimple[76][291] = (byte)-36;
	geoidSimple[76][292] = (byte)-37;
	geoidSimple[76][293] = (byte)-37;
	geoidSimple[76][294] = (byte)-37;
	geoidSimple[76][295] = (byte)-36;
	geoidSimple[76][296] = (byte)-36;
	geoidSimple[76][297] = (byte)-39;
	geoidSimple[76][298] = (byte)-40;
	geoidSimple[76][299] = (byte)-40;
	geoidSimple[76][300] = (byte)-48;
	geoidSimple[76][301] = (byte)-48;
	geoidSimple[76][302] = (byte)-47;
	geoidSimple[76][303] = (byte)-47;
	geoidSimple[76][304] = (byte)-47;
	geoidSimple[76][305] = (byte)-46;
	geoidSimple[76][306] = (byte)-45;
	geoidSimple[76][307] = (byte)-43;
	geoidSimple[76][308] = (byte)-42;
	geoidSimple[76][309] = (byte)-41;
	geoidSimple[76][310] = (byte)-40;
	geoidSimple[76][311] = (byte)-37;
	geoidSimple[76][312] = (byte)-34;
	geoidSimple[76][313] = (byte)-31;
	geoidSimple[76][314] = (byte)-28;
	geoidSimple[76][315] = (byte)-25;
	geoidSimple[76][316] = (byte)-24;
	geoidSimple[76][317] = (byte)-22;
	geoidSimple[76][318] = (byte)-21;
	geoidSimple[76][319] = (byte)-19;
	geoidSimple[76][320] = (byte)-17;
	geoidSimple[76][321] = (byte)-15;
	geoidSimple[76][322] = (byte)-13;
	geoidSimple[76][323] = (byte)-11;
	geoidSimple[76][324] = (byte)-9;
	geoidSimple[76][325] = (byte)-6;
	geoidSimple[76][326] = (byte)-4;
	geoidSimple[76][327] = (byte)-1;
	geoidSimple[76][328] = (byte)0;
	geoidSimple[76][329] = (byte)3;
	geoidSimple[76][330] = (byte)5;
	geoidSimple[76][331] = (byte)8;
	geoidSimple[76][332] = (byte)10;
	geoidSimple[76][333] = (byte)13;
	geoidSimple[76][334] = (byte)14;
	geoidSimple[76][335] = (byte)16;
	geoidSimple[76][336] = (byte)17;
	geoidSimple[76][337] = (byte)17;
	geoidSimple[76][338] = (byte)18;
	geoidSimple[76][339] = (byte)20;
	geoidSimple[76][340] = (byte)21;
	geoidSimple[76][341] = (byte)23;
	geoidSimple[76][342] = (byte)26;
	geoidSimple[76][343] = (byte)29;
	geoidSimple[76][344] = (byte)30;
	geoidSimple[76][345] = (byte)31;
	geoidSimple[76][346] = (byte)31;
	geoidSimple[76][347] = (byte)31;
	geoidSimple[76][348] = (byte)30;
	geoidSimple[76][349] = (byte)31;
	geoidSimple[76][350] = (byte)31;
	geoidSimple[76][351] = (byte)31;
	geoidSimple[76][352] = (byte)29;
	geoidSimple[76][353] = (byte)28;
	geoidSimple[76][354] = (byte)28;
	geoidSimple[76][355] = (byte)28;
	geoidSimple[76][356] = (byte)27;
	geoidSimple[76][357] = (byte)26;
	geoidSimple[76][358] = (byte)25;
	geoidSimple[76][359] = (byte)25;
	}
		/** Row 77*/
	private static void init77() {
	geoidSimple[77][0] = (byte)24;
	geoidSimple[77][1] = (byte)23;
	geoidSimple[77][2] = (byte)22;
	geoidSimple[77][3] = (byte)21;
	geoidSimple[77][4] = (byte)20;
	geoidSimple[77][5] = (byte)19;
	geoidSimple[77][6] = (byte)19;
	geoidSimple[77][7] = (byte)20;
	geoidSimple[77][8] = (byte)21;
	geoidSimple[77][9] = (byte)20;
	geoidSimple[77][10] = (byte)19;
	geoidSimple[77][11] = (byte)18;
	geoidSimple[77][12] = (byte)16;
	geoidSimple[77][13] = (byte)14;
	geoidSimple[77][14] = (byte)13;
	geoidSimple[77][15] = (byte)12;
	geoidSimple[77][16] = (byte)11;
	geoidSimple[77][17] = (byte)10;
	geoidSimple[77][18] = (byte)8;
	geoidSimple[77][19] = (byte)7;
	geoidSimple[77][20] = (byte)5;
	geoidSimple[77][21] = (byte)6;
	geoidSimple[77][22] = (byte)6;
	geoidSimple[77][23] = (byte)6;
	geoidSimple[77][24] = (byte)6;
	geoidSimple[77][25] = (byte)3;
	geoidSimple[77][26] = (byte)2;
	geoidSimple[77][27] = (byte)1;
	geoidSimple[77][28] = (byte)1;
	geoidSimple[77][29] = (byte)0;
	geoidSimple[77][30] = (byte)0;
	geoidSimple[77][31] = (byte)-1;
	geoidSimple[77][32] = (byte)-2;
	geoidSimple[77][33] = (byte)-3;
	geoidSimple[77][34] = (byte)-4;
	geoidSimple[77][35] = (byte)-5;
	geoidSimple[77][36] = (byte)-2;
	geoidSimple[77][37] = (byte)-2;
	geoidSimple[77][38] = (byte)-1;
	geoidSimple[77][39] = (byte)-2;
	geoidSimple[77][40] = (byte)-7;
	geoidSimple[77][41] = (byte)-8;
	geoidSimple[77][42] = (byte)-9;
	geoidSimple[77][43] = (byte)-11;
	geoidSimple[77][44] = (byte)-13;
	geoidSimple[77][45] = (byte)-16;
	geoidSimple[77][46] = (byte)-18;
	geoidSimple[77][47] = (byte)-20;
	geoidSimple[77][48] = (byte)-22;
	geoidSimple[77][49] = (byte)-25;
	geoidSimple[77][50] = (byte)-27;
	geoidSimple[77][51] = (byte)-30;
	geoidSimple[77][52] = (byte)-33;
	geoidSimple[77][53] = (byte)-36;
	geoidSimple[77][54] = (byte)-38;
	geoidSimple[77][55] = (byte)-41;
	geoidSimple[77][56] = (byte)-43;
	geoidSimple[77][57] = (byte)-45;
	geoidSimple[77][58] = (byte)-50;
	geoidSimple[77][59] = (byte)-54;
	geoidSimple[77][60] = (byte)-57;
	geoidSimple[77][61] = (byte)-60;
	geoidSimple[77][62] = (byte)-63;
	geoidSimple[77][63] = (byte)-66;
	geoidSimple[77][64] = (byte)-69;
	geoidSimple[77][65] = (byte)-73;
	geoidSimple[77][66] = (byte)-76;
	geoidSimple[77][67] = (byte)-79;
	geoidSimple[77][68] = (byte)-82;
	geoidSimple[77][69] = (byte)-84;
	geoidSimple[77][70] = (byte)-87;
	geoidSimple[77][71] = (byte)-87;
	geoidSimple[77][72] = (byte)-88;
	geoidSimple[77][73] = (byte)-90;
	geoidSimple[77][74] = (byte)-90;
	geoidSimple[77][75] = (byte)-90;
	geoidSimple[77][76] = (byte)-87;
	geoidSimple[77][77] = (byte)-87;
	geoidSimple[77][78] = (byte)-88;
	geoidSimple[77][79] = (byte)-90;
	geoidSimple[77][80] = (byte)-93;
	geoidSimple[77][81] = (byte)-94;
	geoidSimple[77][82] = (byte)-92;
	geoidSimple[77][83] = (byte)-89;
	geoidSimple[77][84] = (byte)-86;
	geoidSimple[77][85] = (byte)-85;
	geoidSimple[77][86] = (byte)-81;
	geoidSimple[77][87] = (byte)-76;
	geoidSimple[77][88] = (byte)-71;
	geoidSimple[77][89] = (byte)-66;
	geoidSimple[77][90] = (byte)-63;
	geoidSimple[77][91] = (byte)-63;
	geoidSimple[77][92] = (byte)-61;
	geoidSimple[77][93] = (byte)-60;
	geoidSimple[77][94] = (byte)-52;
	geoidSimple[77][95] = (byte)-48;
	geoidSimple[77][96] = (byte)-44;
	geoidSimple[77][97] = (byte)-38;
	geoidSimple[77][98] = (byte)-35;
	geoidSimple[77][99] = (byte)-32;
	geoidSimple[77][100] = (byte)-30;
	geoidSimple[77][101] = (byte)-27;
	geoidSimple[77][102] = (byte)-23;
	geoidSimple[77][103] = (byte)-20;
	geoidSimple[77][104] = (byte)-17;
	geoidSimple[77][105] = (byte)-13;
	geoidSimple[77][106] = (byte)-9;
	geoidSimple[77][107] = (byte)-4;
	geoidSimple[77][108] = (byte)1;
	geoidSimple[77][109] = (byte)3;
	geoidSimple[77][110] = (byte)5;
	geoidSimple[77][111] = (byte)8;
	geoidSimple[77][112] = (byte)13;
	geoidSimple[77][113] = (byte)17;
	geoidSimple[77][114] = (byte)22;
	geoidSimple[77][115] = (byte)26;
	geoidSimple[77][116] = (byte)30;
	geoidSimple[77][117] = (byte)34;
	geoidSimple[77][118] = (byte)38;
	geoidSimple[77][119] = (byte)41;
	geoidSimple[77][120] = (byte)44;
	geoidSimple[77][121] = (byte)49;
	geoidSimple[77][122] = (byte)51;
	geoidSimple[77][123] = (byte)53;
	geoidSimple[77][124] = (byte)54;
	geoidSimple[77][125] = (byte)48;
	geoidSimple[77][126] = (byte)47;
	geoidSimple[77][127] = (byte)52;
	geoidSimple[77][128] = (byte)53;
	geoidSimple[77][129] = (byte)53;
	geoidSimple[77][130] = (byte)52;
	geoidSimple[77][131] = (byte)52;
	geoidSimple[77][132] = (byte)52;
	geoidSimple[77][133] = (byte)52;
	geoidSimple[77][134] = (byte)53;
	geoidSimple[77][135] = (byte)54;
	geoidSimple[77][136] = (byte)54;
	geoidSimple[77][137] = (byte)55;
	geoidSimple[77][138] = (byte)55;
	geoidSimple[77][139] = (byte)53;
	geoidSimple[77][140] = (byte)52;
	geoidSimple[77][141] = (byte)51;
	geoidSimple[77][142] = (byte)52;
	geoidSimple[77][143] = (byte)51;
	geoidSimple[77][144] = (byte)45;
	geoidSimple[77][145] = (byte)36;
	geoidSimple[77][146] = (byte)37;
	geoidSimple[77][147] = (byte)45;
	geoidSimple[77][148] = (byte)46;
	geoidSimple[77][149] = (byte)45;
	geoidSimple[77][150] = (byte)43;
	geoidSimple[77][151] = (byte)41;
	geoidSimple[77][152] = (byte)40;
	geoidSimple[77][153] = (byte)39;
	geoidSimple[77][154] = (byte)37;
	geoidSimple[77][155] = (byte)35;
	geoidSimple[77][156] = (byte)35;
	geoidSimple[77][157] = (byte)33;
	geoidSimple[77][158] = (byte)32;
	geoidSimple[77][159] = (byte)31;
	geoidSimple[77][160] = (byte)29;
	geoidSimple[77][161] = (byte)29;
	geoidSimple[77][162] = (byte)28;
	geoidSimple[77][163] = (byte)26;
	geoidSimple[77][164] = (byte)26;
	geoidSimple[77][165] = (byte)25;
	geoidSimple[77][166] = (byte)24;
	geoidSimple[77][167] = (byte)21;
	geoidSimple[77][168] = (byte)22;
	geoidSimple[77][169] = (byte)21;
	geoidSimple[77][170] = (byte)20;
	geoidSimple[77][171] = (byte)18;
	geoidSimple[77][172] = (byte)17;
	geoidSimple[77][173] = (byte)16;
	geoidSimple[77][174] = (byte)15;
	geoidSimple[77][175] = (byte)14;
	geoidSimple[77][176] = (byte)13;
	geoidSimple[77][177] = (byte)13;
	geoidSimple[77][178] = (byte)12;
	geoidSimple[77][179] = (byte)10;
	geoidSimple[77][LAT_GRID_SIZE] = (byte)10;
	geoidSimple[77][181] = (byte)10;
	geoidSimple[77][182] = (byte)11;
	geoidSimple[77][183] = (byte)10;
	geoidSimple[77][184] = (byte)10;
	geoidSimple[77][185] = (byte)10;
	geoidSimple[77][186] = (byte)10;
	geoidSimple[77][187] = (byte)10;
	geoidSimple[77][188] = (byte)10;
	geoidSimple[77][189] = (byte)10;
	geoidSimple[77][190] = (byte)10;
	geoidSimple[77][191] = (byte)11;
	geoidSimple[77][192] = (byte)11;
	geoidSimple[77][193] = (byte)11;
	geoidSimple[77][194] = (byte)11;
	geoidSimple[77][195] = (byte)11;
	geoidSimple[77][196] = (byte)10;
	geoidSimple[77][197] = (byte)9;
	geoidSimple[77][198] = (byte)8;
	geoidSimple[77][199] = (byte)7;
	geoidSimple[77][200] = (byte)7;
	geoidSimple[77][201] = (byte)6;
	geoidSimple[77][202] = (byte)4;
	geoidSimple[77][203] = (byte)4;
	geoidSimple[77][204] = (byte)3;
	geoidSimple[77][205] = (byte)2;
	geoidSimple[77][206] = (byte)1;
	geoidSimple[77][207] = (byte)0;
	geoidSimple[77][208] = (byte)-1;
	geoidSimple[77][209] = (byte)-1;
	geoidSimple[77][210] = (byte)-2;
	geoidSimple[77][211] = (byte)-3;
	geoidSimple[77][212] = (byte)-4;
	geoidSimple[77][213] = (byte)-5;
	geoidSimple[77][214] = (byte)-6;
	geoidSimple[77][215] = (byte)-7;
	geoidSimple[77][216] = (byte)-8;
	geoidSimple[77][217] = (byte)-9;
	geoidSimple[77][218] = (byte)-11;
	geoidSimple[77][219] = (byte)-13;
	geoidSimple[77][220] = (byte)-14;
	geoidSimple[77][221] = (byte)-16;
	geoidSimple[77][222] = (byte)-18;
	geoidSimple[77][223] = (byte)-20;
	geoidSimple[77][224] = (byte)-22;
	geoidSimple[77][225] = (byte)-24;
	geoidSimple[77][226] = (byte)-26;
	geoidSimple[77][227] = (byte)-28;
	geoidSimple[77][228] = (byte)-30;
	geoidSimple[77][229] = (byte)-32;
	geoidSimple[77][230] = (byte)-33;
	geoidSimple[77][231] = (byte)-35;
	geoidSimple[77][232] = (byte)-36;
	geoidSimple[77][233] = (byte)-38;
	geoidSimple[77][234] = (byte)-39;
	geoidSimple[77][235] = (byte)-40;
	geoidSimple[77][236] = (byte)-41;
	geoidSimple[77][237] = (byte)-42;
	geoidSimple[77][238] = (byte)-42;
	geoidSimple[77][239] = (byte)-42;
	geoidSimple[77][240] = (byte)-42;
	geoidSimple[77][241] = (byte)-42;
	geoidSimple[77][242] = (byte)-42;
	geoidSimple[77][243] = (byte)-41;
	geoidSimple[77][244] = (byte)-40;
	geoidSimple[77][245] = (byte)-39;
	geoidSimple[77][246] = (byte)-37;
	geoidSimple[77][247] = (byte)-36;
	geoidSimple[77][248] = (byte)-34;
	geoidSimple[77][249] = (byte)-32;
	geoidSimple[77][250] = (byte)-30;
	geoidSimple[77][251] = (byte)-28;
	geoidSimple[77][252] = (byte)-26;
	geoidSimple[77][253] = (byte)-24;
	geoidSimple[77][254] = (byte)-21;
	geoidSimple[77][255] = (byte)-19;
	geoidSimple[77][256] = (byte)-17;
	geoidSimple[77][257] = (byte)-15;
	geoidSimple[77][258] = (byte)-13;
	geoidSimple[77][259] = (byte)-11;
	geoidSimple[77][260] = (byte)-9;
	geoidSimple[77][261] = (byte)-8;
	geoidSimple[77][262] = (byte)-7;
	geoidSimple[77][263] = (byte)-6;
	geoidSimple[77][264] = (byte)-5;
	geoidSimple[77][265] = (byte)-4;
	geoidSimple[77][266] = (byte)-3;
	geoidSimple[77][267] = (byte)-2;
	geoidSimple[77][268] = (byte)-3;
	geoidSimple[77][269] = (byte)-4;
	geoidSimple[77][270] = (byte)-3;
	geoidSimple[77][271] = (byte)-1;
	geoidSimple[77][272] = (byte)0;
	geoidSimple[77][273] = (byte)4;
	geoidSimple[77][274] = (byte)7;
	geoidSimple[77][275] = (byte)7;
	geoidSimple[77][276] = (byte)5;
	geoidSimple[77][277] = (byte)4;
	geoidSimple[77][278] = (byte)2;
	geoidSimple[77][279] = (byte)0;
	geoidSimple[77][280] = (byte)-1;
	geoidSimple[77][281] = (byte)-3;
	geoidSimple[77][282] = (byte)-6;
	geoidSimple[77][283] = (byte)-8;
	geoidSimple[77][284] = (byte)-13;
	geoidSimple[77][285] = (byte)-19;
	geoidSimple[77][286] = (byte)-22;
	geoidSimple[77][287] = (byte)-22;
	geoidSimple[77][288] = (byte)-22;
	geoidSimple[77][289] = (byte)-24;
	geoidSimple[77][290] = (byte)-28;
	geoidSimple[77][291] = (byte)-32;
	geoidSimple[77][292] = (byte)-36;
	geoidSimple[77][293] = (byte)-38;
	geoidSimple[77][294] = (byte)-39;
	geoidSimple[77][295] = (byte)-36;
	geoidSimple[77][296] = (byte)-35;
	geoidSimple[77][297] = (byte)-40;
	geoidSimple[77][298] = (byte)-39;
	geoidSimple[77][299] = (byte)-44;
	geoidSimple[77][300] = (byte)-49;
	geoidSimple[77][301] = (byte)-46;
	geoidSimple[77][302] = (byte)-46;
	geoidSimple[77][303] = (byte)-46;
	geoidSimple[77][304] = (byte)-45;
	geoidSimple[77][305] = (byte)-45;
	geoidSimple[77][306] = (byte)-44;
	geoidSimple[77][307] = (byte)-44;
	geoidSimple[77][308] = (byte)-43;
	geoidSimple[77][309] = (byte)-42;
	geoidSimple[77][310] = (byte)-41;
	geoidSimple[77][311] = (byte)-39;
	geoidSimple[77][312] = (byte)-36;
	geoidSimple[77][313] = (byte)-33;
	geoidSimple[77][314] = (byte)-30;
	geoidSimple[77][315] = (byte)-26;
	geoidSimple[77][316] = (byte)-24;
	geoidSimple[77][317] = (byte)-23;
	geoidSimple[77][318] = (byte)-21;
	geoidSimple[77][319] = (byte)-19;
	geoidSimple[77][320] = (byte)-17;
	geoidSimple[77][321] = (byte)-16;
	geoidSimple[77][322] = (byte)-14;
	geoidSimple[77][323] = (byte)-12;
	geoidSimple[77][324] = (byte)-10;
	geoidSimple[77][325] = (byte)-7;
	geoidSimple[77][326] = (byte)-5;
	geoidSimple[77][327] = (byte)-2;
	geoidSimple[77][328] = (byte)0;
	geoidSimple[77][329] = (byte)2;
	geoidSimple[77][330] = (byte)4;
	geoidSimple[77][331] = (byte)7;
	geoidSimple[77][332] = (byte)9;
	geoidSimple[77][333] = (byte)11;
	geoidSimple[77][334] = (byte)13;
	geoidSimple[77][335] = (byte)14;
	geoidSimple[77][336] = (byte)15;
	geoidSimple[77][337] = (byte)16;
	geoidSimple[77][338] = (byte)17;
	geoidSimple[77][339] = (byte)19;
	geoidSimple[77][340] = (byte)20;
	geoidSimple[77][341] = (byte)21;
	geoidSimple[77][342] = (byte)24;
	geoidSimple[77][343] = (byte)28;
	geoidSimple[77][344] = (byte)29;
	geoidSimple[77][345] = (byte)30;
	geoidSimple[77][346] = (byte)30;
	geoidSimple[77][347] = (byte)30;
	geoidSimple[77][348] = (byte)31;
	geoidSimple[77][349] = (byte)32;
	geoidSimple[77][350] = (byte)32;
	geoidSimple[77][351] = (byte)31;
	geoidSimple[77][352] = (byte)30;
	geoidSimple[77][353] = (byte)28;
	geoidSimple[77][354] = (byte)28;
	geoidSimple[77][355] = (byte)28;
	geoidSimple[77][356] = (byte)27;
	geoidSimple[77][357] = (byte)26;
	geoidSimple[77][358] = (byte)25;
	geoidSimple[77][359] = (byte)25;
	}
		/** Row 78*/
	private static void init78() {
	geoidSimple[78][0] = (byte)23;
	geoidSimple[78][1] = (byte)22;
	geoidSimple[78][2] = (byte)22;
	geoidSimple[78][3] = (byte)21;
	geoidSimple[78][4] = (byte)19;
	geoidSimple[78][5] = (byte)20;
	geoidSimple[78][6] = (byte)21;
	geoidSimple[78][7] = (byte)21;
	geoidSimple[78][8] = (byte)21;
	geoidSimple[78][9] = (byte)21;
	geoidSimple[78][10] = (byte)20;
	geoidSimple[78][11] = (byte)18;
	geoidSimple[78][12] = (byte)17;
	geoidSimple[78][13] = (byte)15;
	geoidSimple[78][14] = (byte)13;
	geoidSimple[78][15] = (byte)12;
	geoidSimple[78][16] = (byte)11;
	geoidSimple[78][17] = (byte)9;
	geoidSimple[78][18] = (byte)7;
	geoidSimple[78][19] = (byte)6;
	geoidSimple[78][20] = (byte)4;
	geoidSimple[78][21] = (byte)4;
	geoidSimple[78][22] = (byte)3;
	geoidSimple[78][23] = (byte)3;
	geoidSimple[78][24] = (byte)2;
	geoidSimple[78][25] = (byte)1;
	geoidSimple[78][26] = (byte)0;
	geoidSimple[78][27] = (byte)-1;
	geoidSimple[78][28] = (byte)-1;
	geoidSimple[78][29] = (byte)0;
	geoidSimple[78][30] = (byte)-1;
	geoidSimple[78][31] = (byte)-2;
	geoidSimple[78][32] = (byte)-3;
	geoidSimple[78][33] = (byte)-4;
	geoidSimple[78][34] = (byte)-4;
	geoidSimple[78][35] = (byte)-5;
	geoidSimple[78][36] = (byte)-3;
	geoidSimple[78][37] = (byte)-3;
	geoidSimple[78][38] = (byte)-3;
	geoidSimple[78][39] = (byte)-5;
	geoidSimple[78][40] = (byte)-8;
	geoidSimple[78][41] = (byte)-9;
	geoidSimple[78][42] = (byte)-10;
	geoidSimple[78][43] = (byte)-13;
	geoidSimple[78][44] = (byte)-16;
	geoidSimple[78][45] = (byte)-18;
	geoidSimple[78][46] = (byte)-20;
	geoidSimple[78][47] = (byte)-23;
	geoidSimple[78][48] = (byte)-25;
	geoidSimple[78][49] = (byte)-27;
	geoidSimple[78][50] = (byte)-29;
	geoidSimple[78][51] = (byte)-32;
	geoidSimple[78][52] = (byte)-37;
	geoidSimple[78][53] = (byte)-41;
	geoidSimple[78][54] = (byte)-44;
	geoidSimple[78][55] = (byte)-44;
	geoidSimple[78][56] = (byte)-46;
	geoidSimple[78][57] = (byte)-48;
	geoidSimple[78][58] = (byte)-52;
	geoidSimple[78][59] = (byte)-55;
	geoidSimple[78][60] = (byte)-58;
	geoidSimple[78][61] = (byte)-61;
	geoidSimple[78][62] = (byte)-64;
	geoidSimple[78][63] = (byte)-68;
	geoidSimple[78][64] = (byte)-71;
	geoidSimple[78][65] = (byte)-74;
	geoidSimple[78][66] = (byte)-77;
	geoidSimple[78][67] = (byte)-80;
	geoidSimple[78][68] = (byte)-83;
	geoidSimple[78][69] = (byte)-86;
	geoidSimple[78][70] = (byte)-89;
	geoidSimple[78][71] = (byte)-89;
	geoidSimple[78][72] = (byte)-91;
	geoidSimple[78][73] = (byte)-93;
	geoidSimple[78][74] = (byte)-93;
	geoidSimple[78][75] = (byte)-92;
	geoidSimple[78][76] = (byte)-90;
	geoidSimple[78][77] = (byte)-91;
	geoidSimple[78][78] = (byte)-91;
	geoidSimple[78][79] = (byte)-91;
	geoidSimple[78][80] = (byte)-95;
	geoidSimple[78][81] = (byte)-96;
	geoidSimple[78][82] = (byte)-94;
	geoidSimple[78][83] = (byte)-91;
	geoidSimple[78][84] = (byte)-88;
	geoidSimple[78][85] = (byte)-85;
	geoidSimple[78][86] = (byte)-81;
	geoidSimple[78][87] = (byte)-76;
	geoidSimple[78][88] = (byte)-71;
	geoidSimple[78][89] = (byte)-66;
	geoidSimple[78][90] = (byte)-63;
	geoidSimple[78][91] = (byte)-63;
	geoidSimple[78][92] = (byte)-61;
	geoidSimple[78][93] = (byte)-58;
	geoidSimple[78][94] = (byte)-51;
	geoidSimple[78][95] = (byte)-47;
	geoidSimple[78][96] = (byte)-43;
	geoidSimple[78][97] = (byte)-37;
	geoidSimple[78][98] = (byte)-34;
	geoidSimple[78][99] = (byte)-30;
	geoidSimple[78][100] = (byte)-28;
	geoidSimple[78][101] = (byte)-25;
	geoidSimple[78][102] = (byte)-21;
	geoidSimple[78][103] = (byte)-17;
	geoidSimple[78][104] = (byte)-15;
	geoidSimple[78][105] = (byte)-11;
	geoidSimple[78][106] = (byte)-7;
	geoidSimple[78][107] = (byte)-2;
	geoidSimple[78][108] = (byte)2;
	geoidSimple[78][109] = (byte)5;
	geoidSimple[78][110] = (byte)7;
	geoidSimple[78][111] = (byte)11;
	geoidSimple[78][112] = (byte)15;
	geoidSimple[78][113] = (byte)20;
	geoidSimple[78][114] = (byte)25;
	geoidSimple[78][115] = (byte)29;
	geoidSimple[78][116] = (byte)34;
	geoidSimple[78][117] = (byte)38;
	geoidSimple[78][118] = (byte)41;
	geoidSimple[78][119] = (byte)47;
	geoidSimple[78][120] = (byte)50;
	geoidSimple[78][121] = (byte)52;
	geoidSimple[78][122] = (byte)55;
	geoidSimple[78][123] = (byte)58;
	geoidSimple[78][124] = (byte)61;
	geoidSimple[78][125] = (byte)60;
	geoidSimple[78][126] = (byte)48;
	geoidSimple[78][127] = (byte)53;
	geoidSimple[78][128] = (byte)56;
	geoidSimple[78][129] = (byte)55;
	geoidSimple[78][130] = (byte)55;
	geoidSimple[78][131] = (byte)54;
	geoidSimple[78][132] = (byte)54;
	geoidSimple[78][133] = (byte)54;
	geoidSimple[78][134] = (byte)55;
	geoidSimple[78][135] = (byte)56;
	geoidSimple[78][136] = (byte)56;
	geoidSimple[78][137] = (byte)56;
	geoidSimple[78][138] = (byte)55;
	geoidSimple[78][139] = (byte)52;
	geoidSimple[78][140] = (byte)50;
	geoidSimple[78][141] = (byte)42;
	geoidSimple[78][142] = (byte)40;
	geoidSimple[78][143] = (byte)41;
	geoidSimple[78][144] = (byte)39;
	geoidSimple[78][145] = (byte)43;
	geoidSimple[78][146] = (byte)46;
	geoidSimple[78][147] = (byte)47;
	geoidSimple[78][148] = (byte)46;
	geoidSimple[78][149] = (byte)45;
	geoidSimple[78][150] = (byte)43;
	geoidSimple[78][151] = (byte)42;
	geoidSimple[78][152] = (byte)40;
	geoidSimple[78][153] = (byte)39;
	geoidSimple[78][154] = (byte)39;
	geoidSimple[78][155] = (byte)37;
	geoidSimple[78][156] = (byte)37;
	geoidSimple[78][157] = (byte)34;
	geoidSimple[78][158] = (byte)33;
	geoidSimple[78][159] = (byte)32;
	geoidSimple[78][160] = (byte)30;
	geoidSimple[78][161] = (byte)31;
	geoidSimple[78][162] = (byte)31;
	geoidSimple[78][163] = (byte)28;
	geoidSimple[78][164] = (byte)28;
	geoidSimple[78][165] = (byte)28;
	geoidSimple[78][166] = (byte)27;
	geoidSimple[78][167] = (byte)26;
	geoidSimple[78][168] = (byte)23;
	geoidSimple[78][169] = (byte)22;
	geoidSimple[78][170] = (byte)22;
	geoidSimple[78][171] = (byte)20;
	geoidSimple[78][172] = (byte)19;
	geoidSimple[78][173] = (byte)18;
	geoidSimple[78][174] = (byte)17;
	geoidSimple[78][175] = (byte)15;
	geoidSimple[78][176] = (byte)14;
	geoidSimple[78][177] = (byte)14;
	geoidSimple[78][178] = (byte)13;
	geoidSimple[78][179] = (byte)12;
	geoidSimple[78][LAT_GRID_SIZE] = (byte)11;
	geoidSimple[78][181] = (byte)10;
	geoidSimple[78][182] = (byte)11;
	geoidSimple[78][183] = (byte)11;
	geoidSimple[78][184] = (byte)11;
	geoidSimple[78][185] = (byte)10;
	geoidSimple[78][186] = (byte)10;
	geoidSimple[78][187] = (byte)10;
	geoidSimple[78][188] = (byte)10;
	geoidSimple[78][189] = (byte)10;
	geoidSimple[78][190] = (byte)11;
	geoidSimple[78][191] = (byte)11;
	geoidSimple[78][192] = (byte)12;
	geoidSimple[78][193] = (byte)12;
	geoidSimple[78][194] = (byte)13;
	geoidSimple[78][195] = (byte)11;
	geoidSimple[78][196] = (byte)11;
	geoidSimple[78][197] = (byte)10;
	geoidSimple[78][198] = (byte)9;
	geoidSimple[78][199] = (byte)9;
	geoidSimple[78][200] = (byte)8;
	geoidSimple[78][201] = (byte)7;
	geoidSimple[78][202] = (byte)6;
	geoidSimple[78][203] = (byte)5;
	geoidSimple[78][204] = (byte)4;
	geoidSimple[78][205] = (byte)3;
	geoidSimple[78][206] = (byte)2;
	geoidSimple[78][207] = (byte)1;
	geoidSimple[78][208] = (byte)0;
	geoidSimple[78][209] = (byte)0;
	geoidSimple[78][210] = (byte)-1;
	geoidSimple[78][211] = (byte)-2;
	geoidSimple[78][212] = (byte)-3;
	geoidSimple[78][213] = (byte)-4;
	geoidSimple[78][214] = (byte)-5;
	geoidSimple[78][215] = (byte)-6;
	geoidSimple[78][216] = (byte)-7;
	geoidSimple[78][217] = (byte)-8;
	geoidSimple[78][218] = (byte)-10;
	geoidSimple[78][219] = (byte)-12;
	geoidSimple[78][220] = (byte)-13;
	geoidSimple[78][221] = (byte)-15;
	geoidSimple[78][222] = (byte)-17;
	geoidSimple[78][223] = (byte)-19;
	geoidSimple[78][224] = (byte)-21;
	geoidSimple[78][225] = (byte)-23;
	geoidSimple[78][226] = (byte)-25;
	geoidSimple[78][227] = (byte)-27;
	geoidSimple[78][228] = (byte)-28;
	geoidSimple[78][229] = (byte)-30;
	geoidSimple[78][230] = (byte)-32;
	geoidSimple[78][231] = (byte)-33;
	geoidSimple[78][232] = (byte)-35;
	geoidSimple[78][233] = (byte)-36;
	geoidSimple[78][234] = (byte)-38;
	geoidSimple[78][235] = (byte)-39;
	geoidSimple[78][236] = (byte)-40;
	geoidSimple[78][237] = (byte)-40;
	geoidSimple[78][238] = (byte)-41;
	geoidSimple[78][239] = (byte)-41;
	geoidSimple[78][240] = (byte)-41;
	geoidSimple[78][241] = (byte)-41;
	geoidSimple[78][242] = (byte)-41;
	geoidSimple[78][243] = (byte)-40;
	geoidSimple[78][244] = (byte)-39;
	geoidSimple[78][245] = (byte)-38;
	geoidSimple[78][246] = (byte)-36;
	geoidSimple[78][247] = (byte)-35;
	geoidSimple[78][248] = (byte)-33;
	geoidSimple[78][249] = (byte)-31;
	geoidSimple[78][250] = (byte)-29;
	geoidSimple[78][251] = (byte)-27;
	geoidSimple[78][252] = (byte)-25;
	geoidSimple[78][253] = (byte)-23;
	geoidSimple[78][254] = (byte)-21;
	geoidSimple[78][255] = (byte)-19;
	geoidSimple[78][256] = (byte)-17;
	geoidSimple[78][257] = (byte)-15;
	geoidSimple[78][258] = (byte)-13;
	geoidSimple[78][259] = (byte)-11;
	geoidSimple[78][260] = (byte)-10;
	geoidSimple[78][261] = (byte)-9;
	geoidSimple[78][262] = (byte)-8;
	geoidSimple[78][263] = (byte)-6;
	geoidSimple[78][264] = (byte)-5;
	geoidSimple[78][265] = (byte)-4;
	geoidSimple[78][266] = (byte)-2;
	geoidSimple[78][267] = (byte)-1;
	geoidSimple[78][268] = (byte)0;
	geoidSimple[78][269] = (byte)0;
	geoidSimple[78][270] = (byte)0;
	geoidSimple[78][271] = (byte)-1;
	geoidSimple[78][272] = (byte)-1;
	geoidSimple[78][273] = (byte)1;
	geoidSimple[78][274] = (byte)6;
	geoidSimple[78][275] = (byte)8;
	geoidSimple[78][276] = (byte)7;
	geoidSimple[78][277] = (byte)4;
	geoidSimple[78][278] = (byte)2;
	geoidSimple[78][279] = (byte)1;
	geoidSimple[78][280] = (byte)0;
	geoidSimple[78][281] = (byte)-2;
	geoidSimple[78][282] = (byte)-4;
	geoidSimple[78][283] = (byte)-7;
	geoidSimple[78][284] = (byte)-11;
	geoidSimple[78][285] = (byte)-14;
	geoidSimple[78][286] = (byte)-13;
	geoidSimple[78][287] = (byte)-14;
	geoidSimple[78][288] = (byte)-16;
	geoidSimple[78][289] = (byte)-20;
	geoidSimple[78][290] = (byte)-20;
	geoidSimple[78][291] = (byte)-21;
	geoidSimple[78][292] = (byte)-25;
	geoidSimple[78][293] = (byte)-27;
	geoidSimple[78][294] = (byte)-31;
	geoidSimple[78][295] = (byte)-31;
	geoidSimple[78][296] = (byte)-32;
	geoidSimple[78][297] = (byte)-36;
	geoidSimple[78][298] = (byte)-39;
	geoidSimple[78][299] = (byte)-44;
	geoidSimple[78][300] = (byte)-48;
	geoidSimple[78][301] = (byte)-46;
	geoidSimple[78][302] = (byte)-46;
	geoidSimple[78][303] = (byte)-47;
	geoidSimple[78][304] = (byte)-46;
	geoidSimple[78][305] = (byte)-45;
	geoidSimple[78][306] = (byte)-45;
	geoidSimple[78][307] = (byte)-44;
	geoidSimple[78][308] = (byte)-44;
	geoidSimple[78][309] = (byte)-43;
	geoidSimple[78][310] = (byte)-42;
	geoidSimple[78][311] = (byte)-40;
	geoidSimple[78][312] = (byte)-38;
	geoidSimple[78][313] = (byte)-35;
	geoidSimple[78][314] = (byte)-31;
	geoidSimple[78][315] = (byte)-28;
	geoidSimple[78][316] = (byte)-25;
	geoidSimple[78][317] = (byte)-23;
	geoidSimple[78][318] = (byte)-21;
	geoidSimple[78][319] = (byte)-19;
	geoidSimple[78][320] = (byte)-17;
	geoidSimple[78][321] = (byte)-15;
	geoidSimple[78][322] = (byte)-13;
	geoidSimple[78][323] = (byte)-11;
	geoidSimple[78][324] = (byte)-9;
	geoidSimple[78][325] = (byte)-7;
	geoidSimple[78][326] = (byte)-5;
	geoidSimple[78][327] = (byte)-3;
	geoidSimple[78][328] = (byte)0;
	geoidSimple[78][329] = (byte)1;
	geoidSimple[78][330] = (byte)3;
	geoidSimple[78][331] = (byte)5;
	geoidSimple[78][332] = (byte)8;
	geoidSimple[78][333] = (byte)10;
	geoidSimple[78][334] = (byte)12;
	geoidSimple[78][335] = (byte)13;
	geoidSimple[78][336] = (byte)14;
	geoidSimple[78][337] = (byte)15;
	geoidSimple[78][338] = (byte)16;
	geoidSimple[78][339] = (byte)17;
	geoidSimple[78][340] = (byte)18;
	geoidSimple[78][341] = (byte)20;
	geoidSimple[78][342] = (byte)23;
	geoidSimple[78][343] = (byte)27;
	geoidSimple[78][344] = (byte)28;
	geoidSimple[78][345] = (byte)29;
	geoidSimple[78][346] = (byte)30;
	geoidSimple[78][347] = (byte)32;
	geoidSimple[78][348] = (byte)34;
	geoidSimple[78][349] = (byte)33;
	geoidSimple[78][350] = (byte)32;
	geoidSimple[78][351] = (byte)31;
	geoidSimple[78][352] = (byte)29;
	geoidSimple[78][353] = (byte)28;
	geoidSimple[78][354] = (byte)29;
	geoidSimple[78][355] = (byte)28;
	geoidSimple[78][356] = (byte)27;
	geoidSimple[78][357] = (byte)26;
	geoidSimple[78][358] = (byte)25;
	geoidSimple[78][359] = (byte)24;
	}
		/** Row 79*/
	private static void init79() {
	geoidSimple[79][0] = (byte)22;
	geoidSimple[79][1] = (byte)22;
	geoidSimple[79][2] = (byte)23;
	geoidSimple[79][3] = (byte)22;
	geoidSimple[79][4] = (byte)22;
	geoidSimple[79][5] = (byte)22;
	geoidSimple[79][6] = (byte)22;
	geoidSimple[79][7] = (byte)23;
	geoidSimple[79][8] = (byte)22;
	geoidSimple[79][9] = (byte)22;
	geoidSimple[79][10] = (byte)20;
	geoidSimple[79][11] = (byte)18;
	geoidSimple[79][12] = (byte)17;
	geoidSimple[79][13] = (byte)16;
	geoidSimple[79][14] = (byte)14;
	geoidSimple[79][15] = (byte)12;
	geoidSimple[79][16] = (byte)10;
	geoidSimple[79][17] = (byte)8;
	geoidSimple[79][18] = (byte)6;
	geoidSimple[79][19] = (byte)4;
	geoidSimple[79][20] = (byte)2;
	geoidSimple[79][21] = (byte)1;
	geoidSimple[79][22] = (byte)1;
	geoidSimple[79][23] = (byte)1;
	geoidSimple[79][24] = (byte)0;
	geoidSimple[79][25] = (byte)0;
	geoidSimple[79][26] = (byte)-1;
	geoidSimple[79][27] = (byte)-3;
	geoidSimple[79][28] = (byte)-4;
	geoidSimple[79][29] = (byte)-3;
	geoidSimple[79][30] = (byte)-3;
	geoidSimple[79][31] = (byte)-4;
	geoidSimple[79][32] = (byte)-5;
	geoidSimple[79][33] = (byte)-5;
	geoidSimple[79][34] = (byte)-3;
	geoidSimple[79][35] = (byte)-5;
	geoidSimple[79][36] = (byte)-4;
	geoidSimple[79][37] = (byte)-5;
	geoidSimple[79][38] = (byte)-7;
	geoidSimple[79][39] = (byte)-8;
	geoidSimple[79][40] = (byte)-10;
	geoidSimple[79][41] = (byte)-11;
	geoidSimple[79][42] = (byte)-12;
	geoidSimple[79][43] = (byte)-15;
	geoidSimple[79][44] = (byte)-19;
	geoidSimple[79][45] = (byte)-20;
	geoidSimple[79][46] = (byte)-23;
	geoidSimple[79][47] = (byte)-24;
	geoidSimple[79][48] = (byte)-26;
	geoidSimple[79][49] = (byte)-28;
	geoidSimple[79][50] = (byte)-31;
	geoidSimple[79][51] = (byte)-36;
	geoidSimple[79][52] = (byte)-43;
	geoidSimple[79][53] = (byte)-46;
	geoidSimple[79][54] = (byte)-47;
	geoidSimple[79][55] = (byte)-49;
	geoidSimple[79][56] = (byte)-48;
	geoidSimple[79][57] = (byte)-50;
	geoidSimple[79][58] = (byte)-51;
	geoidSimple[79][59] = (byte)-55;
	geoidSimple[79][60] = (byte)-59;
	geoidSimple[79][61] = (byte)-63;
	geoidSimple[79][62] = (byte)-66;
	geoidSimple[79][63] = (byte)-69;
	geoidSimple[79][64] = (byte)-72;
	geoidSimple[79][65] = (byte)-76;
	geoidSimple[79][66] = (byte)-79;
	geoidSimple[79][67] = (byte)-82;
	geoidSimple[79][68] = (byte)-85;
	geoidSimple[79][69] = (byte)-88;
	geoidSimple[79][70] = (byte)-90;
	geoidSimple[79][71] = (byte)-91;
	geoidSimple[79][72] = (byte)-92;
	geoidSimple[79][73] = (byte)-94;
	geoidSimple[79][74] = (byte)-95;
	geoidSimple[79][75] = (byte)-94;
	geoidSimple[79][76] = (byte)-93;
	geoidSimple[79][77] = (byte)-94;
	geoidSimple[79][78] = (byte)-94;
	geoidSimple[79][79] = (byte)-93;
	geoidSimple[79][80] = (byte)-96;
	geoidSimple[79][81] = (byte)-98;
	geoidSimple[79][82] = (byte)-95;
	geoidSimple[79][83] = (byte)-92;
	geoidSimple[79][84] = (byte)-89;
	geoidSimple[79][85] = (byte)-86;
	geoidSimple[79][86] = (byte)-82;
	geoidSimple[79][87] = (byte)-77;
	geoidSimple[79][88] = (byte)-71;
	geoidSimple[79][89] = (byte)-66;
	geoidSimple[79][90] = (byte)-63;
	geoidSimple[79][91] = (byte)-62;
	geoidSimple[79][92] = (byte)-61;
	geoidSimple[79][93] = (byte)-60;
	geoidSimple[79][94] = (byte)-50;
	geoidSimple[79][95] = (byte)-46;
	geoidSimple[79][96] = (byte)-41;
	geoidSimple[79][97] = (byte)-35;
	geoidSimple[79][98] = (byte)-31;
	geoidSimple[79][99] = (byte)-28;
	geoidSimple[79][100] = (byte)-25;
	geoidSimple[79][101] = (byte)-23;
	geoidSimple[79][102] = (byte)-19;
	geoidSimple[79][103] = (byte)-15;
	geoidSimple[79][104] = (byte)-12;
	geoidSimple[79][105] = (byte)-9;
	geoidSimple[79][106] = (byte)-4;
	geoidSimple[79][107] = (byte)-1;
	geoidSimple[79][108] = (byte)3;
	geoidSimple[79][109] = (byte)7;
	geoidSimple[79][110] = (byte)10;
	geoidSimple[79][111] = (byte)14;
	geoidSimple[79][112] = (byte)18;
	geoidSimple[79][113] = (byte)23;
	geoidSimple[79][114] = (byte)28;
	geoidSimple[79][115] = (byte)32;
	geoidSimple[79][116] = (byte)37;
	geoidSimple[79][117] = (byte)40;
	geoidSimple[79][118] = (byte)44;
	geoidSimple[79][119] = (byte)50;
	geoidSimple[79][120] = (byte)53;
	geoidSimple[79][121] = (byte)54;
	geoidSimple[79][122] = (byte)56;
	geoidSimple[79][123] = (byte)61;
	geoidSimple[79][124] = (byte)64;
	geoidSimple[79][125] = (byte)66;
	geoidSimple[79][126] = (byte)52;
	geoidSimple[79][127] = (byte)54;
	geoidSimple[79][128] = (byte)58;
	geoidSimple[79][129] = (byte)58;
	geoidSimple[79][130] = (byte)57;
	geoidSimple[79][131] = (byte)57;
	geoidSimple[79][132] = (byte)56;
	geoidSimple[79][133] = (byte)56;
	geoidSimple[79][134] = (byte)57;
	geoidSimple[79][135] = (byte)58;
	geoidSimple[79][136] = (byte)58;
	geoidSimple[79][137] = (byte)58;
	geoidSimple[79][138] = (byte)56;
	geoidSimple[79][139] = (byte)53;
	geoidSimple[79][140] = (byte)52;
	geoidSimple[79][141] = (byte)46;
	geoidSimple[79][142] = (byte)46;
	geoidSimple[79][143] = (byte)47;
	geoidSimple[79][144] = (byte)51;
	geoidSimple[79][145] = (byte)52;
	geoidSimple[79][146] = (byte)51;
	geoidSimple[79][147] = (byte)49;
	geoidSimple[79][148] = (byte)47;
	geoidSimple[79][149] = (byte)45;
	geoidSimple[79][150] = (byte)44;
	geoidSimple[79][151] = (byte)43;
	geoidSimple[79][152] = (byte)42;
	geoidSimple[79][153] = (byte)41;
	geoidSimple[79][154] = (byte)40;
	geoidSimple[79][155] = (byte)39;
	geoidSimple[79][156] = (byte)38;
	geoidSimple[79][157] = (byte)37;
	geoidSimple[79][158] = (byte)35;
	geoidSimple[79][159] = (byte)34;
	geoidSimple[79][160] = (byte)34;
	geoidSimple[79][161] = (byte)32;
	geoidSimple[79][162] = (byte)31;
	geoidSimple[79][163] = (byte)30;
	geoidSimple[79][164] = (byte)28;
	geoidSimple[79][165] = (byte)27;
	geoidSimple[79][166] = (byte)27;
	geoidSimple[79][167] = (byte)25;
	geoidSimple[79][168] = (byte)24;
	geoidSimple[79][169] = (byte)24;
	geoidSimple[79][170] = (byte)23;
	geoidSimple[79][171] = (byte)22;
	geoidSimple[79][172] = (byte)21;
	geoidSimple[79][173] = (byte)20;
	geoidSimple[79][174] = (byte)18;
	geoidSimple[79][175] = (byte)17;
	geoidSimple[79][176] = (byte)16;
	geoidSimple[79][177] = (byte)15;
	geoidSimple[79][178] = (byte)14;
	geoidSimple[79][179] = (byte)13;
	geoidSimple[79][LAT_GRID_SIZE] = (byte)12;
	geoidSimple[79][181] = (byte)11;
	geoidSimple[79][182] = (byte)11;
	geoidSimple[79][183] = (byte)10;
	geoidSimple[79][184] = (byte)10;
	geoidSimple[79][185] = (byte)10;
	geoidSimple[79][186] = (byte)10;
	geoidSimple[79][187] = (byte)10;
	geoidSimple[79][188] = (byte)10;
	geoidSimple[79][189] = (byte)11;
	geoidSimple[79][190] = (byte)12;
	geoidSimple[79][191] = (byte)11;
	geoidSimple[79][192] = (byte)12;
	geoidSimple[79][193] = (byte)12;
	geoidSimple[79][194] = (byte)13;
	geoidSimple[79][195] = (byte)13;
	geoidSimple[79][196] = (byte)13;
	geoidSimple[79][197] = (byte)11;
	geoidSimple[79][198] = (byte)10;
	geoidSimple[79][199] = (byte)10;
	geoidSimple[79][200] = (byte)9;
	geoidSimple[79][201] = (byte)8;
	geoidSimple[79][202] = (byte)7;
	geoidSimple[79][203] = (byte)6;
	geoidSimple[79][204] = (byte)5;
	geoidSimple[79][205] = (byte)5;
	geoidSimple[79][206] = (byte)4;
	geoidSimple[79][207] = (byte)3;
	geoidSimple[79][208] = (byte)1;
	geoidSimple[79][209] = (byte)0;
	geoidSimple[79][210] = (byte)0;
	geoidSimple[79][211] = (byte)-1;
	geoidSimple[79][212] = (byte)-1;
	geoidSimple[79][213] = (byte)-2;
	geoidSimple[79][214] = (byte)-3;
	geoidSimple[79][215] = (byte)-5;
	geoidSimple[79][216] = (byte)-6;
	geoidSimple[79][217] = (byte)-7;
	geoidSimple[79][218] = (byte)-9;
	geoidSimple[79][219] = (byte)-10;
	geoidSimple[79][220] = (byte)-12;
	geoidSimple[79][221] = (byte)-14;
	geoidSimple[79][222] = (byte)-16;
	geoidSimple[79][223] = (byte)-18;
	geoidSimple[79][224] = (byte)-20;
	geoidSimple[79][225] = (byte)-22;
	geoidSimple[79][226] = (byte)-24;
	geoidSimple[79][227] = (byte)-25;
	geoidSimple[79][228] = (byte)-27;
	geoidSimple[79][229] = (byte)-29;
	geoidSimple[79][230] = (byte)-30;
	geoidSimple[79][231] = (byte)-32;
	geoidSimple[79][232] = (byte)-33;
	geoidSimple[79][233] = (byte)-35;
	geoidSimple[79][234] = (byte)-36;
	geoidSimple[79][235] = (byte)-37;
	geoidSimple[79][236] = (byte)-38;
	geoidSimple[79][237] = (byte)-39;
	geoidSimple[79][238] = (byte)-39;
	geoidSimple[79][239] = (byte)-40;
	geoidSimple[79][240] = (byte)-40;
	geoidSimple[79][241] = (byte)-40;
	geoidSimple[79][242] = (byte)-39;
	geoidSimple[79][243] = (byte)-39;
	geoidSimple[79][244] = (byte)-38;
	geoidSimple[79][245] = (byte)-37;
	geoidSimple[79][246] = (byte)-35;
	geoidSimple[79][247] = (byte)-34;
	geoidSimple[79][248] = (byte)-32;
	geoidSimple[79][249] = (byte)-30;
	geoidSimple[79][250] = (byte)-28;
	geoidSimple[79][251] = (byte)-27;
	geoidSimple[79][252] = (byte)-25;
	geoidSimple[79][253] = (byte)-23;
	geoidSimple[79][254] = (byte)-21;
	geoidSimple[79][255] = (byte)-19;
	geoidSimple[79][256] = (byte)-17;
	geoidSimple[79][257] = (byte)-15;
	geoidSimple[79][258] = (byte)-13;
	geoidSimple[79][259] = (byte)-12;
	geoidSimple[79][260] = (byte)-10;
	geoidSimple[79][261] = (byte)-9;
	geoidSimple[79][262] = (byte)-8;
	geoidSimple[79][263] = (byte)-6;
	geoidSimple[79][264] = (byte)-5;
	geoidSimple[79][265] = (byte)-4;
	geoidSimple[79][266] = (byte)-2;
	geoidSimple[79][267] = (byte)-1;
	geoidSimple[79][268] = (byte)0;
	geoidSimple[79][269] = (byte)1;
	geoidSimple[79][270] = (byte)1;
	geoidSimple[79][271] = (byte)3;
	geoidSimple[79][272] = (byte)2;
	geoidSimple[79][273] = (byte)2;
	geoidSimple[79][274] = (byte)8;
	geoidSimple[79][275] = (byte)9;
	geoidSimple[79][276] = (byte)9;
	geoidSimple[79][277] = (byte)5;
	geoidSimple[79][278] = (byte)3;
	geoidSimple[79][279] = (byte)0;
	geoidSimple[79][280] = (byte)-1;
	geoidSimple[79][281] = (byte)-2;
	geoidSimple[79][282] = (byte)-4;
	geoidSimple[79][283] = (byte)-6;
	geoidSimple[79][284] = (byte)-6;
	geoidSimple[79][285] = (byte)-6;
	geoidSimple[79][286] = (byte)1;
	geoidSimple[79][287] = (byte)-5;
	geoidSimple[79][288] = (byte)-14;
	geoidSimple[79][289] = (byte)-14;
	geoidSimple[79][290] = (byte)-14;
	geoidSimple[79][291] = (byte)-16;
	geoidSimple[79][292] = (byte)-19;
	geoidSimple[79][293] = (byte)-20;
	geoidSimple[79][294] = (byte)-27;
	geoidSimple[79][295] = (byte)-29;
	geoidSimple[79][296] = (byte)-31;
	geoidSimple[79][297] = (byte)-37;
	geoidSimple[79][298] = (byte)-41;
	geoidSimple[79][299] = (byte)-43;
	geoidSimple[79][300] = (byte)-44;
	geoidSimple[79][301] = (byte)-42;
	geoidSimple[79][302] = (byte)-45;
	geoidSimple[79][303] = (byte)-46;
	geoidSimple[79][304] = (byte)-46;
	geoidSimple[79][305] = (byte)-45;
	geoidSimple[79][306] = (byte)-45;
	geoidSimple[79][307] = (byte)-45;
	geoidSimple[79][308] = (byte)-44;
	geoidSimple[79][309] = (byte)-43;
	geoidSimple[79][310] = (byte)-42;
	geoidSimple[79][311] = (byte)-40;
	geoidSimple[79][312] = (byte)-38;
	geoidSimple[79][313] = (byte)-36;
	geoidSimple[79][314] = (byte)-33;
	geoidSimple[79][315] = (byte)-30;
	geoidSimple[79][316] = (byte)-27;
	geoidSimple[79][317] = (byte)-24;
	geoidSimple[79][318] = (byte)-21;
	geoidSimple[79][319] = (byte)-19;
	geoidSimple[79][320] = (byte)-17;
	geoidSimple[79][321] = (byte)-15;
	geoidSimple[79][322] = (byte)-13;
	geoidSimple[79][323] = (byte)-11;
	geoidSimple[79][324] = (byte)-9;
	geoidSimple[79][325] = (byte)-7;
	geoidSimple[79][326] = (byte)-5;
	geoidSimple[79][327] = (byte)-3;
	geoidSimple[79][328] = (byte)0;
	geoidSimple[79][329] = (byte)1;
	geoidSimple[79][330] = (byte)3;
	geoidSimple[79][331] = (byte)5;
	geoidSimple[79][332] = (byte)7;
	geoidSimple[79][333] = (byte)9;
	geoidSimple[79][334] = (byte)10;
	geoidSimple[79][335] = (byte)12;
	geoidSimple[79][336] = (byte)14;
	geoidSimple[79][337] = (byte)15;
	geoidSimple[79][338] = (byte)15;
	geoidSimple[79][339] = (byte)16;
	geoidSimple[79][340] = (byte)17;
	geoidSimple[79][341] = (byte)19;
	geoidSimple[79][342] = (byte)22;
	geoidSimple[79][343] = (byte)27;
	geoidSimple[79][344] = (byte)28;
	geoidSimple[79][345] = (byte)29;
	geoidSimple[79][346] = (byte)31;
	geoidSimple[79][347] = (byte)32;
	geoidSimple[79][348] = (byte)34;
	geoidSimple[79][349] = (byte)32;
	geoidSimple[79][350] = (byte)31;
	geoidSimple[79][351] = (byte)31;
	geoidSimple[79][352] = (byte)30;
	geoidSimple[79][353] = (byte)28;
	geoidSimple[79][354] = (byte)28;
	geoidSimple[79][355] = (byte)28;
	geoidSimple[79][356] = (byte)26;
	geoidSimple[79][357] = (byte)25;
	geoidSimple[79][358] = (byte)24;
	geoidSimple[79][359] = (byte)23;
	}
		/** Row 80*/
	private static void init80() {
	geoidSimple[80][0] = (byte)22;
	geoidSimple[80][1] = (byte)23;
	geoidSimple[80][2] = (byte)24;
	geoidSimple[80][3] = (byte)24;
	geoidSimple[80][4] = (byte)23;
	geoidSimple[80][5] = (byte)23;
	geoidSimple[80][6] = (byte)26;
	geoidSimple[80][7] = (byte)24;
	geoidSimple[80][8] = (byte)23;
	geoidSimple[80][9] = (byte)23;
	geoidSimple[80][10] = (byte)20;
	geoidSimple[80][11] = (byte)18;
	geoidSimple[80][12] = (byte)17;
	geoidSimple[80][13] = (byte)15;
	geoidSimple[80][14] = (byte)13;
	geoidSimple[80][15] = (byte)11;
	geoidSimple[80][16] = (byte)8;
	geoidSimple[80][17] = (byte)6;
	geoidSimple[80][18] = (byte)4;
	geoidSimple[80][19] = (byte)1;
	geoidSimple[80][20] = (byte)0;
	geoidSimple[80][21] = (byte)0;
	geoidSimple[80][22] = (byte)0;
	geoidSimple[80][23] = (byte)0;
	geoidSimple[80][24] = (byte)-1;
	geoidSimple[80][25] = (byte)-2;
	geoidSimple[80][26] = (byte)-3;
	geoidSimple[80][27] = (byte)-4;
	geoidSimple[80][28] = (byte)-5;
	geoidSimple[80][29] = (byte)-6;
	geoidSimple[80][30] = (byte)-6;
	geoidSimple[80][31] = (byte)-7;
	geoidSimple[80][32] = (byte)-8;
	geoidSimple[80][33] = (byte)-7;
	geoidSimple[80][34] = (byte)-4;
	geoidSimple[80][35] = (byte)-4;
	geoidSimple[80][36] = (byte)-5;
	geoidSimple[80][37] = (byte)-7;
	geoidSimple[80][38] = (byte)-7;
	geoidSimple[80][39] = (byte)-7;
	geoidSimple[80][40] = (byte)-11;
	geoidSimple[80][41] = (byte)-12;
	geoidSimple[80][42] = (byte)-13;
	geoidSimple[80][43] = (byte)-15;
	geoidSimple[80][44] = (byte)-18;
	geoidSimple[80][45] = (byte)-21;
	geoidSimple[80][46] = (byte)-24;
	geoidSimple[80][47] = (byte)-25;
	geoidSimple[80][48] = (byte)-26;
	geoidSimple[80][49] = (byte)-30;
	geoidSimple[80][50] = (byte)-34;
	geoidSimple[80][51] = (byte)-40;
	geoidSimple[80][52] = (byte)-47;
	geoidSimple[80][53] = (byte)-49;
	geoidSimple[80][54] = (byte)-51;
	geoidSimple[80][55] = (byte)-51;
	geoidSimple[80][56] = (byte)-50;
	geoidSimple[80][57] = (byte)-50;
	geoidSimple[80][58] = (byte)-52;
	geoidSimple[80][59] = (byte)-55;
	geoidSimple[80][60] = (byte)-59;
	geoidSimple[80][61] = (byte)-63;
	geoidSimple[80][62] = (byte)-67;
	geoidSimple[80][63] = (byte)-71;
	geoidSimple[80][64] = (byte)-74;
	geoidSimple[80][65] = (byte)-77;
	geoidSimple[80][66] = (byte)-80;
	geoidSimple[80][67] = (byte)-84;
	geoidSimple[80][68] = (byte)-87;
	geoidSimple[80][69] = (byte)-89;
	geoidSimple[80][70] = (byte)-92;
	geoidSimple[80][71] = (byte)-93;
	geoidSimple[80][72] = (byte)-94;
	geoidSimple[80][73] = (byte)-95;
	geoidSimple[80][74] = (byte)-97;
	geoidSimple[80][75] = (byte)-97;
	geoidSimple[80][76] = (byte)-95;
	geoidSimple[80][77] = (byte)-95;
	geoidSimple[80][78] = (byte)-95;
	geoidSimple[80][79] = (byte)-95;
	geoidSimple[80][80] = (byte)-96;
	geoidSimple[80][81] = (byte)-97;
	geoidSimple[80][82] = (byte)-96;
	geoidSimple[80][83] = (byte)-93;
	geoidSimple[80][84] = (byte)-90;
	geoidSimple[80][85] = (byte)-86;
	geoidSimple[80][86] = (byte)-82;
	geoidSimple[80][87] = (byte)-76;
	geoidSimple[80][88] = (byte)-71;
	geoidSimple[80][89] = (byte)-65;
	geoidSimple[80][90] = (byte)-62;
	geoidSimple[80][91] = (byte)-61;
	geoidSimple[80][92] = (byte)-60;
	geoidSimple[80][93] = (byte)-60;
	geoidSimple[80][94] = (byte)-49;
	geoidSimple[80][95] = (byte)-44;
	geoidSimple[80][96] = (byte)-38;
	geoidSimple[80][97] = (byte)-33;
	geoidSimple[80][98] = (byte)-29;
	geoidSimple[80][99] = (byte)-25;
	geoidSimple[80][100] = (byte)-23;
	geoidSimple[80][101] = (byte)-20;
	geoidSimple[80][102] = (byte)-17;
	geoidSimple[80][103] = (byte)-13;
	geoidSimple[80][104] = (byte)-9;
	geoidSimple[80][105] = (byte)-6;
	geoidSimple[80][106] = (byte)-2;
	geoidSimple[80][107] = (byte)1;
	geoidSimple[80][108] = (byte)5;
	geoidSimple[80][109] = (byte)9;
	geoidSimple[80][110] = (byte)13;
	geoidSimple[80][111] = (byte)17;
	geoidSimple[80][112] = (byte)22;
	geoidSimple[80][113] = (byte)26;
	geoidSimple[80][114] = (byte)30;
	geoidSimple[80][115] = (byte)35;
	geoidSimple[80][116] = (byte)38;
	geoidSimple[80][117] = (byte)42;
	geoidSimple[80][118] = (byte)48;
	geoidSimple[80][119] = (byte)50;
	geoidSimple[80][120] = (byte)53;
	geoidSimple[80][121] = (byte)54;
	geoidSimple[80][122] = (byte)57;
	geoidSimple[80][123] = (byte)62;
	geoidSimple[80][124] = (byte)64;
	geoidSimple[80][125] = (byte)65;
	geoidSimple[80][126] = (byte)58;
	geoidSimple[80][127] = (byte)54;
	geoidSimple[80][128] = (byte)60;
	geoidSimple[80][129] = (byte)60;
	geoidSimple[80][130] = (byte)59;
	geoidSimple[80][131] = (byte)59;
	geoidSimple[80][132] = (byte)59;
	geoidSimple[80][133] = (byte)59;
	geoidSimple[80][134] = (byte)60;
	geoidSimple[80][135] = (byte)60;
	geoidSimple[80][136] = (byte)60;
	geoidSimple[80][137] = (byte)60;
	geoidSimple[80][138] = (byte)57;
	geoidSimple[80][139] = (byte)59;
	geoidSimple[80][140] = (byte)60;
	geoidSimple[80][141] = (byte)58;
	geoidSimple[80][142] = (byte)55;
	geoidSimple[80][143] = (byte)53;
	geoidSimple[80][144] = (byte)54;
	geoidSimple[80][145] = (byte)55;
	geoidSimple[80][146] = (byte)53;
	geoidSimple[80][147] = (byte)51;
	geoidSimple[80][148] = (byte)51;
	geoidSimple[80][149] = (byte)47;
	geoidSimple[80][150] = (byte)46;
	geoidSimple[80][151] = (byte)44;
	geoidSimple[80][152] = (byte)44;
	geoidSimple[80][153] = (byte)42;
	geoidSimple[80][154] = (byte)41;
	geoidSimple[80][155] = (byte)41;
	geoidSimple[80][156] = (byte)40;
	geoidSimple[80][157] = (byte)39;
	geoidSimple[80][158] = (byte)37;
	geoidSimple[80][159] = (byte)35;
	geoidSimple[80][160] = (byte)35;
	geoidSimple[80][161] = (byte)34;
	geoidSimple[80][162] = (byte)33;
	geoidSimple[80][163] = (byte)30;
	geoidSimple[80][164] = (byte)29;
	geoidSimple[80][165] = (byte)28;
	geoidSimple[80][166] = (byte)28;
	geoidSimple[80][167] = (byte)27;
	geoidSimple[80][168] = (byte)25;
	geoidSimple[80][169] = (byte)26;
	geoidSimple[80][170] = (byte)25;
	geoidSimple[80][171] = (byte)22;
	geoidSimple[80][172] = (byte)21;
	geoidSimple[80][173] = (byte)20;
	geoidSimple[80][174] = (byte)19;
	geoidSimple[80][175] = (byte)18;
	geoidSimple[80][176] = (byte)17;
	geoidSimple[80][177] = (byte)16;
	geoidSimple[80][178] = (byte)15;
	geoidSimple[80][179] = (byte)13;
	geoidSimple[80][LAT_GRID_SIZE] = (byte)12;
	geoidSimple[80][181] = (byte)12;
	geoidSimple[80][182] = (byte)12;
	geoidSimple[80][183] = (byte)11;
	geoidSimple[80][184] = (byte)10;
	geoidSimple[80][185] = (byte)10;
	geoidSimple[80][186] = (byte)10;
	geoidSimple[80][187] = (byte)10;
	geoidSimple[80][188] = (byte)11;
	geoidSimple[80][189] = (byte)11;
	geoidSimple[80][190] = (byte)11;
	geoidSimple[80][191] = (byte)12;
	geoidSimple[80][192] = (byte)12;
	geoidSimple[80][193] = (byte)12;
	geoidSimple[80][194] = (byte)13;
	geoidSimple[80][195] = (byte)14;
	geoidSimple[80][196] = (byte)13;
	geoidSimple[80][197] = (byte)13;
	geoidSimple[80][198] = (byte)12;
	geoidSimple[80][199] = (byte)11;
	geoidSimple[80][200] = (byte)10;
	geoidSimple[80][201] = (byte)10;
	geoidSimple[80][202] = (byte)9;
	geoidSimple[80][203] = (byte)8;
	geoidSimple[80][204] = (byte)7;
	geoidSimple[80][205] = (byte)6;
	geoidSimple[80][206] = (byte)5;
	geoidSimple[80][207] = (byte)4;
	geoidSimple[80][208] = (byte)3;
	geoidSimple[80][209] = (byte)2;
	geoidSimple[80][210] = (byte)1;
	geoidSimple[80][211] = (byte)0;
	geoidSimple[80][212] = (byte)0;
	geoidSimple[80][213] = (byte)-1;
	geoidSimple[80][214] = (byte)-2;
	geoidSimple[80][215] = (byte)-3;
	geoidSimple[80][216] = (byte)-5;
	geoidSimple[80][217] = (byte)-6;
	geoidSimple[80][218] = (byte)-8;
	geoidSimple[80][219] = (byte)-9;
	geoidSimple[80][220] = (byte)-11;
	geoidSimple[80][221] = (byte)-13;
	geoidSimple[80][222] = (byte)-15;
	geoidSimple[80][223] = (byte)-17;
	geoidSimple[80][224] = (byte)-19;
	geoidSimple[80][225] = (byte)-21;
	geoidSimple[80][226] = (byte)-22;
	geoidSimple[80][227] = (byte)-24;
	geoidSimple[80][228] = (byte)-26;
	geoidSimple[80][229] = (byte)-27;
	geoidSimple[80][230] = (byte)-29;
	geoidSimple[80][231] = (byte)-30;
	geoidSimple[80][232] = (byte)-32;
	geoidSimple[80][233] = (byte)-33;
	geoidSimple[80][234] = (byte)-34;
	geoidSimple[80][235] = (byte)-35;
	geoidSimple[80][236] = (byte)-36;
	geoidSimple[80][237] = (byte)-37;
	geoidSimple[80][238] = (byte)-38;
	geoidSimple[80][239] = (byte)-38;
	geoidSimple[80][240] = (byte)-38;
	geoidSimple[80][241] = (byte)-38;
	geoidSimple[80][242] = (byte)-38;
	geoidSimple[80][243] = (byte)-37;
	geoidSimple[80][244] = (byte)-36;
	geoidSimple[80][245] = (byte)-35;
	geoidSimple[80][246] = (byte)-34;
	geoidSimple[80][247] = (byte)-33;
	geoidSimple[80][248] = (byte)-31;
	geoidSimple[80][249] = (byte)-30;
	geoidSimple[80][250] = (byte)-28;
	geoidSimple[80][251] = (byte)-26;
	geoidSimple[80][252] = (byte)-24;
	geoidSimple[80][253] = (byte)-22;
	geoidSimple[80][254] = (byte)-21;
	geoidSimple[80][255] = (byte)-19;
	geoidSimple[80][256] = (byte)-17;
	geoidSimple[80][257] = (byte)-15;
	geoidSimple[80][258] = (byte)-14;
	geoidSimple[80][259] = (byte)-12;
	geoidSimple[80][260] = (byte)-11;
	geoidSimple[80][261] = (byte)-9;
	geoidSimple[80][262] = (byte)-8;
	geoidSimple[80][263] = (byte)-6;
	geoidSimple[80][264] = (byte)-5;
	geoidSimple[80][265] = (byte)-4;
	geoidSimple[80][266] = (byte)-2;
	geoidSimple[80][267] = (byte)-1;
	geoidSimple[80][268] = (byte)0;
	geoidSimple[80][269] = (byte)0;
	geoidSimple[80][270] = (byte)1;
	geoidSimple[80][271] = (byte)3;
	geoidSimple[80][272] = (byte)4;
	geoidSimple[80][273] = (byte)4;
	geoidSimple[80][274] = (byte)7;
	geoidSimple[80][275] = (byte)9;
	geoidSimple[80][276] = (byte)13;
	geoidSimple[80][277] = (byte)10;
	geoidSimple[80][278] = (byte)6;
	geoidSimple[80][279] = (byte)5;
	geoidSimple[80][280] = (byte)6;
	geoidSimple[80][281] = (byte)5;
	geoidSimple[80][282] = (byte)0;
	geoidSimple[80][283] = (byte)-1;
	geoidSimple[80][284] = (byte)-1;
	geoidSimple[80][285] = (byte)-4;
	geoidSimple[80][286] = (byte)-2;
	geoidSimple[80][287] = (byte)-6;
	geoidSimple[80][288] = (byte)-13;
	geoidSimple[80][289] = (byte)-10;
	geoidSimple[80][290] = (byte)-10;
	geoidSimple[80][291] = (byte)-13;
	geoidSimple[80][292] = (byte)-14;
	geoidSimple[80][293] = (byte)-17;
	geoidSimple[80][294] = (byte)-22;
	geoidSimple[80][295] = (byte)-28;
	geoidSimple[80][296] = (byte)-34;
	geoidSimple[80][297] = (byte)-40;
	geoidSimple[80][298] = (byte)-41;
	geoidSimple[80][299] = (byte)-39;
	geoidSimple[80][300] = (byte)-38;
	geoidSimple[80][301] = (byte)-40;
	geoidSimple[80][302] = (byte)-41;
	geoidSimple[80][303] = (byte)-43;
	geoidSimple[80][304] = (byte)-44;
	geoidSimple[80][305] = (byte)-44;
	geoidSimple[80][306] = (byte)-44;
	geoidSimple[80][307] = (byte)-44;
	geoidSimple[80][308] = (byte)-44;
	geoidSimple[80][309] = (byte)-43;
	geoidSimple[80][310] = (byte)-42;
	geoidSimple[80][311] = (byte)-40;
	geoidSimple[80][312] = (byte)-38;
	geoidSimple[80][313] = (byte)-36;
	geoidSimple[80][314] = (byte)-34;
	geoidSimple[80][315] = (byte)-31;
	geoidSimple[80][316] = (byte)-27;
	geoidSimple[80][317] = (byte)-24;
	geoidSimple[80][318] = (byte)-20;
	geoidSimple[80][319] = (byte)-17;
	geoidSimple[80][320] = (byte)-15;
	geoidSimple[80][321] = (byte)-13;
	geoidSimple[80][322] = (byte)-11;
	geoidSimple[80][323] = (byte)-9;
	geoidSimple[80][324] = (byte)-7;
	geoidSimple[80][325] = (byte)-6;
	geoidSimple[80][326] = (byte)-4;
	geoidSimple[80][327] = (byte)-2;
	geoidSimple[80][328] = (byte)0;
	geoidSimple[80][329] = (byte)1;
	geoidSimple[80][330] = (byte)3;
	geoidSimple[80][331] = (byte)5;
	geoidSimple[80][332] = (byte)7;
	geoidSimple[80][333] = (byte)9;
	geoidSimple[80][334] = (byte)10;
	geoidSimple[80][335] = (byte)12;
	geoidSimple[80][336] = (byte)13;
	geoidSimple[80][337] = (byte)15;
	geoidSimple[80][338] = (byte)16;
	geoidSimple[80][339] = (byte)17;
	geoidSimple[80][340] = (byte)18;
	geoidSimple[80][341] = (byte)19;
	geoidSimple[80][342] = (byte)22;
	geoidSimple[80][343] = (byte)26;
	geoidSimple[80][344] = (byte)28;
	geoidSimple[80][345] = (byte)31;
	geoidSimple[80][346] = (byte)32;
	geoidSimple[80][347] = (byte)31;
	geoidSimple[80][348] = (byte)31;
	geoidSimple[80][349] = (byte)33;
	geoidSimple[80][350] = (byte)33;
	geoidSimple[80][351] = (byte)33;
	geoidSimple[80][352] = (byte)31;
	geoidSimple[80][353] = (byte)29;
	geoidSimple[80][354] = (byte)28;
	geoidSimple[80][355] = (byte)27;
	geoidSimple[80][356] = (byte)26;
	geoidSimple[80][357] = (byte)26;
	geoidSimple[80][358] = (byte)24;
	geoidSimple[80][359] = (byte)24;
	}
		/** Row 81*/
	private static void init81() {
	geoidSimple[81][0] = (byte)24;
	geoidSimple[81][1] = (byte)24;
	geoidSimple[81][2] = (byte)25;
	geoidSimple[81][3] = (byte)25;
	geoidSimple[81][4] = (byte)24;
	geoidSimple[81][5] = (byte)23;
	geoidSimple[81][6] = (byte)24;
	geoidSimple[81][7] = (byte)24;
	geoidSimple[81][8] = (byte)22;
	geoidSimple[81][9] = (byte)21;
	geoidSimple[81][10] = (byte)20;
	geoidSimple[81][11] = (byte)19;
	geoidSimple[81][12] = (byte)17;
	geoidSimple[81][13] = (byte)15;
	geoidSimple[81][14] = (byte)13;
	geoidSimple[81][15] = (byte)10;
	geoidSimple[81][16] = (byte)7;
	geoidSimple[81][17] = (byte)4;
	geoidSimple[81][18] = (byte)2;
	geoidSimple[81][19] = (byte)0;
	geoidSimple[81][20] = (byte)0;
	geoidSimple[81][21] = (byte)-1;
	geoidSimple[81][22] = (byte)-1;
	geoidSimple[81][23] = (byte)-1;
	geoidSimple[81][24] = (byte)-2;
	geoidSimple[81][25] = (byte)-4;
	geoidSimple[81][26] = (byte)-5;
	geoidSimple[81][27] = (byte)-6;
	geoidSimple[81][28] = (byte)-6;
	geoidSimple[81][29] = (byte)-8;
	geoidSimple[81][30] = (byte)-8;
	geoidSimple[81][31] = (byte)-8;
	geoidSimple[81][32] = (byte)-10;
	geoidSimple[81][33] = (byte)-10;
	geoidSimple[81][34] = (byte)-8;
	geoidSimple[81][35] = (byte)-5;
	geoidSimple[81][36] = (byte)-6;
	geoidSimple[81][37] = (byte)-7;
	geoidSimple[81][38] = (byte)-7;
	geoidSimple[81][39] = (byte)-10;
	geoidSimple[81][40] = (byte)-13;
	geoidSimple[81][41] = (byte)-14;
	geoidSimple[81][42] = (byte)-16;
	geoidSimple[81][43] = (byte)-18;
	geoidSimple[81][44] = (byte)-20;
	geoidSimple[81][45] = (byte)-23;
	geoidSimple[81][46] = (byte)-26;
	geoidSimple[81][47] = (byte)-28;
	geoidSimple[81][48] = (byte)-29;
	geoidSimple[81][49] = (byte)-33;
	geoidSimple[81][50] = (byte)-38;
	geoidSimple[81][51] = (byte)-46;
	geoidSimple[81][52] = (byte)-50;
	geoidSimple[81][53] = (byte)-52;
	geoidSimple[81][54] = (byte)-52;
	geoidSimple[81][55] = (byte)-52;
	geoidSimple[81][56] = (byte)-51;
	geoidSimple[81][57] = (byte)-52;
	geoidSimple[81][58] = (byte)-53;
	geoidSimple[81][59] = (byte)-56;
	geoidSimple[81][60] = (byte)-59;
	geoidSimple[81][61] = (byte)-63;
	geoidSimple[81][62] = (byte)-67;
	geoidSimple[81][63] = (byte)-71;
	geoidSimple[81][64] = (byte)-75;
	geoidSimple[81][65] = (byte)-78;
	geoidSimple[81][66] = (byte)-82;
	geoidSimple[81][67] = (byte)-85;
	geoidSimple[81][68] = (byte)-88;
	geoidSimple[81][69] = (byte)-91;
	geoidSimple[81][70] = (byte)-93;
	geoidSimple[81][71] = (byte)-95;
	geoidSimple[81][72] = (byte)-95;
	geoidSimple[81][73] = (byte)-97;
	geoidSimple[81][74] = (byte)-99;
	geoidSimple[81][75] = (byte)-99;
	geoidSimple[81][76] = (byte)-97;
	geoidSimple[81][77] = (byte)-97;
	geoidSimple[81][78] = (byte)-98;
	geoidSimple[81][79] = (byte)-97;
	geoidSimple[81][80] = (byte)-95;
	geoidSimple[81][81] = (byte)-95;
	geoidSimple[81][82] = (byte)-96;
	geoidSimple[81][83] = (byte)-93;
	geoidSimple[81][84] = (byte)-90;
	geoidSimple[81][85] = (byte)-86;
	geoidSimple[81][86] = (byte)-82;
	geoidSimple[81][87] = (byte)-76;
	geoidSimple[81][88] = (byte)-70;
	geoidSimple[81][89] = (byte)-64;
	geoidSimple[81][90] = (byte)-61;
	geoidSimple[81][91] = (byte)-59;
	geoidSimple[81][92] = (byte)-59;
	geoidSimple[81][93] = (byte)-57;
	geoidSimple[81][94] = (byte)-47;
	geoidSimple[81][95] = (byte)-42;
	geoidSimple[81][96] = (byte)-35;
	geoidSimple[81][97] = (byte)-31;
	geoidSimple[81][98] = (byte)-27;
	geoidSimple[81][99] = (byte)-22;
	geoidSimple[81][100] = (byte)-20;
	geoidSimple[81][101] = (byte)-17;
	geoidSimple[81][102] = (byte)-14;
	geoidSimple[81][103] = (byte)-10;
	geoidSimple[81][104] = (byte)-7;
	geoidSimple[81][105] = (byte)-4;
	geoidSimple[81][106] = (byte)0;
	geoidSimple[81][107] = (byte)4;
	geoidSimple[81][108] = (byte)8;
	geoidSimple[81][109] = (byte)12;
	geoidSimple[81][110] = (byte)16;
	geoidSimple[81][111] = (byte)20;
	geoidSimple[81][112] = (byte)24;
	geoidSimple[81][113] = (byte)29;
	geoidSimple[81][114] = (byte)33;
	geoidSimple[81][115] = (byte)36;
	geoidSimple[81][116] = (byte)39;
	geoidSimple[81][117] = (byte)46;
	geoidSimple[81][118] = (byte)49;
	geoidSimple[81][119] = (byte)51;
	geoidSimple[81][120] = (byte)54;
	geoidSimple[81][121] = (byte)54;
	geoidSimple[81][122] = (byte)56;
	geoidSimple[81][123] = (byte)64;
	geoidSimple[81][124] = (byte)67;
	geoidSimple[81][125] = (byte)68;
	geoidSimple[81][126] = (byte)62;
	geoidSimple[81][127] = (byte)54;
	geoidSimple[81][128] = (byte)61;
	geoidSimple[81][129] = (byte)63;
	geoidSimple[81][130] = (byte)62;
	geoidSimple[81][131] = (byte)61;
	geoidSimple[81][132] = (byte)62;
	geoidSimple[81][133] = (byte)62;
	geoidSimple[81][134] = (byte)62;
	geoidSimple[81][135] = (byte)61;
	geoidSimple[81][136] = (byte)62;
	geoidSimple[81][137] = (byte)61;
	geoidSimple[81][138] = (byte)58;
	geoidSimple[81][139] = (byte)61;
	geoidSimple[81][140] = (byte)61;
	geoidSimple[81][141] = (byte)61;
	geoidSimple[81][142] = (byte)60;
	geoidSimple[81][143] = (byte)58;
	geoidSimple[81][144] = (byte)56;
	geoidSimple[81][145] = (byte)57;
	geoidSimple[81][146] = (byte)56;
	geoidSimple[81][147] = (byte)55;
	geoidSimple[81][148] = (byte)56;
	geoidSimple[81][149] = (byte)53;
	geoidSimple[81][150] = (byte)52;
	geoidSimple[81][151] = (byte)50;
	geoidSimple[81][152] = (byte)51;
	geoidSimple[81][153] = (byte)45;
	geoidSimple[81][154] = (byte)44;
	geoidSimple[81][155] = (byte)44;
	geoidSimple[81][156] = (byte)43;
	geoidSimple[81][157] = (byte)42;
	geoidSimple[81][158] = (byte)40;
	geoidSimple[81][159] = (byte)38;
	geoidSimple[81][160] = (byte)36;
	geoidSimple[81][161] = (byte)35;
	geoidSimple[81][162] = (byte)33;
	geoidSimple[81][163] = (byte)31;
	geoidSimple[81][164] = (byte)30;
	geoidSimple[81][165] = (byte)29;
	geoidSimple[81][166] = (byte)28;
	geoidSimple[81][167] = (byte)28;
	geoidSimple[81][168] = (byte)26;
	geoidSimple[81][169] = (byte)25;
	geoidSimple[81][170] = (byte)25;
	geoidSimple[81][171] = (byte)25;
	geoidSimple[81][172] = (byte)22;
	geoidSimple[81][173] = (byte)21;
	geoidSimple[81][174] = (byte)20;
	geoidSimple[81][175] = (byte)19;
	geoidSimple[81][176] = (byte)17;
	geoidSimple[81][177] = (byte)17;
	geoidSimple[81][178] = (byte)15;
	geoidSimple[81][179] = (byte)14;
	geoidSimple[81][LAT_GRID_SIZE] = (byte)13;
	geoidSimple[81][181] = (byte)13;
	geoidSimple[81][182] = (byte)12;
	geoidSimple[81][183] = (byte)11;
	geoidSimple[81][184] = (byte)10;
	geoidSimple[81][185] = (byte)10;
	geoidSimple[81][186] = (byte)9;
	geoidSimple[81][187] = (byte)10;
	geoidSimple[81][188] = (byte)10;
	geoidSimple[81][189] = (byte)11;
	geoidSimple[81][190] = (byte)11;
	geoidSimple[81][191] = (byte)12;
	geoidSimple[81][192] = (byte)12;
	geoidSimple[81][193] = (byte)13;
	geoidSimple[81][194] = (byte)13;
	geoidSimple[81][195] = (byte)13;
	geoidSimple[81][196] = (byte)13;
	geoidSimple[