/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.util.math;

import it.stefanochizzolini.clown.util.math.LUDecomposition;

public final class SquareMatrix
implements Cloneable {
    private double[][] data;
    private int size;

    public static SquareMatrix getIdentity(int size) {
        SquareMatrix matrix = new SquareMatrix(size);
        double[][] matrixData = matrix.getData();
        int i = 0;
        while (i < size) {
            int j = 0;
            while (j < size) {
                matrixData[i][j] = i == j ? 1.0 : 0.0;
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public SquareMatrix(int size) {
        this.size = size;
        this.data = new double[size][size];
    }

    public SquareMatrix(double[][] data) {
        this.size = data.length;
        int i = 0;
        while (i < this.size) {
            if (data[i].length != this.size) {
                throw new IllegalArgumentException("All rows must have the same length.");
            }
            ++i;
        }
        this.data = data;
    }

    public Object clone() {
        SquareMatrix clone = new SquareMatrix(this.size);
        double[][] cloneData = clone.getData();
        int i = 0;
        while (i < this.size) {
            int j = 0;
            while (j < this.size) {
                cloneData[i][j] = this.data[i][j];
                ++j;
            }
            ++i;
        }
        return clone;
    }

    public double[][] getData() {
        return this.data;
    }

    public SquareMatrix getMatrix(int[] rowIndexes, int startColumnIndex) {
        SquareMatrix subMatrix = new SquareMatrix(rowIndexes.length);
        double[][] subMatrixData = subMatrix.getData();
        int endColumnIndex = startColumnIndex + rowIndexes.length - 1;
        try {
            int i = 0;
            while (i < rowIndexes.length) {
                int j = startColumnIndex;
                while (j <= endColumnIndex) {
                    subMatrixData[i][j - startColumnIndex] = this.data[rowIndexes[i]][j];
                    ++j;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return subMatrix;
    }

    public double getDet() {
        return new LUDecomposition(this).getDet();
    }

    public SquareMatrix getInverse() {
        return this.solve(SquareMatrix.getIdentity(this.size));
    }

    public int getSize() {
        return this.size;
    }

    public SquareMatrix solve(SquareMatrix target) {
        return new LUDecomposition(this).solve(target);
    }
}

