/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.tools;

import it.stefanochizzolini.clown.documents.contents.ContentScanner;
import it.stefanochizzolini.clown.documents.contents.Contents;
import it.stefanochizzolini.clown.documents.contents.IContentContext;
import it.stefanochizzolini.clown.documents.contents.ITextString;
import it.stefanochizzolini.clown.documents.contents.TextChar;
import it.stefanochizzolini.clown.documents.contents.TextStyle;
import it.stefanochizzolini.clown.documents.contents.objects.ContainerObject;
import it.stefanochizzolini.clown.documents.contents.objects.ContentObject;
import it.stefanochizzolini.clown.documents.contents.objects.Text;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TextExtractor {
    private AreaModeEnum areaMode = AreaModeEnum.Containment;
    private List<Rectangle2D> areas;
    private double areaTolerance = 0.0;
    private boolean sorted;

    public TextExtractor() {
        this(true);
    }

    public TextExtractor(boolean sorted) {
        this(null, sorted);
    }

    public TextExtractor(List<Rectangle2D> areas, boolean sorted) {
        this.setAreas(areas);
        this.setSorted(sorted);
    }

    public Map<Rectangle2D, List<ITextString>> extract(IContentContext contentContext) {
        Map<Rectangle2D, List<ITextString>> extractedTextStrings;
        ArrayList<ITextString> textStrings = new ArrayList<ITextString>();
        ArrayList<ContentScanner.TextStringWrapper> rawTextStrings = new ArrayList<ContentScanner.TextStringWrapper>();
        this.extract(new ContentScanner(contentContext), rawTextStrings);
        if (this.sorted) {
            this.sort(rawTextStrings, textStrings);
        } else {
            textStrings.addAll(rawTextStrings);
        }
        if (this.areas.isEmpty()) {
            extractedTextStrings = new HashMap<Rectangle2D, List<ITextString>>();
            extractedTextStrings.put(null, textStrings);
        } else {
            extractedTextStrings = this.filter(textStrings, this.areas.toArray(new Rectangle2D[this.areas.size()]));
        }
        return extractedTextStrings;
    }

    public Map<Rectangle2D, List<ITextString>> extract(Contents contents) {
        return this.extract(contents.getContentContext());
    }

    public String extractPlain(IContentContext contentContext) {
        StringBuilder textBuilder = new StringBuilder();
        for (List<ITextString> textStrings : this.extract(contentContext).values()) {
            if (textBuilder.length() > 0) {
                textBuilder.append('\n');
            }
            for (ITextString textString : textStrings) {
                textBuilder.append(String.valueOf(textString.getText()) + '\n');
            }
        }
        return textBuilder.toString();
    }

    public String extractPlain(Contents contents) {
        return this.extractPlain(contents.getContentContext());
    }

    public List<ITextString> filter(Map<Rectangle2D, List<ITextString>> textStrings, Rectangle2D area) {
        return this.filter(textStrings, new Rectangle2D[]{area}).get(area);
    }

    public Map<Rectangle2D, List<ITextString>> filter(Map<Rectangle2D, List<ITextString>> textStrings, Rectangle2D ... areas) {
        Map<Rectangle2D, List<ITextString>> filteredTextStrings = null;
        for (List<ITextString> areaTextStrings : textStrings.values()) {
            Map<Rectangle2D, List<ITextString>> filteredAreasTextStrings = this.filter(areaTextStrings, areas);
            if (filteredTextStrings == null) {
                filteredTextStrings = filteredAreasTextStrings;
                continue;
            }
            for (Map.Entry<Rectangle2D, List<ITextString>> filteredAreaTextStringsEntry : filteredAreasTextStrings.entrySet()) {
                filteredTextStrings.get(filteredAreaTextStringsEntry.getKey()).addAll((Collection<ITextString>)filteredAreaTextStringsEntry.getValue());
            }
        }
        return filteredTextStrings;
    }

    public List<ITextString> filter(List<? extends ITextString> textStrings, Rectangle2D area) {
        return this.filter(textStrings, new Rectangle2D[]{area}).get(area);
    }

    public Map<Rectangle2D, List<ITextString>> filter(List<? extends ITextString> textStrings, Rectangle2D ... areas) {
        HashMap<Rectangle2D, List<ITextString>> filteredAreasTextStrings = new HashMap<Rectangle2D, List<ITextString>>();
        Rectangle2D[] rectangle2DArray = areas;
        int n = areas.length;
        int n2 = 0;
        while (n2 < n) {
            Rectangle2D area = rectangle2DArray[n2];
            ArrayList<TextString> filteredAreaTextStrings = new ArrayList<TextString>();
            filteredAreasTextStrings.put(area, filteredAreaTextStrings);
            Rectangle2D toleratedArea = this.areaTolerance != 0.0 ? new Rectangle2D.Double(area.getX() - this.areaTolerance, area.getY() - this.areaTolerance, area.getWidth() + this.areaTolerance * 2.0, area.getHeight() + this.areaTolerance * 2.0) : area;
            for (ITextString iTextString : textStrings) {
                Rectangle2D textStringBox = iTextString.getBox();
                if (!toleratedArea.intersects(textStringBox)) continue;
                TextString filteredTextString = new TextString();
                List<TextChar> filteredTextStringChars = filteredTextString.getTextChars();
                for (TextChar textChar : iTextString.getTextChars()) {
                    Rectangle2D textCharBox = textChar.box;
                    if ((this.areaMode != AreaModeEnum.Containment || !toleratedArea.contains(textCharBox)) && (this.areaMode != AreaModeEnum.Intersection || !toleratedArea.intersects(textCharBox))) continue;
                    filteredTextStringChars.add(textChar);
                }
                filteredAreaTextStrings.add(filteredTextString);
            }
            ++n2;
        }
        return filteredAreasTextStrings;
    }

    public AreaModeEnum getAreaMode() {
        return this.areaMode;
    }

    public List<Rectangle2D> getAreas() {
        return this.areas;
    }

    public double getAreaTolerance() {
        return this.areaTolerance;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public void setAreaMode(AreaModeEnum value) {
        this.areaMode = value;
    }

    public void setAreas(List<Rectangle2D> value) {
        this.areas = value == null ? new ArrayList() : value;
    }

    public void setAreaTolerance(double value) {
        this.areaTolerance = value;
    }

    public void setSorted(boolean value) {
        this.sorted = value;
    }

    private void extract(ContentScanner level, List<ContentScanner.TextStringWrapper> extractedTextStrings) {
        while (level.moveNext()) {
            ContentObject content = level.getCurrent();
            if (content instanceof Text) {
                extractedTextStrings.addAll(((ContentScanner.TextWrapper)level.getCurrentWrapper()).getTextStrings());
                continue;
            }
            if (!(content instanceof ContainerObject)) continue;
            this.extract(level.getChildLevel(), extractedTextStrings);
        }
    }

    private void sort(List<ContentScanner.TextStringWrapper> rawTextStrings, List<ITextString> textStrings) {
        TextStringPositionComparator positionComparator = new TextStringPositionComparator();
        Collections.sort(rawTextStrings, positionComparator);
        TextString textString = null;
        TextChar previousTextChar = null;
        for (ContentScanner.TextStringWrapper rawTextString : rawTextStrings) {
            if (textString == null || !textString.getTextChars().isEmpty() && !TextStringPositionComparator.isOnTheSameLine(textString.getBox(), rawTextString.getBox())) {
                textString = new TextString();
                textStrings.add(textString);
                previousTextChar = null;
            }
            TextStyle textStyle = rawTextString.getStyle();
            double spaceWidth = 0.0;
            try {
                spaceWidth = textStyle.font.getWidth(' ', textStyle.fontSize);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (spaceWidth == 0.0) {
                spaceWidth = textStyle.fontSize * 0.25;
            }
            for (TextChar textChar : rawTextString.getTextChars()) {
                double characterSpace;
                if (previousTextChar != null && (characterSpace = textChar.box.getX() - previousTextChar.box.getMaxX()) >= spaceWidth) {
                    textString.textChars.add(new TextChar(' ', new Rectangle2D.Double(previousTextChar.box.getMaxX(), textChar.box.getY(), characterSpace, textChar.box.getHeight()), textStyle, true));
                }
                previousTextChar = textChar;
                textString.textChars.add(previousTextChar);
            }
        }
    }

    public static enum AreaModeEnum {
        Containment,
        Intersection;

    }

    private static class TextString
    implements ITextString {
        private List<TextChar> textChars = new ArrayList<TextChar>();

        private TextString() {
        }

        @Override
        public Rectangle2D getBox() {
            Rectangle2D box = null;
            for (TextChar textChar : this.textChars) {
                if (box == null) {
                    box = (Rectangle2D)textChar.box.clone();
                    continue;
                }
                box.add(textChar.box);
            }
            return box;
        }

        @Override
        public String getText() {
            StringBuilder textBuilder = new StringBuilder();
            for (TextChar textChar : this.textChars) {
                textBuilder.append(textChar);
            }
            return textBuilder.toString();
        }

        @Override
        public List<TextChar> getTextChars() {
            return this.textChars;
        }
    }

    private static class TextStringPositionComparator
    implements Comparator<ITextString> {
        private TextStringPositionComparator() {
        }

        public static boolean isOnTheSameLine(Rectangle2D box1, Rectangle2D box2) {
            double minHeight = Math.min(box1.getHeight(), box2.getHeight());
            double yThreshold = minHeight * 0.75;
            return box1.getY() > box2.getY() - yThreshold && box1.getY() < box2.getMaxY() + yThreshold - minHeight || box2.getY() > box1.getY() - yThreshold && box2.getY() < box1.getMaxY() + yThreshold - minHeight;
        }

        @Override
        public int compare(ITextString textString1, ITextString textString2) {
            Rectangle2D box2;
            Rectangle2D box1 = textString1.getBox();
            if (TextStringPositionComparator.isOnTheSameLine(box1, box2 = textString2.getBox())) {
                if (box1.getX() < box2.getX()) {
                    return -1;
                }
                if (box1.getX() > box2.getX()) {
                    return 1;
                }
                return 0;
            }
            if (box1.getY() < box2.getY()) {
                return -1;
            }
            return 1;
        }
    }
}

