/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.objects;

import it.stefanochizzolini.clown.bytes.IOutputStream;
import it.stefanochizzolini.clown.files.File;
import it.stefanochizzolini.clown.objects.PdfAtomicObject;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.util.ConvertUtils;
import it.stefanochizzolini.clown.util.NotImplementedException;
import java.io.ByteArrayOutputStream;

public class PdfString
extends PdfAtomicObject<byte[]> {
    private static final byte BackspaceCode = 8;
    private static final byte CarriageReturnCode = 13;
    private static final byte FormFeedCode = 12;
    private static final byte HorizontalTabCode = 9;
    private static final byte LineFeedCode = 10;
    private static final byte HexLeftDelimiterCode = 60;
    private static final byte HexRightDelimiterCode = 62;
    private static final byte LiteralEscapeCode = 92;
    private static final byte LiteralLeftDelimiterCode = 40;
    private static final byte LiteralRightDelimiterCode = 41;
    private static final String Encoding = "ISO-8859-1";
    private SerializationModeEnum serializationMode = SerializationModeEnum.Literal;

    public PdfString() {
    }

    public PdfString(byte[] value) {
        this.setRawValue(value);
    }

    public PdfString(String value) {
        this.setValue(value);
    }

    public PdfString(byte[] value, SerializationModeEnum serializationMode) {
        this.setSerializationMode(serializationMode);
        this.setRawValue(value);
    }

    public PdfString(String value, SerializationModeEnum serializationMode) {
        this.setSerializationMode(serializationMode);
        this.setValue(value);
    }

    @Override
    public Object clone(File context) {
        PdfString clone = (PdfString)super.clone();
        return clone;
    }

    @Override
    public int compareTo(PdfDirectObject object) {
        if (!(object instanceof PdfString)) {
            throw new IllegalArgumentException("Object MUST be a PdfString");
        }
        return ((String)this.getValue()).compareTo((String)((PdfString)object).getValue());
    }

    public SerializationModeEnum getSerializationMode() {
        return this.serializationMode;
    }

    @Override
    public Object getValue() {
        switch (this.serializationMode) {
            case Literal: {
                try {
                    return new String((byte[])this.getRawValue(), Encoding);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            case Hex: {
                return ConvertUtils.byteArrayToHex((byte[])this.getRawValue());
            }
        }
        throw new NotImplementedException((Object)((Object)this.serializationMode) + " serialization mode is not implemented.");
    }

    public void setSerializationMode(SerializationModeEnum value) {
        this.serializationMode = value;
    }

    @Override
    public void setValue(Object value) {
        switch (this.serializationMode) {
            case Literal: {
                try {
                    this.setRawValue(((String)value).getBytes(Encoding));
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            case Hex: {
                this.setRawValue(ConvertUtils.hexToByteArray((String)value));
                break;
            }
            default: {
                throw new NotImplementedException((Object)((Object)this.serializationMode) + " serialization mode is not implemented.");
            }
        }
    }

    @Override
    public void writeTo(IOutputStream stream) {
        stream.write(this.toPdf());
    }

    private byte[] toPdf() {
        byte[] rawValue = (byte[])this.getRawValue();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        switch (this.serializationMode) {
            case Literal: {
                buffer.write(40);
                int index = 0;
                while (index < rawValue.length) {
                    int valueByte = rawValue[index];
                    switch (valueByte) {
                        case 10: {
                            buffer.write(92);
                            valueByte = 110;
                            break;
                        }
                        case 13: {
                            buffer.write(92);
                            valueByte = 114;
                            break;
                        }
                        case 9: {
                            buffer.write(92);
                            valueByte = 116;
                            break;
                        }
                        case 8: {
                            buffer.write(92);
                            valueByte = 98;
                            break;
                        }
                        case 12: {
                            buffer.write(92);
                            valueByte = 102;
                            break;
                        }
                        case 40: 
                        case 41: 
                        case 92: {
                            buffer.write(92);
                        }
                    }
                    buffer.write(valueByte);
                    ++index;
                }
                buffer.write(41);
                break;
            }
            case Hex: {
                buffer.write(60);
                try {
                    byte[] value = ConvertUtils.byteArrayToHex(rawValue).getBytes(Encoding);
                    buffer.write(value, 0, value.length);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                buffer.write(62);
                break;
            }
            default: {
                throw new NotImplementedException();
            }
        }
        return buffer.toByteArray();
    }

    public static enum SerializationModeEnum {
        Literal,
        Hex;

    }
}

