/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.objects;

import it.stefanochizzolini.clown.bytes.IOutputStream;
import it.stefanochizzolini.clown.files.File;
import it.stefanochizzolini.clown.objects.IPdfIndirectObject;
import it.stefanochizzolini.clown.objects.PdfDataObject;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfIndirectObject;
import it.stefanochizzolini.clown.tokens.Parser;
import it.stefanochizzolini.clown.util.NotImplementedException;
import java.text.DecimalFormat;

public class PdfReference
extends PdfDirectObject
implements IPdfIndirectObject {
    private static final DecimalFormat xRefGenerationFormatter = new DecimalFormat("00000");
    private static final DecimalFormat xRefOffsetFormatter = new DecimalFormat("0000000000");
    private PdfIndirectObject indirectObject;
    private int generationNumber;
    private int objectNumber;
    private File file;

    PdfReference(PdfIndirectObject indirectObject, int objectNumber, int generationNumber) {
        this.indirectObject = indirectObject;
        this.objectNumber = objectNumber;
        this.generationNumber = generationNumber;
    }

    public PdfReference(Parser.Reference reference, File file) {
        this.objectNumber = reference.getObjectNumber();
        this.generationNumber = reference.getGenerationNumber();
        this.file = file;
    }

    @Override
    public int compareTo(PdfDirectObject object) {
        throw new NotImplementedException();
    }

    public boolean equals(Object object) {
        if (!(object instanceof PdfReference)) {
            return false;
        }
        return this.getID().equals(((PdfReference)object).getID());
    }

    public String getCrossReference(long offset) {
        return String.valueOf(xRefOffsetFormatter.format(offset)) + " " + xRefGenerationFormatter.format(this.generationNumber) + " " + this.getIndirectObject().getUsage() + "\r\n";
    }

    public int getGenerationNumber() {
        return this.generationNumber;
    }

    public String getID() {
        return String.valueOf(this.objectNumber) + " " + this.generationNumber;
    }

    public String getIndirectReference() {
        return String.valueOf(this.getID()) + " R";
    }

    public int getObjectNumber() {
        return this.objectNumber;
    }

    public int hashCode() {
        return this.getIndirectObject().hashCode();
    }

    public String toString() {
        return this.getIndirectReference();
    }

    @Override
    public void writeTo(IOutputStream stream) {
        stream.write(this.getIndirectReference());
    }

    @Override
    public Object clone(File context) {
        return ((PdfIndirectObject)this.getIndirectObject().clone(context)).getReference();
    }

    @Override
    public void delete() {
        this.getIndirectObject().delete();
    }

    @Override
    public PdfDataObject getDataObject() {
        return this.getIndirectObject().getDataObject();
    }

    @Override
    public PdfIndirectObject getIndirectObject() {
        if (this.indirectObject == null) {
            this.indirectObject = this.file.getIndirectObjects().get(this.objectNumber);
        }
        return this.indirectObject;
    }

    @Override
    public PdfReference getReference() {
        return this;
    }

    @Override
    public void setDataObject(PdfDataObject value) {
        this.getIndirectObject().setDataObject(value);
    }
}

