/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.objects;

import it.stefanochizzolini.clown.bytes.IOutputStream;
import it.stefanochizzolini.clown.files.File;
import it.stefanochizzolini.clown.objects.IPdfNumber;
import it.stefanochizzolini.clown.objects.PdfAtomicObject;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfNumber;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class PdfReal
extends PdfAtomicObject<Double>
implements IPdfNumber {
    protected static final DecimalFormat formatter;

    static {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        formatter = new DecimalFormat("0.#####", symbols);
    }

    public static PdfReal get(Double value) {
        return value == null ? null : new PdfReal(value);
    }

    public PdfReal(double value) {
        this.setRawValue(value);
    }

    @Override
    public Object clone(File context) {
        PdfReal clone = (PdfReal)super.clone();
        return clone;
    }

    @Override
    public int compareTo(PdfDirectObject obj) {
        return PdfNumber.compare(this, obj);
    }

    @Override
    public void writeTo(IOutputStream stream) {
        stream.write(this.toPdf((Double)this.getRawValue()));
    }

    @Override
    public double getNumberValue() {
        return (Double)this.getRawValue();
    }

    @Override
    public void setNumberValue(double value) {
        this.setRawValue(value);
    }

    @Override
    public void translateNumberValue(double value) {
        this.setRawValue((Double)this.getRawValue() + value);
    }

    private String toPdf(double value) {
        return formatter.format(value);
    }
}

