/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.objects;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.files.File;
import it.stefanochizzolini.clown.objects.PdfDataObject;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfIndirectObject;
import it.stefanochizzolini.clown.objects.PdfReference;

public abstract class PdfObjectWrapper<TDataObject extends PdfDataObject> {
    private TDataObject baseDataObject;
    private PdfDirectObject baseObject;
    private PdfIndirectObject container;

    protected PdfObjectWrapper(File context, TDataObject baseDataObject) {
        this(context.register((PdfDataObject)baseDataObject), null);
    }

    protected PdfObjectWrapper(PdfDirectObject baseObject, PdfIndirectObject container) {
        this.setBaseObject(baseObject);
        this.setContainer(container);
    }

    public abstract Object clone(Document var1);

    public boolean delete() {
        if (this.baseObject instanceof PdfReference) {
            ((PdfReference)this.baseObject).delete();
            return true;
        }
        return false;
    }

    public TDataObject getBaseDataObject() {
        return this.baseDataObject;
    }

    public PdfDirectObject getBaseObject() {
        return this.baseObject;
    }

    public PdfIndirectObject getContainer() {
        return this.container;
    }

    public Document getDocument() {
        return this.container.getFile().getDocument();
    }

    public File getFile() {
        return this.container.getFile();
    }

    public void update() {
        this.container.update();
    }

    protected void setBaseObject(PdfDirectObject value) {
        this.baseObject = value;
        this.baseDataObject = File.resolve(this.baseObject);
    }

    public void setContainer(PdfIndirectObject value) {
        this.container = this.baseObject instanceof PdfReference ? ((PdfReference)this.baseObject).getIndirectObject() : value;
    }
}

