/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.objects;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.files.File;
import it.stefanochizzolini.clown.objects.PdfArray;
import it.stefanochizzolini.clown.objects.PdfDataObject;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfIndirectObject;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfObjectWrapper;
import it.stefanochizzolini.clown.objects.PdfReference;
import it.stefanochizzolini.clown.objects.PdfString;
import it.stefanochizzolini.clown.util.NotImplementedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class NameTree<T extends PdfObjectWrapper<?>>
extends PdfObjectWrapper<PdfDictionary>
implements Map<PdfString, T> {
    private static final int NodeMinSize = 5;
    private static final int TreeOrder = 10;
    private static final int NameNodeMinSize = 10;
    private static final int NameOrder = 20;
    private static final int[] ChildrenOrders = new int[]{20, 10};
    private static final PdfName[] ChildrenTypeNames = new PdfName[]{PdfName.Names, PdfName.Kids};

    public NameTree(Document context) {
        super(context.getFile(), new PdfDictionary(new PdfName[]{PdfName.Names}, new PdfDirectObject[]{new PdfArray()}));
    }

    public NameTree(PdfDirectObject baseObject, PdfIndirectObject container) {
        super(baseObject, container);
    }

    @Override
    public NameTree<T> clone(Document context) {
        throw new NotImplementedException();
    }

    @Override
    public void clear() {
        this.clear((PdfDictionary)this.getBaseDataObject());
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new NotImplementedException();
    }

    @Override
    public Set<Map.Entry<PdfString, T>> entrySet() {
        IFiller filler = new IFiller<Set<Map.Entry<PdfString, T>>>(){
            private Set<Map.Entry<PdfString, T>> entrySet = new HashSet();

            @Override
            public void add(PdfArray names, int offset, PdfIndirectObject container) {
                PdfString key = (PdfString)names.get(offset);
                Object value = NameTree.this.wrap(names.get(offset + 1), container, key);
                this.entrySet.add(new Entry(NameTree.this, key, (PdfObjectWrapper)value));
            }

            @Override
            public Set<Map.Entry<PdfString, T>> getCollection() {
                return this.entrySet;
            }
        };
        this.fill(filler, (PdfReference)this.getBaseObject());
        return (Set)filler.getCollection();
    }

    @Override
    public boolean equals(Object object) {
        throw new NotImplementedException();
    }

    @Override
    public T get(Object key) {
        int mid;
        int high;
        int low;
        PdfDirectObject namesObject;
        PdfString keyString = (PdfString)key;
        PdfDirectObject containerObject = this.getBaseObject();
        PdfDictionary parent = (PdfDictionary)this.getBaseDataObject();
        while ((namesObject = parent.get(PdfName.Names)) == null) {
            PdfDictionary kid;
            PdfDirectObject kidObject;
            PdfArray kids = (PdfArray)parent.resolve(PdfName.Kids);
            low = 0;
            high = kids.size() - 1;
            while (true) {
                if (low > high) {
                    return null;
                }
                mid = (low + high) / 2;
                kidObject = kids.get(mid);
                kid = (PdfDictionary)File.resolve(kidObject);
                PdfArray limits = (PdfArray)kid.resolve(PdfName.Limits);
                int comparison = keyString.compareTo((PdfString)limits.get(0));
                if (comparison < 0) {
                    high = mid - 1;
                    continue;
                }
                comparison = keyString.compareTo((PdfString)limits.get(1));
                if (comparison <= 0) break;
                low = mid + 1;
            }
            containerObject = kidObject;
            parent = kid;
        }
        if (namesObject instanceof PdfReference) {
            containerObject = namesObject;
        }
        PdfArray names = (PdfArray)File.resolve(namesObject);
        low = 0;
        high = names.size();
        while (true) {
            int comparison;
            if (low > high) {
                return null;
            }
            mid = (low + high) / 2;
            if ((comparison = keyString.compareTo((PdfString)names.get(mid -= mid % 2))) < 0) {
                high = mid - 2;
                continue;
            }
            if (comparison <= 0) break;
            low = mid + 2;
        }
        return this.wrap(names.get(mid + 1), ((PdfReference)containerObject).getIndirectObject(), (PdfString)names.get(mid));
    }

    @Override
    public int hashCode() {
        throw new NotImplementedException();
    }

    @Override
    public boolean isEmpty() {
        PdfDictionary rootNode = (PdfDictionary)this.getBaseDataObject();
        PdfArray children = (PdfArray)rootNode.resolve(PdfName.Names);
        if (children == null) {
            children = (PdfArray)rootNode.resolve(PdfName.Kids);
        }
        return children == null || children.size() == 0;
    }

    @Override
    public Set<PdfString> keySet() {
        IFiller<Set<PdfString>> filler = new IFiller<Set<PdfString>>(){
            private Set<PdfString> keySet = new HashSet<PdfString>();

            @Override
            public void add(PdfArray names, int offset, PdfIndirectObject container) {
                this.keySet.add((PdfString)names.get(offset));
            }

            @Override
            public Set<PdfString> getCollection() {
                return this.keySet;
            }
        };
        this.fill(filler, (PdfReference)this.getBaseObject());
        return (Set)filler.getCollection();
    }

    @Override
    public T put(PdfString key, T value) {
        PdfReference rootReference = (PdfReference)this.getBaseObject();
        PdfDictionary root = (PdfDictionary)rootReference.getDataObject();
        Children rootChildren = this.getChildren(root);
        if (rootChildren.items.size() >= rootChildren.order) {
            PdfDataObject oldRootDataObject = rootReference.getDataObject();
            root = new PdfDictionary(new PdfName[]{PdfName.Kids}, new PdfDirectObject[]{new PdfArray(this.getFile().register(oldRootDataObject))});
            rootReference.setDataObject(root);
            this.splitFullNode((PdfArray)root.get(PdfName.Kids), 0, rootChildren.typeName);
        }
        return this.put(key, value, rootReference);
    }

    @Override
    public void putAll(Map<? extends PdfString, ? extends T> entries) {
        for (Map.Entry<PdfString, T> entry : entries.entrySet()) {
            this.put(entry.getKey(), (T)((PdfObjectWrapper)entry.getValue()));
        }
    }

    @Override
    public T remove(Object key) {
        throw new NotImplementedException();
    }

    @Override
    public int size() {
        return this.getSize((PdfDictionary)this.getBaseDataObject());
    }

    @Override
    public Collection<T> values() {
        IFiller filler = new IFiller<Collection<T>>(){
            private Collection<T> values = new ArrayList();

            @Override
            public void add(PdfArray names, int offset, PdfIndirectObject container) {
                this.values.add(NameTree.this.wrap(names.get(offset + 1), container, (PdfString)names.get(offset)));
            }

            @Override
            public Collection<T> getCollection() {
                return this.values;
            }
        };
        this.fill(filler, (PdfReference)this.getBaseObject());
        return filler.getCollection();
    }

    protected abstract T wrap(PdfDirectObject var1, PdfIndirectObject var2, PdfString var3);

    private void clear(PdfDictionary node) {
        Children children = this.getChildren(node);
        if (children.typeName.equals(PdfName.Kids)) {
            for (PdfDirectObject child : children.items) {
                this.clear((PdfDictionary)File.resolve(child));
                this.getFile().unregister((PdfReference)child);
            }
            node.put(PdfName.Names, node.get(children.typeName));
            node.remove(children.typeName);
        }
        children.items.clear();
        node.remove(PdfName.Limits);
    }

    private <TCollection extends Collection<?>> void fill(IFiller<TCollection> filler, PdfReference nodeReference) {
        PdfDictionary node = (PdfDictionary)nodeReference.getDataObject();
        File.ResolvedObject kidsObject = File.resolve(node.get(PdfName.Kids), nodeReference);
        if (kidsObject == null) {
            File.ResolvedObject namesObject = File.resolve(node.get(PdfName.Names), nodeReference);
            int index = 0;
            int length = ((PdfArray)namesObject.dataObject).size();
            while (index < length) {
                filler.add((PdfArray)namesObject.dataObject, index, namesObject.container);
                index += 2;
            }
        } else {
            for (PdfDirectObject kidObject : (PdfArray)kidsObject.dataObject) {
                this.fill(filler, (PdfReference)kidObject);
            }
        }
    }

    private Children getChildren(PdfDictionary node) {
        PdfArray children = null;
        PdfName childrenTypeName = null;
        int childrenOrder = 0;
        int index = 0;
        int length = ChildrenTypeNames.length;
        while (index < length) {
            childrenTypeName = ChildrenTypeNames[index];
            children = (PdfArray)node.resolve(childrenTypeName);
            if (children != null) {
                childrenOrder = ChildrenOrders[index];
                break;
            }
            ++index;
        }
        return new Children(children, childrenTypeName, childrenOrder);
    }

    private int getSize(PdfDictionary node) {
        PdfArray children = (PdfArray)node.resolve(PdfName.Names);
        if (children == null) {
            children = (PdfArray)node.resolve(PdfName.Kids);
            int size = 0;
            for (PdfDirectObject child : children) {
                size += this.getSize((PdfDictionary)File.resolve(child));
            }
            return size;
        }
        return children.size() / 2;
    }

    private T put(PdfString key, T value, PdfReference nodeReference) {
        Object oldValue;
        PdfDictionary node = (PdfDictionary)nodeReference.getDataObject();
        PdfArray children = (PdfArray)node.resolve(PdfName.Names);
        if (children == null) {
            PdfDictionary kid;
            PdfReference kidReference;
            int mid;
            boolean matched;
            children = (PdfArray)node.resolve(PdfName.Kids);
            int low = 0;
            int high = children.size() - 1;
            do {
                matched = false;
                mid = (low + high) / 2;
                kidReference = (PdfReference)children.get(mid);
                kid = (PdfDictionary)kidReference.getDataObject();
                PdfArray limits = (PdfArray)kid.resolve(PdfName.Limits);
                if (key.compareTo((PdfString)limits.get(0)) < 0) {
                    high = mid - 1;
                    continue;
                }
                if (key.compareTo((PdfString)limits.get(1)) > 0) {
                    low = mid + 1;
                    continue;
                }
                matched = true;
            } while (!matched && low <= high);
            Children kidChildren = this.getChildren(kid);
            if (kidChildren.items.size() >= kidChildren.order) {
                this.splitFullNode(children, mid, kidChildren.typeName);
                if (key.compareTo(((PdfArray)kid.resolve(PdfName.Limits)).get(0)) < 0) {
                    kidReference = (PdfReference)children.get(mid);
                    kid = (PdfDictionary)kidReference.getDataObject();
                }
            }
            oldValue = this.put(key, value, kidReference);
            this.updateNodeLimits(node, children, PdfName.Kids);
        } else {
            block12: {
                int childrenSize = children.size();
                int low = 0;
                int high = childrenSize;
                do {
                    int mid = (low + high) / 2;
                    if ((mid -= mid % 2) >= childrenSize) {
                        oldValue = null;
                        children.add(key);
                        children.add(((PdfObjectWrapper)value).getBaseObject());
                    } else {
                        int comparison = key.compareTo((PdfString)children.get(mid));
                        if (comparison < 0) {
                            high = mid - 2;
                            continue;
                        }
                        if (comparison > 0) {
                            low = mid + 2;
                            continue;
                        }
                        oldValue = this.wrap(children.get(mid + 1), nodeReference.getIndirectObject(), (PdfString)children.get(mid));
                        children.set(mid, key);
                        children.set(++mid, ((PdfObjectWrapper)value).getBaseObject());
                    }
                    break block12;
                } while (low <= high);
                oldValue = null;
                children.add(low, key);
                children.add(++low, ((PdfObjectWrapper)value).getBaseObject());
            }
            this.updateNodeLimits(node, children, PdfName.Names);
        }
        return oldValue;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void splitFullNode(PdfArray nodes, int fullNodeIndex, PdfName childrenTypeName) {
        int length;
        PdfDictionary fullNode = (PdfDictionary)nodes.resolve(fullNodeIndex);
        PdfArray fullNodeChildren = (PdfArray)fullNode.resolve(childrenTypeName);
        PdfDictionary newNode = new PdfDictionary();
        PdfArray newNodeChildren = new PdfArray();
        newNode.put(childrenTypeName, newNodeChildren);
        nodes.add(fullNodeIndex, this.getFile().register(newNode));
        int index = 0;
        if (childrenTypeName.equals(PdfName.Kids)) {
            length = 5;
        } else {
            if (!childrenTypeName.equals(PdfName.Names)) {
                throw new UnsupportedOperationException(childrenTypeName + " is NOT a supported child type.");
            }
            length = 10;
        }
        while (index++ < length) {
            newNodeChildren.add(fullNodeChildren.get(0));
            fullNodeChildren.remove(0);
        }
        this.updateNodeLimits(newNode, newNodeChildren, childrenTypeName);
        this.updateNodeLimits(fullNode, fullNodeChildren, childrenTypeName);
    }

    private void updateNodeLimits(PdfDictionary node, PdfArray children, PdfName childrenTypeName) {
        if (childrenTypeName.equals(PdfName.Kids)) {
            node.put(PdfName.Limits, new PdfArray(((PdfArray)((PdfDictionary)children.resolve(0)).resolve(PdfName.Limits)).get(0), ((PdfArray)((PdfDictionary)children.resolve(children.size() - 1)).resolve(PdfName.Limits)).get(1)));
        } else if (childrenTypeName.equals(PdfName.Names)) {
            node.put(PdfName.Limits, new PdfArray(children.get(0), children.get(children.size() - 2)));
        } else {
            throw new UnsupportedOperationException(childrenTypeName + " is NOT a supported child type.");
        }
    }

    private static final class Children {
        public final PdfArray items;
        public final int order;
        public final PdfName typeName;

        private Children(PdfArray items, PdfName typeName, int order) {
            this.items = items;
            this.typeName = typeName;
            this.order = order;
        }
    }

    private static final class Entry
    implements Map.Entry<PdfString, T>,
    Comparable<Entry> {
        private final PdfString key;
        private final T value;
        final /* synthetic */ NameTree this$0;

        private Entry(PdfString key, T value) {
            this.this$0 = var1_1;
            this.key = key;
            this.value = value;
        }

        @Override
        public int compareTo(Entry obj) {
            return this.key.compareTo(obj.getKey());
        }

        @Override
        public PdfString getKey() {
            return this.key;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public T setValue(T value) {
            throw new UnsupportedOperationException();
        }
    }

    private static interface IFiller<TCollection extends Collection<?>> {
        public void add(PdfArray var1, int var2, PdfIndirectObject var3);

        public TCollection getCollection();
    }
}

