/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.files;

import it.stefanochizzolini.clown.files.File;
import it.stefanochizzolini.clown.files.UpdateModeEnum;
import it.stefanochizzolini.clown.objects.PdfDataObject;
import it.stefanochizzolini.clown.objects.PdfIndirectObject;
import it.stefanochizzolini.clown.tokens.XRefEntry;
import it.stefanochizzolini.clown.util.NotImplementedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.TreeMap;

public class IndirectObjects
implements List<PdfIndirectObject> {
    private File file;
    private Hashtable<Integer, PdfIndirectObject> importedObjects = new Hashtable();
    private TreeMap<Integer, PdfIndirectObject> modifiedObjects = new TreeMap();
    private TreeMap<Integer, PdfIndirectObject> wokenObjects = new TreeMap();
    private int lastObjectNumber = -1;
    private XRefEntry[] xrefEntries;
    private UpdateModeEnum updateMode = UpdateModeEnum.Manual;

    IndirectObjects(File file, XRefEntry[] xrefEntries) {
        this.file = file;
        this.xrefEntries = xrefEntries;
        if (this.xrefEntries == null) {
            ++this.lastObjectNumber;
            this.modifiedObjects.put(this.lastObjectNumber, new PdfIndirectObject(this.file, null, new XRefEntry(this.lastObjectNumber, 65535, 0, XRefEntry.UsageEnum.Free)));
        } else {
            this.lastObjectNumber = xrefEntries.length - 1;
        }
    }

    public File getFile() {
        return this.file;
    }

    public PdfIndirectObject add(PdfDataObject object) {
        ++this.lastObjectNumber;
        PdfIndirectObject indirectObject = new PdfIndirectObject(this.file, object, new XRefEntry(this.lastObjectNumber, 0, 0, XRefEntry.UsageEnum.InUse));
        this.modifiedObjects.put(this.lastObjectNumber, indirectObject);
        return indirectObject;
    }

    public PdfIndirectObject addExternal(PdfIndirectObject object) {
        PdfIndirectObject indirectObject = this.importedObjects.get(object.hashCode());
        if (indirectObject == null) {
            indirectObject = this.add((PdfDataObject)object.getDataObject().clone(this.file));
            this.importedObjects.put(object.hashCode(), indirectObject);
        }
        return indirectObject;
    }

    public Collection<? extends PdfIndirectObject> addAllExternal(Collection<? extends PdfIndirectObject> objects) {
        ArrayList<PdfIndirectObject> addedObjects = new ArrayList<PdfIndirectObject>(objects.size());
        for (PdfIndirectObject pdfIndirectObject : objects) {
            addedObjects.add(this.addExternal(pdfIndirectObject));
        }
        return addedObjects;
    }

    @Override
    public void add(int index, PdfIndirectObject object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends PdfIndirectObject> objects) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PdfIndirectObject get(int index) {
        PdfIndirectObject object = this.modifiedObjects.get(index);
        if (object == null && (object = this.wokenObjects.get(index)) == null) {
            try {
                object = new PdfIndirectObject(this.file, null, this.xrefEntries[index]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.wokenObjects.put(index, object);
            if (this.updateMode == UpdateModeEnum.Automatic) {
                this.update(object);
            }
        }
        return object;
    }

    @Override
    public int indexOf(Object object) {
        if (((PdfIndirectObject)object).getFile() != this.file) {
            return -1;
        }
        return ((PdfIndirectObject)object).getReference().getObjectNumber();
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.indexOf(object);
    }

    @Override
    public ListIterator<PdfIndirectObject> listIterator() {
        throw new NotImplementedException();
    }

    @Override
    public ListIterator<PdfIndirectObject> listIterator(int index) {
        throw new NotImplementedException();
    }

    @Override
    public PdfIndirectObject remove(int index) {
        return this.update(new PdfIndirectObject(this.file, null, new XRefEntry(index, 65535, 0, XRefEntry.UsageEnum.Free)));
    }

    @Override
    public PdfIndirectObject set(int index, PdfIndirectObject object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<PdfIndirectObject> subList(int fromIndex, int toIndex) {
        throw new NotImplementedException();
    }

    @Override
    public boolean add(PdfIndirectObject object) {
        boolean changed = this.addExternal(object) != null;
        return changed;
    }

    @Override
    public boolean addAll(Collection<? extends PdfIndirectObject> objects) {
        boolean changed = false;
        for (PdfIndirectObject pdfIndirectObject : objects) {
            changed |= this.addExternal(pdfIndirectObject) != null;
        }
        return changed;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object object) {
        throw new NotImplementedException();
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        throw new NotImplementedException();
    }

    @Override
    public boolean equals(Object object) {
        throw new NotImplementedException();
    }

    @Override
    public int hashCode() {
        throw new NotImplementedException();
    }

    @Override
    public boolean isEmpty() {
        for (PdfIndirectObject object : this) {
            if (!object.isInUse()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean remove(Object object) {
        return this.remove(((PdfIndirectObject)object).getReference().getObjectNumber()) != null;
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        throw new NotImplementedException();
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.lastObjectNumber + 1;
    }

    public PdfIndirectObject[] toArray() {
        throw new NotImplementedException();
    }

    @Override
    public <T> T[] toArray(T[] objects) {
        throw new NotImplementedException();
    }

    @Override
    public Iterator<PdfIndirectObject> iterator() {
        return new Iterator<PdfIndirectObject>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < IndirectObjects.this.size();
            }

            @Override
            public PdfIndirectObject next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return IndirectObjects.this.get(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public TreeMap<Integer, PdfIndirectObject> getModifiedObjects() {
        return this.modifiedObjects;
    }

    public PdfIndirectObject update(PdfIndirectObject object) {
        int index = object.getReference().getObjectNumber();
        PdfIndirectObject old = this.get(index);
        if (old != object) {
            old.dropFile();
        }
        this.modifiedObjects.put(index, object);
        this.wokenObjects.remove(index);
        object.dropOriginal();
        return old;
    }
}

