/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.interaction.navigation.document;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.interaction.navigation.document.LocalDestination;
import it.stefanochizzolini.clown.documents.interaction.navigation.document.RemoteDestination;
import it.stefanochizzolini.clown.files.File;
import it.stefanochizzolini.clown.objects.PdfArray;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfIndirectObject;
import it.stefanochizzolini.clown.objects.PdfInteger;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfNamedObjectWrapper;
import it.stefanochizzolini.clown.objects.PdfReal;
import it.stefanochizzolini.clown.objects.PdfReference;
import it.stefanochizzolini.clown.objects.PdfString;
import it.stefanochizzolini.clown.util.NotImplementedException;

public abstract class Destination
extends PdfNamedObjectWrapper<PdfArray> {
    public static final Destination wrap(PdfDirectObject baseObject, PdfIndirectObject container, PdfString name) {
        if (baseObject == null) {
            return null;
        }
        PdfArray dataObject = (PdfArray)File.resolve(baseObject);
        PdfDirectObject pageObject = dataObject.get(0);
        if (pageObject instanceof PdfReference) {
            return new LocalDestination(baseObject, container, name);
        }
        if (pageObject instanceof PdfInteger) {
            return new RemoteDestination(baseObject, container, name);
        }
        throw new IllegalArgumentException("'baseObject' parameter doesn't represent a valid destination object.");
    }

    protected Destination(Document context, PdfDirectObject pageObject, ModeEnum mode, Double[] viewParams) {
        super(context.getFile(), new PdfArray());
        PdfArray destinationObject = (PdfArray)this.getBaseDataObject();
        destinationObject.add(pageObject);
        switch (mode) {
            case Fit: {
                destinationObject.add(PdfName.Fit);
                break;
            }
            case FitBoundingBox: {
                destinationObject.add(PdfName.FitB);
                break;
            }
            case FitBoundingBoxHorizontal: {
                destinationObject.add(PdfName.FitBH);
                destinationObject.add(PdfReal.get(viewParams[0]));
                break;
            }
            case FitBoundingBoxVertical: {
                destinationObject.add(PdfName.FitBV);
                destinationObject.add(PdfReal.get(viewParams[0]));
                break;
            }
            case FitHorizontal: {
                destinationObject.add(PdfName.FitH);
                destinationObject.add(PdfReal.get(viewParams[0]));
                break;
            }
            case FitRectangle: {
                destinationObject.add(PdfName.FitR);
                destinationObject.add(PdfReal.get(viewParams[0]));
                destinationObject.add(PdfReal.get(viewParams[1]));
                destinationObject.add(PdfReal.get(viewParams[2]));
                destinationObject.add(PdfReal.get(viewParams[3]));
                break;
            }
            case FitVertical: {
                destinationObject.add(PdfName.FitV);
                destinationObject.add(PdfReal.get(viewParams[0]));
                break;
            }
            case XYZ: {
                destinationObject.add(PdfName.XYZ);
                destinationObject.add(PdfReal.get(viewParams[0]));
                destinationObject.add(PdfReal.get(viewParams[1]));
                destinationObject.add(PdfReal.get(viewParams[2]));
            }
        }
    }

    protected Destination(PdfDirectObject baseObject, PdfIndirectObject container, PdfString name) {
        super(baseObject, container, name);
    }

    @Override
    public Destination clone(Document context) {
        throw new NotImplementedException();
    }

    public ModeEnum getMode() {
        PdfName modeObject = (PdfName)((PdfArray)this.getBaseDataObject()).get(1);
        if (modeObject.equals(PdfName.FitB)) {
            return ModeEnum.FitBoundingBox;
        }
        if (modeObject.equals(PdfName.FitBH)) {
            return ModeEnum.FitBoundingBoxHorizontal;
        }
        if (modeObject.equals(PdfName.FitBV)) {
            return ModeEnum.FitBoundingBoxVertical;
        }
        if (modeObject.equals(PdfName.FitH)) {
            return ModeEnum.FitHorizontal;
        }
        if (modeObject.equals(PdfName.FitR)) {
            return ModeEnum.FitRectangle;
        }
        if (modeObject.equals(PdfName.FitV)) {
            return ModeEnum.FitVertical;
        }
        if (modeObject.equals(PdfName.XYZ)) {
            return ModeEnum.XYZ;
        }
        return ModeEnum.Fit;
    }

    public abstract Object getPageRef();

    public static enum ModeEnum {
        XYZ,
        Fit,
        FitHorizontal,
        FitVertical,
        FitRectangle,
        FitBoundingBox,
        FitBoundingBoxHorizontal,
        FitBoundingBoxVertical;

    }
}

