/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.interaction.forms;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.interaction.annotations.Widget;
import it.stefanochizzolini.clown.documents.interaction.forms.Field;
import it.stefanochizzolini.clown.files.File;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfInteger;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfTextString;
import it.stefanochizzolini.clown.util.NotImplementedException;
import java.util.EnumSet;

public class TextField
extends Field {
    public TextField(String name, Widget widget, String value) {
        super(PdfName.Tx, name, widget);
        this.setValue(value);
    }

    public TextField(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public TextField clone(Document context) {
        throw new NotImplementedException();
    }

    public int getMaxLength() {
        PdfInteger maxLengthObject = (PdfInteger)File.resolve(this.getInheritableAttribute(PdfName.MaxLen));
        if (maxLengthObject == null) {
            return Integer.MAX_VALUE;
        }
        return (Integer)maxLengthObject.getRawValue();
    }

    public boolean isMultiline() {
        return this.getFlags().contains((Object)Field.FlagsEnum.Multiline);
    }

    public boolean isPassword() {
        return this.getFlags().contains((Object)Field.FlagsEnum.Password);
    }

    public boolean isSpellChecked() {
        return !this.getFlags().contains((Object)Field.FlagsEnum.DoNotSpellCheck);
    }

    public void setMaxLength(int value) {
        throw new NotImplementedException();
    }

    public void setMultiline(boolean value) {
        EnumSet<Field.FlagsEnum> flags = this.getFlags();
        if (value) {
            flags.add(Field.FlagsEnum.Multiline);
        } else {
            flags.remove((Object)Field.FlagsEnum.Multiline);
        }
        this.setFlags(flags);
    }

    public void setPassword(boolean value) {
        EnumSet<Field.FlagsEnum> flags = this.getFlags();
        if (value) {
            flags.add(Field.FlagsEnum.Password);
        } else {
            flags.remove((Object)Field.FlagsEnum.Password);
        }
        this.setFlags(flags);
    }

    public void setSpellChecked(boolean value) {
        EnumSet<Field.FlagsEnum> flags = this.getFlags();
        if (value) {
            flags.remove((Object)Field.FlagsEnum.DoNotSpellCheck);
        } else {
            flags.add(Field.FlagsEnum.DoNotSpellCheck);
        }
        this.setFlags(flags);
    }

    @Override
    public void setValue(Object value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.V, new PdfTextString((String)value));
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.DV, new PdfTextString((String)value));
    }
}

