/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.interaction.forms;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.interaction.annotations.DualWidget;
import it.stefanochizzolini.clown.documents.interaction.annotations.Widget;
import it.stefanochizzolini.clown.documents.interaction.forms.CheckBox;
import it.stefanochizzolini.clown.documents.interaction.forms.Field;
import it.stefanochizzolini.clown.documents.interaction.forms.RadioButton;
import it.stefanochizzolini.clown.files.File;
import it.stefanochizzolini.clown.objects.PdfArray;
import it.stefanochizzolini.clown.objects.PdfDataObject;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfIndirectObject;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfObjectWrapper;
import it.stefanochizzolini.clown.objects.PdfReference;
import it.stefanochizzolini.clown.util.NotImplementedException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class FieldWidgets
extends PdfObjectWrapper<PdfDataObject>
implements List<Widget> {
    private Field field;
    private boolean isDual;

    FieldWidgets(PdfDirectObject baseObject, PdfIndirectObject container, Field field) {
        super(baseObject, container);
        this.field = field;
        this.isDual = field instanceof CheckBox || field instanceof RadioButton;
    }

    @Override
    public FieldWidgets clone(Document context) {
        throw new NotImplementedException();
    }

    public Field getField() {
        return this.field;
    }

    @Override
    public void add(int index, Widget value) {
        this.ensureArray().add(index, value.getBaseObject());
    }

    @Override
    public boolean addAll(int index, Collection<? extends Widget> values) {
        PdfArray items = this.ensureArray();
        for (Widget widget : values) {
            items.add(index++, widget.getBaseObject());
        }
        return true;
    }

    @Override
    public Widget get(int index) {
        Object baseDataObject = this.getBaseDataObject();
        if (baseDataObject instanceof PdfDictionary) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: 1");
            }
            return this.newWidget(this.getBaseObject());
        }
        return this.newWidget(((PdfArray)baseDataObject).get(index));
    }

    @Override
    public int indexOf(Object value) {
        if (!(value instanceof Widget)) {
            return -1;
        }
        Object baseDataObject = this.getBaseDataObject();
        if (baseDataObject instanceof PdfDictionary) {
            if (((Widget)value).getBaseObject().equals(this.getBaseObject())) {
                return 0;
            }
            return -1;
        }
        return ((PdfArray)baseDataObject).indexOf(((Widget)value).getBaseObject());
    }

    @Override
    public int lastIndexOf(Object value) {
        return this.indexOf(value);
    }

    @Override
    public ListIterator<Widget> listIterator() {
        throw new NotImplementedException();
    }

    @Override
    public ListIterator<Widget> listIterator(int index) {
        throw new NotImplementedException();
    }

    @Override
    public Widget remove(int index) {
        PdfDirectObject widgetObject = this.ensureArray().remove(index);
        return this.newWidget(widgetObject);
    }

    @Override
    public Widget set(int index, Widget value) {
        return this.newWidget(this.ensureArray().set(index, value.getBaseObject()));
    }

    @Override
    public List<Widget> subList(int fromIndex, int toIndex) {
        throw new NotImplementedException();
    }

    @Override
    public boolean add(Widget value) {
        ((PdfDictionary)value.getBaseDataObject()).put(PdfName.Parent, this.field.getBaseObject());
        return this.ensureArray().add(value.getBaseObject());
    }

    @Override
    public boolean addAll(Collection<? extends Widget> values) {
        for (Widget widget : values) {
            this.add(widget);
        }
        return true;
    }

    @Override
    public void clear() {
        this.ensureArray().clear();
    }

    @Override
    public boolean contains(Object value) {
        if (!(value instanceof Widget)) {
            return false;
        }
        Object baseDataObject = this.getBaseDataObject();
        if (baseDataObject instanceof PdfDictionary) {
            return ((Widget)value).getBaseObject().equals(this.getBaseObject());
        }
        return ((PdfArray)baseDataObject).contains(((Widget)value).getBaseObject());
    }

    @Override
    public boolean containsAll(Collection<?> values) {
        throw new NotImplementedException();
    }

    @Override
    public boolean equals(Object object) {
        throw new NotImplementedException();
    }

    @Override
    public int hashCode() {
        throw new NotImplementedException();
    }

    @Override
    public boolean isEmpty() {
        Object baseDataObject = this.getBaseDataObject();
        if (baseDataObject instanceof PdfDictionary) {
            return false;
        }
        return ((PdfArray)baseDataObject).isEmpty();
    }

    @Override
    public boolean remove(Object value) {
        if (!(value instanceof Widget)) {
            return false;
        }
        return this.ensureArray().remove(((Widget)value).getBaseObject());
    }

    @Override
    public boolean removeAll(Collection<?> values) {
        throw new NotImplementedException();
    }

    @Override
    public boolean retainAll(Collection<?> values) {
        throw new NotImplementedException();
    }

    @Override
    public int size() {
        Object baseDataObject = this.getBaseDataObject();
        if (baseDataObject instanceof PdfDictionary) {
            return 1;
        }
        return ((PdfArray)baseDataObject).size();
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Widget[0]);
    }

    @Override
    public <T> T[] toArray(T[] values) {
        Object baseDataObject = this.getBaseDataObject();
        if (baseDataObject instanceof PdfDictionary) {
            if (values.length == 0) {
                values = new Object[]{this.newWidget(this.getBaseObject())};
            }
        } else {
            PdfArray widgetObjects = (PdfArray)baseDataObject;
            if (values.length < widgetObjects.size()) {
                values = new Object[widgetObjects.size()];
            }
            int index = 0;
            int length = widgetObjects.size();
            while (index < length) {
                values[index] = this.newWidget(widgetObjects.get(index));
                ++index;
            }
        }
        return values;
    }

    @Override
    public Iterator<Widget> iterator() {
        return new Iterator<Widget>(){
            private int index = 0;
            private int size;
            {
                this.size = FieldWidgets.this.size();
            }

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public Widget next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return FieldWidgets.this.get(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private PdfArray ensureArray() {
        Object baseDataObject = this.getBaseDataObject();
        if (baseDataObject instanceof PdfDictionary) {
            PdfArray widgetsArray = new PdfArray();
            PdfDictionary fieldDictionary = (PdfDictionary)baseDataObject;
            PdfDictionary widgetDictionary = null;
            for (PdfName key : new HashMap<PdfName, PdfDirectObject>(fieldDictionary).keySet()) {
                if (!key.equals(PdfName.Type) && !key.equals(PdfName.Subtype) && !key.equals(PdfName.Rect) && !key.equals(PdfName.Contents) && !key.equals(PdfName.P) && !key.equals(PdfName.NM) && !key.equals(PdfName.M) && !key.equals(PdfName.F) && !key.equals(PdfName.BS) && !key.equals(PdfName.AP) && !key.equals(PdfName.AS) && !key.equals(PdfName.Border) && !key.equals(PdfName.C) && !key.equals(PdfName.A) && !key.equals(PdfName.AA) && !key.equals(PdfName.StructParent) && !key.equals(PdfName.OC) && !key.equals(PdfName.H) && !key.equals(PdfName.MK)) continue;
                if (widgetDictionary == null) {
                    widgetDictionary = new PdfDictionary();
                    PdfReference widgetReference = this.getFile().register(widgetDictionary);
                    PdfArray pageAnnotationsArray = (PdfArray)File.resolve(((PdfDictionary)File.resolve(fieldDictionary.get(PdfName.P))).get(PdfName.Annots));
                    pageAnnotationsArray.remove(this.field.getBaseObject());
                    pageAnnotationsArray.add(widgetReference);
                    widgetsArray.add(widgetReference);
                    widgetDictionary.put(PdfName.Parent, this.field.getBaseObject());
                }
                widgetDictionary.put(key, fieldDictionary.get(key));
                fieldDictionary.remove(key);
            }
            this.setBaseObject(widgetsArray);
            ((PdfDictionary)this.field.getBaseDataObject()).put(PdfName.Kids, widgetsArray);
            baseDataObject = widgetsArray;
        }
        return (PdfArray)baseDataObject;
    }

    private Widget newWidget(PdfDirectObject baseObject) {
        if (this.isDual) {
            return new DualWidget(baseObject, this.getContainer());
        }
        return new Widget(baseObject, this.getContainer());
    }
}

