/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.interaction.annotations;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.Page;
import it.stefanochizzolini.clown.documents.interaction.annotations.Annotation;
import it.stefanochizzolini.clown.objects.IPdfNumber;
import it.stefanochizzolini.clown.objects.PdfArray;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfIndirectObject;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfReal;
import it.stefanochizzolini.clown.util.NotImplementedException;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class TextMarkup
extends Annotation {
    public TextMarkup(Page page, Rectangle2D box, MarkupTypeEnum type) {
        super(page.getDocument(), type.getCode(), box, page);
    }

    public TextMarkup(PdfDirectObject baseObject, PdfIndirectObject container) {
        super(baseObject, container);
    }

    @Override
    public TextMarkup clone(Document context) {
        throw new NotImplementedException();
    }

    public List<Rectangle2D> getBoxes() {
        PdfArray quadPointsObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.QuadPoints);
        ArrayList<Rectangle2D> boxes = new ArrayList<Rectangle2D>();
        double pageHeight = this.getPage().getBox().getHeight();
        int index = 0;
        int length = quadPointsObject.size();
        while (index < length) {
            double x = ((IPdfNumber)((Object)quadPointsObject.get(index + 6))).getNumberValue();
            double y = pageHeight - ((IPdfNumber)((Object)quadPointsObject.get(index + 7))).getNumberValue();
            double width = ((IPdfNumber)((Object)quadPointsObject.get(index + 2))).getNumberValue() - ((IPdfNumber)((Object)quadPointsObject.get(index))).getNumberValue();
            double height = ((IPdfNumber)((Object)quadPointsObject.get(index + 3))).getNumberValue() - ((IPdfNumber)((Object)quadPointsObject.get(index + 1))).getNumberValue();
            boxes.add(new Rectangle2D.Double(x, y, width, height));
            index += 8;
        }
        return boxes;
    }

    public MarkupTypeEnum getMarkupType() {
        return MarkupTypeEnum.get((PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Subtype));
    }

    public void setBoxes(List<Rectangle2D> value) {
        PdfArray quadPointsObject = new PdfArray();
        double pageHeight = this.getPage().getBox().getHeight();
        for (Rectangle2D box : value) {
            quadPointsObject.add(new PdfReal(box.getX()));
            quadPointsObject.add(new PdfReal(pageHeight - (box.getY() + box.getHeight())));
            quadPointsObject.add(new PdfReal(box.getX() + box.getWidth()));
            quadPointsObject.add(quadPointsObject.get(1));
            quadPointsObject.add(quadPointsObject.get(2));
            quadPointsObject.add(new PdfReal(pageHeight - box.getY()));
            quadPointsObject.add(quadPointsObject.get(0));
            quadPointsObject.add(quadPointsObject.get(5));
        }
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.QuadPoints, quadPointsObject);
    }

    public void setMarkupType(MarkupTypeEnum value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Subtype, value.getCode());
    }

    public static enum MarkupTypeEnum {
        Highlight(PdfName.Highlight),
        Squiggly(PdfName.Squiggly),
        StrikeOut(PdfName.StrikeOut),
        Underline(PdfName.Underline);

        private final PdfName code;

        public static MarkupTypeEnum get(PdfName value) {
            MarkupTypeEnum[] markupTypeEnumArray = MarkupTypeEnum.values();
            int n = markupTypeEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                MarkupTypeEnum markupType = markupTypeEnumArray[n2];
                if (markupType.getCode().equals(value)) {
                    return markupType;
                }
                ++n2;
            }
            return null;
        }

        private MarkupTypeEnum(PdfName code) {
            this.code = code;
        }

        public PdfName getCode() {
            return this.code;
        }
    }
}

