/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.interaction.annotations;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.Page;
import it.stefanochizzolini.clown.documents.interaction.annotations.Annotation;
import it.stefanochizzolini.clown.documents.multimedia.Sound;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfIndirectObject;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.util.NotImplementedException;
import java.awt.geom.Rectangle2D;

public class SoundAnnotation
extends Annotation {
    public SoundAnnotation(Page page, Rectangle2D box, Sound sound) {
        super(page.getDocument(), PdfName.Sound, box, page);
        this.setSound(sound);
    }

    public SoundAnnotation(PdfDirectObject baseObject, PdfIndirectObject container) {
        super(baseObject, container);
    }

    @Override
    public SoundAnnotation clone(Document context) {
        throw new NotImplementedException();
    }

    public IconTypeEnum getIconType() {
        PdfName nameObject = (PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Name);
        if (nameObject == null) {
            return IconTypeEnum.Speaker;
        }
        return IconTypeEnum.get(nameObject);
    }

    public Sound getSound() {
        return new Sound(((PdfDictionary)this.getBaseDataObject()).get(PdfName.Sound));
    }

    public void setIconType(IconTypeEnum value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Name, value.getCode());
    }

    public void setSound(Sound value) {
        if (value == null) {
            throw new IllegalArgumentException("Sound MUST be defined.");
        }
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Sound, value.getBaseObject());
    }

    public static enum IconTypeEnum {
        Speaker(PdfName.Speaker),
        Microphone(PdfName.Mic);

        private final PdfName code;

        public static IconTypeEnum get(PdfName value) {
            IconTypeEnum[] iconTypeEnumArray = IconTypeEnum.values();
            int n = iconTypeEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                IconTypeEnum iconType = iconTypeEnumArray[n2];
                if (iconType.getCode().equals(value)) {
                    return iconType;
                }
                ++n2;
            }
            return null;
        }

        private IconTypeEnum(PdfName code) {
            this.code = code;
        }

        public PdfName getCode() {
            return this.code;
        }
    }
}

