/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.interaction.annotations;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.Page;
import it.stefanochizzolini.clown.documents.interaction.annotations.Annotation;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfIndirectObject;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.util.NotImplementedException;
import java.awt.geom.Rectangle2D;

public class RubberStamp
extends Annotation {
    public RubberStamp(Page page, Rectangle2D box, IconTypeEnum iconType) {
        super(page.getDocument(), PdfName.Stamp, box, page);
        this.setIconType(iconType);
    }

    public RubberStamp(PdfDirectObject baseObject, PdfIndirectObject container) {
        super(baseObject, container);
    }

    @Override
    public RubberStamp clone(Document context) {
        throw new NotImplementedException();
    }

    public IconTypeEnum getIconType() {
        PdfName nameObject = (PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Name);
        if (nameObject == null) {
            return IconTypeEnum.Draft;
        }
        return IconTypeEnum.get(nameObject);
    }

    public void setIconType(IconTypeEnum value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Name, value.getCode());
    }

    public static enum IconTypeEnum {
        Approved(PdfName.Approved),
        AsIs(PdfName.AsIs),
        Confidential(PdfName.Confidential),
        Departmental(PdfName.Departmental),
        Draft(PdfName.Draft),
        Experimental(PdfName.Experimental),
        Expired(PdfName.Expired),
        Final(PdfName.Final),
        ForComment(PdfName.ForComment),
        ForPublicRelease(PdfName.ForPublicRelease),
        NotApproved(PdfName.NotApproved),
        NotForPublicRelease(PdfName.NotForPublicRelease),
        Sold(PdfName.Sold),
        TopSecret(PdfName.TopSecret);

        private final PdfName code;

        public static IconTypeEnum get(PdfName value) {
            IconTypeEnum[] iconTypeEnumArray = IconTypeEnum.values();
            int n = iconTypeEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                IconTypeEnum iconType = iconTypeEnumArray[n2];
                if (iconType.getCode().equals(value)) {
                    return iconType;
                }
                ++n2;
            }
            return null;
        }

        private IconTypeEnum(PdfName code) {
            this.code = code;
        }

        public PdfName getCode() {
            return this.code;
        }
    }
}

