/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.interaction.annotations;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.Page;
import it.stefanochizzolini.clown.documents.interaction.annotations.Annotation;
import it.stefanochizzolini.clown.objects.PdfBoolean;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfIndirectObject;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.util.NotImplementedException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Note
extends Annotation {
    public Note(Page page, Point2D location, String text) {
        super(page.getDocument(), PdfName.Text, new Rectangle2D.Double(location.getX(), location.getY(), 0.0, 0.0), page);
        this.setText(text);
    }

    public Note(PdfDirectObject baseObject, PdfIndirectObject container) {
        super(baseObject, container);
    }

    @Override
    public Note clone(Document context) {
        throw new NotImplementedException();
    }

    public IconTypeEnum getIconType() {
        PdfName nameObject = (PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Name);
        if (nameObject == null) {
            return IconTypeEnum.Note;
        }
        return IconTypeEnum.get(nameObject);
    }

    public boolean isOpen() {
        PdfBoolean openObject = (PdfBoolean)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Open);
        if (openObject == null) {
            return false;
        }
        return (Boolean)openObject.getValue();
    }

    public void setIconType(IconTypeEnum value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Name, value.getCode());
    }

    public void setOpen(boolean value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Open, new PdfBoolean(value));
    }

    public static enum IconTypeEnum {
        Comment(PdfName.Comment),
        Help(PdfName.Help),
        Insert(PdfName.Insert),
        Key(PdfName.Key),
        NewParagraph(PdfName.NewParagraph),
        Note(PdfName.Note),
        Paragraph(PdfName.Paragraph);

        private final PdfName code;

        public static IconTypeEnum get(PdfName value) {
            IconTypeEnum[] iconTypeEnumArray = IconTypeEnum.values();
            int n = iconTypeEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                IconTypeEnum iconType = iconTypeEnumArray[n2];
                if (iconType.getCode().equals(value)) {
                    return iconType;
                }
                ++n2;
            }
            return null;
        }

        private IconTypeEnum(PdfName code) {
            this.code = code;
        }

        public PdfName getCode() {
            return this.code;
        }
    }
}

