/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.interaction.annotations;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.Page;
import it.stefanochizzolini.clown.documents.interaction.ILink;
import it.stefanochizzolini.clown.documents.interaction.actions.Action;
import it.stefanochizzolini.clown.documents.interaction.annotations.Annotation;
import it.stefanochizzolini.clown.documents.interaction.annotations.AnnotationActions;
import it.stefanochizzolini.clown.documents.interaction.navigation.document.Destination;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfIndirectObject;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfObjectWrapper;
import it.stefanochizzolini.clown.util.NotImplementedException;
import java.awt.geom.Rectangle2D;

public class Link
extends Annotation
implements ILink {
    public Link(Page page, Rectangle2D box, Destination destination) {
        this(page, box);
        this.setDestination(destination);
    }

    public Link(Page page, Rectangle2D box, Action action) {
        this(page, box);
        AnnotationActions actions = new AnnotationActions(this);
        actions.setOnActivate(action);
        this.setActions(actions);
    }

    public Link(PdfDirectObject baseObject, PdfIndirectObject container) {
        super(baseObject, container);
    }

    private Link(Page page, Rectangle2D box) {
        super(page.getDocument(), PdfName.Link, box, page);
    }

    @Override
    public Link clone(Document context) {
        throw new NotImplementedException();
    }

    @Override
    public Destination getDestination() {
        PdfDirectObject destinationObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.Dest);
        if (destinationObject == null) {
            return null;
        }
        return Document.resolveName(Destination.class, destinationObject, this.getContainer());
    }

    @Override
    public PdfObjectWrapper<?> getTarget() {
        if (((PdfDictionary)this.getBaseDataObject()).containsKey(PdfName.Dest)) {
            return this.getDestination();
        }
        if (((PdfDictionary)this.getBaseDataObject()).containsKey(PdfName.A)) {
            return this.getAction();
        }
        return null;
    }

    @Override
    public void setAction(Action value) {
        if (((PdfDictionary)this.getBaseDataObject()).containsKey(PdfName.Dest) && value != null) {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.Dest);
        }
        super.setAction(value);
    }

    @Override
    public void setDestination(Destination value) {
        if (value == null) {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.Dest);
        } else {
            if (((PdfDictionary)this.getBaseDataObject()).containsKey(PdfName.A)) {
                ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.A);
            }
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Dest, value.getNamedBaseObject());
        }
    }

    @Override
    public void setTarget(PdfObjectWrapper<?> value) {
        if (value instanceof Destination) {
            this.setDestination((Destination)value);
        } else if (value instanceof Action) {
            this.setAction((Action)value);
        } else {
            throw new IllegalArgumentException("It MUST be either a Destination or an Action.");
        }
    }
}

