/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.interaction.annotations;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.Page;
import it.stefanochizzolini.clown.documents.contents.colorSpaces.DeviceRGBColor;
import it.stefanochizzolini.clown.documents.interaction.annotations.Annotation;
import it.stefanochizzolini.clown.objects.IPdfNumber;
import it.stefanochizzolini.clown.objects.PdfArray;
import it.stefanochizzolini.clown.objects.PdfBoolean;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfIndirectObject;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfReal;
import it.stefanochizzolini.clown.util.NotImplementedException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Line
extends Annotation {
    private static final double DefaultLeaderLineExtensionLength = 0.0;
    private static final double DefaultLeaderLineLength = 0.0;
    private static final LineEndStyleEnum DefaultLineEndStyle = LineEndStyleEnum.None;

    public Line(Page page, Point2D startPoint, Point2D endPoint) {
        super(page.getDocument(), PdfName.Line, new Rectangle2D.Double(startPoint.getX(), startPoint.getY(), endPoint.getX() - startPoint.getX(), endPoint.getY() - startPoint.getY()), page);
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.L, new PdfArray(new PdfReal(0.0), new PdfReal(0.0), new PdfReal(0.0), new PdfReal(0.0)));
        this.setStartPoint(startPoint);
        this.setEndPoint(endPoint);
    }

    public Line(PdfDirectObject baseObject, PdfIndirectObject container) {
        super(baseObject, container);
    }

    @Override
    public Line clone(Document context) {
        throw new NotImplementedException();
    }

    public Point2D getEndPoint() {
        PdfArray coordinatesObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.L);
        return new Point2D.Double(((IPdfNumber)((Object)coordinatesObject.get(2))).getNumberValue(), ((IPdfNumber)((Object)coordinatesObject.get(3))).getNumberValue());
    }

    public LineEndStyleEnum getEndStyle() {
        PdfArray endstylesObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.LE);
        if (endstylesObject == null) {
            return DefaultLineEndStyle;
        }
        return LineEndStyleEnum.get((PdfName)endstylesObject.get(1));
    }

    public DeviceRGBColor getFillColor() {
        PdfArray fillColorObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.IC);
        if (fillColorObject == null) {
            return null;
        }
        return new DeviceRGBColor(((IPdfNumber)((Object)fillColorObject.get(0))).getNumberValue(), ((IPdfNumber)((Object)fillColorObject.get(1))).getNumberValue(), ((IPdfNumber)((Object)fillColorObject.get(2))).getNumberValue());
    }

    public double getLeaderLineExtensionLength() {
        IPdfNumber leaderLineExtensionLengthObject = (IPdfNumber)((Object)((PdfDictionary)this.getBaseDataObject()).get(PdfName.LLE));
        if (leaderLineExtensionLengthObject == null) {
            return 0.0;
        }
        return leaderLineExtensionLengthObject.getNumberValue();
    }

    public double getLeaderLineLength() {
        IPdfNumber leaderLineLengthObject = (IPdfNumber)((Object)((PdfDictionary)this.getBaseDataObject()).get(PdfName.LL));
        if (leaderLineLengthObject == null) {
            return 0.0;
        }
        return -leaderLineLengthObject.getNumberValue();
    }

    public Point2D getStartPoint() {
        PdfArray coordinatesObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.L);
        return new Point2D.Double(((IPdfNumber)((Object)coordinatesObject.get(0))).getNumberValue(), ((IPdfNumber)((Object)coordinatesObject.get(1))).getNumberValue());
    }

    public LineEndStyleEnum getStartStyle() {
        PdfArray endstylesObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.LE);
        if (endstylesObject == null) {
            return DefaultLineEndStyle;
        }
        return LineEndStyleEnum.get((PdfName)endstylesObject.get(0));
    }

    public boolean isCaptionVisible() {
        PdfBoolean captionVisibleObject = (PdfBoolean)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Cap);
        if (captionVisibleObject == null) {
            return false;
        }
        return (Boolean)captionVisibleObject.getValue();
    }

    public void setCaptionVisible(boolean value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Cap, new PdfBoolean(value));
    }

    public void setEndPoint(Point2D value) {
        PdfArray coordinatesObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.L);
        coordinatesObject.set(2, new PdfReal(value.getX()));
        coordinatesObject.set(3, new PdfReal(this.getPage().getBox().getHeight() - value.getY()));
    }

    public void setEndStyle(LineEndStyleEnum value) {
        this.ensureLineEndStylesObject().set(1, value.getCode());
    }

    public void setFillColor(DeviceRGBColor value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.IC, new PdfArray(new PdfReal(value.getRedComponent()), new PdfReal(value.getGreenComponent()), new PdfReal(value.getBlueComponent())));
    }

    public void setLeaderLineExtensionLength(double value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.LLE, new PdfReal(value));
        if (!((PdfDictionary)this.getBaseDataObject()).containsKey(PdfName.LL)) {
            this.setLeaderLineLength(0.0);
        }
    }

    public void setLeaderLineLength(double value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.LL, new PdfReal(-value));
    }

    public void setStartPoint(Point2D value) {
        PdfArray coordinatesObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.L);
        coordinatesObject.set(0, new PdfReal(value.getX()));
        coordinatesObject.set(1, new PdfReal(this.getPage().getBox().getHeight() - value.getY()));
    }

    public void setStartStyle(LineEndStyleEnum value) {
        this.ensureLineEndStylesObject().set(0, value.getCode());
    }

    private PdfArray ensureLineEndStylesObject() {
        PdfArray endStylesObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.LE);
        if (endStylesObject == null) {
            endStylesObject = new PdfArray(DefaultLineEndStyle.getCode(), DefaultLineEndStyle.getCode());
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.LE, endStylesObject);
        }
        return endStylesObject;
    }

    public static enum LineEndStyleEnum {
        Square(PdfName.Square),
        Circle(PdfName.Circle),
        Diamond(PdfName.Diamond),
        OpenArrow(PdfName.OpenArrow),
        ClosedArrow(PdfName.ClosedArrow),
        None(PdfName.None),
        Butt(PdfName.Butt),
        ReverseOpenArrow(PdfName.ROpenArrow),
        ReverseClosedArrow(PdfName.RClosedArrow),
        Slash(PdfName.Slash);

        private final PdfName code;

        public static LineEndStyleEnum get(PdfName value) {
            LineEndStyleEnum[] lineEndStyleEnumArray = LineEndStyleEnum.values();
            int n = lineEndStyleEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                LineEndStyleEnum style = lineEndStyleEnumArray[n2];
                if (style.getCode().equals(value)) {
                    return style;
                }
                ++n2;
            }
            return null;
        }

        private LineEndStyleEnum(PdfName code) {
            this.code = code;
        }

        public PdfName getCode() {
            return this.code;
        }
    }
}

