/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.interaction.annotations;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.Page;
import it.stefanochizzolini.clown.documents.interaction.annotations.Annotation;
import it.stefanochizzolini.clown.objects.IPdfNumber;
import it.stefanochizzolini.clown.objects.PdfArray;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfIndirectObject;
import it.stefanochizzolini.clown.objects.PdfInteger;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfObjectWrapper;
import it.stefanochizzolini.clown.objects.PdfReal;
import it.stefanochizzolini.clown.util.NotImplementedException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class CalloutNote
extends Annotation {
    public CalloutNote(Page page, Rectangle2D box, String text) {
        super(page.getDocument(), PdfName.FreeText, box, page);
        this.setText(text);
    }

    public CalloutNote(PdfDirectObject baseObject, PdfIndirectObject container) {
        super(baseObject, container);
    }

    @Override
    public CalloutNote clone(Document context) {
        throw new NotImplementedException();
    }

    public JustificationEnum getJustification() {
        PdfInteger justificationObject = (PdfInteger)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Q);
        if (justificationObject == null) {
            return JustificationEnum.Left;
        }
        return JustificationEnum.get(justificationObject);
    }

    public LineObject getLine() {
        PdfArray calloutLineObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.CL);
        if (calloutLineObject == null) {
            return null;
        }
        return new LineObject(calloutLineObject, this.getContainer());
    }

    public void setJustification(JustificationEnum value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Q, value.getCode());
    }

    public void setLine(LineObject value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.CL, value.getBaseObject());
    }

    public static enum JustificationEnum {
        Left(new PdfInteger(0)),
        Center(new PdfInteger(1)),
        Right(new PdfInteger(2));

        private final PdfInteger code;

        public static JustificationEnum get(PdfInteger value) {
            JustificationEnum[] justificationEnumArray = JustificationEnum.values();
            int n = justificationEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                JustificationEnum justification = justificationEnumArray[n2];
                if (justification.getCode().equals(value)) {
                    return justification;
                }
                ++n2;
            }
            return null;
        }

        private JustificationEnum(PdfInteger code) {
            this.code = code;
        }

        public PdfInteger getCode() {
            return this.code;
        }
    }

    public static class LineObject
    extends PdfObjectWrapper<PdfArray> {
        private Page page;

        public LineObject(Page page, Point2D start, Point2D end) {
            super(page.getFile(), new PdfArray());
            this.page = page;
            PdfArray baseDataObject = (PdfArray)this.getBaseDataObject();
            double pageHeight = page.getBox().getHeight();
            baseDataObject.add(new PdfReal(start.getX()));
            baseDataObject.add(new PdfReal(pageHeight - start.getY()));
            baseDataObject.add(new PdfReal(end.getX()));
            baseDataObject.add(new PdfReal(pageHeight - end.getY()));
        }

        public LineObject(Page page, Point2D start, Point2D knee, Point2D end) {
            super(page.getFile(), new PdfArray());
            this.page = page;
            PdfArray baseDataObject = (PdfArray)this.getBaseDataObject();
            double pageHeight = page.getBox().getHeight();
            baseDataObject.add(new PdfReal(start.getX()));
            baseDataObject.add(new PdfReal(pageHeight - start.getY()));
            baseDataObject.add(new PdfReal(knee.getX()));
            baseDataObject.add(new PdfReal(pageHeight - knee.getY()));
            baseDataObject.add(new PdfReal(end.getX()));
            baseDataObject.add(new PdfReal(pageHeight - end.getY()));
        }

        private LineObject(PdfDirectObject baseObject, PdfIndirectObject container) {
            super(baseObject, container);
        }

        @Override
        public LineObject clone(Document context) {
            throw new NotImplementedException();
        }

        public Point2D getEnd() {
            PdfArray coordinates = (PdfArray)this.getBaseDataObject();
            if (coordinates.size() < 6) {
                return new Point2D.Double(((IPdfNumber)((Object)coordinates.get(2))).getNumberValue(), this.page.getBox().getHeight() - ((IPdfNumber)((Object)coordinates.get(3))).getNumberValue());
            }
            return new Point2D.Double(((IPdfNumber)((Object)coordinates.get(4))).getNumberValue(), this.page.getBox().getHeight() - ((IPdfNumber)((Object)coordinates.get(5))).getNumberValue());
        }

        public Point2D getKnee() {
            PdfArray coordinates = (PdfArray)this.getBaseDataObject();
            if (coordinates.size() < 6) {
                return null;
            }
            return new Point2D.Double(((IPdfNumber)((Object)coordinates.get(2))).getNumberValue(), this.page.getBox().getHeight() - ((IPdfNumber)((Object)coordinates.get(3))).getNumberValue());
        }

        public Point2D getStart() {
            PdfArray coordinates = (PdfArray)this.getBaseDataObject();
            return new Point2D.Double(((IPdfNumber)((Object)coordinates.get(0))).getNumberValue(), this.page.getBox().getHeight() - ((IPdfNumber)((Object)coordinates.get(1))).getNumberValue());
        }
    }
}

