/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.interaction.annotations;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.contents.LineDash;
import it.stefanochizzolini.clown.objects.IPdfNumber;
import it.stefanochizzolini.clown.objects.PdfArray;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfIndirectObject;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfObjectWrapper;
import it.stefanochizzolini.clown.objects.PdfReal;
import it.stefanochizzolini.clown.util.NotImplementedException;

public class Border
extends PdfObjectWrapper<PdfDictionary> {
    private static final LineDash DefaultLineDash = new LineDash(new double[]{3.0});
    private static final StyleEnum DefaultStyle = StyleEnum.Solid;
    private static final double DefaultWidth = 1.0;

    public Border(Document context) {
        super(context.getFile(), new PdfDictionary());
    }

    public Border(Document context, double width, StyleEnum style, LineDash pattern) {
        this(context);
        this.setWidth(width);
        this.setStyle(style);
        this.setPattern(pattern);
    }

    public Border(PdfDirectObject baseObject, PdfIndirectObject container) {
        super(baseObject, container);
    }

    @Override
    public Border clone(Document context) {
        throw new NotImplementedException();
    }

    public LineDash getPattern() {
        PdfArray dashObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.D);
        if (dashObject == null) {
            return DefaultLineDash;
        }
        double[] dashArray = new double[dashObject.size()];
        int dashIndex = 0;
        int dashLength = dashArray.length;
        while (dashIndex < dashLength) {
            dashArray[dashIndex] = ((IPdfNumber)((Object)dashObject.get(dashIndex))).getNumberValue();
            ++dashIndex;
        }
        return new LineDash(dashArray);
    }

    public StyleEnum getStyle() {
        PdfName styleObject = (PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.S);
        if (styleObject == null) {
            return DefaultStyle;
        }
        return StyleEnum.get(styleObject);
    }

    public double getWidth() {
        IPdfNumber widthObject = (IPdfNumber)((Object)((PdfDictionary)this.getBaseDataObject()).get(PdfName.W));
        if (widthObject == null) {
            return 1.0;
        }
        return widthObject.getNumberValue();
    }

    public void setPattern(LineDash value) {
        if (value == null) {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.D);
        } else {
            PdfArray dashObject = new PdfArray();
            double[] dashArray = value.getDashArray();
            int dashIndex = 0;
            int dashLength = dashArray.length;
            while (dashIndex < dashLength) {
                dashObject.add(new PdfReal(dashArray[dashIndex]));
                ++dashIndex;
            }
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.D, dashObject);
        }
    }

    public void setStyle(StyleEnum value) {
        if (value == null || value == DefaultStyle) {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.S);
        } else {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.S, value.getCode());
        }
    }

    public void setWidth(double value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.W, new PdfReal(value));
    }

    public static enum StyleEnum {
        Solid(PdfName.S),
        Dashed(PdfName.D),
        Beveled(PdfName.B),
        Inset(PdfName.I),
        Underline(PdfName.U);

        private final PdfName code;

        public static StyleEnum get(PdfName value) {
            StyleEnum[] styleEnumArray = StyleEnum.values();
            int n = styleEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                StyleEnum style = styleEnumArray[n2];
                if (style.getCode().equals(value)) {
                    return style;
                }
                ++n2;
            }
            return null;
        }

        private StyleEnum(PdfName code) {
            this.code = code;
        }

        public PdfName getCode() {
            return this.code;
        }
    }
}

