/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.interaction.annotations;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.contents.colorSpaces.Color;
import it.stefanochizzolini.clown.documents.contents.colorSpaces.DeviceCMYKColor;
import it.stefanochizzolini.clown.documents.contents.colorSpaces.DeviceGrayColor;
import it.stefanochizzolini.clown.documents.contents.colorSpaces.DeviceRGBColor;
import it.stefanochizzolini.clown.documents.contents.composition.AlignmentXEnum;
import it.stefanochizzolini.clown.documents.contents.composition.AlignmentYEnum;
import it.stefanochizzolini.clown.documents.contents.xObjects.FormXObject;
import it.stefanochizzolini.clown.objects.IPdfNumber;
import it.stefanochizzolini.clown.objects.PdfArray;
import it.stefanochizzolini.clown.objects.PdfBoolean;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfIndirectObject;
import it.stefanochizzolini.clown.objects.PdfInteger;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfObjectWrapper;
import it.stefanochizzolini.clown.objects.PdfReal;
import it.stefanochizzolini.clown.objects.PdfReference;
import it.stefanochizzolini.clown.objects.PdfTextString;
import it.stefanochizzolini.clown.util.NotImplementedException;

public class AppearanceCharacteristics
extends PdfObjectWrapper<PdfDictionary> {
    public AppearanceCharacteristics(Document context) {
        super(context.getFile(), new PdfDictionary());
    }

    public AppearanceCharacteristics(PdfDirectObject baseObject, PdfIndirectObject container) {
        super(baseObject, container);
    }

    @Override
    public AppearanceCharacteristics clone(Document context) {
        throw new NotImplementedException();
    }

    public String getAlternateCaption() {
        PdfTextString alternateCaptionObject = (PdfTextString)((PdfDictionary)this.getBaseDataObject()).get(PdfName.AC);
        if (alternateCaptionObject == null) {
            return null;
        }
        return (String)alternateCaptionObject.getValue();
    }

    public FormXObject getAlternateIcon() {
        PdfReference alternateIconObject = (PdfReference)((PdfDictionary)this.getBaseDataObject()).get(PdfName.IX);
        if (alternateIconObject == null) {
            return null;
        }
        return new FormXObject(alternateIconObject);
    }

    public Color getBackgroundColor() {
        return this.getColor(PdfName.BG);
    }

    public Color getBorderColor() {
        return this.getColor(PdfName.BC);
    }

    public CaptionPositionEnum getCaptionPosition() {
        PdfInteger captionPositionObject = (PdfInteger)((PdfDictionary)this.getBaseDataObject()).get(PdfName.TP);
        if (captionPositionObject == null) {
            return CaptionPositionEnum.CaptionOnly;
        }
        return CaptionPositionEnum.get((Integer)captionPositionObject.getRawValue());
    }

    public IconFitObject getIconFit() {
        PdfDirectObject iconFitObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.IF);
        if (iconFitObject == null) {
            return null;
        }
        return new IconFitObject(iconFitObject, this.getContainer());
    }

    public String getNormalCaption() {
        PdfTextString normalCaptionObject = (PdfTextString)((PdfDictionary)this.getBaseDataObject()).get(PdfName.CA);
        if (normalCaptionObject == null) {
            return null;
        }
        return (String)normalCaptionObject.getValue();
    }

    public FormXObject getNormalIcon() {
        PdfReference normalIconObject = (PdfReference)((PdfDictionary)this.getBaseDataObject()).get(PdfName.I);
        if (normalIconObject == null) {
            return null;
        }
        return new FormXObject(normalIconObject);
    }

    public OrientationEnum getOrientation() {
        PdfInteger orientationObject = (PdfInteger)((PdfDictionary)this.getBaseDataObject()).get(PdfName.R);
        if (orientationObject == null) {
            return OrientationEnum.Up;
        }
        return OrientationEnum.get((Integer)orientationObject.getRawValue());
    }

    public String getRolloverCaption() {
        PdfTextString rolloverCaptionObject = (PdfTextString)((PdfDictionary)this.getBaseDataObject()).get(PdfName.RC);
        if (rolloverCaptionObject == null) {
            return null;
        }
        return (String)rolloverCaptionObject.getValue();
    }

    public FormXObject getRolloverIcon() {
        PdfReference rolloverIconObject = (PdfReference)((PdfDictionary)this.getBaseDataObject()).get(PdfName.RI);
        if (rolloverIconObject == null) {
            return null;
        }
        return new FormXObject(rolloverIconObject);
    }

    public void setAlternateCaption(String value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.AC, new PdfTextString(value));
    }

    public void setAlternateIcon(FormXObject value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.IX, value.getBaseObject());
    }

    public void setBackgroundColor(Color value) {
        this.setColor(PdfName.BG, value);
    }

    public void setBorderColor(Color value) {
        this.setColor(PdfName.BC, value);
    }

    public void setCaptionPosition(CaptionPositionEnum value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.TP, new PdfInteger(value.getCode()));
    }

    public void setIconFit(IconFitObject value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.IF, value.getBaseObject());
    }

    public void setNormalCaption(String value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.CA, new PdfTextString(value));
    }

    public void setNormalIcon(FormXObject value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.I, value.getBaseObject());
    }

    public void setOrientation(OrientationEnum value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.R, new PdfInteger(value.getCode()));
    }

    public void setRolloverCaption(String value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.RC, new PdfTextString(value));
    }

    public void setRolloverIcon(FormXObject value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.RI, value.getBaseObject());
    }

    private Color getColor(PdfName key) {
        PdfArray colorObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(key);
        if (colorObject == null) {
            return null;
        }
        switch (colorObject.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return new DeviceGrayColor(((IPdfNumber)((Object)colorObject.get(0))).getNumberValue());
            }
            case 3: {
                return new DeviceRGBColor(((IPdfNumber)((Object)colorObject.get(0))).getNumberValue(), ((IPdfNumber)((Object)colorObject.get(1))).getNumberValue(), ((IPdfNumber)((Object)colorObject.get(2))).getNumberValue());
            }
            case 4: {
                return new DeviceCMYKColor(((IPdfNumber)((Object)colorObject.get(0))).getNumberValue(), ((IPdfNumber)((Object)colorObject.get(1))).getNumberValue(), ((IPdfNumber)((Object)colorObject.get(2))).getNumberValue(), ((IPdfNumber)((Object)colorObject.get(3))).getNumberValue());
            }
        }
        return null;
    }

    private void setColor(PdfName key, Color value) {
        PdfArray valueObject = new PdfArray();
        double[] dArray = value.getComponents();
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            double component = dArray[n2];
            valueObject.add(new PdfReal(component));
            ++n2;
        }
        ((PdfDictionary)this.getBaseDataObject()).put(key, valueObject);
    }

    public static enum CaptionPositionEnum {
        CaptionOnly(0),
        NoCaption(1),
        Below(2),
        Above(3),
        Right(4),
        Left(5),
        Overlaid(6);

        private final int code;

        public static CaptionPositionEnum get(int value) {
            CaptionPositionEnum[] captionPositionEnumArray = CaptionPositionEnum.values();
            int n = captionPositionEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                CaptionPositionEnum position = captionPositionEnumArray[n2];
                if (position.getCode() == value) {
                    return position;
                }
                ++n2;
            }
            return null;
        }

        private CaptionPositionEnum(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }

    public static class IconFitObject
    extends PdfObjectWrapper<PdfDictionary> {
        public IconFitObject(Document context) {
            super(context.getFile(), new PdfDictionary());
        }

        public IconFitObject(PdfDirectObject baseObject, PdfIndirectObject container) {
            super(baseObject, container);
        }

        @Override
        public IconFitObject clone(Document context) {
            throw new NotImplementedException();
        }

        public AlignmentXEnum getAlignmentX() {
            PdfArray alignmentObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.A);
            if (alignmentObject == null) {
                return AlignmentXEnum.Center;
            }
            switch ((int)Math.round(((IPdfNumber)((Object)alignmentObject.get(0))).getNumberValue() / 0.5)) {
                case 0: {
                    return AlignmentXEnum.Left;
                }
                case 2: {
                    return AlignmentXEnum.Right;
                }
            }
            return AlignmentXEnum.Center;
        }

        public AlignmentYEnum getAlignmentY() {
            PdfArray alignmentObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.A);
            if (alignmentObject == null) {
                return AlignmentYEnum.Middle;
            }
            switch ((int)Math.round(((IPdfNumber)((Object)alignmentObject.get(1))).getNumberValue() / 0.5)) {
                case 0: {
                    return AlignmentYEnum.Bottom;
                }
                case 2: {
                    return AlignmentYEnum.Top;
                }
            }
            return AlignmentYEnum.Middle;
        }

        public ScaleModeEnum getScaleMode() {
            PdfName scaleModeObject = (PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.SW);
            if (scaleModeObject == null) {
                return ScaleModeEnum.Always;
            }
            return ScaleModeEnum.get(scaleModeObject);
        }

        public ScaleTypeEnum getScaleType() {
            PdfName scaleTypeObject = (PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.S);
            if (scaleTypeObject == null) {
                return ScaleTypeEnum.Proportional;
            }
            return ScaleTypeEnum.get(scaleTypeObject);
        }

        public boolean isBorderExcluded() {
            PdfBoolean borderExcludedObject = (PdfBoolean)((PdfDictionary)this.getBaseDataObject()).get(PdfName.FB);
            if (borderExcludedObject == null) {
                return false;
            }
            return (Boolean)borderExcludedObject.getValue();
        }

        public void setAlignmentX(AlignmentXEnum value) {
            float objectValue;
            PdfArray alignmentObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.A);
            if (alignmentObject == null) {
                alignmentObject = new PdfArray(new PdfReal(0.5), new PdfReal(0.5));
                ((PdfDictionary)this.getBaseDataObject()).put(PdfName.A, alignmentObject);
            }
            switch (value) {
                case Left: {
                    objectValue = 0.0f;
                    break;
                }
                case Right: {
                    objectValue = 1.0f;
                    break;
                }
                default: {
                    objectValue = 0.5f;
                }
            }
            ((IPdfNumber)((Object)alignmentObject.get(0))).setNumberValue(objectValue);
        }

        public void setAlignmentY(AlignmentYEnum value) {
            float objectValue;
            PdfArray alignmentObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.A);
            if (alignmentObject == null) {
                alignmentObject = new PdfArray(new PdfReal(0.5), new PdfReal(0.5));
                ((PdfDictionary)this.getBaseDataObject()).put(PdfName.A, alignmentObject);
            }
            switch (value) {
                case Bottom: {
                    objectValue = 0.0f;
                    break;
                }
                case Top: {
                    objectValue = 1.0f;
                    break;
                }
                default: {
                    objectValue = 0.5f;
                }
            }
            ((IPdfNumber)((Object)alignmentObject.get(1))).setNumberValue(objectValue);
        }

        public void setBorderExcluded(boolean value) {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.FB, new PdfBoolean(value));
        }

        public void setScaleMode(ScaleModeEnum value) {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.SW, value.getCode());
        }

        public void setScaleType(ScaleTypeEnum value) {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.S, value.getCode());
        }

        public static enum ScaleModeEnum {
            Always(PdfName.A),
            Bigger(PdfName.B),
            Smaller(PdfName.S),
            Never(PdfName.N);

            private final PdfName code;

            public static ScaleModeEnum get(PdfName value) {
                ScaleModeEnum[] scaleModeEnumArray = ScaleModeEnum.values();
                int n = scaleModeEnumArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ScaleModeEnum mode = scaleModeEnumArray[n2];
                    if (mode.getCode().equals(value)) {
                        return mode;
                    }
                    ++n2;
                }
                return null;
            }

            private ScaleModeEnum(PdfName code) {
                this.code = code;
            }

            public PdfName getCode() {
                return this.code;
            }
        }

        public static enum ScaleTypeEnum {
            Anamorphic(PdfName.A),
            Proportional(PdfName.P);

            private final PdfName code;

            public static ScaleTypeEnum get(PdfName value) {
                ScaleTypeEnum[] scaleTypeEnumArray = ScaleTypeEnum.values();
                int n = scaleTypeEnumArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ScaleTypeEnum mode = scaleTypeEnumArray[n2];
                    if (mode.getCode().equals(value)) {
                        return mode;
                    }
                    ++n2;
                }
                return null;
            }

            private ScaleTypeEnum(PdfName code) {
                this.code = code;
            }

            public PdfName getCode() {
                return this.code;
            }
        }
    }

    public static enum OrientationEnum {
        Up(0),
        Left(90),
        Down(180),
        Right(270);

        private final int code;

        public static OrientationEnum get(int value) {
            value = value % 360 - value % 90;
            OrientationEnum[] orientationEnumArray = OrientationEnum.values();
            int n = orientationEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                OrientationEnum orientation = orientationEnumArray[n2];
                if (orientation.getCode() == value) {
                    return orientation;
                }
                ++n2;
            }
            return null;
        }

        private OrientationEnum(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

